#ifndef MISSILE_H
#define MISSILE_H
#include "tool.h"
#include "ball.h"
#define BALLSIZE 50

class Missile {
	private:
		//Missile *m;
	public:
		Ball *m;
		Missile ();
		Missile (Ball **ball);
		Missile (Ball **ball, int _color, int x, int y);

		//bool entry;
		void randomizeMissile (Ball **ball);
		Circle& getCollider();
		static const int DOT_VEL = 1;
		const int DOT_WIDTH = 50;
		const int DOT_HEIGHT = 50;

		//SDL_Surface *surface;
		//SDL_Surface *original;
		//SDL_Texture *texture;
		int active;
		int index;
		double mPosX, mPosY;
		double mVelX, mVelY;
		double angleRad;
		int color;

		//Dot's collision circle
		Circle mCollider;
		bool checkCollision( Circle& a, Circle& b );
		double distanceSquared( int x1, int y1, int x2, int y2 );
		void move();
		//int collisions( Circle& circle, Missile *wall_element, bool active, int wcolor);
		Back* collisions( Circle& circle, Missile *m);
		void fixIndex(Missile *missile);


		int checkActive(); 
		void setPosX(double x);
		void setPosY(double y);
		double getPosX();
		double getPosY();
		int getVarCollider();
		SDL_Texture* getTexture();
		double getVelX();
		void addVelX(double n);
		void addVelY(double n);

		void addAngle(double n);
		void setAngle(double n);
		void addPosY(double y);
		void addPosX(double x);
		void changeColor(Ball **ball);


		double getAngle();
		

		//float angleRad;

		//int mVelX, mVelY;
	protected:
		int mWidth;
		int mHeight;

		//Moves the collision circle relative to the dot's offset
		void shiftColliders();

};
#endif
