#include "game.h"
#include "field.h"


Uint32 getpixel(SDL_Surface *surface, int x, int y)
{
	int bpp = surface->format->BytesPerPixel;
	/* Here p is the address to the pixel we want to retrieve */
	Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;

	switch(bpp) {
		case 1:
			return *p;
		case 2:
			return *(Uint16 *)p;
		case 3:
			if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
				return p[0] << 16 | p[1] << 8 | p[2];
			else
				return p[0] | p[1] << 8 | p[2] << 16;
		case 4:
			return *(Uint32 *)p;
		default:
			return 0;
	}
}


void putpixel(SDL_Surface *surface, int x, int y, Uint8 R, Uint8 G, Uint8 B, Uint8 A)
{
    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x *
               surface->format->BytesPerPixel;
    if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
    {
       p[0] = R;
       p[1] = G;
       p[2] = B;
       p[3] = A;
    }
    else
    {
    	p[0] = A;
       p[1] = B;
       p[2] = G;
       p[3] = R;
    }
}


Field::Field (){

    int i,j,k;
    int figure=0, color=1;

    // ustawia field i ustawia kolor przekazywany do szlam
    Field::set(NFIGURE,NELEMENT, color);
    for (figure=0;figure<NFIGURE;figure++){
        for(k=0;k<NELEMENT;k++){

            for (j=0; j<4; j++){
                for (i=0; i<4; i++) {
                    if (this->elements[figure][j+k*4][i]==0) {
                        asm("nop");
                   //     putchar(' ');
                    }
                    // rysuje field
                    else if (this->elements[figure][j+k*4][i]==1) {
                        Field::draw(figure,k,color,i*20,j*20); //rysuje punkty na field
                 //       putchar('#');
                    }
                }
                //putchar('\n');
            }
        }
        color++;// dla kazdej figury po kolorze
    }



}




void Field::draw(int n_figure, int n_element,int color,int x, int y){

    SDL_Rect srcrect;
    SDL_Rect dstrect;
    SDL_Surface *p;
    int r,g,b;

    srcrect.x = 0;
    srcrect.y = 0;
    srcrect.w = 20;
    srcrect.h = 20;
    dstrect.x = x;
    dstrect.y = y;
    dstrect.w = 80;
    dstrect.h = 80;
    //std::cout<<"color:draw: "<<color<<std::endl;
    //Field::setColor(color,&r, &g, &b); //ustawiamy kolor szary
    this->setColor(color,&r, &g, &b); //ustawiamy kolor
	  //p=Field::createField(20,20,r,g,b);
    p=this->createField(20,20,r,g,b);

    SDL_BlitSurface(p, &srcrect, field[n_figure].element[n_element], &dstrect);
	SDL_SetColorKey(field[n_figure].element[n_element], SDL_TRUE, getpixel(field[n_figure].element[n_element],79, 79));

    SDL_FreeSurface(p);
}

void Field::set(int n_figure, int n_element, int color){

    int i,j;
    int r,g,b;
    //int color=0;
    for (i=0;i<NFIGURE;i++){
        field[i].color=color++; // stad jest przekazywany kolor do szlam
        this->setColor(WHITE,&r, &g, &b); //ustawiamy kolor bialy
        for(j=0;j<n_element;j++){
            // tworzy cztery instancje rysunku n_element
            field[i].element[j]=this->createField(80,80,r,g,b);
        }
    }
}

SDL_Surface * Field::get(int n_figure, int n_element) {

    return field[n_figure].element[n_element];
}

int Field::getColor(int n_figure) {
    return field[n_figure].color;
}

bool Field::checkEdgeLeft(SDL_Surface *f, int x_field) {
	
	int i, j;
	Uint32 c;
	Uint8 r, g, b, a;
	
	for (i=0;i<80;i+=20){ // y
        for (j=0;j<80;j+=20){ // x
			c=getpixel(f, j, i);  //getpixel2
            SDL_GetRGBA(c, f->format, &r, &g, &b, &a);

            if (x_field+j <=0)
            {
				printf ("ZERO!!!\n");
				if (r!=255 || g!=255 || b!=255) 
					return SDL_FALSE;
			}
		}
	}
	return SDL_TRUE;
}

bool Field::checkEdgeRight(SDL_Surface *f, int x_field) {
	
	int i, j;
	Uint32 c;
	Uint8 r, g, b, a;
	
	for (i=0;i<80;i+=20){ // y
        for (j=0;j<80;j+=20){ // x
			c=getpixel(f, j, i);  //getpixel2
            SDL_GetRGBA(c, f->format, &r, &g, &b, &a);
            if (x_field+j >= 380)
            {
				if (r!=255 || g!=255 || b!=255) 
					return SDL_FALSE;
			}
		}
	}
	return SDL_TRUE;
}

bool Field::checkEdgeRotate(SDL_Surface *f, int x_field) {
	
	int i, j;
	Uint32 c;
	Uint8 r, g, b, a;
	
	for (i=0;i<80;i+=20){ // y
        for (j=0;j<80;j+=20){ // x
			c=getpixel(f, j, i);  //getpixel2
            SDL_GetRGBA(c, f->format, &r, &g, &b, &a);
            printf ("y: %d  x: %d    r: %d  g: %d  b: %d  a: %d\n", i, j, r, g, b, a);
            printf ("X_FIELD: %d    X_FILED+j: %d\n", x_field, x_field+j);
            if (x_field+j >= 400)
            {
				printf ("ZERO!!!\n");
				if (r!=255 || g!=255 || b!=255) 
					return SDL_FALSE;
			}
		}
	}
	return SDL_TRUE;
}





