#ifndef FIELD_H
#define FIELD_H

#include <iostream>
//#include "tool.h"
#include "shape.h"

#define NFIGURE 7
#define NELEMENT 4
#define WHITE 0

typedef struct _FIELD{
    SDL_Surface *element[NELEMENT];
    int color;
}FIELD;

class Field : public Shape {

    public:
		void render();
		bool loadFromFile( std::string path, SDL_Renderer * renderer);

		//Gets collision circle
		//Circle& getCollider();
		//LTexture *gDotTexture = new LTexture();
		SDL_Surface *surface;
		SDL_Surface *original;
		//SDL_Texture *texture;
		bool active;
		int mPosX, mPosY;
		
//protected:
		//int mWidth;
		//int mHeight;

		//Moves the collision circle relative to the dot's offset
		//void shiftColliders();
		
	public:
        Field();
        SDL_Surface * get(int n_figure, int n_element);
        int getColor(int n_figure);
        bool checkEdgeLeft(SDL_Surface *f, int x_field);
        bool checkEdgeRight(SDL_Surface *f, int x_field);
		bool checkEdgeRotate(SDL_Surface *f, int x_field);

    private:
        FIELD field[NFIGURE];
        void set(int n_figure, int n_element, int color);
        void draw(int n_figure, int n_element,int color, int x, int y);


};

SDL_Rect set_rect(int x, int y, int w, int h);
//SDL_Surface * bg();
Uint32 getpixel(SDL_Surface *surface, int x, int y);


#endif //FIELD_H
