/* 
 * LamerTetris 2
 * author: prymula
 * date: 10-VI-2023
 * licence: Public Domain
 * tool: Geany
 * Program based on:
 * -This source code copyrighted by Lazy Foo' Productions (2004-2020)
 * and may not be redistributed without written permission.
 * -Andrew Lim Chong Liang https://github.com/andrew-lim/sdl2-boilerplate
 */

#ifndef GAME_H
#define GAME_H

#include <SDL2/SDL.h>
#include <SDL_ttf.h>
#include <cstdio>
#include <iostream>
#include <unistd.h>  // sleep  access
#include <time.h>
#include <map>

#if WINDOWS
#include <windows.h>
#include "hiscore_win.h"
#elif LINUX
#include "hiscore_linux.h"
#endif

#include "field.h"
#include "szlam.h"
#include "text.h"


#define SIZEFONT 35
#define SCOREFONT 20

enum {
    DISPLAY_WIDTH  = 400
    , DISPLAY_HEIGHT = 600
    , UPDATE_INTERVAL = 1000/60
    , HERO_SPEED = 2
    , SHAPE_SIZE = 200
    , BALL_SIZE = 75
    , RED_BALL = 0
    , YELLOW_BALL = 75
    , GREEN_BALL = 150
    , BLUE_BALL = 225
   
};

class Game {
public:
    Game();
    ~Game();
    void start();
    void stop() ;
    void draw(SDL_Rect *srcField, SDL_Rect *positionField, bool end);


    void fillRect(SDL_Rect* rc, int r, int g, int b );
    void fpsChanged( int fps );
    void run();

private:
	void up_direction();
	void left_direction();
	void right_direction();
	
    std::map<int,int> keys; // No SDLK_LAST. SDL2 migration guide suggests std::map
    int frameSkip ;
    int running ;
    SDL_Window* window;
    SDL_Rect dst;
    TTF_Font* gFont = NULL;
    TTF_Font* fontScore = NULL;
	SDL_Surface *background = NULL;
    SDL_Surface *screenSurface;
	SDL_Texture *texture;
	HiScore hiscore; 
	int score, hi_score;
	Text scoreTxt;
    Field field;
	Szlam szlam;
	int color,n_element=0, figure=1, rate=1, tmp_element=0;
	SDL_Rect positionField, srcField;
	int left=0;
	SDL_Renderer* renderer;
	bool loadWallpaper();
	bool loadFromFile( std::string path, SDL_Renderer * renderer);
    
};
#endif //GAME_H
