#include "shape.h"

Shape::Shape() {}

SDL_Surface * Shape::createBoxMask(int width, int height) {

    /* Create a 32-bit surface with the bytes of each pixel in R,G,B,A order,
       as expected by OpenGL for textures */
    SDL_Surface *surface;
    Uint32 rmask, gmask, bmask, amask;
	//int width=80;
	//int height=80;

    /* SDL interprets each pixel as a 32-bit number, so our masks must depend
       on the endianness (byte order) of the machine */
#if SDL_BYTEORDER == SDL_BIG_ENDIAN
    rmask = 0xff000000;
    gmask = 0x00ff0000;
    bmask = 0x0000ff00;
    amask = 0x000000ff;
#else
    rmask = 0x000000ff;
    gmask = 0x0000ff00;
    bmask = 0x00ff0000;
    amask = 0xff000000;
#endif

    surface = SDL_CreateRGBSurface(0, width, height, 32,
                                 rmask, gmask, bmask, amask);

    if (surface == NULL) {
        SDL_Log("SDL_CreateRGBSurface() failed: %s", SDL_GetError());
        exit(1);
    }

    /* or using the default masks for the depth: */
    //surface = SDL_CreateRGBSurface(0, width, height, 32, 0, 0, 0, 0);


	return surface;
}


SDL_Surface * Shape::createField(int w,int h, int r, int g, int b){

    SDL_Surface *s;
    //s=Szlam::createBoxMask(w,h);
    s=Shape::createBoxMask(w,h);
	SDL_FillRect(s, NULL, SDL_MapRGB(s->format, r, g, b));
    return s;
}

void Shape::setColor(int color, int *r, int *g, int*b){

    switch(color){
        case 0:
        *r=255, *g=255, *b=255;
        break;
        case 1:
        *r=255, *g=0, *b=0; //czerwony
        break;
        case 2:
        *r=0, *g=255, *b=0; //zielony
        break;
        case 3:
        *r=0, *g=0, *b=255; //niebieski
        break;
        case 4:
        *r=0, *g=255, *b=255; //seledynowy
        break;
		case 5:
        *r=255, *g=255, *b=0; //żółty
        break;
        case 6:
        *r=170, *g=0, *b=255; //fiolet
        break;
        case 7:
        *r=113, *g=255, *b=0; //fiolet
        break;
        
    }
}
