/*
    project: Lamer Teris
    file:    szlam.C
    write:   PRP
    licence: Public Domain
    date:    9-10-2018
    editor:  VSCode
*/
#include "field.h"
#include "szlam.h"
#include <iostream>

char szlamField [30][20]; // 600/20x400/20
bool szlamGhost [30] = {SDL_FALSE};

Szlam::Szlam(){

    field=this->createField(400,600, 255, 255, 255);
    SDL_SetColorKey(field, SDL_TRUE, getpixel(field,0,0));  //getpixel2

}
SDL_Surface * Szlam::get() {

    return field;
}

void Szlam::reset()
{
	int i,j;
	
	for (i=0; i<600/20; i++){
        for (j=0; j<400/20; j++) {
			szlamField[i][j]=0;
		}
        szlamGhost[i]=SDL_FALSE;
	}
}

void Szlam::draw(){

    SDL_Surface *px;
    SDL_Rect box;
    int i,j;
    int r,g,b;

    px=this->createField(20,20, 128, 128, 100);
    SDL_FillRect(field, NULL, SDL_MapRGB(field->format, 255, 255, 255));
    SDL_SetColorKey(field,SDL_TRUE, getpixel(field,0,0));  //getpixel2

    for (i=0; i<600/20; i++){
        for (j=0; j<400/20; j++) {
            if (szlamField[i][j]==0) {
                asm("nop");
                //putchar(' ');
            }
            else if (szlamField[i][j]!=0) {
                box = set_rect(j*20, i*20, 20, 20);
                this->setColor(szlamField[i][j],&r,&g,&b);
                SDL_FillRect(px, NULL, SDL_MapRGB(field->format, r,g,b));
                SDL_BlitSurface( px, NULL, field, &box );
                //putchar('#');
            }
        }
        //putchar('\n');
    }

    SDL_FreeSurface(px);
}

bool Szlam::addBottom(SDL_Surface *s, int n_figure, int n_element, int color, int posX, int posY) {
    Uint32 c;
    Uint8 r,g,b,a;
    int j,i,down = 0, v = 0, vv = 0;
    
    for(j=0;j<80;j+=20){ //j++
        for (i=0;i<80;i+=1){ //i++
            c=getpixel(s, j, i);  //getpixel2
            SDL_GetRGBA(c, s->format, &r, &g, &b, &a);
            if (r !=255 || g !=255 || b !=255) {
                if (i>down) 
                {
					down=i;
                
					switch (80 % down){
						case 1:
							v = 0;
							vv = 0;
							break;
						case 21:
							v = 1;
							vv = 20;
							break;
						case 2:
							v = 2;
							vv = 40;
							break;
					}
				}
			}
			else {
		
			}
        }
    }
    
    if (down+posY+vv>=600) {
        for (i=0; i<4; i++){
            for (j=0; j<4; j++) {
                if (this->elements[n_figure][i+n_element*4][j]==0) {
                    asm("nop");
			putchar(' ');
                }
                else if (this->elements[n_figure][i+n_element*4][j]==1) {
                    szlamField[posY/20+i+v][posX/20+j]=color;
			
		putchar('#');
                }
            }
		putchar('\n');
        }
            return true;
    }
    return false;
}

bool Szlam::collisionLeft(SDL_Surface *s, int n_element, 
                    int figure, int x_s, int y_s, int color){
	
	Uint32 cf, cs;
    Uint8 r,g,b,a, r2,g2,b2,a2;
    int i, j=0;
    
    for(j=0;j<80;j+=1){ // y  j++
        for (i=0;i<80;i+=1){ // x  i++
            
            cs=getpixel(s, i, j);  //getpixel2
            SDL_GetRGBA(cs, s->format, &r, &g, &b, &a);
            cf=getpixel(field, i+x_s-20, j+y_s);  //getpixel2
            printf("2\n");
            SDL_GetRGBA(cf, field->format, &r2, &g2, &b2, &a2);
           
            if ((r2!=255 || g2!=255 || b2!=255) &&
                (r!=255 || g!=255 || b!=255)) {
                    //*bottom=0;
                    //printf ("----bottom: %d\n", *bottom);
                    return SDL_TRUE;
                    //break;
            }
        }
    }
    return SDL_FALSE;
}
    
bool Szlam::collisionRight(SDL_Surface *s, int n_element, 
                    int figure, int x_s, int y_s, int color){
	
	Uint32 cf, cs;
    Uint8 r,g,b,a, r2,g2,b2,a2;
    int i, j=0;
    
    for(j=0;j<80;j+=1){ // y  j++
        for (i=0;i<80;i+=1){ // x  i++
            
            cs=getpixel(s, i, j);  //getpixel2
            SDL_GetRGBA(cs, s->format, &r, &g, &b, &a);
            cf=getpixel(field, i+x_s+20, j+y_s);  //getpixel2
            SDL_GetRGBA(cf, field->format, &r2, &g2, &b2, &a2);
           
            if ((r2!=255 || g2!=255 || b2!=255) &&
                (r!=255 || g!=255 || b!=255)) {
                    //*bottom=0;
                    return SDL_TRUE;
                    //break;
            }
        }
    }
    return SDL_FALSE;
}

bool Szlam::collisionRotate(SDL_Surface *s, int n_element, 
                    int figure, int x_s, int y_s, int color){
	
	Uint32 cf, cs;
    Uint8 r,g,b,a, r2,g2,b2,a2;
    int i, j=0;
    
    for(j=0;j<80;j+=1){ // y  j++
        for (i=0;i<80;i+=1){ // x  i++
            
            cs=getpixel(s, i, j);  //getpixel2
            SDL_GetRGBA(cs, s->format, &r, &g, &b, &a);
            cf=getpixel(field, i+x_s, j+y_s);  //getpixel2
            SDL_GetRGBA(cf, field->format, &r2, &g2, &b2, &a2);
           
            if ((r2!=255 || g2!=255 || b2!=255) &&
                (r!=255 || g!=255 || b!=255)) {
                   // *bottom=0;
                    return SDL_TRUE;
                    //break;
            }
        }
    }
    return SDL_FALSE;
}

bool Szlam::collisionBottom(SDL_Surface *s, int n_element, 
                    int figure, int x_s, int y_s, int color) {

   
    Uint32 cf, cs;
    Uint8 r,g,b,a, r2,g2,b2,a2;
    int i, j=0;
    bool go_szlam=false;
   
    for(j=0;j<80;j+=1){ // y  j++
        for (i=0;i<80;i+=20){ // x  i++
            cs=getpixel(s, i, j);  //getpixel2
            SDL_GetRGBA(cs, s->format, &r, &g, &b, &a);
            cf=getpixel(field, i+x_s, j+y_s);  //getpixel2
            SDL_GetRGBA(cf, field->format, &r2, &g2, &b2, &a2);
        
            if ((r2!=255 || g2!=255 || b2!=255) &&
                (r!=255 || g!=255 || b!=255)) {
                    go_szlam=true;
                    break;
            }
        }
    }
	

        if (go_szlam) {
            for (i=0; i<4; i++){
                for (j=0; j<4; j++) {
                    if (this->elements[figure][i+n_element*4][j]==0) {
                        asm("nop");
                    }
                    else if (this->elements[figure][i+n_element*4][j]==1) {
                        szlamField[y_s/20+i][x_s/20+j]=color;  
                    }
                }
            }
            return true;
        }
    
    return false;
}

// sprawdza czy równa powierzchnia
int Szlam::evenSurface(int *height)
{
	 int i, j, count=0;
	 int full[600/20] = {0};
	 //bool flag[30] = SDL_FALSE; 
	 
	 for (i=0; i<600/20; i++){
        for (j=0; j<400/20; j++) {
			if (szlamField[i][j] !=0 && szlamGhost[i]==SDL_FALSE) {
				full[i]+=1;
                
			}
		}
	}
	for (i=0; i < 600/20; i++){
		if (full[i]==20) {
            count++;
            szlamGhost[i]=SDL_TRUE;
        }
		if (full[i]!=0) (*height)++;
	}
	return count;
}

// skraca studnie
void Szlam::cutSurface(int n, int h) 
{
	int i, j, k;

	while (n-->0) {
		//for (i=600/20-1, k=h; k>0; i--, k--) {
        for (i=600/20-1, k=h; i>0; i--, k--) {
			for (j=400/20-1; j>=0; j--){
				szlamField[i][j] = szlamField[i-1][j];	
                szlamGhost[i] = szlamGhost[i-1];	

			}
		}
	}
}

bool Szlam::highFull()
{
	int j;
	
	for (j=0; j<400/20; j++){
		if (szlamField[0][j] != 0 || szlamField[1][j] != 0)
			return SDL_TRUE;
	}
	return SDL_FALSE;
}

