/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of a Qt Solutions component.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

#include <QtCore/QVariant>
#include <QtCore/QMutexLocker>
#include <QWidget>
//#include <QtGui/QWidget>

#ifdef Q_WS_X11
#   include <X11/Xlib.h>
//# lehrig
#endif
class QtNPStream;
class QtNPBindable;

struct QtNPInstance
{
    NPP npp;

    short fMode;

#ifdef Q_WS_WIN
    typedef HWND Widget;
#elif defined(Q_WS_X11)
    typedef Window Widget;
    Display *display;
#elif defined (Q_WS_MAC)
    typedef NPPort* Widget;
    QWidget *rootWidget;
#elif defined (PVWIN32)
    typedef HWND Widget;
#elif defined (PVMAC)
    typedef NPPort* Widget;
    QWidget *rootWidget;
#elif defined (PVUNIX)
#   include <X11/Xlib.h>
    typedef Window Widget;
    Display *display;
#endif

    Widget window;

    QRect geometry;
    QString mimetype;
    QByteArray htmlID;
    union {
        QObject* object;
        QWidget* widget;
    } qt;
    QtNPStream *pendingStream;
    QtNPBindable* bindable;
    QObject *filter;

    QMap<QByteArray, QVariant> parameters;

    qint32 notificationSeqNum;
    QMutex seqNumMutex;
    qint32 getNotificationSeqNum()
        {
            QMutexLocker locker(&seqNumMutex);

            if (++notificationSeqNum < 0)
                notificationSeqNum = 1;
            return notificationSeqNum;
        }

};
