//***************************************************************************
//                          main.cpp  -  description
//                             -------------------
//  begin            : So. Jan 23 10:25:55 2011
//  generated by     : pvdevelop (C) Lehrig Software Engineering
//  email            : lehrig@t-online.de
//***************************************************************************
#include "pvapp.h"
#include <unistd.h>

// Include the Lua API header files
#ifdef __cplusplus
extern "C" {
#endif
//#include <lua.hpp>
#include <lualib.h>
#include <lauxlib.h>
extern int luaopen_pv(lua_State* L);    // declare the wrapped module
extern int luaopen_rllib(lua_State* L); // declare the wrapped module
#ifdef __cplusplus
}
#endif

typedef struct
{
  int s;
  lua_State *L;
}CleanData;

char pvarg0[1024];
CleanData clean_data[MAX_CLIENTS];

static int cleanup(void *ptr)
{
  PARAM *p = (PARAM *) ptr;
  if(trace) printf("cleanup p->s=%d\n", p->s);
  for(int i=0; i<MAX_CLIENTS; i++)
  {
    if(clean_data[i].s == p->s)
    {
      if(trace) printf("cleanup lua_close\n");
      lua_State *L = (lua_State *) clean_data[i].L;
      lua_close(L);
      clean_data[i].s = -1;
      clean_data[i].L = NULL;
      break;
    }
  }
  return 0;
}
  
int pvMain(PARAM *p)
{
  int i, ret, status;
  lua_State* L;

  // initialize Lua
  if(trace) printf("lua_open\n");
  //L = lua_open();
  L = luaL_newstate();
  luaL_openlibs(L);

  // initialize cleanup
  for(i=0; i<MAX_CLIENTS; i++)
  {
    if(clean_data[i].s == -1 && clean_data[i].L == NULL)
    {
      clean_data[i].s = p->s;
      clean_data[i].L = L;
      break;
    }
  }
  pvSetCleanup(p, cleanup, p);

  // load our custom libs
  ret = luaopen_pv(L);
  if(trace) printf("luaopen_pv ret=%d\n", ret);
  ret = luaopen_rllib(L);
  if(trace) printf("luaopen_rllib ret=%d\n", ret);

  // load the script
  if(trace) printf("Loading '%s'\n", "main.lua");
  status = luaL_dofile(L, "main.lua");
  if(status)
  {
    printf("Couldn't load file: %s\n", lua_tostring(L, -1));
    pvThreadFatal(p,"Lua terminateing");
  }

  // call luaMain
  lua_getglobal(L, "luaMain");
  lua_pushnumber(L, (long) p);
  status = lua_pcall(L, 1, 1, 0); 
  if(status)
  {
    printf("Exception in running lua: %s\n", lua_tostring(L, -1));
    lua_pop(L, 1);
    pvThreadFatal(p,"Lua terminating");
  }
  pvThreadFatal(p,"Lua terminating");
  return 0;
}

static int luaInit()
{
  trace = 1;
  if(getcwd(pvarg0, sizeof(pvarg0)-20) == NULL) return -1;
  strcat(pvarg0,"\\main.lua");
  if(trace) printf("This is the Lua pvserver %s\n", pvarg0);
  /* here you may interpret ac,av and set p->user to your data */
  // initialize cleanup
  for(int i=0; i<MAX_CLIENTS; i++)
  {
    clean_data[i].s = -1;
    clean_data[i].L = NULL;
  }
  return 0;
}

#ifdef USE_INETD
int main(int ac, char **av)
{
PARAM p;

  pvInit(ac,av,&p);
  luaInit();
  pvMain(&p);
  return 0;
}
#else  // multi threaded server
int main(int ac, char **av)
{
PARAM p;
int   s;

  pvInit(ac,av,&p);
  luaInit();
  while(1)
  {
    s = pvAccept(&p);
    if(s != -1) pvCreateThread(&p,s);
  }
  return 0;
}
#endif
