//***************************************************************************
//                          main.cpp  -  description
//                             -------------------
//  Template for pvbrowser server using Python
//  generated by     : pvdevelop (C) 2000-2007 by Lehrig Software Engineering
//  email            : lehrig@t-online.de
//***************************************************************************
#include "pvapp.h"
// todo: comment me out. you can insert these objects as extern in your masks.
//rlModbusClient     modbus(modbusdaemon_MAILBOX,modbusdaemon_SHARED_MEMORY,modbusdaemon_SHARED_MEMORY_SIZE);
//rlSiemensTCPClient siemensTCP(siemensdaemon_MAILBOX,siemensdaemon_SHARED_MEMORY,siemensdaemon_SHARED_MEMORY_SIZE);
//rlPPIClient        ppi(ppidaemon_MAILBOX,ppidaemon_SHARED_MEMORY,ppidaemon_SHARED_MEMORY_SIZE);

// python
PyThreadState *pvsThreadState = NULL;

int pvMain(PARAM *p)
{
int ret;

  // python begin
  pvPyCleanupStruct cleanup_struct; 
  cleanup_struct.thread   = NULL;
  cleanup_struct.instance = NULL;
  cleanup_struct.p        = p;
  pvSetCleanup(p, pvPy_cleanup, &cleanup_struct);
#ifndef USE_INETD
  PyEval_AcquireLock();
  PyInterpreterState *mainInterpreterState = pvsThreadState->interp;
  PyThreadState *myThreadState = PyThreadState_New(mainInterpreterState);
  PyEval_ReleaseLock();
  cleanup_struct.thread   = myThreadState;
#endif
  // python end

  pvSetCaption(p,"pvs");
  pvResize(p,0,1280,1024);
  //pvScreenHint(p,1024,768); // this may be used to automatically set the zoomfactor
  ret = 1;
  pvGetInitialMask(p);
  if(strcmp(p->initial_mask,"mask1") == 0) ret = 1;

  while(1)
  {
    switch(ret)
    {
      case 1:
        pvStatusMessage(p,-1,-1,-1,"mask1");
        ret = show_mask1(p);
        break;
      default:
        return 0;
    }
    pvPy_SetInstance((pvPyCleanupStruct *) p->app_data, NULL);
  }
}

/*** this is the prinziple of the embedding of python ***********************
cs->pmod   = PyImport_ImportModule("mask1");            // fetch module
cs->pclass = PyObject_GetAttrString(cs->pmod,"mask1");  // fetch module.class
Py_DECREF(cs->pmod);

cs->pargs  = Py_BuildValue("()");                      
cs->pinst  = PyEval_CallObject(cs->pclass, cs->pargs);  // call class() constructor
Py_DECREF(cs->pclass);
Py_DECREF(cs->pargs);

cs->pmeth  = PyObject_GetAttrString(cs->pinst, "murx"); // fetch method
Py_DECREF(cs->pinst);
cs->pargs  = Py_BuildValue("()");
cs->pres   = PyEval_CallObject(cs->pmeth, cs->pargs);   // call method()
Py_DECREF(cs->pmeth);
Py_DECREF(cs->pargs);

PyArg_Parse(cs->pres, "s", &cstr);                      // get return value
printf("pres=%s\n", cstr);
Py_DECREF(cs->pres);
****************************************************************************/

int pvPyRun_SimpleFile(const char *filename) 
{
  FILE *fpy = fopen(filename,"r");
  if(fpy == NULL)
  {
    printf("error fopen %s\n", filename);
    return -1;
  }
  PyRun_SimpleFile(fpy,filename);
  fclose(fpy);
  return 0;
}

int pvPy_lock(PARAM *p)
{
  if(p == NULL) p = NULL; // no warnings if not used
#ifndef USE_INETD
  pvPyCleanupStruct *cs = (pvPyCleanupStruct *) p->app_data; 
  PyEval_AcquireLock();
  PyThreadState_Swap(cs->thread);
#endif
  return 0;
} 

int pvPy_unlock(PARAM *p) 
{
  if(p == NULL) p = NULL; // no warnings if not used
#ifndef USE_INETD
  PyThreadState_Swap(NULL);
  PyEval_ReleaseLock();
#endif
  return 0;
}

int pvPy_SetInstance(pvPyCleanupStruct *cs, char *instance)
{
  char classname[128], *cptr;

  if(cs == NULL) return -1;
  pvPy_lock(cs->p);
  if(cs->instance != NULL) // call destructor
  {
    cs->instance = NULL;

    Py_DECREF(cs->pmod);
    Py_DECREF(cs->pclass);
    Py_DECREF(cs->pinst);
  }
  if(instance != NULL)    // call constructor
  {
    cs->instance = instance;
    strcpy(classname, instance);
    cptr = strchr(classname, '_');
    if(cptr != NULL) *cptr = '\0';
    cptr = strstr(classname,"mask");
    if(cptr == NULL) cptr = &classname[0];

    cs->pmod = PyImport_ImportModule(cptr);                   // fetch module maskX
    if(cs->pmod == NULL) { printf("error: pvPy_SetInstance(ImportModule %s)\n", cptr); exit(-1); }
    cs->pclass = PyObject_GetAttrString(cs->pmod, cptr);      // fetch module.class maskX
    if(cs->pclass == NULL) { printf("error: pvPy_SetInstance(GetAttrString %s)\n", cptr); exit(-1); }
    cs->pargs = Py_BuildValue("()");                      
    cs->pinst = PyEval_CallObject(cs->pclass, cs->pargs);     // call class() constructor
    if(cs->pinst == NULL) { printf("error: pvPy_SetInstance(CallObject)\n"); exit(-1); }
    Py_DECREF(cs->pargs);
  }
  pvPy_unlock(cs->p); 
  return 0;
}

int pvPy_cleanup(void *arg) 
{
  printf("pvPy_cleanup()\n");
  pvPy_SetInstance((pvPyCleanupStruct *) arg, NULL);
#ifndef USE_INETD
  PyEval_AcquireLock();
  PyThreadState_Swap(NULL);
  pvPyCleanupStruct *cleanup = (pvPyCleanupStruct *) arg; 
  PyThreadState *myThreadState = cleanup->thread;
  PyThreadState_Clear(myThreadState);
  PyThreadState_Delete(myThreadState);
  PyEval_ReleaseLock();
#endif
  return 0;
}

#ifdef _WIN32
#ifdef __cplusplus
extern "C"{
#endif
void init_pv();     // Initialize (import) the helper class. 
void init_rllib();  // Initialize (import) the helper class. 
}
#endif

static int pvPy_init()
{
#ifdef _WIN32
  init_pv();        // Initialize (import) the helper class.
  init_rllib();     // Initialize (import) the helper class.
#else
  if(pvPyRun_SimpleFile("pvs_init.py") < 0) { Py_Finalize(); return -1; } 
#endif
  return 0;
}

#ifdef USE_INETD
int main(int ac, char **av)
{
PARAM p;

  Py_Initialize();                       // python init
  pvPy_init();                           // pvbrowser init python

  pvInit(ac,av,&p);
  /* here you may interpret ac,av and set p->user to your data */
  pvMain(&p);

  Py_Finalize();                         // python
  return 0;
}
#else  // multi threaded server
int main(int ac, char **av)
{
PARAM p;
int   s;

  Py_Initialize();                       // python init
  pvPy_init();                           // pvbrowser init python
  PyEval_InitThreads();                  // python thread init
  pvsThreadState = PyThreadState_Get();  // python get main thread state
  PyEval_ReleaseLock();                  // python release lock

  pvInit(ac,av,&p);
  /* here you may interpret ac,av and set p->user to your data */
  while(1)
  {
    s = pvAccept(&p);
    if(s != -1) pvCreateThread(&p,s);
    else        break;
  }
  
  Py_Finalize();                         // python
  return 0;
}
#endif
