/* <St> *******************************************************************

  FILENAME    : ODMIF_DEF.h

  -------------------------------------------------------------------------
  CREATED BY  :	R.Mayer,  Hilscher GmbH
  CREATED AT  :	01.05.99
  PROJECT     :	SyCon 
  =========================================================================

  FUNCTION / CLASSDESCRIPTION:
  
  =========================================================================

  CHANGES OF REVISIONS :

  Version	Name		Date		Change
  -------------------------------------------------------------------------

  1.001   RM     	04.02.00				- Driver download structure included
                                  - Definition ODM_SUPPORT_OWN_DOWNLOAD 
                                  included

  1.000   RM     	01.05.99				Created

  ******************************************************************** <En> */
#if !defined( ODMIF_DEF_INCLUDED)
#define ODMIF_DEF_INCLUDED 

#define BOOL int
////////////////////////////////////////////////////////////////////////////////////////////////
// Driver configuration events
#define ODM_DRIVER_START                  1
#define ODM_DRIVER_STOP                   2
#define ODM_DRIVER_SETUP                  3
#define ODM_DRIVER_CONFIGURATION_CHANGED  4

////////////////////////////////////////////////////////////////////////////////////////////////
// Driver information structure
#define ODM_SUPPORT_MESSAGE               0x01
#define ODM_SUPPORT_IODATA                0x02
#define ODM_SUPPORT_CONFIGURATION         0x04
#define ODM_SUPPORT_DIRECT_ACCESS         0x08
#define ODM_SUPPORT_OWN_DOWNLOAD          0x10

#define ODM_GET_FIRST_ENTRY               1
#define ODM_GET_NEXT_ENTRY                2

// GetDriverState
#define ODM_DRV_SEND_STATE_READY          0
#define ODM_DRV_SEND_STATE_BUSY           1
#define ODM_DRV_RECEIVE_STATE_READY       0
#define ODM_DRV_RECEIVE_STATE_BUSY        1

////////////////////////////////////////////////////////////////////////////////////////////////
// Driver error definition

#define ODM_DRV_NO_ERROR                  0

#define ODM_DRV_NOT_OPENED                8001
#define ODM_DRV_UNKNOWN_EVENT             8002
#define ODM_DRV_COMMAND_UNKNOWN           8003
#define ODM_DRV_COMMAND_FAILED            8004
#define ODM_DRV_COMMAND_ACTIVE            8005
#define ODM_DRV_DEVICE_INVALID            8006

#define ODM_DRV_NO_DEVICE_ASSIGNED        8010
#define ODM_DRV_DEVICE_ALREADY_ASSIGNED   8011

#define ODM_DRV_NOT_CONNECTED             8020
#define ODM_DRV_ALREADY_CONNECTED         8021
#define ODM_DRV_CONNECTION_TIMEOUT        8022

#define ODM_DRV_GET_STATE_ERROR           8030
#define ODM_DRV_SEND_ERROR                8031
#define ODM_DRV_SEND_BUSY                 8032
#define ODM_DRV_RECEIVE_ERROR             8033
#define ODM_DRV_RECEIVE_BUSY              8034
#define ODM_DRV_IO_ERROR                  8035


////////////////////////////////////////////////////////////////////////////////////////////////
// Driver assigment
#define ODM_ASSIGN_CANCEL           0
#define ODM_ASSIGN_OK               1
#define ODM_ASSIGN_CREATE           2
#define ODM_ASSIGN_DELETE           3

////////////////////////////////////////////////////////////////////////////////////////////////
// Driver interface structure definition
typedef struct tagODM_DRIVER_INFO {
  char            szName[50+1];             // Driver name
  char            szManufacture[50+1];      // Manufacture
  char            szVersion[50+1];          // Version
  char            szReleaseDate[50+1];      // Realeased Date/Time
  long            lError;                   // Actual error
  long            lSupported;               // Supported functions
  long            lConnectionTimeout;       // Connection timeout
  long            lSendTimeout;             // Send timeout
  long            lReceiveTimeout;          // Receive timeout
  long            lExchangeIOTimeout;       // Exchange timeout
  long            lParallelServices;        // Max. number of parallel services
} ODM_DRIVER_INFO;

////////////////////////////////////////////////////////////////////////////////////////////////
// Device information structure
typedef struct tagODM_DEVICE_INFO {
  BOOL            fAvailable;               // Device available (TRUE/FALSE)
  long            lDeviceID;                // Device ID generated by the driver
  long            lError;                   // Device error
  char            szDescription[50+1];      // Device description
  char            szFirmwareName[50+1];     // Firmware name
  char            szFirmwareVersion[50+1];  // Firmware version
  long            lDeviceModel;             // Device model
  long            lDeviceType;              // Device type
} ODM_DEVICE_INFO;

////////////////////////////////////////////////////////////////////////////////////////////////
// Error structure
typedef struct tagODM_ERROR {
  long            lTxError;           // Send error
  long            lRxError;           // Receive error
  long            lIOError;           // IO error
  long            lConnectionError;   // Connection error
} ODM_ERROR;

////////////////////////////////////////////////////////////////////////////////////////////////
// Device state structure
typedef struct tagODM_DEVICE_STATE {
  long            lSendState;         // Actual send state
  long            lReceiveState;      // Actual receive state
} ODM_DEVICE_STATE;

////////////////////////////////////////////////////////////////////////////////////////////////
// Assignment structure
typedef struct tagODM_ASSIGN_INFO {
  long            lDeviceID;          // -1 = no device
    
  const char      *pszActConfigName;  // Actual configuration name
  const char      *pszNewConfigName;  // New configuration name
  const char      *pszFirmwareName;   // Firmware name
} ODM_ASSIGN_INFO;


// Device list of connected devices
typedef struct tagODM_CONNECTED_DEVICE {
  long lDeviceID;
  long lLogID;
  long lError;
  long lReserved;
} ODM_CONNECTED_DEVICE;

typedef struct tagODM_CONNECTED_DEVICE_LIST {
  unsigned long         ulVersion;
  long                  lAppID;
  long                  lDriverID;
  char                  szDriverName[51];
  long                  lCount;
  long                  lReserved;
  char                  szFirmwareName[8+1];
  char                  szDeviceType  [32+1];
  ODM_CONNECTED_DEVICE  *ptConnectedList;
} ODM_CONNECTED_DEVICE_LIST;


#endif
