/***************************************************************************
                      rlppiclient.h  -  description
                             -------------------
    begin                : Mon Jul 12 2004
    copyright            : (C) 2004 by R. Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU LESSER GENERAL PUBLIC LICENSE as        *
 *   published by the Free Software Foundation                             *
 *                                                                         *
 ***************************************************************************/
#ifndef _RL_PPI_CLIENT_H_
#define _RL_PPI_CLIENT_H_

#include "rldefine.h"
#include "rlmailbox.h"
#include "rlsharedmemory.h"

/*! <pre>
This class is for data acquisition from pvserver according to the pvbrowser principle.
The according daemon is generated by pvdevelop.
It communicates by the means of a shared memory and a mailbox.
</pre> */
class rlPPIClient : public rlMailbox, rlSharedMemory
{
  public:
    enum PPI_area
    {
      daveSD      = 0x3,   
      daveInputs  = 0x81,    
      daveOutputs = 0x82,    
      daveFlags   = 0x83,
      daveDB      = 0x84, //data blocks
      daveDI      = 0x85, //not tested
      daveLocal   = 0x86, //not tested
      daveV       = 0x87, // don't know what it is
      daveCounter = 28,   //not tested
      daveTimer   = 29    //not tested
    };
    rlPPIClient(const char *mbxname, const char *shmname, int shmsize, int have_to_swap=1);
    virtual ~rlPPIClient();
    int write(int slave, int area, int dbnum, int start, int len, const unsigned char *data);
    int writeFloat(int slave, int area, int dbnum, int start, int len, const float *val);
    int writeDword(int slave, int area, int dbnum, int start, int len, const int *val);
    int writeShort(int slave, int area, int dbnum, int start, int len, const short *val);
    int writeUDword(int slave, int area, int dbnum, int start, int len, const unsigned int *val);
    int writeUShort(int slave, int area, int dbnum, int start, int len, const unsigned short *val);
    int read(int offset, int len);
    float        Float(int index);
    int          Dword(int index);
    int          Short(int index);
    unsigned int UDword(int index);
    unsigned int UShort(int index);
    unsigned char buf[512]; // after calling read, the data is here
  private:
    int have_to_swap;
};

#endif

