/***************************************************************************
                          rlsvgvdi.h  -  description
                             -------------------
    begin                : Tu Mar 22 2016
    copyright            : (C) 2016 by R. Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _RL_SVGVDI_H_
#define _RL_SVGVDI_H_

#include <stdio.h>
#include "rlstring.h"
#include "rlspawn.h"
#define MAXARRAY 1024*4  // maximum array size for line(x,y,n)

#ifndef PROCESSVIEWSERVER_H
/* font alignment */
enum rlFontAlignment {   /*                  */
ALIGN_LEFT=0,            /*  example         */
ALIGN_CENTER,            /*      example     */
ALIGN_RIGHT,             /*          example */
ALIGN_VERT_CENTER        /*      e           */
};                       /*      x           */
                         /*      a           */
                         /*      m           */
                         /*      p           */
                         /*      l           */
                         /*      e           */
                         /*                  */
                         
/* linestyle for lines in axis */
enum rlLinestyle {
LINESTYLE_NONE=0,
LINESTYLE_CIRCLE,
LINESTYLE_CROSS,
LINESTYLE_RECT,
LINESTYLE_CIRCLE_NO_LINE,
LINESTYLE_CROSS_NO_LINE,
LINESTYLE_RECT_NO_LINE
};
#endif

/*! <pre>
class for drawing xy-graphics and any svg graphics either on the client or on the server.

SVG (Tiny) is a flexible and powerfull graphics format.
- It can be rendered on a pvbrowser DrawWidget on the client, 
  where the user will also be able to interact with the SVG (example: clicking on named objects within the SVG)
- It can be rendered into another format by SVG converters on the server and/or the client
- It can be used to implement scalable user interfaces especially when using on mobile devices

rlSvgVdi brings some conveniance functions to draw xy-graphics with SVG and 
some general SVG interface functions, that produce SVG content directly.

The Output might be send to File/Socket/stdout or simply collected as a rlString with all the generated SVG.

See example within pvbaddon/demos/rlsvgvdi

HINT 1: Use rlSpawn and the rlsvgcat utility to read static SVG templates and insert the content generated by rlSvgVdi dynamically into the output stream.
        You might use comment strings within the SVG for controlling the filter pipeline.

HINT 2: Use this class for the purpose of generating reports in pdf

HINT 3: Use SVG converters with a commandline interface to convert SVG to png, jpg, pdf ...
        Examples: rsvg, imagemagick
        https://wiki.gnome.org/action/show/Projects/LibRsvg
        http://imagemagick.org/script/index.php

</pre> */
class rlSvgVdi
{
public:
    rlSvgVdi();
    ~rlSvgVdi();
    int setOutput(int *socket_out, int idForPvbrowser=0);
    int setOutput(FILE *fout);
    int setOutput(const char *outputfilename);
    int setOutput(rlSpawn *pipe);
    int endOutput();
    const char *svgHeader(int width=1280, int height=1024, int rbackground=255, int gbackground=255, int bbackground=255);
    const char *svgTrailer();
    const char *drawEllipse(int x, int y, int rx, int ry);
    const char *moveTo(int x, int y);
    const char *lineTo(int x, int y);
    const char *line(int x1, int y1, int x2, int y2);
    const char *text(int x, int y, const char *text, int alignment=ALIGN_LEFT);
    const char *textInAxis(float x, float y, const char *text, int alignment);
    const char *box(int x, int y, int w, int h);
    const char *boxWithText(int x, int y, int w, int h, int fontsize, const char *xlabel, const char *ylabel, const char * rylabel);
    const char *rect(int x, int y, int w, int h);
    const char *xAxis(float start, float delta, float end, int draw=1);
    const char *yAxis(float start, float delta, float end, int draw=1);
    const char *xGrid();
    const char *yGrid();
    const char *rightYAxis(float start, float delta, float end, int draw=1);
    const char *drawSymbol(int x, int y, int type);
    const char *line(float *x, float *y, int n, int linestayle=LINESTYLE_NONE);
    const char *setColor(int r, int g, int b);
    const char *setFont(const char *family, int size, int weight, int italic);
    const char *setWidth(int w);
    const char *setLinestyle(const char *dasharray);
    const char *comment(const char *text);
    const char *svg_put(const char *text);
    const char *svg_printf(const char *format, ...);
    const char *svg_d(int *x, int *y, int count);
    const char *svg_points(int *x, int *y, int count);
    int outputState;
    int getFontsize();
    int getBoxX();
    int getBoxY();
    int getBoxW();
    int getBoxH();

private:
    int      *sout;
    FILE     *fout;
    rlSpawn  *pipe;
    rlString filename, outputfilename;
    int      idForPvbrowser;
    rlString svg, svg2, svg3, fontstring;
    char     stroke[16];
    int      width;
    rlString dasharray;
    rlString lineoptions, textoptions;
    int      perhapsSend(const char *text);
    int      xold, yold;
    float    xmin,dx,xmax;
    float    ymin,dy,ymax;
    int      tx(float x);
    int      ty(float y);
    int      boxx,boxy,boxw,boxh;
    int      fontsize;
    int      sr;       // symbol radius
    char     floatFormat[80];
};

#endif
