/*
 * Generates the code to dynamically load api function calls based on the API header file
 * which is processed by ctags and a file containing the API function calls used by the
 * project.
 * The api header file is processed by ctags to obtain all of the api's prototypes.
 *
 * Run as:
 *   extract_api.rexx --funcs=function file name --api=api file name(s) [--includes=include switches]
 *
 * The project code needs code added:
 * ...
 * #ifdef DYNAMIC_LOAD_API_FUNCTIONS
 * # if defined(WIN32) || defined(WIN64)
 * #  include "win_apidata.h"
 * # elif defined(OS2)
 * #  include "os2_apidata.h"
 * # else
 * #  include "unx_apidata.h"
 * # endif
 * #else
 * # include "no_apidata.h"
 * #endif
 * ...
 * and before other function definitions
 * #ifdef DYNAMIC_LOAD_API_FUNCTIONS
 * # if defined(WIN32) || defined(WIN64)
 * #  include "win_apicode.h"
 * # elif defined(OS2)
 * #  include "os2_apicode.h"
 * # else
 * #  include "unx_apicode.h"
 * # endif
 * #endif
 * ...
 * To call the initialisation code add the following in the package initialisation code:
 * #ifdef DYNAMIC_LOAD_API_FUNCTIONS
 *    RexxPackageLoadAPIFunctions( RxPackageGlobalData );
 * #endif
 * ...
 * To call the initialisation code add the following in the package termiantion code:
 * #ifdef DYNAMIC_LOAD_API_FUNCTIONS
 *    RexxPackageUnloadAPIFunctions();
 * #endif
 */
Call RxFuncAdd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
Call SysLoadFuncs
oses = 'OS/2 WIN32 WIN64 WINARM64 UNIX LINUX'
Parse Arg '--compiler=' compiler '--' . 1 '--funcs=' funcfn '--' . 1 '--api=' apifn '--' . 1 '--includes=' includes '--' . 1 '--outdir=' outdir '--' . 1 '--os=' os '--'
If os = '' Then Parse Source os .
Else
   Do
      os = Translate( os )
      If Wordpos( os, oses ) = 0 Then
         Do
            Say 'Supplied --os='os 'is invalid. Must be one of' oses'. Exiting'
            Exit 1
         End
   End
If os = 'OS/2' Then os = 'OS2'
If Left( os, 3 ) = 'WIN' Then sep = '\'
Else sep = '/'
funcfn = Space( funcfn )
If Stream( funcfn, 'C', 'QUERY EXISTS' ) = '' Then
   Do
      create_no_apidata = 1
   End
Else
   Do
      create_no_apidata = 0
   End
/* create a queue for api file names */
Call Rxqueue 'C' , 'APIFN'
Call Rxqueue 'S' , 'APIFN'
apifn = Space( apifn )
outdir = Strip( outdir )
includes = Space( includes )
If Countstr( '*', apifn ) = 0 Then
   Do
      Do i = 1 To Words( apifn )
         fn = Word( apifn , i )
         ffn = Stream( fn, 'C', 'QUERY EXISTS' )
         If ffn = '' Then
            Do
               /* api file not exists locally */
      /*
               If includes = '' Then
                  Do
                     Say 'API header file:' fn 'not found. Ignoring.'
                     Iterate i
                  End
      */
               /* try and find the file in the C preprocessor search paths */
               ffn = findapifn( os, compiler, fn, includes )
               If ffn = '' Then
                  Do
                     Say 'API header file:' fn 'not found in include directories. Ignoring.'
                     Iterate i
                  End
               Queue ffn
            End
         Else
            Do
               Queue ffn
            End
      End
   End
Else
   Do
      Do i = 1 To Words( includes )
         inc = Substr( Word( includes, i ), 3 )||sep||apifn
say .line inc
         Call SysFileTree inc, 'funcs.', 'FO'
say .line result
--         Address System 'ls' inc With Output STEM funcs.
         Do j = 1 To funcs.0
            Queue funcs.j
         End
      End
   End
If Queued() = 0 Then
   Do
      fn = outdir'/no_apidata.h'
      Say 'No API header files found. Creating empty' fn
/*
      Call Stream fn, 'C', 'OPEN WRITE REPLACE'
      Call Lineout fn,'/* no dynamic API functions */'
      Call Stream fn, 'C', 'CLOSE'
*/
      Exit 0
   End
/* check supplied compiler */
/* create a queue for full prototypes that may be deprecated on some platforms */
Call Rxqueue 'C' , 'PROTOTYPE'
Call Rxqueue 'S' , 'PROTOTYPE'
funcs = ''
If \create_no_apidata Then
   Do
      funcfn = Stream( funcfn, 'C', 'QUERY EXISTS' )
      Do While Lines( funcfn ) > 0
         line = Strip( Linein( funcfn ) )
         If Left( line, 2 ) = '//' Then Iterate
         Parse Var line '#' . 'define' . func '/*' def '*/' .
         def = Strip( def )
         If def = '' Then funcs = funcs func
         Else Queue func def
      End
   End
funcs = Strip( funcs )
/*
If funcs = '' & Queued() = 0 Then
   Do
      Say 'No API functions specified in' funcfn'. This needs populating before the dynamic loading code can be generated. Aborting!'
      Exit 1
   End
*/
If Words( apifn ) = 0 Then
   Do
      Say 'No API header file(s) supplied. Aborting!'
      Exit 1
   End
/* read the api header(s) into a stem so we can traverse it more efficiently */
ctin = 'ctags.in'
Call Stream ctin, 'C', 'OPEN WRITE REPLACE'
Call Rxqueue 'S' ,'APIFN'
idx = 0
allapifn = ''
offsets.0 = Queued()
Do i = 1 To Queued()
   Parse Pull fn
   allapifn = allapifn fn
   Call Lineout ctin, Strip( fn )
   offsets.i = idx fn
   Do While Lines( fn ) > 0
      idx = idx + 1
      api.idx = Strip( Linein( fn ) )
   End
End
do i = 1 to offsets.0
end
api.0 = idx
Call Stream ctin, 'C', 'CLOSE'
If os = 'OS2' Then
   Do
      -- ctags under OS/2 requires the TMPDIR env variable to use forward slashes
      tmp = Value( 'TMPDIR',,'ENVIRONMENT' )
      tmp = Changestr( '\',tmp, '/' )
      Call Value 'TMPDIR', tmp, 'ENVIRONMENT'
   End
cmd = 'ctags -x --c-types=p -hh -L' ctin
Say 'Executing:' cmd
Address System cmd With Output Stem ctags.
Call Rxqueue 'S' , 'PROTOTYPE'
/* complete the prototype definition */
Do i = 1 To ctags.0
   ctags.i = completeprototype( ctags.i )
End
If create_no_apidata Then
   Do
      Do i = 1 To ctags.0
         Call extractfunc Word( ctags.i, 1 )
      End
   End
Else
   Do
      Do i = 1 To Words( funcs )
         Call extractfunc Word( funcs, i )
      End
   End
prototype.0 = Queued()
func.0 = prototype.0
Do i = 1 To Queued()
   Parse Pull func.i prototype.i
End
Call Rxqueue 'D' ,'APIFN'
Call Rxqueue 'D' ,'PROTOTYPE'

If create_no_apidata Then
   Do
      /* generate #defines for no dynamic loading */
      Call Stream funcfn, 'C', 'OPEN WRITE REPLACE'
      Do i = 1 To func.0
         Call generateloaddatadefine funcfn, func.i
      End
      Call Stream funcfn, 'C', 'CLOSE'
   End
datafn.WIN32 = 'win_apidata.h'
codefn.WIN32 = 'win_apicode.h'
datafn.WIN64 = 'win_apidata.h'
codefn.WIN64 = 'win_apicode.h'
datafn.WINARM64 = 'win_apidata.h'
codefn.WINARM64 = 'win_apicode.h'
datafn.OS2 = 'os2_apidata.h'
codefn.OS2 = 'os2_apicode.h'
datafn.UNIX = 'unx_apidata.h'
codefn.UNIX = 'unx_apicode.h'
datafn.LINUX = 'unx_apidata.h'
codefn.LINUX = 'unx_apicode.h'
datafn = outdir||sep||datafn.os
codefn = outdir||sep||codefn.os
Call Stream datafn, 'C', 'OPEN WRITE REPLACE'
Call Stream codefn, 'C', 'OPEN WRITE REPLACE'
Call generateinitialloaddata os, datafn
Call generateinitialloadcode os, codefn
Do i = 1 To prototype.0
   Call generateloaddata os, datafn, i-1, func.i, prototype.i
   Call generateloadcode os, codefn, i-1, func.i, prototype.i
End
Call generatefinalloaddata os, datafn
Call generatefinalloadcode os, codefn
Call Stream datafn, 'C', 'CLOSE'
Call Stream codefn, 'C', 'CLOSE'
Return 0

findapifn: Procedure
Parse Arg os, compiler, fn, includes
Select
   When compiler = 'gcc' | compiler = 'clang' Then ffn = findapifngcc( os, fn, includes )
   When compiler = 'cl' Then ffn = findapifncl( fn, includes )
   Otherwise
      Do
         ffn = ''
      End
End
Return ffn

findapifngcc: Procedure
Parse Arg os, fn, includes
If os = 'OS2' Then src = 'nul'
Else src = '/dev/null'
cmd = 'cpp -v' includes '- <' src
say .line cmd
Address System cmd With Output Stem out. Error Stem out.
state = 'start'
ffn = ''
Do i = 1 To out.0
   Select
      When state = 'start' Then
         Do
            If Left( out.i, 8 ) = '#include' Then
               Do
                  state = 'include'
               End
         End
      When state = 'include' Then
         Do
            If Left( out.i, 8 ) \= '#include' Then
               Do
                  state = 'dirs'
                  ffn = checkffn( os, out.i, fn )
                  If Stream( ffn, 'C', 'QUERY EXISTS' ) \= '' Then Return ffn
                  Else ffn = ''
               End
         End
      When state = 'dirs' Then
         Do
            If Left( out.i, 13 ) = 'End of search' Then Leave i
            ffn = checkffn( os, out.i, fn )
            If Stream( ffn, 'C', 'QUERY EXISTS' ) \= '' Then Return ffn
            Else ffn = ''
         End
   End
End
Return ffn

findapifncl: Procedure
Parse Arg fn, includes
sysincludes = Value( 'INCLUDE', , 'ENVIRONMENT' )
say .line sysincludes
fn = Changestr( '/', fn, '\' )
includes = Changestr( '-I', includes, '' )
includes = Changestr( '/I', includes, '' )
includes = Space( includes )
includes = Changestr( ' ', includes, ';' )
ffn = ''
inc = includes';'sysincludes
say .line inc
Do Forever
   Parse Var inc dir ';' inc
   If Right( dir, 1 ) \= '\' Then dir = dir'\'
say .line dir
   If Stream( dir||fn, 'C', 'QUERY EXISTS' ) \= '' Then
      Do
         ffn = dir||fn
         Leave
      End
   If inc = '' Then Leave
End
say ffn
Return ffn

findapifncl1: Procedure
Parse Arg fn, includes
fn = Changestr( '/', fn, '\' )
ffn = ''
/* split up into tokens delimited by -I or /I */
includes = Changestr( '-I', includes, '1'x )
includes = Changestr( '/I', includes, '1'x )
inc = Space( Substr( includes, 2 ) )
Do Forever
   Parse Var inc dir '1'x inc
   If Right( dir, 1 ) \= '\' Then dir = dir'\'
   If Stream( dir||fn, 'C', 'QUERY EXISTS' ) \= '' Then
      Do
         ffn = dir||fn
         Leave
      End
   If inc = '' Then Leave
End
Return ffn

checkffn: Procedure
Parse Arg os, line, fn
dir = Strip( line )
If Right( dir, 1 ) \= '/' Then ffn = dir'/'fn
Else ffn = dir||fn
If os = 'OS2' Then
   Do
      unixroot = Value( 'UNIXROOT',,'ENVIRONMENT')
      ffn = Changestr( '/@unixroot', ffn, unixroot )
   End
Return ffn

completeprototype: Procedure Expose ctags. api. offsets.
Parse Arg tag
tag = RemoveComments( tag )
If Right( tag, 1 ) = ';' Then Return  tag
Parse Var tag . . num fn proto
/* find the filename offset ... */
fn = Stream(fn,'C','QUERY EXISTS')
offset = 0
Do i = 1 To offsets.0
   If Word( offsets.i, 2 ) = fn Then
      Do
         offset = Word( offsets.i, 1 )
         Leave
      End
End
num = num + 1 + offset
Do i = num To api.0
   tag = tag RemoveComments( api.i )
   If Right( tag, 1 ) = ';' Then Leave i
End
Return tag

RemoveComments: Procedure
Parse Arg tag
tag = Changestr( '9'x, tag, ' ' )
If Countstr( '/*', tag ) = 0 Then Return Space( tag )
Parse Var tag pre '/*' . '*/' post
Return Space( pre post )

extractfunc: Procedure Expose ctags. prototype.
Parse Arg func
ufunc = Translate( func )
Do i = 1 To ctags.0
   If Translate( Word( ctags.i, 1 ) ) = ufunc Then
      Do
         Queue Word( ctags.i, 1 ) Subword( ctags.i, 5 )
         Return
      End
End
Say 'Unable to find' func 'in ctags output. Continuing without it.'
Return

generateinitialloaddata: Procedure
Parse Arg os, hfn
Call Lineout hfn, '#ifdef DYNAMIC_LOAD_API_FUNCTIONS'
Call Lineout hfn, '#include "rxload.h"'
Select
   When Left( os, 3 ) = 'WIN' Then
      Do
         Call Lineout hfn, 'static HMODULE api_handle=NULL;'
      End
   When os = 'OS2' Then
      Do
         Call Lineout hfn, 'static HMODULE api_handle=NULL;'
      End
   Otherwise
      Do
         Call Lineout hfn, 'static void *api_handle=NULL;'
      End
End
Return

generatefinalloaddata: Procedure
Parse Arg os, hfn
Call Lineout hfn, '#endif'
Return

generateinitialloadcode: Procedure
Parse Arg os, hfn
/*
 * for OS/2 we need to look for the function name with and without leading underscores
 * and either as specified, all uppercase or all lowercase. We need a function to do this
 * rather than inline all that code
 */
/*
If os = 'OS2' Then
   Do
      Call Lineout hfn, '#ifdef DYNAMIC_LOAD_API_FUNCTIONS'
      Call Lineout hfn, 'PFN RexxPackageFindAPIFunction( RxPackageGlobalDataDef *RxPackageGlobalData, HMODULE api_handle, char *func )'
      Call Lineout hfn, '{'
      Call Lineout hfn, '   int rc;'
      Call Lineout hfn, '   PFN api_addr;'
      Call Lineout hfn, '   char *tmp = (char *)alloca( strlen( func) + 2 );'
      Call Lineout hfn, '   if ( tmp == NULL )'
      Call Lineout hfn, '   {'
      Call Lineout hfn, '      RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: Memory allocation failed.", func );'
      Call Lineout hfn, '      exit(1);'
      Call Lineout hfn, '   }'
      Call Lineout hfn, '   InternalTrace(RxPackageGlobalData ,"RexxPackageFindAPIFunctions", "Function: %s",func);'
      Call Lineout hfn, '   /* as supplied */'
      Call Lineout hfn, '   strcpy( tmp, func );'
      Call Lineout hfn, '   rc = DosQueryProcAddr( api_handle, 0L, tmp, &api_addr);'
      Call Lineout hfn, '   if ( rc == 0 ) return api_addr;'
      Call Lineout hfn, '   /* as supplied with leading underscore */'
      Call Lineout hfn, '   sprintf( tmp, "_%s", func );'
      Call Lineout hfn, '   rc = DosQueryProcAddr( api_handle, 0L, tmp, &api_addr);'
      Call Lineout hfn, '   if ( rc == 0 ) return api_addr;'
      Call Lineout hfn, '   /* as supplied - lower case */'
      Call Lineout hfn, '   strcpy( tmp, func );'
      Call Lineout hfn, '   tmp = make_lower( RxPackageGlobalData, tmp );'
      Call Lineout hfn, '   rc = DosQueryProcAddr( api_handle, 0L, tmp, &api_addr);'
      Call Lineout hfn, '   if ( rc == 0 ) return api_addr;'
      Call Lineout hfn, '   /* as supplied with leading underscore - lower case */'
      Call Lineout hfn, '   sprintf( tmp, "_%s", func );'
      Call Lineout hfn, '   tmp = make_lower( RxPackageGlobalData, tmp );'
      Call Lineout hfn, '   rc = DosQueryProcAddr( api_handle, 0L, tmp, &api_addr);'
      Call Lineout hfn, '   if ( rc == 0 ) return api_addr;'
      Call Lineout hfn, '   /* as supplied - upper case */'
      Call Lineout hfn, '   strcpy( tmp, func );'
      Call Lineout hfn, '   tmp = make_upper( RxPackageGlobalData, tmp );'
      Call Lineout hfn, '   rc = DosQueryProcAddr( api_handle, 0L, tmp, &api_addr);'
      Call Lineout hfn, '   if ( rc == 0 ) return api_addr;'
      Call Lineout hfn, '   /* as supplied with leading underscore - upper case */'
      Call Lineout hfn, '   sprintf( tmp, "_%s", func );'
      Call Lineout hfn, '   tmp = make_upper( RxPackageGlobalData, tmp );'
      Call Lineout hfn, '   rc = DosQueryProcAddr( api_handle, 0L, tmp, &api_addr);'
      Call Lineout hfn, '   if ( rc == 0 ) return api_addr;'
      Call Lineout hfn, '   return NULL;'
      Call Lineout hfn, '}'
      Call Lineout hfn, '#endif'
   End
*/
Call Lineout hfn, '#ifdef DYNAMIC_LOAD_API_FUNCTIONS'
Call Lineout hfn, 'void RexxPackageLoadAPIFunctions( RxPackageGlobalDataDef *RxPackageGlobalData )'
Call Lineout hfn, '{'
Select
   When Left( os, 3 ) = 'WIN' Then
      Do
         Call Lineout hfn, '   char LoadError[256];'
         Call Lineout hfn, '   char errmsg[300], *perrmsg=errmsg;'
         Call Lineout hfn, '   char *dllname = RxGetAPIDLLName( RxPackageGlobalData );'
         Call Lineout hfn, '   InternalTrace(RxPackageGlobalData ,"RexxPackageLoadAPIFunctions", "DLL Name: %s",dllname);'
         Call Lineout hfn, '   if ( dllname == NULL || strlen(dllname) == 0 )'
         Call Lineout hfn, '   {'
         Call Lineout hfn, '      RxDisplayStringToFile( RxPackageGlobalData, stderr, "No external library specified" );'
         Call Lineout hfn, '      exit(1);'
         Call Lineout hfn, '   }'
         Call Lineout hfn, '   if ( api_handle == NULL )'
         Call Lineout hfn, '   {'
/*
         Call Lineout hfn, '      api_handle = LoadLibrary( dllname );'
         Call Lineout hfn, '      if ( api_handle == NULL )'
         Call Lineout hfn, '      {'
         Call Lineout hfn, '         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );'
         Call Lineout hfn, '         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to load external library \"%s\": LoadLibrary() failed: %s", dllname, LoadError );'
         Call Lineout hfn, '         exit(1);'
         Call Lineout hfn, '      }'
*/
         Call Lineout hfn, '      api_handle = RxLoadLibrary( dllname, perrmsg, sizeof(errmsg)-1 );'
         Call Lineout hfn, '      if ( api_handle == NULL )'
         Call Lineout hfn, '      {'
         Call Lineout hfn, '         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to load external library \"%s\": %s", dllname, perrmsg );'
         Call Lineout hfn, '         exit(1);'
         Call Lineout hfn, '      }'
      End
   When os = 'OS2' Then
      Do
         Call Lineout hfn, '   char LoadError[256];'
         Call Lineout hfn, '   char errmsg[300], *perrmsg=errmsg;'
         Call Lineout hfn, '   PFN api_addr;'
         Call Lineout hfn, '   APIRET rc;'
         Call Lineout hfn, '   char *dllname = RxGetAPIDLLName( RxPackageGlobalData );'
         Call Lineout hfn, '   InternalTrace(RxPackageGlobalData ,"RexxPackageLoadAPIFunctions", "DLL Name: %s",dllname);'
         Call Lineout hfn, '   if ( dllname == NULL || strlen(dllname) == 0 )'
         Call Lineout hfn, '   {'
         Call Lineout hfn, '      RxDisplayStringToFile( RxPackageGlobalData, stderr, "No external library specified" );'
         Call Lineout hfn, '      exit(1);'
         Call Lineout hfn, '   }'
         Call Lineout hfn, '   if ( api_handle == NULL )'
         Call Lineout hfn, '   {'
/*
         Call Lineout hfn, '      if ( DosLoadModule( LoadError, sizeof(LoadError), dllname, &api_handle ) )'
         Call Lineout hfn, '      {'
         Call Lineout hfn, '         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to load external library \"%s\": DosLoadModule() failed: %s", dllname, LoadError );'
         Call Lineout hfn, '         exit(1);'
         Call Lineout hfn, '      }'
*/
         Call Lineout hfn, '      api_handle = RxLoadLibrary( dllname, perrmsg, sizeof(errmsg)-1 );'
         Call Lineout hfn, '      if ( api_handle == NULL )'
         Call Lineout hfn, '      {'
         Call Lineout hfn, '         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to load external library \"%s\": %s", dllname, perrmsg );'
         Call Lineout hfn, '         exit(1);'
         Call Lineout hfn, '      }'
      End
   Otherwise
      Do
         Call Lineout hfn, '   void *api_addr=NULL;'
         Call Lineout hfn, '   char *dllname = RxGetAPIDLLName( RxPackageGlobalData );'
         Call Lineout hfn, '   char errmsg[300], *perrmsg=errmsg;'
         Call Lineout hfn, '   InternalTrace(RxPackageGlobalData ,"RexxPackageLoadAPIFunctions", "DLL Name: %s",dllname);'
         Call Lineout hfn, '   if ( dllname == NULL || strlen(dllname) == 0 )'
         Call Lineout hfn, '   {'
         Call Lineout hfn, '      RxDisplayStringToFile( RxPackageGlobalData, stderr, "No external library specified" );'
         Call Lineout hfn, '      exit(1);'
         Call Lineout hfn, '   }'
         Call Lineout hfn, '   if ( api_handle == NULL )'
         Call Lineout hfn, '   {'
/*
         Call Lineout hfn, '      tmp = (char *)alloca( strlen( dllname ) + 10 );'
         Call Lineout hfn, '      api_handle = dlopen( dllname, RTLD_LAZY | RTLD_GLOBAL );'
         Call Lineout hfn, '      if ( api_handle == NULL )'
         Call Lineout hfn, '      {'
         Call Lineout hfn, '         sprintf( tmp, "lib%s.so", dllname );'
         Call Lineout hfn, '         api_handle = dlopen( tmp, RTLD_LAZY | RTLD_GLOBAL );'
         Call Lineout hfn, '         if ( api_handle == NULL )'
         Call Lineout hfn, '         {'
         Call Lineout hfn, '            RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to load external library \"%s\": dlopen() failed: %s", dllname, dlerror() );'
         Call Lineout hfn, '            exit(1);'
         Call Lineout hfn, '         }'
         Call Lineout hfn, '      }'
*/
         Call Lineout hfn, '      api_handle = RxLoadLibrary( dllname, perrmsg, sizeof(errmsg)-1 );'
         Call Lineout hfn, '      if ( api_handle == NULL )'
         Call Lineout hfn, '      {'
         Call Lineout hfn, '         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to load external library \"%s\": %s", dllname, perrmsg );'
         Call Lineout hfn, '         exit(1);'
         Call Lineout hfn, '      }'
      End
End
Return

generatefinalloadcode: Procedure
Parse Arg os, hfn
Call Lineout hfn, '   }'
Call Lineout hfn, '}'
Call Lineout hfn, 'void RexxPackageUnloadAPIFunctions(void)'
Call Lineout hfn, '{'
Call Lineout hfn, '   if ( api_handle )'
Call Lineout hfn, '   {'
Call Lineout hfn, '      RxLibraryUnload( api_handle );'
Call Lineout hfn, '      api_handle = NULL;'
Call Lineout hfn, '   }'
Call Lineout hfn, '}'
Call Lineout hfn, '#endif'

Return

generateloaddata: Procedure
Parse Arg os, hfn, idx, func, proto
ufunc = Translate( func )
/* not platform dependent */
Call Lineout hfn, '/*' func '*/'
start = 1
Do Forever
   pos = Pos( func, proto, start )
   endpos = pos + Length( func )
   char = Substr( proto, endpos, 1 )
   If char = ' ' | char = '(' Then Leave
   start = endpos
   If start > Length( proto ) Then Leave
End
proto = Overlay( ufunc, proto, pos )
proto = Insert( 'T_', proto, pos - 1)
Call Lineout hfn, 'typedef' proto
Call Lineout hfn, 'T_'ufunc '*p_'func';'
Call Lineout hfn, '# define' '_RX_API_'func ' ((*p_'func'))'
Return

generateloaddatadefine: Procedure
Parse Arg hfn, func
ufunc = Translate( func )
/* not platform dependent */
Call Lineout hfn, '# define' '_RX_API_'func func
Return

generateloadcode: Procedure
Parse Arg os, hfn, idx, func, proto
ufunc = Translate( func )
Select
   When Left( os, 3 ) = 'WIN' Then
      Do
/*
         Call Lineout hfn, '      p_'func '= (T_'ufunc' *)GetProcAddress( (HMODULE)api_handle, "'func'" );'
         Call Lineout hfn, '      if ( p_'func '== NULL )'
         Call Lineout hfn, '      {'
         Call Lineout hfn, '         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );'
         Call Lineout hfn, '         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "'func'", LoadError );'
         Call Lineout hfn, '         exit(1);'
         Call Lineout hfn, '      }'
*/
         Call Lineout hfn, '      p_'func '= (T_'ufunc' *)RxGetModuleAddress( api_handle, "'func'", perrmsg, sizeof(errmsg)-1 );'
         Call Lineout hfn, '      if ( p_'func '== NULL )'
         Call Lineout hfn, '      {'
         Call Lineout hfn, '         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: \"%s\" Error: %s", "'func'", dllname, perrmsg );'
         Call Lineout hfn, '         exit(1);'
         Call Lineout hfn, '      }'
      End
   When os = 'OS2' Then
      Do
/*
         Call Lineout hfn, '      api_addr = RexxPackageFindAPIFunction( RxPackageGlobalData, api_handle, "'func'" );'
         Call Lineout hfn, '      if ( api_addr == NULL )'
         Call Lineout hfn, '      {'
         Call Lineout hfn, '         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: DosQueryProcAddr() failed: %d", "'func'", rc );'
         Call Lineout hfn, '         exit(1);'
         Call Lineout hfn, '      }'
         Call Lineout hfn, '      p_'func '= (T_'ufunc' *)api_addr;'
*/
         Call Lineout hfn, '#if 0'
         Call Lineout hfn, '      p_'func '= (T_'ufunc' *)RxGetModuleAddress( api_handle, "'func'", perrmsg, sizeof(errmsg)-1 );'
         Call Lineout hfn, '      if ( p_'func '== NULL )'
         Call Lineout hfn, '#else'
         Call Lineout hfn, '      api_addr = RxGetModuleAddress( api_handle, "'func'", perrmsg, sizeof(errmsg)-1 );'
         Call Lineout hfn, '      if ( api_addr == NULL )'
         Call Lineout hfn, '#endif'
         Call Lineout hfn, '      {'
         Call Lineout hfn, '         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: %s", "'func'", perrmsg );'
         Call Lineout hfn, '         exit(1);'
         Call Lineout hfn, '      }'
         Call Lineout hfn, '      p_'func '= (T_'ufunc' *)api_addr;'
      End
   Otherwise
      Do
         Call Lineout hfn, '#if 0'
         Call Lineout hfn, '      p_'func '= (T_'ufunc' *)RxGetModuleAddress( api_handle, "'func'", perrmsg, sizeof(errmsg)-1 );'
         Call Lineout hfn, '      if ( p_'func '== NULL )'
         Call Lineout hfn, '#else'
         Call Lineout hfn, '      api_addr = RxGetModuleAddress( api_handle, "'func'", perrmsg, sizeof(errmsg)-1 );'
         Call Lineout hfn, '      if ( api_addr == NULL )'
         Call Lineout hfn, '#endif'
         Call Lineout hfn, '      {'
         Call Lineout hfn, '         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: %s", "'func'", perrmsg );'
         Call Lineout hfn, '         exit(1);'
         Call Lineout hfn, '      }'
         Call Lineout hfn, '      p_'func '= (T_'ufunc' *)api_addr;'

      End
End
Return
