/**/
Trace N
Parse Arg fn generate instoutfn uninstoutfn dbname startwith
home = Value( 'VCPKG_HOME', , 'ENVIRONMENT' )
If home = '' & generate = 'Y' Then
   Do
      Say 'No VCPKG_HOME set, cannot use this tool.'
      Exit 1
   End
If startwith \= '' Then
   Do
      Say 'Starting with' startwith 'rather than' fn
      fn = startwith
      Queue startwith
   End
If generate = 'Y' Then
   Do
      Say 'Generating dependencies...'
      rcode = GetDeps( fn, home )
   End
lib = 0
files = ''
Do Queued()
   Parse Pull dll
--   Say 'Dep:' dll
   If Wordpos( dll, files ) = 0 Then files = files dll
End
If instoutfn \= '' & uninstoutfn \= '' Then
   Do
      Call Stream instoutfn, 'C', 'OPEN WRITE REPLACE'
      Call Stream uninstoutfn, 'C', 'OPEN WRITE REPLACE'
      Call Lineout instoutfn,';This file contains DLLs that' fn 'is dependent on'
      Call Lineout uninstoutfn,';This file contains DLLs that' fn 'is dependent on'
      If lib Then
         Do
            Call Lineout instoutfn,'IfFileExists "$INSTDIR\'fn'" 0 new_installation'
            Call Lineout instoutfn,'  StrCpy $ALREADY_INSTALLED 1'
            Call Lineout instoutfn,'new_installation:'
         End
      Do i = 1 To Words( files )
         dll = Word( files, i )
         If lib Then
            Do
               Call Lineout instoutfn,'!insertmacro InstallLib DLL $ALREADY_INSTALLED REBOOT_NOTPROTECTED "'home'\bin\'dll'"' '$INSTDIR\'dll '$INSTDIR'
            End
         Else
            Do
               If Left( dll, Length( home ) ) \= home Then fullfile = home'\bin\'dll
               Else fullfile = dll
               If Stream( fullfile, 'C', 'QUERY EXISTS' ) \= '' Then
                  Do
                     Address System 'dir /K /M' fullfile
                     Call Lineout instoutfn, 'File "'fullfile'"'
                     Call Lineout instoutfn, 'Push $INSTDIR\'dll
                     Call Lineout instoutfn, 'Call AddSharedDll'
                  End
            End
         If lib Then
            Do
               Call Lineout uninstoutfn,'!insertmacro UnInstallLib DLL SHARED REBOOT_NOTPROTECTED $INSTDIR\'dll
            End
         Else
            Do
--               Call Lineout uninstoutfn, 'Delete "$INSTDIR\'dll'"'
               Call Lineout uninstoutfn, 'Push $INSTDIR\'dll
               Call Lineout uninstoutfn, 'Call un.RemoveSharedDll'
            End
      End
      Call Stream instoutfn, 'C', 'CLOSE'
      Call Stream uninstoutfn, 'C', 'CLOSE'
   End
Else
   Do
      Say files
   End
Return 0

GetDeps: Procedure Expose files
Parse Arg fn, home
cmd = 'dumpbin /dependents' fn
--Say 'Checking' fn 'using...' cmd
Address System cmd With Output Stem out.
state = 'start'
Do i = 1 To out.0
   Select
      When state = 'start' Then
         Do
            If Countstr( 'Image has the following', out.i ) = 1 Then state = 'dlls'
         End
      When state = 'dlls' Then
         Do
            If Countstr( 'Summary', out.i ) = 1 Then Leave
            If Strip( out.i ) \= '' Then
               Do
                  dll = home'\bin\'Strip( out.i )
                  If Stream( dll, 'C', 'QUERY EXISTS' ) \= '' Then
                     Do
                        Queue Strip( out.i )
                        rcode = GetDeps( dll, home )
                     End
               End
         End
   End
End
Return 0

Header: Procedure
Parse Arg fn, dbname
Call Lineout fn, ';------------------------------------------------------------------------'
Call Lineout fn, 'Section "'dbname' DLLs" SecDLL'
Call Lineout fn, '  ; Set output path to the installation directory.'
Call Lineout fn, '  SetOutPath $INSTDIR'
Return

Footer: Procedure
Parse Arg fn
Call Lineout fn, 'SectionEnd'
Return
