/*
 * Rexx/CURL sample program to connect to a web server and display
 * the source of the page specified by the supplied URL.
 * Only argument is a URL as in http://rexxcurl.sourceforge.net
 */
Call RxFuncAdd 'CurlLoadFuncs', 'rexxcurl', 'CurlLoadFuncs'
If result > 10 Then
   Do
      Parse Version ver
      If Left( ver, 11 ) = 'REXX-Regina' Then extra = RxFuncErrMsg()
      Else extra = ''
      Say 'Unable to load CurlLoadFuncs, result:' result extra
      Exit 1
   End
Call CurlLoadFuncs

Parse Arg url
If url = '' Then
   Do
      Call Charout ,'Enter URL of page to download: '
      Parse Pull url
   End
protocols = 'Protocols:' !REXXCURL.!PROTOCOLS

Parse Version ver
msg = 'We are running' CurlVariable('VERSION') 'with' ver
len = Max( Length( msg ), Length( protocols ) )
Say Copies( '*', len )
Say msg
Say protocols
Say Copies( '*', len )

curl = CurlInit()
If curl \= '' Then
   Do
      Say
      idx = 0
      idx+=1;option.idx = 'URL';            value.idx=url
      idx+=1;option.idx = 'VERBOSE';        value.idx=0
      idx+=1;option.idx = 'SSLVERIFYPEER';  value.idx=0
      idx+=1;option.idx = 'FOLLOWLOCATION'; value.idx=1
      option.0 = idx;                       value.0 = idx  -- ensure an "array" is defined
      /* set all options with a single call to CurlSetopt() */
      Call CurlSetopt curl, 'option.', 'value.'
      If curlerror.intcode \= 0 Then Call Abort 'Error setting options:', curl
      /*
       * Or set each individual option individually
       *
      Call CurlSetopt curl, 'URL', url
      If curlerror.intcode \= 0 Then Call Abort 'Error setting URL option', curl

      Call CurlSetopt curl, 'VERBOSE', 0
      If curlerror.intcode \= 0 Then Call Abort 'Error setting VERBOSE option', curl

      Call CurlSetopt curl, 'SSLVERIFYPEER', 0
      If curlerror.intcode \= 0 Then Call Abort 'Error setting SSLVERIFYPEER option', curl

      Call CurlSetopt curl, 'FOLLOWLOCATION', 1
      If curlerror.intcode \= 0 Then Call Abort 'Error setting FOLLOWLOCATION option', curl
      */

      Call CurlPerform curl
      If curlerror.intcode \= 0 Then Call Abort 'Error getting source of' url, curl
      /*
       * Cleanup the connection
       */
      Call CurlCLeanup curl
   End
Return 0

Abort: Procedure Expose curlerror.
Parse Arg msg, curl
Say msg
If curlerror.curlcode \= 0 Then Say 'cURL error:' curlerror.curlcode '-' curlerror.curlerrm
Else Say 'RexxCURL error:' curlerror.intcode '-' curlerror.interrm
Call CurlCLeanup curl
Exit 1
