#ifdef DYNAMIC_LOAD_API_FUNCTIONS
void RexxPackageLoadAPIFunctions( RxPackageGlobalDataDef *RxPackageGlobalData )
{
   void *api_addr=NULL;
   char *dllname = RxGetAPIDLLName( RxPackageGlobalData );
   char *tmp;
   InternalTrace(RxPackageGlobalData ,"RexxPackageLoadAPIFunctions", "DLL Name: %s",dllname);
   if ( dllname == NULL || strlen(dllname) == 0 )
   {
      RxDisplayStringToFile( RxPackageGlobalData, stderr, "No external library specified" );
      exit(1);
   }
   if ( api_handle == NULL )
   {
      tmp = (char *)alloca( strlen( dllname ) + 10 );
      api_handle = dlopen( dllname, RTLD_LAZY | RTLD_GLOBAL );
      if ( api_handle == NULL )
      {
         sprintf( tmp, "lib%s.so", dllname );
         api_handle = dlopen( tmp, RTLD_LAZY | RTLD_GLOBAL );
         if ( api_handle == NULL )
         {
            RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to load external library \"%s\": dlopen() failed: %s", dllname, dlerror() );
            exit(1);
         }
      }
      api_addr = dlsym( api_handle, "curl_formadd" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_formadd", dlerror() );
         exit(1);
      }
      p_curl_formadd = (T_CURL_FORMADD *)api_addr;
      api_addr = dlsym( api_handle, "curl_formfree" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_formfree", dlerror() );
         exit(1);
      }
      p_curl_formfree = (T_CURL_FORMFREE *)api_addr;
      api_addr = dlsym( api_handle, "curl_easy_cleanup" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_easy_cleanup", dlerror() );
         exit(1);
      }
      p_curl_easy_cleanup = (T_CURL_EASY_CLEANUP *)api_addr;
      api_addr = dlsym( api_handle, "curl_easy_escape" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_easy_escape", dlerror() );
         exit(1);
      }
      p_curl_easy_escape = (T_CURL_EASY_ESCAPE *)api_addr;
      api_addr = dlsym( api_handle, "curl_easy_getinfo" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_easy_getinfo", dlerror() );
         exit(1);
      }
      p_curl_easy_getinfo = (T_CURL_EASY_GETINFO *)api_addr;
      api_addr = dlsym( api_handle, "curl_easy_init" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_easy_init", dlerror() );
         exit(1);
      }
      p_curl_easy_init = (T_CURL_EASY_INIT *)api_addr;
      api_addr = dlsym( api_handle, "curl_easy_perform" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_easy_perform", dlerror() );
         exit(1);
      }
      p_curl_easy_perform = (T_CURL_EASY_PERFORM *)api_addr;
      api_addr = dlsym( api_handle, "curl_easy_reset" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_easy_reset", dlerror() );
         exit(1);
      }
      p_curl_easy_reset = (T_CURL_EASY_RESET *)api_addr;
      api_addr = dlsym( api_handle, "curl_easy_setopt" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_easy_setopt", dlerror() );
         exit(1);
      }
      p_curl_easy_setopt = (T_CURL_EASY_SETOPT *)api_addr;
      api_addr = dlsym( api_handle, "curl_easy_unescape" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_easy_unescape", dlerror() );
         exit(1);
      }
      p_curl_easy_unescape = (T_CURL_EASY_UNESCAPE *)api_addr;
      api_addr = dlsym( api_handle, "curl_free" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_free", dlerror() );
         exit(1);
      }
      p_curl_free = (T_CURL_FREE *)api_addr;
      api_addr = dlsym( api_handle, "curl_global_cleanup" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_global_cleanup", dlerror() );
         exit(1);
      }
      p_curl_global_cleanup = (T_CURL_GLOBAL_CLEANUP *)api_addr;
      api_addr = dlsym( api_handle, "curl_global_init" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_global_init", dlerror() );
         exit(1);
      }
      p_curl_global_init = (T_CURL_GLOBAL_INIT *)api_addr;
      api_addr = dlsym( api_handle, "curl_mime_addpart" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_mime_addpart", dlerror() );
         exit(1);
      }
      p_curl_mime_addpart = (T_CURL_MIME_ADDPART *)api_addr;
      api_addr = dlsym( api_handle, "curl_mime_data" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_mime_data", dlerror() );
         exit(1);
      }
      p_curl_mime_data = (T_CURL_MIME_DATA *)api_addr;
      api_addr = dlsym( api_handle, "curl_mime_encoder" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_mime_encoder", dlerror() );
         exit(1);
      }
      p_curl_mime_encoder = (T_CURL_MIME_ENCODER *)api_addr;
      api_addr = dlsym( api_handle, "curl_mime_filedata" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_mime_filedata", dlerror() );
         exit(1);
      }
      p_curl_mime_filedata = (T_CURL_MIME_FILEDATA *)api_addr;
      api_addr = dlsym( api_handle, "curl_mime_filename" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_mime_filename", dlerror() );
         exit(1);
      }
      p_curl_mime_filename = (T_CURL_MIME_FILENAME *)api_addr;
      api_addr = dlsym( api_handle, "curl_mime_free" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_mime_free", dlerror() );
         exit(1);
      }
      p_curl_mime_free = (T_CURL_MIME_FREE *)api_addr;
      api_addr = dlsym( api_handle, "curl_mime_headers" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_mime_headers", dlerror() );
         exit(1);
      }
      p_curl_mime_headers = (T_CURL_MIME_HEADERS *)api_addr;
      api_addr = dlsym( api_handle, "curl_mime_init" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_mime_init", dlerror() );
         exit(1);
      }
      p_curl_mime_init = (T_CURL_MIME_INIT *)api_addr;
      api_addr = dlsym( api_handle, "curl_mime_name" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_mime_name", dlerror() );
         exit(1);
      }
      p_curl_mime_name = (T_CURL_MIME_NAME *)api_addr;
      api_addr = dlsym( api_handle, "curl_mime_subparts" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_mime_subparts", dlerror() );
         exit(1);
      }
      p_curl_mime_subparts = (T_CURL_MIME_SUBPARTS *)api_addr;
      api_addr = dlsym( api_handle, "curl_mime_type" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_mime_type", dlerror() );
         exit(1);
      }
      p_curl_mime_type = (T_CURL_MIME_TYPE *)api_addr;
      api_addr = dlsym( api_handle, "curl_slist_append" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_slist_append", dlerror() );
         exit(1);
      }
      p_curl_slist_append = (T_CURL_SLIST_APPEND *)api_addr;
      api_addr = dlsym( api_handle, "curl_slist_free_all" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_slist_free_all", dlerror() );
         exit(1);
      }
      p_curl_slist_free_all = (T_CURL_SLIST_FREE_ALL *)api_addr;
      api_addr = dlsym( api_handle, "curl_version" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_version", dlerror() );
         exit(1);
      }
      p_curl_version = (T_CURL_VERSION *)api_addr;
      api_addr = dlsym( api_handle, "curl_version_info" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_version_info", dlerror() );
         exit(1);
      }
      p_curl_version_info = (T_CURL_VERSION_INFO *)api_addr;
      api_addr = dlsym( api_handle, "curl_ws_recv" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_ws_recv", dlerror() );
         exit(1);
      }
      p_curl_ws_recv = (T_CURL_WS_RECV *)api_addr;
      api_addr = dlsym( api_handle, "curl_ws_send" );
      if ( api_addr == NULL )
      {
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: dlsym() failed: %s", "curl_ws_send", dlerror() );
         exit(1);
      }
      p_curl_ws_send = (T_CURL_WS_SEND *)api_addr;
   }
}
void RexxPackageUnloadAPIFunctions(void)
{
   if ( api_handle )
   {
      dlclose( api_handle );
      api_handle = NULL;
   }
}
#endif
