#ifdef DYNAMIC_LOAD_API_FUNCTIONS
void RexxPackageLoadAPIFunctions( RxPackageGlobalDataDef *RxPackageGlobalData )
{
   char LoadError[256];
   char *dllname = RxGetAPIDLLName( RxPackageGlobalData );
   InternalTrace(RxPackageGlobalData ,"RexxPackageLoadAPIFunctions", "DLL Name: %s",dllname);
   if ( dllname == NULL || strlen(dllname) == 0 )
   {
      RxDisplayStringToFile( RxPackageGlobalData, stderr, "No external library specified" );
      exit(1);
   }
   if ( api_handle == NULL )
   {
      api_handle = LoadLibrary( dllname );
      if ( api_handle == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to load external library \"%s\": LoadLibrary() failed: %s", dllname, LoadError );
         exit(1);
      }
      p_curl_formadd = (T_CURL_FORMADD *)GetProcAddress( (HMODULE)api_handle, "curl_formadd" );
      if ( p_curl_formadd == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_formadd", LoadError );
         exit(1);
      }
      p_curl_formfree = (T_CURL_FORMFREE *)GetProcAddress( (HMODULE)api_handle, "curl_formfree" );
      if ( p_curl_formfree == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_formfree", LoadError );
         exit(1);
      }
      p_curl_easy_cleanup = (T_CURL_EASY_CLEANUP *)GetProcAddress( (HMODULE)api_handle, "curl_easy_cleanup" );
      if ( p_curl_easy_cleanup == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_easy_cleanup", LoadError );
         exit(1);
      }
      p_curl_easy_escape = (T_CURL_EASY_ESCAPE *)GetProcAddress( (HMODULE)api_handle, "curl_easy_escape" );
      if ( p_curl_easy_escape == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_easy_escape", LoadError );
         exit(1);
      }
      p_curl_easy_getinfo = (T_CURL_EASY_GETINFO *)GetProcAddress( (HMODULE)api_handle, "curl_easy_getinfo" );
      if ( p_curl_easy_getinfo == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_easy_getinfo", LoadError );
         exit(1);
      }
      p_curl_easy_init = (T_CURL_EASY_INIT *)GetProcAddress( (HMODULE)api_handle, "curl_easy_init" );
      if ( p_curl_easy_init == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_easy_init", LoadError );
         exit(1);
      }
      p_curl_easy_perform = (T_CURL_EASY_PERFORM *)GetProcAddress( (HMODULE)api_handle, "curl_easy_perform" );
      if ( p_curl_easy_perform == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_easy_perform", LoadError );
         exit(1);
      }
      p_curl_easy_reset = (T_CURL_EASY_RESET *)GetProcAddress( (HMODULE)api_handle, "curl_easy_reset" );
      if ( p_curl_easy_reset == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_easy_reset", LoadError );
         exit(1);
      }
      p_curl_easy_setopt = (T_CURL_EASY_SETOPT *)GetProcAddress( (HMODULE)api_handle, "curl_easy_setopt" );
      if ( p_curl_easy_setopt == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_easy_setopt", LoadError );
         exit(1);
      }
      p_curl_easy_unescape = (T_CURL_EASY_UNESCAPE *)GetProcAddress( (HMODULE)api_handle, "curl_easy_unescape" );
      if ( p_curl_easy_unescape == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_easy_unescape", LoadError );
         exit(1);
      }
      p_curl_free = (T_CURL_FREE *)GetProcAddress( (HMODULE)api_handle, "curl_free" );
      if ( p_curl_free == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_free", LoadError );
         exit(1);
      }
      p_curl_global_cleanup = (T_CURL_GLOBAL_CLEANUP *)GetProcAddress( (HMODULE)api_handle, "curl_global_cleanup" );
      if ( p_curl_global_cleanup == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_global_cleanup", LoadError );
         exit(1);
      }
      p_curl_global_init = (T_CURL_GLOBAL_INIT *)GetProcAddress( (HMODULE)api_handle, "curl_global_init" );
      if ( p_curl_global_init == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_global_init", LoadError );
         exit(1);
      }
      p_curl_mime_addpart = (T_CURL_MIME_ADDPART *)GetProcAddress( (HMODULE)api_handle, "curl_mime_addpart" );
      if ( p_curl_mime_addpart == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_mime_addpart", LoadError );
         exit(1);
      }
      p_curl_mime_data = (T_CURL_MIME_DATA *)GetProcAddress( (HMODULE)api_handle, "curl_mime_data" );
      if ( p_curl_mime_data == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_mime_data", LoadError );
         exit(1);
      }
      p_curl_mime_encoder = (T_CURL_MIME_ENCODER *)GetProcAddress( (HMODULE)api_handle, "curl_mime_encoder" );
      if ( p_curl_mime_encoder == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_mime_encoder", LoadError );
         exit(1);
      }
      p_curl_mime_filedata = (T_CURL_MIME_FILEDATA *)GetProcAddress( (HMODULE)api_handle, "curl_mime_filedata" );
      if ( p_curl_mime_filedata == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_mime_filedata", LoadError );
         exit(1);
      }
      p_curl_mime_filename = (T_CURL_MIME_FILENAME *)GetProcAddress( (HMODULE)api_handle, "curl_mime_filename" );
      if ( p_curl_mime_filename == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_mime_filename", LoadError );
         exit(1);
      }
      p_curl_mime_free = (T_CURL_MIME_FREE *)GetProcAddress( (HMODULE)api_handle, "curl_mime_free" );
      if ( p_curl_mime_free == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_mime_free", LoadError );
         exit(1);
      }
      p_curl_mime_headers = (T_CURL_MIME_HEADERS *)GetProcAddress( (HMODULE)api_handle, "curl_mime_headers" );
      if ( p_curl_mime_headers == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_mime_headers", LoadError );
         exit(1);
      }
      p_curl_mime_init = (T_CURL_MIME_INIT *)GetProcAddress( (HMODULE)api_handle, "curl_mime_init" );
      if ( p_curl_mime_init == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_mime_init", LoadError );
         exit(1);
      }
      p_curl_mime_name = (T_CURL_MIME_NAME *)GetProcAddress( (HMODULE)api_handle, "curl_mime_name" );
      if ( p_curl_mime_name == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_mime_name", LoadError );
         exit(1);
      }
      p_curl_mime_subparts = (T_CURL_MIME_SUBPARTS *)GetProcAddress( (HMODULE)api_handle, "curl_mime_subparts" );
      if ( p_curl_mime_subparts == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_mime_subparts", LoadError );
         exit(1);
      }
      p_curl_mime_type = (T_CURL_MIME_TYPE *)GetProcAddress( (HMODULE)api_handle, "curl_mime_type" );
      if ( p_curl_mime_type == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_mime_type", LoadError );
         exit(1);
      }
      p_curl_slist_append = (T_CURL_SLIST_APPEND *)GetProcAddress( (HMODULE)api_handle, "curl_slist_append" );
      if ( p_curl_slist_append == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_slist_append", LoadError );
         exit(1);
      }
      p_curl_slist_free_all = (T_CURL_SLIST_FREE_ALL *)GetProcAddress( (HMODULE)api_handle, "curl_slist_free_all" );
      if ( p_curl_slist_free_all == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_slist_free_all", LoadError );
         exit(1);
      }
      p_curl_version = (T_CURL_VERSION *)GetProcAddress( (HMODULE)api_handle, "curl_version" );
      if ( p_curl_version == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_version", LoadError );
         exit(1);
      }
      p_curl_version_info = (T_CURL_VERSION_INFO *)GetProcAddress( (HMODULE)api_handle, "curl_version_info" );
      if ( p_curl_version_info == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_version_info", LoadError );
         exit(1);
      }
      p_curl_ws_recv = (T_CURL_WS_RECV *)GetProcAddress( (HMODULE)api_handle, "curl_ws_recv" );
      if ( p_curl_ws_recv == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_ws_recv", LoadError );
         exit(1);
      }
      p_curl_ws_send = (T_CURL_WS_SEND *)GetProcAddress( (HMODULE)api_handle, "curl_ws_send" );
      if ( p_curl_ws_send == NULL )
      {
         FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), LoadError, 256, NULL );
         RxDisplayStringToFile( RxPackageGlobalData, stderr, "Failed to find \"%s\" in external library: GetProcAddress() failed: %s", "curl_ws_send", LoadError );
         exit(1);
      }
   }
}
void RexxPackageUnloadAPIFunctions(void)
{
   if ( api_handle )
   {
      FreeLibrary( api_handle );
      api_handle = NULL;
   }
}
#endif
