Overview
========

SciTECO is an interactive TECO dialect, similar to Video TECO.
It also adds features from classic TECO-11, as well as unique new ideas.

The basic approach to text editing is both radically different and surprisingly similar to popular
editors like Vi or EMacs. Instead of using mostly keyboard commands to modify text in a visual
manner, in SciTECO you edit a program (called macro) using very few keyboard commands (called
immediate editing commands). This program edits text for the user and is executed immediately,
as far as possible. For instance, moving the cursor to the right can be done immediatly via the
"C" command which is a part of the editor language. The language is the editor so to speak.
When you delete a character from the end of the command line macro (called rubout), the
side-effects of that character which may be a command or part of a command, are undone.

![SciTECO demo](https://sciteco.fmsbw.de/screenshots/v2.1-dev-freebsd-ncurses.gif)

SciTECO uses the [Scintilla](https://www.scintilla.org/) editor component and supports
GTK+ 3 as well as Curses frontends (using [Scinterm](https://foicica.com/scinterm/)).

The Curses frontend is verified to work with [ncurses](https://www.gnu.org/software/ncurses/),
[NetBSD Curses](https://github.com/sabotage-linux/netbsd-curses),
[PDCurses/XCurses](https://github.com/wmcbrine/PDCurses),
[PDCursesMod](https://github.com/Bill-Gray/PDCursesMod) and
[EMCurses](https://github.com/rhaberkorn/emcurses).
All X/Open-compatible libraries should be supported.
SVr4 curses without enhanced definitions is **not** supported.

Linux, FreeBSD, NetBSD, [Mac OS X](https://sciteco.fmsbw.de/knowledge/Mac%20OS%20Support),
Windows (MinGW 32/64) ~~and [Haiku](https://www.haiku-os.org/) (gcc4)~~ are tested and supported.
SciTECO compiles with both GCC and Clang.
SciTECO should compile just fine on other UNIX-compatible platforms.
However UNIX-compatibility is not strictly required:
Since SciTECO primarily depends on [glib](https://developer.gnome.org/glib/) and
some implementation of Curses, it should be easy to port to even more exotic platforms.

__Warning: The SciTECO language is work in progress and has not yet fully stabilized.
It may change drastically and in backwards-incompatible ways in the repository's
master branch and between releases until version 3.0 is released.__

Features
========

* Supports most of the [Video TECO](http://www.copters.com/teco.html) commands.
* Improved parser compared to classic TECOs, making SciTECO
  more similar to other imperative languages.
* Operator precedence in arithmetic expressions and an argument stack that may be modified
  by the user (commands may have more than two arguments)
* Extended Q-Register namespace (arbitrary strings): Can be used to build libraries and
  can be abused as a data structure.
* Quick access to the system clipboard via special `~` registers, even on ncurses!
* Make use of your keyboard's function keys by assigning them to strings inserted into
  the command stream.
  This also enables navigating with function keys (e.g. cursor keys) as demonstrated
  by the standard library `fnkeys.tes`.
  In fact, all keys with printable representation and control keys can be remapped using
  key macros - and they can be context-sensitive as well!
* There is scriptable mouse support via the key macro mechanism (see also `fnkeys.tes`).
  Autocompletion popups can also be scrolled and clicked.
* Many TECO-11 features, like that most commands have a colon-modified form, string-building
  characters, exotic match characters...
* Interactivity: Immediate searching (similar to search-as-you-type) and
  context-sensitive immediate editing commands.
  In fact almost everything is done on-the-fly, giving immediate interactive feedback.
  This also means that commands can fail immediately and will not even be accepted into
  the command line, making it harder to write incorrect interactive macros.
  Context-sensitive immediate editing commands also make it much harder to destroy a day's
  work by accident than in classic TECOs.
  Also, SciTECO supports many types of context-sensitive auto-completions (i.e. the Tab-key):
  Q-Register names, file names, directories, goto labels, help topics...
* Command rubout: SciTECO can undo almost every side effect, including file writes
  (`EW` command).
  This makes it even harder to destroy work by accident than in most other
  editors.
  Rubbed out commands can be re-inserted (redo).
* Munging: Macros may be munged, that is executed in batch mode. In other words, SciTECO
  can be used for scripting.
  By default, a profile is munged.
* Full Unicode (UTF-8) support: The document is still represented as a random-accessible
  codepoint sequence.
  While SciTECO macros can be written in plain ASCII - even in its printable subset -
  Unicode glyphs can be used everywhere, where a single character is accepted, for instance
  in single letter Q-Register names.
* 8-bit clean: SciTECO can be used to edit binary files if the encoding is changed to
  ANSI and automatic EOL conversion is turned off (easiest with `--8bit`).
* Self-documenting: An integrated indexed help system allows browsing formatted documentation
  about commands, macros and concepts within SciTECO (`?` command).
  Macro packages can be documented with the `tedoc` tool, generating man pages.
  Man pages and [GNU troff](https://www.gnu.org/software/groff/) markup in general
  can be compiled into documents loadable by SciTECO using the `grosciteco` post-processor.
* Cross platform: Builds on a wide variety of platforms. While being focused on UNIX
  and drawing some inspiration from it, other platforms (esp. Windows) are fully
  supported. It is made sure that SciTECO integrates well into all supported
  platforms even without an UNIX-like environment.
* SciTECO is console and command-line friendly.
  Besides running under Curses and being a scripting language, it is written
  to be used interactively on system terminals, can be integrated into
  UNIX pipelines and can be extended with external command-line tools
  (see `EC` command).
  It can easily replace tools like *sed* and *awk*.
* Themeability and consistency: Color settings (or schemes) are applied consistenly
  across all supported platforms. Gtk+ builds allow further customization using CSS.
  The user interface is kept minimalistic and is consistent in spirit across the
  different platforms.
* Syntax highlighting, styles, line numbers, folding, etc. thanks to Scintilla, Lexilla and Scintillua.
  Low-level Scintilla commands can also be accessed to extend SciTECO.
  SciTECO even syntax highlights code, written in the SciTECO language itself.
* Configurable command line with syntax highlighting.
* A growing standard library of macros with frameworks for color schemes, syntax highlighting
  and buffer sessions.
  Optimized for hack-ability rather than completeness.

Download
========

There are prebuilt binary packages and source bundles for your convenience:

* [Main download archive](https://sciteco.fmsbw.de/downloads)
* [Download Archive at Sourceforge](https://sourceforge.net/projects/sciteco/files/)
* [FreeBSD port](https://www.freshports.org/editors/sciteco/)
  [![FreeBSD port](https://repology.org/badge/version-for-repo/freebsd/sciteco-curses.svg?header=PACKAGE)](https://repology.org/project/sciteco-curses/versions)
* OBS repositories and binary downloads for RPM-based (Fedora, openSUSE, etc.) and
  Debian-based (Debian, Raspbian, Ubuntu) distributions:
  [![build result](https://build.opensuse.org/projects/home:rhaberkorn:sciteco:STABLE/packages/sciteco/badge.svg?type=percent)](https://build.opensuse.org/package/show/home:rhaberkorn:sciteco:STABLE/sciteco)
  * [Common packages](https://software.opensuse.org/download.html?project=home:rhaberkorn:sciteco:STABLE&package=sciteco-common)
  * [Gtk packages](https://software.opensuse.org/download.html?project=home:rhaberkorn:sciteco:STABLE&package=sciteco-gtk)
  * [Curses packages](https://software.opensuse.org/download.html?project=home:rhaberkorn:sciteco:STABLE&package=sciteco-curses)
* [Arch User Repository](https://aur.archlinux.org/packages/sciteco-git)
  [![AUR package](https://repology.org/badge/version-for-repo/aur/sciteco.svg?header=PACKAGE)](https://repology.org/project/sciteco/versions)
* [Alpine Linux package](https://pkgs.alpinelinux.org/package/edge/community/x86_64/sciteco)
  [![Alpine Linux Edge package](https://repology.org/badge/version-for-repo/alpine_edge/sciteco.svg?header=PACKAGE)](https://repology.org/project/sciteco/versions)
* [Chocolatey package](https://community.chocolatey.org/packages/SciTECO)
  for Windows users
  [![Chocolatey package](https://repology.org/badge/version-for-repo/chocolatey/sciteco.svg?header=PACKAGE)](https://repology.org/project/sciteco/versions)
* Yocto/OpenEmbedded users should try the
  [`sciteco` package from this layer](https://git.fmsbw.de/meta-rhaberkorn/).
* Users of OpenWrt may try to install the
  [`sciteco` package of this feed](https://git.fmsbw.de/nanonote-ports/).
* ~~[Ubuntu PPA repository](https://launchpad.net/~robin-haberkorn/+archive/sciteco)~~ (deprecated)

These releases may be quite outdated and not all of them are provided or tested by the author.
So you may also try out the following nightly builds:

* OBS repositories and binary downloads for RPM-based (Fedora, openSUSE, etc.) and
  Debian-based (Debian, Raspbian, Ubuntu) distributions:
  [![build result](https://build.opensuse.org/projects/home:rhaberkorn:sciteco:UNSTABLE/packages/sciteco/badge.svg?type=percent)](https://build.opensuse.org/package/show/home:rhaberkorn:sciteco:UNSTABLE/sciteco)
  * [Common packages](https://software.opensuse.org/download.html?project=home:rhaberkorn:sciteco:UNSTABLE&package=sciteco-common)
  * [Gtk packages](https://software.opensuse.org/download.html?project=home:rhaberkorn:sciteco:UNSTABLE&package=sciteco-gtk)
  * [Curses packages](https://software.opensuse.org/download.html?project=home:rhaberkorn:sciteco:UNSTABLE&package=sciteco-curses)
* [Nightly builds](https://sciteco.fmsbw.de/downloads/nightly)
  for Mac OS, Windows and Linux (AppImages).

Nightly builds represent the repository's HEAD commit but may well be unstable.
For [Mac OS X](https://sciteco.fmsbw.de/knowledge/Mac%20OS%20Support/),
we currently only provide *experimental* ncurses builds.

If everything fails, you can try building from source.
See [`INSTALL`](https://git.fmsbw.de/sciteco/tree/INSTALL) for more details.

Community
=========

* Report bugs or submit patches via the [hackers@fmsbw.de mailing list](https://git.fmsbw.de/?p=about).
  You can also send an E-Mail to the author.
  Bugs and planned features are managed in the [TODO](https://git.fmsbw.de/sciteco/tree/TODO) file,
  so you might want to check it before sending your email.
  Make sure to include `[sciteco]` in the mail subject.
* Use the [dings@fmsbw.de mailing list](https://git.fmsbw.de/?p=about)
  for discussions and asking questions.
  Make sure to include `[sciteco]` in the mail subject.
* Join our [IRC chatroom](https://web.libera.chat/#sciteco): #sciteco at irc.libera.chat
* We are also present in the [alt.lang.teco](https://newsgrouper.org/alt.lang.teco) Usenet group,
  but it is not restricted to SciTECO.

Additional Documentation
========================

* Online manpages:
  [__sciteco__(1)](https://sciteco.fmsbw.de/sciteco.1.html),
  [__sciteco__(7)](https://sciteco.fmsbw.de/sciteco.7.html),
  [__grosciteco.tes__(1)](https://sciteco.fmsbw.de/grosciteco.tes.1.html),
  [__tedoc.tes__(1)](https://sciteco.fmsbw.de/tedoc.tes.1.html)
* [Tutorial](https://sciteco.fmsbw.de/tutorial.html):
  This is what you see when you launch SciTECO for the first time.
* [Cheat Sheet and Language Overview](https://sciteco.fmsbw.de/manuals/cheat-sheet.pdf).
  This can be printed on an A4 sheet of paper.
* [Knowledge Base](https://sciteco.fmsbw.de/knowledge/):
  Contains [useful macros](https://sciteco.fmsbw.de/knowledge/Useful%20Macros),
  the [FAQ](https://sciteco.fmsbw.de/knowledge/Frequently%20Asked%20Questions%20(FAQ)) etc.
* A [short presentation](https://sciteco.fmsbw.de/manuals/presentation.pdf)
  (in German!) hold at [Netz39](https://www.netz39.de/).

<p align="center"><img alt="SciTECO icon" src="https://sciteco.fmsbw.de/graphics/sciteco-48.png"/></p>
