
AC_DEFUN([AX_PTRDIFF_ALIASES_INT], [
	AC_CACHE_CHECK([whether ptrdiff_t* aliases int*], [ax_cv_ptrdiff_aliases_int], [
		AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
			@%:@include <stddef.h>
			@%:@include <assert.h>
		]], [[
			ptrdiff_t x = 23;
			_Static_assert(_Generic(&x, int* : 1, default : 0),
			               "ptrdiff_t* does not alias int*");
		]])],
		[ax_cv_ptrdiff_aliases_int=yes],
		[ax_cv_ptrdiff_aliases_int=no])
	])
	AS_IF([test "x$ax_cv_ptrdiff_aliases_int" = "xyes"], [
		AC_DEFINE([PTRDIFF_ALIASES_INT], [1], [Whether ptrdiff_t* aliases int*])
	])
])dnl
