#include <gio/gio.h>
#include <stdio.h>

static void
on_prepare_for_sleep(GDBusConnection *connection,
                     const gchar *sender_name,
                     const gchar *object_path,
                     const gchar *interface_name,
                     const gchar *signal_name,
                     GVariant *parameters,
                     gpointer user_data)
{
    gboolean going_to_sleep;
    g_variant_get(parameters, "(b)", &going_to_sleep);

    if (going_to_sleep) {
        g_print("System is preparing to sleep\n");
    } else {
        g_print("System has resumed from sleep\n");
    }
}

int main(int argc, char *argv[])
{
    GMainLoop *loop;
    GDBusConnection *connection;

    // Connect to the system bus synchronously
    GError *error = NULL;
    connection = g_bus_get_sync(G_BUS_TYPE_SYSTEM, NULL, &error);
    if (error) {
        g_printerr("Failed to connect to system bus: %s\n", error->message);
        g_error_free(error);
        return 1;
    }

    // Subscribe to the PrepareForSleep signal of org.freedesktop.login1.Manager
    g_dbus_connection_signal_subscribe(connection,
                                       "org.freedesktop.login1",       // sender
                                       "org.freedesktop.login1.Manager", // interface
                                       "PrepareForSleep",              // signal name
                                       "/org/freedesktop/login1",     // object path
                                       NULL,                          // arg0
                                       G_DBUS_SIGNAL_FLAGS_NONE,
                                       on_prepare_for_sleep,
                                       NULL,
                                       NULL);

    loop = g_main_loop_new(NULL, FALSE);
    g_main_loop_run(loop);

    // Cleanup and exit
    g_main_loop_unref(loop);
    g_object_unref(connection);

    return 0;
}

