# CPC Security

Data transmitted over the physical bus between the CPC daemon and the secondary
can be encrypted to prevent snooping. The encryption scheme is AES-GCM with a
128-bit key.

To use this feature, the CPC daemon and the secondary must be configured
properly and then bound together.


## Configuration

The security feature must be enabled in the CPC daemon configuration and in the
secondary config file. Minimal version required for Mbed-TLS is *2.7.0*.

In cpcd.conf, `disable_encryption` must be set to false:

    disable_encryption: false

For the secondary, the configuration is in `sl_cpc_security_config.h` and should
contain a valid binding key method (here, ECDH):

    #define SL_CPC_SECURITY_ENABLED    1
    #define SL_CPC_SECURITY_BINDING_KEY_METHOD SL_CPC_SECURITY_BINDING_KEY_ECDH

For ECDH and plain-text binding, the binding key must be shared between the
daemon and the secondary (more on that in the next section). An alternate
solution is "customer-specific". `SL_CPC_SECURITY_BINDING_KEY_CUSTOMER_SPECIFIC`
must be selected as the binding key method in the configuration file. When such
method is selected, the following function must be implemented to return the
16-byte-long binding key.

    void sl_cpc_security_fetch_user_specified_binding_key(uint8_t **key, uint16_t *key_size_in_bytes);


## Binding

In order to communicate securely, the CPC daemon and the secondary must first be
bound together if they use the ECDH or the plain-text binding method. For
customer-specific method, this step is not needed. During binding, a binding
key is shared between the two devices and that key is then used to derive a new
session key every time the CPC daemon connects to the secondary.

To bind them, the CPC daemon must be started with the `--bind` option. This
option accepts two values: `ecdh` or `plain-text`. The value must match
`SL_CPC_SECURITY_BINDING_KEY_METHOD` as previously configured.

During ECDH binding, the binding key is generated by the daemon. If plain-text
binding is used, a key must be generated manually, for example with openssl:

    # plain-text binding, first generate a binding key
    openssl rand -hex 16 >binding.key
    # call cpcd with --bind
    cpcd --bind plain-text --key ./binding.key

    # ecdh binding, by default it generates the binding key in the file
    # where "binding_key_file" points to in cpcd.conf
    cpcd --bind ecdh

    # that setting can be overridden with --key
    cpcd --bind ecdh --key ./binding-ecdh.key

If binding is successful, the daemon should exit without errors. The daemon can
then be started normally without the `--bing` argument.
Data is now encrypted between daemon and secondary.

## Unbinding

If the binding key has to be changed between a CPC daemon and a secondary, the
secondary must be unbound before it can bind again. To do so, launch the CPC
daemon with the `--unbind` option:

    cpcd --unbind

The secondary can allow or deny this operation. By default, it's denied. The
following function must be implemented and return this specific value to allow
unbinding:

    #if defined(SL_CATALOG_CPC_SECURITY_PRESENT)
    uint64_t sl_cpc_security_on_unbind_request(bool is_link_encrypted)
    {
      return SL_CPC_SECURITY_OK_TO_UNBIND;
    }
    #endif

If the unbind has not been implemented, the device can be recovered by using the
sample application `cpc_secondary_uart_security_device_recovery`.

Once the daemon has unbound from the secondary, you may restart the daemon without
the `--unbing` argument.

## Side-effect Of Encryption On Secondary

On the secondary, buffers are sent by calling `sl_cpc_write`. To minimize memory
allocations, buffers' contents are replaced by their encrypted counterparts when
security is used. In other words, buffers are modified when passed to
`sl_cpc_write`.
