#include <stdlib.h>
#include <string.h>

#include "tack.h"

#define bit(a, b) ((a & b) == b)
#define bit_push(b, str) { if (value & b) tack_push(&bits, str); }

static char *finish(tack_t *bits) {
    char *out = tack_str_join(bits, " | ");
    tack_clear(bits);
    return out;
}

#define strdup _strdup
static char *strdup(const char *str) {
    char *dup = malloc(strlen(str) + 1);
    if (dup) {
        strcpy(dup, str);
    }
    return dup;
}

char *gl_bits_glPushAttrib(int value) {
    tack_t bits = {0};
    if (bit(value, 0x000FFFFF)) {
        return strdup("GL_ALL_ATTRIB_BITS");
    }
    bit_push(0x00000001, "GL_CURRENT_BIT");
    bit_push(0x00000002, "GL_POINT_BIT");
    bit_push(0x00000004, "GL_LINE_BIT");
    bit_push(0x00000008, "GL_POLYGON_BIT");
    bit_push(0x00000010, "GL_POLYGON_STIPPLE_BIT");
    bit_push(0x00000020, "GL_PIXEL_MODE_BIT");
    bit_push(0x00000040, "GL_LIGHTING_BIT");
    bit_push(0x00000080, "GL_FOG_BIT");
    bit_push(0x00000100, "GL_DEPTH_BUFFER_BIT");
    bit_push(0x00000200, "GL_ACCUM_BUFFER_BIT");
    bit_push(0x00000400, "GL_STENCIL_BUFFER_BIT");
    bit_push(0x00000800, "GL_VIEWPORT_BIT");
    bit_push(0x00001000, "GL_TRANSFORM_BIT");
    bit_push(0x00002000, "GL_ENABLE_BIT");
    bit_push(0x00004000, "GL_COLOR_BUFFER_BIT");
    bit_push(0x00008000, "GL_HINT_BIT");
    bit_push(0x00010000, "GL_EVAL_BIT");
    bit_push(0x00020000, "GL_LIST_BIT");
    bit_push(0x00040000, "GL_TEXTURE_BIT");
    bit_push(0x00080000, "GL_SCISSOR_BIT");
    return finish(&bits);
}

char *gl_bits_glPushClientAttrib(int value) {
    tack_t bits = {0};
    if (bit(value, 0xFFFFFFFF)) {
        return strdup("GL_CLIENT_ALL_ATTRIB_BITS");
    }
    bit_push(0x00000001, "GL_CLIENT_PIXEL_STORE_BIT");
    bit_push(0x00000002, "GL_CLIENT_VERTEX_ARRAY_BIT");
    return finish(&bits);
}

char *gl_bits_glCreateShader(int value) {
    tack_t bits = {0};
    if (bit(value, 0xFFFFFFFF)) {
        return strdup("GL_ALL_SHADER_BITS");
    }
    bit_push(0x00000001, "GL_VERTEX_SHADER_BIT");
    bit_push(0x00000002, "GL_FRAGMENT_SHADER_BIT");
    bit_push(0x00000004, "GL_GEOMETRY_SHADER_BIT");
    bit_push(0x00000008, "GL_TESS_CONTROL_SHADER_BIT");
    return finish(&bits);
}

const char *gl_str_glMap(int value) {
    switch (value) {
        case 0x0001: return "GL_MAP_READ_BIT";
        case 0x0002: return "GL_MAP_WRITE_BIT";
        case 0x0004: return "GL_MAP_INVALIDATE_RANGE_BIT";
        case 0x0008: return "GL_MAP_INVALIDATE_BUFFER_BIT";
        case 0x0010: return "GL_MAP_FLUSH_EXPLICIT_BIT";
        case 0x0020: return "GL_MAP_UNSYNCHRONIZED_BIT";
    }
    return NULL;
}

const char *gl_str_primitive(int value) {
    switch (value) {
        case 0x0000: return "GL_POINTS";
        case 0x0001: return "GL_LINES";
        case 0x0002: return "GL_LINE_LOOP";
        case 0x0003: return "GL_LINE_STRIP";
        case 0x0004: return "GL_TRIANGLES";
        case 0x0005: return "GL_TRIANGLE_STRIP";
        case 0x0006: return "GL_TRIANGLE_FAN";
        case 0x0007: return "GL_QUADS";
        case 0x0008: return "GL_QUAD_STRIP";
        case 0x0009: return "GL_POLYGON";
        case 0x000A: return "GL_LINES_ADJACENCY";
        case 0x000B: return "GL_LINE_STRIP_ADJACENCY";
        case 0x000C: return "GL_TRIANGLES_ADJACENCY";
        case 0x000D: return "GL_TRIANGLE_STRIP_ADJACENCY";
    }
    return NULL;
}

const char *gl_str(int value) {
    switch (value) {
        case 0x0: return "GL_ZERO";
        case 0x1: return "GL_ONE";
        case 0x0A00: return "GL_COEFF";
        case 0x0A01: return "GL_ORDER";
        case 0x0A02: return "GL_DOMAIN";
        case 0x0B00: return "GL_CURRENT_COLOR";
        case 0x0B01: return "GL_CURRENT_INDEX";
        case 0x0B02: return "GL_CURRENT_NORMAL";
        case 0x0B03: return "GL_CURRENT_TEXTURE_COORDS";
        case 0x0B04: return "GL_CURRENT_RASTER_COLOR";
        case 0x0B05: return "GL_CURRENT_RASTER_INDEX";
        case 0x0B06: return "GL_CURRENT_RASTER_TEXTURE_COORDS";
        case 0x0B07: return "GL_CURRENT_RASTER_POSITION";
        case 0x0B08: return "GL_CURRENT_RASTER_POSITION_VALID";
        case 0x0B09: return "GL_CURRENT_RASTER_DISTANCE";
        case 0x0B10: return "GL_POINT_SMOOTH";
        case 0x0B11: return "GL_POINT_SIZE";
        case 0x0B12: return "GL_POINT_SIZE_RANGE";
        case 0x0B13: return "GL_POINT_SIZE_GRANULARITY";
        case 0x0B20: return "GL_LINE_SMOOTH";
        case 0x0B21: return "GL_LINE_WIDTH";
        case 0x0B22: return "GL_LINE_WIDTH_RANGE";
        case 0x0B23: return "GL_LINE_WIDTH_GRANULARITY";
        case 0x0B24: return "GL_LINE_STIPPLE";
        case 0x0B25: return "GL_LINE_STIPPLE_PATTERN";
        case 0x0B26: return "GL_LINE_STIPPLE_REPEAT";
        case 0x0B30: return "GL_LIST_MODE";
        case 0x0B31: return "GL_MAX_LIST_NESTING";
        case 0x0B32: return "GL_LIST_BASE";
        case 0x0B33: return "GL_LIST_INDEX";
        case 0x0B40: return "GL_POLYGON_MODE";
        case 0x0B41: return "GL_POLYGON_SMOOTH";
        case 0x0B42: return "GL_POLYGON_STIPPLE";
        case 0x0B43: return "GL_EDGE_FLAG";
        case 0x0B44: return "GL_CULL_FACE";
        case 0x0B45: return "GL_CULL_FACE_MODE";
        case 0x0B46: return "GL_FRONT_FACE";
        case 0x0B50: return "GL_LIGHTING";
        case 0x0B51: return "GL_LIGHT_MODEL_LOCAL_VIEWER";
        case 0x0B52: return "GL_LIGHT_MODEL_TWO_SIDE";
        case 0x0B53: return "GL_LIGHT_MODEL_AMBIENT";
        case 0x0B54: return "GL_SHADE_MODEL";
        case 0x0B55: return "GL_COLOR_MATERIAL_FACE";
        case 0x0B56: return "GL_COLOR_MATERIAL_PARAMETER";
        case 0x0B57: return "GL_COLOR_MATERIAL";
        case 0x0B60: return "GL_FOG";
        case 0x0B61: return "GL_FOG_INDEX";
        case 0x0B62: return "GL_FOG_DENSITY";
        case 0x0B63: return "GL_FOG_START";
        case 0x0B64: return "GL_FOG_END";
        case 0x0B65: return "GL_FOG_MODE";
        case 0x0B66: return "GL_FOG_COLOR";
        case 0x0B70: return "GL_DEPTH_RANGE";
        case 0x0B71: return "GL_DEPTH_TEST";
        case 0x0B72: return "GL_DEPTH_WRITEMASK";
        case 0x0B73: return "GL_DEPTH_CLEAR_VALUE";
        case 0x0B74: return "GL_DEPTH_FUNC";
        case 0x0B80: return "GL_ACCUM_CLEAR_VALUE";
        case 0x0B90: return "GL_STENCIL_TEST";
        case 0x0B91: return "GL_STENCIL_CLEAR_VALUE";
        case 0x0B92: return "GL_STENCIL_FUNC";
        case 0x0B93: return "GL_STENCIL_VALUE_MASK";
        case 0x0B94: return "GL_STENCIL_FAIL";
        case 0x0B95: return "GL_STENCIL_PASS_DEPTH_FAIL";
        case 0x0B96: return "GL_STENCIL_PASS_DEPTH_PASS";
        case 0x0B97: return "GL_STENCIL_REF";
        case 0x0B98: return "GL_STENCIL_WRITEMASK";
        case 0x0BA0: return "GL_MATRIX_MODE";
        case 0x0BA1: return "GL_NORMALIZE";
        case 0x0BA2: return "GL_VIEWPORT";
        case 0x0BA3: return "GL_MODELVIEW_STACK_DEPTH";
        case 0x0BA4: return "GL_PROJECTION_STACK_DEPTH";
        case 0x0BA5: return "GL_TEXTURE_STACK_DEPTH";
        case 0x0BA6: return "GL_MODELVIEW_MATRIX";
        case 0x0BA7: return "GL_PROJECTION_MATRIX";
        case 0x0BA8: return "GL_TEXTURE_MATRIX";
        case 0x0BB0: return "GL_ATTRIB_STACK_DEPTH";
        case 0x0BB1: return "GL_CLIENT_ATTRIB_STACK_DEPTH";
        case 0x0BC0: return "GL_ALPHA_TEST";
        case 0x0BC1: return "GL_ALPHA_TEST_FUNC";
        case 0x0BC2: return "GL_ALPHA_TEST_REF";
        case 0x0BD0: return "GL_DITHER";
        case 0x0BE0: return "GL_BLEND_DST";
        case 0x0BE1: return "GL_BLEND_SRC";
        case 0x0BE2: return "GL_BLEND";
        case 0x0BF0: return "GL_LOGIC_OP_MODE";
        case 0x0BF1: return "GL_LOGIC_OP";
        case 0x0BF2: return "GL_COLOR_LOGIC_OP";
        case 0x0C00: return "GL_AUX_BUFFERS";
        case 0x0C01: return "GL_DRAW_BUFFER";
        case 0x0C02: return "GL_READ_BUFFER";
        case 0x0C10: return "GL_SCISSOR_BOX";
        case 0x0C11: return "GL_SCISSOR_TEST";
        case 0x0C20: return "GL_INDEX_CLEAR_VALUE";
        case 0x0C21: return "GL_INDEX_WRITEMASK";
        case 0x0C22: return "GL_COLOR_CLEAR_VALUE";
        case 0x0C23: return "GL_COLOR_WRITEMASK";
        case 0x0C30: return "GL_INDEX_MODE";
        case 0x0C31: return "GL_RGBA_MODE";
        case 0x0C32: return "GL_DOUBLEBUFFER";
        case 0x0C33: return "GL_STEREO";
        case 0x0C40: return "GL_RENDER_MODE";
        case 0x0C50: return "GL_PERSPECTIVE_CORRECTION_HINT";
        case 0x0C51: return "GL_POINT_SMOOTH_HINT";
        case 0x0C52: return "GL_LINE_SMOOTH_HINT";
        case 0x0C53: return "GL_POLYGON_SMOOTH_HINT";
        case 0x0C54: return "GL_FOG_HINT";
        case 0x0C60: return "GL_TEXTURE_GEN_S";
        case 0x0C61: return "GL_TEXTURE_GEN_T";
        case 0x0C62: return "GL_TEXTURE_GEN_R";
        case 0x0C63: return "GL_TEXTURE_GEN_Q";
        case 0x0C70: return "GL_PIXEL_MAP_I_TO_I";
        case 0x0C71: return "GL_PIXEL_MAP_S_TO_S";
        case 0x0C72: return "GL_PIXEL_MAP_I_TO_R";
        case 0x0C73: return "GL_PIXEL_MAP_I_TO_G";
        case 0x0C74: return "GL_PIXEL_MAP_I_TO_B";
        case 0x0C75: return "GL_PIXEL_MAP_I_TO_A";
        case 0x0C76: return "GL_PIXEL_MAP_R_TO_R";
        case 0x0C77: return "GL_PIXEL_MAP_G_TO_G";
        case 0x0C78: return "GL_PIXEL_MAP_B_TO_B";
        case 0x0C79: return "GL_PIXEL_MAP_A_TO_A";
        case 0x0CB0: return "GL_PIXEL_MAP_I_TO_I_SIZE";
        case 0x0CB1: return "GL_PIXEL_MAP_S_TO_S_SIZE";
        case 0x0CB2: return "GL_PIXEL_MAP_I_TO_R_SIZE";
        case 0x0CB3: return "GL_PIXEL_MAP_I_TO_G_SIZE";
        case 0x0CB4: return "GL_PIXEL_MAP_I_TO_B_SIZE";
        case 0x0CB5: return "GL_PIXEL_MAP_I_TO_A_SIZE";
        case 0x0CB6: return "GL_PIXEL_MAP_R_TO_R_SIZE";
        case 0x0CB7: return "GL_PIXEL_MAP_G_TO_G_SIZE";
        case 0x0CB8: return "GL_PIXEL_MAP_B_TO_B_SIZE";
        case 0x0CB9: return "GL_PIXEL_MAP_A_TO_A_SIZE";
        case 0x0CF0: return "GL_UNPACK_SWAP_BYTES";
        case 0x0CF1: return "GL_UNPACK_LSB_FIRST";
        case 0x0CF2: return "GL_UNPACK_ROW_LENGTH";
        case 0x0CF3: return "GL_UNPACK_SKIP_ROWS";
        case 0x0CF4: return "GL_UNPACK_SKIP_PIXELS";
        case 0x0CF5: return "GL_UNPACK_ALIGNMENT";
        case 0x0D00: return "GL_PACK_SWAP_BYTES";
        case 0x0D01: return "GL_PACK_LSB_FIRST";
        case 0x0D1A: return "GL_BLUE_SCALE";
        case 0x0D1B: return "GL_BLUE_BIAS";
        case 0x0D1C: return "GL_ALPHA_SCALE";
        case 0x0D1D: return "GL_ALPHA_BIAS";
        case 0x0D1E: return "GL_DEPTH_SCALE";
        case 0x0D1F: return "GL_DEPTH_BIAS";
        case 0x0D02: return "GL_PACK_ROW_LENGTH";
        case 0x0D03: return "GL_PACK_SKIP_ROWS";
        case 0x0D3A: return "GL_MAX_VIEWPORT_DIMS";
        case 0x0D3B: return "GL_MAX_CLIENT_ATTRIB_STACK_DEPTH";
        case 0x0D04: return "GL_PACK_SKIP_PIXELS";
        case 0x0D05: return "GL_PACK_ALIGNMENT";
        case 0x0D5A: return "GL_ACCUM_BLUE_BITS";
        case 0x0D5B: return "GL_ACCUM_ALPHA_BITS";
        case 0x0D10: return "GL_MAP_COLOR";
        case 0x0D11: return "GL_MAP_STENCIL";
        case 0x0D12: return "GL_INDEX_SHIFT";
        case 0x0D13: return "GL_INDEX_OFFSET";
        case 0x0D14: return "GL_RED_SCALE";
        case 0x0D15: return "GL_RED_BIAS";
        case 0x0D16: return "GL_ZOOM_X";
        case 0x0D17: return "GL_ZOOM_Y";
        case 0x0D18: return "GL_GREEN_SCALE";
        case 0x0D19: return "GL_GREEN_BIAS";
        case 0x0D30: return "GL_MAX_EVAL_ORDER";
        case 0x0D31: return "GL_MAX_LIGHTS";
        case 0x0D32: return "GL_MAX_CLIP_PLANES";
        case 0x0D33: return "GL_MAX_TEXTURE_SIZE";
        case 0x0D34: return "GL_MAX_PIXEL_MAP_TABLE";
        case 0x0D35: return "GL_MAX_ATTRIB_STACK_DEPTH";
        case 0x0D36: return "GL_MAX_MODELVIEW_STACK_DEPTH";
        case 0x0D37: return "GL_MAX_NAME_STACK_DEPTH";
        case 0x0D38: return "GL_MAX_PROJECTION_STACK_DEPTH";
        case 0x0D39: return "GL_MAX_TEXTURE_STACK_DEPTH";
        case 0x0D50: return "GL_SUBPIXEL_BITS";
        case 0x0D51: return "GL_INDEX_BITS";
        case 0x0D52: return "GL_RED_BITS";
        case 0x0D53: return "GL_GREEN_BITS";
        case 0x0D54: return "GL_BLUE_BITS";
        case 0x0D55: return "GL_ALPHA_BITS";
        case 0x0D56: return "GL_DEPTH_BITS";
        case 0x0D57: return "GL_STENCIL_BITS";
        case 0x0D58: return "GL_ACCUM_RED_BITS";
        case 0x0D59: return "GL_ACCUM_GREEN_BITS";
        case 0x0D70: return "GL_NAME_STACK_DEPTH";
        case 0x0D80: return "GL_AUTO_NORMAL";
        case 0x0D90: return "GL_MAP1_COLOR_4";
        case 0x0D91: return "GL_MAP1_INDEX";
        case 0x0D92: return "GL_MAP1_NORMAL";
        case 0x0D93: return "GL_MAP1_TEXTURE_COORD_1";
        case 0x0D94: return "GL_MAP1_TEXTURE_COORD_2";
        case 0x0D95: return "GL_MAP1_TEXTURE_COORD_3";
        case 0x0D96: return "GL_MAP1_TEXTURE_COORD_4";
        case 0x0D97: return "GL_MAP1_VERTEX_3";
        case 0x0D98: return "GL_MAP1_VERTEX_4";
        case 0x0DB0: return "GL_MAP2_COLOR_4";
        case 0x0DB1: return "GL_MAP2_INDEX";
        case 0x0DB2: return "GL_MAP2_NORMAL";
        case 0x0DB3: return "GL_MAP2_TEXTURE_COORD_1";
        case 0x0DB4: return "GL_MAP2_TEXTURE_COORD_2";
        case 0x0DB5: return "GL_MAP2_TEXTURE_COORD_3";
        case 0x0DB6: return "GL_MAP2_TEXTURE_COORD_4";
        case 0x0DB7: return "GL_MAP2_VERTEX_3";
        case 0x0DB8: return "GL_MAP2_VERTEX_4";
        case 0x0DD0: return "GL_MAP1_GRID_DOMAIN";
        case 0x0DD1: return "GL_MAP1_GRID_SEGMENTS";
        case 0x0DD2: return "GL_MAP2_GRID_DOMAIN";
        case 0x0DD3: return "GL_MAP2_GRID_SEGMENTS";
        case 0x0DE0: return "GL_TEXTURE_1D";
        case 0x0DE1: return "GL_TEXTURE_2D";
        case 0x0DF0: return "GL_FEEDBACK_BUFFER_POINTER";
        case 0x0DF1: return "GL_FEEDBACK_BUFFER_SIZE";
        case 0x0DF2: return "GL_FEEDBACK_BUFFER_TYPE";
        case 0x0DF3: return "GL_SELECTION_BUFFER_POINTER";
        case 0x0DF4: return "GL_SELECTION_BUFFER_SIZE";
        case 0x000E: return "GL_PATCHES";
        case 0x1A00: return "GL_BITMAP";
        case 0x1B00: return "GL_POINT";
        case 0x1B01: return "GL_LINE";
        case 0x1B02: return "GL_FILL";
        case 0x1C00: return "GL_RENDER";
        case 0x1C01: return "GL_FEEDBACK";
        case 0x1C02: return "GL_SELECT";
        case 0x1D00: return "GL_FLAT";
        case 0x1D01: return "GL_SMOOTH";
        case 0x1E00: return "GL_KEEP";
        case 0x1E01: return "GL_REPLACE";
        case 0x1E02: return "GL_INCR";
        case 0x1E03: return "GL_DECR";
        case 0x1F00: return "GL_VENDOR";
        case 0x1F01: return "GL_RENDERER";
        case 0x1F02: return "GL_VERSION";
        case 0x1F03: return "GL_EXTENSIONS";
        case 0x2A00: return "GL_POLYGON_OFFSET_UNITS";
        case 0x2A01: return "GL_POLYGON_OFFSET_POINT";
        case 0x2A02: return "GL_POLYGON_OFFSET_LINE";
        case 0x2A2A: return "GL_T2F_C3F_V3F";
        case 0x2A2B: return "GL_T2F_N3F_V3F";
        case 0x2A2C: return "GL_T2F_C4F_N3F_V3F";
        case 0x2A2D: return "GL_T4F_C4F_N3F_V4F";
        case 0x2A10: return "GL_R3_G3_B2";
        case 0x2A20: return "GL_V2F";
        case 0x2A21: return "GL_V3F";
        case 0x2A22: return "GL_C4UB_V2F";
        case 0x2A23: return "GL_C4UB_V3F";
        case 0x2A24: return "GL_C3F_V3F";
        case 0x2A25: return "GL_N3F_V3F";
        case 0x2A26: return "GL_C4F_N3F_V3F";
        case 0x2A27: return "GL_T2F_V3F";
        case 0x2A28: return "GL_T4F_V4F";
        case 0x2A29: return "GL_T2F_C4UB_V3F";
        case 0x8A00: return "GL_VERTEX_ATTRIB_MAP1_APPLE";
        case 0x8A0A: return "GL_DRAW_PIXELS_APPLE";
        case 0x8A0B: return "GL_FENCE_APPLE";
        case 0x8A0C: return "GL_ELEMENT_ARRAY_APPLE";
        case 0x8A0D: return "GL_ELEMENT_ARRAY_TYPE_APPLE";
        case 0x8A0E: return "GL_ELEMENT_ARRAY_POINTER_APPLE";
        case 0x8A0F: return "GL_COLOR_FLOAT_APPLE";
        case 0x8A01: return "GL_VERTEX_ATTRIB_MAP2_APPLE";
        case 0x8A1A: return "GL_VOLATILE_APPLE";
        case 0x8A1B: return "GL_RETAINED_APPLE";
        case 0x8A1C: return "GL_UNDEFINED_APPLE";
        case 0x8A1D: return "GL_PURGEABLE_APPLE";
        case 0x8A1F: return "GL_RGB_422_APPLE";
        case 0x8A02: return "GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE";
        case 0x8A2A: return "GL_UNIFORM_BUFFER_SIZE";
        case 0x8A2B: return "GL_MAX_VERTEX_UNIFORM_BLOCKS";
        case 0x8A2C: return "GL_MAX_GEOMETRY_UNIFORM_BLOCKS";
        case 0x8A2D: return "GL_MAX_FRAGMENT_UNIFORM_BLOCKS";
        case 0x8A2E: return "GL_MAX_COMBINED_UNIFORM_BLOCKS";
        case 0x8A2F: return "GL_MAX_UNIFORM_BUFFER_BINDINGS";
        case 0x8A03: return "GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE";
        case 0x8A3A: return "GL_UNIFORM_BLOCK_INDEX";
        case 0x8A3B: return "GL_UNIFORM_OFFSET";
        case 0x8A3C: return "GL_UNIFORM_ARRAY_STRIDE";
        case 0x8A3D: return "GL_UNIFORM_MATRIX_STRIDE";
        case 0x8A3E: return "GL_UNIFORM_IS_ROW_MAJOR";
        case 0x8A3F: return "GL_UNIFORM_BLOCK_BINDING";
        case 0x8A04: return "GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE";
        case 0x8A05: return "GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE";
        case 0x8A06: return "GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE";
        case 0x8A07: return "GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE";
        case 0x8A08: return "GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE";
        case 0x8A09: return "GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE";
        case 0x8A11: return "GL_UNIFORM_BUFFER";
        case 0x8A12: return "GL_BUFFER_SERIALIZED_MODIFY_APPLE";
        case 0x8A13: return "GL_BUFFER_FLUSHING_UNMAP_APPLE";
        case 0x8A14: return "GL_AUX_DEPTH_STENCIL_APPLE";
        case 0x8A15: return "GL_PACK_ROW_BYTES_APPLE";
        case 0x8A16: return "GL_UNPACK_ROW_BYTES_APPLE";
        case 0x8A19: return "GL_RELEASED_APPLE";
        case 0x8A28: return "GL_UNIFORM_BUFFER_BINDING";
        case 0x8A29: return "GL_UNIFORM_BUFFER_START";
        case 0x8A30: return "GL_MAX_UNIFORM_BLOCK_SIZE";
        case 0x8A31: return "GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS";
        case 0x8A32: return "GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS";
        case 0x8A33: return "GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS";
        case 0x8A34: return "GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT";
        case 0x8A35: return "GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH";
        case 0x8A36: return "GL_ACTIVE_UNIFORM_BLOCKS";
        case 0x8A37: return "GL_UNIFORM_TYPE";
        case 0x8A38: return "GL_UNIFORM_SIZE";
        case 0x8A39: return "GL_UNIFORM_NAME_LENGTH";
        case 0x8A40: return "GL_UNIFORM_BLOCK_DATA_SIZE";
        case 0x8A41: return "GL_UNIFORM_BLOCK_NAME_LENGTH";
        case 0x8A42: return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS";
        case 0x8A43: return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES";
        case 0x8A44: return "GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER";
        case 0x8A45: return "GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER";
        case 0x8A46: return "GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER";
        case 0x8B4A: return "GL_MAX_VERTEX_UNIFORM_COMPONENTS";
        case 0x8B4B: return "GL_MAX_VARYING_COMPONENTS";
        case 0x8B4C: return "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS";
        case 0x8B4D: return "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS";
        case 0x8B4E: return "GL_OBJECT_TYPE_ARB";
        case 0x8B4F: return "GL_SHADER_TYPE";
        case 0x8B5A: return "GL_FLOAT_MAT2";
        case 0x8B5B: return "GL_FLOAT_MAT3";
        case 0x8B5C: return "GL_FLOAT_MAT4";
        case 0x8B5D: return "GL_SAMPLER_1D";
        case 0x8B5E: return "GL_SAMPLER_2D";
        case 0x8B5F: return "GL_SAMPLER_3D";
        case 0x8B6A: return "GL_FLOAT_MAT4x3";
        case 0x8B8A: return "GL_ACTIVE_ATTRIBUTE_MAX_LENGTH";
        case 0x8B8B: return "GL_FRAGMENT_SHADER_DERIVATIVE_HINT";
        case 0x8B8C: return "GL_SHADING_LANGUAGE_VERSION";
        case 0x8B8D: return "GL_CURRENT_PROGRAM";
        case 0x8B9A: return "GL_IMPLEMENTATION_COLOR_READ_TYPE";
        case 0x8B9B: return "GL_IMPLEMENTATION_COLOR_READ_FORMAT";
        case 0x8B30: return "GL_FRAGMENT_SHADER";
        case 0x8B31: return "GL_VERTEX_SHADER";
        case 0x8B40: return "GL_PROGRAM_OBJECT_ARB";
        case 0x8B48: return "GL_SHADER_OBJECT_ARB";
        case 0x8B49: return "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS";
        case 0x8B50: return "GL_FLOAT_VEC2";
        case 0x8B51: return "GL_FLOAT_VEC3";
        case 0x8B52: return "GL_FLOAT_VEC4";
        case 0x8B53: return "GL_INT_VEC2";
        case 0x8B54: return "GL_INT_VEC3";
        case 0x8B55: return "GL_INT_VEC4";
        case 0x8B56: return "GL_BOOL";
        case 0x8B57: return "GL_BOOL_VEC2";
        case 0x8B58: return "GL_BOOL_VEC3";
        case 0x8B59: return "GL_BOOL_VEC4";
        case 0x8B60: return "GL_SAMPLER_CUBE";
        case 0x8B61: return "GL_SAMPLER_1D_SHADOW";
        case 0x8B62: return "GL_SAMPLER_2D_SHADOW";
        case 0x8B63: return "GL_SAMPLER_2D_RECT";
        case 0x8B64: return "GL_SAMPLER_2D_RECT_SHADOW";
        case 0x8B65: return "GL_FLOAT_MAT2x3";
        case 0x8B66: return "GL_FLOAT_MAT2x4";
        case 0x8B67: return "GL_FLOAT_MAT3x2";
        case 0x8B68: return "GL_FLOAT_MAT3x4";
        case 0x8B69: return "GL_FLOAT_MAT4x2";
        case 0x8B80: return "GL_DELETE_STATUS";
        case 0x8B81: return "GL_COMPILE_STATUS";
        case 0x8B82: return "GL_LINK_STATUS";
        case 0x8B83: return "GL_OBJECT_VALIDATE_STATUS_ARB";
        case 0x8B84: return "GL_INFO_LOG_LENGTH";
        case 0x8B85: return "GL_ATTACHED_SHADERS";
        case 0x8B86: return "GL_ACTIVE_UNIFORMS";
        case 0x8B87: return "GL_ACTIVE_UNIFORM_MAX_LENGTH";
        case 0x8B88: return "GL_OBJECT_SHADER_SOURCE_LENGTH_ARB";
        case 0x8B89: return "GL_ACTIVE_ATTRIBUTES";
        case 0x8bb0: return "GL_FRAGMENT_PROGRAM_POSITION_MESA";
        case 0x8bb1: return "GL_FRAGMENT_PROGRAM_CALLBACK_MESA";
        case 0x8bb2: return "GL_FRAGMENT_PROGRAM_CALLBACK_FUNC_MESA";
        case 0x8bb3: return "GL_FRAGMENT_PROGRAM_CALLBACK_DATA_MESA";
        case 0x8bb4: return "GL_VERTEX_PROGRAM_POSITION_MESA";
        case 0x8bb5: return "GL_VERTEX_PROGRAM_CALLBACK_MESA";
        case 0x8bb6: return "GL_VERTEX_PROGRAM_CALLBACK_FUNC_MESA";
        case 0x8bb7: return "GL_VERTEX_PROGRAM_CALLBACK_DATA_MESA";
        case 0x8BC0: return "GL_COUNTER_TYPE_AMD";
        case 0x8BC1: return "GL_COUNTER_RANGE_AMD";
        case 0x8BC2: return "GL_UNSIGNED_INT64_AMD";
        case 0x8BC3: return "GL_PERCENTAGE_AMD";
        case 0x8BC4: return "GL_PERFMON_RESULT_AVAILABLE_AMD";
        case 0x8BC5: return "GL_PERFMON_RESULT_SIZE_AMD";
        case 0x8BC6: return "GL_PERFMON_RESULT_AMD";
        case 0x8C1A: return "GL_TEXTURE_2D_ARRAY";
        case 0x8C1B: return "GL_PROXY_TEXTURE_2D_ARRAY";
        case 0x8C1C: return "GL_TEXTURE_BINDING_1D_ARRAY";
        case 0x8C1D: return "GL_TEXTURE_BINDING_2D_ARRAY";
        case 0x8C2A: return "GL_TEXTURE_BUFFER";
        case 0x8C2B: return "GL_MAX_TEXTURE_BUFFER_SIZE";
        case 0x8C2C: return "GL_TEXTURE_BINDING_BUFFER";
        case 0x8C2D: return "GL_TEXTURE_BUFFER_DATA_STORE_BINDING";
        case 0x8C2E: return "GL_TEXTURE_BUFFER_FORMAT";
        case 0x8C2F: return "GL_ANY_SAMPLES_PASSED";
        case 0x8C3A: return "GL_R11F_G11F_B10F";
        case 0x8C3B: return "GL_UNSIGNED_INT_10F_11F_11F_REV";
        case 0x8C3C: return "GL_RGBA_SIGNED_COMPONENTS_EXT";
        case 0x8C3D: return "GL_RGB9_E5";
        case 0x8C3E: return "GL_UNSIGNED_INT_5_9_9_9_REV";
        case 0x8C3F: return "GL_TEXTURE_SHARED_SIZE";
        case 0x8C4A: return "GL_COMPRESSED_SLUMINANCE";
        case 0x8C4B: return "GL_COMPRESSED_SLUMINANCE_ALPHA";
        case 0x8C4C: return "GL_COMPRESSED_SRGB_S3TC_DXT1_EXT";
        case 0x8C4D: return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT";
        case 0x8C4E: return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT";
        case 0x8C4F: return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT";
        case 0x8C7F: return "GL_TRANSFORM_FEEDBACK_BUFFER_MODE";
        case 0x8C8A: return "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS";
        case 0x8C8B: return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS";
        case 0x8C8C: return "GL_INTERLEAVED_ATTRIBS";
        case 0x8C8D: return "GL_SEPARATE_ATTRIBS";
        case 0x8C8E: return "GL_TRANSFORM_FEEDBACK_BUFFER";
        case 0x8C8F: return "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING";
        case 0x8C10: return "GL_TEXTURE_RED_TYPE";
        case 0x8C11: return "GL_TEXTURE_GREEN_TYPE";
        case 0x8C12: return "GL_TEXTURE_BLUE_TYPE";
        case 0x8C13: return "GL_TEXTURE_ALPHA_TYPE";
        case 0x8C14: return "GL_TEXTURE_LUMINANCE_TYPE";
        case 0x8C15: return "GL_TEXTURE_INTENSITY_TYPE";
        case 0x8C16: return "GL_TEXTURE_DEPTH_TYPE";
        case 0x8C17: return "GL_UNSIGNED_NORMALIZED";
        case 0x8C18: return "GL_TEXTURE_1D_ARRAY";
        case 0x8C19: return "GL_PROXY_TEXTURE_1D_ARRAY";
        case 0x8C29: return "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS";
        case 0x8C36: return "GL_SAMPLE_SHADING";
        case 0x8C37: return "GL_MIN_SAMPLE_SHADING_VALUE";
        case 0x8C40: return "GL_SRGB";
        case 0x8C41: return "GL_SRGB8";
        case 0x8C42: return "GL_SRGB_ALPHA";
        case 0x8C43: return "GL_SRGB8_ALPHA8";
        case 0x8C44: return "GL_SLUMINANCE_ALPHA";
        case 0x8C45: return "GL_SLUMINANCE8_ALPHA8";
        case 0x8C46: return "GL_SLUMINANCE";
        case 0x8C47: return "GL_SLUMINANCE8";
        case 0x8C48: return "GL_COMPRESSED_SRGB";
        case 0x8C49: return "GL_COMPRESSED_SRGB_ALPHA";
        case 0x8C70: return "GL_COMPRESSED_LUMINANCE_LATC1_EXT";
        case 0x8C71: return "GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT";
        case 0x8C72: return "GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT";
        case 0x8C73: return "GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT";
        case 0x8C76: return "GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH";
        case 0x8C80: return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS";
        case 0x8C83: return "GL_TRANSFORM_FEEDBACK_VARYINGS";
        case 0x8C84: return "GL_TRANSFORM_FEEDBACK_BUFFER_START";
        case 0x8C85: return "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE";
        case 0x8C87: return "GL_PRIMITIVES_GENERATED";
        case 0x8C88: return "GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN";
        case 0x8C89: return "GL_RASTERIZER_DISCARD";
        case 0x8CA0: return "GL_POINT_SPRITE_COORD_ORIGIN";
        case 0x8CA1: return "GL_LOWER_LEFT";
        case 0x8CA2: return "GL_UPPER_LEFT";
        case 0x8CA3: return "GL_STENCIL_BACK_REF";
        case 0x8CA4: return "GL_STENCIL_BACK_VALUE_MASK";
        case 0x8CA5: return "GL_STENCIL_BACK_WRITEMASK";
        case 0x8CA6: return "GL_FRAMEBUFFER_BINDING";
        case 0x8CA7: return "GL_RENDERBUFFER_BINDING";
        case 0x8CA8: return "GL_READ_FRAMEBUFFER";
        case 0x8CA9: return "GL_DRAW_FRAMEBUFFER";
        case 0x8CAA: return "GL_READ_FRAMEBUFFER_BINDING";
        case 0x8CAB: return "GL_RENDERBUFFER_SAMPLES";
        case 0x8CAC: return "GL_DEPTH_COMPONENT32F";
        case 0x8CAD: return "GL_DEPTH32F_STENCIL8";
        case 0x8CD0: return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE";
        case 0x8CD1: return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME";
        case 0x8CD2: return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL";
        case 0x8CD3: return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE";
        case 0x8CD4: return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER";
        case 0x8CD5: return "GL_FRAMEBUFFER_COMPLETE";
        case 0x8CD6: return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
        case 0x8CD7: return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
        case 0x8CD9: return "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT";
        case 0x8CDA: return "GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT";
        case 0x8CDB: return "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER";
        case 0x8CDC: return "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER";
        case 0x8CDD: return "GL_FRAMEBUFFER_UNSUPPORTED";
        case 0x8CDF: return "GL_MAX_COLOR_ATTACHMENTS";
        case 0x8CE0: return "GL_COLOR_ATTACHMENT0";
        case 0x8CE1: return "GL_COLOR_ATTACHMENT1";
        case 0x8CE2: return "GL_COLOR_ATTACHMENT2";
        case 0x8CE3: return "GL_COLOR_ATTACHMENT3";
        case 0x8CE4: return "GL_COLOR_ATTACHMENT4";
        case 0x8CE5: return "GL_COLOR_ATTACHMENT5";
        case 0x8CE6: return "GL_COLOR_ATTACHMENT6";
        case 0x8CE7: return "GL_COLOR_ATTACHMENT7";
        case 0x8CE8: return "GL_COLOR_ATTACHMENT8";
        case 0x8CE9: return "GL_COLOR_ATTACHMENT9";
        case 0x8CEA: return "GL_COLOR_ATTACHMENT10";
        case 0x8CEB: return "GL_COLOR_ATTACHMENT11";
        case 0x8CEC: return "GL_COLOR_ATTACHMENT12";
        case 0x8CED: return "GL_COLOR_ATTACHMENT13";
        case 0x8CEE: return "GL_COLOR_ATTACHMENT14";
        case 0x8CEF: return "GL_COLOR_ATTACHMENT15";
        case 0x8D00: return "GL_DEPTH_ATTACHMENT";
        case 0x8D7A: return "GL_LUMINANCE16UI_EXT";
        case 0x8D7B: return "GL_LUMINANCE_ALPHA16UI_EXT";
        case 0x8D7C: return "GL_RGBA8UI";
        case 0x8D7D: return "GL_RGB8UI";
        case 0x8D7E: return "GL_ALPHA8UI_EXT";
        case 0x8D7F: return "GL_INTENSITY8UI_EXT";
        case 0x8D8A: return "GL_ALPHA16I_EXT";
        case 0x8D8B: return "GL_INTENSITY16I_EXT";
        case 0x8D8C: return "GL_LUMINANCE16I_EXT";
        case 0x8D8D: return "GL_LUMINANCE_ALPHA16I_EXT";
        case 0x8D8E: return "GL_RGBA8I";
        case 0x8D8F: return "GL_RGB8I";
        case 0x8D9A: return "GL_BGR_INTEGER";
        case 0x8D9B: return "GL_BGRA_INTEGER";
        case 0x8D9C: return "GL_LUMINANCE_INTEGER_EXT";
        case 0x8D9D: return "GL_LUMINANCE_ALPHA_INTEGER_EXT";
        case 0x8D9E: return "GL_RGBA_INTEGER_MODE_EXT";
        case 0x8D9F: return "GL_INT_2_10_10_10_REV";
        case 0x8D20: return "GL_STENCIL_ATTACHMENT";
        case 0x8D40: return "GL_FRAMEBUFFER";
        case 0x8D41: return "GL_RENDERBUFFER";
        case 0x8D42: return "GL_RENDERBUFFER_WIDTH";
        case 0x8D43: return "GL_RENDERBUFFER_HEIGHT";
        case 0x8D44: return "GL_RENDERBUFFER_INTERNAL_FORMAT";
        case 0x8D46: return "GL_STENCIL_INDEX1";
        case 0x8D47: return "GL_STENCIL_INDEX4";
        case 0x8D48: return "GL_STENCIL_INDEX8";
        case 0x8D49: return "GL_STENCIL_INDEX16";
        case 0x8D50: return "GL_RENDERBUFFER_RED_SIZE";
        case 0x8D51: return "GL_RENDERBUFFER_GREEN_SIZE";
        case 0x8D52: return "GL_RENDERBUFFER_BLUE_SIZE";
        case 0x8D53: return "GL_RENDERBUFFER_ALPHA_SIZE";
        case 0x8D54: return "GL_RENDERBUFFER_DEPTH_SIZE";
        case 0x8D55: return "GL_RENDERBUFFER_STENCIL_SIZE";
        case 0x8D56: return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE";
        case 0x8D57: return "GL_MAX_SAMPLES";
        case 0x8D70: return "GL_RGBA32UI";
        case 0x8D71: return "GL_RGB32UI";
        case 0x8D72: return "GL_ALPHA32UI_EXT";
        case 0x8D73: return "GL_INTENSITY32UI_EXT";
        case 0x8D74: return "GL_LUMINANCE32UI_EXT";
        case 0x8D75: return "GL_LUMINANCE_ALPHA32UI_EXT";
        case 0x8D76: return "GL_RGBA16UI";
        case 0x8D77: return "GL_RGB16UI";
        case 0x8D78: return "GL_ALPHA16UI_EXT";
        case 0x8D79: return "GL_INTENSITY16UI_EXT";
        case 0x8D80: return "GL_LUMINANCE8UI_EXT";
        case 0x8D81: return "GL_LUMINANCE_ALPHA8UI_EXT";
        case 0x8D82: return "GL_RGBA32I";
        case 0x8D83: return "GL_RGB32I";
        case 0x8D84: return "GL_ALPHA32I_EXT";
        case 0x8D85: return "GL_INTENSITY32I_EXT";
        case 0x8D86: return "GL_LUMINANCE32I_EXT";
        case 0x8D87: return "GL_LUMINANCE_ALPHA32I_EXT";
        case 0x8D88: return "GL_RGBA16I";
        case 0x8D89: return "GL_RGB16I";
        case 0x8D90: return "GL_ALPHA8I_EXT";
        case 0x8D91: return "GL_INTENSITY8I_EXT";
        case 0x8D92: return "GL_LUMINANCE8I_EXT";
        case 0x8D93: return "GL_LUMINANCE_ALPHA8I_EXT";
        case 0x8D94: return "GL_RED_INTEGER";
        case 0x8D95: return "GL_GREEN_INTEGER";
        case 0x8D96: return "GL_BLUE_INTEGER";
        case 0x8D97: return "GL_ALPHA_INTEGER";
        case 0x8D98: return "GL_RGB_INTEGER";
        case 0x8D99: return "GL_RGBA_INTEGER";
        case 0x8DA7: return "GL_FRAMEBUFFER_ATTACHMENT_LAYERED";
        case 0x8DA8: return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS";
        case 0x8DA9: return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT";
        case 0x8DAD: return "GL_FLOAT_32_UNSIGNED_INT_24_8_REV";
        case 0x8DAE: return "GL_SHADER_INCLUDE_ARB";
        case 0x8DB9: return "GL_FRAMEBUFFER_SRGB";
        case 0x8DBA: return "GL_FRAMEBUFFER_SRGB_CAPABLE_EXT";
        case 0x8DBB: return "GL_COMPRESSED_RED_RGTC1";
        case 0x8DBC: return "GL_COMPRESSED_SIGNED_RED_RGTC1";
        case 0x8DBD: return "GL_COMPRESSED_RG_RGTC2";
        case 0x8DBE: return "GL_COMPRESSED_SIGNED_RG_RGTC2";
        case 0x8DC0: return "GL_SAMPLER_1D_ARRAY";
        case 0x8DC1: return "GL_SAMPLER_2D_ARRAY";
        case 0x8DC2: return "GL_SAMPLER_BUFFER";
        case 0x8DC3: return "GL_SAMPLER_1D_ARRAY_SHADOW";
        case 0x8DC4: return "GL_SAMPLER_2D_ARRAY_SHADOW";
        case 0x8DC5: return "GL_SAMPLER_CUBE_SHADOW";
        case 0x8DC6: return "GL_UNSIGNED_INT_VEC2";
        case 0x8DC7: return "GL_UNSIGNED_INT_VEC3";
        case 0x8DC8: return "GL_UNSIGNED_INT_VEC4";
        case 0x8DC9: return "GL_INT_SAMPLER_1D";
        case 0x8DCA: return "GL_INT_SAMPLER_2D";
        case 0x8DCB: return "GL_INT_SAMPLER_3D";
        case 0x8DCC: return "GL_INT_SAMPLER_CUBE";
        case 0x8DCD: return "GL_INT_SAMPLER_2D_RECT";
        case 0x8DCE: return "GL_INT_SAMPLER_1D_ARRAY";
        case 0x8DCF: return "GL_INT_SAMPLER_2D_ARRAY";
        case 0x8DD0: return "GL_INT_SAMPLER_BUFFER";
        case 0x8DD1: return "GL_UNSIGNED_INT_SAMPLER_1D";
        case 0x8DD2: return "GL_UNSIGNED_INT_SAMPLER_2D";
        case 0x8DD3: return "GL_UNSIGNED_INT_SAMPLER_3D";
        case 0x8DD4: return "GL_UNSIGNED_INT_SAMPLER_CUBE";
        case 0x8DD5: return "GL_UNSIGNED_INT_SAMPLER_2D_RECT";
        case 0x8DD6: return "GL_UNSIGNED_INT_SAMPLER_1D_ARRAY";
        case 0x8DD7: return "GL_UNSIGNED_INT_SAMPLER_2D_ARRAY";
        case 0x8DD8: return "GL_UNSIGNED_INT_SAMPLER_BUFFER";
        case 0x8DD9: return "GL_GEOMETRY_SHADER";
        case 0x8DDA: return "GL_GEOMETRY_VERTICES_OUT_EXT";
        case 0x8DDB: return "GL_GEOMETRY_INPUT_TYPE_EXT";
        case 0x8DDC: return "GL_GEOMETRY_OUTPUT_TYPE_EXT";
        case 0x8DDD: return "GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT";
        case 0x8DDE: return "GL_MAX_VERTEX_VARYING_COMPONENTS_EXT";
        case 0x8DDF: return "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS";
        case 0x8DE0: return "GL_MAX_GEOMETRY_OUTPUT_VERTICES";
        case 0x8DE1: return "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS";
        case 0x8DE2: return "GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT";
        case 0x8DE3: return "GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT";
        case 0x8DE4: return "GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT";
        case 0x8DE5: return "GL_ACTIVE_SUBROUTINES";
        case 0x8DE6: return "GL_ACTIVE_SUBROUTINE_UNIFORMS";
        case 0x8DE7: return "GL_MAX_SUBROUTINES";
        case 0x8DE8: return "GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS";
        case 0x8DE9: return "GL_NAMED_STRING_LENGTH_ARB";
        case 0x8DEA: return "GL_NAMED_STRING_TYPE_ARB";
        case 0x8DED: return "GL_MAX_BINDABLE_UNIFORM_SIZE_EXT";
        case 0x8DEE: return "GL_UNIFORM_BUFFER_EXT";
        case 0x8DEF: return "GL_UNIFORM_BUFFER_BINDING_EXT";
        case 0x8DF0: return "GL_LOW_FLOAT";
        case 0x8DF1: return "GL_MEDIUM_FLOAT";
        case 0x8DF2: return "GL_HIGH_FLOAT";
        case 0x8DF3: return "GL_LOW_INT";
        case 0x8DF4: return "GL_MEDIUM_INT";
        case 0x8DF5: return "GL_HIGH_INT";
        case 0x8DF9: return "GL_NUM_SHADER_BINARY_FORMATS";
        case 0x8DFA: return "GL_SHADER_COMPILER";
        case 0x8DFB: return "GL_MAX_VERTEX_UNIFORM_VECTORS";
        case 0x8DFC: return "GL_MAX_VARYING_VECTORS";
        case 0x8DFD: return "GL_MAX_FRAGMENT_UNIFORM_VECTORS";
        case 0x8E1E: return "GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS";
        case 0x8E1F: return "GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS";
        case 0x8E2D: return "GL_PROGRAM_MATRIX_EXT";
        case 0x8E2E: return "GL_TRANSPOSE_PROGRAM_MATRIX_EXT";
        case 0x8E2F: return "GL_PROGRAM_MATRIX_STACK_DEPTH_EXT";
        case 0x8E4A: return "GL_NUM_COMPATIBLE_SUBROUTINES";
        case 0x8E4B: return "GL_COMPATIBLE_SUBROUTINES";
        case 0x8E4C: return "GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION";
        case 0x8E4D: return "GL_FIRST_VERTEX_CONVENTION";
        case 0x8E4E: return "GL_LAST_VERTEX_CONVENTION";
        case 0x8E4F: return "GL_PROVOKING_VERTEX";
        case 0x8E5A: return "GL_MAX_GEOMETRY_SHADER_INVOCATIONS";
        case 0x8E5B: return "GL_MIN_FRAGMENT_INTERPOLATION_OFFSET";
        case 0x8E5C: return "GL_MAX_FRAGMENT_INTERPOLATION_OFFSET";
        case 0x8E5D: return "GL_FRAGMENT_INTERPOLATION_OFFSET_BITS";
        case 0x8E5E: return "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET";
        case 0x8E5F: return "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET";
        case 0x8E7A: return "GL_ISOLINES";
        case 0x8E7B: return "GL_FRACTIONAL_ODD";
        case 0x8E7C: return "GL_FRACTIONAL_EVEN";
        case 0x8E7D: return "GL_MAX_PATCH_VERTICES";
        case 0x8E7E: return "GL_MAX_TESS_GEN_LEVEL";
        case 0x8E7F: return "GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS";
        case 0x8E8A: return "GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS";
        case 0x8E8C: return "GL_COMPRESSED_RGBA_BPTC_UNORM_ARB";
        case 0x8E8D: return "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB";
        case 0x8E8E: return "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB";
        case 0x8E8F: return "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB";
        case 0x8E13: return "GL_QUERY_WAIT";
        case 0x8E14: return "GL_QUERY_NO_WAIT";
        case 0x8E15: return "GL_QUERY_BY_REGION_WAIT";
        case 0x8E16: return "GL_QUERY_BY_REGION_NO_WAIT";
        case 0x8E22: return "GL_TRANSFORM_FEEDBACK";
        case 0x8E23: return "GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED";
        case 0x8E24: return "GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE";
        case 0x8E25: return "GL_TRANSFORM_FEEDBACK_BINDING";
        case 0x8E28: return "GL_TIMESTAMP";
        case 0x8E42: return "GL_TEXTURE_SWIZZLE_R";
        case 0x8E43: return "GL_TEXTURE_SWIZZLE_G";
        case 0x8E44: return "GL_TEXTURE_SWIZZLE_B";
        case 0x8E45: return "GL_TEXTURE_SWIZZLE_A";
        case 0x8E46: return "GL_TEXTURE_SWIZZLE_RGBA";
        case 0x8E47: return "GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS";
        case 0x8E48: return "GL_ACTIVE_SUBROUTINE_MAX_LENGTH";
        case 0x8E49: return "GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH";
        case 0x8E50: return "GL_SAMPLE_POSITION";
        case 0x8E51: return "GL_SAMPLE_MASK";
        case 0x8E52: return "GL_SAMPLE_MASK_VALUE";
        case 0x8E59: return "GL_MAX_SAMPLE_MASK_WORDS";
        case 0x8E70: return "GL_MAX_TRANSFORM_FEEDBACK_BUFFERS";
        case 0x8E71: return "GL_MAX_VERTEX_STREAMS";
        case 0x8E72: return "GL_PATCH_VERTICES";
        case 0x8E73: return "GL_PATCH_DEFAULT_INNER_LEVEL";
        case 0x8E74: return "GL_PATCH_DEFAULT_OUTER_LEVEL";
        case 0x8E75: return "GL_TESS_CONTROL_OUTPUT_VERTICES";
        case 0x8E76: return "GL_TESS_GEN_MODE";
        case 0x8E77: return "GL_TESS_GEN_SPACING";
        case 0x8E78: return "GL_TESS_GEN_VERTEX_ORDER";
        case 0x8E79: return "GL_TESS_GEN_POINT_MODE";
        case 0x8E80: return "GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS";
        case 0x8E81: return "GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS";
        case 0x8E82: return "GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS";
        case 0x8E83: return "GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS";
        case 0x8E84: return "GL_MAX_TESS_PATCH_COMPONENTS";
        case 0x8E85: return "GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS";
        case 0x8E86: return "GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS";
        case 0x8E87: return "GL_TESS_EVALUATION_SHADER";
        case 0x8E88: return "GL_TESS_CONTROL_SHADER";
        case 0x8E89: return "GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS";
        case 0x8F3A: return "GL_IMAGE_BINDING_NAME_EXT";
        case 0x8F3B: return "GL_IMAGE_BINDING_LEVEL_EXT";
        case 0x8F3C: return "GL_IMAGE_BINDING_LAYERED_EXT";
        case 0x8F3D: return "GL_IMAGE_BINDING_LAYER_EXT";
        case 0x8F3E: return "GL_IMAGE_BINDING_ACCESS_EXT";
        case 0x8F3F: return "GL_DRAW_INDIRECT_BUFFER";
        case 0x8F4A: return "GL_DOUBLE_MAT2x4";
        case 0x8F4B: return "GL_DOUBLE_MAT3x2";
        case 0x8F4C: return "GL_DOUBLE_MAT3x4";
        case 0x8F4D: return "GL_DOUBLE_MAT4x2";
        case 0x8F4E: return "GL_DOUBLE_MAT4x3";
        case 0x8F9A: return "GL_RGB16_SNORM";
        case 0x8F9B: return "GL_RGBA16_SNORM";
        case 0x8F9C: return "GL_SIGNED_NORMALIZED";
        case 0x8F9D: return "GL_PRIMITIVE_RESTART";
        case 0x8F9E: return "GL_PRIMITIVE_RESTART_INDEX";
        case 0x8F36: return "GL_COPY_READ_BUFFER";
        case 0x8F37: return "GL_COPY_WRITE_BUFFER";
        case 0x8F38: return "GL_MAX_IMAGE_UNITS_EXT";
        case 0x8F39: return "GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT";
        case 0x8F43: return "GL_DRAW_INDIRECT_BUFFER_BINDING";
        case 0x8F46: return "GL_DOUBLE_MAT2";
        case 0x8F47: return "GL_DOUBLE_MAT3";
        case 0x8F48: return "GL_DOUBLE_MAT4";
        case 0x8F49: return "GL_DOUBLE_MAT2x3";
        case 0x8F90: return "GL_RED_SNORM";
        case 0x8F91: return "GL_RG_SNORM";
        case 0x8F92: return "GL_RGB_SNORM";
        case 0x8F93: return "GL_RGBA_SNORM";
        case 0x8F94: return "GL_R8_SNORM";
        case 0x8F95: return "GL_RG8_SNORM";
        case 0x8F96: return "GL_RGB8_SNORM";
        case 0x8F97: return "GL_RGBA8_SNORM";
        case 0x8F98: return "GL_R16_SNORM";
        case 0x8F99: return "GL_RG16_SNORM";
        case 0x8FFC: return "GL_DOUBLE_VEC2";
        case 0x8FFD: return "GL_DOUBLE_VEC3";
        case 0x8FFE: return "GL_DOUBLE_VEC4";
        case 0x040A: return "GL_AUX1";
        case 0x040B: return "GL_AUX2";
        case 0x040C: return "GL_AUX3";
        case 0x80A0: return "GL_SAMPLE_COVERAGE";
        case 0x80A1: return "GL_1PASS_EXT";
        case 0x80A2: return "GL_2PASS_0_EXT";
        case 0x80A3: return "GL_2PASS_1_EXT";
        case 0x80A4: return "GL_4PASS_0_EXT";
        case 0x80A5: return "GL_4PASS_1_EXT";
        case 0x80A6: return "GL_4PASS_2_EXT";
        case 0x80A7: return "GL_4PASS_3_EXT";
        case 0x80A8: return "GL_SAMPLE_BUFFERS";
        case 0x80A9: return "GL_SAMPLES";
        case 0x80AA: return "GL_SAMPLE_COVERAGE_VALUE";
        case 0x80AB: return "GL_SAMPLE_COVERAGE_INVERT";
        case 0x80AC: return "GL_SAMPLE_PATTERN_EXT";
        case 0x80AD: return "GL_LINEAR_SHARPEN_SGIS";
        case 0x80AE: return "GL_LINEAR_SHARPEN_ALPHA_SGIS";
        case 0x80AF: return "GL_LINEAR_SHARPEN_COLOR_SGIS";
        case 0x80B0: return "GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS";
        case 0x80B1: return "GL_COLOR_MATRIX";
        case 0x80B2: return "GL_COLOR_MATRIX_STACK_DEPTH";
        case 0x80B3: return "GL_MAX_COLOR_MATRIX_STACK_DEPTH";
        case 0x80B4: return "GL_POST_COLOR_MATRIX_RED_SCALE";
        case 0x80B5: return "GL_POST_COLOR_MATRIX_GREEN_SCALE";
        case 0x80B6: return "GL_POST_COLOR_MATRIX_BLUE_SCALE";
        case 0x80B7: return "GL_POST_COLOR_MATRIX_ALPHA_SCALE";
        case 0x80B8: return "GL_POST_COLOR_MATRIX_RED_BIAS";
        case 0x80B9: return "GL_POST_COLOR_MATRIX_GREEN_BIAS";
        case 0x80BA: return "GL_POST_COLOR_MATRIX_BLUE_BIAS";
        case 0x80BB: return "GL_POST_COLOR_MATRIX_ALPHA_BIAS";
        case 0x80BC: return "GL_TEXTURE_COLOR_TABLE_SGI";
        case 0x80BD: return "GL_PROXY_TEXTURE_COLOR_TABLE_SGI";
        case 0x80BF: return "GL_TEXTURE_COMPARE_FAIL_VALUE_ARB";
        case 0x80C8: return "GL_BLEND_DST_RGB";
        case 0x80C9: return "GL_BLEND_SRC_RGB";
        case 0x80CA: return "GL_BLEND_DST_ALPHA";
        case 0x80CB: return "GL_BLEND_SRC_ALPHA";
        case 0x80CC: return "GL_422_EXT";
        case 0x80CD: return "GL_422_REV_EXT";
        case 0x80CE: return "GL_422_AVERAGE_EXT";
        case 0x80CF: return "GL_422_REV_AVERAGE_EXT";
        case 0x80D0: return "GL_COLOR_TABLE";
        case 0x80D1: return "GL_POST_CONVOLUTION_COLOR_TABLE";
        case 0x80D2: return "GL_POST_COLOR_MATRIX_COLOR_TABLE";
        case 0x80D3: return "GL_PROXY_COLOR_TABLE";
        case 0x80D4: return "GL_PROXY_POST_CONVOLUTION_COLOR_TABLE";
        case 0x80D5: return "GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE";
        case 0x80D6: return "GL_COLOR_TABLE_SCALE";
        case 0x80D7: return "GL_COLOR_TABLE_BIAS";
        case 0x80D8: return "GL_COLOR_TABLE_FORMAT";
        case 0x80D9: return "GL_COLOR_TABLE_WIDTH";
        case 0x80DA: return "GL_COLOR_TABLE_RED_SIZE";
        case 0x80DB: return "GL_COLOR_TABLE_GREEN_SIZE";
        case 0x80DC: return "GL_COLOR_TABLE_BLUE_SIZE";
        case 0x80DD: return "GL_COLOR_TABLE_ALPHA_SIZE";
        case 0x80DE: return "GL_COLOR_TABLE_LUMINANCE_SIZE";
        case 0x80DF: return "GL_COLOR_TABLE_INTENSITY_SIZE";
        case 0x80E0: return "GL_BGR";
        case 0x80E1: return "GL_BGRA";
        case 0x80E2: return "GL_COLOR_INDEX1_EXT";
        case 0x80E3: return "GL_COLOR_INDEX2_EXT";
        case 0x80E4: return "GL_COLOR_INDEX4_EXT";
        case 0x80E5: return "GL_COLOR_INDEX8_EXT";
        case 0x80E6: return "GL_COLOR_INDEX12_EXT";
        case 0x80E7: return "GL_COLOR_INDEX16_EXT";
        case 0x80E8: return "GL_MAX_ELEMENTS_VERTICES";
        case 0x80E9: return "GL_MAX_ELEMENTS_INDICES";
        case 0x80EA: return "GL_PHONG_WIN";
        case 0x80EB: return "GL_PHONG_HINT_WIN";
        case 0x80EC: return "GL_FOG_SPECULAR_TEXTURE_WIN";
        case 0x80ED: return "GL_TEXTURE_INDEX_SIZE_EXT";
        case 0x80F0: return "GL_CLIP_VOLUME_CLIPPING_HINT_EXT";
        case 0x81A5: return "GL_DEPTH_COMPONENT16";
        case 0x81A6: return "GL_DEPTH_COMPONENT24";
        case 0x81A7: return "GL_DEPTH_COMPONENT32";
        case 0x81A8: return "GL_ARRAY_ELEMENT_LOCK_FIRST_EXT";
        case 0x81A9: return "GL_ARRAY_ELEMENT_LOCK_COUNT_EXT";
        case 0x81AA: return "GL_CULL_VERTEX_EXT";
        case 0x81AB: return "GL_CULL_VERTEX_EYE_POSITION_EXT";
        case 0x81AC: return "GL_CULL_VERTEX_OBJECT_POSITION_EXT";
        case 0x81AD: return "GL_IUI_V2F_EXT";
        case 0x81AE: return "GL_IUI_V3F_EXT";
        case 0x81AF: return "GL_IUI_N3F_V2F_EXT";
        case 0x81B0: return "GL_IUI_N3F_V3F_EXT";
        case 0x81B1: return "GL_T2F_IUI_V2F_EXT";
        case 0x81B2: return "GL_T2F_IUI_V3F_EXT";
        case 0x81B3: return "GL_T2F_IUI_N3F_V2F_EXT";
        case 0x81B4: return "GL_T2F_IUI_N3F_V3F_EXT";
        case 0x81B5: return "GL_INDEX_TEST_EXT";
        case 0x81B6: return "GL_INDEX_TEST_FUNC_EXT";
        case 0x81B7: return "GL_INDEX_TEST_REF_EXT";
        case 0x81B8: return "GL_INDEX_MATERIAL_EXT";
        case 0x81B9: return "GL_INDEX_MATERIAL_PARAMETER_EXT";
        case 0x81BA: return "GL_INDEX_MATERIAL_FACE_EXT";
        case 0x81D4: return "GL_WRAP_BORDER_SUN";
        case 0x81D5: return "GL_UNPACK_CONSTANT_DATA_SUNX";
        case 0x81D6: return "GL_TEXTURE_CONSTANT_DATA_SUNX";
        case 0x81D7: return "GL_TRIANGLE_LIST_SUN";
        case 0x81D8: return "GL_REPLACEMENT_CODE_SUN";
        case 0x81D9: return "GL_GLOBAL_ALPHA_SUN";
        case 0x81DA: return "GL_GLOBAL_ALPHA_FACTOR_SUN";
        case 0x81EF: return "GL_TEXTURE_COLOR_WRITEMASK_SGIS";
        case 0x81F0: return "GL_EYE_DISTANCE_TO_POINT_SGIS";
        case 0x81F1: return "GL_OBJECT_DISTANCE_TO_POINT_SGIS";
        case 0x81F2: return "GL_EYE_DISTANCE_TO_LINE_SGIS";
        case 0x81F3: return "GL_OBJECT_DISTANCE_TO_LINE_SGIS";
        case 0x81F4: return "GL_EYE_POINT_SGIS";
        case 0x81F5: return "GL_OBJECT_POINT_SGIS";
        case 0x81F6: return "GL_EYE_LINE_SGIS";
        case 0x81F7: return "GL_OBJECT_LINE_SGIS";
        case 0x81F8: return "GL_LIGHT_MODEL_COLOR_CONTROL";
        case 0x81F9: return "GL_SINGLE_COLOR";
        case 0x81FA: return "GL_SEPARATE_SPECULAR_COLOR";
        case 0x81FB: return "GL_SHARED_TEXTURE_PALETTE_EXT";
        case 0x83A0: return "GL_RGB_S3TC";
        case 0x83A1: return "GL_RGB4_S3TC";
        case 0x83A2: return "GL_RGBA_S3TC";
        case 0x83A3: return "GL_RGBA4_S3TC";
        case 0x83F0: return "GL_COMPRESSED_RGB_S3TC_DXT1_EXT";
        case 0x83F1: return "GL_COMPRESSED_RGBA_S3TC_DXT1_EXT";
        case 0x83F2: return "GL_COMPRESSED_RGBA_S3TC_DXT3_EXT";
        case 0x83F3: return "GL_COMPRESSED_RGBA_S3TC_DXT5_EXT";
        case 0x83F4: return "GL_PARALLEL_ARRAYS_INTEL";
        case 0x83F5: return "GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL";
        case 0x83F6: return "GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL";
        case 0x83F7: return "GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL";
        case 0x83F8: return "GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL";
        case 0x84C0: return "GL_TEXTURE0";
        case 0x84C1: return "GL_TEXTURE1";
        case 0x84C2: return "GL_TEXTURE2";
        case 0x84C3: return "GL_TEXTURE3";
        case 0x84C4: return "GL_TEXTURE4";
        case 0x84C5: return "GL_TEXTURE5";
        case 0x84C6: return "GL_TEXTURE6";
        case 0x84C7: return "GL_TEXTURE7";
        case 0x84C8: return "GL_TEXTURE8";
        case 0x84C9: return "GL_TEXTURE9";
        case 0x84CA: return "GL_TEXTURE10";
        case 0x84CB: return "GL_TEXTURE11";
        case 0x84CC: return "GL_TEXTURE12";
        case 0x84CD: return "GL_TEXTURE13";
        case 0x84CE: return "GL_TEXTURE14";
        case 0x84CF: return "GL_TEXTURE15";
        case 0x84D0: return "GL_TEXTURE16";
        case 0x84D1: return "GL_TEXTURE17";
        case 0x84D2: return "GL_TEXTURE18";
        case 0x84D3: return "GL_TEXTURE19";
        case 0x84D4: return "GL_TEXTURE20";
        case 0x84D5: return "GL_TEXTURE21";
        case 0x84D6: return "GL_TEXTURE22";
        case 0x84D7: return "GL_TEXTURE23";
        case 0x84D8: return "GL_TEXTURE24";
        case 0x84D9: return "GL_TEXTURE25";
        case 0x84DA: return "GL_TEXTURE26";
        case 0x84DB: return "GL_TEXTURE27";
        case 0x84DC: return "GL_TEXTURE28";
        case 0x84DD: return "GL_TEXTURE29";
        case 0x84DE: return "GL_TEXTURE30";
        case 0x84DF: return "GL_TEXTURE31";
        case 0x84E0: return "GL_ACTIVE_TEXTURE";
        case 0x84E1: return "GL_CLIENT_ACTIVE_TEXTURE";
        case 0x84E2: return "GL_MAX_TEXTURE_UNITS";
        case 0x84E3: return "GL_TRANSPOSE_MODELVIEW_MATRIX";
        case 0x84E4: return "GL_TRANSPOSE_PROJECTION_MATRIX";
        case 0x84E5: return "GL_TRANSPOSE_TEXTURE_MATRIX";
        case 0x84E6: return "GL_TRANSPOSE_COLOR_MATRIX";
        case 0x84E7: return "GL_SUBTRACT";
        case 0x84E8: return "GL_MAX_RENDERBUFFER_SIZE";
        case 0x84E9: return "GL_COMPRESSED_ALPHA";
        case 0x84EA: return "GL_COMPRESSED_LUMINANCE";
        case 0x84EB: return "GL_COMPRESSED_LUMINANCE_ALPHA";
        case 0x84EC: return "GL_COMPRESSED_INTENSITY";
        case 0x84ED: return "GL_COMPRESSED_RGB";
        case 0x84EE: return "GL_COMPRESSED_RGBA";
        case 0x84EF: return "GL_TEXTURE_COMPRESSION_HINT";
        case 0x84F0: return "GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER";
        case 0x84F1: return "GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER";
        case 0x84F5: return "GL_TEXTURE_RECTANGLE";
        case 0x84F6: return "GL_TEXTURE_BINDING_RECTANGLE";
        case 0x84F7: return "GL_PROXY_TEXTURE_RECTANGLE";
        case 0x84F8: return "GL_MAX_RECTANGLE_TEXTURE_SIZE";
        case 0x84F9: return "GL_DEPTH_STENCIL";
        case 0x84FA: return "GL_UNSIGNED_INT_24_8";
        case 0x84FD: return "GL_MAX_TEXTURE_LOD_BIAS";
        case 0x84FE: return "GL_TEXTURE_MAX_ANISOTROPY_EXT";
        case 0x84FF: return "GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT";
        case 0x85AE: return "GL_PERTURB_EXT";
        case 0x85AF: return "GL_TEXTURE_NORMAL_EXT";
        case 0x85B0: return "GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE";
        case 0x85B1: return "GL_TRANSFORM_HINT_APPLE";
        case 0x85B2: return "GL_UNPACK_CLIENT_STORAGE_APPLE";
        case 0x85B3: return "GL_BUFFER_OBJECT_APPLE";
        case 0x85B4: return "GL_STORAGE_CLIENT_APPLE";
        case 0x85B5: return "GL_VERTEX_ARRAY_BINDING";
        case 0x85B7: return "GL_TEXTURE_RANGE_LENGTH_APPLE";
        case 0x85B8: return "GL_TEXTURE_RANGE_POINTER_APPLE";
        case 0x85B9: return "GL_YCBCR_422_APPLE";
        case 0x85BA: return "GL_UNSIGNED_SHORT_8_8_MESA";
        case 0x85BB: return "GL_UNSIGNED_SHORT_8_8_REV_MESA";
        case 0x85BC: return "GL_TEXTURE_STORAGE_HINT_APPLE";
        case 0x85BD: return "GL_STORAGE_PRIVATE_APPLE";
        case 0x85BE: return "GL_STORAGE_CACHED_APPLE";
        case 0x85BF: return "GL_STORAGE_SHARED_APPLE";
        case 0x85C0: return "GL_REPLACEMENT_CODE_ARRAY_SUN";
        case 0x85C1: return "GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN";
        case 0x85C2: return "GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN";
        case 0x85C3: return "GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN";
        case 0x85C4: return "GL_R1UI_V3F_SUN";
        case 0x85C5: return "GL_R1UI_C4UB_V3F_SUN";
        case 0x85C6: return "GL_R1UI_C3F_V3F_SUN";
        case 0x85C7: return "GL_R1UI_N3F_V3F_SUN";
        case 0x85C8: return "GL_R1UI_C4F_N3F_V3F_SUN";
        case 0x85C9: return "GL_R1UI_T2F_V3F_SUN";
        case 0x85CA: return "GL_R1UI_T2F_N3F_V3F_SUN";
        case 0x85CB: return "GL_R1UI_T2F_C4F_N3F_V3F_SUN";
        case 0x85CC: return "GL_SLICE_ACCUM_SUN";
        case 0x86A0: return "GL_TEXTURE_COMPRESSED_IMAGE_SIZE";
        case 0x86A1: return "GL_TEXTURE_COMPRESSED";
        case 0x86A2: return "GL_NUM_COMPRESSED_TEXTURE_FORMATS";
        case 0x86A3: return "GL_COMPRESSED_TEXTURE_FORMATS";
        case 0x86A4: return "GL_MAX_VERTEX_UNITS_ARB";
        case 0x86A5: return "GL_ACTIVE_VERTEX_UNITS_ARB";
        case 0x86A6: return "GL_WEIGHT_SUM_UNITY_ARB";
        case 0x86A7: return "GL_VERTEX_BLEND_ARB";
        case 0x86A8: return "GL_CURRENT_WEIGHT_ARB";
        case 0x86A9: return "GL_WEIGHT_ARRAY_TYPE_ARB";
        case 0x86AA: return "GL_WEIGHT_ARRAY_STRIDE_ARB";
        case 0x86AB: return "GL_WEIGHT_ARRAY_SIZE_ARB";
        case 0x86AC: return "GL_WEIGHT_ARRAY_POINTER_ARB";
        case 0x86AD: return "GL_WEIGHT_ARRAY_ARB";
        case 0x86AE: return "GL_DOT3_RGB";
        case 0x86AF: return "GL_DOT3_RGBA";
        case 0x86B0: return "GL_COMPRESSED_RGB_FXT1_3DFX";
        case 0x86B1: return "GL_COMPRESSED_RGBA_FXT1_3DFX";
        case 0x86B2: return "GL_MULTISAMPLE_3DFX";
        case 0x86B3: return "GL_SAMPLE_BUFFERS_3DFX";
        case 0x86B4: return "GL_SAMPLES_3DFX";
        case 0x87A0: return "GL_OUTPUT_TEXTURE_COORD3_EXT";
        case 0x87A1: return "GL_OUTPUT_TEXTURE_COORD4_EXT";
        case 0x87A2: return "GL_OUTPUT_TEXTURE_COORD5_EXT";
        case 0x87A3: return "GL_OUTPUT_TEXTURE_COORD6_EXT";
        case 0x87A4: return "GL_OUTPUT_TEXTURE_COORD7_EXT";
        case 0x87A5: return "GL_OUTPUT_TEXTURE_COORD8_EXT";
        case 0x87A6: return "GL_OUTPUT_TEXTURE_COORD9_EXT";
        case 0x87A7: return "GL_OUTPUT_TEXTURE_COORD10_EXT";
        case 0x87A8: return "GL_OUTPUT_TEXTURE_COORD11_EXT";
        case 0x87A9: return "GL_OUTPUT_TEXTURE_COORD12_EXT";
        case 0x87AA: return "GL_OUTPUT_TEXTURE_COORD13_EXT";
        case 0x87AB: return "GL_OUTPUT_TEXTURE_COORD14_EXT";
        case 0x87AC: return "GL_OUTPUT_TEXTURE_COORD15_EXT";
        case 0x87AD: return "GL_OUTPUT_TEXTURE_COORD16_EXT";
        case 0x87AE: return "GL_OUTPUT_TEXTURE_COORD17_EXT";
        case 0x87AF: return "GL_OUTPUT_TEXTURE_COORD18_EXT";
        case 0x87B0: return "GL_OUTPUT_TEXTURE_COORD19_EXT";
        case 0x87B1: return "GL_OUTPUT_TEXTURE_COORD20_EXT";
        case 0x87B2: return "GL_OUTPUT_TEXTURE_COORD21_EXT";
        case 0x87B3: return "GL_OUTPUT_TEXTURE_COORD22_EXT";
        case 0x87B4: return "GL_OUTPUT_TEXTURE_COORD23_EXT";
        case 0x87B5: return "GL_OUTPUT_TEXTURE_COORD24_EXT";
        case 0x87B6: return "GL_OUTPUT_TEXTURE_COORD25_EXT";
        case 0x87B7: return "GL_OUTPUT_TEXTURE_COORD26_EXT";
        case 0x87B8: return "GL_OUTPUT_TEXTURE_COORD27_EXT";
        case 0x87B9: return "GL_OUTPUT_TEXTURE_COORD28_EXT";
        case 0x87BA: return "GL_OUTPUT_TEXTURE_COORD29_EXT";
        case 0x87BB: return "GL_OUTPUT_TEXTURE_COORD30_EXT";
        case 0x87BC: return "GL_OUTPUT_TEXTURE_COORD31_EXT";
        case 0x87BD: return "GL_OUTPUT_FOG_EXT";
        case 0x87BE: return "GL_SCALAR_EXT";
        case 0x87BF: return "GL_VECTOR_EXT";
        case 0x87C0: return "GL_MATRIX_EXT";
        case 0x87C1: return "GL_VARIANT_EXT";
        case 0x87C2: return "GL_INVARIANT_EXT";
        case 0x87C3: return "GL_LOCAL_CONSTANT_EXT";
        case 0x87C4: return "GL_LOCAL_EXT";
        case 0x87C5: return "GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT";
        case 0x87C6: return "GL_MAX_VERTEX_SHADER_VARIANTS_EXT";
        case 0x87C7: return "GL_MAX_VERTEX_SHADER_INVARIANTS_EXT";
        case 0x87C8: return "GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT";
        case 0x87C9: return "GL_MAX_VERTEX_SHADER_LOCALS_EXT";
        case 0x87CA: return "GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT";
        case 0x87CB: return "GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT";
        case 0x87CC: return "GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT";
        case 0x87CD: return "GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT";
        case 0x87CE: return "GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT";
        case 0x87CF: return "GL_VERTEX_SHADER_INSTRUCTIONS_EXT";
        case 0x87D0: return "GL_VERTEX_SHADER_VARIANTS_EXT";
        case 0x87D1: return "GL_VERTEX_SHADER_INVARIANTS_EXT";
        case 0x87D2: return "GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT";
        case 0x87D3: return "GL_VERTEX_SHADER_LOCALS_EXT";
        case 0x87D4: return "GL_VERTEX_SHADER_OPTIMIZED_EXT";
        case 0x87D5: return "GL_X_EXT";
        case 0x87D6: return "GL_Y_EXT";
        case 0x87D7: return "GL_Z_EXT";
        case 0x87D8: return "GL_W_EXT";
        case 0x87D9: return "GL_NEGATIVE_X_EXT";
        case 0x87DA: return "GL_NEGATIVE_Y_EXT";
        case 0x87DB: return "GL_NEGATIVE_Z_EXT";
        case 0x87DC: return "GL_NEGATIVE_W_EXT";
        case 0x87DD: return "GL_ZERO_EXT";
        case 0x87DE: return "GL_ONE_EXT";
        case 0x87DF: return "GL_NEGATIVE_ONE_EXT";
        case 0x87E0: return "GL_NORMALIZED_RANGE_EXT";
        case 0x87E1: return "GL_FULL_RANGE_EXT";
        case 0x87E2: return "GL_CURRENT_VERTEX_EXT";
        case 0x87E3: return "GL_MVP_MATRIX_EXT";
        case 0x87E4: return "GL_VARIANT_VALUE_EXT";
        case 0x87E5: return "GL_VARIANT_DATATYPE_EXT";
        case 0x87E6: return "GL_VARIANT_ARRAY_STRIDE_EXT";
        case 0x87E7: return "GL_VARIANT_ARRAY_TYPE_EXT";
        case 0x87E8: return "GL_VARIANT_ARRAY_EXT";
        case 0x87E9: return "GL_VARIANT_ARRAY_POINTER_EXT";
        case 0x87EA: return "GL_INVARIANT_VALUE_EXT";
        case 0x87EB: return "GL_INVARIANT_DATATYPE_EXT";
        case 0x87EC: return "GL_LOCAL_CONSTANT_VALUE_EXT";
        case 0x87ED: return "GL_LOCAL_CONSTANT_DATATYPE_EXT";
        case 0x87FE: return "GL_NUM_PROGRAM_BINARY_FORMATS";
        case 0x87FF: return "GL_PROGRAM_BINARY_FORMATS";
        case 0x88A0: return "GL_PROGRAM_INSTRUCTIONS_ARB";
        case 0x88A1: return "GL_MAX_PROGRAM_INSTRUCTIONS_ARB";
        case 0x88A2: return "GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB";
        case 0x88A3: return "GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB";
        case 0x88A4: return "GL_PROGRAM_TEMPORARIES_ARB";
        case 0x88A5: return "GL_MAX_PROGRAM_TEMPORARIES_ARB";
        case 0x88A6: return "GL_PROGRAM_NATIVE_TEMPORARIES_ARB";
        case 0x88A7: return "GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB";
        case 0x88A8: return "GL_PROGRAM_PARAMETERS_ARB";
        case 0x88A9: return "GL_MAX_PROGRAM_PARAMETERS_ARB";
        case 0x88AA: return "GL_PROGRAM_NATIVE_PARAMETERS_ARB";
        case 0x88AB: return "GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB";
        case 0x88AC: return "GL_PROGRAM_ATTRIBS_ARB";
        case 0x88AD: return "GL_MAX_PROGRAM_ATTRIBS_ARB";
        case 0x88AE: return "GL_PROGRAM_NATIVE_ATTRIBS_ARB";
        case 0x88AF: return "GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB";
        case 0x88B0: return "GL_PROGRAM_ADDRESS_REGISTERS_ARB";
        case 0x88B1: return "GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB";
        case 0x88B2: return "GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB";
        case 0x88B3: return "GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB";
        case 0x88B4: return "GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB";
        case 0x88B5: return "GL_MAX_PROGRAM_ENV_PARAMETERS_ARB";
        case 0x88B6: return "GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB";
        case 0x88B7: return "GL_TRANSPOSE_CURRENT_MATRIX_ARB";
        case 0x88B8: return "GL_READ_ONLY";
        case 0x88B9: return "GL_WRITE_ONLY";
        case 0x88BA: return "GL_READ_WRITE";
        case 0x88BB: return "GL_BUFFER_ACCESS";
        case 0x88BC: return "GL_BUFFER_MAPPED";
        case 0x88BD: return "GL_BUFFER_MAP_POINTER";
        case 0x88BF: return "GL_TIME_ELAPSED";
        case 0x88C0: return "GL_MATRIX0_ARB";
        case 0x88C1: return "GL_MATRIX1_ARB";
        case 0x88C2: return "GL_MATRIX2_ARB";
        case 0x88C3: return "GL_MATRIX3_ARB";
        case 0x88C4: return "GL_MATRIX4_ARB";
        case 0x88C5: return "GL_MATRIX5_ARB";
        case 0x88C6: return "GL_MATRIX6_ARB";
        case 0x88C7: return "GL_MATRIX7_ARB";
        case 0x88C8: return "GL_MATRIX8_ARB";
        case 0x88C9: return "GL_MATRIX9_ARB";
        case 0x88CA: return "GL_MATRIX10_ARB";
        case 0x88CB: return "GL_MATRIX11_ARB";
        case 0x88CC: return "GL_MATRIX12_ARB";
        case 0x88CD: return "GL_MATRIX13_ARB";
        case 0x88CE: return "GL_MATRIX14_ARB";
        case 0x88CF: return "GL_MATRIX15_ARB";
        case 0x88D0: return "GL_MATRIX16_ARB";
        case 0x88D1: return "GL_MATRIX17_ARB";
        case 0x88D2: return "GL_MATRIX18_ARB";
        case 0x88D3: return "GL_MATRIX19_ARB";
        case 0x88D4: return "GL_MATRIX20_ARB";
        case 0x88D5: return "GL_MATRIX21_ARB";
        case 0x88D6: return "GL_MATRIX22_ARB";
        case 0x88D7: return "GL_MATRIX23_ARB";
        case 0x88D8: return "GL_MATRIX24_ARB";
        case 0x88D9: return "GL_MATRIX25_ARB";
        case 0x88DA: return "GL_MATRIX26_ARB";
        case 0x88DB: return "GL_MATRIX27_ARB";
        case 0x88DC: return "GL_MATRIX28_ARB";
        case 0x88DD: return "GL_MATRIX29_ARB";
        case 0x88DE: return "GL_MATRIX30_ARB";
        case 0x88DF: return "GL_MATRIX31_ARB";
        case 0x88E0: return "GL_STREAM_DRAW";
        case 0x88E1: return "GL_STREAM_READ";
        case 0x88E2: return "GL_STREAM_COPY";
        case 0x88E4: return "GL_STATIC_DRAW";
        case 0x88E5: return "GL_STATIC_READ";
        case 0x88E6: return "GL_STATIC_COPY";
        case 0x88E8: return "GL_DYNAMIC_DRAW";
        case 0x88E9: return "GL_DYNAMIC_READ";
        case 0x88EA: return "GL_DYNAMIC_COPY";
        case 0x88EB: return "GL_PIXEL_PACK_BUFFER";
        case 0x88EC: return "GL_PIXEL_UNPACK_BUFFER";
        case 0x88ED: return "GL_PIXEL_PACK_BUFFER_BINDING";
        case 0x88EF: return "GL_PIXEL_UNPACK_BUFFER_BINDING";
        case 0x88F0: return "GL_DEPTH24_STENCIL8";
        case 0x88F1: return "GL_TEXTURE_STENCIL_SIZE";
        case 0x88F2: return "GL_STENCIL_TAG_BITS_EXT";
        case 0x88F3: return "GL_STENCIL_CLEAR_TAG_VALUE_EXT";
        case 0x88F9: return "GL_SRC1_COLOR";
        case 0x88FA: return "GL_ONE_MINUS_SRC1_COLOR";
        case 0x88FB: return "GL_ONE_MINUS_SRC1_ALPHA";
        case 0x88FC: return "GL_MAX_DUAL_SOURCE_DRAW_BUFFERS";
        case 0x88FD: return "GL_VERTEX_ATTRIB_ARRAY_INTEGER";
        case 0x88FE: return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR";
        case 0x88FF: return "GL_MAX_ARRAY_TEXTURE_LAYERS";
        case 0x0100: return "GL_ACCUM";
        case 0x0101: return "GL_LOAD";
        case 0x0102: return "GL_RETURN";
        case 0x0103: return "GL_MULT";
        case 0x0104: return "GL_ADD";
        case 0x140A: return "GL_DOUBLE";
        case 0x140B: return "GL_HALF_FLOAT";
        case 0x140C: return "GL_FIXED";
        case 0x150A: return "GL_INVERT";
        case 0x150B: return "GL_OR_REVERSE";
        case 0x150C: return "GL_COPY_INVERTED";
        case 0x150D: return "GL_OR_INVERTED";
        case 0x150E: return "GL_NAND";
        case 0x150F: return "GL_SET";
        case 0x190A: return "GL_LUMINANCE_ALPHA";
        case 0x0200: return "GL_NEVER";
        case 0x0201: return "GL_LESS";
        case 0x0202: return "GL_EQUAL";
        case 0x0203: return "GL_LEQUAL";
        case 0x0204: return "GL_GREATER";
        case 0x0205: return "GL_NOTEQUAL";
        case 0x0206: return "GL_GEQUAL";
        case 0x0207: return "GL_ALWAYS";
        case 0x0300: return "GL_SRC_COLOR";
        case 0x0301: return "GL_ONE_MINUS_SRC_COLOR";
        case 0x0302: return "GL_SRC_ALPHA";
        case 0x0303: return "GL_ONE_MINUS_SRC_ALPHA";
        case 0x0304: return "GL_DST_ALPHA";
        case 0x0305: return "GL_ONE_MINUS_DST_ALPHA";
        case 0x0306: return "GL_DST_COLOR";
        case 0x0307: return "GL_ONE_MINUS_DST_COLOR";
        case 0x0308: return "GL_SRC_ALPHA_SATURATE";
        case 0x0400: return "GL_FRONT_LEFT";
        case 0x0401: return "GL_FRONT_RIGHT";
        case 0x0402: return "GL_BACK_LEFT";
        case 0x0403: return "GL_BACK_RIGHT";
        case 0x0404: return "GL_FRONT";
        case 0x0405: return "GL_BACK";
        case 0x0406: return "GL_LEFT";
        case 0x0407: return "GL_RIGHT";
        case 0x0408: return "GL_FRONT_AND_BACK";
        case 0x0409: return "GL_AUX0";
        case 0x0500: return "GL_INVALID_ENUM";
        case 0x0501: return "GL_INVALID_VALUE";
        case 0x0502: return "GL_INVALID_OPERATION";
        case 0x0503: return "GL_STACK_OVERFLOW";
        case 0x0504: return "GL_STACK_UNDERFLOW";
        case 0x0505: return "GL_OUT_OF_MEMORY";
        case 0x0506: return "GL_INVALID_FRAMEBUFFER_OPERATION";
        case 0x0600: return "GL_2D";
        case 0x0601: return "GL_3D";
        case 0x0602: return "GL_3D_COLOR";
        case 0x0603: return "GL_3D_COLOR_TEXTURE";
        case 0x0604: return "GL_4D_COLOR_TEXTURE";
        case 0x0700: return "GL_PASS_THROUGH_TOKEN";
        case 0x0701: return "GL_POINT_TOKEN";
        case 0x0702: return "GL_LINE_TOKEN";
        case 0x0703: return "GL_POLYGON_TOKEN";
        case 0x0704: return "GL_BITMAP_TOKEN";
        case 0x0705: return "GL_DRAW_PIXEL_TOKEN";
        case 0x0706: return "GL_COPY_PIXEL_TOKEN";
        case 0x0707: return "GL_LINE_RESET_TOKEN";
        case 0x0800: return "GL_EXP";
        case 0x800A: return "GL_FUNC_SUBTRACT";
        case 0x800B: return "GL_FUNC_REVERSE_SUBTRACT";
        case 0x800C: return "GL_CMYK_EXT";
        case 0x800D: return "GL_CMYKA_EXT";
        case 0x800E: return "GL_PACK_CMYK_HINT_EXT";
        case 0x800F: return "GL_UNPACK_CMYK_HINT_EXT";
        case 0x0801: return "GL_EXP2";
        case 0x801A: return "GL_MAX_CONVOLUTION_WIDTH";
        case 0x801B: return "GL_MAX_CONVOLUTION_HEIGHT";
        case 0x801C: return "GL_POST_CONVOLUTION_RED_SCALE";
        case 0x801D: return "GL_POST_CONVOLUTION_GREEN_SCALE";
        case 0x801E: return "GL_POST_CONVOLUTION_BLUE_SCALE";
        case 0x801F: return "GL_POST_CONVOLUTION_ALPHA_SCALE";
        case 0x802A: return "GL_HISTOGRAM_BLUE_SIZE";
        case 0x802B: return "GL_HISTOGRAM_ALPHA_SIZE";
        case 0x802C: return "GL_HISTOGRAM_LUMINANCE_SIZE";
        case 0x802D: return "GL_HISTOGRAM_SINK";
        case 0x802E: return "GL_MINMAX";
        case 0x802F: return "GL_MINMAX_FORMAT";
        case 0x803A: return "GL_RESCALE_NORMAL";
        case 0x803B: return "GL_ALPHA4";
        case 0x803C: return "GL_ALPHA8";
        case 0x803D: return "GL_ALPHA12";
        case 0x803E: return "GL_ALPHA16";
        case 0x803F: return "GL_LUMINANCE4";
        case 0x804A: return "GL_INTENSITY4";
        case 0x804B: return "GL_INTENSITY8";
        case 0x804C: return "GL_INTENSITY12";
        case 0x804D: return "GL_INTENSITY16";
        case 0x804E: return "GL_RGB2_EXT";
        case 0x804F: return "GL_RGB4";
        case 0x805A: return "GL_RGBA12";
        case 0x805B: return "GL_RGBA16";
        case 0x805C: return "GL_TEXTURE_RED_SIZE";
        case 0x805D: return "GL_TEXTURE_GREEN_SIZE";
        case 0x805E: return "GL_TEXTURE_BLUE_SIZE";
        case 0x805F: return "GL_TEXTURE_ALPHA_SIZE";
        case 0x806A: return "GL_TEXTURE_BINDING_3D";
        case 0x806B: return "GL_PACK_SKIP_IMAGES";
        case 0x806C: return "GL_PACK_IMAGE_HEIGHT";
        case 0x806D: return "GL_UNPACK_SKIP_IMAGES";
        case 0x806E: return "GL_UNPACK_IMAGE_HEIGHT";
        case 0x806F: return "GL_TEXTURE_3D";
        case 0x807A: return "GL_VERTEX_ARRAY_SIZE";
        case 0x807B: return "GL_VERTEX_ARRAY_TYPE";
        case 0x807C: return "GL_VERTEX_ARRAY_STRIDE";
        case 0x807D: return "GL_VERTEX_ARRAY_COUNT_EXT";
        case 0x807E: return "GL_NORMAL_ARRAY_TYPE";
        case 0x807F: return "GL_NORMAL_ARRAY_STRIDE";
        case 0x808A: return "GL_TEXTURE_COORD_ARRAY_STRIDE";
        case 0x808B: return "GL_TEXTURE_COORD_ARRAY_COUNT_EXT";
        case 0x808C: return "GL_EDGE_FLAG_ARRAY_STRIDE";
        case 0x808D: return "GL_EDGE_FLAG_ARRAY_COUNT_EXT";
        case 0x808E: return "GL_VERTEX_ARRAY_POINTER";
        case 0x808F: return "GL_NORMAL_ARRAY_POINTER";
        case 0x809A: return "GL_DETAIL_TEXTURE_LEVEL_SGIS";
        case 0x809B: return "GL_DETAIL_TEXTURE_MODE_SGIS";
        case 0x809C: return "GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS";
        case 0x809D: return "GL_MULTISAMPLE";
        case 0x809E: return "GL_SAMPLE_ALPHA_TO_COVERAGE";
        case 0x809F: return "GL_SAMPLE_ALPHA_TO_ONE";
        case 0x811A: return "GL_DUAL_INTENSITY12_SGIS";
        case 0x811B: return "GL_DUAL_INTENSITY16_SGIS";
        case 0x811C: return "GL_DUAL_LUMINANCE_ALPHA4_SGIS";
        case 0x811D: return "GL_DUAL_LUMINANCE_ALPHA8_SGIS";
        case 0x811E: return "GL_QUAD_ALPHA4_SGIS";
        case 0x811F: return "GL_QUAD_ALPHA8_SGIS";
        case 0x812A: return "GL_FOG_FUNC_SGIS";
        case 0x812B: return "GL_FOG_FUNC_POINTS_SGIS";
        case 0x812C: return "GL_MAX_FOG_FUNC_POINTS_SGIS";
        case 0x812D: return "GL_CLAMP_TO_BORDER";
        case 0x812F: return "GL_CLAMP_TO_EDGE";
        case 0x813A: return "GL_TEXTURE_MIN_LOD";
        case 0x813B: return "GL_TEXTURE_MAX_LOD";
        case 0x813C: return "GL_TEXTURE_BASE_LEVEL";
        case 0x813D: return "GL_TEXTURE_MAX_LEVEL";
        case 0x814F: return "GL_TEXTURE_4D_BINDING_SGIS";
        case 0x815A: return "GL_IMAGE_ROTATE_ORIGIN_X_HP";
        case 0x815B: return "GL_IMAGE_ROTATE_ORIGIN_Y_HP";
        case 0x815C: return "GL_IMAGE_MAG_FILTER_HP";
        case 0x815D: return "GL_IMAGE_MIN_FILTER_HP";
        case 0x815E: return "GL_IMAGE_CUBIC_WEIGHT_HP";
        case 0x815F: return "GL_CUBIC_HP";
        case 0x821A: return "GL_DEPTH_STENCIL_ATTACHMENT";
        case 0x821B: return "GL_MAJOR_VERSION";
        case 0x821C: return "GL_MINOR_VERSION";
        case 0x821D: return "GL_NUM_EXTENSIONS";
        case 0x821E: return "GL_CONTEXT_FLAGS";
        case 0x822A: return "GL_R16";
        case 0x822B: return "GL_RG8";
        case 0x822C: return "GL_RG16";
        case 0x822D: return "GL_R16F";
        case 0x822E: return "GL_R32F";
        case 0x822F: return "GL_RG16F";
        case 0x823A: return "GL_RG16UI";
        case 0x823B: return "GL_RG32I";
        case 0x823C: return "GL_RG32UI";
        case 0x824A: return "GL_DEBUG_SOURCE_APPLICATION_ARB";
        case 0x824B: return "GL_DEBUG_SOURCE_OTHER_ARB";
        case 0x824C: return "GL_DEBUG_TYPE_ERROR_ARB";
        case 0x824D: return "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB";
        case 0x824E: return "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB";
        case 0x824F: return "GL_DEBUG_TYPE_PORTABILITY_ARB";
        case 0x825A: return "GL_PROGRAM_PIPELINE_BINDING";
        case 0x825B: return "GL_MAX_VIEWPORTS";
        case 0x825C: return "GL_VIEWPORT_SUBPIXEL_BITS";
        case 0x825D: return "GL_VIEWPORT_BOUNDS_RANGE";
        case 0x825E: return "GL_LAYER_PROVOKING_VERTEX";
        case 0x825F: return "GL_VIEWPORT_INDEX_PROVOKING_VERTEX";
        case 0x834A: return "GL_FRAGMENT_NORMAL_EXT";
        case 0x834C: return "GL_FRAGMENT_COLOR_EXT";
        case 0x834D: return "GL_ATTENUATION_EXT";
        case 0x834E: return "GL_SHADOW_ATTENUATION_EXT";
        case 0x834F: return "GL_TEXTURE_APPLICATION_MODE_EXT";
        case 0x843A: return "GL_BINORMAL_ARRAY_EXT";
        case 0x843B: return "GL_CURRENT_TANGENT_EXT";
        case 0x843C: return "GL_CURRENT_BINORMAL_EXT";
        case 0x843E: return "GL_TANGENT_ARRAY_TYPE_EXT";
        case 0x843F: return "GL_TANGENT_ARRAY_STRIDE_EXT";
        case 0x845A: return "GL_SECONDARY_COLOR_ARRAY_SIZE";
        case 0x845B: return "GL_SECONDARY_COLOR_ARRAY_TYPE";
        case 0x845C: return "GL_SECONDARY_COLOR_ARRAY_STRIDE";
        case 0x845D: return "GL_SECONDARY_COLOR_ARRAY_POINTER";
        case 0x845E: return "GL_SECONDARY_COLOR_ARRAY";
        case 0x845F: return "GL_CURRENT_RASTER_SECONDARY_COLOR";
        case 0x846D: return "GL_ALIASED_POINT_SIZE_RANGE";
        case 0x846E: return "GL_ALIASED_LINE_WIDTH_RANGE";
        case 0x850A: return "GL_MODELVIEW1_EXT";
        case 0x850B: return "GL_CURRENT_VERTEX_WEIGHT_EXT";
        case 0x850C: return "GL_VERTEX_WEIGHT_ARRAY_EXT";
        case 0x850D: return "GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT";
        case 0x850E: return "GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT";
        case 0x850F: return "GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT";
        case 0x851A: return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z";
        case 0x851B: return "GL_PROXY_TEXTURE_CUBE_MAP";
        case 0x851C: return "GL_MAX_CUBE_MAP_TEXTURE_SIZE";
        case 0x851D: return "GL_VERTEX_ARRAY_RANGE_APPLE";
        case 0x851E: return "GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE";
        case 0x851F: return "GL_VERTEX_ARRAY_STORAGE_HINT_APPLE";
        case 0x858A: return "GL_SRC2_ALPHA";
        case 0x859A: return "GL_OPERAND2_ALPHA";
        case 0x862E: return "GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB";
        case 0x862F: return "GL_MAX_PROGRAM_MATRICES_ARB";
        case 0x864B: return "GL_PROGRAM_ERROR_POSITION_ARB";
        case 0x864F: return "GL_DEPTH_CLAMP";
        case 0x872A: return "GL_MODELVIEW10_ARB";
        case 0x872B: return "GL_MODELVIEW11_ARB";
        case 0x872C: return "GL_MODELVIEW12_ARB";
        case 0x872D: return "GL_MODELVIEW13_ARB";
        case 0x872E: return "GL_MODELVIEW14_ARB";
        case 0x872F: return "GL_MODELVIEW15_ARB";
        case 0x873A: return "GL_MODELVIEW26_ARB";
        case 0x873B: return "GL_MODELVIEW27_ARB";
        case 0x873C: return "GL_MODELVIEW28_ARB";
        case 0x873D: return "GL_MODELVIEW29_ARB";
        case 0x873E: return "GL_MODELVIEW30_ARB";
        case 0x873F: return "GL_MODELVIEW31_ARB";
        case 0x875A: return "GL_DEBUG_PRINT_MESA";
        // case 0x875A: return "GL_TEXTURE_2D_STACK_MESAX";
        case 0x875B: return "GL_DEBUG_ASSERT_MESA";
        // case 0x875B: return "GL_PROXY_TEXTURE_1D_STACK_MESAX";
        case 0x875C: return "GL_PROXY_TEXTURE_2D_STACK_MESAX";
        case 0x875D: return "GL_TEXTURE_1D_STACK_BINDING_MESAX";
        case 0x875E: return "GL_TEXTURE_2D_STACK_BINDING_MESAX";
        case 0x878A: return "GL_OP_MAX_EXT";
        case 0x878B: return "GL_OP_MIN_EXT";
        case 0x878C: return "GL_OP_SET_GE_EXT";
        case 0x878D: return "GL_OP_SET_LT_EXT";
        case 0x878E: return "GL_OP_CLAMP_EXT";
        case 0x878F: return "GL_OP_FLOOR_EXT";
        case 0x879A: return "GL_OUTPUT_VERTEX_EXT";
        case 0x879B: return "GL_OUTPUT_COLOR0_EXT";
        case 0x879C: return "GL_OUTPUT_COLOR1_EXT";
        case 0x879D: return "GL_OUTPUT_TEXTURE_COORD0_EXT";
        case 0x879E: return "GL_OUTPUT_TEXTURE_COORD1_EXT";
        case 0x879F: return "GL_OUTPUT_TEXTURE_COORD2_EXT";
        case 0x880A: return "GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB";
        case 0x880B: return "GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB";
        case 0x880C: return "GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB";
        case 0x880D: return "GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB";
        case 0x880E: return "GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB";
        case 0x880F: return "GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB";
        case 0x881A: return "GL_RGBA16F";
        case 0x881B: return "GL_RGB16F";
        case 0x881C: return "GL_ALPHA16F_ARB";
        case 0x881D: return "GL_INTENSITY16F_ARB";
        case 0x881E: return "GL_LUMINANCE16F_ARB";
        case 0x881F: return "GL_LUMINANCE_ALPHA16F_ARB";
        case 0x882A: return "GL_DRAW_BUFFER5";
        case 0x882B: return "GL_DRAW_BUFFER6";
        case 0x882C: return "GL_DRAW_BUFFER7";
        case 0x882D: return "GL_DRAW_BUFFER8";
        case 0x882E: return "GL_DRAW_BUFFER9";
        case 0x882F: return "GL_DRAW_BUFFER10";
        case 0x883D: return "GL_BLEND_EQUATION_ALPHA";
        case 0x884A: return "GL_TEXTURE_DEPTH_SIZE";
        case 0x884B: return "GL_DEPTH_TEXTURE_MODE";
        case 0x884C: return "GL_TEXTURE_COMPARE_MODE";
        case 0x884D: return "GL_TEXTURE_COMPARE_FUNC";
        case 0x884E: return "GL_COMPARE_REF_TO_TEXTURE";
        case 0x884F: return "GL_TEXTURE_CUBE_MAP_SEAMLESS";
        case 0x886A: return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED";
        case 0x886C: return "GL_MAX_TESS_CONTROL_INPUT_COMPONENTS";
        case 0x886D: return "GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS";
        case 0x887F: return "GL_GEOMETRY_SHADER_INVOCATIONS";
        case 0x889A: return "GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING";
        case 0x889B: return "GL_EDGE_FLAG_ARRAY_BUFFER_BINDING";
        case 0x889C: return "GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING";
        case 0x889D: return "GL_FOG_COORD_ARRAY_BUFFER_BINDING";
        case 0x889E: return "GL_WEIGHT_ARRAY_BUFFER_BINDING";
        case 0x889F: return "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING";
        case 0x891A: return "GL_CLAMP_VERTEX_COLOR";
        case 0x891B: return "GL_CLAMP_FRAGMENT_COLOR";
        case 0x891C: return "GL_CLAMP_READ_COLOR";
        case 0x891D: return "GL_FIXED_ONLY";
        case 0x0900: return "GL_CW";
        case 0x900A: return "GL_TEXTURE_BINDING_CUBE_MAP_ARRAY";
        case 0x900B: return "GL_PROXY_TEXTURE_CUBE_MAP_ARRAY";
        case 0x900C: return "GL_SAMPLER_CUBE_MAP_ARRAY";
        case 0x900D: return "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW";
        case 0x900E: return "GL_INT_SAMPLER_CUBE_MAP_ARRAY";
        case 0x900F: return "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY";
        case 0x0901: return "GL_CCW";
        case 0x901A: return "GL_LUMINANCE16_ALPHA16_SNORM";
        case 0x901B: return "GL_INTENSITY16_SNORM";
        case 0x904C: return "GL_IMAGE_1D_EXT";
        case 0x904D: return "GL_IMAGE_2D_EXT";
        case 0x904E: return "GL_IMAGE_3D_EXT";
        case 0x904F: return "GL_IMAGE_2D_RECT_EXT";
        case 0x905A: return "GL_INT_IMAGE_2D_RECT_EXT";
        case 0x905B: return "GL_INT_IMAGE_CUBE_EXT";
        case 0x905C: return "GL_INT_IMAGE_BUFFER_EXT";
        case 0x905D: return "GL_INT_IMAGE_1D_ARRAY_EXT";
        case 0x905E: return "GL_INT_IMAGE_2D_ARRAY_EXT";
        case 0x905F: return "GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT";
        case 0x906A: return "GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT";
        case 0x906B: return "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT";
        case 0x906C: return "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT";
        case 0x906D: return "GL_MAX_IMAGE_SAMPLES_EXT";
        case 0x906E: return "GL_IMAGE_BINDING_FORMAT_EXT";
        case 0x906F: return "GL_RGB10_A2UI";
        case 0x910A: return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE";
        case 0x910B: return "GL_SAMPLER_2D_MULTISAMPLE_ARRAY";
        case 0x910C: return "GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
        case 0x910D: return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
        case 0x910E: return "GL_MAX_COLOR_TEXTURE_SAMPLES";
        case 0x910F: return "GL_MAX_DEPTH_TEXTURE_SAMPLES";
        case 0x911A: return "GL_ALREADY_SIGNALED";
        case 0x911B: return "GL_TIMEOUT_EXPIRED";
        case 0x911C: return "GL_CONDITION_SATISFIED";
        case 0x911D: return "GL_WAIT_FAILED";
        case 0x911F: return "GL_BUFFER_ACCESS_FLAGS";
        case 0x914A: return "GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD";
        case 0x914B: return "GL_DEBUG_CATEGORY_DEPRECATION_AMD";
        case 0x914C: return "GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD";
        case 0x914D: return "GL_DEBUG_CATEGORY_PERFORMANCE_AMD";
        case 0x914E: return "GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD";
        case 0x914F: return "GL_DEBUG_CATEGORY_APPLICATION_AMD";
        case 0x1000: return "GL_TEXTURE_WIDTH";
        case 0x1001: return "GL_TEXTURE_HEIGHT";
        case 0x1003: return "GL_TEXTURE_INTERNAL_FORMAT";
        case 0x1004: return "GL_TEXTURE_BORDER_COLOR";
        case 0x1005: return "GL_TEXTURE_BORDER";
        case 0x1100: return "GL_DONT_CARE";
        case 0x1101: return "GL_FASTEST";
        case 0x1102: return "GL_NICEST";
        case 0x1200: return "GL_AMBIENT";
        case 0x1201: return "GL_DIFFUSE";
        case 0x1202: return "GL_SPECULAR";
        case 0x1203: return "GL_POSITION";
        case 0x1204: return "GL_SPOT_DIRECTION";
        case 0x1205: return "GL_SPOT_EXPONENT";
        case 0x1206: return "GL_SPOT_CUTOFF";
        case 0x1207: return "GL_CONSTANT_ATTENUATION";
        case 0x1208: return "GL_LINEAR_ATTENUATION";
        case 0x1209: return "GL_QUADRATIC_ATTENUATION";
        case 0x1300: return "GL_COMPILE";
        case 0x1301: return "GL_COMPILE_AND_EXECUTE";
        case 0x1400: return "GL_BYTE";
        case 0x1401: return "GL_UNSIGNED_BYTE";
        case 0x1402: return "GL_SHORT";
        case 0x1403: return "GL_UNSIGNED_SHORT";
        case 0x1404: return "GL_INT";
        case 0x1405: return "GL_UNSIGNED_INT";
        case 0x1406: return "GL_FLOAT";
        case 0x1407: return "GL_2_BYTES";
        case 0x1408: return "GL_3_BYTES";
        case 0x1409: return "GL_4_BYTES";
        case 0x1500: return "GL_CLEAR";
        case 0x1501: return "GL_AND";
        case 0x1502: return "GL_AND_REVERSE";
        case 0x1503: return "GL_COPY";
        case 0x1504: return "GL_AND_INVERTED";
        case 0x1505: return "GL_NOOP";
        case 0x1506: return "GL_XOR";
        case 0x1507: return "GL_OR";
        case 0x1508: return "GL_NOR";
        case 0x1509: return "GL_EQUIV";
        case 0x1600: return "GL_EMISSION";
        case 0x1601: return "GL_SHININESS";
        case 0x1602: return "GL_AMBIENT_AND_DIFFUSE";
        case 0x1603: return "GL_COLOR_INDEXES";
        case 0x1700: return "GL_MODELVIEW";
        case 0x1701: return "GL_PROJECTION";
        case 0x1702: return "GL_TEXTURE";
        case 0x1800: return "GL_COLOR";
        case 0x1801: return "GL_DEPTH";
        case 0x1802: return "GL_STENCIL";
        case 0x1900: return "GL_COLOR_INDEX";
        case 0x1901: return "GL_STENCIL_INDEX";
        case 0x1902: return "GL_DEPTH_COMPONENT";
        case 0x1903: return "GL_RED";
        case 0x1904: return "GL_GREEN";
        case 0x1905: return "GL_BLUE";
        case 0x1906: return "GL_ALPHA";
        case 0x1907: return "GL_RGB";
        case 0x1908: return "GL_RGBA";
        case 0x1909: return "GL_LUMINANCE";
        case 0x2000: return "GL_S";
        case 0x2001: return "GL_T";
        case 0x2002: return "GL_R";
        case 0x2003: return "GL_Q";
        case 0x2100: return "GL_MODULATE";
        case 0x2101: return "GL_DECAL";
        case 0x2200: return "GL_TEXTURE_ENV_MODE";
        case 0x2201: return "GL_TEXTURE_ENV_COLOR";
        case 0x2300: return "GL_TEXTURE_ENV";
        case 0x2400: return "GL_EYE_LINEAR";
        case 0x2401: return "GL_OBJECT_LINEAR";
        case 0x2402: return "GL_SPHERE_MAP";
        case 0x2500: return "GL_TEXTURE_GEN_MODE";
        case 0x2501: return "GL_OBJECT_PLANE";
        case 0x2502: return "GL_EYE_PLANE";
        case 0x2600: return "GL_NEAREST";
        case 0x2601: return "GL_LINEAR";
        case 0x2700: return "GL_NEAREST_MIPMAP_NEAREST";
        case 0x2701: return "GL_LINEAR_MIPMAP_NEAREST";
        case 0x2702: return "GL_NEAREST_MIPMAP_LINEAR";
        case 0x2703: return "GL_LINEAR_MIPMAP_LINEAR";
        case 0x2800: return "GL_TEXTURE_MAG_FILTER";
        case 0x2801: return "GL_TEXTURE_MIN_FILTER";
        case 0x2802: return "GL_TEXTURE_WRAP_S";
        case 0x2803: return "GL_TEXTURE_WRAP_T";
        case 0x2900: return "GL_CLAMP";
        case 0x2901: return "GL_REPEAT";
        case 0x3000: return "GL_CLIP_PLANE0";
        case 0x3001: return "GL_CLIP_PLANE1";
        case 0x3002: return "GL_CLIP_PLANE2";
        case 0x3003: return "GL_CLIP_PLANE3";
        case 0x3004: return "GL_CLIP_PLANE4";
        case 0x3005: return "GL_CLIP_PLANE5";
        case 0x3006: return "GL_CLIP_DISTANCE6";
        case 0x3007: return "GL_CLIP_DISTANCE7";
        case 0x4000: return "GL_LIGHT0";
        case 0x4001: return "GL_LIGHT1";
        case 0x4002: return "GL_LIGHT2";
        case 0x4003: return "GL_LIGHT3";
        case 0x4004: return "GL_LIGHT4";
        case 0x4005: return "GL_LIGHT5";
        case 0x4006: return "GL_LIGHT6";
        case 0x4007: return "GL_LIGHT7";
        case 0x8000: return "GL_ABGR_EXT";
        case 0x8001: return "GL_CONSTANT_COLOR";
        case 0x8002: return "GL_ONE_MINUS_CONSTANT_COLOR";
        case 0x8003: return "GL_CONSTANT_ALPHA";
        case 0x8004: return "GL_ONE_MINUS_CONSTANT_ALPHA";
        case 0x8005: return "GL_BLEND_COLOR";
        case 0x8006: return "GL_FUNC_ADD";
        case 0x8007: return "GL_MIN";
        case 0x8008: return "GL_MAX";
        case 0x8009: return "GL_BLEND_EQUATION";
        case 0x8010: return "GL_CONVOLUTION_1D";
        case 0x8011: return "GL_CONVOLUTION_2D";
        case 0x8012: return "GL_SEPARABLE_2D";
        case 0x8013: return "GL_CONVOLUTION_BORDER_MODE";
        case 0x8014: return "GL_CONVOLUTION_FILTER_SCALE";
        case 0x8015: return "GL_CONVOLUTION_FILTER_BIAS";
        case 0x8016: return "GL_REDUCE";
        case 0x8017: return "GL_CONVOLUTION_FORMAT";
        case 0x8018: return "GL_CONVOLUTION_WIDTH";
        case 0x8019: return "GL_CONVOLUTION_HEIGHT";
        case 0x8020: return "GL_POST_CONVOLUTION_RED_BIAS";
        case 0x8021: return "GL_POST_CONVOLUTION_GREEN_BIAS";
        case 0x8022: return "GL_POST_CONVOLUTION_BLUE_BIAS";
        case 0x8023: return "GL_POST_CONVOLUTION_ALPHA_BIAS";
        case 0x8024: return "GL_HISTOGRAM";
        case 0x8025: return "GL_PROXY_HISTOGRAM";
        case 0x8026: return "GL_HISTOGRAM_WIDTH";
        case 0x8027: return "GL_HISTOGRAM_FORMAT";
        case 0x8028: return "GL_HISTOGRAM_RED_SIZE";
        case 0x8029: return "GL_HISTOGRAM_GREEN_SIZE";
        case 0x8030: return "GL_MINMAX_SINK";
        case 0x8031: return "GL_TABLE_TOO_LARGE";
        case 0x8032: return "GL_UNSIGNED_BYTE_3_3_2";
        case 0x8033: return "GL_UNSIGNED_SHORT_4_4_4_4";
        case 0x8034: return "GL_UNSIGNED_SHORT_5_5_5_1";
        case 0x8035: return "GL_UNSIGNED_INT_8_8_8_8";
        case 0x8036: return "GL_UNSIGNED_INT_10_10_10_2";
        case 0x8037: return "GL_POLYGON_OFFSET_EXT";
        case 0x8038: return "GL_POLYGON_OFFSET_FACTOR";
        case 0x8039: return "GL_POLYGON_OFFSET_BIAS_EXT";
        case 0x8040: return "GL_LUMINANCE8";
        case 0x8041: return "GL_LUMINANCE12";
        case 0x8042: return "GL_LUMINANCE16";
        case 0x8043: return "GL_LUMINANCE4_ALPHA4";
        case 0x8044: return "GL_LUMINANCE6_ALPHA2";
        case 0x8045: return "GL_LUMINANCE8_ALPHA8";
        case 0x8046: return "GL_LUMINANCE12_ALPHA4";
        case 0x8047: return "GL_LUMINANCE12_ALPHA12";
        case 0x8048: return "GL_LUMINANCE16_ALPHA16";
        case 0x8049: return "GL_INTENSITY";
        case 0x8050: return "GL_RGB5";
        case 0x8051: return "GL_RGB8";
        case 0x8052: return "GL_RGB10";
        case 0x8053: return "GL_RGB12";
        case 0x8054: return "GL_RGB16";
        case 0x8055: return "GL_RGBA2";
        case 0x8056: return "GL_RGBA4";
        case 0x8057: return "GL_RGB5_A1";
        case 0x8058: return "GL_RGBA8";
        case 0x8059: return "GL_RGB10_A2";
        case 0x8060: return "GL_TEXTURE_LUMINANCE_SIZE";
        case 0x8061: return "GL_TEXTURE_INTENSITY_SIZE";
        case 0x8062: return "GL_REPLACE_EXT";
        case 0x8063: return "GL_PROXY_TEXTURE_1D";
        case 0x8064: return "GL_PROXY_TEXTURE_2D";
        case 0x8065: return "GL_TEXTURE_TOO_LARGE_EXT";
        case 0x8066: return "GL_TEXTURE_PRIORITY";
        case 0x8067: return "GL_TEXTURE_RESIDENT";
        case 0x8068: return "GL_TEXTURE_BINDING_1D";
        case 0x8069: return "GL_TEXTURE_BINDING_2D";
        case 0x8070: return "GL_PROXY_TEXTURE_3D";
        case 0x8071: return "GL_TEXTURE_DEPTH";
        case 0x8072: return "GL_TEXTURE_WRAP_R";
        case 0x8073: return "GL_MAX_3D_TEXTURE_SIZE";
        case 0x8074: return "GL_VERTEX_ARRAY";
        case 0x8075: return "GL_NORMAL_ARRAY";
        case 0x8076: return "GL_COLOR_ARRAY";
        case 0x8077: return "GL_INDEX_ARRAY";
        case 0x8078: return "GL_TEXTURE_COORD_ARRAY";
        case 0x8079: return "GL_EDGE_FLAG_ARRAY";
        case 0x8080: return "GL_NORMAL_ARRAY_COUNT_EXT";
        case 0x8081: return "GL_COLOR_ARRAY_SIZE";
        case 0x8082: return "GL_COLOR_ARRAY_TYPE";
        case 0x8083: return "GL_COLOR_ARRAY_STRIDE";
        case 0x8084: return "GL_COLOR_ARRAY_COUNT_EXT";
        case 0x8085: return "GL_INDEX_ARRAY_TYPE";
        case 0x8086: return "GL_INDEX_ARRAY_STRIDE";
        case 0x8087: return "GL_INDEX_ARRAY_COUNT_EXT";
        case 0x8088: return "GL_TEXTURE_COORD_ARRAY_SIZE";
        case 0x8089: return "GL_TEXTURE_COORD_ARRAY_TYPE";
        case 0x8090: return "GL_COLOR_ARRAY_POINTER";
        case 0x8091: return "GL_INDEX_ARRAY_POINTER";
        case 0x8092: return "GL_TEXTURE_COORD_ARRAY_POINTER";
        case 0x8093: return "GL_EDGE_FLAG_ARRAY_POINTER";
        case 0x8095: return "GL_DETAIL_TEXTURE_2D_SGIS";
        case 0x8096: return "GL_DETAIL_TEXTURE_2D_BINDING_SGIS";
        case 0x8097: return "GL_LINEAR_DETAIL_SGIS";
        case 0x8098: return "GL_LINEAR_DETAIL_ALPHA_SGIS";
        case 0x8099: return "GL_LINEAR_DETAIL_COLOR_SGIS";
        case 0x8110: return "GL_DUAL_ALPHA4_SGIS";
        case 0x8111: return "GL_DUAL_ALPHA8_SGIS";
        case 0x8112: return "GL_DUAL_ALPHA12_SGIS";
        case 0x8113: return "GL_DUAL_ALPHA16_SGIS";
        case 0x8114: return "GL_DUAL_LUMINANCE4_SGIS";
        case 0x8115: return "GL_DUAL_LUMINANCE8_SGIS";
        case 0x8116: return "GL_DUAL_LUMINANCE12_SGIS";
        case 0x8117: return "GL_DUAL_LUMINANCE16_SGIS";
        case 0x8118: return "GL_DUAL_INTENSITY4_SGIS";
        case 0x8119: return "GL_DUAL_INTENSITY8_SGIS";
        case 0x8120: return "GL_QUAD_LUMINANCE4_SGIS";
        case 0x8121: return "GL_QUAD_LUMINANCE8_SGIS";
        case 0x8122: return "GL_QUAD_INTENSITY4_SGIS";
        case 0x8123: return "GL_QUAD_INTENSITY8_SGIS";
        case 0x8124: return "GL_DUAL_TEXTURE_SELECT_SGIS";
        case 0x8125: return "GL_QUAD_TEXTURE_SELECT_SGIS";
        case 0x8126: return "GL_POINT_SIZE_MIN";
        case 0x8127: return "GL_POINT_SIZE_MAX";
        case 0x8128: return "GL_POINT_FADE_THRESHOLD_SIZE";
        case 0x8129: return "GL_POINT_DISTANCE_ATTENUATION";
        case 0x8130: return "GL_PACK_SKIP_VOLUMES_SGIS";
        case 0x8131: return "GL_PACK_IMAGE_DEPTH_SGIS";
        case 0x8132: return "GL_UNPACK_SKIP_VOLUMES_SGIS";
        case 0x8133: return "GL_UNPACK_IMAGE_DEPTH_SGIS";
        case 0x8134: return "GL_TEXTURE_4D_SGIS";
        case 0x8135: return "GL_PROXY_TEXTURE_4D_SGIS";
        case 0x8136: return "GL_TEXTURE_4DSIZE_SGIS";
        case 0x8137: return "GL_TEXTURE_WRAP_Q_SGIS";
        case 0x8138: return "GL_MAX_4D_TEXTURE_SIZE_SGIS";
        case 0x8146: return "GL_FILTER4_SGIS";
        case 0x8147: return "GL_TEXTURE_FILTER4_SIZE_SGIS";
        case 0x8150: return "GL_IGNORE_BORDER_HP";
        case 0x8151: return "GL_CONSTANT_BORDER";
        case 0x8153: return "GL_REPLICATE_BORDER";
        case 0x8154: return "GL_CONVOLUTION_BORDER_COLOR";
        case 0x8155: return "GL_IMAGE_SCALE_X_HP";
        case 0x8156: return "GL_IMAGE_SCALE_Y_HP";
        case 0x8157: return "GL_IMAGE_TRANSLATE_X_HP";
        case 0x8158: return "GL_IMAGE_TRANSLATE_Y_HP";
        case 0x8159: return "GL_IMAGE_ROTATE_ANGLE_HP";
        case 0x8160: return "GL_AVERAGE_HP";
        case 0x8161: return "GL_IMAGE_TRANSFORM_2D_HP";
        case 0x8162: return "GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP";
        case 0x8163: return "GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP";
        case 0x8165: return "GL_OCCLUSION_TEST_HP";
        case 0x8166: return "GL_OCCLUSION_TEST_RESULT_HP";
        case 0x8167: return "GL_TEXTURE_LIGHTING_MODE_HP";
        case 0x8168: return "GL_TEXTURE_POST_SPECULAR_HP";
        case 0x8169: return "GL_TEXTURE_PRE_SPECULAR_HP";
        case 0x8191: return "GL_GENERATE_MIPMAP";
        case 0x8192: return "GL_GENERATE_MIPMAP_HINT";
        case 0x8210: return "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING";
        case 0x8211: return "GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE";
        case 0x8212: return "GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE";
        case 0x8213: return "GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE";
        case 0x8214: return "GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE";
        case 0x8215: return "GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE";
        case 0x8216: return "GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE";
        case 0x8217: return "GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE";
        case 0x8218: return "GL_FRAMEBUFFER_DEFAULT";
        case 0x8219: return "GL_FRAMEBUFFER_UNDEFINED";
        case 0x8222: return "GL_INDEX";
        case 0x8223: return "GL_DEPTH_BUFFER";
        case 0x8224: return "GL_STENCIL_BUFFER";
        case 0x8225: return "GL_COMPRESSED_RED";
        case 0x8226: return "GL_COMPRESSED_RG";
        case 0x8227: return "GL_RG";
        case 0x8228: return "GL_RG_INTEGER";
        case 0x8229: return "GL_R8";
        case 0x8230: return "GL_RG32F";
        case 0x8231: return "GL_R8I";
        case 0x8232: return "GL_R8UI";
        case 0x8233: return "GL_R16I";
        case 0x8234: return "GL_R16UI";
        case 0x8235: return "GL_R32I";
        case 0x8236: return "GL_R32UI";
        case 0x8237: return "GL_RG8I";
        case 0x8238: return "GL_RG8UI";
        case 0x8239: return "GL_RG16I";
        case 0x8240: return "GL_SYNC_CL_EVENT_ARB";
        case 0x8241: return "GL_SYNC_CL_EVENT_COMPLETE_ARB";
        case 0x8242: return "GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB";
        case 0x8243: return "GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB";
        case 0x8244: return "GL_DEBUG_CALLBACK_FUNCTION_ARB";
        case 0x8245: return "GL_DEBUG_CALLBACK_USER_PARAM_ARB";
        case 0x8246: return "GL_DEBUG_SOURCE_API_ARB";
        case 0x8247: return "GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB";
        case 0x8248: return "GL_DEBUG_SOURCE_SHADER_COMPILER_ARB";
        case 0x8249: return "GL_DEBUG_SOURCE_THIRD_PARTY_ARB";
        case 0x8250: return "GL_DEBUG_TYPE_PERFORMANCE_ARB";
        case 0x8251: return "GL_DEBUG_TYPE_OTHER_ARB";
        case 0x8252: return "GL_LOSE_CONTEXT_ON_RESET_ARB";
        case 0x8253: return "GL_GUILTY_CONTEXT_RESET_ARB";
        case 0x8254: return "GL_INNOCENT_CONTEXT_RESET_ARB";
        case 0x8255: return "GL_UNKNOWN_CONTEXT_RESET_ARB";
        case 0x8256: return "GL_RESET_NOTIFICATION_STRATEGY_ARB";
        case 0x8257: return "GL_PROGRAM_BINARY_RETRIEVABLE_HINT";
        case 0x8258: return "GL_PROGRAM_SEPARABLE";
        case 0x8259: return "GL_ACTIVE_PROGRAM";
        case 0x8260: return "GL_UNDEFINED_VERTEX";
        case 0x8261: return "GL_NO_RESET_NOTIFICATION_ARB";
        case 0x8330: return "GL_PIXEL_TRANSFORM_2D_EXT";
        case 0x8331: return "GL_PIXEL_MAG_FILTER_EXT";
        case 0x8332: return "GL_PIXEL_MIN_FILTER_EXT";
        case 0x8333: return "GL_PIXEL_CUBIC_WEIGHT_EXT";
        case 0x8334: return "GL_CUBIC_EXT";
        case 0x8335: return "GL_AVERAGE_EXT";
        case 0x8336: return "GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT";
        case 0x8337: return "GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT";
        case 0x8338: return "GL_PIXEL_TRANSFORM_2D_MATRIX_EXT";
        case 0x8349: return "GL_FRAGMENT_MATERIAL_EXT";
        case 0x8350: return "GL_TEXTURE_LIGHT_EXT";
        case 0x8351: return "GL_TEXTURE_MATERIAL_FACE_EXT";
        case 0x8352: return "GL_TEXTURE_MATERIAL_PARAMETER_EXT";
        case 0x8353: return "GL_PIXEL_TEXTURE_SGIS";
        case 0x8354: return "GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS";
        case 0x8355: return "GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS";
        case 0x8356: return "GL_PIXEL_GROUP_COLOR_SGIS";
        case 0x8362: return "GL_UNSIGNED_BYTE_2_3_3_REV";
        case 0x8363: return "GL_UNSIGNED_SHORT_5_6_5";
        case 0x8364: return "GL_UNSIGNED_SHORT_5_6_5_REV";
        case 0x8365: return "GL_UNSIGNED_SHORT_4_4_4_4_REV";
        case 0x8366: return "GL_UNSIGNED_SHORT_1_5_5_5_REV";
        case 0x8367: return "GL_UNSIGNED_INT_8_8_8_8_REV";
        case 0x8368: return "GL_UNSIGNED_INT_2_10_10_10_REV";
        case 0x8370: return "GL_MIRRORED_REPEAT";
        case 0x8439: return "GL_TANGENT_ARRAY_EXT";
        case 0x8440: return "GL_BINORMAL_ARRAY_TYPE_EXT";
        case 0x8441: return "GL_BINORMAL_ARRAY_STRIDE_EXT";
        case 0x8442: return "GL_TANGENT_ARRAY_POINTER_EXT";
        case 0x8443: return "GL_BINORMAL_ARRAY_POINTER_EXT";
        case 0x8444: return "GL_MAP1_TANGENT_EXT";
        case 0x8445: return "GL_MAP2_TANGENT_EXT";
        case 0x8446: return "GL_MAP1_BINORMAL_EXT";
        case 0x8447: return "GL_MAP2_BINORMAL_EXT";
        case 0x8450: return "GL_FOG_COORD_SRC";
        case 0x8451: return "GL_FOG_COORD";
        case 0x8452: return "GL_FRAGMENT_DEPTH";
        case 0x8453: return "GL_CURRENT_FOG_COORD";
        case 0x8454: return "GL_FOG_COORD_ARRAY_TYPE";
        case 0x8455: return "GL_FOG_COORD_ARRAY_STRIDE";
        case 0x8456: return "GL_FOG_COORD_ARRAY_POINTER";
        case 0x8457: return "GL_FOG_COORD_ARRAY";
        case 0x8458: return "GL_COLOR_SUM";
        case 0x8459: return "GL_CURRENT_SECONDARY_COLOR";
        case 0x8490: return "GL_SCREEN_COORDINATES_REND";
        case 0x8491: return "GL_INVERTED_SCREEN_W_REND";
        case 0x8500: return "GL_TEXTURE_FILTER_CONTROL";
        case 0x8501: return "GL_TEXTURE_LOD_BIAS";
        case 0x8502: return "GL_MODELVIEW1_STACK_DEPTH_EXT";
        case 0x8506: return "GL_MODELVIEW1_MATRIX_EXT";
        case 0x8507: return "GL_INCR_WRAP";
        case 0x8508: return "GL_DECR_WRAP";
        case 0x8509: return "GL_VERTEX_WEIGHTING_EXT";
        case 0x8510: return "GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT";
        case 0x8511: return "GL_NORMAL_MAP";
        case 0x8512: return "GL_REFLECTION_MAP";
        case 0x8513: return "GL_TEXTURE_CUBE_MAP";
        case 0x8514: return "GL_TEXTURE_BINDING_CUBE_MAP";
        case 0x8515: return "GL_TEXTURE_CUBE_MAP_POSITIVE_X";
        case 0x8516: return "GL_TEXTURE_CUBE_MAP_NEGATIVE_X";
        case 0x8517: return "GL_TEXTURE_CUBE_MAP_POSITIVE_Y";
        case 0x8518: return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y";
        case 0x8519: return "GL_TEXTURE_CUBE_MAP_POSITIVE_Z";
        case 0x8521: return "GL_VERTEX_ARRAY_RANGE_POINTER_APPLE";
        case 0x8560: return "GL_RED_MIN_CLAMP_INGR";
        case 0x8561: return "GL_GREEN_MIN_CLAMP_INGR";
        case 0x8562: return "GL_BLUE_MIN_CLAMP_INGR";
        case 0x8563: return "GL_ALPHA_MIN_CLAMP_INGR";
        case 0x8564: return "GL_RED_MAX_CLAMP_INGR";
        case 0x8565: return "GL_GREEN_MAX_CLAMP_INGR";
        case 0x8566: return "GL_BLUE_MAX_CLAMP_INGR";
        case 0x8567: return "GL_ALPHA_MAX_CLAMP_INGR";
        case 0x8568: return "GL_INTERLACE_READ_INGR";
        case 0x8570: return "GL_COMBINE";
        case 0x8571: return "GL_COMBINE_RGB";
        case 0x8572: return "GL_COMBINE_ALPHA";
        case 0x8573: return "GL_RGB_SCALE";
        case 0x8574: return "GL_ADD_SIGNED";
        case 0x8575: return "GL_INTERPOLATE";
        case 0x8576: return "GL_CONSTANT";
        case 0x8577: return "GL_PRIMARY_COLOR";
        case 0x8578: return "GL_PREVIOUS";
        case 0x8580: return "GL_SRC0_RGB";
        case 0x8581: return "GL_SRC1_RGB";
        case 0x8582: return "GL_SRC2_RGB";
        case 0x8588: return "GL_SRC0_ALPHA";
        case 0x8589: return "GL_SRC1_ALPHA";
        case 0x8590: return "GL_OPERAND0_RGB";
        case 0x8591: return "GL_OPERAND1_RGB";
        case 0x8592: return "GL_OPERAND2_RGB";
        case 0x8598: return "GL_OPERAND0_ALPHA";
        case 0x8599: return "GL_OPERAND1_ALPHA";
        case 0x8614: return "GL_QUAD_MESH_SUN";
        case 0x8615: return "GL_TRIANGLE_MESH_SUN";
        case 0x8620: return "GL_VERTEX_PROGRAM_ARB";
        case 0x8622: return "GL_VERTEX_ATTRIB_ARRAY_ENABLED";
        case 0x8623: return "GL_VERTEX_ATTRIB_ARRAY_SIZE";
        case 0x8624: return "GL_VERTEX_ATTRIB_ARRAY_STRIDE";
        case 0x8625: return "GL_VERTEX_ATTRIB_ARRAY_TYPE";
        case 0x8626: return "GL_CURRENT_VERTEX_ATTRIB";
        case 0x8627: return "GL_PROGRAM_LENGTH_ARB";
        case 0x8628: return "GL_PROGRAM_STRING_ARB";
        case 0x8640: return "GL_CURRENT_MATRIX_STACK_DEPTH_ARB";
        case 0x8641: return "GL_CURRENT_MATRIX_ARB";
        case 0x8642: return "GL_PROGRAM_POINT_SIZE";
        case 0x8643: return "GL_VERTEX_PROGRAM_TWO_SIDE";
        case 0x8645: return "GL_VERTEX_ATTRIB_ARRAY_POINTER";
        case 0x8677: return "GL_PROGRAM_BINDING_ARB";
        case 0x8722: return "GL_MODELVIEW2_ARB";
        case 0x8723: return "GL_MODELVIEW3_ARB";
        case 0x8724: return "GL_MODELVIEW4_ARB";
        case 0x8725: return "GL_MODELVIEW5_ARB";
        case 0x8726: return "GL_MODELVIEW6_ARB";
        case 0x8727: return "GL_MODELVIEW7_ARB";
        case 0x8728: return "GL_MODELVIEW8_ARB";
        case 0x8729: return "GL_MODELVIEW9_ARB";
        case 0x8730: return "GL_MODELVIEW16_ARB";
        case 0x8731: return "GL_MODELVIEW17_ARB";
        case 0x8732: return "GL_MODELVIEW18_ARB";
        case 0x8733: return "GL_MODELVIEW19_ARB";
        case 0x8734: return "GL_MODELVIEW20_ARB";
        case 0x8735: return "GL_MODELVIEW21_ARB";
        case 0x8736: return "GL_MODELVIEW22_ARB";
        case 0x8737: return "GL_MODELVIEW23_ARB";
        case 0x8738: return "GL_MODELVIEW24_ARB";
        case 0x8739: return "GL_MODELVIEW25_ARB";
        case 0x8740: return "GL_DOT3_RGB_EXT";
        // case 0x8741: return "GL_DOT3_RGBA_EXT";
        case 0x8741: return "GL_PROGRAM_BINARY_LENGTH";
        case 0x8742: return "GL_MIRROR_CLAMP_EXT";
        case 0x8743: return "GL_MIRROR_CLAMP_TO_EDGE_EXT";
        case 0x8750: return "GL_DEPTH_STENCIL_MESA";
        case 0x8751: return "GL_UNSIGNED_INT_24_8_MESA";
        case 0x8752: return "GL_UNSIGNED_INT_8_24_REV_MESA";
        case 0x8753: return "GL_UNSIGNED_SHORT_15_1_MESA";
        case 0x8754: return "GL_UNSIGNED_SHORT_1_15_REV_MESA";
        case 0x8757: return "GL_YCBCR_MESA";
        case 0x8758: return "GL_PACK_INVERT_MESA";
        case 0x8759: return "GL_DEBUG_OBJECT_MESA";
        // case 0x8759: return "GL_TEXTURE_1D_STACK_MESAX";
        case 0x8764: return "GL_BUFFER_SIZE";
        case 0x8765: return "GL_BUFFER_USAGE";
        case 0x8780: return "GL_VERTEX_SHADER_EXT";
        case 0x8781: return "GL_VERTEX_SHADER_BINDING_EXT";
        case 0x8782: return "GL_OP_INDEX_EXT";
        case 0x8783: return "GL_OP_NEGATE_EXT";
        case 0x8784: return "GL_OP_DOT3_EXT";
        case 0x8785: return "GL_OP_DOT4_EXT";
        case 0x8786: return "GL_OP_MUL_EXT";
        case 0x8787: return "GL_OP_ADD_EXT";
        case 0x8788: return "GL_OP_MADD_EXT";
        case 0x8789: return "GL_OP_FRAC_EXT";
        case 0x8790: return "GL_OP_ROUND_EXT";
        case 0x8791: return "GL_OP_EXP_BASE_2_EXT";
        case 0x8792: return "GL_OP_LOG_BASE_2_EXT";
        case 0x8793: return "GL_OP_POWER_EXT";
        case 0x8794: return "GL_OP_RECIP_EXT";
        case 0x8795: return "GL_OP_RECIP_SQRT_EXT";
        case 0x8796: return "GL_OP_SUB_EXT";
        case 0x8797: return "GL_OP_CROSS_PRODUCT_EXT";
        case 0x8798: return "GL_OP_MULTIPLY_MATRIX_EXT";
        case 0x8799: return "GL_OP_MOV_EXT";
        case 0x8800: return "GL_STENCIL_BACK_FUNC";
        case 0x8801: return "GL_STENCIL_BACK_FAIL";
        case 0x8802: return "GL_STENCIL_BACK_PASS_DEPTH_FAIL";
        case 0x8803: return "GL_STENCIL_BACK_PASS_DEPTH_PASS";
        case 0x8804: return "GL_FRAGMENT_PROGRAM_ARB";
        case 0x8805: return "GL_PROGRAM_ALU_INSTRUCTIONS_ARB";
        case 0x8806: return "GL_PROGRAM_TEX_INSTRUCTIONS_ARB";
        case 0x8807: return "GL_PROGRAM_TEX_INDIRECTIONS_ARB";
        case 0x8808: return "GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB";
        case 0x8809: return "GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB";
        case 0x8810: return "GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB";
        case 0x8814: return "GL_RGBA32F";
        case 0x8815: return "GL_RGB32F";
        case 0x8816: return "GL_ALPHA32F_ARB";
        case 0x8817: return "GL_INTENSITY32F_ARB";
        case 0x8818: return "GL_LUMINANCE32F_ARB";
        case 0x8819: return "GL_LUMINANCE_ALPHA32F_ARB";
        case 0x8820: return "GL_RGBA_FLOAT_MODE_ARB";
        case 0x8824: return "GL_MAX_DRAW_BUFFERS";
        case 0x8825: return "GL_DRAW_BUFFER0";
        case 0x8826: return "GL_DRAW_BUFFER1";
        case 0x8827: return "GL_DRAW_BUFFER2";
        case 0x8828: return "GL_DRAW_BUFFER3";
        case 0x8829: return "GL_DRAW_BUFFER4";
        case 0x8830: return "GL_DRAW_BUFFER11";
        case 0x8831: return "GL_DRAW_BUFFER12";
        case 0x8832: return "GL_DRAW_BUFFER13";
        case 0x8833: return "GL_DRAW_BUFFER14";
        case 0x8834: return "GL_DRAW_BUFFER15";
        case 0x8840: return "GL_MATRIX_PALETTE_ARB";
        case 0x8841: return "GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB";
        case 0x8842: return "GL_MAX_PALETTE_MATRICES_ARB";
        case 0x8843: return "GL_CURRENT_PALETTE_MATRIX_ARB";
        case 0x8844: return "GL_MATRIX_INDEX_ARRAY_ARB";
        case 0x8845: return "GL_CURRENT_MATRIX_INDEX_ARB";
        case 0x8846: return "GL_MATRIX_INDEX_ARRAY_SIZE_ARB";
        case 0x8847: return "GL_MATRIX_INDEX_ARRAY_TYPE_ARB";
        case 0x8848: return "GL_MATRIX_INDEX_ARRAY_STRIDE_ARB";
        case 0x8849: return "GL_MATRIX_INDEX_ARRAY_POINTER_ARB";
        case 0x8861: return "GL_POINT_SPRITE";
        case 0x8862: return "GL_COORD_REPLACE";
        case 0x8864: return "GL_QUERY_COUNTER_BITS";
        case 0x8865: return "GL_CURRENT_QUERY";
        case 0x8866: return "GL_QUERY_RESULT";
        case 0x8867: return "GL_QUERY_RESULT_AVAILABLE";
        case 0x8869: return "GL_MAX_VERTEX_ATTRIBS";
        case 0x8871: return "GL_MAX_TEXTURE_COORDS";
        case 0x8872: return "GL_MAX_TEXTURE_IMAGE_UNITS";
        case 0x8874: return "GL_PROGRAM_ERROR_STRING_ARB";
        case 0x8875: return "GL_PROGRAM_FORMAT_ASCII_ARB";
        case 0x8876: return "GL_PROGRAM_FORMAT_ARB";
        case 0x8890: return "GL_DEPTH_BOUNDS_TEST_EXT";
        case 0x8891: return "GL_DEPTH_BOUNDS_EXT";
        case 0x8892: return "GL_ARRAY_BUFFER";
        case 0x8893: return "GL_ELEMENT_ARRAY_BUFFER";
        case 0x8894: return "GL_ARRAY_BUFFER_BINDING";
        case 0x8895: return "GL_ELEMENT_ARRAY_BUFFER_BINDING";
        case 0x8896: return "GL_VERTEX_ARRAY_BUFFER_BINDING";
        case 0x8897: return "GL_NORMAL_ARRAY_BUFFER_BINDING";
        case 0x8898: return "GL_COLOR_ARRAY_BUFFER_BINDING";
        case 0x8899: return "GL_INDEX_ARRAY_BUFFER_BINDING";
        case 0x8904: return "GL_MIN_PROGRAM_TEXEL_OFFSET";
        case 0x8905: return "GL_MAX_PROGRAM_TEXEL_OFFSET";
        case 0x8910: return "GL_STENCIL_TEST_TWO_SIDE_EXT";
        case 0x8911: return "GL_ACTIVE_STENCIL_FACE_EXT";
        case 0x8912: return "GL_MIRROR_CLAMP_TO_BORDER_EXT";
        case 0x8914: return "GL_SAMPLES_PASSED";
        case 0x8916: return "GL_GEOMETRY_VERTICES_OUT";
        case 0x8917: return "GL_GEOMETRY_INPUT_TYPE";
        case 0x8918: return "GL_GEOMETRY_OUTPUT_TYPE";
        case 0x8919: return "GL_SAMPLER_BINDING";
        case 0x8980: return "GL_INTERLACE_OML";
        case 0x8981: return "GL_INTERLACE_READ_OML";
        case 0x8982: return "GL_FORMAT_SUBSAMPLE_24_24_OML";
        case 0x8983: return "GL_FORMAT_SUBSAMPLE_244_244_OML";
        case 0x8984: return "GL_PACK_RESAMPLE_OML";
        case 0x8985: return "GL_UNPACK_RESAMPLE_OML";
        case 0x8986: return "GL_RESAMPLE_REPLICATE_OML";
        case 0x8987: return "GL_RESAMPLE_ZERO_FILL_OML";
        case 0x8988: return "GL_RESAMPLE_AVERAGE_OML";
        case 0x8989: return "GL_RESAMPLE_DECIMATE_OML";
        case 0x9001: return "GL_SAMPLER_BUFFER_AMD";
        case 0x9002: return "GL_INT_SAMPLER_BUFFER_AMD";
        case 0x9003: return "GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD";
        case 0x9004: return "GL_TESSELLATION_MODE_AMD";
        case 0x9005: return "GL_TESSELLATION_FACTOR_AMD";
        case 0x9006: return "GL_DISCRETE_AMD";
        case 0x9007: return "GL_CONTINUOUS_AMD";
        case 0x9009: return "GL_TEXTURE_CUBE_MAP_ARRAY";
        case 0x9010: return "GL_ALPHA_SNORM";
        case 0x9011: return "GL_LUMINANCE_SNORM";
        case 0x9012: return "GL_LUMINANCE_ALPHA_SNORM";
        case 0x9013: return "GL_INTENSITY_SNORM";
        case 0x9014: return "GL_ALPHA8_SNORM";
        case 0x9015: return "GL_LUMINANCE8_SNORM";
        case 0x9016: return "GL_LUMINANCE8_ALPHA8_SNORM";
        case 0x9017: return "GL_INTENSITY8_SNORM";
        case 0x9018: return "GL_ALPHA16_SNORM";
        case 0x9019: return "GL_LUMINANCE16_SNORM";
        case 0x9050: return "GL_IMAGE_CUBE_EXT";
        case 0x9051: return "GL_IMAGE_BUFFER_EXT";
        case 0x9052: return "GL_IMAGE_1D_ARRAY_EXT";
        case 0x9053: return "GL_IMAGE_2D_ARRAY_EXT";
        case 0x9054: return "GL_IMAGE_CUBE_MAP_ARRAY_EXT";
        case 0x9055: return "GL_IMAGE_2D_MULTISAMPLE_EXT";
        case 0x9056: return "GL_IMAGE_2D_MULTISAMPLE_ARRAY_EXT";
        case 0x9057: return "GL_INT_IMAGE_1D_EXT";
        case 0x9058: return "GL_INT_IMAGE_2D_EXT";
        case 0x9059: return "GL_INT_IMAGE_3D_EXT";
        case 0x9060: return "GL_INT_IMAGE_2D_MULTISAMPLE_EXT";
        case 0x9061: return "GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT";
        case 0x9062: return "GL_UNSIGNED_INT_IMAGE_1D_EXT";
        case 0x9063: return "GL_UNSIGNED_INT_IMAGE_2D_EXT";
        case 0x9064: return "GL_UNSIGNED_INT_IMAGE_3D_EXT";
        case 0x9065: return "GL_UNSIGNED_INT_IMAGE_2D_RECT_EXT";
        case 0x9066: return "GL_UNSIGNED_INT_IMAGE_CUBE_EXT";
        case 0x9067: return "GL_UNSIGNED_INT_IMAGE_BUFFER_EXT";
        case 0x9068: return "GL_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT";
        case 0x9069: return "GL_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT";
        case 0x9100: return "GL_TEXTURE_2D_MULTISAMPLE";
        case 0x9101: return "GL_PROXY_TEXTURE_2D_MULTISAMPLE";
        case 0x9102: return "GL_TEXTURE_2D_MULTISAMPLE_ARRAY";
        case 0x9103: return "GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY";
        case 0x9104: return "GL_TEXTURE_BINDING_2D_MULTISAMPLE";
        case 0x9105: return "GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY";
        case 0x9106: return "GL_TEXTURE_SAMPLES";
        case 0x9107: return "GL_TEXTURE_FIXED_SAMPLE_LOCATIONS";
        case 0x9108: return "GL_SAMPLER_2D_MULTISAMPLE";
        case 0x9109: return "GL_INT_SAMPLER_2D_MULTISAMPLE";
        case 0x9110: return "GL_MAX_INTEGER_SAMPLES";
        case 0x9111: return "GL_MAX_SERVER_WAIT_TIMEOUT";
        case 0x9112: return "GL_OBJECT_TYPE";
        case 0x9113: return "GL_SYNC_CONDITION";
        case 0x9114: return "GL_SYNC_STATUS";
        case 0x9115: return "GL_SYNC_FLAGS";
        case 0x9116: return "GL_SYNC_FENCE";
        case 0x9117: return "GL_SYNC_GPU_COMMANDS_COMPLETE";
        case 0x9118: return "GL_UNSIGNALED";
        case 0x9119: return "GL_SIGNALED";
        case 0x9120: return "GL_BUFFER_MAP_LENGTH";
        case 0x9121: return "GL_BUFFER_MAP_OFFSET";
        case 0x9122: return "GL_MAX_VERTEX_OUTPUT_COMPONENTS";
        case 0x9123: return "GL_MAX_GEOMETRY_INPUT_COMPONENTS";
        case 0x9124: return "GL_MAX_GEOMETRY_OUTPUT_COMPONENTS";
        case 0x9125: return "GL_MAX_FRAGMENT_INPUT_COMPONENTS";
        case 0x9126: return "GL_CONTEXT_PROFILE_MASK";
        case 0x9143: return "GL_MAX_DEBUG_MESSAGE_LENGTH_ARB";
        case 0x9144: return "GL_MAX_DEBUG_LOGGED_MESSAGES_ARB";
        case 0x9145: return "GL_DEBUG_LOGGED_MESSAGES_ARB";
        case 0x9146: return "GL_DEBUG_SEVERITY_HIGH_ARB";
        case 0x9147: return "GL_DEBUG_SEVERITY_MEDIUM_ARB";
        case 0x9148: return "GL_DEBUG_SEVERITY_LOW_ARB";
        case 0x9149: return "GL_DEBUG_CATEGORY_API_ERROR_AMD";
        case 0x9150: return "GL_DEBUG_CATEGORY_OTHER_AMD";
        case 0x9151: return "GL_DATA_BUFFER_AMD";
        case 0x9152: return "GL_PERFORMANCE_MONITOR_AMD";
        case 0x9153: return "GL_QUERY_OBJECT_AMD";
        case 0x9154: return "GL_VERTEX_ARRAY_OBJECT_AMD";
        case 0x9155: return "GL_SAMPLER_OBJECT_AMD";
    }
    return NULL;
}
