#pragma once
/*
 *      Copyright (C) 2010-2013 Team XBMC
 *      http://xbmc.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

#include "cores/AudioEngine/Interfaces/AESink.h"
#include "cores/AudioEngine/Utils/AEDeviceInfo.h"
#include "threads/CriticalSection.h"

class AERingBuffer;
namespace jni
{
class CJNIAudioTrack;
};

class CAESinkAUDIOTRACK : public IAESink
{
public:
  virtual const char *GetName() { return "AUDIOTRACK"; }

  CAESinkAUDIOTRACK();
  virtual ~CAESinkAUDIOTRACK();

  virtual bool Initialize(AEAudioFormat &format, std::string &device);
  virtual void Deinitialize();

  virtual double       GetDelay        ();
  virtual double       GetLatency      ();
  virtual double       GetCacheTotal   ();
  virtual unsigned int AddPackets      (uint8_t **data, unsigned int frames, unsigned int offset);
  virtual void         Drain           ();
  virtual bool         HasVolume       ();
  virtual void         SetVolume       (float scale);
  static void          EnumerateDevicesEx(AEDeviceInfoList &list, bool force = false);

private:
  jni::CJNIAudioTrack  *m_at_jni;
  // m_frames_written must wrap at UINT32_MAX
  uint32_t              m_frames_written;

  static CAEDeviceInfo m_info;
  AEAudioFormat      m_format;
  AEAudioFormat      m_lastFormat;
  double             m_volume;
  volatile int       m_min_frames;
  int16_t           *m_alignedS16;
  unsigned int       m_sink_frameSize;
  bool               m_passthrough;
  double             m_audiotrackbuffer_sec;
};
