/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Event;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Scrollbar;
import java.util.Vector;
import vrml.external.Browser;
import vrml.external.Node;
import vrml.external.exception.InvalidEventInException;
import vrml.external.exception.InvalidNodeException;
import vrml.external.field.EventInMFNode;

public class Tiny3D
extends Applet {
    Scrollbar transx;
    Scrollbar transy;
    Scrollbar transz;
    Scrollbar rotx;
    Scrollbar roty;
    Scrollbar rotz;
    Scrollbar scalex;
    Scrollbar scaley;
    Scrollbar scalez;
    Scrollbar colr;
    Scrollbar colg;
    Scrollbar colb;
    Browser browser;
    Node root;
    Vector clumps;
    int topIndex;
    TinyClump curClump = null;
    static int transformRange = 40;

    public boolean action(Event event, Object object) {
        block5: {
            if (!(event.target instanceof Button)) break block5;
            TinyClump tinyClump = null;
            Button button = (Button)event.target;
            if (button.getLabel() == "Cube") {
                tinyClump = new TinyClump(this, 0);
            }
            if (button.getLabel() == "Sphere") {
                tinyClump = new TinyClump(this, 1);
            }
            if (button.getLabel() == "Cone") {
                tinyClump = new TinyClump(this, 2);
            }
            this.clumps.addElement(tinyClump);
            ++this.topIndex;
            this.curClump = tinyClump;
            this.initSlidersFromClump();
            try {
                EventInMFNode eventInMFNode = (EventInMFNode)this.root.getEventIn("addChildren");
                eventInMFNode.setValue(this.curClump.transArray);
            }
            catch (InvalidEventInException invalidEventInException) {
                System.out.println("PROBLEMS!: " + (Object)((Object)invalidEventInException));
            }
        }
        return true;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public boolean handleEvent(Event event) {
        if (event.target instanceof Scrollbar) {
            Object object;
            if (this.curClump == null) {
                return true;
            }
            Scrollbar scrollbar = (Scrollbar)event.target;
            if (scrollbar == this.transx || scrollbar == this.transy || scrollbar == this.transz) {
                object = new float[]{(float)this.transx.getValue() - (float)transformRange / 2.0f, (float)this.transy.getValue() - (float)transformRange / 2.0f, (float)this.transz.getValue() - (float)transformRange / 2.0f};
                this.curClump.set_translation.setValue(object);
            }
            if (scrollbar == this.scalex || scrollbar == this.scaley || scrollbar == this.scalez) {
                object = new float[]{(float)this.scalex.getValue() / 10.0f, (float)this.scaley.getValue() / 10.0f, (float)this.scalez.getValue() / 10.0f};
                this.curClump.set_scale.setValue(object);
            }
            if (scrollbar == this.colr || scrollbar == this.colg || scrollbar == this.colb) {
                object = new float[]{(float)(255 - this.colr.getValue()) / 255.0f, (float)(255 - this.colg.getValue()) / 255.0f, (float)(255 - this.colb.getValue()) / 255.0f};
                this.curClump.set_diffuseColor.setValue(object);
            }
            if (scrollbar == this.rotx || scrollbar == this.roty || scrollbar == this.rotz) {
                this.curClump.xang = this.rotx.getValue();
                this.curClump.yang = this.roty.getValue();
                this.curClump.zang = this.rotz.getValue();
                object = new VbRotation(new VbVec3f(1.0f, 0.0f, 0.0f), (float)this.curClump.xang * ((float)Math.PI / 180));
                VbRotation vbRotation = new VbRotation(new VbVec3f(0.0f, 1.0f, 0.0f), (float)this.curClump.yang * ((float)Math.PI / 180));
                VbRotation vbRotation2 = new VbRotation(new VbVec3f(0.0f, 0.0f, 1.0f), (float)this.curClump.zang * ((float)Math.PI / 180));
                VbRotation vbRotation3 = object.times(vbRotation);
                VbRotation vbRotation4 = vbRotation3.times(vbRotation2);
                VbVec3f vbVec3f = new VbVec3f();
                float f = vbRotation4.getValue(vbVec3f);
                float[] fArray = new float[4];
                float[] fArray2 = vbVec3f.getValue();
                fArray[0] = fArray2[0];
                fArray[1] = fArray2[1];
                fArray[2] = fArray2[2];
                fArray[3] = f;
                this.curClump.set_rotation.setValue(fArray);
            }
            return true;
        }
        return super.handleEvent(event);
    }

    public void init() {
        this.clumps = new Vector();
        this.topIndex = -1;
        this.browser = Browser.getBrowser((Applet)this);
        try {
            this.root = this.browser.getNode("ROOT");
        }
        catch (InvalidNodeException invalidNodeException) {
            System.out.println("PROBLEMS!: " + (Object)((Object)invalidNodeException));
        }
        float f = 0.04f;
        float f2 = 0.04f;
        float f3 = 1.0f - f - f2;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setFont(new Font("Helvetica", 0, 12));
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = f;
        this.makeButton("Cube", gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = f3;
        this.makeLabel("Translation", gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = f2;
        this.makeLabel("Color", gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.weightx = (double)f2 / 3.0;
        this.colr = this.makeScrollbar(gridBagLayout, gridBagConstraints, 1, 0, 0, 255);
        gridBagConstraints.gridx = 6;
        this.colg = this.makeScrollbar(gridBagLayout, gridBagConstraints, 1, 0, 0, 255);
        gridBagConstraints.gridx = 7;
        this.colb = this.makeScrollbar(gridBagLayout, gridBagConstraints, 1, 0, 0, 255);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = (double)f3 / 3.0;
        this.transx = this.makeScrollbar(gridBagLayout, gridBagConstraints, 0, transformRange / 2, 0, transformRange);
        gridBagConstraints.gridx = 3;
        this.transy = this.makeScrollbar(gridBagLayout, gridBagConstraints, 0, transformRange / 2, 0, transformRange);
        gridBagConstraints.gridx = 4;
        this.transz = this.makeScrollbar(gridBagLayout, gridBagConstraints, 0, transformRange / 2, 0, transformRange);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = f;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.makeButton("Sphere", gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = f3;
        this.makeLabel("Rotation", gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = (double)f3 / 3.0;
        this.rotx = this.makeScrollbar(gridBagLayout, gridBagConstraints, 0, 0, 0, 360);
        gridBagConstraints.gridx = 3;
        this.roty = this.makeScrollbar(gridBagLayout, gridBagConstraints, 0, 0, 0, 360);
        gridBagConstraints.gridx = 4;
        this.rotz = this.makeScrollbar(gridBagLayout, gridBagConstraints, 0, 0, 0, 360);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = f;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.makeButton("Cone", gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = f3;
        this.makeLabel("Scale", gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = (double)f3 / 3.0;
        this.scalex = this.makeScrollbar(gridBagLayout, gridBagConstraints, 0, 10, 1, 100);
        gridBagConstraints.gridx = 3;
        this.scaley = this.makeScrollbar(gridBagLayout, gridBagConstraints, 0, 10, 1, 100);
        gridBagConstraints.gridx = 4;
        this.scalez = this.makeScrollbar(gridBagLayout, gridBagConstraints, 0, 10, 1, 100);
    }

    void initSlidersFromClump() {
        float[] fArray = this.curClump.scale_changed.getValue();
        this.scalex.setValue((int)(fArray[0] * 10.0f));
        this.scaley.setValue((int)(fArray[1] * 10.0f));
        this.scalez.setValue((int)(fArray[2] * 10.0f));
        fArray = this.curClump.translation_changed.getValue();
        this.transx.setValue((int)fArray[0] + transformRange / 2);
        this.transy.setValue((int)fArray[1] + transformRange / 2);
        this.transz.setValue((int)fArray[2] + transformRange / 2);
        fArray = this.curClump.diffuseColor_changed.getValue();
        this.colr.setValue(255 - (int)(fArray[0] * 255.0f));
        this.colg.setValue(255 - (int)(fArray[1] * 255.0f));
        this.colb.setValue(255 - (int)(fArray[2] * 255.0f));
        this.rotx.setValue(this.curClump.xang);
        this.roty.setValue(this.curClump.yang);
        this.rotz.setValue(this.curClump.zang);
    }

    public void makeButton(String string, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        Button button = new Button(string);
        gridBagLayout.setConstraints(button, gridBagConstraints);
        this.add(button);
    }

    public void makeCurrent(TinyClump tinyClump) {
        this.curClump = tinyClump;
        this.initSlidersFromClump();
    }

    public void makeLabel(String string, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        Label label = new Label(string, 1);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
    }

    public Scrollbar makeScrollbar(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        Scrollbar scrollbar = new Scrollbar(n, n2, 1, n3, n4);
        gridBagLayout.setConstraints(scrollbar, gridBagConstraints);
        this.add(scrollbar);
        return scrollbar;
    }
}

