/*
  $Id: Structs.h,v 1.161 2013/10/29 16:59:43 crc_canada Exp $

  Structs.h: generated by VRMLC.pm. DO NOT MODIFY, MODIFY VRMLC.pm INSTEAD.

  Code here comes almost verbatim from VRMLC.pm

*/

/****************************************************************************
    This file is part of the FreeWRL/FreeX3D Distribution.

    Copyright 2009 CRC Canada. (http://www.crc.gc.ca)

    FreeWRL/FreeX3D is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FreeWRL/FreeX3D is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FreeWRL/FreeX3D.  If not, see <http://www.gnu.org/licenses/>.
****************************************************************************/



#ifndef __FREEWRL_STRUCTS_H__
#define __FREEWRL_STRUCTS_H__

#include <system_threads.h>
struct point_XYZ {GLDOUBLE x,y,z;};
struct orient_XYZA {GLDOUBLE x,y,z,a;};

struct X3D_Virt {
	void (*prep)(void *);
	void (*rend)(void *);
	void (*children)(void *);
	void (*fin)(void *);
	void (*rendray)(void *);
	void (*mkpolyrep)(void *);
	void (*proximity)(void *);
	void (*other)(void *);
	void (*collision)(void *);
	void (*compile)(void *, void *, void *, void *, void *);
};

/* a string is stored as a pointer, and a length of that mallocd pointer */
struct Uni_String {
	int len;
	char * strptr;
	int touched;
};

/* Internal representation of IndexedFaceSet, Text, Extrusion & ElevationGrid:
 * set of triangles.
 * done so that we get rid of concave polygons etc.
 */
struct X3D_PolyRep { /* Currently a bit wasteful, because copying */
	int irep_change;
	int ccw;	/* ccw field for single faced structures */
	int ntri; /* number of triangles */
	int streamed;	/* is this done the streaming pass? */

	/* indicies for arrays. OpenGL ES 2.0 - unsigned short for the DrawArrays call */
	GLuint *cindex;   /* triples (per triangle) */
	GLuint *colindex;   /* triples (per triangle) */
	GLuint *norindex;
        GLuint *tcindex; /* triples or null */

	float *actualCoord; /* triples (per point) */
	float *color; /* triples or null */
	float *normal; /* triples or null */
        float *GeneratedTexCoords;	/* triples (per triangle) of texture coords if there is no texCoord node */
	int tcoordtype; /* type of texture coord node - is this a NODE_TextureCoordGenerator... */
	int texgentype; /* if we do have a TextureCoordinateGenerator, what "TCGT_XXX" type is it? */
	GLfloat minVals[3];		/* for collision and default texture coord generation */
	GLfloat maxVals[3];		/* for collision and default texture coord generation */
	GLfloat transparency;		/* what the transparency value was during compile, put in color array if RGBA colors */
	int isRGBAcolorNode;		/* color was originally an RGBA, DO NOT re-write if transparency changes */
	GLuint VBO_buffers[VBO_COUNT];		/* VBO indexen */
};

/* viewer dimentions (for collision detection) */
struct sNaviInfo {
        double width;
        double height;
        double step;
};

/* definitions to help scanning values in from a string */ 
#define SCANTONUMBER(value) while (isspace(*value) || (*value==',')) value++; 
#define SCANTOSTRING(value) while (isspace(*value) || (*value==',')) value++; 
#define OLDSCANTOSTRING(value) while ((*value==' ') || (*value==',')) value++; 
#define ISSTARTNUMBER(value) (isdigit(*value) \
		|| (*value == '+') || (*value == '-')) 
#define SCANPASTFLOATNUMBER(value) while (isdigit(*value) \
		|| (*value == '.') || \
		(*value == 'E') || (*value == 'e') || (*value == '+') || (*value == '-')) value++; 
#define SCANPASTINTNUMBER(value) if (isdigit(*value) || (*value == '-') || (*value == '+')) value++; \
		while (isdigit(*value) || \
		(*value == 'x') || (*value == 'X') ||\
		((*value >='a') && (*value <='f')) || \
		((*value >='A') && (*value <='F')) || \
		(*value == '-') || (*value == '+')) value++; 
/* Data type for index into ID-table. */
typedef int indexT;

#define NODE_Anchor	0
#define NODE_Appearance	1
#define NODE_Arc2D	2
#define NODE_ArcClose2D	3
#define NODE_AudioClip	4
#define NODE_Background	5
#define NODE_Billboard	6
#define NODE_BooleanFilter	7
#define NODE_BooleanSequencer	8
#define NODE_BooleanToggle	9
#define NODE_BooleanTrigger	10
#define NODE_Box	11
#define NODE_CADAssembly	12
#define NODE_CADFace	13
#define NODE_CADLayer	14
#define NODE_CADPart	15
#define NODE_Circle2D	16
#define NODE_ClipPlane	17
#define NODE_Collision	18
#define NODE_Color	19
#define NODE_ColorInterpolator	20
#define NODE_ColorRGBA	21
#define NODE_ComposedCubeMapTexture	22
#define NODE_ComposedShader	23
#define NODE_Cone	24
#define NODE_Contour2D	25
#define NODE_ContourPolyLine2D	26
#define NODE_Coordinate	27
#define NODE_CoordinateDouble	28
#define NODE_CoordinateInterpolator	29
#define NODE_CoordinateInterpolator2D	30
#define NODE_Cylinder	31
#define NODE_CylinderSensor	32
#define NODE_DISEntityManager	33
#define NODE_DISEntityTypeMapping	34
#define NODE_DirectionalLight	35
#define NODE_Disk2D	36
#define NODE_EaseInEaseOut	37
#define NODE_ElevationGrid	38
#define NODE_EspduTransform	39
#define NODE_Extrusion	40
#define NODE_FillProperties	41
#define NODE_FloatVertexAttribute	42
#define NODE_Fog	43
#define NODE_FogCoordinate	44
#define NODE_FontStyle	45
#define NODE_GeneratedCubeMapTexture	46
#define NODE_GeoCoordinate	47
#define NODE_GeoElevationGrid	48
#define NODE_GeoLOD	49
#define NODE_GeoLocation	50
#define NODE_GeoMetadata	51
#define NODE_GeoOrigin	52
#define NODE_GeoPositionInterpolator	53
#define NODE_GeoProximitySensor	54
#define NODE_GeoTouchSensor	55
#define NODE_GeoTransform	56
#define NODE_GeoViewpoint	57
#define NODE_Group	58
#define NODE_HAnimDisplacer	59
#define NODE_HAnimHumanoid	60
#define NODE_HAnimJoint	61
#define NODE_HAnimSegment	62
#define NODE_HAnimSite	63
#define NODE_ImageCubeMapTexture	64
#define NODE_ImageTexture	65
#define NODE_IndexedFaceSet	66
#define NODE_IndexedLineSet	67
#define NODE_IndexedQuadSet	68
#define NODE_IndexedTriangleFanSet	69
#define NODE_IndexedTriangleSet	70
#define NODE_IndexedTriangleStripSet	71
#define NODE_Inline	72
#define NODE_IntegerSequencer	73
#define NODE_IntegerTrigger	74
#define NODE_KeySensor	75
#define NODE_LOD	76
#define NODE_LineProperties	77
#define NODE_LineSet	78
#define NODE_LoadSensor	79
#define NODE_LocalFog	80
#define NODE_Material	81
#define NODE_Matrix3VertexAttribute	82
#define NODE_Matrix4VertexAttribute	83
#define NODE_MetadataDouble	84
#define NODE_MetadataFloat	85
#define NODE_MetadataInteger	86
#define NODE_MetadataMFBool	87
#define NODE_MetadataMFColor	88
#define NODE_MetadataMFColorRGBA	89
#define NODE_MetadataMFDouble	90
#define NODE_MetadataMFFloat	91
#define NODE_MetadataMFInt32	92
#define NODE_MetadataMFMatrix3d	93
#define NODE_MetadataMFMatrix3f	94
#define NODE_MetadataMFMatrix4d	95
#define NODE_MetadataMFMatrix4f	96
#define NODE_MetadataMFNode	97
#define NODE_MetadataMFRotation	98
#define NODE_MetadataMFString	99
#define NODE_MetadataMFTime	100
#define NODE_MetadataMFVec2d	101
#define NODE_MetadataMFVec2f	102
#define NODE_MetadataMFVec3d	103
#define NODE_MetadataMFVec3f	104
#define NODE_MetadataMFVec4d	105
#define NODE_MetadataMFVec4f	106
#define NODE_MetadataSFBool	107
#define NODE_MetadataSFColor	108
#define NODE_MetadataSFColorRGBA	109
#define NODE_MetadataSFDouble	110
#define NODE_MetadataSFFloat	111
#define NODE_MetadataSFImage	112
#define NODE_MetadataSFInt32	113
#define NODE_MetadataSFMatrix3d	114
#define NODE_MetadataSFMatrix3f	115
#define NODE_MetadataSFMatrix4d	116
#define NODE_MetadataSFMatrix4f	117
#define NODE_MetadataSFNode	118
#define NODE_MetadataSFRotation	119
#define NODE_MetadataSFString	120
#define NODE_MetadataSFTime	121
#define NODE_MetadataSFVec2d	122
#define NODE_MetadataSFVec2f	123
#define NODE_MetadataSFVec3d	124
#define NODE_MetadataSFVec3f	125
#define NODE_MetadataSFVec4d	126
#define NODE_MetadataSFVec4f	127
#define NODE_MetadataSet	128
#define NODE_MetadataString	129
#define NODE_MovieTexture	130
#define NODE_MultiTexture	131
#define NODE_MultiTextureCoordinate	132
#define NODE_MultiTextureTransform	133
#define NODE_NavigationInfo	134
#define NODE_Normal	135
#define NODE_NormalInterpolator	136
#define NODE_NurbsCurve	137
#define NODE_NurbsCurve2D	138
#define NODE_NurbsOrientationInterpolator	139
#define NODE_NurbsPatchSurface	140
#define NODE_NurbsPositionInterpolator	141
#define NODE_NurbsSet	142
#define NODE_NurbsSurfaceInterpolator	143
#define NODE_NurbsSweptSurface	144
#define NODE_NurbsSwungSurface	145
#define NODE_NurbsTextureCoordinate	146
#define NODE_NurbsTrimmedSurface	147
#define NODE_OSC_Sensor	148
#define NODE_OrientationInterpolator	149
#define NODE_OrthoViewpoint	150
#define NODE_PackagedShader	151
#define NODE_PickableGroup	152
#define NODE_PixelTexture	153
#define NODE_PlaneSensor	154
#define NODE_PointLight	155
#define NODE_PointPickSensor	156
#define NODE_PointSet	157
#define NODE_Polyline2D	158
#define NODE_Polypoint2D	159
#define NODE_PositionInterpolator	160
#define NODE_PositionInterpolator2D	161
#define NODE_ProgramShader	162
#define NODE_Proto	163
#define NODE_ProximitySensor	164
#define NODE_QuadSet	165
#define NODE_ReceiverPdu	166
#define NODE_Rectangle2D	167
#define NODE_ScalarInterpolator	168
#define NODE_Script	169
#define NODE_ShaderPart	170
#define NODE_ShaderProgram	171
#define NODE_Shape	172
#define NODE_SignalPdu	173
#define NODE_Sound	174
#define NODE_Sphere	175
#define NODE_SphereSensor	176
#define NODE_SplinePositionInterpolator	177
#define NODE_SplinePositionInterpolator2D	178
#define NODE_SplineScalarInterpolator	179
#define NODE_SpotLight	180
#define NODE_SquadOrientationInterpolator	181
#define NODE_StaticGroup	182
#define NODE_StringSensor	183
#define NODE_Switch	184
#define NODE_Text	185
#define NODE_TextureBackground	186
#define NODE_TextureCoordinate	187
#define NODE_TextureCoordinateGenerator	188
#define NODE_TextureProperties	189
#define NODE_TextureTransform	190
#define NODE_TimeSensor	191
#define NODE_TimeTrigger	192
#define NODE_TouchSensor	193
#define NODE_Transform	194
#define NODE_TransmitterPdu	195
#define NODE_TriangleFanSet	196
#define NODE_TriangleSet	197
#define NODE_TriangleSet2D	198
#define NODE_TriangleStripSet	199
#define NODE_TwoSidedMaterial	200
#define NODE_Viewpoint	201
#define NODE_ViewpointGroup	202
#define NODE_VisibilitySensor	203
#define NODE_WorldInfo	204


/* Table of built-in fieldIds */
extern const char *FIELDNAMES[];
extern const int FIELDNAMES_COUNT;
#define FIELDNAMES__sideVBO	0
#define FIELDNAMES_integerKey	1
#define FIELDNAMES___proxNode	2
#define FIELDNAMES_activate	3
#define FIELDNAMES_rootNode	4
#define FIELDNAMES_munitionSiteID	5
#define FIELDNAMES_modulationTypeMajor	6
#define FIELDNAMES_whichChoice	7
#define FIELDNAMES_load	8
#define FIELDNAMES_isLoaded	9
#define FIELDNAMES_rotation	10
#define FIELDNAMES_toggle	11
#define FIELDNAMES_set_articulationParameterValue7	12
#define FIELDNAMES_trajectoryCurve	13
#define FIELDNAMES_set_articulationParameterValue3	14
#define FIELDNAMES_title	15
#define FIELDNAMES_geoGridOrigin	16
#define FIELDNAMES___child4Node	17
#define FIELDNAMES_stripCount	18
#define FIELDNAMES_groundColor	19
#define FIELDNAMES_direction	20
#define FIELDNAMES_previous	21
#define FIELDNAMES_transmitterSiteID	22
#define FIELDNAMES_transmitterRadioID	23
#define FIELDNAMES_detonationResult	24
#define FIELDNAMES_maxPosition	25
#define FIELDNAMES_removeChildren	26
#define FIELDNAMES_vClosed	27
#define FIELDNAMES_skin	28
#define FIELDNAMES_speedFactor	29
#define FIELDNAMES_detonateTime	30
#define FIELDNAMES_entityKind	31
#define FIELDNAMES_transmitterEntityID	32
#define FIELDNAMES_retainUserOffsets	33
#define FIELDNAMES_vertices	34
#define FIELDNAMES___children	35
#define FIELDNAMES___do_scale	36
#define FIELDNAMES_left	37
#define FIELDNAMES___sidepoints	38
#define FIELDNAMES_inputTrue	39
#define FIELDNAMES___localFileName	40
#define FIELDNAMES___prototype	41
#define FIELDNAMES_backAmbientIntensity	42
#define FIELDNAMES_exitTime	43
#define FIELDNAMES_joints	44
#define FIELDNAMES__oldhitNormal	45
#define FIELDNAMES_articulationParameterArray	46
#define FIELDNAMES_deletionAllowed	47
#define FIELDNAMES_address	48
#define FIELDNAMES_translation	49
#define FIELDNAMES___inRange	50
#define FIELDNAMES_articulationParameterValue6_changed	51
#define FIELDNAMES_child2Url	52
#define FIELDNAMES_limitOrientation	53
#define FIELDNAMES_skeleton	54
#define FIELDNAMES___cylinderTriangles	55
#define FIELDNAMES__oldhitPoint	56
#define FIELDNAMES_addTrimmingContour	57
#define FIELDNAMES_set_articulationParameterValue1	58
#define FIELDNAMES_type	59
#define FIELDNAMES_writeInterval	60
#define FIELDNAMES_entityID	61
#define FIELDNAMES_fired2	62
#define FIELDNAMES__talkToNodes	63
#define FIELDNAMES__verifiedBackColor	64
#define FIELDNAMES__bboxCenter	65
#define FIELDNAMES_creaseAngle	66
#define FIELDNAMES_triggerTime	67
#define FIELDNAMES_crossSectionCurve	68
#define FIELDNAMES_displacers	69
#define FIELDNAMES_isActive	70
#define FIELDNAMES___childloadstatus	71
#define FIELDNAMES_articulationParameterValue2_changed	72
#define FIELDNAMES_bboxCenter	73
#define FIELDNAMES_xDimension	74
#define FIELDNAMES_centerOfMass	75
#define FIELDNAMES_set_orientation	76
#define FIELDNAMES_set_position	77
#define FIELDNAMES_solid	78
#define FIELDNAMES_mode	79
#define FIELDNAMES___DEFnames	80
#define FIELDNAMES___textureTableIndex	81
#define FIELDNAMES_isRtpHeaderHeard	82
#define FIELDNAMES_on	83
#define FIELDNAMES_leftUrl	84
#define FIELDNAMES_warhead	85
#define FIELDNAMES___do_anything	86
#define FIELDNAMES_sortOrder	87
#define FIELDNAMES_isOver	88
#define FIELDNAMES_shininess	89
#define FIELDNAMES_texturePriority	90
#define FIELDNAMES_description	91
#define FIELDNAMES_top	92
#define FIELDNAMES_outerRadius	93
#define FIELDNAMES_fuse	94
#define FIELDNAMES_set_articulationParameterValue4	95
#define FIELDNAMES_touchTime	96
#define FIELDNAMES_int32Inp	97
#define FIELDNAMES_family	98
#define FIELDNAMES_source	99
#define FIELDNAMES_skinNormal	100
#define FIELDNAMES_front	101
#define FIELDNAMES_leftToRight	102
#define FIELDNAMES_linearVelocity	103
#define FIELDNAMES__loc	104
#define FIELDNAMES_entityDomain	105
#define FIELDNAMES___occludeCheckCount	106
#define FIELDNAMES_boundaryModeT	107
#define FIELDNAMES_summary	108
#define FIELDNAMES_transmitState	109
#define FIELDNAMES_info	110
#define FIELDNAMES_tdlType	111
#define FIELDNAMES__dlchange	112
#define FIELDNAMES_marking	113
#define FIELDNAMES_backSpecularColor	114
#define FIELDNAMES_ambientIntensity	115
#define FIELDNAMES_floatInp	116
#define FIELDNAMES_headlight	117
#define FIELDNAMES___protoDeclares	118
#define FIELDNAMES__bboxSize	119
#define FIELDNAMES_radioEntityTypeKind	120
#define FIELDNAMES_cycleInterval	121
#define FIELDNAMES_mass	122
#define FIELDNAMES_pickedGeometry	123
#define FIELDNAMES_pitch	124
#define FIELDNAMES_rotateYUp	125
#define FIELDNAMES_articulationParameterTypeArray	126
#define FIELDNAMES_bottomTexture	127
#define FIELDNAMES___oldJump	128
#define FIELDNAMES_sites	129
#define FIELDNAMES_encodingScheme	130
#define FIELDNAMES_uOrder	131
#define FIELDNAMES_fired1	132
#define FIELDNAMES__rotationAngle	133
#define FIELDNAMES___t2	134
#define FIELDNAMES_parameter	135
#define FIELDNAMES_borderWidth	136
#define FIELDNAMES_backTransparency	137
#define FIELDNAMES_generateMipMaps	138
#define FIELDNAMES_tessellation	139
#define FIELDNAMES_scale	140
#define FIELDNAMES_proxy	141
#define FIELDNAMES_translation_changed	142
#define FIELDNAMES___numPoints	143
#define FIELDNAMES__floatInpFIFO	144
#define FIELDNAMES_maxFront	145
#define FIELDNAMES_rightTexture	146
#define FIELDNAMES_set_spine	147
#define FIELDNAMES___t1	148
#define FIELDNAMES_rotation_changed	149
#define FIELDNAMES___textureright	150
#define FIELDNAMES_skinCoordWeight	151
#define FIELDNAMES_plane	152
#define FIELDNAMES_radius	153
#define FIELDNAMES_articulationParameterValue7_changed	154
#define FIELDNAMES_controlPoint	155
#define FIELDNAMES_point	156
#define FIELDNAMES_inputSource	157
#define FIELDNAMES_radioEntityTypeNomenclatureVersion	158
#define FIELDNAMES__int32InpFIFO	159
#define FIELDNAMES_normal	160
#define FIELDNAMES___leftTexture	161
#define FIELDNAMES_articulationParameterChangeIndicatorArr	162
#define FIELDNAMES_firingRate	163
#define FIELDNAMES__oldrotation	164
#define FIELDNAMES_eventNumber	165
#define FIELDNAMES_loop	166
#define FIELDNAMES_actionKeyPress	167
#define FIELDNAMES_extra	168
#define FIELDNAMES_horizontal	169
#define FIELDNAMES_enabled	170
#define FIELDNAMES__colourSize	171
#define FIELDNAMES_pickedPoint	172
#define FIELDNAMES_fanCount	173
#define FIELDNAMES___child2Node	174
#define FIELDNAMES_triggerTrue	175
#define FIELDNAMES__parentResource	176
#define FIELDNAMES_articulationParameterCount	177
#define FIELDNAMES_avatarSize	178
#define FIELDNAMES_collide	179
#define FIELDNAMES_specularColor	180
#define FIELDNAMES_transitionTime	181
#define FIELDNAMES__coloursVBO	182
#define FIELDNAMES_siteID	183
#define FIELDNAMES_color	184
#define FIELDNAMES_axisOfRotation	185
#define FIELDNAMES_networkMode	186
#define FIELDNAMES_backEmissiveColor	187
#define FIELDNAMES_repeatT	188
#define FIELDNAMES___visible	189
#define FIELDNAMES_visible	190
#define FIELDNAMES___movedPosition	191
#define FIELDNAMES_topToBottom	192
#define FIELDNAMES_viewpoints	193
#define FIELDNAMES_FreeWRL__protoDef	194
#define FIELDNAMES_length	195
#define FIELDNAMES___SphereIndxVBO	196
#define FIELDNAMES_index	197
#define FIELDNAMES___oldFieldOfView	198
#define FIELDNAMES_intensity	199
#define FIELDNAMES_navType	200
#define FIELDNAMES_update	201
#define FIELDNAMES_set_articulationParameterValue5	202
#define FIELDNAMES__oldisActive	203
#define FIELDNAMES___loading	204
#define FIELDNAMES_next	205
#define FIELDNAMES___level	206
#define FIELDNAMES_isPaused	207
#define FIELDNAMES__oldpickedPoint	208
#define FIELDNAMES_FIFOsize	209
#define FIELDNAMES_value	210
#define FIELDNAMES_articulationParameterIdPartAttachedToAr	211
#define FIELDNAMES___child1Node	212
#define FIELDNAMES_multicastRelayHost	213
#define FIELDNAMES___scriptObj	214
#define FIELDNAMES_keyRelease	215
#define FIELDNAMES___backTexture	216
#define FIELDNAMES_stopTime	217
#define FIELDNAMES_crossSection	218
#define FIELDNAMES_position	219
#define FIELDNAMES___solid	220
#define FIELDNAMES___do_scaleO	221
#define FIELDNAMES_xSpacing	222
#define FIELDNAMES___transparency	223
#define FIELDNAMES_isDetonated	224
#define FIELDNAMES_scaleOrientation	225
#define FIELDNAMES___ctflag	226
#define FIELDNAMES_inputFalse	227
#define FIELDNAMES_bottomUrl	228
#define FIELDNAMES_radioID	229
#define FIELDNAMES_hitPoint_changed	230
#define FIELDNAMES_boundaryModeS	231
#define FIELDNAMES__sortedChildren	232
#define FIELDNAMES_set_normalIndex	233
#define FIELDNAMES_knot	234
#define FIELDNAMES_articulationParameterValue4_changed	235
#define FIELDNAMES_set_articulationParameterValue6	236
#define FIELDNAMES_fogType	237
#define FIELDNAMES_spacing	238
#define FIELDNAMES_skyColor	239
#define FIELDNAMES__oldtranslation	240
#define FIELDNAMES_displacements	241
#define FIELDNAMES_isStandAlone	242
#define FIELDNAMES_topUrl	243
#define FIELDNAMES___colours	244
#define FIELDNAMES_geoSystem	245
#define FIELDNAMES_addChildren	246
#define FIELDNAMES_detonationLocation	247
#define FIELDNAMES_attenuation	248
#define FIELDNAMES_fireMissionIndex	249
#define FIELDNAMES_trimmingContour	250
#define FIELDNAMES_articulationParameterValue3_changed	251
#define FIELDNAMES_endAngle	252
#define FIELDNAMES___oldKeyPtr	253
#define FIELDNAMES_displayed	254
#define FIELDNAMES_hitGeoCoord_changed	255
#define FIELDNAMES_cycleTime	256
#define FIELDNAMES_boundaryModeR	257
#define FIELDNAMES___oldChildren	258
#define FIELDNAMES_applied	259
#define FIELDNAMES_backTexture	260
#define FIELDNAMES_function	261
#define FIELDNAMES_setValue	262
#define FIELDNAMES_isNetworkWriter	263
#define FIELDNAMES_hitTexCoord_changed	264
#define FIELDNAMES_alpha	265
#define FIELDNAMES_enteredText	266
#define FIELDNAMES__origNormalizedPoint	267
#define FIELDNAMES_repeatS	268
#define FIELDNAMES___do_trans	269
#define FIELDNAMES__origPoint	270
#define FIELDNAMES_backDiffuseColor	271
#define FIELDNAMES_bboxSize	272
#define FIELDNAMES_country	273
#define FIELDNAMES_removeGeometry	274
#define FIELDNAMES_visibilityRange	275
#define FIELDNAMES_textBounds	276
#define FIELDNAMES_munitionStartPoint	277
#define FIELDNAMES__npoints	278
#define FIELDNAMES_skinCoordIndex	279
#define FIELDNAMES__retrievedURLData	280
#define FIELDNAMES__coordIndex	281
#define FIELDNAMES_priority	282
#define FIELDNAMES_linetype	283
#define FIELDNAMES__oldtrackPoint	284
#define FIELDNAMES_receiverState	285
#define FIELDNAMES_addedEntities	286
#define FIELDNAMES_eventEntityID	287
#define FIELDNAMES_normal_changed	288
#define FIELDNAMES_spatialize	289
#define FIELDNAMES_articulationParameterValue5_changed	290
#define FIELDNAMES_normalizeVelocity	291
#define FIELDNAMES_geoOrigin	292
#define FIELDNAMES___do_center	293
#define FIELDNAMES_metadata	294
#define FIELDNAMES_geoCoords	295
#define FIELDNAMES_relativeAntennaLocation	296
#define FIELDNAMES_location	297
#define FIELDNAMES_colorPerVertex	298
#define FIELDNAMES_origin	299
#define FIELDNAMES__children	300
#define FIELDNAMES_jump	301
#define FIELDNAMES_directOutput	302
#define FIELDNAMES_port	303
#define FIELDNAMES___oldgeoCoords	304
#define FIELDNAMES_timeOut	305
#define FIELDNAMES_hitNormal_changed	306
#define FIELDNAMES_shape	307
#define FIELDNAMES_skyAngle	308
#define FIELDNAMES_closureType	309
#define FIELDNAMES___finishedloading	310
#define FIELDNAMES_enterTime	311
#define FIELDNAMES___rooturlloadstatus	312
#define FIELDNAMES_center	313
#define FIELDNAMES_munitionEntityID	314
#define FIELDNAMES___ROUTES	315
#define FIELDNAMES_altKey	316
#define FIELDNAMES_spine	317
#define FIELDNAMES_offset	318
#define FIELDNAMES___StartLoadTime	319
#define FIELDNAMES_cryptoSystem	320
#define FIELDNAMES___points	321
#define FIELDNAMES_cryptoKeyID	322
#define FIELDNAMES_anisotropicDegree	323
#define FIELDNAMES_parts	324
#define FIELDNAMES_keyVelocity	325
#define FIELDNAMES_collisionType	326
#define FIELDNAMES___simpleDisk	327
#define FIELDNAMES_normalPerVertex	328
#define FIELDNAMES_topTexture	329
#define FIELDNAMES_position_changed	330
#define FIELDNAMES__initialized	331
#define FIELDNAMES___hit	332
#define FIELDNAMES_set_articulationParameterValue0	333
#define FIELDNAMES_power	334
#define FIELDNAMES_category	335
#define FIELDNAMES_maxBack	336
#define FIELDNAMES_vector	337
#define FIELDNAMES_sampleRate	338
#define FIELDNAMES_modifiedFraction_changed	339
#define FIELDNAMES_firingRange	340
#define FIELDNAMES_geoCoord_changed	341
#define FIELDNAMES_set_index	342
#define FIELDNAMES_stiffness	343
#define FIELDNAMES___segCount	344
#define FIELDNAMES_samples	345
#define FIELDNAMES_detonationRelativeLocation	346
#define FIELDNAMES_minificationFilter	347
#define FIELDNAMES_attrib	348
#define FIELDNAMES_radioEntityTypeCountry	349
#define FIELDNAMES_child4Url	350
#define FIELDNAMES___IS	351
#define FIELDNAMES_uClosed	352
#define FIELDNAMES_vDimension	353
#define FIELDNAMES_rightUrl	354
#define FIELDNAMES_time	355
#define FIELDNAMES_deadReckoning	356
#define FIELDNAMES_fraction_changed	357
#define FIELDNAMES_segments	358
#define FIELDNAMES_texture	359
#define FIELDNAMES_programs	360
#define FIELDNAMES_speed	361
#define FIELDNAMES_objectType	362
#define FIELDNAMES_fillProperties	363
#define FIELDNAMES___VBO	364
#define FIELDNAMES_maxAngle	365
#define FIELDNAMES___movedValue	366
#define FIELDNAMES_modulationTypeSpreadSpectrum	367
#define FIELDNAMES_version	368
#define FIELDNAMES___loadResource	369
#define FIELDNAMES_image	370
#define FIELDNAMES___cylinderVBO	371
#define FIELDNAMES_vTesselation	372
#define FIELDNAMES___botpoints	373
#define FIELDNAMES_receivedPower	374
#define FIELDNAMES_set_crossSection	375
#define FIELDNAMES___subTextures	376
#define FIELDNAMES_levelChanged	377
#define FIELDNAMES_colorIndex	378
#define FIELDNAMES_duration_changed	379
#define FIELDNAMES_order	380
#define FIELDNAMES_geometry	381
#define FIELDNAMES_multicastRelayPort	382
#define FIELDNAMES_textureProperties	383
#define FIELDNAMES_watchList	384
#define FIELDNAMES__oldpickTarget	385
#define FIELDNAMES_lineProperties	386
#define FIELDNAMES__dir	387
#define FIELDNAMES_data	388
#define FIELDNAMES_centerOfRotation	389
#define FIELDNAMES_minBack	390
#define FIELDNAMES___vertIndx	391
#define FIELDNAMES_backShininess	392
#define FIELDNAMES___movedCoords	393
#define FIELDNAMES__int32OutFIFO	394
#define FIELDNAMES___isX3D	395
#define FIELDNAMES_closed	396
#define FIELDNAMES_applicationID	397
#define FIELDNAMES_eventApplicationID	398
#define FIELDNAMES___vertArr	399
#define FIELDNAMES___coneTriangles	400
#define FIELDNAMES_trackPoint_changed	401
#define FIELDNAMES_global	402
#define FIELDNAMES_vTessellation	403
#define FIELDNAMES_back	404
#define FIELDNAMES_tickTime	405
#define FIELDNAMES_uDimension	406
#define FIELDNAMES_articulationParameterValue0_changed	407
#define FIELDNAMES___rightTexture	408
#define FIELDNAMES___protoFlags	409
#define FIELDNAMES__pointsVBO	410
#define FIELDNAMES_geoCenter	411
#define FIELDNAMES_emissiveColor	412
#define FIELDNAMES_antennaPatternLength	413
#define FIELDNAMES_filled	414
#define FIELDNAMES_groundAngle	415
#define FIELDNAMES_mapping	416
#define FIELDNAMES__shaderUserNumber	417
#define FIELDNAMES_isValid	418
#define FIELDNAMES_string	419
#define FIELDNAMES_children	420
#define FIELDNAMES_isBound	421
#define FIELDNAMES_triggerValue	422
#define FIELDNAMES___bottomTexture	423
#define FIELDNAMES_controlKey	424
#define FIELDNAMES_textureCompression	425
#define FIELDNAMES_frontTexture	426
#define FIELDNAMES_entityCategory	427
#define FIELDNAMES_centerOfRotation_changed	428
#define FIELDNAMES_diskAngle	429
#define FIELDNAMES___Samples	430
#define FIELDNAMES__enabled	431
#define FIELDNAMES_transmitFrequencyBandwidth	432
#define FIELDNAMES___do_rotation	433
#define FIELDNAMES_dataLength	434
#define FIELDNAMES_radioEntityTypeCategory	435
#define FIELDNAMES_set_fraction	436
#define FIELDNAMES_subcategory	437
#define FIELDNAMES_transitionComplete	438
#define FIELDNAMES_specific	439
#define FIELDNAMES___inittime	440
#define FIELDNAMES__status	441
#define FIELDNAMES_backUrl	442
#define FIELDNAMES_set_sortOrder	443
#define FIELDNAMES_size	444
#define FIELDNAMES_maxExtent	445
#define FIELDNAMES_domain	446
#define FIELDNAMES_kind	447
#define FIELDNAMES_orientation_changed	448
#define FIELDNAMES___regenSubTextures	449
#define FIELDNAMES_readInterval	450
#define FIELDNAMES___child3Node	451
#define FIELDNAMES_addGeometry	452
#define FIELDNAMES_style	453
#define FIELDNAMES_radioEntityTypeDomain	454
#define FIELDNAMES_bottom	455
#define FIELDNAMES_hatchColor	456
#define FIELDNAMES_justify	457
#define FIELDNAMES_removedEntities	458
#define FIELDNAMES_modulationTypeSystem	459
#define FIELDNAMES_side	460
#define FIELDNAMES_frontUrl	461
#define FIELDNAMES__stringInpFIFO	462
#define FIELDNAMES_modulationTypeDetail	463
#define FIELDNAMES_separateBackColor	464
#define FIELDNAMES___rootUrl	465
#define FIELDNAMES_profileCurve	466
#define FIELDNAMES__verifiedFrontColor	467
#define FIELDNAMES_bindTime	468
#define FIELDNAMES_depth	469
#define FIELDNAMES_set_boolean	470
#define FIELDNAMES__col	471
#define FIELDNAMES_gotEvents	472
#define FIELDNAMES_fieldOfView	473
#define FIELDNAMES___oldHeadlight	474
#define FIELDNAMES_listenfor	475
#define FIELDNAMES_borderColor	476
#define FIELDNAMES_set_height	477
#define FIELDNAMES_child1Url	478
#define FIELDNAMES_endCap	479
#define FIELDNAMES_set_colorIndex	480
#define FIELDNAMES_reference	481
#define FIELDNAMES_uTessellation	482
#define FIELDNAMES___normals	483
#define FIELDNAMES_set_triggerTime	484
#define FIELDNAMES__oldhitTexCoord	485
#define FIELDNAMES__oldpickedGeometry	486
#define FIELDNAMES_value_changed	487
#define FIELDNAMES___oldKeyValuePtr	488
#define FIELDNAMES_keyValue	489
#define FIELDNAMES_bottomRadius	490
#define FIELDNAMES_mustEvaluate	491
#define FIELDNAMES_diffuseColor	492
#define FIELDNAMES_tessellationScale	493
#define FIELDNAMES_handler	494
#define FIELDNAMES___oldmetadata	495
#define FIELDNAMES_inputNegate	496
#define FIELDNAMES_entitySpecific	497
#define FIELDNAMES_set_articulationParameterValue2	498
#define FIELDNAMES_key	499
#define FIELDNAMES_ulimit	500
#define FIELDNAMES___quadcount	501
#define FIELDNAMES_skinCoord	502
#define FIELDNAMES_yScale	503
#define FIELDNAMES___oldEnabled	504
#define FIELDNAMES___movedOrientation	505
#define FIELDNAMES_name	506
#define FIELDNAMES_texCoord	507
#define FIELDNAMES_pickable	508
#define FIELDNAMES___coneVBO	509
#define FIELDNAMES_lineBounds	510
#define FIELDNAMES_hatched	511
#define FIELDNAMES_uTesselation	512
#define FIELDNAMES_easeInEaseOut	513
#define FIELDNAMES__shaderUserDefinedFields	514
#define FIELDNAMES_level_changed	515
#define FIELDNAMES___texCoords	516
#define FIELDNAMES_geovalue_changed	517
#define FIELDNAMES__shaderTableEntry	518
#define FIELDNAMES_texCoordIndex	519
#define FIELDNAMES_vKnot	520
#define FIELDNAMES_intersectionType	521
#define FIELDNAMES_beginCap	522
#define FIELDNAMES_linearAcceleration	523
#define FIELDNAMES_transparency	524
#define FIELDNAMES___vertexCount	525
#define FIELDNAMES_set_bind	526
#define FIELDNAMES_textureTransform	527
#define FIELDNAMES___sourceNumber	528
#define FIELDNAMES_progress	529
#define FIELDNAMES_lengthOfModulationParameters	530
#define FIELDNAMES_height	531
#define FIELDNAMES_right	532
#define FIELDNAMES_pickingGeometry	533
#define FIELDNAMES_entityCountry	534
#define FIELDNAMES___localOrient	535
#define FIELDNAMES_protocol	536
#define FIELDNAMES_isNetworkReader	537
#define FIELDNAMES_uKnot	538
#define FIELDNAMES_antennaPatternType	539
#define FIELDNAMES_startAngle	540
#define FIELDNAMES_minAngle	541
#define FIELDNAMES_weight	542
#define FIELDNAMES_talksTo	543
#define FIELDNAMES_visibilityLimit	544
#define FIELDNAMES_munitionApplicationID	545
#define FIELDNAMES_firedTime	546
#define FIELDNAMES_forceID	547
#define FIELDNAMES__hatchScale	548
#define FIELDNAMES_articulationParameterDesignatorArray	549
#define FIELDNAMES___protoDef	550
#define FIELDNAMES__verifiedColor	551
#define FIELDNAMES___oldSize	552
#define FIELDNAMES__radius	553
#define FIELDNAMES_collideTime	554
#define FIELDNAMES___loadstatus	555
#define FIELDNAMES_magnificationFilter	556
#define FIELDNAMES__shaderLoadThread	557
#define FIELDNAMES_numComponents	558
#define FIELDNAMES_fogCoord	559
#define FIELDNAMES_munitionEndPoint	560
#define FIELDNAMES___oldGeoCenter	561
#define FIELDNAMES_choice	562
#define FIELDNAMES_hatchStyle	563
#define FIELDNAMES___params	564
#define FIELDNAMES_cutOffAngle	565
#define FIELDNAMES_removeTrimmingContour	566
#define FIELDNAMES___parentProto	567
#define FIELDNAMES_minPosition	568
#define FIELDNAMES___rotyup	569
#define FIELDNAMES_linewidthScaleFactor	570
#define FIELDNAMES___geoSystem	571
#define FIELDNAMES_finalText	572
#define FIELDNAMES_rootUrl	573
#define FIELDNAMES_FreeWRL_PROTOInterfaceNodes	574
#define FIELDNAMES_entityExtra	575
#define FIELDNAMES_url	576
#define FIELDNAMES_coord	577
#define FIELDNAMES_startTime	578
#define FIELDNAMES___frontTexture	579
#define FIELDNAMES___topTexture	580
#define FIELDNAMES_minFront	581
#define FIELDNAMES_ccw	582
#define FIELDNAMES_valueChanged	583
#define FIELDNAMES_level	584
#define FIELDNAMES_vertexCount	585
#define FIELDNAMES_transitionType	586
#define FIELDNAMES___rendersub	587
#define FIELDNAMES_llimit	588
#define FIELDNAMES_range	589
#define FIELDNAMES_keyPress	590
#define FIELDNAMES_resumeTime	591
#define FIELDNAMES_antennaLocation	592
#define FIELDNAMES_timestamp	593
#define FIELDNAMES_forceTransitions	594
#define FIELDNAMES_radioEntityTypeNomenclature	595
#define FIELDNAMES_shaders	596
#define FIELDNAMES_language	597
#define FIELDNAMES_shiftKey	598
#define FIELDNAMES_filter	599
#define FIELDNAMES_leftTexture	600
#define FIELDNAMES_lineSegments	601
#define FIELDNAMES_momentsOfInertia	602
#define FIELDNAMES_set_intersectionType	603
#define FIELDNAMES_coordIndex	604
#define FIELDNAMES_stringInp	605
#define FIELDNAMES_material	606
#define FIELDNAMES__selected	607
#define FIELDNAMES_set_scale	608
#define FIELDNAMES_transmitterApplicationID	609
#define FIELDNAMES_loadTime	610
#define FIELDNAMES_frequency	611
#define FIELDNAMES_actionKeyRelease	612
#define FIELDNAMES_articulationParameterValue1_changed	613
#define FIELDNAMES_isSelected	614
#define FIELDNAMES___oldMFString	615
#define FIELDNAMES_rtpHeaderExpected	616
#define FIELDNAMES_child3Url	617
#define FIELDNAMES_pauseTime	618
#define FIELDNAMES_isCollided	619
#define FIELDNAMES_normalIndex	620
#define FIELDNAMES_beamWidth	621
#define FIELDNAMES_pickTarget	622
#define FIELDNAMES_zSpacing	623
#define FIELDNAMES_whichGeometry	624
#define FIELDNAMES___oldSFString	625
#define FIELDNAMES_eventSiteID	626
#define FIELDNAMES_innerRadius	627
#define FIELDNAMES_fontStyle	628
#define FIELDNAMES_convex	629
#define FIELDNAMES_orientation	630
#define FIELDNAMES_set_texCoordIndex	631
#define FIELDNAMES_appearance	632
#define FIELDNAMES_autoOffset	633
#define FIELDNAMES_zDimension	634
#define FIELDNAMES__floatOutFIFO	635
#define FIELDNAMES_vOrder	636
#define FIELDNAMES_entitySubCategory	637
#define FIELDNAMES_set_coordIndex	638
#define FIELDNAMES_munitionQuantity	639
#define FIELDNAMES__stringOutFIFO	640
#define FIELDNAMES_elapsedTime	641
#define FIELDNAMES___vertices	642
#define FIELDNAMES__amb	643

const char *stringFieldType(int st);

/* Table of built-in fieldIds */
extern const char *EVENT_OUT[];
extern const int EVENT_OUT_COUNT;
#define EVENT_OUT_isStandAlone	0
#define EVENT_OUT_inputNegate	1
#define EVENT_OUT_isValid	2
#define EVENT_OUT_position_changed	3
#define EVENT_OUT_finalText	4
#define EVENT_OUT_isBound	5
#define EVENT_OUT_triggerValue	6
#define EVENT_OUT_isRtpHeaderHeard	7
#define EVENT_OUT_controlKey	8
#define EVENT_OUT_actionKeyPress	9
#define EVENT_OUT_centerOfRotation_changed	10
#define EVENT_OUT_isLoaded	11
#define EVENT_OUT_articulationParameterValue3_changed	12
#define EVENT_OUT_modifiedFraction_changed	13
#define EVENT_OUT_isOver	14
#define EVENT_OUT_hitGeoCoord_changed	15
#define EVENT_OUT_pickedPoint	16
#define EVENT_OUT_geoCoord_changed	17
#define EVENT_OUT_cycleTime	18
#define EVENT_OUT_valueChanged	19
#define EVENT_OUT_transitionComplete	20
#define EVENT_OUT_toggle	21
#define EVENT_OUT_lineBounds	22
#define EVENT_OUT_triggerTrue	23
#define EVENT_OUT_touchTime	24
#define EVENT_OUT_time	25
#define EVENT_OUT_keyPress	26
#define EVENT_OUT_fraction_changed	27
#define EVENT_OUT_level_changed	28
#define EVENT_OUT_isNetworkWriter	29
#define EVENT_OUT_hitTexCoord_changed	30
#define EVENT_OUT_orientation_changed	31
#define EVENT_OUT_timestamp	32
#define EVENT_OUT_enteredText	33
#define EVENT_OUT_geovalue_changed	34
#define EVENT_OUT_detonateTime	35
#define EVENT_OUT_progress	36
#define EVENT_OUT_shiftKey	37
#define EVENT_OUT_textBounds	38
#define EVENT_OUT_removedEntities	39
#define EVENT_OUT_inputTrue	40
#define EVENT_OUT_isNetworkReader	41
#define EVENT_OUT_loadTime	42
#define EVENT_OUT_addedEntities	43
#define EVENT_OUT_levelChanged	44
#define EVENT_OUT_actionKeyRelease	45
#define EVENT_OUT_normal_changed	46
#define EVENT_OUT_isSelected	47
#define EVENT_OUT_articulationParameterValue1_changed	48
#define EVENT_OUT_exitTime	49
#define EVENT_OUT_duration_changed	50
#define EVENT_OUT_isPaused	51
#define EVENT_OUT_pickedGeometry	52
#define EVENT_OUT_isCollided	53
#define EVENT_OUT_articulationParameterValue5_changed	54
#define EVENT_OUT_firedTime	55
#define EVENT_OUT_articulationParameterValue6_changed	56
#define EVENT_OUT_origin	57
#define EVENT_OUT_bindTime	58
#define EVENT_OUT_keyRelease	59
#define EVENT_OUT_hitNormal_changed	60
#define EVENT_OUT_translation_changed	61
#define EVENT_OUT_collideTime	62
#define EVENT_OUT_enterTime	63
#define EVENT_OUT_isDetonated	64
#define EVENT_OUT_altKey	65
#define EVENT_OUT_rotation_changed	66
#define EVENT_OUT_triggerTime	67
#define EVENT_OUT_inputFalse	68
#define EVENT_OUT_value_changed	69
#define EVENT_OUT_trackPoint_changed	70
#define EVENT_OUT_isActive	71
#define EVENT_OUT_hitPoint_changed	72
#define EVENT_OUT_articulationParameterValue7_changed	73
#define EVENT_OUT_elapsedTime	74
#define EVENT_OUT_articulationParameterValue0_changed	75
#define EVENT_OUT_articulationParameterValue2_changed	76
#define EVENT_OUT_articulationParameterValue4_changed	77


/* Table of built-in fieldIds */
extern const char *EVENT_IN[];
extern const int EVENT_IN_COUNT;
#define EVENT_IN_set_position	0
#define EVENT_IN_set_articulationParameterValue5	1
#define EVENT_IN_next	2
#define EVENT_IN_set_scale	3
#define EVENT_IN_set_articulationParameterValue2	4
#define EVENT_IN_activate	5
#define EVENT_IN_addChildren	6
#define EVENT_IN_set_crossSection	7
#define EVENT_IN_set_articulationParameterValue0	8
#define EVENT_IN_addTrimmingContour	9
#define EVENT_IN_set_index	10
#define EVENT_IN_set_articulationParameterValue1	11
#define EVENT_IN_set_fraction	12
#define EVENT_IN_set_boolean	13
#define EVENT_IN_set_articulationParameterValue7	14
#define EVENT_IN_set_articulationParameterValue3	15
#define EVENT_IN_set_articulationParameterValue4	16
#define EVENT_IN_set_texCoordIndex	17
#define EVENT_IN_setValue	18
#define EVENT_IN_set_height	19
#define EVENT_IN_set_sortOrder	20
#define EVENT_IN_previous	21
#define EVENT_IN_set_colorIndex	22
#define EVENT_IN_set_spine	23
#define EVENT_IN_set_triggerTime	24
#define EVENT_IN_removeChildren	25
#define EVENT_IN_addGeometry	26
#define EVENT_IN_set_bind	27
#define EVENT_IN_set_coordIndex	28
#define EVENT_IN_removeGeometry	29
#define EVENT_IN_tickTime	30
#define EVENT_IN_set_normalIndex	31
#define EVENT_IN_set_intersectionType	32
#define EVENT_IN_set_articulationParameterValue6	33
#define EVENT_IN_coordIndex	34
#define EVENT_IN_removeTrimmingContour	35
#define EVENT_IN_set_orientation	36


/* Table of built-in fieldIds */
extern const char *EXPOSED_FIELD[];
extern const int EXPOSED_FIELD_COUNT;
#define EXPOSED_FIELD_topTexture	0
#define EXPOSED_FIELD_integerKey	1
#define EXPOSED_FIELD_power	2
#define EXPOSED_FIELD_munitionSiteID	3
#define EXPOSED_FIELD_modulationTypeMajor	4
#define EXPOSED_FIELD_whichChoice	5
#define EXPOSED_FIELD_maxBack	6
#define EXPOSED_FIELD_vector	7
#define EXPOSED_FIELD_sampleRate	8
#define EXPOSED_FIELD_rotation	9
#define EXPOSED_FIELD_firingRange	10
#define EXPOSED_FIELD_stiffness	11
#define EXPOSED_FIELD_samples	12
#define EXPOSED_FIELD_detonationRelativeLocation	13
#define EXPOSED_FIELD_minificationFilter	14
#define EXPOSED_FIELD_trajectoryCurve	15
#define EXPOSED_FIELD_attrib	16
#define EXPOSED_FIELD_radioEntityTypeCountry	17
#define EXPOSED_FIELD_vDimension	18
#define EXPOSED_FIELD_rightUrl	19
#define EXPOSED_FIELD_deadReckoning	20
#define EXPOSED_FIELD_segments	21
#define EXPOSED_FIELD_texture	22
#define EXPOSED_FIELD_groundColor	23
#define EXPOSED_FIELD_direction	24
#define EXPOSED_FIELD_transmitterSiteID	25
#define EXPOSED_FIELD_transmitterRadioID	26
#define EXPOSED_FIELD_detonationResult	27
#define EXPOSED_FIELD_programs	28
#define EXPOSED_FIELD_maxPosition	29
#define EXPOSED_FIELD_objectType	30
#define EXPOSED_FIELD_speed	31
#define EXPOSED_FIELD_fillProperties	32
#define EXPOSED_FIELD_skin	33
#define EXPOSED_FIELD_maxAngle	34
#define EXPOSED_FIELD_modulationTypeSpreadSpectrum	35
#define EXPOSED_FIELD_version	36
#define EXPOSED_FIELD_entityKind	37
#define EXPOSED_FIELD_transmitterEntityID	38
#define EXPOSED_FIELD_retainUserOffsets	39
#define EXPOSED_FIELD_image	40
#define EXPOSED_FIELD_vertices	41
#define EXPOSED_FIELD_left	42
#define EXPOSED_FIELD_vTesselation	43
#define EXPOSED_FIELD_backAmbientIntensity	44
#define EXPOSED_FIELD_receivedPower	45
#define EXPOSED_FIELD_joints	46
#define EXPOSED_FIELD_articulationParameterArray	47
#define EXPOSED_FIELD_order	48
#define EXPOSED_FIELD_deletionAllowed	49
#define EXPOSED_FIELD_geometry	50
#define EXPOSED_FIELD_address	51
#define EXPOSED_FIELD_translation	52
#define EXPOSED_FIELD_multicastRelayPort	53
#define EXPOSED_FIELD_watchList	54
#define EXPOSED_FIELD_limitOrientation	55
#define EXPOSED_FIELD_skeleton	56
#define EXPOSED_FIELD_lineProperties	57
#define EXPOSED_FIELD_data	58
#define EXPOSED_FIELD_centerOfRotation	59
#define EXPOSED_FIELD_minBack	60
#define EXPOSED_FIELD_type	61
#define EXPOSED_FIELD_writeInterval	62
#define EXPOSED_FIELD_backShininess	63
#define EXPOSED_FIELD_entityID	64
#define EXPOSED_FIELD_fired2	65
#define EXPOSED_FIELD_crossSectionCurve	66
#define EXPOSED_FIELD_closed	67
#define EXPOSED_FIELD_eventApplicationID	68
#define EXPOSED_FIELD_applicationID	69
#define EXPOSED_FIELD_global	70
#define EXPOSED_FIELD_vTessellation	71
#define EXPOSED_FIELD_displacers	72
#define EXPOSED_FIELD_uDimension	73
#define EXPOSED_FIELD_back	74
#define EXPOSED_FIELD_emissiveColor	75
#define EXPOSED_FIELD_geoCenter	76
#define EXPOSED_FIELD_antennaPatternLength	77
#define EXPOSED_FIELD_centerOfMass	78
#define EXPOSED_FIELD_filled	79
#define EXPOSED_FIELD_groundAngle	80
#define EXPOSED_FIELD_mapping	81
#define EXPOSED_FIELD_mode	82
#define EXPOSED_FIELD_string	83
#define EXPOSED_FIELD_children	84
#define EXPOSED_FIELD_on	85
#define EXPOSED_FIELD_leftUrl	86
#define EXPOSED_FIELD_textureCompression	87
#define EXPOSED_FIELD_warhead	88
#define EXPOSED_FIELD_frontTexture	89
#define EXPOSED_FIELD_entityCategory	90
#define EXPOSED_FIELD_diskAngle	91
#define EXPOSED_FIELD_transmitFrequencyBandwidth	92
#define EXPOSED_FIELD_dataLength	93
#define EXPOSED_FIELD_shininess	94
#define EXPOSED_FIELD_texturePriority	95
#define EXPOSED_FIELD_description	96
#define EXPOSED_FIELD_radioEntityTypeCategory	97
#define EXPOSED_FIELD_top	98
#define EXPOSED_FIELD_fuse	99
#define EXPOSED_FIELD_int32Inp	100
#define EXPOSED_FIELD_source	101
#define EXPOSED_FIELD_skinNormal	102
#define EXPOSED_FIELD_front	103
#define EXPOSED_FIELD_linearVelocity	104
#define EXPOSED_FIELD_entityDomain	105
#define EXPOSED_FIELD_backUrl	106
#define EXPOSED_FIELD_size	107
#define EXPOSED_FIELD_boundaryModeT	108
#define EXPOSED_FIELD_maxExtent	109
#define EXPOSED_FIELD_summary	110
#define EXPOSED_FIELD_transmitState	111
#define EXPOSED_FIELD_readInterval	112
#define EXPOSED_FIELD_tdlType	113
#define EXPOSED_FIELD_radioEntityTypeDomain	114
#define EXPOSED_FIELD_hatchColor	115
#define EXPOSED_FIELD_bottom	116
#define EXPOSED_FIELD_marking	117
#define EXPOSED_FIELD_backSpecularColor	118
#define EXPOSED_FIELD_ambientIntensity	119
#define EXPOSED_FIELD_modulationTypeSystem	120
#define EXPOSED_FIELD_frontUrl	121
#define EXPOSED_FIELD_floatInp	122
#define EXPOSED_FIELD_headlight	123
#define EXPOSED_FIELD_radioEntityTypeKind	124
#define EXPOSED_FIELD_cycleInterval	125
#define EXPOSED_FIELD_mass	126
#define EXPOSED_FIELD_pitch	127
#define EXPOSED_FIELD_articulationParameterTypeArray	128
#define EXPOSED_FIELD_modulationTypeDetail	129
#define EXPOSED_FIELD_bottomTexture	130
#define EXPOSED_FIELD_separateBackColor	131
#define EXPOSED_FIELD_sites	132
#define EXPOSED_FIELD_encodingScheme	133
#define EXPOSED_FIELD_profileCurve	134
#define EXPOSED_FIELD_uOrder	135
#define EXPOSED_FIELD_fired1	136
#define EXPOSED_FIELD_depth	137
#define EXPOSED_FIELD_parameter	138
#define EXPOSED_FIELD_borderWidth	139
#define EXPOSED_FIELD_gotEvents	140
#define EXPOSED_FIELD_backTransparency	141
#define EXPOSED_FIELD_tessellation	142
#define EXPOSED_FIELD_fieldOfView	143
#define EXPOSED_FIELD_scale	144
#define EXPOSED_FIELD_listenfor	145
#define EXPOSED_FIELD_borderColor	146
#define EXPOSED_FIELD_maxFront	147
#define EXPOSED_FIELD_rightTexture	148
#define EXPOSED_FIELD_uTessellation	149
#define EXPOSED_FIELD_skinCoordWeight	150
#define EXPOSED_FIELD_plane	151
#define EXPOSED_FIELD_keyValue	152
#define EXPOSED_FIELD_radius	153
#define EXPOSED_FIELD_controlPoint	154
#define EXPOSED_FIELD_tessellationScale	155
#define EXPOSED_FIELD_diffuseColor	156
#define EXPOSED_FIELD_handler	157
#define EXPOSED_FIELD_point	158
#define EXPOSED_FIELD_inputSource	159
#define EXPOSED_FIELD_radioEntityTypeNomenclatureVersion	160
#define EXPOSED_FIELD_normal	161
#define EXPOSED_FIELD_articulationParameterChangeIndicatorArr	162
#define EXPOSED_FIELD_firingRate	163
#define EXPOSED_FIELD_entitySpecific	164
#define EXPOSED_FIELD_eventNumber	165
#define EXPOSED_FIELD_loop	166
#define EXPOSED_FIELD_key	167
#define EXPOSED_FIELD_ulimit	168
#define EXPOSED_FIELD_skinCoord	169
#define EXPOSED_FIELD_enabled	170
#define EXPOSED_FIELD_name	171
#define EXPOSED_FIELD_texCoord	172
#define EXPOSED_FIELD_pickable	173
#define EXPOSED_FIELD_hatched	174
#define EXPOSED_FIELD_articulationParameterCount	175
#define EXPOSED_FIELD_uTesselation	176
#define EXPOSED_FIELD_collide	177
#define EXPOSED_FIELD_avatarSize	178
#define EXPOSED_FIELD_specularColor	179
#define EXPOSED_FIELD_easeInEaseOut	180
#define EXPOSED_FIELD_transitionTime	181
#define EXPOSED_FIELD_siteID	182
#define EXPOSED_FIELD_color	183
#define EXPOSED_FIELD_axisOfRotation	184
#define EXPOSED_FIELD_networkMode	185
#define EXPOSED_FIELD_backEmissiveColor	186
#define EXPOSED_FIELD_transparency	187
#define EXPOSED_FIELD_linearAcceleration	188
#define EXPOSED_FIELD_visible	189
#define EXPOSED_FIELD_textureTransform	190
#define EXPOSED_FIELD_lengthOfModulationParameters	191
#define EXPOSED_FIELD_viewpoints	192
#define EXPOSED_FIELD_length	193
#define EXPOSED_FIELD_right	194
#define EXPOSED_FIELD_index	195
#define EXPOSED_FIELD_pickingGeometry	196
#define EXPOSED_FIELD_intensity	197
#define EXPOSED_FIELD_update	198
#define EXPOSED_FIELD_navType	199
#define EXPOSED_FIELD_entityCountry	200
#define EXPOSED_FIELD_protocol	201
#define EXPOSED_FIELD_antennaPatternType	202
#define EXPOSED_FIELD_minAngle	203
#define EXPOSED_FIELD_weight	204
#define EXPOSED_FIELD_talksTo	205
#define EXPOSED_FIELD_visibilityLimit	206
#define EXPOSED_FIELD_munitionApplicationID	207
#define EXPOSED_FIELD_value	208
#define EXPOSED_FIELD_FIFOsize	209
#define EXPOSED_FIELD_articulationParameterIdPartAttachedToAr	210
#define EXPOSED_FIELD_multicastRelayHost	211
#define EXPOSED_FIELD_forceID	212
#define EXPOSED_FIELD_articulationParameterDesignatorArray	213
#define EXPOSED_FIELD_stopTime	214
#define EXPOSED_FIELD_position	215
#define EXPOSED_FIELD_magnificationFilter	216
#define EXPOSED_FIELD_fogCoord	217
#define EXPOSED_FIELD_scaleOrientation	218
#define EXPOSED_FIELD_munitionEndPoint	219
#define EXPOSED_FIELD_choice	220
#define EXPOSED_FIELD_bottomUrl	221
#define EXPOSED_FIELD_radioID	222
#define EXPOSED_FIELD_boundaryModeS	223
#define EXPOSED_FIELD_hatchStyle	224
#define EXPOSED_FIELD_cutOffAngle	225
#define EXPOSED_FIELD_knot	226
#define EXPOSED_FIELD_fogType	227
#define EXPOSED_FIELD_skyColor	228
#define EXPOSED_FIELD_minPosition	229
#define EXPOSED_FIELD_displacements	230
#define EXPOSED_FIELD_topUrl	231
#define EXPOSED_FIELD_linewidthScaleFactor	232
#define EXPOSED_FIELD_detonationLocation	233
#define EXPOSED_FIELD_attenuation	234
#define EXPOSED_FIELD_FreeWRL_PROTOInterfaceNodes	235
#define EXPOSED_FIELD_fireMissionIndex	236
#define EXPOSED_FIELD_entityExtra	237
#define EXPOSED_FIELD_url	238
#define EXPOSED_FIELD_coord	239
#define EXPOSED_FIELD_startTime	240
#define EXPOSED_FIELD_trimmingContour	241
#define EXPOSED_FIELD_minFront	242
#define EXPOSED_FIELD_displayed	243
#define EXPOSED_FIELD_boundaryModeR	244
#define EXPOSED_FIELD_level	245
#define EXPOSED_FIELD_vertexCount	246
#define EXPOSED_FIELD_transitionType	247
#define EXPOSED_FIELD_applied	248
#define EXPOSED_FIELD_backTexture	249
#define EXPOSED_FIELD_llimit	250
#define EXPOSED_FIELD_function	251
#define EXPOSED_FIELD_resumeTime	252
#define EXPOSED_FIELD_antennaLocation	253
#define EXPOSED_FIELD_alpha	254
#define EXPOSED_FIELD_radioEntityTypeNomenclature	255
#define EXPOSED_FIELD_backDiffuseColor	256
#define EXPOSED_FIELD_shaders	257
#define EXPOSED_FIELD_visibilityRange	258
#define EXPOSED_FIELD_filter	259
#define EXPOSED_FIELD_leftTexture	260
#define EXPOSED_FIELD_momentsOfInertia	261
#define EXPOSED_FIELD_stringInp	262
#define EXPOSED_FIELD_munitionStartPoint	263
#define EXPOSED_FIELD_skinCoordIndex	264
#define EXPOSED_FIELD_material	265
#define EXPOSED_FIELD_priority	266
#define EXPOSED_FIELD_linetype	267
#define EXPOSED_FIELD_receiverState	268
#define EXPOSED_FIELD_transmitterApplicationID	269
#define EXPOSED_FIELD_frequency	270
#define EXPOSED_FIELD_eventEntityID	271
#define EXPOSED_FIELD_rtpHeaderExpected	272
#define EXPOSED_FIELD_pauseTime	273
#define EXPOSED_FIELD_normalizeVelocity	274
#define EXPOSED_FIELD_metadata	275
#define EXPOSED_FIELD_geoCoords	276
#define EXPOSED_FIELD_relativeAntennaLocation	277
#define EXPOSED_FIELD_beamWidth	278
#define EXPOSED_FIELD_pickTarget	279
#define EXPOSED_FIELD_location	280
#define EXPOSED_FIELD_jump	281
#define EXPOSED_FIELD_port	282
#define EXPOSED_FIELD_whichGeometry	283
#define EXPOSED_FIELD_timeOut	284
#define EXPOSED_FIELD_skyAngle	285
#define EXPOSED_FIELD_shape	286
#define EXPOSED_FIELD_eventSiteID	287
#define EXPOSED_FIELD_fontStyle	288
#define EXPOSED_FIELD_orientation	289
#define EXPOSED_FIELD_appearance	290
#define EXPOSED_FIELD_center	291
#define EXPOSED_FIELD_autoOffset	292
#define EXPOSED_FIELD_munitionEntityID	293
#define EXPOSED_FIELD_offset	294
#define EXPOSED_FIELD_vOrder	295
#define EXPOSED_FIELD_entitySubCategory	296
#define EXPOSED_FIELD_munitionQuantity	297
#define EXPOSED_FIELD_cryptoSystem	298
#define EXPOSED_FIELD_cryptoKeyID	299
#define EXPOSED_FIELD_anisotropicDegree	300
#define EXPOSED_FIELD_parts	301
#define EXPOSED_FIELD_keyVelocity	302
#define EXPOSED_FIELD_collisionType	303


/* Table of built-in fieldIds */
extern const char *FIELD[];
extern const int FIELD_COUNT;
#define FIELD_rootNode	0
#define FIELD_category	1
#define FIELD_extra	2
#define FIELD_load	3
#define FIELD_horizontal	4
#define FIELD_yScale	5
#define FIELD_fanCount	6
#define FIELD_title	7
#define FIELD_child4Url	8
#define FIELD_geoGridOrigin	9
#define FIELD_uClosed	10
#define FIELD_stripCount	11
#define FIELD_repeatT	12
#define FIELD_vKnot	13
#define FIELD_texCoordIndex	14
#define FIELD_intersectionType	15
#define FIELD_vClosed	16
#define FIELD_beginCap	17
#define FIELD_speedFactor	18
#define FIELD_topToBottom	19
#define FIELD_FreeWRL__protoDef	20
#define FIELD_height	21
#define FIELD_index	22
#define FIELD_uKnot	23
#define FIELD_colorIndex	24
#define FIELD_startAngle	25
#define FIELD_textureProperties	26
#define FIELD_child2Url	27
#define FIELD_crossSection	28
#define FIELD_xSpacing	29
#define FIELD_numComponents	30
#define FIELD_creaseAngle	31
#define FIELD_knot	32
#define FIELD_bboxCenter	33
#define FIELD_xDimension	34
#define FIELD_spacing	35
#define FIELD_solid	36
#define FIELD_geoSystem	37
#define FIELD_rootUrl	38
#define FIELD_sortOrder	39
#define FIELD_endAngle	40
#define FIELD_ccw	41
#define FIELD_subcategory	42
#define FIELD_outerRadius	43
#define FIELD_family	44
#define FIELD_specific	45
#define FIELD_leftToRight	46
#define FIELD_range	47
#define FIELD_domain	48
#define FIELD_kind	49
#define FIELD_repeatS	50
#define FIELD_forceTransitions	51
#define FIELD_bboxSize	52
#define FIELD_country	53
#define FIELD_info	54
#define FIELD_language	55
#define FIELD_style	56
#define FIELD_lineSegments	57
#define FIELD_justify	58
#define FIELD_side	59
#define FIELD_coordIndex	60
#define FIELD_rtpHeaderExpected	61
#define FIELD_child3Url	62
#define FIELD_spatialize	63
#define FIELD_geoOrigin	64
#define FIELD_rotateYUp	65
#define FIELD_normalIndex	66
#define FIELD_colorPerVertex	67
#define FIELD_zSpacing	68
#define FIELD_directOutput	69
#define FIELD_generateMipMaps	70
#define FIELD_innerRadius	71
#define FIELD_proxy	72
#define FIELD_closureType	73
#define FIELD_convex	74
#define FIELD_child1Url	75
#define FIELD_endCap	76
#define FIELD_zDimension	77
#define FIELD_reference	78
#define FIELD_spine	79
#define FIELD_bottomRadius	80
#define FIELD_mustEvaluate	81
#define FIELD_normalPerVertex	82


/* Table of built-in keywords */
extern const char *KEYWORDS[];
extern const int KEYWORDS_COUNT;
#define KW_eventOut	0
#define KW_TRUE	1
#define KW_BROTO	2
#define KW_NULL	3
#define KW_IS	4
#define KW_EXTERNPROTO	5
#define KW_inputOnly	6
#define KW_DEF	7
#define KW_PROTO	8
#define KW_IMPORT	9
#define KW_initializeOnly	10
#define KW_outputOnly	11
#define KW_EXTERNBROTO	12
#define KW_FALSE	13
#define KW_inputOutput	14
#define KW_field	15
#define KW_TO	16
#define KW_PROFILE	17
#define KW_exposedField	18
#define KW_COMPONENT	19
#define KW_eventIn	20
#define KW_META	21
#define KW_EXPORT	22
#define KW_USE	23
#define KW_ROUTE	24

const char *stringKeywordType(int st);

/* Table of built-in profiles */
extern const char *PROFILES[];
extern const int PROFILES_COUNT;
#define PRO_Interchange	0
#define PRO_CADInterchange	1
#define PRO_MPEG4	2
#define PRO_Interactive	3
#define PRO_Full	4
#define PRO_Immersive	5
#define PRO_Core	6

const char *stringProfileType(int st);

/* Table of built-in components */
extern const char *COMPONENTS[];
extern const int COMPONENTS_COUNT;
#define COM_Geometry2D	0
#define COM_Rendering	1
#define COM_PickingSensor	2
#define COM_DIS	3
#define COM_EnvironmentalSensor	4
#define COM_Text	5
#define COM_NURBS	6
#define COM_CubeMapTexturing	7
#define COM_EventUtilities	8
#define COM_Interpolation	9
#define COM_Shaders	10
#define COM_Navigation	11
#define COM_Grouping	12
#define COM_Texturing	13
#define COM_Geospatial	14
#define COM_CADGeometry	15
#define COM_EnvironmentalEffects	16
#define COM_Shape	17
#define COM_Texturing3D	18
#define COM_PointDeviceSensor	19
#define COM_HAnim	20
#define COM_RigidBodyPhysics	21
#define COM_Core	22
#define COM_Layout	23
#define COM_Time	24
#define COM_Geometry3D	25
#define COM_Followers	26
#define COM_Scripting	27
#define COM_Lighting	28
#define COM_KeyDeviceSensor	29
#define COM_Layering	30
#define COM_Networking	31
#define COM_ParticleSystems	32
#define COM_Sound	33

const char *stringComponentType(int st);

/* Table of built-in PROTO keywords */
extern const char *PROTOKEYWORDS[];
extern const int PROTOKEYWORDS_COUNT;
#define PKW_initializeOnly	0
#define PKW_inputOnly	1
#define PKW_outputOnly	2
#define PKW_inputOutput	3
#define PKW_field	4
#define PKW_eventIn	5
#define PKW_eventOut	6
#define PKW_exposedField	7

const char *stringPROTOKeywordType(int st);

/* Table of built-in MULTITEXTUREMODE keywords */
extern const char *MULTITEXTUREMODE[];
extern const int MULTITEXTUREMODE_COUNT;
#define MTMODE_ADDSIGNED2X	0
#define MTMODE_REPLACE	1
#define MTMODE_BLENDCURRENTALPHA	2
#define MTMODE_MODULATE	3
#define MTMODE_DOTPRODUCT3	4
#define MTMODE_SELECTARG2	5
#define MTMODE_SELECTARG1	6
#define MTMODE_BLENDDIFFUSEALPHA	7
#define MTMODE_SUBTRACT	8
#define MTMODE_ADD	9
#define MTMODE_MODULATEINVCOLOR_ADDALPHA	10
#define MTMODE_ADDSMOOTH	11
#define MTMODE_MODULATE2X	12
#define MTMODE_MODULATE4X	13
#define MTMODE_OFF	14
#define MTMODE_MODULATEINVALPHA_ADDCOLOR	15
#define MTMODE_MODULATEALPHA_ADDCOLOR	16
#define MTMODE_ADDSIGNED	17

const char *stringMULTITEXTUREMODEType(int st);

/* Table of built-in MULTITEXTURESOURCE keywords */
extern const char *MULTITEXTURESOURCE[];
extern const int MULTITEXTURESOURCE_COUNT;
#define MTSRC_DIFFUSE	0
#define MTSRC_SPECULAR	1
#define MTSRC_FACTOR	2


/* Table of built-in TEXTURECOORDINATEGENERATOR keywords */
extern const char *TEXTURECOORDINATEGENERATOR[];
extern const int TEXTURECOORDINATEGENERATOR_COUNT;
#define TCGT_NOISE	0
#define TCGT_CAMERASPACENORMAL	1
#define TCGT_NOISE_EYE	2
#define TCGT_SPHERE	3
#define TCGT_SPHERE_REFLECT_LOCAL	4
#define TCGT_SPHERE_REFLECT	5
#define TCGT_CAMERASPACEREFLECTION	6
#define TCGT_SPHERE_LOCAL	7
#define TCGT_COORD_EYE	8
#define TCGT_COORD	9
#define TCGT_CAMERASPACEPOSITION	10

const char *stringMULTITEXTURESOURCEType(int st);

/* Table of built-in MULTITEXTUREFUNCTION keywords */
extern const char *MULTITEXTUREFUNCTION[];
extern const int MULTITEXTUREFUNCTION_COUNT;
#define MTFN_COMPLEMENT	0
#define MTFN_ALPHAREPLICATE	1

const char *stringMULTITEXTUREFUNCTIONType(int st);

/* Table of built-in X3DSPECIAL keywords */
extern const char *X3DSPECIAL[];
extern const int X3DSPECIAL_COUNT;
#define X3DSP_IS	0
#define X3DSP_Scene	1
#define X3DSP_meta	2
#define X3DSP_export	3
#define X3DSP_ProtoDeclare	4
#define X3DSP_field	5
#define X3DSP_connect	6
#define X3DSP_head	7
#define X3DSP_ProtoInterface	8
#define X3DSP_ProtoInstance	9
#define X3DSP_ProtoBody	10
#define X3DSP_X3D	11
#define X3DSP_import	12
#define X3DSP_component	13
#define X3DSP_ExternProtoDeclare	14
#define X3DSP_fieldValue	15
#define X3DSP_ROUTE	16
#define X3DSP_Header	17

const char *stringX3DSPECIALType(int st);

/* Table of built-in TEXTUREBOUNDARY keywords */
extern const char *TEXTUREBOUNDARYKEYWORDS[];
extern const int TEXTUREBOUNDARYKEYWORDS_COUNT;
#define TB_CLAMP_TO_BOUNDARY	0
#define TB_REPEAT	1
#define TB_MIRRORED_REPEAT	2
#define TB_CLAMP	3
#define TB_CLAMP_TO_EDGE	4

const char *stringTEXTUREBOUNDARYKeywordType(int st);

/* Table of built-in TEXTUREMAGNIFICATION keywords */
extern const char *TEXTUREMAGNIFICATIONKEYWORDS[];
extern const int TEXTUREMAGNIFICATIONKEYWORDS_COUNT;
#define TMAG_NICEST	0
#define TMAG_NEAREST_PIXEL	1
#define TMAG_FASTEST	2
#define TMAG_DEFAULT	3
#define TMAG_AVG_PIXEL	4

const char *stringTEXTUREMAGNIFICATIONKeywordType(int st);

/* Table of built-in TEXTUREMINIFICATION keywords */
extern const char *TEXTUREMINIFICATIONKEYWORDS[];
extern const int TEXTUREMINIFICATIONKEYWORDS_COUNT;
#define TMIN_NEAREST_PIXEL_AVG_MIPMAP	0
#define TMIN_DEFAULT	1
#define TMIN_NEAREST_PIXEL	2
#define TMIN_NICEST	3
#define TMIN_AVG_PIXEL_AVG_MIPMAP	4
#define TMIN_FASTEST	5
#define TMIN_AVG_PIXEL	6
#define TMIN_AVG_PIXEL_NEAREST_MIPMAP	7
#define TMIN_NEAREST_PIXEL_NEAREST_MIPMAP	8

const char *stringTEXTUREMINIFICATIONKeywordType(int st);

/* Table of built-in TEXTURECOMPRESSION keywords */
extern const char *TEXTURECOMPRESSIONKEYWORDS[];
extern const int TEXTURECOMPRESSIONKEYWORDS_COUNT;
#define TC_NICEST	0
#define TC_LOW	1
#define TC_FASTEST	2
#define TC_DEFAULT	3
#define TC_HIGH	4
#define TC_MEDIUM	5

const char *stringTEXTURECOMPRESSIONKeywordType(int st);

/* Table of built-in GEOSPATIAL keywords */
extern const char *GEOSPATIAL[];
extern const int GEOSPATIAL_COUNT;
#define GEOSP_CC	0
#define GEOSP_WE	1
#define GEOSP_GCC	2
#define GEOSP_date	3
#define GEOSP_copyright	4
#define GEOSP_FA	5
#define GEOSP_EC	6
#define GEOSP_UTM	7
#define GEOSP_BN	8
#define GEOSP_ED	9
#define GEOSP_CD	10
#define GEOSP_EF	11
#define GEOSP_GD	12
#define GEOSP_dataFormat	13
#define GEOSP_extent	14
#define GEOSP_metadataFormat	15
#define GEOSP_originator	16
#define GEOSP_dataUrl	17
#define GEOSP_verticalDatum	18
#define GEOSP_description	19
#define GEOSP_WD	20
#define GEOSP_resolution	21
#define GEOSP_coordinateSystem	22
#define GEOSP_RF	23
#define GEOSP_title	24
#define GEOSP_WGS84	25
#define GEOSP_ID	26
#define GEOSP_EB	27
#define GEOSP_HO	28
#define GEOSP_horizontalDatum	29
#define GEOSP_HE	30
#define GEOSP_EE	31
#define GEOSP_AA	32
#define GEOSP_SA	33
#define GEOSP_GC	34
#define GEOSP_AM	35
#define GEOSP_ellipsoid	36
#define GEOSP_IN	37
#define GEOSP_AN	38
#define GEOSP_KA	39
#define GEOSP_GDC	40
#define GEOSP_BR	41
#define GEOSP_EA	42

const char *stringGEOSPATIALType(int st);
char mapFieldTypeToEAItype (int st);
int mapEAItypeToFieldType (char st);
int convertToSFType (int st);

/* Table of built-in fieldIds */
extern const char *FIELDTYPES[];
extern const int FIELDTYPES_COUNT;
#define FIELDTYPE_SFFloat	0
#define FIELDTYPE_MFFloat	1
#define FIELDTYPE_SFRotation	2
#define FIELDTYPE_MFRotation	3
#define FIELDTYPE_SFVec3f	4
#define FIELDTYPE_MFVec3f	5
#define FIELDTYPE_SFBool	6
#define FIELDTYPE_MFBool	7
#define FIELDTYPE_SFInt32	8
#define FIELDTYPE_MFInt32	9
#define FIELDTYPE_SFNode	10
#define FIELDTYPE_MFNode	11
#define FIELDTYPE_SFColor	12
#define FIELDTYPE_MFColor	13
#define FIELDTYPE_SFColorRGBA	14
#define FIELDTYPE_MFColorRGBA	15
#define FIELDTYPE_SFTime	16
#define FIELDTYPE_MFTime	17
#define FIELDTYPE_SFString	18
#define FIELDTYPE_MFString	19
#define FIELDTYPE_SFVec2f	20
#define FIELDTYPE_MFVec2f	21
#define FIELDTYPE_SFImage	22
#define FIELDTYPE_FreeWRLPTR	23
#define FIELDTYPE_FreeWRLThread	24
#define FIELDTYPE_SFVec3d	25
#define FIELDTYPE_MFVec3d	26
#define FIELDTYPE_SFDouble	27
#define FIELDTYPE_MFDouble	28
#define FIELDTYPE_SFMatrix3f	29
#define FIELDTYPE_MFMatrix3f	30
#define FIELDTYPE_SFMatrix3d	31
#define FIELDTYPE_MFMatrix3d	32
#define FIELDTYPE_SFMatrix4f	33
#define FIELDTYPE_MFMatrix4f	34
#define FIELDTYPE_SFMatrix4d	35
#define FIELDTYPE_MFMatrix4d	36
#define FIELDTYPE_SFVec2d	37
#define FIELDTYPE_MFVec2d	38
#define FIELDTYPE_SFVec4f	39
#define FIELDTYPE_MFVec4f	40
#define FIELDTYPE_SFVec4d	41
#define FIELDTYPE_MFVec4d	42

/*cstruct*/
struct Multi_Float { int n; float  *p; };
struct SFRotation { float c[4]; };
struct Multi_Rotation { int n; struct SFRotation  *p; };
struct SFVec3f { float c[3]; };
struct Multi_Vec3f { int n; struct SFVec3f  *p; };
/*cstruct*/
struct Multi_Bool { int n; int  *p; };
/*cstruct*/
struct Multi_Int32 { int n; int  *p; };

struct Multi_Node { int n; struct X3D_Node * *p; };
struct SFColor { float c[3]; };
struct Multi_Color { int n; struct SFColor  *p; };
struct SFColorRGBA { float c[4]; };
struct Multi_ColorRGBA { int n; struct SFColorRGBA  *p; };
/*cstruct*/
struct Multi_Time { int n; double  *p; };
/*cstruct*/
struct Multi_String { int n; struct Uni_String * *p; };
struct SFVec2f { float c[2]; };
struct Multi_Vec2f { int n; struct SFVec2f  *p; };
/*cstruct*/
/*cstruct*/
/*cstruct*/
struct SFVec3d { double c[3]; };
struct Multi_Vec3d { int n; struct SFVec3d  *p; };
/*cstruct*/
struct Multi_Double { int n; double  *p; };
struct SFMatrix3f { float c[9]; };
struct Multi_Matrix3f { int n; struct SFMatrix3f  *p; };
struct SFMatrix3d { double c[9]; };
struct Multi_Matrix3d { int n; struct SFMatrix3d  *p; };
struct SFMatrix4f { float c[16]; };
struct Multi_Matrix4f { int n; struct SFMatrix4f  *p; };
struct SFMatrix4d { double c[16]; };
struct Multi_Matrix4d { int n; struct SFMatrix4d  *p; };
struct SFVec2d { double c[2]; };
struct Multi_Vec2d { int n; struct SFVec2d  *p; };
struct SFVec4f { float c[4]; };
struct Multi_Vec4f { int n; struct SFVec4f  *p; };
struct SFVec4d { double c[4]; };
struct Multi_Vec4d { int n; struct SFVec4d  *p; };
const char *stringFieldtypeType(int st);

/* Table of built-in nodeIds */
extern const char *NODES[];
extern const int NODES_COUNT;

/* and now the structs for the nodetypes */ 
const char *stringNodeType(int st);

/* First, a generic struct, contains only the common elements */
struct X3D_Node {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
};
#define X3D_LINEPROPERTIES(node) ((struct X3D_LineProperties*)node)
#define X3D_FILLPROPERTIES(node) ((struct X3D_FillProperties*)node)
#define X3D_TEXTURE_TRANSFORM(node) ((struct X3D_TextureTransform*)node)
#define X3D_NODE(node) ((struct X3D_Node*)node)
#define X3D_APPEARANCE(node) ((struct X3D_Appearance*)node)
#define X3D_MATERIAL(node) ((struct X3D_Material*)node)
#define X3D_TWOSIDEDMATERIAL(node) ((struct X3D_TwoSidedMaterial*)node)
#define X3D_GROUP(node) ((struct X3D_Group*)node)
#define X3D_PROTO(node) ((struct X3D_Proto*)node)
#define X3D_PICKABLEGROUP(node) ((struct X3D_PickableGroup*)node)
#define X3D_POINTPICKSENSOR(node) ((struct X3D_PointPickSensor*)node)
#define X3D_STATICGROUP(node) ((struct X3D_StaticGroup*)node)
#define X3D_ANCHOR(node) ((struct X3D_Anchor*)node)
#define X3D_COLLISION(node) ((struct X3D_Collision*)node)
#define X3D_COMPOSEDSHADER(node) ((struct X3D_ComposedShader*)node)
#define X3D_PACKAGEDSHADER(node) ((struct X3D_PackagedShader*)node)
#define X3D_PROGRAMSHADER(node) ((struct X3D_ProgramShader*)node)
#define X3D_SHADERPROGRAM(node) ((struct X3D_ShaderProgram*)node)
#define X3D_SHAPE(node) ((struct X3D_Shape*)node)
#define X3D_VISIBILITYSENSOR(node) ((struct X3D_VisibilitySensor*)node)
#define X3D_BILLBOARD(node) ((struct X3D_Billboard*)node)
#define X3D_NAVIGATIONINFO(node) ((struct X3D_NavigationInfo*)node)
#define X3D_BACKGROUND(node) ((struct X3D_Background*)node)
#define X3D_TEXTUREBACKGROUND(node) ((struct X3D_TextureBackground*)node)
#define X3D_FOG(node) ((struct X3D_Fog*)node)
#define X3D_INLINE(node) ((struct X3D_Inline*)node)
#define X3D_SWITCH(node) ((struct X3D_Switch*)node)
#define X3D_CADASSEMBLY(node) ((struct X3D_CADAssembly*)node)
#define X3D_CADFACE(node) ((struct X3D_CADFace*)node)
#define X3D_CADLAYER(node) ((struct X3D_CADLayer*)node)
#define X3D_CADPART(node) ((struct X3D_CADPart*)node)
#define X3D_SCRIPT(node) ((struct X3D_Script*)node)
#define X3D_VIEWPOINT(node) ((struct X3D_Viewpoint*)node)
#define X3D_ORTHOVIEWPOINT(node) ((struct X3D_OrthoViewpoint*)node)
#define X3D_LODNODE(node) ((struct X3D_LOD*)node)
#define X3D_TRANSFORM(node) ((struct X3D_Transform*)node)
#define X3D_PROXIMITYSENSOR(node) ((struct X3D_ProximitySensor*)node)
#define X3D_POINTLIGHT(node) ((struct X3D_PointLight*)node)
#define X3D_SPOTLIGHT(node) ((struct X3D_SpotLight*)node)
#define X3D_DIRECTIONALLIGHT(node) ((struct X3D_DirectionalLight*)node)
#define X3D_INDEXEDFACESET(node) ((struct X3D_IndexedFaceSet*)node)
#define X3D_INDEXEDLINESET(node) ((struct X3D_IndexedLineSet*)node)
#define X3D_ELEVATIONGRID(node) ((struct X3D_ElevationGrid*)node)
#define X3D_INDEXEDTRIANGLEFANSET(node) ((struct X3D_IndexedTriangleFanSet*)node)
#define X3D_INDEXEDTRIANGLESET(node) ((struct X3D_IndexedTriangleSet*)node)
#define X3D_INDEXEDTRIANGLESTRIPSET(node) ((struct X3D_IndexedTriangleStripSet*)node)
#define X3D_TRIANGLEFANSET(node) ((struct X3D_TriangleFanSet*)node)
#define X3D_TRIANGLESET(node) ((struct X3D_TriangleSet*)node)
#define X3D_TRIANGLESTRIPSET(node) ((struct X3D_TriangleStripSet*)node)
#define X3D_QUADSET(node) ((struct X3D_QuadSet*)node)
#define X3D_INDEXEDQUADSET(node) ((struct X3D_IndexedQuadSet*)node)
#define X3D_GEOORIGIN(node) ((struct X3D_GeoOrigin*)node)
#define X3D_GEOLOD(node) ((struct X3D_GeoLOD*)node)
#define X3D_GEOCOORD(node) ((struct X3D_GeoCoordinate*)node)
#define X3D_GEOVIEWPOINT(node) ((struct X3D_GeoViewpoint*)node)
#define X3D_GEOELEVATIONGRID(node) ((struct X3D_GeoElevationGrid*)node)
#define X3D_GEOLOCATION(node) ((struct X3D_GeoLocation*)node)
#define X3D_GEOTRANSFORM(node) ((struct X3D_GeoTransform*)node)
#define X3D_GEOPROXIMITYSENSOR(node) ((struct X3D_GeoProximitySensor*)node)
#define X3D_COLOR(node) ((struct X3D_Color*)node)
#define X3D_COORDINATE(node) ((struct X3D_Coordinate*)node)
#define X3D_NORMAL(node) ((struct X3D_Normal*)node)
#define X3D_TEXTURECOORDINATE(node) ((struct X3D_TextureCoordinate*)node)
#define X3D_IMAGETEXTURE(node) ((struct X3D_ImageTexture*)node)
#define X3D_TEXTUREPROPERTIES(node) ((struct X3D_TextureProperties*)node)
#define X3D_PIXELTEXTURE(node) ((struct X3D_PixelTexture*)node)
#undef DEBUG_VALIDNODE
#ifdef DEBUG_VALIDNODE	
#define X3D_NODE_CHECK(node) checkNode(node,__FILE__,__LINE__)
#define MARK_EVENT(node,offset) mark_event_check(node,(int) offset,__FILE__,__LINE__)
#else
#define X3D_NODE_CHECK(node)
#define MARK_EVENT(node,offset)	mark_event(node,(int) offset)
#endif
#define COPY_SFVEC3F_TO_POINT_XYZ(too,from) { too.x = from[0]; too.y = from[1]; too.z = from[2];}
#define COPY_POINT_XYZ_TO_SFVEC3F(too,from) { too[0] = (float) from.x; too[1] = (float) from.y; too[2] = (float) from.z;}
#define offsetPointer_deref(t, me, offs) ((t)(((char*)(me))+offs))

/* now, generated structures for each VRML/X3D Node*/
/***********************/
struct X3D_Anchor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	void * _parentResource;
	struct Multi_Node addChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Node children;
	struct Uni_String *description;
	struct X3D_Node *metadata;
	struct Multi_String parameter;
	struct Multi_Node removeChildren;
	struct Multi_String url;
};
extern struct X3D_Virt virt_Anchor;
/***********************/
struct X3D_Appearance {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *fillProperties;
	struct X3D_Node *lineProperties;
	struct X3D_Node *material;
	struct X3D_Node *metadata;
	struct Multi_Node shaders;
	struct X3D_Node *texture;
	struct X3D_Node *textureTransform;
};
extern struct X3D_Virt virt_Appearance;
/***********************/
struct X3D_Arc2D {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __numPoints;
	struct Multi_Vec2f __points;
	float endAngle;
	struct X3D_Node *metadata;
	float radius;
	float startAngle;
};
extern struct X3D_Virt virt_Arc2D;
/***********************/
struct X3D_ArcClose2D {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __numPoints;
	struct Multi_Vec2f __points;
	struct Uni_String *closureType;
	float endAngle;
	struct X3D_Node *metadata;
	float radius;
	int solid;
	float startAngle;
};
extern struct X3D_Virt virt_ArcClose2D;
/***********************/
struct X3D_AudioClip {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	double __inittime;
	void * __localFileName;
	int __sourceNumber;
	void * _parentResource;
	struct Uni_String *description;
	double duration_changed;
	double elapsedTime;
	int isActive;
	int isPaused;
	int loop;
	struct X3D_Node *metadata;
	double pauseTime;
	float pitch;
	double resumeTime;
	double startTime;
	double stopTime;
	struct Multi_String url;
};
extern struct X3D_Virt virt_AudioClip;
/***********************/
struct X3D_Background {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __VBO;
	struct X3D_Node *__backTexture;
	struct X3D_Node *__bottomTexture;
	struct Multi_Color __colours;
	struct X3D_Node *__frontTexture;
	struct X3D_Node *__leftTexture;
	struct Multi_Vec3f __points;
	int __quadcount;
	struct X3D_Node *__rightTexture;
	int __textureright;
	struct X3D_Node *__topTexture;
	void * _parentResource;
	struct Multi_String backUrl;
	double bindTime;
	struct Multi_String bottomUrl;
	struct Multi_String frontUrl;
	struct Multi_Float groundAngle;
	struct Multi_Color groundColor;
	int isBound;
	struct Multi_String leftUrl;
	struct X3D_Node *metadata;
	struct Multi_String rightUrl;
	int set_bind;
	struct Multi_Float skyAngle;
	struct Multi_Color skyColor;
	struct Multi_String topUrl;
	float transparency;
};
extern struct X3D_Virt virt_Background;
/***********************/
struct X3D_Billboard {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	double _rotationAngle;
	struct Multi_Node addChildren;
	struct SFVec3f axisOfRotation;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	struct Multi_Node removeChildren;
};
extern struct X3D_Virt virt_Billboard;
/***********************/
struct X3D_BooleanFilter {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int inputFalse;
	int inputNegate;
	int inputTrue;
	struct X3D_Node *metadata;
	int set_boolean;
};
extern struct X3D_Virt virt_BooleanFilter;
/***********************/
struct X3D_BooleanSequencer {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float key;
	struct Multi_Bool keyValue;
	struct X3D_Node *metadata;
	int next;
	int previous;
	float set_fraction;
	int value_changed;
};
extern struct X3D_Virt virt_BooleanSequencer;
/***********************/
struct X3D_BooleanToggle {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	int set_boolean;
	int toggle;
};
extern struct X3D_Virt virt_BooleanToggle;
/***********************/
struct X3D_BooleanTrigger {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	double set_triggerTime;
	int triggerTrue;
};
extern struct X3D_Virt virt_BooleanTrigger;
/***********************/
struct X3D_Box {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec3f __points;
	struct X3D_Node *metadata;
	struct SFVec3f size;
	int solid;
};
extern struct X3D_Virt virt_Box;
/***********************/
struct X3D_CADAssembly {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node _sortedChildren;
	struct Multi_Node addChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Multi_Node removeChildren;
};
extern struct X3D_Virt virt_CADAssembly;
/***********************/
struct X3D_CADFace {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct X3D_Node *shape;
};
extern struct X3D_Virt virt_CADFace;
/***********************/
struct X3D_CADLayer {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Multi_Node removeChildren;
	struct Multi_Bool visible;
};
extern struct X3D_Virt virt_CADLayer;
/***********************/
struct X3D_CADPart {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __do_anything;
	int __do_center;
	int __do_rotation;
	int __do_scale;
	int __do_scaleO;
	int __do_trans;
	struct Multi_Node _sortedChildren;
	struct Multi_Node addChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct SFVec3f center;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Multi_Node removeChildren;
	struct SFRotation rotation;
	struct SFVec3f scale;
	struct SFRotation scaleOrientation;
	struct SFVec3f translation;
};
extern struct X3D_Virt virt_CADPart;
/***********************/
struct X3D_Circle2D {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __numPoints;
	struct Multi_Vec2f __points;
	struct X3D_Node *metadata;
	float radius;
};
extern struct X3D_Virt virt_Circle2D;
/***********************/
struct X3D_ClipPlane {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int enabled;
	struct X3D_Node *metadata;
	struct SFVec4f plane;
};
extern struct X3D_Virt virt_ClipPlane;
/***********************/
struct X3D_Collision {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __hit;
	struct Multi_Node addChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Node children;
	int collide;
	double collideTime;
	int enabled;
	struct X3D_Node *metadata;
	struct X3D_Node *proxy;
	struct Multi_Node removeChildren;
};
extern struct X3D_Virt virt_Collision;
/***********************/
struct X3D_Color {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Color color;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_Color;
/***********************/
struct X3D_ColorInterpolator {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float key;
	struct Multi_Color keyValue;
	struct X3D_Node *metadata;
	float set_fraction;
	struct SFColor value_changed;
};
extern struct X3D_Virt virt_ColorInterpolator;
/***********************/
struct X3D_ColorRGBA {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_ColorRGBA color;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_ColorRGBA;
/***********************/
struct X3D_ComposedCubeMapTexture {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	void * _parentResource;
	struct X3D_Node *back;
	struct X3D_Node *bottom;
	struct X3D_Node *front;
	struct X3D_Node *left;
	struct X3D_Node *metadata;
	struct X3D_Node *right;
	struct X3D_Node *top;
};
extern struct X3D_Virt virt_ComposedCubeMapTexture;
/***********************/
struct X3D_ComposedShader {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int _initialized;
	int _retrievedURLData;
	pthread_t _shaderLoadThread;
	struct X3D_Node *_shaderUserDefinedFields;
	int _shaderUserNumber;
	int activate;
	int isSelected;
	int isValid;
	struct Uni_String *language;
	struct X3D_Node *metadata;
	struct Multi_Node parts;
};
extern struct X3D_Virt virt_ComposedShader;
/***********************/
struct X3D_Cone {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec3f __botpoints;
	int __coneTriangles;
	int __coneVBO;
	struct Multi_Vec3f __normals;
	struct Multi_Vec3f __sidepoints;
	int bottom;
	float bottomRadius;
	float height;
	struct X3D_Node *metadata;
	int side;
	int solid;
};
extern struct X3D_Virt virt_Cone;
/***********************/
struct X3D_Contour2D {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	struct Multi_Node removeChildren;
};
extern struct X3D_Virt virt_Contour2D;
/***********************/
struct X3D_ContourPolyLine2D {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec2d controlPoint;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_ContourPolyLine2D;
/***********************/
struct X3D_Coordinate {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Vec3f point;
};
extern struct X3D_Virt virt_Coordinate;
/***********************/
struct X3D_CoordinateDouble {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec2d controlPoint;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_CoordinateDouble;
/***********************/
struct X3D_CoordinateInterpolator {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float key;
	struct Multi_Vec3f keyValue;
	struct X3D_Node *metadata;
	float set_fraction;
	struct Multi_Vec3f value_changed;
};
extern struct X3D_Virt virt_CoordinateInterpolator;
/***********************/
struct X3D_CoordinateInterpolator2D {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float key;
	struct Multi_Vec2f keyValue;
	struct X3D_Node *metadata;
	float set_fraction;
	struct Multi_Vec2f value_changed;
};
extern struct X3D_Virt virt_CoordinateInterpolator2D;
/***********************/
struct X3D_Cylinder {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __cylinderTriangles;
	int __cylinderVBO;
	struct Multi_Vec3f __normals;
	struct Multi_Vec3f __points;
	int bottom;
	float height;
	struct X3D_Node *metadata;
	float radius;
	int side;
	int solid;
	int top;
};
extern struct X3D_Virt virt_Cylinder;
/***********************/
struct X3D_CylinderSensor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __oldEnabled;
	int _dlchange;
	struct SFRotation _oldrotation;
	struct SFVec3f _oldtrackPoint;
	struct SFVec3f _origPoint;
	float _radius;
	int autoOffset;
	struct Uni_String *description;
	float diskAngle;
	int enabled;
	int isActive;
	int isOver;
	float maxAngle;
	struct X3D_Node *metadata;
	float minAngle;
	float offset;
	struct SFRotation rotation_changed;
	struct SFVec3f trackPoint_changed;
};
extern struct X3D_Virt virt_CylinderSensor;
/***********************/
struct X3D_DISEntityManager {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addedEntities;
	struct Uni_String *address;
	int applicationID;
	struct Multi_Node mapping;
	struct X3D_Node *metadata;
	int port;
	struct Multi_Node removedEntities;
	int siteID;
};
extern struct X3D_Virt virt_DISEntityManager;
/***********************/
struct X3D_DISEntityTypeMapping {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int category;
	int country;
	int domain;
	int extra;
	int kind;
	struct X3D_Node *metadata;
	int specific;
	int subcategory;
	struct Multi_String url;
};
extern struct X3D_Virt virt_DISEntityTypeMapping;
/***********************/
struct X3D_DirectionalLight {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec4f _amb;
	struct SFVec4f _col;
	struct SFVec4f _dir;
	float ambientIntensity;
	struct SFColor color;
	struct SFVec3f direction;
	int global;
	float intensity;
	struct X3D_Node *metadata;
	int on;
};
extern struct X3D_Virt virt_DirectionalLight;
/***********************/
struct X3D_Disk2D {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __numPoints;
	struct Multi_Vec2f __points;
	int __simpleDisk;
	void * __texCoords;
	float innerRadius;
	struct X3D_Node *metadata;
	float outerRadius;
	int solid;
};
extern struct X3D_Virt virt_Disk2D;
/***********************/
struct X3D_EaseInEaseOut {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec2f easeInEaseOut;
	struct Multi_Float key;
	struct X3D_Node *metadata;
	float modifiedFraction_changed;
	float set_fraction;
};
extern struct X3D_Virt virt_EaseInEaseOut;
/***********************/
struct X3D_ElevationGrid {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 _coordIndex;
	struct Multi_Node attrib;
	int ccw;
	struct X3D_Node *color;
	int colorPerVertex;
	float creaseAngle;
	struct X3D_Node *fogCoord;
	struct Multi_Float height;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	int normalPerVertex;
	struct Multi_Float set_height;
	int solid;
	struct X3D_Node *texCoord;
	int xDimension;
	float xSpacing;
	int zDimension;
	float zSpacing;
};
extern struct X3D_Virt virt_ElevationGrid;
/***********************/
struct X3D_EspduTransform {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Uni_String *address;
	int applicationID;
	struct Multi_Float articulationParameterArray;
	struct Multi_Int32 articulationParameterChangeIndicatorArr;
	int articulationParameterCount;
	struct Multi_Int32 articulationParameterDesignatorArray;
	struct Multi_Int32 articulationParameterIdPartAttachedToAr;
	struct Multi_Int32 articulationParameterTypeArray;
	float articulationParameterValue0_changed;
	float articulationParameterValue1_changed;
	float articulationParameterValue2_changed;
	float articulationParameterValue3_changed;
	float articulationParameterValue4_changed;
	float articulationParameterValue5_changed;
	float articulationParameterValue6_changed;
	float articulationParameterValue7_changed;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct SFVec3f center;
	struct Multi_Node children;
	double collideTime;
	int collisionType;
	int deadReckoning;
	double detonateTime;
	struct SFVec3f detonationLocation;
	struct SFVec3f detonationRelativeLocation;
	int detonationResult;
	int enabled;
	int entityCategory;
	int entityCountry;
	int entityDomain;
	int entityExtra;
	int entityID;
	int entityKind;
	int entitySpecific;
	int entitySubCategory;
	int eventApplicationID;
	int eventEntityID;
	int eventNumber;
	int eventSiteID;
	int fireMissionIndex;
	int fired1;
	int fired2;
	double firedTime;
	float firingRange;
	int firingRate;
	int forceID;
	int fuse;
	int isActive;
	int isCollided;
	int isDetonated;
	int isNetworkReader;
	int isNetworkWriter;
	int isRtpHeaderHeard;
	int isStandAlone;
	struct SFVec3f linearAcceleration;
	struct SFVec3f linearVelocity;
	struct Uni_String *marking;
	struct X3D_Node *metadata;
	struct Uni_String *multicastRelayHost;
	int multicastRelayPort;
	int munitionApplicationID;
	struct SFVec3f munitionEndPoint;
	int munitionEntityID;
	int munitionQuantity;
	int munitionSiteID;
	struct SFVec3f munitionStartPoint;
	struct Uni_String *networkMode;
	int port;
	double readInterval;
	struct Multi_Node removeChildren;
	struct SFRotation rotation;
	int rtpHeaderExpected;
	struct SFVec3f scale;
	struct SFRotation scaleOrientation;
	float set_articulationParameterValue0;
	float set_articulationParameterValue1;
	float set_articulationParameterValue2;
	float set_articulationParameterValue3;
	float set_articulationParameterValue4;
	float set_articulationParameterValue5;
	float set_articulationParameterValue6;
	float set_articulationParameterValue7;
	int siteID;
	double timestamp;
	struct SFVec3f translation;
	int warhead;
	double writeInterval;
};
extern struct X3D_Virt virt_EspduTransform;
/***********************/
struct X3D_Extrusion {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int beginCap;
	int ccw;
	int convex;
	float creaseAngle;
	struct Multi_Vec2f crossSection;
	int endCap;
	struct X3D_Node *metadata;
	struct Multi_Rotation orientation;
	struct Multi_Vec2f scale;
	struct Multi_Vec2f set_crossSection;
	struct Multi_Rotation set_orientation;
	struct Multi_Vec2f set_scale;
	struct Multi_Vec3f set_spine;
	int solid;
	struct Multi_Vec3f spine;
};
extern struct X3D_Virt virt_Extrusion;
/***********************/
struct X3D_FillProperties {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int _enabled;
	struct SFVec2f _hatchScale;
	int filled;
	struct SFColor hatchColor;
	int hatchStyle;
	int hatched;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_FillProperties;
/***********************/
struct X3D_FloatVertexAttribute {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *name;
	int numComponents;
	struct Multi_Float value;
};
extern struct X3D_Virt virt_FloatVertexAttribute;
/***********************/
struct X3D_Fog {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	double bindTime;
	struct SFColor color;
	struct Uni_String *fogType;
	int isBound;
	struct X3D_Node *metadata;
	int set_bind;
	float visibilityRange;
};
extern struct X3D_Virt virt_Fog;
/***********************/
struct X3D_FogCoordinate {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float depth;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_FogCoordinate;
/***********************/
struct X3D_FontStyle {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_String family;
	int horizontal;
	struct Multi_String justify;
	struct Uni_String *language;
	int leftToRight;
	struct X3D_Node *metadata;
	float size;
	float spacing;
	struct Uni_String *style;
	int topToBottom;
};
extern struct X3D_Virt virt_FontStyle;
/***********************/
struct X3D_GeneratedCubeMapTexture {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __textureTableIndex;
	struct X3D_Node *metadata;
	int size;
	struct X3D_Node *textureProperties;
	struct Uni_String *update;
};
extern struct X3D_Virt virt_GeneratedCubeMapTexture;
/***********************/
struct X3D_GeoCoordinate {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 __geoSystem;
	struct Multi_Vec3f __movedCoords;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	struct X3D_Node *metadata;
	struct Multi_Vec3d point;
};
extern struct X3D_Virt virt_GeoCoordinate;
/***********************/
struct X3D_GeoElevationGrid {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 __geoSystem;
	struct Multi_Int32 _coordIndex;
	int ccw;
	struct X3D_Node *color;
	int colorPerVertex;
	double creaseAngle;
	struct SFVec3d geoGridOrigin;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	struct Multi_Double height;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	int normalPerVertex;
	struct Multi_Double set_height;
	int solid;
	struct X3D_Node *texCoord;
	int xDimension;
	double xSpacing;
	float yScale;
	int zDimension;
	double zSpacing;
};
extern struct X3D_Virt virt_GeoElevationGrid;
/***********************/
struct X3D_GeoLOD {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *__child1Node;
	struct X3D_Node *__child2Node;
	struct X3D_Node *__child3Node;
	struct X3D_Node *__child4Node;
	int __childloadstatus;
	struct Multi_Int32 __geoSystem;
	int __inRange;
	int __level;
	struct SFVec3d __movedCoords;
	struct X3D_Node *__rootUrl;
	int __rooturlloadstatus;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct SFVec3d center;
	struct Multi_String child1Url;
	struct Multi_String child2Url;
	struct Multi_String child3Url;
	struct Multi_String child4Url;
	struct Multi_Node children;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	int level_changed;
	struct X3D_Node *metadata;
	float range;
	struct Multi_Node rootNode;
	struct Multi_String rootUrl;
};
extern struct X3D_Virt virt_GeoLOD;
/***********************/
struct X3D_GeoLocation {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 __geoSystem;
	struct SFVec4d __localOrient;
	struct SFVec3d __movedCoords;
	struct Multi_Node __oldChildren;
	struct SFVec3d __oldgeoCoords;
	struct Multi_Node _sortedChildren;
	struct Multi_Node addChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Node children;
	struct SFVec3d geoCoords;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	struct X3D_Node *metadata;
	struct Multi_Node removeChildren;
};
extern struct X3D_Virt virt_GeoLocation;
/***********************/
struct X3D_GeoMetadata {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node data;
	struct X3D_Node *metadata;
	struct Multi_String summary;
	struct Multi_String url;
};
extern struct X3D_Virt virt_GeoMetadata;
/***********************/
struct X3D_GeoOrigin {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 __geoSystem;
	struct SFVec3d __movedCoords;
	struct Multi_String __oldMFString;
	struct SFVec3d __oldgeoCoords;
	struct SFVec4d __rotyup;
	struct SFVec3d geoCoords;
	struct Multi_String geoSystem;
	struct X3D_Node *metadata;
	int rotateYUp;
};
extern struct X3D_Virt virt_GeoOrigin;
/***********************/
struct X3D_GeoPositionInterpolator {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 __geoSystem;
	struct Multi_Vec3d __movedValue;
	struct Multi_Float __oldKeyPtr;
	struct Multi_Vec3d __oldKeyValuePtr;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	struct SFVec3d geovalue_changed;
	struct Multi_Float key;
	struct Multi_Vec3d keyValue;
	struct X3D_Node *metadata;
	float set_fraction;
	struct SFVec3f value_changed;
};
extern struct X3D_Virt virt_GeoPositionInterpolator;
/***********************/
struct X3D_GeoProximitySensor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 __geoSystem;
	int __hit;
	struct SFVec4d __localOrient;
	struct SFVec3d __movedCoords;
	int __oldEnabled;
	struct SFVec3d __oldGeoCenter;
	struct SFVec3f __oldSize;
	struct SFVec3f __t1;
	struct SFRotation __t2;
	struct SFVec3f centerOfRotation_changed;
	int enabled;
	double enterTime;
	double exitTime;
	struct SFVec3d geoCenter;
	struct SFVec3d geoCoord_changed;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	int isActive;
	struct X3D_Node *metadata;
	struct SFRotation orientation_changed;
	struct SFVec3f position_changed;
	struct SFVec3f size;
};
extern struct X3D_Virt virt_GeoProximitySensor;
/***********************/
struct X3D_GeoTouchSensor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 __geoSystem;
	int __oldEnabled;
	struct SFVec3f _oldhitNormal;
	struct SFVec3f _oldhitPoint;
	struct SFVec2f _oldhitTexCoord;
	struct Uni_String *description;
	int enabled;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	struct SFVec3d hitGeoCoord_changed;
	struct SFVec3f hitNormal_changed;
	struct SFVec3f hitPoint_changed;
	struct SFVec2f hitTexCoord_changed;
	int isActive;
	int isOver;
	struct X3D_Node *metadata;
	double touchTime;
};
extern struct X3D_Virt virt_GeoTouchSensor;
/***********************/
struct X3D_GeoTransform {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __do_center;
	int __do_rotation;
	int __do_scale;
	int __do_scaleO;
	int __do_trans;
	struct Multi_Int32 __geoSystem;
	struct SFVec4d __localOrient;
	struct SFVec3d __movedCoords;
	struct Multi_Node __oldChildren;
	struct SFVec3d __oldGeoCenter;
	struct Multi_Node _sortedChildren;
	struct Multi_Node addChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Node children;
	struct SFVec3d geoCenter;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	struct X3D_Node *metadata;
	struct Multi_Node removeChildren;
	struct SFRotation rotation;
	struct SFVec3f scale;
	struct SFRotation scaleOrientation;
	struct SFVec3f translation;
};
extern struct X3D_Virt virt_GeoTransform;
/***********************/
struct X3D_GeoViewpoint {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 __geoSystem;
	struct SFRotation __movedOrientation;
	struct SFVec3d __movedPosition;
	float __oldFieldOfView;
	int __oldHeadlight;
	int __oldJump;
	struct Multi_String __oldMFString;
	struct Uni_String *__oldSFString;
	double bindTime;
	struct Uni_String *description;
	float fieldOfView;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	int headlight;
	int isBound;
	int jump;
	struct X3D_Node *metadata;
	struct Multi_String navType;
	struct SFRotation orientation;
	struct SFVec3d position;
	int set_bind;
	struct SFRotation set_orientation;
	struct SFVec3d set_position;
	float speedFactor;
};
extern struct X3D_Virt virt_GeoViewpoint;
/***********************/
struct X3D_Group {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node FreeWRL_PROTOInterfaceNodes;
	int FreeWRL__protoDef;
	struct Multi_Node _sortedChildren;
	struct Multi_Node addChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	struct Multi_Node removeChildren;
};
extern struct X3D_Virt virt_Group;
/***********************/
struct X3D_HAnimDisplacer {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 coordIndex;
	struct Multi_Vec3f displacements;
	struct X3D_Node *metadata;
	struct Uni_String *name;
	float weight;
};
extern struct X3D_Virt virt_HAnimDisplacer;
/***********************/
struct X3D_HAnimHumanoid {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct SFVec3f center;
	struct Multi_String info;
	struct Multi_Node joints;
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct SFRotation rotation;
	struct SFVec3f scale;
	struct SFRotation scaleOrientation;
	struct Multi_Node segments;
	struct Multi_Node sites;
	struct Multi_Node skeleton;
	struct Multi_Node skin;
	struct X3D_Node *skinCoord;
	struct X3D_Node *skinNormal;
	struct SFVec3f translation;
	struct Uni_String *version;
	struct Multi_Node viewpoints;
};
extern struct X3D_Virt virt_HAnimHumanoid;
/***********************/
struct X3D_HAnimJoint {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __do_center;
	int __do_rotation;
	int __do_scale;
	int __do_scaleO;
	int __do_trans;
	struct Multi_Node addChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct SFVec3f center;
	struct Multi_Node children;
	struct Multi_Node displacers;
	struct SFRotation limitOrientation;
	struct Multi_Float llimit;
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Multi_Node removeChildren;
	struct SFRotation rotation;
	struct SFVec3f scale;
	struct SFRotation scaleOrientation;
	struct Multi_Int32 skinCoordIndex;
	struct Multi_Float skinCoordWeight;
	struct Multi_Float stiffness;
	struct SFVec3f translation;
	struct Multi_Float ulimit;
};
extern struct X3D_Virt virt_HAnimJoint;
/***********************/
struct X3D_HAnimSegment {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct SFVec3f centerOfMass;
	struct Multi_Node children;
	struct X3D_Node *coord;
	struct Multi_Node displacers;
	float mass;
	struct X3D_Node *metadata;
	struct Multi_Float momentsOfInertia;
	struct Uni_String *name;
	struct Multi_Node removeChildren;
};
extern struct X3D_Virt virt_HAnimSegment;
/***********************/
struct X3D_HAnimSite {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __do_center;
	int __do_rotation;
	int __do_scale;
	int __do_scaleO;
	int __do_trans;
	struct Multi_Node addChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct SFVec3f center;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Multi_Node removeChildren;
	struct SFRotation rotation;
	struct SFVec3f scale;
	struct SFRotation scaleOrientation;
	struct SFVec3f translation;
};
extern struct X3D_Virt virt_HAnimSite;
/***********************/
struct X3D_ImageCubeMapTexture {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __regenSubTextures;
	struct Multi_Node __subTextures;
	int __textureTableIndex;
	void * _parentResource;
	struct X3D_Node *metadata;
	struct X3D_Node *textureProperties;
	struct Multi_String url;
};
extern struct X3D_Virt virt_ImageCubeMapTexture;
/***********************/
struct X3D_ImageTexture {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __textureTableIndex;
	void * _parentResource;
	struct X3D_Node *metadata;
	int repeatS;
	int repeatT;
	struct X3D_Node *textureProperties;
	struct Multi_String url;
};
extern struct X3D_Virt virt_ImageTexture;
/***********************/
struct X3D_IndexedFaceSet {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node attrib;
	int ccw;
	struct X3D_Node *color;
	struct Multi_Int32 colorIndex;
	int colorPerVertex;
	int convex;
	struct X3D_Node *coord;
	struct Multi_Int32 coordIndex;
	float creaseAngle;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	struct Multi_Int32 normalIndex;
	int normalPerVertex;
	struct Multi_Int32 set_colorIndex;
	struct Multi_Int32 set_coordIndex;
	struct Multi_Int32 set_normalIndex;
	struct Multi_Int32 set_texCoordIndex;
	int solid;
	struct X3D_Node *texCoord;
	struct Multi_Int32 texCoordIndex;
};
extern struct X3D_Virt virt_IndexedFaceSet;
/***********************/
struct X3D_IndexedLineSet {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	void * __colours;
	int __segCount;
	void * __vertArr;
	void * __vertIndx;
	void * __vertexCount;
	void * __vertices;
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct Multi_Int32 colorIndex;
	int colorPerVertex;
	struct X3D_Node *coord;
	struct Multi_Int32 coordIndex;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct Multi_Int32 set_colorIndex;
	struct Multi_Int32 set_coordIndex;
};
extern struct X3D_Virt virt_IndexedLineSet;
/***********************/
struct X3D_IndexedQuadSet {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 _coordIndex;
	struct Multi_Node attrib;
	int ccw;
	struct X3D_Node *color;
	int colorPerVertex;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct Multi_Int32 index;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	int normalPerVertex;
	struct Multi_Int32 set_index;
	int solid;
	struct X3D_Node *texCoord;
};
extern struct X3D_Virt virt_IndexedQuadSet;
/***********************/
struct X3D_IndexedTriangleFanSet {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 _coordIndex;
	struct Multi_Node attrib;
	int ccw;
	struct X3D_Node *color;
	int colorPerVertex;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct Multi_Int32 index;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	int normalPerVertex;
	struct Multi_Int32 set_index;
	int solid;
	struct X3D_Node *texCoord;
};
extern struct X3D_Virt virt_IndexedTriangleFanSet;
/***********************/
struct X3D_IndexedTriangleSet {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 _coordIndex;
	struct Multi_Node attrib;
	int ccw;
	struct X3D_Node *color;
	int colorPerVertex;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct Multi_Int32 index;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	int normalPerVertex;
	struct Multi_Int32 set_index;
	int solid;
	struct X3D_Node *texCoord;
};
extern struct X3D_Virt virt_IndexedTriangleSet;
/***********************/
struct X3D_IndexedTriangleStripSet {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 _coordIndex;
	struct Multi_Node attrib;
	int ccw;
	struct X3D_Node *color;
	int colorPerVertex;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct Multi_Int32 index;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	int normalPerVertex;
	struct Multi_Int32 set_index;
	int solid;
	struct X3D_Node *texCoord;
};
extern struct X3D_Virt virt_IndexedTriangleStripSet;
/***********************/
struct X3D_Inline {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node __children;
	void * __loadResource;
	int __loadstatus;
	void * _parentResource;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	int load;
	struct X3D_Node *metadata;
	struct Multi_String url;
};
extern struct X3D_Virt virt_Inline;
/***********************/
struct X3D_IntegerSequencer {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float key;
	struct Multi_Int32 keyValue;
	struct X3D_Node *metadata;
	int next;
	int previous;
	float set_fraction;
	int value_changed;
};
extern struct X3D_Virt virt_IntegerSequencer;
/***********************/
struct X3D_IntegerTrigger {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int integerKey;
	struct X3D_Node *metadata;
	int set_boolean;
	int triggerValue;
};
extern struct X3D_Virt virt_IntegerTrigger;
/***********************/
struct X3D_KeySensor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __oldEnabled;
	int actionKeyPress;
	int actionKeyRelease;
	int altKey;
	int controlKey;
	int enabled;
	int isActive;
	struct Uni_String *keyPress;
	struct Uni_String *keyRelease;
	struct X3D_Node *metadata;
	int shiftKey;
};
extern struct X3D_Virt virt_KeySensor;
/***********************/
struct X3D_LOD {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __isX3D;
	void * _selected;
	struct Multi_Node addChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct SFVec3f center;
	struct Multi_Node children;
	int forceTransitions;
	struct Multi_Node level;
	int levelChanged;
	struct X3D_Node *metadata;
	struct Multi_Float range;
	struct Multi_Node removeChildren;
};
extern struct X3D_Virt virt_LOD;
/***********************/
struct X3D_LineProperties {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int applied;
	int linetype;
	float linewidthScaleFactor;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_LineProperties;
/***********************/
struct X3D_LineSet {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __segCount;
	void * __vertArr;
	void * __vertIndx;
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct Multi_Int32 vertexCount;
};
extern struct X3D_Virt virt_LineSet;
/***********************/
struct X3D_LoadSensor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	double __StartLoadTime;
	int __finishedloading;
	int __loading;
	int __oldEnabled;
	int enabled;
	int isActive;
	int isLoaded;
	double loadTime;
	struct X3D_Node *metadata;
	float progress;
	double timeOut;
	struct Multi_Node watchList;
};
extern struct X3D_Virt virt_LoadSensor;
/***********************/
struct X3D_LocalFog {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFColor color;
	int enabled;
	struct Uni_String *fogType;
	struct X3D_Node *metadata;
	float visibilityRange;
};
extern struct X3D_Virt virt_LocalFog;
/***********************/
struct X3D_Material {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float _verifiedColor;
	float ambientIntensity;
	struct SFColor diffuseColor;
	struct SFColor emissiveColor;
	struct X3D_Node *metadata;
	float shininess;
	struct SFColor specularColor;
	float transparency;
};
extern struct X3D_Virt virt_Material;
/***********************/
struct X3D_Matrix3VertexAttribute {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Multi_Matrix3f value;
};
extern struct X3D_Virt virt_Matrix3VertexAttribute;
/***********************/
struct X3D_Matrix4VertexAttribute {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Multi_Matrix4f value;
};
extern struct X3D_Virt virt_Matrix4VertexAttribute;
/***********************/
struct X3D_MetadataDouble {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Uni_String *reference;
	struct Multi_Double value;
};
extern struct X3D_Virt virt_MetadataDouble;
/***********************/
struct X3D_MetadataFloat {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Uni_String *reference;
	struct Multi_Float value;
};
extern struct X3D_Virt virt_MetadataFloat;
/***********************/
struct X3D_MetadataInteger {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Uni_String *reference;
	struct Multi_Int32 value;
};
extern struct X3D_Virt virt_MetadataInteger;
/***********************/
struct X3D_MetadataMFBool {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Bool setValue;
	double tickTime;
	struct Multi_Bool value;
	struct Multi_Bool valueChanged;
};
extern struct X3D_Virt virt_MetadataMFBool;
/***********************/
struct X3D_MetadataMFColor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Color setValue;
	double tickTime;
	struct Multi_Color value;
	struct Multi_Color valueChanged;
};
extern struct X3D_Virt virt_MetadataMFColor;
/***********************/
struct X3D_MetadataMFColorRGBA {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_ColorRGBA setValue;
	double tickTime;
	struct Multi_ColorRGBA value;
	struct Multi_ColorRGBA valueChanged;
};
extern struct X3D_Virt virt_MetadataMFColorRGBA;
/***********************/
struct X3D_MetadataMFDouble {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Double setValue;
	double tickTime;
	struct Multi_Double value;
	struct Multi_Double valueChanged;
};
extern struct X3D_Virt virt_MetadataMFDouble;
/***********************/
struct X3D_MetadataMFFloat {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float setValue;
	double tickTime;
	struct Multi_Float value;
	struct Multi_Float valueChanged;
};
extern struct X3D_Virt virt_MetadataMFFloat;
/***********************/
struct X3D_MetadataMFInt32 {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 setValue;
	double tickTime;
	struct Multi_Int32 value;
	struct Multi_Int32 valueChanged;
};
extern struct X3D_Virt virt_MetadataMFInt32;
/***********************/
struct X3D_MetadataMFMatrix3d {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Matrix3d setValue;
	double tickTime;
	struct Multi_Matrix3d value;
	struct Multi_Matrix3d valueChanged;
};
extern struct X3D_Virt virt_MetadataMFMatrix3d;
/***********************/
struct X3D_MetadataMFMatrix3f {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Matrix3f setValue;
	double tickTime;
	struct Multi_Matrix3f value;
	struct Multi_Matrix3f valueChanged;
};
extern struct X3D_Virt virt_MetadataMFMatrix3f;
/***********************/
struct X3D_MetadataMFMatrix4d {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Matrix4d setValue;
	double tickTime;
	struct Multi_Matrix4d value;
	struct Multi_Matrix4d valueChanged;
};
extern struct X3D_Virt virt_MetadataMFMatrix4d;
/***********************/
struct X3D_MetadataMFMatrix4f {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Matrix4f setValue;
	double tickTime;
	struct Multi_Matrix4f value;
	struct Multi_Matrix4f valueChanged;
};
extern struct X3D_Virt virt_MetadataMFMatrix4f;
/***********************/
struct X3D_MetadataMFNode {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node setValue;
	double tickTime;
	struct Multi_Node value;
	struct Multi_Node valueChanged;
};
extern struct X3D_Virt virt_MetadataMFNode;
/***********************/
struct X3D_MetadataMFRotation {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Rotation setValue;
	double tickTime;
	struct Multi_Rotation value;
	struct Multi_Rotation valueChanged;
};
extern struct X3D_Virt virt_MetadataMFRotation;
/***********************/
struct X3D_MetadataMFString {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_String setValue;
	double tickTime;
	struct Multi_String value;
	struct Multi_String valueChanged;
};
extern struct X3D_Virt virt_MetadataMFString;
/***********************/
struct X3D_MetadataMFTime {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Time setValue;
	double tickTime;
	struct Multi_Time value;
	struct Multi_Time valueChanged;
};
extern struct X3D_Virt virt_MetadataMFTime;
/***********************/
struct X3D_MetadataMFVec2d {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec2d setValue;
	double tickTime;
	struct Multi_Vec2d value;
	struct Multi_Vec2d valueChanged;
};
extern struct X3D_Virt virt_MetadataMFVec2d;
/***********************/
struct X3D_MetadataMFVec2f {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec2f setValue;
	double tickTime;
	struct Multi_Vec2f value;
	struct Multi_Vec2f valueChanged;
};
extern struct X3D_Virt virt_MetadataMFVec2f;
/***********************/
struct X3D_MetadataMFVec3d {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec3d setValue;
	double tickTime;
	struct Multi_Vec3d value;
	struct Multi_Vec3d valueChanged;
};
extern struct X3D_Virt virt_MetadataMFVec3d;
/***********************/
struct X3D_MetadataMFVec3f {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec3f setValue;
	double tickTime;
	struct Multi_Vec3f value;
	struct Multi_Vec3f valueChanged;
};
extern struct X3D_Virt virt_MetadataMFVec3f;
/***********************/
struct X3D_MetadataMFVec4d {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec4d setValue;
	double tickTime;
	struct Multi_Vec4d value;
	struct Multi_Vec4d valueChanged;
};
extern struct X3D_Virt virt_MetadataMFVec4d;
/***********************/
struct X3D_MetadataMFVec4f {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec4f setValue;
	double tickTime;
	struct Multi_Vec4f value;
	struct Multi_Vec4f valueChanged;
};
extern struct X3D_Virt virt_MetadataMFVec4f;
/***********************/
struct X3D_MetadataSFBool {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int setValue;
	double tickTime;
	int value;
	int valueChanged;
};
extern struct X3D_Virt virt_MetadataSFBool;
/***********************/
struct X3D_MetadataSFColor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFColor setValue;
	double tickTime;
	struct SFColor value;
	struct SFColor valueChanged;
};
extern struct X3D_Virt virt_MetadataSFColor;
/***********************/
struct X3D_MetadataSFColorRGBA {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFColorRGBA setValue;
	double tickTime;
	struct SFColorRGBA value;
	struct SFColorRGBA valueChanged;
};
extern struct X3D_Virt virt_MetadataSFColorRGBA;
/***********************/
struct X3D_MetadataSFDouble {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	double setValue;
	double tickTime;
	double value;
	double valueChanged;
};
extern struct X3D_Virt virt_MetadataSFDouble;
/***********************/
struct X3D_MetadataSFFloat {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float setValue;
	double tickTime;
	float value;
	float valueChanged;
};
extern struct X3D_Virt virt_MetadataSFFloat;
/***********************/
struct X3D_MetadataSFImage {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 setValue;
	double tickTime;
	struct Multi_Int32 value;
	struct Multi_Int32 valueChanged;
};
extern struct X3D_Virt virt_MetadataSFImage;
/***********************/
struct X3D_MetadataSFInt32 {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int setValue;
	double tickTime;
	int value;
	int valueChanged;
};
extern struct X3D_Virt virt_MetadataSFInt32;
/***********************/
struct X3D_MetadataSFMatrix3d {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFMatrix3d setValue;
	double tickTime;
	struct SFMatrix3d value;
	struct SFMatrix3d valueChanged;
};
extern struct X3D_Virt virt_MetadataSFMatrix3d;
/***********************/
struct X3D_MetadataSFMatrix3f {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFMatrix3f setValue;
	double tickTime;
	struct SFMatrix3f value;
	struct SFMatrix3f valueChanged;
};
extern struct X3D_Virt virt_MetadataSFMatrix3f;
/***********************/
struct X3D_MetadataSFMatrix4d {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFMatrix4d setValue;
	double tickTime;
	struct SFMatrix4d value;
	struct SFMatrix4d valueChanged;
};
extern struct X3D_Virt virt_MetadataSFMatrix4d;
/***********************/
struct X3D_MetadataSFMatrix4f {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFMatrix4f setValue;
	double tickTime;
	struct SFMatrix4f value;
	struct SFMatrix4f valueChanged;
};
extern struct X3D_Virt virt_MetadataSFMatrix4f;
/***********************/
struct X3D_MetadataSFNode {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *setValue;
	double tickTime;
	struct X3D_Node *value;
	struct X3D_Node *valueChanged;
};
extern struct X3D_Virt virt_MetadataSFNode;
/***********************/
struct X3D_MetadataSFRotation {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFRotation setValue;
	double tickTime;
	struct SFRotation value;
	struct SFRotation valueChanged;
};
extern struct X3D_Virt virt_MetadataSFRotation;
/***********************/
struct X3D_MetadataSFString {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Uni_String *setValue;
	double tickTime;
	struct Uni_String *value;
	struct Uni_String *valueChanged;
};
extern struct X3D_Virt virt_MetadataSFString;
/***********************/
struct X3D_MetadataSFTime {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	double setValue;
	double tickTime;
	double value;
	double valueChanged;
};
extern struct X3D_Virt virt_MetadataSFTime;
/***********************/
struct X3D_MetadataSFVec2d {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec2d setValue;
	double tickTime;
	struct SFVec2d value;
	struct SFVec2d valueChanged;
};
extern struct X3D_Virt virt_MetadataSFVec2d;
/***********************/
struct X3D_MetadataSFVec2f {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec2f setValue;
	double tickTime;
	struct SFVec2f value;
	struct SFVec2f valueChanged;
};
extern struct X3D_Virt virt_MetadataSFVec2f;
/***********************/
struct X3D_MetadataSFVec3d {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec3d setValue;
	double tickTime;
	struct SFVec3d value;
	struct SFVec3d valueChanged;
};
extern struct X3D_Virt virt_MetadataSFVec3d;
/***********************/
struct X3D_MetadataSFVec3f {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec3f setValue;
	double tickTime;
	struct SFVec3f value;
	struct SFVec3f valueChanged;
};
extern struct X3D_Virt virt_MetadataSFVec3f;
/***********************/
struct X3D_MetadataSFVec4d {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec4d setValue;
	double tickTime;
	struct SFVec4d value;
	struct SFVec4d valueChanged;
};
extern struct X3D_Virt virt_MetadataSFVec4d;
/***********************/
struct X3D_MetadataSFVec4f {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec4f setValue;
	double tickTime;
	struct SFVec4f value;
	struct SFVec4f valueChanged;
};
extern struct X3D_Virt virt_MetadataSFVec4f;
/***********************/
struct X3D_MetadataSet {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Uni_String *reference;
	struct Multi_Node value;
};
extern struct X3D_Virt virt_MetadataSet;
/***********************/
struct X3D_MetadataString {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Uni_String *reference;
	struct Multi_String value;
};
extern struct X3D_Virt virt_MetadataString;
/***********************/
struct X3D_MovieTexture {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __textureTableIndex;
	void * _parentResource;
	struct Uni_String *description;
	double duration_changed;
	double elapsedTime;
	int isActive;
	double isPaused;
	int loop;
	struct X3D_Node *metadata;
	double pauseTime;
	int repeatS;
	int repeatT;
	double resumeTime;
	float speed;
	double startTime;
	double stopTime;
	struct X3D_Node *textureProperties;
	struct Multi_String url;
};
extern struct X3D_Virt virt_MovieTexture;
/***********************/
struct X3D_MultiTexture {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	void * __params;
	float alpha;
	struct SFColor color;
	struct Multi_String function;
	struct X3D_Node *metadata;
	struct Multi_String mode;
	struct Multi_String source;
	struct Multi_Node texture;
};
extern struct X3D_Virt virt_MultiTexture;
/***********************/
struct X3D_MultiTextureCoordinate {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Node texCoord;
};
extern struct X3D_Virt virt_MultiTextureCoordinate;
/***********************/
struct X3D_MultiTextureTransform {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Node textureTransform;
};
extern struct X3D_Virt virt_MultiTextureTransform;
/***********************/
struct X3D_NavigationInfo {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float avatarSize;
	double bindTime;
	int headlight;
	int isBound;
	struct X3D_Node *metadata;
	int set_bind;
	float speed;
	int transitionComplete;
	double transitionTime;
	struct Multi_String transitionType;
	struct Multi_String type;
	float visibilityLimit;
};
extern struct X3D_Virt virt_NavigationInfo;
/***********************/
struct X3D_Normal {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Vec3f vector;
};
extern struct X3D_Virt virt_Normal;
/***********************/
struct X3D_NormalInterpolator {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float key;
	struct Multi_Vec3f keyValue;
	struct X3D_Node *metadata;
	float set_fraction;
	struct Multi_Vec3f value_changed;
};
extern struct X3D_Virt virt_NormalInterpolator;
/***********************/
struct X3D_NurbsCurve {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *controlPoint;
	struct Multi_Double knot;
	struct X3D_Node *metadata;
	int order;
	int tessellation;
	struct Multi_Double weight;
};
extern struct X3D_Virt virt_NurbsCurve;
/***********************/
struct X3D_NurbsCurve2D {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec2d controlPoint;
	struct Multi_Double knot;
	struct X3D_Node *metadata;
	int order;
	int tessellation;
	struct Multi_Double weight;
};
extern struct X3D_Virt virt_NurbsCurve2D;
/***********************/
struct X3D_NurbsOrientationInterpolator {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *controlPoint;
	struct Multi_Double knot;
	struct X3D_Node *metadata;
	int order;
	float set_fraction;
	struct SFRotation value_changed;
	struct Multi_Double weight;
};
extern struct X3D_Virt virt_NurbsOrientationInterpolator;
/***********************/
struct X3D_NurbsPatchSurface {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *controlPoint;
	struct X3D_Node *metadata;
	int solid;
	struct X3D_Node *texCoord;
	int uClosed;
	int uDimension;
	struct Multi_Double uKnot;
	int uOrder;
	int uTessellation;
	int vClosed;
	int vDimension;
	struct Multi_Double vKnot;
	int vOrder;
	int vTessellation;
	struct Multi_Double weight;
};
extern struct X3D_Virt virt_NurbsPatchSurface;
/***********************/
struct X3D_NurbsPositionInterpolator {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *controlPoint;
	struct Multi_Double knot;
	struct X3D_Node *metadata;
	int order;
	float set_fraction;
	struct SFVec3f value_changed;
	struct Multi_Double weight;
};
extern struct X3D_Virt virt_NurbsPositionInterpolator;
/***********************/
struct X3D_NurbsSet {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addGeometry;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Node geometry;
	struct X3D_Node *metadata;
	struct Multi_Node removeGeometry;
	float tessellationScale;
};
extern struct X3D_Virt virt_NurbsSet;
/***********************/
struct X3D_NurbsSurfaceInterpolator {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *controlPoint;
	struct X3D_Node *metadata;
	struct SFVec3f normal_changed;
	struct SFVec3f position_changed;
	struct SFVec2f set_fraction;
	int uDimension;
	struct Multi_Double uKnot;
	int uOrder;
	int vDimension;
	struct Multi_Double vKnot;
	int vOrder;
};
extern struct X3D_Virt virt_NurbsSurfaceInterpolator;
/***********************/
struct X3D_NurbsSweptSurface {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int ccw;
	struct X3D_Node *crossSectionCurve;
	struct X3D_Node *metadata;
	int solid;
	struct X3D_Node *trajectoryCurve;
};
extern struct X3D_Virt virt_NurbsSweptSurface;
/***********************/
struct X3D_NurbsSwungSurface {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int ccw;
	struct X3D_Node *metadata;
	struct X3D_Node *profileCurve;
	int solid;
	struct X3D_Node *trajectoryCurve;
};
extern struct X3D_Virt virt_NurbsSwungSurface;
/***********************/
struct X3D_NurbsTextureCoordinate {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec2f controlPoint;
	struct X3D_Node *metadata;
	int uDimension;
	struct Multi_Double uKnot;
	int uOrder;
	int vDimension;
	struct Multi_Double vKnot;
	int vOrder;
	struct Multi_Float weight;
};
extern struct X3D_Virt virt_NurbsTextureCoordinate;
/***********************/
struct X3D_NurbsTrimmedSurface {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addTrimmingContour;
	struct X3D_Node *controlPoint;
	struct X3D_Node *metadata;
	struct Multi_Node removeTrimmingContour;
	int solid;
	struct X3D_Node *texCoord;
	struct Multi_Node trimmingContour;
	int uClosed;
	int uDimension;
	struct Multi_Double uKnot;
	int uOrder;
	int uTesselation;
	int vClosed;
	int vDimension;
	struct Multi_Double vKnot;
	int vOrder;
	int vTesselation;
	struct Multi_Double weight;
};
extern struct X3D_Virt virt_NurbsTrimmedSurface;
/***********************/
struct X3D_OSC_Sensor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int FIFOsize;
	struct X3D_Node *__oldmetadata;
	void * _floatInpFIFO;
	void * _floatOutFIFO;
	void * _int32InpFIFO;
	void * _int32OutFIFO;
	int _status;
	void * _stringInpFIFO;
	void * _stringOutFIFO;
	struct Multi_Node _talkToNodes;
	struct Uni_String *description;
	int enabled;
	struct Uni_String *filter;
	float floatInp;
	int gotEvents;
	struct Uni_String *handler;
	int int32Inp;
	struct Uni_String *listenfor;
	struct X3D_Node *metadata;
	int port;
	struct Uni_String *protocol;
	struct Uni_String *stringInp;
	struct Multi_String talksTo;
};
extern struct X3D_Virt virt_OSC_Sensor;
/***********************/
struct X3D_OrientationInterpolator {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float key;
	struct Multi_Rotation keyValue;
	struct X3D_Node *metadata;
	float set_fraction;
	struct SFRotation value_changed;
};
extern struct X3D_Virt virt_OrientationInterpolator;
/***********************/
struct X3D_OrthoViewpoint {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	double bindTime;
	struct SFVec3f centerOfRotation;
	struct Uni_String *description;
	struct Multi_Float fieldOfView;
	int isBound;
	int jump;
	struct X3D_Node *metadata;
	struct SFRotation orientation;
	struct SFVec3f position;
	int retainUserOffsets;
	int set_bind;
};
extern struct X3D_Virt virt_OrthoViewpoint;
/***********************/
struct X3D_PackagedShader {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int _initialized;
	int _retrievedURLData;
	pthread_t _shaderLoadThread;
	struct X3D_Node *_shaderUserDefinedFields;
	int _shaderUserNumber;
	int activate;
	int isSelected;
	int isValid;
	struct Uni_String *language;
	struct X3D_Node *metadata;
	struct Multi_String url;
};
extern struct X3D_Virt virt_PackagedShader;
/***********************/
struct X3D_PickableGroup {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node FreeWRL_PROTOInterfaceNodes;
	int FreeWRL__protoDef;
	struct Multi_Node addChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	struct Multi_String objectType;
	int pickable;
	struct Multi_Node removeChildren;
};
extern struct X3D_Virt virt_PickableGroup;
/***********************/
struct X3D_PixelTexture {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __textureTableIndex;
	void * _parentResource;
	struct Multi_Int32 image;
	struct X3D_Node *metadata;
	int repeatS;
	int repeatT;
	struct X3D_Node *textureProperties;
};
extern struct X3D_Virt virt_PixelTexture;
/***********************/
struct X3D_PlaneSensor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __oldEnabled;
	struct SFVec3f _oldtrackPoint;
	struct SFVec3f _oldtranslation;
	struct SFVec3f _origPoint;
	int autoOffset;
	struct Uni_String *description;
	int enabled;
	int isActive;
	int isOver;
	struct SFVec2f maxPosition;
	struct X3D_Node *metadata;
	struct SFVec2f minPosition;
	struct SFVec3f offset;
	struct SFVec3f trackPoint_changed;
	struct SFVec3f translation_changed;
};
extern struct X3D_Virt virt_PlaneSensor;
/***********************/
struct X3D_PointLight {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec4f _amb;
	struct SFVec4f _col;
	struct SFVec4f _loc;
	float ambientIntensity;
	struct SFVec3f attenuation;
	struct SFColor color;
	int global;
	float intensity;
	struct SFVec3f location;
	struct X3D_Node *metadata;
	int on;
	float radius;
};
extern struct X3D_Virt virt_PointLight;
/***********************/
struct X3D_PointPickSensor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec3f _bboxCenter;
	struct SFVec3f _bboxSize;
	int _oldisActive;
	struct Multi_Node _oldpickTarget;
	struct Multi_Node _oldpickedGeometry;
	struct Multi_Vec3f _oldpickedPoint;
	int enabled;
	struct Uni_String *intersectionType;
	int isActive;
	struct X3D_Node *metadata;
	struct Multi_String objectType;
	struct Multi_Node pickTarget;
	struct Multi_Node pickedGeometry;
	struct Multi_Vec3f pickedPoint;
	struct X3D_Node *pickingGeometry;
	struct Uni_String *set_intersectionType;
	struct Uni_String *set_sortOrder;
	struct Uni_String *sortOrder;
};
extern struct X3D_Virt virt_PointPickSensor;
/***********************/
struct X3D_PointSet {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int _colourSize;
	int _coloursVBO;
	int _npoints;
	int _pointsVBO;
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_PointSet;
/***********************/
struct X3D_Polyline2D {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec2f lineSegments;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_Polyline2D;
/***********************/
struct X3D_Polypoint2D {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Vec2f point;
};
extern struct X3D_Virt virt_Polypoint2D;
/***********************/
struct X3D_PositionInterpolator {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float key;
	struct Multi_Vec3f keyValue;
	struct X3D_Node *metadata;
	float set_fraction;
	struct SFVec3f value_changed;
};
extern struct X3D_Virt virt_PositionInterpolator;
/***********************/
struct X3D_PositionInterpolator2D {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float key;
	struct Multi_Vec2f keyValue;
	struct X3D_Node *metadata;
	float set_fraction;
	struct SFVec2f value_changed;
};
extern struct X3D_Virt virt_PositionInterpolator2D;
/***********************/
struct X3D_ProgramShader {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int _initialized;
	int _retrievedURLData;
	pthread_t _shaderLoadThread;
	int _shaderUserNumber;
	int activate;
	int isSelected;
	int isValid;
	struct Uni_String *language;
	struct X3D_Node *metadata;
	struct Multi_Node programs;
};
extern struct X3D_Virt virt_ProgramShader;
/***********************/
struct X3D_Proto {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	void * __DEFnames;
	void * __IS;
	void * __ROUTES;
	struct X3D_Node *__parentProto;
	struct Multi_Node __protoDeclares;
	void * __protoDef;
	int __protoFlags;
	struct X3D_Node *__prototype;
	struct Multi_Node _children;
	struct Multi_Node _sortedChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_Proto;
/***********************/
struct X3D_ProximitySensor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __hit;
	int __oldEnabled;
	struct SFVec3f __t1;
	struct SFRotation __t2;
	struct SFVec3f center;
	struct SFVec3f centerOfRotation_changed;
	int enabled;
	double enterTime;
	double exitTime;
	int isActive;
	struct X3D_Node *metadata;
	struct SFRotation orientation_changed;
	struct SFVec3f position_changed;
	struct SFVec3f size;
};
extern struct X3D_Virt virt_ProximitySensor;
/***********************/
struct X3D_QuadSet {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 _coordIndex;
	struct Multi_Node attrib;
	int ccw;
	struct X3D_Node *color;
	int colorPerVertex;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	int normalPerVertex;
	int solid;
	struct X3D_Node *texCoord;
};
extern struct X3D_Virt virt_QuadSet;
/***********************/
struct X3D_ReceiverPdu {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Uni_String *address;
	int applicationID;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	int enabled;
	int entityID;
	int isActive;
	int isNetworkReader;
	int isNetworkWriter;
	int isRtpHeaderHeard;
	int isStandAlone;
	struct X3D_Node *metadata;
	struct Uni_String *multicastRelayHost;
	int multicastRelayPort;
	struct Uni_String *networkMode;
	int port;
	int radioID;
	float readInterval;
	float receivedPower;
	int receiverState;
	int rtpHeaderExpected;
	int siteID;
	double timestamp;
	int transmitterApplicationID;
	int transmitterEntityID;
	int transmitterRadioID;
	int transmitterSiteID;
	int whichGeometry;
	float writeInterval;
};
extern struct X3D_Virt virt_ReceiverPdu;
/***********************/
struct X3D_Rectangle2D {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __numPoints;
	struct Multi_Vec3f __points;
	struct X3D_Node *metadata;
	struct SFVec2f size;
	int solid;
};
extern struct X3D_Virt virt_Rectangle2D;
/***********************/
struct X3D_ScalarInterpolator {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float key;
	struct Multi_Float keyValue;
	struct X3D_Node *metadata;
	float set_fraction;
	float value_changed;
};
extern struct X3D_Virt virt_ScalarInterpolator;
/***********************/
struct X3D_Script {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	void * __scriptObj;
	void * _parentResource;
	int directOutput;
	struct X3D_Node *metadata;
	int mustEvaluate;
	struct Multi_String url;
};
extern struct X3D_Virt virt_Script;
/***********************/
struct X3D_ShaderPart {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	void * _parentResource;
	struct X3D_Node *metadata;
	struct Uni_String *type;
	struct Multi_String url;
};
extern struct X3D_Virt virt_ShaderPart;
/***********************/
struct X3D_ShaderProgram {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	void * _parentResource;
	struct X3D_Node *_shaderUserDefinedFields;
	struct X3D_Node *metadata;
	struct Uni_String *type;
	struct Multi_String url;
};
extern struct X3D_Virt virt_ShaderProgram;
/***********************/
struct X3D_Shape {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __Samples;
	int __occludeCheckCount;
	int __visible;
	int _shaderTableEntry;
	struct X3D_Node *appearance;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct X3D_Node *geometry;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_Shape;
/***********************/
struct X3D_SignalPdu {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Uni_String *address;
	int applicationID;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Int32 data;
	int dataLength;
	int enabled;
	int encodingScheme;
	int entityID;
	int isActive;
	int isNetworkReader;
	int isNetworkWriter;
	int isRtpHeaderHeard;
	int isStandAlone;
	struct X3D_Node *metadata;
	struct Uni_String *multicastRelayHost;
	int multicastRelayPort;
	struct Uni_String *networkMode;
	int port;
	int radioID;
	float readInterval;
	int rtpHeaderExpected;
	int sampleRate;
	int samples;
	int siteID;
	int tdlType;
	double timestamp;
	int whichGeometry;
	float writeInterval;
};
extern struct X3D_Virt virt_SignalPdu;
/***********************/
struct X3D_Sound {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec3f direction;
	float intensity;
	struct SFVec3f location;
	float maxBack;
	float maxFront;
	struct X3D_Node *metadata;
	float minBack;
	float minFront;
	float priority;
	struct X3D_Node *source;
	int spatialize;
};
extern struct X3D_Virt virt_Sound;
/***********************/
struct X3D_Sphere {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __SphereIndxVBO;
	struct Multi_Vec3f __points;
	int _sideVBO;
	struct X3D_Node *metadata;
	float radius;
	int solid;
};
extern struct X3D_Virt virt_Sphere;
/***********************/
struct X3D_SphereSensor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __oldEnabled;
	struct SFRotation _oldrotation;
	struct SFVec3f _oldtrackPoint;
	struct SFVec3f _origNormalizedPoint;
	struct SFVec3f _origPoint;
	float _radius;
	int autoOffset;
	struct Uni_String *description;
	int enabled;
	int isActive;
	int isOver;
	struct X3D_Node *metadata;
	struct SFRotation offset;
	struct SFRotation rotation_changed;
	struct SFVec3f trackPoint_changed;
};
extern struct X3D_Virt virt_SphereSensor;
/***********************/
struct X3D_SplinePositionInterpolator {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int closed;
	struct Multi_Float key;
	struct Multi_Vec3f keyValue;
	struct Multi_Vec3f keyVelocity;
	struct X3D_Node *metadata;
	int normalizeVelocity;
	float set_fraction;
	struct SFVec3f value_changed;
};
extern struct X3D_Virt virt_SplinePositionInterpolator;
/***********************/
struct X3D_SplinePositionInterpolator2D {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int closed;
	struct Multi_Float key;
	struct Multi_Vec2f keyValue;
	struct Multi_Vec2f keyVelocity;
	struct X3D_Node *metadata;
	int normalizeVelocity;
	float set_fraction;
	struct SFVec2f value_changed;
};
extern struct X3D_Virt virt_SplinePositionInterpolator2D;
/***********************/
struct X3D_SplineScalarInterpolator {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int closed;
	struct Multi_Float key;
	struct Multi_Float keyValue;
	struct Multi_Float keyVelocity;
	struct X3D_Node *metadata;
	int normalizeVelocity;
	float set_fraction;
	float value_changed;
};
extern struct X3D_Virt virt_SplineScalarInterpolator;
/***********************/
struct X3D_SpotLight {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec4f _amb;
	struct SFVec4f _col;
	struct SFVec4f _dir;
	struct SFVec4f _loc;
	float ambientIntensity;
	struct SFVec3f attenuation;
	float beamWidth;
	struct SFColor color;
	float cutOffAngle;
	struct SFVec3f direction;
	int global;
	float intensity;
	struct SFVec3f location;
	struct X3D_Node *metadata;
	int on;
	float radius;
};
extern struct X3D_Virt virt_SpotLight;
/***********************/
struct X3D_SquadOrientationInterpolator {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float key;
	struct Multi_Rotation keyValue;
	struct X3D_Node *metadata;
	int normalizeVelocity;
	float set_fraction;
	struct SFRotation value_changed;
};
extern struct X3D_Virt virt_SquadOrientationInterpolator;
/***********************/
struct X3D_StaticGroup {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __solid;
	int __transparency;
	struct Multi_Node _sortedChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Node children;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_StaticGroup;
/***********************/
struct X3D_StringSensor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __oldEnabled;
	int _initialized;
	int deletionAllowed;
	int enabled;
	struct Uni_String *enteredText;
	struct Uni_String *finalText;
	int isActive;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_StringSensor;
/***********************/
struct X3D_Switch {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __isX3D;
	struct Multi_Node addChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Node children;
	struct Multi_Node choice;
	struct X3D_Node *metadata;
	struct Multi_Node removeChildren;
	int whichChoice;
};
extern struct X3D_Virt virt_Switch;
/***********************/
struct X3D_Text {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __rendersub;
	struct X3D_Node *fontStyle;
	struct Multi_Float length;
	struct Multi_Vec2f lineBounds;
	float maxExtent;
	struct X3D_Node *metadata;
	struct SFVec3f origin;
	int solid;
	struct Multi_String string;
	struct SFVec2f textBounds;
};
extern struct X3D_Virt virt_Text;
/***********************/
struct X3D_TextureBackground {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __VBO;
	struct Multi_Vec3f __colours;
	struct Multi_Vec3f __points;
	int __quadcount;
	void * _parentResource;
	struct X3D_Node *backTexture;
	double bindTime;
	struct X3D_Node *bottomTexture;
	struct X3D_Node *frontTexture;
	struct Multi_Float groundAngle;
	struct Multi_Color groundColor;
	int isBound;
	struct X3D_Node *leftTexture;
	struct X3D_Node *metadata;
	struct X3D_Node *rightTexture;
	int set_bind;
	struct Multi_Float skyAngle;
	struct Multi_Color skyColor;
	struct X3D_Node *topTexture;
	struct Multi_Float transparency;
};
extern struct X3D_Virt virt_TextureBackground;
/***********************/
struct X3D_TextureCoordinate {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Vec2f point;
};
extern struct X3D_Virt virt_TextureCoordinate;
/***********************/
struct X3D_TextureCoordinateGenerator {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *mode;
	struct Multi_Float parameter;
};
extern struct X3D_Virt virt_TextureCoordinateGenerator;
/***********************/
struct X3D_TextureProperties {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float anisotropicDegree;
	struct SFColorRGBA borderColor;
	int borderWidth;
	struct Uni_String *boundaryModeR;
	struct Uni_String *boundaryModeS;
	struct Uni_String *boundaryModeT;
	int generateMipMaps;
	struct Uni_String *magnificationFilter;
	struct X3D_Node *metadata;
	struct Uni_String *minificationFilter;
	struct Uni_String *textureCompression;
	float texturePriority;
};
extern struct X3D_Virt virt_TextureProperties;
/***********************/
struct X3D_TextureTransform {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec2f center;
	struct X3D_Node *metadata;
	float rotation;
	struct SFVec2f scale;
	struct SFVec2f translation;
};
extern struct X3D_Virt virt_TextureTransform;
/***********************/
struct X3D_TimeSensor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	double __ctflag;
	double __inittime;
	int __oldEnabled;
	double cycleInterval;
	double cycleTime;
	double elapsedTime;
	int enabled;
	float fraction_changed;
	int isActive;
	double isPaused;
	int loop;
	struct X3D_Node *metadata;
	double pauseTime;
	double resumeTime;
	double startTime;
	double stopTime;
	double time;
};
extern struct X3D_Virt virt_TimeSensor;
/***********************/
struct X3D_TimeTrigger {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	int set_boolean;
	double triggerTime;
};
extern struct X3D_Virt virt_TimeTrigger;
/***********************/
struct X3D_TouchSensor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __oldEnabled;
	struct SFVec3f _oldhitNormal;
	struct SFVec3f _oldhitPoint;
	struct SFVec2f _oldhitTexCoord;
	struct Uni_String *description;
	int enabled;
	struct SFVec3f hitNormal_changed;
	struct SFVec3f hitPoint_changed;
	struct SFVec2f hitTexCoord_changed;
	int isActive;
	int isOver;
	struct X3D_Node *metadata;
	double touchTime;
};
extern struct X3D_Virt virt_TouchSensor;
/***********************/
struct X3D_Transform {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __do_anything;
	int __do_center;
	int __do_rotation;
	int __do_scale;
	int __do_scaleO;
	int __do_trans;
	struct Multi_Node _sortedChildren;
	struct Multi_Node addChildren;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct SFVec3f center;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	struct Multi_Node removeChildren;
	struct SFRotation rotation;
	struct SFVec3f scale;
	struct SFRotation scaleOrientation;
	struct SFVec3f translation;
};
extern struct X3D_Virt virt_Transform;
/***********************/
struct X3D_TransmitterPdu {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Uni_String *address;
	struct SFVec3f antennaLocation;
	int antennaPatternLength;
	int antennaPatternType;
	int applicationID;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	int cryptoKeyID;
	int cryptoSystem;
	int enabled;
	int entityID;
	int frequency;
	int inputSource;
	int isActive;
	int isNetworkReader;
	int isNetworkWriter;
	int isRtpHeaderHeard;
	int isStandAlone;
	int lengthOfModulationParameters;
	struct X3D_Node *metadata;
	int modulationTypeDetail;
	int modulationTypeMajor;
	int modulationTypeSpreadSpectrum;
	int modulationTypeSystem;
	struct Uni_String *multicastRelayHost;
	int multicastRelayPort;
	struct Uni_String *networkMode;
	int port;
	float power;
	int radioEntityTypeCategory;
	int radioEntityTypeCountry;
	int radioEntityTypeDomain;
	int radioEntityTypeKind;
	int radioEntityTypeNomenclature;
	int radioEntityTypeNomenclatureVersion;
	int radioID;
	float readInterval;
	struct SFVec3f relativeAntennaLocation;
	int rtpHeaderExpected;
	int siteID;
	double timestamp;
	float transmitFrequencyBandwidth;
	int transmitState;
	int whichGeometry;
	float writeInterval;
};
extern struct X3D_Virt virt_TransmitterPdu;
/***********************/
struct X3D_TriangleFanSet {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 _coordIndex;
	struct Multi_Node attrib;
	int ccw;
	struct X3D_Node *color;
	int colorPerVertex;
	struct X3D_Node *coord;
	struct Multi_Int32 fanCount;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	int normalPerVertex;
	int solid;
	struct X3D_Node *texCoord;
};
extern struct X3D_Virt virt_TriangleFanSet;
/***********************/
struct X3D_TriangleSet {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 _coordIndex;
	struct Multi_Node attrib;
	int ccw;
	struct X3D_Node *color;
	int colorPerVertex;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	int normalPerVertex;
	int solid;
	struct X3D_Node *texCoord;
};
extern struct X3D_Virt virt_TriangleSet;
/***********************/
struct X3D_TriangleSet2D {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	void * __texCoords;
	struct X3D_Node *metadata;
	int solid;
	struct Multi_Vec2f vertices;
};
extern struct X3D_Virt virt_TriangleSet2D;
/***********************/
struct X3D_TriangleStripSet {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 _coordIndex;
	struct Multi_Node attrib;
	int ccw;
	struct X3D_Node *color;
	int colorPerVertex;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	int normalPerVertex;
	int solid;
	struct Multi_Int32 stripCount;
	struct X3D_Node *texCoord;
};
extern struct X3D_Virt virt_TriangleStripSet;
/***********************/
struct X3D_TwoSidedMaterial {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float _verifiedBackColor;
	struct Multi_Float _verifiedFrontColor;
	float ambientIntensity;
	float backAmbientIntensity;
	struct SFColor backDiffuseColor;
	struct SFColor backEmissiveColor;
	float backShininess;
	struct SFColor backSpecularColor;
	float backTransparency;
	struct SFColor diffuseColor;
	struct SFColor emissiveColor;
	struct X3D_Node *metadata;
	int separateBackColor;
	float shininess;
	struct SFColor specularColor;
	float transparency;
};
extern struct X3D_Virt virt_TwoSidedMaterial;
/***********************/
struct X3D_Viewpoint {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	double bindTime;
	struct SFVec3f centerOfRotation;
	struct Uni_String *description;
	float fieldOfView;
	int isBound;
	int jump;
	struct X3D_Node *metadata;
	struct SFRotation orientation;
	struct SFVec3f position;
	int retainUserOffsets;
	int set_bind;
};
extern struct X3D_Virt virt_Viewpoint;
/***********************/
struct X3D_ViewpointGroup {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *__proxNode;
	struct SFVec3f center;
	struct Multi_Node children;
	struct Uni_String *description;
	int displayed;
	struct X3D_Node *metadata;
	int retainUserOffsets;
	struct SFVec3f size;
};
extern struct X3D_Virt virt_ViewpointGroup;
/***********************/
struct X3D_VisibilitySensor {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int __Samples;
	int __occludeCheckCount;
	int __oldEnabled;
	struct Multi_Vec3f __points;
	int __visible;
	struct SFVec3f center;
	int enabled;
	double enterTime;
	double exitTime;
	int isActive;
	struct X3D_Node *metadata;
	struct SFVec3f size;
};
extern struct X3D_Virt virt_VisibilitySensor;
/***********************/
struct X3D_WorldInfo {
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int _nodeType; /* unique integer for each type */ 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_String info;
	struct X3D_Node *metadata;
	struct Uni_String *title;
};
extern struct X3D_Virt virt_WorldInfo;
extern struct X3D_Virt* virtTable[];

extern const int *NODE_OFFSETS[];

int getSAI_X3DNodeType (int FreeWRLNodeType);

#endif /* __FREEWRL_STRUCTS_H__ */
