/*
 * Decompiled with CFR 0.152.
 */
package org.iotivity.cloud.accountserver.oauth;

import java.util.HashMap;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.GitHubTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.apache.oltu.oauth2.common.OAuthProviderType;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.iotivity.cloud.accountserver.db.TokenTable;
import org.iotivity.cloud.accountserver.db.UserTable;
import org.iotivity.cloud.accountserver.oauth.OAuthProvider;
import org.iotivity.cloud.base.exception.ServerException;
import org.iotivity.cloud.util.JSONUtil;
import org.iotivity.cloud.util.Log;

public class Github
implements OAuthProvider {
    private static final String client_id = "ea9c18f540323b0213d0";
    private static final String secret = "4bc0cd9fe21269507eb8eba3a32664a0f598dbc9";
    private static final String resource_url = "https://api.github.com/user";

    public TokenTable requestAccessTokenInfo(String authCode, Object options) {
        TokenTable tokenInfo = new TokenTable();
        try {
            OAuthClientRequest request = OAuthClientRequest.tokenProvider((OAuthProviderType)OAuthProviderType.GITHUB).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId(client_id).setClientSecret(secret).setCode(authCode).buildBodyMessage();
            OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
            GitHubTokenResponse oAuthResponse = (GitHubTokenResponse)oAuthClient.accessToken(request, GitHubTokenResponse.class);
            tokenInfo.setAccesstoken((Object)oAuthResponse.getAccessToken());
            tokenInfo.setRefreshtoken((Object)oAuthResponse.getRefreshToken());
            tokenInfo.setExpiredtime((Object)-1);
        }
        catch (OAuthProblemException | OAuthSystemException e) {
            e.printStackTrace();
            throw new ServerException.InternalServerErrorException("OAuth provider(Github) error");
        }
        return tokenInfo;
    }

    public TokenTable requestRefreshTokenInfo(String refreshToken) {
        TokenTable tokenInfo = new TokenTable();
        return tokenInfo;
    }

    public UserTable requestGetUserInfo(String accessToken, Object options) {
        String response = null;
        UserTable userInfo = new UserTable();
        if (accessToken == null) {
            Log.w((String)"accessToken is null!");
            return null;
        }
        try {
            OAuthClientRequest request = new OAuthBearerClientRequest(resource_url).setAccessToken(accessToken).buildQueryMessage();
            OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
            OAuthResourceResponse resourceResponse = (OAuthResourceResponse)oAuthClient.resource(request, "GET", OAuthResourceResponse.class);
            response = resourceResponse.getBody();
            Log.d((String)("response: " + response));
        }
        catch (OAuthProblemException | OAuthSystemException e) {
            e.printStackTrace();
            throw new ServerException.InternalServerErrorException("OAuth provider(Github) error");
        }
        String userIdKey = "login";
        JSONUtil util = new JSONUtil();
        HashMap parsedData = (HashMap)util.parseJSON(response, HashMap.class);
        String userId = (String)parsedData.get(userIdKey);
        userInfo.setUserid((Object)userId);
        return userInfo;
    }
}

