/******************************************************************
 *
 * Copyright 2014 Samsung Electronics All Rights Reserved.
 *
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ******************************************************************/

package org.iotivity.ca;

public class CaIpInterface {

    public enum WifiAPState{
        WIFI_AP_STATE_DISABLING (10),
        WIFI_AP_STATE_DISABLED (11),
        WIFI_AP_STATE_ENABLING (12),
        WIFI_AP_STATE_ENABLED (13),
        WIFI_AP_STATE_FAILED (14)
        ; // semicolon needed when fields / methods follow


        private final int apstate;

        WifiAPState(int apstate)
        {
            this.apstate = apstate;
        }
        public int getIntValue() {
           return this.apstate;
        }
    }

    private CaIpInterface() {
        registerIpStateReceiver();
    }

    private void registerIpStateReceiver() {
    }

    public static void destroyIpInterface() {
    }

    private native static void caIpStateEnabled();

    private native static void caIpStateDisabled();
}
