//******************************************************************
//
// Copyright 2016 Samsung Electronics All Rights Reserved.
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// Warning disabled globally but VS2013 ignores the /wd4200 option in C++ files.
#if defined(_MSC_VER) && _MSC_VER < 1900
#pragma warning(disable : 4200)
#endif

#include <cinttypes>
#include "iotivity_config.h"
#include "gtest/gtest.h"
#include "time.h"
#include "octypes.h"
#ifdef HAVE_WINSOCK2_H
#include <winsock2.h>
#endif

// Test function hooks
#define CAcloseSslConnection CAcloseSslConnectionTest
#define CAdecryptSsl CAdecryptSslTest
#define CAdeinitSslAdapter CAdeinitSslAdapterTest
#define CAencryptSsl CAencryptSslTest
#define CAinitSslAdapter CAinitSslAdapterTest
#define CAinitiateSslHandshake CAinitiateSslHandshakeTest
#define CAsetCredentialTypesCallback CAsetCredentialTypesCallbackTest
#define CAsetSslAdapterCallbacks CAsetSslAdapterCallbacksTest
#define CAsetSslHandshakeCallback CAsetSslHandshakeCallbackTest
#define CAsetTlsCipherSuite CAsetTlsCipherSuiteTest
#define CAsslGenerateOwnerPsk CAsslGenerateOwnerPskTest
#define CAcloseSslConnectionAll CAcloseSslConnectionAllTest
#define GetCASecureEndpointData GetCASecureEndpointDataTest
#define SetCASecureEndpointAttribute SetCASecureEndpointAttributeTest
#define GetCASecureEndpointAttributes GetCASecureEndpointAttributesTest

#include "../src/adapter_util/ca_adapter_net_ssl.c"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_PTHREAD_H
#include <pthread.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

#if defined(_WIN32)
#include "pthread_create.h"
#endif
#ifdef HAVE_WINDOWS_H
#include <windows.h>
/** @todo stop-gap for naming issue. Windows.h does not like us to use ERROR */
#ifdef ERROR
#undef ERROR
#endif //ERROR
#endif //HAVE_WINDOWS_H
#include "platform_features.h"
#include "logger.h"


#define SEED "PREDICTED_SEED"
#define dummyHandler 0xF123

#define DEFAULT_HEX_WIDTH 16

#define SERVER_PORT 4433
#define SERVER_PORT_STRING "4433"
#define SERVER_NAME "localhost"
#define GET_REQUEST "GET / HTTP/1.0\r\n\r\n"

/* **************************
 *
 *
 * Common routines
 *
 *
 * *************************/

// Data blob contains 7 certificates in PEM and DER encoding
unsigned char certChain[] = {
    // PEM encoded certificate
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49,
    0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x43,
    0x6e, 0x44, 0x43, 0x43, 0x41, 0x6a, 0x2b, 0x67, 0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49, 0x55,
    0x44, 0x67, 0x45, 0x38, 0x4e, 0x50, 0x54, 0x4c, 0x46, 0x64, 0x6d, 0x68, 0x75, 0x72, 0x53, 0x69,
    0x36, 0x33, 0x49, 0x31, 0x41, 0x77, 0x76, 0x37, 0x39, 0x49, 0x6b, 0x77, 0x44, 0x41, 0x59, 0x49,
    0x4b, 0x6f, 0x5a, 0x49, 0x7a, 0x6a, 0x30, 0x45, 0x41, 0x77, 0x49, 0x46, 0x0a, 0x41, 0x44, 0x43,
    0x42, 0x67, 0x7a, 0x45, 0x34, 0x4d, 0x44, 0x59, 0x47, 0x41, 0x31, 0x55, 0x45, 0x41, 0x78, 0x4d,
    0x76, 0x55, 0x32, 0x46, 0x74, 0x63, 0x33, 0x56, 0x75, 0x5a, 0x79, 0x42, 0x46, 0x62, 0x47, 0x56,
    0x6a, 0x64, 0x48, 0x4a, 0x76, 0x62, 0x6d, 0x6c, 0x6a, 0x63, 0x79, 0x42, 0x50, 0x51, 0x30, 0x59,
    0x67, 0x54, 0x55, 0x4d, 0x67, 0x52, 0x47, 0x56, 0x32, 0x61, 0x57, 0x4e, 0x6c, 0x0a, 0x49, 0x46,
    0x4e, 0x31, 0x59, 0x6b, 0x4e, 0x42, 0x49, 0x48, 0x59, 0x78, 0x49, 0x46, 0x52, 0x46, 0x55, 0x31,
    0x51, 0x78, 0x48, 0x44, 0x41, 0x61, 0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x73, 0x54, 0x45, 0x30,
    0x39, 0x44, 0x52, 0x69, 0x42, 0x4e, 0x51, 0x79, 0x42, 0x45, 0x5a, 0x58, 0x5a, 0x70, 0x59, 0x32,
    0x55, 0x67, 0x55, 0x33, 0x56, 0x69, 0x51, 0x30, 0x45, 0x78, 0x48, 0x44, 0x41, 0x61, 0x0a, 0x42,
    0x67, 0x4e, 0x56, 0x42, 0x41, 0x6f, 0x54, 0x45, 0x31, 0x4e, 0x68, 0x62, 0x58, 0x4e, 0x31, 0x62,
    0x6d, 0x63, 0x67, 0x52, 0x57, 0x78, 0x6c, 0x59, 0x33, 0x52, 0x79, 0x62, 0x32, 0x35, 0x70, 0x59,
    0x33, 0x4d, 0x78, 0x43, 0x7a, 0x41, 0x4a, 0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x59, 0x54, 0x41,
    0x6b, 0x74, 0x53, 0x4d, 0x43, 0x41, 0x58, 0x44, 0x54, 0x45, 0x32, 0x4d, 0x54, 0x45, 0x79, 0x0a,
    0x4e, 0x44, 0x41, 0x79, 0x4e, 0x44, 0x67, 0x78, 0x4d, 0x6c, 0x6f, 0x59, 0x44, 0x7a, 0x49, 0x77,
    0x4e, 0x6a, 0x6b, 0x78, 0x4d, 0x6a, 0x4d, 0x78, 0x4d, 0x54, 0x51, 0x31, 0x4f, 0x54, 0x55, 0x35,
    0x57, 0x6a, 0x43, 0x42, 0x6a, 0x54, 0x46, 0x49, 0x4d, 0x45, 0x59, 0x47, 0x41, 0x31, 0x55, 0x45,
    0x41, 0x78, 0x4d, 0x2f, 0x54, 0x30, 0x4e, 0x47, 0x49, 0x45, 0x52, 0x6c, 0x64, 0x6d, 0x6c, 0x6a,
    0x0a, 0x5a, 0x53, 0x42, 0x55, 0x52, 0x56, 0x4e, 0x55, 0x4f, 0x69, 0x42, 0x4f, 0x5a, 0x58, 0x52,
    0x33, 0x62, 0x33, 0x4a, 0x72, 0x49, 0x43, 0x67, 0x77, 0x4e, 0x6a, 0x51, 0x79, 0x4e, 0x32, 0x45,
    0x32, 0x4e, 0x53, 0x31, 0x69, 0x5a, 0x6a, 0x63, 0x30, 0x4c, 0x54, 0x51, 0x33, 0x4d, 0x7a, 0x63,
    0x74, 0x4f, 0x54, 0x5a, 0x6d, 0x4d, 0x53, 0x30, 0x78, 0x59, 0x6d, 0x49, 0x78, 0x4f, 0x44, 0x5a,
    0x6b, 0x0a, 0x4f, 0x47, 0x59, 0x33, 0x59, 0x6a, 0x4d, 0x70, 0x4d, 0x52, 0x59, 0x77, 0x46, 0x41,
    0x59, 0x44, 0x56, 0x51, 0x51, 0x4c, 0x45, 0x77, 0x31, 0x50, 0x51, 0x30, 0x59, 0x67, 0x54, 0x55,
    0x4d, 0x67, 0x52, 0x47, 0x56, 0x32, 0x61, 0x57, 0x4e, 0x6c, 0x4d, 0x52, 0x77, 0x77, 0x47, 0x67,
    0x59, 0x44, 0x56, 0x51, 0x51, 0x4b, 0x45, 0x78, 0x4e, 0x54, 0x59, 0x57, 0x31, 0x7a, 0x64, 0x57,
    0x35, 0x6e, 0x0a, 0x49, 0x45, 0x56, 0x73, 0x5a, 0x57, 0x4e, 0x30, 0x63, 0x6d, 0x39, 0x75, 0x61,
    0x57, 0x4e, 0x7a, 0x4d, 0x51, 0x73, 0x77, 0x43, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x47, 0x45,
    0x77, 0x4a, 0x4c, 0x55, 0x6a, 0x42, 0x5a, 0x4d, 0x42, 0x4d, 0x47, 0x42, 0x79, 0x71, 0x47, 0x53,
    0x4d, 0x34, 0x39, 0x41, 0x67, 0x45, 0x47, 0x43, 0x43, 0x71, 0x47, 0x53, 0x4d, 0x34, 0x39, 0x41,
    0x77, 0x45, 0x48, 0x0a, 0x41, 0x30, 0x49, 0x41, 0x42, 0x45, 0x45, 0x77, 0x51, 0x41, 0x52, 0x73,
    0x62, 0x67, 0x43, 0x59, 0x2b, 0x43, 0x59, 0x6b, 0x49, 0x6a, 0x6b, 0x59, 0x6f, 0x47, 0x78, 0x6f,
    0x52, 0x33, 0x75, 0x70, 0x33, 0x38, 0x59, 0x47, 0x54, 0x32, 0x63, 0x4b, 0x30, 0x31, 0x74, 0x6d,
    0x32, 0x70, 0x38, 0x79, 0x4c, 0x4b, 0x4e, 0x73, 0x6d, 0x69, 0x53, 0x6f, 0x76, 0x46, 0x70, 0x4a,
    0x32, 0x35, 0x63, 0x52, 0x0a, 0x74, 0x72, 0x57, 0x34, 0x41, 0x56, 0x7a, 0x76, 0x73, 0x64, 0x67,
    0x62, 0x74, 0x72, 0x45, 0x62, 0x6b, 0x2b, 0x37, 0x73, 0x56, 0x61, 0x58, 0x50, 0x74, 0x78, 0x43,
    0x6a, 0x67, 0x59, 0x41, 0x77, 0x66, 0x6a, 0x41, 0x4f, 0x42, 0x67, 0x4e, 0x56, 0x48, 0x51, 0x38,
    0x42, 0x41, 0x66, 0x38, 0x45, 0x42, 0x41, 0x4d, 0x43, 0x41, 0x38, 0x67, 0x77, 0x4c, 0x67, 0x59,
    0x44, 0x56, 0x52, 0x30, 0x66, 0x0a, 0x42, 0x43, 0x63, 0x77, 0x4a, 0x54, 0x41, 0x6a, 0x6f, 0x43,
    0x47, 0x67, 0x48, 0x34, 0x59, 0x64, 0x61, 0x48, 0x52, 0x30, 0x63, 0x44, 0x6f, 0x76, 0x4c, 0x32,
    0x4e, 0x68, 0x4c, 0x6e, 0x4e, 0x68, 0x62, 0x58, 0x4e, 0x31, 0x62, 0x6d, 0x64, 0x70, 0x62, 0x33,
    0x52, 0x7a, 0x4c, 0x6d, 0x4e, 0x76, 0x62, 0x53, 0x39, 0x6a, 0x63, 0x6d, 0x77, 0x77, 0x50, 0x41,
    0x59, 0x49, 0x4b, 0x77, 0x59, 0x42, 0x0a, 0x42, 0x51, 0x55, 0x48, 0x41, 0x51, 0x45, 0x45, 0x4d,
    0x44, 0x41, 0x75, 0x4d, 0x43, 0x77, 0x47, 0x43, 0x43, 0x73, 0x47, 0x41, 0x51, 0x55, 0x46, 0x42,
    0x7a, 0x41, 0x42, 0x68, 0x69, 0x42, 0x6f, 0x64, 0x48, 0x52, 0x77, 0x4f, 0x69, 0x38, 0x76, 0x62,
    0x32, 0x4e, 0x7a, 0x63, 0x43, 0x31, 0x30, 0x5a, 0x58, 0x4e, 0x30, 0x4c, 0x6e, 0x4e, 0x68, 0x62,
    0x58, 0x4e, 0x31, 0x62, 0x6d, 0x64, 0x70, 0x0a, 0x62, 0x33, 0x52, 0x7a, 0x4c, 0x6d, 0x4e, 0x76,
    0x62, 0x54, 0x41, 0x4d, 0x42, 0x67, 0x67, 0x71, 0x68, 0x6b, 0x6a, 0x4f, 0x50, 0x51, 0x51, 0x44,
    0x41, 0x67, 0x55, 0x41, 0x41, 0x30, 0x6b, 0x41, 0x4d, 0x45, 0x59, 0x43, 0x49, 0x51, 0x43, 0x33,
    0x58, 0x30, 0x42, 0x61, 0x4f, 0x49, 0x6f, 0x63, 0x4b, 0x4f, 0x45, 0x65, 0x44, 0x46, 0x52, 0x6b,
    0x63, 0x66, 0x30, 0x48, 0x76, 0x68, 0x68, 0x67, 0x0a, 0x73, 0x6c, 0x65, 0x49, 0x52, 0x32, 0x49,
    0x62, 0x6d, 0x66, 0x34, 0x6e, 0x69, 0x52, 0x52, 0x55, 0x38, 0x41, 0x49, 0x68, 0x41, 0x4f, 0x4d,
    0x44, 0x31, 0x77, 0x45, 0x62, 0x50, 0x67, 0x34, 0x70, 0x47, 0x77, 0x49, 0x79, 0x65, 0x77, 0x63,
    0x61, 0x6b, 0x76, 0x72, 0x4e, 0x4b, 0x66, 0x44, 0x79, 0x2b, 0x4f, 0x4e, 0x43, 0x6e, 0x4e, 0x6e,
    0x43, 0x59, 0x57, 0x4a, 0x37, 0x39, 0x35, 0x4b, 0x49, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45,
    0x4e, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d,
    0x2d, 0x2d, 0x2d,
    // PEM encoded certificate
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49,
    0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x43,
    0x6e, 0x44, 0x43, 0x43, 0x41, 0x6a, 0x2b, 0x67, 0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49, 0x55,
    0x44, 0x67, 0x45, 0x38, 0x4e, 0x50, 0x54, 0x4c, 0x46, 0x64, 0x6d, 0x68, 0x75, 0x72, 0x53, 0x69,
    0x36, 0x33, 0x49, 0x31, 0x41, 0x77, 0x76, 0x37, 0x39, 0x49, 0x6b, 0x77, 0x44, 0x41, 0x59, 0x49,
    0x4b, 0x6f, 0x5a, 0x49, 0x7a, 0x6a, 0x30, 0x45, 0x41, 0x77, 0x49, 0x46, 0x0a, 0x41, 0x44, 0x43,
    0x42, 0x67, 0x7a, 0x45, 0x34, 0x4d, 0x44, 0x59, 0x47, 0x41, 0x31, 0x55, 0x45, 0x41, 0x78, 0x4d,
    0x76, 0x55, 0x32, 0x46, 0x74, 0x63, 0x33, 0x56, 0x75, 0x5a, 0x79, 0x42, 0x46, 0x62, 0x47, 0x56,
    0x6a, 0x64, 0x48, 0x4a, 0x76, 0x62, 0x6d, 0x6c, 0x6a, 0x63, 0x79, 0x42, 0x50, 0x51, 0x30, 0x59,
    0x67, 0x54, 0x55, 0x4d, 0x67, 0x52, 0x47, 0x56, 0x32, 0x61, 0x57, 0x4e, 0x6c, 0x0a, 0x49, 0x46,
    0x4e, 0x31, 0x59, 0x6b, 0x4e, 0x42, 0x49, 0x48, 0x59, 0x78, 0x49, 0x46, 0x52, 0x46, 0x55, 0x31,
    0x51, 0x78, 0x48, 0x44, 0x41, 0x61, 0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x73, 0x54, 0x45, 0x30,
    0x39, 0x44, 0x52, 0x69, 0x42, 0x4e, 0x51, 0x79, 0x42, 0x45, 0x5a, 0x58, 0x5a, 0x70, 0x59, 0x32,
    0x55, 0x67, 0x55, 0x33, 0x56, 0x69, 0x51, 0x30, 0x45, 0x78, 0x48, 0x44, 0x41, 0x61, 0x0a, 0x42,
    0x67, 0x4e, 0x56, 0x42, 0x41, 0x6f, 0x54, 0x45, 0x31, 0x4e, 0x68, 0x62, 0x58, 0x4e, 0x31, 0x62,
    0x6d, 0x63, 0x67, 0x52, 0x57, 0x78, 0x6c, 0x59, 0x33, 0x52, 0x79, 0x62, 0x32, 0x35, 0x70, 0x59,
    0x33, 0x4d, 0x78, 0x43, 0x7a, 0x41, 0x4a, 0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x59, 0x54, 0x41,
    0x6b, 0x74, 0x53, 0x4d, 0x43, 0x41, 0x58, 0x44, 0x54, 0x45, 0x32, 0x4d, 0x54, 0x45, 0x79, 0x0a,
    0x4e, 0x44, 0x41, 0x79, 0x4e, 0x44, 0x67, 0x78, 0x4d, 0x6c, 0x6f, 0x59, 0x44, 0x7a, 0x49, 0x77,
    0x4e, 0x6a, 0x6b, 0x78, 0x4d, 0x6a, 0x4d, 0x78, 0x4d, 0x54, 0x51, 0x31, 0x4f, 0x54, 0x55, 0x35,
    0x57, 0x6a, 0x43, 0x42, 0x6a, 0x54, 0x46, 0x49, 0x4d, 0x45, 0x59, 0x47, 0x41, 0x31, 0x55, 0x45,
    0x41, 0x78, 0x4d, 0x2f, 0x54, 0x30, 0x4e, 0x47, 0x49, 0x45, 0x52, 0x6c, 0x64, 0x6d, 0x6c, 0x6a,
    0x0a, 0x5a, 0x53, 0x42, 0x55, 0x52, 0x56, 0x4e, 0x55, 0x4f, 0x69, 0x42, 0x4f, 0x5a, 0x58, 0x52,
    0x33, 0x62, 0x33, 0x4a, 0x72, 0x49, 0x43, 0x67, 0x77, 0x4e, 0x6a, 0x51, 0x79, 0x4e, 0x32, 0x45,
    0x32, 0x4e, 0x53, 0x31, 0x69, 0x5a, 0x6a, 0x63, 0x30, 0x4c, 0x54, 0x51, 0x33, 0x4d, 0x7a, 0x63,
    0x74, 0x4f, 0x54, 0x5a, 0x6d, 0x4d, 0x53, 0x30, 0x78, 0x59, 0x6d, 0x49, 0x78, 0x4f, 0x44, 0x5a,
    0x6b, 0x0a, 0x4f, 0x47, 0x59, 0x33, 0x59, 0x6a, 0x4d, 0x70, 0x4d, 0x52, 0x59, 0x77, 0x46, 0x41,
    0x59, 0x44, 0x56, 0x51, 0x51, 0x4c, 0x45, 0x77, 0x31, 0x50, 0x51, 0x30, 0x59, 0x67, 0x54, 0x55,
    0x4d, 0x67, 0x52, 0x47, 0x56, 0x32, 0x61, 0x57, 0x4e, 0x6c, 0x4d, 0x52, 0x77, 0x77, 0x47, 0x67,
    0x59, 0x44, 0x56, 0x51, 0x51, 0x4b, 0x45, 0x78, 0x4e, 0x54, 0x59, 0x57, 0x31, 0x7a, 0x64, 0x57,
    0x35, 0x6e, 0x0a, 0x49, 0x45, 0x56, 0x73, 0x5a, 0x57, 0x4e, 0x30, 0x63, 0x6d, 0x39, 0x75, 0x61,
    0x57, 0x4e, 0x7a, 0x4d, 0x51, 0x73, 0x77, 0x43, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x47, 0x45,
    0x77, 0x4a, 0x4c, 0x55, 0x6a, 0x42, 0x5a, 0x4d, 0x42, 0x4d, 0x47, 0x42, 0x79, 0x71, 0x47, 0x53,
    0x4d, 0x34, 0x39, 0x41, 0x67, 0x45, 0x47, 0x43, 0x43, 0x71, 0x47, 0x53, 0x4d, 0x34, 0x39, 0x41,
    0x77, 0x45, 0x48, 0x0a, 0x41, 0x30, 0x49, 0x41, 0x42, 0x45, 0x45, 0x77, 0x51, 0x41, 0x52, 0x73,
    0x62, 0x67, 0x43, 0x59, 0x2b, 0x43, 0x59, 0x6b, 0x49, 0x6a, 0x6b, 0x59, 0x6f, 0x47, 0x78, 0x6f,
    0x52, 0x33, 0x75, 0x70, 0x33, 0x38, 0x59, 0x47, 0x54, 0x32, 0x63, 0x4b, 0x30, 0x31, 0x74, 0x6d,
    0x32, 0x70, 0x38, 0x79, 0x4c, 0x4b, 0x4e, 0x73, 0x6d, 0x69, 0x53, 0x6f, 0x76, 0x46, 0x70, 0x4a,
    0x32, 0x35, 0x63, 0x52, 0x0a, 0x74, 0x72, 0x57, 0x34, 0x41, 0x56, 0x7a, 0x76, 0x73, 0x64, 0x67,
    0x62, 0x74, 0x72, 0x45, 0x62, 0x6b, 0x2b, 0x37, 0x73, 0x56, 0x61, 0x58, 0x50, 0x74, 0x78, 0x43,
    0x6a, 0x67, 0x59, 0x41, 0x77, 0x66, 0x6a, 0x41, 0x4f, 0x42, 0x67, 0x4e, 0x56, 0x48, 0x51, 0x38,
    0x42, 0x41, 0x66, 0x38, 0x45, 0x42, 0x41, 0x4d, 0x43, 0x41, 0x38, 0x67, 0x77, 0x4c, 0x67, 0x59,
    0x44, 0x56, 0x52, 0x30, 0x66, 0x0a, 0x42, 0x43, 0x63, 0x77, 0x4a, 0x54, 0x41, 0x6a, 0x6f, 0x43,
    0x47, 0x67, 0x48, 0x34, 0x59, 0x64, 0x61, 0x48, 0x52, 0x30, 0x63, 0x44, 0x6f, 0x76, 0x4c, 0x32,
    0x4e, 0x68, 0x4c, 0x6e, 0x4e, 0x68, 0x62, 0x58, 0x4e, 0x31, 0x62, 0x6d, 0x64, 0x70, 0x62, 0x33,
    0x52, 0x7a, 0x4c, 0x6d, 0x4e, 0x76, 0x62, 0x53, 0x39, 0x6a, 0x63, 0x6d, 0x77, 0x77, 0x50, 0x41,
    0x59, 0x49, 0x4b, 0x77, 0x59, 0x42, 0x0a, 0x42, 0x51, 0x55, 0x48, 0x41, 0x51, 0x45, 0x45, 0x4d,
    0x44, 0x41, 0x75, 0x4d, 0x43, 0x77, 0x47, 0x43, 0x43, 0x73, 0x47, 0x41, 0x51, 0x55, 0x46, 0x42,
    0x7a, 0x41, 0x42, 0x68, 0x69, 0x42, 0x6f, 0x64, 0x48, 0x52, 0x77, 0x4f, 0x69, 0x38, 0x76, 0x62,
    0x32, 0x4e, 0x7a, 0x63, 0x43, 0x31, 0x30, 0x5a, 0x58, 0x4e, 0x30, 0x4c, 0x6e, 0x4e, 0x68, 0x62,
    0x58, 0x4e, 0x31, 0x62, 0x6d, 0x64, 0x70, 0x0a, 0x62, 0x33, 0x52, 0x7a, 0x4c, 0x6d, 0x4e, 0x76,
    0x62, 0x54, 0x41, 0x4d, 0x42, 0x67, 0x67, 0x71, 0x68, 0x6b, 0x6a, 0x4f, 0x50, 0x51, 0x51, 0x44,
    0x41, 0x67, 0x55, 0x41, 0x41, 0x30, 0x6b, 0x41, 0x4d, 0x45, 0x59, 0x43, 0x49, 0x51, 0x43, 0x33,
    0x58, 0x30, 0x42, 0x61, 0x4f, 0x49, 0x6f, 0x63, 0x4b, 0x4f, 0x45, 0x65, 0x44, 0x46, 0x52, 0x6b,
    0x63, 0x66, 0x30, 0x48, 0x76, 0x68, 0x68, 0x67, 0x0a, 0x73, 0x6c, 0x65, 0x49, 0x52, 0x32, 0x49,
    0x62, 0x6d, 0x66, 0x34, 0x6e, 0x69, 0x52, 0x52, 0x55, 0x38, 0x41, 0x49, 0x68, 0x41, 0x4f, 0x4d,
    0x44, 0x31, 0x77, 0x45, 0x62, 0x50, 0x67, 0x34, 0x70, 0x47, 0x77, 0x49, 0x79, 0x65, 0x77, 0x63,
    0x61, 0x6b, 0x76, 0x72, 0x4e, 0x4b, 0x66, 0x44, 0x79, 0x2b, 0x4f, 0x4e, 0x43, 0x6e, 0x4e, 0x6e,
    0x43, 0x59, 0x57, 0x4a, 0x37, 0x39, 0x35, 0x4b, 0x49, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45,
    0x4e, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d,
    0x2d, 0x2d, 0x2d,
    // PEM encoded certificate
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49,
    0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0d, 0x0a, 0x4d, 0x49, 0x49,
    0x45, 0x67, 0x44, 0x43, 0x43, 0x41, 0x32, 0x69, 0x67, 0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49,
    0x49, 0x58, 0x32, 0x37, 0x50, 0x44, 0x4d, 0x55, 0x38, 0x2b, 0x66, 0x6f, 0x77, 0x44, 0x51, 0x59,
    0x4a, 0x4b, 0x6f, 0x5a, 0x49, 0x68, 0x76, 0x63, 0x4e, 0x41, 0x51, 0x45, 0x4c, 0x42, 0x51, 0x41,
    0x77, 0x53, 0x54, 0x45, 0x4c, 0x4d, 0x41, 0x6b, 0x47, 0x41, 0x31, 0x55, 0x45, 0x0d, 0x0a, 0x42,
    0x68, 0x4d, 0x43, 0x56, 0x56, 0x4d, 0x78, 0x45, 0x7a, 0x41, 0x52, 0x42, 0x67, 0x4e, 0x56, 0x42,
    0x41, 0x6f, 0x54, 0x43, 0x6b, 0x64, 0x76, 0x62, 0x32, 0x64, 0x73, 0x5a, 0x53, 0x42, 0x4a, 0x62,
    0x6d, 0x4d, 0x78, 0x4a, 0x54, 0x41, 0x6a, 0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x4d, 0x54, 0x48,
    0x45, 0x64, 0x76, 0x62, 0x32, 0x64, 0x73, 0x5a, 0x53, 0x42, 0x4a, 0x62, 0x6e, 0x52, 0x6c, 0x0d,
    0x0a, 0x63, 0x6d, 0x35, 0x6c, 0x64, 0x43, 0x42, 0x42, 0x64, 0x58, 0x52, 0x6f, 0x62, 0x33, 0x4a,
    0x70, 0x64, 0x48, 0x6b, 0x67, 0x52, 0x7a, 0x49, 0x77, 0x48, 0x68, 0x63, 0x4e, 0x4d, 0x54, 0x59,
    0x78, 0x4d, 0x6a, 0x41, 0x78, 0x4d, 0x54, 0x51, 0x78, 0x4f, 0x44, 0x55, 0x32, 0x57, 0x68, 0x63,
    0x4e, 0x4d, 0x54, 0x63, 0x77, 0x4d, 0x6a, 0x49, 0x7a, 0x4d, 0x54, 0x51, 0x78, 0x4e, 0x6a, 0x41,
    0x77, 0x0d, 0x0a, 0x57, 0x6a, 0x42, 0x6f, 0x4d, 0x51, 0x73, 0x77, 0x43, 0x51, 0x59, 0x44, 0x56,
    0x51, 0x51, 0x47, 0x45, 0x77, 0x4a, 0x56, 0x55, 0x7a, 0x45, 0x54, 0x4d, 0x42, 0x45, 0x47, 0x41,
    0x31, 0x55, 0x45, 0x43, 0x41, 0x77, 0x4b, 0x51, 0x32, 0x46, 0x73, 0x61, 0x57, 0x5a, 0x76, 0x63,
    0x6d, 0x35, 0x70, 0x59, 0x54, 0x45, 0x57, 0x4d, 0x42, 0x51, 0x47, 0x41, 0x31, 0x55, 0x45, 0x42,
    0x77, 0x77, 0x4e, 0x0d, 0x0a, 0x54, 0x57, 0x39, 0x31, 0x62, 0x6e, 0x52, 0x68, 0x61, 0x57, 0x34,
    0x67, 0x56, 0x6d, 0x6c, 0x6c, 0x64, 0x7a, 0x45, 0x54, 0x4d, 0x42, 0x45, 0x47, 0x41, 0x31, 0x55,
    0x45, 0x43, 0x67, 0x77, 0x4b, 0x52, 0x32, 0x39, 0x76, 0x5a, 0x32, 0x78, 0x6c, 0x49, 0x45, 0x6c,
    0x75, 0x59, 0x7a, 0x45, 0x58, 0x4d, 0x42, 0x55, 0x47, 0x41, 0x31, 0x55, 0x45, 0x41, 0x77, 0x77,
    0x4f, 0x61, 0x57, 0x31, 0x68, 0x0d, 0x0a, 0x63, 0x43, 0x35, 0x6e, 0x62, 0x57, 0x46, 0x70, 0x62,
    0x43, 0x35, 0x6a, 0x62, 0x32, 0x30, 0x77, 0x67, 0x67, 0x45, 0x69, 0x4d, 0x41, 0x30, 0x47, 0x43,
    0x53, 0x71, 0x47, 0x53, 0x49, 0x62, 0x33, 0x44, 0x51, 0x45, 0x42, 0x41, 0x51, 0x55, 0x41, 0x41,
    0x34, 0x49, 0x42, 0x44, 0x77, 0x41, 0x77, 0x67, 0x67, 0x45, 0x4b, 0x41, 0x6f, 0x49, 0x42, 0x41,
    0x51, 0x43, 0x61, 0x57, 0x66, 0x7a, 0x79, 0x0d, 0x0a, 0x75, 0x59, 0x6e, 0x66, 0x4e, 0x69, 0x54,
    0x54, 0x61, 0x50, 0x69, 0x33, 0x6b, 0x57, 0x63, 0x6b, 0x65, 0x44, 0x4e, 0x48, 0x78, 0x6f, 0x6f,
    0x5a, 0x71, 0x4d, 0x31, 0x36, 0x5a, 0x37, 0x5a, 0x38, 0x38, 0x5a, 0x63, 0x48, 0x69, 0x78, 0x79,
    0x74, 0x68, 0x63, 0x38, 0x4e, 0x6c, 0x31, 0x32, 0x59, 0x45, 0x66, 0x46, 0x78, 0x66, 0x51, 0x4e,
    0x77, 0x73, 0x2f, 0x65, 0x41, 0x4b, 0x31, 0x66, 0x6a, 0x0d, 0x0a, 0x41, 0x43, 0x59, 0x54, 0x57,
    0x39, 0x39, 0x63, 0x45, 0x36, 0x31, 0x4e, 0x51, 0x68, 0x59, 0x48, 0x6c, 0x51, 0x67, 0x78, 0x6f,
    0x62, 0x49, 0x39, 0x50, 0x44, 0x66, 0x61, 0x4f, 0x7a, 0x36, 0x4e, 0x6b, 0x72, 0x66, 0x62, 0x61,
    0x79, 0x61, 0x53, 0x7a, 0x77, 0x4a, 0x39, 0x44, 0x76, 0x4b, 0x64, 0x49, 0x52, 0x4f, 0x64, 0x58,
    0x36, 0x6d, 0x70, 0x72, 0x53, 0x2b, 0x79, 0x4c, 0x56, 0x47, 0x32, 0x0d, 0x0a, 0x2f, 0x4f, 0x49,
    0x51, 0x37, 0x72, 0x37, 0x48, 0x32, 0x65, 0x62, 0x77, 0x48, 0x6d, 0x69, 0x58, 0x6f, 0x33, 0x5a,
    0x30, 0x50, 0x4b, 0x62, 0x6c, 0x66, 0x4b, 0x44, 0x4b, 0x6b, 0x63, 0x67, 0x4b, 0x4c, 0x31, 0x73,
    0x6b, 0x33, 0x42, 0x51, 0x65, 0x78, 0x49, 0x78, 0x32, 0x4a, 0x31, 0x53, 0x51, 0x4a, 0x61, 0x32,
    0x53, 0x66, 0x55, 0x6e, 0x46, 0x6e, 0x61, 0x70, 0x62, 0x4f, 0x6a, 0x4a, 0x2b, 0x0d, 0x0a, 0x4a,
    0x42, 0x68, 0x77, 0x4f, 0x71, 0x68, 0x67, 0x36, 0x6b, 0x43, 0x4b, 0x70, 0x2b, 0x4a, 0x4e, 0x4e,
    0x59, 0x44, 0x53, 0x44, 0x47, 0x4b, 0x57, 0x47, 0x76, 0x49, 0x45, 0x44, 0x7a, 0x6f, 0x55, 0x7a,
    0x66, 0x37, 0x35, 0x36, 0x2f, 0x63, 0x58, 0x57, 0x34, 0x6d, 0x36, 0x34, 0x74, 0x44, 0x78, 0x39,
    0x54, 0x33, 0x4d, 0x66, 0x4b, 0x65, 0x55, 0x6a, 0x77, 0x31, 0x30, 0x68, 0x41, 0x72, 0x6f, 0x0d,
    0x0a, 0x63, 0x33, 0x37, 0x62, 0x4a, 0x64, 0x69, 0x2f, 0x46, 0x66, 0x6c, 0x34, 0x7a, 0x38, 0x2f,
    0x43, 0x75, 0x56, 0x55, 0x4f, 0x4c, 0x36, 0x76, 0x55, 0x6e, 0x75, 0x55, 0x35, 0x75, 0x6e, 0x46,
    0x6a, 0x67, 0x6d, 0x52, 0x6a, 0x36, 0x6e, 0x65, 0x47, 0x53, 0x63, 0x33, 0x57, 0x4a, 0x31, 0x79,
    0x76, 0x76, 0x56, 0x32, 0x6e, 0x4f, 0x37, 0x41, 0x50, 0x4b, 0x6e, 0x43, 0x4f, 0x68, 0x6c, 0x4e,
    0x7a, 0x0d, 0x0a, 0x6e, 0x7a, 0x45, 0x6f, 0x69, 0x73, 0x73, 0x68, 0x6d, 0x6c, 0x7a, 0x78, 0x43,
    0x62, 0x4d, 0x76, 0x41, 0x67, 0x4d, 0x42, 0x41, 0x41, 0x47, 0x6a, 0x67, 0x67, 0x46, 0x4c, 0x4d,
    0x49, 0x49, 0x42, 0x52, 0x7a, 0x41, 0x64, 0x42, 0x67, 0x4e, 0x56, 0x48, 0x53, 0x55, 0x45, 0x46,
    0x6a, 0x41, 0x55, 0x42, 0x67, 0x67, 0x72, 0x42, 0x67, 0x45, 0x46, 0x42, 0x51, 0x63, 0x44, 0x41,
    0x51, 0x59, 0x49, 0x0d, 0x0a, 0x4b, 0x77, 0x59, 0x42, 0x42, 0x51, 0x55, 0x48, 0x41, 0x77, 0x49,
    0x77, 0x47, 0x51, 0x59, 0x44, 0x56, 0x52, 0x30, 0x52, 0x42, 0x42, 0x49, 0x77, 0x45, 0x49, 0x49,
    0x4f, 0x61, 0x57, 0x31, 0x68, 0x63, 0x43, 0x35, 0x6e, 0x62, 0x57, 0x46, 0x70, 0x62, 0x43, 0x35,
    0x6a, 0x62, 0x32, 0x30, 0x77, 0x61, 0x41, 0x59, 0x49, 0x4b, 0x77, 0x59, 0x42, 0x42, 0x51, 0x55,
    0x48, 0x41, 0x51, 0x45, 0x45, 0x0d, 0x0a, 0x58, 0x44, 0x42, 0x61, 0x4d, 0x43, 0x73, 0x47, 0x43,
    0x43, 0x73, 0x47, 0x41, 0x51, 0x55, 0x46, 0x42, 0x7a, 0x41, 0x43, 0x68, 0x68, 0x39, 0x6f, 0x64,
    0x48, 0x52, 0x77, 0x4f, 0x69, 0x38, 0x76, 0x63, 0x47, 0x74, 0x70, 0x4c, 0x6d, 0x64, 0x76, 0x62,
    0x32, 0x64, 0x73, 0x5a, 0x53, 0x35, 0x6a, 0x62, 0x32, 0x30, 0x76, 0x52, 0x30, 0x6c, 0x42, 0x52,
    0x7a, 0x49, 0x75, 0x59, 0x33, 0x4a, 0x30, 0x0d, 0x0a, 0x4d, 0x43, 0x73, 0x47, 0x43, 0x43, 0x73,
    0x47, 0x41, 0x51, 0x55, 0x46, 0x42, 0x7a, 0x41, 0x42, 0x68, 0x68, 0x39, 0x6f, 0x64, 0x48, 0x52,
    0x77, 0x4f, 0x69, 0x38, 0x76, 0x59, 0x32, 0x78, 0x70, 0x5a, 0x57, 0x35, 0x30, 0x63, 0x7a, 0x45,
    0x75, 0x5a, 0x32, 0x39, 0x76, 0x5a, 0x32, 0x78, 0x6c, 0x4c, 0x6d, 0x4e, 0x76, 0x62, 0x53, 0x39,
    0x76, 0x59, 0x33, 0x4e, 0x77, 0x4d, 0x42, 0x30, 0x47, 0x0d, 0x0a, 0x41, 0x31, 0x55, 0x64, 0x44,
    0x67, 0x51, 0x57, 0x42, 0x42, 0x52, 0x75, 0x74, 0x41, 0x41, 0x45, 0x4b, 0x70, 0x75, 0x65, 0x4c,
    0x4f, 0x4c, 0x4b, 0x33, 0x64, 0x6e, 0x56, 0x2b, 0x75, 0x59, 0x47, 0x68, 0x77, 0x68, 0x58, 0x6d,
    0x6a, 0x41, 0x4d, 0x42, 0x67, 0x4e, 0x56, 0x48, 0x52, 0x4d, 0x42, 0x41, 0x66, 0x38, 0x45, 0x41,
    0x6a, 0x41, 0x41, 0x4d, 0x42, 0x38, 0x47, 0x41, 0x31, 0x55, 0x64, 0x0d, 0x0a, 0x49, 0x77, 0x51,
    0x59, 0x4d, 0x42, 0x61, 0x41, 0x46, 0x45, 0x72, 0x64, 0x42, 0x68, 0x59, 0x62, 0x76, 0x50, 0x5a,
    0x6f, 0x74, 0x58, 0x62, 0x31, 0x67, 0x62, 0x61, 0x37, 0x59, 0x68, 0x71, 0x36, 0x57, 0x6f, 0x45,
    0x76, 0x4d, 0x43, 0x45, 0x47, 0x41, 0x31, 0x55, 0x64, 0x49, 0x41, 0x51, 0x61, 0x4d, 0x42, 0x67,
    0x77, 0x44, 0x41, 0x59, 0x4b, 0x4b, 0x77, 0x59, 0x42, 0x42, 0x41, 0x48, 0x57, 0x0d, 0x0a, 0x65,
    0x51, 0x49, 0x46, 0x41, 0x54, 0x41, 0x49, 0x42, 0x67, 0x5a, 0x6e, 0x67, 0x51, 0x77, 0x42, 0x41,
    0x67, 0x49, 0x77, 0x4d, 0x41, 0x59, 0x44, 0x56, 0x52, 0x30, 0x66, 0x42, 0x43, 0x6b, 0x77, 0x4a,
    0x7a, 0x41, 0x6c, 0x6f, 0x43, 0x4f, 0x67, 0x49, 0x59, 0x59, 0x66, 0x61, 0x48, 0x52, 0x30, 0x63,
    0x44, 0x6f, 0x76, 0x4c, 0x33, 0x42, 0x72, 0x61, 0x53, 0x35, 0x6e, 0x62, 0x32, 0x39, 0x6e, 0x0d,
    0x0a, 0x62, 0x47, 0x55, 0x75, 0x59, 0x32, 0x39, 0x74, 0x4c, 0x30, 0x64, 0x4a, 0x51, 0x55, 0x63,
    0x79, 0x4c, 0x6d, 0x4e, 0x79, 0x62, 0x44, 0x41, 0x4e, 0x42, 0x67, 0x6b, 0x71, 0x68, 0x6b, 0x69,
    0x47, 0x39, 0x77, 0x30, 0x42, 0x41, 0x51, 0x73, 0x46, 0x41, 0x41, 0x4f, 0x43, 0x41, 0x51, 0x45,
    0x41, 0x58, 0x31, 0x7a, 0x42, 0x4a, 0x45, 0x2b, 0x6b, 0x4e, 0x2f, 0x39, 0x50, 0x42, 0x4a, 0x48,
    0x59, 0x0d, 0x0a, 0x35, 0x74, 0x57, 0x62, 0x44, 0x57, 0x62, 0x75, 0x44, 0x63, 0x66, 0x32, 0x72,
    0x31, 0x49, 0x35, 0x6f, 0x6e, 0x62, 0x38, 0x5a, 0x4e, 0x35, 0x44, 0x50, 0x61, 0x69, 0x32, 0x43,
    0x75, 0x71, 0x43, 0x66, 0x49, 0x7a, 0x46, 0x50, 0x4c, 0x75, 0x37, 0x65, 0x6a, 0x61, 0x73, 0x31,
    0x41, 0x74, 0x67, 0x33, 0x31, 0x6e, 0x38, 0x45, 0x35, 0x38, 0x55, 0x4d, 0x31, 0x51, 0x44, 0x45,
    0x74, 0x71, 0x54, 0x0d, 0x0a, 0x58, 0x45, 0x47, 0x48, 0x61, 0x68, 0x6d, 0x74, 0x6e, 0x52, 0x30,
    0x6e, 0x4f, 0x71, 0x61, 0x6e, 0x35, 0x63, 0x43, 0x6c, 0x54, 0x5a, 0x46, 0x6b, 0x61, 0x59, 0x46,
    0x47, 0x79, 0x65, 0x54, 0x75, 0x76, 0x4f, 0x33, 0x69, 0x4e, 0x54, 0x47, 0x4d, 0x50, 0x69, 0x64,
    0x4c, 0x48, 0x47, 0x51, 0x68, 0x55, 0x4b, 0x2f, 0x63, 0x4b, 0x6b, 0x67, 0x79, 0x52, 0x54, 0x68,
    0x75, 0x38, 0x4f, 0x78, 0x6e, 0x0d, 0x0a, 0x2b, 0x67, 0x6d, 0x65, 0x33, 0x70, 0x66, 0x76, 0x49,
    0x58, 0x74, 0x73, 0x61, 0x42, 0x4c, 0x71, 0x4e, 0x47, 0x69, 0x42, 0x38, 0x76, 0x69, 0x59, 0x2b,
    0x6b, 0x48, 0x75, 0x72, 0x50, 0x64, 0x53, 0x4c, 0x36, 0x53, 0x72, 0x4a, 0x57, 0x65, 0x34, 0x76,
    0x30, 0x39, 0x79, 0x62, 0x45, 0x6f, 0x74, 0x72, 0x30, 0x72, 0x34, 0x32, 0x30, 0x51, 0x74, 0x32,
    0x33, 0x52, 0x69, 0x4a, 0x44, 0x69, 0x41, 0x0d, 0x0a, 0x54, 0x77, 0x48, 0x53, 0x78, 0x57, 0x6a,
    0x64, 0x2f, 0x68, 0x64, 0x64, 0x43, 0x52, 0x75, 0x4b, 0x55, 0x4f, 0x6c, 0x36, 0x52, 0x56, 0x66,
    0x4f, 0x4a, 0x56, 0x68, 0x4a, 0x75, 0x31, 0x4b, 0x65, 0x71, 0x6b, 0x70, 0x76, 0x78, 0x44, 0x37,
    0x4d, 0x75, 0x6f, 0x39, 0x30, 0x6a, 0x41, 0x42, 0x4e, 0x44, 0x74, 0x4f, 0x4f, 0x43, 0x79, 0x5a,
    0x61, 0x56, 0x6a, 0x7a, 0x36, 0x2f, 0x77, 0x75, 0x42, 0x0d, 0x0a, 0x53, 0x50, 0x64, 0x54, 0x34,
    0x64, 0x2f, 0x4d, 0x49, 0x68, 0x51, 0x78, 0x49, 0x31, 0x76, 0x6a, 0x77, 0x48, 0x59, 0x51, 0x4d,
    0x70, 0x54, 0x76, 0x4f, 0x38, 0x68, 0x34, 0x68, 0x46, 0x36, 0x45, 0x71, 0x73, 0x58, 0x31, 0x36,
    0x70, 0x52, 0x41, 0x4a, 0x6b, 0x6e, 0x47, 0x6e, 0x63, 0x38, 0x4a, 0x59, 0x4d, 0x76, 0x62, 0x70,
    0x56, 0x6e, 0x79, 0x63, 0x6e, 0x4a, 0x73, 0x43, 0x68, 0x65, 0x73, 0x0d, 0x0a, 0x46, 0x4c, 0x78,
    0x6f, 0x6c, 0x77, 0x3d, 0x3d, 0x0d, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45, 0x4e, 0x44, 0x20,
    0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
    // PEM encoded certificate
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49,
    0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x44,
    0x38, 0x44, 0x43, 0x43, 0x41, 0x74, 0x69, 0x67, 0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49, 0x44,
    0x41, 0x6a, 0x71, 0x53, 0x4d, 0x41, 0x30, 0x47, 0x43, 0x53, 0x71, 0x47, 0x53, 0x49, 0x62, 0x33,
    0x44, 0x51, 0x45, 0x42, 0x43, 0x77, 0x55, 0x41, 0x4d, 0x45, 0x49, 0x78, 0x43, 0x7a, 0x41, 0x4a,
    0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x59, 0x54, 0x41, 0x6c, 0x56, 0x54, 0x0a, 0x4d, 0x52, 0x59,
    0x77, 0x46, 0x41, 0x59, 0x44, 0x56, 0x51, 0x51, 0x4b, 0x45, 0x77, 0x31, 0x48, 0x5a, 0x57, 0x39,
    0x55, 0x63, 0x6e, 0x56, 0x7a, 0x64, 0x43, 0x42, 0x4a, 0x62, 0x6d, 0x4d, 0x75, 0x4d, 0x52, 0x73,
    0x77, 0x47, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x44, 0x45, 0x78, 0x4a, 0x48, 0x5a, 0x57, 0x39,
    0x55, 0x63, 0x6e, 0x56, 0x7a, 0x64, 0x43, 0x42, 0x48, 0x62, 0x47, 0x39, 0x69, 0x0a, 0x59, 0x57,
    0x77, 0x67, 0x51, 0x30, 0x45, 0x77, 0x48, 0x68, 0x63, 0x4e, 0x4d, 0x54, 0x55, 0x77, 0x4e, 0x44,
    0x41, 0x78, 0x4d, 0x44, 0x41, 0x77, 0x4d, 0x44, 0x41, 0x77, 0x57, 0x68, 0x63, 0x4e, 0x4d, 0x54,
    0x63, 0x78, 0x4d, 0x6a, 0x4d, 0x78, 0x4d, 0x6a, 0x4d, 0x31, 0x4f, 0x54, 0x55, 0x35, 0x57, 0x6a,
    0x42, 0x4a, 0x4d, 0x51, 0x73, 0x77, 0x43, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x47, 0x0a, 0x45,
    0x77, 0x4a, 0x56, 0x55, 0x7a, 0x45, 0x54, 0x4d, 0x42, 0x45, 0x47, 0x41, 0x31, 0x55, 0x45, 0x43,
    0x68, 0x4d, 0x4b, 0x52, 0x32, 0x39, 0x76, 0x5a, 0x32, 0x78, 0x6c, 0x49, 0x45, 0x6c, 0x75, 0x59,
    0x7a, 0x45, 0x6c, 0x4d, 0x43, 0x4d, 0x47, 0x41, 0x31, 0x55, 0x45, 0x41, 0x78, 0x4d, 0x63, 0x52,
    0x32, 0x39, 0x76, 0x5a, 0x32, 0x78, 0x6c, 0x49, 0x45, 0x6c, 0x75, 0x64, 0x47, 0x56, 0x79, 0x0a,
    0x62, 0x6d, 0x56, 0x30, 0x49, 0x45, 0x46, 0x31, 0x64, 0x47, 0x68, 0x76, 0x63, 0x6d, 0x6c, 0x30,
    0x65, 0x53, 0x42, 0x48, 0x4d, 0x6a, 0x43, 0x43, 0x41, 0x53, 0x49, 0x77, 0x44, 0x51, 0x59, 0x4a,
    0x4b, 0x6f, 0x5a, 0x49, 0x68, 0x76, 0x63, 0x4e, 0x41, 0x51, 0x45, 0x42, 0x42, 0x51, 0x41, 0x44,
    0x67, 0x67, 0x45, 0x50, 0x41, 0x44, 0x43, 0x43, 0x41, 0x51, 0x6f, 0x43, 0x67, 0x67, 0x45, 0x42,
    0x0a, 0x41, 0x4a, 0x77, 0x71, 0x42, 0x48, 0x64, 0x63, 0x32, 0x46, 0x43, 0x52, 0x4f, 0x67, 0x61,
    0x6a, 0x67, 0x75, 0x44, 0x59, 0x55, 0x45, 0x69, 0x38, 0x69, 0x54, 0x2f, 0x78, 0x47, 0x58, 0x41,
    0x61, 0x69, 0x45, 0x5a, 0x2b, 0x34, 0x49, 0x2f, 0x46, 0x38, 0x59, 0x6e, 0x4f, 0x49, 0x65, 0x35,
    0x61, 0x2f, 0x6d, 0x45, 0x4e, 0x74, 0x7a, 0x4a, 0x45, 0x69, 0x61, 0x42, 0x30, 0x43, 0x31, 0x4e,
    0x50, 0x0a, 0x56, 0x61, 0x54, 0x4f, 0x67, 0x6d, 0x4b, 0x56, 0x37, 0x75, 0x74, 0x5a, 0x58, 0x38,
    0x62, 0x68, 0x42, 0x59, 0x41, 0x53, 0x78, 0x46, 0x36, 0x55, 0x50, 0x37, 0x78, 0x62, 0x53, 0x44,
    0x6a, 0x30, 0x55, 0x2f, 0x63, 0x6b, 0x35, 0x76, 0x75, 0x52, 0x36, 0x52, 0x58, 0x45, 0x7a, 0x2f,
    0x52, 0x54, 0x44, 0x66, 0x52, 0x4b, 0x2f, 0x4a, 0x39, 0x55, 0x33, 0x6e, 0x32, 0x2b, 0x6f, 0x47,
    0x74, 0x76, 0x0a, 0x68, 0x38, 0x44, 0x51, 0x55, 0x42, 0x38, 0x6f, 0x4d, 0x41, 0x4e, 0x41, 0x32,
    0x67, 0x68, 0x7a, 0x55, 0x57, 0x78, 0x2f, 0x2f, 0x7a, 0x6f, 0x38, 0x70, 0x7a, 0x63, 0x47, 0x6a,
    0x72, 0x31, 0x4c, 0x45, 0x51, 0x54, 0x72, 0x66, 0x53, 0x54, 0x65, 0x35, 0x76, 0x6e, 0x38, 0x4d,
    0x58, 0x48, 0x37, 0x6c, 0x4e, 0x56, 0x67, 0x38, 0x79, 0x35, 0x4b, 0x72, 0x30, 0x4c, 0x53, 0x79,
    0x2b, 0x72, 0x45, 0x0a, 0x61, 0x68, 0x71, 0x79, 0x7a, 0x46, 0x50, 0x64, 0x46, 0x55, 0x75, 0x4c,
    0x48, 0x38, 0x67, 0x5a, 0x59, 0x52, 0x2f, 0x4e, 0x6e, 0x61, 0x67, 0x2b, 0x59, 0x79, 0x75, 0x45,
    0x4e, 0x57, 0x6c, 0x6c, 0x68, 0x4d, 0x67, 0x5a, 0x78, 0x55, 0x59, 0x69, 0x2b, 0x46, 0x4f, 0x56,
    0x76, 0x75, 0x4f, 0x41, 0x53, 0x68, 0x44, 0x47, 0x4b, 0x75, 0x79, 0x36, 0x6c, 0x79, 0x41, 0x52,
    0x78, 0x7a, 0x6d, 0x5a, 0x0a, 0x45, 0x41, 0x53, 0x67, 0x38, 0x47, 0x46, 0x36, 0x6c, 0x53, 0x57,
    0x4d, 0x54, 0x6c, 0x4a, 0x31, 0x34, 0x72, 0x62, 0x74, 0x43, 0x4d, 0x6f, 0x55, 0x2f, 0x4d, 0x34,
    0x69, 0x61, 0x72, 0x4e, 0x4f, 0x7a, 0x30, 0x59, 0x44, 0x6c, 0x35, 0x63, 0x44, 0x66, 0x73, 0x43,
    0x78, 0x33, 0x6e, 0x75, 0x76, 0x52, 0x54, 0x50, 0x50, 0x75, 0x6a, 0x35, 0x78, 0x74, 0x39, 0x37,
    0x30, 0x4a, 0x53, 0x58, 0x43, 0x0a, 0x44, 0x54, 0x57, 0x4a, 0x6e, 0x5a, 0x33, 0x37, 0x44, 0x68,
    0x46, 0x35, 0x69, 0x52, 0x34, 0x33, 0x78, 0x61, 0x2b, 0x4f, 0x63, 0x6d, 0x6b, 0x43, 0x41, 0x77,
    0x45, 0x41, 0x41, 0x61, 0x4f, 0x42, 0x35, 0x7a, 0x43, 0x42, 0x35, 0x44, 0x41, 0x66, 0x42, 0x67,
    0x4e, 0x56, 0x48, 0x53, 0x4d, 0x45, 0x47, 0x44, 0x41, 0x57, 0x67, 0x42, 0x54, 0x41, 0x65, 0x70,
    0x68, 0x6f, 0x6a, 0x59, 0x6e, 0x37, 0x0a, 0x71, 0x77, 0x56, 0x6b, 0x44, 0x42, 0x46, 0x39, 0x71,
    0x6e, 0x31, 0x6c, 0x75, 0x4d, 0x72, 0x4d, 0x54, 0x6a, 0x41, 0x64, 0x42, 0x67, 0x4e, 0x56, 0x48,
    0x51, 0x34, 0x45, 0x46, 0x67, 0x51, 0x55, 0x53, 0x74, 0x30, 0x47, 0x46, 0x68, 0x75, 0x38, 0x39,
    0x6d, 0x69, 0x31, 0x64, 0x76, 0x57, 0x42, 0x74, 0x72, 0x74, 0x69, 0x47, 0x72, 0x70, 0x61, 0x67,
    0x53, 0x38, 0x77, 0x44, 0x67, 0x59, 0x44, 0x0a, 0x56, 0x52, 0x30, 0x50, 0x41, 0x51, 0x48, 0x2f,
    0x42, 0x41, 0x51, 0x44, 0x41, 0x67, 0x45, 0x47, 0x4d, 0x43, 0x34, 0x47, 0x43, 0x43, 0x73, 0x47,
    0x41, 0x51, 0x55, 0x46, 0x42, 0x77, 0x45, 0x42, 0x42, 0x43, 0x49, 0x77, 0x49, 0x44, 0x41, 0x65,
    0x42, 0x67, 0x67, 0x72, 0x42, 0x67, 0x45, 0x46, 0x42, 0x51, 0x63, 0x77, 0x41, 0x59, 0x59, 0x53,
    0x61, 0x48, 0x52, 0x30, 0x63, 0x44, 0x6f, 0x76, 0x0a, 0x4c, 0x32, 0x63, 0x75, 0x63, 0x33, 0x6c,
    0x74, 0x59, 0x32, 0x51, 0x75, 0x59, 0x32, 0x39, 0x74, 0x4d, 0x42, 0x49, 0x47, 0x41, 0x31, 0x55,
    0x64, 0x45, 0x77, 0x45, 0x42, 0x2f, 0x77, 0x51, 0x49, 0x4d, 0x41, 0x59, 0x42, 0x41, 0x66, 0x38,
    0x43, 0x41, 0x51, 0x41, 0x77, 0x4e, 0x51, 0x59, 0x44, 0x56, 0x52, 0x30, 0x66, 0x42, 0x43, 0x34,
    0x77, 0x4c, 0x44, 0x41, 0x71, 0x6f, 0x43, 0x69, 0x67, 0x0a, 0x4a, 0x6f, 0x59, 0x6b, 0x61, 0x48,
    0x52, 0x30, 0x63, 0x44, 0x6f, 0x76, 0x4c, 0x32, 0x63, 0x75, 0x63, 0x33, 0x6c, 0x74, 0x59, 0x32,
    0x49, 0x75, 0x59, 0x32, 0x39, 0x74, 0x4c, 0x32, 0x4e, 0x79, 0x62, 0x48, 0x4d, 0x76, 0x5a, 0x33,
    0x52, 0x6e, 0x62, 0x47, 0x39, 0x69, 0x59, 0x57, 0x77, 0x75, 0x59, 0x33, 0x4a, 0x73, 0x4d, 0x42,
    0x63, 0x47, 0x41, 0x31, 0x55, 0x64, 0x49, 0x41, 0x51, 0x51, 0x0a, 0x4d, 0x41, 0x34, 0x77, 0x44,
    0x41, 0x59, 0x4b, 0x4b, 0x77, 0x59, 0x42, 0x42, 0x41, 0x48, 0x57, 0x65, 0x51, 0x49, 0x46, 0x41,
    0x54, 0x41, 0x4e, 0x42, 0x67, 0x6b, 0x71, 0x68, 0x6b, 0x69, 0x47, 0x39, 0x77, 0x30, 0x42, 0x41,
    0x51, 0x73, 0x46, 0x41, 0x41, 0x4f, 0x43, 0x41, 0x51, 0x45, 0x41, 0x43, 0x45, 0x34, 0x45, 0x70,
    0x34, 0x42, 0x2f, 0x45, 0x42, 0x5a, 0x44, 0x58, 0x67, 0x4b, 0x74, 0x0a, 0x31, 0x30, 0x4b, 0x41,
    0x39, 0x4c, 0x43, 0x4f, 0x30, 0x71, 0x36, 0x7a, 0x36, 0x78, 0x46, 0x39, 0x6b, 0x49, 0x51, 0x59,
    0x66, 0x65, 0x65, 0x51, 0x46, 0x66, 0x74, 0x4a, 0x66, 0x36, 0x69, 0x5a, 0x42, 0x5a, 0x47, 0x37,
    0x65, 0x73, 0x6e, 0x57, 0x50, 0x44, 0x63, 0x59, 0x43, 0x5a, 0x71, 0x32, 0x78, 0x35, 0x49, 0x67,
    0x42, 0x7a, 0x55, 0x7a, 0x43, 0x65, 0x51, 0x6f, 0x59, 0x33, 0x49, 0x4e, 0x0a, 0x74, 0x4f, 0x41,
    0x79, 0x6e, 0x49, 0x65, 0x59, 0x78, 0x42, 0x74, 0x32, 0x69, 0x57, 0x66, 0x42, 0x55, 0x46, 0x69,
    0x77, 0x45, 0x36, 0x6f, 0x54, 0x47, 0x68, 0x73, 0x79, 0x70, 0x62, 0x37, 0x71, 0x45, 0x5a, 0x56,
    0x4d, 0x53, 0x47, 0x4e, 0x4a, 0x36, 0x5a, 0x6c, 0x64, 0x49, 0x44, 0x66, 0x4d, 0x2f, 0x69, 0x70,
    0x70, 0x55, 0x52, 0x61, 0x56, 0x53, 0x36, 0x6e, 0x65, 0x53, 0x59, 0x4c, 0x41, 0x0a, 0x45, 0x48,
    0x44, 0x30, 0x4c, 0x50, 0x50, 0x73, 0x76, 0x43, 0x51, 0x6b, 0x30, 0x45, 0x36, 0x73, 0x70, 0x64,
    0x6c, 0x65, 0x48, 0x6d, 0x32, 0x53, 0x77, 0x61, 0x65, 0x73, 0x53, 0x44, 0x57, 0x42, 0x2b, 0x65,
    0x58, 0x6b, 0x6e, 0x47, 0x56, 0x70, 0x7a, 0x59, 0x65, 0x6b, 0x51, 0x56, 0x41, 0x2f, 0x4c, 0x6c,
    0x65, 0x6c, 0x6b, 0x56, 0x45, 0x53, 0x57, 0x41, 0x36, 0x4d, 0x43, 0x61, 0x47, 0x73, 0x0a, 0x65,
    0x71, 0x51, 0x53, 0x70, 0x53, 0x66, 0x7a, 0x6d, 0x68, 0x43, 0x58, 0x66, 0x56, 0x55, 0x44, 0x42,
    0x76, 0x64, 0x6d, 0x57, 0x46, 0x39, 0x66, 0x5a, 0x4f, 0x47, 0x72, 0x58, 0x57, 0x32, 0x6c, 0x4f,
    0x55, 0x68, 0x31, 0x6d, 0x45, 0x77, 0x70, 0x57, 0x6a, 0x71, 0x4e, 0x30, 0x79, 0x76, 0x4b, 0x6e,
    0x46, 0x55, 0x45, 0x76, 0x2f, 0x54, 0x6d, 0x46, 0x4e, 0x57, 0x41, 0x72, 0x43, 0x62, 0x74, 0x0a,
    0x46, 0x34, 0x6d, 0x6d, 0x6b, 0x32, 0x78, 0x63, 0x70, 0x4d, 0x79, 0x34, 0x38, 0x47, 0x61, 0x4f,
    0x5a, 0x4f, 0x4e, 0x39, 0x6d, 0x75, 0x49, 0x41, 0x73, 0x30, 0x6e, 0x48, 0x35, 0x41, 0x71, 0x71,
    0x33, 0x56, 0x75, 0x44, 0x78, 0x33, 0x43, 0x51, 0x52, 0x6b, 0x36, 0x2b, 0x30, 0x4e, 0x74, 0x5a,
    0x6c, 0x6d, 0x77, 0x75, 0x39, 0x52, 0x59, 0x32, 0x33, 0x6e, 0x48, 0x4d, 0x41, 0x63, 0x49, 0x53,
    0x0a, 0x77, 0x53, 0x48, 0x47, 0x46, 0x67, 0x3d, 0x3d, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45,
    0x4e, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d,
    0x2d, 0x2d, 0x2d,
    // PEM encoded certificate
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49,
    0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x43,
    0x6e, 0x44, 0x43, 0x43, 0x41, 0x6a, 0x2b, 0x67, 0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49, 0x55,
    0x44, 0x67, 0x45, 0x38, 0x4e, 0x50, 0x54, 0x4c, 0x46, 0x64, 0x6d, 0x68, 0x75, 0x72, 0x53, 0x69,
    0x36, 0x33, 0x49, 0x31, 0x41, 0x77, 0x76, 0x37, 0x39, 0x49, 0x6b, 0x77, 0x44, 0x41, 0x59, 0x49,
    0x4b, 0x6f, 0x5a, 0x49, 0x7a, 0x6a, 0x30, 0x45, 0x41, 0x77, 0x49, 0x46, 0x0a, 0x41, 0x44, 0x43,
    0x42, 0x67, 0x7a, 0x45, 0x34, 0x4d, 0x44, 0x59, 0x47, 0x41, 0x31, 0x55, 0x45, 0x41, 0x78, 0x4d,
    0x76, 0x55, 0x32, 0x46, 0x74, 0x63, 0x33, 0x56, 0x75, 0x5a, 0x79, 0x42, 0x46, 0x62, 0x47, 0x56,
    0x6a, 0x64, 0x48, 0x4a, 0x76, 0x62, 0x6d, 0x6c, 0x6a, 0x63, 0x79, 0x42, 0x50, 0x51, 0x30, 0x59,
    0x67, 0x54, 0x55, 0x4d, 0x67, 0x52, 0x47, 0x56, 0x32, 0x61, 0x57, 0x4e, 0x6c, 0x0a, 0x49, 0x46,
    0x4e, 0x31, 0x59, 0x6b, 0x4e, 0x42, 0x49, 0x48, 0x59, 0x78, 0x49, 0x46, 0x52, 0x46, 0x55, 0x31,
    0x51, 0x78, 0x48, 0x44, 0x41, 0x61, 0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x73, 0x54, 0x45, 0x30,
    0x39, 0x44, 0x52, 0x69, 0x42, 0x4e, 0x51, 0x79, 0x42, 0x45, 0x5a, 0x58, 0x5a, 0x70, 0x59, 0x32,
    0x55, 0x67, 0x55, 0x33, 0x56, 0x69, 0x51, 0x30, 0x45, 0x78, 0x48, 0x44, 0x41, 0x61, 0x0a, 0x42,
    0x67, 0x4e, 0x56, 0x42, 0x41, 0x6f, 0x54, 0x45, 0x31, 0x4e, 0x68, 0x62, 0x58, 0x4e, 0x31, 0x62,
    0x6d, 0x63, 0x67, 0x52, 0x57, 0x78, 0x6c, 0x59, 0x33, 0x52, 0x79, 0x62, 0x32, 0x35, 0x70, 0x59,
    0x33, 0x4d, 0x78, 0x43, 0x7a, 0x41, 0x4a, 0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x59, 0x54, 0x41,
    0x6b, 0x74, 0x53, 0x4d, 0x43, 0x41, 0x58, 0x44, 0x54, 0x45, 0x32, 0x4d, 0x54, 0x45, 0x79, 0x0a,
    0x4e, 0x44, 0x41, 0x79, 0x4e, 0x44, 0x67, 0x78, 0x4d, 0x6c, 0x6f, 0x59, 0x44, 0x7a, 0x49, 0x77,
    0x4e, 0x6a, 0x6b, 0x78, 0x4d, 0x6a, 0x4d, 0x78, 0x4d, 0x54, 0x51, 0x31, 0x4f, 0x54, 0x55, 0x35,
    0x57, 0x6a, 0x43, 0x42, 0x6a, 0x54, 0x46, 0x49, 0x4d, 0x45, 0x59, 0x47, 0x41, 0x31, 0x55, 0x45,
    0x41, 0x78, 0x4d, 0x2f, 0x54, 0x30, 0x4e, 0x47, 0x49, 0x45, 0x52, 0x6c, 0x64, 0x6d, 0x6c, 0x6a,
    0x0a, 0x5a, 0x53, 0x42, 0x55, 0x52, 0x56, 0x4e, 0x55, 0x4f, 0x69, 0x42, 0x4f, 0x5a, 0x58, 0x52,
    0x33, 0x62, 0x33, 0x4a, 0x72, 0x49, 0x43, 0x67, 0x77, 0x4e, 0x6a, 0x51, 0x79, 0x4e, 0x32, 0x45,
    0x32, 0x4e, 0x53, 0x31, 0x69, 0x5a, 0x6a, 0x63, 0x30, 0x4c, 0x54, 0x51, 0x33, 0x4d, 0x7a, 0x63,
    0x74, 0x4f, 0x54, 0x5a, 0x6d, 0x4d, 0x53, 0x30, 0x78, 0x59, 0x6d, 0x49, 0x78, 0x4f, 0x44, 0x5a,
    0x6b, 0x0a, 0x4f, 0x47, 0x59, 0x33, 0x59, 0x6a, 0x4d, 0x70, 0x4d, 0x52, 0x59, 0x77, 0x46, 0x41,
    0x59, 0x44, 0x56, 0x51, 0x51, 0x4c, 0x45, 0x77, 0x31, 0x50, 0x51, 0x30, 0x59, 0x67, 0x54, 0x55,
    0x4d, 0x67, 0x52, 0x47, 0x56, 0x32, 0x61, 0x57, 0x4e, 0x6c, 0x4d, 0x52, 0x77, 0x77, 0x47, 0x67,
    0x59, 0x44, 0x56, 0x51, 0x51, 0x4b, 0x45, 0x78, 0x4e, 0x54, 0x59, 0x57, 0x31, 0x7a, 0x64, 0x57,
    0x35, 0x6e, 0x0a, 0x49, 0x45, 0x56, 0x73, 0x5a, 0x57, 0x4e, 0x30, 0x63, 0x6d, 0x39, 0x75, 0x61,
    0x57, 0x4e, 0x7a, 0x4d, 0x51, 0x73, 0x77, 0x43, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x47, 0x45,
    0x77, 0x4a, 0x4c, 0x55, 0x6a, 0x42, 0x5a, 0x4d, 0x42, 0x4d, 0x47, 0x42, 0x79, 0x71, 0x47, 0x53,
    0x4d, 0x34, 0x39, 0x41, 0x67, 0x45, 0x47, 0x43, 0x43, 0x71, 0x47, 0x53, 0x4d, 0x34, 0x39, 0x41,
    0x77, 0x45, 0x48, 0x0a, 0x41, 0x30, 0x49, 0x41, 0x42, 0x45, 0x45, 0x77, 0x51, 0x41, 0x52, 0x73,
    0x62, 0x67, 0x43, 0x59, 0x2b, 0x43, 0x59, 0x6b, 0x49, 0x6a, 0x6b, 0x59, 0x6f, 0x47, 0x78, 0x6f,
    0x52, 0x33, 0x75, 0x70, 0x33, 0x38, 0x59, 0x47, 0x54, 0x32, 0x63, 0x4b, 0x30, 0x31, 0x74, 0x6d,
    0x32, 0x70, 0x38, 0x79, 0x4c, 0x4b, 0x4e, 0x73, 0x6d, 0x69, 0x53, 0x6f, 0x76, 0x46, 0x70, 0x4a,
    0x32, 0x35, 0x63, 0x52, 0x0a, 0x74, 0x72, 0x57, 0x34, 0x41, 0x56, 0x7a, 0x76, 0x73, 0x64, 0x67,
    0x62, 0x74, 0x72, 0x45, 0x62, 0x6b, 0x2b, 0x37, 0x73, 0x56, 0x61, 0x58, 0x50, 0x74, 0x78, 0x43,
    0x6a, 0x67, 0x59, 0x41, 0x77, 0x66, 0x6a, 0x41, 0x4f, 0x42, 0x67, 0x4e, 0x56, 0x48, 0x51, 0x38,
    0x42, 0x41, 0x66, 0x38, 0x45, 0x42, 0x41, 0x4d, 0x43, 0x41, 0x38, 0x67, 0x77, 0x4c, 0x67, 0x59,
    0x44, 0x56, 0x52, 0x30, 0x66, 0x0a, 0x42, 0x43, 0x63, 0x77, 0x4a, 0x54, 0x41, 0x6a, 0x6f, 0x43,
    0x47, 0x67, 0x48, 0x34, 0x59, 0x64, 0x61, 0x48, 0x52, 0x30, 0x63, 0x44, 0x6f, 0x76, 0x4c, 0x32,
    0x4e, 0x68, 0x4c, 0x6e, 0x4e, 0x68, 0x62, 0x58, 0x4e, 0x31, 0x62, 0x6d, 0x64, 0x70, 0x62, 0x33,
    0x52, 0x7a, 0x4c, 0x6d, 0x4e, 0x76, 0x62, 0x53, 0x39, 0x6a, 0x63, 0x6d, 0x77, 0x77, 0x50, 0x41,
    0x59, 0x49, 0x4b, 0x77, 0x59, 0x42, 0x0a, 0x42, 0x51, 0x55, 0x48, 0x41, 0x51, 0x45, 0x45, 0x4d,
    0x44, 0x41, 0x75, 0x4d, 0x43, 0x77, 0x47, 0x43, 0x43, 0x73, 0x47, 0x41, 0x51, 0x55, 0x46, 0x42,
    0x7a, 0x41, 0x42, 0x68, 0x69, 0x42, 0x6f, 0x64, 0x48, 0x52, 0x77, 0x4f, 0x69, 0x38, 0x76, 0x62,
    0x32, 0x4e, 0x7a, 0x63, 0x43, 0x31, 0x30, 0x5a, 0x58, 0x4e, 0x30, 0x4c, 0x6e, 0x4e, 0x68, 0x62,
    0x58, 0x4e, 0x31, 0x62, 0x6d, 0x64, 0x70, 0x0a, 0x62, 0x33, 0x52, 0x7a, 0x4c, 0x6d, 0x4e, 0x76,
    0x62, 0x54, 0x41, 0x4d, 0x42, 0x67, 0x67, 0x71, 0x68, 0x6b, 0x6a, 0x4f, 0x50, 0x51, 0x51, 0x44,
    0x41, 0x67, 0x55, 0x41, 0x41, 0x30, 0x6b, 0x41, 0x4d, 0x45, 0x59, 0x43, 0x49, 0x51, 0x43, 0x33,
    0x58, 0x30, 0x42, 0x61, 0x4f, 0x49, 0x6f, 0x63, 0x4b, 0x4f, 0x45, 0x65, 0x44, 0x46, 0x52, 0x6b,
    0x63, 0x66, 0x30, 0x48, 0x76, 0x68, 0x68, 0x67, 0x0a, 0x73, 0x6c, 0x65, 0x49, 0x52, 0x32, 0x49,
    0x62, 0x6d, 0x66, 0x34, 0x6e, 0x69, 0x52, 0x52, 0x55, 0x38, 0x41, 0x49, 0x68, 0x41, 0x4f, 0x4d,
    0x44, 0x31, 0x77, 0x45, 0x62, 0x50, 0x67, 0x34, 0x70, 0x47, 0x77, 0x49, 0x79, 0x65, 0x77, 0x63,
    0x61, 0x6b, 0x76, 0x72, 0x4e, 0x4b, 0x66, 0x44, 0x79, 0x2b, 0x4f, 0x4e, 0x43, 0x6e, 0x4e, 0x6e,
    0x43, 0x59, 0x57, 0x4a, 0x37, 0x39, 0x35, 0x4b, 0x49, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45,
    0x4e, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d,
    0x2d, 0x2d, 0x2d,
    // PEM encoded certificate
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49,
    0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x44,
    0x38, 0x44, 0x43, 0x43, 0x41, 0x74, 0x69, 0x67, 0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49, 0x44,
    0x41, 0x6a, 0x71, 0x53, 0x4d, 0x41, 0x30, 0x47, 0x43, 0x53, 0x71, 0x47, 0x53, 0x49, 0x62, 0x33,
    0x44, 0x51, 0x45, 0x42, 0x43, 0x77, 0x55, 0x41, 0x4d, 0x45, 0x49, 0x78, 0x43, 0x7a, 0x41, 0x4a,
    0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x59, 0x54, 0x41, 0x6c, 0x56, 0x54, 0x0a, 0x4d, 0x52, 0x59,
    0x77, 0x46, 0x41, 0x59, 0x44, 0x56, 0x51, 0x51, 0x4b, 0x45, 0x77, 0x31, 0x48, 0x5a, 0x57, 0x39,
    0x55, 0x63, 0x6e, 0x56, 0x7a, 0x64, 0x43, 0x42, 0x4a, 0x62, 0x6d, 0x4d, 0x75, 0x4d, 0x52, 0x73,
    0x77, 0x47, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x44, 0x45, 0x78, 0x4a, 0x48, 0x5a, 0x57, 0x39,
    0x55, 0x63, 0x6e, 0x56, 0x7a, 0x64, 0x43, 0x42, 0x48, 0x62, 0x47, 0x39, 0x69, 0x0a, 0x59, 0x57,
    0x77, 0x67, 0x51, 0x30, 0x45, 0x77, 0x48, 0x68, 0x63, 0x4e, 0x4d, 0x54, 0x55, 0x77, 0x4e, 0x44,
    0x41, 0x78, 0x4d, 0x44, 0x41, 0x77, 0x4d, 0x44, 0x41, 0x77, 0x57, 0x68, 0x63, 0x4e, 0x4d, 0x54,
    0x63, 0x78, 0x4d, 0x6a, 0x4d, 0x78, 0x4d, 0x6a, 0x4d, 0x31, 0x4f, 0x54, 0x55, 0x35, 0x57, 0x6a,
    0x42, 0x4a, 0x4d, 0x51, 0x73, 0x77, 0x43, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x47, 0x0a, 0x45,
    0x77, 0x4a, 0x56, 0x55, 0x7a, 0x45, 0x54, 0x4d, 0x42, 0x45, 0x47, 0x41, 0x31, 0x55, 0x45, 0x43,
    0x68, 0x4d, 0x4b, 0x52, 0x32, 0x39, 0x76, 0x5a, 0x32, 0x78, 0x6c, 0x49, 0x45, 0x6c, 0x75, 0x59,
    0x7a, 0x45, 0x6c, 0x4d, 0x43, 0x4d, 0x47, 0x41, 0x31, 0x55, 0x45, 0x41, 0x78, 0x4d, 0x63, 0x52,
    0x32, 0x39, 0x76, 0x5a, 0x32, 0x78, 0x6c, 0x49, 0x45, 0x6c, 0x75, 0x64, 0x47, 0x56, 0x79, 0x0a,
    0x62, 0x6d, 0x56, 0x30, 0x49, 0x45, 0x46, 0x31, 0x64, 0x47, 0x68, 0x76, 0x63, 0x6d, 0x6c, 0x30,
    0x65, 0x53, 0x42, 0x48, 0x4d, 0x6a, 0x43, 0x43, 0x41, 0x53, 0x49, 0x77, 0x44, 0x51, 0x59, 0x4a,
    0x4b, 0x6f, 0x5a, 0x49, 0x68, 0x76, 0x63, 0x4e, 0x41, 0x51, 0x45, 0x42, 0x42, 0x51, 0x41, 0x44,
    0x67, 0x67, 0x45, 0x50, 0x41, 0x44, 0x43, 0x43, 0x41, 0x51, 0x6f, 0x43, 0x67, 0x67, 0x45, 0x42,
    0x0a, 0x41, 0x4a, 0x77, 0x71, 0x42, 0x48, 0x64, 0x63, 0x32, 0x46, 0x43, 0x52, 0x4f, 0x67, 0x61,
    0x6a, 0x67, 0x75, 0x44, 0x59, 0x55, 0x45, 0x69, 0x38, 0x69, 0x54, 0x2f, 0x78, 0x47, 0x58, 0x41,
    0x61, 0x69, 0x45, 0x5a, 0x2b, 0x34, 0x49, 0x2f, 0x46, 0x38, 0x59, 0x6e, 0x4f, 0x49, 0x65, 0x35,
    0x61, 0x2f, 0x6d, 0x45, 0x4e, 0x74, 0x7a, 0x4a, 0x45, 0x69, 0x61, 0x42, 0x30, 0x43, 0x31, 0x4e,
    0x50, 0x0a, 0x56, 0x61, 0x54, 0x4f, 0x67, 0x6d, 0x4b, 0x56, 0x37, 0x75, 0x74, 0x5a, 0x58, 0x38,
    0x62, 0x68, 0x42, 0x59, 0x41, 0x53, 0x78, 0x46, 0x36, 0x55, 0x50, 0x37, 0x78, 0x62, 0x53, 0x44,
    0x6a, 0x30, 0x55, 0x2f, 0x63, 0x6b, 0x35, 0x76, 0x75, 0x52, 0x36, 0x52, 0x58, 0x45, 0x7a, 0x2f,
    0x52, 0x54, 0x44, 0x66, 0x52, 0x4b, 0x2f, 0x4a, 0x39, 0x55, 0x33, 0x6e, 0x32, 0x2b, 0x6f, 0x47,
    0x74, 0x76, 0x0a, 0x68, 0x38, 0x44, 0x51, 0x55, 0x42, 0x38, 0x6f, 0x4d, 0x41, 0x4e, 0x41, 0x32,
    0x67, 0x68, 0x7a, 0x55, 0x57, 0x78, 0x2f, 0x2f, 0x7a, 0x6f, 0x38, 0x70, 0x7a, 0x63, 0x47, 0x6a,
    0x72, 0x31, 0x4c, 0x45, 0x51, 0x54, 0x72, 0x66, 0x53, 0x54, 0x65, 0x35, 0x76, 0x6e, 0x38, 0x4d,
    0x58, 0x48, 0x37, 0x6c, 0x4e, 0x56, 0x67, 0x38, 0x79, 0x35, 0x4b, 0x72, 0x30, 0x4c, 0x53, 0x79,
    0x2b, 0x72, 0x45, 0x0a, 0x61, 0x68, 0x71, 0x79, 0x7a, 0x46, 0x50, 0x64, 0x46, 0x55, 0x75, 0x4c,
    0x48, 0x38, 0x67, 0x5a, 0x59, 0x52, 0x2f, 0x4e, 0x6e, 0x61, 0x67, 0x2b, 0x59, 0x79, 0x75, 0x45,
    0x4e, 0x57, 0x6c, 0x6c, 0x68, 0x4d, 0x67, 0x5a, 0x78, 0x55, 0x59, 0x69, 0x2b, 0x46, 0x4f, 0x56,
    0x76, 0x75, 0x4f, 0x41, 0x53, 0x68, 0x44, 0x47, 0x4b, 0x75, 0x79, 0x36, 0x6c, 0x79, 0x41, 0x52,
    0x78, 0x7a, 0x6d, 0x5a, 0x0a, 0x45, 0x41, 0x53, 0x67, 0x38, 0x47, 0x46, 0x36, 0x6c, 0x53, 0x57,
    0x4d, 0x54, 0x6c, 0x4a, 0x31, 0x34, 0x72, 0x62, 0x74, 0x43, 0x4d, 0x6f, 0x55, 0x2f, 0x4d, 0x34,
    0x69, 0x61, 0x72, 0x4e, 0x4f, 0x7a, 0x30, 0x59, 0x44, 0x6c, 0x35, 0x63, 0x44, 0x66, 0x73, 0x43,
    0x78, 0x33, 0x6e, 0x75, 0x76, 0x52, 0x54, 0x50, 0x50, 0x75, 0x6a, 0x35, 0x78, 0x74, 0x39, 0x37,
    0x30, 0x4a, 0x53, 0x58, 0x43, 0x0a, 0x44, 0x54, 0x57, 0x4a, 0x6e, 0x5a, 0x33, 0x37, 0x44, 0x68,
    0x46, 0x35, 0x69, 0x52, 0x34, 0x33, 0x78, 0x61, 0x2b, 0x4f, 0x63, 0x6d, 0x6b, 0x43, 0x41, 0x77,
    0x45, 0x41, 0x41, 0x61, 0x4f, 0x42, 0x35, 0x7a, 0x43, 0x42, 0x35, 0x44, 0x41, 0x66, 0x42, 0x67,
    0x4e, 0x56, 0x48, 0x53, 0x4d, 0x45, 0x47, 0x44, 0x41, 0x57, 0x67, 0x42, 0x54, 0x41, 0x65, 0x70,
    0x68, 0x6f, 0x6a, 0x59, 0x6e, 0x37, 0x0a, 0x71, 0x77, 0x56, 0x6b, 0x44, 0x42, 0x46, 0x39, 0x71,
    0x6e, 0x31, 0x6c, 0x75, 0x4d, 0x72, 0x4d, 0x54, 0x6a, 0x41, 0x64, 0x42, 0x67, 0x4e, 0x56, 0x48,
    0x51, 0x34, 0x45, 0x46, 0x67, 0x51, 0x55, 0x53, 0x74, 0x30, 0x47, 0x46, 0x68, 0x75, 0x38, 0x39,
    0x6d, 0x69, 0x31, 0x64, 0x76, 0x57, 0x42, 0x74, 0x72, 0x74, 0x69, 0x47, 0x72, 0x70, 0x61, 0x67,
    0x53, 0x38, 0x77, 0x44, 0x67, 0x59, 0x44, 0x0a, 0x56, 0x52, 0x30, 0x50, 0x41, 0x51, 0x48, 0x2f,
    0x42, 0x41, 0x51, 0x44, 0x41, 0x67, 0x45, 0x47, 0x4d, 0x43, 0x34, 0x47, 0x43, 0x43, 0x73, 0x47,
    0x41, 0x51, 0x55, 0x46, 0x42, 0x77, 0x45, 0x42, 0x42, 0x43, 0x49, 0x77, 0x49, 0x44, 0x41, 0x65,
    0x42, 0x67, 0x67, 0x72, 0x42, 0x67, 0x45, 0x46, 0x42, 0x51, 0x63, 0x77, 0x41, 0x59, 0x59, 0x53,
    0x61, 0x48, 0x52, 0x30, 0x63, 0x44, 0x6f, 0x76, 0x0a, 0x4c, 0x32, 0x63, 0x75, 0x63, 0x33, 0x6c,
    0x74, 0x59, 0x32, 0x51, 0x75, 0x59, 0x32, 0x39, 0x74, 0x4d, 0x42, 0x49, 0x47, 0x41, 0x31, 0x55,
    0x64, 0x45, 0x77, 0x45, 0x42, 0x2f, 0x77, 0x51, 0x49, 0x4d, 0x41, 0x59, 0x42, 0x41, 0x66, 0x38,
    0x43, 0x41, 0x51, 0x41, 0x77, 0x4e, 0x51, 0x59, 0x44, 0x56, 0x52, 0x30, 0x66, 0x42, 0x43, 0x34,
    0x77, 0x4c, 0x44, 0x41, 0x71, 0x6f, 0x43, 0x69, 0x67, 0x0a, 0x4a, 0x6f, 0x59, 0x6b, 0x61, 0x48,
    0x52, 0x30, 0x63, 0x44, 0x6f, 0x76, 0x4c, 0x32, 0x63, 0x75, 0x63, 0x33, 0x6c, 0x74, 0x59, 0x32,
    0x49, 0x75, 0x59, 0x32, 0x39, 0x74, 0x4c, 0x32, 0x4e, 0x79, 0x62, 0x48, 0x4d, 0x76, 0x5a, 0x33,
    0x52, 0x6e, 0x62, 0x47, 0x39, 0x69, 0x59, 0x57, 0x77, 0x75, 0x59, 0x33, 0x4a, 0x73, 0x4d, 0x42,
    0x63, 0x47, 0x41, 0x31, 0x55, 0x64, 0x49, 0x41, 0x51, 0x51, 0x0a, 0x4d, 0x41, 0x34, 0x77, 0x44,
    0x41, 0x59, 0x4b, 0x4b, 0x77, 0x59, 0x42, 0x42, 0x41, 0x48, 0x57, 0x65, 0x51, 0x49, 0x46, 0x41,
    0x54, 0x41, 0x4e, 0x42, 0x67, 0x6b, 0x71, 0x68, 0x6b, 0x69, 0x47, 0x39, 0x77, 0x30, 0x42, 0x41,
    0x51, 0x73, 0x46, 0x41, 0x41, 0x4f, 0x43, 0x41, 0x51, 0x45, 0x41, 0x43, 0x45, 0x34, 0x45, 0x70,
    0x34, 0x42, 0x2f, 0x45, 0x42, 0x5a, 0x44, 0x58, 0x67, 0x4b, 0x74, 0x0a, 0x31, 0x30, 0x4b, 0x41,
    0x39, 0x4c, 0x43, 0x4f, 0x30, 0x71, 0x36, 0x7a, 0x36, 0x78, 0x46, 0x39, 0x6b, 0x49, 0x51, 0x59,
    0x66, 0x65, 0x65, 0x51, 0x46, 0x66, 0x74, 0x4a, 0x66, 0x36, 0x69, 0x5a, 0x42, 0x5a, 0x47, 0x37,
    0x65, 0x73, 0x6e, 0x57, 0x50, 0x44, 0x63, 0x59, 0x43, 0x5a, 0x71, 0x32, 0x78, 0x35, 0x49, 0x67,
    0x42, 0x7a, 0x55, 0x7a, 0x43, 0x65, 0x51, 0x6f, 0x59, 0x33, 0x49, 0x4e, 0x0a, 0x74, 0x4f, 0x41,
    0x79, 0x6e, 0x49, 0x65, 0x59, 0x78, 0x42, 0x74, 0x32, 0x69, 0x57, 0x66, 0x42, 0x55, 0x46, 0x69,
    0x77, 0x45, 0x36, 0x6f, 0x54, 0x47, 0x68, 0x73, 0x79, 0x70, 0x62, 0x37, 0x71, 0x45, 0x5a, 0x56,
    0x4d, 0x53, 0x47, 0x4e, 0x4a, 0x36, 0x5a, 0x6c, 0x64, 0x49, 0x44, 0x66, 0x4d, 0x2f, 0x69, 0x70,
    0x70, 0x55, 0x52, 0x61, 0x56, 0x53, 0x36, 0x6e, 0x65, 0x53, 0x59, 0x4c, 0x41, 0x0a, 0x45, 0x48,
    0x44, 0x30, 0x4c, 0x50, 0x50, 0x73, 0x76, 0x43, 0x51, 0x6b, 0x30, 0x45, 0x36, 0x73, 0x70, 0x64,
    0x6c, 0x65, 0x48, 0x6d, 0x32, 0x53, 0x77, 0x61, 0x65, 0x73, 0x53, 0x44, 0x57, 0x42, 0x2b, 0x65,
    0x58, 0x6b, 0x6e, 0x47, 0x56, 0x70, 0x7a, 0x59, 0x65, 0x6b, 0x51, 0x56, 0x41, 0x2f, 0x4c, 0x6c,
    0x65, 0x6c, 0x6b, 0x56, 0x45, 0x53, 0x57, 0x41, 0x36, 0x4d, 0x43, 0x61, 0x47, 0x73, 0x0a, 0x65,
    0x71, 0x51, 0x53, 0x70, 0x53, 0x66, 0x7a, 0x6d, 0x68, 0x43, 0x58, 0x66, 0x56, 0x55, 0x44, 0x42,
    0x76, 0x64, 0x6d, 0x57, 0x46, 0x39, 0x66, 0x5a, 0x4f, 0x47, 0x72, 0x58, 0x57, 0x32, 0x6c, 0x4f,
    0x55, 0x68, 0x31, 0x6d, 0x45, 0x77, 0x70, 0x57, 0x6a, 0x71, 0x4e, 0x30, 0x79, 0x76, 0x4b, 0x6e,
    0x46, 0x55, 0x45, 0x76, 0x2f, 0x54, 0x6d, 0x46, 0x4e, 0x57, 0x41, 0x72, 0x43, 0x62, 0x74, 0x0a,
    0x46, 0x34, 0x6d, 0x6d, 0x6b, 0x32, 0x78, 0x63, 0x70, 0x4d, 0x79, 0x34, 0x38, 0x47, 0x61, 0x4f,
    0x5a, 0x4f, 0x4e, 0x39, 0x6d, 0x75, 0x49, 0x41, 0x73, 0x30, 0x6e, 0x48, 0x35, 0x41, 0x71, 0x71,
    0x33, 0x56, 0x75, 0x44, 0x78, 0x33, 0x43, 0x51, 0x52, 0x6b, 0x36, 0x2b, 0x30, 0x4e, 0x74, 0x5a,
    0x6c, 0x6d, 0x77, 0x75, 0x39, 0x52, 0x59, 0x32, 0x33, 0x6e, 0x48, 0x4d, 0x41, 0x63, 0x49, 0x53,
    0x0a, 0x77, 0x53, 0x48, 0x47, 0x46, 0x67, 0x3d, 0x3d, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45,
    0x4e, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d,
    0x2d, 0x2d, 0x2d,
    // PEM encoded certificate
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49,
    0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x43,
    0x6e, 0x44, 0x43, 0x43, 0x41, 0x6a, 0x2b, 0x67, 0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49, 0x55,
    0x44, 0x67, 0x45, 0x38, 0x4e, 0x50, 0x54, 0x4c, 0x46, 0x64, 0x6d, 0x68, 0x75, 0x72, 0x53, 0x69,
    0x36, 0x33, 0x49, 0x31, 0x41, 0x77, 0x76, 0x37, 0x39, 0x49, 0x6b, 0x77, 0x44, 0x41, 0x59, 0x49,
    0x4b, 0x6f, 0x5a, 0x49, 0x7a, 0x6a, 0x30, 0x45, 0x41, 0x77, 0x49, 0x46, 0x0a, 0x41, 0x44, 0x43,
    0x42, 0x67, 0x7a, 0x45, 0x34, 0x4d, 0x44, 0x59, 0x47, 0x41, 0x31, 0x55, 0x45, 0x41, 0x78, 0x4d,
    0x76, 0x55, 0x32, 0x46, 0x74, 0x63, 0x33, 0x56, 0x75, 0x5a, 0x79, 0x42, 0x46, 0x62, 0x47, 0x56,
    0x6a, 0x64, 0x48, 0x4a, 0x76, 0x62, 0x6d, 0x6c, 0x6a, 0x63, 0x79, 0x42, 0x50, 0x51, 0x30, 0x59,
    0x67, 0x54, 0x55, 0x4d, 0x67, 0x52, 0x47, 0x56, 0x32, 0x61, 0x57, 0x4e, 0x6c, 0x0a, 0x49, 0x46,
    0x4e, 0x31, 0x59, 0x6b, 0x4e, 0x42, 0x49, 0x48, 0x59, 0x78, 0x49, 0x46, 0x52, 0x46, 0x55, 0x31,
    0x51, 0x78, 0x48, 0x44, 0x41, 0x61, 0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x73, 0x54, 0x45, 0x30,
    0x39, 0x44, 0x52, 0x69, 0x42, 0x4e, 0x51, 0x79, 0x42, 0x45, 0x5a, 0x58, 0x5a, 0x70, 0x59, 0x32,
    0x55, 0x67, 0x55, 0x33, 0x56, 0x69, 0x51, 0x30, 0x45, 0x78, 0x48, 0x44, 0x41, 0x61, 0x0a, 0x42,
    0x67, 0x4e, 0x56, 0x42, 0x41, 0x6f, 0x54, 0x45, 0x31, 0x4e, 0x68, 0x62, 0x58, 0x4e, 0x31, 0x62,
    0x6d, 0x63, 0x67, 0x52, 0x57, 0x78, 0x6c, 0x59, 0x33, 0x52, 0x79, 0x62, 0x32, 0x35, 0x70, 0x59,
    0x33, 0x4d, 0x78, 0x43, 0x7a, 0x41, 0x4a, 0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x59, 0x54, 0x41,
    0x6b, 0x74, 0x53, 0x4d, 0x43, 0x41, 0x58, 0x44, 0x54, 0x45, 0x32, 0x4d, 0x54, 0x45, 0x79, 0x0a,
    0x4e, 0x44, 0x41, 0x79, 0x4e, 0x44, 0x67, 0x78, 0x4d, 0x6c, 0x6f, 0x59, 0x44, 0x7a, 0x49, 0x77,
    0x4e, 0x6a, 0x6b, 0x78, 0x4d, 0x6a, 0x4d, 0x78, 0x4d, 0x54, 0x51, 0x31, 0x4f, 0x54, 0x55, 0x35,
    0x57, 0x6a, 0x43, 0x42, 0x6a, 0x54, 0x46, 0x49, 0x4d, 0x45, 0x59, 0x47, 0x41, 0x31, 0x55, 0x45,
    0x41, 0x78, 0x4d, 0x2f, 0x54, 0x30, 0x4e, 0x47, 0x49, 0x45, 0x52, 0x6c, 0x64, 0x6d, 0x6c, 0x6a,
    0x0a, 0x5a, 0x53, 0x42, 0x55, 0x52, 0x56, 0x4e, 0x55, 0x4f, 0x69, 0x42, 0x4f, 0x5a, 0x58, 0x52,
    0x33, 0x62, 0x33, 0x4a, 0x72, 0x49, 0x43, 0x67, 0x77, 0x4e, 0x6a, 0x51, 0x79, 0x4e, 0x32, 0x45,
    0x32, 0x4e, 0x53, 0x31, 0x69, 0x5a, 0x6a, 0x63, 0x30, 0x4c, 0x54, 0x51, 0x33, 0x4d, 0x7a, 0x63,
    0x74, 0x4f, 0x54, 0x5a, 0x6d, 0x4d, 0x53, 0x30, 0x78, 0x59, 0x6d, 0x49, 0x78, 0x4f, 0x44, 0x5a,
    0x6b, 0x0a, 0x4f, 0x47, 0x59, 0x33, 0x59, 0x6a, 0x4d, 0x70, 0x4d, 0x52, 0x59, 0x77, 0x46, 0x41,
    0x59, 0x44, 0x56, 0x51, 0x51, 0x4c, 0x45, 0x77, 0x31, 0x50, 0x51, 0x30, 0x59, 0x67, 0x54, 0x55,
    0x4d, 0x67, 0x52, 0x47, 0x56, 0x32, 0x61, 0x57, 0x4e, 0x6c, 0x4d, 0x52, 0x77, 0x77, 0x47, 0x67,
    0x59, 0x44, 0x56, 0x51, 0x51, 0x4b, 0x45, 0x78, 0x4e, 0x54, 0x59, 0x57, 0x31, 0x7a, 0x64, 0x57,
    0x35, 0x6e, 0x0a, 0x49, 0x45, 0x56, 0x73, 0x5a, 0x57, 0x4e, 0x30, 0x63, 0x6d, 0x39, 0x75, 0x61,
    0x57, 0x4e, 0x7a, 0x4d, 0x51, 0x73, 0x77, 0x43, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x47, 0x45,
    0x77, 0x4a, 0x4c, 0x55, 0x6a, 0x42, 0x5a, 0x4d, 0x42, 0x4d, 0x47, 0x42, 0x79, 0x71, 0x47, 0x53,
    0x4d, 0x34, 0x39, 0x41, 0x67, 0x45, 0x47, 0x43, 0x43, 0x71, 0x47, 0x53, 0x4d, 0x34, 0x39, 0x41,
    0x77, 0x45, 0x48, 0x0a, 0x41, 0x30, 0x49, 0x41, 0x42, 0x45, 0x45, 0x77, 0x51, 0x41, 0x52, 0x73,
    0x62, 0x67, 0x43, 0x59, 0x2b, 0x43, 0x59, 0x6b, 0x49, 0x6a, 0x6b, 0x59, 0x6f, 0x47, 0x78, 0x6f,
    0x52, 0x33, 0x75, 0x70, 0x33, 0x38, 0x59, 0x47, 0x54, 0x32, 0x63, 0x4b, 0x30, 0x31, 0x74, 0x6d,
    0x32, 0x70, 0x38, 0x79, 0x4c, 0x4b, 0x4e, 0x73, 0x6d, 0x69, 0x53, 0x6f, 0x76, 0x46, 0x70, 0x4a,
    0x32, 0x35, 0x63, 0x52, 0x0a, 0x74, 0x72, 0x57, 0x34, 0x41, 0x56, 0x7a, 0x76, 0x73, 0x64, 0x67,
    0x62, 0x74, 0x72, 0x45, 0x62, 0x6b, 0x2b, 0x37, 0x73, 0x56, 0x61, 0x58, 0x50, 0x74, 0x78, 0x43,
    0x6a, 0x67, 0x59, 0x41, 0x77, 0x66, 0x6a, 0x41, 0x4f, 0x42, 0x67, 0x4e, 0x56, 0x48, 0x51, 0x38,
    0x42, 0x41, 0x66, 0x38, 0x45, 0x42, 0x41, 0x4d, 0x43, 0x41, 0x38, 0x67, 0x77, 0x4c, 0x67, 0x59,
    0x44, 0x56, 0x52, 0x30, 0x66, 0x0a, 0x42, 0x43, 0x63, 0x77, 0x4a, 0x54, 0x41, 0x6a, 0x6f, 0x43,
    0x47, 0x67, 0x48, 0x34, 0x59, 0x64, 0x61, 0x48, 0x52, 0x30, 0x63, 0x44, 0x6f, 0x76, 0x4c, 0x32,
    0x4e, 0x68, 0x4c, 0x6e, 0x4e, 0x68, 0x62, 0x58, 0x4e, 0x31, 0x62, 0x6d, 0x64, 0x70, 0x62, 0x33,
    0x52, 0x7a, 0x4c, 0x6d, 0x4e, 0x76, 0x62, 0x53, 0x39, 0x6a, 0x63, 0x6d, 0x77, 0x77, 0x50, 0x41,
    0x59, 0x49, 0x4b, 0x77, 0x59, 0x42, 0x0a, 0x42, 0x51, 0x55, 0x48, 0x41, 0x51, 0x45, 0x45, 0x4d,
    0x44, 0x41, 0x75, 0x4d, 0x43, 0x77, 0x47, 0x43, 0x43, 0x73, 0x47, 0x41, 0x51, 0x55, 0x46, 0x42,
    0x7a, 0x41, 0x42, 0x68, 0x69, 0x42, 0x6f, 0x64, 0x48, 0x52, 0x77, 0x4f, 0x69, 0x38, 0x76, 0x62,
    0x32, 0x4e, 0x7a, 0x63, 0x43, 0x31, 0x30, 0x5a, 0x58, 0x4e, 0x30, 0x4c, 0x6e, 0x4e, 0x68, 0x62,
    0x58, 0x4e, 0x31, 0x62, 0x6d, 0x64, 0x70, 0x0a, 0x62, 0x33, 0x52, 0x7a, 0x4c, 0x6d, 0x4e, 0x76,
    0x62, 0x54, 0x41, 0x4d, 0x42, 0x67, 0x67, 0x71, 0x68, 0x6b, 0x6a, 0x4f, 0x50, 0x51, 0x51, 0x44,
    0x41, 0x67, 0x55, 0x41, 0x41, 0x30, 0x6b, 0x41, 0x4d, 0x45, 0x59, 0x43, 0x49, 0x51, 0x43, 0x33,
    0x58, 0x30, 0x42, 0x61, 0x4f, 0x49, 0x6f, 0x63, 0x4b, 0x4f, 0x45, 0x65, 0x44, 0x46, 0x52, 0x6b,
    0x63, 0x66, 0x30, 0x48, 0x76, 0x68, 0x68, 0x67, 0x0a, 0x73, 0x6c, 0x65, 0x49, 0x52, 0x32, 0x49,
    0x62, 0x6d, 0x66, 0x34, 0x6e, 0x69, 0x52, 0x52, 0x55, 0x38, 0x41, 0x49, 0x68, 0x41, 0x4f, 0x4d,
    0x44, 0x31, 0x77, 0x45, 0x62, 0x50, 0x67, 0x34, 0x70, 0x47, 0x77, 0x49, 0x79, 0x65, 0x77, 0x63,
    0x61, 0x6b, 0x76, 0x72, 0x4e, 0x4b, 0x66, 0x44, 0x79, 0x2b, 0x4f, 0x4e, 0x43, 0x6e, 0x4e, 0x6e,
    0x43, 0x59, 0x57, 0x4a, 0x37, 0x39, 0x35, 0x4b, 0x49, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45,
    0x4e, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d,
    0x2d, 0x2d, 0x2d,
    // NULL terminator
    0x00
};
int certChainLen = sizeof(certChain);

unsigned char serverCert[] =
    "-----BEGIN CERTIFICATE-----\n"
    "MIICOTCCAd8CAQEwCgYIKoZIzj0EAwIwfDELMAkGA1UEBhMCVVMxEjAQBgNVBAgM\n"
    "CVNvbWVzdGF0ZTERMA8GA1UEBwwIU29tZWNpdHkxCzAJBgNVBAoMAkJCMRYwFAYD\n"
    "VQQLDA1TZXF1cml0eSBQYXJ0MQswCQYDVQQDDAJvYjEUMBIGCSqGSIb3DQEJARYF\n"
    "b2JAYmIwHhcNMTYwODE1MTMxMTE3WhcNMTkwNTEyMTMxMTE3WjCB1DELMAkGA1UE\n"
    "BhMCVUExDDAKBgNVBAgMA0FzZDEPMA0GA1UEBwwGR290aGFtMQswCQYDVQQKDAJa\n"
    "WjERMA8GA1UECwwIQmVhbVRlYW0xHDAaBgkqhkiG9w0BCQEWDXJhaWxAbWFpbC5j\n"
    "b20xMjAwBgNVBAMMKXV1aWQ6MzIzMjMyMzItMzIzMi0zMjMyLTMyMzItMzIzMjMy\n"
    "MzIzMjMyMTQwMgYDVR0RDCt1c2VyaWQ6Njc2NzY3NjctNjc2Ny02NzY3LTY3Njct\n"
    "Njc2NzY3Njc2NzY3MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE9xNcc3LOEOUJ\n"
    "l5r48nCmPYn1xeRE4kq2YagSjbTcK0eEYAwlZung5awivxXccbGITxa/wnc3dj/g\n"
    "Z8YdI/58izAKBggqhkjOPQQDAgNIADBFAiBHzEGKJ8fQqrSrhb8JTQbXfg05+Tah\n"
    "PZYj4iRkmGMhugIhAOWPf/GmggNqGHpU5w4ld9hG+paKfhTEyyEyPonZuow/\n"
    "-----END CERTIFICATE-----\n";
int serverCertLen = sizeof(serverCert);

unsigned char serverPrivateKey[] = {
    0x30, 0x77, 0x02, 0x01, 0x01, 0x04, 0x20, 0x02, 0x51, 0xb5, 0x97, 0xb9, 0xe9, 0xd8, 0x8d, 0x66,
    0x2b, 0x8a, 0xb3, 0x9c, 0x6a, 0xd2, 0xca, 0x18, 0x21, 0xb9, 0x87, 0x3d, 0xf5, 0x8e, 0xa2, 0x8d,
    0x38, 0xf6, 0xb7, 0xd2, 0x76, 0x74, 0x99, 0xa0, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
    0x03, 0x01, 0x07, 0xa1, 0x44, 0x03, 0x42, 0x00, 0x04, 0xf7, 0x13, 0x5c, 0x73, 0x72, 0xce, 0x10,
    0xe5, 0x09, 0x97, 0x9a, 0xf8, 0xf2, 0x70, 0xa6, 0x3d, 0x89, 0xf5, 0xc5, 0xe4, 0x44, 0xe2, 0x4a,
    0xb6, 0x61, 0xa8, 0x12, 0x8d, 0xb4, 0xdc, 0x2b, 0x47, 0x84, 0x60, 0x0c, 0x25, 0x66, 0xe9, 0xe0,
    0xe5, 0xac, 0x22, 0xbf, 0x15, 0xdc, 0x71, 0xb1, 0x88, 0x4f, 0x16, 0xbf, 0xc2, 0x77, 0x37, 0x76,
    0x3f, 0xe0, 0x67, 0xc6, 0x1d, 0x23, 0xfe, 0x7c, 0x8b
};

int serverPrivateKeyLen = sizeof(serverPrivateKey);

unsigned char caCert[] = 
    "-----BEGIN CERTIFICATE-----\n"
    "MIICPjCCAeWgAwIBAgIJAIenaAF86fjwMAoGCCqGSM49BAMCMHwxCzAJBgNVBAYT\n"
    "AlVTMRIwEAYDVQQIDAlTb21lc3RhdGUxETAPBgNVBAcMCFNvbWVjaXR5MQswCQYD\n"
    "VQQKDAJCQjEWMBQGA1UECwwNU2VxdXJpdHkgUGFydDELMAkGA1UEAwwCb2IxFDAS\n"
    "BgkqhkiG9w0BCQEWBW9iQGJiMB4XDTE2MDcyNTExMTYxMVoXDTE5MDUxNTExMTYx\n"
    "MVowfDELMAkGA1UEBhMCVVMxEjAQBgNVBAgMCVNvbWVzdGF0ZTERMA8GA1UEBwwI\n"
    "U29tZWNpdHkxCzAJBgNVBAoMAkJCMRYwFAYDVQQLDA1TZXF1cml0eSBQYXJ0MQsw\n"
    "CQYDVQQDDAJvYjEUMBIGCSqGSIb3DQEJARYFb2JAYmIwWTATBgcqhkjOPQIBBggq\n"
    "hkjOPQMBBwNCAAQuz8P6LgQRYjRjb9+2Z/taUIwVc8nBVzqe+PSoDBrpkVGdAyZI\n"
    "qkaEEgYt/Ga+Qe39zTKjmzTyqpUfjl1Jd4DCo1AwTjAdBgNVHQ4EFgQUHoHDYv+M\n"
    "WpiQrCzDZbk/jwRV+nwwHwYDVR0jBBgwFoAUHoHDYv+MWpiQrCzDZbk/jwRV+nww\n"
    "DAYDVR0TBAUwAwEB/zAKBggqhkjOPQQDAgNHADBEAiAcoVWoBLxbAKisL+a3PHzz\n"
    "fpPO4N9uNuQ2IMs2nBM7xAIgfxgTfRuM41vZrHSMwOm/G0hvtmpFA6ZdTWX3lqAI\n"
    "g3w=\n"
    "-----END CERTIFICATE-----\n";
int caCertLen = sizeof(caCert);

unsigned char control_server_message_ECDHE_ECDSA_WITH_AES_128_CCM[] = {
    0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x30, 0x20, 0x32, 0x30, 0x30, 0x20, 0x4f, 0x4b, 0x0d,
    0x0a, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54, 0x79, 0x70, 0x65, 0x3a, 0x20, 0x74,
    0x65, 0x78, 0x74, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x68, 0x32, 0x3e,
    0x6d, 0x62, 0x65, 0x64, 0x20, 0x54, 0x4c, 0x53, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x53, 0x65,
    0x72, 0x76, 0x65, 0x72, 0x3c, 0x2f, 0x68, 0x32, 0x3e, 0x0d, 0x0a, 0x54, 0x45, 0x53, 0x54, 0x20,
    0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x0d, 0x0a, 0x3c, 0x70, 0x3e, 0x53, 0x75, 0x63, 0x63,
    0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x20, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
    0x6e, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x3a, 0x20, 0x54, 0x4c, 0x53, 0x2d, 0x45, 0x43, 0x44,
    0x48, 0x45, 0x2d, 0x45, 0x43, 0x44, 0x53, 0x41, 0x2d, 0x57, 0x49, 0x54, 0x48, 0x2d, 0x41, 0x45,
    0x53, 0x2d, 0x31, 0x32, 0x38, 0x2d, 0x43, 0x43, 0x4d, 0x3c, 0x2f, 0x70, 0x3e, 0x0d, 0x0a
};
size_t control_server_message_ECDHE_ECDSA_WITH_AES_128_CCM_len = sizeof(control_server_message_ECDHE_ECDSA_WITH_AES_128_CCM);

unsigned char control_server_message_ECDHE_ECDSA_WITH_AES_128_CCM_8[] = {
    0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x30, 0x20, 0x32, 0x30, 0x30, 0x20, 0x4f, 0x4b, 0x0d,
    0x0a, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54, 0x79, 0x70, 0x65, 0x3a, 0x20, 0x74,
    0x65, 0x78, 0x74, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x68, 0x32, 0x3e,
    0x6d, 0x62, 0x65, 0x64, 0x20, 0x54, 0x4c, 0x53, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x53, 0x65,
    0x72, 0x76, 0x65, 0x72, 0x3c, 0x2f, 0x68, 0x32, 0x3e, 0x0d, 0x0a, 0x54, 0x45, 0x53, 0x54, 0x20,
    0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x0d, 0x0a, 0x3c, 0x70, 0x3e, 0x53, 0x75, 0x63, 0x63,
    0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x20, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
    0x6e, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x3a, 0x20, 0x54, 0x4c, 0x53, 0x2d, 0x45, 0x43, 0x44,
    0x48, 0x45, 0x2d, 0x45, 0x43, 0x44, 0x53, 0x41, 0x2d, 0x57, 0x49, 0x54, 0x48, 0x2d, 0x41, 0x45,
    0x53, 0x2d, 0x31, 0x32, 0x38, 0x2d, 0x43, 0x43, 0x4d, 0x2d, 0x38, 0x3c, 0x2f, 0x70, 0x3e, 0x0d,
    0x0a
};
size_t control_server_message_ECDHE_ECDSA_WITH_AES_128_CCM_8_len = sizeof(control_server_message_ECDHE_ECDSA_WITH_AES_128_CCM_8);

unsigned char control_server_message_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256[] = {
    0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x30, 0x20, 0x32, 0x30, 0x30, 0x20, 0x4f, 0x4b, 0x0d,
    0x0a, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54, 0x79, 0x70, 0x65, 0x3a, 0x20, 0x74,
    0x65, 0x78, 0x74, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x68, 0x32, 0x3e,
    0x6d, 0x62, 0x65, 0x64, 0x20, 0x54, 0x4c, 0x53, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x53, 0x65,
    0x72, 0x76, 0x65, 0x72, 0x3c, 0x2f, 0x68, 0x32, 0x3e, 0x0d, 0x0a, 0x54, 0x45, 0x53, 0x54, 0x20,
    0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x0d, 0x0a, 0x3c, 0x70, 0x3e, 0x53, 0x75, 0x63, 0x63,
    0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x20, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
    0x6e, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x3a, 0x20, 0x54, 0x4c, 0x53, 0x2d, 0x45, 0x43, 0x44,
    0x48, 0x45, 0x2d, 0x45, 0x43, 0x44, 0x53, 0x41, 0x2d, 0x57, 0x49, 0x54, 0x48, 0x2d, 0x41, 0x45,
    0x53, 0x2d, 0x31, 0x32, 0x38, 0x2d, 0x43, 0x42, 0x43, 0x2d, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36,
    0x3c, 0x2f, 0x70, 0x3e, 0x0d, 0x0a
};
size_t control_server_message_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256_len = sizeof(control_server_message_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256);

unsigned char control_server_message_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256[] = {
    0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x30, 0x20, 0x32, 0x30, 0x30, 0x20, 0x4f, 0x4b, 0x0d,
    0x0a, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54, 0x79, 0x70, 0x65, 0x3a, 0x20, 0x74,
    0x65, 0x78, 0x74, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x68, 0x32, 0x3e,
    0x6d, 0x62, 0x65, 0x64, 0x20, 0x54, 0x4c, 0x53, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x53, 0x65,
    0x72, 0x76, 0x65, 0x72, 0x3c, 0x2f, 0x68, 0x32, 0x3e, 0x0d, 0x0a, 0x54, 0x45, 0x53, 0x54, 0x20,
    0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x0d, 0x0a, 0x3c, 0x70, 0x3e, 0x53, 0x75, 0x63, 0x63,
    0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x20, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
    0x6e, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x3a, 0x20, 0x54, 0x4c, 0x53, 0x2d, 0x45, 0x43, 0x44,
    0x48, 0x45, 0x2d, 0x45, 0x43, 0x44, 0x53, 0x41, 0x2d, 0x57, 0x49, 0x54, 0x48, 0x2d, 0x41, 0x45,
    0x53, 0x2d, 0x31, 0x32, 0x38, 0x2d, 0x47, 0x43, 0x4D, 0x2d, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36,
    0x3c, 0x2f, 0x70, 0x3e, 0x0d, 0x0a
};
size_t control_server_message_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256_len = sizeof(control_server_message_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256);

unsigned char control_server_message_ECDHE_ECDSA_WITH_AES_128_CBC_SHA[] = {
    0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x30, 0x20, 0x32, 0x30, 0x30, 0x20, 0x4f, 0x4b, 0x0d,
    0x0a, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54, 0x79, 0x70, 0x65, 0x3a, 0x20, 0x74,
    0x65, 0x78, 0x74, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x68, 0x32, 0x3e,
    0x6d, 0x62, 0x65, 0x64, 0x20, 0x54, 0x4c, 0x53, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x53, 0x65,
    0x72, 0x76, 0x65, 0x72, 0x3c, 0x2f, 0x68, 0x32, 0x3e, 0x0d, 0x0a, 0x54, 0x45, 0x53, 0x54, 0x20,
    0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x0d, 0x0a, 0x3c, 0x70, 0x3e, 0x53, 0x75, 0x63, 0x63,
    0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x20, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
    0x6e, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x3a, 0x20, 0x54, 0x4c, 0x53, 0x2d, 0x45, 0x43, 0x44,
    0x48, 0x45, 0x2d, 0x45, 0x43, 0x44, 0x53, 0x41, 0x2d, 0x57, 0x49, 0x54, 0x48, 0x2d, 0x41, 0x45,
    0x53, 0x2d, 0x31, 0x32, 0x38, 0x2d, 0x43, 0x42, 0x43, 0x2d, 0x53, 0x48, 0x41, 0x3c, 0x2f, 0x70,
    0x3e, 0x0d, 0x0a
};
size_t control_server_message_ECDHE_ECDSA_WITH_AES_128_CBC_SHA_len = sizeof(control_server_message_ECDHE_ECDSA_WITH_AES_128_CBC_SHA);

unsigned char control_client_message[] = {
    0x47, 0x45, 0x54, 0x20, 0x2f, 0x20, 0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x30, 0x0d, 0x0a,
    0x0d, 0x0a
};
size_t control_client_message_len = sizeof(control_client_message);

unsigned char control_server_message_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384[] = {
    0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x30, 0x20, 0x32, 0x30, 0x30, 0x20, 0x4f, 0x4b, 0x0d,
    0x0a, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54, 0x79, 0x70, 0x65, 0x3a, 0x20, 0x74,
    0x65, 0x78, 0x74, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x68, 0x32, 0x3e,
    0x6d, 0x62, 0x65, 0x64, 0x20, 0x54, 0x4c, 0x53, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x53, 0x65,
    0x72, 0x76, 0x65, 0x72, 0x3c, 0x2f, 0x68, 0x32, 0x3e, 0x0d, 0x0a, 0x54, 0x45, 0x53, 0x54, 0x20,
    0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x0d, 0x0a, 0x3c, 0x70, 0x3e, 0x53, 0x75, 0x63, 0x63,
    0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x20, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
    0x6e, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x3a, 0x20, 0x54, 0x4c, 0x53, 0x2d, 0x45, 0x43, 0x44,
    0x48, 0x45, 0x2d, 0x45, 0x43, 0x44, 0x53, 0x41, 0x2d, 0x57, 0x49, 0x54, 0x48, 0x2d, 0x41, 0x45,
    0x53, 0x2d, 0x32, 0x35, 0x36, 0x2d, 0x43, 0x42, 0x43, 0x2d, 0x53, 0x48, 0x41, 0x33, 0x38, 0x34,
    0x3c, 0x2f, 0x70, 0x3e, 0x0d, 0x0a
};
size_t control_server_message_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384_len = sizeof(control_server_message_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384);

unsigned char control_server_message_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384[] = {
    0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x30, 0x20, 0x32, 0x30, 0x30, 0x20, 0x4f, 0x4b, 0x0d,
    0x0a, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54, 0x79, 0x70, 0x65, 0x3a, 0x20, 0x74,
    0x65, 0x78, 0x74, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x68, 0x32, 0x3e,
    0x6d, 0x62, 0x65, 0x64, 0x20, 0x54, 0x4c, 0x53, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x53, 0x65,
    0x72, 0x76, 0x65, 0x72, 0x3c, 0x2f, 0x68, 0x32, 0x3e, 0x0d, 0x0a, 0x54, 0x45, 0x53, 0x54, 0x20,
    0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x0d, 0x0a, 0x3c, 0x70, 0x3e, 0x53, 0x75, 0x63, 0x63,
    0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x20, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
    0x6e, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x3a, 0x20, 0x54, 0x4c, 0x53, 0x2d, 0x45, 0x43, 0x44,
    0x48, 0x45, 0x2d, 0x45, 0x43, 0x44, 0x53, 0x41, 0x2d, 0x57, 0x49, 0x54, 0x48, 0x2d, 0x41, 0x45,
    0x53, 0x2d, 0x32, 0x35, 0x36, 0x2d, 0x47, 0x43, 0x4D, 0x2d, 0x53, 0x48, 0x41, 0x33, 0x38, 0x34,
    0x3c, 0x2f, 0x70, 0x3e, 0x0d, 0x0a
};
size_t control_server_message_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384_len = sizeof(control_server_message_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384);

void printHexArray(unsigned char *m, size_t len, size_t cols)
{
    for(size_t i = 0; i < len; i++)
    {
        mbedtls_printf("0x%02x", m[i]);
        if (i != len - 1)
        {
            mbedtls_printf(", ");
        }
        if (i > 0 && (i + 1) % cols == 0)
        {
            mbedtls_printf("\n");
        }
    }
    mbedtls_printf("\n");
}

static volatile bool socket_error = false;

static void error(const char *msg)
{
    socket_error = true;
    perror(msg);
}

static CASocketFd_t sockfd, newsockfd;

static void socketClose()
{
    OC_CLOSE_SOCKET(sockfd);
}

static bool socketConnect()
{
    struct addrinfo* addressInfo = NULL;
    struct addrinfo hints;

    memset(&hints, 0, sizeof(struct addrinfo));
    hints.ai_family = AF_INET;

    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0)
    {
        error("ERROR opening socket");
        return false;
    }

    int result = getaddrinfo(SERVER_NAME, SERVER_PORT_STRING, &hints, &addressInfo);
    if (0 != result)
    {
        error("ERROR, no such host");
        socketClose();
        return false;
    }

    if (connect(sockfd, addressInfo->ai_addr, (int)addressInfo->ai_addrlen) < 0)
    {
        error("ERROR connecting");
        socketClose();
        freeaddrinfo(addressInfo);
        return false;
    }

    freeaddrinfo(addressInfo);
    return true;
}

static ssize_t CATCPPacketSendCB(CAEndpoint_t *, const void *buf, size_t buflen)
{
    int n = send(sockfd, (const char*)buf, (int)buflen, 0);
    if (n < 0)
    {
        error("ERROR writing to socket");
    }
    return n;
}

char msg[256] = {0}; size_t msglen = 0;
static void CATCPPacketReceivedCB(const CASecureEndpoint_t *, const void *data, size_t dataLength)
{
    memcpy(msg, data, dataLength);
    msglen = dataLength;
}

static void PacketReceive(unsigned char *data, int * datalen)
{
    int n;
    char buffer[2048] = {'\0'};
    n = recv(sockfd, buffer, 5, 0);
    if ((buffer[0] == 0x16 || buffer[0] == 0x14 || buffer[0] == 0x17 || buffer[0] == 0x15)
        && buffer[1] == 0x03 && buffer[2] == 0x03)
    {
        int tlslen = (unsigned char)buffer[3] * 0x100 + (unsigned char)buffer[4];
        n = recv(sockfd, buffer + 5, tlslen, 0);
    }

    if (n < 0)
    {
        error("ERROR reading from socket");
        *datalen = 0;
        return;
    }

    *datalen = n + 5;
    memcpy(data, buffer, *datalen);
}

static void infoCallback_that_loads_x509(PkiInfo_t * inf)
{
    inf->crt.data = (uint8_t*)serverCert;
    inf->crt.len = sizeof(serverCert);
    inf->key.data = (uint8_t*)serverPrivateKey;
    inf->key.len = sizeof(serverPrivateKey);
    inf->ca.data = (uint8_t*)caCert;
    inf->ca.len = sizeof(caCert);
    inf->crl.data = NULL;
    inf->crl.len = 0;
}

static bool socketOpen_server()
{
    unsigned short portno;
    struct sockaddr_in serv_addr, cli_addr;
    socklen_t clilen;

#ifdef HAVE_WINSOCK2_H
    WORD wVersionRequested = MAKEWORD(2, 2);
    WSADATA wsaData;
    int err = WSAStartup(wVersionRequested, &wsaData);
    if (err)
    {
        error("WSAStartup error");
        return false;
    }
#endif

    portno = SERVER_PORT;
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0)
    {
        error("\nERROR opening socket");
        return false;
    }
    //bzero((char *) &serv_addr, sizeof(serv_addr));
    memset((void*)&serv_addr, 0, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(portno);
    if (bind(sockfd, (struct sockaddr *) &serv_addr,
              sizeof(serv_addr)) < 0)
    {
        error("\nERROR on binding");
        socketClose();
        return false;
    }
    listen(sockfd,5);
    clilen = sizeof(cli_addr);
    newsockfd = accept(sockfd,
                 (struct sockaddr *) &cli_addr,
                 &clilen);
    if (newsockfd < 0)
    {
        error("\nERROR on accept");
        socketClose();
        return false;
    }
    return true;
}

static ssize_t CATCPPacketSendCB_server(CAEndpoint_t *, const void *buf, size_t buflen)
{
    int n;
    n = send(newsockfd, (const char*)buf, (int)buflen, 0);
    if (n < 0)
    {
        error("ERROR writing to socket");
    }
    return n;
}

static void CATCPPacketReceivedCB_server(const CASecureEndpoint_t *, const void *data, size_t dataLength)
{
    memcpy(msg, data, dataLength);
    msglen = dataLength;
}

static void PacketReceive_server(unsigned char *data, int * datalen)
{
    int n;
    char buffer[2048] = {'\0'};
    n = recv(newsockfd, buffer, 5, 0);

    if (buffer[0] == 0x16 || buffer[0] == 0x14 || buffer[0] == 0x17 || buffer[0] == 0x15)
    {
        int tlslen = (unsigned char)buffer[3] * 0x100 + (unsigned char)buffer[4];
        n = recv(newsockfd, buffer + 5, tlslen, 0);
    }

    if (n < 0)
    {
        error("\nERROR reading from socket");
        *datalen = n;
        return;
    }

    *datalen = n + 5;
    memcpy(data, buffer, *datalen);
}

static void socketClose_server()
{
    OC_CLOSE_SOCKET(newsockfd);
    OC_CLOSE_SOCKET(sockfd);
}

static void clutch(bool * list, const char *deviceId)
{
    OC_UNUSED(deviceId);

    list[1] = true;
}

const unsigned char IDENTITY[] = ("6767676767676767");
const unsigned char RS_CLIENT_PSK[] = ("AAAAAAAAAAAAAAAA");
static int32_t GetDtlsPskCredentials( CADtlsPskCredType_t,
              const unsigned char *, size_t,
              unsigned char *result, size_t)
{
    int32_t ret = -1;

    if (NULL == result)
    {
        return ret;
    }
    memcpy(result, IDENTITY, sizeof(IDENTITY));
    ret = sizeof(IDENTITY);

    return ret;
}

/* **************************
 *
 *
 * MbedTLS client routine
 *
 *
 * *************************/

#if !defined(MBEDTLS_CONFIG_FILE)
#include "mbedtls/config.h"
#else
#include MBEDTLS_CONFIG_FILE
#endif

#if defined(MBEDTLS_PLATFORM_C)
#include "mbedtls/platform.h"
#else
#include <stdio.h>
#include <stdlib.h>
#define mbedtls_fprintf    fprintf
#define mbedtls_printf     printf
#endif

#if !defined(MBEDTLS_BIGNUM_C) || !defined(MBEDTLS_ENTROPY_C) ||  \
    !defined(MBEDTLS_SSL_TLS_C) || !defined(MBEDTLS_SSL_CLI_C) || \
    !defined(MBEDTLS_NET_C) || !defined(MBEDTLS_RSA_C) ||         \
    !defined(MBEDTLS_PEM_PARSE_C) ||!defined(MBEDTLS_CTR_DRBG_C) || \
    !defined(MBEDTLS_X509_CRT_PARSE_C)
static int client( void )
{
    mbedtls_printf("MBEDTLS_BIGNUM_C and/or MBEDTLS_ENTROPY_C and/or "
           "MBEDTLS_SSL_TLS_C and/or MBEDTLS_SSL_CLI_C and/or "
           "MBEDTLS_NET_C and/or MBEDTLS_RSA_C and/or "
           "MBEDTLS_CTR_DRBG_C and/or MBEDTLS_X509_CRT_PARSE_C "
           "not defined.\n");
    return( 0 );
}
#else

#include "mbedtls/net_sockets.h"
#include "mbedtls/debug.h"
#include "mbedtls/ssl.h"
#include "mbedtls/entropy.h"
#include "mbedtls/ctr_drbg.h"
#include "mbedtls/error.h"


#include <string.h>

#define DEBUG_LEVEL (0)

static void my_debug_client( void *ctx, int level,
                      const char *file, int line,
                      const char *str )
{
    ((void) level);

    mbedtls_fprintf( (FILE *) ctx, "%s:%04d: %s", file, line, str );
    fflush(  (FILE *) ctx  );
}

static void * client(void *)
{
    int ret, len;
    mbedtls_net_context server_fd;
    uint32_t flags;
    unsigned char buf[1024];
    const char *pers = "ssl_client1";

    mbedtls_entropy_context entropy;
    mbedtls_ctr_drbg_context ctr_drbg;
    mbedtls_ssl_context ssl;
    mbedtls_ssl_config conf;
    mbedtls_x509_crt cacert;
    mbedtls_x509_crt owncert;
    mbedtls_pk_context pkey;

    /*
     * 0. Initialize the RNG and the session data
     */
    mbedtls_net_init( &server_fd );
    mbedtls_ssl_init( &ssl );
    mbedtls_ssl_config_init( &conf );
    mbedtls_x509_crt_init( &cacert );
    mbedtls_x509_crt_init( &owncert );
    mbedtls_ctr_drbg_init( &ctr_drbg );
    mbedtls_pk_init( &pkey );

    mbedtls_printf( "\n  . Seeding the random number generator..." );
    fflush( stdout );

    mbedtls_entropy_init( &entropy );
    if( ( ret = mbedtls_ctr_drbg_seed( &ctr_drbg, mbedtls_entropy_func, &entropy,
                               (const unsigned char *) pers,
                               strlen( pers ) ) ) != 0 )
    {
        mbedtls_printf( " failed\n  ! mbedtls_ctr_drbg_seed returned %d\n", ret );
        goto exit;
    }

    mbedtls_printf( " ok\n" );

    /*
     * 0. Initialize certificates
     */
    mbedtls_printf( "  . Loading the CA root certificate ..." );
    fflush( stdout );
    ret = mbedtls_x509_crt_parse( &cacert, (const unsigned char *) caCert, caCertLen );
    if( ret < 0 )
    {
        mbedtls_printf( " failed\n  !  mbedtls_x509_crt_parse caCert returned -0x%x\n\n", -ret );
        goto exit;
    }
    ret = mbedtls_x509_crt_parse( &owncert, (const unsigned char *) serverCert, serverCertLen );
    if( ret < 0 )
    {
        mbedtls_printf( " failed\n  !  mbedtls_x509_crt_parse serverCert returned -0x%x\n\n", -ret );
        goto exit;
    }
    ret =  mbedtls_pk_parse_key( &pkey, (const unsigned char *) serverPrivateKey,
                                                                serverPrivateKeyLen, NULL, 0 );
    if( ret < 0 )
    {
        mbedtls_printf( " failed\n  !  mbedtls_pk_parse_key returned -0x%x\n\n", -ret );
        goto exit;
    }

    mbedtls_printf( " ok (%d skipped)\n", ret );

    /*
     * 1. Start the connection
     */
    mbedtls_printf( "  . Connecting to tcp/%s/%s...", SERVER_NAME, "SERVER_PORT" );
    fflush( stdout );

    if( ( ret = mbedtls_net_connect( &server_fd, "127.0.0.1",
                                         "4433", MBEDTLS_NET_PROTO_TCP ) ) != 0 )
    {
        mbedtls_printf( " failed\n  ! mbedtls_net_connect returned %d\n\n", ret );
        goto exit;
    }

    mbedtls_printf( " ok\n" );

    /*
     * 2. Setup stuff
     */
    mbedtls_printf( "  . Setting up the SSL/TLS structure..." );
    fflush( stdout );

    if( ( ret = mbedtls_ssl_config_defaults( &conf,
                    MBEDTLS_SSL_IS_CLIENT,
                    MBEDTLS_SSL_TRANSPORT_STREAM,
                    MBEDTLS_SSL_PRESET_DEFAULT ) ) != 0 )
    {
        mbedtls_printf( " failed\n  ! mbedtls_ssl_config_defaults returned %d\n\n", ret );
        goto exit;
    }

    mbedtls_printf( " ok\n" );

    /* OPTIONAL is not optimal for security,
     * but makes interop easier in this simplified example */
    mbedtls_ssl_conf_authmode( &conf, MBEDTLS_SSL_VERIFY_OPTIONAL );
    mbedtls_ssl_conf_ca_chain( &conf, &cacert, NULL );
    mbedtls_ssl_conf_own_cert( &conf, &owncert, &pkey );
    mbedtls_ssl_conf_rng( &conf, mbedtls_ctr_drbg_random, &ctr_drbg );
    mbedtls_ssl_conf_dbg( &conf, my_debug_client, stdout );

    if( ( ret = mbedtls_ssl_setup( &ssl, &conf ) ) != 0 )
    {
        mbedtls_printf( " failed\n  ! mbedtls_ssl_setup returned %d\n\n", ret );
        goto exit;
    }

    if( ( ret = mbedtls_ssl_set_hostname( &ssl, "mbed TLS Server 1" ) ) != 0 )
    {
        mbedtls_printf( " failed\n  ! mbedtls_ssl_set_hostname returned %d\n\n", ret );
        goto exit;
    }

    mbedtls_ssl_set_bio( &ssl, &server_fd, mbedtls_net_send, mbedtls_net_recv, NULL );

    /*
     * 4. Handshake
     */
    mbedtls_printf( "  . Performing the SSL/TLS handshake..." );
    fflush( stdout );

    while( ( ret = mbedtls_ssl_handshake( &ssl ) ) != 0 )
    {
        if( ret != MBEDTLS_ERR_SSL_WANT_READ && ret != MBEDTLS_ERR_SSL_WANT_WRITE )
        {
            mbedtls_printf( " failed\n  ! mbedtls_ssl_handshake returned -0x%x\n\n", -ret );
            goto exit;
        }
    }

    mbedtls_printf( " ok\n" );

    /*
     * 5. Verify the server certificate
     */
    mbedtls_printf( "  . Verifying peer X.509 certificate..." );

    /* In real life, we probably want to bail out when ret != 0 */
    if( ( flags = mbedtls_ssl_get_verify_result( &ssl ) ) != 0 )
    {
        char vrfy_buf[512];

        mbedtls_printf( " failed\n" );

        mbedtls_x509_crt_verify_info( vrfy_buf, sizeof( vrfy_buf ), "  ! ", flags );

        mbedtls_printf( "%s\n", vrfy_buf );
    }
    else
        mbedtls_printf( " ok\n" );

    /*
     * 3. Write the GET request
     */
    mbedtls_printf( "  > Write to server:" );
    fflush( stdout );

    len = sprintf( (char *) buf, GET_REQUEST );

    while( ( ret = mbedtls_ssl_write( &ssl, buf, len ) ) <= 0 )
    {
        if( ret != MBEDTLS_ERR_SSL_WANT_READ && ret != MBEDTLS_ERR_SSL_WANT_WRITE )
        {
            mbedtls_printf( " failed\n  ! mbedtls_ssl_write returned %d\n\n", ret );
            goto exit;
        }
    }

    len = ret;
    mbedtls_printf( " %d bytes written\n\n%s", len, (char *) buf );

    /*
     * 7. Read the HTTP response
     */
    mbedtls_printf( "  < Read from server:" );
    fflush( stdout );

    do
    {
        len = sizeof( buf ) - 1;
        memset( buf, 0, sizeof( buf ) );
        ret = mbedtls_ssl_read( &ssl, buf, len );

        if( ret == MBEDTLS_ERR_SSL_WANT_READ || ret == MBEDTLS_ERR_SSL_WANT_WRITE )
            continue;

        if( ret == MBEDTLS_ERR_SSL_PEER_CLOSE_NOTIFY )
            break;

        if( ret < 0 )
        {
            mbedtls_printf( "failed\n  ! mbedtls_ssl_read returned %d\n\n", ret );
            break;
        }

        if( ret == 0 )
        {
            mbedtls_printf( "\n\nEOF\n\n" );
            break;
        }

        len = ret;
        mbedtls_printf( " %d bytes read\n\n%s", len, (char *) buf );
    }
    while( 1 );

    mbedtls_ssl_close_notify( &ssl );

exit:

#ifdef MBEDTLS_ERROR_C
    if( ret != 0 )
    {
        char error_buf[100];
        mbedtls_strerror( ret, error_buf, 100 );
        mbedtls_printf("Last error was: %d - %s\n\n", ret, error_buf );
    }
#endif

    mbedtls_net_free( &server_fd );

    mbedtls_x509_crt_free( &cacert );
    mbedtls_ssl_free( &ssl );
    mbedtls_ssl_config_free( &conf );
    mbedtls_ctr_drbg_free( &ctr_drbg );
    mbedtls_entropy_free( &entropy );

    return NULL;
}
#endif /* MBEDTLS_BIGNUM_C && MBEDTLS_ENTROPY_C && MBEDTLS_SSL_TLS_C &&
          MBEDTLS_SSL_CLI_C && MBEDTLS_NET_C && MBEDTLS_RSA_C &&
          MBEDTLS_PEM_PARSE_C && MBEDTLS_CTR_DRBG_C &&
          MBEDTLS_X509_CRT_PARSE_C */

/* **************************
 *
 *
 * MbedTLS server routine
 *
 *
 * *************************/

#if !defined(MBEDTLS_CONFIG_FILE)
#include "mbedtls/config.h"
#else
#include MBEDTLS_CONFIG_FILE
#endif

#if defined(MBEDTLS_PLATFORM_C)
#include "mbedtls/platform.h"
#else
#include <stdio.h>
#include <stdlib.h>
#define mbedtls_fprintf    fprintf
#define mbedtls_printf     printf
#endif

#if !defined(MBEDTLS_BIGNUM_C) || !defined(MBEDTLS_PEM_PARSE_C)|| \
    !defined(MBEDTLS_ENTROPY_C) || !defined(MBEDTLS_SSL_TLS_C) || \
    !defined(MBEDTLS_SSL_SRV_C) || !defined(MBEDTLS_NET_C) ||     \
    !defined(MBEDTLS_RSA_C) || !defined(MBEDTLS_CTR_DRBG_C) ||    \
    !defined(MBEDTLS_X509_CRT_PARSE_C) || !defined(MBEDTLS_FS_IO) 

/* int */void * server( void )
{
    mbedtls_printf("MBEDTLS_BIGNUM_C and/or MBEDTLS_ENTROPY_C "
           "and/or MBEDTLS_SSL_TLS_C and/or MBEDTLS_SSL_SRV_C and/or "
           "MBEDTLS_NET_C and/or MBEDTLS_RSA_C and/or "
           "MBEDTLS_CTR_DRBG_C and/or MBEDTLS_X509_CRT_PARSE_C "
           "and/or MBEDTLS_PEM_PARSE_C not defined.\n");
    return(/* 0 */);
}
#else

#include <stdlib.h>
#include <string.h>

#include "mbedtls/entropy.h"
#include "mbedtls/ctr_drbg.h"
#include "mbedtls/x509.h"
#include "mbedtls/ssl.h"
#include "mbedtls/net_sockets.h"
#include "mbedtls/error.h"
#include "mbedtls/debug.h"

#if defined(MBEDTLS_SSL_CACHE_C)
#include "mbedtls/ssl_cache.h"
#endif

#define HTTP_RESPONSE \
    "HTTP/1.0 200 OK\r\nContent-Type: text/html\r\n\r\n" \
    "<h2>mbed TLS Test Server</h2>\r\n" \
    "TEST MESSAGE\r\n" \
    "<p>Successful connection using: %s</p>\r\n"

#define DEBUG_LEVEL (0)

static int mbedtls_entropy_func_clutch(void *, unsigned char *output, size_t len)
{
    for (uint32_t i = 0; i < len; i++) output[i] = 0x11;
    return 0;
}

static void my_debug( void *ctx, int level,
                      const char *file, int line,
                      const char *str )
{
    ((void) level);

    mbedtls_fprintf((FILE *) ctx, "%s:%04d: %s", file, line, str);
    fflush(  (FILE *) ctx  );
}

static void * server(void *)
{
    int ret, len;
    mbedtls_net_context listen_fd, client_fd;
    unsigned char buf[1024];
    const char *pers = "ssl_server";

    mbedtls_entropy_context entropy;
    mbedtls_ctr_drbg_context ctr_drbg;
    mbedtls_ssl_context ssl;
    mbedtls_ssl_config conf;
    mbedtls_x509_crt srvcert;
    mbedtls_pk_context pkey;
#if defined(MBEDTLS_SSL_CACHE_C)
    mbedtls_ssl_cache_context cache;
#endif

    mbedtls_net_init( &listen_fd );
    mbedtls_net_init( &client_fd );
    mbedtls_ssl_init( &ssl );
    mbedtls_ssl_config_init( &conf );
#if defined(MBEDTLS_SSL_CACHE_C)
    mbedtls_ssl_cache_init( &cache );
#endif
    mbedtls_x509_crt_init( &srvcert );
    mbedtls_pk_init( &pkey );
    mbedtls_entropy_init( &entropy );
    mbedtls_ctr_drbg_init( &ctr_drbg );

#if defined(MBEDTLS_DEBUG_C)
    mbedtls_debug_set_threshold( DEBUG_LEVEL );
#endif

    /*
     * 1. Load the certificates and private RSA key
     */
    mbedtls_printf( "\n  . Loading the server cert. and key..." );
    fflush( stdout );

    /*
     * This demonstration program uses embedded test certificates.
     * Instead, you may want to use mbedtls_x509_crt_parse_file() to read the
     * server and CA certificates, as well as mbedtls_pk_parse_keyfile().
     */
    ret = mbedtls_x509_crt_parse( &srvcert, (const unsigned char *) serverCert, serverCertLen );
    if( ret != 0 )
    {
        mbedtls_printf( " failed\n  !  mbedtls_x509_crt_parse returned %d\n\n", ret );
        goto exit;
    }

    ret = mbedtls_x509_crt_parse( &srvcert, (const unsigned char *) caCert, caCertLen );
    if( ret != 0 )
    {
        mbedtls_printf( " failed\n  !  mbedtls_x509_crt_parse returned %d\n\n", ret );
        goto exit;
    }

    ret =  mbedtls_pk_parse_key( &pkey, (const unsigned char *) serverPrivateKey,
                                                                serverPrivateKeyLen, NULL, 0 );
    if( ret != 0 )
    {
        mbedtls_printf( " failed\n  !  mbedtls_pk_parse_key returned %d\n\n", ret );
        goto exit;
    }

    mbedtls_printf( " ok\n" );

    /*
     * 2. Setup the listening TCP socket
     */
    mbedtls_printf( "  . Bind on https://localhost:4433/ ..." );
    fflush( stdout );

    if( ( ret = mbedtls_net_bind( &listen_fd, NULL, "4433", MBEDTLS_NET_PROTO_TCP ) ) != 0 )
    {
        mbedtls_printf( " failed\n  ! mbedtls_net_bind returned %d\n\n", ret );
        goto exit;
    }

    mbedtls_printf( " ok\n" );

    /*
     * 3. Seed the RNG
     */
    mbedtls_printf( "  . Seeding the random number generator..." );
    fflush( stdout );

    if( ( ret = mbedtls_ctr_drbg_seed( &ctr_drbg, mbedtls_entropy_func_clutch, &entropy,
                               (const unsigned char *) pers,
                               strlen( pers ) ) ) != 0 )
    {
        mbedtls_printf( " failed\n  ! mbedtls_ctr_drbg_seed returned %d\n", ret );
    }

    mbedtls_printf( " ok\n" );

    /*
     * 4. Setup stuff
     */
    mbedtls_printf( "  . Setting up the SSL data...." );
    fflush( stdout );

    if( ( ret = mbedtls_ssl_config_defaults( &conf,
                    MBEDTLS_SSL_IS_SERVER,
                    MBEDTLS_SSL_TRANSPORT_STREAM,
                    MBEDTLS_SSL_PRESET_DEFAULT ) ) != 0 )
    {
        mbedtls_printf( " failed\n  ! mbedtls_ssl_config_defaults returned %d\n\n", ret );
        goto exit;
    }

    mbedtls_ssl_conf_rng( &conf, mbedtls_ctr_drbg_random, &ctr_drbg );
    mbedtls_ssl_conf_dbg( &conf, my_debug, stdout );

#if defined(MBEDTLS_SSL_CACHE_C)
    mbedtls_ssl_conf_session_cache( &conf, &cache,
                                   mbedtls_ssl_cache_get,
                                   mbedtls_ssl_cache_set );
#endif

    mbedtls_ssl_conf_ca_chain( &conf, srvcert.next, NULL );
    if( ( ret = mbedtls_ssl_conf_own_cert( &conf, &srvcert, &pkey ) ) != 0 )
    {
        mbedtls_printf( " failed\n  ! mbedtls_ssl_conf_own_cert returned %d\n\n", ret );
        goto exit;
    }

    if( ( ret = mbedtls_ssl_setup( &ssl, &conf ) ) != 0 )
    {
        mbedtls_printf( " failed\n  ! mbedtls_ssl_setup returned %d\n\n", ret );
        goto exit;
    }

    mbedtls_printf( " ok\n" );

reset:
#ifdef MBEDTLS_ERROR_C
    if( ret != 0 )
    {
        char error_buf[100];
        mbedtls_strerror( ret, error_buf, 100 );
        mbedtls_printf("Last error was: %d - %s\n\n", ret, error_buf );
    }
#endif

    mbedtls_net_free( &client_fd );

    mbedtls_ssl_session_reset( &ssl );

    /*
     * 3. Wait until a client connects
     */
    mbedtls_printf( "  . Waiting for a remote connection ..." );
    fflush( stdout );

    if( ( ret = mbedtls_net_accept( &listen_fd, &client_fd,
                                    NULL, 0, NULL ) ) != 0 )
    {
        mbedtls_printf( " failed\n  ! mbedtls_net_accept returned %d\n\n", ret );
        goto exit;
    }

    mbedtls_ssl_set_bio( &ssl, &client_fd, mbedtls_net_send, mbedtls_net_recv, NULL );

    mbedtls_printf( " ok\n" );

    /*
     * 5. Handshake
     */
    mbedtls_printf( "  . Performing the SSL/TLS handshake..." );
    fflush( stdout );

    while( ( ret = mbedtls_ssl_handshake( &ssl ) ) != 0 )
    {
        if( ret != MBEDTLS_ERR_SSL_WANT_READ && ret != MBEDTLS_ERR_SSL_WANT_WRITE )
        {
            mbedtls_printf( " failed\n  ! mbedtls_ssl_handshake returned %d\n\n", ret );
            goto exit;
        }
    }

    mbedtls_printf( " ok\n" );

    /*
     * 6. Read the HTTP Request
     */
    mbedtls_printf( "  < Read from client:" );
    fflush( stdout );

    do
    {
        len = sizeof( buf ) - 1;
        memset( buf, 0, sizeof( buf ) );
        ret = mbedtls_ssl_read( &ssl, buf, len );

        if( ret == MBEDTLS_ERR_SSL_WANT_READ || ret == MBEDTLS_ERR_SSL_WANT_WRITE )
            continue;

        if( ret <= 0 )
        {
            switch( ret )
            {
                case MBEDTLS_ERR_SSL_PEER_CLOSE_NOTIFY:
                    mbedtls_printf( " connection was closed gracefully\n" );
                    break;

                case MBEDTLS_ERR_NET_CONN_RESET:
                    mbedtls_printf( " connection was reset by peer\n" );
                    break;

                default:
                    mbedtls_printf( " mbedtls_ssl_read returned -0x%x\n", -ret );
                    break;
            }

            break;
        }

        len = ret;
        mbedtls_printf( " %d bytes read\n\n%s", len, (char *) buf );

        if( ret > 0 )
            break;
    }
    while( 1 );

    /*
     * 7. Write the 200 Response
     */
    mbedtls_printf( "  > Write to client:" );

    fflush( stdout );

    len = sprintf( (char *) buf, HTTP_RESPONSE,
                   mbedtls_ssl_get_ciphersuite( &ssl ) );

    while( ( ret = mbedtls_ssl_write( &ssl, buf, len ) ) <= 0 )
    {
        if( ret == MBEDTLS_ERR_NET_CONN_RESET )
        {
            mbedtls_printf( " failed\n  ! peer closed the connection\n\n" );
            goto reset;
        }

        if( ret != MBEDTLS_ERR_SSL_WANT_READ && ret != MBEDTLS_ERR_SSL_WANT_WRITE )
        {
            mbedtls_printf( " failed\n  ! mbedtls_ssl_write returned %d\n\n", ret );
            goto exit;
        }
    }

    len = ret;
    mbedtls_printf( " %d bytes written\n\n%s\n", len, (char *) buf );

    mbedtls_printf( "  . Closing the connection..." );

    while( ( ret = mbedtls_ssl_close_notify( &ssl ) ) < 0 )
    {
        if( ret != MBEDTLS_ERR_SSL_WANT_READ &&
            ret != MBEDTLS_ERR_SSL_WANT_WRITE )
        {
            mbedtls_printf( " failed\n  ! mbedtls_ssl_close_notify returned %d\n\n", ret );
            goto exit;
        }
    }

    mbedtls_printf( " ok\n" );

    ret = 0;
    goto exit;

exit:

#ifdef MBEDTLS_ERROR_C
    if( ret != 0 )
    {
        char error_buf[100];
        mbedtls_strerror( ret, error_buf, 100 );
        mbedtls_printf("Last error was: %d - %s\n\n", ret, error_buf );
    }
#endif

    mbedtls_net_free( &client_fd );
    mbedtls_net_free( &listen_fd );

    mbedtls_x509_crt_free( &srvcert );
    mbedtls_pk_free( &pkey );
    mbedtls_ssl_free( &ssl );
    mbedtls_ssl_config_free( &conf );
#if defined(MBEDTLS_SSL_CACHE_C)
    mbedtls_ssl_cache_free( &cache );
#endif
    mbedtls_ctr_drbg_free( &ctr_drbg );
    mbedtls_entropy_free( &entropy );

#if defined(_WIN32)
    mbedtls_printf( "  Press Enter to exit this program.\n" );
    fflush( stdout );
#endif

    return NULL;
}
#endif /* MBEDTLS_BIGNUM_C && MBEDTLS_ENTROPY_C &&
          MBEDTLS_SSL_TLS_C && MBEDTLS_SSL_SRV_C && MBEDTLS_NET_C &&
          MBEDTLS_RSA_C && MBEDTLS_CTR_DRBG_C && MBEDTLS_X509_CRT_PARSE_C
          && MBEDTLS_FS_IO && MBEDTLS_PEM_PARSE_C */

/* **************************
 *
 *
 * CAinitSslAdapter test
 *
 *
 * *************************/

static int testCAinitSslAdapter()
{
    int ret = 0;
    CAResult_t result = CA_STATUS_FAILED;

    result = CAinitSslAdapter();
    if (result == CA_STATUS_OK)
    {
        CAdeinitSslAdapter();
    }
    else
    {
        ret = 1;
    }

    return ret;
}

// CAinitTlsAdapter()
TEST(TLSAdapter, Test_1)
{
    int ret = 0xFF;
    ret = testCAinitSslAdapter();
    EXPECT_EQ(0, ret);
}

/* **************************
 *
 *
 * CAsetSslAdapterCallbacks test
 *
 *
 * *************************/

static int testCAsetSslAdapterCallbacks()
{
    int ret = 0xFF;
    CAResult_t result = CA_STATUS_FAILED;

    result = CAinitSslAdapter();
    if (result != CA_STATUS_OK)
    {
        return 1;
    }

    CAsetSslAdapterCallbacks(CATCPPacketReceivedCB, CATCPPacketSendCB, (CATransportAdapter_t)0);
    if (g_caSslContext->adapterCallbacks[0].recvCallback == NULL &&
        g_caSslContext->adapterCallbacks[0].sendCallback == NULL &&
        g_caSslContext->adapterCallbacks[1].recvCallback == NULL &&
        g_caSslContext->adapterCallbacks[1].sendCallback == NULL)
    {
        ret = 0;
    }
    else
    {
        ret = 1;
    }
    CAsetSslAdapterCallbacks(CATCPPacketReceivedCB, CATCPPacketSendCB, CA_ADAPTER_IP);
    CAsetSslAdapterCallbacks(CATCPPacketReceivedCB, CATCPPacketSendCB, CA_ADAPTER_TCP);
    if (g_caSslContext->adapterCallbacks[0].recvCallback == CATCPPacketReceivedCB &&
        g_caSslContext->adapterCallbacks[0].sendCallback == CATCPPacketSendCB &&
        g_caSslContext->adapterCallbacks[1].recvCallback == CATCPPacketReceivedCB &&
        g_caSslContext->adapterCallbacks[1].sendCallback == CATCPPacketSendCB)
    {
        ret += 0;
    }
    else
    {
        ret += 1;
    }

    CAdeinitSslAdapter();

    return ret;
}

// CAsetSslAdapterCallbacks()
TEST(TLSAdapter, Test_2)
{
    int ret = 0xFF;
    ret = testCAsetSslAdapterCallbacks();
    EXPECT_EQ(0, ret);
}

/* **************************
 *
 *
 * CAinitiateSslHandshake test
 *
 *
 * *************************/

unsigned char predictedClientHello[] = {
    0x16, 0x03, 0x03, 0x00, 0x71, 0x01, 0x00, 0x00, 0x6d, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x34,
    0x1c, 0x45, 0xfa, 0xbf, 0x39, 0xe5, 0xbf, 0x52, 0x20, 0x4f, 0x8f, 0xf5, 0x6b, 0x89, 0xb0, 0xbb,
    0x3a, 0x5e, 0x13, 0xb4, 0x94, 0x73, 0xee, 0xf4, 0x98, 0x48, 0x4a, 0x00, 0x00, 0x14, 0xc0, 0xac,
    0x00, 0x3d, 0x00, 0x9c, 0xc0, 0x2b, 0xc0, 0xae, 0xc0, 0x23, 0xc0, 0x24, 0xc0, 0x2c, 0xc0, 0x27,
    0x00, 0xff, 0x01, 0x00, 0x00, 0x30, 0x00, 0x0d, 0x00, 0x16, 0x00, 0x14, 0x06, 0x03, 0x06, 0x01,
    0x05, 0x03, 0x05, 0x01, 0x04, 0x03, 0x04, 0x01, 0x03, 0x03, 0x03, 0x01, 0x02, 0x03, 0x02, 0x01,
    0x00, 0x0a, 0x00, 0x04, 0x00, 0x02, 0x00, 0x17, 0x00, 0x0b, 0x00, 0x02, 0x01, 0x00, 0x00, 0x16,
    0x00, 0x00, 0x00, 0x17, 0x00, 0x00
};
static unsigned char controlBuf[sizeof(predictedClientHello)];
static size_t controlBufLen = 0;
static ssize_t CATCPPacketSendCB_forInitHsTest(CAEndpoint_t *, const void * buf, size_t buflen)
{
    int n;
    n = send(sockfd, (const char*)buf, (int)buflen, 0);
    if (n < 0)
    {
        error("ERROR writing to socket");
        return n;
    }

    memset(controlBuf, 0, sizeof(predictedClientHello));
    memcpy(controlBuf, buf, buflen);
    controlBufLen = buflen;
    return buflen;
}

static void * test0CAinitiateSslHandshake(void * arg)
{
    CAEndpoint_t serverAddr;
    memset(&serverAddr, 0, sizeof(serverAddr));
    serverAddr.adapter = CA_ADAPTER_TCP;
    serverAddr.flags = CA_SECURE;
    serverAddr.port = 4433;
    char addr[] = {0x31, 0x32, 0x37, 0x2e, 0x30, 0x2e, 0x30, 0x2e, 0x31, 0x00}; // 127.0.0.1
    memcpy(serverAddr.addr, addr, sizeof(addr));
    serverAddr.ifindex = 0;

    g_sslContextMutex = oc_mutex_new_recursive();
    oc_mutex_lock(g_sslContextMutex);
    g_caSslContext = (SslContext_t *)OICCalloc(1, sizeof(SslContext_t));
    g_caSslContext->peerList = u_arraylist_create();
    mbedtls_entropy_init(&g_caSslContext->entropy);
    mbedtls_ctr_drbg_init(&g_caSslContext->rnd);
    mbedtls_ctr_drbg_seed(&g_caSslContext->rnd, mbedtls_entropy_func_clutch,
                                  &g_caSslContext->entropy,
                                  (const unsigned char*) PERSONALIZATION_STRING, sizeof(PERSONALIZATION_STRING));
    mbedtls_ctr_drbg_set_prediction_resistance(&g_caSslContext->rnd, MBEDTLS_CTR_DRBG_PR_OFF);
    InitConfig(&g_caSslContext->clientTlsConf,
                        MBEDTLS_SSL_TRANSPORT_STREAM, MBEDTLS_SSL_IS_CLIENT);
    InitConfig(&g_caSslContext->serverTlsConf,
                        MBEDTLS_SSL_TRANSPORT_STREAM, MBEDTLS_SSL_IS_SERVER);
    mbedtls_ssl_cookie_init(&g_caSslContext->cookieCtx);
    mbedtls_ssl_cookie_setup(&g_caSslContext->cookieCtx, mbedtls_ctr_drbg_random,
                                      &g_caSslContext->rnd);
    InitConfig(&g_caSslContext->clientDtlsConf,
                        MBEDTLS_SSL_TRANSPORT_DATAGRAM, MBEDTLS_SSL_IS_CLIENT);
    InitConfig(&g_caSslContext->serverDtlsConf,
                        MBEDTLS_SSL_TRANSPORT_DATAGRAM, MBEDTLS_SSL_IS_SERVER);
    g_caSslContext->cipher = SSL_CIPHER_MAX;
    mbedtls_x509_crt_init(&g_caSslContext->ca);
    mbedtls_x509_crt_init(&g_caSslContext->crt);
    mbedtls_pk_init(&g_caSslContext->pkey);
    mbedtls_x509_crl_init(&g_caSslContext->crl);
    oc_mutex_unlock(g_sslContextMutex);

    // CAsetSslAdapterCallbacks
    g_caSslContext->adapterCallbacks[1].recvCallback = CATCPPacketReceivedCB;
    g_caSslContext->adapterCallbacks[1].sendCallback = CATCPPacketSendCB_forInitHsTest;

    // CAsetPkixInfoCallback
    g_getPkixInfoCallback = infoCallback_that_loads_x509;

    // CAsetCredentialTypesCallback
    g_getCredentialTypesCallback = clutch;

    // CAsetTlsCipherSuite
    mbedtls_ssl_conf_ciphersuites(&g_caSslContext->clientTlsConf,
                                         tlsCipher[SSL_ECDHE_ECDSA_WITH_AES_128_CCM]);
    mbedtls_ssl_conf_ciphersuites(&g_caSslContext->serverTlsConf,
                                         tlsCipher[SSL_ECDHE_ECDSA_WITH_AES_128_CCM]);
    g_caSslContext->cipher = SSL_ECDHE_ECDSA_WITH_AES_128_CCM;

    CAsetPskCredentialsCallback(GetDtlsPskCredentials);

    if (!socketConnect())
    {
        *((int*)arg) = 0xFF;
        return (void *) 0xFF;
    }

    unsigned int unixTime = (unsigned)time(NULL);
    CAinitiateSslHandshake(&serverAddr);
    predictedClientHello[11] = unixTime >> 24;
    predictedClientHello[12] = (unixTime << 8) >> 24;
    predictedClientHello[13] = (unixTime << 16) >> 24;
    predictedClientHello[14] = (unixTime << 24) >> 24;

    // CAcloseTlsConnection
    oc_mutex_lock(g_sslContextMutex);
    SslEndPoint_t * tep = GetSslPeer(&serverAddr);
    mbedtls_ssl_close_notify(&tep->ssl);
    RemovePeerFromList(&tep->sep.endpoint);
    oc_mutex_unlock(g_sslContextMutex);

    // CAdeinitTlsAdapter
    oc_mutex_lock(g_sslContextMutex);
    DeletePeerList();
    mbedtls_x509_crt_free(&g_caSslContext->crt);
    mbedtls_pk_free(&g_caSslContext->pkey);
    mbedtls_ssl_config_free(&g_caSslContext->clientTlsConf);
    mbedtls_ssl_config_free(&g_caSslContext->serverTlsConf);
    mbedtls_ctr_drbg_free(&g_caSslContext->rnd);
    mbedtls_entropy_free(&g_caSslContext->entropy);
    OICFree(g_caSslContext);
    g_caSslContext = NULL;
    oc_mutex_unlock(g_sslContextMutex);
    oc_mutex_free(g_sslContextMutex);
    g_sslContextMutex = NULL;

    socketClose();

    if (controlBufLen == sizeof(predictedClientHello) &&
        memcmp(predictedClientHello, controlBuf, sizeof(predictedClientHello)) == 0)
    {
        *((int*)arg) = 0;
        return NULL;
    }
    else
    {
        *((int*)arg) = 0xFF;
        return (void *) 0xFF;
    }
}

static int test1CAinitiateSslHandshake()
{
    int ret = 0xff;
    ret = CAinitiateSslHandshake(NULL);
    if (CA_STATUS_INVALID_PARAM == ret)
    {
        ret = 0;
    }
    else
    {
        ret = 1;
    }
    return ret;
}

// CAinitiateSslHandshake()
// This test has a bug in it (IOT-1848):
//  server() listens only on IPv6 on Windows (because IPV6_V6ONLY defaults
//  to true) and socketConnect() is hard coded to try only IPv4.
#ifdef HAVE_WINSOCK2_H
TEST(TLSAdapter, DISABLED_Test_3_0)
#else
TEST(TLSAdapter, Test_3_0)
#endif
{
    socket_error = false;
    pthread_t thread1, thread2;
    int ret = 0;
    int arg = 1;

    ret = pthread_create( &thread1, NULL, server, (void*) NULL);
    if(ret)
    {
        fprintf(stderr, "Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ret = pthread_create( &thread2, NULL, test0CAinitiateSslHandshake, &arg);
    if(ret)
    {
        fprintf(stderr, "Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ASSERT_FALSE(socket_error);
    EXPECT_EQ(0, arg);
}

TEST(TLSAdapter, Test_3_1)
{
    int ret = 0xFF;
    ret = test1CAinitiateSslHandshake();
    EXPECT_EQ(0, ret);
}

/* **************************
 *
 *
 * CAencryptSsl test
 *
 *
 * *************************/

static void * testCAencryptSsl(void * arg)
{
    int ret = 0;
    CAEndpoint_t serverAddr;
    memset(&serverAddr, 0, sizeof(serverAddr));
    serverAddr.adapter = CA_ADAPTER_TCP;
    serverAddr.flags = CA_SECURE;
    serverAddr.port = 4433;
    char addr[] = {0x31, 0x32, 0x37, 0x2e, 0x30, 0x2e, 0x30, 0x2e, 0x31, 0x00}; // 127.0.0.1
    memcpy(serverAddr.addr, addr, sizeof(addr));
    serverAddr.ifindex = 0;

    CAinitSslAdapter();

    CAsetSslAdapterCallbacks(CATCPPacketReceivedCB, CATCPPacketSendCB, CA_ADAPTER_TCP);

    CAsetPkixInfoCallback(infoCallback_that_loads_x509);

    // CAsetCredentialTypesCallback
    g_getCredentialTypesCallback = clutch;

    if (*((int*)arg) == 0)
    {
        CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_128_CCM);
    }
    else if (*((int*)arg) == 1)
    {
        CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8);
    }
    else if (*((int*)arg) == 2)
    {
        CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256);
    }
    else if (*((int*)arg) == 3)
    {
        CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256);
    }
    else if (*((int*)arg) == 4)
    {
        CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384);
    }
    else if (*((int*)arg) == 5)
    {
        CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384);
    }

    CAsetPskCredentialsCallback(GetDtlsPskCredentials);

    if (!socketConnect())
    {
        *((int*)arg) = 0xFF;
        return (void *) 0xFF;
    }

    // CAinitiateSslHandshake
    CAinitiateSslHandshake(&serverAddr);

    unsigned char buffer[2048] = {'\0'};
    int buflen = 0;
    CASecureEndpoint_t * sep = (CASecureEndpoint_t *) malloc (sizeof(CASecureEndpoint_t));
    sep->endpoint = serverAddr;

    for (int i = 0; i < 6; i++)
    {
        PacketReceive(buffer, &buflen);
        if (buflen < 1)
        {
            *((int*)arg) = 0xFF;
            return (void *) 0xFF;
        }
        CAdecryptSsl(sep, (uint8_t *)buffer, buflen);
    }

    ret = sprintf( (char*)buffer, GET_REQUEST );

    CAencryptSsl(&serverAddr, buffer, ret);

    PacketReceive(buffer, &buflen);
    if (buflen < 1)
    {
        *((int*)arg) = 0xFF;
        return (void *) 0xFF;
    }
    CAdecryptSsl(sep, (uint8_t *)buffer, buflen);

    CAcloseSslConnection(&serverAddr);

    CAdeinitSslAdapter();

    socketClose();

    if (*((int*)arg) == 0)
    {
        if (control_server_message_ECDHE_ECDSA_WITH_AES_128_CCM_len == msglen &&
            memcmp(msg, control_server_message_ECDHE_ECDSA_WITH_AES_128_CCM,
            control_server_message_ECDHE_ECDSA_WITH_AES_128_CCM_len) == 0)
        {
            ret = 0;
        }
        else
        {
            ret = 1;
        }
    }
    if (*((int*)arg) == 1)
    {
        if (control_server_message_ECDHE_ECDSA_WITH_AES_128_CCM_8_len == msglen &&
            memcmp(msg, control_server_message_ECDHE_ECDSA_WITH_AES_128_CCM_8,
            control_server_message_ECDHE_ECDSA_WITH_AES_128_CCM_8_len) == 0)
        {
            ret = 0;
        }
        else
        {
            ret = 1;
        }
    }
    else if (*((int*)arg) == 2)
    {
        if (control_server_message_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256_len == msglen &&
            memcmp(msg, control_server_message_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,
            control_server_message_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256_len) == 0)
        {
            ret = 0;
        }
        else
        {
            ret = 1;
        }
    }
    else if (*((int*)arg) == 3)
    {
        if (control_server_message_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256_len == msglen &&
            memcmp(msg, control_server_message_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,
            control_server_message_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256_len) == 0)
        {
            ret = 0;
        }
        else
        {
            ret = 1;
        }
    }
    else if (*((int*)arg) == 4)
    {
        if (control_server_message_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384_len == msglen &&
            memcmp(msg, control_server_message_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,
                   control_server_message_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384_len) == 0)
        {
            ret = 0;
        }
        else
        {
            ret = 1;
        }
    }
    else if (*((int*)arg) == 5)
    {
        if (control_server_message_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384_len == msglen &&
            memcmp(msg, control_server_message_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,
                   control_server_message_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384_len) == 0)
        {
            ret = 0;
        }
        else
        {
            ret = 1;
        }
    }

    if (ret == 0)
    {
        *((int*)arg) = 0;
        return NULL;
    }
    else
    {
        *((int*)arg) = 0xFF;
        return (void *) 0xFF;
    }
}

// CAencryptSsl()
// This test has a bug in it (IOT-1848):
//  server() listens only on IPv6 on Windows (because IPV6_V6ONLY defaults
//  to true) and socketConnect() is hard coded to try only IPv4.
#ifdef HAVE_WINSOCK2_H
TEST(TLSAdapter, DISABLED_Test_4_0)
#else
TEST(TLSAdapter, Test_4_0)
#endif
{
    socket_error = false;
    pthread_t thread1, thread2;
    int ret = 0;
    int arg = 0;

    ret = pthread_create( &thread1, NULL, server, (void*) NULL);
    if(ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ret = pthread_create( &thread2, NULL, testCAencryptSsl, &arg);
    if(ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ASSERT_FALSE(socket_error);
    EXPECT_EQ(0, arg);
}

// CAencryptSsl()
// This test has a bug in it (IOT-1848):
//  server() listens only on IPv6 on Windows (because IPV6_V6ONLY defaults
//  to true) and socketConnect() is hard coded to try only IPv4.
#ifdef HAVE_WINSOCK2_H
TEST(TLSAdapter, DISABLED_Test_4_1)
#else
TEST(TLSAdapter, Test_4_1)
#endif
{
    socket_error = false;
    pthread_t thread1, thread2;
    int ret = 0;
    int arg = 1;

    ret = pthread_create( &thread1, NULL, server, (void*) NULL);
    if(ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ret = pthread_create( &thread2, NULL, testCAencryptSsl, &arg);
    if(ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ASSERT_FALSE(socket_error);
    EXPECT_EQ(0, arg);
}

// CAencryptSsl()
// This test has a bug in it (IOT-1848):
//  server() listens only on IPv6 on Windows (because IPV6_V6ONLY defaults
//  to true) and socketConnect() is hard coded to try only IPv4.
#ifdef HAVE_WINSOCK2_H
TEST(TLSAdapter, DISABLED_Test_4_2)
#else
TEST(TLSAdapter, Test_4_2)
#endif
{
    socket_error = false;
    pthread_t thread1, thread2;
    int ret = 0;
    int arg = 2;

    ret = pthread_create( &thread1, NULL, server, (void*) NULL);
    if(ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ret = pthread_create( &thread2, NULL, testCAencryptSsl, &arg);
    if(ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ASSERT_FALSE(socket_error);
    EXPECT_EQ(0, arg);
}

// CAencryptSsl()
// This test has a bug in it (IOT-1848):
//  server() listens only on IPv6 on Windows (because IPV6_V6ONLY defaults
//  to true) and socketConnect() is hard coded to try only IPv4.
#ifdef HAVE_WINSOCK2_H
TEST(TLSAdapter, DISABLED_Test_4_3)
#else
TEST(TLSAdapter, Test_4_3)
#endif
{
    socket_error = false;
    pthread_t thread1, thread2;
    int ret = 0;
    int arg = 3;

    ret = pthread_create( &thread1, NULL, server, (void*) NULL);
    if(ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ret = pthread_create( &thread2, NULL, testCAencryptSsl, &arg);
    if(ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ASSERT_FALSE(socket_error);
    EXPECT_EQ(0, arg);
}

// CAencryptSsl()
// This test has a bug in it (IOT-1848):
//  server() listens only on IPv6 on Windows (because IPV6_V6ONLY defaults
//  to true) and socketConnect() is hard coded to try only IPv4.
#ifdef HAVE_WINSOCK2_H
TEST(TLSAdapter, DISABLED_Test_4_4)
#else
TEST(TLSAdapter, Test_4_4)
#endif
{
    socket_error = false;
    pthread_t thread1, thread2;
    int ret = 0;
    int arg = 4;

    ret = pthread_create( &thread1, NULL, server, (void*) NULL);
    if(ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ret = pthread_create( &thread2, NULL, testCAencryptSsl, &arg);
    if(ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ASSERT_FALSE(socket_error);
    EXPECT_EQ(0, arg);
}

// This test has a bug in it (IOT-1848):
//  server() listens only on IPv6 on Windows (because IPV6_V6ONLY defaults
//  to true) and socketConnect() is hard coded to try only IPv4.
#ifdef HAVE_WINSOCK2_H
TEST(TLSAdapter, DISABLED_Test_4_5)
#else
TEST(TLSAdapter, Test_4_5)
#endif
{
    socket_error = false;
    pthread_t thread1, thread2;
    int ret = 0;
    int arg = 5;

    ret = pthread_create( &thread1, NULL, server, (void*) NULL);
    if(ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ret = pthread_create( &thread2, NULL, testCAencryptSsl, &arg);
    if(ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ASSERT_FALSE(socket_error);
    EXPECT_EQ(0, arg);
}

/* **************************
 *
 *
 * CAdecryptSsl test
 *
 *
 * *************************/

static void * testCAdecryptSsl(void * arg)
{
    int ret = 0;
    unsigned char buffer[2048] = {'\0'};
    int buflen = 0;

    CAEndpoint_t serverAddr;
    memset(&serverAddr, 0, sizeof(serverAddr));
    serverAddr.adapter = CA_ADAPTER_TCP;
    serverAddr.flags = CA_SECURE;
    serverAddr.port = 4433;
    char addr[] = {0x31, 0x32, 0x37, 0x2e, 0x30, 0x2e, 0x30, 0x2e, 0x31, 0x00}; // 127.0.0.1
    memcpy(serverAddr.addr, addr, sizeof(addr));
    serverAddr.ifindex = 0;

    CAinitSslAdapter();

    CAsetSslAdapterCallbacks(CATCPPacketReceivedCB, CATCPPacketSendCB, CA_ADAPTER_TCP);

    CAsetPkixInfoCallback(infoCallback_that_loads_x509);

    CAsetCredentialTypesCallback(clutch);

    CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_128_CCM);

    CAsetPskCredentialsCallback(GetDtlsPskCredentials);

    if (!socketConnect())
    {
        *((int*)arg) = 0xFF;
        return (void *) 0xFF;
    }

    // CAinitiateSslHandshake
    CAinitiateSslHandshake(&serverAddr);

    CASecureEndpoint_t * sep = (CASecureEndpoint_t *) malloc (sizeof(CASecureEndpoint_t));
    sep->endpoint = serverAddr;

    for (int i = 0; i < 6; i++)
    {
        PacketReceive(buffer, &buflen);
        if (buflen < 1)
        {
            *((int*)arg) = 0xFF;
            return (void *) 0xFF;
        }
        CAdecryptSsl(sep, (uint8_t *)buffer, buflen);
    }

    ret = sprintf((char*)buffer, GET_REQUEST);

    CAencryptSsl(&serverAddr, buffer, ret);

    PacketReceive(buffer, &buflen);
    if (buflen < 1)
    {
        *((int*)arg) = 0xFF;
        return (void *) 0xFF;
    }
    CAdecryptSsl(sep, (uint8_t *)buffer, buflen);

    CAcloseSslConnection(&serverAddr);

    CAdeinitSslAdapter();

    socketClose();

    if (control_server_message_ECDHE_ECDSA_WITH_AES_128_CCM_len == msglen &&
            memcmp(msg, control_server_message_ECDHE_ECDSA_WITH_AES_128_CCM,
            control_server_message_ECDHE_ECDSA_WITH_AES_128_CCM_len) == 0)
    {
        *((int*)arg) = 0;
        return NULL;
    }
    else
    {
        *((int*)arg) = 0xFF;
        return (void *) 0xFF;
    }
}

// CAdecryptTls()
// This test has a bug in it (IOT-1848):
//  server() listens only on IPv6 on Windows (because IPV6_V6ONLY defaults
//  to true) and socketConnect() is hard coded to try only IPv4.
#ifdef HAVE_WINSOCK2_H
TEST(TLSAdapter, DISABLED_Test_5)
#else
TEST(TLSAdapter, Test_5)
#endif
{
    socket_error = false;
    pthread_t thread1, thread2;
    int ret = 0;
    int arg = 1;

    ret = pthread_create( &thread1, NULL, server, (void*) NULL);
    if(ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ret = pthread_create( &thread2, NULL, testCAdecryptSsl, &arg);
    if(ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ASSERT_FALSE(socket_error);
    EXPECT_EQ(0, arg);
}

/* **************************
 *
 *
 * CAdeinitSslAdapter test
 *
 *
 * *************************/

static int testCAdeinitSslAdapter()
{
    int ret = 0;
    CAEndpoint_t serverAddr;
    serverAddr.adapter = CA_ADAPTER_IP;
    serverAddr.flags = CA_SECURE;
    serverAddr.port = 4433;
    char addr[] = {0x31, 0x32, 0x37, 0x2e, 0x30, 0x2e, 0x30, 0x2e, 0x31, 0x00}; // 127.0.0.1
    memcpy(serverAddr.addr, addr, sizeof(addr));
    serverAddr.ifindex = 0;

    CAinitSslAdapter();

    CAsetSslAdapterCallbacks(CATCPPacketReceivedCB, CATCPPacketSendCB, CA_ADAPTER_TCP);

    CAsetPkixInfoCallback(infoCallback_that_loads_x509);

    CAsetTlsCipherSuite(SSL_ECDHE_ECDSA_WITH_AES_128_CCM);

    CAdeinitSslAdapter();

    if (g_caSslContext != NULL ||
        g_sslContextMutex != NULL)
    {
        ret = 1;
    }
    else
    {
        ret = 0;
    }
    return ret;
}

// CAdeinitSslAdapter()
TEST(TLSAdapter, Test_6)
{
    int ret = 0xFF;
    ret = testCAdeinitSslAdapter();
    EXPECT_EQ(0, ret);
}

/* **************************
 *
 *
 * Server side test
 *
 *
 * *************************/

static void * testServer(void * arg)
{
    CAEndpoint_t serverAddr;
    serverAddr.adapter = CA_ADAPTER_TCP;
    serverAddr.flags = CA_SECURE;
    serverAddr.port = 4432;
    char addr[] = {0x31, 0x32, 0x37, 0x2e, 0x30, 0x2e, 0x30, 0x2e, 0x31, 0x00}; // 127.0.0.1
    memcpy(serverAddr.addr, addr, sizeof(addr));
    serverAddr.ifindex = 0;
    unsigned char buffer[2048] = {'\0'};
    int buflen = 0;

    CAinitSslAdapter();

    CAsetSslAdapterCallbacks(CATCPPacketReceivedCB_server, CATCPPacketSendCB_server, CA_ADAPTER_TCP);
    CAsetPkixInfoCallback(infoCallback_that_loads_x509);

    CAsetCredentialTypesCallback(clutch);

    CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_128_CCM);

    CAsetPskCredentialsCallback(GetDtlsPskCredentials);

    if (!socketOpen_server())
    {
        *((int*)arg) = 0xFF;
        return (void *) 0xFF;
    }

    CASecureEndpoint_t * sep = (CASecureEndpoint_t *) malloc (sizeof(CASecureEndpoint_t));
    sep->endpoint = serverAddr;

    for (int i = 0; i < 7; i++)
    {
        PacketReceive_server(buffer, &buflen);
        if (buflen < 1)
        {
            *((int*)arg) = 0xFF;
            return (void *) 0xFF;
        }
        CAdecryptSsl(sep, (uint8_t *)buffer, buflen);
    }

    CAcloseSslConnection(&serverAddr);

    CAdeinitSslAdapter();

    socketClose_server();

    if (control_client_message_len == msglen && memcmp(msg, control_client_message,
                                                            control_client_message_len) == 0)
    {
        *((int*)arg) = 0;
        return NULL;
    }
    else
    {
        *((int*)arg) = 0xFF;
        return (void *) 0xFF;
    }
}

#ifdef HAVE_WINSOCK2_H
// This test doesn't work on Windows:
// testServer opens a socket without first calling WSAStartup
// PacketReceive_server calls read() rather than recv() on a socket handle
TEST(TLSAdapter, DISABLED_Test_7)
#else
TEST(TLSAdapter, Test_7)
#endif
{
    socket_error = false;
    pthread_t thread1, thread2;
    int ret = 0;
    int arg = 1;

    ret = pthread_create( &thread1, NULL, testServer, &arg);
    if (ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ret = pthread_create( &thread2, NULL, client, (void*) NULL);
    if (ret)
    {
        fprintf(stderr,"Error - pthread_create() return code: %d\n", ret);
        ASSERT_TRUE(false);
    }

    sleep(5);

    ASSERT_FALSE(socket_error);
    EXPECT_EQ(0, arg);
}

/* **************************
 *
 * CAsetPskCredentialsCallback test
 * CAsetPkixInfoCallback test
 * CAsetCredentialTypesCallback test
 *
 * *************************/

static int testCAsetPskCredentialsCallback()
{
    static CAgetPskCredentialsHandler credCallback = (CAgetPskCredentialsHandler)dummyHandler;
    CAsetPskCredentialsCallback(credCallback);
    if (g_getCredentialsCallback == (CAgetPskCredentialsHandler)dummyHandler)
    {
        return 0;
    }
    else
    {
        return 1;
    }
}

static int testCAsetPkixInfoCallback()
{
    static CAgetPkixInfoHandler infoCallback = (CAgetPkixInfoHandler)dummyHandler;
    CAsetPkixInfoCallback(infoCallback);
    if (g_getPkixInfoCallback == (CAgetPkixInfoHandler)dummyHandler)
    {
        return 0;
    }
    else
    {
        return 1;
    }
}

static int testCAsetCredentialTypesCallback()
{
    static CAgetCredentialTypesHandler credTypesCallback = (CAgetCredentialTypesHandler)dummyHandler;
    CAsetCredentialTypesCallback(credTypesCallback);
    if (g_getCredentialTypesCallback == (CAgetCredentialTypesHandler)dummyHandler)
    {
        return 0;
    }
    else
    {
        return 1;
    }
}

// CAsetPskCredentialsCallback()
TEST(TLSAdapter, Test_9_0)
{
    int ret = 0xFF;
    ret = testCAsetPskCredentialsCallback();
    EXPECT_EQ(0, ret);
}
// CAsetPkixInfoCallback()
TEST(TLSAdapter, Test_9_1)
{
    int ret = 0xFF;
    ret = testCAsetPkixInfoCallback();
    EXPECT_EQ(0, ret);
}
// CAsetCredentialTypesCallback()
TEST(TLSAdapter, Test_9_2)
{
    int ret = 0xFF;
    ret = testCAsetCredentialTypesCallback();
    EXPECT_EQ(0, ret);
}

/* **************************
 *
 *
 * CAsetTlsCipherSuite test
 *
 *
 * *************************/

static int testCAsetTlsCipherSuite()
{
    int ret = 0, status = 0;
    CAEndpoint_t serverAddr;
    serverAddr.adapter = CA_ADAPTER_TCP;
    serverAddr.flags = CA_SECURE;
    serverAddr.port = 4433;
    char addr[] = {0x31, 0x32, 0x37, 0x2e, 0x30, 0x2e, 0x30, 0x2e, 0x31, 0x00}; // 127.0.0.1
    memcpy(serverAddr.addr, addr, sizeof(addr));
    serverAddr.ifindex = 0;

    CAinitSslAdapter();

    CAsetCredentialTypesCallback(clutch);

    status = CAsetTlsCipherSuite(MBEDTLS_TLS_RSA_WITH_AES_256_CBC_SHA256);
    if (SSL_RSA_WITH_AES_256_CBC_SHA256 != g_caSslContext->cipher || status != CA_STATUS_OK)
    {
        ret += 1;
    }

    status = CAsetTlsCipherSuite(MBEDTLS_TLS_RSA_WITH_AES_128_GCM_SHA256);
    if (SSL_RSA_WITH_AES_128_GCM_SHA256 != g_caSslContext->cipher || status != CA_STATUS_OK)
    {
        ret += 1;
    }

    status = CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256);
    if (SSL_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 != g_caSslContext->cipher || status != CA_STATUS_OK)
    {
        ret += 1;
    }
    status = CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8);
    if (SSL_ECDHE_ECDSA_WITH_AES_128_CCM_8 != g_caSslContext->cipher || status != CA_STATUS_OK)
    {
        ret += 1;
    }

    status = CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_128_CCM);
    if (SSL_ECDHE_ECDSA_WITH_AES_128_CCM != g_caSslContext->cipher || status != CA_STATUS_OK)
    {
        ret += 1;
    }

    status = CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256);
    if (SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 != g_caSslContext->cipher || status != CA_STATUS_OK)
    {
        ret += 1;
    }

    status = CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384);
    if (SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384 != g_caSslContext->cipher || status != CA_STATUS_OK)
    {
        ret += 1;
    }

    status = CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384);
    if (SSL_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 != g_caSslContext->cipher || status != CA_STATUS_OK)
    {
        ret += 1;
    }

    status = CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256);
    if (SSL_ECDHE_PSK_WITH_AES_128_CBC_SHA256 != g_caSslContext->cipher || status != CA_STATUS_OK)
    {
        ret += 1;
    }

    status = CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256);
    if (SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA256 != g_caSslContext->cipher || status != CA_STATUS_OK)
    {
        ret += 1;
    }

    status = CAsetTlsCipherSuite(MBEDTLS_TLS_ECDH_ANON_WITH_AES_128_CBC_SHA256);
    if (SSL_ECDH_ANON_WITH_AES_128_CBC_SHA256 != g_caSslContext->cipher || status != CA_STATUS_OK)
    {
        ret += 1;
    }

    CAdeinitSslAdapter();

    return ret;
}

// CAinitTlsAdapter()
TEST(TLSAdapter, Test_10)
{
    int ret = 0xff;
    ret = testCAsetTlsCipherSuite();
    EXPECT_EQ(0, ret);
}

// This test has a bug in it (IOT-1848):
//  server() listens only on IPv6 on Windows (because IPV6_V6ONLY defaults
//  to true) and socketConnect() is hard coded to try only IPv4.
#ifdef HAVE_WINSOCK2_H
TEST(TLSAdapter, DISABLED_Test_11)
#else
TEST(TLSAdapter, Test_11)
#endif
{
    uint8_t predictedPSK[] = {
        0xba, 0x72, 0x16, 0xbc, 0x7f, 0x8c, 0xfe, 0xfc, 0xd0, 0xac, 0x1a, 0x37, 0xad, 0x60, 0xe8, 0x9e, 
        0xb3, 0x31, 0xa2, 0x30, 0xaf, 0x68, 0xc9, 0xa6, 0x89, 0x8a, 0x04, 0x21, 0x6c, 0xbd, 0x04, 0x08, 
        0x68, 0x11, 0x54, 0x9e, 0x2a, 0x10, 0x91, 0x94, 0x3c, 0x44, 0x52, 0xc7, 0xfa, 0x78, 0x44, 0x87, 
        0xea, 0x30, 0x08, 0x5f, 0xc1, 0x64, 0xaa, 0x0d, 0xfd, 0x84, 0x16, 0x83, 0x20, 0xc9, 0x08, 0x65, 
        0xd2, 0x4a, 0x55, 0x9e, 0x8f, 0x88, 0x3c, 0x57, 0x10, 0xbd, 0x5a, 0x30, 0x01, 0xb4, 0x59, 0x63, 
        0x64, 0x19, 0x8d, 0xfa, 0x5c, 0x86, 0x92, 0xf7, 0x60, 0x99, 0xdb, 0xae, 0x0e, 0xad, 0x80, 0xf1, 
        0x82, 0xaf, 0x1b, 0x14
    };
    size_t predictedPSK_len = sizeof(predictedPSK);

    uint8_t label[] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A};
    uint8_t rsrcServerDeviceId[] = {0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A};
    uint8_t provServerDeviceId[] = {0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A};
    uint8_t *ownerPsk = (uint8_t*)OICMalloc(predictedPSK_len);
    EXPECT_TRUE(NULL != ownerPsk) << "Cannot allocate memory";
    memset(ownerPsk, 0, predictedPSK_len);

    socket_error = false;

    CAEndpoint_t serverAddr;
    memset(&serverAddr, 0, sizeof(serverAddr));
    serverAddr.adapter = CA_ADAPTER_TCP;
    serverAddr.flags = CA_SECURE;
    serverAddr.port = 4433;
    char addr[] = {0x31, 0x32, 0x37, 0x2e, 0x30, 0x2e, 0x30, 0x2e, 0x31, 0x00}; // 127.0.0.1
    memcpy(serverAddr.addr, addr, sizeof(addr));
    serverAddr.ifindex = 0;

    //start server
    pthread_t thread;
    EXPECT_EQ(0, pthread_create( &thread, NULL, server, (void*) NULL)) << "Thread create";
    sleep(5);
    ASSERT_FALSE(socket_error) << "Server: socket error";

    g_sslContextMutex = oc_mutex_new_recursive();
    oc_mutex_lock(g_sslContextMutex);
    g_caSslContext = (SslContext_t *)OICCalloc(1, sizeof(SslContext_t));
    g_caSslContext->peerList = u_arraylist_create();
    mbedtls_entropy_init(&g_caSslContext->entropy);
    mbedtls_ctr_drbg_init(&g_caSslContext->rnd);
    mbedtls_ctr_drbg_seed(&g_caSslContext->rnd, mbedtls_entropy_func_clutch,
                                  &g_caSslContext->entropy,
                                  (const unsigned char*) PERSONALIZATION_STRING, sizeof(PERSONALIZATION_STRING));
    mbedtls_ctr_drbg_set_prediction_resistance(&g_caSslContext->rnd, MBEDTLS_CTR_DRBG_PR_OFF);
    InitConfig(&g_caSslContext->clientTlsConf,
                        MBEDTLS_SSL_TRANSPORT_STREAM, MBEDTLS_SSL_IS_CLIENT);
    InitConfig(&g_caSslContext->serverTlsConf,
                        MBEDTLS_SSL_TRANSPORT_STREAM, MBEDTLS_SSL_IS_SERVER);
    mbedtls_ssl_cookie_init(&g_caSslContext->cookieCtx);
    mbedtls_ssl_cookie_setup(&g_caSslContext->cookieCtx, mbedtls_ctr_drbg_random,
                                      &g_caSslContext->rnd);
    InitConfig(&g_caSslContext->clientDtlsConf,
                        MBEDTLS_SSL_TRANSPORT_DATAGRAM, MBEDTLS_SSL_IS_CLIENT);
    InitConfig(&g_caSslContext->serverDtlsConf,
                        MBEDTLS_SSL_TRANSPORT_DATAGRAM, MBEDTLS_SSL_IS_SERVER);
    g_caSslContext->cipher = SSL_CIPHER_MAX;
    mbedtls_x509_crt_init(&g_caSslContext->ca);
    mbedtls_x509_crt_init(&g_caSslContext->crt);
    mbedtls_pk_init(&g_caSslContext->pkey);
    mbedtls_x509_crl_init(&g_caSslContext->crl);
    oc_mutex_unlock(g_sslContextMutex);

    CAsetSslAdapterCallbacks(CATCPPacketReceivedCB, CATCPPacketSendCB, CA_ADAPTER_TCP);

    CAsetPkixInfoCallback(infoCallback_that_loads_x509);

    CAsetCredentialTypesCallback(clutch);

    CAsetTlsCipherSuite(MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256);
    g_caSslContext->selectedCipher = MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256;

    CAsetPskCredentialsCallback(GetDtlsPskCredentials);

    EXPECT_NE(false, socketConnect());
    ASSERT_FALSE(socket_error) << "Client: cannot connect to server";

    // CAinitiateSslHandshake
    oc_mutex_lock(g_sslContextMutex);
    InitiateTlsHandshake(&serverAddr);
    oc_mutex_unlock(g_sslContextMutex);

    EXPECT_EQ(0, CAsslGenerateOwnerPsk(&serverAddr,
          label, sizeof(label),
          rsrcServerDeviceId, sizeof(rsrcServerDeviceId),
          provServerDeviceId, sizeof(provServerDeviceId),
          ownerPsk, predictedPSK_len));

    CAcloseSslConnection(&serverAddr);

    CAdeinitSslAdapter();

    socketClose();

    ASSERT_FALSE(socket_error) << "Client: socket error";

    mbedtls_printf("Got PSK:\n");
    printHexArray(ownerPsk, predictedPSK_len, DEFAULT_HEX_WIDTH);
    EXPECT_EQ(0, memcmp(predictedPSK, ownerPsk, predictedPSK_len)) << "PSK error";
    OICFree(ownerPsk);
}

TEST(TLSAdapter, Test_ParseChain)
{
    int errNum;
    mbedtls_x509_crt crt;
    mbedtls_x509_crt_init(&crt);
    size_t ret = ParseChain(&crt, certChain, certChainLen, &errNum);
    mbedtls_x509_crt_free(&crt);

    EXPECT_EQ(7, ret);
    EXPECT_EQ(0, errNum);
}

TEST(TLSAdapter, TestCertsValid)
{
    mbedtls_x509_crt cert;

    mbedtls_x509_crt_init(&cert);
    int ret = mbedtls_x509_crt_parse(&cert, (const unsigned char *)serverCert, serverCertLen);
    EXPECT_EQ(0, ret) << "Failed to parse server cert";
    mbedtls_x509_crt_free(&cert);

    mbedtls_x509_crt_init(&cert);
    ret = mbedtls_x509_crt_parse(&cert, (const unsigned char *)caCert, caCertLen);
    EXPECT_EQ(0, ret) << "Failed to parse CA cert";
    mbedtls_x509_crt_free(&cert);
}
