/*
 * Mesh data for a weighted companion cube.
 *
 * A weighted companion cube is a well known meme from the 2007 video game
 * 'Portal' by the Valve Corporation.
 *
 * This mesh data was created from a blender file made by Tobias Brage
 * <gamerfreaq@live.com>, it can be retrieved from:
 * http://www.blendswap.com/blends/low-poly/weighted-companion-cube-hearted/
 *
 * This data is licensed under the Creative Commons Attribution-NonCommercial
 * 3.0 license (CC BY-NC 3.0): http://creativecommons.org/licenses/by-nc/3.0/
 */

#include "companion.h"

float
companion_vertices[COMPANION_VERTEX_COUNT][3] = {
	{-0.218562, 0.774222, -2.897064},
	{-0.973861, 1.529520, -2.897064},
	{-1.106699, 1.367656, -2.897064},
	{-1.205407, 1.182986, -2.897064},
	{-0.218562, 0.774222, -2.897064},
	{-1.205407, 1.182986, -2.897064},
	{-1.266191, 0.982608, -2.897064},
	{-1.266191, 0.982608, -2.897064},
	{-1.286716, 0.774222, -2.897064},
	{-1.266191, 0.565836, -2.897064},
	{-1.205407, 0.365458, -2.897064},
	{-1.106699, 0.180788, -2.897064},
	{-0.973861, 0.018924, -2.897064},
	{-0.811996, -0.113915, -2.897064},
	{-0.627327, -0.212623, -2.897064},
	{-0.426948, -0.273407, -2.897064},
	{-0.218562, 0.774222, -2.897064},
	{-0.426948, -0.273407, -2.897064},
	{-0.218562, -0.293931, -2.897065},
	{-0.218562, -0.293931, -2.897065},
	{-0.010176, -0.273407, -2.897065},
	{0.190203, -0.212622, -2.897065},
	{0.374872, -0.113914, -2.897065},
	{0.536736, 0.018924, -2.897065},
	{0.669575, 0.180789, -2.897065},
	{0.768283, 0.365459, -2.897065},
	{0.829066, 0.565837, -2.897065},
	{0.849590, 0.774223, -2.897065},
	{0.829066, 0.982610, -2.897065},
	{0.768282, 1.182988, -2.897065},
	{0.669573, 1.367657, -2.897065},
	{-0.218562, 0.774222, -2.897064},
	{0.669573, 1.367657, -2.897065},
	{0.536735, 1.529521, -2.897064},
	{0.536735, 1.529521, -2.897064},
	{0.374870, 1.662360, -2.897064},
	{0.190200, 1.761067, -2.897064},
	{-0.010178, 1.821851, -2.897064},
	{-0.218564, 1.842375, -2.897064},
	{-0.426951, 1.821850, -2.897064},
	{-0.627329, 1.761066, -2.897064},
	{-0.811998, 1.662358, -2.897064},
	{-0.218563, 0.774333, 1.627662},
	{-0.973861, 0.019035, 1.627663},
	{-1.106699, 0.180899, 1.627663},
	{-1.205407, 0.365569, 1.627663},
	{-0.218563, 0.774333, 1.627662},
	{-1.205407, 0.365569, 1.627663},
	{-1.266191, 0.565947, 1.627663},
	{-1.286716, 0.774333, 1.627663},
	{-1.266191, 0.982719, 1.627663},
	{-1.205407, 1.183097, 1.627663},
	{-1.106700, 1.367767, 1.627663},
	{-0.218563, 0.774333, 1.627662},
	{-1.106700, 1.367767, 1.627663},
	{-0.973861, 1.529631, 1.627662},
	{-0.973861, 1.529631, 1.627662},
	{-0.811997, 1.662470, 1.627662},
	{-0.627327, 1.761178, 1.627662},
	{-0.426949, 1.821962, 1.627662},
	{-0.218562, 1.842486, 1.627662},
	{-0.010176, 1.821962, 1.627662},
	{0.190202, 1.761178, 1.627662},
	{0.374872, 1.662470, 1.627662},
	{0.536736, 1.529631, 1.627662},
	{0.669574, 1.367767, 1.627662},
	{0.768282, 1.183097, 1.627662},
	{-0.218563, 0.774333, 1.627662},
	{0.768282, 1.183097, 1.627662},
	{0.829066, 0.982719, 1.627662},
	{0.829066, 0.982719, 1.627662},
	{0.849590, 0.774332, 1.627662},
	{0.829066, 0.565946, 1.627662},
	{0.768282, 0.365568, 1.627662},
	{0.669573, 0.180898, 1.627662},
	{0.536735, 0.019034, 1.627662},
	{0.374870, -0.113804, 1.627662},
	{0.190200, -0.212512, 1.627662},
	{0.190200, -0.212512, 1.627662},
	{-0.010178, -0.273296, 1.627662},
	{-0.218563, 0.774333, 1.627662},
	{-0.010178, -0.273296, 1.627662},
	{-0.218564, -0.293820, 1.627663},
	{-0.218564, -0.293820, 1.627663},
	{-0.426951, -0.273295, 1.627663},
	{-0.627329, -0.212511, 1.627663},
	{-0.627329, -0.212511, 1.627663},
	{-0.811998, -0.113802, 1.627663},
	{-0.218563, -1.488086, -0.634645},
	{-0.973861, -1.488086, -1.389944},
	{-1.106699, -1.488086, -1.228079},
	{-1.205407, -1.488086, -1.043410},
	{-1.266191, -1.488086, -0.843032},
	{-1.286716, -1.488086, -0.634646},
	{-1.266191, -1.488086, -0.426259},
	{-0.218563, -1.488086, -0.634645},
	{-1.266191, -1.488086, -0.426259},
	{-1.205407, -1.488086, -0.225881},
	{-1.205407, -1.488086, -0.225881},
	{-1.106699, -1.488086, -0.041211},
	{-0.973861, -1.488086, 0.120653},
	{-0.811997, -1.488086, 0.253491},
	{-0.218563, -1.488086, -0.634645},
	{-0.811997, -1.488086, 0.253491},
	{-0.627327, -1.488086, 0.352199},
	{-0.627327, -1.488086, 0.352199},
	{-0.426949, -1.488086, 0.412983},
	{-0.218562, -1.488086, 0.433507},
	{-0.010176, -1.488086, 0.412983},
	{-0.218563, -1.488086, -0.634645},
	{-0.010176, -1.488086, 0.412983},
	{0.190202, -1.488086, 0.352199},
	{0.190202, -1.488086, 0.352199},
	{0.374872, -1.488086, 0.253491},
	{0.536736, -1.488086, 0.120652},
	{0.669575, -1.488086, -0.041212},
	{0.768282, -1.488086, -0.225882},
	{0.829066, -1.488086, -0.426260},
	{0.849590, -1.488086, -0.634647},
	{0.829066, -1.488086, -0.843033},
	{0.768282, -1.488086, -1.043411},
	{0.669573, -1.488086, -1.228081},
	{0.536735, -1.488086, -1.389945},
	{0.374870, -1.488086, -1.522783},
	{0.374870, -1.488086, -1.522783},
	{0.190200, -1.488086, -1.621491},
	{0.190200, -1.488086, -1.621491},
	{-0.010178, -1.488086, -1.682274},
	{-0.218564, -1.488086, -1.702798},
	{-0.426951, -1.488086, -1.682274},
	{-0.426951, -1.488086, -1.682274},
	{-0.627329, -1.488086, -1.621489},
	{-0.627329, -1.488086, -1.621489},
	{-0.811998, -1.488086, -1.522781},
	{-0.218563, 3.036641, -0.634756},
	{-0.973861, 3.036641, 0.120542},
	{-1.106699, 3.036641, -0.041322},
	{-1.205407, 3.036641, -0.225992},
	{-1.266191, 3.036641, -0.426370},
	{-1.286716, 3.036641, -0.634756},
	{-0.218563, 3.036641, -0.634756},
	{-1.286716, 3.036641, -0.634756},
	{-1.266191, 3.036640, -0.843142},
	{-1.266191, 3.036640, -0.843142},
	{-1.205407, 3.036640, -1.043520},
	{-1.106699, 3.036640, -1.228190},
	{-0.973861, 3.036640, -1.390054},
	{-0.218563, 3.036641, -0.634756},
	{-0.973861, 3.036640, -1.390054},
	{-0.811996, 3.036641, -1.522893},
	{-0.811996, 3.036641, -1.522893},
	{-0.627327, 3.036641, -1.621601},
	{-0.426949, 3.036641, -1.682385},
	{-0.218562, 3.036641, -1.702909},
	{-0.010176, 3.036641, -1.682385},
	{-0.010176, 3.036641, -1.682385},
	{0.190202, 3.036641, -1.621601},
	{0.190202, 3.036641, -1.621601},
	{0.374872, 3.036641, -1.522893},
	{0.536736, 3.036641, -1.390054},
	{0.669575, 3.036641, -1.228190},
	{0.768282, 3.036641, -1.043520},
	{0.829066, 3.036641, -0.843142},
	{0.849590, 3.036641, -0.634755},
	{0.829066, 3.036641, -0.426369},
	{0.768282, 3.036641, -0.225991},
	{0.669574, 3.036641, -0.041321},
	{0.536735, 3.036641, 0.120543},
	{0.374870, 3.036641, 0.253381},
	{0.190201, 3.036641, 0.352089},
	{-0.010178, 3.036641, 0.412873},
	{-0.218564, 3.036641, 0.433397},
	{-0.426951, 3.036641, 0.412872},
	{-0.627329, 3.036641, 0.352088},
	{-0.811998, 3.036641, 0.253379},
	{-0.811998, 3.036641, 0.253379},
	{-0.973861, 3.036641, 0.120542},
	{-0.218563, 3.036641, -0.634756},
	{-2.473807, 0.767158, -0.634756},
	{-2.473807, 0.011860, 0.120542},
	{-2.473807, -0.120978, -0.041322},
	{-2.473807, 0.767158, -0.634756},
	{-2.473807, -0.120978, -0.041322},
	{-2.473807, -0.219686, -0.225992},
	{-2.473807, -0.280470, -0.426370},
	{-2.473807, -0.300995, -0.634756},
	{-2.473807, -0.280470, -0.843142},
	{-2.473807, -0.219686, -1.043520},
	{-2.473807, -0.120978, -1.228190},
	{-2.473807, 0.011860, -1.390054},
	{-2.473807, 0.173724, -1.522893},
	{-2.473807, 0.358394, -1.621601},
	{-2.473807, 0.558772, -1.682385},
	{-2.473807, 0.767159, -1.702909},
	{-2.473807, 0.975545, -1.682385},
	{-2.473807, 1.175923, -1.621600},
	{-2.473807, 0.767158, -0.634756},
	{-2.473807, 1.175923, -1.621600},
	{-2.473807, 1.360593, -1.522892},
	{-2.473807, 1.360593, -1.522892},
	{-2.473807, 1.522457, -1.390054},
	{-2.473807, 1.655296, -1.228189},
	{-2.473807, 1.754004, -1.043520},
	{-2.473807, 1.814787, -0.843141},
	{-2.473807, 1.835311, -0.634755},
	{-2.473807, 1.814787, -0.426369},
	{-2.473807, 1.754003, -0.225991},
	{-2.473807, 1.655294, -0.041321},
	{-2.473807, 0.767158, -0.634756},
	{-2.473807, 1.655294, -0.041321},
	{-2.473807, 1.522456, 0.120543},
	{-2.473807, 0.767158, -0.634756},
	{-2.473807, 1.522456, 0.120543},
	{-2.473807, 1.360591, 0.253381},
	{-2.473807, 1.360591, 0.253381},
	{-2.473807, 1.175921, 0.352089},
	{-2.473807, 0.975543, 0.412873},
	{-2.473807, 0.767157, 0.433397},
	{-2.473807, 0.558770, 0.412872},
	{-2.473807, 0.358392, 0.352088},
	{-2.473807, 0.173723, 0.253380},
	{-2.473807, 0.011860, 0.120542},
	{2.050920, 0.767159, -0.634646},
	{2.050920, 0.011860, -1.389944},
	{2.050920, -0.120978, -1.228080},
	{2.050920, -0.219686, -1.043410},
	{2.050920, -0.280470, -0.843032},
	{2.050920, -0.300995, -0.634646},
	{2.050920, -0.280470, -0.426259},
	{2.050920, -0.219686, -0.225881},
	{2.050920, -0.120978, -0.041212},
	{2.050920, 0.011860, 0.120653},
	{2.050920, 0.173725, 0.253491},
	{2.050920, 0.358394, 0.352199},
	{2.050920, 0.558772, 0.412983},
	{2.050920, 0.767159, 0.433507},
	{2.050920, 0.975545, 0.412983},
	{2.050920, 1.175923, 0.352199},
	{2.050920, 0.767159, -0.634646},
	{2.050920, 1.175923, 0.352199},
	{2.050920, 1.360593, 0.253491},
	{2.050920, 1.360593, 0.253491},
	{2.050920, 1.522457, 0.120652},
	{2.050920, 1.655296, -0.041212},
	{2.050920, 0.767159, -0.634646},
	{2.050920, 1.655296, -0.041212},
	{2.050920, 1.754004, -0.225882},
	{2.050920, 1.754004, -0.225882},
	{2.050920, 1.814787, -0.426260},
	{2.050920, 1.835311, -0.634647},
	{2.050920, 1.814787, -0.843033},
	{2.050920, 1.754003, -1.043411},
	{2.050920, 1.655295, -1.228081},
	{2.050920, 1.522456, -1.389945},
	{2.050920, 1.360591, -1.522783},
	{2.050920, 1.175921, -1.621491},
	{2.050920, 0.767159, -0.634646},
	{2.050920, 1.175921, -1.621491},
	{2.050920, 0.975543, -1.682275},
	{2.050920, 0.975543, -1.682275},
	{2.050920, 0.767157, -1.702799},
	{2.050920, 0.767157, -1.702799},
	{2.050920, 0.558770, -1.682274},
	{2.050920, 0.358392, -1.621490},
	{2.050920, 0.173723, -1.522781},
	{-0.210020, 0.777640, -2.940320},
	{-1.442901, -0.455242, -2.940320},
	{-1.659735, -0.191029, -2.940320},
	{-1.820857, 0.110409, -2.940320},
	{-1.920076, 0.437488, -2.940320},
	{-1.953577, 0.777640, -2.940320},
	{-1.920076, 1.117791, -2.940320},
	{-1.820857, 1.444870, -2.940320},
	{-1.659735, 1.746309, -2.940320},
	{-0.210020, 0.777640, -2.940320},
	{-1.659735, 1.746309, -2.940320},
	{-1.442901, 2.010521, -2.940320},
	{-1.442901, 2.010521, -2.940320},
	{-1.178689, 2.227355, -2.940320},
	{-0.210020, 0.777640, -2.940320},
	{-1.178689, 2.227355, -2.940320},
	{-0.877250, 2.388478, -2.940320},
	{-0.877250, 2.388478, -2.940320},
	{-0.550171, 2.487696, -2.940320},
	{-0.550171, 2.487696, -2.940320},
	{-0.210019, 2.521198, -2.940321},
	{-0.210019, 2.521198, -2.940321},
	{0.130132, 2.487696, -2.940321},
	{0.457212, 2.388477, -2.940321},
	{0.758650, 2.227355, -2.940321},
	{1.022863, 2.010521, -2.940321},
	{-0.210020, 0.777640, -2.940320},
	{1.022863, 2.010521, -2.940321},
	{1.243807, 1.750419, -2.940320},
	{1.243807, 1.750419, -2.940320},
	{1.400818, 1.444870, -2.940320},
	{1.500037, 1.117790, -2.940320},
	{1.533538, 0.777639, -2.940320},
	{1.500036, 0.437487, -2.940320},
	{1.400817, 0.110408, -2.940320},
	{1.239695, -0.191030, -2.940320},
	{1.022861, -0.455243, -2.940320},
	{0.758648, -0.672076, -2.940320},
	{0.457209, -0.833198, -2.940320},
	{0.130129, -0.932416, -2.940320},
	{0.130129, -0.932416, -2.940320},
	{-0.210022, -0.965918, -2.940320},
	{-0.210022, -0.965918, -2.940320},
	{-0.550173, -0.932415, -2.940320},
	{-0.877253, -0.833196, -2.940320},
	{-1.178691, -0.672074, -2.940320},
	{-0.210020, 0.770915, 1.663495},
	{-1.454810, 2.015705, 1.663495},
	{-1.673738, 1.748940, 1.663495},
	{-0.210020, 0.770915, 1.663495},
	{-1.673738, 1.748940, 1.663495},
	{-1.836416, 1.444590, 1.663495},
	{-1.836416, 1.444590, 1.663495},
	{-1.936593, 1.114352, 1.663495},
	{-1.970419, 0.770915, 1.663495},
	{-1.936593, 0.427478, 1.663495},
	{-1.836416, 0.097239, 1.663495},
	{-0.210020, 0.770915, 1.663495},
	{-1.836416, 0.097239, 1.663495},
	{-1.673738, -0.207110, 1.663495},
	{-1.673738, -0.207110, 1.663495},
	{-1.454809, -0.473875, 1.663495},
	{-1.188045, -0.692803, 1.663495},
	{-0.210020, 0.770915, 1.663495},
	{-1.188045, -0.692803, 1.663495},
	{-0.883695, -0.855482, 1.663494},
	{-0.883695, -0.855482, 1.663494},
	{-0.553456, -0.955659, 1.663494},
	{-0.210019, -0.989484, 1.663494},
	{0.133418, -0.955658, 1.663494},
	{0.463657, -0.855481, 1.663494},
	{0.463657, -0.855481, 1.663494},
	{0.768007, -0.692802, 1.663494},
	{0.768007, -0.692802, 1.663494},
	{1.034771, -0.473874, 1.663494},
	{-0.210020, 0.770915, 1.663495},
	{1.034771, -0.473874, 1.663494},
	{1.257850, -0.211259, 1.663494},
	{1.257850, -0.211259, 1.663494},
	{1.416377, 0.097241, 1.663494},
	{1.516554, 0.427480, 1.663494},
	{1.550379, 0.770917, 1.663494},
	{-0.210020, 0.770915, 1.663495},
	{1.550379, 0.770917, 1.663494},
	{1.516553, 1.114354, 1.663494},
	{1.516553, 1.114354, 1.663494},
	{1.416376, 1.444592, 1.663494},
	{1.416376, 1.444592, 1.663494},
	{1.253697, 1.748942, 1.663494},
	{1.253697, 1.748942, 1.663494},
	{1.034769, 2.015707, 1.663494},
	{0.768003, 2.234635, 1.663494},
	{0.768003, 2.234635, 1.663494},
	{0.463653, 2.397312, 1.663495},
	{0.463653, 2.397312, 1.663495},
	{0.133414, 2.497489, 1.663495},
	{-0.210023, 2.531314, 1.663495},
	{-0.553460, 2.497488, 1.663495},
	{-0.883698, 2.397310, 1.663495},
	{-1.188048, 2.234631, 1.663495},
	{-0.210020, -1.523918, -0.638064},
	{-1.442901, -1.523918, 0.594818},
	{-1.659735, -1.523918, 0.330605},
	{-0.210020, -1.523918, -0.638064},
	{-1.659735, -1.523918, 0.330605},
	{-1.820857, -1.523918, 0.029167},
	{-1.920076, -1.523918, -0.297912},
	{-1.953578, -1.523918, -0.638063},
	{-1.920076, -1.523918, -0.978215},
	{-1.820857, -1.523918, -1.305294},
	{-1.659735, -1.523918, -1.606732},
	{-1.442901, -1.523918, -1.870945},
	{-1.178688, -1.523918, -2.087779},
	{-0.877250, -1.523918, -2.248901},
	{-0.550171, -1.523918, -2.348119},
	{-0.210019, -1.523918, -2.381622},
	{-0.210020, -1.523918, -0.638064},
	{-0.210019, -1.523918, -2.381622},
	{0.130132, -1.523917, -2.348119},
	{0.130132, -1.523917, -2.348119},
	{0.457212, -1.523917, -2.248901},
	{0.758650, -1.523917, -2.087779},
	{1.022863, -1.523917, -1.870944},
	{1.022863, -1.523917, -1.870944},
	{1.243807, -1.523918, -1.610842},
	{1.243807, -1.523918, -1.610842},
	{1.400819, -1.523918, -1.305293},
	{-0.210020, -1.523918, -0.638064},
	{1.400819, -1.523918, -1.305293},
	{1.500037, -1.523917, -0.978213},
	{1.500037, -1.523917, -0.978213},
	{1.533538, -1.523917, -0.638062},
	{1.500036, -1.523917, -0.297910},
	{1.400817, -1.523917, 0.029169},
	{1.239695, -1.523917, 0.330607},
	{1.022861, -1.523918, 0.594820},
	{0.758647, -1.523918, 0.811653},
	{0.758647, -1.523918, 0.811653},
	{0.457209, -1.523918, 0.972775},
	{0.457209, -1.523918, 0.972775},
	{0.130129, -1.523918, 1.071993},
	{-0.210022, -1.523918, 1.105494},
	{-0.550174, -1.523918, 1.071992},
	{-0.877253, -1.523918, 0.972773},
	{-1.178691, -1.523918, 0.811650},
	{-1.178691, -1.523918, 0.811650},
	{-1.442901, -1.523918, 0.594818},
	{-0.210020, 3.078297, -0.631338},
	{-1.442901, 3.078297, -1.864220},
	{-1.659735, 3.078297, -1.600007},
	{-1.820857, 3.078297, -1.298569},
	{-1.920076, 3.078297, -0.971489},
	{-1.953578, 3.078297, -0.631338},
	{-1.920076, 3.078297, -0.291187},
	{-1.820857, 3.078297, 0.035892},
	{-1.659735, 3.078297, 0.337331},
	{-1.442901, 3.078297, 0.601543},
	{-0.210020, 3.078297, -0.631338},
	{-1.442901, 3.078297, 0.601543},
	{-1.178689, 3.078297, 0.818377},
	{-1.178689, 3.078297, 0.818377},
	{-0.877250, 3.078297, 0.979500},
	{-0.550170, 3.078297, 1.078718},
	{-0.210019, 3.078297, 1.112220},
	{0.130132, 3.078297, 1.078718},
	{0.130132, 3.078297, 1.078718},
	{0.457212, 3.078297, 0.979499},
	{0.457212, 3.078297, 0.979499},
	{0.758650, 3.078297, 0.818377},
	{1.022863, 3.078297, 0.601543},
	{1.243807, 3.078297, 0.341440},
	{1.400818, 3.078297, 0.035891},
	{1.500037, 3.078297, -0.291188},
	{1.533538, 3.078297, -0.631340},
	{1.500036, 3.078297, -0.971491},
	{-0.210020, 3.078297, -0.631338},
	{1.500036, 3.078297, -0.971491},
	{1.400817, 3.078297, -1.298571},
	{1.400817, 3.078297, -1.298571},
	{1.239695, 3.078297, -1.600009},
	{1.022860, 3.078297, -1.864221},
	{0.758647, 3.078297, -2.081055},
	{0.457209, 3.078297, -2.242177},
	{0.457209, 3.078297, -2.242177},
	{0.130129, 3.078297, -2.341395},
	{0.130129, 3.078297, -2.341395},
	{-0.210023, 3.078297, -2.374896},
	{-0.550174, 3.078297, -2.341393},
	{-0.877253, 3.078297, -2.242174},
	{-1.178691, 3.078297, -2.081052},
	{-2.509639, 0.775701, -0.631338},
	{-2.509638, -0.457180, -1.864220},
	{-2.509638, -0.674014, -1.600007},
	{-2.509638, -0.835136, -1.298569},
	{-2.509638, -0.934355, -0.971489},
	{-2.509638, -0.967856, -0.631338},
	{-2.509638, -0.934354, -0.291187},
	{-2.509638, -0.835136, 0.035893},
	{-2.509638, -0.674014, 0.337331},
	{-2.509638, -0.457180, 0.601544},
	{-2.509638, -0.192967, 0.818378},
	{-2.509638, 0.108471, 0.979500},
	{-2.509639, 0.775701, -0.631338},
	{-2.509638, 0.108471, 0.979500},
	{-2.509639, 0.435550, 1.078718},
	{-2.509639, 0.435550, 1.078718},
	{-2.509639, 0.775702, 1.112220},
	{-2.509639, 1.115853, 1.078718},
	{-2.509639, 1.442933, 0.979499},
	{-2.509639, 1.744371, 0.818377},
	{-2.509639, 2.008584, 0.601543},
	{-2.509639, 0.775701, -0.631338},
	{-2.509639, 2.008584, 0.601543},
	{-2.509640, 2.229528, 0.341440},
	{-2.509640, 2.229528, 0.341440},
	{-2.509640, 2.386539, 0.035891},
	{-2.509639, 0.775701, -0.631338},
	{-2.509640, 2.386539, 0.035891},
	{-2.509639, 2.485758, -0.291188},
	{-2.509639, 2.485758, -0.291188},
	{-2.509639, 2.519259, -0.631340},
	{-2.509639, 2.485757, -0.971491},
	{-2.509639, 2.386538, -1.298571},
	{-2.509639, 2.225415, -1.600009},
	{-2.509639, 2.008581, -1.864221},
	{-2.509639, 1.744368, -2.081055},
	{-2.509639, 1.442930, -2.242177},
	{-2.509639, 1.115850, -2.341394},
	{-2.509639, 0.775698, -2.374896},
	{-2.509639, 0.435547, -2.341393},
	{-2.509639, 0.108468, -2.242174},
	{-2.509639, -0.192970, -2.081052},
	{-2.509639, -0.192970, -2.081052},
	{-2.509638, -0.457180, -1.864220},
	{-2.509639, 0.775701, -0.631338},
	{2.086752, 0.775701, -0.638064},
	{2.086752, -0.457180, 0.594818},
	{2.086752, -0.674014, 0.330605},
	{2.086752, 0.775701, -0.638064},
	{2.086752, -0.674014, 0.330605},
	{2.086752, -0.835136, 0.029167},
	{2.086752, 0.775701, -0.638064},
	{2.086752, -0.835136, 0.029167},
	{2.086752, -0.934355, -0.297912},
	{2.086752, -0.934355, -0.297912},
	{2.086752, -0.967856, -0.638064},
	{2.086752, -0.934355, -0.978215},
	{2.086752, -0.835136, -1.305294},
	{2.086752, -0.835136, -1.305294},
	{2.086752, -0.674014, -1.606732},
	{2.086752, -0.674014, -1.606732},
	{2.086752, -0.457180, -1.870945},
	{2.086752, -0.192967, -2.087779},
	{2.086752, 0.108471, -2.248901},
	{2.086752, 0.435550, -2.348120},
	{2.086752, 0.775702, -2.381622},
	{2.086752, 1.115853, -2.348119},
	{2.086752, 1.442933, -2.248901},
	{2.086752, 1.744371, -2.087779},
	{2.086752, 2.008584, -1.870945},
	{2.086752, 2.229528, -1.610842},
	{2.086752, 2.386539, -1.305293},
	{2.086752, 2.485758, -0.978214},
	{2.086752, 2.519259, -0.638062},
	{2.086752, 2.485757, -0.297911},
	{2.086752, 2.386538, 0.029169},
	{2.086752, 2.225416, 0.330607},
	{2.086752, 2.008581, 0.594820},
	{2.086752, 1.744368, 0.811653},
	{2.086752, 1.442930, 0.972775},
	{2.086752, 0.775701, -0.638064},
	{2.086752, 1.442930, 0.972775},
	{2.086752, 1.115850, 1.071993},
	{2.086752, 1.115850, 1.071993},
	{2.086752, 0.775699, 1.105494},
	{2.086752, 0.775699, 1.105494},
	{2.086752, 0.435547, 1.071992},
	{2.086752, 0.435547, 1.071992},
	{2.086752, 0.108468, 0.972773},
	{2.086752, -0.192970, 0.811650},
	{2.081436, 3.244749, -2.939779},
	{1.421516, 3.244749, -2.939779},
	{1.755954, 3.244749, -2.635721},
	{2.081436, 3.244749, -2.725790},
	{1.237818, 3.244749, -2.454276},
	{1.082304, 3.244749, -2.939780},
	{0.787475, 3.244749, -2.296572},
	{0.787475, 3.244749, -2.939780},
	{0.571060, 3.072946, -2.938577},
	{0.571059, 3.072946, -2.187915},
	{2.081436, 3.244749, -1.640371},
	{1.421516, 3.244749, -1.640371},
	{1.311023, 3.072946, -1.427250},
	{2.081190, 3.072946, -1.427250},
	{0.787475, 3.244749, -2.296572},
	{1.005891, 3.244749, -2.373059},
	{0.930467, 3.244749, -2.939780},
	{0.787475, 3.244749, -2.939780},
	{2.258819, 2.498669, -1.861496},
	{2.258819, 2.579886, -2.093422},
	{2.258819, 3.065389, -1.937909},
	{2.258819, 3.065389, -1.786072},
	{2.258819, 2.422182, -1.643080},
	{2.258819, 2.498669, -1.861496},
	{2.258819, 3.065389, -1.786072},
	{2.258819, 3.065390, -1.643080},
	{2.258819, 1.765981, -2.937041},
	{2.258819, 1.765981, -2.277121},
	{2.086549, 1.562327, -2.166628},
	{2.086549, 1.562327, -2.936795},
	{2.258819, 2.422182, -1.643080},
	{2.258819, 3.065390, -1.643080},
	{2.087016, 3.064187, -1.426665},
	{2.087016, 2.313525, -1.426664},
	{2.258819, 2.761331, -2.611559},
	{2.258819, 3.065389, -2.277121},
	{2.258819, 3.065389, -2.937041},
	{2.258819, 2.422182, -2.937041},
	{2.081436, 3.244749, -1.640371},
	{2.081436, 3.244749, -2.007843},
	{1.608801, 3.244749, -2.197767},
	{1.421516, 3.244749, -1.640371},
	{1.253273, 3.244749, -2.202720},
	{1.272945, 3.244749, -1.882557},
	{1.146502, 3.244749, -2.031245},
	{1.067760, 3.244749, -2.222661},
	{0.881088, 3.244749, -2.234276},
	{0.993168, 3.244749, -2.147139},
	{2.081436, 3.244749, -2.007843},
	{2.081436, 3.244749, -2.381176},
	{1.685320, 3.244749, -2.425503},
	{1.608801, 3.244749, -2.197767},
	{2.081436, 3.244749, -2.381176},
	{1.685320, 3.244749, -2.425503},
	{1.245236, 3.244749, -2.333529},
	{1.253273, 3.244749, -2.202720},
	{1.245236, 3.244749, -2.333529},
	{1.067760, 3.244749, -2.222661},
	{1.035588, 3.244749, -2.300868},
	{0.832409, 3.244749, -2.266670},
	{0.881088, 3.244749, -2.234276},
	{1.005891, 3.244749, -2.373059},
	{0.787475, 3.244749, -2.296572},
	{1.253273, 3.244749, -2.202720},
	{1.245236, 3.244749, -2.333529},
	{1.035588, 3.244749, -2.300868},
	{2.081436, 3.244749, -1.640371},
	{2.081190, 3.072946, -1.427250},
	{2.087016, 3.064187, -1.426665},
	{2.258819, 3.065390, -1.643080},
	{2.081436, 3.244749, -1.640371},
	{2.258819, 3.065390, -1.643080},
	{2.258819, 3.065389, -1.786072},
	{2.081436, 3.244749, -2.007843},
	{2.258819, 3.065389, -1.786072},
	{2.258819, 3.065389, -1.937909},
	{2.081436, 3.244749, -2.381176},
	{2.081436, 3.244749, -2.007843},
	{2.081436, 3.244749, -2.725790},
	{2.258819, 3.065389, -2.277121},
	{2.081436, 3.244749, -2.939779},
	{2.258819, 3.065389, -2.937041},
	{2.089698, 3.073250, -3.108027},
	{2.089698, 2.413330, -3.108027},
	{1.785640, 2.747768, -3.108027},
	{1.446491, 3.073250, -3.108027},
	{1.604195, 2.229632, -3.108027},
	{2.089698, 2.074118, -3.108027},
	{1.446491, 1.779289, -3.108027},
	{2.089698, 1.779289, -3.108027},
	{2.088496, 1.562874, -2.936224},
	{1.337834, 1.562874, -2.936224},
	{0.790290, 3.073250, -3.108027},
	{0.790290, 2.413330, -3.108027},
	{0.572007, 2.302837, -2.936224},
	{0.572007, 3.073004, -2.936224},
	{1.446491, 1.779289, -3.108027},
	{1.522978, 1.997706, -3.108027},
	{2.089698, 1.922282, -3.108027},
	{2.089698, 1.779289, -3.108027},
	{1.522978, 1.997706, -3.108027},
	{2.089698, 1.922282, -3.108027},
	{2.081436, 3.244749, -2.939779},
	{2.258819, 3.065389, -2.937041},
	{2.089698, 3.073250, -3.108027},
	{0.787475, 3.244749, -2.939780},
	{0.790290, 3.073250, -3.108027},
	{0.571060, 3.072946, -2.938577},
	{0.572007, 3.073004, -2.936224},
	{0.790290, 3.073250, -3.108027},
	{0.993712, 3.073250, -3.108027},
	{1.098848, 2.517006, -3.108027},
	{0.790290, 2.413330, -3.108027},
	{1.209709, 2.253870, -3.108027},
	{1.032476, 2.264759, -3.108027},
	{1.181164, 2.138316, -3.108027},
	{1.287126, 2.094727, -3.108027},
	{1.348799, 1.926092, -3.108027},
	{1.304908, 1.992047, -3.108027},
	{1.287126, 2.094727, -3.108027},
	{1.181164, 2.138316, -3.108027},
	{0.787475, 3.244749, -2.939780},
	{0.930467, 3.244749, -2.939780},
	{0.993712, 3.073250, -3.108027},
	{0.790290, 3.073250, -3.108027},
	{1.211046, 3.073250, -3.108027},
	{1.428508, 2.627772, -3.108027},
	{1.399062, 2.242235, -3.108027},
	{1.287126, 2.094727, -3.108027},
	{1.400335, 2.048156, -3.108027},
	{1.395691, 1.855627, -3.108027},
	{1.348799, 1.926092, -3.108027},
	{1.400335, 2.048156, -3.108027},
	{1.522978, 1.997706, -3.108027},
	{1.446491, 1.779289, -3.108027},
	{1.395691, 1.855627, -3.108027},
	{1.400335, 2.048156, -3.108027},
	{1.082304, 3.244749, -2.939780},
	{1.211046, 3.073250, -3.108027},
	{0.993712, 3.073250, -3.108027},
	{0.930467, 3.244749, -2.939780},
	{1.421516, 3.244749, -2.939779},
	{1.446491, 3.073250, -3.108027},
	{1.211046, 3.073250, -3.108027},
	{1.082304, 3.244749, -2.939780},
	{2.081436, 3.244749, -2.939779},
	{2.089698, 3.073250, -3.108027},
	{2.258819, 2.422182, -2.937041},
	{2.089698, 2.413330, -3.108027},
	{2.089698, 3.073250, -3.108027},
	{2.258819, 3.065389, -2.937041},
	{2.258819, 2.008168, -2.128550},
	{2.258819, 2.145380, -2.120119},
	{2.258819, 2.238890, -1.968360},
	{2.258819, 2.156855, -2.002106},
	{2.258819, 2.314579, -1.804776},
	{2.258819, 2.280599, -1.855838},
	{2.258819, 1.765981, -2.277121},
	{2.258819, 2.004865, -2.357386},
	{2.258819, 1.765981, -2.937041},
	{2.258819, 1.923469, -2.937041},
	{2.258819, 2.306147, -2.110241},
	{2.258819, 2.335008, -1.928820},
	{2.258819, 2.354392, -1.744948},
	{2.258819, 2.335008, -1.928820},
	{2.258819, 2.498669, -1.861496},
	{2.258819, 2.422182, -1.643080},
	{2.258819, 2.354392, -1.744948},
	{2.258819, 2.284757, -2.451430},
	{2.258819, 2.107993, -2.937041},
	{2.089698, 2.074118, -3.108027},
	{2.258819, 2.107993, -2.937041},
	{2.258819, 1.923469, -2.937041},
	{2.089698, 1.922282, -3.108027},
	{2.258819, 1.765981, -2.937041},
	{2.089698, 1.779289, -3.108027},
	{2.089698, 1.922282, -3.108027},
	{2.258819, 1.923469, -2.937041},
	{2.089698, 2.413330, -3.108027},
	{2.258819, 2.422182, -2.937041},
	{2.086549, 1.562327, -2.936795},
	{2.089698, 1.779289, -3.108027},
	{2.258819, 1.765981, -2.937041},
	{2.088496, 1.562874, -2.936224},
	{2.081435, -1.523168, -3.107232},
	{1.421516, -1.523168, -3.107232},
	{1.755954, -1.219110, -3.107232},
	{2.081435, -1.309179, -3.107232},
	{1.237817, -1.037665, -3.107232},
	{1.082304, -1.523168, -3.107232},
	{0.787475, -0.879961, -3.107232},
	{0.787475, -1.523169, -3.107232},
	{0.571060, -1.521966, -2.935429},
	{0.571059, -0.771304, -2.935429},
	{2.081435, -0.223760, -3.107232},
	{1.421515, -0.223760, -3.107232},
	{1.311023, -0.010639, -2.935429},
	{2.081190, -0.010639, -2.935429},
	{0.787475, -0.879961, -3.107232},
	{1.005891, -0.956448, -3.107232},
	{0.930467, -1.523168, -3.107232},
	{0.787475, -1.523169, -3.107232},
	{2.258819, -0.444885, -2.361151},
	{2.258819, -0.676811, -2.442369},
	{2.258819, -0.521298, -2.927872},
	{2.258819, -0.369461, -2.927872},
	{2.258819, -0.226469, -2.284665},
	{2.258819, -0.226469, -2.927872},
	{2.258819, -1.520429, -1.628463},
	{2.258819, -0.860510, -1.628463},
	{2.086549, -0.750017, -1.424809},
	{2.086549, -1.520184, -1.424809},
	{2.258819, -0.226469, -2.284665},
	{2.258819, -0.226469, -2.927872},
	{2.087016, -0.010054, -2.926670},
	{2.087016, -0.010053, -2.176008},
	{2.258819, -1.194948, -2.623813},
	{2.258819, -0.860510, -2.927872},
	{2.258819, -1.520429, -2.927872},
	{2.258819, -1.520429, -2.284665},
	{2.081435, -0.223760, -3.107232},
	{2.081435, -0.591232, -3.107232},
	{1.608801, -0.781156, -3.107232},
	{1.421515, -0.223760, -3.107232},
	{1.253273, -0.786109, -3.107232},
	{1.272945, -0.465946, -3.107232},
	{1.146501, -0.614634, -3.107232},
	{1.067760, -0.806050, -3.107232},
	{0.881088, -0.817665, -3.107232},
	{0.993167, -0.730528, -3.107232},
	{2.081435, -0.964565, -3.107232},
	{1.685320, -1.008892, -3.107232},
	{1.245236, -0.916918, -3.107232},
	{1.035588, -0.884257, -3.107232},
	{0.832409, -0.850059, -3.107232},
	{2.081435, -0.223760, -3.107232},
	{2.081190, -0.010639, -2.935429},
	{2.087016, -0.010054, -2.926670},
	{2.258819, -0.226469, -2.927872},
	{2.081435, -0.223760, -3.107232},
	{2.258819, -0.226469, -2.927872},
	{2.258819, -0.369461, -2.927872},
	{2.081435, -0.591232, -3.107232},
	{2.258819, -0.521298, -2.927872},
	{2.081435, -0.964565, -3.107232},
	{2.081435, -1.309179, -3.107232},
	{2.081435, -0.964565, -3.107232},
	{2.258819, -0.521298, -2.927872},
	{2.258819, -0.860510, -2.927872},
	{2.081435, -1.523168, -3.107232},
	{2.258819, -1.520429, -2.927872},
	{2.089698, -1.691416, -2.935733},
	{2.089698, -1.691416, -2.275813},
	{1.785640, -1.691416, -2.610251},
	{1.446491, -1.691416, -2.935733},
	{1.604195, -1.691416, -2.092115},
	{2.089698, -1.691416, -1.936601},
	{1.446491, -1.691416, -1.641772},
	{2.089698, -1.691416, -1.641772},
	{2.088496, -1.519613, -1.425357},
	{1.337834, -1.519613, -1.425356},
	{0.790289, -1.691416, -2.935733},
	{0.790289, -1.691416, -2.275813},
	{0.572007, -1.519613, -2.165320},
	{0.572007, -1.519613, -2.935487},
	{1.446491, -1.691416, -1.641772},
	{1.522977, -1.691416, -1.860188},
	{2.089698, -1.691416, -1.784764},
	{2.089698, -1.691416, -1.641772},
	{1.522977, -1.691416, -1.860188},
	{2.089698, -1.691416, -1.784764},
	{2.081435, -1.523168, -3.107232},
	{2.258819, -1.520429, -2.927872},
	{2.089698, -1.691416, -2.935733},
	{0.787475, -1.523169, -3.107232},
	{0.790289, -1.691416, -2.935733},
	{0.571060, -1.521966, -2.935429},
	{0.572007, -1.519613, -2.935487},
	{0.790289, -1.691416, -2.935733},
	{0.993712, -1.691416, -2.935733},
	{1.098848, -1.691416, -2.379488},
	{0.790289, -1.691416, -2.275813},
	{1.209709, -1.691416, -2.116352},
	{1.032476, -1.691416, -2.127242},
	{1.181164, -1.691416, -2.000798},
	{1.287126, -1.691416, -1.957209},
	{1.348799, -1.691416, -1.788575},
	{1.304908, -1.691416, -1.854530},
	{1.287126, -1.691416, -1.957209},
	{1.181164, -1.691416, -2.000798},
	{0.787475, -1.523169, -3.107232},
	{0.930467, -1.523168, -3.107232},
	{0.993712, -1.691416, -2.935733},
	{0.790289, -1.691416, -2.935733},
	{1.211046, -1.691416, -2.935733},
	{1.428508, -1.691416, -2.490254},
	{1.399062, -1.691416, -2.104718},
	{1.287126, -1.691416, -1.957209},
	{1.400335, -1.691416, -1.910639},
	{1.395691, -1.691416, -1.718109},
	{1.348799, -1.691416, -1.788575},
	{1.522977, -1.691416, -1.860188},
	{1.446491, -1.691416, -1.641772},
	{1.400335, -1.691416, -1.910639},
	{1.082304, -1.523168, -3.107232},
	{1.211046, -1.691416, -2.935733},
	{0.993712, -1.691416, -2.935733},
	{0.930467, -1.523168, -3.107232},
	{1.421516, -1.523168, -3.107232},
	{1.446491, -1.691416, -2.935733},
	{2.081435, -1.523168, -3.107232},
	{2.089698, -1.691416, -2.935733},
	{1.446491, -1.691416, -2.935733},
	{1.421516, -1.523168, -3.107232},
	{2.258819, -1.520429, -2.284665},
	{2.089698, -1.691416, -2.275813},
	{2.089698, -1.691416, -2.935733},
	{2.258819, -1.520429, -2.927872},
	{2.258819, -0.711939, -1.870650},
	{2.258819, -0.703508, -2.007863},
	{2.258819, -0.551749, -2.101373},
	{2.258819, -0.585495, -2.019338},
	{2.258819, -0.388165, -2.177062},
	{2.258819, -0.439227, -2.143082},
	{2.258819, -0.860510, -1.628463},
	{2.258819, -0.940775, -1.867347},
	{2.258819, -1.520429, -1.628463},
	{2.258819, -1.520429, -1.785952},
	{2.258819, -0.693630, -2.168630},
	{2.258819, -0.512209, -2.197491},
	{2.258819, -0.328337, -2.216875},
	{2.258819, -1.034819, -2.147240},
	{2.258819, -1.520429, -1.970476},
	{2.089698, -1.691416, -1.936601},
	{2.258819, -1.520429, -1.970476},
	{2.258819, -1.520429, -1.785952},
	{2.089698, -1.691416, -1.784764},
	{2.258819, -1.520429, -1.628463},
	{2.089698, -1.691416, -1.641772},
	{2.089698, -1.691416, -1.784764},
	{2.258819, -1.520429, -1.785952},
	{2.089698, -1.691416, -2.275813},
	{2.258819, -1.520429, -2.284665},
	{2.086549, -1.520184, -1.424809},
	{2.089698, -1.691416, -1.641772},
	{2.258819, -1.520429, -1.628463},
	{2.088496, -1.519613, -1.425357},
	{-2.500340, 3.244749, -2.938213},
	{-2.500340, 3.244749, -2.724224},
	{-2.174858, 3.244749, -2.634154},
	{-1.840420, 3.244749, -2.938213},
	{-1.656722, 3.244749, -2.452710},
	{-1.501209, 3.244749, -2.938213},
	{-1.206379, 3.244749, -2.295006},
	{-0.989964, 3.072946, -2.186349},
	{-0.989964, 3.072946, -2.937011},
	{-1.206380, 3.244749, -2.938213},
	{-2.500340, 3.244749, -1.638804},
	{-2.500094, 3.072946, -1.425684},
	{-1.729928, 3.072946, -1.425684},
	{-1.840420, 3.244749, -1.638804},
	{-1.206379, 3.244749, -2.295006},
	{-1.206380, 3.244749, -2.938213},
	{-1.349372, 3.244749, -2.938213},
	{-1.424796, 3.244749, -2.371492},
	{-2.677724, 2.498669, -1.859929},
	{-2.677724, 3.065389, -1.784505},
	{-2.677724, 3.065389, -1.936342},
	{-2.677724, 2.579886, -2.091856},
	{-2.677724, 2.422182, -1.641513},
	{-2.677724, 3.065390, -1.641513},
	{-2.677724, 1.765981, -2.935474},
	{-2.505453, 1.562327, -2.935229},
	{-2.505453, 1.562327, -2.165062},
	{-2.677724, 1.765981, -2.275554},
	{-2.677724, 2.422182, -1.641513},
	{-2.505920, 2.313525, -1.425098},
	{-2.505920, 3.064187, -1.425098},
	{-2.677724, 3.065390, -1.641513},
	{-2.677724, 3.065389, -2.275554},
	{-2.677724, 2.761331, -2.609992},
	{-2.677724, 3.065389, -2.935474},
	{-2.677724, 2.422182, -2.935474},
	{-2.500340, 3.244749, -1.638804},
	{-1.840420, 3.244749, -1.638804},
	{-2.027705, 3.244749, -2.196200},
	{-2.500340, 3.244749, -2.006277},
	{-1.691849, 3.244749, -1.880991},
	{-1.672178, 3.244749, -2.201154},
	{-1.565406, 3.244749, -2.029679},
	{-1.412072, 3.244749, -2.145572},
	{-1.299993, 3.244749, -2.232709},
	{-1.486664, 3.244749, -2.221094},
	{-2.500340, 3.244749, -2.006277},
	{-2.027705, 3.244749, -2.196200},
	{-2.104225, 3.244749, -2.423936},
	{-2.500340, 3.244749, -2.379609},
	{-2.500340, 3.244749, -2.379609},
	{-2.104225, 3.244749, -2.423936},
	{-1.672178, 3.244749, -2.201154},
	{-1.664141, 3.244749, -2.331963},
	{-1.664141, 3.244749, -2.331963},
	{-1.486664, 3.244749, -2.221094},
	{-1.299993, 3.244749, -2.232709},
	{-1.251314, 3.244749, -2.265104},
	{-1.454492, 3.244749, -2.299301},
	{-1.206379, 3.244749, -2.295006},
	{-1.424796, 3.244749, -2.371492},
	{-1.672178, 3.244749, -2.201154},
	{-1.664141, 3.244749, -2.331963},
	{-1.454492, 3.244749, -2.299301},
	{-2.500340, 3.244749, -1.638804},
	{-2.677724, 3.065390, -1.641513},
	{-2.505920, 3.064187, -1.425098},
	{-2.500094, 3.072946, -1.425684},
	{-2.500340, 3.244749, -1.638804},
	{-2.500340, 3.244749, -2.006277},
	{-2.677724, 3.065389, -1.784505},
	{-2.677724, 3.065390, -1.641513},
	{-2.500340, 3.244749, -2.379609},
	{-2.677724, 3.065389, -1.936342},
	{-2.500340, 3.244749, -2.724224},
	{-2.677724, 3.065389, -2.275554},
	{-2.500340, 3.244749, -2.938213},
	{-2.677724, 3.065389, -2.935474},
	{-2.677724, 3.065389, -2.275554},
	{-2.500340, 3.244749, -2.724224},
	{-2.508603, 3.073250, -3.106460},
	{-1.865395, 3.073250, -3.106460},
	{-2.204544, 2.747768, -3.106460},
	{-2.508603, 2.413330, -3.106460},
	{-2.023100, 2.229632, -3.106460},
	{-2.508603, 2.074118, -3.106460},
	{-1.865396, 1.779289, -3.106460},
	{-1.756739, 1.562874, -2.934657},
	{-2.507401, 1.562874, -2.934657},
	{-2.508603, 1.779289, -3.106460},
	{-1.209194, 3.073250, -3.106460},
	{-0.990912, 3.073004, -2.934657},
	{-0.990912, 2.302837, -2.934657},
	{-1.209194, 2.413330, -3.106460},
	{-1.865396, 1.779289, -3.106460},
	{-2.508603, 1.779289, -3.106460},
	{-2.508603, 1.922282, -3.106460},
	{-1.941882, 1.997706, -3.106460},
	{-2.500340, 3.244749, -2.938213},
	{-2.508603, 3.073250, -3.106460},
	{-2.677724, 3.065389, -2.935474},
	{-1.206380, 3.244749, -2.938213},
	{-0.990912, 3.073004, -2.934657},
	{-0.989964, 3.072946, -2.937011},
	{-1.209194, 3.073250, -3.106460},
	{-1.209194, 3.073250, -3.106460},
	{-1.209194, 2.413330, -3.106460},
	{-1.517753, 2.517006, -3.106460},
	{-1.412616, 3.073250, -3.106460},
	{-1.451381, 2.264759, -3.106460},
	{-1.628613, 2.253870, -3.106460},
	{-1.600068, 2.138316, -3.106460},
	{-1.723813, 1.992047, -3.106460},
	{-1.767703, 1.926092, -3.106460},
	{-1.706031, 2.094727, -3.106460},
	{-1.206380, 3.244749, -2.938213},
	{-1.209194, 3.073250, -3.106460},
	{-1.412616, 3.073250, -3.106460},
	{-1.349372, 3.244749, -2.938213},
	{-1.847412, 2.627772, -3.106460},
	{-1.629950, 3.073250, -3.106460},
	{-1.817967, 2.242235, -3.106460},
	{-1.814596, 1.855627, -3.106460},
	{-1.819239, 2.048156, -3.106460},
	{-1.501209, 3.244749, -2.938213},
	{-1.629950, 3.073250, -3.106460},
	{-1.840420, 3.244749, -2.938213},
	{-1.501209, 3.244749, -2.938213},
	{-1.629950, 3.073250, -3.106460},
	{-1.865395, 3.073250, -3.106460},
	{-2.500340, 3.244749, -2.938213},
	{-1.840420, 3.244749, -2.938213},
	{-1.865395, 3.073250, -3.106460},
	{-2.508603, 3.073250, -3.106460},
	{-2.677724, 2.422182, -2.935474},
	{-2.677724, 3.065389, -2.935474},
	{-2.508603, 3.073250, -3.106460},
	{-2.508603, 2.413330, -3.106460},
	{-2.677724, 2.008168, -2.126983},
	{-2.677724, 2.156855, -2.000540},
	{-2.677724, 2.238890, -1.966794},
	{-2.677724, 2.145380, -2.118553},
	{-2.677724, 2.280599, -1.854271},
	{-2.677724, 2.314579, -1.803209},
	{-2.677724, 1.765981, -2.275554},
	{-2.677724, 2.004865, -2.355819},
	{-2.677724, 1.765981, -2.935474},
	{-2.677724, 1.923469, -2.935474},
	{-2.677724, 2.335008, -1.927254},
	{-2.677724, 2.306147, -2.108675},
	{-2.677724, 2.354392, -1.743382},
	{-2.677724, 2.284757, -2.449863},
	{-2.677724, 2.107993, -2.935474},
	{-2.508603, 2.074118, -3.106460},
	{-2.508603, 1.922282, -3.106460},
	{-2.677724, 1.923469, -2.935474},
	{-2.677724, 2.107993, -2.935474},
	{-2.677724, 1.765981, -2.935474},
	{-2.508603, 1.779289, -3.106460},
	{-2.508603, 2.413330, -3.106460},
	{-2.677724, 2.422182, -2.935474},
	{-2.505453, 1.562327, -2.935229},
	{-2.507401, 1.562874, -2.934657},
	{-2.677724, 1.765981, -2.935474},
	{-2.508603, 1.779289, -3.106460},
	{-2.500340, -1.523168, -3.108316},
	{-2.500340, -1.309179, -3.108316},
	{-2.174858, -1.219110, -3.108316},
	{-1.840420, -1.523168, -3.108316},
	{-1.656722, -1.037665, -3.108316},
	{-1.501209, -1.523168, -3.108316},
	{-1.206379, -0.879961, -3.108316},
	{-0.989964, -0.771304, -2.936513},
	{-0.989964, -1.521966, -2.936513},
	{-1.206380, -1.523169, -3.108316},
	{-2.500340, -0.223760, -3.108316},
	{-2.500094, -0.010639, -2.936513},
	{-1.729928, -0.010639, -2.936513},
	{-1.840420, -0.223760, -3.108316},
	{-1.206379, -0.879961, -3.108316},
	{-1.206380, -1.523169, -3.108316},
	{-1.349372, -1.523169, -3.108316},
	{-1.424796, -0.956448, -3.108316},
	{-2.677724, -0.444885, -2.362235},
	{-2.677724, -0.369461, -2.928956},
	{-2.677724, -0.521298, -2.928956},
	{-2.677724, -0.676811, -2.443453},
	{-2.677724, -0.226469, -2.285749},
	{-2.677724, -0.226469, -2.928956},
	{-2.677724, -1.520429, -1.629547},
	{-2.505453, -1.520184, -1.425893},
	{-2.505453, -0.750017, -1.425893},
	{-2.677724, -0.860510, -1.629547},
	{-2.677724, -0.226469, -2.285749},
	{-2.505920, -0.010053, -2.177092},
	{-2.505920, -0.010054, -2.927754},
	{-2.677724, -0.226469, -2.928956},
	{-2.677724, -0.860510, -2.928956},
	{-2.677724, -1.194948, -2.624897},
	{-2.677724, -1.520429, -2.928956},
	{-2.677724, -1.520429, -2.285748},
	{-2.500340, -0.223760, -3.108316},
	{-1.840420, -0.223760, -3.108316},
	{-2.027706, -0.781156, -3.108316},
	{-2.500340, -0.591232, -3.108316},
	{-1.691849, -0.465946, -3.108316},
	{-1.672178, -0.786109, -3.108316},
	{-1.565406, -0.614634, -3.108316},
	{-1.412072, -0.730528, -3.108316},
	{-1.299993, -0.817665, -3.108316},
	{-1.486664, -0.806050, -3.108316},
	{-2.104225, -1.008892, -3.108316},
	{-2.500340, -0.964565, -3.108316},
	{-1.664141, -0.916918, -3.108316},
	{-1.251314, -0.850059, -3.108316},
	{-1.454492, -0.884257, -3.108316},
	{-2.500340, -0.223760, -3.108316},
	{-2.677724, -0.226469, -2.928956},
	{-2.505920, -0.010054, -2.927754},
	{-2.500094, -0.010639, -2.936513},
	{-2.500340, -0.223760, -3.108316},
	{-2.500340, -0.591232, -3.108316},
	{-2.677724, -0.369461, -2.928956},
	{-2.677724, -0.226469, -2.928956},
	{-2.500340, -0.964565, -3.108316},
	{-2.677724, -0.521298, -2.928956},
	{-2.500340, -1.309179, -3.108316},
	{-2.677724, -0.860510, -2.928956},
	{-2.500340, -1.523168, -3.108316},
	{-2.677724, -1.520429, -2.928956},
	{-2.677724, -0.860510, -2.928956},
	{-2.500340, -1.309179, -3.108316},
	{-2.508603, -1.691416, -2.936816},
	{-1.865395, -1.691416, -2.936816},
	{-2.204544, -1.691416, -2.611335},
	{-2.508603, -1.691416, -2.276897},
	{-2.023100, -1.691416, -2.093198},
	{-2.508603, -1.691416, -1.937685},
	{-1.865396, -1.691416, -1.642856},
	{-1.756739, -1.519613, -1.426440},
	{-2.507401, -1.519613, -1.426440},
	{-2.508603, -1.691416, -1.642856},
	{-1.209194, -1.691416, -2.936816},
	{-0.990912, -1.519613, -2.936571},
	{-0.990912, -1.519613, -2.166404},
	{-1.209194, -1.691416, -2.276896},
	{-1.865396, -1.691416, -1.642856},
	{-2.508603, -1.691416, -1.642856},
	{-2.508603, -1.691416, -1.785848},
	{-1.941882, -1.691416, -1.861272},
	{-1.941882, -1.691416, -1.861272},
	{-2.508603, -1.691416, -1.785848},
	{-2.500340, -1.523168, -3.108316},
	{-2.508603, -1.691416, -2.936816},
	{-2.677724, -1.520429, -2.928956},
	{-1.206380, -1.523169, -3.108316},
	{-0.990912, -1.519613, -2.936571},
	{-0.989964, -1.521966, -2.936513},
	{-1.209194, -1.691416, -2.936816},
	{-1.209194, -1.691416, -2.936816},
	{-1.209194, -1.691416, -2.276896},
	{-1.517753, -1.691416, -2.380572},
	{-1.412616, -1.691416, -2.936816},
	{-1.451380, -1.691416, -2.128325},
	{-1.628613, -1.691416, -2.117436},
	{-1.600068, -1.691416, -2.001882},
	{-1.723813, -1.691416, -1.855614},
	{-1.767703, -1.691416, -1.789659},
	{-1.706031, -1.691416, -1.958293},
	{-1.600068, -1.691416, -2.001882},
	{-1.706031, -1.691416, -1.958293},
	{-1.206380, -1.523169, -3.108316},
	{-1.209194, -1.691416, -2.936816},
	{-1.412616, -1.691416, -2.936816},
	{-1.349372, -1.523169, -3.108316},
	{-1.847412, -1.691416, -2.491338},
	{-1.629950, -1.691416, -2.936816},
	{-1.817967, -1.691416, -2.105802},
	{-1.706031, -1.691416, -1.958293},
	{-1.767703, -1.691416, -1.789659},
	{-1.814595, -1.691416, -1.719193},
	{-1.819239, -1.691416, -1.911723},
	{-1.865396, -1.691416, -1.642856},
	{-1.941882, -1.691416, -1.861272},
	{-1.819239, -1.691416, -1.911723},
	{-1.501209, -1.523168, -3.108316},
	{-1.349372, -1.523169, -3.108316},
	{-1.412616, -1.691416, -2.936816},
	{-1.629950, -1.691416, -2.936816},
	{-1.840420, -1.523168, -3.108316},
	{-1.501209, -1.523168, -3.108316},
	{-1.629950, -1.691416, -2.936816},
	{-1.865395, -1.691416, -2.936816},
	{-2.500340, -1.523168, -3.108316},
	{-1.840420, -1.523168, -3.108316},
	{-1.865395, -1.691416, -2.936816},
	{-2.508603, -1.691416, -2.936816},
	{-2.677724, -1.520429, -2.285748},
	{-2.677724, -1.520429, -2.928956},
	{-2.508603, -1.691416, -2.936816},
	{-2.508603, -1.691416, -2.276897},
	{-2.677724, -0.711939, -1.871734},
	{-2.677724, -0.585495, -2.020422},
	{-2.677724, -0.551749, -2.102457},
	{-2.677724, -0.703508, -2.008946},
	{-2.677724, -0.439227, -2.144166},
	{-2.677724, -0.388165, -2.178146},
	{-2.677724, -0.860510, -1.629547},
	{-2.677724, -0.940775, -1.868431},
	{-2.677724, -1.520429, -1.629547},
	{-2.677724, -1.520429, -1.787036},
	{-2.677724, -0.512209, -2.198575},
	{-2.677724, -0.693630, -2.169713},
	{-2.677724, -0.328337, -2.217959},
	{-2.677724, -1.034819, -2.148324},
	{-2.677724, -1.520429, -1.971559},
	{-2.508603, -1.691416, -1.937685},
	{-2.508603, -1.691416, -1.785848},
	{-2.677724, -1.520429, -1.787036},
	{-2.677724, -1.520429, -1.971559},
	{-2.677724, -1.520429, -1.629547},
	{-2.677724, -1.520429, -1.787036},
	{-2.508603, -1.691416, -1.785848},
	{-2.508603, -1.691416, -1.642856},
	{-2.508603, -1.691416, -2.276897},
	{-2.677724, -1.520429, -2.285748},
	{-2.505453, -1.520184, -1.425893},
	{-2.507401, -1.519613, -1.426440},
	{-2.677724, -1.520429, -1.629547},
	{-2.508603, -1.691416, -1.642856},
	{-2.501356, 3.245014, 1.660019},
	{-1.841437, 3.245014, 1.660019},
	{-2.175874, 3.245014, 1.355960},
	{-2.501356, 3.245014, 1.446030},
	{-1.657738, 3.245014, 1.174516},
	{-1.502225, 3.245014, 1.660019},
	{-1.207395, 3.245014, 1.016812},
	{-1.207396, 3.245014, 1.660019},
	{-0.990980, 3.073211, 1.658817},
	{-0.990980, 3.073211, 0.908155},
	{-2.501356, 3.245014, 0.360610},
	{-1.841436, 3.245014, 0.360610},
	{-1.730944, 3.073211, 0.147490},
	{-2.501110, 3.073211, 0.147490},
	{-1.207395, 3.245014, 1.016812},
	{-1.425812, 3.245014, 1.093298},
	{-1.350388, 3.245014, 1.660019},
	{-1.207396, 3.245014, 1.660019},
	{-2.678739, 2.498934, 0.581735},
	{-2.678740, 2.580151, 0.813662},
	{-2.678740, 3.065655, 0.658148},
	{-2.678739, 3.065655, 0.506311},
	{-2.678740, 2.422447, 0.363319},
	{-2.678739, 2.498934, 0.581735},
	{-2.678739, 3.065655, 0.506311},
	{-2.678740, 3.065655, 0.363319},
	{-2.678740, 1.766246, 1.657280},
	{-2.678740, 1.766246, 0.997360},
	{-2.506469, 1.562592, 0.886868},
	{-2.506469, 1.562592, 1.657034},
	{-2.678740, 2.422447, 0.363319},
	{-2.678740, 3.065655, 0.363319},
	{-2.506937, 3.064452, 0.146904},
	{-2.506937, 2.313791, 0.146904},
	{-2.678740, 2.580151, 0.813662},
	{-2.678740, 2.761596, 1.331798},
	{-2.678740, 3.065654, 0.997360},
	{-2.678740, 3.065655, 0.658148},
	{-2.678740, 3.065654, 1.657280},
	{-2.678740, 2.422447, 1.657280},
	{-2.501356, 3.245014, 0.360610},
	{-2.501356, 3.245014, 0.728083},
	{-2.028722, 3.245014, 0.918006},
	{-1.841436, 3.245014, 0.360610},
	{-1.673194, 3.245014, 0.922960},
	{-1.692865, 3.245014, 0.602797},
	{-1.566422, 3.245014, 0.751485},
	{-1.487680, 3.245014, 0.942900},
	{-1.301009, 3.245014, 0.954516},
	{-1.413088, 3.245014, 0.867378},
	{-2.501356, 3.245014, 0.728083},
	{-2.501356, 3.245014, 1.101415},
	{-2.105241, 3.245014, 1.145743},
	{-2.028722, 3.245014, 0.918006},
	{-2.501356, 3.245014, 1.101415},
	{-2.105241, 3.245014, 1.145743},
	{-1.665157, 3.245014, 1.053769},
	{-1.673194, 3.245014, 0.922960},
	{-1.665157, 3.245014, 1.053769},
	{-1.487680, 3.245014, 0.942900},
	{-1.455508, 3.245014, 1.021107},
	{-1.252330, 3.245014, 0.986910},
	{-1.301009, 3.245014, 0.954516},
	{-1.425812, 3.245014, 1.093298},
	{-1.207395, 3.245014, 1.016812},
	{-1.673194, 3.245014, 0.922960},
	{-1.665157, 3.245014, 1.053769},
	{-1.455508, 3.245014, 1.021107},
	{-2.501356, 3.245014, 0.360610},
	{-2.501110, 3.073211, 0.147490},
	{-2.506937, 3.064452, 0.146904},
	{-2.678740, 3.065655, 0.363319},
	{-2.501356, 3.245014, 0.360610},
	{-2.678740, 3.065655, 0.363319},
	{-2.678739, 3.065655, 0.506311},
	{-2.501356, 3.245014, 0.728083},
	{-2.678739, 3.065655, 0.506311},
	{-2.678740, 3.065655, 0.658148},
	{-2.501356, 3.245014, 1.101415},
	{-2.501356, 3.245014, 0.728083},
	{-2.501356, 3.245014, 1.446030},
	{-2.501356, 3.245014, 1.101415},
	{-2.678740, 3.065655, 0.658148},
	{-2.678740, 3.065654, 0.997360},
	{-2.501356, 3.245014, 1.660019},
	{-2.678740, 3.065654, 1.657280},
	{-2.509619, 3.073515, 1.828266},
	{-2.509619, 2.413595, 1.828266},
	{-2.205560, 2.748034, 1.828266},
	{-1.866412, 3.073515, 1.828266},
	{-2.024116, 2.229897, 1.828266},
	{-2.509619, 2.074384, 1.828266},
	{-1.866412, 1.779554, 1.828267},
	{-2.509619, 1.779554, 1.828267},
	{-2.508416, 1.563139, 1.656463},
	{-1.757755, 1.563139, 1.656463},
	{-1.210210, 3.073515, 1.828266},
	{-1.210210, 2.413595, 1.828266},
	{-0.991928, 2.303102, 1.656463},
	{-0.991928, 3.073269, 1.656463},
	{-1.866412, 1.779554, 1.828267},
	{-1.942898, 1.997971, 1.828266},
	{-2.509619, 1.922547, 1.828266},
	{-2.509619, 1.779554, 1.828267},
	{-1.942898, 1.997971, 1.828266},
	{-2.509619, 1.922547, 1.828266},
	{-2.501356, 3.245014, 1.660019},
	{-2.678740, 3.065654, 1.657280},
	{-2.509619, 3.073515, 1.828266},
	{-1.207396, 3.245014, 1.660019},
	{-1.210210, 3.073515, 1.828266},
	{-0.990980, 3.073211, 1.658817},
	{-0.991928, 3.073269, 1.656463},
	{-1.210210, 3.073515, 1.828266},
	{-1.413633, 3.073515, 1.828266},
	{-1.518769, 2.517271, 1.828266},
	{-1.210210, 2.413595, 1.828266},
	{-1.629630, 2.254135, 1.828266},
	{-1.452397, 2.265024, 1.828266},
	{-1.601085, 2.138581, 1.828266},
	{-1.707047, 2.094992, 1.828266},
	{-1.768720, 1.926357, 1.828267},
	{-1.724829, 1.992312, 1.828266},
	{-1.707047, 2.094992, 1.828266},
	{-1.601085, 2.138581, 1.828266},
	{-1.207396, 3.245014, 1.660019},
	{-1.350388, 3.245014, 1.660019},
	{-1.413633, 3.073515, 1.828266},
	{-1.210210, 3.073515, 1.828266},
	{-1.630967, 3.073515, 1.828266},
	{-1.848429, 2.628037, 1.828266},
	{-1.818983, 2.242501, 1.828266},
	{-1.707047, 2.094992, 1.828266},
	{-1.820256, 2.048422, 1.828266},
	{-1.815612, 1.855892, 1.828267},
	{-1.768720, 1.926357, 1.828267},
	{-1.820256, 2.048422, 1.828266},
	{-1.942898, 1.997971, 1.828266},
	{-1.866412, 1.779554, 1.828267},
	{-1.815612, 1.855892, 1.828267},
	{-1.820256, 2.048422, 1.828266},
	{-1.502225, 3.245014, 1.660019},
	{-1.630967, 3.073515, 1.828266},
	{-1.841437, 3.245014, 1.660019},
	{-1.866412, 3.073515, 1.828266},
	{-2.501356, 3.245014, 1.660019},
	{-2.509619, 3.073515, 1.828266},
	{-2.678740, 2.422447, 1.657280},
	{-2.509619, 2.413595, 1.828266},
	{-2.509619, 3.073515, 1.828266},
	{-2.678740, 3.065654, 1.657280},
	{-2.678740, 2.008433, 0.848789},
	{-2.678740, 2.145645, 0.840359},
	{-2.678740, 2.239156, 0.688599},
	{-2.678740, 2.157120, 0.722346},
	{-2.678740, 2.157120, 0.722346},
	{-2.678740, 2.239156, 0.688599},
	{-2.678739, 2.314844, 0.525015},
	{-2.678739, 2.280864, 0.576077},
	{-2.678740, 1.766246, 0.997360},
	{-2.678740, 2.005130, 1.077625},
	{-2.678740, 1.766246, 1.657280},
	{-2.678740, 1.923734, 1.657280},
	{-2.678740, 2.145645, 0.840359},
	{-2.678740, 2.306412, 0.830481},
	{-2.678739, 2.335274, 0.649060},
	{-2.678740, 2.239156, 0.688599},
	{-2.678740, 2.306412, 0.830481},
	{-2.678740, 2.580151, 0.813662},
	{-2.678739, 2.498934, 0.581735},
	{-2.678739, 2.335274, 0.649060},
	{-2.678740, 2.239156, 0.688599},
	{-2.678739, 2.335274, 0.649060},
	{-2.678739, 2.354657, 0.465188},
	{-2.678739, 2.314844, 0.525015},
	{-2.678739, 2.335274, 0.649060},
	{-2.678739, 2.498934, 0.581735},
	{-2.678740, 2.422447, 0.363319},
	{-2.678739, 2.354657, 0.465188},
	{-2.678740, 2.285022, 1.171669},
	{-2.678740, 2.306412, 0.830481},
	{-2.678740, 2.108258, 1.657280},
	{-2.509619, 2.074384, 1.828266},
	{-2.678740, 2.108258, 1.657280},
	{-2.678740, 1.923734, 1.657280},
	{-2.509619, 1.922547, 1.828266},
	{-2.678740, 1.766246, 1.657280},
	{-2.509619, 1.779554, 1.828267},
	{-2.509619, 1.922547, 1.828266},
	{-2.678740, 1.923734, 1.657280},
	{-2.509619, 2.413595, 1.828266},
	{-2.678740, 2.422447, 1.657280},
	{-2.506469, 1.562592, 1.657034},
	{-2.509619, 1.779554, 1.828267},
	{-2.678740, 1.766246, 1.657280},
	{-2.508416, 1.563139, 1.656463},
	{-2.501356, -1.522903, 1.827472},
	{-1.841436, -1.522903, 1.827472},
	{-2.175874, -1.218844, 1.827472},
	{-2.501356, -1.308914, 1.827472},
	{-1.657738, -1.037400, 1.827472},
	{-1.502225, -1.522903, 1.827472},
	{-1.207395, -0.879696, 1.827472},
	{-1.207396, -1.522903, 1.827472},
	{-0.990980, -1.521701, 1.655669},
	{-0.990980, -0.771039, 1.655669},
	{-2.501356, -0.223494, 1.827472},
	{-1.841436, -0.223494, 1.827472},
	{-1.730944, -0.010374, 1.655668},
	{-2.501110, -0.010374, 1.655668},
	{-1.207395, -0.879696, 1.827472},
	{-1.425812, -0.956182, 1.827472},
	{-1.350388, -1.522903, 1.827472},
	{-1.207396, -1.522903, 1.827472},
	{-2.678740, -0.444620, 1.081391},
	{-2.678740, -0.676546, 1.162608},
	{-2.678740, -0.521033, 1.648112},
	{-2.678740, -0.369196, 1.648112},
	{-2.678740, -0.226204, 1.004904},
	{-2.678740, -0.226204, 1.648112},
	{-2.678739, -1.520164, 0.348703},
	{-2.678739, -0.860244, 0.348703},
	{-2.506469, -0.749752, 0.145049},
	{-2.506469, -1.519919, 0.145049},
	{-2.678740, -0.226204, 1.004904},
	{-2.678740, -0.226204, 1.648112},
	{-2.506936, -0.009788, 1.646909},
	{-2.506937, -0.009788, 0.896247},
	{-2.678740, -1.194683, 1.344053},
	{-2.678740, -0.860244, 1.648112},
	{-2.678740, -1.520164, 1.648111},
	{-2.678740, -1.520164, 1.004904},
	{-2.501356, -0.223494, 1.827472},
	{-2.501356, -0.590967, 1.827472},
	{-2.028722, -0.780890, 1.827472},
	{-1.841436, -0.223494, 1.827472},
	{-1.673194, -0.785844, 1.827472},
	{-1.692865, -0.465681, 1.827472},
	{-1.566422, -0.614369, 1.827472},
	{-1.487680, -0.805785, 1.827472},
	{-1.301009, -0.817400, 1.827472},
	{-1.413088, -0.730262, 1.827472},
	{-2.501356, -0.964299, 1.827472},
	{-2.105241, -1.008627, 1.827472},
	{-1.665157, -0.916653, 1.827472},
	{-1.455508, -0.883991, 1.827472},
	{-1.252330, -0.849794, 1.827472},
	{-2.501356, -0.223494, 1.827472},
	{-2.501110, -0.010374, 1.655668},
	{-2.506936, -0.009788, 1.646909},
	{-2.678740, -0.226204, 1.648112},
	{-2.501356, -0.223494, 1.827472},
	{-2.678740, -0.226204, 1.648112},
	{-2.678740, -0.369196, 1.648112},
	{-2.501356, -0.590967, 1.827472},
	{-2.678740, -0.521033, 1.648112},
	{-2.501356, -0.964299, 1.827472},
	{-2.501356, -1.308914, 1.827472},
	{-2.678740, -0.860244, 1.648112},
	{-2.501356, -1.522903, 1.827472},
	{-2.501356, -1.308914, 1.827472},
	{-2.678740, -0.860244, 1.648112},
	{-2.678740, -1.520164, 1.648111},
	{-2.509619, -1.691150, 1.655972},
	{-2.509619, -1.691150, 0.996052},
	{-2.205560, -1.691150, 1.330490},
	{-1.866411, -1.691150, 1.655972},
	{-2.024116, -1.691150, 0.812354},
	{-2.509619, -1.691150, 0.656841},
	{-1.866412, -1.691151, 0.362011},
	{-2.509619, -1.691151, 0.362011},
	{-2.508416, -1.519348, 0.145596},
	{-1.757755, -1.519348, 0.145596},
	{-1.210210, -1.691150, 1.655972},
	{-1.210210, -1.691150, 0.996052},
	{-0.991928, -1.519347, 0.885560},
	{-0.991928, -1.519347, 1.655727},
	{-1.866412, -1.691151, 0.362011},
	{-1.942898, -1.691150, 0.580428},
	{-2.509619, -1.691150, 0.505004},
	{-2.509619, -1.691151, 0.362011},
	{-1.942898, -1.691150, 0.580428},
	{-2.509619, -1.691150, 0.505004},
	{-2.501356, -1.522903, 1.827472},
	{-2.678740, -1.520164, 1.648111},
	{-2.509619, -1.691150, 1.655972},
	{-1.207396, -1.522903, 1.827472},
	{-1.210210, -1.691150, 1.655972},
	{-0.990980, -1.521701, 1.655669},
	{-0.991928, -1.519347, 1.655727},
	{-1.210210, -1.691150, 1.655972},
	{-1.413633, -1.691150, 1.655972},
	{-1.518769, -1.691150, 1.099728},
	{-1.210210, -1.691150, 0.996052},
	{-1.629630, -1.691150, 0.836592},
	{-1.452397, -1.691150, 0.847481},
	{-1.601084, -1.691150, 0.721038},
	{-1.707047, -1.691150, 0.677449},
	{-1.768719, -1.691151, 0.508814},
	{-1.724829, -1.691150, 0.574769},
	{-1.707047, -1.691150, 0.677449},
	{-1.601084, -1.691150, 0.721038},
	{-1.207396, -1.522903, 1.827472},
	{-1.350388, -1.522903, 1.827472},
	{-1.413633, -1.691150, 1.655972},
	{-1.210210, -1.691150, 1.655972},
	{-1.630966, -1.691150, 1.655972},
	{-1.848429, -1.691150, 1.210494},
	{-1.818983, -1.691150, 0.824958},
	{-1.707047, -1.691150, 0.677449},
	{-1.820255, -1.691150, 0.630879},
	{-1.815612, -1.691151, 0.438349},
	{-1.768719, -1.691151, 0.508814},
	{-1.942898, -1.691150, 0.580428},
	{-1.866412, -1.691151, 0.362011},
	{-1.820255, -1.691150, 0.630879},
	{-1.502225, -1.522903, 1.827472},
	{-1.630966, -1.691150, 1.655972},
	{-1.841436, -1.522903, 1.827472},
	{-1.866411, -1.691150, 1.655972},
	{-2.501356, -1.522903, 1.827472},
	{-2.509619, -1.691150, 1.655972},
	{-2.678740, -1.520164, 1.004904},
	{-2.509619, -1.691150, 0.996052},
	{-2.509619, -1.691150, 1.655972},
	{-2.678740, -1.520164, 1.648111},
	{-2.678739, -0.711673, 0.590889},
	{-2.678740, -0.703243, 0.728102},
	{-2.678740, -0.551484, 0.821612},
	{-2.678740, -0.585230, 0.739577},
	{-2.678740, -0.585230, 0.739577},
	{-2.678740, -0.551484, 0.821612},
	{-2.678740, -0.387900, 0.897301},
	{-2.678740, -0.438962, 0.863321},
	{-2.678739, -0.860244, 0.348703},
	{-2.678739, -0.940509, 0.587587},
	{-2.678740, -0.703243, 0.728102},
	{-2.678739, -0.711673, 0.590889},
	{-2.678739, -1.520164, 0.348703},
	{-2.678739, -1.520164, 0.506191},
	{-2.678739, -0.940509, 0.587587},
	{-2.678739, -0.860244, 0.348703},
	{-2.678740, -0.703243, 0.728102},
	{-2.678740, -0.693365, 0.888869},
	{-2.678740, -0.511944, 0.917731},
	{-2.678740, -0.328072, 0.937115},
	{-2.678739, -0.940509, 0.587587},
	{-2.678740, -1.034554, 0.867479},
	{-2.678740, -0.693365, 0.888869},
	{-2.678740, -0.703243, 0.728102},
	{-2.678740, -1.034554, 0.867479},
	{-2.678739, -1.520164, 0.506191},
	{-2.678740, -1.520164, 0.690715},
	{-2.678740, -1.034554, 0.867479},
	{-2.678739, -0.940509, 0.587587},
	{-2.678740, -1.520164, 0.690715},
	{-2.509619, -1.691150, 0.656841},
	{-2.678740, -1.520164, 0.690715},
	{-2.678739, -1.520164, 0.506191},
	{-2.509619, -1.691150, 0.505004},
	{-2.678739, -1.520164, 0.348703},
	{-2.509619, -1.691151, 0.362011},
	{-2.509619, -1.691150, 0.505004},
	{-2.678739, -1.520164, 0.506191},
	{-2.509619, -1.691150, 0.996052},
	{-2.678740, -1.520164, 1.004904},
	{-2.678740, -1.520164, 0.690715},
	{-2.509619, -1.691150, 0.656841},
	{-2.506469, -1.519919, 0.145049},
	{-2.509619, -1.691151, 0.362011},
	{-2.678739, -1.520164, 0.348703},
	{-2.508416, -1.519348, 0.145596},
	{2.080420, 3.245014, 1.658453},
	{2.080420, 3.245014, 1.444464},
	{1.754938, 3.245014, 1.354394},
	{1.420500, 3.245014, 1.658453},
	{1.236801, 3.245014, 1.172950},
	{1.081288, 3.245014, 1.658453},
	{0.786459, 3.245014, 1.015246},
	{0.570043, 3.073211, 0.906589},
	{0.570044, 3.073211, 1.657251},
	{0.786459, 3.245014, 1.658453},
	{2.080420, 3.245014, 0.359044},
	{2.080173, 3.073211, 0.145924},
	{1.310007, 3.073211, 0.145924},
	{1.420499, 3.245014, 0.359044},
	{0.786459, 3.245014, 1.015246},
	{0.786459, 3.245014, 1.658453},
	{0.929451, 3.245014, 1.658453},
	{1.004875, 3.245014, 1.091732},
	{2.257803, 2.498934, 0.580169},
	{2.257803, 3.065655, 0.504745},
	{2.257802, 3.065655, 0.656582},
	{2.257802, 2.580151, 0.812096},
	{2.257803, 2.422447, 0.361753},
	{2.257803, 3.065655, 0.361753},
	{2.257803, 3.065655, 0.504745},
	{2.257803, 2.498934, 0.580169},
	{2.257802, 1.766246, 1.655714},
	{2.085533, 1.562592, 1.655468},
	{2.085533, 1.562592, 0.885302},
	{2.257802, 1.766246, 0.995794},
	{2.257803, 2.422447, 0.361753},
	{2.086000, 2.313791, 0.145338},
	{2.086000, 3.064452, 0.145338},
	{2.257803, 3.065655, 0.361753},
	{2.257802, 2.580151, 0.812096},
	{2.257802, 3.065655, 0.656582},
	{2.257802, 3.065654, 0.995794},
	{2.257802, 2.761596, 1.330232},
	{2.257802, 3.065654, 1.655714},
	{2.257802, 2.422447, 1.655714},
	{2.080420, 3.245014, 0.359044},
	{1.420499, 3.245014, 0.359044},
	{1.607785, 3.245014, 0.916440},
	{2.080420, 3.245014, 0.726517},
	{1.271928, 3.245014, 0.601230},
	{1.252257, 3.245014, 0.921393},
	{1.145485, 3.245014, 0.749919},
	{0.992151, 3.245014, 0.865812},
	{0.880072, 3.245014, 0.952949},
	{1.066744, 3.245014, 0.941334},
	{2.080420, 3.245014, 0.726517},
	{1.607785, 3.245014, 0.916440},
	{1.684304, 3.245014, 1.144176},
	{2.080420, 3.245014, 1.099849},
	{2.080420, 3.245014, 1.099849},
	{1.684304, 3.245014, 1.144176},
	{1.252257, 3.245014, 0.921393},
	{1.244220, 3.245014, 1.052202},
	{1.244220, 3.245014, 1.052202},
	{1.066744, 3.245014, 0.941334},
	{0.880072, 3.245014, 0.952949},
	{0.831393, 3.245014, 0.985343},
	{1.034572, 3.245014, 1.019541},
	{0.786459, 3.245014, 1.015246},
	{1.004875, 3.245014, 1.091732},
	{1.252257, 3.245014, 0.921393},
	{1.244220, 3.245014, 1.052202},
	{1.034572, 3.245014, 1.019541},
	{2.080420, 3.245014, 0.359044},
	{2.257803, 3.065655, 0.361753},
	{2.086000, 3.064452, 0.145338},
	{2.080173, 3.073211, 0.145924},
	{2.080420, 3.245014, 0.359044},
	{2.080420, 3.245014, 0.726517},
	{2.257803, 3.065655, 0.504745},
	{2.257803, 3.065655, 0.361753},
	{2.257803, 3.065655, 0.504745},
	{2.080420, 3.245014, 0.726517},
	{2.080420, 3.245014, 1.099849},
	{2.257802, 3.065655, 0.656582},
	{2.080420, 3.245014, 1.444464},
	{2.257802, 3.065654, 0.995794},
	{2.257802, 3.065655, 0.656582},
	{2.080420, 3.245014, 1.099849},
	{2.080420, 3.245014, 1.658453},
	{2.257802, 3.065654, 1.655714},
	{2.088682, 3.073515, 1.826700},
	{1.445475, 3.073515, 1.826700},
	{1.784624, 2.748034, 1.826700},
	{2.088682, 2.413595, 1.826700},
	{1.603179, 2.229897, 1.826700},
	{2.088682, 2.074384, 1.826700},
	{1.445475, 1.779554, 1.826700},
	{1.336818, 1.563139, 1.654897},
	{2.087480, 1.563139, 1.654897},
	{2.088682, 1.779554, 1.826700},
	{0.789273, 3.073515, 1.826700},
	{0.570991, 3.073269, 1.654897},
	{0.570991, 2.303102, 1.654897},
	{0.789273, 2.413595, 1.826700},
	{1.445475, 1.779554, 1.826700},
	{2.088682, 1.779554, 1.826700},
	{2.088682, 1.922547, 1.826700},
	{1.521961, 1.997971, 1.826700},
	{2.080420, 3.245014, 1.658453},
	{2.088682, 3.073515, 1.826700},
	{2.257802, 3.065654, 1.655714},
	{0.786459, 3.245014, 1.658453},
	{0.570991, 3.073269, 1.654897},
	{0.570044, 3.073211, 1.657251},
	{0.789273, 3.073515, 1.826700},
	{0.789273, 3.073515, 1.826700},
	{0.789273, 2.413595, 1.826700},
	{1.097832, 2.517271, 1.826700},
	{0.992696, 3.073515, 1.826700},
	{1.031460, 2.265024, 1.826700},
	{1.208693, 2.254135, 1.826700},
	{1.180148, 2.138581, 1.826700},
	{1.303892, 1.992312, 1.826700},
	{1.347783, 1.926357, 1.826700},
	{1.286110, 2.094992, 1.826700},
	{0.786459, 3.245014, 1.658453},
	{0.789273, 3.073515, 1.826700},
	{0.992696, 3.073515, 1.826700},
	{0.929451, 3.245014, 1.658453},
	{1.427492, 2.628037, 1.826700},
	{1.210030, 3.073515, 1.826700},
	{1.398046, 2.242501, 1.826700},
	{1.394675, 1.855892, 1.826700},
	{1.399319, 2.048422, 1.826700},
	{1.081288, 3.245014, 1.658453},
	{0.929451, 3.245014, 1.658453},
	{0.992696, 3.073515, 1.826700},
	{1.210030, 3.073515, 1.826700},
	{1.420500, 3.245014, 1.658453},
	{1.445475, 3.073515, 1.826700},
	{2.080420, 3.245014, 1.658453},
	{2.088682, 3.073515, 1.826700},
	{2.257802, 2.422447, 1.655714},
	{2.257802, 3.065654, 1.655714},
	{2.088682, 3.073515, 1.826700},
	{2.088682, 2.413595, 1.826700},
	{2.257802, 2.008433, 0.847223},
	{2.257802, 2.157120, 0.720780},
	{2.257802, 2.239156, 0.687033},
	{2.257802, 2.145645, 0.838793},
	{2.257802, 2.157120, 0.720780},
	{2.257803, 2.280864, 0.574511},
	{2.257803, 2.314844, 0.523449},
	{2.257802, 2.239156, 0.687033},
	{2.257802, 1.766246, 0.995794},
	{2.257802, 2.005130, 1.076059},
	{2.257802, 1.766246, 1.655714},
	{2.257802, 1.923734, 1.655714},
	{2.257802, 2.145645, 0.838793},
	{2.257802, 2.239156, 0.687033},
	{2.257803, 2.335274, 0.647494},
	{2.257802, 2.306412, 0.828915},
	{2.257802, 2.306412, 0.828915},
	{2.257803, 2.335274, 0.647494},
	{2.257803, 2.498934, 0.580169},
	{2.257802, 2.580151, 0.812096},
	{2.257802, 2.239156, 0.687033},
	{2.257803, 2.314844, 0.523449},
	{2.257803, 2.354657, 0.463622},
	{2.257803, 2.335274, 0.647494},
	{2.257803, 2.335274, 0.647494},
	{2.257803, 2.354657, 0.463622},
	{2.257802, 2.306412, 0.828915},
	{2.257802, 2.285022, 1.170103},
	{2.257802, 2.108258, 1.655714},
	{2.088682, 2.074384, 1.826700},
	{2.088682, 1.922547, 1.826700},
	{2.257802, 1.923734, 1.655714},
	{2.257802, 2.108258, 1.655714},
	{2.257802, 1.766246, 1.655714},
	{2.088682, 1.779554, 1.826700},
	{2.088682, 2.413595, 1.826700},
	{2.257802, 2.422447, 1.655714},
	{2.085533, 1.562592, 1.655468},
	{2.087480, 1.563139, 1.654897},
	{2.257802, 1.766246, 1.655714},
	{2.088682, 1.779554, 1.826700},
	{2.080420, -1.522903, 1.828556},
	{2.080420, -1.308914, 1.828556},
	{1.754938, -1.218845, 1.828556},
	{1.420500, -1.522903, 1.828556},
	{1.236801, -1.037400, 1.828556},
	{1.081288, -1.522903, 1.828556},
	{0.786459, -0.879696, 1.828556},
	{0.570043, -0.771039, 1.656753},
	{0.570044, -1.521701, 1.656753},
	{0.786459, -1.522904, 1.828556},
	{2.080420, -0.223494, 1.828556},
	{2.080174, -0.010374, 1.656753},
	{1.310007, -0.010374, 1.656753},
	{1.420499, -0.223494, 1.828556},
	{0.786459, -0.879696, 1.828556},
	{0.786459, -1.522904, 1.828556},
	{0.929451, -1.522903, 1.828556},
	{1.004875, -0.956182, 1.828556},
	{2.257802, -0.444620, 1.082475},
	{2.257802, -0.369196, 1.649196},
	{2.257802, -0.521033, 1.649196},
	{2.257802, -0.676546, 1.163693},
	{2.257802, -0.226204, 1.005988},
	{2.257802, -0.226204, 1.649196},
	{2.257803, -1.520164, 0.349787},
	{2.085533, -1.519919, 0.146133},
	{2.085533, -0.749752, 0.146133},
	{2.257803, -0.860244, 0.349787},
	{2.257802, -0.226204, 1.005988},
	{2.085999, -0.009788, 0.897332},
	{2.085999, -0.009788, 1.647993},
	{2.257802, -0.226204, 1.649196},
	{2.257802, -0.860244, 1.649196},
	{2.257802, -1.194683, 1.345137},
	{2.257802, -1.520164, 1.649195},
	{2.257802, -1.520164, 1.005988},
	{2.080420, -0.223494, 1.828556},
	{1.420499, -0.223494, 1.828556},
	{1.607785, -0.780890, 1.828556},
	{2.080420, -0.590967, 1.828556},
	{1.271929, -0.465681, 1.828556},
	{1.252257, -0.785844, 1.828556},
	{1.145486, -0.614369, 1.828556},
	{0.992151, -0.730262, 1.828556},
	{0.880072, -0.817400, 1.828556},
	{1.066744, -0.805785, 1.828556},
	{1.684304, -1.008627, 1.828556},
	{2.080420, -0.964299, 1.828556},
	{1.244220, -0.916653, 1.828556},
	{0.831393, -0.849794, 1.828556},
	{1.034572, -0.883991, 1.828556},
	{2.080420, -0.223494, 1.828556},
	{2.257802, -0.226204, 1.649196},
	{2.085999, -0.009788, 1.647993},
	{2.080174, -0.010374, 1.656753},
	{2.080420, -0.223494, 1.828556},
	{2.080420, -0.590967, 1.828556},
	{2.257802, -0.369196, 1.649196},
	{2.257802, -0.226204, 1.649196},
	{2.080420, -0.964299, 1.828556},
	{2.257802, -0.521033, 1.649196},
	{2.080420, -1.308914, 1.828556},
	{2.257802, -0.860244, 1.649196},
	{2.257802, -0.521033, 1.649196},
	{2.080420, -0.964299, 1.828556},
	{2.080420, -1.522903, 1.828556},
	{2.257802, -1.520164, 1.649195},
	{2.088682, -1.691150, 1.657057},
	{1.445475, -1.691150, 1.657056},
	{1.784624, -1.691150, 1.331574},
	{2.088682, -1.691150, 0.997136},
	{1.603179, -1.691150, 0.813438},
	{2.088682, -1.691150, 0.657925},
	{1.445475, -1.691151, 0.363095},
	{1.336818, -1.519348, 0.146680},
	{2.087480, -1.519348, 0.146680},
	{2.088682, -1.691151, 0.363096},
	{0.789273, -1.691150, 1.657056},
	{0.570991, -1.519347, 1.656811},
	{0.570991, -1.519347, 0.886644},
	{0.789273, -1.691150, 0.997136},
	{1.445475, -1.691151, 0.363095},
	{2.088682, -1.691151, 0.363096},
	{2.088682, -1.691150, 0.506088},
	{1.521961, -1.691150, 0.581512},
	{1.521961, -1.691150, 0.581512},
	{2.088682, -1.691150, 0.506088},
	{2.080420, -1.522903, 1.828556},
	{2.088682, -1.691150, 1.657057},
	{2.257802, -1.520164, 1.649195},
	{0.786459, -1.522904, 1.828556},
	{0.570991, -1.519347, 1.656811},
	{0.570044, -1.521701, 1.656753},
	{0.789273, -1.691150, 1.657056},
	{0.789273, -1.691150, 1.657056},
	{0.789273, -1.691150, 0.997136},
	{1.097832, -1.691150, 1.100812},
	{0.992696, -1.691150, 1.657056},
	{1.031460, -1.691150, 0.848565},
	{1.208693, -1.691150, 0.837676},
	{1.180148, -1.691150, 0.722122},
	{1.303892, -1.691150, 0.575853},
	{1.347783, -1.691151, 0.509898},
	{1.286110, -1.691150, 0.678533},
	{1.180148, -1.691150, 0.722122},
	{1.286110, -1.691150, 0.678533},
	{0.786459, -1.522904, 1.828556},
	{0.789273, -1.691150, 1.657056},
	{0.992696, -1.691150, 1.657056},
	{0.929451, -1.522903, 1.828556},
	{1.427492, -1.691150, 1.211578},
	{1.210030, -1.691150, 1.657056},
	{1.398046, -1.691150, 0.826042},
	{1.286110, -1.691150, 0.678533},
	{1.347783, -1.691151, 0.509898},
	{1.394675, -1.691151, 0.439433},
	{1.399319, -1.691150, 0.631963},
	{1.445475, -1.691151, 0.363095},
	{1.521961, -1.691150, 0.581512},
	{1.399319, -1.691150, 0.631963},
	{1.081288, -1.522903, 1.828556},
	{0.929451, -1.522903, 1.828556},
	{0.992696, -1.691150, 1.657056},
	{1.210030, -1.691150, 1.657056},
	{1.420500, -1.522903, 1.828556},
	{1.445475, -1.691150, 1.657056},
	{2.080420, -1.522903, 1.828556},
	{1.420500, -1.522903, 1.828556},
	{1.445475, -1.691150, 1.657056},
	{2.088682, -1.691150, 1.657057},
	{2.257802, -1.520164, 1.005988},
	{2.257802, -1.520164, 1.649195},
	{2.088682, -1.691150, 1.657057},
	{2.088682, -1.691150, 0.997136},
	{2.257803, -0.711673, 0.591973},
	{2.257802, -0.585230, 0.740661},
	{2.257802, -0.551484, 0.822697},
	{2.257802, -0.703243, 0.729186},
	{2.257802, -0.585230, 0.740661},
	{2.257802, -0.438962, 0.864406},
	{2.257802, -0.387900, 0.898385},
	{2.257802, -0.551484, 0.822697},
	{2.257803, -0.860244, 0.349787},
	{2.257803, -0.711673, 0.591973},
	{2.257802, -0.703243, 0.729186},
	{2.257803, -0.940509, 0.588671},
	{2.257803, -1.520164, 0.349787},
	{2.257803, -0.860244, 0.349787},
	{2.257803, -0.940509, 0.588671},
	{2.257803, -1.520164, 0.507275},
	{2.257802, -0.703243, 0.729186},
	{2.257802, -0.511944, 0.918815},
	{2.257802, -0.693365, 0.889953},
	{2.257802, -0.328072, 0.938199},
	{2.257803, -0.940509, 0.588671},
	{2.257802, -0.703243, 0.729186},
	{2.257802, -0.693365, 0.889953},
	{2.257802, -1.034554, 0.868563},
	{2.257802, -1.034554, 0.868563},
	{2.257803, -1.520164, 0.507275},
	{2.257803, -0.940509, 0.588671},
	{2.257802, -1.034554, 0.868563},
	{2.257802, -1.520164, 0.691799},
	{2.257802, -1.520164, 0.691799},
	{2.088682, -1.691150, 0.657925},
	{2.088682, -1.691150, 0.506088},
	{2.257803, -1.520164, 0.507275},
	{2.257802, -1.520164, 0.691799},
	{2.257803, -1.520164, 0.349787},
	{2.257803, -1.520164, 0.507275},
	{2.088682, -1.691150, 0.506088},
	{2.088682, -1.691151, 0.363096},
	{2.088682, -1.691150, 0.997136},
	{2.088682, -1.691150, 0.657925},
	{2.257802, -1.520164, 0.691799},
	{2.257802, -1.520164, 1.005988},
	{2.085533, -1.519919, 0.146133},
	{2.087480, -1.519348, 0.146680},
	{2.257803, -1.520164, 0.349787},
	{2.088682, -1.691151, 0.363096},
	{0.181555, -1.698040, -2.936938},
	{0.291884, -1.698040, -2.936938},
	{0.291884, -1.698040, -2.521346},
	{0.181555, -1.698040, -2.397875},
	{-0.711104, -1.698040, -2.936938},
	{-0.595058, -1.698040, -2.936938},
	{-0.595058, -1.698040, -2.397876},
	{-0.711103, -1.698040, -2.521346},
	{-0.210634, -1.698040, -2.936938},
	{-0.016501, -1.698040, -2.936938},
	{-0.016501, -1.698040, -2.430085},
	{-0.210634, -1.698040, -2.443506},
	{-0.016501, -1.698040, -2.936938},
	{0.181555, -1.698040, -2.936938},
	{0.181555, -1.698040, -2.397875},
	{-0.016501, -1.698040, -2.430085},
	{-0.402846, -1.698040, -2.936938},
	{-0.402846, -1.698040, -2.430085},
	{-0.210634, -1.698040, -2.936938},
	{-0.210634, -1.698040, -2.443506},
	{-0.711104, -1.698040, -2.936938},
	{-0.711103, -1.698040, -2.521346},
	{-0.796917, -1.524720, -2.453307},
	{-0.796917, -1.524720, -2.937116},
	{0.291884, -1.698040, -2.521346},
	{0.291884, -1.698040, -2.936938},
	{0.377523, -1.524720, -2.937116},
	{0.377524, -1.524720, -2.453308},
	{0.181555, -1.698040, -2.397875},
	{0.291884, -1.698040, -2.521346},
	{0.377524, -1.524720, -2.453308},
	{0.248335, -1.524719, -2.308732},
	{-0.711103, -1.698040, -2.521346},
	{-0.595058, -1.698040, -2.397876},
	{-0.661034, -1.524719, -2.308732},
	{-0.796917, -1.524720, -2.453307},
	{-0.711104, -1.113188, -3.106547},
	{-0.796917, -1.045150, -2.933227},
	{-0.661034, -0.900574, -2.933227},
	{-0.595058, -0.989718, -3.106547},
	{0.181555, -0.989718, -3.106547},
	{0.248335, -0.900574, -2.933227},
	{0.377523, -1.045150, -2.933227},
	{0.291884, -1.113188, -3.106547},
	{0.291884, -1.113188, -3.106547},
	{0.377523, -1.045150, -2.933227},
	{0.377523, -1.528959, -2.933227},
	{0.291884, -1.528781, -3.106547},
	{-0.711104, -1.528781, -3.106547},
	{-0.796917, -1.528959, -2.933227},
	{-0.796917, -1.045150, -2.933227},
	{-0.711104, -1.113188, -3.106547},
	{-0.402846, -1.528781, -3.106547},
	{-0.402846, -1.021928, -3.106547},
	{-0.210635, -1.035349, -3.106547},
	{-0.210634, -1.528781, -3.106547},
	{-0.595058, -1.528781, -3.106547},
	{-0.595058, -0.989718, -3.106547},
	{-0.016501, -1.528781, -3.106547},
	{-0.016501, -1.021928, -3.106547},
	{0.181555, -0.989718, -3.106547},
	{0.181555, -1.528781, -3.106547},
	{-0.016501, -1.021928, -3.106547},
	{-0.016501, -1.528781, -3.106547},
	{-0.711104, -1.528781, -3.106547},
	{-0.711104, -1.113188, -3.106547},
	{0.181555, -1.528781, -3.106547},
	{0.181555, -0.989718, -3.106547},
	{0.291884, -1.113188, -3.106547},
	{0.291884, -1.528781, -3.106547},
	{-0.711104, -1.698040, -2.936938},
	{-0.796917, -1.528959, -2.933227},
	{-0.796917, -1.524720, -2.937116},
	{-0.711104, -1.528781, -3.106547},
	{-0.711104, -1.698040, -2.936938},
	{-0.711104, -1.528781, -3.106547},
	{-0.595058, -1.528781, -3.106547},
	{-0.595058, -1.698040, -2.936938},
	{-0.595058, -1.698040, -2.936938},
	{-0.595058, -1.528781, -3.106547},
	{-0.402846, -1.528781, -3.106547},
	{-0.402846, -1.698040, -2.936938},
	{-0.210634, -1.698040, -2.936938},
	{-0.402846, -1.698040, -2.936938},
	{-0.402846, -1.528781, -3.106547},
	{-0.210634, -1.528781, -3.106547},
	{-0.210634, -1.698040, -2.936938},
	{-0.210634, -1.528781, -3.106547},
	{-0.016501, -1.528781, -3.106547},
	{-0.016501, -1.698040, -2.936938},
	{0.181555, -1.698040, -2.936938},
	{-0.016501, -1.698040, -2.936938},
	{-0.016501, -1.528781, -3.106547},
	{0.181555, -1.528781, -3.106547},
	{0.291884, -1.698040, -2.936938},
	{0.181555, -1.698040, -2.936938},
	{0.181555, -1.528781, -3.106547},
	{0.291884, -1.528781, -3.106547},
	{0.291884, -1.698040, -2.936938},
	{0.291884, -1.528781, -3.106547},
	{0.377523, -1.524720, -2.937116},
	{0.377523, -1.528959, -2.933227},
	{-0.600949, 3.236759, -2.936938},
	{-0.711278, 3.236759, -2.936938},
	{-0.711278, 3.236759, -2.521346},
	{-0.600949, 3.236759, -2.397876},
	{0.291709, 3.236759, -2.936938},
	{0.175664, 3.236759, -2.936938},
	{0.175664, 3.236759, -2.397875},
	{0.291709, 3.236759, -2.521346},
	{-0.208760, 3.236759, -2.936938},
	{-0.402893, 3.236759, -2.936938},
	{-0.402894, 3.236759, -2.430085},
	{-0.208760, 3.236759, -2.443506},
	{-0.402893, 3.236759, -2.936938},
	{-0.402894, 3.236759, -2.430085},
	{-0.016548, 3.236759, -2.936938},
	{-0.016548, 3.236759, -2.430085},
	{-0.016548, 3.236759, -2.936938},
	{-0.208760, 3.236759, -2.936938},
	{-0.208760, 3.236759, -2.443506},
	{-0.016548, 3.236759, -2.430085},
	{0.291709, 3.236759, -2.936938},
	{0.291709, 3.236759, -2.521346},
	{0.377523, 3.063439, -2.453307},
	{0.377523, 3.063439, -2.937116},
	{-0.711278, 3.236759, -2.521346},
	{-0.711278, 3.236759, -2.936938},
	{-0.796918, 3.063439, -2.937116},
	{-0.796918, 3.063439, -2.453307},
	{-0.600949, 3.236759, -2.397876},
	{-0.711278, 3.236759, -2.521346},
	{-0.796918, 3.063439, -2.453307},
	{-0.667729, 3.063439, -2.308731},
	{0.291709, 3.236759, -2.521346},
	{0.175664, 3.236759, -2.397875},
	{0.241640, 3.063439, -2.308731},
	{0.377523, 3.063439, -2.453307},
	{0.291709, 2.651907, -3.106547},
	{0.377522, 2.583869, -2.933227},
	{0.241640, 2.439293, -2.933227},
	{0.175664, 2.528437, -3.106547},
	{-0.600949, 2.528438, -3.106547},
	{-0.667729, 2.439293, -2.933227},
	{-0.796918, 2.583870, -2.933227},
	{-0.711278, 2.651908, -3.106547},
	{-0.711278, 2.651908, -3.106547},
	{-0.796918, 2.583870, -2.933227},
	{-0.796918, 3.067678, -2.933227},
	{-0.711278, 3.067500, -3.106547},
	{0.291709, 3.067500, -3.106547},
	{0.377523, 3.067678, -2.933227},
	{0.377522, 2.583869, -2.933227},
	{0.291709, 2.651907, -3.106547},
	{-0.016548, 3.067500, -3.106547},
	{-0.016548, 2.560647, -3.106547},
	{-0.208760, 2.574068, -3.106547},
	{-0.208760, 3.067500, -3.106547},
	{0.175664, 3.067500, -3.106547},
	{0.175664, 2.528437, -3.106547},
	{-0.402893, 3.067500, -3.106547},
	{-0.402894, 2.560647, -3.106547},
	{-0.600949, 2.528438, -3.106547},
	{-0.600949, 3.067500, -3.106547},
	{0.291709, 3.067500, -3.106547},
	{0.291709, 2.651907, -3.106547},
	{0.175664, 2.528437, -3.106547},
	{0.175664, 3.067500, -3.106547},
	{-0.600949, 3.067500, -3.106547},
	{-0.600949, 2.528438, -3.106547},
	{-0.711278, 2.651908, -3.106547},
	{-0.711278, 3.067500, -3.106547},
	{0.291709, 3.236759, -2.936938},
	{0.377523, 3.067678, -2.933227},
	{0.377523, 3.063439, -2.937116},
	{0.291709, 3.067500, -3.106547},
	{0.291709, 3.236759, -2.936938},
	{0.291709, 3.067500, -3.106547},
	{0.175664, 3.067500, -3.106547},
	{0.175664, 3.236759, -2.936938},
	{0.175664, 3.236759, -2.936938},
	{0.175664, 3.067500, -3.106547},
	{-0.016548, 3.067500, -3.106547},
	{-0.016548, 3.236759, -2.936938},
	{-0.208760, 3.236759, -2.936938},
	{-0.016548, 3.236759, -2.936938},
	{-0.016548, 3.067500, -3.106547},
	{-0.208760, 3.067500, -3.106547},
	{-0.402893, 3.067500, -3.106547},
	{-0.402893, 3.236759, -2.936938},
	{-0.600949, 3.236759, -2.936938},
	{-0.600949, 3.067500, -3.106547},
	{-0.711278, 3.236759, -2.936938},
	{-0.600949, 3.236759, -2.936938},
	{-0.600949, 3.067500, -3.106547},
	{-0.711278, 3.067500, -3.106547},
	{-0.711278, 3.236759, -2.936938},
	{-0.711278, 3.067500, -3.106547},
	{-0.796918, 3.063439, -2.937116},
	{-0.796918, 3.067678, -2.933227},
	{2.257703, 1.160611, -2.936938},
	{2.257703, 1.270940, -2.936938},
	{2.257703, 1.270940, -2.521345},
	{2.257703, 1.160611, -2.397875},
	{2.257703, 0.267953, -2.936938},
	{2.257703, 0.383998, -2.936938},
	{2.257703, 0.383998, -2.397875},
	{2.257703, 0.267953, -2.521345},
	{2.257703, 0.768422, -2.936938},
	{2.257703, 0.962555, -2.936938},
	{2.257703, 0.962556, -2.430084},
	{2.257703, 0.768422, -2.443505},
	{2.257703, 0.576210, -2.936938},
	{2.257703, 0.576210, -2.430084},
	{2.257703, 0.267953, -2.936938},
	{2.257703, 0.267953, -2.521345},
	{2.084383, 0.182139, -2.453307},
	{2.084383, 0.182139, -2.937115},
	{2.257703, 1.270940, -2.521345},
	{2.257703, 1.270940, -2.936938},
	{2.084383, 1.356580, -2.937116},
	{2.084383, 1.356580, -2.453307},
	{2.257703, 1.160611, -2.397875},
	{2.257703, 1.270940, -2.521345},
	{2.084383, 1.356580, -2.453307},
	{2.084383, 1.227391, -2.308731},
	{2.257703, 0.267953, -2.521345},
	{2.257703, 0.383998, -2.397875},
	{2.084383, 0.318022, -2.308731},
	{2.084383, 0.182139, -2.453307},
	{1.672851, 0.267953, -3.106547},
	{1.604813, 0.182139, -2.933226},
	{1.460237, 0.318022, -2.933226},
	{1.549381, 0.383998, -3.106547},
	{1.549381, 1.160611, -3.106547},
	{1.460237, 1.227391, -2.933226},
	{1.604813, 1.356580, -2.933226},
	{1.672851, 1.270940, -3.106547},
	{1.672851, 1.270940, -3.106547},
	{1.604813, 1.356580, -2.933226},
	{2.088622, 1.356580, -2.933226},
	{2.088444, 1.270940, -3.106547},
	{2.088444, 0.267953, -3.106547},
	{2.088622, 0.182139, -2.933226},
	{1.604813, 0.182139, -2.933226},
	{1.672851, 0.267953, -3.106547},
	{2.088444, 0.576210, -3.106547},
	{1.581591, 0.576210, -3.106547},
	{1.595011, 0.768422, -3.106547},
	{2.088444, 0.768422, -3.106547},
	{2.088444, 0.383998, -3.106547},
	{1.549381, 0.383998, -3.106547},
	{2.088444, 0.962555, -3.106547},
	{1.581591, 0.962556, -3.106547},
	{1.549381, 1.160611, -3.106547},
	{2.088444, 1.160611, -3.106547},
	{2.088444, 0.267953, -3.106547},
	{1.672851, 0.267953, -3.106547},
	{1.672851, 1.270940, -3.106547},
	{2.088444, 1.270940, -3.106547},
	{2.257703, 0.267953, -2.936938},
	{2.088622, 0.182139, -2.933226},
	{2.084383, 0.182139, -2.937115},
	{2.088444, 0.267953, -3.106547},
	{2.257703, 0.267953, -2.936938},
	{2.088444, 0.267953, -3.106547},
	{2.088444, 0.383998, -3.106547},
	{2.257703, 0.383998, -2.936938},
	{2.088444, 0.576210, -3.106547},
	{2.257703, 0.576210, -2.936938},
	{2.257703, 0.768422, -2.936938},
	{2.088444, 0.768422, -3.106547},
	{2.088444, 0.962555, -3.106547},
	{2.257703, 0.962555, -2.936938},
	{2.257703, 1.160611, -2.936938},
	{2.088444, 1.160611, -3.106547},
	{2.257703, 1.270940, -2.936938},
	{2.088444, 1.270940, -3.106547},
	{2.257703, 1.270940, -2.936938},
	{2.088444, 1.270940, -3.106547},
	{2.084383, 1.356580, -2.937116},
	{2.088622, 1.356580, -2.933226},
	{-2.677096, 0.378108, -2.936939},
	{-2.677096, 0.267779, -2.936939},
	{-2.677096, 0.267779, -2.521346},
	{-2.677096, 0.378107, -2.397876},
	{-2.677096, 1.270766, -2.936939},
	{-2.677096, 1.154721, -2.936939},
	{-2.677097, 1.154721, -2.397876},
	{-2.677097, 1.270766, -2.521346},
	{-2.677096, 0.770297, -2.936939},
	{-2.677096, 0.576163, -2.936939},
	{-2.677096, 0.576163, -2.430085},
	{-2.677096, 0.770297, -2.443506},
	{-2.677096, 1.154721, -2.936939},
	{-2.677096, 0.962509, -2.936939},
	{-2.677096, 0.962509, -2.430085},
	{-2.677097, 1.154721, -2.397876},
	{-2.677096, 0.962509, -2.936939},
	{-2.677096, 0.962509, -2.430085},
	{-2.677096, 1.270766, -2.936939},
	{-2.677097, 1.270766, -2.521346},
	{-2.503776, 1.356580, -2.453308},
	{-2.503776, 1.356579, -2.937116},
	{-2.677096, 0.267779, -2.521346},
	{-2.677096, 0.267779, -2.936939},
	{-2.503776, 0.182139, -2.937117},
	{-2.503776, 0.182139, -2.453308},
	{-2.677096, 0.378107, -2.397876},
	{-2.677096, 0.267779, -2.521346},
	{-2.503776, 0.182139, -2.453308},
	{-2.503776, 0.311328, -2.308732},
	{-2.677097, 1.270766, -2.521346},
	{-2.677097, 1.154721, -2.397876},
	{-2.503776, 1.220697, -2.308732},
	{-2.503776, 1.356580, -2.453308},
	{-2.092245, 1.270766, -3.106547},
	{-2.024207, 1.356579, -2.933227},
	{-1.879631, 1.220697, -2.933227},
	{-1.968775, 1.154721, -3.106547},
	{-1.968775, 0.378108, -3.106547},
	{-1.879630, 0.311328, -2.933227},
	{-2.024207, 0.182139, -2.933227},
	{-2.092245, 0.267779, -3.106547},
	{-2.092245, 0.267779, -3.106547},
	{-2.024207, 0.182139, -2.933227},
	{-2.508015, 0.182139, -2.933227},
	{-2.507837, 0.267779, -3.106547},
	{-2.507837, 1.270766, -3.106547},
	{-2.508015, 1.356579, -2.933227},
	{-2.024207, 1.356579, -2.933227},
	{-2.092245, 1.270766, -3.106547},
	{-2.507838, 0.962509, -3.106547},
	{-2.000984, 0.962509, -3.106547},
	{-2.014405, 0.770297, -3.106547},
	{-2.507838, 0.770297, -3.106547},
	{-2.507837, 1.154721, -3.106547},
	{-1.968775, 1.154721, -3.106547},
	{-2.507837, 0.576163, -3.106547},
	{-2.000984, 0.576163, -3.106547},
	{-1.968775, 0.378108, -3.106547},
	{-2.507837, 0.378108, -3.106547},
	{-2.507837, 1.270766, -3.106547},
	{-2.092245, 1.270766, -3.106547},
	{-2.092245, 0.267779, -3.106547},
	{-2.507837, 0.267779, -3.106547},
	{-2.677096, 1.270766, -2.936939},
	{-2.508015, 1.356579, -2.933227},
	{-2.503776, 1.356579, -2.937116},
	{-2.507837, 1.270766, -3.106547},
	{-2.677096, 1.270766, -2.936939},
	{-2.507837, 1.270766, -3.106547},
	{-2.507837, 1.154721, -3.106547},
	{-2.677096, 1.154721, -2.936939},
	{-2.677096, 1.154721, -2.936939},
	{-2.507837, 1.154721, -3.106547},
	{-2.507838, 0.962509, -3.106547},
	{-2.677096, 0.962509, -2.936939},
	{-2.677096, 0.770297, -2.936939},
	{-2.677096, 0.962509, -2.936939},
	{-2.507838, 0.962509, -3.106547},
	{-2.507838, 0.770297, -3.106547},
	{-2.677096, 0.770297, -2.936939},
	{-2.507838, 0.770297, -3.106547},
	{-2.507837, 0.576163, -3.106547},
	{-2.677096, 0.576163, -2.936939},
	{-2.677096, 0.378108, -2.936939},
	{-2.677096, 0.576163, -2.936939},
	{-2.507837, 0.576163, -3.106547},
	{-2.507837, 0.378108, -3.106547},
	{-2.677096, 0.267779, -2.936939},
	{-2.507837, 0.267779, -3.106547},
	{-2.677096, 0.267779, -2.936939},
	{-2.507837, 0.267779, -3.106547},
	{-2.503776, 0.182139, -2.937117},
	{-2.508015, 0.182139, -2.933227},
	{-2.677096, -1.528612, -0.247716},
	{-2.677096, -1.528612, -0.137387},
	{-2.677096, -1.113020, -0.137387},
	{-2.677096, -0.989550, -0.247715},
	{-2.677096, -1.528612, -1.140374},
	{-2.677096, -1.528612, -1.024329},
	{-2.677096, -0.989550, -1.024329},
	{-2.677096, -1.113020, -1.140374},
	{-2.677096, -1.528612, -0.639905},
	{-2.677096, -1.528612, -0.445771},
	{-2.677096, -1.021759, -0.445771},
	{-2.677096, -1.035179, -0.639905},
	{-2.677096, -1.528612, -0.445771},
	{-2.677096, -1.528612, -0.247716},
	{-2.677096, -0.989550, -0.247715},
	{-2.677096, -1.021759, -0.445771},
	{-2.677096, -1.528612, -0.832117},
	{-2.677096, -1.021759, -0.832117},
	{-2.677096, -1.528612, -0.639905},
	{-2.677096, -1.035179, -0.639905},
	{-2.677096, -1.528612, -1.140374},
	{-2.677096, -1.113020, -1.140374},
	{-2.503776, -1.044981, -1.226187},
	{-2.503776, -1.528790, -1.226187},
	{-2.677096, -1.113020, -0.137387},
	{-2.677096, -1.528612, -0.137387},
	{-2.503776, -1.528790, -0.051747},
	{-2.503776, -1.044981, -0.051747},
	{-2.677096, -0.989550, -0.247715},
	{-2.677096, -1.113020, -0.137387},
	{-2.503776, -1.044981, -0.051747},
	{-2.503776, -0.900405, -0.180935},
	{-2.677096, -1.113020, -1.140374},
	{-2.677096, -0.989550, -1.024329},
	{-2.503776, -0.900405, -1.090305},
	{-2.503776, -1.044981, -1.226187},
	{-2.092244, -1.698221, -1.140374},
	{-2.024207, -1.524901, -1.226187},
	{-1.879630, -1.524901, -1.090304},
	{-1.968774, -1.698221, -1.024328},
	{-1.968775, -1.698221, -0.247715},
	{-1.879630, -1.524901, -0.180935},
	{-2.024207, -1.524901, -0.051747},
	{-2.092245, -1.698221, -0.137387},
	{-2.092245, -1.698221, -0.137387},
	{-2.024207, -1.524901, -0.051747},
	{-2.508015, -1.524901, -0.051747},
	{-2.507837, -1.698221, -0.137387},
	{-2.507837, -1.698221, -1.140374},
	{-2.508015, -1.524901, -1.226187},
	{-2.024207, -1.524901, -1.226187},
	{-2.092244, -1.698221, -1.140374},
	{-2.507837, -1.698221, -0.832117},
	{-2.000984, -1.698221, -0.832116},
	{-2.014405, -1.698221, -0.639905},
	{-2.507837, -1.698221, -0.639905},
	{-2.507837, -1.698221, -1.024328},
	{-1.968774, -1.698221, -1.024328},
	{-2.507837, -1.698221, -0.445771},
	{-2.000984, -1.698221, -0.445771},
	{-1.968775, -1.698221, -0.247715},
	{-2.507837, -1.698221, -0.247716},
	{-2.507837, -1.698221, -1.140374},
	{-2.092244, -1.698221, -1.140374},
	{-2.507837, -1.698221, -0.247716},
	{-1.968775, -1.698221, -0.247715},
	{-2.092245, -1.698221, -0.137387},
	{-2.507837, -1.698221, -0.137387},
	{-2.677096, -1.528612, -1.140374},
	{-2.508015, -1.524901, -1.226187},
	{-2.503776, -1.528790, -1.226187},
	{-2.507837, -1.698221, -1.140374},
	{-2.677096, -1.528612, -1.140374},
	{-2.507837, -1.698221, -1.140374},
	{-2.507837, -1.698221, -1.024328},
	{-2.677096, -1.528612, -1.024329},
	{-2.677096, -1.528612, -1.024329},
	{-2.507837, -1.698221, -1.024328},
	{-2.507837, -1.698221, -0.832117},
	{-2.677096, -1.528612, -0.832117},
	{-2.677096, -1.528612, -0.639905},
	{-2.677096, -1.528612, -0.832117},
	{-2.507837, -1.698221, -0.832117},
	{-2.507837, -1.698221, -0.639905},
	{-2.507837, -1.698221, -0.445771},
	{-2.677096, -1.528612, -0.445771},
	{-2.677096, -1.528612, -0.247716},
	{-2.507837, -1.698221, -0.247716},
	{-2.677096, -1.528612, -0.137387},
	{-2.677096, -1.528612, -0.247716},
	{-2.507837, -1.698221, -0.247716},
	{-2.507837, -1.698221, -0.137387},
	{-2.677096, -1.528612, -0.137387},
	{-2.507837, -1.698221, -0.137387},
	{-2.503776, -1.528790, -0.051747},
	{-2.508015, -1.524901, -0.051747},
	{-2.677096, 3.067332, -1.030219},
	{-2.677096, 3.067332, -1.140547},
	{-2.677096, 2.651739, -1.140548},
	{-2.677096, 2.528269, -1.030219},
	{-2.677096, 3.067331, -0.137560},
	{-2.677096, 3.067331, -0.253606},
	{-2.677096, 2.528269, -0.253606},
	{-2.677096, 2.651739, -0.137560},
	{-2.677096, 3.067331, -0.638029},
	{-2.677096, 3.067331, -0.832163},
	{-2.677096, 2.560478, -0.832163},
	{-2.677096, 2.573899, -0.638029},
	{-2.677096, 3.067331, -0.445818},
	{-2.677096, 2.560478, -0.445818},
	{-2.677096, 3.067331, -0.137560},
	{-2.677096, 2.651739, -0.137560},
	{-2.503776, 2.583701, -0.051747},
	{-2.503776, 3.067509, -0.051747},
	{-2.677096, 2.651739, -1.140548},
	{-2.677096, 3.067332, -1.140547},
	{-2.503776, 3.067510, -1.226187},
	{-2.503776, 2.583701, -1.226187},
	{-2.677096, 2.528269, -1.030219},
	{-2.677096, 2.651739, -1.140548},
	{-2.503776, 2.583701, -1.226187},
	{-2.503776, 2.439125, -1.096999},
	{-2.677096, 2.651739, -0.137560},
	{-2.677096, 2.528269, -0.253606},
	{-2.503776, 2.439125, -0.187630},
	{-2.503776, 2.583701, -0.051747},
	{-2.092245, 3.236941, -0.137560},
	{-2.024207, 3.063620, -0.051747},
	{-1.879630, 3.063620, -0.187629},
	{-1.968775, 3.236941, -0.253606},
	{-1.968774, 3.236940, -1.030218},
	{-1.879630, 3.063620, -1.096998},
	{-2.024207, 3.063620, -1.226187},
	{-2.092244, 3.236940, -1.140547},
	{-2.092244, 3.236940, -1.140547},
	{-2.024207, 3.063620, -1.226187},
	{-2.508015, 3.063620, -1.226187},
	{-2.507837, 3.236940, -1.140547},
	{-2.507837, 3.236940, -0.137560},
	{-2.508015, 3.063620, -0.051747},
	{-2.024207, 3.063620, -0.051747},
	{-2.092245, 3.236941, -0.137560},
	{-2.507837, 3.236940, -0.445818},
	{-2.000984, 3.236941, -0.445817},
	{-2.014405, 3.236940, -0.638029},
	{-2.507837, 3.236940, -0.638029},
	{-2.507837, 3.236940, -0.253606},
	{-1.968775, 3.236941, -0.253606},
	{-2.000984, 3.236941, -0.445817},
	{-2.507837, 3.236940, -0.445818},
	{-2.507837, 3.236940, -0.832163},
	{-2.000984, 3.236940, -0.832163},
	{-1.968774, 3.236940, -1.030218},
	{-2.507837, 3.236940, -1.030218},
	{-2.507837, 3.236940, -0.638029},
	{-2.014405, 3.236940, -0.638029},
	{-2.000984, 3.236940, -0.832163},
	{-2.507837, 3.236940, -0.832163},
	{-2.507837, 3.236940, -0.137560},
	{-2.092245, 3.236941, -0.137560},
	{-1.968775, 3.236941, -0.253606},
	{-2.507837, 3.236940, -0.253606},
	{-2.092244, 3.236940, -1.140547},
	{-2.507837, 3.236940, -1.140547},
	{-2.677096, 3.067331, -0.137560},
	{-2.508015, 3.063620, -0.051747},
	{-2.503776, 3.067509, -0.051747},
	{-2.507837, 3.236940, -0.137560},
	{-2.677096, 3.067331, -0.137560},
	{-2.507837, 3.236940, -0.137560},
	{-2.507837, 3.236940, -0.253606},
	{-2.677096, 3.067331, -0.253606},
	{-2.677096, 3.067331, -0.253606},
	{-2.507837, 3.236940, -0.253606},
	{-2.507837, 3.236940, -0.445818},
	{-2.677096, 3.067331, -0.445818},
	{-2.677096, 3.067331, -0.638029},
	{-2.507837, 3.236940, -0.638029},
	{-2.507837, 3.236940, -0.832163},
	{-2.677096, 3.067331, -0.832163},
	{-2.677096, 3.067332, -1.030219},
	{-2.677096, 3.067331, -0.832163},
	{-2.507837, 3.236940, -0.832163},
	{-2.507837, 3.236940, -1.030218},
	{-2.677096, 3.067332, -1.140547},
	{-2.677096, 3.067332, -1.030219},
	{-2.507837, 3.236940, -1.030218},
	{-2.507837, 3.236940, -1.140547},
	{-2.677096, 3.067332, -1.140547},
	{-2.507837, 3.236940, -1.140547},
	{-2.503776, 3.067510, -1.226187},
	{-2.508015, 3.063620, -1.226187},
	{2.257703, 3.067332, -0.247713},
	{2.257703, 3.067332, -0.137385},
	{2.257703, 2.651739, -0.137385},
	{2.257703, 2.528269, -0.247713},
	{2.257703, 3.067332, -1.140372},
	{2.257703, 3.067332, -1.024326},
	{2.257703, 2.528269, -1.024326},
	{2.257703, 2.651739, -1.140372},
	{2.257703, 3.067332, -0.639903},
	{2.257703, 3.067332, -0.445769},
	{2.257703, 2.560479, -0.445769},
	{2.257703, 2.573900, -0.639903},
	{2.257703, 3.067332, -1.024326},
	{2.257703, 3.067332, -0.832115},
	{2.257703, 2.560479, -0.832115},
	{2.257703, 2.528269, -1.024326},
	{2.257703, 3.067332, -0.639903},
	{2.257703, 2.573900, -0.639903},
	{2.257703, 3.067332, -1.140372},
	{2.257703, 2.651739, -1.140372},
	{2.084383, 2.583701, -1.226185},
	{2.084383, 3.067510, -1.226185},
	{2.257703, 2.651739, -0.137385},
	{2.257703, 3.067332, -0.137385},
	{2.084383, 3.067510, -0.051745},
	{2.084383, 2.583702, -0.051745},
	{2.257703, 2.528269, -0.247713},
	{2.257703, 2.651739, -0.137385},
	{2.084383, 2.583702, -0.051745},
	{2.084383, 2.439126, -0.180933},
	{2.257703, 2.651739, -1.140372},
	{2.257703, 2.528269, -1.024326},
	{2.084383, 2.439125, -1.090302},
	{2.084383, 2.583701, -1.226185},
	{1.672851, 3.236941, -1.140372},
	{1.604814, 3.063621, -1.226185},
	{1.460237, 3.063621, -1.090303},
	{1.549381, 3.236941, -1.024326},
	{1.549381, 3.236941, -0.247714},
	{1.460237, 3.063621, -0.180934},
	{1.604813, 3.063621, -0.051745},
	{1.672851, 3.236941, -0.137385},
	{1.672851, 3.236941, -0.137385},
	{1.604813, 3.063621, -0.051745},
	{2.088622, 3.063621, -0.051745},
	{2.088444, 3.236941, -0.137385},
	{2.088444, 3.236941, -1.140372},
	{2.088622, 3.063621, -1.226185},
	{1.604814, 3.063621, -1.226185},
	{1.672851, 3.236941, -1.140372},
	{2.088444, 3.236941, -0.832115},
	{1.581591, 3.236941, -0.832115},
	{1.595011, 3.236941, -0.639903},
	{2.088444, 3.236941, -0.639903},
	{2.088444, 3.236941, -1.024326},
	{1.549381, 3.236941, -1.024326},
	{2.088444, 3.236941, -0.445769},
	{1.581591, 3.236941, -0.445769},
	{1.549381, 3.236941, -0.247714},
	{2.088444, 3.236941, -0.247713},
	{2.088444, 3.236941, -0.639903},
	{1.595011, 3.236941, -0.639903},
	{1.581591, 3.236941, -0.445769},
	{2.088444, 3.236941, -0.445769},
	{2.088444, 3.236941, -1.140372},
	{1.672851, 3.236941, -1.140372},
	{1.672851, 3.236941, -0.137385},
	{2.088444, 3.236941, -0.137385},
	{2.257703, 3.067332, -1.140372},
	{2.088622, 3.063621, -1.226185},
	{2.084383, 3.067510, -1.226185},
	{2.088444, 3.236941, -1.140372},
	{2.257703, 3.067332, -1.140372},
	{2.088444, 3.236941, -1.140372},
	{2.088444, 3.236941, -1.024326},
	{2.257703, 3.067332, -1.024326},
	{2.257703, 3.067332, -1.024326},
	{2.088444, 3.236941, -1.024326},
	{2.088444, 3.236941, -0.832115},
	{2.257703, 3.067332, -0.832115},
	{2.257703, 3.067332, -0.639903},
	{2.257703, 3.067332, -0.832115},
	{2.088444, 3.236941, -0.832115},
	{2.088444, 3.236941, -0.639903},
	{2.257703, 3.067332, -0.639903},
	{2.088444, 3.236941, -0.639903},
	{2.088444, 3.236941, -0.445769},
	{2.257703, 3.067332, -0.445769},
	{2.257703, 3.067332, -0.247713},
	{2.088444, 3.236941, -0.247713},
	{2.257703, 3.067332, -0.137385},
	{2.088444, 3.236941, -0.137385},
	{2.257703, 3.067332, -0.137385},
	{2.088444, 3.236941, -0.137385},
	{2.084383, 3.067510, -0.051745},
	{2.088622, 3.063621, -0.051745},
	{2.257703, -1.528612, -1.030217},
	{2.257703, -1.528612, -1.140545},
	{2.257703, -1.113019, -1.140545},
	{2.257703, -0.989549, -1.030217},
	{2.257703, -1.528611, -0.137558},
	{2.257703, -1.528611, -0.253604},
	{2.257703, -0.989549, -0.253604},
	{2.257703, -1.113019, -0.137558},
	{2.257703, -1.528612, -0.638027},
	{2.257703, -1.528612, -0.832161},
	{2.257703, -1.021759, -0.832161},
	{2.257703, -1.035179, -0.638027},
	{2.257703, -1.528611, -0.253604},
	{2.257703, -1.528611, -0.445815},
	{2.257703, -1.021759, -0.445815},
	{2.257703, -0.989549, -0.253604},
	{2.257703, -1.528611, -0.445815},
	{2.257703, -1.021759, -0.445815},
	{2.257703, -1.528611, -0.137558},
	{2.257703, -1.113019, -0.137558},
	{2.084383, -1.044981, -0.051745},
	{2.084383, -1.528790, -0.051745},
	{2.257703, -1.113019, -1.140545},
	{2.257703, -1.528612, -1.140545},
	{2.084383, -1.528790, -1.226185},
	{2.084383, -1.044981, -1.226185},
	{2.257703, -0.989549, -1.030217},
	{2.257703, -1.113019, -1.140545},
	{2.084383, -1.044981, -1.226185},
	{2.084383, -0.900405, -1.096997},
	{2.257703, -1.113019, -0.137558},
	{2.257703, -0.989549, -0.253604},
	{2.084383, -0.900405, -0.187628},
	{2.084383, -1.044981, -0.051745},
	{1.672851, -1.698221, -0.137558},
	{1.604814, -1.524901, -0.051745},
	{1.460237, -1.524901, -0.187628},
	{1.549381, -1.698221, -0.253604},
	{1.549382, -1.698221, -1.030217},
	{1.460237, -1.524901, -1.096997},
	{1.604814, -1.524901, -1.226185},
	{1.672851, -1.698221, -1.140545},
	{1.672851, -1.698221, -1.140545},
	{1.604814, -1.524901, -1.226185},
	{2.088622, -1.524901, -1.226185},
	{2.088444, -1.698221, -1.140545},
	{2.088444, -1.698221, -0.137558},
	{2.088622, -1.524901, -0.051745},
	{1.604814, -1.524901, -0.051745},
	{1.672851, -1.698221, -0.137558},
	{2.088444, -1.698221, -0.445815},
	{1.581591, -1.698221, -0.445816},
	{1.595011, -1.698221, -0.638027},
	{2.088444, -1.698221, -0.638027},
	{2.088444, -1.698221, -0.253604},
	{1.549381, -1.698221, -0.253604},
	{1.581591, -1.698221, -0.445816},
	{2.088444, -1.698221, -0.445815},
	{2.088444, -1.698221, -0.832161},
	{1.581591, -1.698221, -0.832161},
	{1.549382, -1.698221, -1.030217},
	{2.088444, -1.698221, -1.030217},
	{1.581591, -1.698221, -0.832161},
	{2.088444, -1.698221, -0.832161},
	{2.088444, -1.698221, -0.137558},
	{1.672851, -1.698221, -0.137558},
	{1.549381, -1.698221, -0.253604},
	{2.088444, -1.698221, -0.253604},
	{1.672851, -1.698221, -1.140545},
	{2.088444, -1.698221, -1.140545},
	{2.257703, -1.528611, -0.137558},
	{2.088622, -1.524901, -0.051745},
	{2.084383, -1.528790, -0.051745},
	{2.088444, -1.698221, -0.137558},
	{2.257703, -1.528611, -0.137558},
	{2.088444, -1.698221, -0.137558},
	{2.088444, -1.698221, -0.253604},
	{2.257703, -1.528611, -0.253604},
	{2.257703, -1.528611, -0.253604},
	{2.088444, -1.698221, -0.253604},
	{2.088444, -1.698221, -0.445815},
	{2.257703, -1.528611, -0.445815},
	{2.257703, -1.528612, -0.638027},
	{2.257703, -1.528611, -0.445815},
	{2.088444, -1.698221, -0.445815},
	{2.088444, -1.698221, -0.638027},
	{2.257703, -1.528612, -0.638027},
	{2.088444, -1.698221, -0.638027},
	{2.088444, -1.698221, -0.832161},
	{2.257703, -1.528612, -0.832161},
	{2.257703, -1.528612, -1.030217},
	{2.088444, -1.698221, -1.030217},
	{2.257703, -1.528612, -1.140545},
	{2.088444, -1.698221, -1.140545},
	{2.257703, -1.528612, -1.140545},
	{2.088444, -1.698221, -1.140545},
	{2.084383, -1.528790, -1.226185},
	{2.088622, -1.524901, -1.226185},
	{-0.600949, -1.698040, 1.659006},
	{-0.711277, -1.698040, 1.659006},
	{-0.711277, -1.698040, 1.243413},
	{-0.600949, -1.698040, 1.119943},
	{0.291710, -1.698040, 1.659006},
	{0.175664, -1.698040, 1.659006},
	{0.175664, -1.698040, 1.119943},
	{0.291710, -1.698040, 1.243413},
	{-0.208759, -1.698040, 1.659006},
	{-0.402893, -1.698040, 1.659006},
	{-0.402893, -1.698040, 1.152153},
	{-0.208759, -1.698040, 1.165573},
	{-0.402893, -1.698040, 1.659006},
	{-0.600949, -1.698040, 1.659006},
	{-0.600949, -1.698040, 1.119943},
	{-0.402893, -1.698040, 1.152153},
	{0.175664, -1.698040, 1.659006},
	{-0.016547, -1.698040, 1.659006},
	{-0.016547, -1.698040, 1.152153},
	{0.175664, -1.698040, 1.119943},
	{-0.016547, -1.698040, 1.659006},
	{-0.208759, -1.698040, 1.659006},
	{-0.208759, -1.698040, 1.165573},
	{-0.016547, -1.698040, 1.152153},
	{0.291710, -1.698040, 1.659006},
	{0.291710, -1.698040, 1.243413},
	{0.377523, -1.524719, 1.175375},
	{0.377523, -1.524719, 1.659184},
	{-0.711277, -1.698040, 1.243413},
	{-0.711277, -1.698040, 1.659006},
	{-0.796917, -1.524719, 1.659184},
	{-0.796917, -1.524719, 1.175375},
	{-0.600949, -1.698040, 1.119943},
	{-0.711277, -1.698040, 1.243413},
	{-0.796917, -1.524719, 1.175375},
	{-0.667729, -1.524719, 1.030799},
	{0.291710, -1.698040, 1.243413},
	{0.175664, -1.698040, 1.119943},
	{0.241640, -1.524719, 1.030799},
	{0.377523, -1.524719, 1.175375},
	{0.291710, -1.113188, 1.828615},
	{0.377523, -1.045150, 1.655294},
	{0.241640, -0.900574, 1.655294},
	{0.175664, -0.989718, 1.828615},
	{-0.600949, -0.989718, 1.828615},
	{-0.667729, -0.900574, 1.655294},
	{-0.796917, -1.045150, 1.655294},
	{-0.711277, -1.113188, 1.828615},
	{-0.711277, -1.113188, 1.828615},
	{-0.796917, -1.045150, 1.655294},
	{-0.796917, -1.528959, 1.655294},
	{-0.711277, -1.528781, 1.828615},
	{0.291710, -1.528781, 1.828615},
	{0.377523, -1.528959, 1.655294},
	{0.377523, -1.045150, 1.655294},
	{0.291710, -1.113188, 1.828615},
	{-0.016547, -1.528781, 1.828615},
	{-0.016548, -1.021927, 1.828615},
	{-0.208759, -1.035348, 1.828615},
	{-0.208759, -1.528781, 1.828615},
	{0.175664, -1.528781, 1.828615},
	{0.175664, -0.989718, 1.828615},
	{-0.402893, -1.528781, 1.828615},
	{-0.402893, -1.021927, 1.828615},
	{-0.600949, -0.989718, 1.828615},
	{-0.600949, -1.528781, 1.828615},
	{0.291710, -1.528781, 1.828615},
	{0.291710, -1.113188, 1.828615},
	{-0.711277, -1.113188, 1.828615},
	{-0.711277, -1.528781, 1.828615},
	{0.291710, -1.698040, 1.659006},
	{0.377523, -1.528959, 1.655294},
	{0.377523, -1.524719, 1.659184},
	{0.291710, -1.528781, 1.828615},
	{0.291710, -1.698040, 1.659006},
	{0.291710, -1.528781, 1.828615},
	{0.175664, -1.528781, 1.828615},
	{0.175664, -1.698040, 1.659006},
	{0.175664, -1.698040, 1.659006},
	{0.175664, -1.528781, 1.828615},
	{-0.016547, -1.528781, 1.828615},
	{-0.016547, -1.698040, 1.659006},
	{-0.208759, -1.698040, 1.659006},
	{-0.016547, -1.698040, 1.659006},
	{-0.016547, -1.528781, 1.828615},
	{-0.208759, -1.528781, 1.828615},
	{-0.208759, -1.698040, 1.659006},
	{-0.208759, -1.528781, 1.828615},
	{-0.402893, -1.528781, 1.828615},
	{-0.402893, -1.698040, 1.659006},
	{-0.600949, -1.698040, 1.659006},
	{-0.402893, -1.698040, 1.659006},
	{-0.402893, -1.528781, 1.828615},
	{-0.600949, -1.528781, 1.828615},
	{-0.711277, -1.698040, 1.659006},
	{-0.600949, -1.698040, 1.659006},
	{-0.600949, -1.528781, 1.828615},
	{-0.711277, -1.528781, 1.828615},
	{-0.711277, -1.698040, 1.659006},
	{-0.711277, -1.528781, 1.828615},
	{-0.796917, -1.524719, 1.659184},
	{-0.796917, -1.528959, 1.655294},
	{0.181555, 3.236760, 1.659006},
	{0.291883, 3.236760, 1.659006},
	{0.291884, 3.236760, 1.243413},
	{0.181555, 3.236760, 1.119943},
	{-0.711104, 3.236759, 1.659006},
	{-0.595058, 3.236759, 1.659006},
	{-0.595058, 3.236759, 1.119943},
	{-0.711104, 3.236759, 1.243413},
	{-0.210635, 3.236760, 1.659006},
	{-0.016501, 3.236760, 1.659006},
	{-0.016501, 3.236760, 1.152152},
	{-0.210635, 3.236759, 1.165573},
	{-0.016501, 3.236760, 1.659006},
	{-0.016501, 3.236760, 1.152152},
	{-0.595058, 3.236759, 1.659006},
	{-0.402846, 3.236760, 1.659006},
	{-0.402846, 3.236759, 1.152152},
	{-0.595058, 3.236759, 1.119943},
	{-0.402846, 3.236760, 1.659006},
	{-0.210635, 3.236760, 1.659006},
	{-0.210635, 3.236759, 1.165573},
	{-0.402846, 3.236759, 1.152152},
	{-0.711104, 3.236759, 1.659006},
	{-0.711104, 3.236759, 1.243413},
	{-0.796917, 3.063439, 1.175375},
	{-0.796917, 3.063439, 1.659183},
	{0.291884, 3.236760, 1.243413},
	{0.291883, 3.236760, 1.659006},
	{0.377523, 3.063439, 1.659184},
	{0.377524, 3.063439, 1.175375},
	{0.181555, 3.236760, 1.119943},
	{0.291884, 3.236760, 1.243413},
	{0.377524, 3.063439, 1.175375},
	{0.248335, 3.063439, 1.030799},
	{-0.711104, 3.236759, 1.243413},
	{-0.595058, 3.236759, 1.119943},
	{-0.661034, 3.063439, 1.030799},
	{-0.796917, 3.063439, 1.175375},
	{-0.711103, 2.651908, 1.828615},
	{-0.796917, 2.583870, 1.655294},
	{-0.661034, 2.439294, 1.655294},
	{-0.595058, 2.528438, 1.828615},
	{0.181555, 2.528438, 1.828615},
	{0.248335, 2.439294, 1.655294},
	{0.377524, 2.583870, 1.655294},
	{0.291884, 2.651908, 1.828614},
	{0.291884, 2.651908, 1.828614},
	{0.377524, 2.583870, 1.655294},
	{0.377523, 3.067679, 1.655294},
	{0.291883, 3.067501, 1.828615},
	{-0.711104, 3.067500, 1.828615},
	{-0.796917, 3.067678, 1.655294},
	{-0.796917, 2.583870, 1.655294},
	{-0.711103, 2.651908, 1.828615},
	{-0.402846, 3.067501, 1.828615},
	{-0.402846, 2.560647, 1.828615},
	{-0.210634, 2.574068, 1.828615},
	{-0.210635, 3.067501, 1.828615},
	{-0.595058, 3.067500, 1.828615},
	{-0.595058, 2.528438, 1.828615},
	{-0.402846, 2.560647, 1.828615},
	{-0.402846, 3.067501, 1.828615},
	{-0.016501, 3.067501, 1.828615},
	{-0.016501, 2.560647, 1.828615},
	{0.181555, 2.528438, 1.828615},
	{0.181555, 3.067501, 1.828615},
	{-0.210635, 3.067501, 1.828615},
	{-0.210634, 2.574068, 1.828615},
	{-0.711104, 3.067500, 1.828615},
	{-0.711103, 2.651908, 1.828615},
	{-0.595058, 2.528438, 1.828615},
	{-0.595058, 3.067500, 1.828615},
	{0.181555, 3.067501, 1.828615},
	{0.181555, 2.528438, 1.828615},
	{0.291884, 2.651908, 1.828614},
	{0.291883, 3.067501, 1.828615},
	{-0.711104, 3.236759, 1.659006},
	{-0.796917, 3.067678, 1.655294},
	{-0.796917, 3.063439, 1.659183},
	{-0.711104, 3.067500, 1.828615},
	{-0.711104, 3.236759, 1.659006},
	{-0.711104, 3.067500, 1.828615},
	{-0.595058, 3.067500, 1.828615},
	{-0.595058, 3.236759, 1.659006},
	{-0.595058, 3.236759, 1.659006},
	{-0.595058, 3.067500, 1.828615},
	{-0.402846, 3.067501, 1.828615},
	{-0.402846, 3.236760, 1.659006},
	{-0.210635, 3.236760, 1.659006},
	{-0.402846, 3.236760, 1.659006},
	{-0.402846, 3.067501, 1.828615},
	{-0.210635, 3.067501, 1.828615},
	{-0.016501, 3.067501, 1.828615},
	{-0.016501, 3.236760, 1.659006},
	{0.181555, 3.236760, 1.659006},
	{0.181555, 3.067501, 1.828615},
	{0.291883, 3.236760, 1.659006},
	{0.291883, 3.067501, 1.828615},
	{0.291883, 3.236760, 1.659006},
	{0.291883, 3.067501, 1.828615},
	{0.377523, 3.063439, 1.659184},
	{0.377523, 3.067679, 1.655294},
	{-2.677097, 1.160612, 1.659006},
	{-2.677097, 1.270940, 1.659006},
	{-2.677097, 1.270940, 1.243413},
	{-2.677097, 1.160612, 1.119943},
	{-2.677097, 0.267953, 1.659006},
	{-2.677097, 0.383998, 1.659006},
	{-2.677097, 0.383998, 1.119943},
	{-2.677097, 0.267953, 1.243413},
	{-2.677097, 0.768422, 1.659006},
	{-2.677097, 0.962556, 1.659006},
	{-2.677097, 0.962556, 1.152152},
	{-2.677097, 0.768422, 1.165573},
	{-2.677097, 0.576210, 1.659006},
	{-2.677097, 0.576210, 1.152152},
	{-2.677097, 0.267953, 1.659006},
	{-2.677097, 0.267953, 1.243413},
	{-2.503777, 0.182140, 1.175375},
	{-2.503777, 0.182140, 1.659184},
	{-2.677097, 1.270940, 1.243413},
	{-2.677097, 1.270940, 1.659006},
	{-2.503777, 1.356580, 1.659184},
	{-2.503777, 1.356580, 1.175375},
	{-2.677097, 1.160612, 1.119943},
	{-2.677097, 1.270940, 1.243413},
	{-2.503777, 1.356580, 1.175375},
	{-2.503777, 1.227392, 1.030799},
	{-2.677097, 0.267953, 1.243413},
	{-2.677097, 0.383998, 1.119943},
	{-2.503777, 0.318022, 1.030799},
	{-2.503777, 0.182140, 1.175375},
	{-2.092245, 0.267953, 1.828615},
	{-2.024207, 0.182140, 1.655294},
	{-1.879631, 0.318023, 1.655294},
	{-1.968775, 0.383999, 1.828615},
	{-1.968775, 1.160612, 1.828615},
	{-1.879631, 1.227392, 1.655294},
	{-2.024208, 1.356580, 1.655294},
	{-2.092245, 1.270940, 1.828615},
	{-2.092245, 1.270940, 1.828615},
	{-2.024208, 1.356580, 1.655294},
	{-2.508016, 1.356580, 1.655294},
	{-2.507838, 1.270940, 1.828615},
	{-2.507838, 0.267953, 1.828615},
	{-2.508015, 0.182140, 1.655294},
	{-2.024207, 0.182140, 1.655294},
	{-2.092245, 0.267953, 1.828615},
	{-2.507838, 0.576210, 1.828615},
	{-2.000985, 0.576210, 1.828615},
	{-2.014405, 0.768422, 1.828615},
	{-2.507838, 0.768422, 1.828615},
	{-2.507838, 0.383998, 1.828615},
	{-1.968775, 0.383999, 1.828615},
	{-2.507838, 0.962556, 1.828615},
	{-2.000985, 0.962556, 1.828615},
	{-1.968775, 1.160612, 1.828615},
	{-2.507838, 1.160611, 1.828615},
	{-2.507838, 0.267953, 1.828615},
	{-2.092245, 0.267953, 1.828615},
	{-2.092245, 1.270940, 1.828615},
	{-2.507838, 1.270940, 1.828615},
	{-2.677097, 0.267953, 1.659006},
	{-2.508015, 0.182140, 1.655294},
	{-2.503777, 0.182140, 1.659184},
	{-2.507838, 0.267953, 1.828615},
	{-2.677097, 0.267953, 1.659006},
	{-2.507838, 0.267953, 1.828615},
	{-2.507838, 0.383998, 1.828615},
	{-2.677097, 0.383998, 1.659006},
	{-2.677097, 0.383998, 1.659006},
	{-2.507838, 0.383998, 1.828615},
	{-2.507838, 0.576210, 1.828615},
	{-2.677097, 0.576210, 1.659006},
	{-2.677097, 0.768422, 1.659006},
	{-2.507838, 0.768422, 1.828615},
	{-2.507838, 0.962556, 1.828615},
	{-2.677097, 0.962556, 1.659006},
	{-2.677097, 1.160612, 1.659006},
	{-2.507838, 1.160611, 1.828615},
	{-2.677097, 1.270940, 1.659006},
	{-2.507838, 1.270940, 1.828615},
	{-2.677097, 1.270940, 1.659006},
	{-2.507838, 1.270940, 1.828615},
	{-2.503777, 1.356580, 1.659184},
	{-2.508016, 1.356580, 1.655294},
	{2.257703, 0.378108, 1.659006},
	{2.257703, 0.267779, 1.659006},
	{2.257703, 0.267779, 1.243413},
	{2.257703, 0.378108, 1.119943},
	{2.257703, 1.270767, 1.659006},
	{2.257703, 1.154721, 1.659006},
	{2.257703, 1.154721, 1.119943},
	{2.257703, 1.270767, 1.243413},
	{2.257703, 0.770298, 1.659006},
	{2.257703, 0.576164, 1.659006},
	{2.257703, 0.576164, 1.152152},
	{2.257703, 0.770298, 1.165573},
	{2.257703, 0.962509, 1.659006},
	{2.257703, 0.962509, 1.152152},
	{2.257703, 1.270767, 1.659006},
	{2.257703, 1.270767, 1.243413},
	{2.084382, 1.356580, 1.175375},
	{2.084382, 1.356580, 1.659184},
	{2.257703, 0.267779, 1.243413},
	{2.257703, 0.267779, 1.659006},
	{2.084382, 0.182140, 1.659184},
	{2.084383, 0.182140, 1.175375},
	{2.257703, 0.378108, 1.119943},
	{2.257703, 0.267779, 1.243413},
	{2.084383, 0.182140, 1.175375},
	{2.084383, 0.311328, 1.030799},
	{2.257703, 1.270767, 1.243413},
	{2.257703, 1.154721, 1.119943},
	{2.084382, 1.220697, 1.030799},
	{2.084382, 1.356580, 1.175375},
	{1.672851, 1.270767, 1.828615},
	{1.604813, 1.356580, 1.655294},
	{1.460237, 1.220697, 1.655294},
	{1.549381, 1.154721, 1.828615},
	{1.549381, 0.378108, 1.828615},
	{1.460237, 0.311328, 1.655294},
	{1.604813, 0.182140, 1.655294},
	{1.672851, 0.267779, 1.828615},
	{1.672851, 0.267779, 1.828615},
	{1.604813, 0.182140, 1.655294},
	{2.088622, 0.182140, 1.655294},
	{2.088443, 0.267780, 1.828615},
	{2.088443, 1.270767, 1.828615},
	{2.088621, 1.356580, 1.655294},
	{1.604813, 1.356580, 1.655294},
	{1.672851, 1.270767, 1.828615},
	{2.088444, 0.962509, 1.828615},
	{1.581591, 0.962509, 1.828615},
	{1.595011, 0.770298, 1.828615},
	{2.088444, 0.770298, 1.828615},
	{2.088443, 1.154721, 1.828615},
	{1.549381, 1.154721, 1.828615},
	{2.088444, 0.576164, 1.828615},
	{1.581590, 0.576164, 1.828615},
	{1.549381, 0.378108, 1.828615},
	{2.088443, 0.378108, 1.828615},
	{2.088443, 1.270767, 1.828615},
	{1.672851, 1.270767, 1.828615},
	{1.549381, 1.154721, 1.828615},
	{2.088443, 1.154721, 1.828615},
	{1.672851, 0.267779, 1.828615},
	{2.088443, 0.267780, 1.828615},
	{2.257703, 1.270767, 1.659006},
	{2.088621, 1.356580, 1.655294},
	{2.084382, 1.356580, 1.659184},
	{2.088443, 1.270767, 1.828615},
	{2.257703, 1.270767, 1.659006},
	{2.088443, 1.270767, 1.828615},
	{2.088443, 1.154721, 1.828615},
	{2.257703, 1.154721, 1.659006},
	{2.257703, 1.154721, 1.659006},
	{2.088443, 1.154721, 1.828615},
	{2.088444, 0.962509, 1.828615},
	{2.257703, 0.962509, 1.659006},
	{2.257703, 0.770298, 1.659006},
	{2.257703, 0.962509, 1.659006},
	{2.088444, 0.962509, 1.828615},
	{2.088444, 0.770298, 1.828615},
	{2.088444, 0.576164, 1.828615},
	{2.257703, 0.576164, 1.659006},
	{2.257703, 0.378108, 1.659006},
	{2.257703, 0.576164, 1.659006},
	{2.088444, 0.576164, 1.828615},
	{2.088443, 0.378108, 1.828615},
	{2.257703, 0.267779, 1.659006},
	{2.257703, 0.378108, 1.659006},
	{2.088443, 0.378108, 1.828615},
	{2.088443, 0.267780, 1.828615},
	{2.257703, 0.267779, 1.659006},
	{2.088443, 0.267780, 1.828615},
	{2.084382, 0.182140, 1.659184},
	{2.088622, 0.182140, 1.655294},
	{2.086607, -1.521765, -2.935530},
	{2.086607, -1.521765, 1.659402},
	{-2.508325, -1.521765, 1.659402},
	{-2.508324, -1.521765, -2.935531},
	{2.086608, 3.073167, -2.935529},
	{-2.508325, 3.073167, -2.935530},
	{-2.508326, 3.073167, 1.659402},
	{2.086605, 3.073167, 1.659404},
	{2.086607, -1.521765, -2.935530},
	{2.086608, 3.073167, -2.935529},
	{2.086605, 3.073167, 1.659404},
	{2.086607, -1.521765, 1.659402},
	{2.086607, -1.521765, 1.659402},
	{2.086605, 3.073167, 1.659404},
	{-2.508326, 3.073167, 1.659402},
	{-2.508325, -1.521765, 1.659402},
	{-2.508325, -1.521765, 1.659402},
	{-2.508326, 3.073167, 1.659402},
	{-2.508325, 3.073167, -2.935530},
	{-2.508324, -1.521765, -2.935531},
	{2.086608, 3.073167, -2.935529},
	{2.086607, -1.521765, -2.935530},
	{-2.508324, -1.521765, -2.935531},
	{-2.508325, 3.073167, -2.935530},
	{-0.973861, 1.529520, -2.897064},
	{-0.973862, 1.529519, -3.030729},
	{-1.106700, 1.367654, -3.030729},
	{-1.106699, 1.367656, -2.897064},
	{-1.205408, 1.182984, -3.030729},
	{-1.205407, 1.182986, -2.897064},
	{-1.266192, 0.982606, -3.030729},
	{-1.266191, 0.982608, -2.897064},
	{-1.286715, 0.774220, -3.030729},
	{-1.286716, 0.774222, -2.897064},
	{-1.266191, 0.565834, -3.030729},
	{-1.266191, 0.565836, -2.897064},
	{-1.205406, 0.365456, -3.030729},
	{-1.205407, 0.365458, -2.897064},
	{-1.106698, 0.180787, -3.030729},
	{-1.106699, 0.180788, -2.897064},
	{-0.973860, 0.018923, -3.030729},
	{-0.973861, 0.018924, -2.897064},
	{-0.811996, -0.113915, -3.030729},
	{-0.811996, -0.113915, -2.897064},
	{-0.627327, -0.212623, -3.030729},
	{-0.627327, -0.212623, -2.897064},
	{-0.426949, -0.273407, -3.030729},
	{-0.426948, -0.273407, -2.897064},
	{-0.218563, -0.293931, -3.030729},
	{-0.218562, -0.293931, -2.897065},
	{-0.010177, -0.273407, -3.030729},
	{-0.010176, -0.273407, -2.897065},
	{0.190201, -0.212623, -3.030729},
	{0.190203, -0.212622, -2.897065},
	{0.374870, -0.113916, -3.030729},
	{0.374872, -0.113914, -2.897065},
	{0.536734, 0.018922, -3.030729},
	{0.536736, 0.018924, -2.897065},
	{0.669573, 0.180786, -3.030729},
	{0.669575, 0.180789, -2.897065},
	{0.768281, 0.365454, -3.030729},
	{0.768283, 0.365459, -2.897065},
	{0.829066, 0.565832, -3.030729},
	{0.829066, 0.565837, -2.897065},
	{0.849591, 0.774218, -3.030729},
	{0.849590, 0.774223, -2.897065},
	{0.829067, 0.982604, -3.030729},
	{0.829066, 0.982610, -2.897065},
	{0.768284, 1.182982, -3.030729},
	{0.768282, 1.182988, -2.897065},
	{0.669577, 1.367651, -3.030729},
	{0.669573, 1.367657, -2.897065},
	{0.536740, 1.529516, -3.030729},
	{0.536735, 1.529521, -2.897064},
	{0.374877, 1.662355, -3.030729},
	{0.374870, 1.662360, -2.897064},
	{0.190208, 1.761064, -3.030729},
	{0.190200, 1.761067, -2.897064},
	{-0.010169, 1.821849, -3.030729},
	{-0.010178, 1.821851, -2.897064},
	{-0.218555, 1.842375, -3.030729},
	{-0.218564, 1.842375, -2.897064},
	{-0.426941, 1.821852, -3.030729},
	{-0.426951, 1.821850, -2.897064},
	{-0.627319, 1.761070, -3.030729},
	{-0.627329, 1.761066, -2.897064},
	{-0.811989, 1.662364, -3.030729},
	{-0.811998, 1.662358, -2.897064},
	{-0.795541, 1.637747, -3.069480},
	{-0.952927, 1.508584, -3.069480},
	{-0.615989, 1.733717, -3.069480},
	{-0.421165, 1.792815, -3.069480},
	{-0.218555, 1.812769, -3.069480},
	{-0.015945, 1.792812, -3.069480},
	{0.178878, 1.733711, -3.069480},
	{0.358428, 1.637738, -3.069480},
	{0.515805, 1.508581, -3.069480},
	{0.644961, 1.351203, -3.069480},
	{0.740931, 1.171652, -3.069480},
	{0.800030, 0.976828, -3.069480},
	{0.819984, 0.774218, -3.069480},
	{0.800028, 0.571608, -3.069480},
	{0.740928, 0.376784, -3.069480},
	{0.644956, 0.197234, -3.069480},
	{0.515799, 0.039857, -3.069480},
	{0.358421, -0.089299, -3.069480},
	{0.178871, -0.185270, -3.069480},
	{-0.015953, -0.244369, -3.069480},
	{-0.218563, -0.264325, -3.069480},
	{-0.421173, -0.244369, -3.069480},
	{-0.615997, -0.185270, -3.069480},
	{-0.795547, -0.089298, -3.069480},
	{-0.952925, 0.039858, -3.069480},
	{-1.082081, 0.197235, -3.069480},
	{-1.178053, 0.376786, -3.069480},
	{-1.237153, 0.571610, -3.069480},
	{-1.257109, 0.774220, -3.069480},
	{-1.237154, 0.976830, -3.069480},
	{-1.178055, 1.171654, -3.069480},
	{-1.082083, 1.351206, -3.069480},
	{-1.082083, 1.351206, -3.069480},
	{-0.952927, 1.508584, -3.069480},
	{-0.831858, 1.387515, -3.102695},
	{-0.939722, 1.256083, -3.102695},
	{-1.178055, 1.171654, -3.069480},
	{-1.019871, 1.106133, -3.102695},
	{-1.237154, 0.976830, -3.069480},
	{-1.069227, 0.943428, -3.102695},
	{-1.257109, 0.774220, -3.069480},
	{-1.085892, 0.774220, -3.102695},
	{-1.237153, 0.571610, -3.069480},
	{-1.069226, 0.605012, -3.102695},
	{-1.178053, 0.376786, -3.069480},
	{-1.019870, 0.442308, -3.102695},
	{-1.082081, 0.197235, -3.069480},
	{-0.939720, 0.292358, -3.102695},
	{-0.952925, 0.039858, -3.069480},
	{-0.831857, 0.160926, -3.102695},
	{-0.795547, -0.089298, -3.069480},
	{-0.700425, 0.053063, -3.102695},
	{-0.615997, -0.185270, -3.069480},
	{-0.550475, -0.027087, -3.102695},
	{-0.421173, -0.244369, -3.069480},
	{-0.387770, -0.076443, -3.102695},
	{-0.218563, -0.264325, -3.069480},
	{-0.218563, -0.093108, -3.102695},
	{-0.015953, -0.244369, -3.069480},
	{-0.049355, -0.076443, -3.102695},
	{0.178871, -0.185270, -3.069480},
	{0.113349, -0.027087, -3.102695},
	{0.358421, -0.089299, -3.069480},
	{0.263299, 0.053062, -3.102695},
	{0.515799, 0.039857, -3.069480},
	{0.394731, 0.160925, -3.102695},
	{0.644956, 0.197234, -3.069480},
	{0.502595, 0.292357, -3.102695},
	{0.740928, 0.376784, -3.069480},
	{0.582745, 0.442306, -3.102695},
	{0.800028, 0.571608, -3.069480},
	{0.632102, 0.605011, -3.102695},
	{0.819984, 0.774218, -3.069480},
	{0.648768, 0.774218, -3.102695},
	{0.800030, 0.976828, -3.069480},
	{0.632103, 0.943426, -3.102695},
	{0.740931, 1.171652, -3.069480},
	{0.582748, 1.106131, -3.102695},
	{0.644961, 1.351203, -3.069480},
	{0.502599, 1.256081, -3.102695},
	{0.515805, 1.508581, -3.069480},
	{0.394736, 1.387513, -3.102695},
	{0.358428, 1.637738, -3.069480},
	{0.263305, 1.495378, -3.102695},
	{0.178878, 1.733711, -3.069480},
	{0.113356, 1.575528, -3.102695},
	{-0.015945, 1.792812, -3.069480},
	{-0.049349, 1.624885, -3.102695},
	{-0.218555, 1.812769, -3.069480},
	{-0.218556, 1.641552, -3.102695},
	{-0.421165, 1.792815, -3.069480},
	{-0.387763, 1.624888, -3.102695},
	{-0.615989, 1.733717, -3.069480},
	{-0.550469, 1.575533, -3.102695},
	{-0.795541, 1.637747, -3.069480},
	{-0.700419, 1.495384, -3.102695},
	{-0.218562, 0.774222, -3.102695},
	{-0.973861, 0.019035, 1.627663},
	{-0.973862, 0.019036, 1.761327},
	{-1.106700, 0.180901, 1.761328},
	{-1.106699, 0.180899, 1.627663},
	{-1.205408, 0.365571, 1.761327},
	{-1.205407, 0.365569, 1.627663},
	{-1.266192, 0.565949, 1.761327},
	{-1.266191, 0.565947, 1.627663},
	{-1.286716, 0.774335, 1.761327},
	{-1.286716, 0.774333, 1.627663},
	{-1.266191, 0.982721, 1.761327},
	{-1.266191, 0.982719, 1.627663},
	{-1.205407, 1.183099, 1.761327},
	{-1.205407, 1.183097, 1.627663},
	{-1.106699, 1.367768, 1.761327},
	{-1.106700, 1.367767, 1.627663},
	{-0.973860, 1.529632, 1.761327},
	{-0.973861, 1.529631, 1.627662},
	{-0.811996, 1.662470, 1.761327},
	{-0.811997, 1.662470, 1.627662},
	{-0.627327, 1.761178, 1.761327},
	{-0.627327, 1.761178, 1.627662},
	{-0.426950, 1.821962, 1.761327},
	{-0.426949, 1.821962, 1.627662},
	{-0.218564, 1.842486, 1.761327},
	{-0.218562, 1.842486, 1.627662},
	{-0.010178, 1.821962, 1.761327},
	{-0.010176, 1.821962, 1.627662},
	{0.190200, 1.761179, 1.761327},
	{0.190202, 1.761178, 1.627662},
	{0.374869, 1.662471, 1.761327},
	{0.374872, 1.662470, 1.627662},
	{0.536734, 1.529633, 1.761327},
	{0.536736, 1.529631, 1.627662},
	{0.669572, 1.367770, 1.761327},
	{0.669574, 1.367767, 1.627662},
	{0.768281, 1.183101, 1.761327},
	{0.768282, 1.183097, 1.627662},
	{0.829065, 0.982723, 1.761327},
	{0.829066, 0.982719, 1.627662},
	{0.849590, 0.774338, 1.761327},
	{0.849590, 0.774332, 1.627662},
	{0.829067, 0.565952, 1.761327},
	{0.829066, 0.565946, 1.627662},
	{0.768284, 0.365574, 1.761327},
	{0.768282, 0.365568, 1.627662},
	{0.669577, 0.180904, 1.761327},
	{0.669573, 0.180898, 1.627662},
	{0.536740, 0.019039, 1.761327},
	{0.536735, 0.019034, 1.627662},
	{0.374877, -0.113800, 1.761327},
	{0.374870, -0.113804, 1.627662},
	{0.190208, -0.212509, 1.761327},
	{0.190200, -0.212512, 1.627662},
	{-0.010169, -0.273294, 1.761327},
	{-0.010178, -0.273296, 1.627662},
	{-0.218555, -0.293820, 1.761327},
	{-0.218564, -0.293820, 1.627663},
	{-0.426941, -0.273297, 1.761327},
	{-0.426951, -0.273295, 1.627663},
	{-0.627319, -0.212515, 1.761327},
	{-0.627329, -0.212511, 1.627663},
	{-0.811989, -0.113809, 1.761327},
	{-0.811998, -0.113802, 1.627663},
	{-0.795541, -0.089192, 1.800079},
	{-0.952927, 0.039971, 1.800079},
	{-0.615989, -0.185162, 1.800079},
	{-0.421165, -0.244259, 1.800079},
	{-0.218555, -0.264213, 1.800079},
	{-0.015945, -0.244256, 1.800079},
	{0.178878, -0.185156, 1.800079},
	{0.358428, -0.089183, 1.800079},
	{0.515805, 0.039974, 1.800078},
	{0.644961, 0.197352, 1.800078},
	{0.740931, 0.376904, 1.800078},
	{0.800030, 0.571728, 1.800078},
	{0.819984, 0.774338, 1.800078},
	{0.800028, 0.976948, 1.800078},
	{0.740928, 1.171771, 1.800078},
	{0.644956, 1.351321, 1.800078},
	{0.515799, 1.508698, 1.800078},
	{0.358421, 1.637854, 1.800078},
	{0.178870, 1.733826, 1.800078},
	{-0.015954, 1.792925, 1.800078},
	{-0.218564, 1.812880, 1.800078},
	{-0.421174, 1.792924, 1.800078},
	{-0.615997, 1.733825, 1.800078},
	{-0.795548, 1.637853, 1.800078},
	{-0.952925, 1.508697, 1.800078},
	{-1.082082, 1.351320, 1.800078},
	{-1.178054, 1.171769, 1.800078},
	{-1.237153, 0.976945, 1.800078},
	{-1.257109, 0.774335, 1.800078},
	{-1.237154, 0.571725, 1.800079},
	{-1.178055, 0.376901, 1.800079},
	{-1.082083, 0.197349, 1.800079},
	{-1.082083, 0.197349, 1.800079},
	{-0.952927, 0.039971, 1.800079},
	{-0.831858, 0.161040, 1.833294},
	{-0.939722, 0.292472, 1.833294},
	{-1.178055, 0.376901, 1.800079},
	{-1.019871, 0.442422, 1.833294},
	{-1.237154, 0.571725, 1.800079},
	{-1.069227, 0.605127, 1.833294},
	{-1.257109, 0.774335, 1.800078},
	{-1.085892, 0.774335, 1.833294},
	{-1.237153, 0.976945, 1.800078},
	{-1.069227, 0.943543, 1.833294},
	{-1.178054, 1.171769, 1.800078},
	{-1.019870, 1.106247, 1.833294},
	{-1.082082, 1.351320, 1.800078},
	{-0.939720, 1.256197, 1.833294},
	{-0.952925, 1.508697, 1.800078},
	{-0.831857, 1.387629, 1.833294},
	{-0.795548, 1.637853, 1.800078},
	{-0.700425, 1.495492, 1.833294},
	{-0.615997, 1.733825, 1.800078},
	{-0.550475, 1.575642, 1.833294},
	{-0.421174, 1.792924, 1.800078},
	{-0.387771, 1.624998, 1.833294},
	{-0.218564, 1.812880, 1.800078},
	{-0.218563, 1.641664, 1.833294},
	{-0.015954, 1.792925, 1.800078},
	{-0.049356, 1.624998, 1.833294},
	{0.178870, 1.733826, 1.800078},
	{0.113349, 1.575643, 1.833294},
	{0.358421, 1.637854, 1.800078},
	{0.263299, 1.495493, 1.833294},
	{0.515799, 1.508698, 1.800078},
	{0.394731, 1.387630, 1.833294},
	{0.644956, 1.351321, 1.800078},
	{0.502595, 1.256198, 1.833294},
	{0.740928, 1.171771, 1.800078},
	{0.582745, 1.106249, 1.833294},
	{0.800028, 0.976948, 1.800078},
	{0.632102, 0.943544, 1.833294},
	{0.819984, 0.774338, 1.800078},
	{0.648768, 0.774337, 1.833294},
	{0.800030, 0.571728, 1.800078},
	{0.632103, 0.605130, 1.833294},
	{0.740931, 0.376904, 1.800078},
	{0.582748, 0.442425, 1.833294},
	{0.644961, 0.197352, 1.800078},
	{0.502599, 0.292475, 1.833294},
	{0.515805, 0.039974, 1.800078},
	{0.394736, 0.161042, 1.833294},
	{0.358428, -0.089183, 1.800079},
	{0.263305, 0.053178, 1.833294},
	{0.178878, -0.185156, 1.800079},
	{0.113356, -0.026973, 1.833294},
	{-0.015945, -0.244256, 1.800079},
	{-0.049349, -0.076330, 1.833294},
	{-0.218555, -0.264213, 1.800079},
	{-0.218556, -0.092997, 1.833294},
	{-0.421165, -0.244259, 1.800079},
	{-0.387763, -0.076333, 1.833294},
	{-0.615989, -0.185162, 1.800079},
	{-0.550468, -0.026978, 1.833294},
	{-0.795541, -0.089192, 1.800079},
	{-0.700419, 0.053171, 1.833294},
	{-0.218562, 0.774334, 1.833294},
	{-0.973861, -1.488086, -1.389944},
	{-0.973862, -1.621751, -1.389942},
	{-1.106700, -1.621751, -1.228078},
	{-1.106699, -1.488086, -1.228079},
	{-1.205408, -1.621751, -1.043408},
	{-1.205407, -1.488086, -1.043410},
	{-1.266192, -1.621751, -0.843029},
	{-1.266191, -1.488086, -0.843032},
	{-1.286715, -1.621751, -0.634643},
	{-1.286716, -1.488086, -0.634646},
	{-1.266191, -1.621751, -0.426257},
	{-1.266191, -1.488086, -0.426259},
	{-1.205407, -1.621751, -0.225880},
	{-1.205407, -1.488086, -0.225881},
	{-1.106699, -1.621751, -0.041210},
	{-1.106699, -1.488086, -0.041211},
	{-0.973860, -1.621751, 0.120653},
	{-0.973861, -1.488086, 0.120653},
	{-0.811996, -1.621751, 0.253491},
	{-0.811997, -1.488086, 0.253491},
	{-0.627327, -1.621750, 0.352199},
	{-0.627327, -1.488086, 0.352199},
	{-0.426949, -1.621750, 0.412983},
	{-0.426949, -1.488086, 0.412983},
	{-0.218563, -1.621750, 0.433508},
	{-0.218562, -1.488086, 0.433507},
	{-0.010178, -1.621750, 0.412983},
	{-0.010176, -1.488086, 0.412983},
	{0.190200, -1.621750, 0.352200},
	{0.190202, -1.488086, 0.352199},
	{0.374870, -1.621750, 0.253492},
	{0.374872, -1.488086, 0.253491},
	{0.536734, -1.621750, 0.120655},
	{0.536736, -1.488086, 0.120652},
	{0.669572, -1.621750, -0.041209},
	{0.669575, -1.488086, -0.041212},
	{0.768281, -1.621750, -0.225878},
	{0.768282, -1.488086, -0.225882},
	{0.829065, -1.621750, -0.426255},
	{0.829066, -1.488086, -0.426260},
	{0.849590, -1.621750, -0.634641},
	{0.849590, -1.488086, -0.634647},
	{0.829067, -1.621750, -0.843027},
	{0.829066, -1.488086, -0.843033},
	{0.768284, -1.621750, -1.043405},
	{0.768282, -1.488086, -1.043411},
	{0.669577, -1.621750, -1.228075},
	{0.669573, -1.488086, -1.228081},
	{0.536740, -1.621750, -1.389939},
	{0.536735, -1.488086, -1.389945},
	{0.374877, -1.621750, -1.522779},
	{0.374870, -1.488086, -1.522783},
	{0.190208, -1.621751, -1.621487},
	{0.190200, -1.488086, -1.621491},
	{-0.010169, -1.621751, -1.682273},
	{-0.010178, -1.488086, -1.682274},
	{-0.218555, -1.621751, -1.702798},
	{-0.218564, -1.488086, -1.702798},
	{-0.426941, -1.621751, -1.682276},
	{-0.426951, -1.488086, -1.682274},
	{-0.627319, -1.621751, -1.621493},
	{-0.627329, -1.488086, -1.621489},
	{-0.811989, -1.621751, -1.522787},
	{-0.811998, -1.488086, -1.522781},
	{-0.795541, -1.660502, -1.498170},
	{-0.952927, -1.660502, -1.369007},
	{-0.615989, -1.660502, -1.594140},
	{-0.421165, -1.660502, -1.653238},
	{-0.218555, -1.660502, -1.673192},
	{-0.015945, -1.660502, -1.653235},
	{0.178878, -1.660502, -1.594135},
	{0.358428, -1.660502, -1.498162},
	{0.515805, -1.660502, -1.369004},
	{0.644960, -1.660502, -1.211626},
	{0.740931, -1.660502, -1.032075},
	{0.800030, -1.660502, -0.837251},
	{0.819984, -1.660502, -0.634641},
	{0.800028, -1.660502, -0.432031},
	{0.740928, -1.660501, -0.237208},
	{0.644956, -1.660501, -0.057657},
	{0.515799, -1.660501, 0.099720},
	{0.358421, -1.660502, 0.228876},
	{0.178870, -1.660502, 0.324847},
	{-0.015953, -1.660502, 0.383946},
	{-0.218563, -1.660502, 0.403901},
	{-0.421173, -1.660502, 0.383946},
	{-0.615997, -1.660502, 0.324846},
	{-0.795548, -1.660502, 0.228875},
	{-0.952925, -1.660502, 0.099718},
	{-1.082082, -1.660502, -0.057659},
	{-1.178054, -1.660502, -0.237209},
	{-1.237153, -1.660502, -0.432033},
	{-1.257109, -1.660502, -0.634643},
	{-1.237154, -1.660502, -0.837254},
	{-1.178055, -1.660502, -1.032078},
	{-1.082083, -1.660502, -1.211629},
	{-1.082083, -1.660502, -1.211629},
	{-0.952927, -1.660502, -1.369007},
	{-0.831858, -1.693717, -1.247939},
	{-0.939722, -1.693717, -1.116506},
	{-1.178055, -1.660502, -1.032078},
	{-1.019871, -1.693717, -0.966556},
	{-1.237154, -1.660502, -0.837254},
	{-1.069227, -1.693717, -0.803851},
	{-1.257109, -1.660502, -0.634643},
	{-1.085892, -1.693717, -0.634643},
	{-1.237153, -1.660502, -0.432033},
	{-1.069226, -1.693717, -0.465436},
	{-1.178054, -1.660502, -0.237209},
	{-1.019870, -1.693717, -0.302731},
	{-1.082082, -1.660502, -0.057659},
	{-0.939720, -1.693717, -0.152782},
	{-0.952925, -1.660502, 0.099718},
	{-0.831857, -1.693717, -0.021350},
	{-0.795548, -1.660502, 0.228875},
	{-0.700425, -1.693717, 0.086514},
	{-0.615997, -1.660502, 0.324846},
	{-0.550475, -1.693717, 0.166663},
	{-0.421173, -1.660502, 0.383946},
	{-0.387770, -1.693717, 0.216019},
	{-0.218563, -1.660502, 0.403901},
	{-0.218563, -1.693717, 0.232685},
	{-0.015953, -1.660502, 0.383946},
	{-0.049356, -1.693717, 0.216020},
	{0.178870, -1.660502, 0.324847},
	{0.113349, -1.693717, 0.166664},
	{0.358421, -1.660502, 0.228876},
	{0.263299, -1.693717, 0.086514},
	{0.515799, -1.660501, 0.099720},
	{0.394731, -1.693717, -0.021349},
	{0.644956, -1.660501, -0.057657},
	{0.502595, -1.693717, -0.152780},
	{0.740928, -1.660501, -0.237208},
	{0.582745, -1.693717, -0.302730},
	{0.800028, -1.660502, -0.432031},
	{0.632102, -1.693717, -0.465434},
	{0.819984, -1.660502, -0.634641},
	{0.648768, -1.693717, -0.634642},
	{0.800030, -1.660502, -0.837251},
	{0.632103, -1.693717, -0.803849},
	{0.740931, -1.660502, -1.032075},
	{0.582748, -1.693717, -0.966554},
	{0.644960, -1.660502, -1.211626},
	{0.502599, -1.693717, -1.116504},
	{0.515805, -1.660502, -1.369004},
	{0.394736, -1.693717, -1.247937},
	{0.358428, -1.660502, -1.498162},
	{0.263305, -1.693717, -1.355801},
	{0.178878, -1.660502, -1.594135},
	{0.113356, -1.693717, -1.435951},
	{-0.015945, -1.660502, -1.653235},
	{-0.049349, -1.693717, -1.485309},
	{-0.218555, -1.660502, -1.673192},
	{-0.218556, -1.693717, -1.501975},
	{-0.421165, -1.660502, -1.653238},
	{-0.387763, -1.693717, -1.485311},
	{-0.615989, -1.660502, -1.594140},
	{-0.550469, -1.693717, -1.435956},
	{-0.795541, -1.660502, -1.498170},
	{-0.700419, -1.693717, -1.355808},
	{-0.218562, -1.693717, -0.634645},
	{-0.973861, 3.036641, 0.120542},
	{-0.973862, 3.170305, 0.120540},
	{-1.106700, 3.170305, -0.041324},
	{-1.106699, 3.036641, -0.041322},
	{-1.205408, 3.170305, -0.225994},
	{-1.205407, 3.036641, -0.225992},
	{-1.266192, 3.170305, -0.426372},
	{-1.266191, 3.036641, -0.426370},
	{-1.286715, 3.170305, -0.634759},
	{-1.286716, 3.036641, -0.634756},
	{-1.266191, 3.170305, -0.843144},
	{-1.266191, 3.036640, -0.843142},
	{-1.205406, 3.170305, -1.043522},
	{-1.205407, 3.036640, -1.043520},
	{-1.106698, 3.170305, -1.228191},
	{-1.106699, 3.036640, -1.228190},
	{-0.973860, 3.170305, -1.390055},
	{-0.973861, 3.036640, -1.390054},
	{-0.811996, 3.170305, -1.522893},
	{-0.811996, 3.036641, -1.522893},
	{-0.627327, 3.170305, -1.621601},
	{-0.627327, 3.036641, -1.621601},
	{-0.426949, 3.170305, -1.682385},
	{-0.426949, 3.036641, -1.682385},
	{-0.218563, 3.170305, -1.702909},
	{-0.218562, 3.036641, -1.702909},
	{-0.010177, 3.170305, -1.682385},
	{-0.010176, 3.036641, -1.682385},
	{0.190200, 3.170305, -1.621602},
	{0.190202, 3.036641, -1.621601},
	{0.374870, 3.170305, -1.522894},
	{0.374872, 3.036641, -1.522893},
	{0.536734, 3.170305, -1.390056},
	{0.536736, 3.036641, -1.390054},
	{0.669573, 3.170305, -1.228193},
	{0.669575, 3.036641, -1.228190},
	{0.768281, 3.170306, -1.043524},
	{0.768282, 3.036641, -1.043520},
	{0.829066, 3.170306, -0.843146},
	{0.829066, 3.036641, -0.843142},
	{0.849591, 3.170306, -0.634761},
	{0.849590, 3.036641, -0.634755},
	{0.829067, 3.170306, -0.426375},
	{0.829066, 3.036641, -0.426369},
	{0.768284, 3.170306, -0.225997},
	{0.768282, 3.036641, -0.225991},
	{0.669577, 3.170306, -0.041327},
	{0.669574, 3.036641, -0.041321},
	{0.536740, 3.170306, 0.120538},
	{0.536735, 3.036641, 0.120543},
	{0.374877, 3.170306, 0.253377},
	{0.374870, 3.036641, 0.253381},
	{0.190208, 3.170306, 0.352086},
	{0.190201, 3.036641, 0.352089},
	{-0.010169, 3.170306, 0.412871},
	{-0.010178, 3.036641, 0.412873},
	{-0.218555, 3.170306, 0.433397},
	{-0.218564, 3.036641, 0.433397},
	{-0.426941, 3.170305, 0.412874},
	{-0.426951, 3.036641, 0.412872},
	{-0.627319, 3.170305, 0.352092},
	{-0.627329, 3.036641, 0.352088},
	{-0.811989, 3.170305, 0.253385},
	{-0.811998, 3.036641, 0.253379},
	{-0.795540, 3.209057, 0.228768},
	{-0.952927, 3.209057, 0.099606},
	{-0.615989, 3.209057, 0.324739},
	{-0.421165, 3.209057, 0.383836},
	{-0.218555, 3.209057, 0.403790},
	{-0.015945, 3.209057, 0.383833},
	{0.178878, 3.209057, 0.324733},
	{0.358428, 3.209057, 0.228760},
	{0.515805, 3.209057, 0.099603},
	{0.644961, 3.209057, -0.057775},
	{0.740931, 3.209057, -0.237327},
	{0.800030, 3.209057, -0.432151},
	{0.819984, 3.209057, -0.634761},
	{0.800028, 3.209057, -0.837370},
	{0.740928, 3.209057, -1.032194},
	{0.644956, 3.209057, -1.211744},
	{0.515799, 3.209057, -1.369121},
	{0.358421, 3.209057, -1.498277},
	{0.178870, 3.209057, -1.594249},
	{-0.015953, 3.209057, -1.653348},
	{-0.218563, 3.209057, -1.673303},
	{-0.421173, 3.209057, -1.653347},
	{-0.615997, 3.209057, -1.594248},
	{-0.795548, 3.209057, -1.498276},
	{-0.952925, 3.209057, -1.369120},
	{-1.082082, 3.209057, -1.211743},
	{-1.178054, 3.209057, -1.032192},
	{-1.237153, 3.209057, -0.837369},
	{-1.257109, 3.209057, -0.634759},
	{-1.237154, 3.209057, -0.432148},
	{-1.178055, 3.209057, -0.237324},
	{-1.082083, 3.209057, -0.057772},
	{-1.082083, 3.209057, -0.057772},
	{-0.952927, 3.209057, 0.099606},
	{-0.831858, 3.242272, -0.021463},
	{-0.939722, 3.242272, -0.152895},
	{-1.178055, 3.209057, -0.237324},
	{-1.019871, 3.242272, -0.302845},
	{-1.237154, 3.209057, -0.432148},
	{-1.069227, 3.242272, -0.465551},
	{-1.257109, 3.209057, -0.634759},
	{-1.085892, 3.242272, -0.634758},
	{-1.237153, 3.209057, -0.837369},
	{-1.069226, 3.242272, -0.803966},
	{-1.178054, 3.209057, -1.032192},
	{-1.019870, 3.242272, -0.966671},
	{-1.082082, 3.209057, -1.211743},
	{-0.939720, 3.242272, -1.116620},
	{-0.952925, 3.209057, -1.369120},
	{-0.831857, 3.242272, -1.248052},
	{-0.795548, 3.209057, -1.498276},
	{-0.700425, 3.242272, -1.355915},
	{-0.615997, 3.209057, -1.594248},
	{-0.550475, 3.242272, -1.436065},
	{-0.421173, 3.209057, -1.653347},
	{-0.387770, 3.242272, -1.485421},
	{-0.218563, 3.209057, -1.673303},
	{-0.218563, 3.242272, -1.502087},
	{-0.015953, 3.209057, -1.653348},
	{-0.049356, 3.242272, -1.485421},
	{0.178870, 3.209057, -1.594249},
	{0.113349, 3.242272, -1.436066},
	{0.358421, 3.209057, -1.498277},
	{0.263299, 3.242272, -1.355916},
	{0.515799, 3.209057, -1.369121},
	{0.394731, 3.242272, -1.248053},
	{0.644956, 3.209057, -1.211744},
	{0.502595, 3.242272, -1.116621},
	{0.740928, 3.209057, -1.032194},
	{0.582745, 3.242272, -0.966672},
	{0.800028, 3.209057, -0.837370},
	{0.632102, 3.242272, -0.803967},
	{0.819984, 3.209057, -0.634761},
	{0.648768, 3.242272, -0.634760},
	{0.800030, 3.209057, -0.432151},
	{0.632103, 3.242272, -0.465553},
	{0.740931, 3.209057, -0.237327},
	{0.582748, 3.242272, -0.302848},
	{0.644961, 3.209057, -0.057775},
	{0.502599, 3.242272, -0.152898},
	{0.515805, 3.209057, 0.099603},
	{0.394736, 3.242272, -0.021465},
	{0.358428, 3.209057, 0.228760},
	{0.263305, 3.242272, 0.086399},
	{0.178878, 3.209057, 0.324733},
	{0.113356, 3.242272, 0.166550},
	{-0.015945, 3.209057, 0.383833},
	{-0.049349, 3.242272, 0.215907},
	{-0.218555, 3.209057, 0.403790},
	{-0.218556, 3.242272, 0.232573},
	{-0.421165, 3.209057, 0.383836},
	{-0.387763, 3.242272, 0.215909},
	{-0.615989, 3.209057, 0.324739},
	{-0.550468, 3.242272, 0.166555},
	{-0.795540, 3.209057, 0.228768},
	{-0.700419, 3.242272, 0.086406},
	{-0.218562, 3.242272, -0.634757},
	{-2.473807, 0.011860, 0.120542},
	{-2.607471, 0.011859, 0.120541},
	{-2.607471, -0.120980, -0.041324},
	{-2.473807, -0.120978, -0.041322},
	{-2.607471, -0.219687, -0.225994},
	{-2.473807, -0.219686, -0.225992},
	{-2.607471, -0.280471, -0.426372},
	{-2.473807, -0.280470, -0.426370},
	{-2.607471, -0.300995, -0.634758},
	{-2.473807, -0.300995, -0.634756},
	{-2.607471, -0.280470, -0.843144},
	{-2.473807, -0.280470, -0.843142},
	{-2.607471, -0.219686, -1.043522},
	{-2.473807, -0.219686, -1.043520},
	{-2.607471, -0.120978, -1.228191},
	{-2.473807, -0.120978, -1.228190},
	{-2.607471, 0.011861, -1.390055},
	{-2.473807, 0.011860, -1.390054},
	{-2.607471, 0.173725, -1.522893},
	{-2.473807, 0.173724, -1.522893},
	{-2.607471, 0.358394, -1.621601},
	{-2.473807, 0.358394, -1.621601},
	{-2.607471, 0.558772, -1.682385},
	{-2.473807, 0.558772, -1.682385},
	{-2.607471, 0.767158, -1.702909},
	{-2.473807, 0.767159, -1.702909},
	{-2.607471, 0.975543, -1.682385},
	{-2.473807, 0.975545, -1.682385},
	{-2.607471, 1.175921, -1.621601},
	{-2.473807, 1.175923, -1.621600},
	{-2.607471, 1.360591, -1.522894},
	{-2.473807, 1.360593, -1.522892},
	{-2.607471, 1.522455, -1.390056},
	{-2.473807, 1.522457, -1.390054},
	{-2.607471, 1.655293, -1.228193},
	{-2.473807, 1.655296, -1.228189},
	{-2.607471, 1.754002, -1.043524},
	{-2.473807, 1.754004, -1.043520},
	{-2.607471, 1.814786, -0.843146},
	{-2.473807, 1.814787, -0.843141},
	{-2.607471, 1.835312, -0.634760},
	{-2.473807, 1.835311, -0.634755},
	{-2.607471, 1.814788, -0.426374},
	{-2.473807, 1.814787, -0.426369},
	{-2.607471, 1.754005, -0.225996},
	{-2.473807, 1.754003, -0.225991},
	{-2.607471, 1.655298, -0.041327},
	{-2.473807, 1.655294, -0.041321},
	{-2.607471, 1.522461, 0.120538},
	{-2.473807, 1.522456, 0.120543},
	{-2.607471, 1.360598, 0.253377},
	{-2.473807, 1.360591, 0.253381},
	{-2.607471, 1.175929, 0.352086},
	{-2.473807, 1.175921, 0.352089},
	{-2.607471, 0.975552, 0.412871},
	{-2.473807, 0.975543, 0.412873},
	{-2.607471, 0.767166, 0.433397},
	{-2.473807, 0.767157, 0.433397},
	{-2.607471, 0.558780, 0.412874},
	{-2.473807, 0.558770, 0.412872},
	{-2.607471, 0.358402, 0.352092},
	{-2.473807, 0.358392, 0.352088},
	{-2.607471, 0.173732, 0.253386},
	{-2.473807, 0.173723, 0.253380},
	{-2.646223, 0.190181, 0.228769},
	{-2.646223, 0.032794, 0.099606},
	{-2.646223, 0.369732, 0.324739},
	{-2.646223, 0.564556, 0.383837},
	{-2.646223, 0.767166, 0.403790},
	{-2.646223, 0.969776, 0.383834},
	{-2.646223, 1.164599, 0.324733},
	{-2.646223, 1.344149, 0.228760},
	{-2.646223, 1.501526, 0.099603},
	{-2.646223, 1.630682, -0.057775},
	{-2.646223, 1.726652, -0.237326},
	{-2.646223, 1.785751, -0.432150},
	{-2.646223, 1.805705, -0.634760},
	{-2.646223, 1.785749, -0.837370},
	{-2.646223, 1.726649, -1.032194},
	{-2.646223, 1.630677, -1.211744},
	{-2.646223, 1.501520, -1.369121},
	{-2.646223, 1.344142, -1.498277},
	{-2.646223, 1.164592, -1.594249},
	{-2.646223, 0.969768, -1.653347},
	{-2.646223, 0.767158, -1.673303},
	{-2.646223, 0.564548, -1.653347},
	{-2.646223, 0.369724, -1.594248},
	{-2.646223, 0.190173, -1.498276},
	{-2.646223, 0.032796, -1.369120},
	{-2.646223, -0.096360, -1.211743},
	{-2.646223, -0.192333, -1.032192},
	{-2.646223, -0.251432, -0.837368},
	{-2.646223, -0.271388, -0.634758},
	{-2.646223, -0.251433, -0.432148},
	{-2.646223, -0.192334, -0.237324},
	{-2.646223, -0.096362, -0.057772},
	{-2.646223, -0.096362, -0.057772},
	{-2.646223, 0.032794, 0.099606},
	{-2.679438, 0.153863, -0.021463},
	{-2.679438, 0.045999, -0.152895},
	{-2.646223, -0.192334, -0.237324},
	{-2.679438, -0.034150, -0.302845},
	{-2.646223, -0.251433, -0.432148},
	{-2.679438, -0.083506, -0.465550},
	{-2.646223, -0.271388, -0.634758},
	{-2.679438, -0.100171, -0.634758},
	{-2.646223, -0.251432, -0.837368},
	{-2.679438, -0.083505, -0.803966},
	{-2.646223, -0.192333, -1.032192},
	{-2.679438, -0.034149, -0.966670},
	{-2.646223, -0.096360, -1.211743},
	{-2.679438, 0.046001, -1.116620},
	{-2.646223, 0.032796, -1.369120},
	{-2.679438, 0.153864, -1.248052},
	{-2.646223, 0.190173, -1.498276},
	{-2.679438, 0.285296, -1.355915},
	{-2.646223, 0.369724, -1.594248},
	{-2.679438, 0.435246, -1.436065},
	{-2.646223, 0.564548, -1.653347},
	{-2.679438, 0.597951, -1.485421},
	{-2.646223, 0.767158, -1.673303},
	{-2.679438, 0.767158, -1.502086},
	{-2.646223, 0.969768, -1.653347},
	{-2.679438, 0.936365, -1.485421},
	{-2.646223, 1.164592, -1.594249},
	{-2.679438, 1.099070, -1.436065},
	{-2.646223, 1.344142, -1.498277},
	{-2.679438, 1.249020, -1.355916},
	{-2.646223, 1.501520, -1.369121},
	{-2.679438, 1.380452, -1.248053},
	{-2.646223, 1.630677, -1.211744},
	{-2.679438, 1.488316, -1.116621},
	{-2.646223, 1.726649, -1.032194},
	{-2.679438, 1.568466, -0.966672},
	{-2.646223, 1.785749, -0.837370},
	{-2.679438, 1.617823, -0.803967},
	{-2.646223, 1.805705, -0.634760},
	{-2.679438, 1.634489, -0.634760},
	{-2.646223, 1.785751, -0.432150},
	{-2.679438, 1.617824, -0.465552},
	{-2.646223, 1.726652, -0.237326},
	{-2.679438, 1.568469, -0.302847},
	{-2.646223, 1.630682, -0.057775},
	{-2.679438, 1.488320, -0.152897},
	{-2.646223, 1.501526, 0.099603},
	{-2.679438, 1.380457, -0.021465},
	{-2.646223, 1.344149, 0.228760},
	{-2.679438, 1.249026, 0.086399},
	{-2.646223, 1.164599, 0.324733},
	{-2.679438, 1.099077, 0.166550},
	{-2.646223, 0.969776, 0.383834},
	{-2.679438, 0.936372, 0.215907},
	{-2.646223, 0.767166, 0.403790},
	{-2.679438, 0.767165, 0.232574},
	{-2.646223, 0.564556, 0.383837},
	{-2.679438, 0.597958, 0.215910},
	{-2.646223, 0.369732, 0.324739},
	{-2.679438, 0.435252, 0.166555},
	{-2.646223, 0.190181, 0.228769},
	{-2.679438, 0.285302, 0.086406},
	{-2.679438, 0.767159, -0.634756},
	{2.050920, 0.011860, -1.389944},
	{2.184585, 0.011859, -1.389942},
	{2.184585, -0.120979, -1.228078},
	{2.050920, -0.120978, -1.228080},
	{2.184585, -0.219687, -1.043408},
	{2.050920, -0.219686, -1.043410},
	{2.184585, -0.280471, -0.843030},
	{2.050920, -0.280470, -0.843032},
	{2.184585, -0.300995, -0.634643},
	{2.050920, -0.300995, -0.634646},
	{2.184585, -0.280470, -0.426257},
	{2.050920, -0.280470, -0.426259},
	{2.184585, -0.219686, -0.225880},
	{2.050920, -0.219686, -0.225881},
	{2.184585, -0.120977, -0.041211},
	{2.050920, -0.120978, -0.041212},
	{2.184585, 0.011861, 0.120653},
	{2.050920, 0.011860, 0.120653},
	{2.184585, 0.173725, 0.253491},
	{2.050920, 0.173725, 0.253491},
	{2.184585, 0.358394, 0.352199},
	{2.050920, 0.358394, 0.352199},
	{2.184585, 0.558772, 0.412983},
	{2.050920, 0.558772, 0.412983},
	{2.184585, 0.767158, 0.433507},
	{2.050920, 0.767159, 0.433507},
	{2.184585, 0.975544, 0.412983},
	{2.050920, 0.975545, 0.412983},
	{2.184585, 1.175921, 0.352200},
	{2.050920, 1.175923, 0.352199},
	{2.184585, 1.360591, 0.253492},
	{2.050920, 1.360593, 0.253491},
	{2.184585, 1.522455, 0.120654},
	{2.050920, 1.522457, 0.120652},
	{2.184585, 1.655294, -0.041209},
	{2.050920, 1.655296, -0.041212},
	{2.184585, 1.754002, -0.225878},
	{2.050920, 1.754004, -0.225882},
	{2.184585, 1.814787, -0.426255},
	{2.050920, 1.814787, -0.426260},
	{2.184585, 1.835312, -0.634641},
	{2.050920, 1.835311, -0.634647},
	{2.184584, 1.814788, -0.843027},
	{2.050920, 1.814787, -0.843033},
	{2.184585, 1.754005, -1.043405},
	{2.050920, 1.754003, -1.043411},
	{2.184585, 1.655299, -1.228075},
	{2.050920, 1.655295, -1.228081},
	{2.184585, 1.522461, -1.389940},
	{2.050920, 1.522456, -1.389945},
	{2.184585, 1.360598, -1.522779},
	{2.050920, 1.360591, -1.522783},
	{2.184585, 1.175929, -1.621488},
	{2.050920, 1.175921, -1.621491},
	{2.184585, 0.975552, -1.682273},
	{2.050920, 0.975543, -1.682275},
	{2.184585, 0.767166, -1.702799},
	{2.050920, 0.767157, -1.702799},
	{2.184585, 0.558780, -1.682276},
	{2.050920, 0.558770, -1.682274},
	{2.184585, 0.358402, -1.621494},
	{2.050920, 0.358392, -1.621490},
	{2.184585, 0.173732, -1.522787},
	{2.050920, 0.173723, -1.522781},
	{2.223336, 0.190180, -1.498170},
	{2.223336, 0.032794, -1.369007},
	{2.223336, 0.369732, -1.594141},
	{2.223336, 0.564556, -1.653238},
	{2.223336, 0.767166, -1.673192},
	{2.223336, 0.969776, -1.653235},
	{2.223336, 1.164599, -1.594135},
	{2.223336, 1.344149, -1.498162},
	{2.223336, 1.501526, -1.369005},
	{2.223336, 1.630682, -1.211627},
	{2.223336, 1.726652, -1.032075},
	{2.223336, 1.785751, -0.837251},
	{2.223336, 1.805705, -0.634641},
	{2.223336, 1.785749, -0.432031},
	{2.223336, 1.726649, -0.237208},
	{2.223336, 1.630677, -0.057658},
	{2.223336, 1.501520, 0.099719},
	{2.223336, 1.344142, 0.228875},
	{2.223336, 1.164592, 0.324847},
	{2.223336, 0.969768, 0.383946},
	{2.223336, 0.767158, 0.403901},
	{2.223336, 0.564548, 0.383945},
	{2.223336, 0.369724, 0.324846},
	{2.223336, 0.190173, 0.228874},
	{2.223336, 0.032796, 0.099718},
	{2.223336, -0.096361, -0.057659},
	{2.223336, -0.192332, -0.237210},
	{2.223336, -0.251432, -0.432033},
	{2.223336, -0.271388, -0.634643},
	{2.223336, -0.251433, -0.837254},
	{2.223336, -0.192334, -1.032078},
	{2.223336, -0.096362, -1.211629},
	{2.223336, -0.096362, -1.211629},
	{2.223336, 0.032794, -1.369007},
	{2.256552, 0.153863, -1.247939},
	{2.256552, 0.045999, -1.116507},
	{2.223336, -0.192334, -1.032078},
	{2.256552, -0.034150, -0.966557},
	{2.223336, -0.251433, -0.837254},
	{2.256551, -0.083506, -0.803851},
	{2.223336, -0.271388, -0.634643},
	{2.256551, -0.100171, -0.634643},
	{2.223336, -0.251432, -0.432033},
	{2.256551, -0.083505, -0.465436},
	{2.223336, -0.192332, -0.237210},
	{2.256551, -0.034149, -0.302731},
	{2.223336, -0.096361, -0.057659},
	{2.256551, 0.046001, -0.152782},
	{2.223336, 0.032796, 0.099718},
	{2.256551, 0.153865, -0.021350},
	{2.223336, 0.190173, 0.228874},
	{2.256551, 0.285296, 0.086513},
	{2.223336, 0.369724, 0.324846},
	{2.256552, 0.435246, 0.166663},
	{2.223336, 0.564548, 0.383945},
	{2.256551, 0.597951, 0.216019},
	{2.223336, 0.767158, 0.403901},
	{2.256551, 0.767158, 0.232685},
	{2.223336, 0.969768, 0.383946},
	{2.256551, 0.936366, 0.216019},
	{2.223336, 1.164592, 0.324847},
	{2.256551, 1.099070, 0.166664},
	{2.223336, 1.344142, 0.228875},
	{2.256551, 1.249020, 0.086514},
	{2.223336, 1.501520, 0.099719},
	{2.256551, 1.380452, -0.021349},
	{2.223336, 1.630677, -0.057658},
	{2.256551, 1.488316, -0.152781},
	{2.223336, 1.726649, -0.237208},
	{2.256551, 1.568466, -0.302730},
	{2.223336, 1.785749, -0.432031},
	{2.256551, 1.617823, -0.465435},
	{2.223336, 1.805705, -0.634641},
	{2.256551, 1.634489, -0.634642},
	{2.223336, 1.785751, -0.837251},
	{2.256551, 1.617824, -0.803849},
	{2.223336, 1.726652, -1.032075},
	{2.256551, 1.568469, -0.966554},
	{2.223336, 1.630682, -1.211627},
	{2.256551, 1.488320, -1.116504},
	{2.223336, 1.501526, -1.369005},
	{2.256551, 1.380457, -1.247937},
	{2.223336, 1.344149, -1.498162},
	{2.256551, 1.249026, -1.355801},
	{2.223336, 1.164599, -1.594135},
	{2.256551, 1.099077, -1.435952},
	{2.223336, 0.969776, -1.653235},
	{2.256551, 0.936372, -1.485309},
	{2.223336, 0.767166, -1.673192},
	{2.256551, 0.767165, -1.501975},
	{2.223336, 0.564556, -1.653238},
	{2.256551, 0.597958, -1.485311},
	{2.223336, 0.369732, -1.594141},
	{2.256551, 0.435252, -1.435956},
	{2.223336, 0.190180, -1.498170},
	{2.256551, 0.285302, -1.355808},
	{2.256551, 0.767159, -0.634645},
	{1.421516, 3.244749, -1.640371},
	{1.272945, 3.244749, -1.882557},
	{1.132084, 3.072946, -1.713519},
	{1.311023, 3.072946, -1.427250},
	{1.146502, 3.244749, -2.031245},
	{0.985987, 3.072946, -1.881598},
	{0.993168, 3.244749, -2.147139},
	{0.832280, 3.072946, -2.029139},
	{2.258819, 2.156855, -2.002106},
	{2.258819, 2.280599, -1.855838},
	{2.087016, 2.154749, -1.687885},
	{2.087016, 2.007208, -1.841592},
	{2.258819, 2.008168, -2.128550},
	{2.087016, 1.839129, -1.987689},
	{2.258819, 1.765981, -2.277121},
	{2.086549, 1.562327, -2.166628},
	{0.881088, 3.244749, -2.234276},
	{0.685997, 3.072946, -2.118054},
	{0.832409, 3.244749, -2.266670},
	{0.626229, 3.072946, -2.154382},
	{0.787475, 3.244749, -2.296572},
	{0.571059, 3.072946, -2.187915},
	{0.790290, 2.413330, -3.108027},
	{1.032476, 2.264759, -3.108027},
	{0.863438, 2.123898, -2.936224},
	{0.572007, 2.302837, -2.936224},
	{1.181164, 2.138316, -3.108027},
	{1.031517, 1.977802, -2.936224},
	{1.304908, 1.992047, -3.108027},
	{1.179058, 1.824095, -2.936224},
	{1.348799, 1.926092, -3.108027},
	{1.228279, 1.743116, -2.936224},
	{1.395691, 1.855627, -3.108027},
	{1.280865, 1.656600, -2.936224},
	{1.446491, 1.779289, -3.108027},
	{1.337834, 1.562874, -2.936224},
	{2.258819, 2.314579, -1.804776},
	{2.087016, 2.192855, -1.625192},
	{2.258819, 2.354392, -1.744948},
	{2.087016, 2.237503, -1.551737},
	{2.258819, 2.422182, -1.643080},
	{2.087016, 2.313525, -1.426664},
	{1.421515, -0.223760, -3.107232},
	{1.272945, -0.465946, -3.107232},
	{1.132084, -0.296908, -2.935429},
	{1.311023, -0.010639, -2.935429},
	{1.146501, -0.614634, -3.107232},
	{0.985987, -0.464987, -2.935429},
	{0.993167, -0.730528, -3.107232},
	{0.832280, -0.612528, -2.935429},
	{2.258819, -0.585495, -2.019338},
	{2.258819, -0.439227, -2.143082},
	{2.087016, -0.271274, -2.017232},
	{2.087016, -0.424981, -1.869691},
	{2.258819, -0.711939, -1.870650},
	{2.087016, -0.571078, -1.701612},
	{2.258819, -0.860510, -1.628463},
	{2.086549, -0.750017, -1.424809},
	{0.881088, -0.817665, -3.107232},
	{0.685996, -0.701443, -2.935429},
	{0.832409, -0.850059, -3.107232},
	{0.626229, -0.737771, -2.935429},
	{0.787475, -0.879961, -3.107232},
	{0.571059, -0.771304, -2.935429},
	{0.790289, -1.691416, -2.275813},
	{1.032476, -1.691416, -2.127242},
	{0.863438, -1.519613, -1.986381},
	{0.572007, -1.519613, -2.165320},
	{1.181164, -1.691416, -2.000798},
	{1.031517, -1.519613, -1.840285},
	{1.304908, -1.691416, -1.854530},
	{1.179058, -1.519613, -1.686577},
	{1.348799, -1.691416, -1.788575},
	{1.228278, -1.519613, -1.605599},
	{1.395691, -1.691416, -1.718109},
	{1.280865, -1.519613, -1.519083},
	{1.446491, -1.691416, -1.641772},
	{1.337834, -1.519613, -1.425356},
	{2.258819, -0.388165, -2.177062},
	{2.087016, -0.208581, -2.055338},
	{2.258819, -0.328337, -2.216875},
	{2.087016, -0.135126, -2.099986},
	{2.258819, -0.226469, -2.284665},
	{2.087016, -0.010053, -2.176008},
	{-1.840420, 3.244749, -1.638804},
	{-1.729928, 3.072946, -1.425684},
	{-1.550988, 3.072946, -1.711953},
	{-1.691849, 3.244749, -1.880991},
	{-1.404892, 3.072946, -1.880032},
	{-1.565406, 3.244749, -2.029679},
	{-1.251185, 3.072946, -2.027573},
	{-1.412072, 3.244749, -2.145572},
	{-2.677724, 2.156855, -2.000540},
	{-2.505920, 2.007208, -1.840026},
	{-2.505920, 2.154749, -1.686319},
	{-2.677724, 2.280599, -1.854271},
	{-2.677724, 2.008168, -2.126983},
	{-2.505920, 1.839129, -1.986122},
	{-2.677724, 1.765981, -2.275554},
	{-2.505453, 1.562327, -2.165062},
	{-1.104901, 3.072946, -2.116487},
	{-1.299993, 3.244749, -2.232709},
	{-1.045134, 3.072946, -2.152815},
	{-1.251314, 3.244749, -2.265104},
	{-0.989964, 3.072946, -2.186349},
	{-1.206379, 3.244749, -2.295006},
	{-1.209194, 2.413330, -3.106460},
	{-0.990912, 2.302837, -2.934657},
	{-1.282343, 2.123898, -2.934657},
	{-1.451381, 2.264759, -3.106460},
	{-1.450422, 1.977802, -2.934657},
	{-1.600068, 2.138316, -3.106460},
	{-1.597963, 1.824095, -2.934657},
	{-1.723813, 1.992047, -3.106460},
	{-1.647183, 1.743116, -2.934657},
	{-1.767703, 1.926092, -3.106460},
	{-1.699770, 1.656600, -2.934657},
	{-1.814596, 1.855627, -3.106460},
	{-1.756739, 1.562874, -2.934657},
	{-1.865396, 1.779289, -3.106460},
	{-2.505920, 2.192855, -1.623626},
	{-2.677724, 2.314579, -1.803209},
	{-2.505920, 2.237503, -1.550170},
	{-2.677724, 2.354392, -1.743382},
	{-2.505920, 2.313525, -1.425098},
	{-2.677724, 2.422182, -1.641513},
	{-1.840420, -0.223760, -3.108316},
	{-1.729928, -0.010639, -2.936513},
	{-1.550988, -0.296908, -2.936513},
	{-1.691849, -0.465946, -3.108316},
	{-1.404892, -0.464987, -2.936513},
	{-1.565406, -0.614634, -3.108316},
	{-1.251185, -0.612528, -2.936513},
	{-1.412072, -0.730528, -3.108316},
	{-2.677724, -0.585495, -2.020422},
	{-2.505920, -0.424981, -1.870775},
	{-2.505920, -0.271274, -2.018316},
	{-2.677724, -0.439227, -2.144166},
	{-2.677724, -0.711939, -1.871734},
	{-2.505920, -0.571078, -1.702696},
	{-2.677724, -0.860510, -1.629547},
	{-2.505453, -0.750017, -1.425893},
	{-1.104901, -0.701443, -2.936513},
	{-1.299993, -0.817665, -3.108316},
	{-1.045134, -0.737771, -2.936513},
	{-1.251314, -0.850059, -3.108316},
	{-0.989964, -0.771304, -2.936513},
	{-1.206379, -0.879961, -3.108316},
	{-1.209194, -1.691416, -2.276896},
	{-0.990912, -1.519613, -2.166404},
	{-1.282343, -1.519613, -1.987465},
	{-1.451380, -1.691416, -2.128325},
	{-1.450422, -1.519613, -1.841368},
	{-1.600068, -1.691416, -2.001882},
	{-1.597962, -1.519613, -1.687661},
	{-1.723813, -1.691416, -1.855614},
	{-1.647183, -1.519613, -1.606683},
	{-1.767703, -1.691416, -1.789659},
	{-1.699770, -1.519613, -1.520166},
	{-1.814595, -1.691416, -1.719193},
	{-1.756739, -1.519613, -1.426440},
	{-1.865396, -1.691416, -1.642856},
	{-2.505920, -0.208581, -2.056422},
	{-2.677724, -0.388165, -2.178146},
	{-2.505920, -0.135126, -2.101070},
	{-2.677724, -0.328337, -2.217959},
	{-2.505920, -0.010053, -2.177092},
	{-2.677724, -0.226469, -2.285749},
	{-1.841436, 3.245014, 0.360610},
	{-1.692865, 3.245014, 0.602797},
	{-1.552004, 3.073211, 0.433759},
	{-1.730944, 3.073211, 0.147490},
	{-1.566422, 3.245014, 0.751485},
	{-1.405908, 3.073211, 0.601838},
	{-1.413088, 3.245014, 0.867378},
	{-1.252201, 3.073211, 0.749379},
	{-2.678740, 2.157120, 0.722346},
	{-2.678739, 2.280864, 0.576077},
	{-2.506937, 2.155015, 0.408125},
	{-2.506937, 2.007473, 0.561832},
	{-2.678740, 2.008433, 0.848789},
	{-2.506937, 1.839394, 0.707928},
	{-2.678740, 1.766246, 0.997360},
	{-2.506469, 1.562592, 0.886868},
	{-1.301009, 3.245014, 0.954516},
	{-1.105917, 3.073211, 0.838293},
	{-1.252330, 3.245014, 0.986910},
	{-1.046150, 3.073211, 0.874622},
	{-1.207395, 3.245014, 1.016812},
	{-0.990980, 3.073211, 0.908155},
	{-1.210210, 2.413595, 1.828266},
	{-1.452397, 2.265024, 1.828266},
	{-1.283359, 2.124163, 1.656463},
	{-0.991928, 2.303102, 1.656463},
	{-1.601085, 2.138581, 1.828266},
	{-1.451438, 1.978067, 1.656463},
	{-1.724829, 1.992312, 1.828266},
	{-1.598979, 1.824360, 1.656463},
	{-1.768720, 1.926357, 1.828267},
	{-1.648199, 1.743381, 1.656463},
	{-1.815612, 1.855892, 1.828267},
	{-1.700786, 1.656865, 1.656463},
	{-1.866412, 1.779554, 1.828267},
	{-1.757755, 1.563139, 1.656463},
	{-2.678739, 2.314844, 0.525015},
	{-2.506937, 2.193120, 0.345432},
	{-2.678739, 2.354657, 0.465188},
	{-2.506937, 2.237768, 0.271976},
	{-2.678740, 2.422447, 0.363319},
	{-2.506937, 2.313791, 0.146904},
	{-1.841436, -0.223494, 1.827472},
	{-1.692865, -0.465681, 1.827472},
	{-1.552004, -0.296643, 1.655668},
	{-1.730944, -0.010374, 1.655668},
	{-1.566422, -0.614369, 1.827472},
	{-1.405908, -0.464722, 1.655668},
	{-1.413088, -0.730262, 1.827472},
	{-1.252201, -0.612263, 1.655669},
	{-2.678740, -0.585230, 0.739577},
	{-2.678740, -0.438962, 0.863321},
	{-2.506936, -0.271009, 0.737471},
	{-2.506936, -0.424716, 0.589930},
	{-2.678739, -0.711673, 0.590889},
	{-2.506936, -0.570813, 0.421851},
	{-2.678739, -0.860244, 0.348703},
	{-2.506469, -0.749752, 0.145049},
	{-1.301009, -0.817400, 1.827472},
	{-1.105917, -0.701178, 1.655669},
	{-1.252330, -0.849794, 1.827472},
	{-1.046150, -0.737506, 1.655669},
	{-1.207395, -0.879696, 1.827472},
	{-0.990980, -0.771039, 1.655669},
	{-1.210210, -1.691150, 0.996052},
	{-1.452397, -1.691150, 0.847481},
	{-1.283358, -1.519347, 0.706621},
	{-0.991928, -1.519347, 0.885560},
	{-1.601084, -1.691150, 0.721038},
	{-1.451438, -1.519347, 0.560524},
	{-1.724829, -1.691150, 0.574769},
	{-1.598978, -1.519347, 0.406817},
	{-1.768719, -1.691151, 0.508814},
	{-1.648199, -1.519347, 0.325838},
	{-1.815612, -1.691151, 0.438349},
	{-1.700786, -1.519348, 0.239322},
	{-1.866412, -1.691151, 0.362011},
	{-1.757755, -1.519348, 0.145596},
	{-2.678740, -0.387900, 0.897301},
	{-2.506936, -0.208316, 0.775578},
	{-2.678740, -0.328072, 0.937115},
	{-2.506936, -0.134861, 0.820225},
	{-2.678740, -0.226204, 1.004904},
	{-2.506937, -0.009788, 0.896247},
	{1.420499, 3.245014, 0.359044},
	{1.310007, 3.073211, 0.145924},
	{1.131068, 3.073211, 0.432193},
	{1.271928, 3.245014, 0.601230},
	{0.984971, 3.073211, 0.600272},
	{1.145485, 3.245014, 0.749919},
	{0.831264, 3.073211, 0.747813},
	{0.992151, 3.245014, 0.865812},
	{2.257802, 2.157120, 0.720780},
	{2.086000, 2.007473, 0.560266},
	{2.086000, 2.155015, 0.406558},
	{2.257803, 2.280864, 0.574511},
	{2.257802, 2.008433, 0.847223},
	{2.085999, 1.839394, 0.706362},
	{2.257802, 1.766246, 0.995794},
	{2.085533, 1.562592, 0.885302},
	{0.684980, 3.073211, 0.836727},
	{0.880072, 3.245014, 0.952949},
	{0.625213, 3.073211, 0.873055},
	{0.831393, 3.245014, 0.985343},
	{0.570043, 3.073211, 0.906589},
	{0.786459, 3.245014, 1.015246},
	{0.789273, 2.413595, 1.826700},
	{0.570991, 2.303102, 1.654897},
	{0.862422, 2.124163, 1.654897},
	{1.031460, 2.265024, 1.826700},
	{1.030501, 1.978067, 1.654897},
	{1.180148, 2.138581, 1.826700},
	{1.178042, 1.824360, 1.654897},
	{1.303892, 1.992312, 1.826700},
	{1.227262, 1.743381, 1.654897},
	{1.347783, 1.926357, 1.826700},
	{1.279849, 1.656865, 1.654897},
	{1.394675, 1.855892, 1.826700},
	{1.336818, 1.563139, 1.654897},
	{1.445475, 1.779554, 1.826700},
	{2.086000, 2.193120, 0.343865},
	{2.257803, 2.314844, 0.523449},
	{2.086000, 2.237768, 0.270410},
	{2.257803, 2.354657, 0.463622},
	{2.086000, 2.313791, 0.145338},
	{2.257803, 2.422447, 0.361753},
	{1.420499, -0.223494, 1.828556},
	{1.310007, -0.010374, 1.656753},
	{1.131068, -0.296643, 1.656753},
	{1.271929, -0.465681, 1.828556},
	{0.984971, -0.464722, 1.656753},
	{1.145486, -0.614369, 1.828556},
	{0.831264, -0.612263, 1.656753},
	{0.992151, -0.730262, 1.828556},
	{2.257802, -0.585230, 0.740661},
	{2.086000, -0.424716, 0.591015},
	{2.085999, -0.271009, 0.738555},
	{2.257802, -0.438962, 0.864406},
	{2.257803, -0.711673, 0.591973},
	{2.086000, -0.570813, 0.422935},
	{2.257803, -0.860244, 0.349787},
	{2.085533, -0.749752, 0.146133},
	{0.684980, -0.701178, 1.656753},
	{0.880072, -0.817400, 1.828556},
	{0.625213, -0.737506, 1.656753},
	{0.831393, -0.849794, 1.828556},
	{0.570043, -0.771039, 1.656753},
	{0.786459, -0.879696, 1.828556},
	{0.789273, -1.691150, 0.997136},
	{0.570991, -1.519347, 0.886644},
	{0.862422, -1.519347, 0.707705},
	{1.031460, -1.691150, 0.848565},
	{1.030501, -1.519347, 0.561608},
	{1.180148, -1.691150, 0.722122},
	{1.178042, -1.519347, 0.407901},
	{1.303892, -1.691150, 0.575853},
	{1.227263, -1.519347, 0.326922},
	{1.347783, -1.691151, 0.509898},
	{1.279849, -1.519348, 0.240406},
	{1.394675, -1.691151, 0.439433},
	{1.336818, -1.519348, 0.146680},
	{1.445475, -1.691151, 0.363095},
	{2.085999, -0.208316, 0.776662},
	{2.257802, -0.387900, 0.898385},
	{2.085999, -0.134861, 0.821310},
	{2.257802, -0.328072, 0.938199},
	{2.085999, -0.009788, 0.897332},
	{2.257802, -0.226204, 1.005988},
	{-0.210634, -1.698040, -2.443506},
	{-0.016501, -1.698040, -2.430085},
	{0.016423, -1.524719, -2.346447},
	{-0.210896, -1.524719, -2.362162},
	{0.181555, -1.698040, -2.397875},
	{0.248335, -1.524719, -2.308732},
	{-0.402846, -1.698040, -2.430085},
	{-0.435965, -1.524719, -2.346447},
	{-0.595058, -1.698040, -2.397876},
	{-0.661034, -1.524719, -2.308732},
	{-0.595058, -0.989718, -3.106547},
	{-0.661034, -0.900574, -2.933227},
	{-0.435965, -0.938290, -2.933227},
	{-0.402846, -1.021928, -3.106547},
	{-0.210896, -0.954004, -2.933227},
	{-0.210635, -1.035349, -3.106547},
	{-0.016501, -1.021928, -3.106547},
	{0.016423, -0.938290, -2.933227},
	{0.248335, -0.900574, -2.933227},
	{0.181555, -0.989718, -3.106547},
	{-0.208760, 3.236759, -2.443506},
	{-0.402894, 3.236759, -2.430085},
	{-0.435817, 3.063439, -2.346447},
	{-0.208498, 3.063439, -2.362161},
	{-0.600949, 3.236759, -2.397876},
	{-0.667729, 3.063439, -2.308731},
	{-0.016548, 3.236759, -2.430085},
	{0.016571, 3.063439, -2.346447},
	{0.175664, 3.236759, -2.397875},
	{0.241640, 3.063439, -2.308731},
	{0.175664, 2.528437, -3.106547},
	{0.241640, 2.439293, -2.933227},
	{0.016571, 2.477009, -2.933227},
	{-0.016548, 2.560647, -3.106547},
	{-0.208498, 2.492724, -2.933227},
	{-0.208760, 2.574068, -3.106547},
	{-0.402894, 2.560647, -3.106547},
	{-0.435818, 2.477009, -2.933227},
	{-0.667729, 2.439293, -2.933227},
	{-0.600949, 2.528438, -3.106547},
	{2.257703, 0.768422, -2.443505},
	{2.257703, 0.962556, -2.430084},
	{2.084383, 0.995479, -2.346446},
	{2.084383, 0.768160, -2.362161},
	{2.257703, 1.160611, -2.397875},
	{2.084383, 1.227391, -2.308731},
	{2.257703, 0.576210, -2.430084},
	{2.084383, 0.543091, -2.346446},
	{2.257703, 0.383998, -2.397875},
	{2.084383, 0.318022, -2.308731},
	{1.549381, 0.383998, -3.106547},
	{1.460237, 0.318022, -2.933226},
	{1.497953, 0.543091, -2.933226},
	{1.581591, 0.576210, -3.106547},
	{1.513667, 0.768160, -2.933226},
	{1.595011, 0.768422, -3.106547},
	{1.581591, 0.962556, -3.106547},
	{1.497952, 0.995479, -2.933226},
	{1.460237, 1.227391, -2.933226},
	{1.549381, 1.160611, -3.106547},
	{-2.677096, 0.770297, -2.443506},
	{-2.677096, 0.576163, -2.430085},
	{-2.503776, 0.543239, -2.346447},
	{-2.503776, 0.770559, -2.362162},
	{-2.677096, 0.378107, -2.397876},
	{-2.503776, 0.311328, -2.308732},
	{-2.677096, 0.962509, -2.430085},
	{-2.503776, 0.995628, -2.346447},
	{-2.677097, 1.154721, -2.397876},
	{-2.503776, 1.220697, -2.308732},
	{-1.968775, 1.154721, -3.106547},
	{-1.879631, 1.220697, -2.933227},
	{-1.917346, 0.995628, -2.933227},
	{-2.000984, 0.962509, -3.106547},
	{-1.933061, 0.770559, -2.933227},
	{-2.014405, 0.770297, -3.106547},
	{-2.000984, 0.576163, -3.106547},
	{-1.917346, 0.543239, -2.933227},
	{-1.879630, 0.311328, -2.933227},
	{-1.968775, 0.378108, -3.106547},
	{-2.677096, -1.035179, -0.639905},
	{-2.677096, -1.021759, -0.445771},
	{-2.503776, -0.938121, -0.412847},
	{-2.503776, -0.953836, -0.640167},
	{-2.677096, -0.989550, -0.247715},
	{-2.503776, -0.900405, -0.180935},
	{-2.677096, -1.021759, -0.832117},
	{-2.503776, -0.938121, -0.865236},
	{-2.677096, -0.989550, -1.024329},
	{-2.503776, -0.900405, -1.090305},
	{-1.968774, -1.698221, -1.024328},
	{-1.879630, -1.524901, -1.090304},
	{-1.917346, -1.524901, -0.865235},
	{-2.000984, -1.698221, -0.832116},
	{-1.933061, -1.524901, -0.640167},
	{-2.014405, -1.698221, -0.639905},
	{-2.000984, -1.698221, -0.445771},
	{-1.917346, -1.524901, -0.412847},
	{-1.879630, -1.524901, -0.180935},
	{-1.968775, -1.698221, -0.247715},
	{-2.677096, 2.573899, -0.638029},
	{-2.677096, 2.560478, -0.832163},
	{-2.503776, 2.476840, -0.865087},
	{-2.503776, 2.492555, -0.637767},
	{-2.677096, 2.528269, -1.030219},
	{-2.503776, 2.439125, -1.096999},
	{-2.677096, 2.560478, -0.445818},
	{-2.503776, 2.476840, -0.412699},
	{-2.677096, 2.528269, -0.253606},
	{-2.503776, 2.439125, -0.187630},
	{-1.968775, 3.236941, -0.253606},
	{-1.879630, 3.063620, -0.187629},
	{-1.917346, 3.063620, -0.412698},
	{-2.000984, 3.236941, -0.445817},
	{-1.933061, 3.063620, -0.637767},
	{-2.014405, 3.236940, -0.638029},
	{-2.000984, 3.236940, -0.832163},
	{-1.917346, 3.063620, -0.865087},
	{-1.879630, 3.063620, -1.096998},
	{-1.968774, 3.236940, -1.030218},
	{2.257703, 2.573900, -0.639903},
	{2.257703, 2.560479, -0.445769},
	{2.084383, 2.476841, -0.412845},
	{2.084383, 2.492556, -0.640165},
	{2.257703, 2.528269, -0.247713},
	{2.084383, 2.439126, -0.180933},
	{2.257703, 2.560479, -0.832115},
	{2.084383, 2.476841, -0.865234},
	{2.257703, 2.528269, -1.024326},
	{2.084383, 2.439125, -1.090302},
	{1.549381, 3.236941, -1.024326},
	{1.460237, 3.063621, -1.090303},
	{1.497953, 3.063621, -0.865234},
	{1.581591, 3.236941, -0.832115},
	{1.513667, 3.063621, -0.640165},
	{1.595011, 3.236941, -0.639903},
	{1.581591, 3.236941, -0.445769},
	{1.497953, 3.063621, -0.412845},
	{1.460237, 3.063621, -0.180934},
	{1.549381, 3.236941, -0.247714},
	{2.257703, -1.035179, -0.638027},
	{2.257703, -1.021759, -0.832161},
	{2.084383, -0.938120, -0.865085},
	{2.084383, -0.953835, -0.637765},
	{2.257703, -0.989549, -1.030217},
	{2.084383, -0.900405, -1.096997},
	{2.257703, -1.021759, -0.445815},
	{2.084383, -0.938120, -0.412696},
	{2.257703, -0.989549, -0.253604},
	{2.084383, -0.900405, -0.187628},
	{1.549381, -1.698221, -0.253604},
	{1.460237, -1.524901, -0.187628},
	{1.497953, -1.524901, -0.412697},
	{1.581591, -1.698221, -0.445816},
	{1.513668, -1.524901, -0.637766},
	{1.595011, -1.698221, -0.638027},
	{1.581591, -1.698221, -0.832161},
	{1.497953, -1.524901, -0.865085},
	{1.460237, -1.524901, -1.096997},
	{1.549382, -1.698221, -1.030217},
	{-0.208759, -1.698040, 1.165573},
	{-0.402893, -1.698040, 1.152153},
	{-0.435817, -1.524719, 1.068514},
	{-0.208497, -1.524719, 1.084229},
	{-0.600949, -1.698040, 1.119943},
	{-0.667729, -1.524719, 1.030799},
	{-0.016547, -1.698040, 1.152153},
	{0.016572, -1.524719, 1.068514},
	{0.175664, -1.698040, 1.119943},
	{0.241640, -1.524719, 1.030799},
	{0.175664, -0.989718, 1.828615},
	{0.241640, -0.900574, 1.655294},
	{0.016572, -0.938289, 1.655294},
	{-0.016548, -1.021927, 1.828615},
	{-0.208497, -0.954004, 1.655294},
	{-0.208759, -1.035348, 1.828615},
	{-0.402893, -1.021927, 1.828615},
	{-0.435817, -0.938289, 1.655294},
	{-0.667729, -0.900574, 1.655294},
	{-0.600949, -0.989718, 1.828615},
	{-0.210635, 3.236759, 1.165573},
	{-0.016501, 3.236760, 1.152152},
	{0.016423, 3.063439, 1.068514},
	{-0.210896, 3.063439, 1.084229},
	{0.181555, 3.236760, 1.119943},
	{0.248335, 3.063439, 1.030799},
	{-0.402846, 3.236759, 1.152152},
	{-0.435965, 3.063439, 1.068514},
	{-0.595058, 3.236759, 1.119943},
	{-0.661034, 3.063439, 1.030799},
	{-0.595058, 2.528438, 1.828615},
	{-0.661034, 2.439294, 1.655294},
	{-0.435965, 2.477009, 1.655294},
	{-0.402846, 2.560647, 1.828615},
	{-0.210896, 2.492724, 1.655294},
	{-0.210634, 2.574068, 1.828615},
	{-0.016501, 2.560647, 1.828615},
	{0.016423, 2.477009, 1.655294},
	{0.248335, 2.439294, 1.655294},
	{0.181555, 2.528438, 1.828615},
	{-2.677097, 0.768422, 1.165573},
	{-2.677097, 0.962556, 1.152152},
	{-2.503777, 0.995480, 1.068514},
	{-2.503777, 0.768160, 1.084229},
	{-2.677097, 1.160612, 1.119943},
	{-2.503777, 1.227392, 1.030799},
	{-2.677097, 0.576210, 1.152152},
	{-2.503777, 0.543091, 1.068514},
	{-2.677097, 0.383998, 1.119943},
	{-2.503777, 0.318022, 1.030799},
	{-1.968775, 0.383999, 1.828615},
	{-1.879631, 0.318023, 1.655294},
	{-1.917346, 0.543091, 1.655294},
	{-2.000985, 0.576210, 1.828615},
	{-1.933061, 0.768160, 1.655294},
	{-2.014405, 0.768422, 1.828615},
	{-2.000985, 0.962556, 1.828615},
	{-1.917346, 0.995480, 1.655294},
	{-1.879631, 1.227392, 1.655294},
	{-1.968775, 1.160612, 1.828615},
	{2.257703, 0.770298, 1.165573},
	{2.257703, 0.576164, 1.152152},
	{2.084383, 0.543240, 1.068514},
	{2.084383, 0.770559, 1.084229},
	{2.257703, 0.378108, 1.119943},
	{2.084383, 0.311328, 1.030799},
	{2.257703, 0.962509, 1.152152},
	{2.084382, 0.995628, 1.068514},
	{2.257703, 1.154721, 1.119943},
	{2.084382, 1.220697, 1.030799},
	{1.549381, 1.154721, 1.828615},
	{1.460237, 1.220697, 1.655294},
	{1.497952, 0.995628, 1.655294},
	{1.581591, 0.962509, 1.828615},
	{1.513667, 0.770559, 1.655294},
	{1.595011, 0.770298, 1.828615},
	{1.581590, 0.576164, 1.828615},
	{1.497952, 0.543240, 1.655294},
	{1.460237, 0.311328, 1.655294},
	{1.549381, 0.378108, 1.828615},
	{-0.153840, 3.080711, -1.627220},
	{-0.153840, 3.080711, -2.374549},
	{-0.269047, 3.080711, -2.374549},
	{-0.269047, 3.080711, -1.627220},
	{-0.153840, 3.080711, 1.103494},
	{-0.153840, 3.080711, 0.356164},
	{-0.269047, 3.080711, 0.356164},
	{-0.269047, 3.080711, 1.103493},
	{1.527578, 3.080711, -0.693132},
	{0.780249, 3.080711, -0.693132},
	{0.780248, 3.080711, -0.577924},
	{1.527578, 3.080710, -0.577924},
	{-1.203135, 3.080711, -0.693132},
	{-1.950464, 3.080711, -0.693131},
	{-1.950465, 3.080711, -0.577924},
	{-1.203136, 3.080711, -0.577924},
	{-0.153839, -1.534256, 0.357818},
	{-0.153839, -1.534256, 1.105147},
	{-0.269047, -1.534256, 1.105148},
	{-0.269047, -1.534256, 0.357818},
	{-0.153839, -1.534256, -2.372895},
	{-0.153839, -1.534256, -1.625566},
	{-0.269047, -1.534256, -1.625566},
	{-0.269047, -1.534256, -2.372895},
	{1.527578, -1.534256, -0.576270},
	{0.780249, -1.534256, -0.576270},
	{0.780249, -1.534256, -0.691478},
	{1.527578, -1.534256, -0.691478},
	{-1.203135, -1.534256, -0.576270},
	{-1.950464, -1.534256, -0.576270},
	{-1.950464, -1.534256, -0.691478},
	{-1.203135, -1.534256, -0.691478},
	{2.087835, 0.833305, 0.357818},
	{2.087835, 0.833305, 1.105147},
	{2.087835, 0.718097, 1.105148},
	{2.087835, 0.718097, 0.357818},
	{2.087835, 0.833305, -2.372895},
	{2.087835, 0.833305, -1.625566},
	{2.087835, 0.718097, -1.625566},
	{2.087835, 0.718097, -2.372895},
	{2.087835, 2.514723, -0.576270},
	{2.087835, 1.767394, -0.576270},
	{2.087835, 1.767393, -0.691478},
	{2.087835, 2.514722, -0.691478},
	{2.087835, -0.215991, -0.576270},
	{2.087835, -0.963320, -0.576270},
	{2.087835, -0.963320, -0.691478},
	{2.087835, -0.215991, -0.691478},
	{0.781672, 0.831054, -2.941403},
	{1.529001, 0.831054, -2.941403},
	{1.529002, 0.715846, -2.941403},
	{0.781673, 0.715846, -2.941403},
	{-1.949041, 0.831054, -2.941403},
	{-1.201712, 0.831054, -2.941403},
	{-1.201711, 0.715846, -2.941403},
	{-1.949040, 0.715846, -2.941403},
	{-0.152416, 2.512471, -2.941403},
	{-0.152416, 1.765142, -2.941403},
	{-0.267623, 1.765142, -2.941403},
	{-0.267623, 2.512471, -2.941403},
	{-0.152416, -0.218242, -2.941403},
	{-0.152416, -0.965571, -2.941403},
	{-0.267623, -0.965572, -2.941403},
	{-0.267623, -0.218242, -2.941403},
	{-2.510722, 0.833304, -1.627220},
	{-2.510722, 0.833304, -2.374549},
	{-2.510721, 0.718097, -2.374549},
	{-2.510721, 0.718097, -1.627220},
	{-2.510722, 0.833304, 1.103494},
	{-2.510722, 0.833304, 0.356164},
	{-2.510721, 0.718097, 0.356164},
	{-2.510721, 0.718097, 1.103493},
	{-2.510721, 2.514722, -0.693132},
	{-2.510721, 1.767393, -0.693132},
	{-2.510721, 1.767393, -0.577924},
	{-2.510721, 2.514722, -0.577924},
	{-2.510721, -0.215991, -0.693132},
	{-2.510722, -0.963320, -0.693131},
	{-2.510722, -0.963321, -0.577924},
	{-2.510721, -0.215992, -0.577924},
	{-1.201712, 0.832708, 1.664578},
	{-1.949041, 0.832708, 1.664578},
	{-1.949041, 0.717501, 1.664578},
	{-1.201712, 0.717501, 1.664578},
	{1.529002, 0.832708, 1.664578},
	{0.781672, 0.832708, 1.664578},
	{0.781672, 0.717501, 1.664577},
	{1.529001, 0.717501, 1.664577},
	{-0.267624, 2.514126, 1.664578},
	{-0.267624, 1.766797, 1.664578},
	{-0.152416, 1.766796, 1.664577},
	{-0.152416, 2.514126, 1.664577},
	{-0.267624, -0.216587, 1.664578},
	{-0.267623, -0.963916, 1.664578},
	{-0.152416, -0.963917, 1.664578},
	{-0.152416, -0.216588, 1.664578},
};

float
companion_texture_coordinates[COMPANION_VERTEX_COUNT][2] = {
	{0.497703, 0.466800},
	{0.611992, 0.581089},
	{0.587500, 0.601190},
	{0.559556, 0.616126},
	{0.497703, 0.466800},
	{0.559556, 0.616126},
	{0.529236, 0.625323},
	{0.529236, 0.625323},
	{0.497703, 0.628429},
	{0.466171, 0.625323},
	{0.435851, 0.616126},
	{0.407907, 0.601190},
	{0.383414, 0.581089},
	{0.363314, 0.556596},
	{0.348378, 0.528653},
	{0.339180, 0.498332},
	{0.497703, 0.466800},
	{0.339180, 0.498332},
	{0.336074, 0.466800},
	{0.336074, 0.466800},
	{0.339180, 0.435268},
	{0.348378, 0.404947},
	{0.363314, 0.377004},
	{0.383414, 0.352511},
	{0.407907, 0.332410},
	{0.435851, 0.317474},
	{0.466171, 0.308277},
	{0.497703, 0.305171},
	{0.529236, 0.308277},
	{0.559556, 0.317475},
	{0.587500, 0.332411},
	{0.497703, 0.466800},
	{0.587500, 0.332411},
	{0.611992, 0.352511},
	{0.611992, 0.352511},
	{0.632093, 0.377004},
	{0.647029, 0.404948},
	{0.656227, 0.435268},
	{0.659332, 0.466800},
	{0.656226, 0.498333},
	{0.647029, 0.528653},
	{0.632093, 0.556597},
	{0.497703, 0.466800},
	{0.611992, 0.581089},
	{0.587500, 0.601190},
	{0.559556, 0.616126},
	{0.497703, 0.466800},
	{0.559556, 0.616126},
	{0.529236, 0.625323},
	{0.497703, 0.628429},
	{0.466171, 0.625323},
	{0.435851, 0.616126},
	{0.407907, 0.601190},
	{0.497703, 0.466800},
	{0.407907, 0.601190},
	{0.383414, 0.581089},
	{0.383414, 0.581089},
	{0.363314, 0.556596},
	{0.348378, 0.528653},
	{0.339180, 0.498332},
	{0.336074, 0.466800},
	{0.339180, 0.435268},
	{0.348378, 0.404947},
	{0.363314, 0.377004},
	{0.383414, 0.352511},
	{0.407907, 0.332410},
	{0.435851, 0.317474},
	{0.497703, 0.466800},
	{0.435851, 0.317474},
	{0.466171, 0.308277},
	{0.466171, 0.308277},
	{0.497703, 0.305171},
	{0.529236, 0.308277},
	{0.559556, 0.317475},
	{0.587500, 0.332411},
	{0.611992, 0.352511},
	{0.632093, 0.377004},
	{0.647029, 0.404948},
	{0.647029, 0.404948},
	{0.656227, 0.435268},
	{0.497703, 0.466800},
	{0.656227, 0.435268},
	{0.659332, 0.466800},
	{0.659332, 0.466800},
	{0.656226, 0.498333},
	{0.647029, 0.528653},
	{0.647029, 0.528653},
	{0.632093, 0.556597},
	{0.497703, 0.466800},
	{0.611992, 0.581089},
	{0.587500, 0.601190},
	{0.559556, 0.616126},
	{0.529236, 0.625323},
	{0.497703, 0.628429},
	{0.466171, 0.625323},
	{0.497703, 0.466800},
	{0.466171, 0.625323},
	{0.435851, 0.616126},
	{0.435851, 0.616126},
	{0.407907, 0.601190},
	{0.383414, 0.581089},
	{0.363314, 0.556596},
	{0.497703, 0.466800},
	{0.363314, 0.556596},
	{0.348378, 0.528653},
	{0.348378, 0.528653},
	{0.339180, 0.498332},
	{0.336074, 0.466800},
	{0.339180, 0.435268},
	{0.497703, 0.466800},
	{0.339180, 0.435268},
	{0.348378, 0.404947},
	{0.348378, 0.404947},
	{0.363314, 0.377004},
	{0.383414, 0.352511},
	{0.407907, 0.332410},
	{0.435851, 0.317474},
	{0.466171, 0.308277},
	{0.497703, 0.305171},
	{0.529236, 0.308277},
	{0.559556, 0.317475},
	{0.587500, 0.332411},
	{0.611992, 0.352511},
	{0.632093, 0.377004},
	{0.632093, 0.377004},
	{0.647029, 0.404948},
	{0.647029, 0.404948},
	{0.656227, 0.435268},
	{0.659332, 0.466800},
	{0.656226, 0.498333},
	{0.656226, 0.498333},
	{0.647029, 0.528653},
	{0.647029, 0.528653},
	{0.632093, 0.556597},
	{0.497703, 0.466800},
	{0.611992, 0.581089},
	{0.587500, 0.601190},
	{0.559556, 0.616126},
	{0.529236, 0.625323},
	{0.497703, 0.628429},
	{0.497703, 0.466800},
	{0.497703, 0.628429},
	{0.466171, 0.625323},
	{0.466171, 0.625323},
	{0.435851, 0.616126},
	{0.407907, 0.601190},
	{0.383414, 0.581089},
	{0.497703, 0.466800},
	{0.383414, 0.581089},
	{0.363314, 0.556596},
	{0.363314, 0.556596},
	{0.348378, 0.528653},
	{0.339180, 0.498332},
	{0.336074, 0.466800},
	{0.339180, 0.435268},
	{0.339180, 0.435268},
	{0.348378, 0.404947},
	{0.348378, 0.404947},
	{0.363314, 0.377004},
	{0.383414, 0.352511},
	{0.407907, 0.332410},
	{0.435851, 0.317474},
	{0.466171, 0.308277},
	{0.497703, 0.305171},
	{0.529236, 0.308277},
	{0.559556, 0.317475},
	{0.587500, 0.332411},
	{0.611992, 0.352511},
	{0.632093, 0.377004},
	{0.647029, 0.404948},
	{0.656227, 0.435268},
	{0.659332, 0.466800},
	{0.656226, 0.498333},
	{0.647029, 0.528653},
	{0.632093, 0.556597},
	{0.632093, 0.556597},
	{0.611992, 0.581089},
	{0.497703, 0.466800},
	{0.497703, 0.466800},
	{0.611992, 0.581089},
	{0.587500, 0.601190},
	{0.497703, 0.466800},
	{0.587500, 0.601190},
	{0.559556, 0.616126},
	{0.529236, 0.625323},
	{0.497703, 0.628429},
	{0.466171, 0.625323},
	{0.435851, 0.616126},
	{0.407907, 0.601190},
	{0.383414, 0.581089},
	{0.363314, 0.556596},
	{0.348378, 0.528653},
	{0.339180, 0.498332},
	{0.336074, 0.466800},
	{0.339180, 0.435268},
	{0.348378, 0.404947},
	{0.497703, 0.466800},
	{0.348378, 0.404947},
	{0.363314, 0.377004},
	{0.363314, 0.377004},
	{0.383414, 0.352511},
	{0.407907, 0.332410},
	{0.435851, 0.317474},
	{0.466171, 0.308277},
	{0.497703, 0.305171},
	{0.529236, 0.308277},
	{0.559556, 0.317475},
	{0.587500, 0.332411},
	{0.497703, 0.466800},
	{0.587500, 0.332411},
	{0.611992, 0.352511},
	{0.497703, 0.466800},
	{0.611992, 0.352511},
	{0.632093, 0.377004},
	{0.632093, 0.377004},
	{0.647029, 0.404948},
	{0.656227, 0.435268},
	{0.659332, 0.466800},
	{0.656226, 0.498333},
	{0.647029, 0.528653},
	{0.632093, 0.556597},
	{0.611992, 0.581089},
	{0.497703, 0.466800},
	{0.611992, 0.581089},
	{0.587500, 0.601190},
	{0.559556, 0.616126},
	{0.529236, 0.625323},
	{0.497703, 0.628429},
	{0.466171, 0.625323},
	{0.435851, 0.616126},
	{0.407907, 0.601190},
	{0.383414, 0.581089},
	{0.363314, 0.556596},
	{0.348378, 0.528653},
	{0.339180, 0.498332},
	{0.336074, 0.466800},
	{0.339180, 0.435268},
	{0.348378, 0.404947},
	{0.497703, 0.466800},
	{0.348378, 0.404947},
	{0.363314, 0.377004},
	{0.363314, 0.377004},
	{0.383414, 0.352511},
	{0.407907, 0.332410},
	{0.497703, 0.466800},
	{0.407907, 0.332410},
	{0.435851, 0.317474},
	{0.435851, 0.317474},
	{0.466171, 0.308277},
	{0.497703, 0.305171},
	{0.529236, 0.308277},
	{0.559556, 0.317475},
	{0.587500, 0.332411},
	{0.611992, 0.352511},
	{0.632093, 0.377004},
	{0.647029, 0.404948},
	{0.497703, 0.466800},
	{0.647029, 0.404948},
	{0.656227, 0.435268},
	{0.656227, 0.435268},
	{0.659332, 0.466800},
	{0.659332, 0.466800},
	{0.656226, 0.498333},
	{0.647029, 0.528653},
	{0.632093, 0.556597},
	{0.500286, 0.468323},
	{0.310836, 0.657773},
	{0.351436, 0.691093},
	{0.397756, 0.715852},
	{0.448017, 0.731098},
	{0.500286, 0.736246},
	{0.552555, 0.731098},
	{0.602816, 0.715852},
	{0.649136, 0.691093},
	{0.500286, 0.468323},
	{0.649136, 0.691093},
	{0.689736, 0.657773},
	{0.689736, 0.657773},
	{0.723056, 0.617173},
	{0.500286, 0.468323},
	{0.723056, 0.617173},
	{0.747815, 0.570853},
	{0.747815, 0.570853},
	{0.763061, 0.520592},
	{0.763061, 0.520592},
	{0.768209, 0.468323},
	{0.768209, 0.468323},
	{0.763061, 0.416054},
	{0.747815, 0.365793},
	{0.723056, 0.319473},
	{0.689736, 0.278872},
	{0.500286, 0.468323},
	{0.689736, 0.278872},
	{0.649136, 0.245553},
	{0.649136, 0.245553},
	{0.602816, 0.220794},
	{0.552555, 0.205548},
	{0.500286, 0.200400},
	{0.448016, 0.205548},
	{0.397756, 0.220794},
	{0.351436, 0.245553},
	{0.310835, 0.278873},
	{0.277516, 0.319473},
	{0.252757, 0.365794},
	{0.237511, 0.416054},
	{0.237511, 0.416054},
	{0.232363, 0.468323},
	{0.232363, 0.468323},
	{0.237511, 0.520593},
	{0.252757, 0.570853},
	{0.277516, 0.617174},
	{0.500286, 0.468323},
	{0.310836, 0.657773},
	{0.351436, 0.691093},
	{0.500286, 0.468323},
	{0.351436, 0.691093},
	{0.397756, 0.715852},
	{0.397756, 0.715852},
	{0.448017, 0.731098},
	{0.500286, 0.736246},
	{0.552555, 0.731098},
	{0.602816, 0.715852},
	{0.500286, 0.468323},
	{0.602816, 0.715852},
	{0.649136, 0.691093},
	{0.649136, 0.691093},
	{0.689736, 0.657773},
	{0.723056, 0.617173},
	{0.500286, 0.468323},
	{0.723056, 0.617173},
	{0.747815, 0.570853},
	{0.747815, 0.570853},
	{0.763061, 0.520592},
	{0.768209, 0.468323},
	{0.763061, 0.416054},
	{0.747815, 0.365793},
	{0.747815, 0.365793},
	{0.723056, 0.319473},
	{0.723056, 0.319473},
	{0.689736, 0.278872},
	{0.500286, 0.468323},
	{0.689736, 0.278872},
	{0.649136, 0.245553},
	{0.649136, 0.245553},
	{0.602816, 0.220794},
	{0.552555, 0.205548},
	{0.500286, 0.200400},
	{0.500286, 0.468323},
	{0.500286, 0.200400},
	{0.448016, 0.205548},
	{0.448016, 0.205548},
	{0.397756, 0.220794},
	{0.397756, 0.220794},
	{0.351436, 0.245553},
	{0.351436, 0.245553},
	{0.310835, 0.278873},
	{0.277516, 0.319473},
	{0.277516, 0.319473},
	{0.252757, 0.365794},
	{0.252757, 0.365794},
	{0.237511, 0.416054},
	{0.232363, 0.468323},
	{0.237511, 0.520593},
	{0.252757, 0.570853},
	{0.277516, 0.617174},
	{0.500286, 0.468323},
	{0.310836, 0.657773},
	{0.351436, 0.691093},
	{0.500286, 0.468323},
	{0.351436, 0.691093},
	{0.397756, 0.715852},
	{0.448017, 0.731098},
	{0.500286, 0.736246},
	{0.552555, 0.731098},
	{0.602816, 0.715852},
	{0.649136, 0.691093},
	{0.689736, 0.657773},
	{0.723056, 0.617173},
	{0.747815, 0.570853},
	{0.763061, 0.520592},
	{0.768209, 0.468323},
	{0.500286, 0.468323},
	{0.768209, 0.468323},
	{0.763061, 0.416054},
	{0.763061, 0.416054},
	{0.747815, 0.365793},
	{0.723056, 0.319473},
	{0.689736, 0.278872},
	{0.689736, 0.278872},
	{0.649136, 0.245553},
	{0.649136, 0.245553},
	{0.602816, 0.220794},
	{0.500286, 0.468323},
	{0.602816, 0.220794},
	{0.552555, 0.205548},
	{0.552555, 0.205548},
	{0.500286, 0.200400},
	{0.448016, 0.205548},
	{0.397756, 0.220794},
	{0.351436, 0.245553},
	{0.310835, 0.278873},
	{0.277516, 0.319473},
	{0.277516, 0.319473},
	{0.252757, 0.365794},
	{0.252757, 0.365794},
	{0.237511, 0.416054},
	{0.232363, 0.468323},
	{0.237511, 0.520593},
	{0.252757, 0.570853},
	{0.277516, 0.617174},
	{0.277516, 0.617174},
	{0.310836, 0.657773},
	{0.500286, 0.468323},
	{0.310836, 0.657773},
	{0.351436, 0.691093},
	{0.397756, 0.715852},
	{0.448017, 0.731098},
	{0.500286, 0.736246},
	{0.552555, 0.731098},
	{0.602816, 0.715852},
	{0.649136, 0.691093},
	{0.689736, 0.657773},
	{0.500286, 0.468323},
	{0.689736, 0.657773},
	{0.723056, 0.617173},
	{0.723056, 0.617173},
	{0.747815, 0.570853},
	{0.763061, 0.520592},
	{0.768209, 0.468323},
	{0.763061, 0.416054},
	{0.763061, 0.416054},
	{0.747815, 0.365793},
	{0.747815, 0.365793},
	{0.723056, 0.319473},
	{0.689736, 0.278872},
	{0.649136, 0.245553},
	{0.602816, 0.220794},
	{0.552555, 0.205548},
	{0.500286, 0.200400},
	{0.448016, 0.205548},
	{0.500286, 0.468323},
	{0.448016, 0.205548},
	{0.397756, 0.220794},
	{0.397756, 0.220794},
	{0.351436, 0.245553},
	{0.310835, 0.278873},
	{0.277516, 0.319473},
	{0.252757, 0.365794},
	{0.252757, 0.365794},
	{0.237511, 0.416054},
	{0.237511, 0.416054},
	{0.232363, 0.468323},
	{0.237511, 0.520593},
	{0.252757, 0.570853},
	{0.277516, 0.617174},
	{0.500286, 0.468323},
	{0.310836, 0.657773},
	{0.351436, 0.691093},
	{0.397756, 0.715852},
	{0.448017, 0.731098},
	{0.500286, 0.736246},
	{0.552555, 0.731098},
	{0.602816, 0.715852},
	{0.649136, 0.691093},
	{0.689736, 0.657773},
	{0.723056, 0.617173},
	{0.747815, 0.570853},
	{0.500286, 0.468323},
	{0.747815, 0.570853},
	{0.763061, 0.520592},
	{0.763061, 0.520592},
	{0.768209, 0.468323},
	{0.763061, 0.416054},
	{0.747815, 0.365793},
	{0.723056, 0.319473},
	{0.689736, 0.278872},
	{0.500286, 0.468323},
	{0.689736, 0.278872},
	{0.649136, 0.245553},
	{0.649136, 0.245553},
	{0.602816, 0.220794},
	{0.500286, 0.468323},
	{0.602816, 0.220794},
	{0.552555, 0.205548},
	{0.552555, 0.205548},
	{0.500286, 0.200400},
	{0.448016, 0.205548},
	{0.397756, 0.220794},
	{0.351436, 0.245553},
	{0.310835, 0.278873},
	{0.277516, 0.319473},
	{0.252757, 0.365794},
	{0.237511, 0.416054},
	{0.232363, 0.468323},
	{0.237511, 0.520593},
	{0.252757, 0.570853},
	{0.277516, 0.617174},
	{0.277516, 0.617174},
	{0.310836, 0.657773},
	{0.500286, 0.468323},
	{0.500286, 0.468323},
	{0.310836, 0.657773},
	{0.351436, 0.691093},
	{0.500286, 0.468323},
	{0.351436, 0.691093},
	{0.397756, 0.715852},
	{0.500286, 0.468323},
	{0.397756, 0.715852},
	{0.448017, 0.731098},
	{0.448017, 0.731098},
	{0.500286, 0.736246},
	{0.552555, 0.731098},
	{0.602816, 0.715852},
	{0.602816, 0.715852},
	{0.649136, 0.691093},
	{0.649136, 0.691093},
	{0.689736, 0.657773},
	{0.723056, 0.617173},
	{0.747815, 0.570853},
	{0.763061, 0.520592},
	{0.768209, 0.468323},
	{0.763061, 0.416054},
	{0.747815, 0.365793},
	{0.723056, 0.319473},
	{0.689736, 0.278872},
	{0.649136, 0.245553},
	{0.602816, 0.220794},
	{0.552555, 0.205548},
	{0.500286, 0.200400},
	{0.448016, 0.205548},
	{0.397756, 0.220794},
	{0.351436, 0.245553},
	{0.310835, 0.278873},
	{0.277516, 0.319473},
	{0.252757, 0.365794},
	{0.500286, 0.468323},
	{0.252757, 0.365794},
	{0.237511, 0.416054},
	{0.237511, 0.416054},
	{0.232363, 0.468323},
	{0.232363, 0.468323},
	{0.237511, 0.520593},
	{0.237511, 0.520593},
	{0.252757, 0.570853},
	{0.277516, 0.617174},
	{0.996051, 0.008576},
	{0.886800, 0.008576},
	{0.942167, 0.058501},
	{0.996051, 0.043712},
	{0.856389, 0.088293},
	{0.830643, 0.008576},
	{0.719298, 0.087333},
	{0.718479, 0.006047},
	{0.636268, 0.019863},
	{0.636677, 0.146778},
	{0.938350, 0.226756},
	{0.856276, 0.226244},
	{0.798525, 0.303435},
	{0.924465, 0.303435},
	{0.781834, 0.114187},
	{0.817993, 0.101628},
	{0.805506, 0.008576},
	{0.781834, 0.008576},
	{0.791360, 0.098863},
	{0.830004, 0.085330},
	{0.804092, 0.004434},
	{0.778793, 0.004434},
	{0.754967, 0.111608},
	{0.791360, 0.098863},
	{0.778793, 0.004434},
	{0.754967, 0.004434},
	{0.939769, 0.225396},
	{0.855264, 0.225595},
	{0.796965, 0.303229},
	{0.924753, 0.303638},
	{0.718882, 0.087133},
	{0.716834, 0.006167},
	{0.636874, 0.017776},
	{0.637386, 0.145931},
	{0.916338, 0.055098},
	{0.860613, 0.004434},
	{0.970570, 0.004435},
	{0.970570, 0.111608},
	{0.996051, 0.221931},
	{0.996051, 0.161595},
	{0.917806, 0.130410},
	{0.886800, 0.221931},
	{0.858947, 0.129597},
	{0.862204, 0.182166},
	{0.841271, 0.157752},
	{0.828235, 0.126323},
	{0.797332, 0.124416},
	{0.815886, 0.138723},
	{0.996051, 0.161595},
	{0.996051, 0.100296},
	{0.930474, 0.093017},
	{0.917806, 0.130410},
	{0.996051, 0.100296},
	{0.930474, 0.093017},
	{0.857617, 0.108119},
	{0.858947, 0.129597},
	{0.857617, 0.108119},
	{0.828235, 0.126323},
	{0.822909, 0.113482},
	{0.789273, 0.119097},
	{0.797332, 0.124416},
	{0.817993, 0.101628},
	{0.781834, 0.114187},
	{0.858947, 0.129597},
	{0.857617, 0.108119},
	{0.822909, 0.113482},
	{0.241629, 0.067519},
	{0.294333, 0.045315},
	{0.307658, 0.040137},
	{0.242284, 0.016503},
	{0.956521, 0.501487},
	{0.978662, 0.501149},
	{0.978662, 0.483300},
	{0.956521, 0.455618},
	{0.978662, 0.483300},
	{0.978662, 0.464347},
	{0.956521, 0.409018},
	{0.956521, 0.455618},
	{0.956521, 0.366002},
	{0.978662, 0.422006},
	{0.956521, 0.339292},
	{0.978662, 0.339634},
	{0.018956, 0.014253},
	{0.018955, 0.123821},
	{0.069439, 0.068294},
	{0.125748, 0.014253},
	{0.099564, 0.154320},
	{0.018955, 0.180141},
	{0.104228, 0.290028},
	{0.018797, 0.289700},
	{0.032904, 0.370091},
	{0.159298, 0.369436},
	{0.240086, 0.070453},
	{0.240086, 0.153548},
	{0.309215, 0.210209},
	{0.309624, 0.083220},
	{0.125748, 0.229091},
	{0.113049, 0.192828},
	{0.018955, 0.205350},
	{0.018955, 0.229091},
	{0.113049, 0.192828},
	{0.018955, 0.205350},
	{0.133333, 0.101873},
	{0.110914, 0.121323},
	{0.137931, 0.129778},
	{0.242063, 0.016631},
	{0.241111, 0.067202},
	{0.307049, 0.041819},
	{0.296046, 0.036292},
	{0.234698, 0.014253},
	{0.200923, 0.014253},
	{0.183468, 0.106607},
	{0.234698, 0.123821},
	{0.165061, 0.150296},
	{0.194487, 0.148488},
	{0.169801, 0.169482},
	{0.152207, 0.176719},
	{0.141968, 0.204718},
	{0.149255, 0.193767},
	{0.152207, 0.176719},
	{0.169801, 0.169482},
	{0.348661, 0.029101},
	{0.368494, 0.029101},
	{0.377266, 0.005765},
	{0.349051, 0.005765},
	{0.164839, 0.014253},
	{0.128734, 0.088217},
	{0.133623, 0.152228},
	{0.152207, 0.176719},
	{0.133411, 0.184451},
	{0.134182, 0.216417},
	{0.141968, 0.204718},
	{0.133411, 0.184451},
	{0.113049, 0.192828},
	{0.125748, 0.229091},
	{0.134182, 0.216417},
	{0.133411, 0.184451},
	{0.389553, 0.029101},
	{0.407410, 0.005765},
	{0.377266, 0.005765},
	{0.368494, 0.029101},
	{0.436602, 0.029101},
	{0.440066, 0.005765},
	{0.407410, 0.005765},
	{0.389553, 0.029101},
	{0.528132, 0.029101},
	{0.529278, 0.005765},
	{0.363979, 0.011335},
	{0.361948, 0.066519},
	{0.513370, 0.066519},
	{0.511567, 0.011335},
	{0.835857, 0.180592},
	{0.834452, 0.157729},
	{0.809166, 0.142148},
	{0.814789, 0.155817},
	{0.781909, 0.129537},
	{0.790417, 0.135199},
	{0.860613, 0.220946},
	{0.873987, 0.181142},
	{0.970570, 0.220946},
	{0.970570, 0.194705},
	{0.832807, 0.130942},
	{0.802578, 0.126133},
	{0.771940, 0.122903},
	{0.802578, 0.126133},
	{0.791360, 0.098863},
	{0.754967, 0.111608},
	{0.771940, 0.122903},
	{0.889656, 0.134506},
	{0.970570, 0.163959},
	{0.436384, 0.061112},
	{0.444181, 0.005758},
	{0.401709, 0.005758},
	{0.401436, 0.061112},
	{0.365461, 0.005758},
	{0.368524, 0.061112},
	{0.401436, 0.061112},
	{0.401709, 0.005758},
	{0.514459, 0.061112},
	{0.516497, 0.005758},
	{0.310293, 0.041072},
	{0.240920, 0.016025},
	{0.240264, 0.066441},
	{0.292705, 0.047655},
	{0.996051, 0.008576},
	{0.886800, 0.008576},
	{0.942167, 0.058501},
	{0.996051, 0.043712},
	{0.856389, 0.088293},
	{0.830643, 0.008576},
	{0.719298, 0.087333},
	{0.718479, 0.006047},
	{0.636268, 0.019863},
	{0.636677, 0.146778},
	{0.938350, 0.226756},
	{0.856276, 0.226244},
	{0.798525, 0.303435},
	{0.924465, 0.303435},
	{0.781834, 0.114187},
	{0.817993, 0.101628},
	{0.805506, 0.008576},
	{0.781834, 0.008576},
	{0.791360, 0.098863},
	{0.830004, 0.085330},
	{0.804092, 0.004434},
	{0.778793, 0.004434},
	{0.754967, 0.111608},
	{0.754967, 0.004434},
	{0.939769, 0.225396},
	{0.855264, 0.225595},
	{0.796965, 0.303229},
	{0.924753, 0.303638},
	{0.718882, 0.087133},
	{0.716834, 0.006167},
	{0.636874, 0.017776},
	{0.637386, 0.145931},
	{0.916338, 0.055098},
	{0.860613, 0.004434},
	{0.970570, 0.004435},
	{0.970570, 0.111608},
	{0.996051, 0.221931},
	{0.996051, 0.161595},
	{0.917806, 0.130410},
	{0.886800, 0.221931},
	{0.858947, 0.129597},
	{0.862204, 0.182166},
	{0.841271, 0.157752},
	{0.828235, 0.126323},
	{0.797332, 0.124416},
	{0.815886, 0.138723},
	{0.996051, 0.100296},
	{0.930474, 0.093017},
	{0.857617, 0.108119},
	{0.822909, 0.113482},
	{0.789273, 0.119097},
	{0.241629, 0.067519},
	{0.294333, 0.045315},
	{0.307658, 0.040137},
	{0.242284, 0.016503},
	{0.956521, 0.501487},
	{0.978662, 0.501149},
	{0.978662, 0.483300},
	{0.956521, 0.455618},
	{0.978662, 0.464347},
	{0.956521, 0.409018},
	{0.956521, 0.366002},
	{0.956521, 0.409018},
	{0.978662, 0.464347},
	{0.978662, 0.422006},
	{0.956521, 0.339292},
	{0.978662, 0.339634},
	{0.018956, 0.014253},
	{0.018955, 0.123821},
	{0.069439, 0.068294},
	{0.125748, 0.014253},
	{0.099564, 0.154320},
	{0.018955, 0.180141},
	{0.104228, 0.290028},
	{0.018797, 0.289700},
	{0.032904, 0.370091},
	{0.159298, 0.369436},
	{0.240086, 0.070453},
	{0.240086, 0.153548},
	{0.309215, 0.210209},
	{0.309624, 0.083220},
	{0.125748, 0.229091},
	{0.113049, 0.192828},
	{0.018955, 0.205350},
	{0.018955, 0.229091},
	{0.113049, 0.192828},
	{0.018955, 0.205350},
	{0.133333, 0.101873},
	{0.110914, 0.121323},
	{0.137931, 0.129778},
	{0.242063, 0.016631},
	{0.241111, 0.067202},
	{0.307049, 0.041819},
	{0.296046, 0.036292},
	{0.234698, 0.014253},
	{0.200923, 0.014253},
	{0.183468, 0.106607},
	{0.234698, 0.123821},
	{0.165061, 0.150296},
	{0.194487, 0.148488},
	{0.169801, 0.169482},
	{0.152207, 0.176719},
	{0.141968, 0.204718},
	{0.149255, 0.193767},
	{0.152207, 0.176719},
	{0.169801, 0.169482},
	{0.348661, 0.029101},
	{0.368494, 0.029101},
	{0.377266, 0.005765},
	{0.349051, 0.005765},
	{0.164839, 0.014253},
	{0.128734, 0.088217},
	{0.133623, 0.152228},
	{0.152207, 0.176719},
	{0.133411, 0.184451},
	{0.134182, 0.216417},
	{0.141968, 0.204718},
	{0.113049, 0.192828},
	{0.125748, 0.229091},
	{0.133411, 0.184451},
	{0.389553, 0.029101},
	{0.407410, 0.005765},
	{0.377266, 0.005765},
	{0.368494, 0.029101},
	{0.436602, 0.029101},
	{0.440066, 0.005765},
	{0.528132, 0.029101},
	{0.529278, 0.005765},
	{0.440066, 0.005765},
	{0.436602, 0.029101},
	{0.363979, 0.011335},
	{0.361948, 0.066519},
	{0.513370, 0.066519},
	{0.511567, 0.011335},
	{0.835857, 0.180592},
	{0.834452, 0.157729},
	{0.809166, 0.142148},
	{0.814789, 0.155817},
	{0.781909, 0.129537},
	{0.790417, 0.135199},
	{0.860613, 0.220946},
	{0.873987, 0.181142},
	{0.970570, 0.220946},
	{0.970570, 0.194705},
	{0.832807, 0.130942},
	{0.802578, 0.126133},
	{0.771940, 0.122903},
	{0.889656, 0.134506},
	{0.970570, 0.163959},
	{0.436384, 0.061112},
	{0.444181, 0.005758},
	{0.401709, 0.005758},
	{0.401436, 0.061112},
	{0.365461, 0.005758},
	{0.368524, 0.061112},
	{0.401436, 0.061112},
	{0.401709, 0.005758},
	{0.514459, 0.061112},
	{0.516497, 0.005758},
	{0.310293, 0.041072},
	{0.240920, 0.016025},
	{0.240264, 0.066441},
	{0.292705, 0.047655},
	{0.996051, 0.008576},
	{0.996051, 0.043712},
	{0.942167, 0.058501},
	{0.886800, 0.008576},
	{0.856389, 0.088293},
	{0.830643, 0.008576},
	{0.719298, 0.087333},
	{0.636677, 0.146778},
	{0.636268, 0.019863},
	{0.718479, 0.006047},
	{0.938350, 0.226756},
	{0.924465, 0.303435},
	{0.798525, 0.303435},
	{0.856276, 0.226244},
	{0.781834, 0.114187},
	{0.781834, 0.008576},
	{0.805506, 0.008576},
	{0.817993, 0.101628},
	{0.791360, 0.098863},
	{0.778793, 0.004434},
	{0.804092, 0.004434},
	{0.830004, 0.085330},
	{0.754967, 0.111608},
	{0.754967, 0.004434},
	{0.939769, 0.225396},
	{0.924753, 0.303638},
	{0.796965, 0.303229},
	{0.855264, 0.225595},
	{0.718882, 0.087133},
	{0.637386, 0.145931},
	{0.636874, 0.017776},
	{0.716834, 0.006167},
	{0.860613, 0.004434},
	{0.916338, 0.055098},
	{0.970570, 0.004435},
	{0.970570, 0.111608},
	{0.996051, 0.221931},
	{0.886800, 0.221931},
	{0.917806, 0.130410},
	{0.996051, 0.161595},
	{0.862204, 0.182166},
	{0.858947, 0.129597},
	{0.841271, 0.157752},
	{0.815886, 0.138723},
	{0.797332, 0.124416},
	{0.828235, 0.126323},
	{0.996051, 0.161595},
	{0.917806, 0.130410},
	{0.930474, 0.093017},
	{0.996051, 0.100296},
	{0.996051, 0.100296},
	{0.930474, 0.093017},
	{0.858947, 0.129597},
	{0.857617, 0.108119},
	{0.857617, 0.108119},
	{0.828235, 0.126323},
	{0.797332, 0.124416},
	{0.789273, 0.119097},
	{0.822909, 0.113482},
	{0.781834, 0.114187},
	{0.817993, 0.101628},
	{0.858947, 0.129597},
	{0.857617, 0.108119},
	{0.822909, 0.113482},
	{0.241629, 0.067519},
	{0.242284, 0.016503},
	{0.307658, 0.040137},
	{0.294333, 0.045315},
	{0.956521, 0.501487},
	{0.956521, 0.455618},
	{0.978662, 0.483300},
	{0.978662, 0.501149},
	{0.956521, 0.409018},
	{0.978662, 0.464347},
	{0.956521, 0.366002},
	{0.978662, 0.422006},
	{0.956521, 0.339292},
	{0.978662, 0.339634},
	{0.978662, 0.422006},
	{0.956521, 0.366002},
	{0.018956, 0.014253},
	{0.125748, 0.014253},
	{0.069439, 0.068294},
	{0.018955, 0.123821},
	{0.099564, 0.154320},
	{0.018955, 0.180141},
	{0.104228, 0.290028},
	{0.159298, 0.369436},
	{0.032904, 0.370091},
	{0.018797, 0.289700},
	{0.240086, 0.070453},
	{0.309624, 0.083220},
	{0.309215, 0.210209},
	{0.240086, 0.153548},
	{0.125748, 0.229091},
	{0.018955, 0.229091},
	{0.018955, 0.205350},
	{0.113049, 0.192828},
	{0.133333, 0.101873},
	{0.137931, 0.129778},
	{0.110914, 0.121323},
	{0.242063, 0.016631},
	{0.296046, 0.036292},
	{0.307049, 0.041819},
	{0.241111, 0.067202},
	{0.234698, 0.014253},
	{0.234698, 0.123821},
	{0.183468, 0.106607},
	{0.200923, 0.014253},
	{0.194487, 0.148488},
	{0.165061, 0.150296},
	{0.169801, 0.169482},
	{0.149255, 0.193767},
	{0.141968, 0.204718},
	{0.152207, 0.176719},
	{0.348661, 0.029101},
	{0.349051, 0.005765},
	{0.377266, 0.005765},
	{0.368494, 0.029101},
	{0.128734, 0.088217},
	{0.164839, 0.014253},
	{0.133623, 0.152228},
	{0.134182, 0.216417},
	{0.133411, 0.184451},
	{0.389553, 0.029101},
	{0.407410, 0.005765},
	{0.436602, 0.029101},
	{0.389553, 0.029101},
	{0.407410, 0.005765},
	{0.440066, 0.005765},
	{0.528132, 0.029101},
	{0.436602, 0.029101},
	{0.440066, 0.005765},
	{0.529278, 0.005765},
	{0.363979, 0.011335},
	{0.511567, 0.011335},
	{0.513370, 0.066519},
	{0.361948, 0.066519},
	{0.835857, 0.180592},
	{0.814789, 0.155817},
	{0.809166, 0.142148},
	{0.834452, 0.157729},
	{0.790417, 0.135199},
	{0.781909, 0.129537},
	{0.860613, 0.220946},
	{0.873987, 0.181142},
	{0.970570, 0.220946},
	{0.970570, 0.194705},
	{0.802578, 0.126133},
	{0.832807, 0.130942},
	{0.771940, 0.122903},
	{0.889656, 0.134506},
	{0.970570, 0.163959},
	{0.436384, 0.061112},
	{0.401436, 0.061112},
	{0.401709, 0.005758},
	{0.444181, 0.005758},
	{0.365461, 0.005758},
	{0.368524, 0.061112},
	{0.514459, 0.061112},
	{0.516497, 0.005758},
	{0.310293, 0.041072},
	{0.292705, 0.047655},
	{0.240264, 0.066441},
	{0.240920, 0.016025},
	{0.996051, 0.008576},
	{0.996051, 0.043712},
	{0.942167, 0.058501},
	{0.886800, 0.008576},
	{0.856389, 0.088293},
	{0.830643, 0.008576},
	{0.719298, 0.087333},
	{0.636677, 0.146778},
	{0.636268, 0.019863},
	{0.718479, 0.006047},
	{0.938350, 0.226756},
	{0.924465, 0.303435},
	{0.798525, 0.303435},
	{0.856276, 0.226244},
	{0.781834, 0.114187},
	{0.781834, 0.008576},
	{0.805506, 0.008576},
	{0.817993, 0.101628},
	{0.791360, 0.098863},
	{0.778793, 0.004434},
	{0.804092, 0.004434},
	{0.830004, 0.085330},
	{0.754967, 0.111608},
	{0.754967, 0.004434},
	{0.939769, 0.225396},
	{0.924753, 0.303638},
	{0.796965, 0.303229},
	{0.855264, 0.225595},
	{0.718882, 0.087133},
	{0.637386, 0.145931},
	{0.636874, 0.017776},
	{0.716834, 0.006167},
	{0.860613, 0.004434},
	{0.916338, 0.055098},
	{0.970570, 0.004435},
	{0.970570, 0.111608},
	{0.996051, 0.221931},
	{0.886800, 0.221931},
	{0.917806, 0.130410},
	{0.996051, 0.161595},
	{0.862204, 0.182166},
	{0.858947, 0.129597},
	{0.841271, 0.157752},
	{0.815886, 0.138723},
	{0.797332, 0.124416},
	{0.828235, 0.126323},
	{0.930474, 0.093017},
	{0.996051, 0.100296},
	{0.857617, 0.108119},
	{0.789273, 0.119097},
	{0.822909, 0.113482},
	{0.241629, 0.067519},
	{0.242284, 0.016503},
	{0.307658, 0.040137},
	{0.294333, 0.045315},
	{0.956521, 0.501487},
	{0.956521, 0.455618},
	{0.978662, 0.483300},
	{0.978662, 0.501149},
	{0.956521, 0.409018},
	{0.978662, 0.464347},
	{0.956521, 0.366002},
	{0.978662, 0.422006},
	{0.956521, 0.339292},
	{0.978662, 0.339634},
	{0.978662, 0.422006},
	{0.956521, 0.366002},
	{0.018956, 0.014253},
	{0.125748, 0.014253},
	{0.069439, 0.068294},
	{0.018955, 0.123821},
	{0.099564, 0.154320},
	{0.018955, 0.180141},
	{0.104228, 0.290028},
	{0.159298, 0.369436},
	{0.032904, 0.370091},
	{0.018797, 0.289700},
	{0.240086, 0.070453},
	{0.309624, 0.083220},
	{0.309215, 0.210209},
	{0.240086, 0.153548},
	{0.125748, 0.229091},
	{0.018955, 0.229091},
	{0.018955, 0.205350},
	{0.113049, 0.192828},
	{0.113049, 0.192828},
	{0.018955, 0.205350},
	{0.133333, 0.101873},
	{0.137931, 0.129778},
	{0.110914, 0.121323},
	{0.242063, 0.016631},
	{0.296046, 0.036292},
	{0.307049, 0.041819},
	{0.241111, 0.067202},
	{0.234698, 0.014253},
	{0.234698, 0.123821},
	{0.183468, 0.106607},
	{0.200923, 0.014253},
	{0.194487, 0.148488},
	{0.165061, 0.150296},
	{0.169801, 0.169482},
	{0.149255, 0.193767},
	{0.141968, 0.204718},
	{0.152207, 0.176719},
	{0.169801, 0.169482},
	{0.152207, 0.176719},
	{0.348661, 0.029101},
	{0.349051, 0.005765},
	{0.377266, 0.005765},
	{0.368494, 0.029101},
	{0.128734, 0.088217},
	{0.164839, 0.014253},
	{0.133623, 0.152228},
	{0.152207, 0.176719},
	{0.141968, 0.204718},
	{0.134182, 0.216417},
	{0.133411, 0.184451},
	{0.125748, 0.229091},
	{0.113049, 0.192828},
	{0.133411, 0.184451},
	{0.389553, 0.029101},
	{0.368494, 0.029101},
	{0.377266, 0.005765},
	{0.407410, 0.005765},
	{0.436602, 0.029101},
	{0.389553, 0.029101},
	{0.407410, 0.005765},
	{0.440066, 0.005765},
	{0.528132, 0.029101},
	{0.436602, 0.029101},
	{0.440066, 0.005765},
	{0.529278, 0.005765},
	{0.363979, 0.011335},
	{0.511567, 0.011335},
	{0.513370, 0.066519},
	{0.361948, 0.066519},
	{0.835857, 0.180592},
	{0.814789, 0.155817},
	{0.809166, 0.142148},
	{0.834452, 0.157729},
	{0.790417, 0.135199},
	{0.781909, 0.129537},
	{0.860613, 0.220946},
	{0.873987, 0.181142},
	{0.970570, 0.220946},
	{0.970570, 0.194705},
	{0.802578, 0.126133},
	{0.832807, 0.130942},
	{0.771940, 0.122903},
	{0.889656, 0.134506},
	{0.970570, 0.163959},
	{0.436384, 0.061112},
	{0.401436, 0.061112},
	{0.401709, 0.005758},
	{0.444181, 0.005758},
	{0.365461, 0.005758},
	{0.401709, 0.005758},
	{0.401436, 0.061112},
	{0.368524, 0.061112},
	{0.514459, 0.061112},
	{0.516497, 0.005758},
	{0.310293, 0.041072},
	{0.292705, 0.047655},
	{0.240264, 0.066441},
	{0.240920, 0.016025},
	{0.996051, 0.008576},
	{0.886800, 0.008576},
	{0.942167, 0.058501},
	{0.996051, 0.043712},
	{0.856389, 0.088293},
	{0.830643, 0.008576},
	{0.719298, 0.087333},
	{0.718479, 0.006047},
	{0.636268, 0.019863},
	{0.636677, 0.146778},
	{0.938350, 0.226756},
	{0.856276, 0.226244},
	{0.798525, 0.303435},
	{0.924465, 0.303435},
	{0.781834, 0.114187},
	{0.817993, 0.101628},
	{0.805506, 0.008576},
	{0.781834, 0.008576},
	{0.791360, 0.098863},
	{0.830004, 0.085330},
	{0.804092, 0.004434},
	{0.778793, 0.004434},
	{0.754967, 0.111608},
	{0.791360, 0.098863},
	{0.778793, 0.004434},
	{0.754967, 0.004434},
	{0.939769, 0.225396},
	{0.855264, 0.225595},
	{0.796965, 0.303229},
	{0.924753, 0.303638},
	{0.718882, 0.087133},
	{0.716834, 0.006167},
	{0.636874, 0.017776},
	{0.637386, 0.145931},
	{0.830004, 0.085330},
	{0.916338, 0.055098},
	{0.860613, 0.004434},
	{0.804092, 0.004434},
	{0.970570, 0.004435},
	{0.970570, 0.111608},
	{0.996051, 0.221931},
	{0.996051, 0.161595},
	{0.917806, 0.130410},
	{0.886800, 0.221931},
	{0.858947, 0.129597},
	{0.862204, 0.182166},
	{0.841271, 0.157752},
	{0.828235, 0.126323},
	{0.797332, 0.124416},
	{0.815886, 0.138723},
	{0.996051, 0.161595},
	{0.996051, 0.100296},
	{0.930474, 0.093017},
	{0.917806, 0.130410},
	{0.996051, 0.100296},
	{0.930474, 0.093017},
	{0.857617, 0.108119},
	{0.858947, 0.129597},
	{0.857617, 0.108119},
	{0.828235, 0.126323},
	{0.822909, 0.113482},
	{0.789273, 0.119097},
	{0.797332, 0.124416},
	{0.817993, 0.101628},
	{0.781834, 0.114187},
	{0.858947, 0.129597},
	{0.857617, 0.108119},
	{0.822909, 0.113482},
	{0.241629, 0.067519},
	{0.294333, 0.045315},
	{0.307658, 0.040137},
	{0.242284, 0.016503},
	{0.956521, 0.501487},
	{0.978662, 0.501149},
	{0.978662, 0.483300},
	{0.956521, 0.455618},
	{0.978662, 0.483300},
	{0.978662, 0.464347},
	{0.956521, 0.409018},
	{0.956521, 0.455618},
	{0.956521, 0.366002},
	{0.956521, 0.409018},
	{0.978662, 0.464347},
	{0.978662, 0.422006},
	{0.956521, 0.339292},
	{0.978662, 0.339634},
	{0.018956, 0.014253},
	{0.018955, 0.123821},
	{0.069439, 0.068294},
	{0.125748, 0.014253},
	{0.099564, 0.154320},
	{0.018955, 0.180141},
	{0.104228, 0.290028},
	{0.018797, 0.289700},
	{0.032904, 0.370091},
	{0.159298, 0.369436},
	{0.240086, 0.070453},
	{0.240086, 0.153548},
	{0.309215, 0.210209},
	{0.309624, 0.083220},
	{0.125748, 0.229091},
	{0.113049, 0.192828},
	{0.018955, 0.205350},
	{0.018955, 0.229091},
	{0.113049, 0.192828},
	{0.018955, 0.205350},
	{0.133333, 0.101873},
	{0.110914, 0.121323},
	{0.137931, 0.129778},
	{0.242063, 0.016631},
	{0.241111, 0.067202},
	{0.307049, 0.041819},
	{0.296046, 0.036292},
	{0.234698, 0.014253},
	{0.200923, 0.014253},
	{0.183468, 0.106607},
	{0.234698, 0.123821},
	{0.165061, 0.150296},
	{0.194487, 0.148488},
	{0.169801, 0.169482},
	{0.152207, 0.176719},
	{0.141968, 0.204718},
	{0.149255, 0.193767},
	{0.152207, 0.176719},
	{0.169801, 0.169482},
	{0.348661, 0.029101},
	{0.368494, 0.029101},
	{0.377266, 0.005765},
	{0.349051, 0.005765},
	{0.164839, 0.014253},
	{0.128734, 0.088217},
	{0.133623, 0.152228},
	{0.152207, 0.176719},
	{0.133411, 0.184451},
	{0.134182, 0.216417},
	{0.141968, 0.204718},
	{0.133411, 0.184451},
	{0.113049, 0.192828},
	{0.125748, 0.229091},
	{0.134182, 0.216417},
	{0.133411, 0.184451},
	{0.389553, 0.029101},
	{0.407410, 0.005765},
	{0.436602, 0.029101},
	{0.440066, 0.005765},
	{0.528132, 0.029101},
	{0.529278, 0.005765},
	{0.363979, 0.011335},
	{0.361948, 0.066519},
	{0.513370, 0.066519},
	{0.511567, 0.011335},
	{0.835857, 0.180592},
	{0.834452, 0.157729},
	{0.809166, 0.142148},
	{0.814789, 0.155817},
	{0.814789, 0.155817},
	{0.809166, 0.142148},
	{0.781909, 0.129537},
	{0.790417, 0.135199},
	{0.860613, 0.220946},
	{0.873987, 0.181142},
	{0.970570, 0.220946},
	{0.970570, 0.194705},
	{0.834452, 0.157729},
	{0.832807, 0.130942},
	{0.802578, 0.126133},
	{0.809166, 0.142148},
	{0.832807, 0.130942},
	{0.830004, 0.085330},
	{0.791360, 0.098863},
	{0.802578, 0.126133},
	{0.809166, 0.142148},
	{0.802578, 0.126133},
	{0.771940, 0.122903},
	{0.781909, 0.129537},
	{0.802578, 0.126133},
	{0.791360, 0.098863},
	{0.754967, 0.111608},
	{0.771940, 0.122903},
	{0.889656, 0.134506},
	{0.832807, 0.130942},
	{0.970570, 0.163959},
	{0.436384, 0.061112},
	{0.444181, 0.005758},
	{0.401709, 0.005758},
	{0.401436, 0.061112},
	{0.365461, 0.005758},
	{0.368524, 0.061112},
	{0.401436, 0.061112},
	{0.401709, 0.005758},
	{0.514459, 0.061112},
	{0.516497, 0.005758},
	{0.310293, 0.041072},
	{0.240920, 0.016025},
	{0.240264, 0.066441},
	{0.292705, 0.047655},
	{0.996051, 0.008576},
	{0.886800, 0.008576},
	{0.942167, 0.058501},
	{0.996051, 0.043712},
	{0.856389, 0.088293},
	{0.830643, 0.008576},
	{0.719298, 0.087333},
	{0.718479, 0.006047},
	{0.636268, 0.019863},
	{0.636677, 0.146778},
	{0.938350, 0.226756},
	{0.856276, 0.226244},
	{0.798525, 0.303435},
	{0.924465, 0.303435},
	{0.781834, 0.114187},
	{0.817993, 0.101628},
	{0.805506, 0.008576},
	{0.781834, 0.008576},
	{0.791360, 0.098863},
	{0.830004, 0.085330},
	{0.804092, 0.004434},
	{0.778793, 0.004434},
	{0.754967, 0.111608},
	{0.754967, 0.004434},
	{0.939769, 0.225396},
	{0.855264, 0.225595},
	{0.796965, 0.303229},
	{0.924753, 0.303638},
	{0.718882, 0.087133},
	{0.716834, 0.006167},
	{0.636874, 0.017776},
	{0.637386, 0.145931},
	{0.916338, 0.055098},
	{0.860613, 0.004434},
	{0.970570, 0.004435},
	{0.970570, 0.111608},
	{0.996051, 0.221931},
	{0.996051, 0.161595},
	{0.917806, 0.130410},
	{0.886800, 0.221931},
	{0.858947, 0.129597},
	{0.862204, 0.182166},
	{0.841271, 0.157752},
	{0.828235, 0.126323},
	{0.797332, 0.124416},
	{0.815886, 0.138723},
	{0.996051, 0.100296},
	{0.930474, 0.093017},
	{0.857617, 0.108119},
	{0.822909, 0.113482},
	{0.789273, 0.119097},
	{0.241629, 0.067519},
	{0.294333, 0.045315},
	{0.307658, 0.040137},
	{0.242284, 0.016503},
	{0.956521, 0.501487},
	{0.978662, 0.501149},
	{0.978662, 0.483300},
	{0.956521, 0.455618},
	{0.978662, 0.464347},
	{0.956521, 0.409018},
	{0.956521, 0.366002},
	{0.978662, 0.422006},
	{0.956521, 0.339292},
	{0.956521, 0.366002},
	{0.978662, 0.422006},
	{0.978662, 0.339634},
	{0.018956, 0.014253},
	{0.018955, 0.123821},
	{0.069439, 0.068294},
	{0.125748, 0.014253},
	{0.099564, 0.154320},
	{0.018955, 0.180141},
	{0.104228, 0.290028},
	{0.018797, 0.289700},
	{0.032904, 0.370091},
	{0.159298, 0.369436},
	{0.240086, 0.070453},
	{0.240086, 0.153548},
	{0.309215, 0.210209},
	{0.309624, 0.083220},
	{0.125748, 0.229091},
	{0.113049, 0.192828},
	{0.018955, 0.205350},
	{0.018955, 0.229091},
	{0.113049, 0.192828},
	{0.018955, 0.205350},
	{0.133333, 0.101873},
	{0.110914, 0.121323},
	{0.137931, 0.129778},
	{0.242063, 0.016631},
	{0.241111, 0.067202},
	{0.307049, 0.041819},
	{0.296046, 0.036292},
	{0.234698, 0.014253},
	{0.200923, 0.014253},
	{0.183468, 0.106607},
	{0.234698, 0.123821},
	{0.165061, 0.150296},
	{0.194487, 0.148488},
	{0.169801, 0.169482},
	{0.152207, 0.176719},
	{0.141968, 0.204718},
	{0.149255, 0.193767},
	{0.152207, 0.176719},
	{0.169801, 0.169482},
	{0.348661, 0.029101},
	{0.368494, 0.029101},
	{0.377266, 0.005765},
	{0.349051, 0.005765},
	{0.164839, 0.014253},
	{0.128734, 0.088217},
	{0.133623, 0.152228},
	{0.152207, 0.176719},
	{0.133411, 0.184451},
	{0.134182, 0.216417},
	{0.141968, 0.204718},
	{0.113049, 0.192828},
	{0.125748, 0.229091},
	{0.133411, 0.184451},
	{0.389553, 0.029101},
	{0.407410, 0.005765},
	{0.436602, 0.029101},
	{0.440066, 0.005765},
	{0.528132, 0.029101},
	{0.529278, 0.005765},
	{0.363979, 0.011335},
	{0.361948, 0.066519},
	{0.513370, 0.066519},
	{0.511567, 0.011335},
	{0.835857, 0.180592},
	{0.834452, 0.157729},
	{0.809166, 0.142148},
	{0.814789, 0.155817},
	{0.814789, 0.155817},
	{0.809166, 0.142148},
	{0.781909, 0.129537},
	{0.790417, 0.135199},
	{0.860613, 0.220946},
	{0.873987, 0.181142},
	{0.834452, 0.157729},
	{0.835857, 0.180592},
	{0.970570, 0.220946},
	{0.970570, 0.194705},
	{0.873987, 0.181142},
	{0.860613, 0.220946},
	{0.834452, 0.157729},
	{0.832807, 0.130942},
	{0.802578, 0.126133},
	{0.771940, 0.122903},
	{0.873987, 0.181142},
	{0.889656, 0.134506},
	{0.832807, 0.130942},
	{0.834452, 0.157729},
	{0.889656, 0.134506},
	{0.970570, 0.194705},
	{0.970570, 0.163959},
	{0.889656, 0.134506},
	{0.873987, 0.181142},
	{0.970570, 0.163959},
	{0.436384, 0.061112},
	{0.444181, 0.005758},
	{0.401709, 0.005758},
	{0.401436, 0.061112},
	{0.365461, 0.005758},
	{0.368524, 0.061112},
	{0.401436, 0.061112},
	{0.401709, 0.005758},
	{0.514459, 0.061112},
	{0.516497, 0.005758},
	{0.444181, 0.005758},
	{0.436384, 0.061112},
	{0.310293, 0.041072},
	{0.240920, 0.016025},
	{0.240264, 0.066441},
	{0.292705, 0.047655},
	{0.996051, 0.008576},
	{0.996051, 0.043712},
	{0.942167, 0.058501},
	{0.886800, 0.008576},
	{0.856389, 0.088293},
	{0.830643, 0.008576},
	{0.719298, 0.087333},
	{0.636677, 0.146778},
	{0.636268, 0.019863},
	{0.718479, 0.006047},
	{0.938350, 0.226756},
	{0.924465, 0.303435},
	{0.798525, 0.303435},
	{0.856276, 0.226244},
	{0.781834, 0.114187},
	{0.781834, 0.008576},
	{0.805506, 0.008576},
	{0.817993, 0.101628},
	{0.791360, 0.098863},
	{0.778793, 0.004434},
	{0.804092, 0.004434},
	{0.830004, 0.085330},
	{0.754967, 0.111608},
	{0.754967, 0.004434},
	{0.778793, 0.004434},
	{0.791360, 0.098863},
	{0.939769, 0.225396},
	{0.924753, 0.303638},
	{0.796965, 0.303229},
	{0.855264, 0.225595},
	{0.718882, 0.087133},
	{0.637386, 0.145931},
	{0.636874, 0.017776},
	{0.716834, 0.006167},
	{0.830004, 0.085330},
	{0.804092, 0.004434},
	{0.860613, 0.004434},
	{0.916338, 0.055098},
	{0.970570, 0.004435},
	{0.970570, 0.111608},
	{0.996051, 0.221931},
	{0.886800, 0.221931},
	{0.917806, 0.130410},
	{0.996051, 0.161595},
	{0.862204, 0.182166},
	{0.858947, 0.129597},
	{0.841271, 0.157752},
	{0.815886, 0.138723},
	{0.797332, 0.124416},
	{0.828235, 0.126323},
	{0.996051, 0.161595},
	{0.917806, 0.130410},
	{0.930474, 0.093017},
	{0.996051, 0.100296},
	{0.996051, 0.100296},
	{0.930474, 0.093017},
	{0.858947, 0.129597},
	{0.857617, 0.108119},
	{0.857617, 0.108119},
	{0.828235, 0.126323},
	{0.797332, 0.124416},
	{0.789273, 0.119097},
	{0.822909, 0.113482},
	{0.781834, 0.114187},
	{0.817993, 0.101628},
	{0.858947, 0.129597},
	{0.857617, 0.108119},
	{0.822909, 0.113482},
	{0.241629, 0.067519},
	{0.242284, 0.016503},
	{0.307658, 0.040137},
	{0.294333, 0.045315},
	{0.956521, 0.501487},
	{0.956521, 0.455618},
	{0.978662, 0.483300},
	{0.978662, 0.501149},
	{0.978662, 0.483300},
	{0.956521, 0.455618},
	{0.956521, 0.409018},
	{0.978662, 0.464347},
	{0.956521, 0.366002},
	{0.978662, 0.422006},
	{0.978662, 0.464347},
	{0.956521, 0.409018},
	{0.956521, 0.339292},
	{0.978662, 0.339634},
	{0.018956, 0.014253},
	{0.125748, 0.014253},
	{0.069439, 0.068294},
	{0.018955, 0.123821},
	{0.099564, 0.154320},
	{0.018955, 0.180141},
	{0.104228, 0.290028},
	{0.159298, 0.369436},
	{0.032904, 0.370091},
	{0.018797, 0.289700},
	{0.240086, 0.070453},
	{0.309624, 0.083220},
	{0.309215, 0.210209},
	{0.240086, 0.153548},
	{0.125748, 0.229091},
	{0.018955, 0.229091},
	{0.018955, 0.205350},
	{0.113049, 0.192828},
	{0.133333, 0.101873},
	{0.137931, 0.129778},
	{0.110914, 0.121323},
	{0.242063, 0.016631},
	{0.296046, 0.036292},
	{0.307049, 0.041819},
	{0.241111, 0.067202},
	{0.234698, 0.014253},
	{0.234698, 0.123821},
	{0.183468, 0.106607},
	{0.200923, 0.014253},
	{0.194487, 0.148488},
	{0.165061, 0.150296},
	{0.169801, 0.169482},
	{0.149255, 0.193767},
	{0.141968, 0.204718},
	{0.152207, 0.176719},
	{0.348661, 0.029101},
	{0.349051, 0.005765},
	{0.377266, 0.005765},
	{0.368494, 0.029101},
	{0.128734, 0.088217},
	{0.164839, 0.014253},
	{0.133623, 0.152228},
	{0.134182, 0.216417},
	{0.133411, 0.184451},
	{0.389553, 0.029101},
	{0.368494, 0.029101},
	{0.377266, 0.005765},
	{0.407410, 0.005765},
	{0.436602, 0.029101},
	{0.440066, 0.005765},
	{0.528132, 0.029101},
	{0.529278, 0.005765},
	{0.363979, 0.011335},
	{0.511567, 0.011335},
	{0.513370, 0.066519},
	{0.361948, 0.066519},
	{0.835857, 0.180592},
	{0.814789, 0.155817},
	{0.809166, 0.142148},
	{0.834452, 0.157729},
	{0.814789, 0.155817},
	{0.790417, 0.135199},
	{0.781909, 0.129537},
	{0.809166, 0.142148},
	{0.860613, 0.220946},
	{0.873987, 0.181142},
	{0.970570, 0.220946},
	{0.970570, 0.194705},
	{0.834452, 0.157729},
	{0.809166, 0.142148},
	{0.802578, 0.126133},
	{0.832807, 0.130942},
	{0.832807, 0.130942},
	{0.802578, 0.126133},
	{0.791360, 0.098863},
	{0.830004, 0.085330},
	{0.809166, 0.142148},
	{0.781909, 0.129537},
	{0.771940, 0.122903},
	{0.802578, 0.126133},
	{0.802578, 0.126133},
	{0.771940, 0.122903},
	{0.832807, 0.130942},
	{0.889656, 0.134506},
	{0.970570, 0.163959},
	{0.436384, 0.061112},
	{0.401436, 0.061112},
	{0.401709, 0.005758},
	{0.444181, 0.005758},
	{0.365461, 0.005758},
	{0.368524, 0.061112},
	{0.514459, 0.061112},
	{0.516497, 0.005758},
	{0.310293, 0.041072},
	{0.292705, 0.047655},
	{0.240264, 0.066441},
	{0.240920, 0.016025},
	{0.996051, 0.008576},
	{0.996051, 0.043712},
	{0.942167, 0.058501},
	{0.886800, 0.008576},
	{0.856389, 0.088293},
	{0.830643, 0.008576},
	{0.719298, 0.087333},
	{0.636677, 0.146778},
	{0.636268, 0.019863},
	{0.718479, 0.006047},
	{0.938350, 0.226756},
	{0.924465, 0.303435},
	{0.798525, 0.303435},
	{0.856276, 0.226244},
	{0.781834, 0.114187},
	{0.781834, 0.008576},
	{0.805506, 0.008576},
	{0.817993, 0.101628},
	{0.791360, 0.098863},
	{0.778793, 0.004434},
	{0.804092, 0.004434},
	{0.830004, 0.085330},
	{0.754967, 0.111608},
	{0.754967, 0.004434},
	{0.939769, 0.225396},
	{0.924753, 0.303638},
	{0.796965, 0.303229},
	{0.855264, 0.225595},
	{0.718882, 0.087133},
	{0.637386, 0.145931},
	{0.636874, 0.017776},
	{0.716834, 0.006167},
	{0.860613, 0.004434},
	{0.916338, 0.055098},
	{0.970570, 0.004435},
	{0.970570, 0.111608},
	{0.996051, 0.221931},
	{0.886800, 0.221931},
	{0.917806, 0.130410},
	{0.996051, 0.161595},
	{0.862204, 0.182166},
	{0.858947, 0.129597},
	{0.841271, 0.157752},
	{0.815886, 0.138723},
	{0.797332, 0.124416},
	{0.828235, 0.126323},
	{0.930474, 0.093017},
	{0.996051, 0.100296},
	{0.857617, 0.108119},
	{0.789273, 0.119097},
	{0.822909, 0.113482},
	{0.241629, 0.067519},
	{0.242284, 0.016503},
	{0.307658, 0.040137},
	{0.294333, 0.045315},
	{0.956521, 0.501487},
	{0.956521, 0.455618},
	{0.978662, 0.483300},
	{0.978662, 0.501149},
	{0.956521, 0.409018},
	{0.978662, 0.464347},
	{0.956521, 0.366002},
	{0.978662, 0.422006},
	{0.978662, 0.464347},
	{0.956521, 0.409018},
	{0.956521, 0.339292},
	{0.978662, 0.339634},
	{0.018956, 0.014253},
	{0.125748, 0.014253},
	{0.069439, 0.068294},
	{0.018955, 0.123821},
	{0.099564, 0.154320},
	{0.018955, 0.180141},
	{0.104228, 0.290028},
	{0.159298, 0.369436},
	{0.032904, 0.370091},
	{0.018797, 0.289700},
	{0.240086, 0.070453},
	{0.309624, 0.083220},
	{0.309215, 0.210209},
	{0.240086, 0.153548},
	{0.125748, 0.229091},
	{0.018955, 0.229091},
	{0.018955, 0.205350},
	{0.113049, 0.192828},
	{0.113049, 0.192828},
	{0.018955, 0.205350},
	{0.133333, 0.101873},
	{0.137931, 0.129778},
	{0.110914, 0.121323},
	{0.242063, 0.016631},
	{0.296046, 0.036292},
	{0.307049, 0.041819},
	{0.241111, 0.067202},
	{0.234698, 0.014253},
	{0.234698, 0.123821},
	{0.183468, 0.106607},
	{0.200923, 0.014253},
	{0.194487, 0.148488},
	{0.165061, 0.150296},
	{0.169801, 0.169482},
	{0.149255, 0.193767},
	{0.141968, 0.204718},
	{0.152207, 0.176719},
	{0.169801, 0.169482},
	{0.152207, 0.176719},
	{0.348661, 0.029101},
	{0.349051, 0.005765},
	{0.377266, 0.005765},
	{0.368494, 0.029101},
	{0.128734, 0.088217},
	{0.164839, 0.014253},
	{0.133623, 0.152228},
	{0.152207, 0.176719},
	{0.141968, 0.204718},
	{0.134182, 0.216417},
	{0.133411, 0.184451},
	{0.125748, 0.229091},
	{0.113049, 0.192828},
	{0.133411, 0.184451},
	{0.389553, 0.029101},
	{0.368494, 0.029101},
	{0.377266, 0.005765},
	{0.407410, 0.005765},
	{0.436602, 0.029101},
	{0.440066, 0.005765},
	{0.528132, 0.029101},
	{0.436602, 0.029101},
	{0.440066, 0.005765},
	{0.529278, 0.005765},
	{0.363979, 0.011335},
	{0.511567, 0.011335},
	{0.513370, 0.066519},
	{0.361948, 0.066519},
	{0.835857, 0.180592},
	{0.814789, 0.155817},
	{0.809166, 0.142148},
	{0.834452, 0.157729},
	{0.814789, 0.155817},
	{0.790417, 0.135199},
	{0.781909, 0.129537},
	{0.809166, 0.142148},
	{0.860613, 0.220946},
	{0.835857, 0.180592},
	{0.834452, 0.157729},
	{0.873987, 0.181142},
	{0.970570, 0.220946},
	{0.860613, 0.220946},
	{0.873987, 0.181142},
	{0.970570, 0.194705},
	{0.834452, 0.157729},
	{0.802578, 0.126133},
	{0.832807, 0.130942},
	{0.771940, 0.122903},
	{0.873987, 0.181142},
	{0.834452, 0.157729},
	{0.832807, 0.130942},
	{0.889656, 0.134506},
	{0.889656, 0.134506},
	{0.970570, 0.194705},
	{0.873987, 0.181142},
	{0.889656, 0.134506},
	{0.970570, 0.163959},
	{0.970570, 0.163959},
	{0.436384, 0.061112},
	{0.401436, 0.061112},
	{0.401709, 0.005758},
	{0.444181, 0.005758},
	{0.365461, 0.005758},
	{0.401709, 0.005758},
	{0.401436, 0.061112},
	{0.368524, 0.061112},
	{0.514459, 0.061112},
	{0.436384, 0.061112},
	{0.444181, 0.005758},
	{0.516497, 0.005758},
	{0.310293, 0.041072},
	{0.292705, 0.047655},
	{0.240264, 0.066441},
	{0.240920, 0.016025},
	{0.024266, 0.557820},
	{0.024266, 0.576626},
	{0.094122, 0.576626},
	{0.115168, 0.557820},
	{0.024266, 0.405663},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.094122, 0.405663},
	{0.024266, 0.490970},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.107390, 0.490970},
	{0.024266, 0.524061},
	{0.024266, 0.557820},
	{0.115168, 0.557820},
	{0.109678, 0.524061},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.024266, 0.490970},
	{0.107390, 0.490970},
	{0.121071, 0.457423},
	{0.121071, 0.516173},
	{0.133581, 0.526091},
	{0.133581, 0.447173},
	{0.134639, 0.520713},
	{0.134639, 0.464222},
	{0.122457, 0.452924},
	{0.122457, 0.530390},
	{0.163710, 0.306233},
	{0.142519, 0.309831},
	{0.146695, 0.326259},
	{0.181889, 0.323868},
	{0.225838, 0.170445},
	{0.233401, 0.189540},
	{0.256635, 0.197020},
	{0.242513, 0.164051},
	{0.225838, 0.170445},
	{0.242513, 0.164051},
	{0.256635, 0.197020},
	{0.233401, 0.189540},
	{0.163710, 0.306233},
	{0.181889, 0.323868},
	{0.146695, 0.326259},
	{0.142519, 0.309831},
	{0.132079, 0.519433},
	{0.119897, 0.529110},
	{0.119897, 0.451644},
	{0.132079, 0.462942},
	{0.121071, 0.457423},
	{0.133581, 0.447173},
	{0.133581, 0.526091},
	{0.121071, 0.516173},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.107390, 0.490970},
	{0.024266, 0.490970},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.115168, 0.557820},
	{0.024266, 0.557820},
	{0.109678, 0.524061},
	{0.024266, 0.524061},
	{0.024266, 0.405663},
	{0.094122, 0.405663},
	{0.024266, 0.557820},
	{0.115168, 0.557820},
	{0.094122, 0.576626},
	{0.024266, 0.576626},
	{0.241046, 0.067643},
	{0.304934, 0.042696},
	{0.308794, 0.040153},
	{0.241046, 0.015818},
	{0.899346, 0.189338},
	{0.929736, 0.158948},
	{0.915018, 0.144230},
	{0.884628, 0.174620},
	{0.884628, 0.174620},
	{0.915018, 0.144230},
	{0.890640, 0.119852},
	{0.860250, 0.150242},
	{0.835872, 0.125864},
	{0.860250, 0.150242},
	{0.890640, 0.119852},
	{0.866262, 0.095474},
	{0.835872, 0.125864},
	{0.866262, 0.095474},
	{0.841640, 0.070852},
	{0.811250, 0.101242},
	{0.786131, 0.076123},
	{0.811250, 0.101242},
	{0.841640, 0.070852},
	{0.816521, 0.045733},
	{0.772138, 0.062130},
	{0.786131, 0.076123},
	{0.816521, 0.045733},
	{0.802529, 0.031740},
	{0.240391, 0.016190},
	{0.240391, 0.065669},
	{0.284044, 0.050344},
	{0.309034, 0.040446},
	{0.024266, 0.557820},
	{0.024266, 0.576626},
	{0.094122, 0.576626},
	{0.115168, 0.557820},
	{0.024266, 0.405663},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.094122, 0.405663},
	{0.024266, 0.490970},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.107390, 0.490970},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.024266, 0.458207},
	{0.024266, 0.490970},
	{0.107390, 0.490970},
	{0.109678, 0.458207},
	{0.121071, 0.457423},
	{0.121071, 0.516173},
	{0.133581, 0.526091},
	{0.133581, 0.447173},
	{0.134639, 0.520713},
	{0.134639, 0.464222},
	{0.122457, 0.452924},
	{0.122457, 0.530390},
	{0.163710, 0.306233},
	{0.142519, 0.309831},
	{0.146695, 0.326259},
	{0.181889, 0.323868},
	{0.225838, 0.170445},
	{0.233401, 0.189540},
	{0.256635, 0.197020},
	{0.242513, 0.164051},
	{0.225838, 0.170445},
	{0.242513, 0.164051},
	{0.256635, 0.197020},
	{0.233401, 0.189540},
	{0.163710, 0.306233},
	{0.181889, 0.323868},
	{0.146695, 0.326259},
	{0.142519, 0.309831},
	{0.132079, 0.519433},
	{0.119897, 0.529110},
	{0.119897, 0.451644},
	{0.132079, 0.462942},
	{0.121071, 0.457423},
	{0.133581, 0.447173},
	{0.133581, 0.526091},
	{0.121071, 0.516173},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.107390, 0.490970},
	{0.024266, 0.490970},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.115168, 0.557820},
	{0.024266, 0.557820},
	{0.024266, 0.405663},
	{0.094122, 0.405663},
	{0.115168, 0.425443},
	{0.024266, 0.425443},
	{0.024266, 0.557820},
	{0.115168, 0.557820},
	{0.094122, 0.576626},
	{0.024266, 0.576626},
	{0.241046, 0.067643},
	{0.304934, 0.042696},
	{0.308794, 0.040153},
	{0.241046, 0.015818},
	{0.899346, 0.189338},
	{0.929736, 0.158948},
	{0.915018, 0.144230},
	{0.884628, 0.174620},
	{0.884628, 0.174620},
	{0.915018, 0.144230},
	{0.890640, 0.119852},
	{0.860250, 0.150242},
	{0.835872, 0.125864},
	{0.860250, 0.150242},
	{0.890640, 0.119852},
	{0.866262, 0.095474},
	{0.841640, 0.070852},
	{0.811250, 0.101242},
	{0.786131, 0.076123},
	{0.816521, 0.045733},
	{0.772138, 0.062130},
	{0.786131, 0.076123},
	{0.816521, 0.045733},
	{0.802529, 0.031740},
	{0.240391, 0.016190},
	{0.240391, 0.065669},
	{0.284044, 0.050344},
	{0.309034, 0.040446},
	{0.024266, 0.557820},
	{0.024266, 0.576626},
	{0.094122, 0.576626},
	{0.115168, 0.557820},
	{0.024266, 0.405663},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.094122, 0.405663},
	{0.024266, 0.490970},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.107390, 0.490970},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.121071, 0.457423},
	{0.121071, 0.516173},
	{0.133581, 0.526091},
	{0.133581, 0.447173},
	{0.134639, 0.520713},
	{0.134639, 0.464222},
	{0.122457, 0.452924},
	{0.122457, 0.530390},
	{0.163710, 0.306233},
	{0.142519, 0.309831},
	{0.146695, 0.326259},
	{0.181889, 0.323868},
	{0.225838, 0.170445},
	{0.233401, 0.189540},
	{0.256635, 0.197020},
	{0.242513, 0.164051},
	{0.225838, 0.170445},
	{0.242513, 0.164051},
	{0.256635, 0.197020},
	{0.233401, 0.189540},
	{0.163710, 0.306233},
	{0.181889, 0.323868},
	{0.146695, 0.326259},
	{0.142519, 0.309831},
	{0.132079, 0.519433},
	{0.119897, 0.529110},
	{0.119897, 0.451644},
	{0.132079, 0.462942},
	{0.121071, 0.457423},
	{0.133581, 0.447173},
	{0.133581, 0.526091},
	{0.121071, 0.516173},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.107390, 0.490970},
	{0.024266, 0.490970},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.115168, 0.557820},
	{0.024266, 0.557820},
	{0.024266, 0.405663},
	{0.094122, 0.405663},
	{0.094122, 0.576626},
	{0.024266, 0.576626},
	{0.241046, 0.067643},
	{0.304934, 0.042696},
	{0.308794, 0.040153},
	{0.241046, 0.015818},
	{0.899346, 0.189338},
	{0.929736, 0.158948},
	{0.915018, 0.144230},
	{0.884628, 0.174620},
	{0.890640, 0.119852},
	{0.860250, 0.150242},
	{0.835872, 0.125864},
	{0.866262, 0.095474},
	{0.841640, 0.070852},
	{0.811250, 0.101242},
	{0.786131, 0.076123},
	{0.816521, 0.045733},
	{0.772138, 0.062130},
	{0.802529, 0.031740},
	{0.240391, 0.016190},
	{0.240391, 0.065669},
	{0.284044, 0.050344},
	{0.309034, 0.040446},
	{0.024266, 0.557820},
	{0.024266, 0.576626},
	{0.094122, 0.576626},
	{0.115168, 0.557820},
	{0.024266, 0.405663},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.094122, 0.405663},
	{0.024266, 0.490970},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.107390, 0.490970},
	{0.024266, 0.425443},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.115168, 0.425443},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.121071, 0.457423},
	{0.121071, 0.516173},
	{0.133581, 0.526091},
	{0.133581, 0.447173},
	{0.134639, 0.520713},
	{0.134639, 0.464222},
	{0.122457, 0.452924},
	{0.122457, 0.530390},
	{0.163710, 0.306233},
	{0.142519, 0.309831},
	{0.146695, 0.326259},
	{0.181889, 0.323868},
	{0.225838, 0.170445},
	{0.233401, 0.189540},
	{0.256635, 0.197020},
	{0.242513, 0.164051},
	{0.225838, 0.170445},
	{0.242513, 0.164051},
	{0.256635, 0.197020},
	{0.233401, 0.189540},
	{0.163710, 0.306233},
	{0.181889, 0.323868},
	{0.146695, 0.326259},
	{0.142519, 0.309831},
	{0.132079, 0.519433},
	{0.119897, 0.529110},
	{0.119897, 0.451644},
	{0.132079, 0.462942},
	{0.121071, 0.457423},
	{0.133581, 0.447173},
	{0.133581, 0.526091},
	{0.121071, 0.516173},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.107390, 0.490970},
	{0.024266, 0.490970},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.115168, 0.557820},
	{0.024266, 0.557820},
	{0.024266, 0.405663},
	{0.094122, 0.405663},
	{0.094122, 0.576626},
	{0.024266, 0.576626},
	{0.241046, 0.067643},
	{0.304934, 0.042696},
	{0.308794, 0.040153},
	{0.241046, 0.015818},
	{0.899346, 0.189338},
	{0.929736, 0.158948},
	{0.915018, 0.144230},
	{0.884628, 0.174620},
	{0.884628, 0.174620},
	{0.915018, 0.144230},
	{0.890640, 0.119852},
	{0.860250, 0.150242},
	{0.835872, 0.125864},
	{0.860250, 0.150242},
	{0.890640, 0.119852},
	{0.866262, 0.095474},
	{0.835872, 0.125864},
	{0.866262, 0.095474},
	{0.841640, 0.070852},
	{0.811250, 0.101242},
	{0.786131, 0.076123},
	{0.811250, 0.101242},
	{0.841640, 0.070852},
	{0.816521, 0.045733},
	{0.772138, 0.062130},
	{0.802529, 0.031740},
	{0.240391, 0.016190},
	{0.240391, 0.065669},
	{0.284044, 0.050344},
	{0.309034, 0.040446},
	{0.024266, 0.557820},
	{0.024266, 0.576626},
	{0.094122, 0.576626},
	{0.115168, 0.557820},
	{0.024266, 0.405663},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.094122, 0.405663},
	{0.024266, 0.490970},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.107390, 0.490970},
	{0.024266, 0.524061},
	{0.024266, 0.557820},
	{0.115168, 0.557820},
	{0.109678, 0.524061},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.024266, 0.490970},
	{0.107390, 0.490970},
	{0.121071, 0.457423},
	{0.121071, 0.516173},
	{0.133581, 0.526091},
	{0.133581, 0.447173},
	{0.134639, 0.520713},
	{0.134639, 0.464222},
	{0.122457, 0.452924},
	{0.122457, 0.530390},
	{0.163710, 0.306233},
	{0.142519, 0.309831},
	{0.146695, 0.326259},
	{0.181889, 0.323868},
	{0.225838, 0.170445},
	{0.233401, 0.189540},
	{0.256635, 0.197020},
	{0.242513, 0.164051},
	{0.225838, 0.170445},
	{0.242513, 0.164051},
	{0.256635, 0.197020},
	{0.233401, 0.189540},
	{0.163710, 0.306233},
	{0.181889, 0.323868},
	{0.146695, 0.326259},
	{0.142519, 0.309831},
	{0.132079, 0.519433},
	{0.119897, 0.529110},
	{0.119897, 0.451644},
	{0.132079, 0.462942},
	{0.121071, 0.457423},
	{0.133581, 0.447173},
	{0.133581, 0.526091},
	{0.121071, 0.516173},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.107390, 0.490970},
	{0.024266, 0.490970},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.115168, 0.557820},
	{0.024266, 0.557820},
	{0.024266, 0.405663},
	{0.094122, 0.405663},
	{0.024266, 0.557820},
	{0.115168, 0.557820},
	{0.094122, 0.576626},
	{0.024266, 0.576626},
	{0.241046, 0.067643},
	{0.304934, 0.042696},
	{0.308794, 0.040153},
	{0.241046, 0.015818},
	{0.899346, 0.189338},
	{0.929736, 0.158948},
	{0.915018, 0.144230},
	{0.884628, 0.174620},
	{0.884628, 0.174620},
	{0.915018, 0.144230},
	{0.890640, 0.119852},
	{0.860250, 0.150242},
	{0.835872, 0.125864},
	{0.860250, 0.150242},
	{0.890640, 0.119852},
	{0.866262, 0.095474},
	{0.841640, 0.070852},
	{0.811250, 0.101242},
	{0.786131, 0.076123},
	{0.816521, 0.045733},
	{0.772138, 0.062130},
	{0.786131, 0.076123},
	{0.816521, 0.045733},
	{0.802529, 0.031740},
	{0.240391, 0.016190},
	{0.240391, 0.065669},
	{0.284044, 0.050344},
	{0.309034, 0.040446},
	{0.024266, 0.557820},
	{0.024266, 0.576626},
	{0.094122, 0.576626},
	{0.115168, 0.557820},
	{0.024266, 0.405663},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.094122, 0.405663},
	{0.024266, 0.490970},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.107390, 0.490970},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.121071, 0.457423},
	{0.121071, 0.516173},
	{0.133581, 0.526091},
	{0.133581, 0.447173},
	{0.134639, 0.520713},
	{0.134639, 0.464222},
	{0.122457, 0.452924},
	{0.122457, 0.530390},
	{0.163710, 0.306233},
	{0.142519, 0.309831},
	{0.146695, 0.326259},
	{0.181889, 0.323868},
	{0.225838, 0.170445},
	{0.233401, 0.189540},
	{0.256635, 0.197020},
	{0.242513, 0.164051},
	{0.225838, 0.170445},
	{0.242513, 0.164051},
	{0.256635, 0.197020},
	{0.233401, 0.189540},
	{0.163710, 0.306233},
	{0.181889, 0.323868},
	{0.146695, 0.326259},
	{0.142519, 0.309831},
	{0.132079, 0.519433},
	{0.119897, 0.529110},
	{0.119897, 0.451644},
	{0.132079, 0.462942},
	{0.121071, 0.457423},
	{0.133581, 0.447173},
	{0.133581, 0.526091},
	{0.121071, 0.516173},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.107390, 0.490970},
	{0.024266, 0.490970},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.109678, 0.458207},
	{0.024266, 0.458207},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.115168, 0.557820},
	{0.024266, 0.557820},
	{0.024266, 0.490970},
	{0.107390, 0.490970},
	{0.109678, 0.524061},
	{0.024266, 0.524061},
	{0.024266, 0.405663},
	{0.094122, 0.405663},
	{0.115168, 0.425443},
	{0.024266, 0.425443},
	{0.094122, 0.576626},
	{0.024266, 0.576626},
	{0.241046, 0.067643},
	{0.304934, 0.042696},
	{0.308794, 0.040153},
	{0.241046, 0.015818},
	{0.899346, 0.189338},
	{0.929736, 0.158948},
	{0.915018, 0.144230},
	{0.884628, 0.174620},
	{0.884628, 0.174620},
	{0.915018, 0.144230},
	{0.890640, 0.119852},
	{0.860250, 0.150242},
	{0.835872, 0.125864},
	{0.866262, 0.095474},
	{0.841640, 0.070852},
	{0.811250, 0.101242},
	{0.786131, 0.076123},
	{0.811250, 0.101242},
	{0.841640, 0.070852},
	{0.816521, 0.045733},
	{0.772138, 0.062130},
	{0.786131, 0.076123},
	{0.816521, 0.045733},
	{0.802529, 0.031740},
	{0.240391, 0.016190},
	{0.240391, 0.065669},
	{0.284044, 0.050344},
	{0.309034, 0.040446},
	{0.024266, 0.557820},
	{0.024266, 0.576626},
	{0.094122, 0.576626},
	{0.115168, 0.557820},
	{0.024266, 0.405663},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.094122, 0.405663},
	{0.024266, 0.490970},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.107390, 0.490970},
	{0.024266, 0.425443},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.115168, 0.425443},
	{0.024266, 0.490970},
	{0.107390, 0.490970},
	{0.121071, 0.457423},
	{0.121071, 0.516173},
	{0.133581, 0.526091},
	{0.133581, 0.447173},
	{0.134639, 0.520713},
	{0.134639, 0.464222},
	{0.122457, 0.452924},
	{0.122457, 0.530390},
	{0.163710, 0.306233},
	{0.142519, 0.309831},
	{0.146695, 0.326259},
	{0.181889, 0.323868},
	{0.225838, 0.170445},
	{0.233401, 0.189540},
	{0.256635, 0.197020},
	{0.242513, 0.164051},
	{0.225838, 0.170445},
	{0.242513, 0.164051},
	{0.256635, 0.197020},
	{0.233401, 0.189540},
	{0.163710, 0.306233},
	{0.181889, 0.323868},
	{0.146695, 0.326259},
	{0.142519, 0.309831},
	{0.132079, 0.519433},
	{0.119897, 0.529110},
	{0.119897, 0.451644},
	{0.132079, 0.462942},
	{0.121071, 0.457423},
	{0.133581, 0.447173},
	{0.133581, 0.526091},
	{0.121071, 0.516173},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.107390, 0.490970},
	{0.024266, 0.490970},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.115168, 0.557820},
	{0.024266, 0.557820},
	{0.024266, 0.490970},
	{0.107390, 0.490970},
	{0.109678, 0.524061},
	{0.024266, 0.524061},
	{0.024266, 0.405663},
	{0.094122, 0.405663},
	{0.094122, 0.576626},
	{0.024266, 0.576626},
	{0.241046, 0.067643},
	{0.304934, 0.042696},
	{0.308794, 0.040153},
	{0.241046, 0.015818},
	{0.899346, 0.189338},
	{0.929736, 0.158948},
	{0.915018, 0.144230},
	{0.884628, 0.174620},
	{0.884628, 0.174620},
	{0.915018, 0.144230},
	{0.890640, 0.119852},
	{0.860250, 0.150242},
	{0.835872, 0.125864},
	{0.860250, 0.150242},
	{0.890640, 0.119852},
	{0.866262, 0.095474},
	{0.835872, 0.125864},
	{0.866262, 0.095474},
	{0.841640, 0.070852},
	{0.811250, 0.101242},
	{0.786131, 0.076123},
	{0.816521, 0.045733},
	{0.772138, 0.062130},
	{0.802529, 0.031740},
	{0.240391, 0.016190},
	{0.240391, 0.065669},
	{0.284044, 0.050344},
	{0.309034, 0.040446},
	{0.024266, 0.557820},
	{0.024266, 0.576626},
	{0.094122, 0.576626},
	{0.115168, 0.557820},
	{0.024266, 0.405663},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.094122, 0.405663},
	{0.024266, 0.490970},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.107390, 0.490970},
	{0.024266, 0.425443},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.115168, 0.425443},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.121071, 0.457423},
	{0.121071, 0.516173},
	{0.133581, 0.526091},
	{0.133581, 0.447173},
	{0.134639, 0.520713},
	{0.134639, 0.464222},
	{0.122457, 0.452924},
	{0.122457, 0.530390},
	{0.163710, 0.306233},
	{0.142519, 0.309831},
	{0.146695, 0.326259},
	{0.181889, 0.323868},
	{0.225838, 0.170445},
	{0.233401, 0.189540},
	{0.256635, 0.197020},
	{0.242513, 0.164051},
	{0.225838, 0.170445},
	{0.242513, 0.164051},
	{0.256635, 0.197020},
	{0.233401, 0.189540},
	{0.163710, 0.306233},
	{0.181889, 0.323868},
	{0.146695, 0.326259},
	{0.142519, 0.309831},
	{0.132079, 0.519433},
	{0.119897, 0.529110},
	{0.119897, 0.451644},
	{0.132079, 0.462942},
	{0.121071, 0.457423},
	{0.133581, 0.447173},
	{0.133581, 0.526091},
	{0.121071, 0.516173},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.107390, 0.490970},
	{0.024266, 0.490970},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.109678, 0.458207},
	{0.024266, 0.458207},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.115168, 0.557820},
	{0.024266, 0.557820},
	{0.109678, 0.524061},
	{0.024266, 0.524061},
	{0.024266, 0.405663},
	{0.094122, 0.405663},
	{0.115168, 0.425443},
	{0.024266, 0.425443},
	{0.094122, 0.576626},
	{0.024266, 0.576626},
	{0.241046, 0.067643},
	{0.304934, 0.042696},
	{0.308794, 0.040153},
	{0.241046, 0.015818},
	{0.899346, 0.189338},
	{0.929736, 0.158948},
	{0.915018, 0.144230},
	{0.884628, 0.174620},
	{0.884628, 0.174620},
	{0.915018, 0.144230},
	{0.890640, 0.119852},
	{0.860250, 0.150242},
	{0.835872, 0.125864},
	{0.860250, 0.150242},
	{0.890640, 0.119852},
	{0.866262, 0.095474},
	{0.835872, 0.125864},
	{0.866262, 0.095474},
	{0.841640, 0.070852},
	{0.811250, 0.101242},
	{0.786131, 0.076123},
	{0.816521, 0.045733},
	{0.772138, 0.062130},
	{0.802529, 0.031740},
	{0.240391, 0.016190},
	{0.240391, 0.065669},
	{0.284044, 0.050344},
	{0.309034, 0.040446},
	{0.024266, 0.557820},
	{0.024266, 0.576626},
	{0.094122, 0.576626},
	{0.115168, 0.557820},
	{0.024266, 0.405663},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.094122, 0.405663},
	{0.024266, 0.490970},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.107390, 0.490970},
	{0.024266, 0.524061},
	{0.024266, 0.557820},
	{0.115168, 0.557820},
	{0.109678, 0.524061},
	{0.024266, 0.425443},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.115168, 0.425443},
	{0.024266, 0.458207},
	{0.024266, 0.490970},
	{0.107390, 0.490970},
	{0.109678, 0.458207},
	{0.121071, 0.457423},
	{0.121071, 0.516173},
	{0.133581, 0.526091},
	{0.133581, 0.447173},
	{0.134639, 0.520713},
	{0.134639, 0.464222},
	{0.122457, 0.452924},
	{0.122457, 0.530390},
	{0.163710, 0.306233},
	{0.142519, 0.309831},
	{0.146695, 0.326259},
	{0.181889, 0.323868},
	{0.225838, 0.170445},
	{0.233401, 0.189540},
	{0.256635, 0.197020},
	{0.242513, 0.164051},
	{0.225838, 0.170445},
	{0.242513, 0.164051},
	{0.256635, 0.197020},
	{0.233401, 0.189540},
	{0.163710, 0.306233},
	{0.181889, 0.323868},
	{0.146695, 0.326259},
	{0.142519, 0.309831},
	{0.132079, 0.519433},
	{0.119897, 0.529110},
	{0.119897, 0.451644},
	{0.132079, 0.462942},
	{0.121071, 0.457423},
	{0.133581, 0.447173},
	{0.133581, 0.526091},
	{0.121071, 0.516173},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.107390, 0.490970},
	{0.024266, 0.490970},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.115168, 0.557820},
	{0.024266, 0.557820},
	{0.024266, 0.405663},
	{0.094122, 0.405663},
	{0.094122, 0.576626},
	{0.024266, 0.576626},
	{0.241046, 0.067643},
	{0.304934, 0.042696},
	{0.308794, 0.040153},
	{0.241046, 0.015818},
	{0.899346, 0.189338},
	{0.929736, 0.158948},
	{0.915018, 0.144230},
	{0.884628, 0.174620},
	{0.884628, 0.174620},
	{0.915018, 0.144230},
	{0.890640, 0.119852},
	{0.860250, 0.150242},
	{0.835872, 0.125864},
	{0.860250, 0.150242},
	{0.890640, 0.119852},
	{0.866262, 0.095474},
	{0.835872, 0.125864},
	{0.866262, 0.095474},
	{0.841640, 0.070852},
	{0.811250, 0.101242},
	{0.786131, 0.076123},
	{0.811250, 0.101242},
	{0.841640, 0.070852},
	{0.816521, 0.045733},
	{0.772138, 0.062130},
	{0.786131, 0.076123},
	{0.816521, 0.045733},
	{0.802529, 0.031740},
	{0.240391, 0.016190},
	{0.240391, 0.065669},
	{0.284044, 0.050344},
	{0.309034, 0.040446},
	{0.024266, 0.557820},
	{0.024266, 0.576626},
	{0.094122, 0.576626},
	{0.115168, 0.557820},
	{0.024266, 0.405663},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.094122, 0.405663},
	{0.024266, 0.490970},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.107390, 0.490970},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.024266, 0.425443},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.115168, 0.425443},
	{0.024266, 0.458207},
	{0.024266, 0.490970},
	{0.107390, 0.490970},
	{0.109678, 0.458207},
	{0.121071, 0.457423},
	{0.121071, 0.516173},
	{0.133581, 0.526091},
	{0.133581, 0.447173},
	{0.134639, 0.520713},
	{0.134639, 0.464222},
	{0.122457, 0.452924},
	{0.122457, 0.530390},
	{0.163710, 0.306233},
	{0.142519, 0.309831},
	{0.146695, 0.326259},
	{0.181889, 0.323868},
	{0.225838, 0.170445},
	{0.233401, 0.189540},
	{0.256635, 0.197020},
	{0.242513, 0.164051},
	{0.225838, 0.170445},
	{0.242513, 0.164051},
	{0.256635, 0.197020},
	{0.233401, 0.189540},
	{0.163710, 0.306233},
	{0.181889, 0.323868},
	{0.146695, 0.326259},
	{0.142519, 0.309831},
	{0.132079, 0.519433},
	{0.119897, 0.529110},
	{0.119897, 0.451644},
	{0.132079, 0.462942},
	{0.121071, 0.457423},
	{0.133581, 0.447173},
	{0.133581, 0.526091},
	{0.121071, 0.516173},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.107390, 0.490970},
	{0.024266, 0.490970},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.109678, 0.458207},
	{0.024266, 0.458207},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.115168, 0.557820},
	{0.024266, 0.557820},
	{0.024266, 0.490970},
	{0.107390, 0.490970},
	{0.024266, 0.405663},
	{0.094122, 0.405663},
	{0.115168, 0.425443},
	{0.024266, 0.425443},
	{0.024266, 0.557820},
	{0.115168, 0.557820},
	{0.094122, 0.576626},
	{0.024266, 0.576626},
	{0.241046, 0.067643},
	{0.304934, 0.042696},
	{0.308794, 0.040153},
	{0.241046, 0.015818},
	{0.899346, 0.189338},
	{0.929736, 0.158948},
	{0.915018, 0.144230},
	{0.884628, 0.174620},
	{0.884628, 0.174620},
	{0.915018, 0.144230},
	{0.890640, 0.119852},
	{0.860250, 0.150242},
	{0.835872, 0.125864},
	{0.860250, 0.150242},
	{0.890640, 0.119852},
	{0.866262, 0.095474},
	{0.841640, 0.070852},
	{0.811250, 0.101242},
	{0.786131, 0.076123},
	{0.816521, 0.045733},
	{0.772138, 0.062130},
	{0.802529, 0.031740},
	{0.240391, 0.016190},
	{0.240391, 0.065669},
	{0.284044, 0.050344},
	{0.309034, 0.040446},
	{0.024266, 0.557820},
	{0.024266, 0.576626},
	{0.094122, 0.576626},
	{0.115168, 0.557820},
	{0.024266, 0.405663},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.094122, 0.405663},
	{0.024266, 0.490970},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.107390, 0.490970},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.121071, 0.457423},
	{0.121071, 0.516173},
	{0.133581, 0.526091},
	{0.133581, 0.447173},
	{0.134639, 0.520713},
	{0.134639, 0.464222},
	{0.122457, 0.452924},
	{0.122457, 0.530390},
	{0.163710, 0.306233},
	{0.142519, 0.309831},
	{0.146695, 0.326259},
	{0.181889, 0.323868},
	{0.225838, 0.170445},
	{0.233401, 0.189540},
	{0.256635, 0.197020},
	{0.242513, 0.164051},
	{0.225838, 0.170445},
	{0.242513, 0.164051},
	{0.256635, 0.197020},
	{0.233401, 0.189540},
	{0.163710, 0.306233},
	{0.181889, 0.323868},
	{0.146695, 0.326259},
	{0.142519, 0.309831},
	{0.132079, 0.519433},
	{0.119897, 0.529110},
	{0.119897, 0.451644},
	{0.132079, 0.462942},
	{0.121071, 0.457423},
	{0.133581, 0.447173},
	{0.133581, 0.526091},
	{0.121071, 0.516173},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.107390, 0.490970},
	{0.024266, 0.490970},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.115168, 0.557820},
	{0.024266, 0.557820},
	{0.024266, 0.405663},
	{0.094122, 0.405663},
	{0.094122, 0.576626},
	{0.024266, 0.576626},
	{0.241046, 0.067643},
	{0.304934, 0.042696},
	{0.308794, 0.040153},
	{0.241046, 0.015818},
	{0.899346, 0.189338},
	{0.929736, 0.158948},
	{0.915018, 0.144230},
	{0.884628, 0.174620},
	{0.884628, 0.174620},
	{0.915018, 0.144230},
	{0.890640, 0.119852},
	{0.860250, 0.150242},
	{0.835872, 0.125864},
	{0.866262, 0.095474},
	{0.841640, 0.070852},
	{0.811250, 0.101242},
	{0.786131, 0.076123},
	{0.816521, 0.045733},
	{0.772138, 0.062130},
	{0.802529, 0.031740},
	{0.240391, 0.016190},
	{0.240391, 0.065669},
	{0.284044, 0.050344},
	{0.309034, 0.040446},
	{0.024266, 0.557820},
	{0.024266, 0.576626},
	{0.094122, 0.576626},
	{0.115168, 0.557820},
	{0.024266, 0.405663},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.094122, 0.405663},
	{0.024266, 0.490970},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.107390, 0.490970},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.121071, 0.457423},
	{0.121071, 0.516173},
	{0.133581, 0.526091},
	{0.133581, 0.447173},
	{0.134639, 0.520713},
	{0.134639, 0.464222},
	{0.122457, 0.452924},
	{0.122457, 0.530390},
	{0.163710, 0.306233},
	{0.142519, 0.309831},
	{0.146695, 0.326259},
	{0.181889, 0.323868},
	{0.225838, 0.170445},
	{0.233401, 0.189540},
	{0.256635, 0.197020},
	{0.242513, 0.164051},
	{0.225838, 0.170445},
	{0.242513, 0.164051},
	{0.256635, 0.197020},
	{0.233401, 0.189540},
	{0.163710, 0.306233},
	{0.181889, 0.323868},
	{0.146695, 0.326259},
	{0.142519, 0.309831},
	{0.132079, 0.519433},
	{0.119897, 0.529110},
	{0.119897, 0.451644},
	{0.132079, 0.462942},
	{0.121071, 0.457423},
	{0.133581, 0.447173},
	{0.133581, 0.526091},
	{0.121071, 0.516173},
	{0.024266, 0.458207},
	{0.109678, 0.458207},
	{0.107390, 0.490970},
	{0.024266, 0.490970},
	{0.024266, 0.425443},
	{0.115168, 0.425443},
	{0.024266, 0.524061},
	{0.109678, 0.524061},
	{0.115168, 0.557820},
	{0.024266, 0.557820},
	{0.024266, 0.405663},
	{0.094122, 0.405663},
	{0.115168, 0.425443},
	{0.024266, 0.425443},
	{0.094122, 0.576626},
	{0.024266, 0.576626},
	{0.241046, 0.067643},
	{0.304934, 0.042696},
	{0.308794, 0.040153},
	{0.241046, 0.015818},
	{0.899346, 0.189338},
	{0.929736, 0.158948},
	{0.915018, 0.144230},
	{0.884628, 0.174620},
	{0.884628, 0.174620},
	{0.915018, 0.144230},
	{0.890640, 0.119852},
	{0.860250, 0.150242},
	{0.835872, 0.125864},
	{0.860250, 0.150242},
	{0.890640, 0.119852},
	{0.866262, 0.095474},
	{0.841640, 0.070852},
	{0.811250, 0.101242},
	{0.786131, 0.076123},
	{0.811250, 0.101242},
	{0.841640, 0.070852},
	{0.816521, 0.045733},
	{0.772138, 0.062130},
	{0.786131, 0.076123},
	{0.816521, 0.045733},
	{0.802529, 0.031740},
	{0.240391, 0.016190},
	{0.240391, 0.065669},
	{0.284044, 0.050344},
	{0.309034, 0.040446},
	{0.753201, 0.213987},
	{0.246799, 0.213987},
	{0.246799, 0.720388},
	{0.753201, 0.720388},
	{0.755338, 0.213412},
	{0.244662, 0.213412},
	{0.244662, 0.724088},
	{0.755338, 0.724088},
	{0.750465, 0.718262},
	{0.750465, 0.217145},
	{0.249348, 0.217144},
	{0.249348, 0.718262},
	{0.751651, 0.720401},
	{0.751651, 0.217099},
	{0.248349, 0.217099},
	{0.248349, 0.720401},
	{0.250893, 0.216518},
	{0.250893, 0.714732},
	{0.749107, 0.714732},
	{0.749107, 0.216518},
	{0.740441, 0.718441},
	{0.740441, 0.221560},
	{0.243560, 0.221560},
	{0.243559, 0.718441},
	{0.159977, 0.969448},
	{0.159976, 0.986021},
	{0.100174, 0.986021},
	{0.100175, 0.969448},
	{0.055738, 0.986021},
	{0.055738, 0.969448},
	{0.028374, 0.986021},
	{0.028374, 0.969448},
	{0.019134, 0.986021},
	{0.019134, 0.969448},
	{0.028374, 0.986021},
	{0.028374, 0.969448},
	{0.055738, 0.986021},
	{0.055738, 0.969448},
	{0.100175, 0.986021},
	{0.100175, 0.969448},
	{0.159977, 0.986021},
	{0.159977, 0.969448},
	{0.232845, 0.986021},
	{0.232845, 0.969448},
	{0.315981, 0.986021},
	{0.315981, 0.969448},
	{0.406188, 0.986021},
	{0.406188, 0.969448},
	{0.500000, 0.986021},
	{0.500000, 0.969448},
	{0.593812, 0.986021},
	{0.593812, 0.969448},
	{0.684018, 0.986021},
	{0.684019, 0.969448},
	{0.767154, 0.986021},
	{0.767155, 0.969448},
	{0.840022, 0.986021},
	{0.840024, 0.969448},
	{0.899824, 0.986021},
	{0.899825, 0.969448},
	{0.944261, 0.986021},
	{0.944262, 0.969448},
	{0.971626, 0.986021},
	{0.971626, 0.969448},
	{0.980866, 0.986021},
	{0.980866, 0.969448},
	{0.971626, 0.986021},
	{0.971626, 0.969448},
	{0.944263, 0.986021},
	{0.944262, 0.969448},
	{0.899827, 0.986021},
	{0.899825, 0.969448},
	{0.840025, 0.986021},
	{0.840023, 0.969448},
	{0.767157, 0.986021},
	{0.767154, 0.969448},
	{0.684022, 0.986021},
	{0.684019, 0.969448},
	{0.593816, 0.986021},
	{0.593811, 0.969448},
	{0.500004, 0.986021},
	{0.499999, 0.969448},
	{0.406191, 0.986021},
	{0.406187, 0.969448},
	{0.315984, 0.986021},
	{0.315980, 0.969448},
	{0.232849, 0.986021},
	{0.232845, 0.969448},
	{0.240254, 0.990826},
	{0.169401, 0.990826},
	{0.321085, 0.990826},
	{0.408792, 0.990826},
	{0.500004, 0.990826},
	{0.591215, 0.990826},
	{0.678922, 0.990826},
	{0.759752, 0.990826},
	{0.830601, 0.990826},
	{0.888744, 0.990826},
	{0.931949, 0.990826},
	{0.958554, 0.990826},
	{0.967537, 0.990826},
	{0.958553, 0.990826},
	{0.931947, 0.990826},
	{0.888742, 0.990826},
	{0.830598, 0.990826},
	{0.759749, 0.990826},
	{0.678918, 0.990826},
	{0.591211, 0.990826},
	{0.500000, 0.990826},
	{0.408788, 0.990826},
	{0.321081, 0.990826},
	{0.240250, 0.990826},
	{0.169402, 0.990826},
	{0.111257, 0.990826},
	{0.068052, 0.990826},
	{0.041447, 0.990826},
	{0.032463, 0.990826},
	{0.041446, 0.990826},
	{0.068052, 0.990826},
	{0.111257, 0.990826},
	{0.585010, 0.597465},
	{0.608824, 0.577921},
	{0.590504, 0.559602},
	{0.570617, 0.575923},
	{0.557841, 0.611987},
	{0.547927, 0.588051},
	{0.528361, 0.620930},
	{0.523307, 0.595520},
	{0.497703, 0.623949},
	{0.497703, 0.598041},
	{0.467045, 0.620929},
	{0.472099, 0.595519},
	{0.437565, 0.611987},
	{0.447479, 0.588051},
	{0.410396, 0.597465},
	{0.424789, 0.575923},
	{0.386582, 0.577921},
	{0.404902, 0.559602},
	{0.367039, 0.554107},
	{0.388580, 0.539714},
	{0.352517, 0.526938},
	{0.376452, 0.517024},
	{0.343574, 0.497459},
	{0.368984, 0.492404},
	{0.340554, 0.466800},
	{0.366462, 0.466800},
	{0.343574, 0.436142},
	{0.368984, 0.441196},
	{0.352516, 0.406662},
	{0.376452, 0.416576},
	{0.367038, 0.379493},
	{0.388580, 0.393887},
	{0.386582, 0.355679},
	{0.404901, 0.373999},
	{0.410396, 0.336136},
	{0.424789, 0.357677},
	{0.437565, 0.321614},
	{0.447479, 0.345549},
	{0.467044, 0.312671},
	{0.472099, 0.338081},
	{0.497703, 0.309651},
	{0.497703, 0.335559},
	{0.528361, 0.312671},
	{0.523306, 0.338081},
	{0.557841, 0.321613},
	{0.547926, 0.345549},
	{0.585010, 0.336135},
	{0.570616, 0.357677},
	{0.608824, 0.355678},
	{0.590504, 0.373998},
	{0.628367, 0.379492},
	{0.606826, 0.393886},
	{0.642890, 0.406661},
	{0.618954, 0.416575},
	{0.651832, 0.436141},
	{0.626422, 0.441195},
	{0.654852, 0.466799},
	{0.628944, 0.466799},
	{0.651833, 0.497457},
	{0.626423, 0.492403},
	{0.642891, 0.526937},
	{0.618955, 0.517023},
	{0.628369, 0.554106},
	{0.606827, 0.539713},
	{0.497703, 0.466800},
	{0.159977, 0.969448},
	{0.159976, 0.986021},
	{0.100174, 0.986021},
	{0.100175, 0.969448},
	{0.055738, 0.986021},
	{0.055738, 0.969448},
	{0.028374, 0.986021},
	{0.028374, 0.969448},
	{0.019134, 0.986021},
	{0.019134, 0.969448},
	{0.028374, 0.986021},
	{0.028374, 0.969448},
	{0.055738, 0.986021},
	{0.055738, 0.969448},
	{0.100175, 0.986021},
	{0.100175, 0.969448},
	{0.159977, 0.986021},
	{0.159977, 0.969448},
	{0.232845, 0.986021},
	{0.232845, 0.969448},
	{0.315981, 0.986021},
	{0.315981, 0.969448},
	{0.406188, 0.986021},
	{0.406188, 0.969448},
	{0.500000, 0.986021},
	{0.500000, 0.969448},
	{0.593812, 0.986021},
	{0.593812, 0.969448},
	{0.684018, 0.986021},
	{0.684019, 0.969448},
	{0.767154, 0.986021},
	{0.767155, 0.969448},
	{0.840022, 0.986021},
	{0.840024, 0.969448},
	{0.899824, 0.986021},
	{0.899825, 0.969448},
	{0.944261, 0.986021},
	{0.944262, 0.969448},
	{0.971626, 0.986021},
	{0.971626, 0.969448},
	{0.980866, 0.986021},
	{0.980866, 0.969448},
	{0.971626, 0.986021},
	{0.971626, 0.969448},
	{0.944263, 0.986021},
	{0.944262, 0.969448},
	{0.899827, 0.986021},
	{0.899825, 0.969448},
	{0.840025, 0.986021},
	{0.840023, 0.969448},
	{0.767157, 0.986021},
	{0.767154, 0.969448},
	{0.684022, 0.986021},
	{0.684019, 0.969448},
	{0.593816, 0.986021},
	{0.593811, 0.969448},
	{0.500004, 0.986021},
	{0.499999, 0.969448},
	{0.406191, 0.986021},
	{0.406187, 0.969448},
	{0.315984, 0.986021},
	{0.315980, 0.969448},
	{0.232849, 0.986021},
	{0.232845, 0.969448},
	{0.240254, 0.990826},
	{0.169401, 0.990826},
	{0.321085, 0.990826},
	{0.408792, 0.990826},
	{0.500004, 0.990826},
	{0.591215, 0.990826},
	{0.678922, 0.990826},
	{0.759752, 0.990826},
	{0.830601, 0.990826},
	{0.888744, 0.990826},
	{0.931949, 0.990826},
	{0.958554, 0.990826},
	{0.967537, 0.990826},
	{0.958553, 0.990826},
	{0.931947, 0.990826},
	{0.888742, 0.990826},
	{0.830598, 0.990826},
	{0.759749, 0.990826},
	{0.678918, 0.990826},
	{0.591211, 0.990826},
	{0.500000, 0.990826},
	{0.408788, 0.990826},
	{0.321081, 0.990826},
	{0.240250, 0.990826},
	{0.169402, 0.990826},
	{0.111257, 0.990826},
	{0.068052, 0.990826},
	{0.041447, 0.990826},
	{0.032463, 0.990826},
	{0.041446, 0.990826},
	{0.068052, 0.990826},
	{0.111257, 0.990826},
	{0.585010, 0.597465},
	{0.608824, 0.577921},
	{0.590504, 0.559602},
	{0.570617, 0.575923},
	{0.557841, 0.611987},
	{0.547927, 0.588051},
	{0.528361, 0.620930},
	{0.523307, 0.595520},
	{0.497703, 0.623949},
	{0.497703, 0.598041},
	{0.467045, 0.620929},
	{0.472099, 0.595519},
	{0.437565, 0.611987},
	{0.447479, 0.588051},
	{0.410396, 0.597465},
	{0.424789, 0.575923},
	{0.386582, 0.577921},
	{0.404902, 0.559602},
	{0.367039, 0.554107},
	{0.388580, 0.539714},
	{0.352517, 0.526938},
	{0.376452, 0.517024},
	{0.343574, 0.497459},
	{0.368984, 0.492404},
	{0.340554, 0.466800},
	{0.366462, 0.466800},
	{0.343574, 0.436142},
	{0.368984, 0.441196},
	{0.352516, 0.406662},
	{0.376452, 0.416576},
	{0.367038, 0.379493},
	{0.388580, 0.393887},
	{0.386582, 0.355679},
	{0.404901, 0.373999},
	{0.410396, 0.336136},
	{0.424789, 0.357677},
	{0.437565, 0.321614},
	{0.447479, 0.345549},
	{0.467044, 0.312671},
	{0.472099, 0.338081},
	{0.497703, 0.309651},
	{0.497703, 0.335559},
	{0.528361, 0.312671},
	{0.523306, 0.338081},
	{0.557841, 0.321613},
	{0.547926, 0.345549},
	{0.585010, 0.336135},
	{0.570616, 0.357677},
	{0.608824, 0.355678},
	{0.590504, 0.373998},
	{0.628367, 0.379492},
	{0.606826, 0.393886},
	{0.642890, 0.406661},
	{0.618954, 0.416575},
	{0.651832, 0.436141},
	{0.626422, 0.441195},
	{0.654852, 0.466799},
	{0.628944, 0.466799},
	{0.651833, 0.497457},
	{0.626423, 0.492403},
	{0.642891, 0.526937},
	{0.618955, 0.517023},
	{0.628369, 0.554106},
	{0.606827, 0.539713},
	{0.497703, 0.466800},
	{0.159977, 0.969448},
	{0.159976, 0.986021},
	{0.100174, 0.986021},
	{0.100175, 0.969448},
	{0.055738, 0.986021},
	{0.055738, 0.969448},
	{0.028374, 0.986021},
	{0.028374, 0.969448},
	{0.019134, 0.986021},
	{0.019134, 0.969448},
	{0.028374, 0.986021},
	{0.028374, 0.969448},
	{0.055738, 0.986021},
	{0.055738, 0.969448},
	{0.100175, 0.986021},
	{0.100175, 0.969448},
	{0.159977, 0.986021},
	{0.159977, 0.969448},
	{0.232845, 0.986021},
	{0.232845, 0.969448},
	{0.315981, 0.986021},
	{0.315981, 0.969448},
	{0.406188, 0.986021},
	{0.406188, 0.969448},
	{0.500000, 0.986021},
	{0.500000, 0.969448},
	{0.593812, 0.986021},
	{0.593812, 0.969448},
	{0.684018, 0.986021},
	{0.684019, 0.969448},
	{0.767154, 0.986021},
	{0.767155, 0.969448},
	{0.840022, 0.986021},
	{0.840024, 0.969448},
	{0.899824, 0.986021},
	{0.899825, 0.969448},
	{0.944261, 0.986021},
	{0.944262, 0.969448},
	{0.971626, 0.986021},
	{0.971626, 0.969448},
	{0.980866, 0.986021},
	{0.980866, 0.969448},
	{0.971626, 0.986021},
	{0.971626, 0.969448},
	{0.944263, 0.986021},
	{0.944262, 0.969448},
	{0.899827, 0.986021},
	{0.899825, 0.969448},
	{0.840025, 0.986021},
	{0.840023, 0.969448},
	{0.767157, 0.986021},
	{0.767154, 0.969448},
	{0.684022, 0.986021},
	{0.684019, 0.969448},
	{0.593816, 0.986021},
	{0.593811, 0.969448},
	{0.500004, 0.986021},
	{0.499999, 0.969448},
	{0.406191, 0.986021},
	{0.406187, 0.969448},
	{0.315984, 0.986021},
	{0.315980, 0.969448},
	{0.232849, 0.986021},
	{0.232845, 0.969448},
	{0.240254, 0.990826},
	{0.169401, 0.990826},
	{0.321085, 0.990826},
	{0.408792, 0.990826},
	{0.500004, 0.990826},
	{0.591215, 0.990826},
	{0.678922, 0.990826},
	{0.759752, 0.990826},
	{0.830601, 0.990826},
	{0.888744, 0.990826},
	{0.931949, 0.990826},
	{0.958554, 0.990826},
	{0.967537, 0.990826},
	{0.958553, 0.990826},
	{0.931947, 0.990826},
	{0.888742, 0.990826},
	{0.830598, 0.990826},
	{0.759749, 0.990826},
	{0.678918, 0.990826},
	{0.591211, 0.990826},
	{0.500000, 0.990826},
	{0.408788, 0.990826},
	{0.321081, 0.990826},
	{0.240250, 0.990826},
	{0.169402, 0.990826},
	{0.111257, 0.990826},
	{0.068052, 0.990826},
	{0.041447, 0.990826},
	{0.032463, 0.990826},
	{0.041446, 0.990826},
	{0.068052, 0.990826},
	{0.111257, 0.990826},
	{0.585010, 0.597465},
	{0.608824, 0.577921},
	{0.590504, 0.559602},
	{0.570617, 0.575923},
	{0.557841, 0.611987},
	{0.547927, 0.588051},
	{0.528361, 0.620930},
	{0.523307, 0.595520},
	{0.497703, 0.623949},
	{0.497703, 0.598041},
	{0.467045, 0.620929},
	{0.472099, 0.595519},
	{0.437565, 0.611987},
	{0.447479, 0.588051},
	{0.410396, 0.597465},
	{0.424789, 0.575923},
	{0.386582, 0.577921},
	{0.404902, 0.559602},
	{0.367039, 0.554107},
	{0.388580, 0.539714},
	{0.352517, 0.526938},
	{0.376452, 0.517024},
	{0.343574, 0.497459},
	{0.368984, 0.492404},
	{0.340554, 0.466800},
	{0.366462, 0.466800},
	{0.343574, 0.436142},
	{0.368984, 0.441196},
	{0.352516, 0.406662},
	{0.376452, 0.416576},
	{0.367038, 0.379493},
	{0.388580, 0.393887},
	{0.386582, 0.355679},
	{0.404901, 0.373999},
	{0.410396, 0.336136},
	{0.424789, 0.357677},
	{0.437565, 0.321614},
	{0.447479, 0.345549},
	{0.467044, 0.312671},
	{0.472099, 0.338081},
	{0.497703, 0.309651},
	{0.497703, 0.335559},
	{0.528361, 0.312671},
	{0.523306, 0.338081},
	{0.557841, 0.321613},
	{0.547926, 0.345549},
	{0.585010, 0.336135},
	{0.570616, 0.357677},
	{0.608824, 0.355678},
	{0.590504, 0.373998},
	{0.628367, 0.379492},
	{0.606826, 0.393886},
	{0.642890, 0.406661},
	{0.618954, 0.416575},
	{0.651832, 0.436141},
	{0.626422, 0.441195},
	{0.654852, 0.466799},
	{0.628944, 0.466799},
	{0.651833, 0.497457},
	{0.626423, 0.492403},
	{0.642891, 0.526937},
	{0.618955, 0.517023},
	{0.628369, 0.554106},
	{0.606827, 0.539713},
	{0.497703, 0.466800},
	{0.159977, 0.969448},
	{0.159976, 0.986021},
	{0.100174, 0.986021},
	{0.100175, 0.969448},
	{0.055738, 0.986021},
	{0.055738, 0.969448},
	{0.028374, 0.986021},
	{0.028374, 0.969448},
	{0.019134, 0.986021},
	{0.019134, 0.969448},
	{0.028374, 0.986021},
	{0.028374, 0.969448},
	{0.055738, 0.986021},
	{0.055738, 0.969448},
	{0.100175, 0.986021},
	{0.100175, 0.969448},
	{0.159977, 0.986021},
	{0.159977, 0.969448},
	{0.232845, 0.986021},
	{0.232845, 0.969448},
	{0.315981, 0.986021},
	{0.315981, 0.969448},
	{0.406188, 0.986021},
	{0.406188, 0.969448},
	{0.500000, 0.986021},
	{0.500000, 0.969448},
	{0.593812, 0.986021},
	{0.593812, 0.969448},
	{0.684018, 0.986021},
	{0.684019, 0.969448},
	{0.767154, 0.986021},
	{0.767155, 0.969448},
	{0.840022, 0.986021},
	{0.840024, 0.969448},
	{0.899824, 0.986021},
	{0.899825, 0.969448},
	{0.944261, 0.986021},
	{0.944262, 0.969448},
	{0.971626, 0.986021},
	{0.971626, 0.969448},
	{0.980866, 0.986021},
	{0.980866, 0.969448},
	{0.971626, 0.986021},
	{0.971626, 0.969448},
	{0.944263, 0.986021},
	{0.944262, 0.969448},
	{0.899827, 0.986021},
	{0.899825, 0.969448},
	{0.840025, 0.986021},
	{0.840023, 0.969448},
	{0.767157, 0.986021},
	{0.767154, 0.969448},
	{0.684022, 0.986021},
	{0.684019, 0.969448},
	{0.593816, 0.986021},
	{0.593811, 0.969448},
	{0.500004, 0.986021},
	{0.499999, 0.969448},
	{0.406191, 0.986021},
	{0.406187, 0.969448},
	{0.315984, 0.986021},
	{0.315980, 0.969448},
	{0.232849, 0.986021},
	{0.232845, 0.969448},
	{0.240254, 0.990826},
	{0.169401, 0.990826},
	{0.321085, 0.990826},
	{0.408792, 0.990826},
	{0.500004, 0.990826},
	{0.591215, 0.990826},
	{0.678922, 0.990826},
	{0.759752, 0.990826},
	{0.830601, 0.990826},
	{0.888744, 0.990826},
	{0.931949, 0.990826},
	{0.958554, 0.990826},
	{0.967537, 0.990826},
	{0.958553, 0.990826},
	{0.931947, 0.990826},
	{0.888742, 0.990826},
	{0.830598, 0.990826},
	{0.759749, 0.990826},
	{0.678918, 0.990826},
	{0.591211, 0.990826},
	{0.500000, 0.990826},
	{0.408788, 0.990826},
	{0.321081, 0.990826},
	{0.240250, 0.990826},
	{0.169402, 0.990826},
	{0.111257, 0.990826},
	{0.068052, 0.990826},
	{0.041447, 0.990826},
	{0.032463, 0.990826},
	{0.041446, 0.990826},
	{0.068052, 0.990826},
	{0.111257, 0.990826},
	{0.585010, 0.597465},
	{0.608824, 0.577921},
	{0.590504, 0.559602},
	{0.570617, 0.575923},
	{0.557841, 0.611987},
	{0.547927, 0.588051},
	{0.528361, 0.620930},
	{0.523307, 0.595520},
	{0.497703, 0.623949},
	{0.497703, 0.598041},
	{0.467045, 0.620929},
	{0.472099, 0.595519},
	{0.437565, 0.611987},
	{0.447479, 0.588051},
	{0.410396, 0.597465},
	{0.424789, 0.575923},
	{0.386582, 0.577921},
	{0.404902, 0.559602},
	{0.367039, 0.554107},
	{0.388580, 0.539714},
	{0.352517, 0.526938},
	{0.376452, 0.517024},
	{0.343574, 0.497459},
	{0.368984, 0.492404},
	{0.340554, 0.466800},
	{0.366462, 0.466800},
	{0.343574, 0.436142},
	{0.368984, 0.441196},
	{0.352516, 0.406662},
	{0.376452, 0.416576},
	{0.367038, 0.379493},
	{0.388580, 0.393887},
	{0.386582, 0.355679},
	{0.404901, 0.373999},
	{0.410396, 0.336136},
	{0.424789, 0.357677},
	{0.437565, 0.321614},
	{0.447479, 0.345549},
	{0.467044, 0.312671},
	{0.472099, 0.338081},
	{0.497703, 0.309651},
	{0.497703, 0.335559},
	{0.528361, 0.312671},
	{0.523306, 0.338081},
	{0.557841, 0.321613},
	{0.547926, 0.345549},
	{0.585010, 0.336135},
	{0.570616, 0.357677},
	{0.608824, 0.355678},
	{0.590504, 0.373998},
	{0.628367, 0.379492},
	{0.606826, 0.393886},
	{0.642890, 0.406661},
	{0.618954, 0.416575},
	{0.651832, 0.436141},
	{0.626422, 0.441195},
	{0.654852, 0.466799},
	{0.628944, 0.466799},
	{0.651833, 0.497457},
	{0.626423, 0.492403},
	{0.642891, 0.526937},
	{0.618955, 0.517023},
	{0.628369, 0.554106},
	{0.606827, 0.539713},
	{0.497703, 0.466800},
	{0.159977, 0.969448},
	{0.159976, 0.986021},
	{0.100174, 0.986021},
	{0.100175, 0.969448},
	{0.055738, 0.986021},
	{0.055738, 0.969448},
	{0.028374, 0.986021},
	{0.028374, 0.969448},
	{0.019134, 0.986021},
	{0.019134, 0.969448},
	{0.028374, 0.986021},
	{0.028374, 0.969448},
	{0.055738, 0.986021},
	{0.055738, 0.969448},
	{0.100175, 0.986021},
	{0.100175, 0.969448},
	{0.159977, 0.986021},
	{0.159977, 0.969448},
	{0.232845, 0.986021},
	{0.232845, 0.969448},
	{0.315981, 0.986021},
	{0.315981, 0.969448},
	{0.406188, 0.986021},
	{0.406188, 0.969448},
	{0.500000, 0.986021},
	{0.500000, 0.969448},
	{0.593812, 0.986021},
	{0.593812, 0.969448},
	{0.684018, 0.986021},
	{0.684019, 0.969448},
	{0.767154, 0.986021},
	{0.767155, 0.969448},
	{0.840022, 0.986021},
	{0.840024, 0.969448},
	{0.899824, 0.986021},
	{0.899825, 0.969448},
	{0.944261, 0.986021},
	{0.944262, 0.969448},
	{0.971626, 0.986021},
	{0.971626, 0.969448},
	{0.980866, 0.986021},
	{0.980866, 0.969448},
	{0.971626, 0.986021},
	{0.971626, 0.969448},
	{0.944263, 0.986021},
	{0.944262, 0.969448},
	{0.899827, 0.986021},
	{0.899825, 0.969448},
	{0.840025, 0.986021},
	{0.840023, 0.969448},
	{0.767157, 0.986021},
	{0.767154, 0.969448},
	{0.684022, 0.986021},
	{0.684019, 0.969448},
	{0.593816, 0.986021},
	{0.593811, 0.969448},
	{0.500004, 0.986021},
	{0.499999, 0.969448},
	{0.406191, 0.986021},
	{0.406187, 0.969448},
	{0.315984, 0.986021},
	{0.315980, 0.969448},
	{0.232849, 0.986021},
	{0.232845, 0.969448},
	{0.240254, 0.990826},
	{0.169401, 0.990826},
	{0.321085, 0.990826},
	{0.408792, 0.990826},
	{0.500004, 0.990826},
	{0.591215, 0.990826},
	{0.678922, 0.990826},
	{0.759752, 0.990826},
	{0.830601, 0.990826},
	{0.888744, 0.990826},
	{0.931949, 0.990826},
	{0.958554, 0.990826},
	{0.967537, 0.990826},
	{0.958553, 0.990826},
	{0.931947, 0.990826},
	{0.888742, 0.990826},
	{0.830598, 0.990826},
	{0.759749, 0.990826},
	{0.678918, 0.990826},
	{0.591211, 0.990826},
	{0.500000, 0.990826},
	{0.408788, 0.990826},
	{0.321081, 0.990826},
	{0.240250, 0.990826},
	{0.169402, 0.990826},
	{0.111257, 0.990826},
	{0.068052, 0.990826},
	{0.041447, 0.990826},
	{0.032463, 0.990826},
	{0.041446, 0.990826},
	{0.068052, 0.990826},
	{0.111257, 0.990826},
	{0.585010, 0.597465},
	{0.608824, 0.577921},
	{0.590504, 0.559602},
	{0.570617, 0.575923},
	{0.557841, 0.611987},
	{0.547927, 0.588051},
	{0.528361, 0.620930},
	{0.523307, 0.595520},
	{0.497703, 0.623949},
	{0.497703, 0.598041},
	{0.467045, 0.620929},
	{0.472099, 0.595519},
	{0.437565, 0.611987},
	{0.447479, 0.588051},
	{0.410396, 0.597465},
	{0.424789, 0.575923},
	{0.386582, 0.577921},
	{0.404902, 0.559602},
	{0.367039, 0.554107},
	{0.388580, 0.539714},
	{0.352517, 0.526938},
	{0.376452, 0.517024},
	{0.343574, 0.497459},
	{0.368984, 0.492404},
	{0.340554, 0.466800},
	{0.366462, 0.466800},
	{0.343574, 0.436142},
	{0.368984, 0.441196},
	{0.352516, 0.406662},
	{0.376452, 0.416576},
	{0.367038, 0.379493},
	{0.388580, 0.393887},
	{0.386582, 0.355679},
	{0.404901, 0.373999},
	{0.410396, 0.336136},
	{0.424789, 0.357677},
	{0.437565, 0.321614},
	{0.447479, 0.345549},
	{0.467044, 0.312671},
	{0.472099, 0.338081},
	{0.497703, 0.309651},
	{0.497703, 0.335559},
	{0.528361, 0.312671},
	{0.523306, 0.338081},
	{0.557841, 0.321613},
	{0.547926, 0.345549},
	{0.585010, 0.336135},
	{0.570616, 0.357677},
	{0.608824, 0.355678},
	{0.590504, 0.373998},
	{0.628367, 0.379492},
	{0.606826, 0.393886},
	{0.642890, 0.406661},
	{0.618954, 0.416575},
	{0.651832, 0.436141},
	{0.626422, 0.441195},
	{0.654852, 0.466799},
	{0.628944, 0.466799},
	{0.651833, 0.497457},
	{0.626423, 0.492403},
	{0.642891, 0.526937},
	{0.618955, 0.517023},
	{0.628369, 0.554106},
	{0.606827, 0.539713},
	{0.497703, 0.466800},
	{0.159977, 0.969448},
	{0.159976, 0.986021},
	{0.100174, 0.986021},
	{0.100175, 0.969448},
	{0.055738, 0.986021},
	{0.055738, 0.969448},
	{0.028374, 0.986021},
	{0.028374, 0.969448},
	{0.019134, 0.986021},
	{0.019134, 0.969448},
	{0.028374, 0.986021},
	{0.028374, 0.969448},
	{0.055738, 0.986021},
	{0.055738, 0.969448},
	{0.100175, 0.986021},
	{0.100175, 0.969448},
	{0.159977, 0.986021},
	{0.159977, 0.969448},
	{0.232845, 0.986021},
	{0.232845, 0.969448},
	{0.315981, 0.986021},
	{0.315981, 0.969448},
	{0.406188, 0.986021},
	{0.406188, 0.969448},
	{0.500000, 0.986021},
	{0.500000, 0.969448},
	{0.593812, 0.986021},
	{0.593812, 0.969448},
	{0.684018, 0.986021},
	{0.684019, 0.969448},
	{0.767154, 0.986021},
	{0.767155, 0.969448},
	{0.840022, 0.986021},
	{0.840024, 0.969448},
	{0.899824, 0.986021},
	{0.899825, 0.969448},
	{0.944261, 0.986021},
	{0.944262, 0.969448},
	{0.971626, 0.986021},
	{0.971626, 0.969448},
	{0.980866, 0.986021},
	{0.980866, 0.969448},
	{0.971626, 0.986021},
	{0.971626, 0.969448},
	{0.944263, 0.986021},
	{0.944262, 0.969448},
	{0.899827, 0.986021},
	{0.899825, 0.969448},
	{0.840025, 0.986021},
	{0.840023, 0.969448},
	{0.767157, 0.986021},
	{0.767154, 0.969448},
	{0.684022, 0.986021},
	{0.684019, 0.969448},
	{0.593816, 0.986021},
	{0.593811, 0.969448},
	{0.500004, 0.986021},
	{0.499999, 0.969448},
	{0.406191, 0.986021},
	{0.406187, 0.969448},
	{0.315984, 0.986021},
	{0.315980, 0.969448},
	{0.232849, 0.986021},
	{0.232845, 0.969448},
	{0.240254, 0.990826},
	{0.169401, 0.990826},
	{0.321085, 0.990826},
	{0.408792, 0.990826},
	{0.500004, 0.990826},
	{0.591215, 0.990826},
	{0.678922, 0.990826},
	{0.759752, 0.990826},
	{0.830601, 0.990826},
	{0.888744, 0.990826},
	{0.931949, 0.990826},
	{0.958554, 0.990826},
	{0.967537, 0.990826},
	{0.958553, 0.990826},
	{0.931947, 0.990826},
	{0.888742, 0.990826},
	{0.830598, 0.990826},
	{0.759749, 0.990826},
	{0.678918, 0.990826},
	{0.591211, 0.990826},
	{0.500000, 0.990826},
	{0.408788, 0.990826},
	{0.321081, 0.990826},
	{0.240250, 0.990826},
	{0.169402, 0.990826},
	{0.111257, 0.990826},
	{0.068052, 0.990826},
	{0.041447, 0.990826},
	{0.032463, 0.990826},
	{0.041446, 0.990826},
	{0.068052, 0.990826},
	{0.111257, 0.990826},
	{0.585010, 0.597465},
	{0.608824, 0.577921},
	{0.590504, 0.559602},
	{0.570617, 0.575923},
	{0.557841, 0.611987},
	{0.547927, 0.588051},
	{0.528361, 0.620930},
	{0.523307, 0.595520},
	{0.497703, 0.623949},
	{0.497703, 0.598041},
	{0.467045, 0.620929},
	{0.472099, 0.595519},
	{0.437565, 0.611987},
	{0.447479, 0.588051},
	{0.410396, 0.597465},
	{0.424789, 0.575923},
	{0.386582, 0.577921},
	{0.404902, 0.559602},
	{0.367039, 0.554107},
	{0.388580, 0.539714},
	{0.352517, 0.526938},
	{0.376452, 0.517024},
	{0.343574, 0.497459},
	{0.368984, 0.492404},
	{0.340554, 0.466800},
	{0.366462, 0.466800},
	{0.343574, 0.436142},
	{0.368984, 0.441196},
	{0.352516, 0.406662},
	{0.376452, 0.416576},
	{0.367038, 0.379493},
	{0.388580, 0.393887},
	{0.386582, 0.355679},
	{0.404901, 0.373999},
	{0.410396, 0.336136},
	{0.424789, 0.357677},
	{0.437565, 0.321614},
	{0.447479, 0.345549},
	{0.467044, 0.312671},
	{0.472099, 0.338081},
	{0.497703, 0.309651},
	{0.497703, 0.335559},
	{0.528361, 0.312671},
	{0.523306, 0.338081},
	{0.557841, 0.321613},
	{0.547926, 0.345549},
	{0.585010, 0.336135},
	{0.570616, 0.357677},
	{0.608824, 0.355678},
	{0.590504, 0.373998},
	{0.628367, 0.379492},
	{0.606826, 0.393886},
	{0.642890, 0.406661},
	{0.618954, 0.416575},
	{0.651832, 0.436141},
	{0.626422, 0.441195},
	{0.654852, 0.466799},
	{0.628944, 0.466799},
	{0.651833, 0.497457},
	{0.626423, 0.492403},
	{0.642891, 0.526937},
	{0.618955, 0.517023},
	{0.628369, 0.554106},
	{0.606827, 0.539713},
	{0.497703, 0.466800},
	{0.848177, 0.224916},
	{0.818438, 0.176440},
	{0.752033, 0.240867},
	{0.783711, 0.291546},
	{0.793129, 0.146678},
	{0.726169, 0.211112},
	{0.762438, 0.123481},
	{0.698958, 0.184992},
	{0.794577, 0.147215},
	{0.765649, 0.122742},
	{0.696432, 0.187743},
	{0.727237, 0.211803},
	{0.819583, 0.176620},
	{0.756668, 0.246737},
	{0.848965, 0.224517},
	{0.780854, 0.289364},
	{0.740004, 0.106039},
	{0.673061, 0.169251},
	{0.730260, 0.099555},
	{0.662480, 0.162820},
	{0.721266, 0.093570},
	{0.652713, 0.156884},
	{0.239538, 0.161658},
	{0.191764, 0.190965},
	{0.255039, 0.258379},
	{0.304188, 0.223557},
	{0.162434, 0.215908},
	{0.225216, 0.284302},
	{0.138024, 0.244760},
	{0.199037, 0.311574},
	{0.129366, 0.257771},
	{0.190304, 0.325943},
	{0.120116, 0.271671},
	{0.180973, 0.341294},
	{0.110095, 0.286729},
	{0.170865, 0.357924},
	{0.755551, 0.116022},
	{0.685121, 0.179332},
	{0.743719, 0.108149},
	{0.671356, 0.171276},
	{0.723573, 0.094742},
	{0.647765, 0.160120},
	{0.848177, 0.224916},
	{0.818438, 0.176440},
	{0.752033, 0.240867},
	{0.783711, 0.291546},
	{0.793129, 0.146678},
	{0.726169, 0.211112},
	{0.762438, 0.123481},
	{0.698958, 0.184992},
	{0.794577, 0.147215},
	{0.765649, 0.122742},
	{0.696432, 0.187743},
	{0.727237, 0.211803},
	{0.819583, 0.176620},
	{0.756668, 0.246737},
	{0.848965, 0.224517},
	{0.780854, 0.289364},
	{0.740004, 0.106039},
	{0.673061, 0.169251},
	{0.730260, 0.099555},
	{0.662480, 0.162820},
	{0.721266, 0.093570},
	{0.652713, 0.156884},
	{0.239538, 0.161658},
	{0.191764, 0.190965},
	{0.255039, 0.258379},
	{0.304188, 0.223557},
	{0.162434, 0.215908},
	{0.225216, 0.284302},
	{0.138024, 0.244760},
	{0.199037, 0.311574},
	{0.129366, 0.257771},
	{0.190304, 0.325943},
	{0.120116, 0.271671},
	{0.180973, 0.341294},
	{0.110095, 0.286729},
	{0.170865, 0.357924},
	{0.755551, 0.116022},
	{0.685121, 0.179332},
	{0.743719, 0.108149},
	{0.671356, 0.171276},
	{0.723573, 0.094742},
	{0.647765, 0.160120},
	{0.848177, 0.224916},
	{0.783711, 0.291546},
	{0.752033, 0.240867},
	{0.818438, 0.176440},
	{0.726169, 0.211112},
	{0.793129, 0.146678},
	{0.698958, 0.184992},
	{0.762438, 0.123481},
	{0.794577, 0.147215},
	{0.727237, 0.211803},
	{0.696432, 0.187743},
	{0.765649, 0.122742},
	{0.819583, 0.176620},
	{0.756668, 0.246737},
	{0.848965, 0.224517},
	{0.780854, 0.289364},
	{0.673061, 0.169251},
	{0.740004, 0.106039},
	{0.662480, 0.162820},
	{0.730260, 0.099555},
	{0.652713, 0.156884},
	{0.721266, 0.093570},
	{0.239538, 0.161658},
	{0.304188, 0.223557},
	{0.255039, 0.258379},
	{0.191764, 0.190965},
	{0.225216, 0.284302},
	{0.162434, 0.215908},
	{0.199037, 0.311574},
	{0.138024, 0.244760},
	{0.190304, 0.325943},
	{0.129366, 0.257771},
	{0.180973, 0.341294},
	{0.120116, 0.271671},
	{0.170865, 0.357924},
	{0.110095, 0.286729},
	{0.685121, 0.179332},
	{0.755551, 0.116022},
	{0.671356, 0.171276},
	{0.743719, 0.108149},
	{0.647765, 0.160120},
	{0.723573, 0.094742},
	{0.848177, 0.224916},
	{0.783711, 0.291546},
	{0.752033, 0.240867},
	{0.818438, 0.176440},
	{0.726169, 0.211112},
	{0.793129, 0.146678},
	{0.698958, 0.184992},
	{0.762438, 0.123481},
	{0.794577, 0.147215},
	{0.727237, 0.211803},
	{0.696432, 0.187743},
	{0.765649, 0.122742},
	{0.819583, 0.176620},
	{0.756668, 0.246737},
	{0.848965, 0.224517},
	{0.780854, 0.289364},
	{0.673061, 0.169251},
	{0.740004, 0.106039},
	{0.662480, 0.162820},
	{0.730260, 0.099555},
	{0.652713, 0.156884},
	{0.721266, 0.093570},
	{0.239538, 0.161658},
	{0.304188, 0.223557},
	{0.255039, 0.258379},
	{0.191764, 0.190965},
	{0.225216, 0.284302},
	{0.162434, 0.215908},
	{0.199037, 0.311574},
	{0.138024, 0.244760},
	{0.190304, 0.325943},
	{0.129366, 0.257771},
	{0.180973, 0.341294},
	{0.120116, 0.271671},
	{0.170865, 0.357924},
	{0.110095, 0.286729},
	{0.685121, 0.179332},
	{0.755551, 0.116022},
	{0.671356, 0.171276},
	{0.743719, 0.108149},
	{0.647765, 0.160120},
	{0.723573, 0.094742},
	{0.848177, 0.224916},
	{0.818438, 0.176440},
	{0.752033, 0.240867},
	{0.783711, 0.291546},
	{0.793129, 0.146678},
	{0.726169, 0.211112},
	{0.762438, 0.123481},
	{0.698958, 0.184992},
	{0.794577, 0.147215},
	{0.765649, 0.122742},
	{0.696432, 0.187743},
	{0.727237, 0.211803},
	{0.819583, 0.176620},
	{0.756668, 0.246737},
	{0.848965, 0.224517},
	{0.780854, 0.289364},
	{0.740004, 0.106039},
	{0.673061, 0.169251},
	{0.730260, 0.099555},
	{0.662480, 0.162820},
	{0.721266, 0.093570},
	{0.652713, 0.156884},
	{0.239538, 0.161658},
	{0.191764, 0.190965},
	{0.255039, 0.258379},
	{0.304188, 0.223557},
	{0.162434, 0.215908},
	{0.225216, 0.284302},
	{0.138024, 0.244760},
	{0.199037, 0.311574},
	{0.129366, 0.257771},
	{0.190304, 0.325943},
	{0.120116, 0.271671},
	{0.180973, 0.341294},
	{0.110095, 0.286729},
	{0.170865, 0.357924},
	{0.755551, 0.116022},
	{0.685121, 0.179332},
	{0.743719, 0.108149},
	{0.671356, 0.171276},
	{0.723573, 0.094742},
	{0.647765, 0.160120},
	{0.848177, 0.224916},
	{0.818438, 0.176440},
	{0.752033, 0.240867},
	{0.783711, 0.291546},
	{0.793129, 0.146678},
	{0.726169, 0.211112},
	{0.762438, 0.123481},
	{0.698958, 0.184992},
	{0.794577, 0.147215},
	{0.765649, 0.122742},
	{0.696432, 0.187743},
	{0.727237, 0.211803},
	{0.819583, 0.176620},
	{0.756668, 0.246737},
	{0.848965, 0.224517},
	{0.780854, 0.289364},
	{0.740004, 0.106039},
	{0.673061, 0.169251},
	{0.730260, 0.099555},
	{0.662480, 0.162820},
	{0.721266, 0.093570},
	{0.652713, 0.156884},
	{0.239538, 0.161658},
	{0.191764, 0.190965},
	{0.255039, 0.258379},
	{0.304188, 0.223557},
	{0.162434, 0.215908},
	{0.225216, 0.284302},
	{0.138024, 0.244760},
	{0.199037, 0.311574},
	{0.129366, 0.257771},
	{0.190304, 0.325943},
	{0.120116, 0.271671},
	{0.180973, 0.341294},
	{0.110095, 0.286729},
	{0.170865, 0.357924},
	{0.755551, 0.116022},
	{0.685121, 0.179332},
	{0.743719, 0.108149},
	{0.671356, 0.171276},
	{0.723573, 0.094742},
	{0.647765, 0.160120},
	{0.848177, 0.224916},
	{0.783711, 0.291546},
	{0.752033, 0.240867},
	{0.818438, 0.176440},
	{0.726169, 0.211112},
	{0.793129, 0.146678},
	{0.698958, 0.184992},
	{0.762438, 0.123481},
	{0.794577, 0.147215},
	{0.727237, 0.211803},
	{0.696432, 0.187743},
	{0.765649, 0.122742},
	{0.819583, 0.176620},
	{0.756668, 0.246737},
	{0.848965, 0.224517},
	{0.780854, 0.289364},
	{0.673061, 0.169251},
	{0.740004, 0.106039},
	{0.662480, 0.162820},
	{0.730260, 0.099555},
	{0.652713, 0.156884},
	{0.721266, 0.093570},
	{0.239538, 0.161658},
	{0.304188, 0.223557},
	{0.255039, 0.258379},
	{0.191764, 0.190965},
	{0.225216, 0.284302},
	{0.162434, 0.215908},
	{0.199037, 0.311574},
	{0.138024, 0.244760},
	{0.190304, 0.325943},
	{0.129366, 0.257771},
	{0.180973, 0.341294},
	{0.120116, 0.271671},
	{0.170865, 0.357924},
	{0.110095, 0.286729},
	{0.685121, 0.179332},
	{0.755551, 0.116022},
	{0.671356, 0.171276},
	{0.743719, 0.108149},
	{0.647765, 0.160120},
	{0.723573, 0.094742},
	{0.848177, 0.224916},
	{0.783711, 0.291546},
	{0.752033, 0.240867},
	{0.818438, 0.176440},
	{0.726169, 0.211112},
	{0.793129, 0.146678},
	{0.698958, 0.184992},
	{0.762438, 0.123481},
	{0.794577, 0.147215},
	{0.727237, 0.211803},
	{0.696432, 0.187743},
	{0.765649, 0.122742},
	{0.819583, 0.176620},
	{0.756668, 0.246737},
	{0.848965, 0.224517},
	{0.780854, 0.289364},
	{0.673061, 0.169251},
	{0.740004, 0.106039},
	{0.662480, 0.162820},
	{0.730260, 0.099555},
	{0.652713, 0.156884},
	{0.721266, 0.093570},
	{0.239538, 0.161658},
	{0.304188, 0.223557},
	{0.255039, 0.258379},
	{0.191764, 0.190965},
	{0.225216, 0.284302},
	{0.162434, 0.215908},
	{0.199037, 0.311574},
	{0.138024, 0.244760},
	{0.190304, 0.325943},
	{0.129366, 0.257771},
	{0.180973, 0.341294},
	{0.120116, 0.271671},
	{0.170865, 0.357924},
	{0.110095, 0.286729},
	{0.685121, 0.179332},
	{0.755551, 0.116022},
	{0.671356, 0.171276},
	{0.743719, 0.108149},
	{0.647765, 0.160120},
	{0.723573, 0.094742},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.137764, 0.490977},
	{0.122964, 0.559352},
	{0.145933, 0.561194},
	{0.117345, 0.457401},
	{0.140166, 0.456563},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.140166, 0.456563},
	{0.117345, 0.457401},
	{0.137764, 0.490977},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.145933, 0.561194},
	{0.122964, 0.559352},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.137764, 0.490977},
	{0.122964, 0.559352},
	{0.145933, 0.561194},
	{0.117345, 0.457401},
	{0.140166, 0.456563},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.140166, 0.456563},
	{0.117345, 0.457401},
	{0.137764, 0.490977},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.145933, 0.561194},
	{0.122964, 0.559352},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.137764, 0.490977},
	{0.122964, 0.559352},
	{0.145933, 0.561194},
	{0.117345, 0.457401},
	{0.140166, 0.456563},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.140166, 0.456563},
	{0.117345, 0.457401},
	{0.137764, 0.490977},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.145933, 0.561194},
	{0.122964, 0.559352},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.137764, 0.490977},
	{0.122964, 0.559352},
	{0.145933, 0.561194},
	{0.117345, 0.457401},
	{0.140166, 0.456563},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.140166, 0.456563},
	{0.117345, 0.457401},
	{0.137764, 0.490977},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.145933, 0.561194},
	{0.122964, 0.559352},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.137764, 0.490977},
	{0.122964, 0.559352},
	{0.145933, 0.561194},
	{0.117345, 0.457401},
	{0.140166, 0.456563},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.140166, 0.456563},
	{0.117345, 0.457401},
	{0.137764, 0.490977},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.145933, 0.561194},
	{0.122964, 0.559352},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.137764, 0.490977},
	{0.122964, 0.559352},
	{0.145933, 0.561194},
	{0.117345, 0.457401},
	{0.140166, 0.456563},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.140166, 0.456563},
	{0.117345, 0.457401},
	{0.137764, 0.490977},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.145933, 0.561194},
	{0.122964, 0.559352},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.137764, 0.490977},
	{0.122964, 0.559352},
	{0.145933, 0.561194},
	{0.117345, 0.457401},
	{0.140166, 0.456563},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.140166, 0.456563},
	{0.117345, 0.457401},
	{0.137764, 0.490977},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.145933, 0.561194},
	{0.122964, 0.559352},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.137764, 0.490977},
	{0.122964, 0.559352},
	{0.145933, 0.561194},
	{0.117345, 0.457401},
	{0.140166, 0.456563},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.140166, 0.456563},
	{0.117345, 0.457401},
	{0.137764, 0.490977},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.145933, 0.561194},
	{0.122964, 0.559352},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.137764, 0.490977},
	{0.122964, 0.559352},
	{0.145933, 0.561194},
	{0.117345, 0.457401},
	{0.140166, 0.456563},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.140166, 0.456563},
	{0.117345, 0.457401},
	{0.137764, 0.490977},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.145933, 0.561194},
	{0.122964, 0.559352},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.137764, 0.490977},
	{0.122964, 0.559352},
	{0.145933, 0.561194},
	{0.117345, 0.457401},
	{0.140166, 0.456563},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.140166, 0.456563},
	{0.117345, 0.457401},
	{0.137764, 0.490977},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.145933, 0.561194},
	{0.122964, 0.559352},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.137764, 0.490977},
	{0.122964, 0.559352},
	{0.145933, 0.561194},
	{0.117345, 0.457401},
	{0.140166, 0.456563},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.140166, 0.456563},
	{0.117345, 0.457401},
	{0.137764, 0.490977},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.145933, 0.561194},
	{0.122964, 0.559352},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.137764, 0.490977},
	{0.122964, 0.559352},
	{0.145933, 0.561194},
	{0.117345, 0.457401},
	{0.140166, 0.456563},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.122964, 0.423869},
	{0.145933, 0.422150},
	{0.140166, 0.456563},
	{0.117345, 0.457401},
	{0.137764, 0.490977},
	{0.115004, 0.490933},
	{0.117345, 0.524801},
	{0.140166, 0.525734},
	{0.145933, 0.561194},
	{0.122964, 0.559352},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
	{0.984768, 0.689506},
	{0.984768, 0.778887},
	{0.992096, 0.778887},
	{0.992096, 0.689507},
};

float
companion_normals[COMPANION_VERTEX_COUNT][3] = {
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000000, 0.000001, 1.000000},
	{0.000000, 0.000001, 1.000000},
	{0.000000, 0.000001, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000003, -0.000000, 1.000000},
	{0.000003, -0.000000, 1.000000},
	{0.000003, -0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000002, -0.000002, 1.000000},
	{0.000002, -0.000002, 1.000000},
	{0.000002, -0.000002, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000002, -0.000002, -1.000000},
	{-0.000002, -0.000002, -1.000000},
	{-0.000002, -0.000002, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{0.000000, -0.000001, -1.000000},
	{0.000000, -0.000001, -1.000000},
	{0.000000, -0.000001, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000002, -0.000001, -1.000000},
	{-0.000002, -0.000001, -1.000000},
	{-0.000002, -0.000001, -1.000000},
	{0.000000, -0.000001, -1.000000},
	{0.000000, -0.000001, -1.000000},
	{0.000000, -0.000001, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000001},
	{-0.000001, 1.000000, -0.000001},
	{-0.000001, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000001, -1.000000, 0.000001},
	{0.000001, -1.000000, 0.000001},
	{0.000001, -1.000000, 0.000001},
	{1.000000, 0.000001, 0.000001},
	{1.000000, 0.000001, 0.000001},
	{1.000000, 0.000001, 0.000001},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, 0.000001, 0.000000},
	{1.000000, 0.000001, 0.000000},
	{1.000000, 0.000001, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, 0.000001, -0.000001},
	{1.000000, 0.000001, -0.000001},
	{1.000000, 0.000001, -0.000001},
	{1.000000, -0.000001, 0.000001},
	{1.000000, -0.000001, 0.000001},
	{1.000000, -0.000001, 0.000001},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, -0.000001, 0.000000},
	{-1.000000, -0.000001, 0.000000},
	{-1.000000, -0.000001, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, -0.000001},
	{-1.000000, 0.000000, -0.000001},
	{-1.000000, 0.000000, -0.000001},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000001, 0.000000},
	{-1.000000, 0.000001, 0.000000},
	{-1.000000, 0.000001, 0.000000},
	{-1.000000, -0.000001, 0.000000},
	{-1.000000, -0.000001, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000001, -0.000001, -1.000000},
	{-0.000001, -0.000001, -1.000000},
	{-0.000001, -0.000001, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{0.000000, -0.000001, -1.000000},
	{0.000000, -0.000001, -1.000000},
	{0.000000, -0.000001, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000001, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000001, 0.000001, 1.000000},
	{0.000001, 0.000001, 1.000000},
	{0.000001, 0.000001, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000001, -0.000001, 1.000000},
	{0.000001, -0.000001, 1.000000},
	{0.000001, -0.000001, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000001, -0.000000, 1.000000},
	{0.000001, -0.000000, 1.000000},
	{0.000001, -0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000001, -0.000000, 1.000000},
	{0.000001, -0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, -0.000001, 1.000000},
	{-0.000000, -0.000001, 1.000000},
	{-0.000000, -0.000001, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000000, 0.000001, 1.000000},
	{0.000000, 0.000001, 1.000000},
	{0.000000, 0.000001, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000001, -0.000001, 1.000000},
	{0.000001, -0.000001, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000001, -0.000000, 1.000000},
	{0.000001, -0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, -1.000000, -0.000001},
	{-0.000000, -1.000000, -0.000001},
	{-0.000000, -1.000000, -0.000001},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{-0.000000, -1.000000, -0.000001},
	{-0.000000, -1.000000, -0.000001},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000001},
	{-0.000001, 1.000000, -0.000001},
	{-0.000001, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, -0.000002, -0.000000},
	{-1.000000, -0.000002, -0.000000},
	{-1.000000, -0.000002, -0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, -0.000001, 0.000001},
	{-1.000000, -0.000001, 0.000001},
	{-1.000000, -0.000001, 0.000001},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, -0.000001},
	{-1.000000, 0.000000, -0.000001},
	{-1.000000, 0.000000, -0.000001},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, -0.000002, 0.000001},
	{-1.000000, -0.000002, 0.000001},
	{-1.000000, -0.000002, 0.000001},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, 0.000001, 0.000001},
	{1.000000, 0.000001, 0.000001},
	{1.000000, 0.000001, 0.000001},
	{1.000000, -0.000000, -0.000001},
	{1.000000, -0.000000, -0.000001},
	{1.000000, -0.000000, -0.000001},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, -0.000001},
	{1.000000, -0.000000, -0.000001},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, 0.000001, 0.000000},
	{1.000000, 0.000001, 0.000000},
	{1.000000, 0.000001, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, 0.000001, 0.000000},
	{1.000000, 0.000001, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.621757, 0.783210, -0.000000},
	{-0.621757, 0.783210, -0.000000},
	{-0.621757, 0.783210, -0.000000},
	{-0.621757, 0.783210, -0.000000},
	{0.000000, 0.778535, 0.627601},
	{0.000000, 0.778535, 0.627601},
	{0.000000, 0.778535, 0.627601},
	{0.000000, 0.778535, 0.627601},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, 0.000000, -0.000003},
	{1.000000, 0.000000, -0.000003},
	{1.000000, 0.000000, -0.000003},
	{1.000000, 0.000000, -0.000003},
	{0.763484, -0.645827, 0.000000},
	{0.763484, -0.645827, 0.000000},
	{0.763484, -0.645827, 0.000000},
	{0.763484, -0.645827, 0.000000},
	{0.783210, 0.000000, 0.621758},
	{0.783210, 0.000000, 0.621758},
	{0.783210, 0.000000, 0.621758},
	{0.783210, 0.000000, 0.621758},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000000},
	{0.000000, 1.000000, -0.000002},
	{0.000000, 1.000000, -0.000002},
	{0.000000, 1.000000, -0.000002},
	{0.000000, 1.000000, -0.000002},
	{0.000000, 1.000000, -0.000002},
	{0.000000, 1.000000, -0.000002},
	{0.000000, 1.000000, -0.000002},
	{0.000000, 1.000000, -0.000002},
	{-0.000000, 1.000000, -0.000000},
	{0.625724, 0.603819, 0.493834},
	{0.625724, 0.603819, 0.493834},
	{0.625724, 0.603819, 0.493834},
	{0.625724, 0.603819, 0.493834},
	{0.711015, 0.703177, -0.000001},
	{0.711015, 0.703177, -0.000001},
	{0.711015, 0.703177, -0.000001},
	{0.711015, 0.703177, -0.000001},
	{0.711015, 0.703177, -0.000000},
	{0.711015, 0.703177, -0.000000},
	{0.711015, 0.703177, -0.000000},
	{0.711015, 0.703177, -0.000000},
	{0.711015, 0.703177, -0.000000},
	{0.711015, 0.703177, -0.000000},
	{0.711015, 0.703177, -0.000000},
	{0.711015, 0.703177, -0.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{0.000000, -0.621758, -0.783209},
	{0.000000, -0.621758, -0.783209},
	{0.000000, -0.621758, -0.783209},
	{0.000000, -0.621758, -0.783209},
	{-0.618479, 0.000000, -0.785801},
	{-0.618479, 0.000000, -0.785801},
	{-0.618479, 0.000000, -0.785801},
	{-0.618479, 0.000000, -0.785801},
	{0.000000, 0.000003, -1.000000},
	{0.000000, 0.000003, -1.000000},
	{0.000000, 0.000003, -1.000000},
	{0.000000, 0.000003, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{0.593241, 0.578147, -0.560188},
	{0.593241, 0.578147, -0.560188},
	{0.593241, 0.578147, -0.560188},
	{-0.489455, 0.612207, -0.620996},
	{-0.489455, 0.612207, -0.620996},
	{-0.489455, 0.612207, -0.620996},
	{-0.489455, 0.612207, -0.620996},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000004, -0.000001, -1.000000},
	{-0.000004, -0.000001, -1.000000},
	{-0.000004, -0.000001, -1.000000},
	{-0.000004, -0.000001, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{0.000000, 0.700306, -0.713843},
	{0.000000, 0.700306, -0.713843},
	{0.000000, 0.700306, -0.713843},
	{0.000000, 0.700306, -0.713843},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{0.000002, 0.000003, -1.000000},
	{0.000002, 0.000003, -1.000000},
	{0.000002, 0.000003, -1.000000},
	{0.000002, 0.000003, -1.000000},
	{0.000001, 0.000002, -1.000000},
	{0.000001, 0.000002, -1.000000},
	{0.000001, 0.000002, -1.000000},
	{0.000001, 0.000002, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{0.000000, 0.700306, -0.713842},
	{0.000000, 0.700306, -0.713842},
	{0.000000, 0.700306, -0.713842},
	{0.000000, 0.700306, -0.713842},
	{0.000000, 0.700307, -0.713842},
	{0.000000, 0.700307, -0.713842},
	{0.000000, 0.700307, -0.713842},
	{0.000000, 0.700307, -0.713842},
	{0.000000, 0.700307, -0.713842},
	{0.000000, 0.700307, -0.713842},
	{0.710974, 0.000000, -0.703218},
	{0.710974, 0.000000, -0.703218},
	{0.710974, 0.000000, -0.703218},
	{0.710974, 0.000000, -0.703218},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000001, -0.000001},
	{1.000000, -0.000001, -0.000001},
	{1.000000, -0.000001, -0.000001},
	{1.000000, -0.000001, -0.000001},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{0.710974, 0.000000, -0.703218},
	{0.710974, 0.000000, -0.703218},
	{0.710974, 0.000000, -0.703218},
	{0.710974, 0.000000, -0.703218},
	{0.710975, 0.000001, -0.703217},
	{0.710975, 0.000001, -0.703217},
	{0.710975, 0.000001, -0.703217},
	{0.710975, 0.000001, -0.703217},
	{0.710974, 0.000000, -0.703218},
	{0.710974, 0.000000, -0.703218},
	{0.593219, -0.502560, -0.628908},
	{0.593219, -0.502560, -0.628908},
	{0.593219, -0.502560, -0.628908},
	{0.593219, -0.502560, -0.628908},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.621757, -0.000000, -0.783210},
	{-0.621757, -0.000000, -0.783210},
	{-0.621757, -0.000000, -0.783210},
	{-0.621757, -0.000000, -0.783210},
	{0.000000, 0.627601, -0.778535},
	{0.000000, 0.627601, -0.778535},
	{0.000000, 0.627601, -0.778535},
	{0.000000, 0.627601, -0.778535},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{0.763484, 0.000000, 0.645827},
	{0.763484, 0.000000, 0.645827},
	{0.763484, 0.000000, 0.645827},
	{0.763484, 0.000000, 0.645827},
	{0.783210, 0.621757, -0.000000},
	{0.783210, 0.621757, -0.000000},
	{0.783210, 0.621757, -0.000000},
	{0.783210, 0.621757, -0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{0.625724, 0.493833, -0.603820},
	{0.625724, 0.493833, -0.603820},
	{0.625724, 0.493833, -0.603820},
	{0.625724, 0.493833, -0.603820},
	{0.711013, 0.000000, -0.703178},
	{0.711013, 0.000000, -0.703178},
	{0.711013, 0.000000, -0.703178},
	{0.711013, 0.000000, -0.703178},
	{0.711013, 0.000000, -0.703178},
	{0.711013, 0.000000, -0.703178},
	{0.711014, -0.000000, -0.703178},
	{0.711014, -0.000000, -0.703178},
	{0.711014, -0.000000, -0.703178},
	{0.711014, -0.000000, -0.703178},
	{0.711014, -0.000000, -0.703178},
	{0.711014, -0.000000, -0.703178},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -0.783210, 0.621758},
	{0.000000, -0.783210, 0.621758},
	{0.000000, -0.783210, 0.621758},
	{0.000000, -0.783210, 0.621758},
	{-0.618479, -0.785801, 0.000000},
	{-0.618479, -0.785801, 0.000000},
	{-0.618479, -0.785801, 0.000000},
	{-0.618479, -0.785801, 0.000000},
	{-0.000000, -1.000000, -0.000001},
	{-0.000000, -1.000000, -0.000001},
	{-0.000000, -1.000000, -0.000001},
	{-0.000000, -1.000000, -0.000001},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.593240, -0.560188, -0.578148},
	{0.593240, -0.560188, -0.578148},
	{0.593240, -0.560188, -0.578148},
	{-0.489456, -0.620997, -0.612206},
	{-0.489456, -0.620997, -0.612206},
	{-0.489456, -0.620997, -0.612206},
	{-0.489456, -0.620997, -0.612206},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{-0.000002, -1.000000, 0.000000},
	{-0.000002, -1.000000, 0.000000},
	{-0.000002, -1.000000, 0.000000},
	{-0.000002, -1.000000, 0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000001, -0.713843, -0.700306},
	{0.000001, -0.713843, -0.700306},
	{0.000001, -0.713843, -0.700306},
	{0.000001, -0.713843, -0.700306},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000001},
	{0.000001, -1.000000, -0.000001},
	{0.000001, -1.000000, -0.000001},
	{0.000001, -1.000000, -0.000001},
	{0.000001, -1.000000, -0.000001},
	{0.000001, -1.000000, -0.000001},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -0.713843, -0.700306},
	{0.000000, -0.713843, -0.700306},
	{0.000000, -0.713843, -0.700306},
	{0.000000, -0.713843, -0.700306},
	{0.000000, -0.713843, -0.700306},
	{0.000000, -0.713843, -0.700306},
	{0.000000, -0.713842, -0.700307},
	{0.000000, -0.713842, -0.700307},
	{0.000000, -0.713842, -0.700307},
	{0.000000, -0.713842, -0.700307},
	{0.710975, -0.703217, 0.000000},
	{0.710975, -0.703217, 0.000000},
	{0.710975, -0.703217, 0.000000},
	{0.710975, -0.703217, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{0.710975, -0.703217, 0.000000},
	{0.710975, -0.703217, 0.000000},
	{0.710975, -0.703217, 0.000000},
	{0.710975, -0.703217, 0.000000},
	{0.710975, -0.703217, -0.000001},
	{0.710975, -0.703217, -0.000001},
	{0.710975, -0.703217, -0.000001},
	{0.710975, -0.703217, -0.000001},
	{0.710975, -0.703217, 0.000000},
	{0.710975, -0.703217, 0.000000},
	{0.593219, -0.628908, 0.502559},
	{0.593219, -0.628908, 0.502559},
	{0.593219, -0.628908, 0.502559},
	{0.593219, -0.628908, 0.502559},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{0.621757, 0.783211, -0.000000},
	{0.621757, 0.783211, -0.000000},
	{0.621757, 0.783211, -0.000000},
	{0.621757, 0.783211, -0.000000},
	{0.000000, 0.778535, 0.627601},
	{0.000000, 0.778535, 0.627601},
	{0.000000, 0.778535, 0.627601},
	{0.000000, 0.778535, 0.627601},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.763483, -0.645828, 0.000000},
	{-0.763483, -0.645828, 0.000000},
	{-0.763483, -0.645828, 0.000000},
	{-0.763483, -0.645828, 0.000000},
	{-0.783210, 0.000000, 0.621758},
	{-0.783210, 0.000000, 0.621758},
	{-0.783210, 0.000000, 0.621758},
	{-0.783210, 0.000000, 0.621758},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000000},
	{0.000000, 1.000000, -0.000002},
	{0.000000, 1.000000, -0.000002},
	{0.000000, 1.000000, -0.000002},
	{0.000000, 1.000000, -0.000002},
	{0.000000, 1.000000, -0.000002},
	{0.000000, 1.000000, -0.000002},
	{0.000000, 1.000000, -0.000002},
	{0.000000, 1.000000, -0.000002},
	{-0.000000, 1.000000, -0.000000},
	{-0.625723, 0.603820, 0.493834},
	{-0.625723, 0.603820, 0.493834},
	{-0.625723, 0.603820, 0.493834},
	{-0.625723, 0.603820, 0.493834},
	{-0.711013, 0.703179, -0.000000},
	{-0.711013, 0.703179, -0.000000},
	{-0.711013, 0.703179, -0.000000},
	{-0.711013, 0.703179, -0.000000},
	{-0.711013, 0.703179, -0.000000},
	{-0.711013, 0.703179, -0.000000},
	{-0.711013, 0.703179, -0.000000},
	{-0.711013, 0.703179, -0.000000},
	{-0.711013, 0.703178, -0.000000},
	{-0.711013, 0.703178, -0.000000},
	{-0.711013, 0.703178, -0.000000},
	{-0.711013, 0.703178, -0.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.621758, -0.783210},
	{-0.000000, -0.621758, -0.783210},
	{-0.000000, -0.621758, -0.783210},
	{-0.000000, -0.621758, -0.783210},
	{0.618480, 0.000000, -0.785801},
	{0.618480, 0.000000, -0.785801},
	{0.618480, 0.000000, -0.785801},
	{0.618480, 0.000000, -0.785801},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.593240, 0.578149, -0.560188},
	{-0.593240, 0.578149, -0.560188},
	{-0.593240, 0.578149, -0.560188},
	{0.489456, 0.612208, -0.620995},
	{0.489456, 0.612208, -0.620995},
	{0.489456, 0.612208, -0.620995},
	{0.489456, 0.612208, -0.620995},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{0.000000, 0.700307, -0.713842},
	{0.000000, 0.700307, -0.713842},
	{0.000000, 0.700307, -0.713842},
	{0.000000, 0.700307, -0.713842},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{0.000000, 0.700307, -0.713842},
	{0.000000, 0.700307, -0.713842},
	{0.000000, 0.700307, -0.713841},
	{0.000000, 0.700307, -0.713841},
	{0.000000, 0.700307, -0.713841},
	{0.000000, 0.700307, -0.713841},
	{-0.000000, 0.700308, -0.713841},
	{-0.000000, 0.700308, -0.713841},
	{-0.000000, 0.700308, -0.713841},
	{-0.000000, 0.700308, -0.713841},
	{-0.710974, 0.000000, -0.703218},
	{-0.710974, 0.000000, -0.703218},
	{-0.710974, 0.000000, -0.703218},
	{-0.710974, 0.000000, -0.703218},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.710974, 0.000000, -0.703218},
	{-0.710974, 0.000000, -0.703218},
	{-0.710974, 0.000000, -0.703218},
	{-0.710974, 0.000000, -0.703218},
	{-0.710974, 0.000000, -0.703218},
	{-0.710974, 0.000000, -0.703218},
	{-0.710974, 0.000000, -0.703218},
	{-0.710974, 0.000000, -0.703218},
	{-0.593218, -0.502560, -0.628908},
	{-0.593218, -0.502560, -0.628908},
	{-0.593218, -0.502560, -0.628908},
	{-0.593218, -0.502560, -0.628908},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{0.621757, -0.000000, -0.783210},
	{0.621757, -0.000000, -0.783210},
	{0.621757, -0.000000, -0.783210},
	{0.621757, -0.000000, -0.783210},
	{0.000000, 0.627601, -0.778535},
	{0.000000, 0.627601, -0.778535},
	{0.000000, 0.627601, -0.778535},
	{0.000000, 0.627601, -0.778535},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.763483, 0.000000, 0.645828},
	{-0.763483, 0.000000, 0.645828},
	{-0.763483, 0.000000, 0.645828},
	{-0.763483, 0.000000, 0.645828},
	{-0.783210, 0.621758, -0.000000},
	{-0.783210, 0.621758, -0.000000},
	{-0.783210, 0.621758, -0.000000},
	{-0.783210, 0.621758, -0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.625723, 0.493833, -0.603820},
	{-0.625723, 0.493833, -0.603820},
	{-0.625723, 0.493833, -0.603820},
	{-0.625723, 0.493833, -0.603820},
	{-0.711013, 0.000000, -0.703179},
	{-0.711013, 0.000000, -0.703179},
	{-0.711013, 0.000000, -0.703179},
	{-0.711013, 0.000000, -0.703179},
	{-0.711013, 0.000000, -0.703179},
	{-0.711013, 0.000000, -0.703179},
	{-0.711013, 0.000000, -0.703179},
	{-0.711013, 0.000000, -0.703179},
	{-0.711013, -0.000000, -0.703178},
	{-0.711013, -0.000000, -0.703178},
	{-0.711013, -0.000000, -0.703178},
	{-0.711013, -0.000000, -0.703178},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -0.783210, 0.621758},
	{0.000000, -0.783210, 0.621758},
	{0.000000, -0.783210, 0.621758},
	{0.000000, -0.783210, 0.621758},
	{0.618479, -0.785801, 0.000000},
	{0.618479, -0.785801, 0.000000},
	{0.618479, -0.785801, 0.000000},
	{0.618479, -0.785801, 0.000000},
	{-0.000000, -1.000000, -0.000001},
	{-0.000000, -1.000000, -0.000001},
	{-0.000000, -1.000000, -0.000001},
	{-0.000000, -1.000000, -0.000001},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{-0.593239, -0.560188, -0.578149},
	{-0.593239, -0.560188, -0.578149},
	{-0.593239, -0.560188, -0.578149},
	{0.489455, -0.620997, -0.612206},
	{0.489455, -0.620997, -0.612206},
	{0.489455, -0.620997, -0.612206},
	{0.489455, -0.620997, -0.612206},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000002, -1.000000, 0.000000},
	{0.000002, -1.000000, 0.000000},
	{0.000002, -1.000000, 0.000000},
	{0.000002, -1.000000, 0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -0.713843, -0.700305},
	{0.000000, -0.713843, -0.700305},
	{0.000000, -0.713843, -0.700305},
	{0.000000, -0.713843, -0.700305},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{-0.000001, -1.000000, -0.000001},
	{-0.000001, -1.000000, -0.000001},
	{-0.000001, -1.000000, -0.000001},
	{-0.000001, -1.000000, -0.000001},
	{-0.000001, -1.000000, -0.000001},
	{-0.000001, -1.000000, -0.000001},
	{0.000000, -1.000000, -0.000000},
	{-0.000001, -0.713843, -0.700306},
	{-0.000001, -0.713843, -0.700306},
	{-0.000001, -0.713843, -0.700306},
	{-0.000001, -0.713843, -0.700306},
	{0.000000, -0.713843, -0.700306},
	{0.000000, -0.713843, -0.700306},
	{0.000000, -0.713843, -0.700306},
	{0.000000, -0.713843, -0.700306},
	{0.000000, -0.713842, -0.700307},
	{0.000000, -0.713842, -0.700307},
	{0.000000, -0.713842, -0.700307},
	{0.000000, -0.713842, -0.700307},
	{-0.710974, -0.703218, 0.000000},
	{-0.710974, -0.703218, 0.000000},
	{-0.710974, -0.703218, 0.000000},
	{-0.710974, -0.703218, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.710974, -0.703218, 0.000000},
	{-0.710974, -0.703218, 0.000000},
	{-0.710974, -0.703218, 0.000000},
	{-0.710974, -0.703218, 0.000000},
	{-0.710974, -0.703218, -0.000001},
	{-0.710974, -0.703218, -0.000001},
	{-0.710974, -0.703218, -0.000001},
	{-0.710974, -0.703218, -0.000001},
	{-0.710974, -0.703218, 0.000000},
	{-0.710974, -0.703218, 0.000000},
	{-0.593218, -0.628909, 0.502560},
	{-0.593218, -0.628909, 0.502560},
	{-0.593218, -0.628909, 0.502560},
	{-0.593218, -0.628909, 0.502560},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{0.621757, 0.783211, -0.000000},
	{0.621757, 0.783211, -0.000000},
	{0.621757, 0.783211, -0.000000},
	{0.621757, 0.783211, -0.000000},
	{0.000000, 0.778535, -0.627601},
	{0.000000, 0.778535, -0.627601},
	{0.000000, 0.778535, -0.627601},
	{0.000000, 0.778535, -0.627601},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-1.000000, -0.000001, -0.000004},
	{-1.000000, -0.000001, -0.000004},
	{-1.000000, -0.000001, -0.000004},
	{-1.000000, -0.000001, -0.000004},
	{-1.000000, 0.000000, 0.000004},
	{-1.000000, 0.000000, 0.000004},
	{-1.000000, 0.000000, 0.000004},
	{-1.000000, 0.000000, 0.000004},
	{-0.763483, -0.645828, 0.000000},
	{-0.763483, -0.645828, 0.000000},
	{-0.763483, -0.645828, 0.000000},
	{-0.763483, -0.645828, 0.000000},
	{-0.783210, 0.000000, -0.621758},
	{-0.783210, 0.000000, -0.621758},
	{-0.783210, 0.000000, -0.621758},
	{-0.783210, 0.000000, -0.621758},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, -0.000000},
	{-0.625724, 0.603819, -0.493834},
	{-0.625724, 0.603819, -0.493834},
	{-0.625724, 0.603819, -0.493834},
	{-0.625724, 0.603819, -0.493834},
	{-0.711014, 0.703177, 0.000001},
	{-0.711014, 0.703177, 0.000001},
	{-0.711014, 0.703177, 0.000001},
	{-0.711014, 0.703177, 0.000001},
	{-0.711013, 0.703178, -0.000001},
	{-0.711013, 0.703178, -0.000001},
	{-0.711013, 0.703178, -0.000001},
	{-0.711013, 0.703178, -0.000001},
	{-0.711014, 0.703178, 0.000000},
	{-0.711014, 0.703178, 0.000000},
	{-0.711014, 0.703178, 0.000000},
	{-0.711014, 0.703178, 0.000000},
	{-0.711014, 0.703178, 0.000000},
	{-0.711014, 0.703178, 0.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, -0.621758, 0.783210},
	{-0.000000, -0.621758, 0.783210},
	{-0.000000, -0.621758, 0.783210},
	{-0.000000, -0.621758, 0.783210},
	{0.618479, 0.000000, 0.785802},
	{0.618479, 0.000000, 0.785802},
	{0.618479, 0.000000, 0.785802},
	{0.618479, 0.000000, 0.785802},
	{-0.000000, 0.000002, 1.000000},
	{-0.000000, 0.000002, 1.000000},
	{-0.000000, 0.000002, 1.000000},
	{-0.000000, 0.000002, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.593240, 0.578148, 0.560188},
	{-0.593240, 0.578148, 0.560188},
	{-0.593240, 0.578148, 0.560188},
	{0.489455, 0.612207, 0.620996},
	{0.489455, 0.612207, 0.620996},
	{0.489455, 0.612207, 0.620996},
	{0.489455, 0.612207, 0.620996},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000003, -0.000000, 1.000000},
	{0.000003, -0.000000, 1.000000},
	{0.000003, -0.000000, 1.000000},
	{0.000003, -0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.700307, 0.713842},
	{-0.000000, 0.700307, 0.713842},
	{-0.000000, 0.700307, 0.713842},
	{-0.000000, 0.700307, 0.713842},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000002, 0.000002, 1.000000},
	{-0.000002, 0.000002, 1.000000},
	{-0.000002, 0.000002, 1.000000},
	{-0.000002, 0.000002, 1.000000},
	{-0.000001, 0.000002, 1.000000},
	{-0.000001, 0.000002, 1.000000},
	{-0.000001, 0.000002, 1.000000},
	{-0.000001, 0.000002, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.700307, 0.713842},
	{-0.000000, 0.700307, 0.713842},
	{-0.000000, 0.700307, 0.713842},
	{-0.000000, 0.700307, 0.713842},
	{-0.000000, 0.700307, 0.713842},
	{-0.000000, 0.700307, 0.713842},
	{-0.710973, 0.000000, 0.703219},
	{-0.710973, 0.000000, 0.703219},
	{-0.710973, 0.000000, 0.703219},
	{-0.710973, 0.000000, 0.703219},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, -0.000006, -0.000009},
	{-1.000000, -0.000006, -0.000009},
	{-1.000000, -0.000006, -0.000009},
	{-1.000000, -0.000006, -0.000009},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000003, -0.000001},
	{-1.000000, 0.000003, -0.000001},
	{-1.000000, 0.000003, -0.000001},
	{-1.000000, 0.000003, -0.000001},
	{-1.000000, -0.000001, -0.000003},
	{-1.000000, -0.000001, -0.000003},
	{-1.000000, -0.000001, -0.000003},
	{-1.000000, -0.000001, -0.000003},
	{-1.000000, 0.000005, -0.000001},
	{-1.000000, 0.000005, -0.000001},
	{-1.000000, 0.000005, -0.000001},
	{-1.000000, 0.000005, -0.000001},
	{-1.000000, -0.000002, 0.000002},
	{-1.000000, -0.000002, 0.000002},
	{-1.000000, -0.000002, 0.000002},
	{-1.000000, -0.000002, 0.000002},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.710973, 0.000000, 0.703219},
	{-0.710973, 0.000000, 0.703219},
	{-0.710973, 0.000000, 0.703219},
	{-0.710973, 0.000000, 0.703219},
	{-0.710974, 0.000001, 0.703218},
	{-0.710974, 0.000001, 0.703218},
	{-0.710974, 0.000001, 0.703218},
	{-0.710974, 0.000001, 0.703218},
	{-0.710973, 0.000000, 0.703219},
	{-0.710973, 0.000000, 0.703219},
	{-0.593218, -0.502560, 0.628908},
	{-0.593218, -0.502560, 0.628908},
	{-0.593218, -0.502560, 0.628908},
	{-0.593218, -0.502560, 0.628908},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.621757, -0.000000, 0.783210},
	{0.621757, -0.000000, 0.783210},
	{0.621757, -0.000000, 0.783210},
	{0.621757, -0.000000, 0.783210},
	{0.000000, 0.627602, 0.778535},
	{0.000000, 0.627602, 0.778535},
	{0.000000, 0.627602, 0.778535},
	{0.000000, 0.627602, 0.778535},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.763484, -0.000000, -0.645827},
	{-0.763484, -0.000000, -0.645827},
	{-0.763484, -0.000000, -0.645827},
	{-0.763484, -0.000000, -0.645827},
	{-0.783209, 0.621758, 0.000000},
	{-0.783209, 0.621758, 0.000000},
	{-0.783209, 0.621758, 0.000000},
	{-0.783209, 0.621758, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.625723, 0.493834, 0.603820},
	{-0.625723, 0.493834, 0.603820},
	{-0.625723, 0.493834, 0.603820},
	{-0.625723, 0.493834, 0.603820},
	{-0.711013, -0.000000, 0.703179},
	{-0.711013, -0.000000, 0.703179},
	{-0.711013, -0.000000, 0.703179},
	{-0.711013, -0.000000, 0.703179},
	{-0.711013, -0.000000, 0.703179},
	{-0.711013, -0.000000, 0.703179},
	{-0.711013, -0.000000, 0.703179},
	{-0.711013, -0.000000, 0.703179},
	{-0.711014, -0.000000, 0.703178},
	{-0.711014, -0.000000, 0.703178},
	{-0.711014, -0.000000, 0.703178},
	{-0.711014, -0.000000, 0.703178},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{-0.000000, -0.783210, -0.621757},
	{-0.000000, -0.783210, -0.621757},
	{-0.000000, -0.783210, -0.621757},
	{-0.000000, -0.783210, -0.621757},
	{0.618479, -0.785801, 0.000000},
	{0.618479, -0.785801, 0.000000},
	{0.618479, -0.785801, 0.000000},
	{0.618479, -0.785801, 0.000000},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{-0.593240, -0.560189, 0.578148},
	{-0.593240, -0.560189, 0.578148},
	{-0.593240, -0.560189, 0.578148},
	{0.489455, -0.620996, 0.612207},
	{0.489455, -0.620996, 0.612207},
	{0.489455, -0.620996, 0.612207},
	{0.489455, -0.620996, 0.612207},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000002, -1.000000, 0.000000},
	{0.000002, -1.000000, 0.000000},
	{0.000002, -1.000000, 0.000000},
	{0.000002, -1.000000, 0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -0.713843, 0.700306},
	{0.000000, -0.713843, 0.700306},
	{0.000000, -0.713843, 0.700306},
	{0.000000, -0.713843, 0.700306},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{-0.000001, -1.000000, 0.000001},
	{-0.000001, -1.000000, 0.000001},
	{-0.000001, -1.000000, 0.000001},
	{-0.000001, -1.000000, 0.000001},
	{-0.000001, -1.000000, 0.000001},
	{-0.000001, -1.000000, 0.000001},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -0.713843, 0.700306},
	{0.000000, -0.713843, 0.700306},
	{0.000000, -0.713843, 0.700306},
	{0.000000, -0.713843, 0.700306},
	{0.000000, -0.713843, 0.700306},
	{0.000000, -0.713843, 0.700306},
	{-0.710974, -0.703218, 0.000000},
	{-0.710974, -0.703218, 0.000000},
	{-0.710974, -0.703218, 0.000000},
	{-0.710974, -0.703218, 0.000000},
	{-1.000000, 0.000000, -0.000003},
	{-1.000000, 0.000000, -0.000003},
	{-1.000000, 0.000000, -0.000003},
	{-1.000000, 0.000000, -0.000003},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, -0.000002},
	{-1.000000, 0.000000, -0.000002},
	{-1.000000, 0.000000, -0.000002},
	{-1.000000, 0.000000, -0.000002},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, -0.000001, -0.000002},
	{-1.000000, -0.000001, -0.000002},
	{-1.000000, -0.000001, -0.000002},
	{-1.000000, -0.000001, -0.000002},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000001, -0.000003},
	{-1.000000, 0.000001, -0.000003},
	{-1.000000, 0.000001, -0.000003},
	{-1.000000, 0.000001, -0.000003},
	{-1.000000, 0.000000, 0.000000},
	{-0.710975, -0.703217, -0.000002},
	{-0.710975, -0.703217, -0.000002},
	{-0.710975, -0.703217, -0.000002},
	{-0.710975, -0.703217, -0.000002},
	{-0.710976, -0.703216, 0.000001},
	{-0.710976, -0.703216, 0.000001},
	{-0.710976, -0.703216, 0.000001},
	{-0.710976, -0.703216, 0.000001},
	{-0.710974, -0.703218, 0.000000},
	{-0.710974, -0.703218, 0.000000},
	{-0.710974, -0.703218, 0.000000},
	{-0.710974, -0.703218, 0.000000},
	{-0.593220, -0.628908, -0.502558},
	{-0.593220, -0.628908, -0.502558},
	{-0.593220, -0.628908, -0.502558},
	{-0.593220, -0.628908, -0.502558},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.621757, 0.783211, 0.000000},
	{-0.621757, 0.783211, 0.000000},
	{-0.621757, 0.783211, 0.000000},
	{-0.621757, 0.783211, 0.000000},
	{0.000000, 0.778535, -0.627601},
	{0.000000, 0.778535, -0.627601},
	{0.000000, 0.778535, -0.627601},
	{0.000000, 0.778535, -0.627601},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{1.000000, 0.000001, 0.000004},
	{1.000000, 0.000001, 0.000004},
	{1.000000, 0.000001, 0.000004},
	{1.000000, 0.000001, 0.000004},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{0.763484, -0.645827, 0.000000},
	{0.763484, -0.645827, 0.000000},
	{0.763484, -0.645827, 0.000000},
	{0.763484, -0.645827, 0.000000},
	{0.783210, 0.000000, -0.621758},
	{0.783210, 0.000000, -0.621758},
	{0.783210, 0.000000, -0.621758},
	{0.783210, 0.000000, -0.621758},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, -0.000000},
	{0.625722, 0.603821, -0.493834},
	{0.625722, 0.603821, -0.493834},
	{0.625722, 0.603821, -0.493834},
	{0.625722, 0.603821, -0.493834},
	{0.711013, 0.703179, 0.000000},
	{0.711013, 0.703179, 0.000000},
	{0.711013, 0.703179, 0.000000},
	{0.711013, 0.703179, 0.000000},
	{0.711015, 0.703177, 0.000001},
	{0.711015, 0.703177, 0.000001},
	{0.711015, 0.703177, 0.000001},
	{0.711015, 0.703177, 0.000001},
	{0.711015, 0.703177, -0.000000},
	{0.711015, 0.703177, -0.000000},
	{0.711015, 0.703177, -0.000000},
	{0.711015, 0.703177, -0.000000},
	{0.711015, 0.703177, -0.000000},
	{0.711015, 0.703177, -0.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000000, -0.621757, 0.783210},
	{0.000000, -0.621757, 0.783210},
	{0.000000, -0.621757, 0.783210},
	{0.000000, -0.621757, 0.783210},
	{-0.618479, 0.000000, 0.785801},
	{-0.618479, 0.000000, 0.785801},
	{-0.618479, 0.000000, 0.785801},
	{-0.618479, 0.000000, 0.785801},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.593241, 0.578149, 0.560187},
	{0.593241, 0.578149, 0.560187},
	{0.593241, 0.578149, 0.560187},
	{-0.489456, 0.612207, 0.620995},
	{-0.489456, 0.612207, 0.620995},
	{-0.489456, 0.612207, 0.620995},
	{-0.489456, 0.612207, 0.620995},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000001, 0.700307, 0.713842},
	{0.000001, 0.700307, 0.713842},
	{0.000001, 0.700307, 0.713842},
	{0.000001, 0.700307, 0.713842},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000000, 0.700308, 0.713841},
	{0.000000, 0.700308, 0.713841},
	{0.000000, 0.700308, 0.713841},
	{0.000000, 0.700308, 0.713841},
	{0.000000, 0.700308, 0.713841},
	{0.000000, 0.700308, 0.713841},
	{0.000000, 0.700308, 0.713841},
	{0.000000, 0.700308, 0.713841},
	{0.710975, 0.000000, 0.703217},
	{0.710975, 0.000000, 0.703217},
	{0.710975, 0.000000, 0.703217},
	{0.710975, 0.000000, 0.703217},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, 0.000006, 0.000009},
	{1.000000, 0.000006, 0.000009},
	{1.000000, 0.000006, 0.000009},
	{1.000000, 0.000006, 0.000009},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000003, 0.000001},
	{1.000000, -0.000003, 0.000001},
	{1.000000, -0.000003, 0.000001},
	{1.000000, -0.000003, 0.000001},
	{1.000000, 0.000001, 0.000003},
	{1.000000, 0.000001, 0.000003},
	{1.000000, 0.000001, 0.000003},
	{1.000000, 0.000001, 0.000003},
	{1.000000, -0.000005, 0.000001},
	{1.000000, -0.000005, 0.000001},
	{1.000000, -0.000005, 0.000001},
	{1.000000, -0.000005, 0.000001},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{0.710975, 0.000000, 0.703217},
	{0.710975, 0.000000, 0.703217},
	{0.710975, 0.000000, 0.703217},
	{0.710975, 0.000000, 0.703217},
	{0.710975, 0.000000, 0.703217},
	{0.710975, 0.000000, 0.703217},
	{0.710975, 0.000000, 0.703217},
	{0.710975, 0.000000, 0.703217},
	{0.593219, -0.502560, 0.628908},
	{0.593219, -0.502560, 0.628908},
	{0.593219, -0.502560, 0.628908},
	{0.593219, -0.502560, 0.628908},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.621757, -0.000000, 0.783210},
	{-0.621757, -0.000000, 0.783210},
	{-0.621757, -0.000000, 0.783210},
	{-0.621757, -0.000000, 0.783210},
	{0.000000, 0.627602, 0.778535},
	{0.000000, 0.627602, 0.778535},
	{0.000000, 0.627602, 0.778535},
	{0.000000, 0.627602, 0.778535},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{0.763483, 0.000000, -0.645828},
	{0.763483, 0.000000, -0.645828},
	{0.763483, 0.000000, -0.645828},
	{0.763483, 0.000000, -0.645828},
	{0.783210, 0.621757, -0.000000},
	{0.783210, 0.621757, -0.000000},
	{0.783210, 0.621757, -0.000000},
	{0.783210, 0.621757, -0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.625725, 0.493834, 0.603818},
	{0.625725, 0.493834, 0.603818},
	{0.625725, 0.493834, 0.603818},
	{0.625725, 0.493834, 0.603818},
	{0.711014, -0.000000, 0.703178},
	{0.711014, -0.000000, 0.703178},
	{0.711014, -0.000000, 0.703178},
	{0.711014, -0.000000, 0.703178},
	{0.711014, -0.000000, 0.703178},
	{0.711014, -0.000000, 0.703178},
	{0.711015, -0.000000, 0.703177},
	{0.711015, -0.000000, 0.703177},
	{0.711015, -0.000000, 0.703177},
	{0.711015, -0.000000, 0.703177},
	{0.711015, -0.000000, 0.703177},
	{0.711015, -0.000000, 0.703177},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{-0.000000, -0.783210, -0.621757},
	{-0.000000, -0.783210, -0.621757},
	{-0.000000, -0.783210, -0.621757},
	{-0.000000, -0.783210, -0.621757},
	{-0.618479, -0.785801, 0.000000},
	{-0.618479, -0.785801, 0.000000},
	{-0.618479, -0.785801, 0.000000},
	{-0.618479, -0.785801, 0.000000},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.593241, -0.560187, 0.578148},
	{0.593241, -0.560187, 0.578148},
	{0.593241, -0.560187, 0.578148},
	{-0.489455, -0.620997, 0.612206},
	{-0.489455, -0.620997, 0.612206},
	{-0.489455, -0.620997, 0.612206},
	{-0.489455, -0.620997, 0.612206},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{-0.000002, -1.000000, 0.000000},
	{-0.000002, -1.000000, 0.000000},
	{-0.000002, -1.000000, 0.000000},
	{-0.000002, -1.000000, 0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000001, -0.713843, 0.700306},
	{0.000001, -0.713843, 0.700306},
	{0.000001, -0.713843, 0.700306},
	{0.000001, -0.713843, 0.700306},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000001, -1.000000, 0.000001},
	{0.000001, -1.000000, 0.000001},
	{0.000001, -1.000000, 0.000001},
	{0.000001, -1.000000, 0.000001},
	{0.000001, -1.000000, 0.000001},
	{0.000001, -1.000000, 0.000001},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -0.713843, 0.700306},
	{0.000000, -0.713843, 0.700306},
	{0.000000, -0.713843, 0.700306},
	{0.000000, -0.713843, 0.700306},
	{0.000000, -0.713843, 0.700306},
	{0.000000, -0.713843, 0.700306},
	{0.000000, -0.713842, 0.700307},
	{0.000000, -0.713842, 0.700307},
	{0.000000, -0.713842, 0.700307},
	{0.000000, -0.713842, 0.700307},
	{0.710975, -0.703217, 0.000000},
	{0.710975, -0.703217, 0.000000},
	{0.710975, -0.703217, 0.000000},
	{0.710975, -0.703217, 0.000000},
	{1.000000, -0.000000, 0.000003},
	{1.000000, -0.000000, 0.000003},
	{1.000000, -0.000000, 0.000003},
	{1.000000, -0.000000, 0.000003},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000002},
	{1.000000, -0.000000, 0.000002},
	{1.000000, -0.000000, 0.000002},
	{1.000000, -0.000000, 0.000002},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, 0.000001, 0.000002},
	{1.000000, 0.000001, 0.000002},
	{1.000000, 0.000001, 0.000002},
	{1.000000, 0.000001, 0.000002},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000001, 0.000003},
	{1.000000, -0.000001, 0.000003},
	{1.000000, -0.000001, 0.000003},
	{1.000000, -0.000001, 0.000003},
	{1.000000, -0.000000, 0.000000},
	{0.710975, -0.703218, 0.000002},
	{0.710975, -0.703218, 0.000002},
	{0.710975, -0.703218, 0.000002},
	{0.710975, -0.703218, 0.000002},
	{0.710974, -0.703218, 0.000001},
	{0.710974, -0.703218, 0.000001},
	{0.710974, -0.703218, 0.000001},
	{0.710974, -0.703218, 0.000001},
	{0.710976, -0.703217, 0.000000},
	{0.710976, -0.703217, 0.000000},
	{0.710976, -0.703217, 0.000000},
	{0.710976, -0.703217, 0.000000},
	{0.593218, -0.628909, -0.502559},
	{0.593218, -0.628909, -0.502559},
	{0.593218, -0.628909, -0.502559},
	{0.593218, -0.628909, -0.502559},
	{-0.000001, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{-0.000001, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{-0.896172, -0.443708, 0.000000},
	{-0.896172, -0.443708, 0.000000},
	{-0.896172, -0.443708, 0.000000},
	{-0.896172, -0.443708, 0.000000},
	{0.896529, -0.442986, -0.000001},
	{0.896529, -0.442986, -0.000001},
	{0.896529, -0.442986, -0.000001},
	{0.896529, -0.442986, -0.000001},
	{0.630906, -0.533044, 0.563757},
	{0.630906, -0.533044, 0.563757},
	{0.630906, -0.533044, 0.563757},
	{0.630906, -0.533044, 0.563757},
	{-0.616629, -0.532810, 0.579553},
	{-0.616629, -0.532810, 0.579553},
	{-0.616629, -0.532810, 0.579553},
	{-0.616629, -0.532810, 0.579553},
	{-0.616631, 0.579553, -0.532808},
	{-0.616631, 0.579553, -0.532808},
	{-0.616631, 0.579553, -0.532808},
	{-0.616631, 0.579553, -0.532808},
	{0.630906, 0.563757, -0.533044},
	{0.630906, 0.563757, -0.533044},
	{0.630906, 0.563757, -0.533044},
	{0.630906, 0.563757, -0.533044},
	{0.896529, -0.000000, -0.442985},
	{0.896529, -0.000000, -0.442985},
	{0.896529, -0.000000, -0.442985},
	{0.896529, -0.000000, -0.442985},
	{-0.896172, -0.000000, -0.443706},
	{-0.896172, -0.000000, -0.443706},
	{-0.896172, -0.000000, -0.443706},
	{-0.896172, -0.000000, -0.443706},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{0.000001, -0.000000, -1.000000},
	{0.000001, -0.000000, -1.000000},
	{0.000001, -0.000000, -1.000000},
	{0.000001, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.818880, -0.405856, -0.405854},
	{-0.818880, -0.405856, -0.405854},
	{-0.818880, -0.405856, -0.405854},
	{-0.818880, -0.405856, -0.405854},
	{0.000001, -0.707838, -0.706375},
	{0.000001, -0.707838, -0.706375},
	{0.000001, -0.707838, -0.706375},
	{0.000001, -0.707838, -0.706375},
	{-0.000000, -0.707837, -0.706375},
	{-0.000000, -0.707837, -0.706375},
	{-0.000000, -0.707837, -0.706375},
	{-0.000000, -0.707837, -0.706375},
	{0.000000, -0.707837, -0.706376},
	{0.000000, -0.707837, -0.706376},
	{0.000000, -0.707837, -0.706376},
	{0.000000, -0.707837, -0.706376},
	{-0.000001, -0.707837, -0.706376},
	{-0.000001, -0.707837, -0.706376},
	{-0.000001, -0.707837, -0.706376},
	{-0.000001, -0.707837, -0.706376},
	{0.000000, -0.707837, -0.706376},
	{0.000000, -0.707837, -0.706376},
	{0.000000, -0.707837, -0.706376},
	{0.000000, -0.707837, -0.706376},
	{0.000000, -0.707836, -0.706377},
	{0.000000, -0.707836, -0.706377},
	{0.000000, -0.707836, -0.706377},
	{0.000000, -0.707836, -0.706377},
	{0.819425, -0.405305, -0.405303},
	{0.819425, -0.405305, -0.405303},
	{0.819425, -0.405305, -0.405303},
	{0.819425, -0.405305, -0.405303},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{0.000001, 1.000000, -0.000000},
	{0.000001, 1.000000, -0.000000},
	{0.000001, 1.000000, -0.000000},
	{0.000001, 1.000000, -0.000000},
	{0.000001, 1.000000, -0.000000},
	{0.000001, 1.000000, -0.000000},
	{0.000001, 1.000000, -0.000000},
	{0.000001, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{0.000001, 1.000000, -0.000000},
	{0.000001, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{0.896172, 0.443707, 0.000000},
	{0.896172, 0.443707, 0.000000},
	{0.896172, 0.443707, 0.000000},
	{0.896172, 0.443707, 0.000000},
	{-0.896528, 0.442986, -0.000000},
	{-0.896528, 0.442986, -0.000000},
	{-0.896528, 0.442986, -0.000000},
	{-0.896528, 0.442986, -0.000000},
	{-0.630906, 0.533046, 0.563756},
	{-0.630906, 0.533046, 0.563756},
	{-0.630906, 0.533046, 0.563756},
	{-0.630906, 0.533046, 0.563756},
	{0.616631, 0.532810, 0.579551},
	{0.616631, 0.532810, 0.579551},
	{0.616631, 0.532810, 0.579551},
	{0.616631, 0.532810, 0.579551},
	{0.616631, -0.579553, -0.532809},
	{0.616631, -0.579553, -0.532809},
	{0.616631, -0.579553, -0.532809},
	{0.616631, -0.579553, -0.532809},
	{-0.630906, -0.563756, -0.533045},
	{-0.630906, -0.563756, -0.533045},
	{-0.630906, -0.563756, -0.533045},
	{-0.630906, -0.563756, -0.533045},
	{-0.896528, 0.000000, -0.442986},
	{-0.896528, 0.000000, -0.442986},
	{-0.896528, 0.000000, -0.442986},
	{-0.896528, 0.000000, -0.442986},
	{0.896172, -0.000000, -0.443706},
	{0.896172, -0.000000, -0.443706},
	{0.896172, -0.000000, -0.443706},
	{0.896172, -0.000000, -0.443706},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000002, 0.000000, -1.000000},
	{-0.000002, 0.000000, -1.000000},
	{-0.000002, 0.000000, -1.000000},
	{-0.000002, 0.000000, -1.000000},
	{0.000002, -0.000000, -1.000000},
	{0.000002, -0.000000, -1.000000},
	{0.000002, -0.000000, -1.000000},
	{0.000002, -0.000000, -1.000000},
	{0.818879, 0.405856, -0.405854},
	{0.818879, 0.405856, -0.405854},
	{0.818879, 0.405856, -0.405854},
	{0.818879, 0.405856, -0.405854},
	{-0.000001, 0.707837, -0.706376},
	{-0.000001, 0.707837, -0.706376},
	{-0.000001, 0.707837, -0.706376},
	{-0.000001, 0.707837, -0.706376},
	{0.000001, 0.707836, -0.706377},
	{0.000001, 0.707836, -0.706377},
	{0.000001, 0.707836, -0.706377},
	{0.000001, 0.707836, -0.706377},
	{0.000000, 0.707836, -0.706377},
	{0.000000, 0.707836, -0.706377},
	{0.000000, 0.707836, -0.706377},
	{0.000000, 0.707836, -0.706377},
	{0.000000, 0.707836, -0.706377},
	{0.000000, 0.707836, -0.706377},
	{0.000000, 0.707836, -0.706377},
	{0.000000, 0.707836, -0.706377},
	{0.000003, 0.707836, -0.706377},
	{0.000003, 0.707836, -0.706377},
	{0.000003, 0.707836, -0.706377},
	{0.000003, 0.707836, -0.706377},
	{-0.819425, 0.405304, -0.405304},
	{-0.819425, 0.405304, -0.405304},
	{-0.819425, 0.405304, -0.405304},
	{-0.819425, 0.405304, -0.405304},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{0.443707, -0.896172, 0.000000},
	{0.443707, -0.896172, 0.000000},
	{0.443707, -0.896172, 0.000000},
	{0.443707, -0.896172, 0.000000},
	{0.442986, 0.896528, -0.000000},
	{0.442986, 0.896528, -0.000000},
	{0.442986, 0.896528, -0.000000},
	{0.442986, 0.896528, -0.000000},
	{0.533045, 0.630906, 0.563756},
	{0.533045, 0.630906, 0.563756},
	{0.533045, 0.630906, 0.563756},
	{0.533045, 0.630906, 0.563756},
	{0.532809, -0.616631, 0.579552},
	{0.532809, -0.616631, 0.579552},
	{0.532809, -0.616631, 0.579552},
	{0.532809, -0.616631, 0.579552},
	{-0.579553, -0.616631, -0.532809},
	{-0.579553, -0.616631, -0.532809},
	{-0.579553, -0.616631, -0.532809},
	{-0.579553, -0.616631, -0.532809},
	{-0.563756, 0.630907, -0.533044},
	{-0.563756, 0.630907, -0.533044},
	{-0.563756, 0.630907, -0.533044},
	{-0.563756, 0.630907, -0.533044},
	{0.000001, 0.896529, -0.442986},
	{0.000001, 0.896529, -0.442986},
	{0.000001, 0.896529, -0.442986},
	{0.000001, 0.896529, -0.442986},
	{0.000000, -0.896172, -0.443707},
	{0.000000, -0.896172, -0.443707},
	{0.000000, -0.896172, -0.443707},
	{0.000000, -0.896172, -0.443707},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{0.405854, -0.818880, -0.405855},
	{0.405854, -0.818880, -0.405855},
	{0.405854, -0.818880, -0.405855},
	{0.405854, -0.818880, -0.405855},
	{0.707836, 0.000000, -0.706377},
	{0.707836, 0.000000, -0.706377},
	{0.707836, 0.000000, -0.706377},
	{0.707836, 0.000000, -0.706377},
	{0.707836, 0.000000, -0.706377},
	{0.707836, 0.000000, -0.706377},
	{0.707836, 0.000000, -0.706377},
	{0.707836, 0.000000, -0.706377},
	{0.707836, 0.000000, -0.706377},
	{0.707836, 0.000000, -0.706377},
	{0.707836, 0.000000, -0.706377},
	{0.707836, 0.000000, -0.706377},
	{0.707836, 0.000000, -0.706377},
	{0.707836, 0.000000, -0.706377},
	{0.405304, 0.819425, -0.405304},
	{0.405304, 0.819425, -0.405304},
	{0.405304, 0.819425, -0.405304},
	{0.405304, 0.819425, -0.405304},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, -0.000001, -0.000001},
	{-1.000000, -0.000001, -0.000001},
	{-1.000000, -0.000001, -0.000001},
	{-1.000000, -0.000001, -0.000001},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, -0.000002, -0.000001},
	{-1.000000, -0.000002, -0.000001},
	{-1.000000, -0.000002, -0.000001},
	{-1.000000, -0.000002, -0.000001},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.443706, 0.896172, -0.000001},
	{-0.443706, 0.896172, -0.000001},
	{-0.443706, 0.896172, -0.000001},
	{-0.443706, 0.896172, -0.000001},
	{-0.442986, -0.896528, -0.000000},
	{-0.442986, -0.896528, -0.000000},
	{-0.442986, -0.896528, -0.000000},
	{-0.442986, -0.896528, -0.000000},
	{-0.533044, -0.630907, 0.563756},
	{-0.533044, -0.630907, 0.563756},
	{-0.533044, -0.630907, 0.563756},
	{-0.533044, -0.630907, 0.563756},
	{-0.532808, 0.616632, 0.579552},
	{-0.532808, 0.616632, 0.579552},
	{-0.532808, 0.616632, 0.579552},
	{-0.532808, 0.616632, 0.579552},
	{0.579552, 0.616631, -0.532809},
	{0.579552, 0.616631, -0.532809},
	{0.579552, 0.616631, -0.532809},
	{0.579552, 0.616631, -0.532809},
	{0.563756, -0.630906, -0.533045},
	{0.563756, -0.630906, -0.533045},
	{0.563756, -0.630906, -0.533045},
	{0.563756, -0.630906, -0.533045},
	{-0.000000, -0.896528, -0.442986},
	{-0.000000, -0.896528, -0.442986},
	{-0.000000, -0.896528, -0.442986},
	{-0.000000, -0.896528, -0.442986},
	{0.000000, 0.896172, -0.443707},
	{0.000000, 0.896172, -0.443707},
	{0.000000, 0.896172, -0.443707},
	{0.000000, 0.896172, -0.443707},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.405854, 0.818880, -0.405856},
	{-0.405854, 0.818880, -0.405856},
	{-0.405854, 0.818880, -0.405856},
	{-0.405854, 0.818880, -0.405856},
	{-0.707836, 0.000000, -0.706377},
	{-0.707836, 0.000000, -0.706377},
	{-0.707836, 0.000000, -0.706377},
	{-0.707836, 0.000000, -0.706377},
	{-0.707837, 0.000001, -0.706376},
	{-0.707837, 0.000001, -0.706376},
	{-0.707837, 0.000001, -0.706376},
	{-0.707837, 0.000001, -0.706376},
	{-0.707837, 0.000000, -0.706376},
	{-0.707837, 0.000000, -0.706376},
	{-0.707837, 0.000000, -0.706376},
	{-0.707837, 0.000000, -0.706376},
	{-0.707837, -0.000001, -0.706376},
	{-0.707837, -0.000001, -0.706376},
	{-0.707837, -0.000001, -0.706376},
	{-0.707837, -0.000001, -0.706376},
	{-0.707836, 0.000000, -0.706377},
	{-0.707836, 0.000000, -0.706377},
	{-0.707836, 0.000000, -0.706377},
	{-0.707836, 0.000000, -0.706377},
	{-0.707836, 0.000000, -0.706377},
	{-0.707836, 0.000000, -0.706377},
	{-0.405305, -0.819424, -0.405305},
	{-0.405305, -0.819424, -0.405305},
	{-0.405305, -0.819424, -0.405305},
	{-0.405305, -0.819424, -0.405305},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000001},
	{-1.000000, 0.000000, 0.000001},
	{-1.000000, 0.000000, 0.000001},
	{-1.000000, 0.000000, 0.000001},
	{-1.000000, 0.000000, -0.000001},
	{-1.000000, 0.000000, -0.000001},
	{-1.000000, 0.000000, -0.000001},
	{-1.000000, 0.000000, -0.000001},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.443705, -0.000000, -0.896173},
	{-0.443705, -0.000000, -0.896173},
	{-0.443705, -0.000000, -0.896173},
	{-0.443705, -0.000000, -0.896173},
	{-0.442987, -0.000000, 0.896528},
	{-0.442987, -0.000000, 0.896528},
	{-0.442987, -0.000000, 0.896528},
	{-0.442987, -0.000000, 0.896528},
	{-0.533045, 0.563756, 0.630906},
	{-0.533045, 0.563756, 0.630906},
	{-0.533045, 0.563756, 0.630906},
	{-0.533045, 0.563756, 0.630906},
	{-0.532809, 0.579552, -0.616631},
	{-0.532809, 0.579552, -0.616631},
	{-0.532809, 0.579552, -0.616631},
	{-0.532809, 0.579552, -0.616631},
	{0.579553, -0.532808, -0.616631},
	{0.579553, -0.532808, -0.616631},
	{0.579553, -0.532808, -0.616631},
	{0.579553, -0.532808, -0.616631},
	{0.563755, -0.533045, 0.630907},
	{0.563755, -0.533045, 0.630907},
	{0.563755, -0.533045, 0.630907},
	{0.563755, -0.533045, 0.630907},
	{-0.000001, -0.442986, 0.896528},
	{-0.000001, -0.442986, 0.896528},
	{-0.000001, -0.442986, 0.896528},
	{-0.000001, -0.442986, 0.896528},
	{0.000000, -0.443707, -0.896172},
	{0.000000, -0.443707, -0.896172},
	{0.000000, -0.443707, -0.896172},
	{0.000000, -0.443707, -0.896172},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000001, -1.000000, 0.000003},
	{0.000001, -1.000000, 0.000003},
	{0.000001, -1.000000, 0.000003},
	{0.000001, -1.000000, 0.000003},
	{-0.405853, -0.405856, -0.818880},
	{-0.405853, -0.405856, -0.818880},
	{-0.405853, -0.405856, -0.818880},
	{-0.405853, -0.405856, -0.818880},
	{-0.707836, -0.706377, 0.000000},
	{-0.707836, -0.706377, 0.000000},
	{-0.707836, -0.706377, 0.000000},
	{-0.707836, -0.706377, 0.000000},
	{-0.707837, -0.706376, -0.000001},
	{-0.707837, -0.706376, -0.000001},
	{-0.707837, -0.706376, -0.000001},
	{-0.707837, -0.706376, -0.000001},
	{-0.707837, -0.706376, -0.000000},
	{-0.707837, -0.706376, -0.000000},
	{-0.707837, -0.706376, -0.000000},
	{-0.707837, -0.706376, -0.000000},
	{-0.707837, -0.706376, -0.000000},
	{-0.707837, -0.706376, -0.000000},
	{-0.707837, -0.706376, -0.000000},
	{-0.707837, -0.706376, -0.000000},
	{-0.707837, -0.706376, 0.000001},
	{-0.707837, -0.706376, 0.000001},
	{-0.707837, -0.706376, 0.000001},
	{-0.707837, -0.706376, 0.000001},
	{-0.405304, -0.405305, 0.819425},
	{-0.405304, -0.405305, 0.819425},
	{-0.405304, -0.405305, 0.819425},
	{-0.405304, -0.405305, 0.819425},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.443707, 0.000000, 0.896172},
	{-0.443707, 0.000000, 0.896172},
	{-0.443707, 0.000000, 0.896172},
	{-0.443707, 0.000000, 0.896172},
	{-0.442985, 0.000000, -0.896529},
	{-0.442985, 0.000000, -0.896529},
	{-0.442985, 0.000000, -0.896529},
	{-0.442985, 0.000000, -0.896529},
	{-0.533043, -0.563757, -0.630907},
	{-0.533043, -0.563757, -0.630907},
	{-0.533043, -0.563757, -0.630907},
	{-0.533043, -0.563757, -0.630907},
	{-0.532809, -0.579553, 0.616630},
	{-0.532809, -0.579553, 0.616630},
	{-0.532809, -0.579553, 0.616630},
	{-0.532809, -0.579553, 0.616630},
	{0.579552, 0.532808, 0.616632},
	{0.579552, 0.532808, 0.616632},
	{0.579552, 0.532808, 0.616632},
	{0.579552, 0.532808, 0.616632},
	{0.563757, 0.533043, -0.630907},
	{0.563757, 0.533043, -0.630907},
	{0.563757, 0.533043, -0.630907},
	{0.563757, 0.533043, -0.630907},
	{-0.000000, 0.442985, -0.896529},
	{-0.000000, 0.442985, -0.896529},
	{-0.000000, 0.442985, -0.896529},
	{-0.000000, 0.442985, -0.896529},
	{-0.000001, 0.443707, 0.896172},
	{-0.000001, 0.443707, 0.896172},
	{-0.000001, 0.443707, 0.896172},
	{-0.000001, 0.443707, 0.896172},
	{-0.000001, 1.000000, -0.000001},
	{-0.000001, 1.000000, -0.000001},
	{-0.000001, 1.000000, -0.000001},
	{-0.000001, 1.000000, -0.000001},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, 0.000001},
	{-0.000001, 1.000000, -0.000001},
	{-0.000001, 1.000000, -0.000001},
	{-0.000001, 1.000000, -0.000001},
	{-0.000001, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.405856, 0.405856, 0.818879},
	{-0.405856, 0.405856, 0.818879},
	{-0.405856, 0.405856, 0.818879},
	{-0.405856, 0.405856, 0.818879},
	{-0.707836, 0.706377, 0.000000},
	{-0.707836, 0.706377, 0.000000},
	{-0.707836, 0.706377, 0.000000},
	{-0.707836, 0.706377, 0.000000},
	{-0.707837, 0.706376, 0.000000},
	{-0.707837, 0.706376, 0.000000},
	{-0.707837, 0.706376, 0.000000},
	{-0.707837, 0.706376, 0.000000},
	{-0.707837, 0.706376, 0.000000},
	{-0.707837, 0.706376, 0.000000},
	{-0.707837, 0.706376, 0.000000},
	{-0.707837, 0.706376, 0.000000},
	{-0.707837, 0.706376, 0.000001},
	{-0.707837, 0.706376, 0.000001},
	{-0.707837, 0.706376, 0.000001},
	{-0.707837, 0.706376, 0.000001},
	{-0.707836, 0.706377, -0.000001},
	{-0.707836, 0.706377, -0.000001},
	{-0.707836, 0.706377, -0.000001},
	{-0.707836, 0.706377, -0.000001},
	{-0.405303, 0.405305, -0.819425},
	{-0.405303, 0.405305, -0.819425},
	{-0.405303, 0.405305, -0.819425},
	{-0.405303, 0.405305, -0.819425},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000001},
	{1.000000, -0.000000, 0.000001},
	{1.000000, -0.000000, 0.000001},
	{1.000000, -0.000000, 0.000001},
	{1.000000, -0.000000, 0.000001},
	{1.000000, -0.000000, 0.000001},
	{0.443707, -0.000000, -0.896172},
	{0.443707, -0.000000, -0.896172},
	{0.443707, -0.000000, -0.896172},
	{0.443707, -0.000000, -0.896172},
	{0.442986, 0.000000, 0.896528},
	{0.442986, 0.000000, 0.896528},
	{0.442986, 0.000000, 0.896528},
	{0.442986, 0.000000, 0.896528},
	{0.533044, -0.563757, 0.630906},
	{0.533044, -0.563757, 0.630906},
	{0.533044, -0.563757, 0.630906},
	{0.533044, -0.563757, 0.630906},
	{0.532809, -0.579552, -0.616631},
	{0.532809, -0.579552, -0.616631},
	{0.532809, -0.579552, -0.616631},
	{0.532809, -0.579552, -0.616631},
	{-0.579552, 0.532809, -0.616631},
	{-0.579552, 0.532809, -0.616631},
	{-0.579552, 0.532809, -0.616631},
	{-0.579552, 0.532809, -0.616631},
	{-0.563757, 0.533044, 0.630906},
	{-0.563757, 0.533044, 0.630906},
	{-0.563757, 0.533044, 0.630906},
	{-0.563757, 0.533044, 0.630906},
	{-0.000000, 0.442986, 0.896529},
	{-0.000000, 0.442986, 0.896529},
	{-0.000000, 0.442986, 0.896529},
	{-0.000000, 0.442986, 0.896529},
	{0.000000, 0.443707, -0.896172},
	{0.000000, 0.443707, -0.896172},
	{0.000000, 0.443707, -0.896172},
	{0.000000, 0.443707, -0.896172},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000001},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{0.405855, 0.405855, -0.818880},
	{0.405855, 0.405855, -0.818880},
	{0.405855, 0.405855, -0.818880},
	{0.405855, 0.405855, -0.818880},
	{0.707836, 0.706377, -0.000001},
	{0.707836, 0.706377, -0.000001},
	{0.707836, 0.706377, -0.000001},
	{0.707836, 0.706377, -0.000001},
	{0.707836, 0.706377, 0.000000},
	{0.707836, 0.706377, 0.000000},
	{0.707836, 0.706377, 0.000000},
	{0.707836, 0.706377, 0.000000},
	{0.707836, 0.706377, 0.000001},
	{0.707836, 0.706377, 0.000001},
	{0.707836, 0.706377, 0.000001},
	{0.707836, 0.706377, 0.000001},
	{0.707837, 0.706376, 0.000000},
	{0.707837, 0.706376, 0.000000},
	{0.707837, 0.706376, 0.000000},
	{0.707837, 0.706376, 0.000000},
	{0.707837, 0.706376, 0.000000},
	{0.707837, 0.706376, 0.000000},
	{0.707837, 0.706376, 0.000000},
	{0.707837, 0.706376, 0.000000},
	{0.405305, 0.405304, 0.819425},
	{0.405305, 0.405304, 0.819425},
	{0.405305, 0.405304, 0.819425},
	{0.405305, 0.405304, 0.819425},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, 0.000001, 0.000001},
	{1.000000, 0.000001, 0.000001},
	{1.000000, 0.000001, 0.000001},
	{1.000000, 0.000001, 0.000001},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000001},
	{1.000000, -0.000000, 0.000001},
	{1.000000, -0.000000, 0.000001},
	{1.000000, -0.000000, 0.000001},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{0.443707, 0.000001, 0.896172},
	{0.443707, 0.000001, 0.896172},
	{0.443707, 0.000001, 0.896172},
	{0.443707, 0.000001, 0.896172},
	{0.442986, -0.000000, -0.896528},
	{0.442986, -0.000000, -0.896528},
	{0.442986, -0.000000, -0.896528},
	{0.442986, -0.000000, -0.896528},
	{0.533044, 0.563757, -0.630906},
	{0.533044, 0.563757, -0.630906},
	{0.533044, 0.563757, -0.630906},
	{0.533044, 0.563757, -0.630906},
	{0.532809, 0.579552, 0.616631},
	{0.532809, 0.579552, 0.616631},
	{0.532809, 0.579552, 0.616631},
	{0.532809, 0.579552, 0.616631},
	{-0.579553, -0.532809, 0.616630},
	{-0.579553, -0.532809, 0.616630},
	{-0.579553, -0.532809, 0.616630},
	{-0.579553, -0.532809, 0.616630},
	{-0.563756, -0.533044, -0.630906},
	{-0.563756, -0.533044, -0.630906},
	{-0.563756, -0.533044, -0.630906},
	{-0.563756, -0.533044, -0.630906},
	{0.000001, -0.442986, -0.896529},
	{0.000001, -0.442986, -0.896529},
	{0.000001, -0.442986, -0.896529},
	{0.000001, -0.442986, -0.896529},
	{-0.000000, -0.443707, 0.896172},
	{-0.000000, -0.443707, 0.896172},
	{-0.000000, -0.443707, 0.896172},
	{-0.000000, -0.443707, 0.896172},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, 0.000001},
	{0.000000, -1.000000, -0.000003},
	{0.000000, -1.000000, -0.000003},
	{0.000000, -1.000000, -0.000003},
	{0.000000, -1.000000, -0.000003},
	{0.000001, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.405856, -0.405855, 0.818879},
	{0.405856, -0.405855, 0.818879},
	{0.405856, -0.405855, 0.818879},
	{0.405856, -0.405855, 0.818879},
	{0.707837, -0.706376, 0.000000},
	{0.707837, -0.706376, 0.000000},
	{0.707837, -0.706376, 0.000000},
	{0.707837, -0.706376, 0.000000},
	{0.707837, -0.706375, 0.000001},
	{0.707837, -0.706375, 0.000001},
	{0.707837, -0.706375, 0.000001},
	{0.707837, -0.706375, 0.000001},
	{0.707837, -0.706376, 0.000000},
	{0.707837, -0.706376, 0.000000},
	{0.707837, -0.706376, 0.000000},
	{0.707837, -0.706376, 0.000000},
	{0.707836, -0.706377, 0.000000},
	{0.707836, -0.706377, 0.000000},
	{0.707836, -0.706377, 0.000000},
	{0.707836, -0.706377, 0.000000},
	{0.707836, -0.706377, 0.000000},
	{0.707836, -0.706377, 0.000000},
	{0.707836, -0.706377, 0.000000},
	{0.707836, -0.706377, 0.000000},
	{0.405305, -0.405306, -0.819424},
	{0.405305, -0.405306, -0.819424},
	{0.405305, -0.405306, -0.819424},
	{0.405305, -0.405306, -0.819424},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{-0.000001, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{0.000001, -1.000000, -0.000000},
	{-0.000001, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{0.896172, -0.443707, 0.000000},
	{0.896172, -0.443707, 0.000000},
	{0.896172, -0.443707, 0.000000},
	{0.896172, -0.443707, 0.000000},
	{-0.896529, -0.442986, 0.000000},
	{-0.896529, -0.442986, 0.000000},
	{-0.896529, -0.442986, 0.000000},
	{-0.896529, -0.442986, 0.000000},
	{-0.630906, -0.533044, -0.563756},
	{-0.630906, -0.533044, -0.563756},
	{-0.630906, -0.533044, -0.563756},
	{-0.630906, -0.533044, -0.563756},
	{0.616630, -0.532809, -0.579553},
	{0.616630, -0.532809, -0.579553},
	{0.616630, -0.532809, -0.579553},
	{0.616630, -0.532809, -0.579553},
	{0.616631, 0.579553, 0.532808},
	{0.616631, 0.579553, 0.532808},
	{0.616631, 0.579553, 0.532808},
	{0.616631, 0.579553, 0.532808},
	{-0.630906, 0.563757, 0.533044},
	{-0.630906, 0.563757, 0.533044},
	{-0.630906, 0.563757, 0.533044},
	{-0.630906, 0.563757, 0.533044},
	{-0.896529, -0.000000, 0.442986},
	{-0.896529, -0.000000, 0.442986},
	{-0.896529, -0.000000, 0.442986},
	{-0.896529, -0.000000, 0.442986},
	{0.896172, 0.000000, 0.443706},
	{0.896172, 0.000000, 0.443706},
	{0.896172, 0.000000, 0.443706},
	{0.896172, 0.000000, 0.443706},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.818879, -0.405855, 0.405855},
	{0.818879, -0.405855, 0.405855},
	{0.818879, -0.405855, 0.405855},
	{0.818879, -0.405855, 0.405855},
	{-0.000000, -0.707837, 0.706376},
	{-0.000000, -0.707837, 0.706376},
	{-0.000000, -0.707837, 0.706376},
	{-0.000000, -0.707837, 0.706376},
	{0.000001, -0.707837, 0.706376},
	{0.000001, -0.707837, 0.706376},
	{0.000001, -0.707837, 0.706376},
	{0.000001, -0.707837, 0.706376},
	{0.000000, -0.707836, 0.706377},
	{0.000000, -0.707836, 0.706377},
	{0.000000, -0.707836, 0.706377},
	{0.000000, -0.707836, 0.706377},
	{-0.000000, -0.707836, 0.706376},
	{-0.000000, -0.707836, 0.706376},
	{-0.000000, -0.707836, 0.706376},
	{-0.000000, -0.707836, 0.706376},
	{-0.000000, -0.707837, 0.706376},
	{-0.000000, -0.707837, 0.706376},
	{-0.000000, -0.707837, 0.706376},
	{-0.000000, -0.707837, 0.706376},
	{0.000001, -0.707837, 0.706376},
	{0.000001, -0.707837, 0.706376},
	{0.000001, -0.707837, 0.706376},
	{0.000001, -0.707837, 0.706376},
	{-0.819425, -0.405305, 0.405303},
	{-0.819425, -0.405305, 0.405303},
	{-0.819425, -0.405305, 0.405303},
	{-0.819425, -0.405305, 0.405303},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.896172, 0.443707, -0.000000},
	{-0.896172, 0.443707, -0.000000},
	{-0.896172, 0.443707, -0.000000},
	{-0.896172, 0.443707, -0.000000},
	{0.896528, 0.442986, 0.000001},
	{0.896528, 0.442986, 0.000001},
	{0.896528, 0.442986, 0.000001},
	{0.896528, 0.442986, 0.000001},
	{0.630906, 0.533045, -0.563756},
	{0.630906, 0.533045, -0.563756},
	{0.630906, 0.533045, -0.563756},
	{0.630906, 0.533045, -0.563756},
	{-0.616631, 0.532809, -0.579552},
	{-0.616631, 0.532809, -0.579552},
	{-0.616631, 0.532809, -0.579552},
	{-0.616631, 0.532809, -0.579552},
	{-0.616631, -0.579553, 0.532808},
	{-0.616631, -0.579553, 0.532808},
	{-0.616631, -0.579553, 0.532808},
	{-0.616631, -0.579553, 0.532808},
	{0.630906, -0.563756, 0.533045},
	{0.630906, -0.563756, 0.533045},
	{0.630906, -0.563756, 0.533045},
	{0.630906, -0.563756, 0.533045},
	{0.896528, 0.000001, 0.442986},
	{0.896528, 0.000001, 0.442986},
	{0.896528, 0.000001, 0.442986},
	{0.896528, 0.000001, 0.442986},
	{-0.896172, -0.000000, 0.443706},
	{-0.896172, -0.000000, 0.443706},
	{-0.896172, -0.000000, 0.443706},
	{-0.896172, -0.000000, 0.443706},
	{0.000001, -0.000000, 1.000000},
	{0.000001, -0.000000, 1.000000},
	{0.000001, -0.000000, 1.000000},
	{0.000001, -0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000001, -0.000000, 1.000000},
	{0.000001, -0.000000, 1.000000},
	{0.000001, -0.000000, 1.000000},
	{0.000001, -0.000000, 1.000000},
	{0.000002, -0.000000, 1.000000},
	{0.000002, -0.000000, 1.000000},
	{0.000002, -0.000000, 1.000000},
	{0.000002, -0.000000, 1.000000},
	{-0.818880, 0.405855, 0.405854},
	{-0.818880, 0.405855, 0.405854},
	{-0.818880, 0.405855, 0.405854},
	{-0.818880, 0.405855, 0.405854},
	{0.000000, 0.707837, 0.706376},
	{0.000000, 0.707837, 0.706376},
	{0.000000, 0.707837, 0.706376},
	{0.000000, 0.707837, 0.706376},
	{-0.000001, 0.707837, 0.706376},
	{-0.000001, 0.707837, 0.706376},
	{-0.000001, 0.707837, 0.706376},
	{-0.000001, 0.707837, 0.706376},
	{0.000000, 0.707837, 0.706376},
	{0.000000, 0.707837, 0.706376},
	{0.000000, 0.707837, 0.706376},
	{0.000000, 0.707837, 0.706376},
	{0.000000, 0.707837, 0.706376},
	{0.000000, 0.707837, 0.706376},
	{0.000000, 0.707837, 0.706376},
	{0.000000, 0.707837, 0.706376},
	{0.000000, 0.707837, 0.706376},
	{0.000000, 0.707837, 0.706376},
	{0.819425, 0.405304, 0.405304},
	{0.819425, 0.405304, 0.405304},
	{0.819425, 0.405304, 0.405304},
	{0.819425, 0.405304, 0.405304},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.443706, -0.896172, 0.000000},
	{-0.443706, -0.896172, 0.000000},
	{-0.443706, -0.896172, 0.000000},
	{-0.443706, -0.896172, 0.000000},
	{-0.442986, 0.896529, 0.000000},
	{-0.442986, 0.896529, 0.000000},
	{-0.442986, 0.896529, 0.000000},
	{-0.442986, 0.896529, 0.000000},
	{-0.533044, 0.630907, -0.563756},
	{-0.533044, 0.630907, -0.563756},
	{-0.533044, 0.630907, -0.563756},
	{-0.533044, 0.630907, -0.563756},
	{-0.532808, -0.616631, -0.579553},
	{-0.532808, -0.616631, -0.579553},
	{-0.532808, -0.616631, -0.579553},
	{-0.532808, -0.616631, -0.579553},
	{0.579552, -0.616631, 0.532809},
	{0.579552, -0.616631, 0.532809},
	{0.579552, -0.616631, 0.532809},
	{0.579552, -0.616631, 0.532809},
	{0.563756, 0.630907, 0.533043},
	{0.563756, 0.630907, 0.533043},
	{0.563756, 0.630907, 0.533043},
	{0.563756, 0.630907, 0.533043},
	{-0.000001, 0.896529, 0.442985},
	{-0.000001, 0.896529, 0.442985},
	{-0.000001, 0.896529, 0.442985},
	{-0.000001, 0.896529, 0.442985},
	{0.000000, -0.896172, 0.443707},
	{0.000000, -0.896172, 0.443707},
	{0.000000, -0.896172, 0.443707},
	{0.000000, -0.896172, 0.443707},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.405855, -0.818880, 0.405855},
	{-0.405855, -0.818880, 0.405855},
	{-0.405855, -0.818880, 0.405855},
	{-0.405855, -0.818880, 0.405855},
	{-0.707836, 0.000000, 0.706377},
	{-0.707836, 0.000000, 0.706377},
	{-0.707836, 0.000000, 0.706377},
	{-0.707836, 0.000000, 0.706377},
	{-0.707837, -0.000000, 0.706376},
	{-0.707837, -0.000000, 0.706376},
	{-0.707837, -0.000000, 0.706376},
	{-0.707837, -0.000000, 0.706376},
	{-0.707837, -0.000000, 0.706376},
	{-0.707837, -0.000000, 0.706376},
	{-0.707837, -0.000000, 0.706376},
	{-0.707837, -0.000000, 0.706376},
	{-0.707837, -0.000000, 0.706376},
	{-0.707837, -0.000000, 0.706376},
	{-0.707837, -0.000000, 0.706376},
	{-0.707837, -0.000000, 0.706376},
	{-0.405305, 0.819425, 0.405303},
	{-0.405305, 0.819425, 0.405303},
	{-0.405305, 0.819425, 0.405303},
	{-0.405305, 0.819425, 0.405303},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{0.443706, 0.896172, 0.000000},
	{0.443706, 0.896172, 0.000000},
	{0.443706, 0.896172, 0.000000},
	{0.443706, 0.896172, 0.000000},
	{0.442986, -0.896529, 0.000001},
	{0.442986, -0.896529, 0.000001},
	{0.442986, -0.896529, 0.000001},
	{0.442986, -0.896529, 0.000001},
	{0.533044, -0.630907, -0.563756},
	{0.533044, -0.630907, -0.563756},
	{0.533044, -0.630907, -0.563756},
	{0.533044, -0.630907, -0.563756},
	{0.532808, 0.616631, -0.579553},
	{0.532808, 0.616631, -0.579553},
	{0.532808, 0.616631, -0.579553},
	{0.532808, 0.616631, -0.579553},
	{-0.579552, 0.616631, 0.532809},
	{-0.579552, 0.616631, 0.532809},
	{-0.579552, 0.616631, 0.532809},
	{-0.579552, 0.616631, 0.532809},
	{-0.563756, -0.630906, 0.533045},
	{-0.563756, -0.630906, 0.533045},
	{-0.563756, -0.630906, 0.533045},
	{-0.563756, -0.630906, 0.533045},
	{0.000000, -0.896528, 0.442986},
	{0.000000, -0.896528, 0.442986},
	{0.000000, -0.896528, 0.442986},
	{0.000000, -0.896528, 0.442986},
	{0.000000, 0.896172, 0.443707},
	{0.000000, 0.896172, 0.443707},
	{0.000000, 0.896172, 0.443707},
	{0.000000, 0.896172, 0.443707},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, -0.000001, 1.000000},
	{-0.000000, -0.000001, 1.000000},
	{-0.000000, -0.000001, 1.000000},
	{-0.000000, -0.000001, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.405854, 0.818879, 0.405856},
	{0.405854, 0.818879, 0.405856},
	{0.405854, 0.818879, 0.405856},
	{0.405854, 0.818879, 0.405856},
	{0.707836, 0.000000, 0.706377},
	{0.707836, 0.000000, 0.706377},
	{0.707836, 0.000000, 0.706377},
	{0.707836, 0.000000, 0.706377},
	{0.707836, 0.000001, 0.706377},
	{0.707836, 0.000001, 0.706377},
	{0.707836, 0.000001, 0.706377},
	{0.707836, 0.000001, 0.706377},
	{0.707837, 0.000000, 0.706376},
	{0.707837, 0.000000, 0.706376},
	{0.707837, 0.000000, 0.706376},
	{0.707837, 0.000000, 0.706376},
	{0.707837, 0.000000, 0.706376},
	{0.707837, 0.000000, 0.706376},
	{0.707836, -0.000001, 0.706377},
	{0.707836, -0.000001, 0.706377},
	{0.707836, -0.000001, 0.706377},
	{0.707836, -0.000001, 0.706377},
	{0.707836, 0.000000, 0.706377},
	{0.707836, 0.000000, 0.706377},
	{0.707836, 0.000000, 0.706377},
	{0.707836, 0.000000, 0.706377},
	{0.405304, -0.819424, 0.405306},
	{0.405304, -0.819424, 0.405306},
	{0.405304, -0.819424, 0.405306},
	{0.405304, -0.819424, 0.405306},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{0.000000, -1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.000000, -0.000000, -1.000000},
	{-0.514664, 0.514695, 0.685690},
	{-0.671194, 0.671194, -0.314524},
	{-0.789239, 0.527360, -0.314524},
	{-0.605213, 0.404370, 0.685690},
	{-0.876980, 0.363231, -0.314524},
	{-0.672475, 0.278542, 0.685690},
	{-0.930998, 0.185186, -0.314524},
	{-0.713889, 0.142003, 0.685690},
	{-0.949217, 0.000000, -0.314524},
	{-0.727866, 0.000000, 0.685690},
	{-0.930998, -0.185186, -0.314524},
	{-0.713889, -0.142003, 0.685690},
	{-0.876980, -0.363231, -0.314524},
	{-0.672475, -0.278542, 0.685690},
	{-0.789239, -0.527360, -0.314524},
	{-0.605213, -0.404370, 0.685690},
	{-0.671194, -0.671194, -0.314524},
	{-0.514664, -0.514664, 0.685690},
	{-0.527360, -0.789239, -0.314524},
	{-0.404370, -0.605213, 0.685690},
	{-0.363231, -0.876980, -0.314524},
	{-0.278542, -0.672475, 0.685690},
	{-0.185186, -0.930998, -0.314524},
	{-0.141972, -0.713889, 0.685690},
	{0.000000, -0.949217, -0.314524},
	{0.000000, -0.727866, 0.685690},
	{0.185186, -0.930998, -0.314524},
	{0.142003, -0.713889, 0.685690},
	{0.363231, -0.876980, -0.314524},
	{0.278542, -0.672475, 0.685690},
	{0.527360, -0.789239, -0.314524},
	{0.404370, -0.605213, 0.685690},
	{0.671194, -0.671194, -0.314524},
	{0.514664, -0.514664, 0.685690},
	{0.789239, -0.527360, -0.314524},
	{0.605213, -0.404370, 0.685690},
	{0.876980, -0.363262, -0.314524},
	{0.672475, -0.278542, 0.685690},
	{0.930998, -0.185186, -0.314524},
	{0.713889, -0.142003, 0.685690},
	{0.949217, 0.000000, -0.314524},
	{0.727866, 0.000000, 0.685690},
	{0.930998, 0.185156, -0.314524},
	{0.713889, 0.142003, 0.685690},
	{0.876980, 0.363231, -0.314524},
	{0.672475, 0.278542, 0.685690},
	{0.789270, 0.527360, -0.314524},
	{0.605213, 0.404370, 0.685690},
	{0.671194, 0.671194, -0.314524},
	{0.514664, 0.514664, 0.685690},
	{0.527360, 0.789239, -0.314524},
	{0.404370, 0.605213, 0.685690},
	{0.363262, 0.876980, -0.314524},
	{0.278542, 0.672475, 0.685690},
	{0.185186, 0.930998, -0.314524},
	{0.141972, 0.713889, 0.685690},
	{0.000000, 0.949217, -0.314524},
	{0.000000, 0.727866, 0.685690},
	{-0.185156, 0.930998, -0.314524},
	{-0.142003, 0.713889, 0.685690},
	{-0.363231, 0.876980, -0.314524},
	{-0.278542, 0.672475, 0.685690},
	{-0.527360, 0.789270, -0.314524},
	{-0.404370, 0.605213, 0.685690},
	{-0.301431, 0.451155, -0.839961},
	{-0.383679, 0.383679, -0.839961},
	{-0.207617, 0.501297, -0.839961},
	{-0.105838, 0.532182, -0.839961},
	{0.000000, 0.542589, -0.839961},
	{0.105838, 0.532182, -0.839961},
	{0.207648, 0.501297, -0.839961},
	{0.301462, 0.451155, -0.839961},
	{0.383679, 0.383679, -0.839961},
	{0.451155, 0.301431, -0.839961},
	{0.501297, 0.207617, -0.839961},
	{0.532182, 0.105838, -0.839961},
	{0.542589, 0.000000, -0.839961},
	{0.532182, -0.105838, -0.839961},
	{0.501297, -0.207648, -0.839961},
	{0.451155, -0.301462, -0.839961},
	{0.383679, -0.383679, -0.839961},
	{0.301431, -0.451155, -0.839961},
	{0.207648, -0.501297, -0.839961},
	{0.105838, -0.532182, -0.839961},
	{0.000000, -0.542589, -0.839961},
	{-0.105838, -0.532182, -0.839961},
	{-0.207648, -0.501297, -0.839961},
	{-0.301431, -0.451155, -0.839961},
	{-0.383679, -0.383679, -0.839961},
	{-0.451155, -0.301462, -0.839961},
	{-0.501297, -0.207648, -0.839961},
	{-0.532182, -0.105838, -0.839961},
	{-0.542589, 0.000000, -0.839961},
	{-0.532182, 0.105838, -0.839961},
	{-0.501297, 0.207648, -0.839961},
	{-0.451155, 0.301431, -0.839961},
	{-0.451155, 0.301431, -0.839961},
	{-0.383679, 0.383679, -0.839961},
	{-0.071810, 0.071810, -0.994812},
	{-0.084445, 0.056429, -0.994812},
	{-0.501297, 0.207648, -0.839961},
	{-0.093844, 0.038850, -0.994812},
	{-0.532182, 0.105838, -0.839961},
	{-0.099612, 0.019807, -0.994812},
	{-0.542589, 0.000000, -0.839961},
	{-0.101566, 0.000000, -0.994812},
	{-0.532182, -0.105838, -0.839961},
	{-0.099612, -0.019807, -0.994812},
	{-0.501297, -0.207648, -0.839961},
	{-0.093844, -0.038850, -0.994812},
	{-0.451155, -0.301462, -0.839961},
	{-0.084445, -0.056429, -0.994812},
	{-0.383679, -0.383679, -0.839961},
	{-0.071810, -0.071810, -0.994812},
	{-0.301431, -0.451155, -0.839961},
	{-0.056429, -0.084445, -0.994812},
	{-0.207648, -0.501297, -0.839961},
	{-0.038850, -0.093844, -0.994812},
	{-0.105838, -0.532182, -0.839961},
	{-0.019807, -0.099612, -0.994812},
	{0.000000, -0.542589, -0.839961},
	{0.000000, -0.101566, -0.994812},
	{0.105838, -0.532182, -0.839961},
	{0.019807, -0.099612, -0.994812},
	{0.207648, -0.501297, -0.839961},
	{0.038850, -0.093844, -0.994812},
	{0.301431, -0.451155, -0.839961},
	{0.056429, -0.084445, -0.994812},
	{0.383679, -0.383679, -0.839961},
	{0.071810, -0.071810, -0.994812},
	{0.451155, -0.301462, -0.839961},
	{0.084445, -0.056429, -0.994812},
	{0.501297, -0.207648, -0.839961},
	{0.093844, -0.038850, -0.994812},
	{0.532182, -0.105838, -0.839961},
	{0.099612, -0.019807, -0.994812},
	{0.542589, 0.000000, -0.839961},
	{0.101566, 0.000000, -0.994812},
	{0.532182, 0.105838, -0.839961},
	{0.099612, 0.019807, -0.994812},
	{0.501297, 0.207617, -0.839961},
	{0.093844, 0.038850, -0.994812},
	{0.451155, 0.301431, -0.839961},
	{0.084445, 0.056429, -0.994812},
	{0.383679, 0.383679, -0.839961},
	{0.071810, 0.071810, -0.994812},
	{0.301462, 0.451155, -0.839961},
	{0.056429, 0.084445, -0.994812},
	{0.207648, 0.501297, -0.839961},
	{0.038850, 0.093844, -0.994812},
	{0.105838, 0.532182, -0.839961},
	{0.019807, 0.099612, -0.994812},
	{0.000000, 0.542589, -0.839961},
	{0.000000, 0.101566, -0.994812},
	{-0.105838, 0.532182, -0.839961},
	{-0.019807, 0.099612, -0.994812},
	{-0.207617, 0.501297, -0.839961},
	{-0.038850, 0.093844, -0.994812},
	{-0.301431, 0.451155, -0.839961},
	{-0.056429, 0.084445, -0.994812},
	{-0.000000, -0.000000, -1.000000},
	{-0.514664, -0.514695, -0.685690},
	{-0.671194, -0.671194, 0.314524},
	{-0.789239, -0.527360, 0.314524},
	{-0.605213, -0.404370, -0.685690},
	{-0.876980, -0.363231, 0.314524},
	{-0.672475, -0.278542, -0.685690},
	{-0.930998, -0.185186, 0.314524},
	{-0.713889, -0.142003, -0.685690},
	{-0.949217, 0.000000, 0.314524},
	{-0.727866, 0.000000, -0.685690},
	{-0.930998, 0.185186, 0.314524},
	{-0.713889, 0.142003, -0.685690},
	{-0.876980, 0.363231, 0.314524},
	{-0.672475, 0.278542, -0.685690},
	{-0.789239, 0.527360, 0.314524},
	{-0.605213, 0.404370, -0.685690},
	{-0.671194, 0.671194, 0.314524},
	{-0.514695, 0.514664, -0.685690},
	{-0.527360, 0.789239, 0.314524},
	{-0.404370, 0.605213, -0.685690},
	{-0.363231, 0.876980, 0.314524},
	{-0.278542, 0.672475, -0.685690},
	{-0.185186, 0.930998, 0.314524},
	{-0.142003, 0.713889, -0.685690},
	{0.000000, 0.949217, 0.314524},
	{0.000000, 0.727866, -0.685690},
	{0.185186, 0.930998, 0.314524},
	{0.142003, 0.713889, -0.685690},
	{0.363231, 0.876980, 0.314524},
	{0.278542, 0.672475, -0.685690},
	{0.527360, 0.789270, 0.314524},
	{0.404370, 0.605213, -0.685690},
	{0.671194, 0.671194, 0.314524},
	{0.514664, 0.514664, -0.685690},
	{0.789239, 0.527360, 0.314524},
	{0.605213, 0.404370, -0.685690},
	{0.876980, 0.363262, 0.314524},
	{0.672475, 0.278542, -0.685690},
	{0.930998, 0.185186, 0.314524},
	{0.713889, 0.142003, -0.685690},
	{0.949217, 0.000000, 0.314524},
	{0.727866, 0.000000, -0.685690},
	{0.930998, -0.185156, 0.314524},
	{0.713889, -0.142003, -0.685690},
	{0.876980, -0.363231, 0.314524},
	{0.672475, -0.278542, -0.685690},
	{0.789270, -0.527360, 0.314524},
	{0.605213, -0.404370, -0.685690},
	{0.671194, -0.671194, 0.314524},
	{0.514664, -0.514664, -0.685690},
	{0.527360, -0.789239, 0.314524},
	{0.404370, -0.605213, -0.685690},
	{0.363262, -0.876980, 0.314524},
	{0.278542, -0.672475, -0.685690},
	{0.185186, -0.930998, 0.314524},
	{0.141972, -0.713889, -0.685690},
	{0.000000, -0.949217, 0.314524},
	{0.000000, -0.727866, -0.685690},
	{-0.185156, -0.930998, 0.314524},
	{-0.142003, -0.713889, -0.685690},
	{-0.363231, -0.876980, 0.314524},
	{-0.278542, -0.672475, -0.685690},
	{-0.527360, -0.789270, 0.314524},
	{-0.404370, -0.605213, -0.685690},
	{-0.301431, -0.451155, 0.839961},
	{-0.383679, -0.383679, 0.839961},
	{-0.207617, -0.501297, 0.839961},
	{-0.105838, -0.532182, 0.839961},
	{0.000000, -0.542589, 0.839961},
	{0.105838, -0.532182, 0.839961},
	{0.207648, -0.501297, 0.839961},
	{0.301462, -0.451155, 0.839961},
	{0.383679, -0.383679, 0.839961},
	{0.451155, -0.301431, 0.839961},
	{0.501297, -0.207617, 0.839961},
	{0.532182, -0.105838, 0.839961},
	{0.542589, 0.000000, 0.839961},
	{0.532182, 0.105838, 0.839961},
	{0.501297, 0.207648, 0.839961},
	{0.451155, 0.301462, 0.839961},
	{0.383679, 0.383679, 0.839961},
	{0.301431, 0.451155, 0.839961},
	{0.207648, 0.501297, 0.839961},
	{0.105838, 0.532182, 0.839961},
	{0.000000, 0.542589, 0.839961},
	{-0.105838, 0.532182, 0.839961},
	{-0.207648, 0.501297, 0.839961},
	{-0.301431, 0.451155, 0.839961},
	{-0.383679, 0.383679, 0.839961},
	{-0.451155, 0.301462, 0.839961},
	{-0.501297, 0.207648, 0.839961},
	{-0.532182, 0.105838, 0.839961},
	{-0.542589, 0.000000, 0.839961},
	{-0.532182, -0.105838, 0.839961},
	{-0.501297, -0.207648, 0.839961},
	{-0.451155, -0.301431, 0.839961},
	{-0.451155, -0.301431, 0.839961},
	{-0.383679, -0.383679, 0.839961},
	{-0.071810, -0.071810, 0.994812},
	{-0.084445, -0.056429, 0.994812},
	{-0.501297, -0.207648, 0.839961},
	{-0.093844, -0.038850, 0.994812},
	{-0.532182, -0.105838, 0.839961},
	{-0.099612, -0.019807, 0.994812},
	{-0.542589, 0.000000, 0.839961},
	{-0.101566, 0.000000, 0.994812},
	{-0.532182, 0.105838, 0.839961},
	{-0.099612, 0.019807, 0.994812},
	{-0.501297, 0.207648, 0.839961},
	{-0.093844, 0.038850, 0.994812},
	{-0.451155, 0.301462, 0.839961},
	{-0.084445, 0.056429, 0.994812},
	{-0.383679, 0.383679, 0.839961},
	{-0.071810, 0.071810, 0.994812},
	{-0.301431, 0.451155, 0.839961},
	{-0.056429, 0.084445, 0.994812},
	{-0.207648, 0.501297, 0.839961},
	{-0.038850, 0.093844, 0.994812},
	{-0.105838, 0.532182, 0.839961},
	{-0.019807, 0.099612, 0.994812},
	{0.000000, 0.542589, 0.839961},
	{0.000000, 0.101566, 0.994812},
	{0.105838, 0.532182, 0.839961},
	{0.019807, 0.099612, 0.994812},
	{0.207648, 0.501297, 0.839961},
	{0.038850, 0.093844, 0.994812},
	{0.301431, 0.451155, 0.839961},
	{0.056429, 0.084445, 0.994812},
	{0.383679, 0.383679, 0.839961},
	{0.071810, 0.071810, 0.994812},
	{0.451155, 0.301462, 0.839961},
	{0.084445, 0.056429, 0.994812},
	{0.501297, 0.207648, 0.839961},
	{0.093844, 0.038850, 0.994812},
	{0.532182, 0.105838, 0.839961},
	{0.099612, 0.019807, 0.994812},
	{0.542589, 0.000000, 0.839961},
	{0.101566, 0.000000, 0.994812},
	{0.532182, -0.105838, 0.839961},
	{0.099612, -0.019807, 0.994812},
	{0.501297, -0.207617, 0.839961},
	{0.093844, -0.038850, 0.994812},
	{0.451155, -0.301431, 0.839961},
	{0.084445, -0.056429, 0.994812},
	{0.383679, -0.383679, 0.839961},
	{0.071810, -0.071810, 0.994812},
	{0.301462, -0.451155, 0.839961},
	{0.056429, -0.084445, 0.994812},
	{0.207648, -0.501297, 0.839961},
	{0.038850, -0.093844, 0.994812},
	{0.105838, -0.532182, 0.839961},
	{0.019807, -0.099612, 0.994812},
	{0.000000, -0.542589, 0.839961},
	{0.000000, -0.101566, 0.994812},
	{-0.105838, -0.532182, 0.839961},
	{-0.019807, -0.099612, 0.994812},
	{-0.207617, -0.501297, 0.839961},
	{-0.038850, -0.093844, 0.994812},
	{-0.301431, -0.451155, 0.839961},
	{-0.056429, -0.084445, 0.994812},
	{-0.000000, 0.000000, 1.000000},
	{-0.514664, 0.685690, -0.514695},
	{-0.671194, -0.314524, -0.671194},
	{-0.789239, -0.314524, -0.527360},
	{-0.605213, 0.685690, -0.404370},
	{-0.876980, -0.314524, -0.363231},
	{-0.672475, 0.685690, -0.278542},
	{-0.930998, -0.314524, -0.185186},
	{-0.713889, 0.685690, -0.142003},
	{-0.949217, -0.314524, 0.000000},
	{-0.727866, 0.685690, 0.000000},
	{-0.930998, -0.314524, 0.185186},
	{-0.713889, 0.685690, 0.142003},
	{-0.876980, -0.314524, 0.363231},
	{-0.672475, 0.685690, 0.278542},
	{-0.789239, -0.314524, 0.527360},
	{-0.605213, 0.685690, 0.404370},
	{-0.671194, -0.314524, 0.671194},
	{-0.514664, 0.685690, 0.514664},
	{-0.527360, -0.314524, 0.789239},
	{-0.404370, 0.685690, 0.605213},
	{-0.363231, -0.314524, 0.876980},
	{-0.278542, 0.685690, 0.672475},
	{-0.185186, -0.314524, 0.930998},
	{-0.142003, 0.685690, 0.713889},
	{0.000000, -0.314524, 0.949217},
	{0.000000, 0.685690, 0.727866},
	{0.185186, -0.314524, 0.930998},
	{0.142003, 0.685690, 0.713889},
	{0.363231, -0.314524, 0.876980},
	{0.278542, 0.685690, 0.672475},
	{0.527360, -0.314524, 0.789239},
	{0.404370, 0.685690, 0.605213},
	{0.671194, -0.314524, 0.671194},
	{0.514664, 0.685690, 0.514664},
	{0.789239, -0.314524, 0.527360},
	{0.605213, 0.685690, 0.404370},
	{0.876980, -0.314524, 0.363262},
	{0.672475, 0.685690, 0.278542},
	{0.930998, -0.314524, 0.185186},
	{0.713889, 0.685690, 0.142003},
	{0.949217, -0.314524, 0.000000},
	{0.727866, 0.685690, 0.000000},
	{0.930998, -0.314524, -0.185156},
	{0.713889, 0.685690, -0.142003},
	{0.876980, -0.314524, -0.363231},
	{0.672475, 0.685690, -0.278542},
	{0.789270, -0.314524, -0.527360},
	{0.605213, 0.685690, -0.404370},
	{0.671194, -0.314524, -0.671194},
	{0.514664, 0.685690, -0.514664},
	{0.527360, -0.314524, -0.789239},
	{0.404370, 0.685690, -0.605213},
	{0.363262, -0.314524, -0.876980},
	{0.278542, 0.685690, -0.672475},
	{0.185186, -0.314524, -0.930998},
	{0.142003, 0.685690, -0.713889},
	{0.000000, -0.314524, -0.949217},
	{0.000000, 0.685690, -0.727866},
	{-0.185156, -0.314524, -0.930998},
	{-0.142003, 0.685690, -0.713889},
	{-0.363231, -0.314524, -0.876980},
	{-0.278542, 0.685690, -0.672475},
	{-0.527360, -0.314524, -0.789270},
	{-0.404370, 0.685690, -0.605213},
	{-0.301431, -0.839961, -0.451155},
	{-0.383679, -0.839961, -0.383679},
	{-0.207617, -0.839961, -0.501297},
	{-0.105838, -0.839961, -0.532182},
	{0.000000, -0.839961, -0.542589},
	{0.105838, -0.839961, -0.532182},
	{0.207648, -0.839961, -0.501297},
	{0.301462, -0.839961, -0.451155},
	{0.383679, -0.839961, -0.383679},
	{0.451155, -0.839961, -0.301431},
	{0.501297, -0.839961, -0.207617},
	{0.532182, -0.839961, -0.105838},
	{0.542589, -0.839961, 0.000000},
	{0.532182, -0.839961, 0.105838},
	{0.501297, -0.839961, 0.207648},
	{0.451155, -0.839961, 0.301462},
	{0.383679, -0.839961, 0.383679},
	{0.301431, -0.839961, 0.451155},
	{0.207648, -0.839961, 0.501297},
	{0.105838, -0.839961, 0.532182},
	{0.000000, -0.839961, 0.542589},
	{-0.105838, -0.839961, 0.532182},
	{-0.207648, -0.839961, 0.501297},
	{-0.301431, -0.839961, 0.451155},
	{-0.383679, -0.839961, 0.383679},
	{-0.451155, -0.839961, 0.301431},
	{-0.501297, -0.839961, 0.207648},
	{-0.532182, -0.839961, 0.105838},
	{-0.542589, -0.839961, 0.000000},
	{-0.532182, -0.839961, -0.105838},
	{-0.501297, -0.839961, -0.207648},
	{-0.451155, -0.839961, -0.301431},
	{-0.451155, -0.839961, -0.301431},
	{-0.383679, -0.839961, -0.383679},
	{-0.071810, -0.994812, -0.071810},
	{-0.084445, -0.994812, -0.056429},
	{-0.501297, -0.839961, -0.207648},
	{-0.093844, -0.994812, -0.038850},
	{-0.532182, -0.839961, -0.105838},
	{-0.099612, -0.994812, -0.019807},
	{-0.542589, -0.839961, 0.000000},
	{-0.101566, -0.994812, 0.000000},
	{-0.532182, -0.839961, 0.105838},
	{-0.099612, -0.994812, 0.019807},
	{-0.501297, -0.839961, 0.207648},
	{-0.093844, -0.994812, 0.038850},
	{-0.451155, -0.839961, 0.301431},
	{-0.084445, -0.994812, 0.056429},
	{-0.383679, -0.839961, 0.383679},
	{-0.071810, -0.994812, 0.071810},
	{-0.301431, -0.839961, 0.451155},
	{-0.056429, -0.994812, 0.084445},
	{-0.207648, -0.839961, 0.501297},
	{-0.038850, -0.994812, 0.093844},
	{-0.105838, -0.839961, 0.532182},
	{-0.019807, -0.994812, 0.099612},
	{0.000000, -0.839961, 0.542589},
	{0.000000, -0.994812, 0.101566},
	{0.105838, -0.839961, 0.532182},
	{0.019807, -0.994812, 0.099612},
	{0.207648, -0.839961, 0.501297},
	{0.038850, -0.994812, 0.093844},
	{0.301431, -0.839961, 0.451155},
	{0.056429, -0.994812, 0.084445},
	{0.383679, -0.839961, 0.383679},
	{0.071810, -0.994812, 0.071810},
	{0.451155, -0.839961, 0.301462},
	{0.084445, -0.994812, 0.056429},
	{0.501297, -0.839961, 0.207648},
	{0.093844, -0.994812, 0.038850},
	{0.532182, -0.839961, 0.105838},
	{0.099612, -0.994812, 0.019807},
	{0.542589, -0.839961, 0.000000},
	{0.101566, -0.994812, 0.000000},
	{0.532182, -0.839961, -0.105838},
	{0.099612, -0.994812, -0.019807},
	{0.501297, -0.839961, -0.207617},
	{0.093844, -0.994812, -0.038850},
	{0.451155, -0.839961, -0.301431},
	{0.084445, -0.994812, -0.056429},
	{0.383679, -0.839961, -0.383679},
	{0.071810, -0.994812, -0.071810},
	{0.301462, -0.839961, -0.451155},
	{0.056429, -0.994812, -0.084445},
	{0.207648, -0.839961, -0.501297},
	{0.038850, -0.994812, -0.093844},
	{0.105838, -0.839961, -0.532182},
	{0.019807, -0.994812, -0.099612},
	{0.000000, -0.839961, -0.542589},
	{0.000000, -0.994812, -0.101566},
	{-0.105838, -0.839961, -0.532182},
	{-0.019807, -0.994812, -0.099612},
	{-0.207617, -0.839961, -0.501297},
	{-0.038850, -0.994812, -0.093844},
	{-0.301431, -0.839961, -0.451155},
	{-0.056429, -0.994812, -0.084445},
	{0.000000, -1.000000, -0.000000},
	{-0.514664, -0.685690, 0.514695},
	{-0.671194, 0.314524, 0.671194},
	{-0.789270, 0.314524, 0.527360},
	{-0.605213, -0.685690, 0.404370},
	{-0.876980, 0.314524, 0.363231},
	{-0.672475, -0.685690, 0.278542},
	{-0.930998, 0.314524, 0.185186},
	{-0.713889, -0.685690, 0.142003},
	{-0.949217, 0.314524, 0.000000},
	{-0.727866, -0.685690, 0.000000},
	{-0.930998, 0.314524, -0.185186},
	{-0.713889, -0.685690, -0.142003},
	{-0.876980, 0.314524, -0.363262},
	{-0.672475, -0.685690, -0.278542},
	{-0.789239, 0.314524, -0.527360},
	{-0.605213, -0.685690, -0.404370},
	{-0.671194, 0.314524, -0.671194},
	{-0.514664, -0.685690, -0.514664},
	{-0.527360, 0.314524, -0.789239},
	{-0.404370, -0.685690, -0.605213},
	{-0.363231, 0.314524, -0.876980},
	{-0.278542, -0.685690, -0.672475},
	{-0.185186, 0.314524, -0.930998},
	{-0.142003, -0.685690, -0.713889},
	{0.000000, 0.314524, -0.949217},
	{0.000000, -0.685690, -0.727866},
	{0.185186, 0.314524, -0.930998},
	{0.142003, -0.685690, -0.713889},
	{0.363231, 0.314524, -0.876980},
	{0.278542, -0.685690, -0.672475},
	{0.527360, 0.314524, -0.789270},
	{0.404370, -0.685690, -0.605213},
	{0.671194, 0.314524, -0.671194},
	{0.514664, -0.685690, -0.514664},
	{0.789239, 0.314524, -0.527360},
	{0.605213, -0.685690, -0.404370},
	{0.876980, 0.314524, -0.363262},
	{0.672475, -0.685690, -0.278542},
	{0.930998, 0.314524, -0.185186},
	{0.713889, -0.685690, -0.142003},
	{0.949217, 0.314524, 0.000000},
	{0.727866, -0.685690, 0.000000},
	{0.930998, 0.314524, 0.185156},
	{0.713889, -0.685690, 0.142003},
	{0.876980, 0.314524, 0.363231},
	{0.672475, -0.685690, 0.278542},
	{0.789270, 0.314524, 0.527360},
	{0.605213, -0.685690, 0.404370},
	{0.671194, 0.314524, 0.671194},
	{0.514664, -0.685690, 0.514695},
	{0.527360, 0.314524, 0.789239},
	{0.404370, -0.685690, 0.605213},
	{0.363262, 0.314524, 0.876980},
	{0.278542, -0.685690, 0.672475},
	{0.185186, 0.314524, 0.930998},
	{0.142003, -0.685690, 0.713889},
	{0.000000, 0.314524, 0.949217},
	{0.000000, -0.685690, 0.727866},
	{-0.185156, 0.314524, 0.930998},
	{-0.142003, -0.685690, 0.713889},
	{-0.363231, 0.314524, 0.876980},
	{-0.278542, -0.685690, 0.672475},
	{-0.527360, 0.314524, 0.789270},
	{-0.404370, -0.685690, 0.605213},
	{-0.301431, 0.839961, 0.451155},
	{-0.383679, 0.839961, 0.383679},
	{-0.207617, 0.839961, 0.501297},
	{-0.105838, 0.839961, 0.532182},
	{0.000000, 0.839961, 0.542589},
	{0.105838, 0.839961, 0.532182},
	{0.207648, 0.839961, 0.501297},
	{0.301462, 0.839961, 0.451155},
	{0.383679, 0.839961, 0.383679},
	{0.451155, 0.839961, 0.301431},
	{0.501297, 0.839961, 0.207648},
	{0.532182, 0.839961, 0.105838},
	{0.542589, 0.839961, 0.000000},
	{0.532182, 0.839961, -0.105838},
	{0.501297, 0.839961, -0.207648},
	{0.451155, 0.839961, -0.301462},
	{0.383679, 0.839961, -0.383679},
	{0.301462, 0.839961, -0.451155},
	{0.207648, 0.839961, -0.501297},
	{0.105838, 0.839961, -0.532182},
	{0.000000, 0.839961, -0.542589},
	{-0.105838, 0.839961, -0.532182},
	{-0.207648, 0.839961, -0.501297},
	{-0.301462, 0.839961, -0.451155},
	{-0.383679, 0.839961, -0.383679},
	{-0.451155, 0.839961, -0.301462},
	{-0.501297, 0.839961, -0.207648},
	{-0.532182, 0.839961, -0.105838},
	{-0.542589, 0.839961, 0.000000},
	{-0.532182, 0.839961, 0.105838},
	{-0.501297, 0.839961, 0.207648},
	{-0.451155, 0.839961, 0.301431},
	{-0.451155, 0.839961, 0.301431},
	{-0.383679, 0.839961, 0.383679},
	{-0.071810, 0.994812, 0.071810},
	{-0.084445, 0.994812, 0.056429},
	{-0.501297, 0.839961, 0.207648},
	{-0.093844, 0.994812, 0.038850},
	{-0.532182, 0.839961, 0.105838},
	{-0.099612, 0.994812, 0.019807},
	{-0.542589, 0.839961, 0.000000},
	{-0.101566, 0.994812, 0.000000},
	{-0.532182, 0.839961, -0.105838},
	{-0.099612, 0.994812, -0.019807},
	{-0.501297, 0.839961, -0.207648},
	{-0.093844, 0.994812, -0.038850},
	{-0.451155, 0.839961, -0.301462},
	{-0.084445, 0.994812, -0.056429},
	{-0.383679, 0.839961, -0.383679},
	{-0.071810, 0.994812, -0.071810},
	{-0.301462, 0.839961, -0.451155},
	{-0.056429, 0.994812, -0.084445},
	{-0.207648, 0.839961, -0.501297},
	{-0.038850, 0.994812, -0.093844},
	{-0.105838, 0.839961, -0.532182},
	{-0.019807, 0.994812, -0.099612},
	{0.000000, 0.839961, -0.542589},
	{0.000000, 0.994812, -0.101566},
	{0.105838, 0.839961, -0.532182},
	{0.019807, 0.994812, -0.099612},
	{0.207648, 0.839961, -0.501297},
	{0.038850, 0.994812, -0.093844},
	{0.301462, 0.839961, -0.451155},
	{0.056429, 0.994812, -0.084445},
	{0.383679, 0.839961, -0.383679},
	{0.071810, 0.994812, -0.071810},
	{0.451155, 0.839961, -0.301462},
	{0.084445, 0.994812, -0.056429},
	{0.501297, 0.839961, -0.207648},
	{0.093844, 0.994812, -0.038850},
	{0.532182, 0.839961, -0.105838},
	{0.099612, 0.994812, -0.019807},
	{0.542589, 0.839961, 0.000000},
	{0.101566, 0.994812, 0.000000},
	{0.532182, 0.839961, 0.105838},
	{0.099612, 0.994812, 0.019807},
	{0.501297, 0.839961, 0.207648},
	{0.093844, 0.994812, 0.038850},
	{0.451155, 0.839961, 0.301431},
	{0.084445, 0.994812, 0.056429},
	{0.383679, 0.839961, 0.383679},
	{0.071810, 0.994812, 0.071810},
	{0.301462, 0.839961, 0.451155},
	{0.056429, 0.994812, 0.084445},
	{0.207648, 0.839961, 0.501297},
	{0.038850, 0.994812, 0.093844},
	{0.105838, 0.839961, 0.532182},
	{0.019807, 0.994812, 0.099612},
	{0.000000, 0.839961, 0.542589},
	{0.000000, 0.994812, 0.101566},
	{-0.105838, 0.839961, 0.532182},
	{-0.019807, 0.994812, 0.099612},
	{-0.207617, 0.839961, 0.501297},
	{-0.038850, 0.994812, 0.093844},
	{-0.301431, 0.839961, 0.451155},
	{-0.056429, 0.994812, 0.084445},
	{-0.000000, 1.000000, -0.000000},
	{0.685690, -0.514664, 0.514695},
	{-0.314524, -0.671194, 0.671194},
	{-0.314524, -0.789239, 0.527360},
	{0.685690, -0.605213, 0.404370},
	{-0.314524, -0.876980, 0.363231},
	{0.685690, -0.672475, 0.278542},
	{-0.314524, -0.930998, 0.185186},
	{0.685690, -0.713889, 0.142003},
	{-0.314524, -0.949217, 0.000000},
	{0.685690, -0.727866, 0.000000},
	{-0.314524, -0.930998, -0.185186},
	{0.685690, -0.713889, -0.142003},
	{-0.314524, -0.876980, -0.363231},
	{0.685690, -0.672475, -0.278542},
	{-0.314524, -0.789239, -0.527360},
	{0.685690, -0.605213, -0.404370},
	{-0.314524, -0.671194, -0.671194},
	{0.685690, -0.514664, -0.514664},
	{-0.314524, -0.527360, -0.789239},
	{0.685690, -0.404370, -0.605213},
	{-0.314524, -0.363231, -0.876980},
	{0.685690, -0.278542, -0.672475},
	{-0.314524, -0.185186, -0.930998},
	{0.685690, -0.142003, -0.713889},
	{-0.314524, 0.000000, -0.949217},
	{0.685690, 0.000000, -0.727866},
	{-0.314524, 0.185186, -0.930998},
	{0.685690, 0.142003, -0.713889},
	{-0.314524, 0.363231, -0.876980},
	{0.685690, 0.278542, -0.672475},
	{-0.314524, 0.527360, -0.789239},
	{0.685690, 0.404370, -0.605213},
	{-0.314524, 0.671194, -0.671194},
	{0.685690, 0.514695, -0.514664},
	{-0.314524, 0.789239, -0.527360},
	{0.685690, 0.605213, -0.404370},
	{-0.314524, 0.876980, -0.363262},
	{0.685690, 0.672475, -0.278542},
	{-0.314524, 0.930998, -0.185186},
	{0.685690, 0.713889, -0.142003},
	{-0.314524, 0.949217, 0.000000},
	{0.685690, 0.727866, 0.000000},
	{-0.314524, 0.930998, 0.185156},
	{0.685690, 0.713889, 0.142003},
	{-0.314524, 0.876980, 0.363231},
	{0.685690, 0.672475, 0.278542},
	{-0.314524, 0.789270, 0.527360},
	{0.685690, 0.605213, 0.404370},
	{-0.314524, 0.671194, 0.671194},
	{0.685690, 0.514664, 0.514664},
	{-0.314524, 0.527360, 0.789239},
	{0.685690, 0.404370, 0.605213},
	{-0.314524, 0.363262, 0.876980},
	{0.685690, 0.278542, 0.672475},
	{-0.314524, 0.185186, 0.930998},
	{0.685690, 0.142003, 0.713889},
	{-0.314524, 0.000000, 0.949217},
	{0.685690, 0.000000, 0.727866},
	{-0.314524, -0.185156, 0.930998},
	{0.685690, -0.142003, 0.713889},
	{-0.314524, -0.363231, 0.876980},
	{0.685690, -0.278542, 0.672475},
	{-0.314524, -0.527360, 0.789270},
	{0.685690, -0.404370, 0.605213},
	{-0.839961, -0.301431, 0.451155},
	{-0.839961, -0.383679, 0.383679},
	{-0.839961, -0.207617, 0.501297},
	{-0.839961, -0.105838, 0.532182},
	{-0.839961, 0.000000, 0.542589},
	{-0.839961, 0.105838, 0.532182},
	{-0.839961, 0.207648, 0.501297},
	{-0.839961, 0.301462, 0.451155},
	{-0.839961, 0.383679, 0.383679},
	{-0.839961, 0.451155, 0.301431},
	{-0.839961, 0.501297, 0.207648},
	{-0.839961, 0.532182, 0.105838},
	{-0.839961, 0.542589, 0.000000},
	{-0.839961, 0.532182, -0.105838},
	{-0.839961, 0.501297, -0.207648},
	{-0.839961, 0.451155, -0.301462},
	{-0.839961, 0.383679, -0.383679},
	{-0.839961, 0.301431, -0.451155},
	{-0.839961, 0.207648, -0.501297},
	{-0.839961, 0.105838, -0.532182},
	{-0.839961, 0.000000, -0.542589},
	{-0.839961, -0.105838, -0.532182},
	{-0.839961, -0.207648, -0.501297},
	{-0.839961, -0.301431, -0.451155},
	{-0.839961, -0.383679, -0.383679},
	{-0.839961, -0.451155, -0.301431},
	{-0.839961, -0.501297, -0.207648},
	{-0.839961, -0.532182, -0.105838},
	{-0.839961, -0.542589, 0.000000},
	{-0.839961, -0.532182, 0.105838},
	{-0.839961, -0.501297, 0.207648},
	{-0.839961, -0.451155, 0.301431},
	{-0.839961, -0.451155, 0.301431},
	{-0.839961, -0.383679, 0.383679},
	{-0.994812, -0.071810, 0.071810},
	{-0.994812, -0.084445, 0.056429},
	{-0.839961, -0.501297, 0.207648},
	{-0.994812, -0.093844, 0.038850},
	{-0.839961, -0.532182, 0.105838},
	{-0.994812, -0.099612, 0.019807},
	{-0.839961, -0.542589, 0.000000},
	{-0.994812, -0.101566, 0.000000},
	{-0.839961, -0.532182, -0.105838},
	{-0.994812, -0.099612, -0.019807},
	{-0.839961, -0.501297, -0.207648},
	{-0.994812, -0.093844, -0.038850},
	{-0.839961, -0.451155, -0.301431},
	{-0.994812, -0.084445, -0.056429},
	{-0.839961, -0.383679, -0.383679},
	{-0.994812, -0.071810, -0.071810},
	{-0.839961, -0.301431, -0.451155},
	{-0.994812, -0.056429, -0.084445},
	{-0.839961, -0.207648, -0.501297},
	{-0.994812, -0.038850, -0.093844},
	{-0.839961, -0.105838, -0.532182},
	{-0.994812, -0.019807, -0.099612},
	{-0.839961, 0.000000, -0.542589},
	{-0.994812, 0.000000, -0.101566},
	{-0.839961, 0.105838, -0.532182},
	{-0.994812, 0.019807, -0.099612},
	{-0.839961, 0.207648, -0.501297},
	{-0.994812, 0.038850, -0.093844},
	{-0.839961, 0.301431, -0.451155},
	{-0.994812, 0.056429, -0.084445},
	{-0.839961, 0.383679, -0.383679},
	{-0.994812, 0.071810, -0.071810},
	{-0.839961, 0.451155, -0.301462},
	{-0.994812, 0.084445, -0.056429},
	{-0.839961, 0.501297, -0.207648},
	{-0.994812, 0.093844, -0.038850},
	{-0.839961, 0.532182, -0.105838},
	{-0.994812, 0.099612, -0.019807},
	{-0.839961, 0.542589, 0.000000},
	{-0.994812, 0.101566, 0.000000},
	{-0.839961, 0.532182, 0.105838},
	{-0.994812, 0.099612, 0.019807},
	{-0.839961, 0.501297, 0.207648},
	{-0.994812, 0.093844, 0.038850},
	{-0.839961, 0.451155, 0.301431},
	{-0.994812, 0.084445, 0.056429},
	{-0.839961, 0.383679, 0.383679},
	{-0.994812, 0.071810, 0.071810},
	{-0.839961, 0.301462, 0.451155},
	{-0.994812, 0.056429, 0.084445},
	{-0.839961, 0.207648, 0.501297},
	{-0.994812, 0.038850, 0.093844},
	{-0.839961, 0.105838, 0.532182},
	{-0.994812, 0.019807, 0.099612},
	{-0.839961, 0.000000, 0.542589},
	{-0.994812, 0.000000, 0.101566},
	{-0.839961, -0.105838, 0.532182},
	{-0.994812, -0.019807, 0.099612},
	{-0.839961, -0.207617, 0.501297},
	{-0.994812, -0.038850, 0.093844},
	{-0.839961, -0.301431, 0.451155},
	{-0.994812, -0.056429, 0.084445},
	{-1.000000, 0.000000, 0.000000},
	{-0.685690, -0.514664, -0.514695},
	{0.314524, -0.671194, -0.671194},
	{0.314524, -0.789239, -0.527360},
	{-0.685690, -0.605213, -0.404370},
	{0.314524, -0.876980, -0.363231},
	{-0.685690, -0.672475, -0.278542},
	{0.314524, -0.930998, -0.185186},
	{-0.685690, -0.713889, -0.142003},
	{0.314524, -0.949217, 0.000000},
	{-0.685690, -0.727866, 0.000000},
	{0.314524, -0.930998, 0.185186},
	{-0.685690, -0.713889, 0.142003},
	{0.314524, -0.876980, 0.363231},
	{-0.685690, -0.672475, 0.278542},
	{0.314524, -0.789239, 0.527360},
	{-0.685690, -0.605213, 0.404370},
	{0.314524, -0.671194, 0.671194},
	{-0.685690, -0.514664, 0.514664},
	{0.314524, -0.527360, 0.789239},
	{-0.685690, -0.404370, 0.605213},
	{0.314524, -0.363231, 0.876980},
	{-0.685690, -0.278542, 0.672475},
	{0.314524, -0.185186, 0.930998},
	{-0.685690, -0.142003, 0.713889},
	{0.314524, 0.000000, 0.949217},
	{-0.685690, 0.000000, 0.727866},
	{0.314524, 0.185186, 0.930998},
	{-0.685690, 0.142003, 0.713889},
	{0.314524, 0.363231, 0.876980},
	{-0.685690, 0.278542, 0.672475},
	{0.314524, 0.527360, 0.789239},
	{-0.685690, 0.404370, 0.605213},
	{0.314524, 0.671194, 0.671194},
	{-0.685690, 0.514664, 0.514664},
	{0.314524, 0.789239, 0.527360},
	{-0.685690, 0.605213, 0.404370},
	{0.314524, 0.876980, 0.363262},
	{-0.685690, 0.672475, 0.278542},
	{0.314524, 0.930998, 0.185186},
	{-0.685690, 0.713889, 0.142003},
	{0.314524, 0.949217, 0.000000},
	{-0.685690, 0.727866, 0.000000},
	{0.314524, 0.930998, -0.185156},
	{-0.685690, 0.713889, -0.142003},
	{0.314524, 0.876980, -0.363231},
	{-0.685690, 0.672475, -0.278542},
	{0.314524, 0.789270, -0.527360},
	{-0.685690, 0.605213, -0.404370},
	{0.314524, 0.671194, -0.671194},
	{-0.685690, 0.514664, -0.514695},
	{0.314524, 0.527360, -0.789239},
	{-0.685690, 0.404370, -0.605213},
	{0.314524, 0.363262, -0.876980},
	{-0.685690, 0.278542, -0.672475},
	{0.314524, 0.185186, -0.930998},
	{-0.685690, 0.141972, -0.713889},
	{0.314524, 0.000000, -0.949217},
	{-0.685690, 0.000000, -0.727866},
	{0.314524, -0.185156, -0.930998},
	{-0.685690, -0.142003, -0.713889},
	{0.314524, -0.363231, -0.876980},
	{-0.685690, -0.278542, -0.672475},
	{0.314524, -0.527360, -0.789270},
	{-0.685690, -0.404370, -0.605213},
	{0.839961, -0.301431, -0.451155},
	{0.839961, -0.383679, -0.383679},
	{0.839961, -0.207617, -0.501297},
	{0.839961, -0.105838, -0.532182},
	{0.839961, 0.000000, -0.542589},
	{0.839961, 0.105838, -0.532182},
	{0.839961, 0.207648, -0.501297},
	{0.839961, 0.301462, -0.451155},
	{0.839961, 0.383679, -0.383679},
	{0.839961, 0.451155, -0.301431},
	{0.839961, 0.501297, -0.207617},
	{0.839961, 0.532182, -0.105838},
	{0.839961, 0.542589, 0.000000},
	{0.839961, 0.532182, 0.105838},
	{0.839961, 0.501297, 0.207648},
	{0.839961, 0.451155, 0.301462},
	{0.839961, 0.383679, 0.383679},
	{0.839961, 0.301431, 0.451155},
	{0.839961, 0.207648, 0.501297},
	{0.839961, 0.105838, 0.532182},
	{0.839961, 0.000000, 0.542589},
	{0.839961, -0.105838, 0.532182},
	{0.839961, -0.207648, 0.501297},
	{0.839961, -0.301431, 0.451155},
	{0.839961, -0.383679, 0.383679},
	{0.839961, -0.451155, 0.301462},
	{0.839961, -0.501297, 0.207648},
	{0.839961, -0.532182, 0.105838},
	{0.839961, -0.542589, 0.000000},
	{0.839961, -0.532182, -0.105838},
	{0.839961, -0.501297, -0.207648},
	{0.839961, -0.451155, -0.301431},
	{0.839961, -0.451155, -0.301431},
	{0.839961, -0.383679, -0.383679},
	{0.994812, -0.071810, -0.071810},
	{0.994812, -0.084445, -0.056429},
	{0.839961, -0.501297, -0.207648},
	{0.994812, -0.093844, -0.038850},
	{0.839961, -0.532182, -0.105838},
	{0.994812, -0.099612, -0.019807},
	{0.839961, -0.542589, 0.000000},
	{0.994812, -0.101566, 0.000000},
	{0.839961, -0.532182, 0.105838},
	{0.994812, -0.099612, 0.019807},
	{0.839961, -0.501297, 0.207648},
	{0.994812, -0.093844, 0.038850},
	{0.839961, -0.451155, 0.301462},
	{0.994812, -0.084445, 0.056429},
	{0.839961, -0.383679, 0.383679},
	{0.994812, -0.071810, 0.071810},
	{0.839961, -0.301431, 0.451155},
	{0.994812, -0.056429, 0.084445},
	{0.839961, -0.207648, 0.501297},
	{0.994812, -0.038850, 0.093844},
	{0.839961, -0.105838, 0.532182},
	{0.994812, -0.019807, 0.099612},
	{0.839961, 0.000000, 0.542589},
	{0.994812, 0.000000, 0.101566},
	{0.839961, 0.105838, 0.532182},
	{0.994812, 0.019807, 0.099612},
	{0.839961, 0.207648, 0.501297},
	{0.994812, 0.038850, 0.093844},
	{0.839961, 0.301431, 0.451155},
	{0.994812, 0.056429, 0.084445},
	{0.839961, 0.383679, 0.383679},
	{0.994812, 0.071810, 0.071810},
	{0.839961, 0.451155, 0.301462},
	{0.994812, 0.084445, 0.056429},
	{0.839961, 0.501297, 0.207648},
	{0.994812, 0.093844, 0.038850},
	{0.839961, 0.532182, 0.105838},
	{0.994812, 0.099612, 0.019807},
	{0.839961, 0.542589, 0.000000},
	{0.994812, 0.101566, 0.000000},
	{0.839961, 0.532182, -0.105838},
	{0.994812, 0.099612, -0.019807},
	{0.839961, 0.501297, -0.207617},
	{0.994812, 0.093844, -0.038850},
	{0.839961, 0.451155, -0.301431},
	{0.994812, 0.084445, -0.056429},
	{0.839961, 0.383679, -0.383679},
	{0.994812, 0.071810, -0.071810},
	{0.839961, 0.301462, -0.451155},
	{0.994812, 0.056429, -0.084445},
	{0.839961, 0.207648, -0.501297},
	{0.994812, 0.038850, -0.093844},
	{0.839961, 0.105838, -0.532182},
	{0.994812, 0.019807, -0.099612},
	{0.839961, 0.000000, -0.542589},
	{0.994812, 0.000000, -0.101566},
	{0.839961, -0.105838, -0.532182},
	{0.994812, -0.019807, -0.099612},
	{0.839961, -0.207617, -0.501297},
	{0.994812, -0.038850, -0.093844},
	{0.839961, -0.301431, -0.451155},
	{0.994812, -0.056429, -0.084445},
	{1.000000, -0.000000, 0.000000},
	{-0.192969, 0.921323, 0.337504},
	{-0.254006, 0.948393, 0.189734},
	{-0.510392, 0.778008, 0.366314},
	{-0.279611, 0.813959, 0.509171},
	{-0.220862, 0.950011, 0.220588},
	{-0.443312, 0.777856, 0.445418},
	{-0.212104, 0.938292, 0.273049},
	{-0.390728, 0.760552, 0.518509},
	{0.949217, -0.219489, 0.225288},
	{0.939970, -0.269448, 0.209296},
	{0.765801, -0.516770, 0.382702},
	{0.782067, -0.435530, 0.445662},
	{0.948057, -0.191290, 0.254097},
	{0.776299, -0.370159, 0.510208},
	{0.917753, -0.347667, 0.191900},
	{0.805170, -0.520188, 0.284738},
	{-0.188055, 0.940214, 0.283883},
	{-0.354442, 0.760613, 0.543870},
	{-0.182989, 0.939726, 0.288797},
	{-0.343333, 0.767174, 0.541795},
	{-0.334849, 0.922849, 0.190191},
	{-0.510636, 0.814692, 0.274667},
	{-0.332499, -0.193548, -0.923002},
	{-0.189001, -0.253975, -0.948546},
	{-0.364452, -0.510483, -0.778802},
	{-0.503800, -0.276803, -0.818232},
	{-0.219489, -0.225288, -0.949217},
	{-0.435530, -0.445662, -0.782067},
	{-0.269295, -0.209204, -0.940031},
	{-0.516404, -0.382488, -0.766137},
	{-0.294015, -0.186316, -0.937437},
	{-0.550066, -0.348582, -0.758843},
	{-0.290414, -0.184027, -0.939024},
	{-0.543962, -0.344707, -0.765007},
	{-0.190710, -0.335215, -0.922605},
	{-0.275369, -0.511155, -0.814173},
	{0.937162, -0.294687, 0.186743},
	{0.757530, -0.551378, 0.349406},
	{0.938627, -0.291299, 0.184576},
	{0.763665, -0.545305, 0.345561},
	{0.922422, -0.191107, 0.335521},
	{0.813715, -0.275948, 0.511551},
	{-0.192969, 0.337504, -0.921323},
	{-0.254006, 0.189734, -0.948393},
	{-0.510392, 0.366314, -0.778008},
	{-0.279611, 0.509171, -0.813959},
	{-0.220862, 0.220588, -0.950011},
	{-0.443312, 0.445418, -0.777856},
	{-0.212104, 0.273049, -0.938292},
	{-0.390728, 0.518509, -0.760552},
	{0.949217, 0.225288, 0.219489},
	{0.939970, 0.209296, 0.269448},
	{0.765801, 0.382702, 0.516770},
	{0.782067, 0.445662, 0.435530},
	{0.948057, 0.254097, 0.191290},
	{0.776299, 0.510208, 0.370159},
	{0.917753, 0.191900, 0.347667},
	{0.805170, 0.284738, 0.520188},
	{-0.188055, 0.283883, -0.940214},
	{-0.354442, 0.543870, -0.760613},
	{-0.182989, 0.288797, -0.939726},
	{-0.343333, 0.541795, -0.767174},
	{-0.334849, 0.190191, -0.922849},
	{-0.510636, 0.274667, -0.814692},
	{-0.332499, -0.923002, 0.193548},
	{-0.189001, -0.948546, 0.253975},
	{-0.364452, -0.778802, 0.510483},
	{-0.503800, -0.818232, 0.276803},
	{-0.219489, -0.949217, 0.225288},
	{-0.435530, -0.782067, 0.445662},
	{-0.269295, -0.940031, 0.209204},
	{-0.516404, -0.766137, 0.382488},
	{-0.294015, -0.937437, 0.186316},
	{-0.550066, -0.758843, 0.348582},
	{-0.290414, -0.939024, 0.184027},
	{-0.543962, -0.765007, 0.344707},
	{-0.190710, -0.922605, 0.335215},
	{-0.275369, -0.814173, 0.511124},
	{0.937162, 0.186743, 0.294687},
	{0.757530, 0.349406, 0.551378},
	{0.938627, 0.184576, 0.291299},
	{0.763665, 0.345561, 0.545305},
	{0.922422, 0.335521, 0.191107},
	{0.813715, 0.511551, 0.275948},
	{0.192969, 0.921323, 0.337504},
	{0.279611, 0.813959, 0.509171},
	{0.510392, 0.778008, 0.366314},
	{0.254006, 0.948393, 0.189734},
	{0.443312, 0.777856, 0.445418},
	{0.220862, 0.950011, 0.220588},
	{0.390728, 0.760552, 0.518509},
	{0.212104, 0.938292, 0.273049},
	{-0.949217, -0.219489, 0.225288},
	{-0.782067, -0.435530, 0.445662},
	{-0.765801, -0.516770, 0.382702},
	{-0.939970, -0.269448, 0.209296},
	{-0.948057, -0.191290, 0.254097},
	{-0.776299, -0.370159, 0.510208},
	{-0.917753, -0.347667, 0.191900},
	{-0.805170, -0.520188, 0.284738},
	{0.354442, 0.760613, 0.543870},
	{0.188055, 0.940214, 0.283883},
	{0.343333, 0.767174, 0.541795},
	{0.182989, 0.939726, 0.288797},
	{0.510636, 0.814692, 0.274667},
	{0.334849, 0.922849, 0.190191},
	{0.332499, -0.193548, -0.923002},
	{0.503800, -0.276803, -0.818232},
	{0.364452, -0.510483, -0.778802},
	{0.189001, -0.253975, -0.948546},
	{0.435530, -0.445662, -0.782067},
	{0.219489, -0.225288, -0.949217},
	{0.516404, -0.382488, -0.766137},
	{0.269295, -0.209204, -0.940031},
	{0.550066, -0.348582, -0.758843},
	{0.294015, -0.186316, -0.937437},
	{0.543962, -0.344707, -0.765007},
	{0.290414, -0.184027, -0.939024},
	{0.275369, -0.511124, -0.814173},
	{0.190710, -0.335215, -0.922605},
	{-0.757530, -0.551378, 0.349406},
	{-0.937162, -0.294687, 0.186743},
	{-0.763665, -0.545305, 0.345561},
	{-0.938627, -0.291299, 0.184576},
	{-0.813715, -0.275948, 0.511551},
	{-0.922422, -0.191107, 0.335521},
	{0.192969, 0.337504, -0.921323},
	{0.279611, 0.509171, -0.813959},
	{0.510392, 0.366314, -0.778008},
	{0.254006, 0.189734, -0.948393},
	{0.443312, 0.445418, -0.777856},
	{0.220862, 0.220588, -0.950011},
	{0.390728, 0.518509, -0.760552},
	{0.212104, 0.273049, -0.938292},
	{-0.949217, 0.225288, 0.219489},
	{-0.782067, 0.445662, 0.435530},
	{-0.765801, 0.382702, 0.516770},
	{-0.939970, 0.209296, 0.269448},
	{-0.948057, 0.254097, 0.191290},
	{-0.776299, 0.510208, 0.370159},
	{-0.917753, 0.191900, 0.347667},
	{-0.805170, 0.284738, 0.520188},
	{0.354442, 0.543870, -0.760613},
	{0.188055, 0.283883, -0.940214},
	{0.343333, 0.541795, -0.767174},
	{0.182989, 0.288797, -0.939726},
	{0.510636, 0.274667, -0.814692},
	{0.334849, 0.190191, -0.922849},
	{0.332499, -0.923002, 0.193548},
	{0.503800, -0.818232, 0.276803},
	{0.364452, -0.778802, 0.510483},
	{0.189001, -0.948546, 0.253975},
	{0.435530, -0.782067, 0.445662},
	{0.219489, -0.949217, 0.225288},
	{0.516404, -0.766137, 0.382488},
	{0.269295, -0.940031, 0.209204},
	{0.550066, -0.758843, 0.348582},
	{0.294015, -0.937437, 0.186316},
	{0.543962, -0.765007, 0.344707},
	{0.290414, -0.939024, 0.184027},
	{0.275369, -0.814173, 0.511124},
	{0.190710, -0.922605, 0.335215},
	{-0.757530, 0.349406, 0.551378},
	{-0.937162, 0.186743, 0.294687},
	{-0.763665, 0.345561, 0.545305},
	{-0.938627, 0.184576, 0.291299},
	{-0.813715, 0.511551, 0.275948},
	{-0.922422, 0.335521, 0.191107},
	{0.192969, 0.921323, -0.337504},
	{0.254006, 0.948393, -0.189734},
	{0.510392, 0.778008, -0.366314},
	{0.279611, 0.813959, -0.509171},
	{0.220862, 0.950011, -0.220588},
	{0.443312, 0.777856, -0.445418},
	{0.212104, 0.938292, -0.273049},
	{0.390728, 0.760552, -0.518509},
	{-0.949217, -0.219489, -0.225288},
	{-0.939970, -0.269448, -0.209296},
	{-0.765801, -0.516770, -0.382702},
	{-0.782067, -0.435530, -0.445662},
	{-0.948057, -0.191290, -0.254097},
	{-0.776299, -0.370159, -0.510208},
	{-0.917753, -0.347667, -0.191900},
	{-0.805170, -0.520188, -0.284738},
	{0.188055, 0.940214, -0.283883},
	{0.354442, 0.760613, -0.543870},
	{0.182989, 0.939726, -0.288797},
	{0.343333, 0.767174, -0.541795},
	{0.334849, 0.922849, -0.190191},
	{0.510636, 0.814692, -0.274667},
	{0.332499, -0.193548, 0.923002},
	{0.189001, -0.253975, 0.948546},
	{0.364452, -0.510483, 0.778802},
	{0.503800, -0.276803, 0.818232},
	{0.219489, -0.225288, 0.949217},
	{0.435530, -0.445662, 0.782067},
	{0.269295, -0.209204, 0.940031},
	{0.516404, -0.382488, 0.766137},
	{0.294015, -0.186316, 0.937437},
	{0.550066, -0.348582, 0.758843},
	{0.290414, -0.184027, 0.939024},
	{0.543962, -0.344707, 0.765007},
	{0.190710, -0.335215, 0.922605},
	{0.275369, -0.511124, 0.814173},
	{-0.937162, -0.294687, -0.186743},
	{-0.757530, -0.551378, -0.349406},
	{-0.938627, -0.291299, -0.184576},
	{-0.763665, -0.545305, -0.345561},
	{-0.922422, -0.191107, -0.335521},
	{-0.813715, -0.275948, -0.511551},
	{0.192969, 0.337504, 0.921323},
	{0.254006, 0.189734, 0.948393},
	{0.510392, 0.366314, 0.778008},
	{0.279611, 0.509171, 0.813959},
	{0.220862, 0.220588, 0.950011},
	{0.443312, 0.445418, 0.777856},
	{0.212104, 0.273049, 0.938292},
	{0.390728, 0.518509, 0.760552},
	{-0.949217, 0.225288, -0.219489},
	{-0.939970, 0.209296, -0.269448},
	{-0.765801, 0.382702, -0.516770},
	{-0.782067, 0.445662, -0.435530},
	{-0.948057, 0.254097, -0.191290},
	{-0.776299, 0.510208, -0.370159},
	{-0.917753, 0.191900, -0.347667},
	{-0.805170, 0.284738, -0.520188},
	{0.188055, 0.283883, 0.940214},
	{0.354442, 0.543870, 0.760613},
	{0.182989, 0.288797, 0.939726},
	{0.343333, 0.541795, 0.767174},
	{0.334849, 0.190191, 0.922849},
	{0.510636, 0.274667, 0.814692},
	{0.332499, -0.923002, -0.193548},
	{0.189001, -0.948546, -0.253975},
	{0.364452, -0.778802, -0.510483},
	{0.503800, -0.818232, -0.276803},
	{0.219489, -0.949217, -0.225288},
	{0.435530, -0.782067, -0.445662},
	{0.269295, -0.940031, -0.209204},
	{0.516404, -0.766137, -0.382488},
	{0.294015, -0.937437, -0.186316},
	{0.550066, -0.758843, -0.348582},
	{0.290414, -0.939024, -0.184027},
	{0.543962, -0.765007, -0.344707},
	{0.190710, -0.922605, -0.335215},
	{0.275369, -0.814173, -0.511124},
	{-0.937162, 0.186743, -0.294687},
	{-0.757530, 0.349406, -0.551378},
	{-0.938627, 0.184576, -0.291299},
	{-0.763665, 0.345561, -0.545305},
	{-0.922422, 0.335521, -0.191107},
	{-0.813715, 0.511551, -0.275948},
	{-0.192969, 0.921323, -0.337504},
	{-0.279611, 0.813959, -0.509171},
	{-0.510392, 0.778008, -0.366314},
	{-0.254006, 0.948393, -0.189734},
	{-0.443312, 0.777856, -0.445418},
	{-0.220862, 0.950011, -0.220588},
	{-0.390728, 0.760552, -0.518509},
	{-0.212104, 0.938292, -0.273049},
	{0.949217, -0.219489, -0.225288},
	{0.782067, -0.435530, -0.445662},
	{0.765801, -0.516770, -0.382702},
	{0.939970, -0.269448, -0.209296},
	{0.948057, -0.191290, -0.254097},
	{0.776299, -0.370159, -0.510208},
	{0.917753, -0.347667, -0.191900},
	{0.805170, -0.520188, -0.284738},
	{-0.354442, 0.760613, -0.543870},
	{-0.188055, 0.940214, -0.283883},
	{-0.343333, 0.767174, -0.541795},
	{-0.182989, 0.939726, -0.288797},
	{-0.510636, 0.814692, -0.274667},
	{-0.334849, 0.922849, -0.190191},
	{-0.332499, -0.193548, 0.923002},
	{-0.503800, -0.276803, 0.818232},
	{-0.364452, -0.510483, 0.778802},
	{-0.189001, -0.253975, 0.948546},
	{-0.435530, -0.445662, 0.782067},
	{-0.219489, -0.225288, 0.949217},
	{-0.516404, -0.382488, 0.766137},
	{-0.269295, -0.209204, 0.940031},
	{-0.550066, -0.348582, 0.758843},
	{-0.294015, -0.186316, 0.937437},
	{-0.543962, -0.344707, 0.765007},
	{-0.290414, -0.184027, 0.939024},
	{-0.275369, -0.511124, 0.814173},
	{-0.190710, -0.335215, 0.922605},
	{0.757530, -0.551378, -0.349406},
	{0.937162, -0.294687, -0.186743},
	{0.763665, -0.545305, -0.345561},
	{0.938627, -0.291299, -0.184576},
	{0.813715, -0.275948, -0.511551},
	{0.922422, -0.191107, -0.335521},
	{-0.192969, 0.337504, 0.921323},
	{-0.279611, 0.509171, 0.813959},
	{-0.510392, 0.366314, 0.778008},
	{-0.254006, 0.189734, 0.948393},
	{-0.443312, 0.445418, 0.777856},
	{-0.220862, 0.220588, 0.950011},
	{-0.390728, 0.518509, 0.760552},
	{-0.212104, 0.273049, 0.938292},
	{0.949217, 0.225288, -0.219489},
	{0.782067, 0.445662, -0.435499},
	{0.765801, 0.382702, -0.516770},
	{0.939970, 0.209296, -0.269448},
	{0.948057, 0.254097, -0.191290},
	{0.776299, 0.510208, -0.370159},
	{0.917753, 0.191900, -0.347667},
	{0.805170, 0.284738, -0.520188},
	{-0.354442, 0.543870, 0.760613},
	{-0.188055, 0.283883, 0.940214},
	{-0.343333, 0.541795, 0.767174},
	{-0.182989, 0.288797, 0.939726},
	{-0.510636, 0.274667, 0.814692},
	{-0.334849, 0.190191, 0.922849},
	{-0.332499, -0.923002, -0.193548},
	{-0.503800, -0.818232, -0.276803},
	{-0.364452, -0.778802, -0.510483},
	{-0.189001, -0.948546, -0.253975},
	{-0.435530, -0.782067, -0.445662},
	{-0.219489, -0.949217, -0.225288},
	{-0.516404, -0.766137, -0.382488},
	{-0.269295, -0.940031, -0.209204},
	{-0.550066, -0.758843, -0.348582},
	{-0.294015, -0.937437, -0.186316},
	{-0.543962, -0.765007, -0.344707},
	{-0.290414, -0.939024, -0.184027},
	{-0.275369, -0.814173, -0.511124},
	{-0.190710, -0.922605, -0.335215},
	{0.757530, 0.349406, -0.551378},
	{0.937162, 0.186743, -0.294687},
	{0.763665, 0.345561, -0.545305},
	{0.938627, 0.184576, -0.291299},
	{0.813715, 0.511551, -0.275948},
	{0.922422, 0.335521, -0.191107},
	{0.000122, -0.854793, 0.518937},
	{-0.057375, -0.848994, 0.525254},
	{-0.110385, -0.414838, 0.903134},
	{0.000366, -0.424848, 0.905240},
	{0.161443, -0.804743, 0.571215},
	{0.315409, -0.527299, 0.788934},
	{0.058596, -0.849147, 0.524857},
	{0.113254, -0.414167, 0.903104},
	{-0.152837, -0.804865, 0.573412},
	{-0.304483, -0.524735, 0.794916},
	{-0.152837, 0.573412, -0.804865},
	{-0.304483, 0.794916, -0.524735},
	{0.113254, 0.903104, -0.414167},
	{0.058596, 0.524857, -0.849147},
	{0.000366, 0.905240, -0.424848},
	{0.000122, 0.518937, -0.854793},
	{-0.057375, 0.525254, -0.848994},
	{-0.110385, 0.903134, -0.414838},
	{0.315409, 0.788934, -0.527299},
	{0.161443, 0.571184, -0.804743},
	{-0.000122, 0.854793, 0.518937},
	{0.057375, 0.848994, 0.525254},
	{0.110385, 0.414838, 0.903134},
	{-0.000366, 0.424848, 0.905240},
	{-0.161443, 0.804743, 0.571184},
	{-0.315409, 0.527299, 0.788934},
	{-0.058596, 0.849147, 0.524857},
	{-0.113254, 0.414167, 0.903104},
	{0.152837, 0.804865, 0.573412},
	{0.304483, 0.524766, 0.794916},
	{0.152837, -0.573412, -0.804865},
	{0.304483, -0.794916, -0.524735},
	{-0.113254, -0.903104, -0.414167},
	{-0.058596, -0.524857, -0.849147},
	{-0.000366, -0.905240, -0.424848},
	{-0.000122, -0.518937, -0.854793},
	{0.057375, -0.525254, -0.848994},
	{0.110385, -0.903134, -0.414838},
	{-0.315409, -0.788934, -0.527299},
	{-0.161443, -0.571184, -0.804743},
	{0.854793, 0.000122, 0.518937},
	{0.848994, -0.057375, 0.525254},
	{0.414838, -0.110385, 0.903134},
	{0.424848, 0.000366, 0.905240},
	{0.804743, 0.161443, 0.571184},
	{0.527299, 0.315409, 0.788934},
	{0.849147, 0.058596, 0.524857},
	{0.414167, 0.113254, 0.903104},
	{0.804865, -0.152837, 0.573412},
	{0.524766, -0.304483, 0.794916},
	{-0.573412, -0.152837, -0.804865},
	{-0.794916, -0.304483, -0.524735},
	{-0.903104, 0.113254, -0.414167},
	{-0.524857, 0.058596, -0.849147},
	{-0.905240, 0.000366, -0.424848},
	{-0.518937, 0.000122, -0.854793},
	{-0.525254, -0.057375, -0.848994},
	{-0.903134, -0.110385, -0.414838},
	{-0.788934, 0.315409, -0.527299},
	{-0.571184, 0.161443, -0.804743},
	{-0.854793, -0.000122, 0.518937},
	{-0.848994, 0.057375, 0.525254},
	{-0.414838, 0.110385, 0.903134},
	{-0.424848, -0.000366, 0.905240},
	{-0.804743, -0.161443, 0.571184},
	{-0.527299, -0.315409, 0.788934},
	{-0.849147, -0.058596, 0.524857},
	{-0.414167, -0.113254, 0.903104},
	{-0.804865, 0.152837, 0.573412},
	{-0.524735, 0.304483, 0.794916},
	{0.573412, 0.152837, -0.804865},
	{0.794916, 0.304483, -0.524766},
	{0.903104, -0.113254, -0.414167},
	{0.524857, -0.058596, -0.849147},
	{0.905240, -0.000366, -0.424848},
	{0.518937, -0.000122, -0.854793},
	{0.525254, 0.057375, -0.848994},
	{0.903134, 0.110385, -0.414838},
	{0.788934, -0.315409, -0.527299},
	{0.571184, -0.161443, -0.804743},
	{-0.854793, 0.518937, 0.000122},
	{-0.848994, 0.525254, -0.057375},
	{-0.414838, 0.903134, -0.110385},
	{-0.424848, 0.905240, 0.000366},
	{-0.804743, 0.571184, 0.161443},
	{-0.527299, 0.788934, 0.315409},
	{-0.849147, 0.524827, 0.058596},
	{-0.414167, 0.903104, 0.113254},
	{-0.804865, 0.573412, -0.152837},
	{-0.524766, 0.794916, -0.304483},
	{0.573412, -0.804865, -0.152837},
	{0.794916, -0.524735, -0.304483},
	{0.903104, -0.414167, 0.113254},
	{0.524857, -0.849147, 0.058596},
	{0.905240, -0.424848, 0.000366},
	{0.518937, -0.854793, 0.000122},
	{0.525254, -0.848994, -0.057375},
	{0.903134, -0.414838, -0.110385},
	{0.788934, -0.527299, 0.315409},
	{0.571184, -0.804743, 0.161443},
	{-0.854793, -0.518937, -0.000122},
	{-0.848994, -0.525254, 0.057375},
	{-0.414838, -0.903134, 0.110385},
	{-0.424848, -0.905240, -0.000366},
	{-0.804743, -0.571184, -0.161443},
	{-0.527299, -0.788934, -0.315409},
	{-0.849147, -0.524857, -0.058596},
	{-0.414167, -0.903104, -0.113254},
	{-0.804865, -0.573412, 0.152837},
	{-0.524735, -0.794916, 0.304483},
	{0.573412, 0.804865, 0.152837},
	{0.794916, 0.524735, 0.304483},
	{0.903104, 0.414167, -0.113254},
	{0.524857, 0.849147, -0.058596},
	{0.905240, 0.424848, -0.000366},
	{0.518937, 0.854793, -0.000122},
	{0.525254, 0.848994, 0.057375},
	{0.903134, 0.414838, 0.110385},
	{0.788934, 0.527299, -0.315409},
	{0.571184, 0.804743, -0.161443},
	{0.854793, -0.518937, 0.000122},
	{0.848994, -0.525254, -0.057375},
	{0.414838, -0.903134, -0.110385},
	{0.424848, -0.905240, 0.000366},
	{0.804743, -0.571184, 0.161443},
	{0.527299, -0.788934, 0.315409},
	{0.849147, -0.524857, 0.058596},
	{0.414167, -0.903104, 0.113254},
	{0.804865, -0.573412, -0.152837},
	{0.524735, -0.794916, -0.304483},
	{-0.573412, 0.804865, -0.152837},
	{-0.794916, 0.524766, -0.304483},
	{-0.903104, 0.414167, 0.113254},
	{-0.524857, 0.849147, 0.058596},
	{-0.905240, 0.424848, 0.000366},
	{-0.518937, 0.854793, 0.000122},
	{-0.525254, 0.848994, -0.057375},
	{-0.903134, 0.414838, -0.110385},
	{-0.788934, 0.527299, 0.315409},
	{-0.571184, 0.804743, 0.161443},
	{0.854793, 0.518937, -0.000122},
	{0.848994, 0.525254, 0.057375},
	{0.414838, 0.903134, 0.110385},
	{0.424848, 0.905240, -0.000366},
	{0.804743, 0.571184, -0.161443},
	{0.527299, 0.788934, -0.315409},
	{0.849147, 0.524857, -0.058596},
	{0.414167, 0.903104, -0.113254},
	{0.804865, 0.573412, 0.152837},
	{0.524735, 0.794916, 0.304483},
	{-0.573412, -0.804865, 0.152837},
	{-0.794916, -0.524735, 0.304483},
	{-0.903104, -0.414167, -0.113254},
	{-0.524857, -0.849147, -0.058596},
	{-0.905240, -0.424848, -0.000366},
	{-0.518937, -0.854793, -0.000122},
	{-0.525254, -0.848994, 0.057375},
	{-0.903134, -0.414838, 0.110385},
	{-0.788934, -0.527299, -0.315409},
	{-0.571184, -0.804743, -0.161443},
	{-0.000122, -0.854793, -0.518937},
	{0.057375, -0.848994, -0.525254},
	{0.110385, -0.414838, -0.903134},
	{-0.000366, -0.424848, -0.905240},
	{-0.161443, -0.804743, -0.571184},
	{-0.315409, -0.527299, -0.788934},
	{-0.058596, -0.849147, -0.524857},
	{-0.113254, -0.414167, -0.903104},
	{0.152837, -0.804865, -0.573412},
	{0.304483, -0.524735, -0.794916},
	{0.152837, 0.573412, 0.804865},
	{0.304483, 0.794916, 0.524735},
	{-0.113254, 0.903104, 0.414167},
	{-0.058596, 0.524857, 0.849147},
	{-0.000366, 0.905240, 0.424848},
	{-0.000122, 0.518937, 0.854793},
	{0.057375, 0.525254, 0.848994},
	{0.110385, 0.903134, 0.414838},
	{-0.315409, 0.788934, 0.527299},
	{-0.161443, 0.571184, 0.804743},
	{0.000122, 0.854793, -0.518937},
	{-0.057375, 0.848994, -0.525254},
	{-0.110385, 0.414838, -0.903134},
	{0.000366, 0.424848, -0.905240},
	{0.161443, 0.804743, -0.571184},
	{0.315409, 0.527299, -0.788934},
	{0.058596, 0.849147, -0.524857},
	{0.113254, 0.414167, -0.903104},
	{-0.152837, 0.804865, -0.573412},
	{-0.304483, 0.524735, -0.794916},
	{-0.152837, -0.573412, 0.804865},
	{-0.304483, -0.794916, 0.524735},
	{0.113254, -0.903104, 0.414167},
	{0.058596, -0.524857, 0.849147},
	{0.000366, -0.905240, 0.424848},
	{0.000122, -0.518937, 0.854793},
	{-0.057375, -0.525254, 0.848994},
	{-0.110385, -0.903134, 0.414838},
	{0.315409, -0.788934, 0.527299},
	{0.161443, -0.571184, 0.804743},
	{-0.854793, 0.000122, -0.518937},
	{-0.848994, -0.057375, -0.525254},
	{-0.414838, -0.110385, -0.903134},
	{-0.424848, 0.000366, -0.905240},
	{-0.804743, 0.161443, -0.571184},
	{-0.527299, 0.315409, -0.788934},
	{-0.849147, 0.058596, -0.524857},
	{-0.414167, 0.113254, -0.903104},
	{-0.804865, -0.152837, -0.573412},
	{-0.524735, -0.304483, -0.794916},
	{0.573412, -0.152837, 0.804865},
	{0.794916, -0.304483, 0.524735},
	{0.903104, 0.113254, 0.414167},
	{0.524857, 0.058596, 0.849147},
	{0.905240, 0.000366, 0.424848},
	{0.518937, 0.000122, 0.854793},
	{0.525254, -0.057375, 0.848994},
	{0.903134, -0.110385, 0.414838},
	{0.788934, 0.315409, 0.527299},
	{0.571184, 0.161443, 0.804743},
	{0.854793, -0.000122, -0.518937},
	{0.848994, 0.057375, -0.525254},
	{0.414838, 0.110385, -0.903134},
	{0.424848, -0.000366, -0.905240},
	{0.804743, -0.161443, -0.571184},
	{0.527299, -0.315409, -0.788934},
	{0.849147, -0.058596, -0.524857},
	{0.414167, -0.113254, -0.903104},
	{0.804865, 0.152837, -0.573412},
	{0.524735, 0.304483, -0.794916},
	{-0.573412, 0.152837, 0.804865},
	{-0.794916, 0.304483, 0.524766},
	{-0.903104, -0.113254, 0.414167},
	{-0.524857, -0.058596, 0.849147},
	{-0.905240, -0.000366, 0.424848},
	{-0.518937, -0.000122, 0.854793},
	{-0.525254, 0.057375, 0.848994},
	{-0.903134, 0.110385, 0.414838},
	{-0.788934, -0.315409, 0.527299},
	{-0.571184, -0.161443, 0.804743},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000001, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, -0.000000},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000002},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, 0.000001},
	{-0.000000, 1.000000, 0.000001},
	{-0.000002, -1.000000, 0.000000},
	{-0.000002, -1.000000, 0.000000},
	{-0.000002, -1.000000, 0.000000},
	{-0.000002, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{-0.000001, -1.000000, 0.000000},
	{0.000000, -1.000000, -0.000002},
	{0.000000, -1.000000, -0.000002},
	{0.000000, -1.000000, -0.000002},
	{0.000000, -1.000000, -0.000002},
	{0.000000, -1.000000, -0.000002},
	{0.000000, -1.000000, -0.000002},
	{0.000000, -1.000000, -0.000002},
	{0.000000, -1.000000, -0.000002},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000000, 0.000000},
	{1.000000, -0.000002, 0.000000},
	{1.000000, -0.000002, 0.000000},
	{1.000000, -0.000002, 0.000000},
	{1.000000, -0.000002, 0.000000},
	{1.000000, 0.000000, -0.000002},
	{1.000000, 0.000000, -0.000002},
	{1.000000, 0.000000, -0.000002},
	{1.000000, 0.000000, -0.000002},
	{1.000000, 0.000000, -0.000004},
	{1.000000, 0.000000, -0.000004},
	{1.000000, 0.000000, -0.000004},
	{1.000000, 0.000000, -0.000004},
	{0.000000, -0.000002, -1.000000},
	{0.000000, -0.000002, -1.000000},
	{0.000000, -0.000002, -1.000000},
	{0.000000, -0.000002, -1.000000},
	{0.000000, -0.000001, -1.000000},
	{0.000000, -0.000001, -1.000000},
	{0.000000, -0.000001, -1.000000},
	{0.000000, -0.000001, -1.000000},
	{-0.000002, 0.000000, -1.000000},
	{-0.000002, 0.000000, -1.000000},
	{-0.000002, 0.000000, -1.000000},
	{-0.000002, 0.000000, -1.000000},
	{-0.000002, 0.000000, -1.000000},
	{-0.000002, 0.000000, -1.000000},
	{-0.000002, 0.000000, -1.000000},
	{-0.000002, 0.000000, -1.000000},
	{-1.000000, -0.000004, 0.000000},
	{-1.000000, -0.000004, 0.000000},
	{-1.000000, -0.000004, 0.000000},
	{-1.000000, -0.000004, 0.000000},
	{-1.000000, -0.000004, 0.000000},
	{-1.000000, -0.000004, 0.000000},
	{-1.000000, -0.000004, 0.000000},
	{-1.000000, -0.000004, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000000, 0.000000},
	{-1.000000, 0.000001, 0.000000},
	{-1.000000, 0.000001, 0.000000},
	{-1.000000, 0.000001, 0.000000},
	{-1.000000, 0.000001, 0.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{-0.000000, 0.000000, 1.000000},
	{0.000000, -0.000003, 1.000000},
	{0.000000, -0.000003, 1.000000},
	{0.000000, -0.000003, 1.000000},
	{0.000000, -0.000003, 1.000000},
	{0.000003, -0.000000, 1.000000},
	{0.000003, -0.000000, 1.000000},
	{0.000003, -0.000000, 1.000000},
	{0.000003, -0.000000, 1.000000},
	{0.000002, -0.000000, 1.000000},
	{0.000002, -0.000000, 1.000000},
	{0.000002, -0.000000, 1.000000},
	{0.000002, -0.000000, 1.000000},
};

short
companion_triangles[COMPANION_TRIANGLE_COUNT][3] = {
	{0, 1, 2},
	{0, 2, 3},
	{4, 5, 6},
	{0, 7, 8},
	{0, 8, 9},
	{0, 9, 10},
	{0, 10, 11},
	{0, 11, 12},
	{0, 12, 13},
	{0, 13, 14},
	{0, 14, 15},
	{16, 17, 18},
	{0, 19, 20},
	{0, 20, 21},
	{0, 21, 22},
	{0, 22, 23},
	{0, 23, 24},
	{0, 24, 25},
	{0, 25, 26},
	{0, 26, 27},
	{0, 27, 28},
	{0, 28, 29},
	{0, 29, 30},
	{31, 32, 33},
	{0, 34, 35},
	{0, 35, 36},
	{0, 36, 37},
	{0, 37, 38},
	{0, 38, 39},
	{0, 39, 40},
	{0, 40, 41},
	{41, 1, 0},
	{42, 43, 44},
	{42, 44, 45},
	{46, 47, 48},
	{46, 48, 49},
	{46, 49, 50},
	{46, 50, 51},
	{46, 51, 52},
	{53, 54, 55},
	{42, 56, 57},
	{42, 57, 58},
	{42, 58, 59},
	{42, 59, 60},
	{42, 60, 61},
	{42, 61, 62},
	{42, 62, 63},
	{42, 63, 64},
	{42, 64, 65},
	{42, 65, 66},
	{67, 68, 69},
	{42, 70, 71},
	{42, 71, 72},
	{42, 72, 73},
	{42, 73, 74},
	{42, 74, 75},
	{42, 75, 76},
	{42, 76, 77},
	{46, 78, 79},
	{80, 81, 82},
	{67, 83, 84},
	{67, 84, 85},
	{42, 86, 87},
	{87, 43, 42},
	{88, 89, 90},
	{88, 90, 91},
	{88, 91, 92},
	{88, 92, 93},
	{88, 93, 94},
	{95, 96, 97},
	{88, 98, 99},
	{88, 99, 100},
	{88, 100, 101},
	{102, 103, 104},
	{88, 105, 106},
	{88, 106, 107},
	{88, 107, 108},
	{109, 110, 111},
	{88, 112, 113},
	{88, 113, 114},
	{88, 114, 115},
	{88, 115, 116},
	{88, 116, 117},
	{88, 117, 118},
	{88, 118, 119},
	{88, 119, 120},
	{88, 120, 121},
	{88, 121, 122},
	{88, 122, 123},
	{109, 124, 125},
	{88, 126, 127},
	{88, 127, 128},
	{88, 128, 129},
	{109, 130, 131},
	{88, 132, 133},
	{133, 89, 88},
	{134, 135, 136},
	{134, 136, 137},
	{134, 137, 138},
	{134, 138, 139},
	{140, 141, 142},
	{134, 143, 144},
	{134, 144, 145},
	{134, 145, 146},
	{147, 148, 149},
	{134, 150, 151},
	{134, 151, 152},
	{134, 152, 153},
	{134, 153, 154},
	{147, 155, 156},
	{134, 157, 158},
	{134, 158, 159},
	{134, 159, 160},
	{134, 160, 161},
	{134, 161, 162},
	{134, 162, 163},
	{134, 163, 164},
	{134, 164, 165},
	{134, 165, 166},
	{134, 166, 167},
	{134, 167, 168},
	{134, 168, 169},
	{134, 169, 170},
	{134, 170, 171},
	{134, 171, 172},
	{134, 172, 173},
	{134, 173, 174},
	{175, 176, 177},
	{178, 179, 180},
	{181, 182, 183},
	{181, 183, 184},
	{181, 184, 185},
	{181, 185, 186},
	{181, 186, 187},
	{181, 187, 188},
	{181, 188, 189},
	{181, 189, 190},
	{181, 190, 191},
	{181, 191, 192},
	{181, 192, 193},
	{181, 193, 194},
	{181, 194, 195},
	{196, 197, 198},
	{181, 199, 200},
	{181, 200, 201},
	{181, 201, 202},
	{181, 202, 203},
	{181, 203, 204},
	{181, 204, 205},
	{181, 205, 206},
	{181, 206, 207},
	{208, 209, 210},
	{211, 212, 213},
	{181, 214, 215},
	{181, 215, 216},
	{181, 216, 217},
	{181, 217, 218},
	{181, 218, 219},
	{181, 219, 220},
	{220, 221, 181},
	{222, 223, 224},
	{222, 224, 225},
	{222, 225, 226},
	{222, 226, 227},
	{222, 227, 228},
	{222, 228, 229},
	{222, 229, 230},
	{222, 230, 231},
	{222, 231, 232},
	{222, 232, 233},
	{222, 233, 234},
	{222, 234, 235},
	{222, 235, 236},
	{222, 236, 237},
	{238, 239, 240},
	{222, 241, 242},
	{222, 242, 243},
	{244, 245, 246},
	{222, 247, 248},
	{222, 248, 249},
	{222, 249, 250},
	{222, 250, 251},
	{222, 251, 252},
	{222, 252, 253},
	{222, 253, 254},
	{222, 254, 255},
	{256, 257, 258},
	{238, 259, 260},
	{222, 261, 262},
	{222, 262, 263},
	{222, 263, 264},
	{264, 223, 222},
	{265, 266, 267},
	{265, 267, 268},
	{265, 268, 269},
	{265, 269, 270},
	{265, 270, 271},
	{265, 271, 272},
	{265, 272, 273},
	{274, 275, 276},
	{265, 277, 278},
	{279, 280, 281},
	{265, 282, 283},
	{279, 284, 285},
	{265, 286, 287},
	{265, 287, 288},
	{265, 288, 289},
	{265, 289, 290},
	{291, 292, 293},
	{265, 294, 295},
	{265, 295, 296},
	{265, 296, 297},
	{265, 297, 298},
	{265, 298, 299},
	{265, 299, 300},
	{265, 300, 301},
	{265, 301, 302},
	{265, 302, 303},
	{265, 303, 304},
	{279, 305, 306},
	{265, 307, 308},
	{265, 308, 309},
	{265, 309, 310},
	{310, 266, 265},
	{311, 312, 313},
	{314, 315, 316},
	{311, 317, 318},
	{311, 318, 319},
	{311, 319, 320},
	{311, 320, 321},
	{322, 323, 324},
	{311, 325, 326},
	{311, 326, 327},
	{328, 329, 330},
	{311, 331, 332},
	{311, 332, 333},
	{311, 333, 334},
	{311, 334, 335},
	{328, 336, 337},
	{311, 338, 339},
	{340, 341, 342},
	{311, 343, 344},
	{311, 344, 345},
	{311, 345, 346},
	{347, 348, 349},
	{311, 350, 351},
	{322, 352, 353},
	{311, 354, 355},
	{311, 355, 356},
	{328, 357, 358},
	{311, 359, 360},
	{311, 360, 361},
	{311, 361, 362},
	{311, 362, 363},
	{311, 363, 364},
	{364, 312, 311},
	{365, 366, 367},
	{368, 369, 370},
	{368, 370, 371},
	{368, 371, 372},
	{368, 372, 373},
	{368, 373, 374},
	{368, 374, 375},
	{368, 375, 376},
	{368, 376, 377},
	{368, 377, 378},
	{368, 378, 379},
	{368, 379, 380},
	{381, 382, 383},
	{368, 384, 385},
	{368, 385, 386},
	{368, 386, 387},
	{365, 388, 389},
	{368, 390, 391},
	{392, 393, 394},
	{368, 395, 396},
	{368, 396, 397},
	{368, 397, 398},
	{368, 398, 399},
	{368, 399, 400},
	{368, 400, 401},
	{381, 402, 403},
	{368, 404, 405},
	{368, 405, 406},
	{368, 406, 407},
	{368, 407, 408},
	{368, 408, 409},
	{410, 411, 381},
	{412, 413, 414},
	{412, 414, 415},
	{412, 415, 416},
	{412, 416, 417},
	{412, 417, 418},
	{412, 418, 419},
	{412, 419, 420},
	{412, 420, 421},
	{422, 423, 424},
	{412, 425, 426},
	{412, 426, 427},
	{412, 427, 428},
	{412, 428, 429},
	{422, 430, 431},
	{412, 432, 433},
	{412, 433, 434},
	{412, 434, 435},
	{412, 435, 436},
	{412, 436, 437},
	{412, 437, 438},
	{412, 438, 439},
	{440, 441, 442},
	{412, 443, 444},
	{412, 444, 445},
	{412, 445, 446},
	{412, 446, 447},
	{422, 448, 449},
	{412, 450, 451},
	{412, 451, 452},
	{412, 452, 453},
	{412, 453, 454},
	{454, 413, 412},
	{455, 456, 457},
	{455, 457, 458},
	{455, 458, 459},
	{455, 459, 460},
	{455, 460, 461},
	{455, 461, 462},
	{455, 462, 463},
	{455, 463, 464},
	{455, 464, 465},
	{455, 465, 466},
	{467, 468, 469},
	{455, 470, 471},
	{455, 471, 472},
	{455, 472, 473},
	{455, 473, 474},
	{455, 474, 475},
	{476, 477, 478},
	{455, 479, 480},
	{481, 482, 483},
	{455, 484, 485},
	{455, 485, 486},
	{455, 486, 487},
	{455, 487, 488},
	{455, 488, 489},
	{455, 489, 490},
	{455, 490, 491},
	{455, 491, 492},
	{455, 492, 493},
	{455, 493, 494},
	{455, 494, 495},
	{455, 495, 496},
	{497, 498, 499},
	{500, 501, 502},
	{503, 504, 505},
	{506, 507, 508},
	{500, 509, 510},
	{500, 510, 511},
	{500, 511, 512},
	{506, 513, 514},
	{500, 515, 516},
	{500, 516, 517},
	{500, 517, 518},
	{500, 518, 519},
	{500, 519, 520},
	{500, 520, 521},
	{500, 521, 522},
	{500, 522, 523},
	{500, 523, 524},
	{500, 524, 525},
	{500, 525, 526},
	{500, 526, 527},
	{500, 527, 528},
	{500, 528, 529},
	{500, 529, 530},
	{500, 530, 531},
	{500, 531, 532},
	{500, 532, 533},
	{500, 533, 534},
	{535, 536, 537},
	{500, 538, 539},
	{535, 540, 541},
	{500, 542, 543},
	{500, 543, 544},
	{544, 501, 500},
	{545, 546, 547},
	{545, 547, 548},
	{549, 547, 546},
	{549, 546, 550},
	{551, 552, 553},
	{551, 553, 554},
	{555, 556, 557},
	{555, 557, 558},
	{559, 560, 561},
	{559, 561, 562},
	{560, 549, 550},
	{560, 550, 561},
	{563, 564, 565},
	{563, 565, 566},
	{567, 568, 569},
	{567, 569, 570},
	{571, 572, 573},
	{571, 573, 574},
	{575, 576, 577},
	{575, 577, 578},
	{564, 579, 580},
	{564, 580, 565},
	{581, 580, 579},
	{581, 579, 582},
	{583, 584, 585},
	{583, 585, 586},
	{586, 585, 587},
	{586, 587, 588},
	{589, 590, 591},
	{589, 591, 592},
	{588, 587, 590},
	{588, 590, 589},
	{593, 594, 595},
	{593, 595, 596},
	{597, 548, 547},
	{597, 547, 598},
	{596, 595, 599},
	{596, 599, 600},
	{598, 547, 549},
	{598, 549, 601},
	{602, 603, 604},
	{602, 604, 605},
	{603, 606, 607},
	{603, 607, 604},
	{608, 609, 603},
	{608, 603, 602},
	{601, 549, 560},
	{601, 560, 610},
	{611, 612, 613},
	{611, 613, 614},
	{615, 616, 617},
	{615, 617, 618},
	{619, 620, 621},
	{619, 621, 622},
	{623, 621, 620},
	{623, 620, 624},
	{625, 623, 624},
	{625, 624, 626},
	{627, 628, 629},
	{627, 629, 630},
	{631, 629, 628},
	{631, 628, 632},
	{633, 634, 635},
	{633, 635, 636},
	{637, 638, 639},
	{637, 639, 640},
	{641, 642, 643},
	{641, 643, 644},
	{645, 631, 632},
	{645, 632, 646},
	{647, 648, 649},
	{650, 651, 652},
	{650, 652, 653},
	{654, 655, 656},
	{654, 656, 657},
	{657, 656, 658},
	{657, 658, 659},
	{660, 661, 662},
	{660, 662, 663},
	{659, 658, 664},
	{659, 664, 665},
	{666, 667, 668},
	{666, 668, 669},
	{655, 670, 671},
	{655, 671, 656},
	{670, 630, 629},
	{670, 629, 671},
	{656, 671, 672},
	{656, 672, 658},
	{671, 629, 631},
	{671, 631, 672},
	{673, 674, 675},
	{673, 675, 676},
	{677, 678, 679},
	{677, 679, 680},
	{658, 672, 681},
	{658, 681, 664},
	{672, 631, 645},
	{672, 645, 681},
	{682, 683, 684},
	{682, 684, 685},
	{686, 687, 688},
	{686, 688, 689},
	{690, 691, 687},
	{690, 687, 686},
	{692, 693, 694},
	{692, 694, 695},
	{696, 697, 698},
	{696, 698, 699},
	{699, 698, 700},
	{699, 700, 701},
	{702, 703, 697},
	{702, 697, 696},
	{704, 705, 703},
	{704, 703, 702},
	{697, 706, 707},
	{697, 707, 698},
	{706, 564, 563},
	{706, 563, 707},
	{698, 707, 708},
	{698, 708, 700},
	{709, 710, 711},
	{709, 711, 712},
	{703, 713, 706},
	{703, 706, 697},
	{713, 579, 564},
	{713, 564, 706},
	{705, 714, 713},
	{705, 713, 703},
	{714, 582, 579},
	{714, 579, 713},
	{715, 716, 717},
	{715, 717, 718},
	{719, 720, 721},
	{719, 721, 722},
	{723, 724, 716},
	{723, 716, 715},
	{725, 726, 727},
	{725, 727, 728},
	{729, 730, 731},
	{729, 731, 732},
	{733, 731, 730},
	{733, 730, 734},
	{735, 736, 737},
	{735, 737, 738},
	{739, 740, 741},
	{739, 741, 742},
	{743, 744, 745},
	{743, 745, 746},
	{744, 733, 734},
	{744, 734, 745},
	{747, 748, 749},
	{747, 749, 750},
	{751, 747, 750},
	{751, 750, 752},
	{753, 754, 755},
	{753, 755, 756},
	{757, 758, 759},
	{757, 759, 760},
	{748, 761, 762},
	{748, 762, 749},
	{763, 762, 761},
	{763, 761, 764},
	{765, 766, 767},
	{765, 767, 768},
	{768, 767, 769},
	{768, 769, 770},
	{771, 772, 773},
	{771, 773, 774},
	{770, 769, 772},
	{770, 772, 771},
	{766, 775, 776},
	{766, 776, 767},
	{775, 732, 731},
	{775, 731, 776},
	{767, 776, 777},
	{767, 777, 769},
	{776, 731, 733},
	{776, 733, 777},
	{772, 778, 779},
	{772, 779, 773},
	{778, 744, 743},
	{778, 743, 779},
	{769, 777, 778},
	{769, 778, 772},
	{777, 733, 744},
	{777, 744, 778},
	{780, 781, 782},
	{780, 782, 783},
	{784, 785, 786},
	{784, 786, 787},
	{786, 788, 789},
	{786, 789, 787},
	{790, 791, 792},
	{790, 792, 793},
	{794, 790, 793},
	{794, 793, 795},
	{796, 797, 798},
	{796, 798, 799},
	{800, 798, 797},
	{800, 797, 801},
	{802, 803, 804},
	{802, 804, 805},
	{806, 807, 808},
	{806, 808, 809},
	{810, 811, 812},
	{810, 812, 813},
	{814, 800, 801},
	{814, 801, 815},
	{816, 817, 818},
	{819, 820, 821},
	{819, 821, 822},
	{823, 824, 825},
	{823, 825, 826},
	{826, 825, 827},
	{826, 827, 828},
	{829, 830, 831},
	{829, 831, 832},
	{828, 827, 833},
	{828, 833, 834},
	{835, 836, 837},
	{835, 837, 838},
	{824, 839, 840},
	{824, 840, 825},
	{839, 799, 798},
	{839, 798, 840},
	{825, 840, 841},
	{825, 841, 827},
	{840, 798, 800},
	{840, 800, 841},
	{842, 843, 844},
	{842, 844, 845},
	{843, 846, 847},
	{843, 847, 844},
	{827, 841, 848},
	{827, 848, 833},
	{841, 800, 814},
	{841, 814, 848},
	{849, 850, 851},
	{849, 851, 852},
	{853, 854, 850},
	{853, 850, 849},
	{855, 856, 857},
	{855, 857, 858},
	{859, 860, 861},
	{859, 861, 862},
	{863, 864, 865},
	{863, 865, 866},
	{866, 865, 867},
	{866, 867, 868},
	{869, 870, 864},
	{869, 864, 863},
	{871, 872, 870},
	{871, 870, 869},
	{864, 873, 874},
	{864, 874, 865},
	{873, 748, 747},
	{873, 747, 874},
	{865, 874, 875},
	{865, 875, 867},
	{874, 747, 751},
	{874, 751, 875},
	{870, 876, 873},
	{870, 873, 864},
	{876, 761, 748},
	{876, 748, 873},
	{872, 877, 876},
	{872, 876, 870},
	{877, 764, 761},
	{877, 761, 876},
	{878, 879, 880},
	{878, 880, 881},
	{882, 883, 884},
	{882, 884, 885},
	{886, 887, 879},
	{886, 879, 878},
	{888, 889, 890},
	{888, 890, 891},
	{892, 893, 894},
	{892, 894, 895},
	{896, 897, 895},
	{896, 895, 894},
	{898, 899, 900},
	{898, 900, 901},
	{902, 903, 904},
	{902, 904, 905},
	{906, 907, 908},
	{906, 908, 909},
	{909, 908, 897},
	{909, 897, 896},
	{910, 911, 912},
	{910, 912, 913},
	{914, 915, 911},
	{914, 911, 910},
	{916, 917, 918},
	{916, 918, 919},
	{920, 921, 922},
	{920, 922, 923},
	{913, 912, 924},
	{913, 924, 925},
	{926, 927, 925},
	{926, 925, 924},
	{928, 929, 930},
	{928, 930, 931},
	{929, 932, 933},
	{929, 933, 930},
	{934, 935, 936},
	{934, 936, 937},
	{932, 934, 937},
	{932, 937, 933},
	{938, 939, 940},
	{938, 940, 941},
	{942, 943, 894},
	{942, 894, 893},
	{939, 944, 945},
	{939, 945, 940},
	{943, 946, 896},
	{943, 896, 894},
	{947, 948, 949},
	{947, 949, 950},
	{950, 949, 951},
	{950, 951, 952},
	{953, 947, 950},
	{953, 950, 954},
	{946, 955, 909},
	{946, 909, 896},
	{956, 957, 958},
	{956, 958, 959},
	{960, 961, 962},
	{960, 962, 963},
	{962, 961, 964},
	{962, 964, 965},
	{966, 967, 965},
	{966, 965, 964},
	{968, 969, 970},
	{968, 970, 971},
	{972, 973, 974},
	{972, 974, 975},
	{976, 977, 975},
	{976, 975, 974},
	{978, 979, 980},
	{978, 980, 981},
	{982, 983, 984},
	{982, 984, 985},
	{986, 987, 988},
	{986, 988, 989},
	{989, 988, 977},
	{989, 977, 976},
	{990, 991, 992},
	{993, 994, 995},
	{993, 995, 996},
	{997, 998, 999},
	{997, 999, 1000},
	{998, 1001, 1002},
	{998, 1002, 999},
	{1003, 1004, 1005},
	{1003, 1005, 1006},
	{1001, 1003, 1006},
	{1001, 1006, 1002},
	{1007, 1008, 1009},
	{1007, 1009, 1010},
	{1000, 999, 1011},
	{1000, 1011, 1012},
	{1012, 1011, 974},
	{1012, 974, 973},
	{999, 1002, 1013},
	{999, 1013, 1011},
	{1011, 1013, 976},
	{1011, 976, 974},
	{1006, 1005, 1014},
	{1006, 1014, 1015},
	{1015, 1014, 986},
	{1015, 986, 989},
	{1002, 1006, 1015},
	{1002, 1015, 1013},
	{1013, 1015, 989},
	{1013, 989, 976},
	{1016, 1010, 1009},
	{1016, 1009, 1017},
	{1018, 1019, 1020},
	{1018, 1020, 1021},
	{1022, 1023, 1024},
	{1022, 1024, 1025},
	{1026, 1027, 1028},
	{1026, 1028, 1029},
	{1030, 1031, 1032},
	{1030, 1032, 1033},
	{1031, 1034, 1035},
	{1031, 1035, 1032},
	{1036, 1030, 1033},
	{1036, 1033, 1037},
	{1038, 1036, 1037},
	{1038, 1037, 1039},
	{1033, 1032, 1040},
	{1033, 1040, 1041},
	{1041, 1040, 910},
	{1041, 910, 913},
	{1032, 1035, 1042},
	{1032, 1042, 1040},
	{1040, 1042, 914},
	{1040, 914, 910},
	{1037, 1033, 1041},
	{1037, 1041, 1043},
	{1043, 1041, 913},
	{1043, 913, 925},
	{1039, 1037, 1043},
	{1039, 1043, 1044},
	{1044, 1043, 925},
	{1044, 925, 927},
	{1045, 1046, 1047},
	{1045, 1047, 1048},
	{1049, 1047, 1046},
	{1049, 1046, 1050},
	{1051, 1045, 1048},
	{1051, 1048, 1052},
	{1053, 1054, 1055},
	{1053, 1055, 1056},
	{1057, 1058, 1059},
	{1057, 1059, 1060},
	{1061, 1062, 1060},
	{1061, 1060, 1059},
	{1063, 1064, 1065},
	{1063, 1065, 1066},
	{1067, 1068, 1069},
	{1067, 1069, 1070},
	{1071, 1072, 1073},
	{1071, 1073, 1074},
	{1074, 1073, 1062},
	{1074, 1062, 1061},
	{1075, 1076, 1077},
	{1075, 1077, 1078},
	{1079, 1080, 1076},
	{1079, 1076, 1075},
	{1081, 1082, 1083},
	{1081, 1083, 1084},
	{1085, 1086, 1087},
	{1085, 1087, 1088},
	{1078, 1077, 1089},
	{1078, 1089, 1090},
	{1091, 1092, 1090},
	{1091, 1090, 1089},
	{1093, 1094, 1095},
	{1093, 1095, 1096},
	{1094, 1097, 1098},
	{1094, 1098, 1095},
	{1099, 1100, 1101},
	{1099, 1101, 1102},
	{1097, 1099, 1102},
	{1097, 1102, 1098},
	{1096, 1095, 1103},
	{1096, 1103, 1104},
	{1104, 1103, 1059},
	{1104, 1059, 1058},
	{1095, 1098, 1105},
	{1095, 1105, 1103},
	{1103, 1105, 1061},
	{1103, 1061, 1059},
	{1102, 1101, 1106},
	{1102, 1106, 1107},
	{1107, 1106, 1071},
	{1107, 1071, 1074},
	{1098, 1102, 1107},
	{1098, 1107, 1105},
	{1105, 1107, 1074},
	{1105, 1074, 1061},
	{1108, 1109, 1110},
	{1108, 1110, 1111},
	{1112, 1113, 1114},
	{1112, 1114, 1115},
	{1114, 1113, 1116},
	{1114, 1116, 1117},
	{1118, 1119, 1117},
	{1118, 1117, 1116},
	{1120, 1121, 1122},
	{1120, 1122, 1123},
	{1124, 1125, 1126},
	{1124, 1126, 1127},
	{1128, 1129, 1127},
	{1128, 1127, 1126},
	{1130, 1131, 1132},
	{1130, 1132, 1133},
	{1134, 1135, 1136},
	{1134, 1136, 1137},
	{1138, 1139, 1140},
	{1138, 1140, 1141},
	{1142, 1143, 1129},
	{1142, 1129, 1128},
	{1144, 1145, 1146},
	{1147, 1148, 1149},
	{1147, 1149, 1150},
	{1151, 1152, 1153},
	{1151, 1153, 1154},
	{1152, 1155, 1156},
	{1152, 1156, 1153},
	{1157, 1158, 1159},
	{1157, 1159, 1160},
	{1155, 1161, 1162},
	{1155, 1162, 1156},
	{1163, 1164, 1165},
	{1163, 1165, 1166},
	{1154, 1153, 1167},
	{1154, 1167, 1168},
	{1168, 1167, 1126},
	{1168, 1126, 1125},
	{1153, 1156, 1169},
	{1153, 1169, 1167},
	{1167, 1169, 1128},
	{1167, 1128, 1126},
	{1170, 1171, 1172},
	{1170, 1172, 1173},
	{1173, 1172, 1174},
	{1173, 1174, 1175},
	{1156, 1162, 1176},
	{1156, 1176, 1169},
	{1169, 1176, 1142},
	{1169, 1142, 1128},
	{1177, 1178, 1179},
	{1177, 1179, 1180},
	{1181, 1182, 1183},
	{1181, 1183, 1184},
	{1185, 1186, 1187},
	{1185, 1187, 1188},
	{1189, 1190, 1191},
	{1189, 1191, 1192},
	{1193, 1194, 1195},
	{1193, 1195, 1196},
	{1194, 1197, 1198},
	{1194, 1198, 1195},
	{1199, 1193, 1196},
	{1199, 1196, 1200},
	{1201, 1199, 1200},
	{1201, 1200, 1202},
	{1196, 1195, 1203},
	{1196, 1203, 1204},
	{1204, 1203, 1075},
	{1204, 1075, 1078},
	{1195, 1198, 1205},
	{1195, 1205, 1203},
	{1203, 1205, 1079},
	{1203, 1079, 1075},
	{1200, 1196, 1204},
	{1200, 1204, 1206},
	{1206, 1204, 1078},
	{1206, 1078, 1090},
	{1202, 1200, 1206},
	{1202, 1206, 1207},
	{1207, 1206, 1090},
	{1207, 1090, 1092},
	{1208, 1209, 1210},
	{1208, 1210, 1211},
	{1212, 1213, 1214},
	{1212, 1214, 1215},
	{1216, 1208, 1211},
	{1216, 1211, 1217},
	{1218, 1219, 1220},
	{1218, 1220, 1221},
	{1222, 1223, 1224},
	{1222, 1224, 1225},
	{1226, 1224, 1223},
	{1226, 1223, 1227},
	{1228, 1229, 1230},
	{1228, 1230, 1231},
	{1232, 1233, 1234},
	{1232, 1234, 1235},
	{1236, 1237, 1238},
	{1236, 1238, 1239},
	{1237, 1226, 1227},
	{1237, 1227, 1238},
	{1240, 1241, 1242},
	{1240, 1242, 1243},
	{1244, 1245, 1246},
	{1244, 1246, 1247},
	{1248, 1249, 1250},
	{1248, 1250, 1251},
	{1252, 1253, 1254},
	{1252, 1254, 1255},
	{1256, 1257, 1258},
	{1256, 1258, 1259},
	{1260, 1258, 1257},
	{1260, 1257, 1261},
	{1262, 1263, 1264},
	{1262, 1264, 1265},
	{1265, 1264, 1266},
	{1265, 1266, 1267},
	{1268, 1269, 1270},
	{1268, 1270, 1271},
	{1267, 1266, 1269},
	{1267, 1269, 1268},
	{1272, 1273, 1274},
	{1272, 1274, 1275},
	{1276, 1225, 1224},
	{1276, 1224, 1277},
	{1275, 1274, 1278},
	{1275, 1278, 1279},
	{1277, 1224, 1226},
	{1277, 1226, 1280},
	{1281, 1282, 1283},
	{1281, 1283, 1284},
	{1282, 1285, 1286},
	{1282, 1286, 1283},
	{1287, 1288, 1282},
	{1287, 1282, 1281},
	{1280, 1226, 1237},
	{1280, 1237, 1289},
	{1290, 1291, 1292},
	{1290, 1292, 1293},
	{1294, 1295, 1296},
	{1294, 1296, 1297},
	{1298, 1299, 1300},
	{1298, 1300, 1301},
	{1302, 1303, 1304},
	{1302, 1304, 1305},
	{1306, 1302, 1305},
	{1306, 1305, 1307},
	{1308, 1309, 1310},
	{1308, 1310, 1311},
	{1312, 1310, 1309},
	{1312, 1309, 1313},
	{1314, 1315, 1316},
	{1314, 1316, 1317},
	{1318, 1319, 1320},
	{1318, 1320, 1321},
	{1322, 1323, 1324},
	{1322, 1324, 1325},
	{1326, 1312, 1313},
	{1326, 1313, 1327},
	{1328, 1329, 1330},
	{1331, 1332, 1333},
	{1331, 1333, 1334},
	{1335, 1336, 1337},
	{1335, 1337, 1338},
	{1338, 1337, 1339},
	{1338, 1339, 1340},
	{1341, 1342, 1343},
	{1341, 1343, 1344},
	{1340, 1339, 1345},
	{1340, 1345, 1346},
	{1347, 1348, 1349},
	{1347, 1349, 1350},
	{1336, 1351, 1352},
	{1336, 1352, 1337},
	{1351, 1311, 1310},
	{1351, 1310, 1352},
	{1337, 1352, 1353},
	{1337, 1353, 1339},
	{1352, 1310, 1312},
	{1352, 1312, 1353},
	{1354, 1355, 1356},
	{1354, 1356, 1357},
	{1358, 1359, 1360},
	{1358, 1360, 1361},
	{1339, 1353, 1362},
	{1339, 1362, 1345},
	{1353, 1312, 1326},
	{1353, 1326, 1362},
	{1363, 1364, 1349},
	{1363, 1349, 1348},
	{1365, 1366, 1364},
	{1365, 1364, 1363},
	{1367, 1368, 1366},
	{1367, 1366, 1365},
	{1369, 1370, 1371},
	{1369, 1371, 1372},
	{1373, 1374, 1375},
	{1373, 1375, 1376},
	{1377, 1378, 1379},
	{1377, 1379, 1380},
	{1381, 1382, 1374},
	{1381, 1374, 1373},
	{1383, 1384, 1382},
	{1383, 1382, 1381},
	{1385, 1386, 1387},
	{1385, 1387, 1388},
	{1389, 1390, 1391},
	{1389, 1391, 1392},
	{1393, 1394, 1395},
	{1393, 1395, 1396},
	{1397, 1398, 1399},
	{1397, 1399, 1400},
	{1382, 1401, 1402},
	{1382, 1402, 1374},
	{1401, 1257, 1256},
	{1401, 1256, 1402},
	{1384, 1403, 1401},
	{1384, 1401, 1382},
	{1403, 1261, 1257},
	{1403, 1257, 1401},
	{1404, 1405, 1406},
	{1404, 1406, 1407},
	{1408, 1409, 1410},
	{1408, 1410, 1411},
	{1412, 1413, 1405},
	{1412, 1405, 1404},
	{1414, 1415, 1416},
	{1414, 1416, 1417},
	{1418, 1419, 1420},
	{1418, 1420, 1421},
	{1422, 1420, 1419},
	{1422, 1419, 1423},
	{1424, 1425, 1426},
	{1424, 1426, 1427},
	{1428, 1429, 1430},
	{1428, 1430, 1431},
	{1432, 1433, 1434},
	{1432, 1434, 1435},
	{1433, 1422, 1423},
	{1433, 1423, 1434},
	{1436, 1437, 1438},
	{1436, 1438, 1439},
	{1440, 1436, 1439},
	{1440, 1439, 1441},
	{1442, 1443, 1444},
	{1442, 1444, 1445},
	{1446, 1447, 1448},
	{1446, 1448, 1449},
	{1437, 1450, 1451},
	{1437, 1451, 1438},
	{1452, 1451, 1450},
	{1452, 1450, 1453},
	{1454, 1455, 1456},
	{1454, 1456, 1457},
	{1457, 1456, 1458},
	{1457, 1458, 1459},
	{1460, 1461, 1462},
	{1460, 1462, 1463},
	{1459, 1458, 1461},
	{1459, 1461, 1460},
	{1455, 1464, 1465},
	{1455, 1465, 1456},
	{1464, 1421, 1420},
	{1464, 1420, 1465},
	{1456, 1465, 1466},
	{1456, 1466, 1458},
	{1465, 1420, 1422},
	{1465, 1422, 1466},
	{1461, 1467, 1468},
	{1461, 1468, 1462},
	{1467, 1433, 1432},
	{1467, 1432, 1468},
	{1458, 1466, 1467},
	{1458, 1467, 1461},
	{1466, 1422, 1433},
	{1466, 1433, 1467},
	{1469, 1470, 1471},
	{1469, 1471, 1472},
	{1473, 1474, 1475},
	{1473, 1475, 1476},
	{1475, 1477, 1478},
	{1475, 1478, 1476},
	{1479, 1478, 1477},
	{1479, 1477, 1480},
	{1481, 1482, 1483},
	{1481, 1483, 1484},
	{1485, 1486, 1487},
	{1485, 1487, 1488},
	{1489, 1487, 1486},
	{1489, 1486, 1490},
	{1491, 1492, 1493},
	{1491, 1493, 1494},
	{1495, 1496, 1497},
	{1495, 1497, 1498},
	{1499, 1500, 1501},
	{1499, 1501, 1502},
	{1503, 1489, 1490},
	{1503, 1490, 1504},
	{1505, 1506, 1507},
	{1508, 1509, 1510},
	{1508, 1510, 1511},
	{1512, 1513, 1514},
	{1512, 1514, 1515},
	{1515, 1514, 1516},
	{1515, 1516, 1517},
	{1518, 1519, 1520},
	{1518, 1520, 1521},
	{1517, 1516, 1522},
	{1517, 1522, 1523},
	{1524, 1525, 1526},
	{1524, 1526, 1527},
	{1513, 1528, 1529},
	{1513, 1529, 1514},
	{1528, 1488, 1487},
	{1528, 1487, 1529},
	{1514, 1529, 1530},
	{1514, 1530, 1516},
	{1529, 1487, 1489},
	{1529, 1489, 1530},
	{1531, 1532, 1533},
	{1531, 1533, 1534},
	{1532, 1535, 1536},
	{1532, 1536, 1533},
	{1516, 1530, 1537},
	{1516, 1537, 1522},
	{1530, 1489, 1503},
	{1530, 1503, 1537},
	{1538, 1539, 1526},
	{1538, 1526, 1525},
	{1540, 1541, 1539},
	{1540, 1539, 1538},
	{1542, 1543, 1541},
	{1542, 1541, 1540},
	{1544, 1545, 1546},
	{1544, 1546, 1547},
	{1548, 1549, 1550},
	{1548, 1550, 1551},
	{1552, 1553, 1554},
	{1552, 1554, 1555},
	{1556, 1557, 1558},
	{1556, 1558, 1559},
	{1560, 1561, 1562},
	{1560, 1562, 1563},
	{1564, 1565, 1566},
	{1564, 1566, 1553},
	{1565, 1437, 1436},
	{1565, 1436, 1566},
	{1553, 1566, 1567},
	{1553, 1567, 1554},
	{1566, 1436, 1440},
	{1566, 1440, 1567},
	{1568, 1569, 1570},
	{1568, 1570, 1571},
	{1572, 1450, 1437},
	{1572, 1437, 1565},
	{1573, 1574, 1575},
	{1573, 1575, 1576},
	{1577, 1453, 1450},
	{1577, 1450, 1572},
	{1578, 1579, 1580},
	{1578, 1580, 1581},
	{1582, 1583, 1584},
	{1582, 1584, 1585},
	{1586, 1587, 1588},
	{1586, 1588, 1589},
	{1590, 1591, 1592},
	{1590, 1592, 1593},
	{1594, 1595, 1596},
	{1594, 1596, 1597},
	{1598, 1599, 1597},
	{1598, 1597, 1596},
	{1600, 1601, 1602},
	{1600, 1602, 1603},
	{1604, 1605, 1606},
	{1604, 1606, 1607},
	{1608, 1609, 1610},
	{1608, 1610, 1611},
	{1611, 1610, 1599},
	{1611, 1599, 1598},
	{1612, 1613, 1614},
	{1612, 1614, 1615},
	{1616, 1617, 1618},
	{1616, 1618, 1619},
	{1620, 1621, 1622},
	{1620, 1622, 1623},
	{1624, 1625, 1626},
	{1624, 1626, 1627},
	{1628, 1629, 1630},
	{1628, 1630, 1631},
	{1632, 1633, 1631},
	{1632, 1631, 1630},
	{1634, 1635, 1636},
	{1634, 1636, 1637},
	{1635, 1638, 1639},
	{1635, 1639, 1636},
	{1640, 1641, 1642},
	{1640, 1642, 1643},
	{1638, 1640, 1643},
	{1638, 1643, 1639},
	{1644, 1645, 1646},
	{1644, 1646, 1647},
	{1648, 1649, 1596},
	{1648, 1596, 1595},
	{1645, 1650, 1651},
	{1645, 1651, 1646},
	{1649, 1652, 1598},
	{1649, 1598, 1596},
	{1653, 1654, 1655},
	{1653, 1655, 1656},
	{1656, 1655, 1657},
	{1656, 1657, 1658},
	{1659, 1653, 1656},
	{1659, 1656, 1660},
	{1652, 1661, 1611},
	{1652, 1611, 1598},
	{1662, 1663, 1664},
	{1662, 1664, 1665},
	{1666, 1667, 1668},
	{1666, 1668, 1669},
	{1670, 1671, 1672},
	{1670, 1672, 1673},
	{1674, 1675, 1676},
	{1674, 1676, 1677},
	{1678, 1679, 1675},
	{1678, 1675, 1674},
	{1680, 1681, 1682},
	{1680, 1682, 1683},
	{1684, 1685, 1683},
	{1684, 1683, 1682},
	{1686, 1687, 1688},
	{1686, 1688, 1689},
	{1690, 1691, 1692},
	{1690, 1692, 1693},
	{1694, 1695, 1696},
	{1694, 1696, 1697},
	{1697, 1696, 1685},
	{1697, 1685, 1684},
	{1698, 1699, 1700},
	{1701, 1702, 1703},
	{1701, 1703, 1704},
	{1705, 1706, 1707},
	{1705, 1707, 1708},
	{1706, 1709, 1710},
	{1706, 1710, 1707},
	{1711, 1712, 1713},
	{1711, 1713, 1714},
	{1709, 1711, 1714},
	{1709, 1714, 1710},
	{1715, 1716, 1717},
	{1715, 1717, 1718},
	{1708, 1707, 1719},
	{1708, 1719, 1720},
	{1720, 1719, 1682},
	{1720, 1682, 1681},
	{1707, 1710, 1721},
	{1707, 1721, 1719},
	{1719, 1721, 1684},
	{1719, 1684, 1682},
	{1714, 1713, 1722},
	{1714, 1722, 1723},
	{1723, 1722, 1694},
	{1723, 1694, 1697},
	{1710, 1714, 1723},
	{1710, 1723, 1721},
	{1721, 1723, 1697},
	{1721, 1697, 1684},
	{1724, 1725, 1726},
	{1724, 1726, 1727},
	{1728, 1724, 1727},
	{1728, 1727, 1729},
	{1730, 1728, 1729},
	{1730, 1729, 1731},
	{1732, 1733, 1734},
	{1732, 1734, 1735},
	{1736, 1737, 1738},
	{1736, 1738, 1739},
	{1740, 1741, 1742},
	{1740, 1742, 1743},
	{1744, 1736, 1739},
	{1744, 1739, 1745},
	{1746, 1744, 1745},
	{1746, 1745, 1747},
	{1748, 1749, 1750},
	{1748, 1750, 1751},
	{1752, 1753, 1754},
	{1752, 1754, 1755},
	{1756, 1757, 1758},
	{1756, 1758, 1759},
	{1760, 1761, 1616},
	{1760, 1616, 1619},
	{1745, 1739, 1762},
	{1745, 1762, 1763},
	{1763, 1762, 1628},
	{1763, 1628, 1631},
	{1747, 1745, 1763},
	{1747, 1763, 1764},
	{1764, 1763, 1631},
	{1764, 1631, 1633},
	{1765, 1766, 1767},
	{1765, 1767, 1768},
	{1769, 1767, 1766},
	{1769, 1766, 1770},
	{1771, 1765, 1768},
	{1771, 1768, 1772},
	{1773, 1774, 1775},
	{1773, 1775, 1776},
	{1777, 1778, 1779},
	{1777, 1779, 1780},
	{1781, 1782, 1780},
	{1781, 1780, 1779},
	{1783, 1784, 1785},
	{1783, 1785, 1786},
	{1787, 1788, 1789},
	{1787, 1789, 1790},
	{1791, 1792, 1793},
	{1791, 1793, 1794},
	{1794, 1793, 1782},
	{1794, 1782, 1781},
	{1795, 1796, 1797},
	{1795, 1797, 1798},
	{1799, 1800, 1796},
	{1799, 1796, 1795},
	{1801, 1802, 1803},
	{1801, 1803, 1804},
	{1805, 1806, 1807},
	{1805, 1807, 1808},
	{1798, 1797, 1809},
	{1798, 1809, 1810},
	{1811, 1812, 1810},
	{1811, 1810, 1809},
	{1813, 1814, 1815},
	{1813, 1815, 1816},
	{1814, 1817, 1818},
	{1814, 1818, 1815},
	{1819, 1820, 1821},
	{1819, 1821, 1822},
	{1817, 1819, 1822},
	{1817, 1822, 1818},
	{1816, 1815, 1823},
	{1816, 1823, 1824},
	{1824, 1823, 1779},
	{1824, 1779, 1778},
	{1815, 1818, 1825},
	{1815, 1825, 1823},
	{1823, 1825, 1781},
	{1823, 1781, 1779},
	{1822, 1821, 1826},
	{1822, 1826, 1827},
	{1827, 1826, 1791},
	{1827, 1791, 1794},
	{1818, 1822, 1827},
	{1818, 1827, 1825},
	{1825, 1827, 1794},
	{1825, 1794, 1781},
	{1828, 1829, 1830},
	{1828, 1830, 1831},
	{1832, 1833, 1834},
	{1832, 1834, 1835},
	{1834, 1833, 1836},
	{1834, 1836, 1837},
	{1838, 1839, 1840},
	{1838, 1840, 1841},
	{1842, 1843, 1839},
	{1842, 1839, 1838},
	{1844, 1845, 1846},
	{1844, 1846, 1847},
	{1848, 1849, 1847},
	{1848, 1847, 1846},
	{1850, 1851, 1852},
	{1850, 1852, 1853},
	{1854, 1855, 1856},
	{1854, 1856, 1857},
	{1858, 1859, 1860},
	{1858, 1860, 1861},
	{1862, 1863, 1849},
	{1862, 1849, 1848},
	{1864, 1865, 1866},
	{1867, 1868, 1869},
	{1867, 1869, 1870},
	{1871, 1872, 1873},
	{1871, 1873, 1874},
	{1872, 1875, 1876},
	{1872, 1876, 1873},
	{1877, 1878, 1879},
	{1877, 1879, 1880},
	{1875, 1881, 1882},
	{1875, 1882, 1876},
	{1883, 1884, 1885},
	{1883, 1885, 1886},
	{1874, 1873, 1887},
	{1874, 1887, 1888},
	{1888, 1887, 1846},
	{1888, 1846, 1845},
	{1873, 1876, 1889},
	{1873, 1889, 1887},
	{1887, 1889, 1848},
	{1887, 1848, 1846},
	{1890, 1891, 1892},
	{1890, 1892, 1893},
	{1893, 1892, 1894},
	{1893, 1894, 1895},
	{1876, 1882, 1896},
	{1876, 1896, 1889},
	{1889, 1896, 1862},
	{1889, 1862, 1848},
	{1897, 1898, 1899},
	{1897, 1899, 1900},
	{1901, 1897, 1900},
	{1901, 1900, 1902},
	{1903, 1904, 1905},
	{1903, 1905, 1906},
	{1907, 1908, 1909},
	{1907, 1909, 1910},
	{1911, 1912, 1913},
	{1911, 1913, 1914},
	{1915, 1916, 1917},
	{1915, 1917, 1918},
	{1919, 1920, 1921},
	{1919, 1921, 1922},
	{1923, 1924, 1925},
	{1923, 1925, 1926},
	{1927, 1918, 1928},
	{1927, 1928, 1929},
	{1929, 1928, 1795},
	{1929, 1795, 1798},
	{1918, 1917, 1930},
	{1918, 1930, 1928},
	{1928, 1930, 1799},
	{1928, 1799, 1795},
	{1931, 1932, 1933},
	{1931, 1933, 1934},
	{1935, 1929, 1798},
	{1935, 1798, 1810},
	{1936, 1937, 1938},
	{1936, 1938, 1939},
	{1940, 1935, 1810},
	{1940, 1810, 1812},
	{1941, 1942, 1943},
	{1941, 1943, 1944},
	{1945, 1946, 1947},
	{1945, 1947, 1948},
	{1949, 1950, 1951},
	{1949, 1951, 1952},
	{1953, 1954, 1955},
	{1953, 1955, 1956},
	{1957, 1958, 1959},
	{1957, 1959, 1960},
	{1961, 1962, 1963},
	{1961, 1963, 1964},
	{1965, 1966, 1967},
	{1965, 1967, 1968},
	{1969, 1970, 1971},
	{1969, 1971, 1972},
	{1962, 1973, 1974},
	{1962, 1974, 1963},
	{1973, 1975, 1976},
	{1973, 1976, 1974},
	{1977, 1978, 1979},
	{1977, 1979, 1980},
	{1981, 1982, 1983},
	{1981, 1983, 1984},
	{1985, 1986, 1987},
	{1985, 1987, 1988},
	{1989, 1990, 1991},
	{1989, 1991, 1992},
	{1993, 1994, 1995},
	{1993, 1995, 1996},
	{1997, 1998, 1999},
	{1997, 1999, 2000},
	{2001, 2002, 2003},
	{2001, 2003, 2004},
	{2005, 2006, 2007},
	{2005, 2007, 2008},
	{2009, 2010, 2011},
	{2009, 2011, 2012},
	{2013, 2014, 2010},
	{2013, 2010, 2009},
	{2015, 2016, 2017},
	{2015, 2017, 2018},
	{2012, 2011, 2019},
	{2012, 2019, 2020},
	{2021, 2022, 2014},
	{2021, 2014, 2013},
	{2023, 2024, 2025},
	{2023, 2025, 2026},
	{2027, 2028, 2029},
	{2027, 2029, 2030},
	{2031, 2032, 2033},
	{2031, 2033, 2034},
	{2035, 2036, 2037},
	{2035, 2037, 2038},
	{2039, 2040, 2041},
	{2039, 2041, 2042},
	{2043, 2044, 2045},
	{2043, 2045, 2046},
	{2047, 2048, 2049},
	{2047, 2049, 2050},
	{2051, 2052, 2053},
	{2051, 2053, 2054},
	{2055, 2056, 2057},
	{2055, 2057, 2058},
	{2059, 2060, 2061},
	{2059, 2061, 2062},
	{2063, 2064, 2065},
	{2063, 2065, 2066},
	{2067, 2068, 2069},
	{2067, 2069, 2070},
	{2071, 2059, 2062},
	{2071, 2062, 2072},
	{2064, 2073, 2074},
	{2064, 2074, 2065},
	{2075, 2076, 2077},
	{2075, 2077, 2078},
	{2079, 2080, 2081},
	{2079, 2081, 2082},
	{2083, 2084, 2085},
	{2083, 2085, 2086},
	{2087, 2088, 2089},
	{2087, 2089, 2090},
	{2091, 2092, 2093},
	{2091, 2093, 2094},
	{2095, 2096, 2097},
	{2095, 2097, 2098},
	{2099, 2100, 2101},
	{2099, 2101, 2102},
	{2103, 2104, 2105},
	{2103, 2105, 2106},
	{2107, 2108, 2109},
	{2107, 2109, 2110},
	{2111, 2112, 2113},
	{2111, 2113, 2114},
	{2115, 2116, 2112},
	{2115, 2112, 2111},
	{2117, 2118, 2119},
	{2117, 2119, 2120},
	{2114, 2113, 2118},
	{2114, 2118, 2117},
	{2121, 2122, 2123},
	{2121, 2123, 2124},
	{2125, 2126, 2127},
	{2125, 2127, 2128},
	{2129, 2130, 2131},
	{2129, 2131, 2132},
	{2133, 2134, 2135},
	{2133, 2135, 2136},
	{2137, 2138, 2139},
	{2137, 2139, 2140},
	{2141, 2142, 2143},
	{2141, 2143, 2144},
	{2141, 2144, 2145},
	{2141, 2145, 2146},
	{2147, 2146, 2145},
	{2147, 2145, 2148},
	{2149, 2150, 2151},
	{2149, 2151, 2152},
	{2153, 2154, 2155},
	{2153, 2155, 2156},
	{2157, 2158, 2159},
	{2157, 2159, 2160},
	{2161, 2162, 2163},
	{2161, 2163, 2164},
	{2165, 2166, 2167},
	{2165, 2167, 2168},
	{2166, 2157, 2160},
	{2166, 2160, 2167},
	{2162, 2169, 2170},
	{2162, 2170, 2163},
	{2169, 2165, 2168},
	{2169, 2168, 2170},
	{2171, 2172, 2173},
	{2171, 2173, 2174},
	{2175, 2176, 2177},
	{2175, 2177, 2178},
	{2179, 2180, 2181},
	{2179, 2181, 2182},
	{2183, 2184, 2185},
	{2183, 2185, 2186},
	{2187, 2188, 2189},
	{2187, 2189, 2190},
	{2191, 2192, 2193},
	{2191, 2193, 2194},
	{2195, 2196, 2197},
	{2195, 2197, 2198},
	{2199, 2200, 2201},
	{2199, 2201, 2202},
	{2203, 2204, 2205},
	{2203, 2205, 2206},
	{2207, 2208, 2204},
	{2207, 2204, 2203},
	{2209, 2210, 2211},
	{2209, 2211, 2212},
	{2206, 2205, 2210},
	{2206, 2210, 2209},
	{2213, 2214, 2208},
	{2213, 2208, 2207},
	{2212, 2211, 2215},
	{2212, 2215, 2216},
	{2217, 2218, 2219},
	{2217, 2219, 2220},
	{2221, 2222, 2223},
	{2221, 2223, 2224},
	{2224, 2223, 2225},
	{2224, 2225, 2226},
	{2227, 2226, 2225},
	{2227, 2225, 2228},
	{2227, 2228, 2229},
	{2227, 2229, 2230},
	{2231, 2230, 2229},
	{2231, 2229, 2232},
	{2233, 2231, 2232},
	{2233, 2232, 2234},
	{2235, 2236, 2237},
	{2235, 2237, 2238},
	{2239, 2240, 2241},
	{2239, 2241, 2242},
	{2243, 2244, 2245},
	{2243, 2245, 2246},
	{2247, 2248, 2249},
	{2247, 2249, 2250},
	{2248, 2239, 2242},
	{2248, 2242, 2249},
	{2251, 2252, 2253},
	{2251, 2253, 2254},
	{2255, 2247, 2250},
	{2255, 2250, 2256},
	{2257, 2258, 2259},
	{2257, 2259, 2260},
	{2261, 2262, 2263},
	{2261, 2263, 2264},
	{2265, 2266, 2267},
	{2265, 2267, 2268},
	{2269, 2270, 2271},
	{2269, 2271, 2272},
	{2273, 2274, 2275},
	{2273, 2275, 2276},
	{2277, 2278, 2279},
	{2277, 2279, 2280},
	{2281, 2282, 2283},
	{2281, 2283, 2284},
	{2285, 2286, 2287},
	{2285, 2287, 2288},
	{2289, 2290, 2291},
	{2289, 2291, 2292},
	{2293, 2294, 2290},
	{2293, 2290, 2289},
	{2295, 2296, 2297},
	{2295, 2297, 2298},
	{2292, 2291, 2296},
	{2292, 2296, 2295},
	{2299, 2300, 2294},
	{2299, 2294, 2293},
	{2298, 2297, 2301},
	{2298, 2301, 2302},
	{2303, 2304, 2305},
	{2303, 2305, 2306},
	{2307, 2308, 2309},
	{2307, 2309, 2310},
	{2311, 2312, 2313},
	{2311, 2313, 2314},
	{2315, 2316, 2317},
	{2315, 2317, 2318},
	{2319, 2320, 2321},
	{2319, 2321, 2322},
	{2323, 2324, 2325},
	{2323, 2325, 2326},
	{2327, 2323, 2326},
	{2327, 2326, 2328},
	{2329, 2330, 2331},
	{2329, 2331, 2332},
	{2333, 2334, 2335},
	{2333, 2335, 2336},
	{2337, 2338, 2339},
	{2337, 2339, 2340},
	{2341, 2342, 2343},
	{2341, 2343, 2344},
	{2345, 2346, 2347},
	{2345, 2347, 2348},
	{2338, 2349, 2350},
	{2338, 2350, 2339},
	{2349, 2351, 2352},
	{2349, 2352, 2350},
	{2353, 2354, 2355},
	{2353, 2355, 2356},
	{2357, 2358, 2359},
	{2357, 2359, 2360},
	{2361, 2362, 2363},
	{2361, 2363, 2364},
	{2365, 2366, 2367},
	{2365, 2367, 2368},
	{2369, 2370, 2371},
	{2369, 2371, 2372},
	{2373, 2374, 2375},
	{2373, 2375, 2376},
	{2377, 2378, 2379},
	{2377, 2379, 2380},
	{2381, 2382, 2383},
	{2381, 2383, 2384},
	{2385, 2386, 2387},
	{2385, 2387, 2388},
	{2389, 2390, 2386},
	{2389, 2386, 2385},
	{2391, 2392, 2393},
	{2391, 2393, 2394},
	{2388, 2387, 2392},
	{2388, 2392, 2391},
	{2395, 2396, 2390},
	{2395, 2390, 2389},
	{2397, 2398, 2399},
	{2397, 2399, 2400},
	{2401, 2402, 2403},
	{2401, 2403, 2404},
	{2405, 2406, 2407},
	{2405, 2407, 2408},
	{2409, 2410, 2411},
	{2409, 2411, 2412},
	{2413, 2414, 2415},
	{2413, 2415, 2416},
	{2413, 2416, 2417},
	{2413, 2417, 2418},
	{2419, 2418, 2417},
	{2419, 2417, 2420},
	{2421, 2422, 2423},
	{2421, 2423, 2424},
	{2425, 2426, 2427},
	{2425, 2427, 2428},
	{2429, 2430, 2431},
	{2429, 2431, 2432},
	{2433, 2434, 2435},
	{2433, 2435, 2436},
	{2437, 2438, 2439},
	{2437, 2439, 2440},
	{2438, 2429, 2432},
	{2438, 2432, 2439},
	{2434, 2441, 2442},
	{2434, 2442, 2435},
	{2441, 2437, 2440},
	{2441, 2440, 2442},
	{2443, 2444, 2445},
	{2443, 2445, 2446},
	{2447, 2448, 2449},
	{2447, 2449, 2450},
	{2451, 2452, 2453},
	{2451, 2453, 2454},
	{2455, 2456, 2457},
	{2455, 2457, 2458},
	{2459, 2460, 2461},
	{2459, 2461, 2462},
	{2463, 2464, 2465},
	{2463, 2465, 2466},
	{2467, 2468, 2469},
	{2467, 2469, 2470},
	{2471, 2472, 2473},
	{2471, 2473, 2474},
	{2475, 2476, 2477},
	{2475, 2477, 2478},
	{2479, 2480, 2481},
	{2479, 2481, 2482},
	{2483, 2484, 2485},
	{2483, 2485, 2486},
	{2487, 2488, 2489},
	{2487, 2489, 2490},
	{2491, 2492, 2493},
	{2491, 2493, 2494},
	{2486, 2485, 2495},
	{2486, 2495, 2496},
	{2497, 2498, 2499},
	{2497, 2499, 2500},
	{2501, 2502, 2503},
	{2501, 2503, 2504},
	{2505, 2506, 2507},
	{2505, 2507, 2508},
	{2509, 2508, 2507},
	{2509, 2507, 2510},
	{2509, 2510, 2511},
	{2509, 2511, 2512},
	{2513, 2514, 2515},
	{2513, 2515, 2516},
	{2517, 2518, 2519},
	{2517, 2519, 2520},
	{2521, 2522, 2523},
	{2521, 2523, 2524},
	{2525, 2526, 2527},
	{2525, 2527, 2528},
	{2529, 2530, 2531},
	{2529, 2531, 2532},
	{2533, 2534, 2535},
	{2533, 2535, 2536},
	{2534, 2525, 2528},
	{2534, 2528, 2535},
	{2537, 2538, 2539},
	{2537, 2539, 2540},
	{2538, 2541, 2542},
	{2538, 2542, 2539},
	{2543, 2544, 2545},
	{2543, 2545, 2546},
	{2547, 2548, 2549},
	{2547, 2549, 2550},
	{2551, 2552, 2553},
	{2551, 2553, 2554},
	{2555, 2556, 2557},
	{2555, 2557, 2558},
	{2559, 2560, 2561},
	{2559, 2561, 2562},
	{2563, 2564, 2565},
	{2563, 2565, 2566},
	{2567, 2568, 2569},
	{2567, 2569, 2570},
	{2571, 2572, 2573},
	{2571, 2573, 2574},
	{2575, 2576, 2577},
	{2575, 2577, 2578},
	{2579, 2580, 2576},
	{2579, 2576, 2575},
	{2581, 2582, 2583},
	{2581, 2583, 2584},
	{2585, 2586, 2587},
	{2585, 2587, 2588},
	{2589, 2590, 2580},
	{2589, 2580, 2579},
	{2584, 2583, 2591},
	{2584, 2591, 2592},
	{2593, 2594, 2595},
	{2593, 2595, 2596},
	{2597, 2598, 2599},
	{2597, 2599, 2600},
	{2601, 2602, 2603},
	{2601, 2603, 2604},
	{2605, 2606, 2607},
	{2605, 2607, 2608},
	{2609, 2610, 2611},
	{2609, 2611, 2612},
	{2613, 2612, 2611},
	{2613, 2611, 2614},
	{2615, 2613, 2614},
	{2615, 2614, 2616},
	{2617, 2618, 2619},
	{2617, 2619, 2620},
	{2621, 2622, 2623},
	{2621, 2623, 2624},
	{2625, 2626, 2627},
	{2625, 2627, 2628},
	{2629, 2630, 2631},
	{2629, 2631, 2632},
	{2630, 2621, 2624},
	{2630, 2624, 2631},
	{2633, 2634, 2635},
	{2633, 2635, 2636},
	{2637, 2629, 2632},
	{2637, 2632, 2638},
	{2639, 2640, 2641},
	{2639, 2641, 2642},
	{2643, 2644, 2645},
	{2643, 2645, 2646},
	{2647, 2648, 2649},
	{2647, 2649, 2650},
	{2651, 2652, 2653},
	{2651, 2653, 2654},
	{2655, 2656, 2657},
	{2655, 2657, 2658},
	{2659, 2660, 2661},
	{2659, 2661, 2662},
	{2663, 2664, 2665},
	{2663, 2665, 2666},
	{2667, 2668, 2669},
	{2667, 2669, 2670},
	{2671, 2672, 2673},
	{2671, 2673, 2674},
	{2675, 2676, 2677},
	{2675, 2677, 2678},
	{2679, 2680, 2681},
	{2679, 2681, 2682},
	{2674, 2673, 2683},
	{2674, 2683, 2684},
	{2685, 2686, 2687},
	{2685, 2687, 2688},
	{2682, 2681, 2689},
	{2682, 2689, 2690},
	{2691, 2692, 2693},
	{2691, 2693, 2694},
	{2695, 2696, 2697},
	{2695, 2697, 2698},
	{2699, 2700, 2701},
	{2699, 2701, 2702},
	{2703, 2704, 2705},
	{2703, 2705, 2706},
	{2707, 2708, 2709},
	{2707, 2709, 2710},
	{2711, 2710, 2709},
	{2711, 2709, 2712},
	{2713, 2711, 2712},
	{2713, 2712, 2714},
	{2715, 2716, 2717},
	{2715, 2717, 2718},
	{2719, 2720, 2721},
	{2719, 2721, 2722},
	{2723, 2724, 2725},
	{2723, 2725, 2726},
	{2727, 2728, 2729},
	{2727, 2729, 2730},
	{2731, 2732, 2733},
	{2731, 2733, 2734},
	{2735, 2736, 2737},
	{2735, 2737, 2738},
	{2739, 2740, 2741},
	{2739, 2741, 2742},
	{2743, 2744, 2745},
	{2743, 2745, 2746},
	{2747, 2748, 2749},
	{2747, 2749, 2750},
	{2751, 2752, 2753},
	{2751, 2753, 2754},
	{2755, 2756, 2757},
	{2755, 2757, 2758},
	{2759, 2760, 2761},
	{2759, 2761, 2762},
	{2763, 2764, 2765},
	{2763, 2765, 2766},
	{2767, 2768, 2769},
	{2767, 2769, 2770},
	{2771, 2772, 2773},
	{2771, 2773, 2774},
	{2775, 2776, 2777},
	{2775, 2777, 2778},
	{2779, 2780, 2776},
	{2779, 2776, 2775},
	{2781, 2782, 2783},
	{2781, 2783, 2784},
	{2778, 2777, 2782},
	{2778, 2782, 2781},
	{2785, 2786, 2780},
	{2785, 2780, 2779},
	{2784, 2783, 2787},
	{2784, 2787, 2788},
	{2789, 2790, 2791},
	{2789, 2791, 2792},
	{2793, 2794, 2795},
	{2793, 2795, 2796},
	{2797, 2798, 2799},
	{2797, 2799, 2800},
	{2801, 2802, 2803},
	{2801, 2803, 2804},
	{2805, 2806, 2807},
	{2805, 2807, 2808},
	{2809, 2810, 2811},
	{2809, 2811, 2812},
	{2813, 2814, 2815},
	{2813, 2815, 2816},
	{2817, 2818, 2819},
	{2817, 2819, 2820},
	{2821, 2822, 2823},
	{2821, 2823, 2824},
	{2825, 2826, 2827},
	{2825, 2827, 2828},
	{2829, 2830, 2831},
	{2829, 2831, 2832},
	{2833, 2821, 2824},
	{2833, 2824, 2834},
	{2835, 2836, 2837},
	{2835, 2837, 2838},
	{2839, 2840, 2841},
	{2839, 2841, 2842},
	{2843, 2844, 2845},
	{2843, 2845, 2846},
	{2847, 2848, 2849},
	{2847, 2849, 2850},
	{2851, 2852, 2853},
	{2851, 2853, 2854},
	{2855, 2856, 2857},
	{2855, 2857, 2858},
	{2859, 2860, 2861},
	{2859, 2861, 2862},
	{2863, 2864, 2865},
	{2863, 2865, 2866},
	{2867, 2868, 2869},
	{2867, 2869, 2870},
	{2871, 2872, 2873},
	{2871, 2873, 2874},
	{2875, 2876, 2877},
	{2875, 2877, 2878},
	{2879, 2880, 2881},
	{2879, 2881, 2882},
	{2883, 2884, 2885},
	{2883, 2885, 2886},
	{2887, 2888, 2884},
	{2887, 2884, 2883},
	{2889, 2890, 2891},
	{2889, 2891, 2892},
	{2893, 2894, 2895},
	{2893, 2895, 2896},
	{2897, 2898, 2899},
	{2897, 2899, 2900},
	{2901, 2902, 2903},
	{2901, 2903, 2904},
	{2905, 2906, 2907},
	{2905, 2907, 2908},
	{2909, 2910, 2911},
	{2909, 2911, 2912},
	{2909, 2912, 2913},
	{2909, 2913, 2914},
	{2915, 2914, 2913},
	{2915, 2913, 2916},
	{2917, 2915, 2916},
	{2917, 2916, 2918},
	{2919, 2920, 2921},
	{2919, 2921, 2922},
	{2923, 2924, 2925},
	{2923, 2925, 2926},
	{2927, 2928, 2929},
	{2927, 2929, 2930},
	{2931, 2932, 2933},
	{2931, 2933, 2934},
	{2932, 2923, 2926},
	{2932, 2926, 2933},
	{2928, 2935, 2936},
	{2928, 2936, 2929},
	{2935, 2931, 2934},
	{2935, 2934, 2936},
	{2937, 2938, 2939},
	{2937, 2939, 2940},
	{2941, 2942, 2943},
	{2941, 2943, 2944},
	{2945, 2946, 2947},
	{2945, 2947, 2948},
	{2949, 2950, 2951},
	{2949, 2951, 2952},
	{2953, 2954, 2955},
	{2953, 2955, 2956},
	{2957, 2958, 2959},
	{2957, 2959, 2960},
	{2961, 2962, 2963},
	{2961, 2963, 2964},
	{2965, 2966, 2967},
	{2965, 2967, 2968},
	{2969, 2970, 2971},
	{2969, 2971, 2972},
	{2973, 2974, 2970},
	{2973, 2970, 2969},
	{2975, 2976, 2977},
	{2975, 2977, 2978},
	{2972, 2971, 2976},
	{2972, 2976, 2975},
	{2979, 2980, 2974},
	{2979, 2974, 2973},
	{2978, 2977, 2981},
	{2978, 2981, 2982},
	{2983, 2984, 2985},
	{2983, 2985, 2986},
	{2987, 2988, 2989},
	{2987, 2989, 2990},
	{2991, 2992, 2993},
	{2991, 2993, 2994},
	{2995, 2994, 2993},
	{2995, 2993, 2996},
	{2995, 2996, 2997},
	{2995, 2997, 2998},
	{2999, 2998, 2997},
	{2999, 2997, 3000},
	{3001, 2999, 3000},
	{3001, 3000, 3002},
	{3003, 3004, 3005},
	{3003, 3005, 3006},
	{3007, 3008, 3009},
	{3007, 3009, 3010},
	{3011, 3012, 3013},
	{3011, 3013, 3014},
	{3015, 3016, 3017},
	{3015, 3017, 3018},
	{3016, 3007, 3010},
	{3016, 3010, 3017},
	{3012, 3019, 3020},
	{3012, 3020, 3013},
	{3019, 3015, 3018},
	{3019, 3018, 3020},
	{3021, 3022, 3023},
	{3021, 3023, 3024},
	{3025, 3026, 3027},
	{3025, 3027, 3028},
	{3029, 3030, 3031},
	{3029, 3031, 3032},
	{3033, 3034, 3035},
	{3033, 3035, 3036},
	{3037, 3038, 3039},
	{3037, 3039, 3040},
	{3041, 3042, 3043},
	{3041, 3043, 3044},
	{3045, 3046, 3047},
	{3045, 3047, 3048},
	{3049, 3050, 3051},
	{3049, 3051, 3052},
	{3053, 3054, 3055},
	{3053, 3055, 3056},
	{3057, 3058, 3054},
	{3057, 3054, 3053},
	{3059, 3060, 3061},
	{3059, 3061, 3062},
	{3056, 3055, 3060},
	{3056, 3060, 3059},
	{3063, 3064, 3065},
	{3063, 3065, 3066},
	{3062, 3061, 3067},
	{3062, 3067, 3068},
	{3069, 3070, 3071},
	{3069, 3071, 3072},
	{3073, 3074, 3075},
	{3073, 3075, 3076},
	{3077, 3078, 3079},
	{3077, 3079, 3080},
	{3081, 3082, 3083},
	{3081, 3083, 3084},
	{3081, 3084, 3085},
	{3081, 3085, 3086},
	{3087, 3088, 3089},
	{3087, 3089, 3090},
	{3091, 3092, 3093},
	{3091, 3093, 3094},
	{3095, 3096, 3097},
	{3095, 3097, 3098},
	{3099, 3100, 3101},
	{3099, 3101, 3102},
	{3103, 3104, 3105},
	{3103, 3105, 3106},
	{3107, 3108, 3109},
	{3107, 3109, 3110},
	{3111, 3112, 3113},
	{3111, 3113, 3114},
	{3115, 3116, 3117},
	{3115, 3117, 3118},
	{3119, 3120, 3121},
	{3119, 3121, 3122},
	{3123, 3124, 3125},
	{3123, 3125, 3126},
	{3126, 3125, 3127},
	{3126, 3127, 3128},
	{3128, 3127, 3129},
	{3128, 3129, 3130},
	{3130, 3129, 3131},
	{3130, 3131, 3132},
	{3132, 3131, 3133},
	{3132, 3133, 3134},
	{3134, 3133, 3135},
	{3134, 3135, 3136},
	{3136, 3135, 3137},
	{3136, 3137, 3138},
	{3138, 3137, 3139},
	{3138, 3139, 3140},
	{3140, 3139, 3141},
	{3140, 3141, 3142},
	{3142, 3141, 3143},
	{3142, 3143, 3144},
	{3144, 3143, 3145},
	{3144, 3145, 3146},
	{3146, 3145, 3147},
	{3146, 3147, 3148},
	{3148, 3147, 3149},
	{3148, 3149, 3150},
	{3150, 3149, 3151},
	{3150, 3151, 3152},
	{3152, 3151, 3153},
	{3152, 3153, 3154},
	{3154, 3153, 3155},
	{3154, 3155, 3156},
	{3156, 3155, 3157},
	{3156, 3157, 3158},
	{3158, 3157, 3159},
	{3158, 3159, 3160},
	{3160, 3159, 3161},
	{3160, 3161, 3162},
	{3162, 3161, 3163},
	{3162, 3163, 3164},
	{3164, 3163, 3165},
	{3164, 3165, 3166},
	{3166, 3165, 3167},
	{3166, 3167, 3168},
	{3168, 3167, 3169},
	{3168, 3169, 3170},
	{3170, 3169, 3171},
	{3170, 3171, 3172},
	{3172, 3171, 3173},
	{3172, 3173, 3174},
	{3174, 3173, 3175},
	{3174, 3175, 3176},
	{3176, 3175, 3177},
	{3176, 3177, 3178},
	{3178, 3177, 3179},
	{3178, 3179, 3180},
	{3180, 3179, 3181},
	{3180, 3181, 3182},
	{3182, 3181, 3183},
	{3182, 3183, 3184},
	{3184, 3183, 3185},
	{3184, 3185, 3186},
	{3124, 3123, 3186},
	{3124, 3186, 3185},
	{3124, 3185, 3187},
	{3124, 3187, 3188},
	{3185, 3183, 3189},
	{3185, 3189, 3187},
	{3183, 3181, 3190},
	{3183, 3190, 3189},
	{3181, 3179, 3191},
	{3181, 3191, 3190},
	{3179, 3177, 3192},
	{3179, 3192, 3191},
	{3177, 3175, 3193},
	{3177, 3193, 3192},
	{3175, 3173, 3194},
	{3175, 3194, 3193},
	{3173, 3171, 3195},
	{3173, 3195, 3194},
	{3171, 3169, 3196},
	{3171, 3196, 3195},
	{3169, 3167, 3197},
	{3169, 3197, 3196},
	{3167, 3165, 3198},
	{3167, 3198, 3197},
	{3165, 3163, 3199},
	{3165, 3199, 3198},
	{3163, 3161, 3200},
	{3163, 3200, 3199},
	{3161, 3159, 3201},
	{3161, 3201, 3200},
	{3159, 3157, 3202},
	{3159, 3202, 3201},
	{3157, 3155, 3203},
	{3157, 3203, 3202},
	{3155, 3153, 3204},
	{3155, 3204, 3203},
	{3153, 3151, 3205},
	{3153, 3205, 3204},
	{3151, 3149, 3206},
	{3151, 3206, 3205},
	{3149, 3147, 3207},
	{3149, 3207, 3206},
	{3147, 3145, 3208},
	{3147, 3208, 3207},
	{3145, 3143, 3209},
	{3145, 3209, 3208},
	{3143, 3141, 3210},
	{3143, 3210, 3209},
	{3141, 3139, 3211},
	{3141, 3211, 3210},
	{3139, 3137, 3212},
	{3139, 3212, 3211},
	{3137, 3135, 3213},
	{3137, 3213, 3212},
	{3135, 3133, 3214},
	{3135, 3214, 3213},
	{3133, 3131, 3215},
	{3133, 3215, 3214},
	{3131, 3129, 3216},
	{3131, 3216, 3215},
	{3129, 3127, 3217},
	{3129, 3217, 3216},
	{3127, 3125, 3218},
	{3127, 3218, 3217},
	{3125, 3124, 3188},
	{3125, 3188, 3218},
	{3219, 3220, 3221},
	{3219, 3221, 3222},
	{3223, 3219, 3222},
	{3223, 3222, 3224},
	{3225, 3223, 3224},
	{3225, 3224, 3226},
	{3227, 3225, 3226},
	{3227, 3226, 3228},
	{3229, 3227, 3228},
	{3229, 3228, 3230},
	{3231, 3229, 3230},
	{3231, 3230, 3232},
	{3233, 3231, 3232},
	{3233, 3232, 3234},
	{3235, 3233, 3234},
	{3235, 3234, 3236},
	{3237, 3235, 3236},
	{3237, 3236, 3238},
	{3239, 3237, 3238},
	{3239, 3238, 3240},
	{3241, 3239, 3240},
	{3241, 3240, 3242},
	{3243, 3241, 3242},
	{3243, 3242, 3244},
	{3245, 3243, 3244},
	{3245, 3244, 3246},
	{3247, 3245, 3246},
	{3247, 3246, 3248},
	{3249, 3247, 3248},
	{3249, 3248, 3250},
	{3251, 3249, 3250},
	{3251, 3250, 3252},
	{3253, 3251, 3252},
	{3253, 3252, 3254},
	{3255, 3253, 3254},
	{3255, 3254, 3256},
	{3257, 3255, 3256},
	{3257, 3256, 3258},
	{3259, 3257, 3258},
	{3259, 3258, 3260},
	{3261, 3259, 3260},
	{3261, 3260, 3262},
	{3263, 3261, 3262},
	{3263, 3262, 3264},
	{3265, 3263, 3264},
	{3265, 3264, 3266},
	{3267, 3265, 3266},
	{3267, 3266, 3268},
	{3269, 3267, 3268},
	{3269, 3268, 3270},
	{3271, 3269, 3270},
	{3271, 3270, 3272},
	{3273, 3271, 3272},
	{3273, 3272, 3274},
	{3275, 3273, 3274},
	{3275, 3274, 3276},
	{3277, 3275, 3276},
	{3277, 3276, 3278},
	{3279, 3277, 3278},
	{3279, 3278, 3280},
	{3281, 3279, 3280},
	{3281, 3280, 3282},
	{3220, 3281, 3282},
	{3220, 3282, 3221},
	{3283, 3222, 3221},
	{3283, 3224, 3222},
	{3283, 3226, 3224},
	{3283, 3228, 3226},
	{3283, 3230, 3228},
	{3283, 3232, 3230},
	{3283, 3234, 3232},
	{3283, 3236, 3234},
	{3283, 3238, 3236},
	{3283, 3240, 3238},
	{3283, 3242, 3240},
	{3283, 3244, 3242},
	{3283, 3246, 3244},
	{3283, 3248, 3246},
	{3283, 3250, 3248},
	{3283, 3252, 3250},
	{3283, 3254, 3252},
	{3283, 3256, 3254},
	{3283, 3258, 3256},
	{3283, 3260, 3258},
	{3283, 3262, 3260},
	{3283, 3264, 3262},
	{3283, 3266, 3264},
	{3283, 3268, 3266},
	{3283, 3270, 3268},
	{3283, 3272, 3270},
	{3283, 3274, 3272},
	{3283, 3276, 3274},
	{3283, 3278, 3276},
	{3283, 3280, 3278},
	{3283, 3282, 3280},
	{3283, 3221, 3282},
	{3284, 3285, 3286},
	{3284, 3286, 3287},
	{3287, 3286, 3288},
	{3287, 3288, 3289},
	{3289, 3288, 3290},
	{3289, 3290, 3291},
	{3291, 3290, 3292},
	{3291, 3292, 3293},
	{3293, 3292, 3294},
	{3293, 3294, 3295},
	{3295, 3294, 3296},
	{3295, 3296, 3297},
	{3297, 3296, 3298},
	{3297, 3298, 3299},
	{3299, 3298, 3300},
	{3299, 3300, 3301},
	{3301, 3300, 3302},
	{3301, 3302, 3303},
	{3303, 3302, 3304},
	{3303, 3304, 3305},
	{3305, 3304, 3306},
	{3305, 3306, 3307},
	{3307, 3306, 3308},
	{3307, 3308, 3309},
	{3309, 3308, 3310},
	{3309, 3310, 3311},
	{3311, 3310, 3312},
	{3311, 3312, 3313},
	{3313, 3312, 3314},
	{3313, 3314, 3315},
	{3315, 3314, 3316},
	{3315, 3316, 3317},
	{3317, 3316, 3318},
	{3317, 3318, 3319},
	{3319, 3318, 3320},
	{3319, 3320, 3321},
	{3321, 3320, 3322},
	{3321, 3322, 3323},
	{3323, 3322, 3324},
	{3323, 3324, 3325},
	{3325, 3324, 3326},
	{3325, 3326, 3327},
	{3327, 3326, 3328},
	{3327, 3328, 3329},
	{3329, 3328, 3330},
	{3329, 3330, 3331},
	{3331, 3330, 3332},
	{3331, 3332, 3333},
	{3333, 3332, 3334},
	{3333, 3334, 3335},
	{3335, 3334, 3336},
	{3335, 3336, 3337},
	{3337, 3336, 3338},
	{3337, 3338, 3339},
	{3339, 3338, 3340},
	{3339, 3340, 3341},
	{3341, 3340, 3342},
	{3341, 3342, 3343},
	{3343, 3342, 3344},
	{3343, 3344, 3345},
	{3345, 3344, 3346},
	{3345, 3346, 3347},
	{3285, 3284, 3347},
	{3285, 3347, 3346},
	{3285, 3346, 3348},
	{3285, 3348, 3349},
	{3346, 3344, 3350},
	{3346, 3350, 3348},
	{3344, 3342, 3351},
	{3344, 3351, 3350},
	{3342, 3340, 3352},
	{3342, 3352, 3351},
	{3340, 3338, 3353},
	{3340, 3353, 3352},
	{3338, 3336, 3354},
	{3338, 3354, 3353},
	{3336, 3334, 3355},
	{3336, 3355, 3354},
	{3334, 3332, 3356},
	{3334, 3356, 3355},
	{3332, 3330, 3357},
	{3332, 3357, 3356},
	{3330, 3328, 3358},
	{3330, 3358, 3357},
	{3328, 3326, 3359},
	{3328, 3359, 3358},
	{3326, 3324, 3360},
	{3326, 3360, 3359},
	{3324, 3322, 3361},
	{3324, 3361, 3360},
	{3322, 3320, 3362},
	{3322, 3362, 3361},
	{3320, 3318, 3363},
	{3320, 3363, 3362},
	{3318, 3316, 3364},
	{3318, 3364, 3363},
	{3316, 3314, 3365},
	{3316, 3365, 3364},
	{3314, 3312, 3366},
	{3314, 3366, 3365},
	{3312, 3310, 3367},
	{3312, 3367, 3366},
	{3310, 3308, 3368},
	{3310, 3368, 3367},
	{3308, 3306, 3369},
	{3308, 3369, 3368},
	{3306, 3304, 3370},
	{3306, 3370, 3369},
	{3304, 3302, 3371},
	{3304, 3371, 3370},
	{3302, 3300, 3372},
	{3302, 3372, 3371},
	{3300, 3298, 3373},
	{3300, 3373, 3372},
	{3298, 3296, 3374},
	{3298, 3374, 3373},
	{3296, 3294, 3375},
	{3296, 3375, 3374},
	{3294, 3292, 3376},
	{3294, 3376, 3375},
	{3292, 3290, 3377},
	{3292, 3377, 3376},
	{3290, 3288, 3378},
	{3290, 3378, 3377},
	{3288, 3286, 3379},
	{3288, 3379, 3378},
	{3286, 3285, 3349},
	{3286, 3349, 3379},
	{3380, 3381, 3382},
	{3380, 3382, 3383},
	{3384, 3380, 3383},
	{3384, 3383, 3385},
	{3386, 3384, 3385},
	{3386, 3385, 3387},
	{3388, 3386, 3387},
	{3388, 3387, 3389},
	{3390, 3388, 3389},
	{3390, 3389, 3391},
	{3392, 3390, 3391},
	{3392, 3391, 3393},
	{3394, 3392, 3393},
	{3394, 3393, 3395},
	{3396, 3394, 3395},
	{3396, 3395, 3397},
	{3398, 3396, 3397},
	{3398, 3397, 3399},
	{3400, 3398, 3399},
	{3400, 3399, 3401},
	{3402, 3400, 3401},
	{3402, 3401, 3403},
	{3404, 3402, 3403},
	{3404, 3403, 3405},
	{3406, 3404, 3405},
	{3406, 3405, 3407},
	{3408, 3406, 3407},
	{3408, 3407, 3409},
	{3410, 3408, 3409},
	{3410, 3409, 3411},
	{3412, 3410, 3411},
	{3412, 3411, 3413},
	{3414, 3412, 3413},
	{3414, 3413, 3415},
	{3416, 3414, 3415},
	{3416, 3415, 3417},
	{3418, 3416, 3417},
	{3418, 3417, 3419},
	{3420, 3418, 3419},
	{3420, 3419, 3421},
	{3422, 3420, 3421},
	{3422, 3421, 3423},
	{3424, 3422, 3423},
	{3424, 3423, 3425},
	{3426, 3424, 3425},
	{3426, 3425, 3427},
	{3428, 3426, 3427},
	{3428, 3427, 3429},
	{3430, 3428, 3429},
	{3430, 3429, 3431},
	{3432, 3430, 3431},
	{3432, 3431, 3433},
	{3434, 3432, 3433},
	{3434, 3433, 3435},
	{3436, 3434, 3435},
	{3436, 3435, 3437},
	{3438, 3436, 3437},
	{3438, 3437, 3439},
	{3440, 3438, 3439},
	{3440, 3439, 3441},
	{3442, 3440, 3441},
	{3442, 3441, 3443},
	{3381, 3442, 3443},
	{3381, 3443, 3382},
	{3444, 3383, 3382},
	{3444, 3385, 3383},
	{3444, 3387, 3385},
	{3444, 3389, 3387},
	{3444, 3391, 3389},
	{3444, 3393, 3391},
	{3444, 3395, 3393},
	{3444, 3397, 3395},
	{3444, 3399, 3397},
	{3444, 3401, 3399},
	{3444, 3403, 3401},
	{3444, 3405, 3403},
	{3444, 3407, 3405},
	{3444, 3409, 3407},
	{3444, 3411, 3409},
	{3444, 3413, 3411},
	{3444, 3415, 3413},
	{3444, 3417, 3415},
	{3444, 3419, 3417},
	{3444, 3421, 3419},
	{3444, 3423, 3421},
	{3444, 3425, 3423},
	{3444, 3427, 3425},
	{3444, 3429, 3427},
	{3444, 3431, 3429},
	{3444, 3433, 3431},
	{3444, 3435, 3433},
	{3444, 3437, 3435},
	{3444, 3439, 3437},
	{3444, 3441, 3439},
	{3444, 3443, 3441},
	{3444, 3382, 3443},
	{3445, 3446, 3447},
	{3445, 3447, 3448},
	{3448, 3447, 3449},
	{3448, 3449, 3450},
	{3450, 3449, 3451},
	{3450, 3451, 3452},
	{3452, 3451, 3453},
	{3452, 3453, 3454},
	{3454, 3453, 3455},
	{3454, 3455, 3456},
	{3456, 3455, 3457},
	{3456, 3457, 3458},
	{3458, 3457, 3459},
	{3458, 3459, 3460},
	{3460, 3459, 3461},
	{3460, 3461, 3462},
	{3462, 3461, 3463},
	{3462, 3463, 3464},
	{3464, 3463, 3465},
	{3464, 3465, 3466},
	{3466, 3465, 3467},
	{3466, 3467, 3468},
	{3468, 3467, 3469},
	{3468, 3469, 3470},
	{3470, 3469, 3471},
	{3470, 3471, 3472},
	{3472, 3471, 3473},
	{3472, 3473, 3474},
	{3474, 3473, 3475},
	{3474, 3475, 3476},
	{3476, 3475, 3477},
	{3476, 3477, 3478},
	{3478, 3477, 3479},
	{3478, 3479, 3480},
	{3480, 3479, 3481},
	{3480, 3481, 3482},
	{3482, 3481, 3483},
	{3482, 3483, 3484},
	{3484, 3483, 3485},
	{3484, 3485, 3486},
	{3486, 3485, 3487},
	{3486, 3487, 3488},
	{3488, 3487, 3489},
	{3488, 3489, 3490},
	{3490, 3489, 3491},
	{3490, 3491, 3492},
	{3492, 3491, 3493},
	{3492, 3493, 3494},
	{3494, 3493, 3495},
	{3494, 3495, 3496},
	{3496, 3495, 3497},
	{3496, 3497, 3498},
	{3498, 3497, 3499},
	{3498, 3499, 3500},
	{3500, 3499, 3501},
	{3500, 3501, 3502},
	{3502, 3501, 3503},
	{3502, 3503, 3504},
	{3504, 3503, 3505},
	{3504, 3505, 3506},
	{3506, 3505, 3507},
	{3506, 3507, 3508},
	{3446, 3445, 3508},
	{3446, 3508, 3507},
	{3446, 3507, 3509},
	{3446, 3509, 3510},
	{3507, 3505, 3511},
	{3507, 3511, 3509},
	{3505, 3503, 3512},
	{3505, 3512, 3511},
	{3503, 3501, 3513},
	{3503, 3513, 3512},
	{3501, 3499, 3514},
	{3501, 3514, 3513},
	{3499, 3497, 3515},
	{3499, 3515, 3514},
	{3497, 3495, 3516},
	{3497, 3516, 3515},
	{3495, 3493, 3517},
	{3495, 3517, 3516},
	{3493, 3491, 3518},
	{3493, 3518, 3517},
	{3491, 3489, 3519},
	{3491, 3519, 3518},
	{3489, 3487, 3520},
	{3489, 3520, 3519},
	{3487, 3485, 3521},
	{3487, 3521, 3520},
	{3485, 3483, 3522},
	{3485, 3522, 3521},
	{3483, 3481, 3523},
	{3483, 3523, 3522},
	{3481, 3479, 3524},
	{3481, 3524, 3523},
	{3479, 3477, 3525},
	{3479, 3525, 3524},
	{3477, 3475, 3526},
	{3477, 3526, 3525},
	{3475, 3473, 3527},
	{3475, 3527, 3526},
	{3473, 3471, 3528},
	{3473, 3528, 3527},
	{3471, 3469, 3529},
	{3471, 3529, 3528},
	{3469, 3467, 3530},
	{3469, 3530, 3529},
	{3467, 3465, 3531},
	{3467, 3531, 3530},
	{3465, 3463, 3532},
	{3465, 3532, 3531},
	{3463, 3461, 3533},
	{3463, 3533, 3532},
	{3461, 3459, 3534},
	{3461, 3534, 3533},
	{3459, 3457, 3535},
	{3459, 3535, 3534},
	{3457, 3455, 3536},
	{3457, 3536, 3535},
	{3455, 3453, 3537},
	{3455, 3537, 3536},
	{3453, 3451, 3538},
	{3453, 3538, 3537},
	{3451, 3449, 3539},
	{3451, 3539, 3538},
	{3449, 3447, 3540},
	{3449, 3540, 3539},
	{3447, 3446, 3510},
	{3447, 3510, 3540},
	{3541, 3542, 3543},
	{3541, 3543, 3544},
	{3545, 3541, 3544},
	{3545, 3544, 3546},
	{3547, 3545, 3546},
	{3547, 3546, 3548},
	{3549, 3547, 3548},
	{3549, 3548, 3550},
	{3551, 3549, 3550},
	{3551, 3550, 3552},
	{3553, 3551, 3552},
	{3553, 3552, 3554},
	{3555, 3553, 3554},
	{3555, 3554, 3556},
	{3557, 3555, 3556},
	{3557, 3556, 3558},
	{3559, 3557, 3558},
	{3559, 3558, 3560},
	{3561, 3559, 3560},
	{3561, 3560, 3562},
	{3563, 3561, 3562},
	{3563, 3562, 3564},
	{3565, 3563, 3564},
	{3565, 3564, 3566},
	{3567, 3565, 3566},
	{3567, 3566, 3568},
	{3569, 3567, 3568},
	{3569, 3568, 3570},
	{3571, 3569, 3570},
	{3571, 3570, 3572},
	{3573, 3571, 3572},
	{3573, 3572, 3574},
	{3575, 3573, 3574},
	{3575, 3574, 3576},
	{3577, 3575, 3576},
	{3577, 3576, 3578},
	{3579, 3577, 3578},
	{3579, 3578, 3580},
	{3581, 3579, 3580},
	{3581, 3580, 3582},
	{3583, 3581, 3582},
	{3583, 3582, 3584},
	{3585, 3583, 3584},
	{3585, 3584, 3586},
	{3587, 3585, 3586},
	{3587, 3586, 3588},
	{3589, 3587, 3588},
	{3589, 3588, 3590},
	{3591, 3589, 3590},
	{3591, 3590, 3592},
	{3593, 3591, 3592},
	{3593, 3592, 3594},
	{3595, 3593, 3594},
	{3595, 3594, 3596},
	{3597, 3595, 3596},
	{3597, 3596, 3598},
	{3599, 3597, 3598},
	{3599, 3598, 3600},
	{3601, 3599, 3600},
	{3601, 3600, 3602},
	{3603, 3601, 3602},
	{3603, 3602, 3604},
	{3542, 3603, 3604},
	{3542, 3604, 3543},
	{3605, 3544, 3543},
	{3605, 3546, 3544},
	{3605, 3548, 3546},
	{3605, 3550, 3548},
	{3605, 3552, 3550},
	{3605, 3554, 3552},
	{3605, 3556, 3554},
	{3605, 3558, 3556},
	{3605, 3560, 3558},
	{3605, 3562, 3560},
	{3605, 3564, 3562},
	{3605, 3566, 3564},
	{3605, 3568, 3566},
	{3605, 3570, 3568},
	{3605, 3572, 3570},
	{3605, 3574, 3572},
	{3605, 3576, 3574},
	{3605, 3578, 3576},
	{3605, 3580, 3578},
	{3605, 3582, 3580},
	{3605, 3584, 3582},
	{3605, 3586, 3584},
	{3605, 3588, 3586},
	{3605, 3590, 3588},
	{3605, 3592, 3590},
	{3605, 3594, 3592},
	{3605, 3596, 3594},
	{3605, 3598, 3596},
	{3605, 3600, 3598},
	{3605, 3602, 3600},
	{3605, 3604, 3602},
	{3605, 3543, 3604},
	{3606, 3607, 3608},
	{3606, 3608, 3609},
	{3609, 3608, 3610},
	{3609, 3610, 3611},
	{3611, 3610, 3612},
	{3611, 3612, 3613},
	{3613, 3612, 3614},
	{3613, 3614, 3615},
	{3615, 3614, 3616},
	{3615, 3616, 3617},
	{3617, 3616, 3618},
	{3617, 3618, 3619},
	{3619, 3618, 3620},
	{3619, 3620, 3621},
	{3621, 3620, 3622},
	{3621, 3622, 3623},
	{3623, 3622, 3624},
	{3623, 3624, 3625},
	{3625, 3624, 3626},
	{3625, 3626, 3627},
	{3627, 3626, 3628},
	{3627, 3628, 3629},
	{3629, 3628, 3630},
	{3629, 3630, 3631},
	{3631, 3630, 3632},
	{3631, 3632, 3633},
	{3633, 3632, 3634},
	{3633, 3634, 3635},
	{3635, 3634, 3636},
	{3635, 3636, 3637},
	{3637, 3636, 3638},
	{3637, 3638, 3639},
	{3639, 3638, 3640},
	{3639, 3640, 3641},
	{3641, 3640, 3642},
	{3641, 3642, 3643},
	{3643, 3642, 3644},
	{3643, 3644, 3645},
	{3645, 3644, 3646},
	{3645, 3646, 3647},
	{3647, 3646, 3648},
	{3647, 3648, 3649},
	{3649, 3648, 3650},
	{3649, 3650, 3651},
	{3651, 3650, 3652},
	{3651, 3652, 3653},
	{3653, 3652, 3654},
	{3653, 3654, 3655},
	{3655, 3654, 3656},
	{3655, 3656, 3657},
	{3657, 3656, 3658},
	{3657, 3658, 3659},
	{3659, 3658, 3660},
	{3659, 3660, 3661},
	{3661, 3660, 3662},
	{3661, 3662, 3663},
	{3663, 3662, 3664},
	{3663, 3664, 3665},
	{3665, 3664, 3666},
	{3665, 3666, 3667},
	{3667, 3666, 3668},
	{3667, 3668, 3669},
	{3607, 3606, 3669},
	{3607, 3669, 3668},
	{3607, 3668, 3670},
	{3607, 3670, 3671},
	{3668, 3666, 3672},
	{3668, 3672, 3670},
	{3666, 3664, 3673},
	{3666, 3673, 3672},
	{3664, 3662, 3674},
	{3664, 3674, 3673},
	{3662, 3660, 3675},
	{3662, 3675, 3674},
	{3660, 3658, 3676},
	{3660, 3676, 3675},
	{3658, 3656, 3677},
	{3658, 3677, 3676},
	{3656, 3654, 3678},
	{3656, 3678, 3677},
	{3654, 3652, 3679},
	{3654, 3679, 3678},
	{3652, 3650, 3680},
	{3652, 3680, 3679},
	{3650, 3648, 3681},
	{3650, 3681, 3680},
	{3648, 3646, 3682},
	{3648, 3682, 3681},
	{3646, 3644, 3683},
	{3646, 3683, 3682},
	{3644, 3642, 3684},
	{3644, 3684, 3683},
	{3642, 3640, 3685},
	{3642, 3685, 3684},
	{3640, 3638, 3686},
	{3640, 3686, 3685},
	{3638, 3636, 3687},
	{3638, 3687, 3686},
	{3636, 3634, 3688},
	{3636, 3688, 3687},
	{3634, 3632, 3689},
	{3634, 3689, 3688},
	{3632, 3630, 3690},
	{3632, 3690, 3689},
	{3630, 3628, 3691},
	{3630, 3691, 3690},
	{3628, 3626, 3692},
	{3628, 3692, 3691},
	{3626, 3624, 3693},
	{3626, 3693, 3692},
	{3624, 3622, 3694},
	{3624, 3694, 3693},
	{3622, 3620, 3695},
	{3622, 3695, 3694},
	{3620, 3618, 3696},
	{3620, 3696, 3695},
	{3618, 3616, 3697},
	{3618, 3697, 3696},
	{3616, 3614, 3698},
	{3616, 3698, 3697},
	{3614, 3612, 3699},
	{3614, 3699, 3698},
	{3612, 3610, 3700},
	{3612, 3700, 3699},
	{3610, 3608, 3701},
	{3610, 3701, 3700},
	{3608, 3607, 3671},
	{3608, 3671, 3701},
	{3702, 3703, 3704},
	{3702, 3704, 3705},
	{3706, 3702, 3705},
	{3706, 3705, 3707},
	{3708, 3706, 3707},
	{3708, 3707, 3709},
	{3710, 3708, 3709},
	{3710, 3709, 3711},
	{3712, 3710, 3711},
	{3712, 3711, 3713},
	{3714, 3712, 3713},
	{3714, 3713, 3715},
	{3716, 3714, 3715},
	{3716, 3715, 3717},
	{3718, 3716, 3717},
	{3718, 3717, 3719},
	{3720, 3718, 3719},
	{3720, 3719, 3721},
	{3722, 3720, 3721},
	{3722, 3721, 3723},
	{3724, 3722, 3723},
	{3724, 3723, 3725},
	{3726, 3724, 3725},
	{3726, 3725, 3727},
	{3728, 3726, 3727},
	{3728, 3727, 3729},
	{3730, 3728, 3729},
	{3730, 3729, 3731},
	{3732, 3730, 3731},
	{3732, 3731, 3733},
	{3734, 3732, 3733},
	{3734, 3733, 3735},
	{3736, 3734, 3735},
	{3736, 3735, 3737},
	{3738, 3736, 3737},
	{3738, 3737, 3739},
	{3740, 3738, 3739},
	{3740, 3739, 3741},
	{3742, 3740, 3741},
	{3742, 3741, 3743},
	{3744, 3742, 3743},
	{3744, 3743, 3745},
	{3746, 3744, 3745},
	{3746, 3745, 3747},
	{3748, 3746, 3747},
	{3748, 3747, 3749},
	{3750, 3748, 3749},
	{3750, 3749, 3751},
	{3752, 3750, 3751},
	{3752, 3751, 3753},
	{3754, 3752, 3753},
	{3754, 3753, 3755},
	{3756, 3754, 3755},
	{3756, 3755, 3757},
	{3758, 3756, 3757},
	{3758, 3757, 3759},
	{3760, 3758, 3759},
	{3760, 3759, 3761},
	{3762, 3760, 3761},
	{3762, 3761, 3763},
	{3764, 3762, 3763},
	{3764, 3763, 3765},
	{3703, 3764, 3765},
	{3703, 3765, 3704},
	{3766, 3705, 3704},
	{3766, 3707, 3705},
	{3766, 3709, 3707},
	{3766, 3711, 3709},
	{3766, 3713, 3711},
	{3766, 3715, 3713},
	{3766, 3717, 3715},
	{3766, 3719, 3717},
	{3766, 3721, 3719},
	{3766, 3723, 3721},
	{3766, 3725, 3723},
	{3766, 3727, 3725},
	{3766, 3729, 3727},
	{3766, 3731, 3729},
	{3766, 3733, 3731},
	{3766, 3735, 3733},
	{3766, 3737, 3735},
	{3766, 3739, 3737},
	{3766, 3741, 3739},
	{3766, 3743, 3741},
	{3766, 3745, 3743},
	{3766, 3747, 3745},
	{3766, 3749, 3747},
	{3766, 3751, 3749},
	{3766, 3753, 3751},
	{3766, 3755, 3753},
	{3766, 3757, 3755},
	{3766, 3759, 3757},
	{3766, 3761, 3759},
	{3766, 3763, 3761},
	{3766, 3765, 3763},
	{3766, 3704, 3765},
	{3767, 3768, 3769},
	{3767, 3769, 3770},
	{3770, 3769, 3771},
	{3770, 3771, 3772},
	{3772, 3771, 3773},
	{3772, 3773, 3774},
	{3774, 3773, 3775},
	{3774, 3775, 3776},
	{3776, 3775, 3777},
	{3776, 3777, 3778},
	{3778, 3777, 3779},
	{3778, 3779, 3780},
	{3780, 3779, 3781},
	{3780, 3781, 3782},
	{3782, 3781, 3783},
	{3782, 3783, 3784},
	{3784, 3783, 3785},
	{3784, 3785, 3786},
	{3786, 3785, 3787},
	{3786, 3787, 3788},
	{3788, 3787, 3789},
	{3788, 3789, 3790},
	{3790, 3789, 3791},
	{3790, 3791, 3792},
	{3792, 3791, 3793},
	{3792, 3793, 3794},
	{3794, 3793, 3795},
	{3794, 3795, 3796},
	{3796, 3795, 3797},
	{3796, 3797, 3798},
	{3798, 3797, 3799},
	{3798, 3799, 3800},
	{3800, 3799, 3801},
	{3800, 3801, 3802},
	{3802, 3801, 3803},
	{3802, 3803, 3804},
	{3804, 3803, 3805},
	{3804, 3805, 3806},
	{3806, 3805, 3807},
	{3806, 3807, 3808},
	{3808, 3807, 3809},
	{3808, 3809, 3810},
	{3810, 3809, 3811},
	{3810, 3811, 3812},
	{3812, 3811, 3813},
	{3812, 3813, 3814},
	{3814, 3813, 3815},
	{3814, 3815, 3816},
	{3816, 3815, 3817},
	{3816, 3817, 3818},
	{3818, 3817, 3819},
	{3818, 3819, 3820},
	{3820, 3819, 3821},
	{3820, 3821, 3822},
	{3822, 3821, 3823},
	{3822, 3823, 3824},
	{3824, 3823, 3825},
	{3824, 3825, 3826},
	{3826, 3825, 3827},
	{3826, 3827, 3828},
	{3828, 3827, 3829},
	{3828, 3829, 3830},
	{3768, 3767, 3830},
	{3768, 3830, 3829},
	{3768, 3829, 3831},
	{3768, 3831, 3832},
	{3829, 3827, 3833},
	{3829, 3833, 3831},
	{3827, 3825, 3834},
	{3827, 3834, 3833},
	{3825, 3823, 3835},
	{3825, 3835, 3834},
	{3823, 3821, 3836},
	{3823, 3836, 3835},
	{3821, 3819, 3837},
	{3821, 3837, 3836},
	{3819, 3817, 3838},
	{3819, 3838, 3837},
	{3817, 3815, 3839},
	{3817, 3839, 3838},
	{3815, 3813, 3840},
	{3815, 3840, 3839},
	{3813, 3811, 3841},
	{3813, 3841, 3840},
	{3811, 3809, 3842},
	{3811, 3842, 3841},
	{3809, 3807, 3843},
	{3809, 3843, 3842},
	{3807, 3805, 3844},
	{3807, 3844, 3843},
	{3805, 3803, 3845},
	{3805, 3845, 3844},
	{3803, 3801, 3846},
	{3803, 3846, 3845},
	{3801, 3799, 3847},
	{3801, 3847, 3846},
	{3799, 3797, 3848},
	{3799, 3848, 3847},
	{3797, 3795, 3849},
	{3797, 3849, 3848},
	{3795, 3793, 3850},
	{3795, 3850, 3849},
	{3793, 3791, 3851},
	{3793, 3851, 3850},
	{3791, 3789, 3852},
	{3791, 3852, 3851},
	{3789, 3787, 3853},
	{3789, 3853, 3852},
	{3787, 3785, 3854},
	{3787, 3854, 3853},
	{3785, 3783, 3855},
	{3785, 3855, 3854},
	{3783, 3781, 3856},
	{3783, 3856, 3855},
	{3781, 3779, 3857},
	{3781, 3857, 3856},
	{3779, 3777, 3858},
	{3779, 3858, 3857},
	{3777, 3775, 3859},
	{3777, 3859, 3858},
	{3775, 3773, 3860},
	{3775, 3860, 3859},
	{3773, 3771, 3861},
	{3773, 3861, 3860},
	{3771, 3769, 3862},
	{3771, 3862, 3861},
	{3769, 3768, 3832},
	{3769, 3832, 3862},
	{3863, 3864, 3865},
	{3863, 3865, 3866},
	{3867, 3863, 3866},
	{3867, 3866, 3868},
	{3869, 3867, 3868},
	{3869, 3868, 3870},
	{3871, 3869, 3870},
	{3871, 3870, 3872},
	{3873, 3871, 3872},
	{3873, 3872, 3874},
	{3875, 3873, 3874},
	{3875, 3874, 3876},
	{3877, 3875, 3876},
	{3877, 3876, 3878},
	{3879, 3877, 3878},
	{3879, 3878, 3880},
	{3881, 3879, 3880},
	{3881, 3880, 3882},
	{3883, 3881, 3882},
	{3883, 3882, 3884},
	{3885, 3883, 3884},
	{3885, 3884, 3886},
	{3887, 3885, 3886},
	{3887, 3886, 3888},
	{3889, 3887, 3888},
	{3889, 3888, 3890},
	{3891, 3889, 3890},
	{3891, 3890, 3892},
	{3893, 3891, 3892},
	{3893, 3892, 3894},
	{3895, 3893, 3894},
	{3895, 3894, 3896},
	{3897, 3895, 3896},
	{3897, 3896, 3898},
	{3899, 3897, 3898},
	{3899, 3898, 3900},
	{3901, 3899, 3900},
	{3901, 3900, 3902},
	{3903, 3901, 3902},
	{3903, 3902, 3904},
	{3905, 3903, 3904},
	{3905, 3904, 3906},
	{3907, 3905, 3906},
	{3907, 3906, 3908},
	{3909, 3907, 3908},
	{3909, 3908, 3910},
	{3911, 3909, 3910},
	{3911, 3910, 3912},
	{3913, 3911, 3912},
	{3913, 3912, 3914},
	{3915, 3913, 3914},
	{3915, 3914, 3916},
	{3917, 3915, 3916},
	{3917, 3916, 3918},
	{3919, 3917, 3918},
	{3919, 3918, 3920},
	{3921, 3919, 3920},
	{3921, 3920, 3922},
	{3923, 3921, 3922},
	{3923, 3922, 3924},
	{3925, 3923, 3924},
	{3925, 3924, 3926},
	{3864, 3925, 3926},
	{3864, 3926, 3865},
	{3927, 3866, 3865},
	{3927, 3868, 3866},
	{3927, 3870, 3868},
	{3927, 3872, 3870},
	{3927, 3874, 3872},
	{3927, 3876, 3874},
	{3927, 3878, 3876},
	{3927, 3880, 3878},
	{3927, 3882, 3880},
	{3927, 3884, 3882},
	{3927, 3886, 3884},
	{3927, 3888, 3886},
	{3927, 3890, 3888},
	{3927, 3892, 3890},
	{3927, 3894, 3892},
	{3927, 3896, 3894},
	{3927, 3898, 3896},
	{3927, 3900, 3898},
	{3927, 3902, 3900},
	{3927, 3904, 3902},
	{3927, 3906, 3904},
	{3927, 3908, 3906},
	{3927, 3910, 3908},
	{3927, 3912, 3910},
	{3927, 3914, 3912},
	{3927, 3916, 3914},
	{3927, 3918, 3916},
	{3927, 3920, 3918},
	{3927, 3922, 3920},
	{3927, 3924, 3922},
	{3927, 3926, 3924},
	{3927, 3865, 3926},
	{3928, 3929, 3930},
	{3928, 3930, 3931},
	{3931, 3930, 3932},
	{3931, 3932, 3933},
	{3933, 3932, 3934},
	{3933, 3934, 3935},
	{3935, 3934, 3936},
	{3935, 3936, 3937},
	{3937, 3936, 3938},
	{3937, 3938, 3939},
	{3939, 3938, 3940},
	{3939, 3940, 3941},
	{3941, 3940, 3942},
	{3941, 3942, 3943},
	{3943, 3942, 3944},
	{3943, 3944, 3945},
	{3945, 3944, 3946},
	{3945, 3946, 3947},
	{3947, 3946, 3948},
	{3947, 3948, 3949},
	{3949, 3948, 3950},
	{3949, 3950, 3951},
	{3951, 3950, 3952},
	{3951, 3952, 3953},
	{3953, 3952, 3954},
	{3953, 3954, 3955},
	{3955, 3954, 3956},
	{3955, 3956, 3957},
	{3957, 3956, 3958},
	{3957, 3958, 3959},
	{3959, 3958, 3960},
	{3959, 3960, 3961},
	{3961, 3960, 3962},
	{3961, 3962, 3963},
	{3963, 3962, 3964},
	{3963, 3964, 3965},
	{3965, 3964, 3966},
	{3965, 3966, 3967},
	{3967, 3966, 3968},
	{3967, 3968, 3969},
	{3969, 3968, 3970},
	{3969, 3970, 3971},
	{3971, 3970, 3972},
	{3971, 3972, 3973},
	{3973, 3972, 3974},
	{3973, 3974, 3975},
	{3975, 3974, 3976},
	{3975, 3976, 3977},
	{3977, 3976, 3978},
	{3977, 3978, 3979},
	{3979, 3978, 3980},
	{3979, 3980, 3981},
	{3981, 3980, 3982},
	{3981, 3982, 3983},
	{3983, 3982, 3984},
	{3983, 3984, 3985},
	{3985, 3984, 3986},
	{3985, 3986, 3987},
	{3987, 3986, 3988},
	{3987, 3988, 3989},
	{3989, 3988, 3990},
	{3989, 3990, 3991},
	{3929, 3928, 3991},
	{3929, 3991, 3990},
	{3929, 3990, 3992},
	{3929, 3992, 3993},
	{3990, 3988, 3994},
	{3990, 3994, 3992},
	{3988, 3986, 3995},
	{3988, 3995, 3994},
	{3986, 3984, 3996},
	{3986, 3996, 3995},
	{3984, 3982, 3997},
	{3984, 3997, 3996},
	{3982, 3980, 3998},
	{3982, 3998, 3997},
	{3980, 3978, 3999},
	{3980, 3999, 3998},
	{3978, 3976, 4000},
	{3978, 4000, 3999},
	{3976, 3974, 4001},
	{3976, 4001, 4000},
	{3974, 3972, 4002},
	{3974, 4002, 4001},
	{3972, 3970, 4003},
	{3972, 4003, 4002},
	{3970, 3968, 4004},
	{3970, 4004, 4003},
	{3968, 3966, 4005},
	{3968, 4005, 4004},
	{3966, 3964, 4006},
	{3966, 4006, 4005},
	{3964, 3962, 4007},
	{3964, 4007, 4006},
	{3962, 3960, 4008},
	{3962, 4008, 4007},
	{3960, 3958, 4009},
	{3960, 4009, 4008},
	{3958, 3956, 4010},
	{3958, 4010, 4009},
	{3956, 3954, 4011},
	{3956, 4011, 4010},
	{3954, 3952, 4012},
	{3954, 4012, 4011},
	{3952, 3950, 4013},
	{3952, 4013, 4012},
	{3950, 3948, 4014},
	{3950, 4014, 4013},
	{3948, 3946, 4015},
	{3948, 4015, 4014},
	{3946, 3944, 4016},
	{3946, 4016, 4015},
	{3944, 3942, 4017},
	{3944, 4017, 4016},
	{3942, 3940, 4018},
	{3942, 4018, 4017},
	{3940, 3938, 4019},
	{3940, 4019, 4018},
	{3938, 3936, 4020},
	{3938, 4020, 4019},
	{3936, 3934, 4021},
	{3936, 4021, 4020},
	{3934, 3932, 4022},
	{3934, 4022, 4021},
	{3932, 3930, 4023},
	{3932, 4023, 4022},
	{3930, 3929, 3993},
	{3930, 3993, 4023},
	{4024, 4025, 4026},
	{4024, 4026, 4027},
	{4028, 4024, 4027},
	{4028, 4027, 4029},
	{4030, 4028, 4029},
	{4030, 4029, 4031},
	{4032, 4030, 4031},
	{4032, 4031, 4033},
	{4034, 4032, 4033},
	{4034, 4033, 4035},
	{4036, 4034, 4035},
	{4036, 4035, 4037},
	{4038, 4036, 4037},
	{4038, 4037, 4039},
	{4040, 4038, 4039},
	{4040, 4039, 4041},
	{4042, 4040, 4041},
	{4042, 4041, 4043},
	{4044, 4042, 4043},
	{4044, 4043, 4045},
	{4046, 4044, 4045},
	{4046, 4045, 4047},
	{4048, 4046, 4047},
	{4048, 4047, 4049},
	{4050, 4048, 4049},
	{4050, 4049, 4051},
	{4052, 4050, 4051},
	{4052, 4051, 4053},
	{4054, 4052, 4053},
	{4054, 4053, 4055},
	{4056, 4054, 4055},
	{4056, 4055, 4057},
	{4058, 4056, 4057},
	{4058, 4057, 4059},
	{4060, 4058, 4059},
	{4060, 4059, 4061},
	{4062, 4060, 4061},
	{4062, 4061, 4063},
	{4064, 4062, 4063},
	{4064, 4063, 4065},
	{4066, 4064, 4065},
	{4066, 4065, 4067},
	{4068, 4066, 4067},
	{4068, 4067, 4069},
	{4070, 4068, 4069},
	{4070, 4069, 4071},
	{4072, 4070, 4071},
	{4072, 4071, 4073},
	{4074, 4072, 4073},
	{4074, 4073, 4075},
	{4076, 4074, 4075},
	{4076, 4075, 4077},
	{4078, 4076, 4077},
	{4078, 4077, 4079},
	{4080, 4078, 4079},
	{4080, 4079, 4081},
	{4082, 4080, 4081},
	{4082, 4081, 4083},
	{4084, 4082, 4083},
	{4084, 4083, 4085},
	{4086, 4084, 4085},
	{4086, 4085, 4087},
	{4025, 4086, 4087},
	{4025, 4087, 4026},
	{4088, 4027, 4026},
	{4088, 4029, 4027},
	{4088, 4031, 4029},
	{4088, 4033, 4031},
	{4088, 4035, 4033},
	{4088, 4037, 4035},
	{4088, 4039, 4037},
	{4088, 4041, 4039},
	{4088, 4043, 4041},
	{4088, 4045, 4043},
	{4088, 4047, 4045},
	{4088, 4049, 4047},
	{4088, 4051, 4049},
	{4088, 4053, 4051},
	{4088, 4055, 4053},
	{4088, 4057, 4055},
	{4088, 4059, 4057},
	{4088, 4061, 4059},
	{4088, 4063, 4061},
	{4088, 4065, 4063},
	{4088, 4067, 4065},
	{4088, 4069, 4067},
	{4088, 4071, 4069},
	{4088, 4073, 4071},
	{4088, 4075, 4073},
	{4088, 4077, 4075},
	{4088, 4079, 4077},
	{4088, 4081, 4079},
	{4088, 4083, 4081},
	{4088, 4085, 4083},
	{4088, 4087, 4085},
	{4088, 4026, 4087},
	{4089, 4090, 4091},
	{4089, 4091, 4092},
	{4090, 4093, 4094},
	{4090, 4094, 4091},
	{4093, 4095, 4096},
	{4093, 4096, 4094},
	{4097, 4098, 4099},
	{4097, 4099, 4100},
	{4101, 4097, 4100},
	{4101, 4100, 4102},
	{4103, 4101, 4102},
	{4103, 4102, 4104},
	{4095, 4105, 4106},
	{4095, 4106, 4096},
	{4105, 4107, 4108},
	{4105, 4108, 4106},
	{4107, 4109, 4110},
	{4107, 4110, 4108},
	{4111, 4112, 4113},
	{4111, 4113, 4114},
	{4112, 4115, 4116},
	{4112, 4116, 4113},
	{4115, 4117, 4118},
	{4115, 4118, 4116},
	{4117, 4119, 4120},
	{4117, 4120, 4118},
	{4119, 4121, 4122},
	{4119, 4122, 4120},
	{4121, 4123, 4124},
	{4121, 4124, 4122},
	{4098, 4125, 4126},
	{4098, 4126, 4099},
	{4125, 4127, 4128},
	{4125, 4128, 4126},
	{4127, 4129, 4130},
	{4127, 4130, 4128},
	{4131, 4132, 4133},
	{4131, 4133, 4134},
	{4132, 4135, 4136},
	{4132, 4136, 4133},
	{4135, 4137, 4138},
	{4135, 4138, 4136},
	{4139, 4140, 4141},
	{4139, 4141, 4142},
	{4143, 4139, 4142},
	{4143, 4142, 4144},
	{4145, 4143, 4144},
	{4145, 4144, 4146},
	{4137, 4147, 4148},
	{4137, 4148, 4138},
	{4147, 4149, 4150},
	{4147, 4150, 4148},
	{4149, 4151, 4152},
	{4149, 4152, 4150},
	{4153, 4154, 4155},
	{4153, 4155, 4156},
	{4154, 4157, 4158},
	{4154, 4158, 4155},
	{4157, 4159, 4160},
	{4157, 4160, 4158},
	{4159, 4161, 4162},
	{4159, 4162, 4160},
	{4161, 4163, 4164},
	{4161, 4164, 4162},
	{4163, 4165, 4166},
	{4163, 4166, 4164},
	{4140, 4167, 4168},
	{4140, 4168, 4141},
	{4167, 4169, 4170},
	{4167, 4170, 4168},
	{4169, 4171, 4172},
	{4169, 4172, 4170},
	{4173, 4174, 4175},
	{4173, 4175, 4176},
	{4176, 4175, 4177},
	{4176, 4177, 4178},
	{4178, 4177, 4179},
	{4178, 4179, 4180},
	{4181, 4182, 4183},
	{4181, 4183, 4184},
	{4185, 4186, 4182},
	{4185, 4182, 4181},
	{4187, 4188, 4186},
	{4187, 4186, 4185},
	{4180, 4179, 4189},
	{4180, 4189, 4190},
	{4190, 4189, 4191},
	{4190, 4191, 4192},
	{4192, 4191, 4193},
	{4192, 4193, 4194},
	{4195, 4196, 4197},
	{4195, 4197, 4198},
	{4198, 4197, 4199},
	{4198, 4199, 4200},
	{4200, 4199, 4201},
	{4200, 4201, 4202},
	{4202, 4201, 4203},
	{4202, 4203, 4204},
	{4204, 4203, 4205},
	{4204, 4205, 4206},
	{4206, 4205, 4207},
	{4206, 4207, 4208},
	{4184, 4183, 4209},
	{4184, 4209, 4210},
	{4210, 4209, 4211},
	{4210, 4211, 4212},
	{4212, 4211, 4213},
	{4212, 4213, 4214},
	{4215, 4216, 4217},
	{4215, 4217, 4218},
	{4218, 4217, 4219},
	{4218, 4219, 4220},
	{4220, 4219, 4221},
	{4220, 4221, 4222},
	{4223, 4224, 4225},
	{4223, 4225, 4226},
	{4227, 4228, 4224},
	{4227, 4224, 4223},
	{4229, 4230, 4228},
	{4229, 4228, 4227},
	{4222, 4221, 4231},
	{4222, 4231, 4232},
	{4232, 4231, 4233},
	{4232, 4233, 4234},
	{4234, 4233, 4235},
	{4234, 4235, 4236},
	{4237, 4238, 4239},
	{4237, 4239, 4240},
	{4240, 4239, 4241},
	{4240, 4241, 4242},
	{4242, 4241, 4243},
	{4242, 4243, 4244},
	{4244, 4243, 4245},
	{4244, 4245, 4246},
	{4246, 4245, 4247},
	{4246, 4247, 4248},
	{4248, 4247, 4249},
	{4248, 4249, 4250},
	{4226, 4225, 4251},
	{4226, 4251, 4252},
	{4252, 4251, 4253},
	{4252, 4253, 4254},
	{4254, 4253, 4255},
	{4254, 4255, 4256},
	{4257, 4258, 4259},
	{4257, 4259, 4260},
	{4258, 4261, 4262},
	{4258, 4262, 4259},
	{4261, 4263, 4264},
	{4261, 4264, 4262},
	{4265, 4266, 4267},
	{4265, 4267, 4268},
	{4269, 4265, 4268},
	{4269, 4268, 4270},
	{4271, 4269, 4270},
	{4271, 4270, 4272},
	{4263, 4273, 4274},
	{4263, 4274, 4264},
	{4273, 4275, 4276},
	{4273, 4276, 4274},
	{4275, 4277, 4278},
	{4275, 4278, 4276},
	{4279, 4280, 4281},
	{4279, 4281, 4282},
	{4280, 4283, 4284},
	{4280, 4284, 4281},
	{4283, 4285, 4286},
	{4283, 4286, 4284},
	{4285, 4287, 4288},
	{4285, 4288, 4286},
	{4287, 4289, 4290},
	{4287, 4290, 4288},
	{4289, 4291, 4292},
	{4289, 4292, 4290},
	{4266, 4293, 4294},
	{4266, 4294, 4267},
	{4293, 4295, 4296},
	{4293, 4296, 4294},
	{4295, 4297, 4298},
	{4295, 4298, 4296},
	{4299, 4300, 4301},
	{4299, 4301, 4302},
	{4300, 4303, 4304},
	{4300, 4304, 4301},
	{4303, 4305, 4306},
	{4303, 4306, 4304},
	{4307, 4308, 4309},
	{4307, 4309, 4310},
	{4311, 4307, 4310},
	{4311, 4310, 4312},
	{4313, 4311, 4312},
	{4313, 4312, 4314},
	{4305, 4315, 4316},
	{4305, 4316, 4306},
	{4315, 4317, 4318},
	{4315, 4318, 4316},
	{4317, 4319, 4320},
	{4317, 4320, 4318},
	{4321, 4322, 4323},
	{4321, 4323, 4324},
	{4322, 4325, 4326},
	{4322, 4326, 4323},
	{4325, 4327, 4328},
	{4325, 4328, 4326},
	{4327, 4329, 4330},
	{4327, 4330, 4328},
	{4329, 4331, 4332},
	{4329, 4332, 4330},
	{4331, 4333, 4334},
	{4331, 4334, 4332},
	{4308, 4335, 4336},
	{4308, 4336, 4309},
	{4335, 4337, 4338},
	{4335, 4338, 4336},
	{4337, 4339, 4340},
	{4337, 4340, 4338},
	{4341, 4342, 4343},
	{4341, 4343, 4344},
	{4344, 4343, 4345},
	{4344, 4345, 4346},
	{4346, 4345, 4347},
	{4346, 4347, 4348},
	{4349, 4350, 4351},
	{4349, 4351, 4352},
	{4353, 4354, 4350},
	{4353, 4350, 4349},
	{4355, 4356, 4354},
	{4355, 4354, 4353},
	{4348, 4347, 4357},
	{4348, 4357, 4358},
	{4358, 4357, 4359},
	{4358, 4359, 4360},
	{4360, 4359, 4361},
	{4360, 4361, 4362},
	{4363, 4364, 4365},
	{4363, 4365, 4366},
	{4366, 4365, 4367},
	{4366, 4367, 4368},
	{4368, 4367, 4369},
	{4368, 4369, 4370},
	{4370, 4369, 4371},
	{4370, 4371, 4372},
	{4372, 4371, 4373},
	{4372, 4373, 4374},
	{4374, 4373, 4375},
	{4374, 4375, 4376},
	{4352, 4351, 4377},
	{4352, 4377, 4378},
	{4378, 4377, 4379},
	{4378, 4379, 4380},
	{4380, 4379, 4381},
	{4380, 4381, 4382},
	{4383, 4384, 4385},
	{4383, 4385, 4386},
	{4386, 4385, 4387},
	{4386, 4387, 4388},
	{4388, 4387, 4389},
	{4388, 4389, 4390},
	{4391, 4392, 4393},
	{4391, 4393, 4394},
	{4395, 4396, 4392},
	{4395, 4392, 4391},
	{4397, 4398, 4396},
	{4397, 4396, 4395},
	{4390, 4389, 4399},
	{4390, 4399, 4400},
	{4400, 4399, 4401},
	{4400, 4401, 4402},
	{4402, 4401, 4403},
	{4402, 4403, 4404},
	{4405, 4406, 4407},
	{4405, 4407, 4408},
	{4408, 4407, 4409},
	{4408, 4409, 4410},
	{4410, 4409, 4411},
	{4410, 4411, 4412},
	{4412, 4411, 4413},
	{4412, 4413, 4414},
	{4414, 4413, 4415},
	{4414, 4415, 4416},
	{4416, 4415, 4417},
	{4416, 4417, 4418},
	{4394, 4393, 4419},
	{4394, 4419, 4420},
	{4420, 4419, 4421},
	{4420, 4421, 4422},
	{4422, 4421, 4423},
	{4422, 4423, 4424},
	{4425, 4426, 4427},
	{4425, 4427, 4428},
	{4426, 4429, 4430},
	{4426, 4430, 4427},
	{4431, 4425, 4428},
	{4431, 4428, 4432},
	{4433, 4431, 4432},
	{4433, 4432, 4434},
	{4435, 4436, 4437},
	{4435, 4437, 4438},
	{4438, 4437, 4439},
	{4438, 4439, 4440},
	{4441, 4442, 4443},
	{4441, 4443, 4444},
	{4440, 4439, 4442},
	{4440, 4442, 4441},
	{4445, 4446, 4447},
	{4445, 4447, 4448},
	{4446, 4449, 4450},
	{4446, 4450, 4447},
	{4451, 4445, 4448},
	{4451, 4448, 4452},
	{4453, 4451, 4452},
	{4453, 4452, 4454},
	{4455, 4456, 4457},
	{4455, 4457, 4458},
	{4458, 4457, 4459},
	{4458, 4459, 4460},
	{4461, 4462, 4463},
	{4461, 4463, 4464},
	{4460, 4459, 4462},
	{4460, 4462, 4461},
	{4465, 4466, 4467},
	{4465, 4467, 4468},
	{4466, 4469, 4470},
	{4466, 4470, 4467},
	{4471, 4465, 4468},
	{4471, 4468, 4472},
	{4473, 4471, 4472},
	{4473, 4472, 4474},
	{4475, 4476, 4477},
	{4475, 4477, 4478},
	{4478, 4477, 4479},
	{4478, 4479, 4480},
	{4481, 4482, 4483},
	{4481, 4483, 4484},
	{4480, 4479, 4482},
	{4480, 4482, 4481},
	{4485, 4486, 4487},
	{4485, 4487, 4488},
	{4486, 4489, 4490},
	{4486, 4490, 4487},
	{4491, 4485, 4488},
	{4491, 4488, 4492},
	{4493, 4491, 4492},
	{4493, 4492, 4494},
	{4495, 4496, 4497},
	{4495, 4497, 4498},
	{4498, 4497, 4499},
	{4498, 4499, 4500},
	{4501, 4502, 4503},
	{4501, 4503, 4504},
	{4500, 4499, 4502},
	{4500, 4502, 4501},
	{4505, 4506, 4507},
	{4505, 4507, 4508},
	{4506, 4509, 4510},
	{4506, 4510, 4507},
	{4511, 4505, 4508},
	{4511, 4508, 4512},
	{4513, 4511, 4512},
	{4513, 4512, 4514},
	{4515, 4516, 4517},
	{4515, 4517, 4518},
	{4518, 4517, 4519},
	{4518, 4519, 4520},
	{4521, 4522, 4523},
	{4521, 4523, 4524},
	{4520, 4519, 4522},
	{4520, 4522, 4521},
	{4525, 4526, 4527},
	{4525, 4527, 4528},
	{4526, 4529, 4530},
	{4526, 4530, 4527},
	{4531, 4525, 4528},
	{4531, 4528, 4532},
	{4533, 4531, 4532},
	{4533, 4532, 4534},
	{4535, 4536, 4537},
	{4535, 4537, 4538},
	{4538, 4537, 4539},
	{4538, 4539, 4540},
	{4541, 4542, 4543},
	{4541, 4543, 4544},
	{4540, 4539, 4542},
	{4540, 4542, 4541},
	{4545, 4546, 4547},
	{4545, 4547, 4548},
	{4546, 4549, 4550},
	{4546, 4550, 4547},
	{4551, 4545, 4548},
	{4551, 4548, 4552},
	{4553, 4551, 4552},
	{4553, 4552, 4554},
	{4555, 4556, 4557},
	{4555, 4557, 4558},
	{4558, 4557, 4559},
	{4558, 4559, 4560},
	{4561, 4562, 4563},
	{4561, 4563, 4564},
	{4560, 4559, 4562},
	{4560, 4562, 4561},
	{4565, 4566, 4567},
	{4565, 4567, 4568},
	{4566, 4569, 4570},
	{4566, 4570, 4567},
	{4571, 4565, 4568},
	{4571, 4568, 4572},
	{4573, 4571, 4572},
	{4573, 4572, 4574},
	{4575, 4576, 4577},
	{4575, 4577, 4578},
	{4578, 4577, 4579},
	{4578, 4579, 4580},
	{4581, 4582, 4583},
	{4581, 4583, 4584},
	{4580, 4579, 4582},
	{4580, 4582, 4581},
	{4585, 4586, 4587},
	{4585, 4587, 4588},
	{4586, 4589, 4590},
	{4586, 4590, 4587},
	{4591, 4585, 4588},
	{4591, 4588, 4592},
	{4593, 4591, 4592},
	{4593, 4592, 4594},
	{4595, 4596, 4597},
	{4595, 4597, 4598},
	{4598, 4597, 4599},
	{4598, 4599, 4600},
	{4601, 4602, 4603},
	{4601, 4603, 4604},
	{4600, 4599, 4602},
	{4600, 4602, 4601},
	{4605, 4606, 4607},
	{4605, 4607, 4608},
	{4606, 4609, 4610},
	{4606, 4610, 4607},
	{4611, 4605, 4608},
	{4611, 4608, 4612},
	{4613, 4611, 4612},
	{4613, 4612, 4614},
	{4615, 4616, 4617},
	{4615, 4617, 4618},
	{4618, 4617, 4619},
	{4618, 4619, 4620},
	{4621, 4622, 4623},
	{4621, 4623, 4624},
	{4620, 4619, 4622},
	{4620, 4622, 4621},
	{4625, 4626, 4627},
	{4625, 4627, 4628},
	{4626, 4629, 4630},
	{4626, 4630, 4627},
	{4631, 4625, 4628},
	{4631, 4628, 4632},
	{4633, 4631, 4632},
	{4633, 4632, 4634},
	{4635, 4636, 4637},
	{4635, 4637, 4638},
	{4638, 4637, 4639},
	{4638, 4639, 4640},
	{4641, 4642, 4643},
	{4641, 4643, 4644},
	{4640, 4639, 4642},
	{4640, 4642, 4641},
	{4645, 4646, 4647},
	{4645, 4647, 4648},
	{4646, 4649, 4650},
	{4646, 4650, 4647},
	{4651, 4645, 4648},
	{4651, 4648, 4652},
	{4653, 4651, 4652},
	{4653, 4652, 4654},
	{4655, 4656, 4657},
	{4655, 4657, 4658},
	{4658, 4657, 4659},
	{4658, 4659, 4660},
	{4661, 4662, 4663},
	{4661, 4663, 4664},
	{4660, 4659, 4662},
	{4660, 4662, 4661},
	{4665, 4666, 4667},
	{4665, 4667, 4668},
	{4669, 4670, 4671},
	{4669, 4671, 4672},
	{4673, 4674, 4675},
	{4673, 4675, 4676},
	{4677, 4678, 4679},
	{4677, 4679, 4680},
	{4681, 4682, 4683},
	{4681, 4683, 4684},
	{4685, 4686, 4687},
	{4685, 4687, 4688},
	{4689, 4690, 4691},
	{4689, 4691, 4692},
	{4693, 4694, 4695},
	{4693, 4695, 4696},
	{4697, 4698, 4699},
	{4697, 4699, 4700},
	{4701, 4702, 4703},
	{4701, 4703, 4704},
	{4705, 4706, 4707},
	{4705, 4707, 4708},
	{4709, 4710, 4711},
	{4709, 4711, 4712},
	{4713, 4714, 4715},
	{4713, 4715, 4716},
	{4717, 4718, 4719},
	{4717, 4719, 4720},
	{4721, 4722, 4723},
	{4721, 4723, 4724},
	{4725, 4726, 4727},
	{4725, 4727, 4728},
	{4729, 4730, 4731},
	{4729, 4731, 4732},
	{4733, 4734, 4735},
	{4733, 4735, 4736},
	{4737, 4738, 4739},
	{4737, 4739, 4740},
	{4741, 4742, 4743},
	{4741, 4743, 4744},
	{4745, 4746, 4747},
	{4745, 4747, 4748},
	{4749, 4750, 4751},
	{4749, 4751, 4752},
	{4753, 4754, 4755},
	{4753, 4755, 4756},
	{4757, 4758, 4759},
	{4757, 4759, 4760},
};

