/****************************************************************************
**
** Copyright (C) 2007-2009 Kevin Clague. All rights reserved.
** Copyright (C) 2015 - 2025 Trevor SANDY. All rights reserved.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

/****************************************************************************
*
* These dialogs provide graphical user interfaces for the UnitsMeta.
*
* Please see lpub.h for an overall description of how the files in LPub3D
* make up the LPub program.
*
***************************************************************************/

#include "scaledialog.h"
#include <QVBoxLayout>
#include <QGroupBox>
#include <QDialogButtonBox>

#include "commonmenus.h"
#include "metagui.h"

UnitsDialog::UnitsDialog(
  float   values[2],
  QString _name,
  QString _labels,
  QWidget *parent)
  : QDialog(parent)
{
  setWindowTitle(_name);
  setWhatsThis(lpubWT(WT_DIALOG_UNITS,windowTitle()));

  QVBoxLayout *layout = new QVBoxLayout(this);
  setLayout(layout);

  QGroupBox *box = new QGroupBox(_name,this);
  layout->addWidget(box);
  meta.setValues(values[0],values[1]);
  units = new UnitsGui(_labels.isEmpty() ? tr("L/R|T/B") : _labels, &meta, box, false/*isMargin*/);

  QDialogButtonBox *buttonBox;
  buttonBox = new QDialogButtonBox(this);
  buttonBox->addButton(QDialogButtonBox::Ok);
  connect(buttonBox,SIGNAL(accepted()),SLOT(accept()));
  buttonBox->addButton(QDialogButtonBox::Cancel);
  connect(buttonBox,SIGNAL(rejected()),SLOT(cancel()));
  layout->addWidget(buttonBox);

  setModal(true);
  setMinimumSize(40,20);
}

UnitsDialog::~UnitsDialog()
{
}

bool UnitsDialog::getUnits(
  float    values[2],
  QString  name,
  QString  labels,
  QWidget *parent)
{
  UnitsDialog *dialog = new UnitsDialog(values,name,labels,parent);

  bool ok = dialog->exec() == QDialog::Accepted;

  if (ok) {
    values[0] = dialog->meta.value(0);
    values[1] = dialog->meta.value(1);
  }
  return ok;
}

void UnitsDialog::accept()
{
  if (units->modified) {
    QDialog::accept();
  } else {
    QDialog::reject();
  }
}

void UnitsDialog::cancel()
{
  QDialog::reject();
}
