#include "8bit.h"
#include "iso5cvt.h"

using namespace std;


static const wchar_t iso2ucs[] = {
	0x00A0, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x0406, 0x0407,
	0x0408, 0x0409, 0x040A, 0x040B, 0x040C, 0x00AD, 0x040E, 0x040F,
	0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
	0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F,
	0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
	0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F,
	0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
	0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F,
	0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
	0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F,
	0x2116, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457,
	0x0458, 0x0459, 0x045A, 0x045B, 0x045C, 0x00A7, 0x045E, 0x045F
};

static const struct cw ucs2iso[] = {
	{0xA0, 0x00A0}, {0xFD, 0x00A7}, {0xAD, 0x00AD}, {0xA1, 0x0401},
	{0xA2, 0x0402}, {0xA3, 0x0403}, {0xA4, 0x0404}, {0xA5, 0x0405},
	{0xA6, 0x0406}, {0xA7, 0x0407}, {0xA8, 0x0408}, {0xA9, 0x0409},
	{0xAA, 0x040A}, {0xAB, 0x040B}, {0xAC, 0x040C}, {0xAE, 0x040E},
	{0xAF, 0x040F}, {0xB0, 0x0410}, {0xB1, 0x0411}, {0xB2, 0x0412},
	{0xB3, 0x0413}, {0xB4, 0x0414}, {0xB5, 0x0415}, {0xB6, 0x0416},
	{0xB7, 0x0417}, {0xB8, 0x0418}, {0xB9, 0x0419}, {0xBA, 0x041A},
	{0xBB, 0x041B}, {0xBC, 0x041C}, {0xBD, 0x041D}, {0xBE, 0x041E},
	{0xBF, 0x041F}, {0xC0, 0x0420}, {0xC1, 0x0421}, {0xC2, 0x0422},
	{0xC3, 0x0423}, {0xC4, 0x0424}, {0xC5, 0x0425}, {0xC6, 0x0426},
	{0xC7, 0x0427}, {0xC8, 0x0428}, {0xC9, 0x0429}, {0xCA, 0x042A},
	{0xCB, 0x042B}, {0xCC, 0x042C}, {0xCD, 0x042D}, {0xCE, 0x042E},
	{0xCF, 0x042F}, {0xD0, 0x0430}, {0xD1, 0x0431}, {0xD2, 0x0432},
	{0xD3, 0x0433}, {0xD4, 0x0434}, {0xD5, 0x0435}, {0xD6, 0x0436},
	{0xD7, 0x0437}, {0xD8, 0x0438}, {0xD9, 0x0439}, {0xDA, 0x043A},
	{0xDB, 0x043B}, {0xDC, 0x043C}, {0xDD, 0x043D}, {0xDE, 0x043E},
	{0xDF, 0x043F}, {0xE0, 0x0440}, {0xE1, 0x0441}, {0xE2, 0x0442},
	{0xE3, 0x0443}, {0xE4, 0x0444}, {0xE5, 0x0445}, {0xE6, 0x0446},
	{0xE7, 0x0447}, {0xE8, 0x0448}, {0xE9, 0x0449}, {0xEA, 0x044A},
	{0xEB, 0x044B}, {0xEC, 0x044C}, {0xED, 0x044D}, {0xEE, 0x044E},
	{0xEF, 0x044F}, {0xF1, 0x0451}, {0xF2, 0x0452}, {0xF3, 0x0453},
	{0xF4, 0x0454}, {0xF5, 0x0455}, {0xF6, 0x0456}, {0xF7, 0x0457},
	{0xF8, 0x0458}, {0xF9, 0x0459}, {0xFA, 0x045A}, {0xFB, 0x045B},
	{0xFC, 0x045C}, {0xFE, 0x045E}, {0xFF, 0x045F}, {0xF0, 0x2116}
};


codecvt_base::result iso5cvt::do_in(mbstate_t&, const char* from,
  const char* from_end, const char*& from_next, wchar_t* to,
  wchar_t* to_limit, wchar_t*& to_next) const
{
	return ::do_in(from, from_end, from_next, to, to_limit, to_next, 0xA0,
	  iso2ucs) ? codecvt_base::error : codecvt_base::ok;
}

codecvt_base::result iso5cvt::do_out(mbstate_t&, const wchar_t* from,
  const wchar_t* from_end, const wchar_t*& from_next, char* to,
  char* to_limit, char*& to_next) const
{
	return ::do_out(from, from_end, from_next, to, to_limit, to_next, 0xA0,
	  ucs2iso, sizeof(ucs2iso)) ? codecvt_base::error : codecvt_base::ok;
}

codecvt_base::result iso5cvt::do_unshift(mbstate_t&, char* to, char*,
  char*& to_next) const
{
	to_next = to;

	return codecvt_base::noconv;
}
