# This file is part of the desktop management solution opsi http://www.opsi.org
# Copyright (c) 2023-2024 uib GmbH <info@uib.de>
# This code is owned by the uib GmbH, Mainz, Germany (uib.de). All rights reserved.
# License: AGPL-3.0

from __future__ import annotations

from typing import TYPE_CHECKING

from opsicommon.logging import get_logger

from opsiagent.plugin import OpsiAgentPlugin

if TYPE_CHECKING:
	pass

logger = get_logger("opsiagent.plugin.opsi_bootimage")
logger.context_name = "opsi_bootimage"


class OpsiBootimagePlugin(OpsiAgentPlugin):
	id = "opsi_bootimage"
	name = "opsi bootimage"
	version = "0.1"

	def on_load(self) -> None:
		"""Called after loading the plugin"""
		logger.devel("opsi-bootimage on_load")

	def on_unload(self) -> None:
		"""Called before unloading the plugin"""
		logger.devel("opsi-bootimage on_unload")
