# AUTOGENERATED FROM _localdev postgres instance WITH
#    $ edb gen-sql-introspection

"""Declarations of information schema and pg_catalog"""


ColumnName = str
ColumnType = str | None

INFORMATION_SCHEMA: dict[str, list[tuple[ColumnName, ColumnType, int]]] = {
    "administrable_role_authorizations": [
        ("grantee", "sql_identifier", 13),
        ("role_name", "sql_identifier", 13),
        ("is_grantable", "yes_or_no", 13),
    ],
    "applicable_roles": [
        ("grantee", "sql_identifier", 13),
        ("role_name", "sql_identifier", 13),
        ("is_grantable", "yes_or_no", 13),
    ],
    "attributes": [
        ("udt_catalog", "sql_identifier", 13),
        ("udt_schema", "sql_identifier", 13),
        ("udt_name", "sql_identifier", 13),
        ("attribute_name", "sql_identifier", 13),
        ("ordinal_position", "cardinal_number", 13),
        ("attribute_default", "character_data", 13),
        ("is_nullable", "yes_or_no", 13),
        ("data_type", "character_data", 13),
        ("character_maximum_length", "cardinal_number", 13),
        ("character_octet_length", "cardinal_number", 13),
        ("character_set_catalog", "sql_identifier", 13),
        ("character_set_schema", "sql_identifier", 13),
        ("character_set_name", "sql_identifier", 13),
        ("collation_catalog", "sql_identifier", 13),
        ("collation_schema", "sql_identifier", 13),
        ("collation_name", "sql_identifier", 13),
        ("numeric_precision", "cardinal_number", 13),
        ("numeric_precision_radix", "cardinal_number", 13),
        ("numeric_scale", "cardinal_number", 13),
        ("datetime_precision", "cardinal_number", 13),
        ("interval_type", "character_data", 13),
        ("interval_precision", "cardinal_number", 13),
        ("attribute_udt_catalog", "sql_identifier", 13),
        ("attribute_udt_schema", "sql_identifier", 13),
        ("attribute_udt_name", "sql_identifier", 13),
        ("scope_catalog", "sql_identifier", 13),
        ("scope_schema", "sql_identifier", 13),
        ("scope_name", "sql_identifier", 13),
        ("maximum_cardinality", "cardinal_number", 13),
        ("dtd_identifier", "sql_identifier", 13),
        ("is_derived_reference_attribute", "yes_or_no", 13),
    ],
    "character_sets": [
        ("character_set_catalog", "sql_identifier", 13),
        ("character_set_schema", "sql_identifier", 13),
        ("character_set_name", "sql_identifier", 13),
        ("character_repertoire", "sql_identifier", 13),
        ("form_of_use", "sql_identifier", 13),
        ("default_collate_catalog", "sql_identifier", 13),
        ("default_collate_schema", "sql_identifier", 13),
        ("default_collate_name", "sql_identifier", 13),
    ],
    "check_constraint_routine_usage": [
        ("constraint_catalog", "sql_identifier", 13),
        ("constraint_schema", "sql_identifier", 13),
        ("constraint_name", "sql_identifier", 13),
        ("specific_catalog", "sql_identifier", 13),
        ("specific_schema", "sql_identifier", 13),
        ("specific_name", "sql_identifier", 13),
    ],
    "check_constraints": [
        ("constraint_catalog", "sql_identifier", 13),
        ("constraint_schema", "sql_identifier", 13),
        ("constraint_name", "sql_identifier", 13),
        ("check_clause", "character_data", 13),
    ],
    "collation_character_set_applicability": [
        ("collation_catalog", "sql_identifier", 13),
        ("collation_schema", "sql_identifier", 13),
        ("collation_name", "sql_identifier", 13),
        ("character_set_catalog", "sql_identifier", 13),
        ("character_set_schema", "sql_identifier", 13),
        ("character_set_name", "sql_identifier", 13),
    ],
    "collations": [
        ("collation_catalog", "sql_identifier", 13),
        ("collation_schema", "sql_identifier", 13),
        ("collation_name", "sql_identifier", 13),
        ("pad_attribute", "character_data", 13),
    ],
    "column_column_usage": [
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("column_name", "sql_identifier", 13),
        ("dependent_column", "sql_identifier", 13),
    ],
    "column_domain_usage": [
        ("domain_catalog", "sql_identifier", 13),
        ("domain_schema", "sql_identifier", 13),
        ("domain_name", "sql_identifier", 13),
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("column_name", "sql_identifier", 13),
    ],
    "column_options": [
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("column_name", "sql_identifier", 13),
        ("option_name", "sql_identifier", 13),
        ("option_value", "character_data", 13),
    ],
    "column_privileges": [
        ("grantor", "sql_identifier", 13),
        ("grantee", "sql_identifier", 13),
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("column_name", "sql_identifier", 13),
        ("privilege_type", "character_data", 13),
        ("is_grantable", "yes_or_no", 13),
    ],
    "column_udt_usage": [
        ("udt_catalog", "sql_identifier", 13),
        ("udt_schema", "sql_identifier", 13),
        ("udt_name", "sql_identifier", 13),
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("column_name", "sql_identifier", 13),
    ],
    "columns": [
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("column_name", "sql_identifier", 13),
        ("ordinal_position", "cardinal_number", 13),
        ("column_default", "character_data", 13),
        ("is_nullable", "yes_or_no", 13),
        ("data_type", "character_data", 13),
        ("character_maximum_length", "cardinal_number", 13),
        ("character_octet_length", "cardinal_number", 13),
        ("numeric_precision", "cardinal_number", 13),
        ("numeric_precision_radix", "cardinal_number", 13),
        ("numeric_scale", "cardinal_number", 13),
        ("datetime_precision", "cardinal_number", 13),
        ("interval_type", "character_data", 13),
        ("interval_precision", "cardinal_number", 13),
        ("character_set_catalog", "sql_identifier", 13),
        ("character_set_schema", "sql_identifier", 13),
        ("character_set_name", "sql_identifier", 13),
        ("collation_catalog", "sql_identifier", 13),
        ("collation_schema", "sql_identifier", 13),
        ("collation_name", "sql_identifier", 13),
        ("domain_catalog", "sql_identifier", 13),
        ("domain_schema", "sql_identifier", 13),
        ("domain_name", "sql_identifier", 13),
        ("udt_catalog", "sql_identifier", 13),
        ("udt_schema", "sql_identifier", 13),
        ("udt_name", "sql_identifier", 13),
        ("scope_catalog", "sql_identifier", 13),
        ("scope_schema", "sql_identifier", 13),
        ("scope_name", "sql_identifier", 13),
        ("maximum_cardinality", "cardinal_number", 13),
        ("dtd_identifier", "sql_identifier", 13),
        ("is_self_referencing", "yes_or_no", 13),
        ("is_identity", "yes_or_no", 13),
        ("identity_generation", "character_data", 13),
        ("identity_start", "character_data", 13),
        ("identity_increment", "character_data", 13),
        ("identity_maximum", "character_data", 13),
        ("identity_minimum", "character_data", 13),
        ("identity_cycle", "yes_or_no", 13),
        ("is_generated", "character_data", 13),
        ("generation_expression", "character_data", 13),
        ("is_updatable", "yes_or_no", 13),
    ],
    "constraint_column_usage": [
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("column_name", "sql_identifier", 13),
        ("constraint_catalog", "sql_identifier", 13),
        ("constraint_schema", "sql_identifier", 13),
        ("constraint_name", "sql_identifier", 13),
    ],
    "constraint_table_usage": [
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("constraint_catalog", "sql_identifier", 13),
        ("constraint_schema", "sql_identifier", 13),
        ("constraint_name", "sql_identifier", 13),
    ],
    "data_type_privileges": [
        ("object_catalog", "sql_identifier", 13),
        ("object_schema", "sql_identifier", 13),
        ("object_name", "sql_identifier", 13),
        ("object_type", "character_data", 13),
        ("dtd_identifier", "sql_identifier", 13),
    ],
    "domain_constraints": [
        ("constraint_catalog", "sql_identifier", 13),
        ("constraint_schema", "sql_identifier", 13),
        ("constraint_name", "sql_identifier", 13),
        ("domain_catalog", "sql_identifier", 13),
        ("domain_schema", "sql_identifier", 13),
        ("domain_name", "sql_identifier", 13),
        ("is_deferrable", "yes_or_no", 13),
        ("initially_deferred", "yes_or_no", 13),
    ],
    "domain_udt_usage": [
        ("udt_catalog", "sql_identifier", 13),
        ("udt_schema", "sql_identifier", 13),
        ("udt_name", "sql_identifier", 13),
        ("domain_catalog", "sql_identifier", 13),
        ("domain_schema", "sql_identifier", 13),
        ("domain_name", "sql_identifier", 13),
    ],
    "domains": [
        ("domain_catalog", "sql_identifier", 13),
        ("domain_schema", "sql_identifier", 13),
        ("domain_name", "sql_identifier", 13),
        ("data_type", "character_data", 13),
        ("character_maximum_length", "cardinal_number", 13),
        ("character_octet_length", "cardinal_number", 13),
        ("character_set_catalog", "sql_identifier", 13),
        ("character_set_schema", "sql_identifier", 13),
        ("character_set_name", "sql_identifier", 13),
        ("collation_catalog", "sql_identifier", 13),
        ("collation_schema", "sql_identifier", 13),
        ("collation_name", "sql_identifier", 13),
        ("numeric_precision", "cardinal_number", 13),
        ("numeric_precision_radix", "cardinal_number", 13),
        ("numeric_scale", "cardinal_number", 13),
        ("datetime_precision", "cardinal_number", 13),
        ("interval_type", "character_data", 13),
        ("interval_precision", "cardinal_number", 13),
        ("domain_default", "character_data", 13),
        ("udt_catalog", "sql_identifier", 13),
        ("udt_schema", "sql_identifier", 13),
        ("udt_name", "sql_identifier", 13),
        ("scope_catalog", "sql_identifier", 13),
        ("scope_schema", "sql_identifier", 13),
        ("scope_name", "sql_identifier", 13),
        ("maximum_cardinality", "cardinal_number", 13),
        ("dtd_identifier", "sql_identifier", 13),
    ],
    "element_types": [
        ("object_catalog", "sql_identifier", 13),
        ("object_schema", "sql_identifier", 13),
        ("object_name", "sql_identifier", 13),
        ("object_type", "character_data", 13),
        ("collection_type_identifier", "sql_identifier", 13),
        ("data_type", "character_data", 13),
        ("character_maximum_length", "cardinal_number", 13),
        ("character_octet_length", "cardinal_number", 13),
        ("character_set_catalog", "sql_identifier", 13),
        ("character_set_schema", "sql_identifier", 13),
        ("character_set_name", "sql_identifier", 13),
        ("collation_catalog", "sql_identifier", 13),
        ("collation_schema", "sql_identifier", 13),
        ("collation_name", "sql_identifier", 13),
        ("numeric_precision", "cardinal_number", 13),
        ("numeric_precision_radix", "cardinal_number", 13),
        ("numeric_scale", "cardinal_number", 13),
        ("datetime_precision", "cardinal_number", 13),
        ("interval_type", "character_data", 13),
        ("interval_precision", "cardinal_number", 13),
        ("udt_catalog", "sql_identifier", 13),
        ("udt_schema", "sql_identifier", 13),
        ("udt_name", "sql_identifier", 13),
        ("scope_catalog", "sql_identifier", 13),
        ("scope_schema", "sql_identifier", 13),
        ("scope_name", "sql_identifier", 13),
        ("maximum_cardinality", "cardinal_number", 13),
        ("dtd_identifier", "sql_identifier", 13),
    ],
    "enabled_roles": [
        ("role_name", "sql_identifier", 13),
    ],
    "foreign_data_wrapper_options": [
        ("foreign_data_wrapper_catalog", "sql_identifier", 13),
        ("foreign_data_wrapper_name", "sql_identifier", 13),
        ("option_name", "sql_identifier", 13),
        ("option_value", "character_data", 13),
    ],
    "foreign_data_wrappers": [
        ("foreign_data_wrapper_catalog", "sql_identifier", 13),
        ("foreign_data_wrapper_name", "sql_identifier", 13),
        ("authorization_identifier", "sql_identifier", 13),
        ("library_name", "character_data", 13),
        ("foreign_data_wrapper_language", "character_data", 13),
    ],
    "foreign_server_options": [
        ("foreign_server_catalog", "sql_identifier", 13),
        ("foreign_server_name", "sql_identifier", 13),
        ("option_name", "sql_identifier", 13),
        ("option_value", "character_data", 13),
    ],
    "foreign_servers": [
        ("foreign_server_catalog", "sql_identifier", 13),
        ("foreign_server_name", "sql_identifier", 13),
        ("foreign_data_wrapper_catalog", "sql_identifier", 13),
        ("foreign_data_wrapper_name", "sql_identifier", 13),
        ("foreign_server_type", "character_data", 13),
        ("foreign_server_version", "character_data", 13),
        ("authorization_identifier", "sql_identifier", 13),
    ],
    "foreign_table_options": [
        ("foreign_table_catalog", "sql_identifier", 13),
        ("foreign_table_schema", "sql_identifier", 13),
        ("foreign_table_name", "sql_identifier", 13),
        ("option_name", "sql_identifier", 13),
        ("option_value", "character_data", 13),
    ],
    "foreign_tables": [
        ("foreign_table_catalog", "sql_identifier", 13),
        ("foreign_table_schema", "sql_identifier", 13),
        ("foreign_table_name", "sql_identifier", 13),
        ("foreign_server_catalog", "sql_identifier", 13),
        ("foreign_server_name", "sql_identifier", 13),
    ],
    "information_schema_catalog_name": [
        ("catalog_name", "sql_identifier", 13),
    ],
    "key_column_usage": [
        ("constraint_catalog", "sql_identifier", 13),
        ("constraint_schema", "sql_identifier", 13),
        ("constraint_name", "sql_identifier", 13),
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("column_name", "sql_identifier", 13),
        ("ordinal_position", "cardinal_number", 13),
        ("position_in_unique_constraint", "cardinal_number", 13),
    ],
    "parameters": [
        ("specific_catalog", "sql_identifier", 13),
        ("specific_schema", "sql_identifier", 13),
        ("specific_name", "sql_identifier", 13),
        ("ordinal_position", "cardinal_number", 13),
        ("parameter_mode", "character_data", 13),
        ("is_result", "yes_or_no", 13),
        ("as_locator", "yes_or_no", 13),
        ("parameter_name", "sql_identifier", 13),
        ("data_type", "character_data", 13),
        ("character_maximum_length", "cardinal_number", 13),
        ("character_octet_length", "cardinal_number", 13),
        ("character_set_catalog", "sql_identifier", 13),
        ("character_set_schema", "sql_identifier", 13),
        ("character_set_name", "sql_identifier", 13),
        ("collation_catalog", "sql_identifier", 13),
        ("collation_schema", "sql_identifier", 13),
        ("collation_name", "sql_identifier", 13),
        ("numeric_precision", "cardinal_number", 13),
        ("numeric_precision_radix", "cardinal_number", 13),
        ("numeric_scale", "cardinal_number", 13),
        ("datetime_precision", "cardinal_number", 13),
        ("interval_type", "character_data", 13),
        ("interval_precision", "cardinal_number", 13),
        ("udt_catalog", "sql_identifier", 13),
        ("udt_schema", "sql_identifier", 13),
        ("udt_name", "sql_identifier", 13),
        ("scope_catalog", "sql_identifier", 13),
        ("scope_schema", "sql_identifier", 13),
        ("scope_name", "sql_identifier", 13),
        ("maximum_cardinality", "cardinal_number", 13),
        ("dtd_identifier", "sql_identifier", 13),
        ("parameter_default", "character_data", 13),
    ],
    "referential_constraints": [
        ("constraint_catalog", "sql_identifier", 13),
        ("constraint_schema", "sql_identifier", 13),
        ("constraint_name", "sql_identifier", 13),
        ("unique_constraint_catalog", "sql_identifier", 13),
        ("unique_constraint_schema", "sql_identifier", 13),
        ("unique_constraint_name", "sql_identifier", 13),
        ("match_option", "character_data", 13),
        ("update_rule", "character_data", 13),
        ("delete_rule", "character_data", 13),
    ],
    "role_column_grants": [
        ("grantor", "sql_identifier", 13),
        ("grantee", "sql_identifier", 13),
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("column_name", "sql_identifier", 13),
        ("privilege_type", "character_data", 13),
        ("is_grantable", "yes_or_no", 13),
    ],
    "role_routine_grants": [
        ("grantor", "sql_identifier", 13),
        ("grantee", "sql_identifier", 13),
        ("specific_catalog", "sql_identifier", 13),
        ("specific_schema", "sql_identifier", 13),
        ("specific_name", "sql_identifier", 13),
        ("routine_catalog", "sql_identifier", 13),
        ("routine_schema", "sql_identifier", 13),
        ("routine_name", "sql_identifier", 13),
        ("privilege_type", "character_data", 13),
        ("is_grantable", "yes_or_no", 13),
    ],
    "role_table_grants": [
        ("grantor", "sql_identifier", 13),
        ("grantee", "sql_identifier", 13),
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("privilege_type", "character_data", 13),
        ("is_grantable", "yes_or_no", 13),
        ("with_hierarchy", "yes_or_no", 13),
    ],
    "role_udt_grants": [
        ("grantor", "sql_identifier", 13),
        ("grantee", "sql_identifier", 13),
        ("udt_catalog", "sql_identifier", 13),
        ("udt_schema", "sql_identifier", 13),
        ("udt_name", "sql_identifier", 13),
        ("privilege_type", "character_data", 13),
        ("is_grantable", "yes_or_no", 13),
    ],
    "role_usage_grants": [
        ("grantor", "sql_identifier", 13),
        ("grantee", "sql_identifier", 13),
        ("object_catalog", "sql_identifier", 13),
        ("object_schema", "sql_identifier", 13),
        ("object_name", "sql_identifier", 13),
        ("object_type", "character_data", 13),
        ("privilege_type", "character_data", 13),
        ("is_grantable", "yes_or_no", 13),
    ],
    "routine_column_usage": [
        ("specific_catalog", "sql_identifier", 14),
        ("specific_schema", "sql_identifier", 14),
        ("specific_name", "sql_identifier", 14),
        ("routine_catalog", "sql_identifier", 14),
        ("routine_schema", "sql_identifier", 14),
        ("routine_name", "sql_identifier", 14),
        ("table_catalog", "sql_identifier", 14),
        ("table_schema", "sql_identifier", 14),
        ("table_name", "sql_identifier", 14),
        ("column_name", "sql_identifier", 14),
    ],
    "routine_privileges": [
        ("grantor", "sql_identifier", 13),
        ("grantee", "sql_identifier", 13),
        ("specific_catalog", "sql_identifier", 13),
        ("specific_schema", "sql_identifier", 13),
        ("specific_name", "sql_identifier", 13),
        ("routine_catalog", "sql_identifier", 13),
        ("routine_schema", "sql_identifier", 13),
        ("routine_name", "sql_identifier", 13),
        ("privilege_type", "character_data", 13),
        ("is_grantable", "yes_or_no", 13),
    ],
    "routine_routine_usage": [
        ("specific_catalog", "sql_identifier", 14),
        ("specific_schema", "sql_identifier", 14),
        ("specific_name", "sql_identifier", 14),
        ("routine_catalog", "sql_identifier", 14),
        ("routine_schema", "sql_identifier", 14),
        ("routine_name", "sql_identifier", 14),
    ],
    "routine_sequence_usage": [
        ("specific_catalog", "sql_identifier", 14),
        ("specific_schema", "sql_identifier", 14),
        ("specific_name", "sql_identifier", 14),
        ("routine_catalog", "sql_identifier", 14),
        ("routine_schema", "sql_identifier", 14),
        ("routine_name", "sql_identifier", 14),
        ("sequence_catalog", "sql_identifier", 14),
        ("sequence_schema", "sql_identifier", 14),
        ("sequence_name", "sql_identifier", 14),
    ],
    "routine_table_usage": [
        ("specific_catalog", "sql_identifier", 14),
        ("specific_schema", "sql_identifier", 14),
        ("specific_name", "sql_identifier", 14),
        ("routine_catalog", "sql_identifier", 14),
        ("routine_schema", "sql_identifier", 14),
        ("routine_name", "sql_identifier", 14),
        ("table_catalog", "sql_identifier", 14),
        ("table_schema", "sql_identifier", 14),
        ("table_name", "sql_identifier", 14),
    ],
    "routines": [
        ("specific_catalog", "sql_identifier", 13),
        ("specific_schema", "sql_identifier", 13),
        ("specific_name", "sql_identifier", 13),
        ("routine_catalog", "sql_identifier", 13),
        ("routine_schema", "sql_identifier", 13),
        ("routine_name", "sql_identifier", 13),
        ("routine_type", "character_data", 13),
        ("module_catalog", "sql_identifier", 13),
        ("module_schema", "sql_identifier", 13),
        ("module_name", "sql_identifier", 13),
        ("udt_catalog", "sql_identifier", 13),
        ("udt_schema", "sql_identifier", 13),
        ("udt_name", "sql_identifier", 13),
        ("data_type", "character_data", 13),
        ("character_maximum_length", "cardinal_number", 13),
        ("character_octet_length", "cardinal_number", 13),
        ("character_set_catalog", "sql_identifier", 13),
        ("character_set_schema", "sql_identifier", 13),
        ("character_set_name", "sql_identifier", 13),
        ("collation_catalog", "sql_identifier", 13),
        ("collation_schema", "sql_identifier", 13),
        ("collation_name", "sql_identifier", 13),
        ("numeric_precision", "cardinal_number", 13),
        ("numeric_precision_radix", "cardinal_number", 13),
        ("numeric_scale", "cardinal_number", 13),
        ("datetime_precision", "cardinal_number", 13),
        ("interval_type", "character_data", 13),
        ("interval_precision", "cardinal_number", 13),
        ("type_udt_catalog", "sql_identifier", 13),
        ("type_udt_schema", "sql_identifier", 13),
        ("type_udt_name", "sql_identifier", 13),
        ("scope_catalog", "sql_identifier", 13),
        ("scope_schema", "sql_identifier", 13),
        ("scope_name", "sql_identifier", 13),
        ("maximum_cardinality", "cardinal_number", 13),
        ("dtd_identifier", "sql_identifier", 13),
        ("routine_body", "character_data", 13),
        ("routine_definition", "character_data", 13),
        ("external_name", "character_data", 13),
        ("external_language", "character_data", 13),
        ("parameter_style", "character_data", 13),
        ("is_deterministic", "yes_or_no", 13),
        ("sql_data_access", "character_data", 13),
        ("is_null_call", "yes_or_no", 13),
        ("sql_path", "character_data", 13),
        ("schema_level_routine", "yes_or_no", 13),
        ("max_dynamic_result_sets", "cardinal_number", 13),
        ("is_user_defined_cast", "yes_or_no", 13),
        ("is_implicitly_invocable", "yes_or_no", 13),
        ("security_type", "character_data", 13),
        ("to_sql_specific_catalog", "sql_identifier", 13),
        ("to_sql_specific_schema", "sql_identifier", 13),
        ("to_sql_specific_name", "sql_identifier", 13),
        ("as_locator", "yes_or_no", 13),
        ("created", "time_stamp", 13),
        ("last_altered", "time_stamp", 13),
        ("new_savepoint_level", "yes_or_no", 13),
        ("is_udt_dependent", "yes_or_no", 13),
        ("result_cast_from_data_type", "character_data", 13),
        ("result_cast_as_locator", "yes_or_no", 13),
        ("result_cast_char_max_length", "cardinal_number", 13),
        ("result_cast_char_octet_length", "cardinal_number", 13),
        ("result_cast_char_set_catalog", "sql_identifier", 13),
        ("result_cast_char_set_schema", "sql_identifier", 13),
        ("result_cast_char_set_name", "sql_identifier", 13),
        ("result_cast_collation_catalog", "sql_identifier", 13),
        ("result_cast_collation_schema", "sql_identifier", 13),
        ("result_cast_collation_name", "sql_identifier", 13),
        ("result_cast_numeric_precision", "cardinal_number", 13),
        ("result_cast_numeric_precision_radix", "cardinal_number", 13),
        ("result_cast_numeric_scale", "cardinal_number", 13),
        ("result_cast_datetime_precision", "cardinal_number", 13),
        ("result_cast_interval_type", "character_data", 13),
        ("result_cast_interval_precision", "cardinal_number", 13),
        ("result_cast_type_udt_catalog", "sql_identifier", 13),
        ("result_cast_type_udt_schema", "sql_identifier", 13),
        ("result_cast_type_udt_name", "sql_identifier", 13),
        ("result_cast_scope_catalog", "sql_identifier", 13),
        ("result_cast_scope_schema", "sql_identifier", 13),
        ("result_cast_scope_name", "sql_identifier", 13),
        ("result_cast_maximum_cardinality", "cardinal_number", 13),
        ("result_cast_dtd_identifier", "sql_identifier", 13),
    ],
    "schemata": [
        ("catalog_name", "sql_identifier", 13),
        ("schema_name", "sql_identifier", 13),
        ("schema_owner", "sql_identifier", 13),
        ("default_character_set_catalog", "sql_identifier", 13),
        ("default_character_set_schema", "sql_identifier", 13),
        ("default_character_set_name", "sql_identifier", 13),
        ("sql_path", "character_data", 13),
    ],
    "sequences": [
        ("sequence_catalog", "sql_identifier", 13),
        ("sequence_schema", "sql_identifier", 13),
        ("sequence_name", "sql_identifier", 13),
        ("data_type", "character_data", 13),
        ("numeric_precision", "cardinal_number", 13),
        ("numeric_precision_radix", "cardinal_number", 13),
        ("numeric_scale", "cardinal_number", 13),
        ("start_value", "character_data", 13),
        ("minimum_value", "character_data", 13),
        ("maximum_value", "character_data", 13),
        ("increment", "character_data", 13),
        ("cycle_option", "yes_or_no", 13),
    ],
    "sql_features": [
        ("feature_id", "character_data", 13),
        ("feature_name", "character_data", 13),
        ("sub_feature_id", "character_data", 13),
        ("sub_feature_name", "character_data", 13),
        ("is_supported", "yes_or_no", 13),
        ("is_verified_by", "character_data", 13),
        ("comments", "character_data", 13),
    ],
    "sql_implementation_info": [
        ("implementation_info_id", "character_data", 13),
        ("implementation_info_name", "character_data", 13),
        ("integer_value", "cardinal_number", 13),
        ("character_value", "character_data", 13),
        ("comments", "character_data", 13),
    ],
    "sql_parts": [
        ("feature_id", "character_data", 13),
        ("feature_name", "character_data", 13),
        ("is_supported", "yes_or_no", 13),
        ("is_verified_by", "character_data", 13),
        ("comments", "character_data", 13),
    ],
    "sql_sizing": [
        ("sizing_id", "cardinal_number", 13),
        ("sizing_name", "character_data", 13),
        ("supported_value", "cardinal_number", 13),
        ("comments", "character_data", 13),
    ],
    "table_constraints": [
        ("constraint_catalog", "sql_identifier", 13),
        ("constraint_schema", "sql_identifier", 13),
        ("constraint_name", "sql_identifier", 13),
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("constraint_type", "character_data", 13),
        ("is_deferrable", "yes_or_no", 13),
        ("initially_deferred", "yes_or_no", 13),
        ("enforced", "yes_or_no", 13),
        ("nulls_distinct", "yes_or_no", 15),
    ],
    "table_privileges": [
        ("grantor", "sql_identifier", 13),
        ("grantee", "sql_identifier", 13),
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("privilege_type", "character_data", 13),
        ("is_grantable", "yes_or_no", 13),
        ("with_hierarchy", "yes_or_no", 13),
    ],
    "tables": [
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("table_type", "character_data", 13),
        ("self_referencing_column_name", "sql_identifier", 13),
        ("reference_generation", "character_data", 13),
        ("user_defined_type_catalog", "sql_identifier", 13),
        ("user_defined_type_schema", "sql_identifier", 13),
        ("user_defined_type_name", "sql_identifier", 13),
        ("is_insertable_into", "yes_or_no", 13),
        ("is_typed", "yes_or_no", 13),
        ("commit_action", "character_data", 13),
    ],
    "transforms": [
        ("udt_catalog", "sql_identifier", 13),
        ("udt_schema", "sql_identifier", 13),
        ("udt_name", "sql_identifier", 13),
        ("specific_catalog", "sql_identifier", 13),
        ("specific_schema", "sql_identifier", 13),
        ("specific_name", "sql_identifier", 13),
        ("group_name", "sql_identifier", 13),
        ("transform_type", "character_data", 13),
    ],
    "triggered_update_columns": [
        ("trigger_catalog", "sql_identifier", 13),
        ("trigger_schema", "sql_identifier", 13),
        ("trigger_name", "sql_identifier", 13),
        ("event_object_catalog", "sql_identifier", 13),
        ("event_object_schema", "sql_identifier", 13),
        ("event_object_table", "sql_identifier", 13),
        ("event_object_column", "sql_identifier", 13),
    ],
    "triggers": [
        ("trigger_catalog", "sql_identifier", 13),
        ("trigger_schema", "sql_identifier", 13),
        ("trigger_name", "sql_identifier", 13),
        ("event_manipulation", "character_data", 13),
        ("event_object_catalog", "sql_identifier", 13),
        ("event_object_schema", "sql_identifier", 13),
        ("event_object_table", "sql_identifier", 13),
        ("action_order", "cardinal_number", 13),
        ("action_condition", "character_data", 13),
        ("action_statement", "character_data", 13),
        ("action_orientation", "character_data", 13),
        ("action_timing", "character_data", 13),
        ("action_reference_old_table", "sql_identifier", 13),
        ("action_reference_new_table", "sql_identifier", 13),
        ("action_reference_old_row", "sql_identifier", 13),
        ("action_reference_new_row", "sql_identifier", 13),
        ("created", "time_stamp", 13),
    ],
    "udt_privileges": [
        ("grantor", "sql_identifier", 13),
        ("grantee", "sql_identifier", 13),
        ("udt_catalog", "sql_identifier", 13),
        ("udt_schema", "sql_identifier", 13),
        ("udt_name", "sql_identifier", 13),
        ("privilege_type", "character_data", 13),
        ("is_grantable", "yes_or_no", 13),
    ],
    "usage_privileges": [
        ("grantor", "sql_identifier", 13),
        ("grantee", "sql_identifier", 13),
        ("object_catalog", "sql_identifier", 13),
        ("object_schema", "sql_identifier", 13),
        ("object_name", "sql_identifier", 13),
        ("object_type", "character_data", 13),
        ("privilege_type", "character_data", 13),
        ("is_grantable", "yes_or_no", 13),
    ],
    "user_defined_types": [
        ("user_defined_type_catalog", "sql_identifier", 13),
        ("user_defined_type_schema", "sql_identifier", 13),
        ("user_defined_type_name", "sql_identifier", 13),
        ("user_defined_type_category", "character_data", 13),
        ("is_instantiable", "yes_or_no", 13),
        ("is_final", "yes_or_no", 13),
        ("ordering_form", "character_data", 13),
        ("ordering_category", "character_data", 13),
        ("ordering_routine_catalog", "sql_identifier", 13),
        ("ordering_routine_schema", "sql_identifier", 13),
        ("ordering_routine_name", "sql_identifier", 13),
        ("reference_type", "character_data", 13),
        ("data_type", "character_data", 13),
        ("character_maximum_length", "cardinal_number", 13),
        ("character_octet_length", "cardinal_number", 13),
        ("character_set_catalog", "sql_identifier", 13),
        ("character_set_schema", "sql_identifier", 13),
        ("character_set_name", "sql_identifier", 13),
        ("collation_catalog", "sql_identifier", 13),
        ("collation_schema", "sql_identifier", 13),
        ("collation_name", "sql_identifier", 13),
        ("numeric_precision", "cardinal_number", 13),
        ("numeric_precision_radix", "cardinal_number", 13),
        ("numeric_scale", "cardinal_number", 13),
        ("datetime_precision", "cardinal_number", 13),
        ("interval_type", "character_data", 13),
        ("interval_precision", "cardinal_number", 13),
        ("source_dtd_identifier", "sql_identifier", 13),
        ("ref_dtd_identifier", "sql_identifier", 13),
    ],
    "user_mapping_options": [
        ("authorization_identifier", "sql_identifier", 13),
        ("foreign_server_catalog", "sql_identifier", 13),
        ("foreign_server_name", "sql_identifier", 13),
        ("option_name", "sql_identifier", 13),
        ("option_value", "character_data", 13),
    ],
    "user_mappings": [
        ("authorization_identifier", "sql_identifier", 13),
        ("foreign_server_catalog", "sql_identifier", 13),
        ("foreign_server_name", "sql_identifier", 13),
    ],
    "view_column_usage": [
        ("view_catalog", "sql_identifier", 13),
        ("view_schema", "sql_identifier", 13),
        ("view_name", "sql_identifier", 13),
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("column_name", "sql_identifier", 13),
    ],
    "view_routine_usage": [
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("specific_catalog", "sql_identifier", 13),
        ("specific_schema", "sql_identifier", 13),
        ("specific_name", "sql_identifier", 13),
    ],
    "view_table_usage": [
        ("view_catalog", "sql_identifier", 13),
        ("view_schema", "sql_identifier", 13),
        ("view_name", "sql_identifier", 13),
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
    ],
    "views": [
        ("table_catalog", "sql_identifier", 13),
        ("table_schema", "sql_identifier", 13),
        ("table_name", "sql_identifier", 13),
        ("view_definition", "character_data", 13),
        ("check_option", "character_data", 13),
        ("is_updatable", "yes_or_no", 13),
        ("is_insertable_into", "yes_or_no", 13),
        ("is_trigger_updatable", "yes_or_no", 13),
        ("is_trigger_deletable", "yes_or_no", 13),
        ("is_trigger_insertable_into", "yes_or_no", 13),
    ]
}
PG_CATALOG: dict[str, list[tuple[ColumnName, ColumnType, int]]] = {
    "pg_aggregate": [
        ("aggfnoid", "regproc", 13),
        ("aggkind", "\"char\"", 13),
        ("aggnumdirectargs", "smallint", 13),
        ("aggtransfn", "regproc", 13),
        ("aggfinalfn", "regproc", 13),
        ("aggcombinefn", "regproc", 13),
        ("aggserialfn", "regproc", 13),
        ("aggdeserialfn", "regproc", 13),
        ("aggmtransfn", "regproc", 13),
        ("aggminvtransfn", "regproc", 13),
        ("aggmfinalfn", "regproc", 13),
        ("aggfinalextra", "boolean", 13),
        ("aggmfinalextra", "boolean", 13),
        ("aggfinalmodify", "\"char\"", 13),
        ("aggmfinalmodify", "\"char\"", 13),
        ("aggsortop", "oid", 13),
        ("aggtranstype", "oid", 13),
        ("aggtransspace", "integer", 13),
        ("aggmtranstype", "oid", 13),
        ("aggmtransspace", "integer", 13),
        ("agginitval", "text", 13),
        ("aggminitval", "text", 13),
    ],
    "pg_am": [
        ("oid", "oid", 13),
        ("amname", "name", 13),
        ("amhandler", "regproc", 13),
        ("amtype", "\"char\"", 13),
    ],
    "pg_amop": [
        ("oid", "oid", 13),
        ("amopfamily", "oid", 13),
        ("amoplefttype", "oid", 13),
        ("amoprighttype", "oid", 13),
        ("amopstrategy", "smallint", 13),
        ("amoppurpose", "\"char\"", 13),
        ("amopopr", "oid", 13),
        ("amopmethod", "oid", 13),
        ("amopsortfamily", "oid", 13),
    ],
    "pg_amproc": [
        ("oid", "oid", 13),
        ("amprocfamily", "oid", 13),
        ("amproclefttype", "oid", 13),
        ("amprocrighttype", "oid", 13),
        ("amprocnum", "smallint", 13),
        ("amproc", "regproc", 13),
    ],
    "pg_attrdef": [
        ("oid", "oid", 13),
        ("adrelid", "oid", 13),
        ("adnum", "smallint", 13),
        ("adbin", "pg_node_tree", 13),
    ],
    "pg_attribute": [
        ("attrelid", "oid", 13),
        ("attname", "name", 13),
        ("atttypid", "oid", 13),
        ("attlen", "smallint", 13),
        ("attnum", "smallint", 13),
        ("attcacheoff", "integer", 13),
        ("atttypmod", "integer", 13),
        ("attndims", "smallint", 13),
        ("attbyval", "boolean", 13),
        ("attalign", "\"char\"", 13),
        ("attstorage", "\"char\"", 13),
        ("attcompression", "\"char\"", 14),
        ("attnotnull", "boolean", 13),
        ("atthasdef", "boolean", 13),
        ("atthasmissing", "boolean", 13),
        ("attidentity", "\"char\"", 13),
        ("attgenerated", "\"char\"", 13),
        ("attisdropped", "boolean", 13),
        ("attislocal", "boolean", 13),
        ("attinhcount", "smallint", 13),
        ("attcollation", "oid", 13),
        ("attstattarget", "smallint", 13),
        ("attacl", None, 13),
        ("attoptions", None, 13),
        ("attfdwoptions", None, 13),
        ("attmissingval", None, 13),
    ],
    "pg_auth_members": [
        ("oid", "oid", 16),
        ("roleid", "oid", 13),
        ("member", "oid", 13),
        ("grantor", "oid", 13),
        ("admin_option", "boolean", 13),
        ("inherit_option", "boolean", 16),
        ("set_option", "boolean", 16),
    ],
    "pg_authid": [
        ("oid", "oid", 13),
        ("rolname", "name", 13),
        ("rolsuper", "boolean", 13),
        ("rolinherit", "boolean", 13),
        ("rolcreaterole", "boolean", 13),
        ("rolcreatedb", "boolean", 13),
        ("rolcanlogin", "boolean", 13),
        ("rolreplication", "boolean", 13),
        ("rolbypassrls", "boolean", 13),
        ("rolconnlimit", "integer", 13),
        ("rolpassword", "text", 13),
        ("rolvaliduntil", "timestamp with time zone", 13),
    ],
    "pg_available_extension_versions": [
        ("name", "name", 13),
        ("version", "text", 13),
        ("installed", "boolean", 13),
        ("superuser", "boolean", 13),
        ("trusted", "boolean", 13),
        ("relocatable", "boolean", 13),
        ("schema", "name", 13),
        ("requires", None, 13),
        ("comment", "text", 13),
    ],
    "pg_available_extensions": [
        ("name", "name", 13),
        ("default_version", "text", 13),
        ("installed_version", "text", 13),
        ("comment", "text", 13),
    ],
    "pg_backend_memory_contexts": [
        ("name", "text", 14),
        ("ident", "text", 14),
        ("parent", "text", 14),
        ("level", "integer", 14),
        ("total_bytes", "bigint", 14),
        ("total_nblocks", "bigint", 14),
        ("free_bytes", "bigint", 14),
        ("free_chunks", "bigint", 14),
        ("used_bytes", "bigint", 14),
    ],
    "pg_cast": [
        ("oid", "oid", 13),
        ("castsource", "oid", 13),
        ("casttarget", "oid", 13),
        ("castfunc", "oid", 13),
        ("castcontext", "\"char\"", 13),
        ("castmethod", "\"char\"", 13),
    ],
    "pg_class": [
        ("oid", "oid", 13),
        ("relname", "name", 13),
        ("relnamespace", "oid", 13),
        ("reltype", "oid", 13),
        ("reloftype", "oid", 13),
        ("relowner", "oid", 13),
        ("relam", "oid", 13),
        ("relfilenode", "oid", 13),
        ("reltablespace", "oid", 13),
        ("relpages", "integer", 13),
        ("reltuples", "real", 13),
        ("relallvisible", "integer", 13),
        ("reltoastrelid", "oid", 13),
        ("relhasindex", "boolean", 13),
        ("relisshared", "boolean", 13),
        ("relpersistence", "\"char\"", 13),
        ("relkind", "\"char\"", 13),
        ("relnatts", "smallint", 13),
        ("relchecks", "smallint", 13),
        ("relhasrules", "boolean", 13),
        ("relhastriggers", "boolean", 13),
        ("relhassubclass", "boolean", 13),
        ("relrowsecurity", "boolean", 13),
        ("relforcerowsecurity", "boolean", 13),
        ("relispopulated", "boolean", 13),
        ("relreplident", "\"char\"", 13),
        ("relispartition", "boolean", 13),
        ("relrewrite", "oid", 13),
        ("relfrozenxid", "xid", 13),
        ("relminmxid", "xid", 13),
        ("relacl", None, 13),
        ("reloptions", None, 13),
        ("relpartbound", "pg_node_tree", 13),
    ],
    "pg_collation": [
        ("oid", "oid", 13),
        ("collname", "name", 13),
        ("collnamespace", "oid", 13),
        ("collowner", "oid", 13),
        ("collprovider", "\"char\"", 13),
        ("collisdeterministic", "boolean", 13),
        ("collencoding", "integer", 13),
        ("collcollate", "text", 13),
        ("collctype", "text", 13),
        ("colllocale", "text", 17),
        ("collicurules", "text", 16),
        ("collversion", "text", 13),
    ],
    "pg_config": [
        ("name", "text", 13),
        ("setting", "text", 13),
    ],
    "pg_constraint": [
        ("oid", "oid", 13),
        ("conname", "name", 13),
        ("connamespace", "oid", 13),
        ("contype", "\"char\"", 13),
        ("condeferrable", "boolean", 13),
        ("condeferred", "boolean", 13),
        ("convalidated", "boolean", 13),
        ("conrelid", "oid", 13),
        ("contypid", "oid", 13),
        ("conindid", "oid", 13),
        ("conparentid", "oid", 13),
        ("confrelid", "oid", 13),
        ("confupdtype", "\"char\"", 13),
        ("confdeltype", "\"char\"", 13),
        ("confmatchtype", "\"char\"", 13),
        ("conislocal", "boolean", 13),
        ("coninhcount", "smallint", 13),
        ("connoinherit", "boolean", 13),
        ("conkey", None, 13),
        ("confkey", None, 13),
        ("conpfeqop", None, 13),
        ("conppeqop", None, 13),
        ("conffeqop", None, 13),
        ("confdelsetcols", None, 15),
        ("conexclop", None, 13),
        ("conbin", "pg_node_tree", 13),
    ],
    "pg_conversion": [
        ("oid", "oid", 13),
        ("conname", "name", 13),
        ("connamespace", "oid", 13),
        ("conowner", "oid", 13),
        ("conforencoding", "integer", 13),
        ("contoencoding", "integer", 13),
        ("conproc", "regproc", 13),
        ("condefault", "boolean", 13),
    ],
    "pg_cursors": [
        ("name", "text", 13),
        ("statement", "text", 13),
        ("is_holdable", "boolean", 13),
        ("is_binary", "boolean", 13),
        ("is_scrollable", "boolean", 13),
        ("creation_time", "timestamp with time zone", 13),
    ],
    "pg_database": [
        ("oid", "oid", 13),
        ("datname", "name", 13),
        ("datdba", "oid", 13),
        ("encoding", "integer", 13),
        ("datlocprovider", "\"char\"", 15),
        ("datistemplate", "boolean", 13),
        ("datallowconn", "boolean", 13),
        ("dathasloginevt", "boolean", 17),
        ("datconnlimit", "integer", 13),
        ("datfrozenxid", "xid", 13),
        ("datminmxid", "xid", 13),
        ("dattablespace", "oid", 13),
        ("datcollate", "text", 13),
        ("datctype", "text", 13),
        ("datlocale", "text", 17),
        ("daticurules", "text", 16),
        ("datcollversion", "text", 15),
        ("datacl", None, 13),
    ],
    "pg_db_role_setting": [
        ("setdatabase", "oid", 13),
        ("setrole", "oid", 13),
        ("setconfig", None, 13),
    ],
    "pg_default_acl": [
        ("oid", "oid", 13),
        ("defaclrole", "oid", 13),
        ("defaclnamespace", "oid", 13),
        ("defaclobjtype", "\"char\"", 13),
        ("defaclacl", None, 13),
    ],
    "pg_depend": [
        ("classid", "oid", 13),
        ("objid", "oid", 13),
        ("objsubid", "integer", 13),
        ("refclassid", "oid", 13),
        ("refobjid", "oid", 13),
        ("refobjsubid", "integer", 13),
        ("deptype", "\"char\"", 13),
    ],
    "pg_description": [
        ("objoid", "oid", 13),
        ("classoid", "oid", 13),
        ("objsubid", "integer", 13),
        ("description", "text", 13),
    ],
    "pg_enum": [
        ("oid", "oid", 13),
        ("enumtypid", "oid", 13),
        ("enumsortorder", "real", 13),
        ("enumlabel", "name", 13),
    ],
    "pg_event_trigger": [
        ("oid", "oid", 13),
        ("evtname", "name", 13),
        ("evtevent", "name", 13),
        ("evtowner", "oid", 13),
        ("evtfoid", "oid", 13),
        ("evtenabled", "\"char\"", 13),
        ("evttags", None, 13),
    ],
    "pg_extension": [
        ("oid", "oid", 13),
        ("extname", "name", 13),
        ("extowner", "oid", 13),
        ("extnamespace", "oid", 13),
        ("extrelocatable", "boolean", 13),
        ("extversion", "text", 13),
        ("extconfig", None, 13),
        ("extcondition", None, 13),
    ],
    "pg_file_settings": [
        ("sourcefile", "text", 13),
        ("sourceline", "integer", 13),
        ("seqno", "integer", 13),
        ("name", "text", 13),
        ("setting", "text", 13),
        ("applied", "boolean", 13),
        ("error", "text", 13),
    ],
    "pg_foreign_data_wrapper": [
        ("oid", "oid", 13),
        ("fdwname", "name", 13),
        ("fdwowner", "oid", 13),
        ("fdwhandler", "oid", 13),
        ("fdwvalidator", "oid", 13),
        ("fdwacl", None, 13),
        ("fdwoptions", None, 13),
    ],
    "pg_foreign_server": [
        ("oid", "oid", 13),
        ("srvname", "name", 13),
        ("srvowner", "oid", 13),
        ("srvfdw", "oid", 13),
        ("srvtype", "text", 13),
        ("srvversion", "text", 13),
        ("srvacl", None, 13),
        ("srvoptions", None, 13),
    ],
    "pg_foreign_table": [
        ("ftrelid", "oid", 13),
        ("ftserver", "oid", 13),
        ("ftoptions", None, 13),
    ],
    "pg_group": [
        ("groname", "name", 13),
        ("grosysid", "oid", 13),
        ("grolist", None, 13),
    ],
    "pg_hba_file_rules": [
        ("rule_number", "integer", 16),
        ("file_name", "text", 16),
        ("line_number", "integer", 13),
        ("type", "text", 13),
        ("database", None, 13),
        ("user_name", None, 13),
        ("address", "text", 13),
        ("netmask", "text", 13),
        ("auth_method", "text", 13),
        ("options", None, 13),
        ("error", "text", 13),
    ],
    "pg_ident_file_mappings": [
        ("map_number", "integer", 16),
        ("file_name", "text", 16),
        ("line_number", "integer", 15),
        ("map_name", "text", 15),
        ("sys_name", "text", 15),
        ("pg_username", "text", 15),
        ("error", "text", 15),
    ],
    "pg_index": [
        ("indexrelid", "oid", 13),
        ("indrelid", "oid", 13),
        ("indnatts", "smallint", 13),
        ("indnkeyatts", "smallint", 13),
        ("indisunique", "boolean", 13),
        ("indnullsnotdistinct", "boolean", 15),
        ("indisprimary", "boolean", 13),
        ("indisexclusion", "boolean", 13),
        ("indimmediate", "boolean", 13),
        ("indisclustered", "boolean", 13),
        ("indisvalid", "boolean", 13),
        ("indcheckxmin", "boolean", 13),
        ("indisready", "boolean", 13),
        ("indislive", "boolean", 13),
        ("indisreplident", "boolean", 13),
        ("indkey", None, 13),
        ("indcollation", None, 13),
        ("indclass", None, 13),
        ("indoption", None, 13),
        ("indexprs", "pg_node_tree", 13),
        ("indpred", "pg_node_tree", 13),
    ],
    "pg_indexes": [
        ("schemaname", "name", 13),
        ("tablename", "name", 13),
        ("indexname", "name", 13),
        ("tablespace", "name", 13),
        ("indexdef", "text", 13),
    ],
    "pg_inherits": [
        ("inhrelid", "oid", 13),
        ("inhparent", "oid", 13),
        ("inhseqno", "integer", 13),
        ("inhdetachpending", "boolean", 14),
    ],
    "pg_init_privs": [
        ("objoid", "oid", 13),
        ("classoid", "oid", 13),
        ("objsubid", "integer", 13),
        ("privtype", "\"char\"", 13),
        ("initprivs", None, 13),
    ],
    "pg_language": [
        ("oid", "oid", 13),
        ("lanname", "name", 13),
        ("lanowner", "oid", 13),
        ("lanispl", "boolean", 13),
        ("lanpltrusted", "boolean", 13),
        ("lanplcallfoid", "oid", 13),
        ("laninline", "oid", 13),
        ("lanvalidator", "oid", 13),
        ("lanacl", None, 13),
    ],
    "pg_largeobject": [
        ("loid", "oid", 13),
        ("pageno", "integer", 13),
        ("data", "bytea", 13),
    ],
    "pg_largeobject_metadata": [
        ("oid", "oid", 13),
        ("lomowner", "oid", 13),
        ("lomacl", None, 13),
    ],
    "pg_locks": [
        ("locktype", "text", 13),
        ("database", "oid", 13),
        ("relation", "oid", 13),
        ("page", "integer", 13),
        ("tuple", "smallint", 13),
        ("virtualxid", "text", 13),
        ("transactionid", "xid", 13),
        ("classid", "oid", 13),
        ("objid", "oid", 13),
        ("objsubid", "smallint", 13),
        ("virtualtransaction", "text", 13),
        ("pid", "integer", 13),
        ("mode", "text", 13),
        ("granted", "boolean", 13),
        ("fastpath", "boolean", 13),
        ("waitstart", "timestamp with time zone", 14),
    ],
    "pg_matviews": [
        ("schemaname", "name", 13),
        ("matviewname", "name", 13),
        ("matviewowner", "name", 13),
        ("tablespace", "name", 13),
        ("hasindexes", "boolean", 13),
        ("ispopulated", "boolean", 13),
        ("definition", "text", 13),
    ],
    "pg_namespace": [
        ("oid", "oid", 13),
        ("nspname", "name", 13),
        ("nspowner", "oid", 13),
        ("nspacl", None, 13),
    ],
    "pg_opclass": [
        ("oid", "oid", 13),
        ("opcmethod", "oid", 13),
        ("opcname", "name", 13),
        ("opcnamespace", "oid", 13),
        ("opcowner", "oid", 13),
        ("opcfamily", "oid", 13),
        ("opcintype", "oid", 13),
        ("opcdefault", "boolean", 13),
        ("opckeytype", "oid", 13),
    ],
    "pg_operator": [
        ("oid", "oid", 13),
        ("oprname", "name", 13),
        ("oprnamespace", "oid", 13),
        ("oprowner", "oid", 13),
        ("oprkind", "\"char\"", 13),
        ("oprcanmerge", "boolean", 13),
        ("oprcanhash", "boolean", 13),
        ("oprleft", "oid", 13),
        ("oprright", "oid", 13),
        ("oprresult", "oid", 13),
        ("oprcom", "oid", 13),
        ("oprnegate", "oid", 13),
        ("oprcode", "regproc", 13),
        ("oprrest", "regproc", 13),
        ("oprjoin", "regproc", 13),
    ],
    "pg_opfamily": [
        ("oid", "oid", 13),
        ("opfmethod", "oid", 13),
        ("opfname", "name", 13),
        ("opfnamespace", "oid", 13),
        ("opfowner", "oid", 13),
    ],
    "pg_parameter_acl": [
        ("oid", "oid", 15),
        ("parname", "text", 15),
        ("paracl", None, 15),
    ],
    "pg_partitioned_table": [
        ("partrelid", "oid", 13),
        ("partstrat", "\"char\"", 13),
        ("partnatts", "smallint", 13),
        ("partdefid", "oid", 13),
        ("partattrs", None, 13),
        ("partclass", None, 13),
        ("partcollation", None, 13),
        ("partexprs", "pg_node_tree", 13),
    ],
    "pg_policies": [
        ("schemaname", "name", 13),
        ("tablename", "name", 13),
        ("policyname", "name", 13),
        ("permissive", "text", 13),
        ("roles", None, 13),
        ("cmd", "text", 13),
        ("qual", "text", 13),
        ("with_check", "text", 13),
    ],
    "pg_policy": [
        ("oid", "oid", 13),
        ("polname", "name", 13),
        ("polrelid", "oid", 13),
        ("polcmd", "\"char\"", 13),
        ("polpermissive", "boolean", 13),
        ("polroles", None, 13),
        ("polqual", "pg_node_tree", 13),
        ("polwithcheck", "pg_node_tree", 13),
    ],
    "pg_prepared_statements": [
        ("name", "text", 13),
        ("statement", "text", 13),
        ("prepare_time", "timestamp with time zone", 13),
        ("parameter_types", None, 13),
        ("result_types", None, 16),
        ("from_sql", "boolean", 13),
        ("generic_plans", "bigint", 14),
        ("custom_plans", "bigint", 14),
    ],
    "pg_prepared_xacts": [
        ("transaction", "xid", 13),
        ("gid", "text", 13),
        ("prepared", "timestamp with time zone", 13),
        ("owner", "name", 13),
        ("database", "name", 13),
    ],
    "pg_proc": [
        ("oid", "oid", 13),
        ("proname", "name", 13),
        ("pronamespace", "oid", 13),
        ("proowner", "oid", 13),
        ("prolang", "oid", 13),
        ("procost", "real", 13),
        ("prorows", "real", 13),
        ("provariadic", "oid", 13),
        ("prosupport", "regproc", 13),
        ("prokind", "\"char\"", 13),
        ("prosecdef", "boolean", 13),
        ("proleakproof", "boolean", 13),
        ("proisstrict", "boolean", 13),
        ("proretset", "boolean", 13),
        ("provolatile", "\"char\"", 13),
        ("proparallel", "\"char\"", 13),
        ("pronargs", "smallint", 13),
        ("pronargdefaults", "smallint", 13),
        ("prorettype", "oid", 13),
        ("proargtypes", None, 13),
        ("proallargtypes", None, 13),
        ("proargmodes", None, 13),
        ("proargnames", None, 13),
        ("proargdefaults", "pg_node_tree", 13),
        ("protrftypes", None, 13),
        ("prosrc", "text", 13),
        ("probin", "text", 13),
        ("prosqlbody", "pg_node_tree", 14),
        ("proconfig", None, 13),
        ("proacl", None, 13),
    ],
    "pg_publication": [
        ("oid", "oid", 13),
        ("pubname", "name", 13),
        ("pubowner", "oid", 13),
        ("puballtables", "boolean", 13),
        ("pubinsert", "boolean", 13),
        ("pubupdate", "boolean", 13),
        ("pubdelete", "boolean", 13),
        ("pubtruncate", "boolean", 13),
        ("pubviaroot", "boolean", 13),
    ],
    "pg_publication_namespace": [
        ("oid", "oid", 15),
        ("pnpubid", "oid", 15),
        ("pnnspid", "oid", 15),
    ],
    "pg_publication_rel": [
        ("oid", "oid", 13),
        ("prpubid", "oid", 13),
        ("prrelid", "oid", 13),
        ("prqual", "pg_node_tree", 15),
        ("prattrs", None, 15),
    ],
    "pg_publication_tables": [
        ("pubname", "name", 13),
        ("schemaname", "name", 13),
        ("tablename", "name", 13),
        ("attnames", None, 15),
        ("rowfilter", "text", 15),
    ],
    "pg_range": [
        ("rngtypid", "oid", 13),
        ("rngsubtype", "oid", 13),
        ("rngmultitypid", "oid", 14),
        ("rngcollation", "oid", 13),
        ("rngsubopc", "oid", 13),
        ("rngcanonical", "regproc", 13),
        ("rngsubdiff", "regproc", 13),
    ],
    "pg_replication_origin": [
        ("roident", "oid", 13),
        ("roname", "text", 13),
    ],
    "pg_replication_origin_status": [
        ("local_id", "oid", 13),
        ("external_id", "text", 13),
        ("remote_lsn", "pg_lsn", 13),
        ("local_lsn", "pg_lsn", 13),
    ],
    "pg_replication_slots": [
        ("slot_name", "name", 13),
        ("plugin", "name", 13),
        ("slot_type", "text", 13),
        ("datoid", "oid", 13),
        ("database", "name", 13),
        ("temporary", "boolean", 13),
        ("active", "boolean", 13),
        ("active_pid", "integer", 13),
        ("xmin", "xid", 13),
        ("catalog_xmin", "xid", 13),
        ("restart_lsn", "pg_lsn", 13),
        ("confirmed_flush_lsn", "pg_lsn", 13),
        ("wal_status", "text", 13),
        ("safe_wal_size", "bigint", 13),
        ("two_phase", "boolean", 14),
        ("inactive_since", "timestamp with time zone", 17),
        ("conflicting", "boolean", 16),
        ("invalidation_reason", "text", 17),
        ("failover", "boolean", 17),
        ("synced", "boolean", 17),
    ],
    "pg_rewrite": [
        ("oid", "oid", 13),
        ("rulename", "name", 13),
        ("ev_class", "oid", 13),
        ("ev_type", "\"char\"", 13),
        ("ev_enabled", "\"char\"", 13),
        ("is_instead", "boolean", 13),
        ("ev_qual", "pg_node_tree", 13),
        ("ev_action", "pg_node_tree", 13),
    ],
    "pg_roles": [
        ("rolname", "name", 13),
        ("rolsuper", "boolean", 13),
        ("rolinherit", "boolean", 13),
        ("rolcreaterole", "boolean", 13),
        ("rolcreatedb", "boolean", 13),
        ("rolcanlogin", "boolean", 13),
        ("rolreplication", "boolean", 13),
        ("rolconnlimit", "integer", 13),
        ("rolpassword", "text", 13),
        ("rolvaliduntil", "timestamp with time zone", 13),
        ("rolbypassrls", "boolean", 13),
        ("rolconfig", None, 13),
        ("oid", "oid", 13),
    ],
    "pg_rules": [
        ("schemaname", "name", 13),
        ("tablename", "name", 13),
        ("rulename", "name", 13),
        ("definition", "text", 13),
    ],
    "pg_seclabel": [
        ("objoid", "oid", 13),
        ("classoid", "oid", 13),
        ("objsubid", "integer", 13),
        ("provider", "text", 13),
        ("label", "text", 13),
    ],
    "pg_seclabels": [
        ("objoid", "oid", 13),
        ("classoid", "oid", 13),
        ("objsubid", "integer", 13),
        ("objtype", "text", 13),
        ("objnamespace", "oid", 13),
        ("objname", "text", 13),
        ("provider", "text", 13),
        ("label", "text", 13),
    ],
    "pg_sequence": [
        ("seqrelid", "oid", 13),
        ("seqtypid", "oid", 13),
        ("seqstart", "bigint", 13),
        ("seqincrement", "bigint", 13),
        ("seqmax", "bigint", 13),
        ("seqmin", "bigint", 13),
        ("seqcache", "bigint", 13),
        ("seqcycle", "boolean", 13),
    ],
    "pg_sequences": [
        ("schemaname", "name", 13),
        ("sequencename", "name", 13),
        ("sequenceowner", "name", 13),
        ("data_type", "regtype", 13),
        ("start_value", "bigint", 13),
        ("min_value", "bigint", 13),
        ("max_value", "bigint", 13),
        ("increment_by", "bigint", 13),
        ("cycle", "boolean", 13),
        ("cache_size", "bigint", 13),
        ("last_value", "bigint", 13),
    ],
    "pg_settings": [
        ("name", "text", 13),
        ("setting", "text", 13),
        ("unit", "text", 13),
        ("category", "text", 13),
        ("short_desc", "text", 13),
        ("extra_desc", "text", 13),
        ("context", "text", 13),
        ("vartype", "text", 13),
        ("source", "text", 13),
        ("min_val", "text", 13),
        ("max_val", "text", 13),
        ("enumvals", None, 13),
        ("boot_val", "text", 13),
        ("reset_val", "text", 13),
        ("sourcefile", "text", 13),
        ("sourceline", "integer", 13),
        ("pending_restart", "boolean", 13),
    ],
    "pg_shadow": [
        ("usename", "name", 13),
        ("usesysid", "oid", 13),
        ("usecreatedb", "boolean", 13),
        ("usesuper", "boolean", 13),
        ("userepl", "boolean", 13),
        ("usebypassrls", "boolean", 13),
        ("passwd", "text", 13),
        ("valuntil", "timestamp with time zone", 13),
        ("useconfig", None, 13),
    ],
    "pg_shdepend": [
        ("dbid", "oid", 13),
        ("classid", "oid", 13),
        ("objid", "oid", 13),
        ("objsubid", "integer", 13),
        ("refclassid", "oid", 13),
        ("refobjid", "oid", 13),
        ("deptype", "\"char\"", 13),
    ],
    "pg_shdescription": [
        ("objoid", "oid", 13),
        ("classoid", "oid", 13),
        ("description", "text", 13),
    ],
    "pg_shmem_allocations": [
        ("name", "text", 13),
        ("off", "bigint", 13),
        ("size", "bigint", 13),
        ("allocated_size", "bigint", 13),
    ],
    "pg_shseclabel": [
        ("objoid", "oid", 13),
        ("classoid", "oid", 13),
        ("provider", "text", 13),
        ("label", "text", 13),
    ],
    "pg_stat_activity": [
        ("datid", "oid", 13),
        ("datname", "name", 13),
        ("pid", "integer", 13),
        ("leader_pid", "integer", 13),
        ("usesysid", "oid", 13),
        ("usename", "name", 13),
        ("application_name", "text", 13),
        ("client_addr", "inet", 13),
        ("client_hostname", "text", 13),
        ("client_port", "integer", 13),
        ("backend_start", "timestamp with time zone", 13),
        ("xact_start", "timestamp with time zone", 13),
        ("query_start", "timestamp with time zone", 13),
        ("state_change", "timestamp with time zone", 13),
        ("wait_event_type", "text", 13),
        ("wait_event", "text", 13),
        ("state", "text", 13),
        ("backend_xid", "xid", 13),
        ("backend_xmin", "xid", 13),
        ("query_id", "bigint", 14),
        ("query", "text", 13),
        ("backend_type", "text", 13),
    ],
    "pg_stat_all_indexes": [
        ("relid", "oid", 13),
        ("indexrelid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("indexrelname", "name", 13),
        ("idx_scan", "bigint", 13),
        ("last_idx_scan", "timestamp with time zone", 16),
        ("idx_tup_read", "bigint", 13),
        ("idx_tup_fetch", "bigint", 13),
    ],
    "pg_stat_all_tables": [
        ("relid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("seq_scan", "bigint", 13),
        ("last_seq_scan", "timestamp with time zone", 16),
        ("seq_tup_read", "bigint", 13),
        ("idx_scan", "bigint", 13),
        ("last_idx_scan", "timestamp with time zone", 16),
        ("idx_tup_fetch", "bigint", 13),
        ("n_tup_ins", "bigint", 13),
        ("n_tup_upd", "bigint", 13),
        ("n_tup_del", "bigint", 13),
        ("n_tup_hot_upd", "bigint", 13),
        ("n_tup_newpage_upd", "bigint", 16),
        ("n_live_tup", "bigint", 13),
        ("n_dead_tup", "bigint", 13),
        ("n_mod_since_analyze", "bigint", 13),
        ("n_ins_since_vacuum", "bigint", 13),
        ("last_vacuum", "timestamp with time zone", 13),
        ("last_autovacuum", "timestamp with time zone", 13),
        ("last_analyze", "timestamp with time zone", 13),
        ("last_autoanalyze", "timestamp with time zone", 13),
        ("vacuum_count", "bigint", 13),
        ("autovacuum_count", "bigint", 13),
        ("analyze_count", "bigint", 13),
        ("autoanalyze_count", "bigint", 13),
    ],
    "pg_stat_archiver": [
        ("archived_count", "bigint", 13),
        ("last_archived_wal", "text", 13),
        ("last_archived_time", "timestamp with time zone", 13),
        ("failed_count", "bigint", 13),
        ("last_failed_wal", "text", 13),
        ("last_failed_time", "timestamp with time zone", 13),
        ("stats_reset", "timestamp with time zone", 13),
    ],
    "pg_stat_bgwriter": [
        ("buffers_clean", "bigint", 13),
        ("maxwritten_clean", "bigint", 13),
        ("buffers_alloc", "bigint", 13),
        ("stats_reset", "timestamp with time zone", 13),
    ],
    "pg_stat_checkpointer": [
        ("num_timed", "bigint", 17),
        ("num_requested", "bigint", 17),
        ("restartpoints_timed", "bigint", 17),
        ("restartpoints_req", "bigint", 17),
        ("restartpoints_done", "bigint", 17),
        ("write_time", "double precision", 17),
        ("sync_time", "double precision", 17),
        ("buffers_written", "bigint", 17),
        ("stats_reset", "timestamp with time zone", 17),
    ],
    "pg_stat_database": [
        ("datid", "oid", 13),
        ("datname", "name", 13),
        ("numbackends", "integer", 13),
        ("xact_commit", "bigint", 13),
        ("xact_rollback", "bigint", 13),
        ("blks_read", "bigint", 13),
        ("blks_hit", "bigint", 13),
        ("tup_returned", "bigint", 13),
        ("tup_fetched", "bigint", 13),
        ("tup_inserted", "bigint", 13),
        ("tup_updated", "bigint", 13),
        ("tup_deleted", "bigint", 13),
        ("conflicts", "bigint", 13),
        ("temp_files", "bigint", 13),
        ("temp_bytes", "bigint", 13),
        ("deadlocks", "bigint", 13),
        ("checksum_failures", "bigint", 13),
        ("checksum_last_failure", "timestamp with time zone", 13),
        ("blk_read_time", "double precision", 13),
        ("blk_write_time", "double precision", 13),
        ("session_time", "double precision", 14),
        ("active_time", "double precision", 14),
        ("idle_in_transaction_time", "double precision", 14),
        ("sessions", "bigint", 14),
        ("sessions_abandoned", "bigint", 14),
        ("sessions_fatal", "bigint", 14),
        ("sessions_killed", "bigint", 14),
        ("stats_reset", "timestamp with time zone", 13),
    ],
    "pg_stat_database_conflicts": [
        ("datid", "oid", 13),
        ("datname", "name", 13),
        ("confl_tablespace", "bigint", 13),
        ("confl_lock", "bigint", 13),
        ("confl_snapshot", "bigint", 13),
        ("confl_bufferpin", "bigint", 13),
        ("confl_deadlock", "bigint", 13),
        ("confl_active_logicalslot", "bigint", 16),
    ],
    "pg_stat_gssapi": [
        ("pid", "integer", 13),
        ("gss_authenticated", "boolean", 13),
        ("principal", "text", 13),
        ("encrypted", "boolean", 13),
        ("credentials_delegated", "boolean", 16),
    ],
    "pg_stat_io": [
        ("backend_type", "text", 16),
        ("object", "text", 16),
        ("context", "text", 16),
        ("reads", "bigint", 16),
        ("read_time", "double precision", 16),
        ("writes", "bigint", 16),
        ("write_time", "double precision", 16),
        ("writebacks", "bigint", 16),
        ("writeback_time", "double precision", 16),
        ("extends", "bigint", 16),
        ("extend_time", "double precision", 16),
        ("op_bytes", "bigint", 16),
        ("hits", "bigint", 16),
        ("evictions", "bigint", 16),
        ("reuses", "bigint", 16),
        ("fsyncs", "bigint", 16),
        ("fsync_time", "double precision", 16),
        ("stats_reset", "timestamp with time zone", 16),
    ],
    "pg_stat_progress_analyze": [
        ("pid", "integer", 13),
        ("datid", "oid", 13),
        ("datname", "name", 13),
        ("relid", "oid", 13),
        ("phase", "text", 13),
        ("sample_blks_total", "bigint", 13),
        ("sample_blks_scanned", "bigint", 13),
        ("ext_stats_total", "bigint", 13),
        ("ext_stats_computed", "bigint", 13),
        ("child_tables_total", "bigint", 13),
        ("child_tables_done", "bigint", 13),
        ("current_child_table_relid", "oid", 13),
    ],
    "pg_stat_progress_basebackup": [
        ("pid", "integer", 13),
        ("phase", "text", 13),
        ("backup_total", "bigint", 13),
        ("backup_streamed", "bigint", 13),
        ("tablespaces_total", "bigint", 13),
        ("tablespaces_streamed", "bigint", 13),
    ],
    "pg_stat_progress_cluster": [
        ("pid", "integer", 13),
        ("datid", "oid", 13),
        ("datname", "name", 13),
        ("relid", "oid", 13),
        ("command", "text", 13),
        ("phase", "text", 13),
        ("cluster_index_relid", "oid", 13),
        ("heap_tuples_scanned", "bigint", 13),
        ("heap_tuples_written", "bigint", 13),
        ("heap_blks_total", "bigint", 13),
        ("heap_blks_scanned", "bigint", 13),
        ("index_rebuild_count", "bigint", 13),
    ],
    "pg_stat_progress_copy": [
        ("pid", "integer", 14),
        ("datid", "oid", 14),
        ("datname", "name", 14),
        ("relid", "oid", 14),
        ("command", "text", 14),
        ("type", "text", 14),
        ("bytes_processed", "bigint", 14),
        ("bytes_total", "bigint", 14),
        ("tuples_processed", "bigint", 14),
        ("tuples_excluded", "bigint", 14),
        ("tuples_skipped", "bigint", 17),
    ],
    "pg_stat_progress_create_index": [
        ("pid", "integer", 13),
        ("datid", "oid", 13),
        ("datname", "name", 13),
        ("relid", "oid", 13),
        ("index_relid", "oid", 13),
        ("command", "text", 13),
        ("phase", "text", 13),
        ("lockers_total", "bigint", 13),
        ("lockers_done", "bigint", 13),
        ("current_locker_pid", "bigint", 13),
        ("blocks_total", "bigint", 13),
        ("blocks_done", "bigint", 13),
        ("tuples_total", "bigint", 13),
        ("tuples_done", "bigint", 13),
        ("partitions_total", "bigint", 13),
        ("partitions_done", "bigint", 13),
    ],
    "pg_stat_progress_vacuum": [
        ("pid", "integer", 13),
        ("datid", "oid", 13),
        ("datname", "name", 13),
        ("relid", "oid", 13),
        ("phase", "text", 13),
        ("heap_blks_total", "bigint", 13),
        ("heap_blks_scanned", "bigint", 13),
        ("heap_blks_vacuumed", "bigint", 13),
        ("index_vacuum_count", "bigint", 13),
        ("max_dead_tuple_bytes", "bigint", 17),
        ("dead_tuple_bytes", "bigint", 17),
        ("num_dead_item_ids", "bigint", 17),
        ("indexes_total", "bigint", 17),
        ("indexes_processed", "bigint", 17),
    ],
    "pg_stat_recovery_prefetch": [
        ("stats_reset", "timestamp with time zone", 15),
        ("prefetch", "bigint", 15),
        ("hit", "bigint", 15),
        ("skip_init", "bigint", 15),
        ("skip_new", "bigint", 15),
        ("skip_fpw", "bigint", 15),
        ("skip_rep", "bigint", 15),
        ("wal_distance", "integer", 15),
        ("block_distance", "integer", 15),
        ("io_depth", "integer", 15),
    ],
    "pg_stat_replication": [
        ("pid", "integer", 13),
        ("usesysid", "oid", 13),
        ("usename", "name", 13),
        ("application_name", "text", 13),
        ("client_addr", "inet", 13),
        ("client_hostname", "text", 13),
        ("client_port", "integer", 13),
        ("backend_start", "timestamp with time zone", 13),
        ("backend_xmin", "xid", 13),
        ("state", "text", 13),
        ("sent_lsn", "pg_lsn", 13),
        ("write_lsn", "pg_lsn", 13),
        ("flush_lsn", "pg_lsn", 13),
        ("replay_lsn", "pg_lsn", 13),
        ("write_lag", "interval", 13),
        ("flush_lag", "interval", 13),
        ("replay_lag", "interval", 13),
        ("sync_priority", "integer", 13),
        ("sync_state", "text", 13),
        ("reply_time", "timestamp with time zone", 13),
    ],
    "pg_stat_replication_slots": [
        ("slot_name", "text", 14),
        ("spill_txns", "bigint", 14),
        ("spill_count", "bigint", 14),
        ("spill_bytes", "bigint", 14),
        ("stream_txns", "bigint", 14),
        ("stream_count", "bigint", 14),
        ("stream_bytes", "bigint", 14),
        ("total_txns", "bigint", 14),
        ("total_bytes", "bigint", 14),
        ("stats_reset", "timestamp with time zone", 14),
    ],
    "pg_stat_slru": [
        ("name", "text", 13),
        ("blks_zeroed", "bigint", 13),
        ("blks_hit", "bigint", 13),
        ("blks_read", "bigint", 13),
        ("blks_written", "bigint", 13),
        ("blks_exists", "bigint", 13),
        ("flushes", "bigint", 13),
        ("truncates", "bigint", 13),
        ("stats_reset", "timestamp with time zone", 13),
    ],
    "pg_stat_ssl": [
        ("pid", "integer", 13),
        ("ssl", "boolean", 13),
        ("version", "text", 13),
        ("cipher", "text", 13),
        ("bits", "integer", 13),
        ("client_dn", "text", 13),
        ("client_serial", "numeric", 13),
        ("issuer_dn", "text", 13),
    ],
    "pg_stat_subscription": [
        ("subid", "oid", 13),
        ("subname", "name", 13),
        ("worker_type", "text", 17),
        ("pid", "integer", 13),
        ("leader_pid", "integer", 16),
        ("relid", "oid", 13),
        ("received_lsn", "pg_lsn", 13),
        ("last_msg_send_time", "timestamp with time zone", 13),
        ("last_msg_receipt_time", "timestamp with time zone", 13),
        ("latest_end_lsn", "pg_lsn", 13),
        ("latest_end_time", "timestamp with time zone", 13),
    ],
    "pg_stat_subscription_stats": [
        ("subid", "oid", 15),
        ("subname", "name", 15),
        ("apply_error_count", "bigint", 15),
        ("sync_error_count", "bigint", 15),
        ("stats_reset", "timestamp with time zone", 15),
    ],
    "pg_stat_sys_indexes": [
        ("relid", "oid", 13),
        ("indexrelid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("indexrelname", "name", 13),
        ("idx_scan", "bigint", 13),
        ("last_idx_scan", "timestamp with time zone", 16),
        ("idx_tup_read", "bigint", 13),
        ("idx_tup_fetch", "bigint", 13),
    ],
    "pg_stat_sys_tables": [
        ("relid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("seq_scan", "bigint", 13),
        ("last_seq_scan", "timestamp with time zone", 16),
        ("seq_tup_read", "bigint", 13),
        ("idx_scan", "bigint", 13),
        ("last_idx_scan", "timestamp with time zone", 16),
        ("idx_tup_fetch", "bigint", 13),
        ("n_tup_ins", "bigint", 13),
        ("n_tup_upd", "bigint", 13),
        ("n_tup_del", "bigint", 13),
        ("n_tup_hot_upd", "bigint", 13),
        ("n_tup_newpage_upd", "bigint", 16),
        ("n_live_tup", "bigint", 13),
        ("n_dead_tup", "bigint", 13),
        ("n_mod_since_analyze", "bigint", 13),
        ("n_ins_since_vacuum", "bigint", 13),
        ("last_vacuum", "timestamp with time zone", 13),
        ("last_autovacuum", "timestamp with time zone", 13),
        ("last_analyze", "timestamp with time zone", 13),
        ("last_autoanalyze", "timestamp with time zone", 13),
        ("vacuum_count", "bigint", 13),
        ("autovacuum_count", "bigint", 13),
        ("analyze_count", "bigint", 13),
        ("autoanalyze_count", "bigint", 13),
    ],
    "pg_stat_user_functions": [
        ("funcid", "oid", 13),
        ("schemaname", "name", 13),
        ("funcname", "name", 13),
        ("calls", "bigint", 13),
        ("total_time", "double precision", 13),
        ("self_time", "double precision", 13),
    ],
    "pg_stat_user_indexes": [
        ("relid", "oid", 13),
        ("indexrelid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("indexrelname", "name", 13),
        ("idx_scan", "bigint", 13),
        ("last_idx_scan", "timestamp with time zone", 16),
        ("idx_tup_read", "bigint", 13),
        ("idx_tup_fetch", "bigint", 13),
    ],
    "pg_stat_user_tables": [
        ("relid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("seq_scan", "bigint", 13),
        ("last_seq_scan", "timestamp with time zone", 16),
        ("seq_tup_read", "bigint", 13),
        ("idx_scan", "bigint", 13),
        ("last_idx_scan", "timestamp with time zone", 16),
        ("idx_tup_fetch", "bigint", 13),
        ("n_tup_ins", "bigint", 13),
        ("n_tup_upd", "bigint", 13),
        ("n_tup_del", "bigint", 13),
        ("n_tup_hot_upd", "bigint", 13),
        ("n_tup_newpage_upd", "bigint", 16),
        ("n_live_tup", "bigint", 13),
        ("n_dead_tup", "bigint", 13),
        ("n_mod_since_analyze", "bigint", 13),
        ("n_ins_since_vacuum", "bigint", 13),
        ("last_vacuum", "timestamp with time zone", 13),
        ("last_autovacuum", "timestamp with time zone", 13),
        ("last_analyze", "timestamp with time zone", 13),
        ("last_autoanalyze", "timestamp with time zone", 13),
        ("vacuum_count", "bigint", 13),
        ("autovacuum_count", "bigint", 13),
        ("analyze_count", "bigint", 13),
        ("autoanalyze_count", "bigint", 13),
    ],
    "pg_stat_wal": [
        ("wal_records", "bigint", 14),
        ("wal_fpi", "bigint", 14),
        ("wal_bytes", "numeric", 14),
        ("wal_buffers_full", "bigint", 14),
        ("wal_write", "bigint", 14),
        ("wal_sync", "bigint", 14),
        ("wal_write_time", "double precision", 14),
        ("wal_sync_time", "double precision", 14),
        ("stats_reset", "timestamp with time zone", 14),
    ],
    "pg_stat_wal_receiver": [
        ("pid", "integer", 13),
        ("status", "text", 13),
        ("receive_start_lsn", "pg_lsn", 13),
        ("receive_start_tli", "integer", 13),
        ("written_lsn", "pg_lsn", 13),
        ("flushed_lsn", "pg_lsn", 13),
        ("received_tli", "integer", 13),
        ("last_msg_send_time", "timestamp with time zone", 13),
        ("last_msg_receipt_time", "timestamp with time zone", 13),
        ("latest_end_lsn", "pg_lsn", 13),
        ("latest_end_time", "timestamp with time zone", 13),
        ("slot_name", "text", 13),
        ("sender_host", "text", 13),
        ("sender_port", "integer", 13),
        ("conninfo", "text", 13),
    ],
    "pg_stat_xact_all_tables": [
        ("relid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("seq_scan", "bigint", 13),
        ("seq_tup_read", "bigint", 13),
        ("idx_scan", "bigint", 13),
        ("idx_tup_fetch", "bigint", 13),
        ("n_tup_ins", "bigint", 13),
        ("n_tup_upd", "bigint", 13),
        ("n_tup_del", "bigint", 13),
        ("n_tup_hot_upd", "bigint", 13),
        ("n_tup_newpage_upd", "bigint", 16),
    ],
    "pg_stat_xact_sys_tables": [
        ("relid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("seq_scan", "bigint", 13),
        ("seq_tup_read", "bigint", 13),
        ("idx_scan", "bigint", 13),
        ("idx_tup_fetch", "bigint", 13),
        ("n_tup_ins", "bigint", 13),
        ("n_tup_upd", "bigint", 13),
        ("n_tup_del", "bigint", 13),
        ("n_tup_hot_upd", "bigint", 13),
        ("n_tup_newpage_upd", "bigint", 16),
    ],
    "pg_stat_xact_user_functions": [
        ("funcid", "oid", 13),
        ("schemaname", "name", 13),
        ("funcname", "name", 13),
        ("calls", "bigint", 13),
        ("total_time", "double precision", 13),
        ("self_time", "double precision", 13),
    ],
    "pg_stat_xact_user_tables": [
        ("relid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("seq_scan", "bigint", 13),
        ("seq_tup_read", "bigint", 13),
        ("idx_scan", "bigint", 13),
        ("idx_tup_fetch", "bigint", 13),
        ("n_tup_ins", "bigint", 13),
        ("n_tup_upd", "bigint", 13),
        ("n_tup_del", "bigint", 13),
        ("n_tup_hot_upd", "bigint", 13),
        ("n_tup_newpage_upd", "bigint", 16),
    ],
    "pg_statio_all_indexes": [
        ("relid", "oid", 13),
        ("indexrelid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("indexrelname", "name", 13),
        ("idx_blks_read", "bigint", 13),
        ("idx_blks_hit", "bigint", 13),
    ],
    "pg_statio_all_sequences": [
        ("relid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("blks_read", "bigint", 13),
        ("blks_hit", "bigint", 13),
    ],
    "pg_statio_all_tables": [
        ("relid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("heap_blks_read", "bigint", 13),
        ("heap_blks_hit", "bigint", 13),
        ("idx_blks_read", "bigint", 13),
        ("idx_blks_hit", "bigint", 13),
        ("toast_blks_read", "bigint", 13),
        ("toast_blks_hit", "bigint", 13),
        ("tidx_blks_read", "bigint", 13),
        ("tidx_blks_hit", "bigint", 13),
    ],
    "pg_statio_sys_indexes": [
        ("relid", "oid", 13),
        ("indexrelid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("indexrelname", "name", 13),
        ("idx_blks_read", "bigint", 13),
        ("idx_blks_hit", "bigint", 13),
    ],
    "pg_statio_sys_sequences": [
        ("relid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("blks_read", "bigint", 13),
        ("blks_hit", "bigint", 13),
    ],
    "pg_statio_sys_tables": [
        ("relid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("heap_blks_read", "bigint", 13),
        ("heap_blks_hit", "bigint", 13),
        ("idx_blks_read", "bigint", 13),
        ("idx_blks_hit", "bigint", 13),
        ("toast_blks_read", "bigint", 13),
        ("toast_blks_hit", "bigint", 13),
        ("tidx_blks_read", "bigint", 13),
        ("tidx_blks_hit", "bigint", 13),
    ],
    "pg_statio_user_indexes": [
        ("relid", "oid", 13),
        ("indexrelid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("indexrelname", "name", 13),
        ("idx_blks_read", "bigint", 13),
        ("idx_blks_hit", "bigint", 13),
    ],
    "pg_statio_user_sequences": [
        ("relid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("blks_read", "bigint", 13),
        ("blks_hit", "bigint", 13),
    ],
    "pg_statio_user_tables": [
        ("relid", "oid", 13),
        ("schemaname", "name", 13),
        ("relname", "name", 13),
        ("heap_blks_read", "bigint", 13),
        ("heap_blks_hit", "bigint", 13),
        ("idx_blks_read", "bigint", 13),
        ("idx_blks_hit", "bigint", 13),
        ("toast_blks_read", "bigint", 13),
        ("toast_blks_hit", "bigint", 13),
        ("tidx_blks_read", "bigint", 13),
        ("tidx_blks_hit", "bigint", 13),
    ],
    "pg_statistic": [
        ("starelid", "oid", 13),
        ("staattnum", "smallint", 13),
        ("stainherit", "boolean", 13),
        ("stanullfrac", "real", 13),
        ("stawidth", "integer", 13),
        ("stadistinct", "real", 13),
        ("stakind1", "smallint", 13),
        ("stakind2", "smallint", 13),
        ("stakind3", "smallint", 13),
        ("stakind4", "smallint", 13),
        ("stakind5", "smallint", 13),
        ("staop1", "oid", 13),
        ("staop2", "oid", 13),
        ("staop3", "oid", 13),
        ("staop4", "oid", 13),
        ("staop5", "oid", 13),
        ("stacoll1", "oid", 13),
        ("stacoll2", "oid", 13),
        ("stacoll3", "oid", 13),
        ("stacoll4", "oid", 13),
        ("stacoll5", "oid", 13),
        ("stanumbers1", None, 13),
        ("stanumbers2", None, 13),
        ("stanumbers3", None, 13),
        ("stanumbers4", None, 13),
        ("stanumbers5", None, 13),
        ("stavalues1", None, 13),
        ("stavalues2", None, 13),
        ("stavalues3", None, 13),
        ("stavalues4", None, 13),
        ("stavalues5", None, 13),
    ],
    "pg_statistic_ext": [
        ("oid", "oid", 13),
        ("stxrelid", "oid", 13),
        ("stxname", "name", 13),
        ("stxnamespace", "oid", 13),
        ("stxowner", "oid", 13),
        ("stxkeys", None, 13),
        ("stxstattarget", "smallint", 13),
        ("stxkind", None, 13),
        ("stxexprs", "pg_node_tree", 14),
    ],
    "pg_statistic_ext_data": [
        ("stxoid", "oid", 13),
        ("stxdinherit", "boolean", 15),
        ("stxdndistinct", "pg_ndistinct", 13),
        ("stxddependencies", "pg_dependencies", 13),
        ("stxdmcv", "pg_mcv_list", 13),
        ("stxdexpr", None, 14),
    ],
    "pg_stats": [
        ("schemaname", "name", 13),
        ("tablename", "name", 13),
        ("attname", "name", 13),
        ("inherited", "boolean", 13),
        ("null_frac", "real", 13),
        ("avg_width", "integer", 13),
        ("n_distinct", "real", 13),
        ("most_common_vals", None, 13),
        ("most_common_freqs", None, 13),
        ("histogram_bounds", None, 13),
        ("correlation", "real", 13),
        ("most_common_elems", None, 13),
        ("most_common_elem_freqs", None, 13),
        ("elem_count_histogram", None, 13),
        ("range_length_histogram", None, 17),
        ("range_empty_frac", "real", 17),
        ("range_bounds_histogram", None, 17),
    ],
    "pg_stats_ext": [
        ("schemaname", "name", 13),
        ("tablename", "name", 13),
        ("statistics_schemaname", "name", 13),
        ("statistics_name", "name", 13),
        ("statistics_owner", "name", 13),
        ("attnames", None, 13),
        ("exprs", None, 14),
        ("kinds", None, 13),
        ("inherited", "boolean", 15),
        ("n_distinct", "pg_ndistinct", 13),
        ("dependencies", "pg_dependencies", 13),
        ("most_common_vals", None, 13),
        ("most_common_val_nulls", None, 13),
        ("most_common_freqs", None, 13),
        ("most_common_base_freqs", None, 13),
    ],
    "pg_stats_ext_exprs": [
        ("schemaname", "name", 14),
        ("tablename", "name", 14),
        ("statistics_schemaname", "name", 14),
        ("statistics_name", "name", 14),
        ("statistics_owner", "name", 14),
        ("expr", "text", 14),
        ("inherited", "boolean", 15),
        ("null_frac", "real", 14),
        ("avg_width", "integer", 14),
        ("n_distinct", "real", 14),
        ("most_common_vals", None, 14),
        ("most_common_freqs", None, 14),
        ("histogram_bounds", None, 14),
        ("correlation", "real", 14),
        ("most_common_elems", None, 14),
        ("most_common_elem_freqs", None, 14),
        ("elem_count_histogram", None, 14),
    ],
    "pg_subscription": [
        ("oid", "oid", 13),
        ("subdbid", "oid", 13),
        ("subskiplsn", "pg_lsn", 15),
        ("subname", "name", 13),
        ("subowner", "oid", 13),
        ("subenabled", "boolean", 13),
        ("subbinary", "boolean", 14),
        ("substream", "\"char\"", 14),
        ("subtwophasestate", "\"char\"", 15),
        ("subdisableonerr", "boolean", 15),
        ("subpasswordrequired", "boolean", 16),
        ("subrunasowner", "boolean", 16),
        ("subfailover", "boolean", 17),
        ("subconninfo", "text", 13),
        ("subslotname", "name", 13),
        ("subsynccommit", "text", 13),
        ("subpublications", None, 13),
        ("suborigin", "text", 16),
    ],
    "pg_subscription_rel": [
        ("srsubid", "oid", 13),
        ("srrelid", "oid", 13),
        ("srsubstate", "\"char\"", 13),
        ("srsublsn", "pg_lsn", 13),
    ],
    "pg_tables": [
        ("schemaname", "name", 13),
        ("tablename", "name", 13),
        ("tableowner", "name", 13),
        ("tablespace", "name", 13),
        ("hasindexes", "boolean", 13),
        ("hasrules", "boolean", 13),
        ("hastriggers", "boolean", 13),
        ("rowsecurity", "boolean", 13),
    ],
    "pg_tablespace": [
        ("oid", "oid", 13),
        ("spcname", "name", 13),
        ("spcowner", "oid", 13),
        ("spcacl", None, 13),
        ("spcoptions", None, 13),
    ],
    "pg_timezone_abbrevs": [
        ("abbrev", "text", 13),
        ("utc_offset", "interval", 13),
        ("is_dst", "boolean", 13),
    ],
    "pg_timezone_names": [
        ("name", "text", 13),
        ("abbrev", "text", 13),
        ("utc_offset", "interval", 13),
        ("is_dst", "boolean", 13),
    ],
    "pg_transform": [
        ("oid", "oid", 13),
        ("trftype", "oid", 13),
        ("trflang", "oid", 13),
        ("trffromsql", "regproc", 13),
        ("trftosql", "regproc", 13),
    ],
    "pg_trigger": [
        ("oid", "oid", 13),
        ("tgrelid", "oid", 13),
        ("tgparentid", "oid", 13),
        ("tgname", "name", 13),
        ("tgfoid", "oid", 13),
        ("tgtype", "smallint", 13),
        ("tgenabled", "\"char\"", 13),
        ("tgisinternal", "boolean", 13),
        ("tgconstrrelid", "oid", 13),
        ("tgconstrindid", "oid", 13),
        ("tgconstraint", "oid", 13),
        ("tgdeferrable", "boolean", 13),
        ("tginitdeferred", "boolean", 13),
        ("tgnargs", "smallint", 13),
        ("tgattr", None, 13),
        ("tgargs", "bytea", 13),
        ("tgqual", "pg_node_tree", 13),
        ("tgoldtable", "name", 13),
        ("tgnewtable", "name", 13),
    ],
    "pg_ts_config": [
        ("oid", "oid", 13),
        ("cfgname", "name", 13),
        ("cfgnamespace", "oid", 13),
        ("cfgowner", "oid", 13),
        ("cfgparser", "oid", 13),
    ],
    "pg_ts_config_map": [
        ("mapcfg", "oid", 13),
        ("maptokentype", "integer", 13),
        ("mapseqno", "integer", 13),
        ("mapdict", "oid", 13),
    ],
    "pg_ts_dict": [
        ("oid", "oid", 13),
        ("dictname", "name", 13),
        ("dictnamespace", "oid", 13),
        ("dictowner", "oid", 13),
        ("dicttemplate", "oid", 13),
        ("dictinitoption", "text", 13),
    ],
    "pg_ts_parser": [
        ("oid", "oid", 13),
        ("prsname", "name", 13),
        ("prsnamespace", "oid", 13),
        ("prsstart", "regproc", 13),
        ("prstoken", "regproc", 13),
        ("prsend", "regproc", 13),
        ("prsheadline", "regproc", 13),
        ("prslextype", "regproc", 13),
    ],
    "pg_ts_template": [
        ("oid", "oid", 13),
        ("tmplname", "name", 13),
        ("tmplnamespace", "oid", 13),
        ("tmplinit", "regproc", 13),
        ("tmpllexize", "regproc", 13),
    ],
    "pg_type": [
        ("oid", "oid", 13),
        ("typname", "name", 13),
        ("typnamespace", "oid", 13),
        ("typowner", "oid", 13),
        ("typlen", "smallint", 13),
        ("typbyval", "boolean", 13),
        ("typtype", "\"char\"", 13),
        ("typcategory", "\"char\"", 13),
        ("typispreferred", "boolean", 13),
        ("typisdefined", "boolean", 13),
        ("typdelim", "\"char\"", 13),
        ("typrelid", "oid", 13),
        ("typsubscript", "regproc", 14),
        ("typelem", "oid", 13),
        ("typarray", "oid", 13),
        ("typinput", "regproc", 13),
        ("typoutput", "regproc", 13),
        ("typreceive", "regproc", 13),
        ("typsend", "regproc", 13),
        ("typmodin", "regproc", 13),
        ("typmodout", "regproc", 13),
        ("typanalyze", "regproc", 13),
        ("typalign", "\"char\"", 13),
        ("typstorage", "\"char\"", 13),
        ("typnotnull", "boolean", 13),
        ("typbasetype", "oid", 13),
        ("typtypmod", "integer", 13),
        ("typndims", "integer", 13),
        ("typcollation", "oid", 13),
        ("typdefaultbin", "pg_node_tree", 13),
        ("typdefault", "text", 13),
        ("typacl", None, 13),
    ],
    "pg_user": [
        ("usename", "name", 13),
        ("usesysid", "oid", 13),
        ("usecreatedb", "boolean", 13),
        ("usesuper", "boolean", 13),
        ("userepl", "boolean", 13),
        ("usebypassrls", "boolean", 13),
        ("passwd", "text", 13),
        ("valuntil", "timestamp with time zone", 13),
        ("useconfig", None, 13),
    ],
    "pg_user_mapping": [
        ("oid", "oid", 13),
        ("umuser", "oid", 13),
        ("umserver", "oid", 13),
        ("umoptions", None, 13),
    ],
    "pg_user_mappings": [
        ("umid", "oid", 13),
        ("srvid", "oid", 13),
        ("srvname", "name", 13),
        ("umuser", "oid", 13),
        ("usename", "name", 13),
        ("umoptions", None, 13),
    ],
    "pg_views": [
        ("schemaname", "name", 13),
        ("viewname", "name", 13),
        ("viewowner", "name", 13),
        ("definition", "text", 13),
    ],
    "pg_wait_events": [
        ("type", "text", 17),
        ("name", "text", 17),
        ("description", "text", 17),
    ]
}
