import { DeviceModel } from 'models/devices';
import React, { FC } from 'react';
import { ComplianceImageProps } from 'shared/components/modals/Compliance/ComplianceImageSwitch';

const JapaneseTelecomLogo = () => (
  <svg>
    <rect width="32" height="32" transform="translate(0 38)" />
    <path
      d="M26.5118 58.0198C26.3395 57.9796 26.1587 58.0074 26.0055 58.0976C25.8522 58.1878 25.7378 58.3338 25.6851 58.5065C25.0034 60.0902 23.9182 61.4571 22.5433 62.4639C20.6422 63.8376 18.3329 64.4898 16.0128 64.3082C13.6927 64.1267 11.507 63.1228 9.83183 61.4693C8.79388 60.4303 7.98134 59.1791 7.44716 57.7972C6.91297 56.4152 6.66911 54.9336 6.73146 53.4488C6.73146 53.0467 6.87614 52.8562 7.26885 52.7716C8.28164 52.56 9.33577 52.2848 10.2659 52.0521L16.0119 50.6342V53.9355L28 51.0151C28 50.8881 28 50.8035 28 50.7188C27.4582 48.7128 26.4082 46.8889 24.9563 45.4321C23.5044 43.9753 21.7022 42.9373 19.7323 42.4232C19.0101 42.2414 18.2787 42.1001 17.5414 42H15.7639H15.5158C13.3526 42.1792 11.2957 43.0363 9.62514 44.4548C7.89967 45.7438 6.56769 47.5085 5.78453 49.543C5.00137 51.5776 4.79932 53.7982 5.20194 55.9459C5.63273 58.7335 7.01606 61.2741 9.10551 63.115C11.195 64.9558 13.8548 65.9775 16.6113 65.998C18.3488 66.0312 20.0706 65.6554 21.6438 64.8996C23.217 64.1438 24.5996 63.0281 25.6851 61.6385C26.5772 60.5745 27.2771 59.3563 27.752 58.041C27.3385 58.0574 26.9245 58.0503 26.5118 58.0198V58.0198ZM15.6192 43.82C17.7239 43.5796 19.8484 44.0381 21.6794 45.1279C23.5103 46.2176 24.9508 47.8808 25.7884 49.8723L17.5207 51.9886V48.6449L7.18618 51.1421C7.70575 49.1927 8.78937 47.45 10.2945 46.1431C11.7997 44.8362 13.656 44.0263 15.6192 43.82V43.82ZM22.9567 58.6335C22.936 59.0565 22.936 59.4803 22.9567 59.9032H18.4302C18.0375 59.9032 17.9135 60.0302 17.9341 60.4323C17.9341 61.1518 17.9341 61.8925 17.9341 62.5485C17.9341 63.2046 17.8101 63.1622 17.4174 63.1622H16.0119C15.6605 63.1622 15.5778 63.0141 15.5778 62.6755C15.5778 61.7867 15.5778 60.8979 15.5778 59.9456H10.5966V58.0833H10.9893H22.2953C22.812 57.9986 23.0187 58.1468 22.9567 58.697V58.6335ZM22.9567 56.7078H10.5552V54.8878H22.9567V56.7078Z"
      fill="#6B6D76"
    />
  </svg>
);

export const ComplianceImage = () => (
  <svg width="260" height="70" viewBox="0 0 260 70" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M27.3829 20.8034L18.3332 8.23013C17.8571 7.57017 17.1553 7.13787 16.381 7.02772C15.6068 6.91756 14.8231 7.13849 14.2012 7.64223C13.9959 7.8139 13.8107 8.01129 13.6496 8.23013L4.60509 20.8034C4.27129 21.2696 4.06642 21.8259 4.01362 22.4095C3.96082 22.9932 4.0622 23.581 4.30631 24.1065C4.55041 24.632 4.92752 25.0743 5.39505 25.3835C5.86258 25.6926 6.40189 25.8563 6.95209 25.856H25.0568C25.6065 25.8553 26.145 25.6907 26.6115 25.3807C27.0779 25.0708 27.4537 24.6279 27.6963 24.1022C27.9388 23.5764 28.0385 22.9889 27.9841 22.4059C27.9296 21.8229 27.7232 21.2678 27.3881 20.8034H27.3829ZM25.0516 23.9703H6.94689C6.69051 23.9692 6.44101 23.8818 6.23394 23.7207C5.98724 23.5177 5.82583 23.219 5.78489 22.8896C5.74395 22.5603 5.82679 22.2271 6.01537 21.9626L15.0651 9.40038C15.1271 9.31032 15.2007 9.23004 15.2837 9.16189C15.5289 8.96032 15.8391 8.87049 16.1463 8.91206C16.4535 8.95364 16.7328 9.12324 16.9229 9.38374L25.9779 21.9459C26.1653 22.2118 26.2465 22.5459 26.2036 22.8753C26.1606 23.2047 25.9972 23.5027 25.7489 23.7041C25.5431 23.8644 25.296 23.9535 25.0411 23.9592L25.0516 23.9703Z"
      fill="#6B6D76"
    />
    <path
      d="M20.3071 15.5787C20.3619 15.5205 20.4053 15.4513 20.435 15.3752C20.4646 15.2991 20.4799 15.2175 20.4799 15.135C20.4799 15.0526 20.4646 14.971 20.435 14.8948C20.4053 14.8187 20.3619 14.7495 20.3071 14.6913C20.2528 14.6323 20.1881 14.5854 20.1166 14.5534C20.0451 14.5214 19.9683 14.5049 19.8908 14.5049C19.8132 14.5049 19.7365 14.5214 19.665 14.5534C19.5935 14.5854 19.5287 14.6323 19.4745 14.6913L15.9514 18.4461C15.9144 18.4857 15.8674 18.5127 15.8161 18.5238C15.7795 18.5347 15.7413 18.5377 15.7036 18.5327C15.6659 18.5277 15.6296 18.5147 15.5966 18.4946C15.5637 18.4745 15.5349 18.4476 15.5118 18.4154C15.4887 18.3833 15.4718 18.3466 15.4622 18.3075L15.0615 16.7379C15.0201 16.5773 14.9208 16.4406 14.7854 16.3575C14.65 16.2745 14.4892 16.2517 14.3381 16.2942C14.1926 16.3349 14.0673 16.4335 13.988 16.5697C13.9086 16.7058 13.8812 16.8692 13.9114 17.0263L14.6087 19.8327C14.6647 20.0469 14.7978 20.2289 14.9791 20.339C15.1604 20.4492 15.3752 20.4785 15.5767 20.4206C15.7114 20.3824 15.8338 20.3057 15.9306 20.1987L20.3071 15.5787Z"
      fill="#6B6D76"
    />
    <path
      d="M17.811 12.6448C16.8234 12.2595 15.7508 12.1948 14.7288 12.4591C13.7068 12.7233 12.7812 13.3045 12.069 14.1292C11.3569 14.954 10.8901 15.9852 10.7278 17.0926C10.5655 18.2 10.7148 19.3339 11.157 20.3508C11.5992 21.3678 12.3144 22.2222 13.2121 22.806C14.1098 23.3899 15.1498 23.677 16.2006 23.631C17.2514 23.5851 18.2658 23.2081 19.1156 22.5479C19.9654 21.8876 20.6125 20.9736 20.975 19.9215C21.1875 19.301 21.2984 18.6463 21.3029 17.9858C21.3029 17.8182 21.2404 17.6573 21.1291 17.5388C21.0179 17.4202 20.867 17.3536 20.7096 17.3536C20.5523 17.3536 20.4014 17.4202 20.2901 17.5388C20.1789 17.6573 20.1164 17.8182 20.1164 17.9858C20.1174 18.857 19.8759 19.709 19.4225 20.4339C18.9691 21.1588 18.3242 21.7241 17.5693 22.0583C16.8143 22.3924 15.9834 22.4804 15.1815 22.3111C14.3796 22.1419 13.6429 21.7229 13.0645 21.1072C12.4861 20.4916 12.0921 19.7069 11.9322 18.8525C11.7724 17.9982 11.8539 17.1124 12.1665 16.3074C12.4791 15.5025 13.0087 14.8144 13.6883 14.3302C14.3679 13.8461 15.167 13.5877 15.9844 13.5877C16.4655 13.5873 16.9429 13.6775 17.3947 13.8539C17.5472 13.9066 17.7131 13.8931 17.8563 13.8163C17.9996 13.7394 18.1086 13.6055 18.1597 13.4435C18.2075 13.2888 18.1981 13.1205 18.1333 12.9731C18.0684 12.8256 17.9531 12.7101 17.811 12.6504V12.6448Z"
      fill="#6B6D76"
    />
    <path
      d="M49.6291 17.8251C50.503 14.7951 51.5041 13.544 51.9119 13.1217C52.8926 12.1965 54.0155 11.4337 55.2382 10.8624C56.6789 10.2184 57.1291 9.58494 58.0401 8.60309C57.3585 9.63609 56.4207 10.4761 55.3177 11.0419C54.1441 11.5702 53.0805 12.3133 52.182 13.2326C50.8685 14.5417 49.931 17.7354 49.7668 18.3846C49.7738 18.5619 49.7578 18.7393 49.7191 18.9125C49.5549 19.4404 50.0369 19.0973 50.0369 19.0973L50.2805 17.8884C51.6259 16.3048 53.1831 16.3048 55.9056 14.7212C58.93 12.9106 59.3378 10.8466 59.6874 8.84063C60.0475 6.63938 59.2795 4 59.2795 4C59.0586 5.05337 58.5739 6.03394 57.8706 6.85054C55.7996 9.48992 53.4691 8.50807 50.4553 10.9838C47.5793 13.3329 49.4543 17.4767 49.6238 17.8462"
      fill="#6B6D76"
    />
    <path
      d="M44.6536 25.4788C44.6124 25.2551 44.4893 25.0547 44.3083 24.9162C44.1273 24.7777 43.9012 24.7111 43.6737 24.7292C42.8263 24.7292 42.4767 25.4207 42.4767 26.1439C42.4767 26.8671 42.8422 27.622 43.6896 27.622C43.8201 27.6234 43.9497 27.5991 44.0707 27.5504C44.1917 27.5017 44.302 27.4297 44.395 27.3385C44.488 27.2472 44.562 27.1386 44.6128 27.0187C44.6635 26.8989 44.69 26.7702 44.6907 26.6401V26.5979H45.1621C45.1551 26.9797 44.997 27.3432 44.7221 27.6092C44.4473 27.8752 44.078 28.0221 43.6949 28.0179H43.6314C42.5297 28.0179 42 27.205 42 26.1809C42 25.1568 42.5879 24.3228 43.679 24.3228C44.0218 24.2936 44.3629 24.3958 44.6326 24.6087C44.9023 24.8216 45.0803 25.129 45.1303 25.4683H44.643L44.6536 25.4788Z"
      fill="#6B6D76"
    />
    <path
      d="M46.9866 25.3468C47.146 25.3418 47.3047 25.3683 47.4537 25.4245C47.6028 25.4807 47.7392 25.5657 47.8553 25.6745C47.9714 25.7834 48.0649 25.9139 48.1303 26.0588C48.1957 26.2036 48.2319 26.3599 48.2367 26.5187C48.2367 26.5714 48.2367 26.6295 48.2367 26.6876C48.2431 27.0049 48.1273 27.3126 47.9131 27.5473C47.6989 27.7821 47.4026 27.9262 47.085 27.9499C46.7675 27.9735 46.4529 27.875 46.2061 27.6746C45.9592 27.4742 45.7988 27.1871 45.7578 26.8723C45.7524 26.8109 45.7524 26.749 45.7578 26.6876C45.7386 26.5305 45.7509 26.3711 45.7939 26.2187C45.8368 26.0663 45.9097 25.9239 46.0081 25.7997C46.1066 25.6756 46.2288 25.5721 46.3677 25.4952C46.5066 25.4184 46.6593 25.3697 46.8172 25.3521C46.8788 25.3467 46.9409 25.3467 47.0025 25.3521L46.9866 25.3468ZM47.0025 27.643C47.4422 27.643 47.8023 27.2946 47.8023 26.677C47.8023 26.0594 47.4422 25.711 47.0025 25.711C46.5629 25.711 46.2027 26.0594 46.2027 26.677C46.2027 27.2946 46.5629 27.643 47.0025 27.643Z"
      fill="#6B6D76"
    />
    <path
      d="M48.9297 25.3893H49.3216V25.7694C49.408 25.6286 49.5308 25.5137 49.6771 25.4366C49.8234 25.3595 49.9879 25.3231 50.1532 25.3312C50.3035 25.3158 50.4546 25.3504 50.583 25.4297C50.7115 25.509 50.8099 25.6284 50.863 25.7694C50.9466 25.6334 51.0644 25.5215 51.2046 25.4447C51.3449 25.3679 51.5027 25.3288 51.6628 25.3312C52.1924 25.3312 52.5102 25.5424 52.5102 26.0703V27.9389H52.1077V26.2656C52.1077 25.9488 52.0176 25.706 51.6098 25.706C51.4476 25.6929 51.2868 25.7444 51.1626 25.8493C51.0385 25.9542 50.9612 26.1039 50.9477 26.2656C50.9452 26.2954 50.9452 26.3254 50.9477 26.3553V27.9389H50.5187V26.2656C50.5187 25.933 50.4127 25.706 50.0367 25.706C49.8614 25.7059 49.6928 25.7734 49.5664 25.8945C49.44 26.0156 49.3656 26.1807 49.3587 26.3553V27.9389H48.9297V25.3893Z"
      fill="#6B6D76"
    />
    <path
      d="M53.3545 25.3894H53.7782V25.7378C53.8621 25.6005 53.9831 25.4896 54.1274 25.4177C54.2717 25.3458 54.4334 25.3159 54.5939 25.3314C54.7697 25.3237 54.945 25.3551 55.1071 25.4233C55.2692 25.4915 55.414 25.5948 55.5312 25.7256C55.6483 25.8565 55.7347 26.0117 55.7842 26.18C55.8337 26.3483 55.8451 26.5254 55.8174 26.6986C55.847 27.0091 55.7523 27.3187 55.5539 27.56C55.3555 27.8012 55.0694 27.9546 54.7581 27.9866H54.6204C54.459 27.992 54.2987 27.9577 54.1537 27.8868C54.0087 27.816 53.8834 27.7106 53.7888 27.5801V28.8893H53.3651L53.3545 25.3894ZM54.5515 25.7062C53.9901 25.7062 53.7623 26.1918 53.7623 26.6722C53.7623 27.1526 53.9901 27.6382 54.5674 27.6382C55.1448 27.6382 55.3354 27.1526 55.3354 26.6564C55.3354 26.1601 55.0971 25.7062 54.5515 25.7062Z"
      fill="#6B6D76"
    />
    <path d="M56.9208 24.4231H56.4971V27.9493H56.9208V24.4231Z" fill="#6B6D76" />
    <path
      d="M58.2274 24.94H57.8037V24.4121H58.2274V24.94ZM57.8037 25.3887H58.2274V27.9383H57.8037V25.3887Z"
      fill="#6B6D76"
    />
    <path
      d="M61.3353 27.9383C61.2444 27.9925 61.1392 28.0182 61.0334 28.0122C60.9885 28.0158 60.9432 28.0104 60.9004 27.9964C60.8576 27.9823 60.818 27.9599 60.7839 27.9304C60.7499 27.9009 60.7221 27.8649 60.7022 27.8246C60.6823 27.7843 60.6706 27.7404 60.668 27.6955V27.6216C60.5598 27.7505 60.4232 27.8528 60.2689 27.9206C60.1145 27.9883 59.9466 28.0197 59.7781 28.0122C59.3067 28.0122 58.9307 27.8011 58.9307 27.3049C58.9307 26.8087 59.3703 26.6133 59.794 26.5236C60.2177 26.4339 60.6574 26.4603 60.6574 26.1435C60.6574 25.8268 60.3502 25.7212 60.08 25.7212C59.7199 25.7212 59.4603 25.8268 59.4444 26.2069H59.0207C59.0525 25.5734 59.5504 25.3464 60.1118 25.3464C60.562 25.3464 61.0652 25.452 61.0652 26.0538V27.3629C61.0652 27.5582 61.0652 27.6533 61.1976 27.6533C61.238 27.6588 61.279 27.6588 61.3194 27.6533V27.9541L61.3353 27.9383ZM60.6574 26.6292C60.4158 26.7279 60.1603 26.7884 59.8999 26.8087C59.6086 26.8509 59.3703 26.9565 59.3703 27.2626C59.3703 27.5688 59.6086 27.6374 59.8682 27.6374C60.4296 27.6374 60.6521 27.289 60.6521 27.062V26.6292H60.6574Z"
      fill="#6B6D76"
    />
    <path
      d="M61.928 25.3886H62.3252V25.7951C62.4064 25.6479 62.5273 25.5263 62.6743 25.4442C62.8213 25.3621 62.9885 25.3227 63.1568 25.3306C63.8348 25.3306 64.0308 25.7054 64.0308 26.2649V27.9383H63.607V26.2016C63.6144 26.1383 63.6088 26.0742 63.5908 26.0131C63.5728 25.952 63.5426 25.8952 63.5021 25.8459C63.4616 25.7967 63.4115 25.7561 63.355 25.7265C63.2984 25.6969 63.2364 25.6789 63.1727 25.6737H63.0933C63 25.6672 62.9064 25.6792 62.8178 25.7089C62.7292 25.7386 62.6474 25.7855 62.577 25.8468C62.5066 25.9081 62.4491 25.9827 62.4077 26.0662C62.3663 26.1497 62.3419 26.2406 62.3358 26.3335C62.3306 26.3809 62.3306 26.4287 62.3358 26.4761V27.9225H61.9121L61.928 25.3886Z"
      fill="#6B6D76"
    />
    <path
      d="M65.4695 25.3895H65.9992V25.7538H65.4695V27.3374C65.4695 27.5327 65.5278 27.5644 65.7873 27.5644H65.9833V27.9233H65.6655C65.2259 27.9233 65.0617 27.8336 65.0617 27.3638V25.7379H64.6221V25.3737H65.0617V24.5872H65.4854V25.3684L65.4695 25.3895Z"
      fill="#6B6D76"
    />
    <path
      d="M42.354 16.769H45.5744C47.0416 16.769 47.799 17.4447 47.799 18.5902C47.8344 18.9586 47.7431 19.3281 47.54 19.6379C47.3369 19.9478 47.0341 20.1796 46.6814 20.2953C47.0892 20.3533 47.6825 20.6542 47.6825 21.71C47.6825 22.4965 47.7884 23.2039 48.0426 23.4731H46.7714C46.6221 23.1704 46.5597 22.8324 46.5914 22.4965C46.5914 21.2613 46.3318 20.7176 45.246 20.7176H43.5034V23.5312H42.3223V16.769H42.354ZM43.5352 19.836H45.4685C46.2259 19.836 46.6178 19.4718 46.6178 18.7803C46.6178 17.9198 46.0882 17.7562 45.4526 17.7562H43.5352V19.836Z"
      fill="#6B6D76"
    />
    <path
      d="M48.4463 21.0655C48.4463 19.5716 49.3361 18.5 50.9092 18.5C52.4823 18.5 53.3775 19.5558 53.3775 21.0655C53.3775 22.5752 52.4823 23.6415 50.9092 23.6415C49.3361 23.6415 48.4463 22.5858 48.4463 21.0655ZM52.3022 21.0655C52.3022 20.2209 51.8785 19.3446 50.9092 19.3446C49.9399 19.3446 49.5215 20.2209 49.5215 21.0655C49.5215 21.9101 49.9452 22.7811 50.9092 22.7811C51.8732 22.7811 52.3022 21.9101 52.3022 21.0655Z"
      fill="#6B6D76"
    />
    <path
      d="M54.0332 16.769H55.2091V19.4507H58.2811V16.769H59.4623V23.5312H58.2811V20.4589H55.2091V23.5312H54.0332V16.769Z"
      fill="#6B6D76"
    />
    <path
      d="M61.2947 21.261C61.2947 22.3168 62.0627 22.7074 63.0002 22.7074C64.0595 22.7074 64.425 22.1796 64.425 21.6992C64.4345 21.5216 64.3845 21.3459 64.2828 21.1997C64.1812 21.0535 64.0337 20.9451 63.8636 20.8915C63.3975 20.7121 62.7725 20.5906 61.8508 20.332C60.7015 20.0153 60.3519 19.3237 60.3519 18.6322C60.3519 17.2756 61.5913 16.658 62.8201 16.658C64.2237 16.658 65.4049 17.397 65.4049 18.7959H64.2396C64.1814 17.9196 63.5881 17.6029 62.7884 17.6029C62.2587 17.6029 61.5489 17.8035 61.5489 18.4791C61.5489 18.9489 61.8667 19.2182 62.3487 19.3554L64.2873 19.8358C64.6633 19.9411 64.9948 20.1654 65.2317 20.4748C65.4686 20.7843 65.5982 21.1621 65.6009 21.5514C65.6009 23.0611 64.2555 23.6629 62.9102 23.6629C61.3636 23.6629 60.1241 22.9239 60.0977 21.2663H61.2788L61.2947 21.261Z"
      fill="#6B6D76"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M89.0923 22.8993C88.9625 22.9093 88.8321 22.9093 88.7023 22.8993C87.0819 22.8523 85.5432 22.1512 84.4131 20.9453C83.283 19.7394 82.6508 18.1236 82.6508 16.4415C82.6508 14.7594 83.283 13.1437 84.4131 11.9377C85.5432 10.7318 87.0819 10.0308 88.7023 9.98369H89.0923V7.51489C88.9509 7.51489 88.8144 7.51489 88.673 7.51489C86.3757 7.51623 84.1727 8.46278 82.5469 10.147C80.921 11.8313 80.0052 14.1158 80 16.4997C80 21.4727 83.7295 25.3276 88.673 25.4997C88.8144 25.4997 88.9509 25.4997 89.1069 25.4997L89.0923 22.8993Z"
      fill="#6B6D76"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M103.971 22.8991C103.843 22.9092 103.714 22.9092 103.586 22.8991C102.083 22.9029 100.629 22.3411 99.4942 21.3179C98.3594 20.2948 97.6204 18.8795 97.414 17.3342H102.333V14.7946H97.5506C98.4281 11.8604 100.437 9.99866 103.596 9.99866C103.727 9.99866 103.854 9.99866 103.986 9.99866V7.49951C103.844 7.49951 103.708 7.49951 103.567 7.49951C101.266 7.49951 99.0603 8.44772 97.4338 10.1355C95.8073 11.8234 94.8936 14.1125 94.8936 16.4995C94.8936 18.8864 95.8073 21.1756 97.4338 22.8634C99.0603 24.5512 101.266 25.4995 103.567 25.4995C103.708 25.4995 103.844 25.4995 104 25.4995L103.971 22.8991Z"
      fill="#6B6D76"
    />
    <path
      d="M128.575 20.2476V25.9576H124.04C124.04 25.9576 122.253 25.777 121.648 24.749C121.044 23.7209 118.295 18.8931 118.295 18.8931C118.933 19.6472 119.833 20.1247 120.81 20.2268C121.394 20.3657 128.575 20.2476 128.575 20.2476Z"
      fill="#6B6D76"
    />
    <path
      d="M118 17.2051C118 17.2051 118.041 20.3033 122.81 19.8656C123.284 19.0529 124.872 16.4549 124.872 16.4549L126.383 17.2468L123.731 12.3843H118.234L119.787 13.5304L118 17.2051Z"
      fill="#6B6D76"
    />
    <path
      d="M126.989 12.3288L122.179 9.37658L124.515 5.44487C124.515 5.44487 125.573 4 126.769 4C127.965 4 133.462 4.11809 133.462 4.11809C132.493 4.27176 131.624 4.80606 131.043 5.60464C130.583 6.06311 126.989 12.3288 126.989 12.3288Z"
      fill="#6B6D76"
    />
    <path
      d="M134.995 4.7572C134.995 4.7572 132.35 3.1873 130.268 7.5358C130.721 8.34854 132.095 11.0646 132.095 11.0646L130.639 11.9815L136.177 12.2177L139.022 7.45244L137.235 8.20961L134.995 4.7572Z"
      fill="#6B6D76"
    />
    <path
      d="M134.484 14.9961L139.391 12.155L141.624 16.1423C141.624 16.1423 142.352 17.7886 141.782 18.8445C141.212 19.9004 138.387 24.7212 138.387 24.7212C138.724 23.7931 138.689 22.769 138.291 21.8662C138.154 21.248 134.484 14.9961 134.484 14.9961Z"
      fill="#6B6D76"
    />
    <path
      d="M137.137 25.756C137.137 25.756 139.783 24.1722 137.034 20.1988C136.113 20.1988 133.11 20.0807 133.11 20.0807L133.035 18.3511L130.142 23.1372L132.89 27.9997L133.103 26.0547L137.137 25.756Z"
      fill="#6B6D76"
    />
    <path
      d="M169.668 5.31639H168.097V5.59978H169.668V5.31639ZM165.161 6.10495C164.938 6.21882 164.751 6.39616 164.622 6.61628H165.161V6.10495ZM173.345 8.5692L172.752 9.18526L172.716 9.50561H173.428V8.5692H173.345ZM168.008 13.6024L164.948 10.2449L165.452 16.3316L168.008 13.6024ZM168.601 13.6024L171.53 16.8244L172.123 10.0477H172.07V9.91221L168.601 13.6024ZM164.877 9.52409L168.316 13.2882L170.332 11.1443H167.468V9.99846H170.789V10.6145L172.094 9.22838V8.06403H172.331L172.408 7.21386H164.699L164.877 9.52409ZM173.179 19.2517C173.188 19.3377 173.188 19.4244 173.179 19.5105C173.18 19.7226 173.142 19.9331 173.064 20.1296C172.987 20.3261 172.874 20.5048 172.73 20.6554C172.586 20.806 172.415 20.9256 172.226 21.0071C172.038 21.0887 171.835 21.1307 171.631 21.1307C171.347 21.1306 171.069 21.0503 170.825 20.8984C170.582 20.7465 170.383 20.5286 170.249 20.2682H166.442V21.1122H165.44V20.2867C165.381 20.2761 165.326 20.2468 165.284 20.2026C165.241 20.1585 165.213 20.1018 165.203 20.0403L164.966 17.4405L159.629 23.0713L159.302 22.7509L164.877 16.8552L164.284 9.59186L159 3.7516V3.13553L164.248 8.87107L164.106 7.19538H163.465V6.63476H164.058C164.058 6.5978 164.058 6.567 164.094 6.53003C164.319 6.06104 164.707 5.69791 165.179 5.51353V5.12541H166.11V5.1747C166.59 5.06836 167.078 5.00447 167.569 4.98372V4.75578H170.226V6.14191H167.569V5.52585C167.073 5.55815 166.581 5.63441 166.098 5.7538V6.61628H172.408C172.153 6.00022 171.222 5.73531 170.243 5.59978V4.98372C171.204 5.10693 172.189 5.39032 172.681 5.9879C172.757 5.88892 172.857 5.81152 172.97 5.76284C173.082 5.71415 173.205 5.69572 173.327 5.70925C173.448 5.72279 173.565 5.76784 173.665 5.84028C173.766 5.91272 173.847 6.01022 173.902 6.12382C173.956 6.23741 173.983 6.36346 173.978 6.49038C173.974 6.6173 173.939 6.74102 173.876 6.85017C173.813 6.95931 173.726 7.05038 173.62 7.11501C173.515 7.17964 173.396 7.21575 173.274 7.22002C173.175 7.2192 173.077 7.20258 172.983 7.17074L172.9 8.03322H173.256L178 3V3.61606L173.849 7.99626H173.932V9.94917H172.698L172.034 17.2865L176.897 22.6216L176.577 22.9358L173.179 19.2517ZM170.077 19.5289C170.075 19.1333 170.214 18.7508 170.467 18.4551C170.72 18.1593 171.069 17.9713 171.447 17.9272L171.501 17.4343L168.316 13.9351L165.488 16.923L165.725 19.7384H170.095C170.089 19.6687 170.089 19.5986 170.095 19.5289H170.077ZM170.825 19.5289C170.825 19.6959 170.872 19.859 170.962 19.9978C171.051 20.1366 171.178 20.2448 171.326 20.3087C171.475 20.3726 171.638 20.3893 171.796 20.3567C171.953 20.3242 172.098 20.2438 172.211 20.1257C172.325 20.0077 172.402 19.8573 172.434 19.6936C172.465 19.5299 172.449 19.3602 172.388 19.2059C172.326 19.0517 172.222 18.9199 172.088 18.8272C171.955 18.7344 171.798 18.6849 171.637 18.6849C171.422 18.6849 171.215 18.7738 171.063 18.9321C170.91 19.0904 170.825 19.3051 170.825 19.5289ZM171.109 19.5289C171.109 19.4205 171.14 19.3145 171.198 19.2243C171.256 19.1341 171.339 19.0639 171.435 19.0224C171.531 18.9809 171.638 18.97 171.74 18.9912C171.842 19.0123 171.936 19.0645 172.01 19.1412C172.084 19.2179 172.134 19.3156 172.155 19.422C172.175 19.5283 172.165 19.6386 172.125 19.7388C172.085 19.8389 172.017 19.9246 171.93 19.9848C171.843 20.0451 171.741 20.0772 171.637 20.0772C171.567 20.0781 171.498 20.0644 171.434 20.0372C171.37 20.0099 171.311 19.9696 171.262 19.9185C171.213 19.8674 171.174 19.8066 171.148 19.7397C171.122 19.6728 171.108 19.6012 171.109 19.5289ZM160.548 25L176.54 25V29L160.548 29V25Z"
      fill="#6B6D76"
    />
    <g clip-path="url(#clip0_16290_803984)">
      <path
        d="M215.412 20.9881C213.93 22.3076 211.922 23.0475 209.83 23.0451C207.737 23.0427 205.731 22.2982 204.253 20.9753C202.775 19.6524 201.947 17.8595 201.949 15.9911C201.952 14.1227 202.786 12.3318 204.268 11.0123C204.999 10.3575 205.867 9.83801 206.823 9.48353C207.779 9.12905 208.804 8.94658 209.84 8.94658C210.875 8.94658 211.9 9.12905 212.856 9.48353C213.813 9.83801 214.681 10.3575 215.412 11.0123C215.718 11.2882 215.998 11.5856 216.251 11.9016L218 10.7466C217.072 9.5878 215.847 8.64343 214.428 7.99184C213.009 7.34025 211.436 7.00023 209.84 7C204.65 7 200.382 10.5194 199.844 15.0374H196.024V9.14971H200.78L202.508 7H194V25L196.024 23.6714V16.9639H199.844C200.382 21.481 204.65 25 209.84 25C211.436 25.0003 213.009 24.6605 214.428 24.009C215.848 23.3574 217.072 22.4129 218 21.2539L216.251 20.0967C215.999 20.4135 215.718 20.7116 215.412 20.9881Z"
        fill="#6B6D76"
      />
      <path
        d="M209.841 12.7694C210.427 12.7707 211.003 12.8991 211.521 13.1436C212.038 13.3881 212.482 13.7414 212.812 14.173L214.563 13.0158C214.031 12.3388 213.324 11.7861 212.502 11.4045C211.68 11.0228 210.768 10.8235 209.841 10.8232C206.647 10.8232 204.059 13.1405 204.059 16C204.059 18.8594 206.647 21.175 209.841 21.1758C210.768 21.1758 211.68 20.9766 212.502 20.5951C213.324 20.2135 214.031 19.6608 214.563 18.9837L212.812 17.8265C212.459 18.2828 211.98 18.6499 211.421 18.8924C210.862 19.1349 210.243 19.2446 209.623 19.2108C209.003 19.1771 208.403 19.001 207.881 18.6996C207.36 18.3983 206.934 17.9819 206.645 17.4906C206.357 16.9994 206.215 16.45 206.234 15.8956C206.252 15.3411 206.431 14.8003 206.753 14.3256C207.074 13.8509 207.527 13.4582 208.068 13.1856C208.609 12.913 209.22 12.7696 209.841 12.7694Z"
        fill="#6B6D76"
      />
    </g>
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M232.808 6C232.362 6 232 6.3616 232 6.80766V25.3839C232 25.8299 232.362 26.1915 232.808 26.1915H233.615C234.061 26.1915 234.423 25.8299 234.423 25.3839V6.80766C234.423 6.3616 234.061 6 233.615 6H232.808ZM255.856 22.1136C256.122 21.7555 256.005 21.2549 255.626 21.0185L254.973 20.61C254.595 20.3736 254.099 20.4917 253.825 20.8432C252.975 21.9304 251.846 22.7738 250.551 23.2787C249.005 23.8817 247.305 23.9696 245.704 23.5291C244.104 23.0886 242.688 22.1434 241.668 20.834C240.648 19.5245 240.078 17.9208 240.042 16.2612C240.006 14.6017 240.507 12.975 241.47 11.6229C242.433 10.2709 243.807 9.26581 245.387 8.75707C246.967 8.24833 248.669 8.26313 250.24 8.79927C251.555 9.24812 252.72 10.0423 253.615 11.092C253.905 11.4314 254.405 11.5282 254.772 11.2758L255.408 10.8396C255.776 10.5872 255.872 10.082 255.591 9.73561C254.398 8.26564 252.812 7.15595 251.011 6.5411C248.954 5.83904 246.725 5.81966 244.656 6.48585C242.587 7.15203 240.788 8.46821 239.527 10.2387C238.266 12.0091 237.61 14.1393 237.657 16.3124C237.703 18.4856 238.45 20.5856 239.786 22.3004C241.122 24.0151 242.975 25.2528 245.071 25.8296C247.167 26.4064 249.393 26.2914 251.418 25.5017C253.191 24.8101 254.728 23.6334 255.856 22.1136Z"
      fill="#6B6D76"
    />
  </svg>
);

export const ComplianceImageT = () => (
  <svg width="260" height="70" viewBox="0 0 260 70" fill="none" xmlns="http://www.w3.org/2000/svg">
    <ComplianceImage />
    <JapaneseTelecomLogo />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M49 48H37V60H49V48ZM37 47H36V48V60V61H37H49H50V60V48V47H49H37Z"
      fill="#5A5C61"
    />
    <mask id="path-32-inside-1_16290_803984" fill="white">
      <path d="M40 50.8594V50H46V50.8594H43.4844V58H42.5156V50.8594H40Z" />
    </mask>
    <path
      d="M40 50.8594H39V51.8594H40V50.8594ZM40 50V49H39V50H40ZM46 50H47V49H46V50ZM46 50.8594V51.8594H47V50.8594H46ZM43.4844 50.8594V49.8594H42.4844V50.8594H43.4844ZM43.4844 58V59H44.4844V58H43.4844ZM42.5156 58H41.5156V59H42.5156V58ZM42.5156 50.8594H43.5156V49.8594H42.5156V50.8594ZM41 50.8594V50H39V50.8594H41ZM40 51H46V49H40V51ZM45 50V50.8594H47V50H45ZM46 49.8594H43.4844V51.8594H46V49.8594ZM42.4844 50.8594V58H44.4844V50.8594H42.4844ZM43.4844 57H42.5156V59H43.4844V57ZM43.5156 58V50.8594H41.5156V58H43.5156ZM42.5156 49.8594H40V51.8594H42.5156V49.8594Z"
      fill="#5A5C61"
      mask="url(#path-32-inside-1_16290_803984)"
    />
    <path
      d="M60.75 58.5H58.0568V49.7727H60.8693C61.7159 49.7727 62.4403 49.9474 63.0426 50.2969C63.6449 50.6435 64.1065 51.142 64.4276 51.7926C64.7486 52.4403 64.9091 53.2159 64.9091 54.1193C64.9091 55.0284 64.7472 55.8111 64.4233 56.4673C64.0994 57.1207 63.6278 57.6236 63.0085 57.9759C62.3892 58.3253 61.6364 58.5 60.75 58.5ZM59.1136 57.5625H60.6818C61.4034 57.5625 62.0014 57.4233 62.4759 57.1449C62.9503 56.8665 63.304 56.4702 63.5369 55.956C63.7699 55.4418 63.8864 54.8295 63.8864 54.1193C63.8864 53.4148 63.7713 52.8082 63.5412 52.2997C63.3111 51.7884 62.9673 51.3963 62.5099 51.1236C62.0526 50.848 61.483 50.7102 60.8011 50.7102H59.1136V57.5625ZM72.9716 49.7727V58.5H71.9148V50.8807H71.8636L69.733 52.2955V51.2216L71.9148 49.7727H72.9716ZM78.3793 58.6193C78.0213 58.6136 77.6634 58.5455 77.3054 58.4148C76.9474 58.2841 76.6207 58.0639 76.3253 57.7543C76.0298 57.4418 75.7926 57.0199 75.6136 56.4886C75.4347 55.9545 75.3452 55.2841 75.3452 54.4773C75.3452 53.7045 75.4176 53.0199 75.5625 52.4233C75.7074 51.8239 75.9176 51.3196 76.1932 50.9105C76.4688 50.4986 76.8011 50.1861 77.1903 49.973C77.5824 49.7599 78.0241 49.6534 78.5156 49.6534C79.0043 49.6534 79.4389 49.7514 79.8196 49.9474C80.2031 50.1406 80.5156 50.4105 80.7571 50.7571C80.9986 51.1037 81.1548 51.5028 81.2259 51.9545H80.1861C80.0895 51.5625 79.902 51.2372 79.6236 50.9787C79.3452 50.7202 78.9759 50.5909 78.5156 50.5909C77.8395 50.5909 77.3068 50.8849 76.9176 51.473C76.5313 52.0611 76.3366 52.8864 76.3338 53.9489H76.402C76.5611 53.7074 76.75 53.5014 76.9688 53.331C77.1903 53.1577 77.4347 53.0241 77.7017 52.9304C77.9688 52.8366 78.2514 52.7898 78.5497 52.7898C79.0497 52.7898 79.5071 52.9148 79.9219 53.1648C80.3366 53.4119 80.669 53.7543 80.919 54.1918C81.169 54.6264 81.294 55.125 81.294 55.6875C81.294 56.2273 81.1733 56.7216 80.9318 57.1705C80.6903 57.6165 80.3509 57.9716 79.9134 58.2358C79.4787 58.4972 78.9673 58.625 78.3793 58.6193ZM78.3793 57.6818C78.7372 57.6818 79.0582 57.5923 79.3423 57.4134C79.6293 57.2344 79.8551 56.9943 80.0199 56.6932C80.1875 56.392 80.2713 56.0568 80.2713 55.6875C80.2713 55.3267 80.1903 54.9986 80.0284 54.7031C79.8693 54.4048 79.6491 54.1676 79.3679 53.9915C79.0895 53.8153 78.7713 53.7273 78.4134 53.7273C78.1435 53.7273 77.892 53.7812 77.6591 53.8892C77.4261 53.9943 77.2216 54.1392 77.0455 54.3239C76.8722 54.5085 76.7358 54.7202 76.6364 54.9588C76.5369 55.1946 76.4872 55.4432 76.4872 55.7045C76.4872 56.0511 76.5682 56.375 76.7301 56.6761C76.8949 56.9773 77.1193 57.2202 77.4034 57.4048C77.6903 57.5895 78.0156 57.6818 78.3793 57.6818ZM86.7369 53.6676V54.6051H82.9187V53.6676H86.7369ZM91.3359 58.6193C90.6939 58.6193 90.147 58.4446 89.6953 58.0952C89.2436 57.7429 88.8984 57.233 88.6598 56.5653C88.4212 55.8949 88.3018 55.0852 88.3018 54.1364C88.3018 53.1932 88.4212 52.3878 88.6598 51.7202C88.9013 51.0497 89.2479 50.5384 89.6996 50.1861C90.1541 49.831 90.6996 49.6534 91.3359 49.6534C91.9723 49.6534 92.5163 49.831 92.968 50.1861C93.4226 50.5384 93.7692 51.0497 94.0078 51.7202C94.2493 52.3878 94.37 53.1932 94.37 54.1364C94.37 55.0852 94.2507 55.8949 94.0121 56.5653C93.7734 57.233 93.4283 57.7429 92.9766 58.0952C92.5249 58.4446 91.978 58.6193 91.3359 58.6193ZM91.3359 57.6818C91.9723 57.6818 92.4666 57.375 92.8189 56.7614C93.1712 56.1477 93.3473 55.2727 93.3473 54.1364C93.3473 53.3807 93.2663 52.7372 93.1044 52.206C92.9453 51.6747 92.7152 51.2699 92.4141 50.9915C92.1158 50.7131 91.7564 50.5739 91.3359 50.5739C90.7053 50.5739 90.2124 50.8849 89.8572 51.5071C89.5021 52.1264 89.3246 53.0028 89.3246 54.1364C89.3246 54.892 89.4041 55.5341 89.5632 56.0625C89.7223 56.5909 89.951 56.9929 90.2493 57.2685C90.5504 57.544 90.9126 57.6818 91.3359 57.6818ZM98.8359 58.6193C98.1939 58.6193 97.647 58.4446 97.1953 58.0952C96.7436 57.7429 96.3984 57.233 96.1598 56.5653C95.9212 55.8949 95.8018 55.0852 95.8018 54.1364C95.8018 53.1932 95.9212 52.3878 96.1598 51.7202C96.4013 51.0497 96.7479 50.5384 97.1996 50.1861C97.6541 49.831 98.1996 49.6534 98.8359 49.6534C99.4723 49.6534 100.016 49.831 100.468 50.1861C100.923 50.5384 101.269 51.0497 101.508 51.7202C101.749 52.3878 101.87 53.1932 101.87 54.1364C101.87 55.0852 101.751 55.8949 101.512 56.5653C101.273 57.233 100.928 57.7429 100.477 58.0952C100.025 58.4446 99.478 58.6193 98.8359 58.6193ZM98.8359 57.6818C99.4723 57.6818 99.9666 57.375 100.319 56.7614C100.671 56.1477 100.847 55.2727 100.847 54.1364C100.847 53.3807 100.766 52.7372 100.604 52.206C100.445 51.6747 100.215 51.2699 99.9141 50.9915C99.6158 50.7131 99.2564 50.5739 98.8359 50.5739C98.2053 50.5739 97.7124 50.8849 97.3572 51.5071C97.0021 52.1264 96.8246 53.0028 96.8246 54.1364C96.8246 54.892 96.9041 55.5341 97.0632 56.0625C97.2223 56.5909 97.451 56.9929 97.7493 57.2685C98.0504 57.544 98.4126 57.6818 98.8359 57.6818ZM106.558 49.7727V58.5H105.501V50.8807H105.45L103.319 52.2955V51.2216L105.501 49.7727H106.558ZM111.863 58.6193C111.278 58.6193 110.761 58.5156 110.312 58.3082C109.866 58.098 109.518 57.8097 109.268 57.4432C109.018 57.0739 108.894 56.6534 108.897 56.1818C108.894 55.8125 108.967 55.4716 109.114 55.1591C109.262 54.8437 109.464 54.581 109.719 54.3707C109.978 54.1577 110.266 54.0227 110.585 53.9659V53.9148C110.167 53.8068 109.835 53.5724 109.587 53.2116C109.34 52.848 109.218 52.4347 109.221 51.9716C109.218 51.5284 109.33 51.1321 109.558 50.7827C109.785 50.4332 110.097 50.1577 110.495 49.956C110.896 49.7543 111.352 49.6534 111.863 49.6534C112.369 49.6534 112.82 49.7543 113.218 49.956C113.616 50.1577 113.928 50.4332 114.156 50.7827C114.386 51.1321 114.502 51.5284 114.505 51.9716C114.502 52.4347 114.376 52.848 114.126 53.2116C113.879 53.5724 113.55 53.8068 113.141 53.9148V53.9659C113.457 54.0227 113.741 54.1577 113.994 54.3707C114.246 54.581 114.448 54.8437 114.599 55.1591C114.749 55.4716 114.826 55.8125 114.829 56.1818C114.826 56.6534 114.698 57.0739 114.445 57.4432C114.195 57.8097 113.847 58.098 113.401 58.3082C112.958 58.5156 112.445 58.6193 111.863 58.6193ZM111.863 57.6818C112.258 57.6818 112.599 57.6179 112.886 57.4901C113.173 57.3622 113.394 57.1818 113.55 56.9489C113.707 56.7159 113.786 56.4432 113.789 56.1307C113.786 55.8011 113.701 55.5099 113.533 55.2571C113.366 55.0043 113.137 54.8054 112.847 54.6605C112.56 54.5156 112.232 54.4432 111.863 54.4432C111.491 54.4432 111.158 54.5156 110.866 54.6605C110.576 54.8054 110.347 55.0043 110.18 55.2571C110.015 55.5099 109.934 55.8011 109.937 56.1307C109.934 56.4432 110.009 56.7159 110.163 56.9489C110.319 57.1818 110.542 57.3622 110.832 57.4901C111.121 57.6179 111.465 57.6818 111.863 57.6818ZM111.863 53.5398C112.175 53.5398 112.452 53.4773 112.694 53.3523C112.938 53.2273 113.13 53.0526 113.269 52.8281C113.408 52.6037 113.479 52.3409 113.482 52.0398C113.479 51.7443 113.41 51.4872 113.273 51.2685C113.137 51.0469 112.948 50.8764 112.707 50.7571C112.465 50.6349 112.184 50.5739 111.863 50.5739C111.536 50.5739 111.251 50.6349 111.006 50.7571C110.762 50.8764 110.573 51.0469 110.44 51.2685C110.306 51.4872 110.241 51.7443 110.244 52.0398C110.241 52.3409 110.308 52.6037 110.444 52.8281C110.583 53.0526 110.775 53.2273 111.019 53.3523C111.263 53.4773 111.545 53.5398 111.863 53.5398ZM119.837 58.5V57.733L122.718 54.5795C123.056 54.2102 123.334 53.8892 123.553 53.6165C123.772 53.3409 123.934 53.0824 124.039 52.8409C124.147 52.5966 124.201 52.3409 124.201 52.0739C124.201 51.767 124.127 51.5014 123.979 51.277C123.834 51.0526 123.635 50.8793 123.382 50.7571C123.13 50.6349 122.846 50.5739 122.53 50.5739C122.195 50.5739 121.902 50.6435 121.652 50.7827C121.405 50.919 121.213 51.1108 121.077 51.358C120.944 51.6051 120.877 51.8949 120.877 52.2273H119.871C119.871 51.7159 119.989 51.267 120.225 50.8807C120.461 50.4943 120.782 50.1932 121.188 49.9773C121.597 49.7614 122.056 49.6534 122.564 49.6534C123.076 49.6534 123.529 49.7614 123.924 49.9773C124.319 50.1932 124.628 50.4844 124.853 50.8509C125.077 51.2173 125.189 51.625 125.189 52.0739C125.189 52.3949 125.131 52.7088 125.015 53.0156C124.901 53.3196 124.702 53.6591 124.418 54.0341C124.137 54.4062 123.746 54.8608 123.246 55.3977L121.286 57.4943V57.5625H125.343V58.5H119.837ZM129.949 58.6193C129.307 58.6193 128.76 58.4446 128.309 58.0952C127.857 57.7429 127.512 57.233 127.273 56.5653C127.034 55.8949 126.915 55.0852 126.915 54.1364C126.915 53.1932 127.034 52.3878 127.273 51.7202C127.515 51.0497 127.861 50.5384 128.313 50.1861C128.767 49.831 129.313 49.6534 129.949 49.6534C130.586 49.6534 131.13 49.831 131.581 50.1861C132.036 50.5384 132.382 51.0497 132.621 51.7202C132.863 52.3878 132.983 53.1932 132.983 54.1364C132.983 55.0852 132.864 55.8949 132.625 56.5653C132.387 57.233 132.042 57.7429 131.59 58.0952C131.138 58.4446 130.591 58.6193 129.949 58.6193ZM129.949 57.6818C130.586 57.6818 131.08 57.375 131.432 56.7614C131.784 56.1477 131.961 55.2727 131.961 54.1364C131.961 53.3807 131.88 52.7372 131.718 52.206C131.559 51.6747 131.328 51.2699 131.027 50.9915C130.729 50.7131 130.37 50.5739 129.949 50.5739C129.319 50.5739 128.826 50.8849 128.471 51.5071C128.115 52.1264 127.938 53.0028 127.938 54.1364C127.938 54.892 128.017 55.5341 128.176 56.0625C128.336 56.5909 128.564 56.9929 128.863 57.2685C129.164 57.544 129.526 57.6818 129.949 57.6818ZM134.603 58.5V57.733L137.483 54.5795C137.821 54.2102 138.1 53.8892 138.319 53.6165C138.537 53.3409 138.699 53.0824 138.804 52.8409C138.912 52.5966 138.966 52.3409 138.966 52.0739C138.966 51.767 138.892 51.5014 138.745 51.277C138.6 51.0526 138.401 50.8793 138.148 50.7571C137.895 50.6349 137.611 50.5739 137.296 50.5739C136.961 50.5739 136.668 50.6435 136.418 50.7827C136.171 50.919 135.979 51.1108 135.843 51.358C135.709 51.6051 135.642 51.8949 135.642 52.2273H134.637C134.637 51.7159 134.755 51.267 134.99 50.8807C135.226 50.4943 135.547 50.1932 135.953 49.9773C136.363 49.7614 136.821 49.6534 137.33 49.6534C137.841 49.6534 138.294 49.7614 138.689 49.9773C139.084 50.1932 139.394 50.4844 139.618 50.8509C139.843 51.2173 139.955 51.625 139.955 52.0739C139.955 52.3949 139.897 52.7088 139.78 53.0156C139.667 53.3196 139.468 53.6591 139.184 54.0341C138.902 54.4062 138.512 54.8608 138.012 55.3977L136.051 57.4943V57.5625H140.108V58.5H134.603Z"
      fill="#6B6D76"
    />
  </svg>
);

export const ComplianceImageR: FC<ComplianceImageProps> = ({ model }) => {
  const LogoR = () => (
    <svg>
      <rect x="36.5" y="47.5" width="13" height="13" stroke="#5A5C61" />
      <path
        d="M40.0568 58V49.2727H43.0057C43.6875 49.2727 44.2472 49.3892 44.6847 49.6222C45.1222 49.8523 45.446 50.169 45.6562 50.5724C45.8665 50.9759 45.9716 51.4347 45.9716 51.9489C45.9716 52.4631 45.8665 52.919 45.6562 53.3168C45.446 53.7145 45.1236 54.027 44.6889 54.2543C44.2543 54.4787 43.6989 54.5909 43.0227 54.5909H40.6364V53.6364H42.9886C43.4545 53.6364 43.8295 53.5682 44.1136 53.4318C44.4006 53.2955 44.608 53.1023 44.7358 52.8523C44.8665 52.5994 44.9318 52.2983 44.9318 51.9489C44.9318 51.5994 44.8665 51.294 44.7358 51.0327C44.6051 50.7713 44.3963 50.5696 44.1094 50.4276C43.8224 50.2827 43.4432 50.2102 42.9716 50.2102H41.1136V58H40.0568ZM44.1648 54.0795L46.3125 58H45.0852L42.9716 54.0795H44.1648Z"
        fill="#5A5C61"
      />
    </svg>
  );

  switch (model) {
    case DeviceModel.UCKG2:
      return (
        <svg width="260" height="70" viewBox="0 0 260 70" fill="none" xmlns="http://www.w3.org/2000/svg">
          <ComplianceImage />
          <JapaneseTelecomLogo />
          <LogoR />
          <path
            d="M56.9034 58.5V57.733L59.7841 54.5795C60.1222 54.2102 60.4006 53.8892 60.6193 53.6165C60.8381 53.3409 61 53.0824 61.1051 52.8409C61.2131 52.5966 61.267 52.3409 61.267 52.0739C61.267 51.767 61.1932 51.5014 61.0455 51.277C60.9006 51.0526 60.7017 50.8793 60.4489 50.7571C60.196 50.6349 59.9119 50.5739 59.5966 50.5739C59.2614 50.5739 58.9688 50.6435 58.7188 50.7827C58.4716 50.919 58.2798 51.1108 58.1435 51.358C58.0099 51.6051 57.9432 51.8949 57.9432 52.2273H56.9375C56.9375 51.7159 57.0554 51.267 57.2912 50.8807C57.527 50.4943 57.848 50.1932 58.2543 49.9773C58.6634 49.7614 59.1222 49.6534 59.6307 49.6534C60.142 49.6534 60.5952 49.7614 60.9901 49.9773C61.3849 50.1932 61.6946 50.4844 61.919 50.8509C62.1435 51.2173 62.2557 51.625 62.2557 52.0739C62.2557 52.3949 62.1974 52.7088 62.081 53.0156C61.9673 53.3196 61.7685 53.6591 61.4844 54.0341C61.2031 54.4062 60.8125 54.8608 60.3125 55.3977L58.3523 57.4943V57.5625H62.4091V58.5H56.9034ZM67.0156 58.6193C66.3736 58.6193 65.8267 58.4446 65.375 58.0952C64.9233 57.7429 64.5781 57.233 64.3395 56.5653C64.1009 55.8949 63.9815 55.0852 63.9815 54.1364C63.9815 53.1932 64.1009 52.3878 64.3395 51.7202C64.581 51.0497 64.9276 50.5384 65.3793 50.1861C65.8338 49.831 66.3793 49.6534 67.0156 49.6534C67.652 49.6534 68.196 49.831 68.6477 50.1861C69.1023 50.5384 69.4489 51.0497 69.6875 51.7202C69.929 52.3878 70.0497 53.1932 70.0497 54.1364C70.0497 55.0852 69.9304 55.8949 69.6918 56.5653C69.4531 57.233 69.108 57.7429 68.6562 58.0952C68.2045 58.4446 67.6577 58.6193 67.0156 58.6193ZM67.0156 57.6818C67.652 57.6818 68.1463 57.375 68.4986 56.7614C68.8509 56.1477 69.027 55.2727 69.027 54.1364C69.027 53.3807 68.946 52.7372 68.7841 52.206C68.625 51.6747 68.3949 51.2699 68.0938 50.9915C67.7955 50.7131 67.4361 50.5739 67.0156 50.5739C66.3849 50.5739 65.892 50.8849 65.5369 51.5071C65.1818 52.1264 65.0043 53.0028 65.0043 54.1364C65.0043 54.892 65.0838 55.5341 65.2429 56.0625C65.402 56.5909 65.6307 56.9929 65.929 57.2685C66.2301 57.544 66.5923 57.6818 67.0156 57.6818ZM74.7372 49.7727V58.5H73.6804V50.8807H73.6293L71.4986 52.2955V51.2216L73.6804 49.7727H74.7372ZM81.0142 53.6676V54.6051H77.196V53.6676H81.0142ZM85.8349 49.7727V58.5H84.7781V50.8807H84.7269L82.5962 52.2955V51.2216L84.7781 49.7727H85.8349ZM91.1403 58.6193C90.555 58.6193 90.038 58.5156 89.5891 58.3082C89.1431 58.098 88.7951 57.8097 88.5451 57.4432C88.2951 57.0739 88.1715 56.6534 88.1744 56.1818C88.1715 55.8125 88.244 55.4716 88.3917 55.1591C88.5394 54.8437 88.7411 54.581 88.9968 54.3707C89.2553 54.1577 89.5437 54.0227 89.8619 53.9659V53.9148C89.4442 53.8068 89.1119 53.5724 88.8647 53.2116C88.6175 52.848 88.4954 52.4347 88.4982 51.9716C88.4954 51.5284 88.6076 51.1321 88.8349 50.7827C89.0621 50.4332 89.3746 50.1577 89.7724 49.956C90.1729 49.7543 90.6289 49.6534 91.1403 49.6534C91.646 49.6534 92.0977 49.7543 92.4954 49.956C92.8931 50.1577 93.2056 50.4332 93.4329 50.7827C93.663 51.1321 93.7795 51.5284 93.7823 51.9716C93.7795 52.4347 93.6531 52.848 93.4031 53.2116C93.1559 53.5724 92.8278 53.8068 92.4187 53.9148V53.9659C92.734 54.0227 93.0181 54.1577 93.271 54.3707C93.5238 54.581 93.7255 54.8437 93.8761 55.1591C94.0266 55.4716 94.1033 55.8125 94.1062 56.1818C94.1033 56.6534 93.9755 57.0739 93.7227 57.4432C93.4727 57.8097 93.1246 58.098 92.6786 58.3082C92.2354 58.5156 91.7227 58.6193 91.1403 58.6193ZM91.1403 57.6818C91.5352 57.6818 91.8761 57.6179 92.163 57.4901C92.4499 57.3622 92.6715 57.1818 92.8278 56.9489C92.984 56.7159 93.0636 56.4432 93.0664 56.1307C93.0636 55.8011 92.9783 55.5099 92.8107 55.2571C92.6431 55.0043 92.4144 54.8054 92.1246 54.6605C91.8377 54.5156 91.5096 54.4432 91.1403 54.4432C90.7681 54.4432 90.4357 54.5156 90.1431 54.6605C89.8533 54.8054 89.6246 55.0043 89.457 55.2571C89.2923 55.5099 89.2113 55.8011 89.2141 56.1307C89.2113 56.4432 89.2866 56.7159 89.44 56.9489C89.5962 57.1818 89.8192 57.3622 90.109 57.4901C90.3988 57.6179 90.7425 57.6818 91.1403 57.6818ZM91.1403 53.5398C91.4528 53.5398 91.7298 53.4773 91.9712 53.3523C92.2156 53.2273 92.4073 53.0526 92.5465 52.8281C92.6857 52.6037 92.7567 52.3409 92.7596 52.0398C92.7567 51.7443 92.6871 51.4872 92.5508 51.2685C92.4144 51.0469 92.2255 50.8764 91.984 50.7571C91.7425 50.6349 91.4613 50.5739 91.1403 50.5739C90.8136 50.5739 90.5281 50.6349 90.2837 50.7571C90.0394 50.8764 89.8505 51.0469 89.717 51.2685C89.5835 51.4872 89.5181 51.7443 89.521 52.0398C89.5181 52.3409 89.5849 52.6037 89.7212 52.8281C89.8604 53.0526 90.0522 53.2273 90.2965 53.3523C90.5408 53.4773 90.8221 53.5398 91.1403 53.5398ZM98.5859 58.6193C97.9439 58.6193 97.397 58.4446 96.9453 58.0952C96.4936 57.7429 96.1484 57.233 95.9098 56.5653C95.6712 55.8949 95.5518 55.0852 95.5518 54.1364C95.5518 53.1932 95.6712 52.3878 95.9098 51.7202C96.1513 51.0497 96.4979 50.5384 96.9496 50.1861C97.4041 49.831 97.9496 49.6534 98.5859 49.6534C99.2223 49.6534 99.7663 49.831 100.218 50.1861C100.673 50.5384 101.019 51.0497 101.258 51.7202C101.499 52.3878 101.62 53.1932 101.62 54.1364C101.62 55.0852 101.501 55.8949 101.262 56.5653C101.023 57.233 100.678 57.7429 100.227 58.0952C99.7749 58.4446 99.228 58.6193 98.5859 58.6193ZM98.5859 57.6818C99.2223 57.6818 99.7166 57.375 100.069 56.7614C100.421 56.1477 100.597 55.2727 100.597 54.1364C100.597 53.3807 100.516 52.7372 100.354 52.206C100.195 51.6747 99.9652 51.2699 99.6641 50.9915C99.3658 50.7131 99.0064 50.5739 98.5859 50.5739C97.9553 50.5739 97.4624 50.8849 97.1072 51.5071C96.7521 52.1264 96.5746 53.0028 96.5746 54.1364C96.5746 54.892 96.6541 55.5341 96.8132 56.0625C96.9723 56.5909 97.201 56.9929 97.4993 57.2685C97.8004 57.544 98.1626 57.6818 98.5859 57.6818ZM106.137 58.6193C105.779 58.6136 105.421 58.5455 105.063 58.4148C104.705 58.2841 104.379 58.0639 104.083 57.7543C103.788 57.4418 103.55 57.0199 103.371 56.4886C103.192 55.9545 103.103 55.2841 103.103 54.4773C103.103 53.7045 103.175 53.0199 103.32 52.4233C103.465 51.8239 103.675 51.3196 103.951 50.9105C104.227 50.4986 104.559 50.1861 104.948 49.973C105.34 49.7599 105.782 49.6534 106.273 49.6534C106.762 49.6534 107.197 49.7514 107.577 49.9474C107.961 50.1406 108.273 50.4105 108.515 50.7571C108.756 51.1037 108.913 51.5028 108.984 51.9545H107.944C107.847 51.5625 107.66 51.2372 107.381 50.9787C107.103 50.7202 106.734 50.5909 106.273 50.5909C105.597 50.5909 105.065 50.8849 104.675 51.473C104.289 52.0611 104.094 52.8864 104.092 53.9489H104.16C104.319 53.7074 104.508 53.5014 104.727 53.331C104.948 53.1577 105.192 53.0241 105.46 52.9304C105.727 52.8366 106.009 52.7898 106.308 52.7898C106.808 52.7898 107.265 52.9148 107.68 53.1648C108.094 53.4119 108.427 53.7543 108.677 54.1918C108.927 54.6264 109.052 55.125 109.052 55.6875C109.052 56.2273 108.931 56.7216 108.69 57.1705C108.448 57.6165 108.109 57.9716 107.671 58.2358C107.237 58.4972 106.725 58.625 106.137 58.6193ZM106.137 57.6818C106.495 57.6818 106.816 57.5923 107.1 57.4134C107.387 57.2344 107.613 56.9943 107.778 56.6932C107.945 56.392 108.029 56.0568 108.029 55.6875C108.029 55.3267 107.948 54.9986 107.786 54.7031C107.627 54.4048 107.407 54.1676 107.126 53.9915C106.847 53.8153 106.529 53.7273 106.171 53.7273C105.901 53.7273 105.65 53.7812 105.417 53.8892C105.184 53.9943 104.979 54.1392 104.803 54.3239C104.63 54.5085 104.494 54.7202 104.394 54.9588C104.295 55.1946 104.245 55.4432 104.245 55.7045C104.245 56.0511 104.326 56.375 104.488 56.6761C104.653 56.9773 104.877 57.2202 105.161 57.4048C105.448 57.5895 105.773 57.6818 106.137 57.6818ZM111 58.5L114.904 50.7784V50.7102H110.404V49.7727H115.995V50.7614L112.108 58.5H111ZM120.244 49.6534C120.602 49.6562 120.96 49.7244 121.318 49.858C121.676 49.9915 122.003 50.2131 122.298 50.5227C122.594 50.8295 122.831 51.2486 123.01 51.7798C123.189 52.3111 123.278 52.9773 123.278 53.7784C123.278 54.554 123.205 55.2429 123.057 55.8452C122.912 56.4446 122.702 56.9503 122.426 57.3622C122.153 57.7741 121.821 58.0866 121.429 58.2997C121.04 58.5128 120.599 58.6193 120.108 58.6193C119.619 58.6193 119.183 58.5227 118.8 58.3295C118.419 58.1335 118.107 57.8622 117.862 57.5156C117.621 57.1662 117.466 56.7614 117.398 56.3011H118.438C118.531 56.7017 118.717 57.0327 118.996 57.294C119.277 57.5526 119.648 57.6818 120.108 57.6818C120.781 57.6818 121.313 57.3878 121.702 56.7997C122.094 56.2116 122.29 55.3807 122.29 54.3068H122.222C122.063 54.5455 121.874 54.7514 121.655 54.9247C121.436 55.098 121.193 55.2315 120.926 55.3253C120.659 55.419 120.375 55.4659 120.074 55.4659C119.574 55.4659 119.115 55.3423 118.697 55.0952C118.283 54.8452 117.95 54.5028 117.7 54.0682C117.453 53.6307 117.33 53.1307 117.33 52.5682C117.33 52.0341 117.449 51.5455 117.688 51.1023C117.929 50.6562 118.267 50.3011 118.702 50.0369C119.139 49.7727 119.653 49.6449 120.244 49.6534ZM120.244 50.5909C119.886 50.5909 119.564 50.6804 119.277 50.8594C118.993 51.0355 118.767 51.2741 118.599 51.5753C118.435 51.8736 118.352 52.2045 118.352 52.5682C118.352 52.9318 118.432 53.2628 118.591 53.5611C118.753 53.8565 118.973 54.0923 119.251 54.2685C119.533 54.4418 119.852 54.5284 120.21 54.5284C120.48 54.5284 120.732 54.4759 120.964 54.3707C121.197 54.2628 121.401 54.1165 121.574 53.9318C121.75 53.7443 121.888 53.5327 121.987 53.2969C122.087 53.0582 122.136 52.8097 122.136 52.5511C122.136 52.2102 122.054 51.8906 121.889 51.5923C121.727 51.294 121.503 51.0526 121.216 50.8679C120.932 50.6832 120.608 50.5909 120.244 50.5909Z"
            fill="#6B6D76"
          />
        </svg>
      );
    case DeviceModel.UCKP:
      return (
        <svg width="260" height="70" viewBox="0 0 260 70" fill="none" xmlns="http://www.w3.org/2000/svg">
          <ComplianceImage />
          <JapaneseTelecomLogo />
          <LogoR />
          <path
            d="M56.9034 58.5V57.733L59.7841 54.5795C60.1222 54.2102 60.4006 53.8892 60.6193 53.6165C60.8381 53.3409 61 53.0824 61.1051 52.8409C61.2131 52.5966 61.267 52.3409 61.267 52.0739C61.267 51.767 61.1932 51.5014 61.0455 51.277C60.9006 51.0526 60.7017 50.8793 60.4489 50.7571C60.196 50.6349 59.9119 50.5739 59.5966 50.5739C59.2614 50.5739 58.9688 50.6435 58.7188 50.7827C58.4716 50.919 58.2798 51.1108 58.1435 51.358C58.0099 51.6051 57.9432 51.8949 57.9432 52.2273H56.9375C56.9375 51.7159 57.0554 51.267 57.2912 50.8807C57.527 50.4943 57.848 50.1932 58.2543 49.9773C58.6634 49.7614 59.1222 49.6534 59.6307 49.6534C60.142 49.6534 60.5952 49.7614 60.9901 49.9773C61.3849 50.1932 61.6946 50.4844 61.919 50.8509C62.1435 51.2173 62.2557 51.625 62.2557 52.0739C62.2557 52.3949 62.1974 52.7088 62.081 53.0156C61.9673 53.3196 61.7685 53.6591 61.4844 54.0341C61.2031 54.4062 60.8125 54.8608 60.3125 55.3977L58.3523 57.4943V57.5625H62.4091V58.5H56.9034ZM67.0156 58.6193C66.3736 58.6193 65.8267 58.4446 65.375 58.0952C64.9233 57.7429 64.5781 57.233 64.3395 56.5653C64.1009 55.8949 63.9815 55.0852 63.9815 54.1364C63.9815 53.1932 64.1009 52.3878 64.3395 51.7202C64.581 51.0497 64.9276 50.5384 65.3793 50.1861C65.8338 49.831 66.3793 49.6534 67.0156 49.6534C67.652 49.6534 68.196 49.831 68.6477 50.1861C69.1023 50.5384 69.4489 51.0497 69.6875 51.7202C69.929 52.3878 70.0497 53.1932 70.0497 54.1364C70.0497 55.0852 69.9304 55.8949 69.6918 56.5653C69.4531 57.233 69.108 57.7429 68.6562 58.0952C68.2045 58.4446 67.6577 58.6193 67.0156 58.6193ZM67.0156 57.6818C67.652 57.6818 68.1463 57.375 68.4986 56.7614C68.8509 56.1477 69.027 55.2727 69.027 54.1364C69.027 53.3807 68.946 52.7372 68.7841 52.206C68.625 51.6747 68.3949 51.2699 68.0938 50.9915C67.7955 50.7131 67.4361 50.5739 67.0156 50.5739C66.3849 50.5739 65.892 50.8849 65.5369 51.5071C65.1818 52.1264 65.0043 53.0028 65.0043 54.1364C65.0043 54.892 65.0838 55.5341 65.2429 56.0625C65.402 56.5909 65.6307 56.9929 65.929 57.2685C66.2301 57.544 66.5923 57.6818 67.0156 57.6818ZM74.7372 49.7727V58.5H73.6804V50.8807H73.6293L71.4986 52.2955V51.2216L73.6804 49.7727H74.7372ZM81.0142 53.6676V54.6051H77.196V53.6676H81.0142ZM85.8349 49.7727V58.5H84.7781V50.8807H84.7269L82.5962 52.2955V51.2216L84.7781 49.7727H85.8349ZM91.1232 49.6534C91.4812 49.6562 91.8391 49.7244 92.1971 49.858C92.555 49.9915 92.8817 50.2131 93.1772 50.5227C93.4727 50.8295 93.7099 51.2486 93.8888 51.7798C94.0678 52.3111 94.1573 52.9773 94.1573 53.7784C94.1573 54.554 94.0835 55.2429 93.9357 55.8452C93.7908 56.4446 93.5806 56.9503 93.305 57.3622C93.0323 57.7741 92.6999 58.0866 92.3079 58.2997C91.9187 58.5128 91.4783 58.6193 90.9869 58.6193C90.4982 58.6193 90.0621 58.5227 89.6786 58.3295C89.2979 58.1335 88.9854 57.8622 88.7411 57.5156C88.4996 57.1662 88.3448 56.7614 88.2766 56.3011H89.3164C89.4102 56.7017 89.5962 57.0327 89.8746 57.294C90.1559 57.5526 90.5266 57.6818 90.9869 57.6818C91.6602 57.6818 92.1914 57.3878 92.5806 56.7997C92.9727 56.2116 93.1687 55.3807 93.1687 54.3068H93.1005C92.9414 54.5455 92.7525 54.7514 92.5337 54.9247C92.315 55.098 92.0721 55.2315 91.805 55.3253C91.538 55.419 91.2539 55.4659 90.9528 55.4659C90.4528 55.4659 89.994 55.3423 89.5763 55.0952C89.1616 54.8452 88.8292 54.5028 88.5792 54.0682C88.332 53.6307 88.2085 53.1307 88.2085 52.5682C88.2085 52.0341 88.3278 51.5455 88.5664 51.1023C88.8079 50.6562 89.146 50.3011 89.5806 50.0369C90.0181 49.7727 90.5323 49.6449 91.1232 49.6534ZM91.1232 50.5909C90.7653 50.5909 90.4428 50.6804 90.1559 50.8594C89.8718 51.0355 89.646 51.2741 89.4783 51.5753C89.3136 51.8736 89.2312 52.2045 89.2312 52.5682C89.2312 52.9318 89.3107 53.2628 89.4698 53.5611C89.6317 53.8565 89.8519 54.0923 90.1303 54.2685C90.4116 54.4418 90.7312 54.5284 91.0891 54.5284C91.359 54.5284 91.6104 54.4759 91.8434 54.3707C92.0763 54.2628 92.2795 54.1165 92.4528 53.9318C92.6289 53.7443 92.7667 53.5327 92.8661 53.2969C92.9656 53.0582 93.0153 52.8097 93.0153 52.5511C93.0153 52.2102 92.9329 51.8906 92.7681 51.5923C92.6062 51.294 92.3817 51.0526 92.0948 50.8679C91.8107 50.6832 91.4869 50.5909 91.1232 50.5909ZM98.6797 58.6193C98.0376 58.6193 97.4908 58.4446 97.0391 58.0952C96.5874 57.7429 96.2422 57.233 96.0036 56.5653C95.7649 55.8949 95.6456 55.0852 95.6456 54.1364C95.6456 53.1932 95.7649 52.3878 96.0036 51.7202C96.245 51.0497 96.5916 50.5384 97.0433 50.1861C97.4979 49.831 98.0433 49.6534 98.6797 49.6534C99.3161 49.6534 99.8601 49.831 100.312 50.1861C100.766 50.5384 101.113 51.0497 101.352 51.7202C101.593 52.3878 101.714 53.1932 101.714 54.1364C101.714 55.0852 101.594 55.8949 101.356 56.5653C101.117 57.233 100.772 57.7429 100.32 58.0952C99.8686 58.4446 99.3217 58.6193 98.6797 58.6193ZM98.6797 57.6818C99.3161 57.6818 99.8104 57.375 100.163 56.7614C100.515 56.1477 100.691 55.2727 100.691 54.1364C100.691 53.3807 100.61 52.7372 100.448 52.206C100.289 51.6747 100.059 51.2699 99.7578 50.9915C99.4595 50.7131 99.1001 50.5739 98.6797 50.5739C98.049 50.5739 97.5561 50.8849 97.201 51.5071C96.8459 52.1264 96.6683 53.0028 96.6683 54.1364C96.6683 54.892 96.7479 55.5341 96.907 56.0625C97.0661 56.5909 97.2947 56.9929 97.593 57.2685C97.8942 57.544 98.2564 57.6818 98.6797 57.6818ZM106.18 58.6193C105.538 58.6193 104.991 58.4446 104.539 58.0952C104.087 57.7429 103.742 57.233 103.504 56.5653C103.265 55.8949 103.146 55.0852 103.146 54.1364C103.146 53.1932 103.265 52.3878 103.504 51.7202C103.745 51.0497 104.092 50.5384 104.543 50.1861C104.998 49.831 105.543 49.6534 106.18 49.6534C106.816 49.6534 107.36 49.831 107.812 50.1861C108.266 50.5384 108.613 51.0497 108.852 51.7202C109.093 52.3878 109.214 53.1932 109.214 54.1364C109.214 55.0852 109.094 55.8949 108.856 56.5653C108.617 57.233 108.272 57.7429 107.82 58.0952C107.369 58.4446 106.822 58.6193 106.18 58.6193ZM106.18 57.6818C106.816 57.6818 107.31 57.375 107.663 56.7614C108.015 56.1477 108.191 55.2727 108.191 54.1364C108.191 53.3807 108.11 52.7372 107.948 52.206C107.789 51.6747 107.559 51.2699 107.258 50.9915C106.96 50.7131 106.6 50.5739 106.18 50.5739C105.549 50.5739 105.056 50.8849 104.701 51.5071C104.346 52.1264 104.168 53.0028 104.168 54.1364C104.168 54.892 104.248 55.5341 104.407 56.0625C104.566 56.5909 104.795 56.9929 105.093 57.2685C105.394 57.544 105.756 57.6818 106.18 57.6818ZM110.629 56.7102V55.8409L114.464 49.7727H115.094V51.1193H114.668L111.771 55.7045V55.7727H116.935V56.7102H110.629ZM114.737 58.5V56.446V56.0412V49.7727H115.742V58.5H114.737ZM118.805 58.5L122.708 50.7784V50.7102H118.208V49.7727H123.799V50.7614L119.913 58.5H118.805Z"
            fill="#6B6D76"
          />
        </svg>
      );
    default:
      return;
  }
};

export const ComplianceImageTR: FC<ComplianceImageProps> = ({ model }) => {
  const LogoT = () => (
    <svg>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M49 39.5H37V51.5H49V39.5ZM37 38.5H36V39.5V51.5V52.5H37H49H50V51.5V39.5V38.5H49H37Z"
        fill="#5A5C61"
      />
      <mask id="path-32-inside-1_4045_57993" fill="white">
        <path d="M40 42.3594V41.5H46V42.3594H43.4844V49.5H42.5156V42.3594H40Z" />
      </mask>
      <path
        d="M40 42.3594H39V43.3594H40V42.3594ZM40 41.5V40.5H39V41.5H40ZM46 41.5H47V40.5H46V41.5ZM46 42.3594V43.3594H47V42.3594H46ZM43.4844 42.3594V41.3594H42.4844V42.3594H43.4844ZM43.4844 49.5V50.5H44.4844V49.5H43.4844ZM42.5156 49.5H41.5156V50.5H42.5156V49.5ZM42.5156 42.3594H43.5156V41.3594H42.5156V42.3594ZM41 42.3594V41.5H39V42.3594H41ZM40 42.5H46V40.5H40V42.5ZM45 41.5V42.3594H47V41.5H45ZM46 41.3594H43.4844V43.3594H46V41.3594ZM42.4844 42.3594V49.5H44.4844V42.3594H42.4844ZM43.4844 48.5H42.5156V50.5H43.4844V48.5ZM43.5156 49.5V42.3594H41.5156V49.5H43.5156ZM42.5156 41.3594H40V43.3594H42.5156V41.3594Z"
        fill="#5A5C61"
        mask="url(#path-32-inside-1_4045_57993)"
      />
    </svg>
  );
  const LogoR = () => (
    <svg>
      <rect x="36.5" y="56" width="13" height="13" stroke="#5A5C61" />
      <path
        d="M40.0568 67V58.2727H43.0057C43.6875 58.2727 44.2472 58.3892 44.6847 58.6222C45.1222 58.8523 45.446 59.169 45.6562 59.5724C45.8665 59.9759 45.9716 60.4347 45.9716 60.9489C45.9716 61.4631 45.8665 61.919 45.6562 62.3168C45.446 62.7145 45.1236 63.027 44.6889 63.2543C44.2543 63.4787 43.6989 63.5909 43.0227 63.5909H40.6364V62.6364H42.9886C43.4545 62.6364 43.8295 62.5682 44.1136 62.4318C44.4006 62.2955 44.608 62.1023 44.7358 61.8523C44.8665 61.5994 44.9318 61.2983 44.9318 60.9489C44.9318 60.5994 44.8665 60.294 44.7358 60.0327C44.6051 59.7713 44.3963 59.5696 44.1094 59.4276C43.8224 59.2827 43.4432 59.2102 42.9716 59.2102H41.1136V67H40.0568ZM44.1648 63.0795L46.3125 67H45.0852L42.9716 63.0795H44.1648Z"
        fill="#5A5C61"
      />
    </svg>
  );
  switch (model) {
    case DeviceModel.UDMPRO:
      return (
        <svg width="260" height="70" viewBox="0 0 260 70" fill="none" xmlns="http://www.w3.org/2000/svg">
          <ComplianceImage />
          <JapaneseTelecomLogo />
          <LogoT />
          <path
            d="M60.75 50H58.0568V41.2727H60.8693C61.7159 41.2727 62.4403 41.4474 63.0426 41.7969C63.6449 42.1435 64.1065 42.642 64.4276 43.2926C64.7486 43.9403 64.9091 44.7159 64.9091 45.6193C64.9091 46.5284 64.7472 47.3111 64.4233 47.9673C64.0994 48.6207 63.6278 49.1236 63.0085 49.4759C62.3892 49.8253 61.6364 50 60.75 50ZM59.1136 49.0625H60.6818C61.4034 49.0625 62.0014 48.9233 62.4759 48.6449C62.9503 48.3665 63.304 47.9702 63.5369 47.456C63.7699 46.9418 63.8864 46.3295 63.8864 45.6193C63.8864 44.9148 63.7713 44.3082 63.5412 43.7997C63.3111 43.2884 62.9673 42.8963 62.5099 42.6236C62.0526 42.348 61.483 42.2102 60.8011 42.2102H59.1136V49.0625ZM66.5284 50V49.233L69.4091 46.0795C69.7472 45.7102 70.0256 45.3892 70.2443 45.1165C70.4631 44.8409 70.625 44.5824 70.7301 44.3409C70.8381 44.0966 70.892 43.8409 70.892 43.5739C70.892 43.267 70.8182 43.0014 70.6705 42.777C70.5256 42.5526 70.3267 42.3793 70.0739 42.2571C69.821 42.1349 69.5369 42.0739 69.2216 42.0739C68.8864 42.0739 68.5938 42.1435 68.3438 42.2827C68.0966 42.419 67.9048 42.6108 67.7685 42.858C67.6349 43.1051 67.5682 43.3949 67.5682 43.7273H66.5625C66.5625 43.2159 66.6804 42.767 66.9162 42.3807C67.152 41.9943 67.473 41.6932 67.8793 41.4773C68.2884 41.2614 68.7472 41.1534 69.2557 41.1534C69.767 41.1534 70.2202 41.2614 70.6151 41.4773C71.0099 41.6932 71.3196 41.9844 71.544 42.3509C71.7685 42.7173 71.8807 43.125 71.8807 43.5739C71.8807 43.8949 71.8224 44.2088 71.706 44.5156C71.5923 44.8196 71.3935 45.1591 71.1094 45.5341C70.8281 45.9062 70.4375 46.3608 69.9375 46.8977L67.9773 48.9943V49.0625H72.0341V50H66.5284ZM73.794 50V49.233L76.6747 46.0795C77.0128 45.7102 77.2912 45.3892 77.5099 45.1165C77.7287 44.8409 77.8906 44.5824 77.9957 44.3409C78.1037 44.0966 78.1577 43.8409 78.1577 43.5739C78.1577 43.267 78.0838 43.0014 77.9361 42.777C77.7912 42.5526 77.5923 42.3793 77.3395 42.2571C77.0866 42.1349 76.8026 42.0739 76.4872 42.0739C76.152 42.0739 75.8594 42.1435 75.6094 42.2827C75.3622 42.419 75.1705 42.6108 75.0341 42.858C74.9006 43.1051 74.8338 43.3949 74.8338 43.7273H73.8281C73.8281 43.2159 73.946 42.767 74.1818 42.3807C74.4176 41.9943 74.7386 41.6932 75.1449 41.4773C75.554 41.2614 76.0128 41.1534 76.5213 41.1534C77.0327 41.1534 77.4858 41.2614 77.8807 41.4773C78.2756 41.6932 78.5852 41.9844 78.8097 42.3509C79.0341 42.7173 79.1463 43.125 79.1463 43.5739C79.1463 43.8949 79.0881 44.2088 78.9716 44.5156C78.858 44.8196 78.6591 45.1591 78.375 45.5341C78.0938 45.9062 77.7031 46.3608 77.2031 46.8977L75.2429 48.9943V49.0625H79.2997V50H73.794ZM84.8267 45.1676V46.1051H81.0085V45.1676H84.8267ZM89.4258 50.1193C88.7837 50.1193 88.2369 49.9446 87.7852 49.5952C87.3335 49.2429 86.9883 48.733 86.7496 48.0653C86.511 47.3949 86.3917 46.5852 86.3917 45.6364C86.3917 44.6932 86.511 43.8878 86.7496 43.2202C86.9911 42.5497 87.3377 42.0384 87.7894 41.6861C88.244 41.331 88.7894 41.1534 89.4258 41.1534C90.0621 41.1534 90.6062 41.331 91.0579 41.6861C91.5124 42.0384 91.859 42.5497 92.0977 43.2202C92.3391 43.8878 92.4599 44.6932 92.4599 45.6364C92.4599 46.5852 92.3406 47.3949 92.1019 48.0653C91.8633 48.733 91.5181 49.2429 91.0664 49.5952C90.6147 49.9446 90.0678 50.1193 89.4258 50.1193ZM89.4258 49.1818C90.0621 49.1818 90.5565 48.875 90.9087 48.2614C91.261 47.6477 91.4371 46.7727 91.4371 45.6364C91.4371 44.8807 91.3562 44.2372 91.1942 43.706C91.0352 43.1747 90.805 42.7699 90.5039 42.4915C90.2056 42.2131 89.8462 42.0739 89.4258 42.0739C88.7951 42.0739 88.3022 42.3849 87.9471 43.0071C87.592 43.6264 87.4144 44.5028 87.4144 45.6364C87.4144 46.392 87.494 47.0341 87.6531 47.5625C87.8121 48.0909 88.0408 48.4929 88.3391 48.7685C88.6403 49.044 89.0025 49.1818 89.4258 49.1818ZM96.9258 50.1193C96.2837 50.1193 95.7369 49.9446 95.2852 49.5952C94.8335 49.2429 94.4883 48.733 94.2496 48.0653C94.011 47.3949 93.8917 46.5852 93.8917 45.6364C93.8917 44.6932 94.011 43.8878 94.2496 43.2202C94.4911 42.5497 94.8377 42.0384 95.2894 41.6861C95.744 41.331 96.2894 41.1534 96.9258 41.1534C97.5621 41.1534 98.1062 41.331 98.5579 41.6861C99.0124 42.0384 99.359 42.5497 99.5977 43.2202C99.8391 43.8878 99.9599 44.6932 99.9599 45.6364C99.9599 46.5852 99.8406 47.3949 99.6019 48.0653C99.3633 48.733 99.0181 49.2429 98.5664 49.5952C98.1147 49.9446 97.5678 50.1193 96.9258 50.1193ZM96.9258 49.1818C97.5621 49.1818 98.0565 48.875 98.4087 48.2614C98.761 47.6477 98.9371 46.7727 98.9371 45.6364C98.9371 44.8807 98.8562 44.2372 98.6942 43.706C98.5352 43.1747 98.305 42.7699 98.0039 42.4915C97.7056 42.2131 97.3462 42.0739 96.9258 42.0739C96.2951 42.0739 95.8022 42.3849 95.4471 43.0071C95.092 43.6264 94.9144 44.5028 94.9144 45.6364C94.9144 46.392 94.994 47.0341 95.1531 47.5625C95.3121 48.0909 95.5408 48.4929 95.8391 48.7685C96.1403 49.044 96.5025 49.1818 96.9258 49.1818ZM104.306 50.1193C103.806 50.1193 103.356 50.0199 102.956 49.821C102.555 49.6222 102.234 49.3494 101.993 49.0028C101.751 48.6562 101.619 48.2614 101.596 47.8182H102.619C102.659 48.2131 102.838 48.5398 103.156 48.7983C103.477 49.054 103.86 49.1818 104.306 49.1818C104.664 49.1818 104.983 49.098 105.261 48.9304C105.542 48.7628 105.762 48.5327 105.922 48.2401C106.083 47.9446 106.164 47.6108 106.164 47.2386C106.164 46.858 106.081 46.5185 105.913 46.2202C105.748 45.919 105.521 45.6818 105.231 45.5085C104.941 45.3352 104.61 45.2472 104.238 45.2443C103.971 45.2415 103.697 45.2827 103.416 45.3679C103.135 45.4503 102.903 45.5568 102.721 45.6875L101.733 45.5682L102.261 41.2727H106.795V42.2102H103.147L102.841 44.7841H102.892C103.071 44.642 103.295 44.5241 103.565 44.4304C103.835 44.3366 104.116 44.2898 104.409 44.2898C104.943 44.2898 105.419 44.4176 105.836 44.6733C106.257 44.9261 106.586 45.2727 106.825 45.7131C107.066 46.1534 107.187 46.6562 107.187 47.2216C107.187 47.7784 107.062 48.2756 106.812 48.7131C106.565 49.1477 106.224 49.4915 105.789 49.7443C105.355 49.9943 104.86 50.1193 104.306 50.1193ZM111.829 50.1193C111.266 50.1193 110.765 50.0227 110.325 49.8295C109.887 49.6364 109.539 49.3679 109.281 49.0241C109.025 48.6776 108.886 48.2756 108.863 47.8182H109.937C109.96 48.0994 110.056 48.3423 110.227 48.5469C110.397 48.7486 110.62 48.9048 110.896 49.0156C111.171 49.1264 111.477 49.1818 111.812 49.1818C112.187 49.1818 112.519 49.1165 112.809 48.9858C113.099 48.8551 113.326 48.6733 113.491 48.4403C113.656 48.2074 113.738 47.9375 113.738 47.6307C113.738 47.3097 113.658 47.027 113.499 46.7827C113.34 46.5355 113.107 46.3423 112.8 46.2031C112.494 46.0639 112.119 45.9943 111.675 45.9943H110.977V45.0568H111.675C112.022 45.0568 112.326 44.9943 112.587 44.8693C112.852 44.7443 113.058 44.5682 113.205 44.3409C113.356 44.1136 113.431 43.8466 113.431 43.5398C113.431 43.2443 113.366 42.9872 113.235 42.7685C113.104 42.5497 112.92 42.3793 112.681 42.2571C112.445 42.1349 112.167 42.0739 111.846 42.0739C111.545 42.0739 111.261 42.1293 110.994 42.2401C110.729 42.348 110.513 42.5057 110.346 42.7131C110.178 42.9176 110.087 43.1648 110.073 43.4545H109.05C109.067 42.9972 109.205 42.5966 109.464 42.2528C109.722 41.9062 110.06 41.6364 110.478 41.4432C110.898 41.25 111.36 41.1534 111.863 41.1534C112.403 41.1534 112.866 41.2628 113.252 41.4815C113.638 41.6974 113.935 41.983 114.143 42.3381C114.35 42.6932 114.454 43.0767 114.454 43.4886C114.454 43.9801 114.325 44.3991 114.066 44.7457C113.81 45.0923 113.462 45.3324 113.022 45.4659V45.5341C113.573 45.625 114.004 45.8594 114.313 46.2372C114.623 46.6122 114.778 47.0767 114.778 47.6307C114.778 48.1051 114.648 48.5312 114.39 48.9091C114.134 49.2841 113.785 49.5795 113.342 49.7955C112.898 50.0114 112.394 50.1193 111.829 50.1193ZM119.367 50.1193C118.725 50.1193 118.178 49.9446 117.727 49.5952C117.275 49.2429 116.93 48.733 116.691 48.0653C116.452 47.3949 116.333 46.5852 116.333 45.6364C116.333 44.6932 116.452 43.8878 116.691 43.2202C116.933 42.5497 117.279 42.0384 117.731 41.6861C118.185 41.331 118.731 41.1534 119.367 41.1534C120.004 41.1534 120.548 41.331 120.999 41.6861C121.454 42.0384 121.8 42.5497 122.039 43.2202C122.281 43.8878 122.401 44.6932 122.401 45.6364C122.401 46.5852 122.282 47.3949 122.043 48.0653C121.805 48.733 121.46 49.2429 121.008 49.5952C120.556 49.9446 120.009 50.1193 119.367 50.1193ZM119.367 49.1818C120.004 49.1818 120.498 48.875 120.85 48.2614C121.202 47.6477 121.379 46.7727 121.379 45.6364C121.379 44.8807 121.298 44.2372 121.136 43.706C120.977 43.1747 120.746 42.7699 120.445 42.4915C120.147 42.2131 119.788 42.0739 119.367 42.0739C118.737 42.0739 118.244 42.3849 117.888 43.0071C117.533 43.6264 117.356 44.5028 117.356 45.6364C117.356 46.392 117.435 47.0341 117.594 47.5625C117.754 48.0909 117.982 48.4929 118.281 48.7685C118.582 49.044 118.944 49.1818 119.367 49.1818ZM126.867 50.1193C126.225 50.1193 125.678 49.9446 125.227 49.5952C124.775 49.2429 124.43 48.733 124.191 48.0653C123.952 47.3949 123.833 46.5852 123.833 45.6364C123.833 44.6932 123.952 43.8878 124.191 43.2202C124.433 42.5497 124.779 42.0384 125.231 41.6861C125.685 41.331 126.231 41.1534 126.867 41.1534C127.504 41.1534 128.048 41.331 128.499 41.6861C128.954 42.0384 129.3 42.5497 129.539 43.2202C129.781 43.8878 129.901 44.6932 129.901 45.6364C129.901 46.5852 129.782 47.3949 129.543 48.0653C129.305 48.733 128.96 49.2429 128.508 49.5952C128.056 49.9446 127.509 50.1193 126.867 50.1193ZM126.867 49.1818C127.504 49.1818 127.998 48.875 128.35 48.2614C128.702 47.6477 128.879 46.7727 128.879 45.6364C128.879 44.8807 128.798 44.2372 128.636 43.706C128.477 43.1747 128.246 42.7699 127.945 42.4915C127.647 42.2131 127.288 42.0739 126.867 42.0739C126.237 42.0739 125.744 42.3849 125.388 43.0071C125.033 43.6264 124.856 44.5028 124.856 45.6364C124.856 46.392 124.935 47.0341 125.094 47.5625C125.254 48.0909 125.482 48.4929 125.781 48.7685C126.082 49.044 126.444 49.1818 126.867 49.1818ZM134.589 41.2727V50H133.532V42.3807H133.481L131.35 43.7955V42.7216L133.532 41.2727H134.589Z"
            fill="#6B6D76"
          />
          <LogoR />
          <path
            d="M56.9034 67V66.233L59.7841 63.0795C60.1222 62.7102 60.4006 62.3892 60.6193 62.1165C60.8381 61.8409 61 61.5824 61.1051 61.3409C61.2131 61.0966 61.267 60.8409 61.267 60.5739C61.267 60.267 61.1932 60.0014 61.0455 59.777C60.9006 59.5526 60.7017 59.3793 60.4489 59.2571C60.196 59.1349 59.9119 59.0739 59.5966 59.0739C59.2614 59.0739 58.9688 59.1435 58.7188 59.2827C58.4716 59.419 58.2798 59.6108 58.1435 59.858C58.0099 60.1051 57.9432 60.3949 57.9432 60.7273H56.9375C56.9375 60.2159 57.0554 59.767 57.2912 59.3807C57.527 58.9943 57.848 58.6932 58.2543 58.4773C58.6634 58.2614 59.1222 58.1534 59.6307 58.1534C60.142 58.1534 60.5952 58.2614 60.9901 58.4773C61.3849 58.6932 61.6946 58.9844 61.919 59.3509C62.1435 59.7173 62.2557 60.125 62.2557 60.5739C62.2557 60.8949 62.1974 61.2088 62.081 61.5156C61.9673 61.8196 61.7685 62.1591 61.4844 62.5341C61.2031 62.9062 60.8125 63.3608 60.3125 63.8977L58.3523 65.9943V66.0625H62.4091V67H56.9034ZM67.0156 67.1193C66.3736 67.1193 65.8267 66.9446 65.375 66.5952C64.9233 66.2429 64.5781 65.733 64.3395 65.0653C64.1009 64.3949 63.9815 63.5852 63.9815 62.6364C63.9815 61.6932 64.1009 60.8878 64.3395 60.2202C64.581 59.5497 64.9276 59.0384 65.3793 58.6861C65.8338 58.331 66.3793 58.1534 67.0156 58.1534C67.652 58.1534 68.196 58.331 68.6477 58.6861C69.1023 59.0384 69.4489 59.5497 69.6875 60.2202C69.929 60.8878 70.0497 61.6932 70.0497 62.6364C70.0497 63.5852 69.9304 64.3949 69.6918 65.0653C69.4531 65.733 69.108 66.2429 68.6562 66.5952C68.2045 66.9446 67.6577 67.1193 67.0156 67.1193ZM67.0156 66.1818C67.652 66.1818 68.1463 65.875 68.4986 65.2614C68.8509 64.6477 69.027 63.7727 69.027 62.6364C69.027 61.8807 68.946 61.2372 68.7841 60.706C68.625 60.1747 68.3949 59.7699 68.0938 59.4915C67.7955 59.2131 67.4361 59.0739 67.0156 59.0739C66.3849 59.0739 65.892 59.3849 65.5369 60.0071C65.1818 60.6264 65.0043 61.5028 65.0043 62.6364C65.0043 63.392 65.0838 64.0341 65.2429 64.5625C65.402 65.0909 65.6307 65.4929 65.929 65.7685C66.2301 66.044 66.5923 66.1818 67.0156 66.1818ZM74.7372 58.2727V67H73.6804V59.3807H73.6293L71.4986 60.7955V59.7216L73.6804 58.2727H74.7372ZM81.0142 62.1676V63.1051H77.196V62.1676H81.0142ZM82.3565 67V66.233L85.2372 63.0795C85.5753 62.7102 85.8537 62.3892 86.0724 62.1165C86.2912 61.8409 86.4531 61.5824 86.5582 61.3409C86.6662 61.0966 86.7202 60.8409 86.7202 60.5739C86.7202 60.267 86.6463 60.0014 86.4986 59.777C86.3537 59.5526 86.1548 59.3793 85.902 59.2571C85.6491 59.1349 85.3651 59.0739 85.0497 59.0739C84.7145 59.0739 84.4219 59.1435 84.1719 59.2827C83.9247 59.419 83.733 59.6108 83.5966 59.858C83.4631 60.1051 83.3963 60.3949 83.3963 60.7273H82.3906C82.3906 60.2159 82.5085 59.767 82.7443 59.3807C82.9801 58.9943 83.3011 58.6932 83.7074 58.4773C84.1165 58.2614 84.5753 58.1534 85.0838 58.1534C85.5952 58.1534 86.0483 58.2614 86.4432 58.4773C86.8381 58.6932 87.1477 58.9844 87.3722 59.3509C87.5966 59.7173 87.7088 60.125 87.7088 60.5739C87.7088 60.8949 87.6506 61.2088 87.5341 61.5156C87.4205 61.8196 87.2216 62.1591 86.9375 62.5341C86.6562 62.9062 86.2656 63.3608 85.7656 63.8977L83.8054 65.9943V66.0625H87.8622V67H82.3565ZM89.6222 67V66.233L92.5028 63.0795C92.8409 62.7102 93.1193 62.3892 93.3381 62.1165C93.5568 61.8409 93.7188 61.5824 93.8239 61.3409C93.9318 61.0966 93.9858 60.8409 93.9858 60.5739C93.9858 60.267 93.9119 60.0014 93.7642 59.777C93.6193 59.5526 93.4205 59.3793 93.1676 59.2571C92.9148 59.1349 92.6307 59.0739 92.3153 59.0739C91.9801 59.0739 91.6875 59.1435 91.4375 59.2827C91.1903 59.419 90.9986 59.6108 90.8622 59.858C90.7287 60.1051 90.6619 60.3949 90.6619 60.7273H89.6562C89.6562 60.2159 89.7741 59.767 90.0099 59.3807C90.2457 58.9943 90.5668 58.6932 90.973 58.4773C91.3821 58.2614 91.8409 58.1534 92.3494 58.1534C92.8608 58.1534 93.3139 58.2614 93.7088 58.4773C94.1037 58.6932 94.4134 58.9844 94.6378 59.3509C94.8622 59.7173 94.9744 60.125 94.9744 60.5739C94.9744 60.8949 94.9162 61.2088 94.7997 61.5156C94.6861 61.8196 94.4872 62.1591 94.2031 62.5341C93.9219 62.9062 93.5312 63.3608 93.0312 63.8977L91.071 65.9943V66.0625H95.1278V67H89.6222ZM99.7344 67.1193C99.0923 67.1193 98.5455 66.9446 98.0938 66.5952C97.642 66.2429 97.2969 65.733 97.0582 65.0653C96.8196 64.3949 96.7003 63.5852 96.7003 62.6364C96.7003 61.6932 96.8196 60.8878 97.0582 60.2202C97.2997 59.5497 97.6463 59.0384 98.098 58.6861C98.5526 58.331 99.098 58.1534 99.7344 58.1534C100.371 58.1534 100.915 58.331 101.366 58.6861C101.821 59.0384 102.168 59.5497 102.406 60.2202C102.648 60.8878 102.768 61.6932 102.768 62.6364C102.768 63.5852 102.649 64.3949 102.411 65.0653C102.172 65.733 101.827 66.2429 101.375 66.5952C100.923 66.9446 100.376 67.1193 99.7344 67.1193ZM99.7344 66.1818C100.371 66.1818 100.865 65.875 101.217 65.2614C101.57 64.6477 101.746 63.7727 101.746 62.6364C101.746 61.8807 101.665 61.2372 101.503 60.706C101.344 60.1747 101.114 59.7699 100.812 59.4915C100.514 59.2131 100.155 59.0739 99.7344 59.0739C99.1037 59.0739 98.6108 59.3849 98.2557 60.0071C97.9006 60.6264 97.723 61.5028 97.723 62.6364C97.723 63.392 97.8026 64.0341 97.9616 64.5625C98.1207 65.0909 98.3494 65.4929 98.6477 65.7685C98.9489 66.044 99.3111 66.1818 99.7344 66.1818ZM104.388 67V66.233L107.268 63.0795C107.607 62.7102 107.885 62.3892 108.104 62.1165C108.322 61.8409 108.484 61.5824 108.589 61.3409C108.697 61.0966 108.751 60.8409 108.751 60.5739C108.751 60.267 108.678 60.0014 108.53 59.777C108.385 59.5526 108.186 59.3793 107.933 59.2571C107.68 59.1349 107.396 59.0739 107.081 59.0739C106.746 59.0739 106.453 59.1435 106.203 59.2827C105.956 59.419 105.764 59.6108 105.628 59.858C105.494 60.1051 105.428 60.3949 105.428 60.7273H104.422C104.422 60.2159 104.54 59.767 104.776 59.3807C105.011 58.9943 105.332 58.6932 105.739 58.4773C106.148 58.2614 106.607 58.1534 107.115 58.1534C107.626 58.1534 108.08 58.2614 108.474 58.4773C108.869 58.6932 109.179 58.9844 109.403 59.3509C109.628 59.7173 109.74 60.125 109.74 60.5739C109.74 60.8949 109.682 61.2088 109.565 61.5156C109.452 61.8196 109.253 62.1591 108.969 62.5341C108.688 62.9062 108.297 63.3608 107.797 63.8977L105.837 65.9943V66.0625H109.893V67H104.388ZM114.722 58.2727V67H113.665V59.3807H113.614L111.483 60.7955V59.7216L113.665 58.2727H114.722ZM120.18 67.1193C119.618 67.1193 119.116 67.0227 118.676 66.8295C118.239 66.6364 117.891 66.3679 117.632 66.0241C117.376 65.6776 117.237 65.2756 117.214 64.8182H118.288C118.311 65.0994 118.408 65.3423 118.578 65.5469C118.749 65.7486 118.972 65.9048 119.247 66.0156C119.523 66.1264 119.828 66.1818 120.163 66.1818C120.538 66.1818 120.871 66.1165 121.161 65.9858C121.45 65.8551 121.678 65.6733 121.842 65.4403C122.007 65.2074 122.089 64.9375 122.089 64.6307C122.089 64.3097 122.01 64.027 121.851 63.7827C121.692 63.5355 121.459 63.3423 121.152 63.2031C120.845 63.0639 120.47 62.9943 120.027 62.9943H119.328V62.0568H120.027C120.374 62.0568 120.678 61.9943 120.939 61.8693C121.203 61.7443 121.409 61.5682 121.557 61.3409C121.707 61.1136 121.783 60.8466 121.783 60.5398C121.783 60.2443 121.717 59.9872 121.587 59.7685C121.456 59.5497 121.271 59.3793 121.033 59.2571C120.797 59.1349 120.518 59.0739 120.197 59.0739C119.896 59.0739 119.612 59.1293 119.345 59.2401C119.081 59.348 118.865 59.5057 118.697 59.7131C118.53 59.9176 118.439 60.1648 118.425 60.4545H117.402C117.419 59.9972 117.557 59.5966 117.815 59.2528C118.074 58.9062 118.412 58.6364 118.83 58.4432C119.25 58.25 119.712 58.1534 120.214 58.1534C120.754 58.1534 121.217 58.2628 121.604 58.4815C121.99 58.6974 122.287 58.983 122.494 59.3381C122.702 59.6932 122.805 60.0767 122.805 60.4886C122.805 60.9801 122.676 61.3991 122.418 61.7457C122.162 62.0923 121.814 62.3324 121.374 62.4659V62.5341C121.925 62.625 122.355 62.8594 122.665 63.2372C122.974 63.6122 123.129 64.0767 123.129 64.6307C123.129 65.1051 123 65.5312 122.741 65.9091C122.486 66.2841 122.136 66.5795 121.693 66.7955C121.25 67.0114 120.746 67.1193 120.18 67.1193Z"
            fill="#6B6D76"
          />
        </svg>
      );
    case DeviceModel.UDMPROSE:
      return (
        <svg width="260" height="70" viewBox="0 0 260 70" fill="none" xmlns="http://www.w3.org/2000/svg">
          <ComplianceImage />
          <JapaneseTelecomLogo />
          <LogoT />
          <path
            d="M60.75 50H58.0568V41.2727H60.8693C61.7159 41.2727 62.4403 41.4474 63.0426 41.7969C63.6449 42.1435 64.1065 42.642 64.4276 43.2926C64.7486 43.9403 64.9091 44.7159 64.9091 45.6193C64.9091 46.5284 64.7472 47.3111 64.4233 47.9673C64.0994 48.6207 63.6278 49.1236 63.0085 49.4759C62.3892 49.8253 61.6364 50 60.75 50ZM59.1136 49.0625H60.6818C61.4034 49.0625 62.0014 48.9233 62.4759 48.6449C62.9503 48.3665 63.304 47.9702 63.5369 47.456C63.7699 46.9418 63.8864 46.3295 63.8864 45.6193C63.8864 44.9148 63.7713 44.3082 63.5412 43.7997C63.3111 43.2884 62.9673 42.8963 62.5099 42.6236C62.0526 42.348 61.483 42.2102 60.8011 42.2102H59.1136V49.0625ZM66.5284 50V49.233L69.4091 46.0795C69.7472 45.7102 70.0256 45.3892 70.2443 45.1165C70.4631 44.8409 70.625 44.5824 70.7301 44.3409C70.8381 44.0966 70.892 43.8409 70.892 43.5739C70.892 43.267 70.8182 43.0014 70.6705 42.777C70.5256 42.5526 70.3267 42.3793 70.0739 42.2571C69.821 42.1349 69.5369 42.0739 69.2216 42.0739C68.8864 42.0739 68.5938 42.1435 68.3438 42.2827C68.0966 42.419 67.9048 42.6108 67.7685 42.858C67.6349 43.1051 67.5682 43.3949 67.5682 43.7273H66.5625C66.5625 43.2159 66.6804 42.767 66.9162 42.3807C67.152 41.9943 67.473 41.6932 67.8793 41.4773C68.2884 41.2614 68.7472 41.1534 69.2557 41.1534C69.767 41.1534 70.2202 41.2614 70.6151 41.4773C71.0099 41.6932 71.3196 41.9844 71.544 42.3509C71.7685 42.7173 71.8807 43.125 71.8807 43.5739C71.8807 43.8949 71.8224 44.2088 71.706 44.5156C71.5923 44.8196 71.3935 45.1591 71.1094 45.5341C70.8281 45.9062 70.4375 46.3608 69.9375 46.8977L67.9773 48.9943V49.0625H72.0341V50H66.5284ZM76.6406 50.1193C75.9986 50.1193 75.4517 49.9446 75 49.5952C74.5483 49.2429 74.2031 48.733 73.9645 48.0653C73.7259 47.3949 73.6065 46.5852 73.6065 45.6364C73.6065 44.6932 73.7259 43.8878 73.9645 43.2202C74.206 42.5497 74.5526 42.0384 75.0043 41.6861C75.4588 41.331 76.0043 41.1534 76.6406 41.1534C77.277 41.1534 77.821 41.331 78.2727 41.6861C78.7273 42.0384 79.0739 42.5497 79.3125 43.2202C79.554 43.8878 79.6747 44.6932 79.6747 45.6364C79.6747 46.5852 79.5554 47.3949 79.3168 48.0653C79.0781 48.733 78.733 49.2429 78.2812 49.5952C77.8295 49.9446 77.2827 50.1193 76.6406 50.1193ZM76.6406 49.1818C77.277 49.1818 77.7713 48.875 78.1236 48.2614C78.4759 47.6477 78.652 46.7727 78.652 45.6364C78.652 44.8807 78.571 44.2372 78.4091 43.706C78.25 43.1747 78.0199 42.7699 77.7188 42.4915C77.4205 42.2131 77.0611 42.0739 76.6406 42.0739C76.0099 42.0739 75.517 42.3849 75.1619 43.0071C74.8068 43.6264 74.6293 44.5028 74.6293 45.6364C74.6293 46.392 74.7088 47.0341 74.8679 47.5625C75.027 48.0909 75.2557 48.4929 75.554 48.7685C75.8551 49.044 76.2173 49.1818 76.6406 49.1818ZM85.0611 45.1676V46.1051H81.2429V45.1676H85.0611ZM89.6602 50.1193C89.0181 50.1193 88.4712 49.9446 88.0195 49.5952C87.5678 49.2429 87.2227 48.733 86.984 48.0653C86.7454 47.3949 86.6261 46.5852 86.6261 45.6364C86.6261 44.6932 86.7454 43.8878 86.984 43.2202C87.2255 42.5497 87.5721 42.0384 88.0238 41.6861C88.4783 41.331 89.0238 41.1534 89.6602 41.1534C90.2965 41.1534 90.8406 41.331 91.2923 41.6861C91.7468 42.0384 92.0934 42.5497 92.332 43.2202C92.5735 43.8878 92.6942 44.6932 92.6942 45.6364C92.6942 46.5852 92.5749 47.3949 92.3363 48.0653C92.0977 48.733 91.7525 49.2429 91.3008 49.5952C90.8491 49.9446 90.3022 50.1193 89.6602 50.1193ZM89.6602 49.1818C90.2965 49.1818 90.7908 48.875 91.1431 48.2614C91.4954 47.6477 91.6715 46.7727 91.6715 45.6364C91.6715 44.8807 91.5906 44.2372 91.4286 43.706C91.2695 43.1747 91.0394 42.7699 90.7383 42.4915C90.44 42.2131 90.0806 42.0739 89.6602 42.0739C89.0295 42.0739 88.5366 42.3849 88.1815 43.0071C87.8263 43.6264 87.6488 44.5028 87.6488 45.6364C87.6488 46.392 87.7283 47.0341 87.8874 47.5625C88.0465 48.0909 88.2752 48.4929 88.5735 48.7685C88.8746 49.044 89.2369 49.1818 89.6602 49.1818ZM97.1602 50.1193C96.5181 50.1193 95.9712 49.9446 95.5195 49.5952C95.0678 49.2429 94.7227 48.733 94.484 48.0653C94.2454 47.3949 94.1261 46.5852 94.1261 45.6364C94.1261 44.6932 94.2454 43.8878 94.484 43.2202C94.7255 42.5497 95.0721 42.0384 95.5238 41.6861C95.9783 41.331 96.5238 41.1534 97.1602 41.1534C97.7965 41.1534 98.3406 41.331 98.7923 41.6861C99.2468 42.0384 99.5934 42.5497 99.832 43.2202C100.074 43.8878 100.194 44.6932 100.194 45.6364C100.194 46.5852 100.075 47.3949 99.8363 48.0653C99.5977 48.733 99.2525 49.2429 98.8008 49.5952C98.3491 49.9446 97.8022 50.1193 97.1602 50.1193ZM97.1602 49.1818C97.7965 49.1818 98.2908 48.875 98.6431 48.2614C98.9954 47.6477 99.1715 46.7727 99.1715 45.6364C99.1715 44.8807 99.0906 44.2372 98.9286 43.706C98.7695 43.1747 98.5394 42.7699 98.2383 42.4915C97.94 42.2131 97.5806 42.0739 97.1602 42.0739C96.5295 42.0739 96.0366 42.3849 95.6815 43.0071C95.3263 43.6264 95.1488 44.5028 95.1488 45.6364C95.1488 46.392 95.2283 47.0341 95.3874 47.5625C95.5465 48.0909 95.7752 48.4929 96.0735 48.7685C96.3746 49.044 96.7369 49.1818 97.1602 49.1818ZM104.592 41.1534C104.95 41.1562 105.308 41.2244 105.666 41.358C106.024 41.4915 106.35 41.7131 106.646 42.0227C106.941 42.3295 107.179 42.7486 107.358 43.2798C107.537 43.8111 107.626 44.4773 107.626 45.2784C107.626 46.054 107.552 46.7429 107.404 47.3452C107.26 47.9446 107.049 48.4503 106.774 48.8622C106.501 49.2741 106.169 49.5866 105.777 49.7997C105.387 50.0128 104.947 50.1193 104.456 50.1193C103.967 50.1193 103.531 50.0227 103.147 49.8295C102.767 49.6335 102.454 49.3622 102.21 49.0156C101.968 48.6662 101.814 48.2614 101.745 47.8011H102.785C102.879 48.2017 103.065 48.5327 103.343 48.794C103.625 49.0526 103.995 49.1818 104.456 49.1818C105.129 49.1818 105.66 48.8878 106.049 48.2997C106.441 47.7116 106.637 46.8807 106.637 45.8068H106.569C106.41 46.0455 106.221 46.2514 106.002 46.4247C105.784 46.598 105.541 46.7315 105.274 46.8253C105.007 46.919 104.723 46.9659 104.422 46.9659C103.922 46.9659 103.463 46.8423 103.045 46.5952C102.63 46.3452 102.298 46.0028 102.048 45.5682C101.801 45.1307 101.677 44.6307 101.677 44.0682C101.677 43.5341 101.797 43.0455 102.035 42.6023C102.277 42.1562 102.615 41.8011 103.049 41.5369C103.487 41.2727 104.001 41.1449 104.592 41.1534ZM104.592 42.0909C104.234 42.0909 103.912 42.1804 103.625 42.3594C103.341 42.5355 103.115 42.7741 102.947 43.0753C102.782 43.3736 102.7 43.7045 102.7 44.0682C102.7 44.4318 102.779 44.7628 102.939 45.0611C103.1 45.3565 103.321 45.5923 103.599 45.7685C103.88 45.9418 104.2 46.0284 104.558 46.0284C104.828 46.0284 105.079 45.9759 105.312 45.8707C105.545 45.7628 105.748 45.6165 105.922 45.4318C106.098 45.2443 106.235 45.0327 106.335 44.7969C106.434 44.5582 106.484 44.3097 106.484 44.0511C106.484 43.7102 106.402 43.3906 106.237 43.0923C106.075 42.794 105.85 42.5526 105.564 42.3679C105.279 42.1832 104.956 42.0909 104.592 42.0909ZM112.251 50.1193C111.688 50.1193 111.187 50.0227 110.746 49.8295C110.309 49.6364 109.961 49.3679 109.702 49.0241C109.447 48.6776 109.308 48.2756 109.285 47.8182H110.359C110.381 48.0994 110.478 48.3423 110.648 48.5469C110.819 48.7486 111.042 48.9048 111.317 49.0156C111.593 49.1264 111.898 49.1818 112.234 49.1818C112.609 49.1818 112.941 49.1165 113.231 48.9858C113.521 48.8551 113.748 48.6733 113.913 48.4403C114.077 48.2074 114.16 47.9375 114.16 47.6307C114.16 47.3097 114.08 47.027 113.921 46.7827C113.762 46.5355 113.529 46.3423 113.222 46.2031C112.915 46.0639 112.54 45.9943 112.097 45.9943H111.398V45.0568H112.097C112.444 45.0568 112.748 44.9943 113.009 44.8693C113.273 44.7443 113.479 44.5682 113.627 44.3409C113.778 44.1136 113.853 43.8466 113.853 43.5398C113.853 43.2443 113.788 42.9872 113.657 42.7685C113.526 42.5497 113.342 42.3793 113.103 42.2571C112.867 42.1349 112.589 42.0739 112.268 42.0739C111.967 42.0739 111.683 42.1293 111.415 42.2401C111.151 42.348 110.935 42.5057 110.768 42.7131C110.6 42.9176 110.509 43.1648 110.495 43.4545H109.472C109.489 42.9972 109.627 42.5966 109.886 42.2528C110.144 41.9062 110.482 41.6364 110.9 41.4432C111.32 41.25 111.782 41.1534 112.285 41.1534C112.825 41.1534 113.288 41.2628 113.674 41.4815C114.06 41.6974 114.357 41.983 114.565 42.3381C114.772 42.6932 114.876 43.0767 114.876 43.4886C114.876 43.9801 114.746 44.3991 114.488 44.7457C114.232 45.0923 113.884 45.3324 113.444 45.4659V45.5341C113.995 45.625 114.425 45.8594 114.735 46.2372C115.045 46.6122 115.2 47.0767 115.2 47.6307C115.2 48.1051 115.07 48.5312 114.812 48.9091C114.556 49.2841 114.207 49.5795 113.763 49.7955C113.32 50.0114 112.816 50.1193 112.251 50.1193ZM119.789 50.1193C119.147 50.1193 118.6 49.9446 118.148 49.5952C117.697 49.2429 117.352 48.733 117.113 48.0653C116.874 47.3949 116.755 46.5852 116.755 45.6364C116.755 44.6932 116.874 43.8878 117.113 43.2202C117.354 42.5497 117.701 42.0384 118.153 41.6861C118.607 41.331 119.153 41.1534 119.789 41.1534C120.425 41.1534 120.969 41.331 121.421 41.6861C121.876 42.0384 122.222 42.5497 122.461 43.2202C122.702 43.8878 122.823 44.6932 122.823 45.6364C122.823 46.5852 122.704 47.3949 122.465 48.0653C122.227 48.733 121.881 49.2429 121.43 49.5952C120.978 49.9446 120.431 50.1193 119.789 50.1193ZM119.789 49.1818C120.425 49.1818 120.92 48.875 121.272 48.2614C121.624 47.6477 121.8 46.7727 121.8 45.6364C121.8 44.8807 121.719 44.2372 121.558 43.706C121.398 43.1747 121.168 42.7699 120.867 42.4915C120.569 42.2131 120.21 42.0739 119.789 42.0739C119.158 42.0739 118.665 42.3849 118.31 43.0071C117.955 43.6264 117.778 44.5028 117.778 45.6364C117.778 46.392 117.857 47.0341 118.016 47.5625C118.175 48.0909 118.404 48.4929 118.702 48.7685C119.004 49.044 119.366 49.1818 119.789 49.1818ZM127.289 50.1193C126.647 50.1193 126.1 49.9446 125.648 49.5952C125.197 49.2429 124.852 48.733 124.613 48.0653C124.374 47.3949 124.255 46.5852 124.255 45.6364C124.255 44.6932 124.374 43.8878 124.613 43.2202C124.854 42.5497 125.201 42.0384 125.653 41.6861C126.107 41.331 126.653 41.1534 127.289 41.1534C127.925 41.1534 128.469 41.331 128.921 41.6861C129.376 42.0384 129.722 42.5497 129.961 43.2202C130.202 43.8878 130.323 44.6932 130.323 45.6364C130.323 46.5852 130.204 47.3949 129.965 48.0653C129.727 48.733 129.381 49.2429 128.93 49.5952C128.478 49.9446 127.931 50.1193 127.289 50.1193ZM127.289 49.1818C127.925 49.1818 128.42 48.875 128.772 48.2614C129.124 47.6477 129.3 46.7727 129.3 45.6364C129.3 44.8807 129.219 44.2372 129.058 43.706C128.898 43.1747 128.668 42.7699 128.367 42.4915C128.069 42.2131 127.71 42.0739 127.289 42.0739C126.658 42.0739 126.165 42.3849 125.81 43.0071C125.455 43.6264 125.278 44.5028 125.278 45.6364C125.278 46.392 125.357 47.0341 125.516 47.5625C125.675 48.0909 125.904 48.4929 126.202 48.7685C126.504 49.044 126.866 49.1818 127.289 49.1818ZM135.011 41.2727V50H133.954V42.3807H133.903L131.772 43.7955V42.7216L133.954 41.2727H135.011Z"
            fill="#6B6D76"
          />
          <LogoR />
          <path
            d="M56.9034 67V66.233L59.7841 63.0795C60.1222 62.7102 60.4006 62.3892 60.6193 62.1165C60.8381 61.8409 61 61.5824 61.1051 61.3409C61.2131 61.0966 61.267 60.8409 61.267 60.5739C61.267 60.267 61.1932 60.0014 61.0455 59.777C60.9006 59.5526 60.7017 59.3793 60.4489 59.2571C60.196 59.1349 59.9119 59.0739 59.5966 59.0739C59.2614 59.0739 58.9688 59.1435 58.7188 59.2827C58.4716 59.419 58.2798 59.6108 58.1435 59.858C58.0099 60.1051 57.9432 60.3949 57.9432 60.7273H56.9375C56.9375 60.2159 57.0554 59.767 57.2912 59.3807C57.527 58.9943 57.848 58.6932 58.2543 58.4773C58.6634 58.2614 59.1222 58.1534 59.6307 58.1534C60.142 58.1534 60.5952 58.2614 60.9901 58.4773C61.3849 58.6932 61.6946 58.9844 61.919 59.3509C62.1435 59.7173 62.2557 60.125 62.2557 60.5739C62.2557 60.8949 62.1974 61.2088 62.081 61.5156C61.9673 61.8196 61.7685 62.1591 61.4844 62.5341C61.2031 62.9062 60.8125 63.3608 60.3125 63.8977L58.3523 65.9943V66.0625H62.4091V67H56.9034ZM67.0156 67.1193C66.3736 67.1193 65.8267 66.9446 65.375 66.5952C64.9233 66.2429 64.5781 65.733 64.3395 65.0653C64.1009 64.3949 63.9815 63.5852 63.9815 62.6364C63.9815 61.6932 64.1009 60.8878 64.3395 60.2202C64.581 59.5497 64.9276 59.0384 65.3793 58.6861C65.8338 58.331 66.3793 58.1534 67.0156 58.1534C67.652 58.1534 68.196 58.331 68.6477 58.6861C69.1023 59.0384 69.4489 59.5497 69.6875 60.2202C69.929 60.8878 70.0497 61.6932 70.0497 62.6364C70.0497 63.5852 69.9304 64.3949 69.6918 65.0653C69.4531 65.733 69.108 66.2429 68.6562 66.5952C68.2045 66.9446 67.6577 67.1193 67.0156 67.1193ZM67.0156 66.1818C67.652 66.1818 68.1463 65.875 68.4986 65.2614C68.8509 64.6477 69.027 63.7727 69.027 62.6364C69.027 61.8807 68.946 61.2372 68.7841 60.706C68.625 60.1747 68.3949 59.7699 68.0938 59.4915C67.7955 59.2131 67.4361 59.0739 67.0156 59.0739C66.3849 59.0739 65.892 59.3849 65.5369 60.0071C65.1818 60.6264 65.0043 61.5028 65.0043 62.6364C65.0043 63.392 65.0838 64.0341 65.2429 64.5625C65.402 65.0909 65.6307 65.4929 65.929 65.7685C66.2301 66.044 66.5923 66.1818 67.0156 66.1818ZM74.4474 58.1534C74.8054 58.1562 75.1634 58.2244 75.5213 58.358C75.8793 58.4915 76.206 58.7131 76.5014 59.0227C76.7969 59.3295 77.0341 59.7486 77.2131 60.2798C77.392 60.8111 77.4815 61.4773 77.4815 62.2784C77.4815 63.054 77.4077 63.7429 77.2599 64.3452C77.1151 64.9446 76.9048 65.4503 76.6293 65.8622C76.3565 66.2741 76.0241 66.5866 75.6321 66.7997C75.2429 67.0128 74.8026 67.1193 74.3111 67.1193C73.8224 67.1193 73.3864 67.0227 73.0028 66.8295C72.6222 66.6335 72.3097 66.3622 72.0653 66.0156C71.8239 65.6662 71.669 65.2614 71.6009 64.8011H72.6406C72.7344 65.2017 72.9205 65.5327 73.1989 65.794C73.4801 66.0526 73.8509 66.1818 74.3111 66.1818C74.9844 66.1818 75.5156 65.8878 75.9048 65.2997C76.2969 64.7116 76.4929 63.8807 76.4929 62.8068H76.4247C76.2656 63.0455 76.0767 63.2514 75.858 63.4247C75.6392 63.598 75.3963 63.7315 75.1293 63.8253C74.8622 63.919 74.5781 63.9659 74.277 63.9659C73.777 63.9659 73.3182 63.8423 72.9006 63.5952C72.4858 63.3452 72.1534 63.0028 71.9034 62.5682C71.6562 62.1307 71.5327 61.6307 71.5327 61.0682C71.5327 60.5341 71.652 60.0455 71.8906 59.6023C72.1321 59.1562 72.4702 58.8011 72.9048 58.5369C73.3423 58.2727 73.8565 58.1449 74.4474 58.1534ZM74.4474 59.0909C74.0895 59.0909 73.767 59.1804 73.4801 59.3594C73.196 59.5355 72.9702 59.7741 72.8026 60.0753C72.6378 60.3736 72.5554 60.7045 72.5554 61.0682C72.5554 61.4318 72.6349 61.7628 72.794 62.0611C72.956 62.3565 73.1761 62.5923 73.4545 62.7685C73.7358 62.9418 74.0554 63.0284 74.4134 63.0284C74.6832 63.0284 74.9347 62.9759 75.1676 62.8707C75.4006 62.7628 75.6037 62.6165 75.777 62.4318C75.9531 62.2443 76.0909 62.0327 76.1903 61.7969C76.2898 61.5582 76.3395 61.3097 76.3395 61.0511C76.3395 60.7102 76.2571 60.3906 76.0923 60.0923C75.9304 59.794 75.706 59.5526 75.419 59.3679C75.1349 59.1832 74.8111 59.0909 74.4474 59.0909ZM82.9244 62.1676V63.1051H79.1062V62.1676H82.9244ZM88.1712 58.2727H89.228V64.5114C89.228 65.0682 89.1257 65.5412 88.9212 65.9304C88.7166 66.3196 88.4283 66.6151 88.0561 66.8168C87.6839 67.0185 87.245 67.1193 86.7393 67.1193C86.2621 67.1193 85.8374 67.0327 85.4652 66.8594C85.093 66.6832 84.8004 66.4332 84.5874 66.1094C84.3743 65.7855 84.2678 65.4006 84.2678 64.9545H85.3075C85.3075 65.2017 85.3686 65.4176 85.4908 65.6023C85.6158 65.7841 85.7862 65.9261 86.0021 66.0284C86.218 66.1307 86.4638 66.1818 86.7393 66.1818C87.0433 66.1818 87.3018 66.1179 87.5149 65.9901C87.728 65.8622 87.8899 65.6747 88.0007 65.4276C88.1143 65.1776 88.1712 64.8722 88.1712 64.5114V58.2727ZM94.0391 67.1193C93.397 67.1193 92.8501 66.9446 92.3984 66.5952C91.9467 66.2429 91.6016 65.733 91.3629 65.0653C91.1243 64.3949 91.005 63.5852 91.005 62.6364C91.005 61.6932 91.1243 60.8878 91.3629 60.2202C91.6044 59.5497 91.951 59.0384 92.4027 58.6861C92.8572 58.331 93.4027 58.1534 94.0391 58.1534C94.6754 58.1534 95.2195 58.331 95.6712 58.6861C96.1257 59.0384 96.4723 59.5497 96.7109 60.2202C96.9524 60.8878 97.0732 61.6932 97.0732 62.6364C97.0732 63.5852 96.9538 64.3949 96.7152 65.0653C96.4766 65.733 96.1314 66.2429 95.6797 66.5952C95.228 66.9446 94.6811 67.1193 94.0391 67.1193ZM94.0391 66.1818C94.6754 66.1818 95.1697 65.875 95.522 65.2614C95.8743 64.6477 96.0504 63.7727 96.0504 62.6364C96.0504 61.8807 95.9695 61.2372 95.8075 60.706C95.6484 60.1747 95.4183 59.7699 95.1172 59.4915C94.8189 59.2131 94.4595 59.0739 94.0391 59.0739C93.4084 59.0739 92.9155 59.3849 92.5604 60.0071C92.2053 60.6264 92.0277 61.5028 92.0277 62.6364C92.0277 63.392 92.1072 64.0341 92.2663 64.5625C92.4254 65.0909 92.6541 65.4929 92.9524 65.7685C93.2536 66.044 93.6158 66.1818 94.0391 66.1818ZM101.539 67.1193C100.897 67.1193 100.35 66.9446 99.8984 66.5952C99.4467 66.2429 99.1016 65.733 98.8629 65.0653C98.6243 64.3949 98.505 63.5852 98.505 62.6364C98.505 61.6932 98.6243 60.8878 98.8629 60.2202C99.1044 59.5497 99.451 59.0384 99.9027 58.6861C100.357 58.331 100.903 58.1534 101.539 58.1534C102.175 58.1534 102.719 58.331 103.171 58.6861C103.626 59.0384 103.972 59.5497 104.211 60.2202C104.452 60.8878 104.573 61.6932 104.573 62.6364C104.573 63.5852 104.454 64.3949 104.215 65.0653C103.977 65.733 103.631 66.2429 103.18 66.5952C102.728 66.9446 102.181 67.1193 101.539 67.1193ZM101.539 66.1818C102.175 66.1818 102.67 65.875 103.022 65.2614C103.374 64.6477 103.55 63.7727 103.55 62.6364C103.55 61.8807 103.469 61.2372 103.308 60.706C103.148 60.1747 102.918 59.7699 102.617 59.4915C102.319 59.2131 101.96 59.0739 101.539 59.0739C100.908 59.0739 100.415 59.3849 100.06 60.0071C99.7053 60.6264 99.5277 61.5028 99.5277 62.6364C99.5277 63.392 99.6072 64.0341 99.7663 64.5625C99.9254 65.0909 100.154 65.4929 100.452 65.7685C100.754 66.044 101.116 66.1818 101.539 66.1818ZM105.988 65.2102V64.3409L109.823 58.2727H110.454V59.6193H110.028L107.13 64.2045V64.2727H112.295V65.2102H105.988ZM110.096 67V64.946V64.5412V58.2727H111.102V67H110.096ZM113.892 67V66.233L116.772 63.0795C117.11 62.7102 117.389 62.3892 117.608 62.1165C117.826 61.8409 117.988 61.5824 118.093 61.3409C118.201 61.0966 118.255 60.8409 118.255 60.5739C118.255 60.267 118.181 60.0014 118.034 59.777C117.889 59.5526 117.69 59.3793 117.437 59.2571C117.184 59.1349 116.9 59.0739 116.585 59.0739C116.25 59.0739 115.957 59.1435 115.707 59.2827C115.46 59.419 115.268 59.6108 115.132 59.858C114.998 60.1051 114.931 60.3949 114.931 60.7273H113.926C113.926 60.2159 114.044 59.767 114.279 59.3807C114.515 58.9943 114.836 58.6932 115.243 58.4773C115.652 58.2614 116.11 58.1534 116.619 58.1534C117.13 58.1534 117.583 58.2614 117.978 58.4773C118.373 58.6932 118.683 58.9844 118.907 59.3509C119.132 59.7173 119.244 60.125 119.244 60.5739C119.244 60.8949 119.186 61.2088 119.069 61.5156C118.956 61.8196 118.757 62.1591 118.473 62.5341C118.191 62.9062 117.801 63.3608 117.301 63.8977L115.341 65.9943V66.0625H119.397V67H113.892ZM121.43 67L125.333 59.2784V59.2102H120.833V58.2727H126.424V59.2614L122.538 67H121.43Z"
            fill="#6B6D76"
          />
        </svg>
      );
    default:
      return;
  }
};

export const ComplianceImageR5: FC<ComplianceImageProps> = ({ model }) => {
  const LogoR = () => (
    <svg>
      <rect x="38.5" y="43" width="13" height="13" stroke="#5A5C61" />
      <path
        d="M42.0568 54V45.2727H45.0057C45.6875 45.2727 46.2472 45.3892 46.6847 45.6222C47.1222 45.8523 47.446 46.169 47.6562 46.5724C47.8665 46.9759 47.9716 47.4347 47.9716 47.9489C47.9716 48.4631 47.8665 48.919 47.6562 49.3168C47.446 49.7145 47.1236 50.027 46.6889 50.2543C46.2543 50.4787 45.6989 50.5909 45.0227 50.5909H42.6364V49.6364H44.9886C45.4545 49.6364 45.8295 49.5682 46.1136 49.4318C46.4006 49.2955 46.608 49.1023 46.7358 48.8523C46.8665 48.5994 46.9318 48.2983 46.9318 47.9489C46.9318 47.5994 46.8665 47.294 46.7358 47.0327C46.6051 46.7713 46.3963 46.5696 46.1094 46.4276C45.8224 46.2827 45.4432 46.2102 44.9716 46.2102H43.1136V54H42.0568ZM46.1648 50.0795L48.3125 54H47.0852L44.9716 50.0795H46.1648Z"
        fill="#5A5C61"
      />
    </svg>
  );
  const Logo5GHZ = () => (
    <svg>
      <path
        d="M41.6307 71.1193C41.1307 71.1193 40.6804 71.0199 40.2798 70.821C39.8793 70.6222 39.5582 70.3494 39.3168 70.0028C39.0753 69.6562 38.9432 69.2614 38.9205 68.8182H39.9432C39.983 69.2131 40.1619 69.5398 40.4801 69.7983C40.8011 70.054 41.1847 70.1818 41.6307 70.1818C41.9886 70.1818 42.3068 70.098 42.5852 69.9304C42.8665 69.7628 43.0866 69.5327 43.2457 69.2401C43.4077 68.9446 43.4886 68.6108 43.4886 68.2386C43.4886 67.858 43.4048 67.5185 43.2372 67.2202C43.0724 66.919 42.8452 66.6818 42.5554 66.5085C42.2656 66.3352 41.9347 66.2472 41.5625 66.2443C41.2955 66.2415 41.0213 66.2827 40.7401 66.3679C40.4588 66.4503 40.2273 66.5568 40.0455 66.6875L39.0568 66.5682L39.5852 62.2727H44.1193V63.2102H40.4716L40.1648 65.7841H40.2159C40.3949 65.642 40.6193 65.5241 40.8892 65.4304C41.1591 65.3366 41.4403 65.2898 41.733 65.2898C42.267 65.2898 42.7429 65.4176 43.1605 65.6733C43.581 65.9261 43.9105 66.2727 44.1491 66.7131C44.3906 67.1534 44.5114 67.6562 44.5114 68.2216C44.5114 68.7784 44.3864 69.2756 44.1364 69.7131C43.8892 70.1477 43.5483 70.4915 43.1136 70.7443C42.679 70.9943 42.1847 71.1193 41.6307 71.1193ZM52.3235 65C52.2298 64.7131 52.1062 64.456 51.9528 64.2287C51.8022 63.9986 51.6218 63.8026 51.4116 63.6406C51.2042 63.4787 50.9684 63.3551 50.7042 63.2699C50.44 63.1847 50.1502 63.142 49.8349 63.142C49.3178 63.142 48.8477 63.2756 48.4244 63.5426C48.0011 63.8097 47.6644 64.2031 47.4144 64.723C47.1644 65.2429 47.0394 65.8807 47.0394 66.6364C47.0394 67.392 47.1658 68.0298 47.4187 68.5497C47.6715 69.0696 48.0138 69.4631 48.4457 69.7301C48.8775 69.9972 49.3633 70.1307 49.9031 70.1307C50.4031 70.1307 50.8434 70.0241 51.2241 69.8111C51.6076 69.5952 51.9059 69.2912 52.119 68.8991C52.3349 68.5043 52.4428 68.0398 52.4428 67.5057L52.7667 67.5739H50.1417V66.6364H53.4656V67.5739C53.4656 68.2926 53.3121 68.9176 53.0053 69.4489C52.7013 69.9801 52.2809 70.392 51.744 70.6847C51.2099 70.9744 50.5962 71.1193 49.9031 71.1193C49.1303 71.1193 48.4513 70.9375 47.8661 70.5739C47.2837 70.2102 46.8292 69.6932 46.5025 69.0227C46.1786 68.3523 46.0167 67.5568 46.0167 66.6364C46.0167 65.946 46.109 65.3253 46.2937 64.7741C46.4812 64.2202 46.7454 63.7486 47.0863 63.3594C47.4272 62.9702 47.8306 62.6719 48.2965 62.4645C48.7624 62.2571 49.2752 62.1534 49.8349 62.1534C50.2951 62.1534 50.7241 62.223 51.1218 62.3622C51.5224 62.4986 51.8789 62.6932 52.1914 62.946C52.5067 63.196 52.7695 63.4957 52.9798 63.8452C53.19 64.1918 53.3349 64.5767 53.4144 65H52.3235ZM55.2756 71V62.2727H56.3324V66.1591H60.9858V62.2727H62.0426V71H60.9858V67.0966H56.3324V71H55.2756ZM63.8345 71V70.233L67.5504 65.4602V65.392H63.9538V64.4545H68.8459V65.2557L65.2322 69.9943V70.0625H68.9652V71H63.8345ZM75.1018 66.284V71.96H75.9898V66.284H75.1018ZM75.1138 60.932V64.448H76.0018V60.932H75.1138ZM71.8858 67.628V71.072H72.7498V68.372H78.9178V67.628H71.8858ZM78.5698 67.628V70.124C78.5698 70.256 78.5338 70.304 78.3658 70.316C78.1978 70.316 77.6338 70.328 76.9858 70.304C77.1178 70.52 77.2378 70.832 77.2858 71.072C78.1258 71.072 78.6778 71.072 79.0258 70.94C79.3738 70.808 79.4578 70.58 79.4578 70.136V67.628H78.5698ZM70.5298 65.624V68H71.3698V66.368H79.7938V68H80.6698V65.624H70.5298ZM72.1738 60.992V64.88H79.0378V60.992H78.1498V64.148H73.0378V60.992H72.1738ZM70.2058 62.192V62.948H80.9938V62.192H70.2058ZM86.2472 66.6364C86.2472 65.5625 86.3864 64.5753 86.6648 63.6747C86.946 62.7713 87.3466 61.9403 87.8665 61.1818H88.7528C88.5483 61.4631 88.3565 61.8097 88.1776 62.2216C88.0014 62.6307 87.8466 63.081 87.7131 63.5724C87.5795 64.0611 87.4744 64.5668 87.3977 65.0895C87.3239 65.6122 87.2869 66.1278 87.2869 66.6364C87.2869 67.3125 87.3523 67.9986 87.483 68.6946C87.6136 69.3906 87.7898 70.0369 88.0114 70.6335C88.233 71.2301 88.4801 71.7159 88.7528 72.0909H87.8665C87.3466 71.3324 86.946 70.5028 86.6648 69.6023C86.3864 68.6989 86.2472 67.7102 86.2472 66.6364ZM91.9585 71L89.5721 62.2727H90.646L92.4698 69.3807H92.555L94.413 62.2727H95.6062L97.4641 69.3807H97.5494L99.3732 62.2727H100.447L98.0607 71H96.9698L95.0437 64.0455H94.9755L93.0494 71H91.9585ZM104.338 71.1193C103.838 71.1193 103.387 71.0199 102.987 70.821C102.586 70.6222 102.265 70.3494 102.024 70.0028C101.782 69.6562 101.65 69.2614 101.627 68.8182H102.65C102.69 69.2131 102.869 69.5398 103.187 69.7983C103.508 70.054 103.892 70.1818 104.338 70.1818C104.696 70.1818 105.014 70.098 105.292 69.9304C105.574 69.7628 105.794 69.5327 105.953 69.2401C106.115 68.9446 106.196 68.6108 106.196 68.2386C106.196 67.858 106.112 67.5185 105.944 67.2202C105.779 66.919 105.552 66.6818 105.262 66.5085C104.973 66.3352 104.642 66.2472 104.27 66.2443C104.002 66.2415 103.728 66.2827 103.447 66.3679C103.166 66.4503 102.934 66.5568 102.752 66.6875L101.764 66.5682L102.292 62.2727H106.826V63.2102H103.179L102.872 65.7841H102.923C103.102 65.642 103.326 65.5241 103.596 65.4304C103.866 65.3366 104.147 65.2898 104.44 65.2898C104.974 65.2898 105.45 65.4176 105.868 65.6733C106.288 65.9261 106.618 66.2727 106.856 66.7131C107.098 67.1534 107.218 67.6562 107.218 68.2216C107.218 68.7784 107.093 69.2756 106.843 69.7131C106.596 70.1477 106.255 70.4915 105.821 70.7443C105.386 70.9943 104.892 71.1193 104.338 71.1193ZM108.911 71V70.233L111.792 67.0795C112.13 66.7102 112.408 66.3892 112.627 66.1165C112.846 65.8409 113.008 65.5824 113.113 65.3409C113.221 65.0966 113.275 64.8409 113.275 64.5739C113.275 64.267 113.201 64.0014 113.053 63.777C112.908 63.5526 112.71 63.3793 112.457 63.2571C112.204 63.1349 111.92 63.0739 111.604 63.0739C111.269 63.0739 110.977 63.1435 110.727 63.2827C110.479 63.419 110.288 63.6108 110.151 63.858C110.018 64.1051 109.951 64.3949 109.951 64.7273H108.945C108.945 64.2159 109.063 63.767 109.299 63.3807C109.535 62.9943 109.856 62.6932 110.262 62.4773C110.671 62.2614 111.13 62.1534 111.638 62.1534C112.15 62.1534 112.603 62.2614 112.998 62.4773C113.393 62.6932 113.702 62.9844 113.927 63.3509C114.151 63.7173 114.263 64.125 114.263 64.5739C114.263 64.8949 114.205 65.2088 114.089 65.5156C113.975 65.8196 113.776 66.1591 113.492 66.5341C113.211 66.9062 112.82 67.3608 112.32 67.8977L110.36 69.9943V70.0625H114.417V71H108.911ZM117.694 69.8068L117.626 70.267C117.577 70.5909 117.504 70.9375 117.404 71.3068C117.308 71.6761 117.207 72.0241 117.102 72.3509C116.996 72.6776 116.91 72.9375 116.842 73.1307H116.075C116.112 72.9489 116.16 72.7088 116.219 72.4105C116.279 72.1122 116.339 71.7784 116.398 71.4091C116.461 71.0426 116.512 70.6676 116.552 70.2841L116.603 69.8068H117.694ZM124.654 71L122.267 62.2727H123.341L125.165 69.3807H125.25L127.108 62.2727H128.301L130.159 69.3807H130.245L132.069 62.2727H133.142L130.756 71H129.665L127.739 64.0455H127.671L125.745 71H124.654ZM137.033 71.1193C136.533 71.1193 136.083 71.0199 135.682 70.821C135.282 70.6222 134.961 70.3494 134.719 70.0028C134.478 69.6562 134.346 69.2614 134.323 68.8182H135.346C135.385 69.2131 135.564 69.5398 135.882 69.7983C136.203 70.054 136.587 70.1818 137.033 70.1818C137.391 70.1818 137.709 70.098 137.988 69.9304C138.269 69.7628 138.489 69.5327 138.648 69.2401C138.81 68.9446 138.891 68.6108 138.891 68.2386C138.891 67.858 138.807 67.5185 138.64 67.2202C138.475 66.919 138.248 66.6818 137.958 66.5085C137.668 66.3352 137.337 66.2472 136.965 66.2443C136.698 66.2415 136.424 66.2827 136.142 66.3679C135.861 66.4503 135.63 66.5568 135.448 66.6875L134.459 66.5682L134.988 62.2727H139.522V63.2102H135.874L135.567 65.7841H135.618C135.797 65.642 136.022 65.5241 136.292 65.4304C136.561 65.3366 136.843 65.2898 137.135 65.2898C137.669 65.2898 138.145 65.4176 138.563 65.6733C138.983 65.9261 139.313 66.2727 139.551 66.7131C139.793 67.1534 139.914 67.6562 139.914 68.2216C139.914 68.7784 139.789 69.2756 139.539 69.7131C139.292 70.1477 138.951 70.4915 138.516 70.7443C138.081 70.9943 137.587 71.1193 137.033 71.1193ZM144.555 71.1193C143.993 71.1193 143.491 71.0227 143.051 70.8295C142.614 70.6364 142.266 70.3679 142.007 70.0241C141.751 69.6776 141.612 69.2756 141.589 68.8182H142.663C142.686 69.0994 142.783 69.3423 142.953 69.5469C143.124 69.7486 143.347 69.9048 143.622 70.0156C143.898 70.1264 144.203 70.1818 144.538 70.1818C144.913 70.1818 145.246 70.1165 145.536 69.9858C145.825 69.8551 146.053 69.6733 146.217 69.4403C146.382 69.2074 146.464 68.9375 146.464 68.6307C146.464 68.3097 146.385 68.027 146.226 67.7827C146.067 67.5355 145.834 67.3423 145.527 67.2031C145.22 67.0639 144.845 66.9943 144.402 66.9943H143.703V66.0568H144.402C144.749 66.0568 145.053 65.9943 145.314 65.8693C145.578 65.7443 145.784 65.5682 145.932 65.3409C146.082 65.1136 146.158 64.8466 146.158 64.5398C146.158 64.2443 146.092 63.9872 145.962 63.7685C145.831 63.5497 145.646 63.3793 145.408 63.2571C145.172 63.1349 144.893 63.0739 144.572 63.0739C144.271 63.0739 143.987 63.1293 143.72 63.2401C143.456 63.348 143.24 63.5057 143.072 63.7131C142.905 63.9176 142.814 64.1648 142.8 64.4545H141.777C141.794 63.9972 141.932 63.5966 142.19 63.2528C142.449 62.9062 142.787 62.6364 143.205 62.4432C143.625 62.25 144.087 62.1534 144.589 62.1534C145.129 62.1534 145.592 62.2628 145.979 62.4815C146.365 62.6974 146.662 62.983 146.869 63.3381C147.077 63.6932 147.18 64.0767 147.18 64.4886C147.18 64.9801 147.051 65.3991 146.793 65.7457C146.537 66.0923 146.189 66.3324 145.749 66.4659V66.5341C146.3 66.625 146.73 66.8594 147.04 67.2372C147.349 67.6122 147.504 68.0767 147.504 68.6307C147.504 69.1051 147.375 69.5312 147.116 69.9091C146.861 70.2841 146.511 70.5795 146.068 70.7955C145.625 71.0114 145.121 71.1193 144.555 71.1193ZM151.412 66.6364C151.412 67.7102 151.271 68.6989 150.99 69.6023C150.712 70.5028 150.313 71.3324 149.793 72.0909H148.906C149.111 71.8097 149.301 71.4631 149.477 71.0511C149.656 70.642 149.813 70.1932 149.946 69.7045C150.08 69.2131 150.183 68.706 150.257 68.1832C150.334 67.6577 150.372 67.142 150.372 66.6364C150.372 65.9602 150.307 65.2741 150.176 64.5781C150.045 63.8821 149.869 63.2358 149.648 62.6392C149.426 62.0426 149.179 61.5568 148.906 61.1818H149.793C150.313 61.9403 150.712 62.7713 150.99 63.6747C151.271 64.5753 151.412 65.5625 151.412 66.6364ZM154.345 69.8835C154.135 69.8835 153.954 69.8082 153.804 69.6577C153.653 69.5071 153.578 69.3267 153.578 69.1165C153.578 68.9062 153.653 68.7259 153.804 68.5753C153.954 68.4247 154.135 68.3494 154.345 68.3494C154.555 68.3494 154.735 68.4247 154.886 68.5753C155.037 68.7259 155.112 68.9062 155.112 69.1165C155.112 69.2557 155.076 69.3835 155.005 69.5C154.937 69.6165 154.845 69.7102 154.728 69.7812C154.615 69.8494 154.487 69.8835 154.345 69.8835ZM154.345 65.4688C154.135 65.4688 153.954 65.3935 153.804 65.2429C153.653 65.0923 153.578 64.9119 153.578 64.7017C153.578 64.4915 153.653 64.3111 153.804 64.1605C153.954 64.0099 154.135 63.9347 154.345 63.9347C154.555 63.9347 154.735 64.0099 154.886 64.1605C155.037 64.3111 155.112 64.4915 155.112 64.7017C155.112 64.8409 155.076 64.9688 155.005 65.0852C154.937 65.2017 154.845 65.2955 154.728 65.3665C154.615 65.4347 154.487 65.4688 154.345 65.4688ZM157.736 61.532V64.892C157.736 66.836 157.628 69.572 156.428 71.504C156.656 71.6 157.052 71.816 157.22 71.972C158.468 69.956 158.636 66.956 158.636 64.892V61.532H157.736ZM158.216 61.532V62.288H165.74V63.548H158.216V64.304H166.64V61.532H158.216ZM158.66 65.096V65.828H166.988V65.096H158.66ZM159.2 68.828V69.584H166.424V68.828H159.2ZM158.288 70.88V71.624H167.36V70.88H158.288ZM162.308 67.7V71.36H163.196V67.7H162.308ZM158.924 67.208L158.984 67.952C160.712 67.892 163.316 67.796 165.764 67.676L165.8 66.98C163.244 67.088 160.592 67.172 158.924 67.208ZM161.384 65.24C161.084 65.9 160.532 66.86 160.088 67.448L160.796 67.736C161.252 67.172 161.816 66.296 162.284 65.552L161.384 65.24ZM163.7 66.284C164.612 66.86 165.692 67.724 166.208 68.336L166.916 67.832C166.388 67.232 165.284 66.392 164.372 65.84L163.7 66.284ZM173.408 65.792C174.632 66.896 176.168 68.432 176.888 69.38L177.632 68.804C176.864 67.868 175.304 66.368 174.08 65.312L173.408 65.792ZM173.54 60.92V63.272C173.54 64.928 173.384 67.244 170.384 68.864C170.588 69.02 170.9 69.344 171.02 69.536C174.116 67.724 174.464 65.192 174.464 63.272V60.92H173.54ZM169.172 62.972V71.984H170.072V63.86H178.352V62.972H169.172ZM177.944 62.972V70.772C177.944 70.976 177.872 71.048 177.644 71.06C177.404 71.072 176.588 71.072 175.736 71.036C175.856 71.288 176 71.708 176.036 71.96C177.116 71.96 177.86 71.948 178.28 71.804C178.688 71.648 178.832 71.36 178.832 70.772V62.972H177.944ZM183.836 62.252V63.092H191.54V62.252H183.836ZM185.024 65.024H190.268V66.824H185.024V65.024ZM184.196 64.256V67.592H191.144V64.256H184.196ZM184.94 67.832L184.196 68.084C185.468 70.28 187.928 71.528 191.108 71.984C191.228 71.732 191.456 71.372 191.648 71.18C188.528 70.832 186.068 69.716 184.94 67.832ZM187.172 60.968V66.272C187.172 68.3 186.968 70.352 183.404 71.252C183.584 71.444 183.836 71.804 183.944 72.008C187.664 70.904 188.06 68.6 188.06 66.284V60.968H187.172ZM183.32 60.896C182.624 62.72 181.448 64.508 180.236 65.648C180.404 65.864 180.656 66.332 180.74 66.536C182.072 65.204 183.356 63.188 184.172 61.16L183.32 60.896ZM182.06 64.04V72.02H182.924V63.2L182.912 63.188L182.06 64.04ZM194.336 61.772V62.636H202.1V61.772H194.336ZM194.336 64.568V65.42H202.088V64.568H194.336ZM194.276 67.436V68.288H202.112V67.436H194.276ZM193.832 61.772V66.116C193.832 67.808 193.7 69.944 192.38 71.432C192.572 71.552 192.932 71.852 193.076 72.032C194.504 70.436 194.72 67.952 194.72 66.128V61.772H193.832ZM201.74 61.772V70.736C201.74 70.964 201.656 71.036 201.428 71.048C201.2 71.048 200.384 71.06 199.532 71.024C199.664 71.264 199.808 71.66 199.844 71.9C200.984 71.912 201.68 71.9 202.088 71.756C202.484 71.6 202.628 71.324 202.628 70.736V61.772H201.74ZM197.6 62.096V71.852H198.512V62.096H197.6ZM209.84 63.728V64.484H214.316V63.728H209.84ZM207.968 70.916L208.268 71.792C209.432 71.528 211.04 71.18 212.552 70.832L212.492 70.04C210.812 70.376 209.072 70.724 207.968 70.916ZM209.324 61.46V70.988H210.2V61.46H209.324ZM209.84 61.46V62.252H213.86V65.996H209.84V66.788H214.736V61.46H209.84ZM212.156 66.272L211.412 66.416C211.964 68.948 213.08 70.976 214.952 71.924C215.084 71.696 215.348 71.36 215.552 71.18C213.764 70.388 212.672 68.516 212.156 66.272ZM214.544 67.064C214.04 67.64 213.14 68.396 212.492 68.864L213.056 69.32C213.728 68.876 214.58 68.204 215.252 67.58L214.544 67.064ZM204.968 61.448V71.972H205.82V62.264H208.04V61.448H204.968ZM207.776 61.448V61.7C207.5 62.528 207.008 63.98 206.528 65.072C207.464 66.008 207.716 66.8 207.716 67.46C207.728 67.832 207.656 68.144 207.452 68.276C207.332 68.348 207.188 68.384 207.032 68.396C206.816 68.408 206.552 68.408 206.24 68.372C206.384 68.612 206.456 68.972 206.468 69.188C206.768 69.212 207.104 69.212 207.38 69.176C207.632 69.152 207.86 69.08 208.04 68.96C208.4 68.708 208.556 68.216 208.556 67.556C208.556 66.812 208.328 65.96 207.356 64.964C207.8 64.016 208.304 62.78 208.688 61.784L208.076 61.412L207.944 61.448H207.776ZM218.528 64.592V65.456H225.524V64.592H218.528ZM221.984 67.46V68.312H226.028V67.46H221.984ZM221.504 65.036V70.988L222.44 71.108V65.036H221.504ZM218.66 66.488C218.396 68.66 217.748 70.376 216.404 71.42C216.62 71.552 217.004 71.864 217.148 72.02C218.504 70.844 219.26 69.008 219.596 66.584L218.66 66.488ZM219.224 68.036L218.492 68.312C219.524 71.24 221.48 71.804 224.336 71.804H227.156C227.192 71.54 227.348 71.108 227.492 70.892C226.904 70.904 224.828 70.904 224.384 70.904C221.948 70.904 220.076 70.484 219.224 68.036ZM221.492 60.932V62.876H222.44V60.932H221.492ZM216.98 62.3V64.916H217.868V63.164H226.088V64.916H227.012V62.3H216.98Z"
        fill="#6B6D76"
      />
    </svg>
  );
  switch (model) {
    case DeviceModel.UHDIW:
      return (
        <svg width="260" height="105" viewBox="0 0 260 105" fill="none" xmlns="http://www.w3.org/2000/svg">
          <ComplianceImage />
          <JapaneseTelecomLogo />
          <LogoR />
          <path
            d="M58.9034 54V53.233L61.7841 50.0795C62.1222 49.7102 62.4006 49.3892 62.6193 49.1165C62.8381 48.8409 63 48.5824 63.1051 48.3409C63.2131 48.0966 63.267 47.8409 63.267 47.5739C63.267 47.267 63.1932 47.0014 63.0455 46.777C62.9006 46.5526 62.7017 46.3793 62.4489 46.2571C62.196 46.1349 61.9119 46.0739 61.5966 46.0739C61.2614 46.0739 60.9688 46.1435 60.7188 46.2827C60.4716 46.419 60.2798 46.6108 60.1435 46.858C60.0099 47.1051 59.9432 47.3949 59.9432 47.7273H58.9375C58.9375 47.2159 59.0554 46.767 59.2912 46.3807C59.527 45.9943 59.848 45.6932 60.2543 45.4773C60.6634 45.2614 61.1222 45.1534 61.6307 45.1534C62.142 45.1534 62.5952 45.2614 62.9901 45.4773C63.3849 45.6932 63.6946 45.9844 63.919 46.3509C64.1435 46.7173 64.2557 47.125 64.2557 47.5739C64.2557 47.8949 64.1974 48.2088 64.081 48.5156C63.9673 48.8196 63.7685 49.1591 63.4844 49.5341C63.2031 49.9062 62.8125 50.3608 62.3125 50.8977L60.3523 52.9943V53.0625H64.4091V54H58.9034ZM69.0156 54.1193C68.3736 54.1193 67.8267 53.9446 67.375 53.5952C66.9233 53.2429 66.5781 52.733 66.3395 52.0653C66.1009 51.3949 65.9815 50.5852 65.9815 49.6364C65.9815 48.6932 66.1009 47.8878 66.3395 47.2202C66.581 46.5497 66.9276 46.0384 67.3793 45.6861C67.8338 45.331 68.3793 45.1534 69.0156 45.1534C69.652 45.1534 70.196 45.331 70.6477 45.6861C71.1023 46.0384 71.4489 46.5497 71.6875 47.2202C71.929 47.8878 72.0497 48.6932 72.0497 49.6364C72.0497 50.5852 71.9304 51.3949 71.6918 52.0653C71.4531 52.733 71.108 53.2429 70.6562 53.5952C70.2045 53.9446 69.6577 54.1193 69.0156 54.1193ZM69.0156 53.1818C69.652 53.1818 70.1463 52.875 70.4986 52.2614C70.8509 51.6477 71.027 50.7727 71.027 49.6364C71.027 48.8807 70.946 48.2372 70.7841 47.706C70.625 47.1747 70.3949 46.7699 70.0938 46.4915C69.7955 46.2131 69.4361 46.0739 69.0156 46.0739C68.3849 46.0739 67.892 46.3849 67.5369 47.0071C67.1818 47.6264 67.0043 48.5028 67.0043 49.6364C67.0043 50.392 67.0838 51.0341 67.2429 51.5625C67.402 52.0909 67.6307 52.4929 67.929 52.7685C68.2301 53.044 68.5923 53.1818 69.0156 53.1818ZM76.7372 45.2727V54H75.6804V46.3807H75.6293L73.4986 47.7955V46.7216L75.6804 45.2727H76.7372ZM83.0142 49.1676V50.1051H79.196V49.1676H83.0142ZM87.8349 45.2727V54H86.7781V46.3807H86.7269L84.5962 47.7955V46.7216L86.7781 45.2727H87.8349ZM93.1232 45.1534C93.4812 45.1562 93.8391 45.2244 94.1971 45.358C94.555 45.4915 94.8817 45.7131 95.1772 46.0227C95.4727 46.3295 95.7099 46.7486 95.8888 47.2798C96.0678 47.8111 96.1573 48.4773 96.1573 49.2784C96.1573 50.054 96.0835 50.7429 95.9357 51.3452C95.7908 51.9446 95.5806 52.4503 95.305 52.8622C95.0323 53.2741 94.6999 53.5866 94.3079 53.7997C93.9187 54.0128 93.4783 54.1193 92.9869 54.1193C92.4982 54.1193 92.0621 54.0227 91.6786 53.8295C91.2979 53.6335 90.9854 53.3622 90.7411 53.0156C90.4996 52.6662 90.3448 52.2614 90.2766 51.8011H91.3164C91.4102 52.2017 91.5962 52.5327 91.8746 52.794C92.1559 53.0526 92.5266 53.1818 92.9869 53.1818C93.6602 53.1818 94.1914 52.8878 94.5806 52.2997C94.9727 51.7116 95.1687 50.8807 95.1687 49.8068H95.1005C94.9414 50.0455 94.7525 50.2514 94.5337 50.4247C94.315 50.598 94.0721 50.7315 93.805 50.8253C93.538 50.919 93.2539 50.9659 92.9528 50.9659C92.4528 50.9659 91.994 50.8423 91.5763 50.5952C91.1616 50.3452 90.8292 50.0028 90.5792 49.5682C90.332 49.1307 90.2085 48.6307 90.2085 48.0682C90.2085 47.5341 90.3278 47.0455 90.5664 46.6023C90.8079 46.1562 91.146 45.8011 91.5806 45.5369C92.0181 45.2727 92.5323 45.1449 93.1232 45.1534ZM93.1232 46.0909C92.7653 46.0909 92.4428 46.1804 92.1559 46.3594C91.8718 46.5355 91.646 46.7741 91.4783 47.0753C91.3136 47.3736 91.2312 47.7045 91.2312 48.0682C91.2312 48.4318 91.3107 48.7628 91.4698 49.0611C91.6317 49.3565 91.8519 49.5923 92.1303 49.7685C92.4116 49.9418 92.7312 50.0284 93.0891 50.0284C93.359 50.0284 93.6104 49.9759 93.8434 49.8707C94.0763 49.7628 94.2795 49.6165 94.4528 49.4318C94.6289 49.2443 94.7667 49.0327 94.8661 48.7969C94.9656 48.5582 95.0153 48.3097 95.0153 48.0511C95.0153 47.7102 94.9329 47.3906 94.7681 47.0923C94.6062 46.794 94.3817 46.5526 94.0948 46.3679C93.8107 46.1832 93.4869 46.0909 93.1232 46.0909ZM100.68 54.1193C100.038 54.1193 99.4908 53.9446 99.0391 53.5952C98.5874 53.2429 98.2422 52.733 98.0036 52.0653C97.7649 51.3949 97.6456 50.5852 97.6456 49.6364C97.6456 48.6932 97.7649 47.8878 98.0036 47.2202C98.245 46.5497 98.5916 46.0384 99.0433 45.6861C99.4979 45.331 100.043 45.1534 100.68 45.1534C101.316 45.1534 101.86 45.331 102.312 45.6861C102.766 46.0384 103.113 46.5497 103.352 47.2202C103.593 47.8878 103.714 48.6932 103.714 49.6364C103.714 50.5852 103.594 51.3949 103.356 52.0653C103.117 52.733 102.772 53.2429 102.32 53.5952C101.869 53.9446 101.322 54.1193 100.68 54.1193ZM100.68 53.1818C101.316 53.1818 101.81 52.875 102.163 52.2614C102.515 51.6477 102.691 50.7727 102.691 49.6364C102.691 48.8807 102.61 48.2372 102.448 47.706C102.289 47.1747 102.059 46.7699 101.758 46.4915C101.46 46.2131 101.1 46.0739 100.68 46.0739C100.049 46.0739 99.5561 46.3849 99.201 47.0071C98.8459 47.6264 98.6683 48.5028 98.6683 49.6364C98.6683 50.392 98.7479 51.0341 98.907 51.5625C99.0661 52.0909 99.2947 52.4929 99.593 52.7685C99.8942 53.044 100.256 53.1818 100.68 53.1818ZM108.401 45.2727V54H107.344V46.3807H107.293L105.163 47.7955V46.7216L107.344 45.2727H108.401ZM110.911 54V53.233L113.792 50.0795C114.13 49.7102 114.408 49.3892 114.627 49.1165C114.846 48.8409 115.008 48.5824 115.113 48.3409C115.221 48.0966 115.275 47.8409 115.275 47.5739C115.275 47.267 115.201 47.0014 115.053 46.777C114.908 46.5526 114.71 46.3793 114.457 46.2571C114.204 46.1349 113.92 46.0739 113.604 46.0739C113.269 46.0739 112.977 46.1435 112.727 46.2827C112.479 46.419 112.288 46.6108 112.151 46.858C112.018 47.1051 111.951 47.3949 111.951 47.7273H110.945C110.945 47.2159 111.063 46.767 111.299 46.3807C111.535 45.9943 111.856 45.6932 112.262 45.4773C112.671 45.2614 113.13 45.1534 113.638 45.1534C114.15 45.1534 114.603 45.2614 114.998 45.4773C115.393 45.6932 115.702 45.9844 115.927 46.3509C116.151 46.7173 116.263 47.125 116.263 47.5739C116.263 47.8949 116.205 48.2088 116.089 48.5156C115.975 48.8196 115.776 49.1591 115.492 49.5341C115.211 49.9062 114.82 50.3608 114.32 50.8977L112.36 52.9943V53.0625H116.417V54H110.911ZM121.245 45.2727V54H120.188V46.3807H120.137L118.006 47.7955V46.7216L120.188 45.2727H121.245Z"
            fill="#6B6D76"
          />
          <Logo5GHZ />
        </svg>
      );
    case DeviceModel.U6M:
      return (
        <svg width="260" height="105" viewBox="0 0 260 105" fill="none" xmlns="http://www.w3.org/2000/svg">
          <ComplianceImage />
          <JapaneseTelecomLogo />
          <LogoR />
          <path
            d="M62.2784 54V53.233L65.1591 50.0795C65.4972 49.7102 65.7756 49.3892 65.9943 49.1165C66.2131 48.8409 66.375 48.5824 66.4801 48.3409C66.5881 48.0966 66.642 47.8409 66.642 47.5739C66.642 47.267 66.5682 47.0014 66.4205 46.777C66.2756 46.5526 66.0767 46.3793 65.8239 46.2571C65.571 46.1349 65.2869 46.0739 64.9716 46.0739C64.6364 46.0739 64.3438 46.1435 64.0938 46.2827C63.8466 46.419 63.6548 46.6108 63.5185 46.858C63.3849 47.1051 63.3182 47.3949 63.3182 47.7273H62.3125C62.3125 47.2159 62.4304 46.767 62.6662 46.3807C62.902 45.9943 63.223 45.6932 63.6293 45.4773C64.0384 45.2614 64.4972 45.1534 65.0057 45.1534C65.517 45.1534 65.9702 45.2614 66.3651 45.4773C66.7599 45.6932 67.0696 45.9844 67.294 46.3509C67.5185 46.7173 67.6307 47.125 67.6307 47.5739C67.6307 47.8949 67.5724 48.2088 67.456 48.5156C67.3423 48.8196 67.1435 49.1591 66.8594 49.5341C66.5781 49.9062 66.1875 50.3608 65.6875 50.8977L63.7273 52.9943V53.0625H67.7841V54H62.2784ZM72.3906 54.1193C71.7486 54.1193 71.2017 53.9446 70.75 53.5952C70.2983 53.2429 69.9531 52.733 69.7145 52.0653C69.4759 51.3949 69.3565 50.5852 69.3565 49.6364C69.3565 48.6932 69.4759 47.8878 69.7145 47.2202C69.956 46.5497 70.3026 46.0384 70.7543 45.6861C71.2088 45.331 71.7543 45.1534 72.3906 45.1534C73.027 45.1534 73.571 45.331 74.0227 45.6861C74.4773 46.0384 74.8239 46.5497 75.0625 47.2202C75.304 47.8878 75.4247 48.6932 75.4247 49.6364C75.4247 50.5852 75.3054 51.3949 75.0668 52.0653C74.8281 52.733 74.483 53.2429 74.0312 53.5952C73.5795 53.9446 73.0327 54.1193 72.3906 54.1193ZM72.3906 53.1818C73.027 53.1818 73.5213 52.875 73.8736 52.2614C74.2259 51.6477 74.402 50.7727 74.402 49.6364C74.402 48.8807 74.321 48.2372 74.1591 47.706C74 47.1747 73.7699 46.7699 73.4688 46.4915C73.1705 46.2131 72.8111 46.0739 72.3906 46.0739C71.7599 46.0739 71.267 46.3849 70.9119 47.0071C70.5568 47.6264 70.3793 48.5028 70.3793 49.6364C70.3793 50.392 70.4588 51.0341 70.6179 51.5625C70.777 52.0909 71.0057 52.4929 71.304 52.7685C71.6051 53.044 71.9673 53.1818 72.3906 53.1818ZM80.1122 45.2727V54H79.0554V46.3807H79.0043L76.8736 47.7955V46.7216L79.0554 45.2727H80.1122ZM86.3892 49.1676V50.1051H82.571V49.1676H86.3892ZM87.7315 54V53.233L90.6122 50.0795C90.9503 49.7102 91.2287 49.3892 91.4474 49.1165C91.6662 48.8409 91.8281 48.5824 91.9332 48.3409C92.0412 48.0966 92.0952 47.8409 92.0952 47.5739C92.0952 47.267 92.0213 47.0014 91.8736 46.777C91.7287 46.5526 91.5298 46.3793 91.277 46.2571C91.0241 46.1349 90.7401 46.0739 90.4247 46.0739C90.0895 46.0739 89.7969 46.1435 89.5469 46.2827C89.2997 46.419 89.108 46.6108 88.9716 46.858C88.8381 47.1051 88.7713 47.3949 88.7713 47.7273H87.7656C87.7656 47.2159 87.8835 46.767 88.1193 46.3807C88.3551 45.9943 88.6761 45.6932 89.0824 45.4773C89.4915 45.2614 89.9503 45.1534 90.4588 45.1534C90.9702 45.1534 91.4233 45.2614 91.8182 45.4773C92.2131 45.6932 92.5227 45.9844 92.7472 46.3509C92.9716 46.7173 93.0838 47.125 93.0838 47.5739C93.0838 47.8949 93.0256 48.2088 92.9091 48.5156C92.7955 48.8196 92.5966 49.1591 92.3125 49.5341C92.0312 49.9062 91.6406 50.3608 91.1406 50.8977L89.1804 52.9943V53.0625H93.2372V54H87.7315ZM94.9972 54V53.233L97.8778 50.0795C98.2159 49.7102 98.4943 49.3892 98.7131 49.1165C98.9318 48.8409 99.0938 48.5824 99.1989 48.3409C99.3068 48.0966 99.3608 47.8409 99.3608 47.5739C99.3608 47.267 99.2869 47.0014 99.1392 46.777C98.9943 46.5526 98.7955 46.3793 98.5426 46.2571C98.2898 46.1349 98.0057 46.0739 97.6903 46.0739C97.3551 46.0739 97.0625 46.1435 96.8125 46.2827C96.5653 46.419 96.3736 46.6108 96.2372 46.858C96.1037 47.1051 96.0369 47.3949 96.0369 47.7273H95.0312C95.0312 47.2159 95.1491 46.767 95.3849 46.3807C95.6207 45.9943 95.9418 45.6932 96.348 45.4773C96.7571 45.2614 97.2159 45.1534 97.7244 45.1534C98.2358 45.1534 98.6889 45.2614 99.0838 45.4773C99.4787 45.6932 99.7884 45.9844 100.013 46.3509C100.237 46.7173 100.349 47.125 100.349 47.5739C100.349 47.8949 100.291 48.2088 100.175 48.5156C100.061 48.8196 99.8622 49.1591 99.5781 49.5341C99.2969 49.9062 98.9062 50.3608 98.4062 50.8977L96.446 52.9943V53.0625H100.503V54H94.9972ZM105.109 54.1193C104.467 54.1193 103.92 53.9446 103.469 53.5952C103.017 53.2429 102.672 52.733 102.433 52.0653C102.195 51.3949 102.075 50.5852 102.075 49.6364C102.075 48.6932 102.195 47.8878 102.433 47.2202C102.675 46.5497 103.021 46.0384 103.473 45.6861C103.928 45.331 104.473 45.1534 105.109 45.1534C105.746 45.1534 106.29 45.331 106.741 45.6861C107.196 46.0384 107.543 46.5497 107.781 47.2202C108.023 47.8878 108.143 48.6932 108.143 49.6364C108.143 50.5852 108.024 51.3949 107.786 52.0653C107.547 52.733 107.202 53.2429 106.75 53.5952C106.298 53.9446 105.751 54.1193 105.109 54.1193ZM105.109 53.1818C105.746 53.1818 106.24 52.875 106.592 52.2614C106.945 51.6477 107.121 50.7727 107.121 49.6364C107.121 48.8807 107.04 48.2372 106.878 47.706C106.719 47.1747 106.489 46.7699 106.188 46.4915C105.889 46.2131 105.53 46.0739 105.109 46.0739C104.479 46.0739 103.986 46.3849 103.631 47.0071C103.276 47.6264 103.098 48.5028 103.098 49.6364C103.098 50.392 103.178 51.0341 103.337 51.5625C103.496 52.0909 103.724 52.4929 104.023 52.7685C104.324 53.044 104.686 53.1818 105.109 53.1818ZM112.609 54.1193C111.967 54.1193 111.42 53.9446 110.969 53.5952C110.517 53.2429 110.172 52.733 109.933 52.0653C109.695 51.3949 109.575 50.5852 109.575 49.6364C109.575 48.6932 109.695 47.8878 109.933 47.2202C110.175 46.5497 110.521 46.0384 110.973 45.6861C111.428 45.331 111.973 45.1534 112.609 45.1534C113.246 45.1534 113.79 45.331 114.241 45.6861C114.696 46.0384 115.043 46.5497 115.281 47.2202C115.523 47.8878 115.643 48.6932 115.643 49.6364C115.643 50.5852 115.524 51.3949 115.286 52.0653C115.047 52.733 114.702 53.2429 114.25 53.5952C113.798 53.9446 113.251 54.1193 112.609 54.1193ZM112.609 53.1818C113.246 53.1818 113.74 52.875 114.092 52.2614C114.445 51.6477 114.621 50.7727 114.621 49.6364C114.621 48.8807 114.54 48.2372 114.378 47.706C114.219 47.1747 113.989 46.7699 113.688 46.4915C113.389 46.2131 113.03 46.0739 112.609 46.0739C111.979 46.0739 111.486 46.3849 111.131 47.0071C110.776 47.6264 110.598 48.5028 110.598 49.6364C110.598 50.392 110.678 51.0341 110.837 51.5625C110.996 52.0909 111.224 52.4929 111.523 52.7685C111.824 53.044 112.186 53.1818 112.609 53.1818ZM117.263 54V53.233L120.143 50.0795C120.482 49.7102 120.76 49.3892 120.979 49.1165C121.197 48.8409 121.359 48.5824 121.464 48.3409C121.572 48.0966 121.626 47.8409 121.626 47.5739C121.626 47.267 121.553 47.0014 121.405 46.777C121.26 46.5526 121.061 46.3793 120.808 46.2571C120.555 46.1349 120.271 46.0739 119.956 46.0739C119.621 46.0739 119.328 46.1435 119.078 46.2827C118.831 46.419 118.639 46.6108 118.503 46.858C118.369 47.1051 118.303 47.3949 118.303 47.7273H117.297C117.297 47.2159 117.415 46.767 117.651 46.3807C117.886 45.9943 118.207 45.6932 118.614 45.4773C119.023 45.2614 119.482 45.1534 119.99 45.1534C120.501 45.1534 120.955 45.2614 121.349 45.4773C121.744 45.6932 122.054 45.9844 122.278 46.3509C122.503 46.7173 122.615 47.125 122.615 47.5739C122.615 47.8949 122.557 48.2088 122.44 48.5156C122.327 48.8196 122.128 49.1591 121.844 49.5341C121.562 49.9062 121.172 50.3608 120.672 50.8977L118.712 52.9943V53.0625H122.768V54H117.263ZM124.528 54V53.233L127.409 50.0795C127.747 49.7102 128.026 49.3892 128.244 49.1165C128.463 48.8409 128.625 48.5824 128.73 48.3409C128.838 48.0966 128.892 47.8409 128.892 47.5739C128.892 47.267 128.818 47.0014 128.67 46.777C128.526 46.5526 128.327 46.3793 128.074 46.2571C127.821 46.1349 127.537 46.0739 127.222 46.0739C126.886 46.0739 126.594 46.1435 126.344 46.2827C126.097 46.419 125.905 46.6108 125.768 46.858C125.635 47.1051 125.568 47.3949 125.568 47.7273H124.562C124.562 47.2159 124.68 46.767 124.916 46.3807C125.152 45.9943 125.473 45.6932 125.879 45.4773C126.288 45.2614 126.747 45.1534 127.256 45.1534C127.767 45.1534 128.22 45.2614 128.615 45.4773C129.01 45.6932 129.32 45.9844 129.544 46.3509C129.768 46.7173 129.881 47.125 129.881 47.5739C129.881 47.8949 129.822 48.2088 129.706 48.5156C129.592 48.8196 129.393 49.1591 129.109 49.5341C128.828 49.9062 128.438 50.3608 127.938 50.8977L125.977 52.9943V53.0625H130.034V54H124.528Z"
            fill="#6B6D76"
          />
          <Logo5GHZ />
        </svg>
      );
    case DeviceModel.U6EXT:
      return (
        <svg width="260" height="105" viewBox="0 0 260 105" fill="none" xmlns="http://www.w3.org/2000/svg">
          <ComplianceImage />
          <JapaneseTelecomLogo />
          <LogoR />
          <path
            d="M58.9034 54V53.233L61.7841 50.0795C62.1222 49.7102 62.4006 49.3892 62.6193 49.1165C62.8381 48.8409 63 48.5824 63.1051 48.3409C63.2131 48.0966 63.267 47.8409 63.267 47.5739C63.267 47.267 63.1932 47.0014 63.0455 46.777C62.9006 46.5526 62.7017 46.3793 62.4489 46.2571C62.196 46.1349 61.9119 46.0739 61.5966 46.0739C61.2614 46.0739 60.9688 46.1435 60.7188 46.2827C60.4716 46.419 60.2798 46.6108 60.1435 46.858C60.0099 47.1051 59.9432 47.3949 59.9432 47.7273H58.9375C58.9375 47.2159 59.0554 46.767 59.2912 46.3807C59.527 45.9943 59.848 45.6932 60.2543 45.4773C60.6634 45.2614 61.1222 45.1534 61.6307 45.1534C62.142 45.1534 62.5952 45.2614 62.9901 45.4773C63.3849 45.6932 63.6946 45.9844 63.919 46.3509C64.1435 46.7173 64.2557 47.125 64.2557 47.5739C64.2557 47.8949 64.1974 48.2088 64.081 48.5156C63.9673 48.8196 63.7685 49.1591 63.4844 49.5341C63.2031 49.9062 62.8125 50.3608 62.3125 50.8977L60.3523 52.9943V53.0625H64.4091V54H58.9034ZM69.0156 54.1193C68.3736 54.1193 67.8267 53.9446 67.375 53.5952C66.9233 53.2429 66.5781 52.733 66.3395 52.0653C66.1009 51.3949 65.9815 50.5852 65.9815 49.6364C65.9815 48.6932 66.1009 47.8878 66.3395 47.2202C66.581 46.5497 66.9276 46.0384 67.3793 45.6861C67.8338 45.331 68.3793 45.1534 69.0156 45.1534C69.652 45.1534 70.196 45.331 70.6477 45.6861C71.1023 46.0384 71.4489 46.5497 71.6875 47.2202C71.929 47.8878 72.0497 48.6932 72.0497 49.6364C72.0497 50.5852 71.9304 51.3949 71.6918 52.0653C71.4531 52.733 71.108 53.2429 70.6562 53.5952C70.2045 53.9446 69.6577 54.1193 69.0156 54.1193ZM69.0156 53.1818C69.652 53.1818 70.1463 52.875 70.4986 52.2614C70.8509 51.6477 71.027 50.7727 71.027 49.6364C71.027 48.8807 70.946 48.2372 70.7841 47.706C70.625 47.1747 70.3949 46.7699 70.0938 46.4915C69.7955 46.2131 69.4361 46.0739 69.0156 46.0739C68.3849 46.0739 67.892 46.3849 67.5369 47.0071C67.1818 47.6264 67.0043 48.5028 67.0043 49.6364C67.0043 50.392 67.0838 51.0341 67.2429 51.5625C67.402 52.0909 67.6307 52.4929 67.929 52.7685C68.2301 53.044 68.5923 53.1818 69.0156 53.1818ZM76.7372 45.2727V54H75.6804V46.3807H75.6293L73.4986 47.7955V46.7216L75.6804 45.2727H76.7372ZM83.0142 49.1676V50.1051H79.196V49.1676H83.0142ZM84.3565 54V53.233L87.2372 50.0795C87.5753 49.7102 87.8537 49.3892 88.0724 49.1165C88.2912 48.8409 88.4531 48.5824 88.5582 48.3409C88.6662 48.0966 88.7202 47.8409 88.7202 47.5739C88.7202 47.267 88.6463 47.0014 88.4986 46.777C88.3537 46.5526 88.1548 46.3793 87.902 46.2571C87.6491 46.1349 87.3651 46.0739 87.0497 46.0739C86.7145 46.0739 86.4219 46.1435 86.1719 46.2827C85.9247 46.419 85.733 46.6108 85.5966 46.858C85.4631 47.1051 85.3963 47.3949 85.3963 47.7273H84.3906C84.3906 47.2159 84.5085 46.767 84.7443 46.3807C84.9801 45.9943 85.3011 45.6932 85.7074 45.4773C86.1165 45.2614 86.5753 45.1534 87.0838 45.1534C87.5952 45.1534 88.0483 45.2614 88.4432 45.4773C88.8381 45.6932 89.1477 45.9844 89.3722 46.3509C89.5966 46.7173 89.7088 47.125 89.7088 47.5739C89.7088 47.8949 89.6506 48.2088 89.5341 48.5156C89.4205 48.8196 89.2216 49.1591 88.9375 49.5341C88.6562 49.9062 88.2656 50.3608 87.7656 50.8977L85.8054 52.9943V53.0625H89.8622V54H84.3565ZM91.6222 54V53.233L94.5028 50.0795C94.8409 49.7102 95.1193 49.3892 95.3381 49.1165C95.5568 48.8409 95.7188 48.5824 95.8239 48.3409C95.9318 48.0966 95.9858 47.8409 95.9858 47.5739C95.9858 47.267 95.9119 47.0014 95.7642 46.777C95.6193 46.5526 95.4205 46.3793 95.1676 46.2571C94.9148 46.1349 94.6307 46.0739 94.3153 46.0739C93.9801 46.0739 93.6875 46.1435 93.4375 46.2827C93.1903 46.419 92.9986 46.6108 92.8622 46.858C92.7287 47.1051 92.6619 47.3949 92.6619 47.7273H91.6562C91.6562 47.2159 91.7741 46.767 92.0099 46.3807C92.2457 45.9943 92.5668 45.6932 92.973 45.4773C93.3821 45.2614 93.8409 45.1534 94.3494 45.1534C94.8608 45.1534 95.3139 45.2614 95.7088 45.4773C96.1037 45.6932 96.4134 45.9844 96.6378 46.3509C96.8622 46.7173 96.9744 47.125 96.9744 47.5739C96.9744 47.8949 96.9162 48.2088 96.7997 48.5156C96.6861 48.8196 96.4872 49.1591 96.2031 49.5341C95.9219 49.9062 95.5312 50.3608 95.0312 50.8977L93.071 52.9943V53.0625H97.1278V54H91.6222ZM101.734 54.1193C101.092 54.1193 100.545 53.9446 100.094 53.5952C99.642 53.2429 99.2969 52.733 99.0582 52.0653C98.8196 51.3949 98.7003 50.5852 98.7003 49.6364C98.7003 48.6932 98.8196 47.8878 99.0582 47.2202C99.2997 46.5497 99.6463 46.0384 100.098 45.6861C100.553 45.331 101.098 45.1534 101.734 45.1534C102.371 45.1534 102.915 45.331 103.366 45.6861C103.821 46.0384 104.168 46.5497 104.406 47.2202C104.648 47.8878 104.768 48.6932 104.768 49.6364C104.768 50.5852 104.649 51.3949 104.411 52.0653C104.172 52.733 103.827 53.2429 103.375 53.5952C102.923 53.9446 102.376 54.1193 101.734 54.1193ZM101.734 53.1818C102.371 53.1818 102.865 52.875 103.217 52.2614C103.57 51.6477 103.746 50.7727 103.746 49.6364C103.746 48.8807 103.665 48.2372 103.503 47.706C103.344 47.1747 103.114 46.7699 102.812 46.4915C102.514 46.2131 102.155 46.0739 101.734 46.0739C101.104 46.0739 100.611 46.3849 100.256 47.0071C99.9006 47.6264 99.723 48.5028 99.723 49.6364C99.723 50.392 99.8026 51.0341 99.9616 51.5625C100.121 52.0909 100.349 52.4929 100.648 52.7685C100.949 53.044 101.311 53.1818 101.734 53.1818ZM109.456 45.2727V54H108.399V46.3807H108.348L106.217 47.7955V46.7216L108.399 45.2727H109.456ZM111.966 54V53.233L114.847 50.0795C115.185 49.7102 115.463 49.3892 115.682 49.1165C115.901 48.8409 116.063 48.5824 116.168 48.3409C116.276 48.0966 116.33 47.8409 116.33 47.5739C116.33 47.267 116.256 47.0014 116.108 46.777C115.963 46.5526 115.764 46.3793 115.511 46.2571C115.259 46.1349 114.974 46.0739 114.659 46.0739C114.324 46.0739 114.031 46.1435 113.781 46.2827C113.534 46.419 113.342 46.6108 113.206 46.858C113.072 47.1051 113.006 47.3949 113.006 47.7273H112C112 47.2159 112.118 46.767 112.354 46.3807C112.589 45.9943 112.911 45.6932 113.317 45.4773C113.726 45.2614 114.185 45.1534 114.693 45.1534C115.205 45.1534 115.658 45.2614 116.053 45.4773C116.447 45.6932 116.757 45.9844 116.982 46.3509C117.206 46.7173 117.318 47.125 117.318 47.5739C117.318 47.8949 117.26 48.2088 117.143 48.5156C117.03 48.8196 116.831 49.1591 116.547 49.5341C116.266 49.9062 115.875 50.3608 115.375 50.8977L113.415 52.9943V53.0625H117.472V54H111.966ZM122.01 45.1534C122.368 45.1562 122.726 45.2244 123.084 45.358C123.442 45.4915 123.768 45.7131 124.064 46.0227C124.359 46.3295 124.597 46.7486 124.776 47.2798C124.955 47.8111 125.044 48.4773 125.044 49.2784C125.044 50.054 124.97 50.7429 124.822 51.3452C124.678 51.9446 124.467 52.4503 124.192 52.8622C123.919 53.2741 123.587 53.5866 123.195 53.7997C122.805 54.0128 122.365 54.1193 121.874 54.1193C121.385 54.1193 120.949 54.0227 120.565 53.8295C120.185 53.6335 119.872 53.3622 119.628 53.0156C119.386 52.6662 119.232 52.2614 119.163 51.8011H120.203C120.297 52.2017 120.483 52.5327 120.761 52.794C121.043 53.0526 121.413 53.1818 121.874 53.1818C122.547 53.1818 123.078 52.8878 123.467 52.2997C123.859 51.7116 124.055 50.8807 124.055 49.8068H123.987C123.828 50.0455 123.639 50.2514 123.42 50.4247C123.202 50.598 122.959 50.7315 122.692 50.8253C122.425 50.919 122.141 50.9659 121.839 50.9659C121.339 50.9659 120.881 50.8423 120.463 50.5952C120.048 50.3452 119.716 50.0028 119.466 49.5682C119.219 49.1307 119.095 48.6307 119.095 48.0682C119.095 47.5341 119.214 47.0455 119.453 46.6023C119.695 46.1562 120.033 45.8011 120.467 45.5369C120.905 45.2727 121.419 45.1449 122.01 45.1534ZM122.01 46.0909C121.652 46.0909 121.33 46.1804 121.043 46.3594C120.759 46.5355 120.533 46.7741 120.365 47.0753C120.2 47.3736 120.118 47.7045 120.118 48.0682C120.118 48.4318 120.197 48.7628 120.357 49.0611C120.518 49.3565 120.739 49.5923 121.017 49.7685C121.298 49.9418 121.618 50.0284 121.976 50.0284C122.246 50.0284 122.497 49.9759 122.73 49.8707C122.963 49.7628 123.166 49.6165 123.339 49.4318C123.516 49.2443 123.653 49.0327 123.753 48.7969C123.852 48.5582 123.902 48.3097 123.902 48.0511C123.902 47.7102 123.82 47.3906 123.655 47.0923C123.493 46.794 123.268 46.5526 122.982 46.3679C122.697 46.1832 122.374 46.0909 122.01 46.0909Z"
            fill="#6B6D76"
          />
          <Logo5GHZ />
        </svg>
      );
    case DeviceModel.UAP6MP:
      return (
        <svg width="260" height="105" viewBox="0 0 260 105" fill="none" xmlns="http://www.w3.org/2000/svg">
          <ComplianceImage />
          <JapaneseTelecomLogo />
          <LogoR />
          <path
            d="M62.2784 54V53.233L65.1591 50.0795C65.4972 49.7102 65.7756 49.3892 65.9943 49.1165C66.2131 48.8409 66.375 48.5824 66.4801 48.3409C66.5881 48.0966 66.642 47.8409 66.642 47.5739C66.642 47.267 66.5682 47.0014 66.4205 46.777C66.2756 46.5526 66.0767 46.3793 65.8239 46.2571C65.571 46.1349 65.2869 46.0739 64.9716 46.0739C64.6364 46.0739 64.3438 46.1435 64.0938 46.2827C63.8466 46.419 63.6548 46.6108 63.5185 46.858C63.3849 47.1051 63.3182 47.3949 63.3182 47.7273H62.3125C62.3125 47.2159 62.4304 46.767 62.6662 46.3807C62.902 45.9943 63.223 45.6932 63.6293 45.4773C64.0384 45.2614 64.4972 45.1534 65.0057 45.1534C65.517 45.1534 65.9702 45.2614 66.3651 45.4773C66.7599 45.6932 67.0696 45.9844 67.294 46.3509C67.5185 46.7173 67.6307 47.125 67.6307 47.5739C67.6307 47.8949 67.5724 48.2088 67.456 48.5156C67.3423 48.8196 67.1435 49.1591 66.8594 49.5341C66.5781 49.9062 66.1875 50.3608 65.6875 50.8977L63.7273 52.9943V53.0625H67.7841V54H62.2784ZM72.3906 54.1193C71.7486 54.1193 71.2017 53.9446 70.75 53.5952C70.2983 53.2429 69.9531 52.733 69.7145 52.0653C69.4759 51.3949 69.3565 50.5852 69.3565 49.6364C69.3565 48.6932 69.4759 47.8878 69.7145 47.2202C69.956 46.5497 70.3026 46.0384 70.7543 45.6861C71.2088 45.331 71.7543 45.1534 72.3906 45.1534C73.027 45.1534 73.571 45.331 74.0227 45.6861C74.4773 46.0384 74.8239 46.5497 75.0625 47.2202C75.304 47.8878 75.4247 48.6932 75.4247 49.6364C75.4247 50.5852 75.3054 51.3949 75.0668 52.0653C74.8281 52.733 74.483 53.2429 74.0312 53.5952C73.5795 53.9446 73.0327 54.1193 72.3906 54.1193ZM72.3906 53.1818C73.027 53.1818 73.5213 52.875 73.8736 52.2614C74.2259 51.6477 74.402 50.7727 74.402 49.6364C74.402 48.8807 74.321 48.2372 74.1591 47.706C74 47.1747 73.7699 46.7699 73.4688 46.4915C73.1705 46.2131 72.8111 46.0739 72.3906 46.0739C71.7599 46.0739 71.267 46.3849 70.9119 47.0071C70.5568 47.6264 70.3793 48.5028 70.3793 49.6364C70.3793 50.392 70.4588 51.0341 70.6179 51.5625C70.777 52.0909 71.0057 52.4929 71.304 52.7685C71.6051 53.044 71.9673 53.1818 72.3906 53.1818ZM80.1122 45.2727V54H79.0554V46.3807H79.0043L76.8736 47.7955V46.7216L79.0554 45.2727H80.1122ZM86.3892 49.1676V50.1051H82.571V49.1676H86.3892ZM87.7315 54V53.233L90.6122 50.0795C90.9503 49.7102 91.2287 49.3892 91.4474 49.1165C91.6662 48.8409 91.8281 48.5824 91.9332 48.3409C92.0412 48.0966 92.0952 47.8409 92.0952 47.5739C92.0952 47.267 92.0213 47.0014 91.8736 46.777C91.7287 46.5526 91.5298 46.3793 91.277 46.2571C91.0241 46.1349 90.7401 46.0739 90.4247 46.0739C90.0895 46.0739 89.7969 46.1435 89.5469 46.2827C89.2997 46.419 89.108 46.6108 88.9716 46.858C88.8381 47.1051 88.7713 47.3949 88.7713 47.7273H87.7656C87.7656 47.2159 87.8835 46.767 88.1193 46.3807C88.3551 45.9943 88.6761 45.6932 89.0824 45.4773C89.4915 45.2614 89.9503 45.1534 90.4588 45.1534C90.9702 45.1534 91.4233 45.2614 91.8182 45.4773C92.2131 45.6932 92.5227 45.9844 92.7472 46.3509C92.9716 46.7173 93.0838 47.125 93.0838 47.5739C93.0838 47.8949 93.0256 48.2088 92.9091 48.5156C92.7955 48.8196 92.5966 49.1591 92.3125 49.5341C92.0312 49.9062 91.6406 50.3608 91.1406 50.8977L89.1804 52.9943V53.0625H93.2372V54H87.7315ZM94.9972 54V53.233L97.8778 50.0795C98.2159 49.7102 98.4943 49.3892 98.7131 49.1165C98.9318 48.8409 99.0938 48.5824 99.1989 48.3409C99.3068 48.0966 99.3608 47.8409 99.3608 47.5739C99.3608 47.267 99.2869 47.0014 99.1392 46.777C98.9943 46.5526 98.7955 46.3793 98.5426 46.2571C98.2898 46.1349 98.0057 46.0739 97.6903 46.0739C97.3551 46.0739 97.0625 46.1435 96.8125 46.2827C96.5653 46.419 96.3736 46.6108 96.2372 46.858C96.1037 47.1051 96.0369 47.3949 96.0369 47.7273H95.0312C95.0312 47.2159 95.1491 46.767 95.3849 46.3807C95.6207 45.9943 95.9418 45.6932 96.348 45.4773C96.7571 45.2614 97.2159 45.1534 97.7244 45.1534C98.2358 45.1534 98.6889 45.2614 99.0838 45.4773C99.4787 45.6932 99.7884 45.9844 100.013 46.3509C100.237 46.7173 100.349 47.125 100.349 47.5739C100.349 47.8949 100.291 48.2088 100.175 48.5156C100.061 48.8196 99.8622 49.1591 99.5781 49.5341C99.2969 49.9062 98.9062 50.3608 98.4062 50.8977L96.446 52.9943V53.0625H100.503V54H94.9972ZM105.109 54.1193C104.467 54.1193 103.92 53.9446 103.469 53.5952C103.017 53.2429 102.672 52.733 102.433 52.0653C102.195 51.3949 102.075 50.5852 102.075 49.6364C102.075 48.6932 102.195 47.8878 102.433 47.2202C102.675 46.5497 103.021 46.0384 103.473 45.6861C103.928 45.331 104.473 45.1534 105.109 45.1534C105.746 45.1534 106.29 45.331 106.741 45.6861C107.196 46.0384 107.543 46.5497 107.781 47.2202C108.023 47.8878 108.143 48.6932 108.143 49.6364C108.143 50.5852 108.024 51.3949 107.786 52.0653C107.547 52.733 107.202 53.2429 106.75 53.5952C106.298 53.9446 105.751 54.1193 105.109 54.1193ZM105.109 53.1818C105.746 53.1818 106.24 52.875 106.592 52.2614C106.945 51.6477 107.121 50.7727 107.121 49.6364C107.121 48.8807 107.04 48.2372 106.878 47.706C106.719 47.1747 106.489 46.7699 106.188 46.4915C105.889 46.2131 105.53 46.0739 105.109 46.0739C104.479 46.0739 103.986 46.3849 103.631 47.0071C103.276 47.6264 103.098 48.5028 103.098 49.6364C103.098 50.392 103.178 51.0341 103.337 51.5625C103.496 52.0909 103.724 52.4929 104.023 52.7685C104.324 53.044 104.686 53.1818 105.109 53.1818ZM112.609 54.1193C111.967 54.1193 111.42 53.9446 110.969 53.5952C110.517 53.2429 110.172 52.733 109.933 52.0653C109.695 51.3949 109.575 50.5852 109.575 49.6364C109.575 48.6932 109.695 47.8878 109.933 47.2202C110.175 46.5497 110.521 46.0384 110.973 45.6861C111.428 45.331 111.973 45.1534 112.609 45.1534C113.246 45.1534 113.79 45.331 114.241 45.6861C114.696 46.0384 115.043 46.5497 115.281 47.2202C115.523 47.8878 115.643 48.6932 115.643 49.6364C115.643 50.5852 115.524 51.3949 115.286 52.0653C115.047 52.733 114.702 53.2429 114.25 53.5952C113.798 53.9446 113.251 54.1193 112.609 54.1193ZM112.609 53.1818C113.246 53.1818 113.74 52.875 114.092 52.2614C114.445 51.6477 114.621 50.7727 114.621 49.6364C114.621 48.8807 114.54 48.2372 114.378 47.706C114.219 47.1747 113.989 46.7699 113.688 46.4915C113.389 46.2131 113.03 46.0739 112.609 46.0739C111.979 46.0739 111.486 46.3849 111.131 47.0071C110.776 47.6264 110.598 48.5028 110.598 49.6364C110.598 50.392 110.678 51.0341 110.837 51.5625C110.996 52.0909 111.224 52.4929 111.523 52.7685C111.824 53.044 112.186 53.1818 112.609 53.1818ZM120.161 54.1193C119.803 54.1136 119.445 54.0455 119.087 53.9148C118.729 53.7841 118.402 53.5639 118.107 53.2543C117.811 52.9418 117.574 52.5199 117.395 51.9886C117.216 51.4545 117.126 50.7841 117.126 49.9773C117.126 49.2045 117.199 48.5199 117.344 47.9233C117.489 47.3239 117.699 46.8196 117.974 46.4105C118.25 45.9986 118.582 45.6861 118.972 45.473C119.364 45.2599 119.805 45.1534 120.297 45.1534C120.786 45.1534 121.22 45.2514 121.601 45.4474C121.984 45.6406 122.297 45.9105 122.538 46.2571C122.78 46.6037 122.936 47.0028 123.007 47.4545H121.967C121.871 47.0625 121.683 46.7372 121.405 46.4787C121.126 46.2202 120.757 46.0909 120.297 46.0909C119.621 46.0909 119.088 46.3849 118.699 46.973C118.313 47.5611 118.118 48.3864 118.115 49.4489H118.183C118.342 49.2074 118.531 49.0014 118.75 48.831C118.972 48.6577 119.216 48.5241 119.483 48.4304C119.75 48.3366 120.033 48.2898 120.331 48.2898C120.831 48.2898 121.288 48.4148 121.703 48.6648C122.118 48.9119 122.45 49.2543 122.7 49.6918C122.95 50.1264 123.075 50.625 123.075 51.1875C123.075 51.7273 122.955 52.2216 122.713 52.6705C122.472 53.1165 122.132 53.4716 121.695 53.7358C121.26 53.9972 120.749 54.125 120.161 54.1193ZM120.161 53.1818C120.518 53.1818 120.839 53.0923 121.124 52.9134C121.411 52.7344 121.636 52.4943 121.801 52.1932C121.969 51.892 122.053 51.5568 122.053 51.1875C122.053 50.8267 121.972 50.4986 121.81 50.2031C121.651 49.9048 121.43 49.6676 121.149 49.4915C120.871 49.3153 120.553 49.2273 120.195 49.2273C119.925 49.2273 119.673 49.2812 119.44 49.3892C119.207 49.4943 119.003 49.6392 118.827 49.8239C118.653 50.0085 118.517 50.2202 118.418 50.4588C118.318 50.6946 118.268 50.9432 118.268 51.2045C118.268 51.5511 118.349 51.875 118.511 52.1761C118.676 52.4773 118.901 52.7202 119.185 52.9048C119.472 53.0895 119.797 53.1818 120.161 53.1818ZM127.819 45.2727V54H126.762V46.3807H126.711L124.581 47.7955V46.7216L126.762 45.2727H127.819Z"
            fill="#6B6D76"
          />
          <Logo5GHZ />
        </svg>
      );
    case DeviceModel.UALR6v2:
      return (
        <svg width="260" height="105" viewBox="0 0 260 105" fill="none" xmlns="http://www.w3.org/2000/svg">
          <ComplianceImage />
          <JapaneseTelecomLogo />
          <LogoR />
          <path
            d="M58.9034 54V53.233L61.7841 50.0795C62.1222 49.7102 62.4006 49.3892 62.6193 49.1165C62.8381 48.8409 63 48.5824 63.1051 48.3409C63.2131 48.0966 63.267 47.8409 63.267 47.5739C63.267 47.267 63.1932 47.0014 63.0455 46.777C62.9006 46.5526 62.7017 46.3793 62.4489 46.2571C62.196 46.1349 61.9119 46.0739 61.5966 46.0739C61.2614 46.0739 60.9688 46.1435 60.7188 46.2827C60.4716 46.419 60.2798 46.6108 60.1435 46.858C60.0099 47.1051 59.9432 47.3949 59.9432 47.7273H58.9375C58.9375 47.2159 59.0554 46.767 59.2912 46.3807C59.527 45.9943 59.848 45.6932 60.2543 45.4773C60.6634 45.2614 61.1222 45.1534 61.6307 45.1534C62.142 45.1534 62.5952 45.2614 62.9901 45.4773C63.3849 45.6932 63.6946 45.9844 63.919 46.3509C64.1435 46.7173 64.2557 47.125 64.2557 47.5739C64.2557 47.8949 64.1974 48.2088 64.081 48.5156C63.9673 48.8196 63.7685 49.1591 63.4844 49.5341C63.2031 49.9062 62.8125 50.3608 62.3125 50.8977L60.3523 52.9943V53.0625H64.4091V54H58.9034ZM69.0156 54.1193C68.3736 54.1193 67.8267 53.9446 67.375 53.5952C66.9233 53.2429 66.5781 52.733 66.3395 52.0653C66.1009 51.3949 65.9815 50.5852 65.9815 49.6364C65.9815 48.6932 66.1009 47.8878 66.3395 47.2202C66.581 46.5497 66.9276 46.0384 67.3793 45.6861C67.8338 45.331 68.3793 45.1534 69.0156 45.1534C69.652 45.1534 70.196 45.331 70.6477 45.6861C71.1023 46.0384 71.4489 46.5497 71.6875 47.2202C71.929 47.8878 72.0497 48.6932 72.0497 49.6364C72.0497 50.5852 71.9304 51.3949 71.6918 52.0653C71.4531 52.733 71.108 53.2429 70.6562 53.5952C70.2045 53.9446 69.6577 54.1193 69.0156 54.1193ZM69.0156 53.1818C69.652 53.1818 70.1463 52.875 70.4986 52.2614C70.8509 51.6477 71.027 50.7727 71.027 49.6364C71.027 48.8807 70.946 48.2372 70.7841 47.706C70.625 47.1747 70.3949 46.7699 70.0938 46.4915C69.7955 46.2131 69.4361 46.0739 69.0156 46.0739C68.3849 46.0739 67.892 46.3849 67.5369 47.0071C67.1818 47.6264 67.0043 48.5028 67.0043 49.6364C67.0043 50.392 67.0838 51.0341 67.2429 51.5625C67.402 52.0909 67.6307 52.4929 67.929 52.7685C68.2301 53.044 68.5923 53.1818 69.0156 53.1818ZM76.7372 45.2727V54H75.6804V46.3807H75.6293L73.4986 47.7955V46.7216L75.6804 45.2727H76.7372ZM83.0142 49.1676V50.1051H79.196V49.1676H83.0142ZM84.3565 54V53.233L87.2372 50.0795C87.5753 49.7102 87.8537 49.3892 88.0724 49.1165C88.2912 48.8409 88.4531 48.5824 88.5582 48.3409C88.6662 48.0966 88.7202 47.8409 88.7202 47.5739C88.7202 47.267 88.6463 47.0014 88.4986 46.777C88.3537 46.5526 88.1548 46.3793 87.902 46.2571C87.6491 46.1349 87.3651 46.0739 87.0497 46.0739C86.7145 46.0739 86.4219 46.1435 86.1719 46.2827C85.9247 46.419 85.733 46.6108 85.5966 46.858C85.4631 47.1051 85.3963 47.3949 85.3963 47.7273H84.3906C84.3906 47.2159 84.5085 46.767 84.7443 46.3807C84.9801 45.9943 85.3011 45.6932 85.7074 45.4773C86.1165 45.2614 86.5753 45.1534 87.0838 45.1534C87.5952 45.1534 88.0483 45.2614 88.4432 45.4773C88.8381 45.6932 89.1477 45.9844 89.3722 46.3509C89.5966 46.7173 89.7088 47.125 89.7088 47.5739C89.7088 47.8949 89.6506 48.2088 89.5341 48.5156C89.4205 48.8196 89.2216 49.1591 88.9375 49.5341C88.6562 49.9062 88.2656 50.3608 87.7656 50.8977L85.8054 52.9943V53.0625H89.8622V54H84.3565ZM91.6222 54V53.233L94.5028 50.0795C94.8409 49.7102 95.1193 49.3892 95.3381 49.1165C95.5568 48.8409 95.7188 48.5824 95.8239 48.3409C95.9318 48.0966 95.9858 47.8409 95.9858 47.5739C95.9858 47.267 95.9119 47.0014 95.7642 46.777C95.6193 46.5526 95.4205 46.3793 95.1676 46.2571C94.9148 46.1349 94.6307 46.0739 94.3153 46.0739C93.9801 46.0739 93.6875 46.1435 93.4375 46.2827C93.1903 46.419 92.9986 46.6108 92.8622 46.858C92.7287 47.1051 92.6619 47.3949 92.6619 47.7273H91.6562C91.6562 47.2159 91.7741 46.767 92.0099 46.3807C92.2457 45.9943 92.5668 45.6932 92.973 45.4773C93.3821 45.2614 93.8409 45.1534 94.3494 45.1534C94.8608 45.1534 95.3139 45.2614 95.7088 45.4773C96.1037 45.6932 96.4134 45.9844 96.6378 46.3509C96.8622 46.7173 96.9744 47.125 96.9744 47.5739C96.9744 47.8949 96.9162 48.2088 96.7997 48.5156C96.6861 48.8196 96.4872 49.1591 96.2031 49.5341C95.9219 49.9062 95.5312 50.3608 95.0312 50.8977L93.071 52.9943V53.0625H97.1278V54H91.6222ZM101.734 54.1193C101.092 54.1193 100.545 53.9446 100.094 53.5952C99.642 53.2429 99.2969 52.733 99.0582 52.0653C98.8196 51.3949 98.7003 50.5852 98.7003 49.6364C98.7003 48.6932 98.8196 47.8878 99.0582 47.2202C99.2997 46.5497 99.6463 46.0384 100.098 45.6861C100.553 45.331 101.098 45.1534 101.734 45.1534C102.371 45.1534 102.915 45.331 103.366 45.6861C103.821 46.0384 104.168 46.5497 104.406 47.2202C104.648 47.8878 104.768 48.6932 104.768 49.6364C104.768 50.5852 104.649 51.3949 104.411 52.0653C104.172 52.733 103.827 53.2429 103.375 53.5952C102.923 53.9446 102.376 54.1193 101.734 54.1193ZM101.734 53.1818C102.371 53.1818 102.865 52.875 103.217 52.2614C103.57 51.6477 103.746 50.7727 103.746 49.6364C103.746 48.8807 103.665 48.2372 103.503 47.706C103.344 47.1747 103.114 46.7699 102.812 46.4915C102.514 46.2131 102.155 46.0739 101.734 46.0739C101.104 46.0739 100.611 46.3849 100.256 47.0071C99.9006 47.6264 99.723 48.5028 99.723 49.6364C99.723 50.392 99.8026 51.0341 99.9616 51.5625C100.121 52.0909 100.349 52.4929 100.648 52.7685C100.949 53.044 101.311 53.1818 101.734 53.1818ZM109.456 45.2727V54H108.399V46.3807H108.348L106.217 47.7955V46.7216L108.399 45.2727H109.456ZM112.239 54L116.142 46.2784V46.2102H111.642V45.2727H117.233V46.2614L113.347 54H112.239ZM121.571 54.1193C121.009 54.1193 120.507 54.0227 120.067 53.8295C119.629 53.6364 119.281 53.3679 119.023 53.0241C118.767 52.6776 118.628 52.2756 118.605 51.8182H119.679C119.702 52.0994 119.798 52.3423 119.969 52.5469C120.139 52.7486 120.362 52.9048 120.638 53.0156C120.913 53.1264 121.219 53.1818 121.554 53.1818C121.929 53.1818 122.261 53.1165 122.551 52.9858C122.841 52.8551 123.068 52.6733 123.233 52.4403C123.398 52.2074 123.48 51.9375 123.48 51.6307C123.48 51.3097 123.401 51.027 123.241 50.7827C123.082 50.5355 122.849 50.3423 122.543 50.2031C122.236 50.0639 121.861 49.9943 121.418 49.9943H120.719V49.0568H121.418C121.764 49.0568 122.068 48.9943 122.33 48.8693C122.594 48.7443 122.8 48.5682 122.947 48.3409C123.098 48.1136 123.173 47.8466 123.173 47.5398C123.173 47.2443 123.108 46.9872 122.977 46.7685C122.847 46.5497 122.662 46.3793 122.423 46.2571C122.188 46.1349 121.909 46.0739 121.588 46.0739C121.287 46.0739 121.003 46.1293 120.736 46.2401C120.472 46.348 120.256 46.5057 120.088 46.7131C119.92 46.9176 119.83 47.1648 119.815 47.4545H118.793C118.81 46.9972 118.947 46.5966 119.206 46.2528C119.464 45.9062 119.803 45.6364 120.22 45.4432C120.641 45.25 121.102 45.1534 121.605 45.1534C122.145 45.1534 122.608 45.2628 122.994 45.4815C123.381 45.6974 123.678 45.983 123.885 46.3381C124.092 46.6932 124.196 47.0767 124.196 47.4886C124.196 47.9801 124.067 48.3991 123.808 48.7457C123.553 49.0923 123.205 49.3324 122.764 49.4659V49.5341C123.315 49.625 123.746 49.8594 124.055 50.2372C124.365 50.6122 124.52 51.0767 124.52 51.6307C124.52 52.1051 124.391 52.5312 124.132 52.9091C123.876 53.2841 123.527 53.5795 123.084 53.7955C122.641 54.0114 122.136 54.1193 121.571 54.1193Z"
            fill="#6B6D76"
          />
          <Logo5GHZ />
        </svg>
      );
    case DeviceModel.UAL6:
      return (
        <svg width="260" height="105" viewBox="0 0 260 105" fill="none" xmlns="http://www.w3.org/2000/svg">
          <ComplianceImage />
          <JapaneseTelecomLogo />
          <LogoR />
          <path
            d="M58.9034 54V53.233L61.7841 50.0795C62.1222 49.7102 62.4006 49.3892 62.6193 49.1165C62.8381 48.8409 63 48.5824 63.1051 48.3409C63.2131 48.0966 63.267 47.8409 63.267 47.5739C63.267 47.267 63.1932 47.0014 63.0455 46.777C62.9006 46.5526 62.7017 46.3793 62.4489 46.2571C62.196 46.1349 61.9119 46.0739 61.5966 46.0739C61.2614 46.0739 60.9688 46.1435 60.7188 46.2827C60.4716 46.419 60.2798 46.6108 60.1435 46.858C60.0099 47.1051 59.9432 47.3949 59.9432 47.7273H58.9375C58.9375 47.2159 59.0554 46.767 59.2912 46.3807C59.527 45.9943 59.848 45.6932 60.2543 45.4773C60.6634 45.2614 61.1222 45.1534 61.6307 45.1534C62.142 45.1534 62.5952 45.2614 62.9901 45.4773C63.3849 45.6932 63.6946 45.9844 63.919 46.3509C64.1435 46.7173 64.2557 47.125 64.2557 47.5739C64.2557 47.8949 64.1974 48.2088 64.081 48.5156C63.9673 48.8196 63.7685 49.1591 63.4844 49.5341C63.2031 49.9062 62.8125 50.3608 62.3125 50.8977L60.3523 52.9943V53.0625H64.4091V54H58.9034ZM69.0156 54.1193C68.3736 54.1193 67.8267 53.9446 67.375 53.5952C66.9233 53.2429 66.5781 52.733 66.3395 52.0653C66.1009 51.3949 65.9815 50.5852 65.9815 49.6364C65.9815 48.6932 66.1009 47.8878 66.3395 47.2202C66.581 46.5497 66.9276 46.0384 67.3793 45.6861C67.8338 45.331 68.3793 45.1534 69.0156 45.1534C69.652 45.1534 70.196 45.331 70.6477 45.6861C71.1023 46.0384 71.4489 46.5497 71.6875 47.2202C71.929 47.8878 72.0497 48.6932 72.0497 49.6364C72.0497 50.5852 71.9304 51.3949 71.6918 52.0653C71.4531 52.733 71.108 53.2429 70.6562 53.5952C70.2045 53.9446 69.6577 54.1193 69.0156 54.1193ZM69.0156 53.1818C69.652 53.1818 70.1463 52.875 70.4986 52.2614C70.8509 51.6477 71.027 50.7727 71.027 49.6364C71.027 48.8807 70.946 48.2372 70.7841 47.706C70.625 47.1747 70.3949 46.7699 70.0938 46.4915C69.7955 46.2131 69.4361 46.0739 69.0156 46.0739C68.3849 46.0739 67.892 46.3849 67.5369 47.0071C67.1818 47.6264 67.0043 48.5028 67.0043 49.6364C67.0043 50.392 67.0838 51.0341 67.2429 51.5625C67.402 52.0909 67.6307 52.4929 67.929 52.7685C68.2301 53.044 68.5923 53.1818 69.0156 53.1818ZM76.7372 45.2727V54H75.6804V46.3807H75.6293L73.4986 47.7955V46.7216L75.6804 45.2727H76.7372ZM83.0142 49.1676V50.1051H79.196V49.1676H83.0142ZM84.3565 54V53.233L87.2372 50.0795C87.5753 49.7102 87.8537 49.3892 88.0724 49.1165C88.2912 48.8409 88.4531 48.5824 88.5582 48.3409C88.6662 48.0966 88.7202 47.8409 88.7202 47.5739C88.7202 47.267 88.6463 47.0014 88.4986 46.777C88.3537 46.5526 88.1548 46.3793 87.902 46.2571C87.6491 46.1349 87.3651 46.0739 87.0497 46.0739C86.7145 46.0739 86.4219 46.1435 86.1719 46.2827C85.9247 46.419 85.733 46.6108 85.5966 46.858C85.4631 47.1051 85.3963 47.3949 85.3963 47.7273H84.3906C84.3906 47.2159 84.5085 46.767 84.7443 46.3807C84.9801 45.9943 85.3011 45.6932 85.7074 45.4773C86.1165 45.2614 86.5753 45.1534 87.0838 45.1534C87.5952 45.1534 88.0483 45.2614 88.4432 45.4773C88.8381 45.6932 89.1477 45.9844 89.3722 46.3509C89.5966 46.7173 89.7088 47.125 89.7088 47.5739C89.7088 47.8949 89.6506 48.2088 89.5341 48.5156C89.4205 48.8196 89.2216 49.1591 88.9375 49.5341C88.6562 49.9062 88.2656 50.3608 87.7656 50.8977L85.8054 52.9943V53.0625H89.8622V54H84.3565ZM94.6903 45.2727V54H93.6335V46.3807H93.5824L91.4517 47.7955V46.7216L93.6335 45.2727H94.6903ZM100.047 54.1193C99.4048 54.1193 98.858 53.9446 98.4062 53.5952C97.9545 53.2429 97.6094 52.733 97.3707 52.0653C97.1321 51.3949 97.0128 50.5852 97.0128 49.6364C97.0128 48.6932 97.1321 47.8878 97.3707 47.2202C97.6122 46.5497 97.9588 46.0384 98.4105 45.6861C98.8651 45.331 99.4105 45.1534 100.047 45.1534C100.683 45.1534 101.227 45.331 101.679 45.6861C102.134 46.0384 102.48 46.5497 102.719 47.2202C102.96 47.8878 103.081 48.6932 103.081 49.6364C103.081 50.5852 102.962 51.3949 102.723 52.0653C102.484 52.733 102.139 53.2429 101.688 53.5952C101.236 53.9446 100.689 54.1193 100.047 54.1193ZM100.047 53.1818C100.683 53.1818 101.178 52.875 101.53 52.2614C101.882 51.6477 102.058 50.7727 102.058 49.6364C102.058 48.8807 101.977 48.2372 101.815 47.706C101.656 47.1747 101.426 46.7699 101.125 46.4915C100.827 46.2131 100.467 46.0739 100.047 46.0739C99.4162 46.0739 98.9233 46.3849 98.5682 47.0071C98.2131 47.6264 98.0355 48.5028 98.0355 49.6364C98.0355 50.392 98.1151 51.0341 98.2741 51.5625C98.4332 52.0909 98.6619 52.4929 98.9602 52.7685C99.2614 53.044 99.6236 53.1818 100.047 53.1818ZM104.7 54V53.233L107.581 50.0795C107.919 49.7102 108.197 49.3892 108.416 49.1165C108.635 48.8409 108.797 48.5824 108.902 48.3409C109.01 48.0966 109.064 47.8409 109.064 47.5739C109.064 47.267 108.99 47.0014 108.842 46.777C108.697 46.5526 108.499 46.3793 108.246 46.2571C107.993 46.1349 107.709 46.0739 107.393 46.0739C107.058 46.0739 106.766 46.1435 106.516 46.2827C106.268 46.419 106.077 46.6108 105.94 46.858C105.807 47.1051 105.74 47.3949 105.74 47.7273H104.734C104.734 47.2159 104.852 46.767 105.088 46.3807C105.324 45.9943 105.645 45.6932 106.051 45.4773C106.46 45.2614 106.919 45.1534 107.428 45.1534C107.939 45.1534 108.392 45.2614 108.787 45.4773C109.182 45.6932 109.491 45.9844 109.716 46.3509C109.94 46.7173 110.053 47.125 110.053 47.5739C110.053 47.8949 109.994 48.2088 109.878 48.5156C109.764 48.8196 109.565 49.1591 109.281 49.5341C109 49.9062 108.609 50.3608 108.109 50.8977L106.149 52.9943V53.0625H110.206V54H104.7ZM114.761 54.1193C114.176 54.1193 113.659 54.0156 113.21 53.8082C112.764 53.598 112.416 53.3097 112.166 52.9432C111.916 52.5739 111.793 52.1534 111.795 51.6818C111.793 51.3125 111.865 50.9716 112.013 50.6591C112.161 50.3437 112.362 50.081 112.618 49.8707C112.876 49.6577 113.165 49.5227 113.483 49.4659V49.4148C113.065 49.3068 112.733 49.0724 112.486 48.7116C112.239 48.348 112.116 47.9347 112.119 47.4716C112.116 47.0284 112.229 46.6321 112.456 46.2827C112.683 45.9332 112.996 45.6577 113.393 45.456C113.794 45.2543 114.25 45.1534 114.761 45.1534C115.267 45.1534 115.719 45.2543 116.116 45.456C116.514 45.6577 116.827 45.9332 117.054 46.2827C117.284 46.6321 117.401 47.0284 117.403 47.4716C117.401 47.9347 117.274 48.348 117.024 48.7116C116.777 49.0724 116.449 49.3068 116.04 49.4148V49.4659C116.355 49.5227 116.639 49.6577 116.892 49.8707C117.145 50.081 117.347 50.3437 117.497 50.6591C117.648 50.9716 117.724 51.3125 117.727 51.6818C117.724 52.1534 117.597 52.5739 117.344 52.9432C117.094 53.3097 116.746 53.598 116.3 53.8082C115.857 54.0156 115.344 54.1193 114.761 54.1193ZM114.761 53.1818C115.156 53.1818 115.497 53.1179 115.784 52.9901C116.071 52.8622 116.293 52.6818 116.449 52.4489C116.605 52.2159 116.685 51.9432 116.688 51.6307C116.685 51.3011 116.599 51.0099 116.432 50.7571C116.264 50.5043 116.036 50.3054 115.746 50.1605C115.459 50.0156 115.131 49.9432 114.761 49.9432C114.389 49.9432 114.057 50.0156 113.764 50.1605C113.474 50.3054 113.246 50.5043 113.078 50.7571C112.913 51.0099 112.832 51.3011 112.835 51.6307C112.832 51.9432 112.908 52.2159 113.061 52.4489C113.217 52.6818 113.44 52.8622 113.73 52.9901C114.02 53.1179 114.364 53.1818 114.761 53.1818ZM114.761 49.0398C115.074 49.0398 115.351 48.9773 115.592 48.8523C115.837 48.7273 116.028 48.5526 116.168 48.3281C116.307 48.1037 116.378 47.8409 116.381 47.5398C116.378 47.2443 116.308 46.9872 116.172 46.7685C116.036 46.5469 115.847 46.3764 115.605 46.2571C115.364 46.1349 115.082 46.0739 114.761 46.0739C114.435 46.0739 114.149 46.1349 113.905 46.2571C113.661 46.3764 113.472 46.5469 113.338 46.7685C113.205 46.9872 113.139 47.2443 113.142 47.5398C113.139 47.8409 113.206 48.1037 113.342 48.3281C113.482 48.5526 113.673 48.7273 113.918 48.8523C114.162 48.9773 114.443 49.0398 114.761 49.0398ZM122.139 45.1534C122.497 45.1562 122.855 45.2244 123.213 45.358C123.571 45.4915 123.897 45.7131 124.193 46.0227C124.488 46.3295 124.725 46.7486 124.904 47.2798C125.083 47.8111 125.173 48.4773 125.173 49.2784C125.173 50.054 125.099 50.7429 124.951 51.3452C124.806 51.9446 124.596 52.4503 124.321 52.8622C124.048 53.2741 123.716 53.5866 123.324 53.7997C122.934 54.0128 122.494 54.1193 122.002 54.1193C121.514 54.1193 121.078 54.0227 120.694 53.8295C120.314 53.6335 120.001 53.3622 119.757 53.0156C119.515 52.6662 119.36 52.2614 119.292 51.8011H120.332C120.426 52.2017 120.612 52.5327 120.89 52.794C121.172 53.0526 121.542 53.1818 122.002 53.1818C122.676 53.1818 123.207 52.8878 123.596 52.2997C123.988 51.7116 124.184 50.8807 124.184 49.8068H124.116C123.957 50.0455 123.768 50.2514 123.549 50.4247C123.331 50.598 123.088 50.7315 122.821 50.8253C122.554 50.919 122.27 50.9659 121.968 50.9659C121.468 50.9659 121.01 50.8423 120.592 50.5952C120.177 50.3452 119.845 50.0028 119.595 49.5682C119.348 49.1307 119.224 48.6307 119.224 48.0682C119.224 47.5341 119.343 47.0455 119.582 46.6023C119.824 46.1562 120.162 45.8011 120.596 45.5369C121.034 45.2727 121.548 45.1449 122.139 45.1534ZM122.139 46.0909C121.781 46.0909 121.458 46.1804 121.172 46.3594C120.887 46.5355 120.662 46.7741 120.494 47.0753C120.329 47.3736 120.247 47.7045 120.247 48.0682C120.247 48.4318 120.326 48.7628 120.485 49.0611C120.647 49.3565 120.868 49.5923 121.146 49.7685C121.427 49.9418 121.747 50.0284 122.105 50.0284C122.375 50.0284 122.626 49.9759 122.859 49.8707C123.092 49.7628 123.295 49.6165 123.468 49.4318C123.645 49.2443 123.782 49.0327 123.882 48.7969C123.981 48.5582 124.031 48.3097 124.031 48.0511C124.031 47.7102 123.949 47.3906 123.784 47.0923C123.622 46.794 123.397 46.5526 123.11 46.3679C122.826 46.1832 122.502 46.0909 122.139 46.0909Z"
            fill="#6B6D76"
          />
          <Logo5GHZ />
        </svg>
      );
    case DeviceModel.UFLHD:
      return (
        <svg width="260" height="105" viewBox="0 0 260 105" fill="none" xmlns="http://www.w3.org/2000/svg">
          <ComplianceImage />
          <JapaneseTelecomLogo />
          <LogoR />
          <path
            d="M58.9034 54V53.233L61.7841 50.0795C62.1222 49.7102 62.4006 49.3892 62.6193 49.1165C62.8381 48.8409 63 48.5824 63.1051 48.3409C63.2131 48.0966 63.267 47.8409 63.267 47.5739C63.267 47.267 63.1932 47.0014 63.0455 46.777C62.9006 46.5526 62.7017 46.3793 62.4489 46.2571C62.196 46.1349 61.9119 46.0739 61.5966 46.0739C61.2614 46.0739 60.9688 46.1435 60.7188 46.2827C60.4716 46.419 60.2798 46.6108 60.1435 46.858C60.0099 47.1051 59.9432 47.3949 59.9432 47.7273H58.9375C58.9375 47.2159 59.0554 46.767 59.2912 46.3807C59.527 45.9943 59.848 45.6932 60.2543 45.4773C60.6634 45.2614 61.1222 45.1534 61.6307 45.1534C62.142 45.1534 62.5952 45.2614 62.9901 45.4773C63.3849 45.6932 63.6946 45.9844 63.919 46.3509C64.1435 46.7173 64.2557 47.125 64.2557 47.5739C64.2557 47.8949 64.1974 48.2088 64.081 48.5156C63.9673 48.8196 63.7685 49.1591 63.4844 49.5341C63.2031 49.9062 62.8125 50.3608 62.3125 50.8977L60.3523 52.9943V53.0625H64.4091V54H58.9034ZM69.0156 54.1193C68.3736 54.1193 67.8267 53.9446 67.375 53.5952C66.9233 53.2429 66.5781 52.733 66.3395 52.0653C66.1009 51.3949 65.9815 50.5852 65.9815 49.6364C65.9815 48.6932 66.1009 47.8878 66.3395 47.2202C66.581 46.5497 66.9276 46.0384 67.3793 45.6861C67.8338 45.331 68.3793 45.1534 69.0156 45.1534C69.652 45.1534 70.196 45.331 70.6477 45.6861C71.1023 46.0384 71.4489 46.5497 71.6875 47.2202C71.929 47.8878 72.0497 48.6932 72.0497 49.6364C72.0497 50.5852 71.9304 51.3949 71.6918 52.0653C71.4531 52.733 71.108 53.2429 70.6562 53.5952C70.2045 53.9446 69.6577 54.1193 69.0156 54.1193ZM69.0156 53.1818C69.652 53.1818 70.1463 52.875 70.4986 52.2614C70.8509 51.6477 71.027 50.7727 71.027 49.6364C71.027 48.8807 70.946 48.2372 70.7841 47.706C70.625 47.1747 70.3949 46.7699 70.0938 46.4915C69.7955 46.2131 69.4361 46.0739 69.0156 46.0739C68.3849 46.0739 67.892 46.3849 67.5369 47.0071C67.1818 47.6264 67.0043 48.5028 67.0043 49.6364C67.0043 50.392 67.0838 51.0341 67.2429 51.5625C67.402 52.0909 67.6307 52.4929 67.929 52.7685C68.2301 53.044 68.5923 53.1818 69.0156 53.1818ZM76.7372 45.2727V54H75.6804V46.3807H75.6293L73.4986 47.7955V46.7216L75.6804 45.2727H76.7372ZM83.0142 49.1676V50.1051H79.196V49.1676H83.0142ZM84.3565 54V53.233L87.2372 50.0795C87.5753 49.7102 87.8537 49.3892 88.0724 49.1165C88.2912 48.8409 88.4531 48.5824 88.5582 48.3409C88.6662 48.0966 88.7202 47.8409 88.7202 47.5739C88.7202 47.267 88.6463 47.0014 88.4986 46.777C88.3537 46.5526 88.1548 46.3793 87.902 46.2571C87.6491 46.1349 87.3651 46.0739 87.0497 46.0739C86.7145 46.0739 86.4219 46.1435 86.1719 46.2827C85.9247 46.419 85.733 46.6108 85.5966 46.858C85.4631 47.1051 85.3963 47.3949 85.3963 47.7273H84.3906C84.3906 47.2159 84.5085 46.767 84.7443 46.3807C84.9801 45.9943 85.3011 45.6932 85.7074 45.4773C86.1165 45.2614 86.5753 45.1534 87.0838 45.1534C87.5952 45.1534 88.0483 45.2614 88.4432 45.4773C88.8381 45.6932 89.1477 45.9844 89.3722 46.3509C89.5966 46.7173 89.7088 47.125 89.7088 47.5739C89.7088 47.8949 89.6506 48.2088 89.5341 48.5156C89.4205 48.8196 89.2216 49.1591 88.9375 49.5341C88.6562 49.9062 88.2656 50.3608 87.7656 50.8977L85.8054 52.9943V53.0625H89.8622V54H84.3565ZM94.4688 54.1193C93.8267 54.1193 93.2798 53.9446 92.8281 53.5952C92.3764 53.2429 92.0313 52.733 91.7926 52.0653C91.554 51.3949 91.4347 50.5852 91.4347 49.6364C91.4347 48.6932 91.554 47.8878 91.7926 47.2202C92.0341 46.5497 92.3807 46.0384 92.8324 45.6861C93.2869 45.331 93.8324 45.1534 94.4688 45.1534C95.1051 45.1534 95.6491 45.331 96.1009 45.6861C96.5554 46.0384 96.902 46.5497 97.1406 47.2202C97.3821 47.8878 97.5028 48.6932 97.5028 49.6364C97.5028 50.5852 97.3835 51.3949 97.1449 52.0653C96.9062 52.733 96.5611 53.2429 96.1094 53.5952C95.6577 53.9446 95.1108 54.1193 94.4688 54.1193ZM94.4688 53.1818C95.1051 53.1818 95.5994 52.875 95.9517 52.2614C96.304 51.6477 96.4801 50.7727 96.4801 49.6364C96.4801 48.8807 96.3991 48.2372 96.2372 47.706C96.0781 47.1747 95.848 46.7699 95.5469 46.4915C95.2486 46.2131 94.8892 46.0739 94.4688 46.0739C93.8381 46.0739 93.3452 46.3849 92.9901 47.0071C92.6349 47.6264 92.4574 48.5028 92.4574 49.6364C92.4574 50.392 92.5369 51.0341 92.696 51.5625C92.8551 52.0909 93.0838 52.4929 93.3821 52.7685C93.6832 53.044 94.0455 53.1818 94.4688 53.1818ZM101.969 54.1193C101.327 54.1193 100.78 53.9446 100.328 53.5952C99.8764 53.2429 99.5313 52.733 99.2926 52.0653C99.054 51.3949 98.9347 50.5852 98.9347 49.6364C98.9347 48.6932 99.054 47.8878 99.2926 47.2202C99.5341 46.5497 99.8807 46.0384 100.332 45.6861C100.787 45.331 101.332 45.1534 101.969 45.1534C102.605 45.1534 103.149 45.331 103.601 45.6861C104.055 46.0384 104.402 46.5497 104.641 47.2202C104.882 47.8878 105.003 48.6932 105.003 49.6364C105.003 50.5852 104.884 51.3949 104.645 52.0653C104.406 52.733 104.061 53.2429 103.609 53.5952C103.158 53.9446 102.611 54.1193 101.969 54.1193ZM101.969 53.1818C102.605 53.1818 103.099 52.875 103.452 52.2614C103.804 51.6477 103.98 50.7727 103.98 49.6364C103.98 48.8807 103.899 48.2372 103.737 47.706C103.578 47.1747 103.348 46.7699 103.047 46.4915C102.749 46.2131 102.389 46.0739 101.969 46.0739C101.338 46.0739 100.845 46.3849 100.49 47.0071C100.135 47.6264 99.9574 48.5028 99.9574 49.6364C99.9574 50.392 100.037 51.0341 100.196 51.5625C100.355 52.0909 100.584 52.4929 100.882 52.7685C101.183 53.044 101.545 53.1818 101.969 53.1818ZM109.401 45.1534C109.759 45.1562 110.116 45.2244 110.474 45.358C110.832 45.4915 111.159 45.7131 111.455 46.0227C111.75 46.3295 111.987 46.7486 112.166 47.2798C112.345 47.8111 112.435 48.4773 112.435 49.2784C112.435 50.054 112.361 50.7429 112.213 51.3452C112.068 51.9446 111.858 52.4503 111.582 52.8622C111.31 53.2741 110.977 53.5866 110.585 53.7997C110.196 54.0128 109.756 54.1193 109.264 54.1193C108.776 54.1193 108.339 54.0227 107.956 53.8295C107.575 53.6335 107.263 53.3622 107.018 53.0156C106.777 52.6662 106.622 52.2614 106.554 51.8011H107.594C107.688 52.2017 107.874 52.5327 108.152 52.794C108.433 53.0526 108.804 53.1818 109.264 53.1818C109.938 53.1818 110.469 52.8878 110.858 52.2997C111.25 51.7116 111.446 50.8807 111.446 49.8068H111.378C111.219 50.0455 111.03 50.2514 110.811 50.4247C110.592 50.598 110.349 50.7315 110.082 50.8253C109.815 50.919 109.531 50.9659 109.23 50.9659C108.73 50.9659 108.271 50.8423 107.854 50.5952C107.439 50.3452 107.107 50.0028 106.857 49.5682C106.609 49.1307 106.486 48.6307 106.486 48.0682C106.486 47.5341 106.605 47.0455 106.844 46.6023C107.085 46.1562 107.423 45.8011 107.858 45.5369C108.295 45.2727 108.81 45.1449 109.401 45.1534ZM109.401 46.0909C109.043 46.0909 108.72 46.1804 108.433 46.3594C108.149 46.5355 107.923 46.7741 107.756 47.0753C107.591 47.3736 107.509 47.7045 107.509 48.0682C107.509 48.4318 107.588 48.7628 107.747 49.0611C107.909 49.3565 108.129 49.5923 108.408 49.7685C108.689 49.9418 109.009 50.0284 109.366 50.0284C109.636 50.0284 109.888 49.9759 110.121 49.8707C110.354 49.7628 110.557 49.6165 110.73 49.4318C110.906 49.2443 111.044 49.0327 111.143 48.7969C111.243 48.5582 111.293 48.3097 111.293 48.0511C111.293 47.7102 111.21 47.3906 111.045 47.0923C110.884 46.794 110.659 46.5526 110.372 46.3679C110.088 46.1832 109.764 46.0909 109.401 46.0909ZM117.008 54.1193C116.65 54.1136 116.292 54.0455 115.934 53.9148C115.576 53.7841 115.25 53.5639 114.954 53.2543C114.659 52.9418 114.422 52.5199 114.243 51.9886C114.064 51.4545 113.974 50.7841 113.974 49.9773C113.974 49.2045 114.047 48.5199 114.191 47.9233C114.336 47.3239 114.547 46.8196 114.822 46.4105C115.098 45.9986 115.43 45.6861 115.819 45.473C116.211 45.2599 116.653 45.1534 117.145 45.1534C117.633 45.1534 118.068 45.2514 118.449 45.4474C118.832 45.6406 119.145 45.9105 119.386 46.2571C119.627 46.6037 119.784 47.0028 119.855 47.4545H118.815C118.718 47.0625 118.531 46.7372 118.252 46.4787C117.974 46.2202 117.605 46.0909 117.145 46.0909C116.468 46.0909 115.936 46.3849 115.547 46.973C115.16 47.5611 114.966 48.3864 114.963 49.4489H115.031C115.19 49.2074 115.379 49.0014 115.598 48.831C115.819 48.6577 116.064 48.5241 116.331 48.4304C116.598 48.3366 116.88 48.2898 117.179 48.2898C117.679 48.2898 118.136 48.4148 118.551 48.6648C118.966 48.9119 119.298 49.2543 119.548 49.6918C119.798 50.1264 119.923 50.625 119.923 51.1875C119.923 51.7273 119.802 52.2216 119.561 52.6705C119.319 53.1165 118.98 53.4716 118.542 53.7358C118.108 53.9972 117.596 54.125 117.008 54.1193ZM117.008 53.1818C117.366 53.1818 117.687 53.0923 117.971 52.9134C118.258 52.7344 118.484 52.4943 118.649 52.1932C118.816 51.892 118.9 51.5568 118.9 51.1875C118.9 50.8267 118.819 50.4986 118.657 50.2031C118.498 49.9048 118.278 49.6676 117.997 49.4915C117.718 49.3153 117.4 49.2273 117.042 49.2273C116.772 49.2273 116.521 49.2812 116.288 49.3892C116.055 49.4943 115.85 49.6392 115.674 49.8239C115.501 50.0085 115.365 50.2202 115.265 50.4588C115.166 50.6946 115.116 50.9432 115.116 51.2045C115.116 51.5511 115.197 51.875 115.359 52.1761C115.524 52.4773 115.748 52.7202 116.032 52.9048C116.319 53.0895 116.645 53.1818 117.008 53.1818ZM124.394 54.1193C123.809 54.1193 123.292 54.0156 122.843 53.8082C122.397 53.598 122.049 53.3097 121.799 52.9432C121.549 52.5739 121.425 52.1534 121.428 51.6818C121.425 51.3125 121.498 50.9716 121.646 50.6591C121.793 50.3437 121.995 50.081 122.251 49.8707C122.509 49.6577 122.798 49.5227 123.116 49.4659V49.4148C122.698 49.3068 122.366 49.0724 122.119 48.7116C121.871 48.348 121.749 47.9347 121.752 47.4716C121.749 47.0284 121.862 46.6321 122.089 46.2827C122.316 45.9332 122.629 45.6577 123.026 45.456C123.427 45.2543 123.883 45.1534 124.394 45.1534C124.9 45.1534 125.352 45.2543 125.749 45.456C126.147 45.6577 126.46 45.9332 126.687 46.2827C126.917 46.6321 127.033 47.0284 127.036 47.4716C127.033 47.9347 126.907 48.348 126.657 48.7116C126.41 49.0724 126.082 49.3068 125.673 49.4148V49.4659C125.988 49.5227 126.272 49.6577 126.525 49.8707C126.778 50.081 126.979 50.3437 127.13 50.6591C127.281 50.9716 127.357 51.3125 127.36 51.6818C127.357 52.1534 127.229 52.5739 126.977 52.9432C126.727 53.3097 126.379 53.598 125.933 53.8082C125.489 54.0156 124.977 54.1193 124.394 54.1193ZM124.394 53.1818C124.789 53.1818 125.13 53.1179 125.417 52.9901C125.704 52.8622 125.925 52.6818 126.082 52.4489C126.238 52.2159 126.317 51.9432 126.32 51.6307C126.317 51.3011 126.232 51.0099 126.065 50.7571C125.897 50.5043 125.668 50.3054 125.379 50.1605C125.092 50.0156 124.763 49.9432 124.394 49.9432C124.022 49.9432 123.69 50.0156 123.397 50.1605C123.107 50.3054 122.879 50.5043 122.711 50.7571C122.546 51.0099 122.465 51.3011 122.468 51.6307C122.465 51.9432 122.54 52.2159 122.694 52.4489C122.85 52.6818 123.073 52.8622 123.363 52.9901C123.653 53.1179 123.996 53.1818 124.394 53.1818ZM124.394 49.0398C124.707 49.0398 124.984 48.9773 125.225 48.8523C125.469 48.7273 125.661 48.5526 125.8 48.3281C125.94 48.1037 126.011 47.8409 126.013 47.5398C126.011 47.2443 125.941 46.9872 125.805 46.7685C125.668 46.5469 125.479 46.3764 125.238 46.2571C124.996 46.1349 124.715 46.0739 124.394 46.0739C124.067 46.0739 123.782 46.1349 123.538 46.2571C123.293 46.3764 123.104 46.5469 122.971 46.7685C122.837 46.9872 122.772 47.2443 122.775 47.5398C122.772 47.8409 122.839 48.1037 122.975 48.3281C123.114 48.5526 123.306 48.7273 123.55 48.8523C123.795 48.9773 124.076 49.0398 124.394 49.0398Z"
            fill="#6B6D76"
          />
          <path
            d="M41.6307 71.1193C41.1307 71.1193 40.6804 71.0199 40.2798 70.821C39.8793 70.6222 39.5582 70.3494 39.3168 70.0028C39.0753 69.6562 38.9432 69.2614 38.9205 68.8182H39.9432C39.983 69.2131 40.1619 69.5398 40.4801 69.7983C40.8011 70.054 41.1847 70.1818 41.6307 70.1818C41.9886 70.1818 42.3068 70.098 42.5852 69.9304C42.8665 69.7628 43.0866 69.5327 43.2457 69.2401C43.4077 68.9446 43.4886 68.6108 43.4886 68.2386C43.4886 67.858 43.4048 67.5185 43.2372 67.2202C43.0724 66.919 42.8452 66.6818 42.5554 66.5085C42.2656 66.3352 41.9347 66.2472 41.5625 66.2443C41.2955 66.2415 41.0213 66.2827 40.7401 66.3679C40.4588 66.4503 40.2273 66.5568 40.0455 66.6875L39.0568 66.5682L39.5852 62.2727H44.1193V63.2102H40.4716L40.1648 65.7841H40.2159C40.3949 65.642 40.6193 65.5241 40.8892 65.4304C41.1591 65.3366 41.4403 65.2898 41.733 65.2898C42.267 65.2898 42.7429 65.4176 43.1605 65.6733C43.581 65.9261 43.9105 66.2727 44.1491 66.7131C44.3906 67.1534 44.5114 67.6562 44.5114 68.2216C44.5114 68.7784 44.3864 69.2756 44.1364 69.7131C43.8892 70.1477 43.5483 70.4915 43.1136 70.7443C42.679 70.9943 42.1847 71.1193 41.6307 71.1193ZM52.3235 65C52.2298 64.7131 52.1062 64.456 51.9528 64.2287C51.8022 63.9986 51.6218 63.8026 51.4116 63.6406C51.2042 63.4787 50.9684 63.3551 50.7042 63.2699C50.44 63.1847 50.1502 63.142 49.8349 63.142C49.3178 63.142 48.8477 63.2756 48.4244 63.5426C48.0011 63.8097 47.6644 64.2031 47.4144 64.723C47.1644 65.2429 47.0394 65.8807 47.0394 66.6364C47.0394 67.392 47.1658 68.0298 47.4187 68.5497C47.6715 69.0696 48.0138 69.4631 48.4457 69.7301C48.8775 69.9972 49.3633 70.1307 49.9031 70.1307C50.4031 70.1307 50.8434 70.0241 51.2241 69.8111C51.6076 69.5952 51.9059 69.2912 52.119 68.8991C52.3349 68.5043 52.4428 68.0398 52.4428 67.5057L52.7667 67.5739H50.1417V66.6364H53.4656V67.5739C53.4656 68.2926 53.3121 68.9176 53.0053 69.4489C52.7013 69.9801 52.2809 70.392 51.744 70.6847C51.2099 70.9744 50.5962 71.1193 49.9031 71.1193C49.1303 71.1193 48.4513 70.9375 47.8661 70.5739C47.2837 70.2102 46.8292 69.6932 46.5025 69.0227C46.1786 68.3523 46.0167 67.5568 46.0167 66.6364C46.0167 65.946 46.109 65.3253 46.2937 64.7741C46.4812 64.2202 46.7454 63.7486 47.0863 63.3594C47.4272 62.9702 47.8306 62.6719 48.2965 62.4645C48.7624 62.2571 49.2752 62.1534 49.8349 62.1534C50.2951 62.1534 50.7241 62.223 51.1218 62.3622C51.5224 62.4986 51.8789 62.6932 52.1914 62.946C52.5067 63.196 52.7695 63.4957 52.9798 63.8452C53.19 64.1918 53.3349 64.5767 53.4144 65H52.3235ZM55.2756 71V62.2727H56.3324V66.1591H60.9858V62.2727H62.0426V71H60.9858V67.0966H56.3324V71H55.2756ZM63.8345 71V70.233L67.5504 65.4602V65.392H63.9538V64.4545H68.8459V65.2557L65.2322 69.9943V70.0625H68.9652V71H63.8345ZM75.1018 66.284V71.96H75.9898V66.284H75.1018ZM75.1138 60.932V64.448H76.0018V60.932H75.1138ZM71.8858 67.628V71.072H72.7498V68.372H78.9178V67.628H71.8858ZM78.5698 67.628V70.124C78.5698 70.256 78.5338 70.304 78.3658 70.316C78.1978 70.316 77.6338 70.328 76.9858 70.304C77.1178 70.52 77.2378 70.832 77.2858 71.072C78.1258 71.072 78.6778 71.072 79.0258 70.94C79.3738 70.808 79.4578 70.58 79.4578 70.136V67.628H78.5698ZM70.5298 65.624V68H71.3698V66.368H79.7938V68H80.6698V65.624H70.5298ZM72.1738 60.992V64.88H79.0378V60.992H78.1498V64.148H73.0378V60.992H72.1738ZM70.2058 62.192V62.948H80.9938V62.192H70.2058ZM86.2472 66.6364C86.2472 65.5625 86.3864 64.5753 86.6648 63.6747C86.946 62.7713 87.3466 61.9403 87.8665 61.1818H88.7528C88.5483 61.4631 88.3565 61.8097 88.1776 62.2216C88.0014 62.6307 87.8466 63.081 87.7131 63.5724C87.5795 64.0611 87.4744 64.5668 87.3977 65.0895C87.3239 65.6122 87.2869 66.1278 87.2869 66.6364C87.2869 67.3125 87.3523 67.9986 87.483 68.6946C87.6136 69.3906 87.7898 70.0369 88.0114 70.6335C88.233 71.2301 88.4801 71.7159 88.7528 72.0909H87.8665C87.3466 71.3324 86.946 70.5028 86.6648 69.6023C86.3864 68.6989 86.2472 67.7102 86.2472 66.6364ZM91.9585 71L89.5721 62.2727H90.646L92.4698 69.3807H92.555L94.413 62.2727H95.6062L97.4641 69.3807H97.5494L99.3732 62.2727H100.447L98.0607 71H96.9698L95.0437 64.0455H94.9755L93.0494 71H91.9585ZM104.338 71.1193C103.838 71.1193 103.387 71.0199 102.987 70.821C102.586 70.6222 102.265 70.3494 102.024 70.0028C101.782 69.6562 101.65 69.2614 101.627 68.8182H102.65C102.69 69.2131 102.869 69.5398 103.187 69.7983C103.508 70.054 103.892 70.1818 104.338 70.1818C104.696 70.1818 105.014 70.098 105.292 69.9304C105.574 69.7628 105.794 69.5327 105.953 69.2401C106.115 68.9446 106.196 68.6108 106.196 68.2386C106.196 67.858 106.112 67.5185 105.944 67.2202C105.779 66.919 105.552 66.6818 105.262 66.5085C104.973 66.3352 104.642 66.2472 104.27 66.2443C104.002 66.2415 103.728 66.2827 103.447 66.3679C103.166 66.4503 102.934 66.5568 102.752 66.6875L101.764 66.5682L102.292 62.2727H106.826V63.2102H103.179L102.872 65.7841H102.923C103.102 65.642 103.326 65.5241 103.596 65.4304C103.866 65.3366 104.147 65.2898 104.44 65.2898C104.974 65.2898 105.45 65.4176 105.868 65.6733C106.288 65.9261 106.618 66.2727 106.856 66.7131C107.098 67.1534 107.218 67.6562 107.218 68.2216C107.218 68.7784 107.093 69.2756 106.843 69.7131C106.596 70.1477 106.255 70.4915 105.821 70.7443C105.386 70.9943 104.892 71.1193 104.338 71.1193ZM108.911 71V70.233L111.792 67.0795C112.13 66.7102 112.408 66.3892 112.627 66.1165C112.846 65.8409 113.008 65.5824 113.113 65.3409C113.221 65.0966 113.275 64.8409 113.275 64.5739C113.275 64.267 113.201 64.0014 113.053 63.777C112.908 63.5526 112.71 63.3793 112.457 63.2571C112.204 63.1349 111.92 63.0739 111.604 63.0739C111.269 63.0739 110.977 63.1435 110.727 63.2827C110.479 63.419 110.288 63.6108 110.151 63.858C110.018 64.1051 109.951 64.3949 109.951 64.7273H108.945C108.945 64.2159 109.063 63.767 109.299 63.3807C109.535 62.9943 109.856 62.6932 110.262 62.4773C110.671 62.2614 111.13 62.1534 111.638 62.1534C112.15 62.1534 112.603 62.2614 112.998 62.4773C113.393 62.6932 113.702 62.9844 113.927 63.3509C114.151 63.7173 114.263 64.125 114.263 64.5739C114.263 64.8949 114.205 65.2088 114.089 65.5156C113.975 65.8196 113.776 66.1591 113.492 66.5341C113.211 66.9062 112.82 67.3608 112.32 67.8977L110.36 69.9943V70.0625H114.417V71H108.911ZM117.694 69.8068L117.626 70.267C117.577 70.5909 117.504 70.9375 117.404 71.3068C117.308 71.6761 117.207 72.0241 117.102 72.3509C116.996 72.6776 116.91 72.9375 116.842 73.1307H116.075C116.112 72.9489 116.16 72.7088 116.219 72.4105C116.279 72.1122 116.339 71.7784 116.398 71.4091C116.461 71.0426 116.512 70.6676 116.552 70.2841L116.603 69.8068H117.694ZM124.654 71L122.267 62.2727H123.341L125.165 69.3807H125.25L127.108 62.2727H128.301L130.159 69.3807H130.245L132.069 62.2727H133.142L130.756 71H129.665L127.739 64.0455H127.671L125.745 71H124.654ZM137.033 71.1193C136.533 71.1193 136.083 71.0199 135.682 70.821C135.282 70.6222 134.961 70.3494 134.719 70.0028C134.478 69.6562 134.346 69.2614 134.323 68.8182H135.346C135.385 69.2131 135.564 69.5398 135.882 69.7983C136.203 70.054 136.587 70.1818 137.033 70.1818C137.391 70.1818 137.709 70.098 137.988 69.9304C138.269 69.7628 138.489 69.5327 138.648 69.2401C138.81 68.9446 138.891 68.6108 138.891 68.2386C138.891 67.858 138.807 67.5185 138.64 67.2202C138.475 66.919 138.248 66.6818 137.958 66.5085C137.668 66.3352 137.337 66.2472 136.965 66.2443C136.698 66.2415 136.424 66.2827 136.142 66.3679C135.861 66.4503 135.63 66.5568 135.448 66.6875L134.459 66.5682L134.988 62.2727H139.522V63.2102H135.874L135.567 65.7841H135.618C135.797 65.642 136.022 65.5241 136.292 65.4304C136.561 65.3366 136.843 65.2898 137.135 65.2898C137.669 65.2898 138.145 65.4176 138.563 65.6733C138.983 65.9261 139.313 66.2727 139.551 66.7131C139.793 67.1534 139.914 67.6562 139.914 68.2216C139.914 68.7784 139.789 69.2756 139.539 69.7131C139.292 70.1477 138.951 70.4915 138.516 70.7443C138.081 70.9943 137.587 71.1193 137.033 71.1193ZM144.555 71.1193C143.993 71.1193 143.491 71.0227 143.051 70.8295C142.614 70.6364 142.266 70.3679 142.007 70.0241C141.751 69.6776 141.612 69.2756 141.589 68.8182H142.663C142.686 69.0994 142.783 69.3423 142.953 69.5469C143.124 69.7486 143.347 69.9048 143.622 70.0156C143.898 70.1264 144.203 70.1818 144.538 70.1818C144.913 70.1818 145.246 70.1165 145.536 69.9858C145.825 69.8551 146.053 69.6733 146.217 69.4403C146.382 69.2074 146.464 68.9375 146.464 68.6307C146.464 68.3097 146.385 68.027 146.226 67.7827C146.067 67.5355 145.834 67.3423 145.527 67.2031C145.22 67.0639 144.845 66.9943 144.402 66.9943H143.703V66.0568H144.402C144.749 66.0568 145.053 65.9943 145.314 65.8693C145.578 65.7443 145.784 65.5682 145.932 65.3409C146.082 65.1136 146.158 64.8466 146.158 64.5398C146.158 64.2443 146.092 63.9872 145.962 63.7685C145.831 63.5497 145.646 63.3793 145.408 63.2571C145.172 63.1349 144.893 63.0739 144.572 63.0739C144.271 63.0739 143.987 63.1293 143.72 63.2401C143.456 63.348 143.24 63.5057 143.072 63.7131C142.905 63.9176 142.814 64.1648 142.8 64.4545H141.777C141.794 63.9972 141.932 63.5966 142.19 63.2528C142.449 62.9062 142.787 62.6364 143.205 62.4432C143.625 62.25 144.087 62.1534 144.589 62.1534C145.129 62.1534 145.592 62.2628 145.979 62.4815C146.365 62.6974 146.662 62.983 146.869 63.3381C147.077 63.6932 147.18 64.0767 147.18 64.4886C147.18 64.9801 147.051 65.3991 146.793 65.7457C146.537 66.0923 146.189 66.3324 145.749 66.4659V66.5341C146.3 66.625 146.73 66.8594 147.04 67.2372C147.349 67.6122 147.504 68.0767 147.504 68.6307C147.504 69.1051 147.375 69.5312 147.116 69.9091C146.861 70.2841 146.511 70.5795 146.068 70.7955C145.625 71.0114 145.121 71.1193 144.555 71.1193ZM151.412 66.6364C151.412 67.7102 151.271 68.6989 150.99 69.6023C150.712 70.5028 150.313 71.3324 149.793 72.0909H148.906C149.111 71.8097 149.301 71.4631 149.477 71.0511C149.656 70.642 149.813 70.1932 149.946 69.7045C150.08 69.2131 150.183 68.706 150.257 68.1832C150.334 67.6577 150.372 67.142 150.372 66.6364C150.372 65.9602 150.307 65.2741 150.176 64.5781C150.045 63.8821 149.869 63.2358 149.648 62.6392C149.426 62.0426 149.179 61.5568 148.906 61.1818H149.793C150.313 61.9403 150.712 62.7713 150.99 63.6747C151.271 64.5753 151.412 65.5625 151.412 66.6364ZM154.345 69.8835C154.135 69.8835 153.954 69.8082 153.804 69.6577C153.653 69.5071 153.578 69.3267 153.578 69.1165C153.578 68.9062 153.653 68.7259 153.804 68.5753C153.954 68.4247 154.135 68.3494 154.345 68.3494C154.555 68.3494 154.735 68.4247 154.886 68.5753C155.037 68.7259 155.112 68.9062 155.112 69.1165C155.112 69.2557 155.076 69.3835 155.005 69.5C154.937 69.6165 154.845 69.7102 154.728 69.7812C154.615 69.8494 154.487 69.8835 154.345 69.8835ZM154.345 65.4688C154.135 65.4688 153.954 65.3935 153.804 65.2429C153.653 65.0923 153.578 64.9119 153.578 64.7017C153.578 64.4915 153.653 64.3111 153.804 64.1605C153.954 64.0099 154.135 63.9347 154.345 63.9347C154.555 63.9347 154.735 64.0099 154.886 64.1605C155.037 64.3111 155.112 64.4915 155.112 64.7017C155.112 64.8409 155.076 64.9688 155.005 65.0852C154.937 65.2017 154.845 65.2955 154.728 65.3665C154.615 65.4347 154.487 65.4688 154.345 65.4688ZM157.736 61.532V64.892C157.736 66.836 157.628 69.572 156.428 71.504C156.656 71.6 157.052 71.816 157.22 71.972C158.468 69.956 158.636 66.956 158.636 64.892V61.532H157.736ZM158.216 61.532V62.288H165.74V63.548H158.216V64.304H166.64V61.532H158.216ZM158.66 65.096V65.828H166.988V65.096H158.66ZM159.2 68.828V69.584H166.424V68.828H159.2ZM158.288 70.88V71.624H167.36V70.88H158.288ZM162.308 67.7V71.36H163.196V67.7H162.308ZM158.924 67.208L158.984 67.952C160.712 67.892 163.316 67.796 165.764 67.676L165.8 66.98C163.244 67.088 160.592 67.172 158.924 67.208ZM161.384 65.24C161.084 65.9 160.532 66.86 160.088 67.448L160.796 67.736C161.252 67.172 161.816 66.296 162.284 65.552L161.384 65.24ZM163.7 66.284C164.612 66.86 165.692 67.724 166.208 68.336L166.916 67.832C166.388 67.232 165.284 66.392 164.372 65.84L163.7 66.284ZM173.408 65.792C174.632 66.896 176.168 68.432 176.888 69.38L177.632 68.804C176.864 67.868 175.304 66.368 174.08 65.312L173.408 65.792ZM173.54 60.92V63.272C173.54 64.928 173.384 67.244 170.384 68.864C170.588 69.02 170.9 69.344 171.02 69.536C174.116 67.724 174.464 65.192 174.464 63.272V60.92H173.54ZM169.172 62.972V71.984H170.072V63.86H178.352V62.972H169.172ZM177.944 62.972V70.772C177.944 70.976 177.872 71.048 177.644 71.06C177.404 71.072 176.588 71.072 175.736 71.036C175.856 71.288 176 71.708 176.036 71.96C177.116 71.96 177.86 71.948 178.28 71.804C178.688 71.648 178.832 71.36 178.832 70.772V62.972H177.944ZM183.836 62.252V63.092H191.54V62.252H183.836ZM185.024 65.024H190.268V66.824H185.024V65.024ZM184.196 64.256V67.592H191.144V64.256H184.196ZM184.94 67.832L184.196 68.084C185.468 70.28 187.928 71.528 191.108 71.984C191.228 71.732 191.456 71.372 191.648 71.18C188.528 70.832 186.068 69.716 184.94 67.832ZM187.172 60.968V66.272C187.172 68.3 186.968 70.352 183.404 71.252C183.584 71.444 183.836 71.804 183.944 72.008C187.664 70.904 188.06 68.6 188.06 66.284V60.968H187.172ZM183.32 60.896C182.624 62.72 181.448 64.508 180.236 65.648C180.404 65.864 180.656 66.332 180.74 66.536C182.072 65.204 183.356 63.188 184.172 61.16L183.32 60.896ZM182.06 64.04V72.02H182.924V63.2L182.912 63.188L182.06 64.04ZM194.336 61.772V62.636H202.1V61.772H194.336ZM194.336 64.568V65.42H202.088V64.568H194.336ZM194.276 67.436V68.288H202.112V67.436H194.276ZM193.832 61.772V66.116C193.832 67.808 193.7 69.944 192.38 71.432C192.572 71.552 192.932 71.852 193.076 72.032C194.504 70.436 194.72 67.952 194.72 66.128V61.772H193.832ZM201.74 61.772V70.736C201.74 70.964 201.656 71.036 201.428 71.048C201.2 71.048 200.384 71.06 199.532 71.024C199.664 71.264 199.808 71.66 199.844 71.9C200.984 71.912 201.68 71.9 202.088 71.756C202.484 71.6 202.628 71.324 202.628 70.736V61.772H201.74ZM197.6 62.096V71.852H198.512V62.096H197.6ZM209.84 63.728V64.484H214.316V63.728H209.84ZM207.968 70.916L208.268 71.792C209.432 71.528 211.04 71.18 212.552 70.832L212.492 70.04C210.812 70.376 209.072 70.724 207.968 70.916ZM209.324 61.46V70.988H210.2V61.46H209.324ZM209.84 61.46V62.252H213.86V65.996H209.84V66.788H214.736V61.46H209.84ZM212.156 66.272L211.412 66.416C211.964 68.948 213.08 70.976 214.952 71.924C215.084 71.696 215.348 71.36 215.552 71.18C213.764 70.388 212.672 68.516 212.156 66.272ZM214.544 67.064C214.04 67.64 213.14 68.396 212.492 68.864L213.056 69.32C213.728 68.876 214.58 68.204 215.252 67.58L214.544 67.064ZM204.968 61.448V71.972H205.82V62.264H208.04V61.448H204.968ZM207.776 61.448V61.7C207.5 62.528 207.008 63.98 206.528 65.072C207.464 66.008 207.716 66.8 207.716 67.46C207.728 67.832 207.656 68.144 207.452 68.276C207.332 68.348 207.188 68.384 207.032 68.396C206.816 68.408 206.552 68.408 206.24 68.372C206.384 68.612 206.456 68.972 206.468 69.188C206.768 69.212 207.104 69.212 207.38 69.176C207.632 69.152 207.86 69.08 208.04 68.96C208.4 68.708 208.556 68.216 208.556 67.556C208.556 66.812 208.328 65.96 207.356 64.964C207.8 64.016 208.304 62.78 208.688 61.784L208.076 61.412L207.944 61.448H207.776ZM218.528 64.592V65.456H225.524V64.592H218.528ZM221.984 67.46V68.312H226.028V67.46H221.984ZM221.504 65.036V70.988L222.44 71.108V65.036H221.504ZM218.66 66.488C218.396 68.66 217.748 70.376 216.404 71.42C216.62 71.552 217.004 71.864 217.148 72.02C218.504 70.844 219.26 69.008 219.596 66.584L218.66 66.488ZM219.224 68.036L218.492 68.312C219.524 71.24 221.48 71.804 224.336 71.804H227.156C227.192 71.54 227.348 71.108 227.492 70.892C226.904 70.904 224.828 70.904 224.384 70.904C221.948 70.904 220.076 70.484 219.224 68.036ZM221.492 60.932V62.876H222.44V60.932H221.492ZM216.98 62.3V64.916H217.868V63.164H226.088V64.916H227.012V62.3H216.98Z"
            fill="#6B6D76"
          />
          <Logo5GHZ />
        </svg>
      );
    case DeviceModel.U7NHD:
      return (
        <svg width="260" height="105" viewBox="0 0 260 105" fill="none" xmlns="http://www.w3.org/2000/svg">
          <ComplianceImage />
          <JapaneseTelecomLogo />
          <LogoR />
          <path
            d="M58.9034 54V53.233L61.7841 50.0795C62.1222 49.7102 62.4006 49.3892 62.6193 49.1165C62.8381 48.8409 63 48.5824 63.1051 48.3409C63.2131 48.0966 63.267 47.8409 63.267 47.5739C63.267 47.267 63.1932 47.0014 63.0455 46.777C62.9006 46.5526 62.7017 46.3793 62.4489 46.2571C62.196 46.1349 61.9119 46.0739 61.5966 46.0739C61.2614 46.0739 60.9688 46.1435 60.7188 46.2827C60.4716 46.419 60.2798 46.6108 60.1435 46.858C60.0099 47.1051 59.9432 47.3949 59.9432 47.7273H58.9375C58.9375 47.2159 59.0554 46.767 59.2912 46.3807C59.527 45.9943 59.848 45.6932 60.2543 45.4773C60.6634 45.2614 61.1222 45.1534 61.6307 45.1534C62.142 45.1534 62.5952 45.2614 62.9901 45.4773C63.3849 45.6932 63.6946 45.9844 63.919 46.3509C64.1435 46.7173 64.2557 47.125 64.2557 47.5739C64.2557 47.8949 64.1974 48.2088 64.081 48.5156C63.9673 48.8196 63.7685 49.1591 63.4844 49.5341C63.2031 49.9062 62.8125 50.3608 62.3125 50.8977L60.3523 52.9943V53.0625H64.4091V54H58.9034ZM69.0156 54.1193C68.3736 54.1193 67.8267 53.9446 67.375 53.5952C66.9233 53.2429 66.5781 52.733 66.3395 52.0653C66.1009 51.3949 65.9815 50.5852 65.9815 49.6364C65.9815 48.6932 66.1009 47.8878 66.3395 47.2202C66.581 46.5497 66.9276 46.0384 67.3793 45.6861C67.8338 45.331 68.3793 45.1534 69.0156 45.1534C69.652 45.1534 70.196 45.331 70.6477 45.6861C71.1023 46.0384 71.4489 46.5497 71.6875 47.2202C71.929 47.8878 72.0497 48.6932 72.0497 49.6364C72.0497 50.5852 71.9304 51.3949 71.6918 52.0653C71.4531 52.733 71.108 53.2429 70.6562 53.5952C70.2045 53.9446 69.6577 54.1193 69.0156 54.1193ZM69.0156 53.1818C69.652 53.1818 70.1463 52.875 70.4986 52.2614C70.8509 51.6477 71.027 50.7727 71.027 49.6364C71.027 48.8807 70.946 48.2372 70.7841 47.706C70.625 47.1747 70.3949 46.7699 70.0938 46.4915C69.7955 46.2131 69.4361 46.0739 69.0156 46.0739C68.3849 46.0739 67.892 46.3849 67.5369 47.0071C67.1818 47.6264 67.0043 48.5028 67.0043 49.6364C67.0043 50.392 67.0838 51.0341 67.2429 51.5625C67.402 52.0909 67.6307 52.4929 67.929 52.7685C68.2301 53.044 68.5923 53.1818 69.0156 53.1818ZM76.7372 45.2727V54H75.6804V46.3807H75.6293L73.4986 47.7955V46.7216L75.6804 45.2727H76.7372ZM83.0142 49.1676V50.1051H79.196V49.1676H83.0142ZM87.8349 45.2727V54H86.7781V46.3807H86.7269L84.5962 47.7955V46.7216L86.7781 45.2727H87.8349ZM93.1403 54.1193C92.555 54.1193 92.038 54.0156 91.5891 53.8082C91.1431 53.598 90.7951 53.3097 90.5451 52.9432C90.2951 52.5739 90.1715 52.1534 90.1744 51.6818C90.1715 51.3125 90.244 50.9716 90.3917 50.6591C90.5394 50.3437 90.7411 50.081 90.9968 49.8707C91.2553 49.6577 91.5437 49.5227 91.8619 49.4659V49.4148C91.4442 49.3068 91.1119 49.0724 90.8647 48.7116C90.6175 48.348 90.4954 47.9347 90.4982 47.4716C90.4954 47.0284 90.6076 46.6321 90.8349 46.2827C91.0621 45.9332 91.3746 45.6577 91.7724 45.456C92.1729 45.2543 92.6289 45.1534 93.1403 45.1534C93.646 45.1534 94.0977 45.2543 94.4954 45.456C94.8931 45.6577 95.2056 45.9332 95.4329 46.2827C95.663 46.6321 95.7795 47.0284 95.7823 47.4716C95.7795 47.9347 95.6531 48.348 95.4031 48.7116C95.1559 49.0724 94.8278 49.3068 94.4187 49.4148V49.4659C94.734 49.5227 95.0181 49.6577 95.271 49.8707C95.5238 50.081 95.7255 50.3437 95.8761 50.6591C96.0266 50.9716 96.1033 51.3125 96.1062 51.6818C96.1033 52.1534 95.9755 52.5739 95.7227 52.9432C95.4727 53.3097 95.1246 53.598 94.6786 53.8082C94.2354 54.0156 93.7227 54.1193 93.1403 54.1193ZM93.1403 53.1818C93.5352 53.1818 93.8761 53.1179 94.163 52.9901C94.4499 52.8622 94.6715 52.6818 94.8278 52.4489C94.984 52.2159 95.0636 51.9432 95.0664 51.6307C95.0636 51.3011 94.9783 51.0099 94.8107 50.7571C94.6431 50.5043 94.4144 50.3054 94.1246 50.1605C93.8377 50.0156 93.5096 49.9432 93.1403 49.9432C92.7681 49.9432 92.4357 50.0156 92.1431 50.1605C91.8533 50.3054 91.6246 50.5043 91.457 50.7571C91.2923 51.0099 91.2113 51.3011 91.2141 51.6307C91.2113 51.9432 91.2866 52.2159 91.44 52.4489C91.5962 52.6818 91.8192 52.8622 92.109 52.9901C92.3988 53.1179 92.7425 53.1818 93.1403 53.1818ZM93.1403 49.0398C93.4528 49.0398 93.7298 48.9773 93.9712 48.8523C94.2156 48.7273 94.4073 48.5526 94.5465 48.3281C94.6857 48.1037 94.7567 47.8409 94.7596 47.5398C94.7567 47.2443 94.6871 46.9872 94.5508 46.7685C94.4144 46.5469 94.2255 46.3764 93.984 46.2571C93.7425 46.1349 93.4613 46.0739 93.1403 46.0739C92.8136 46.0739 92.5281 46.1349 92.2837 46.2571C92.0394 46.3764 91.8505 46.5469 91.717 46.7685C91.5835 46.9872 91.5181 47.2443 91.521 47.5398C91.5181 47.8409 91.5849 48.1037 91.7212 48.3281C91.8604 48.5526 92.0522 48.7273 92.2965 48.8523C92.5408 48.9773 92.8221 49.0398 93.1403 49.0398ZM100.586 54.1193C99.9439 54.1193 99.397 53.9446 98.9453 53.5952C98.4936 53.2429 98.1484 52.733 97.9098 52.0653C97.6712 51.3949 97.5518 50.5852 97.5518 49.6364C97.5518 48.6932 97.6712 47.8878 97.9098 47.2202C98.1513 46.5497 98.4979 46.0384 98.9496 45.6861C99.4041 45.331 99.9496 45.1534 100.586 45.1534C101.222 45.1534 101.766 45.331 102.218 45.6861C102.673 46.0384 103.019 46.5497 103.258 47.2202C103.499 47.8878 103.62 48.6932 103.62 49.6364C103.62 50.5852 103.501 51.3949 103.262 52.0653C103.023 52.733 102.678 53.2429 102.227 53.5952C101.775 53.9446 101.228 54.1193 100.586 54.1193ZM100.586 53.1818C101.222 53.1818 101.717 52.875 102.069 52.2614C102.421 51.6477 102.597 50.7727 102.597 49.6364C102.597 48.8807 102.516 48.2372 102.354 47.706C102.195 47.1747 101.965 46.7699 101.664 46.4915C101.366 46.2131 101.006 46.0739 100.586 46.0739C99.9553 46.0739 99.4624 46.3849 99.1072 47.0071C98.7521 47.6264 98.5746 48.5028 98.5746 49.6364C98.5746 50.392 98.6541 51.0341 98.8132 51.5625C98.9723 52.0909 99.201 52.4929 99.4993 52.7685C99.8004 53.044 100.163 53.1818 100.586 53.1818ZM108.035 54.1193C107.45 54.1193 106.933 54.0156 106.484 53.8082C106.038 53.598 105.69 53.3097 105.44 52.9432C105.19 52.5739 105.066 52.1534 105.069 51.6818C105.066 51.3125 105.138 50.9716 105.286 50.6591C105.434 50.3437 105.636 50.081 105.891 49.8707C106.15 49.6577 106.438 49.5227 106.756 49.4659V49.4148C106.339 49.3068 106.006 49.0724 105.759 48.7116C105.512 48.348 105.39 47.9347 105.393 47.4716C105.39 47.0284 105.502 46.6321 105.729 46.2827C105.957 45.9332 106.269 45.6577 106.667 45.456C107.067 45.2543 107.523 45.1534 108.035 45.1534C108.54 45.1534 108.992 45.2543 109.39 45.456C109.788 45.6577 110.1 45.9332 110.327 46.2827C110.558 46.6321 110.674 47.0284 110.677 47.4716C110.674 47.9347 110.548 48.348 110.298 48.7116C110.05 49.0724 109.722 49.3068 109.313 49.4148V49.4659C109.629 49.5227 109.913 49.6577 110.165 49.8707C110.418 50.081 110.62 50.3437 110.771 50.6591C110.921 50.9716 110.998 51.3125 111.001 51.6818C110.998 52.1534 110.87 52.5739 110.617 52.9432C110.367 53.3097 110.019 53.598 109.573 53.8082C109.13 54.0156 108.617 54.1193 108.035 54.1193ZM108.035 53.1818C108.43 53.1818 108.771 53.1179 109.058 52.9901C109.344 52.8622 109.566 52.6818 109.722 52.4489C109.879 52.2159 109.958 51.9432 109.961 51.6307C109.958 51.3011 109.873 51.0099 109.705 50.7571C109.538 50.5043 109.309 50.3054 109.019 50.1605C108.732 50.0156 108.404 49.9432 108.035 49.9432C107.663 49.9432 107.33 50.0156 107.038 50.1605C106.748 50.3054 106.519 50.5043 106.352 50.7571C106.187 51.0099 106.106 51.3011 106.109 51.6307C106.106 51.9432 106.181 52.2159 106.335 52.4489C106.491 52.6818 106.714 52.8622 107.004 52.9901C107.293 53.1179 107.637 53.1818 108.035 53.1818ZM108.035 49.0398C108.347 49.0398 108.624 48.9773 108.866 48.8523C109.11 48.7273 109.302 48.5526 109.441 48.3281C109.58 48.1037 109.651 47.8409 109.654 47.5398C109.651 47.2443 109.582 46.9872 109.445 46.7685C109.309 46.5469 109.12 46.3764 108.879 46.2571C108.637 46.1349 108.356 46.0739 108.035 46.0739C107.708 46.0739 107.423 46.1349 107.178 46.2571C106.934 46.3764 106.745 46.5469 106.612 46.7685C106.478 46.9872 106.413 47.2443 106.415 47.5398C106.413 47.8409 106.479 48.1037 106.616 48.3281C106.755 48.5526 106.947 48.7273 107.191 48.8523C107.435 48.9773 107.717 49.0398 108.035 49.0398ZM115.361 54.1193C114.861 54.1193 114.411 54.0199 114.01 53.821C113.61 53.6222 113.289 53.3494 113.047 53.0028C112.806 52.6562 112.674 52.2614 112.651 51.8182H113.674C113.713 52.2131 113.892 52.5398 114.211 52.7983C114.532 53.054 114.915 53.1818 115.361 53.1818C115.719 53.1818 116.037 53.098 116.316 52.9304C116.597 52.7628 116.817 52.5327 116.976 52.2401C117.138 51.9446 117.219 51.6108 117.219 51.2386C117.219 50.858 117.135 50.5185 116.968 50.2202C116.803 49.919 116.576 49.6818 116.286 49.5085C115.996 49.3352 115.665 49.2472 115.293 49.2443C115.026 49.2415 114.752 49.2827 114.471 49.3679C114.189 49.4503 113.958 49.5568 113.776 49.6875L112.787 49.5682L113.316 45.2727H117.85V46.2102H114.202L113.895 48.7841H113.946C114.125 48.642 114.35 48.5241 114.62 48.4304C114.89 48.3366 115.171 48.2898 115.463 48.2898C115.998 48.2898 116.473 48.4176 116.891 48.6733C117.311 48.9261 117.641 49.2727 117.88 49.7131C118.121 50.1534 118.242 50.6562 118.242 51.2216C118.242 51.7784 118.117 52.2756 117.867 52.7131C117.62 53.1477 117.279 53.4915 116.844 53.7443C116.409 53.9943 115.915 54.1193 115.361 54.1193ZM122.713 45.1534C123.071 45.1562 123.429 45.2244 123.787 45.358C124.145 45.4915 124.472 45.7131 124.767 46.0227C125.063 46.3295 125.3 46.7486 125.479 47.2798C125.658 47.8111 125.747 48.4773 125.747 49.2784C125.747 50.054 125.673 50.7429 125.526 51.3452C125.381 51.9446 125.17 52.4503 124.895 52.8622C124.622 53.2741 124.29 53.5866 123.898 53.7997C123.509 54.0128 123.068 54.1193 122.577 54.1193C122.088 54.1193 121.652 54.0227 121.268 53.8295C120.888 53.6335 120.575 53.3622 120.331 53.0156C120.089 52.6662 119.935 52.2614 119.866 51.8011H120.906C121 52.2017 121.186 52.5327 121.464 52.794C121.746 53.0526 122.116 53.1818 122.577 53.1818C123.25 53.1818 123.781 52.8878 124.17 52.2997C124.563 51.7116 124.759 50.8807 124.759 49.8068H124.69C124.531 50.0455 124.342 50.2514 124.124 50.4247C123.905 50.598 123.662 50.7315 123.395 50.8253C123.128 50.919 122.844 50.9659 122.543 50.9659C122.043 50.9659 121.584 50.8423 121.166 50.5952C120.751 50.3452 120.419 50.0028 120.169 49.5682C119.922 49.1307 119.798 48.6307 119.798 48.0682C119.798 47.5341 119.918 47.0455 120.156 46.6023C120.398 46.1562 120.736 45.8011 121.17 45.5369C121.608 45.2727 122.122 45.1449 122.713 45.1534ZM122.713 46.0909C122.355 46.0909 122.033 46.1804 121.746 46.3594C121.462 46.5355 121.236 46.7741 121.068 47.0753C120.903 47.3736 120.821 47.7045 120.821 48.0682C120.821 48.4318 120.901 48.7628 121.06 49.0611C121.222 49.3565 121.442 49.5923 121.72 49.7685C122.001 49.9418 122.321 50.0284 122.679 50.0284C122.949 50.0284 123.2 49.9759 123.433 49.8707C123.666 49.7628 123.869 49.6165 124.043 49.4318C124.219 49.2443 124.357 49.0327 124.456 48.7969C124.555 48.5582 124.605 48.3097 124.605 48.0511C124.605 47.7102 124.523 47.3906 124.358 47.0923C124.196 46.794 123.972 46.5526 123.685 46.3679C123.401 46.1832 123.077 46.0909 122.713 46.0909Z"
            fill="#6B6D76"
          />
          <path
            d="M41.6307 71.1193C41.1307 71.1193 40.6804 71.0199 40.2798 70.821C39.8793 70.6222 39.5582 70.3494 39.3168 70.0028C39.0753 69.6562 38.9432 69.2614 38.9205 68.8182H39.9432C39.983 69.2131 40.1619 69.5398 40.4801 69.7983C40.8011 70.054 41.1847 70.1818 41.6307 70.1818C41.9886 70.1818 42.3068 70.098 42.5852 69.9304C42.8665 69.7628 43.0866 69.5327 43.2457 69.2401C43.4077 68.9446 43.4886 68.6108 43.4886 68.2386C43.4886 67.858 43.4048 67.5185 43.2372 67.2202C43.0724 66.919 42.8452 66.6818 42.5554 66.5085C42.2656 66.3352 41.9347 66.2472 41.5625 66.2443C41.2955 66.2415 41.0213 66.2827 40.7401 66.3679C40.4588 66.4503 40.2273 66.5568 40.0455 66.6875L39.0568 66.5682L39.5852 62.2727H44.1193V63.2102H40.4716L40.1648 65.7841H40.2159C40.3949 65.642 40.6193 65.5241 40.8892 65.4304C41.1591 65.3366 41.4403 65.2898 41.733 65.2898C42.267 65.2898 42.7429 65.4176 43.1605 65.6733C43.581 65.9261 43.9105 66.2727 44.1491 66.7131C44.3906 67.1534 44.5114 67.6562 44.5114 68.2216C44.5114 68.7784 44.3864 69.2756 44.1364 69.7131C43.8892 70.1477 43.5483 70.4915 43.1136 70.7443C42.679 70.9943 42.1847 71.1193 41.6307 71.1193ZM52.3235 65C52.2298 64.7131 52.1062 64.456 51.9528 64.2287C51.8022 63.9986 51.6218 63.8026 51.4116 63.6406C51.2042 63.4787 50.9684 63.3551 50.7042 63.2699C50.44 63.1847 50.1502 63.142 49.8349 63.142C49.3178 63.142 48.8477 63.2756 48.4244 63.5426C48.0011 63.8097 47.6644 64.2031 47.4144 64.723C47.1644 65.2429 47.0394 65.8807 47.0394 66.6364C47.0394 67.392 47.1658 68.0298 47.4187 68.5497C47.6715 69.0696 48.0138 69.4631 48.4457 69.7301C48.8775 69.9972 49.3633 70.1307 49.9031 70.1307C50.4031 70.1307 50.8434 70.0241 51.2241 69.8111C51.6076 69.5952 51.9059 69.2912 52.119 68.8991C52.3349 68.5043 52.4428 68.0398 52.4428 67.5057L52.7667 67.5739H50.1417V66.6364H53.4656V67.5739C53.4656 68.2926 53.3121 68.9176 53.0053 69.4489C52.7013 69.9801 52.2809 70.392 51.744 70.6847C51.2099 70.9744 50.5962 71.1193 49.9031 71.1193C49.1303 71.1193 48.4513 70.9375 47.8661 70.5739C47.2837 70.2102 46.8292 69.6932 46.5025 69.0227C46.1786 68.3523 46.0167 67.5568 46.0167 66.6364C46.0167 65.946 46.109 65.3253 46.2937 64.7741C46.4812 64.2202 46.7454 63.7486 47.0863 63.3594C47.4272 62.9702 47.8306 62.6719 48.2965 62.4645C48.7624 62.2571 49.2752 62.1534 49.8349 62.1534C50.2951 62.1534 50.7241 62.223 51.1218 62.3622C51.5224 62.4986 51.8789 62.6932 52.1914 62.946C52.5067 63.196 52.7695 63.4957 52.9798 63.8452C53.19 64.1918 53.3349 64.5767 53.4144 65H52.3235ZM55.2756 71V62.2727H56.3324V66.1591H60.9858V62.2727H62.0426V71H60.9858V67.0966H56.3324V71H55.2756ZM63.8345 71V70.233L67.5504 65.4602V65.392H63.9538V64.4545H68.8459V65.2557L65.2322 69.9943V70.0625H68.9652V71H63.8345ZM75.1018 66.284V71.96H75.9898V66.284H75.1018ZM75.1138 60.932V64.448H76.0018V60.932H75.1138ZM71.8858 67.628V71.072H72.7498V68.372H78.9178V67.628H71.8858ZM78.5698 67.628V70.124C78.5698 70.256 78.5338 70.304 78.3658 70.316C78.1978 70.316 77.6338 70.328 76.9858 70.304C77.1178 70.52 77.2378 70.832 77.2858 71.072C78.1258 71.072 78.6778 71.072 79.0258 70.94C79.3738 70.808 79.4578 70.58 79.4578 70.136V67.628H78.5698ZM70.5298 65.624V68H71.3698V66.368H79.7938V68H80.6698V65.624H70.5298ZM72.1738 60.992V64.88H79.0378V60.992H78.1498V64.148H73.0378V60.992H72.1738ZM70.2058 62.192V62.948H80.9938V62.192H70.2058ZM86.2472 66.6364C86.2472 65.5625 86.3864 64.5753 86.6648 63.6747C86.946 62.7713 87.3466 61.9403 87.8665 61.1818H88.7528C88.5483 61.4631 88.3565 61.8097 88.1776 62.2216C88.0014 62.6307 87.8466 63.081 87.7131 63.5724C87.5795 64.0611 87.4744 64.5668 87.3977 65.0895C87.3239 65.6122 87.2869 66.1278 87.2869 66.6364C87.2869 67.3125 87.3523 67.9986 87.483 68.6946C87.6136 69.3906 87.7898 70.0369 88.0114 70.6335C88.233 71.2301 88.4801 71.7159 88.7528 72.0909H87.8665C87.3466 71.3324 86.946 70.5028 86.6648 69.6023C86.3864 68.6989 86.2472 67.7102 86.2472 66.6364ZM91.9585 71L89.5721 62.2727H90.646L92.4698 69.3807H92.555L94.413 62.2727H95.6062L97.4641 69.3807H97.5494L99.3732 62.2727H100.447L98.0607 71H96.9698L95.0437 64.0455H94.9755L93.0494 71H91.9585ZM104.338 71.1193C103.838 71.1193 103.387 71.0199 102.987 70.821C102.586 70.6222 102.265 70.3494 102.024 70.0028C101.782 69.6562 101.65 69.2614 101.627 68.8182H102.65C102.69 69.2131 102.869 69.5398 103.187 69.7983C103.508 70.054 103.892 70.1818 104.338 70.1818C104.696 70.1818 105.014 70.098 105.292 69.9304C105.574 69.7628 105.794 69.5327 105.953 69.2401C106.115 68.9446 106.196 68.6108 106.196 68.2386C106.196 67.858 106.112 67.5185 105.944 67.2202C105.779 66.919 105.552 66.6818 105.262 66.5085C104.973 66.3352 104.642 66.2472 104.27 66.2443C104.002 66.2415 103.728 66.2827 103.447 66.3679C103.166 66.4503 102.934 66.5568 102.752 66.6875L101.764 66.5682L102.292 62.2727H106.826V63.2102H103.179L102.872 65.7841H102.923C103.102 65.642 103.326 65.5241 103.596 65.4304C103.866 65.3366 104.147 65.2898 104.44 65.2898C104.974 65.2898 105.45 65.4176 105.868 65.6733C106.288 65.9261 106.618 66.2727 106.856 66.7131C107.098 67.1534 107.218 67.6562 107.218 68.2216C107.218 68.7784 107.093 69.2756 106.843 69.7131C106.596 70.1477 106.255 70.4915 105.821 70.7443C105.386 70.9943 104.892 71.1193 104.338 71.1193ZM108.911 71V70.233L111.792 67.0795C112.13 66.7102 112.408 66.3892 112.627 66.1165C112.846 65.8409 113.008 65.5824 113.113 65.3409C113.221 65.0966 113.275 64.8409 113.275 64.5739C113.275 64.267 113.201 64.0014 113.053 63.777C112.908 63.5526 112.71 63.3793 112.457 63.2571C112.204 63.1349 111.92 63.0739 111.604 63.0739C111.269 63.0739 110.977 63.1435 110.727 63.2827C110.479 63.419 110.288 63.6108 110.151 63.858C110.018 64.1051 109.951 64.3949 109.951 64.7273H108.945C108.945 64.2159 109.063 63.767 109.299 63.3807C109.535 62.9943 109.856 62.6932 110.262 62.4773C110.671 62.2614 111.13 62.1534 111.638 62.1534C112.15 62.1534 112.603 62.2614 112.998 62.4773C113.393 62.6932 113.702 62.9844 113.927 63.3509C114.151 63.7173 114.263 64.125 114.263 64.5739C114.263 64.8949 114.205 65.2088 114.089 65.5156C113.975 65.8196 113.776 66.1591 113.492 66.5341C113.211 66.9062 112.82 67.3608 112.32 67.8977L110.36 69.9943V70.0625H114.417V71H108.911ZM117.694 69.8068L117.626 70.267C117.577 70.5909 117.504 70.9375 117.404 71.3068C117.308 71.6761 117.207 72.0241 117.102 72.3509C116.996 72.6776 116.91 72.9375 116.842 73.1307H116.075C116.112 72.9489 116.16 72.7088 116.219 72.4105C116.279 72.1122 116.339 71.7784 116.398 71.4091C116.461 71.0426 116.512 70.6676 116.552 70.2841L116.603 69.8068H117.694ZM124.654 71L122.267 62.2727H123.341L125.165 69.3807H125.25L127.108 62.2727H128.301L130.159 69.3807H130.245L132.069 62.2727H133.142L130.756 71H129.665L127.739 64.0455H127.671L125.745 71H124.654ZM137.033 71.1193C136.533 71.1193 136.083 71.0199 135.682 70.821C135.282 70.6222 134.961 70.3494 134.719 70.0028C134.478 69.6562 134.346 69.2614 134.323 68.8182H135.346C135.385 69.2131 135.564 69.5398 135.882 69.7983C136.203 70.054 136.587 70.1818 137.033 70.1818C137.391 70.1818 137.709 70.098 137.988 69.9304C138.269 69.7628 138.489 69.5327 138.648 69.2401C138.81 68.9446 138.891 68.6108 138.891 68.2386C138.891 67.858 138.807 67.5185 138.64 67.2202C138.475 66.919 138.248 66.6818 137.958 66.5085C137.668 66.3352 137.337 66.2472 136.965 66.2443C136.698 66.2415 136.424 66.2827 136.142 66.3679C135.861 66.4503 135.63 66.5568 135.448 66.6875L134.459 66.5682L134.988 62.2727H139.522V63.2102H135.874L135.567 65.7841H135.618C135.797 65.642 136.022 65.5241 136.292 65.4304C136.561 65.3366 136.843 65.2898 137.135 65.2898C137.669 65.2898 138.145 65.4176 138.563 65.6733C138.983 65.9261 139.313 66.2727 139.551 66.7131C139.793 67.1534 139.914 67.6562 139.914 68.2216C139.914 68.7784 139.789 69.2756 139.539 69.7131C139.292 70.1477 138.951 70.4915 138.516 70.7443C138.081 70.9943 137.587 71.1193 137.033 71.1193ZM144.555 71.1193C143.993 71.1193 143.491 71.0227 143.051 70.8295C142.614 70.6364 142.266 70.3679 142.007 70.0241C141.751 69.6776 141.612 69.2756 141.589 68.8182H142.663C142.686 69.0994 142.783 69.3423 142.953 69.5469C143.124 69.7486 143.347 69.9048 143.622 70.0156C143.898 70.1264 144.203 70.1818 144.538 70.1818C144.913 70.1818 145.246 70.1165 145.536 69.9858C145.825 69.8551 146.053 69.6733 146.217 69.4403C146.382 69.2074 146.464 68.9375 146.464 68.6307C146.464 68.3097 146.385 68.027 146.226 67.7827C146.067 67.5355 145.834 67.3423 145.527 67.2031C145.22 67.0639 144.845 66.9943 144.402 66.9943H143.703V66.0568H144.402C144.749 66.0568 145.053 65.9943 145.314 65.8693C145.578 65.7443 145.784 65.5682 145.932 65.3409C146.082 65.1136 146.158 64.8466 146.158 64.5398C146.158 64.2443 146.092 63.9872 145.962 63.7685C145.831 63.5497 145.646 63.3793 145.408 63.2571C145.172 63.1349 144.893 63.0739 144.572 63.0739C144.271 63.0739 143.987 63.1293 143.72 63.2401C143.456 63.348 143.24 63.5057 143.072 63.7131C142.905 63.9176 142.814 64.1648 142.8 64.4545H141.777C141.794 63.9972 141.932 63.5966 142.19 63.2528C142.449 62.9062 142.787 62.6364 143.205 62.4432C143.625 62.25 144.087 62.1534 144.589 62.1534C145.129 62.1534 145.592 62.2628 145.979 62.4815C146.365 62.6974 146.662 62.983 146.869 63.3381C147.077 63.6932 147.18 64.0767 147.18 64.4886C147.18 64.9801 147.051 65.3991 146.793 65.7457C146.537 66.0923 146.189 66.3324 145.749 66.4659V66.5341C146.3 66.625 146.73 66.8594 147.04 67.2372C147.349 67.6122 147.504 68.0767 147.504 68.6307C147.504 69.1051 147.375 69.5312 147.116 69.9091C146.861 70.2841 146.511 70.5795 146.068 70.7955C145.625 71.0114 145.121 71.1193 144.555 71.1193ZM151.412 66.6364C151.412 67.7102 151.271 68.6989 150.99 69.6023C150.712 70.5028 150.313 71.3324 149.793 72.0909H148.906C149.111 71.8097 149.301 71.4631 149.477 71.0511C149.656 70.642 149.813 70.1932 149.946 69.7045C150.08 69.2131 150.183 68.706 150.257 68.1832C150.334 67.6577 150.372 67.142 150.372 66.6364C150.372 65.9602 150.307 65.2741 150.176 64.5781C150.045 63.8821 149.869 63.2358 149.648 62.6392C149.426 62.0426 149.179 61.5568 148.906 61.1818H149.793C150.313 61.9403 150.712 62.7713 150.99 63.6747C151.271 64.5753 151.412 65.5625 151.412 66.6364ZM154.345 69.8835C154.135 69.8835 153.954 69.8082 153.804 69.6577C153.653 69.5071 153.578 69.3267 153.578 69.1165C153.578 68.9062 153.653 68.7259 153.804 68.5753C153.954 68.4247 154.135 68.3494 154.345 68.3494C154.555 68.3494 154.735 68.4247 154.886 68.5753C155.037 68.7259 155.112 68.9062 155.112 69.1165C155.112 69.2557 155.076 69.3835 155.005 69.5C154.937 69.6165 154.845 69.7102 154.728 69.7812C154.615 69.8494 154.487 69.8835 154.345 69.8835ZM154.345 65.4688C154.135 65.4688 153.954 65.3935 153.804 65.2429C153.653 65.0923 153.578 64.9119 153.578 64.7017C153.578 64.4915 153.653 64.3111 153.804 64.1605C153.954 64.0099 154.135 63.9347 154.345 63.9347C154.555 63.9347 154.735 64.0099 154.886 64.1605C155.037 64.3111 155.112 64.4915 155.112 64.7017C155.112 64.8409 155.076 64.9688 155.005 65.0852C154.937 65.2017 154.845 65.2955 154.728 65.3665C154.615 65.4347 154.487 65.4688 154.345 65.4688ZM157.736 61.532V64.892C157.736 66.836 157.628 69.572 156.428 71.504C156.656 71.6 157.052 71.816 157.22 71.972C158.468 69.956 158.636 66.956 158.636 64.892V61.532H157.736ZM158.216 61.532V62.288H165.74V63.548H158.216V64.304H166.64V61.532H158.216ZM158.66 65.096V65.828H166.988V65.096H158.66ZM159.2 68.828V69.584H166.424V68.828H159.2ZM158.288 70.88V71.624H167.36V70.88H158.288ZM162.308 67.7V71.36H163.196V67.7H162.308ZM158.924 67.208L158.984 67.952C160.712 67.892 163.316 67.796 165.764 67.676L165.8 66.98C163.244 67.088 160.592 67.172 158.924 67.208ZM161.384 65.24C161.084 65.9 160.532 66.86 160.088 67.448L160.796 67.736C161.252 67.172 161.816 66.296 162.284 65.552L161.384 65.24ZM163.7 66.284C164.612 66.86 165.692 67.724 166.208 68.336L166.916 67.832C166.388 67.232 165.284 66.392 164.372 65.84L163.7 66.284ZM173.408 65.792C174.632 66.896 176.168 68.432 176.888 69.38L177.632 68.804C176.864 67.868 175.304 66.368 174.08 65.312L173.408 65.792ZM173.54 60.92V63.272C173.54 64.928 173.384 67.244 170.384 68.864C170.588 69.02 170.9 69.344 171.02 69.536C174.116 67.724 174.464 65.192 174.464 63.272V60.92H173.54ZM169.172 62.972V71.984H170.072V63.86H178.352V62.972H169.172ZM177.944 62.972V70.772C177.944 70.976 177.872 71.048 177.644 71.06C177.404 71.072 176.588 71.072 175.736 71.036C175.856 71.288 176 71.708 176.036 71.96C177.116 71.96 177.86 71.948 178.28 71.804C178.688 71.648 178.832 71.36 178.832 70.772V62.972H177.944ZM183.836 62.252V63.092H191.54V62.252H183.836ZM185.024 65.024H190.268V66.824H185.024V65.024ZM184.196 64.256V67.592H191.144V64.256H184.196ZM184.94 67.832L184.196 68.084C185.468 70.28 187.928 71.528 191.108 71.984C191.228 71.732 191.456 71.372 191.648 71.18C188.528 70.832 186.068 69.716 184.94 67.832ZM187.172 60.968V66.272C187.172 68.3 186.968 70.352 183.404 71.252C183.584 71.444 183.836 71.804 183.944 72.008C187.664 70.904 188.06 68.6 188.06 66.284V60.968H187.172ZM183.32 60.896C182.624 62.72 181.448 64.508 180.236 65.648C180.404 65.864 180.656 66.332 180.74 66.536C182.072 65.204 183.356 63.188 184.172 61.16L183.32 60.896ZM182.06 64.04V72.02H182.924V63.2L182.912 63.188L182.06 64.04ZM194.336 61.772V62.636H202.1V61.772H194.336ZM194.336 64.568V65.42H202.088V64.568H194.336ZM194.276 67.436V68.288H202.112V67.436H194.276ZM193.832 61.772V66.116C193.832 67.808 193.7 69.944 192.38 71.432C192.572 71.552 192.932 71.852 193.076 72.032C194.504 70.436 194.72 67.952 194.72 66.128V61.772H193.832ZM201.74 61.772V70.736C201.74 70.964 201.656 71.036 201.428 71.048C201.2 71.048 200.384 71.06 199.532 71.024C199.664 71.264 199.808 71.66 199.844 71.9C200.984 71.912 201.68 71.9 202.088 71.756C202.484 71.6 202.628 71.324 202.628 70.736V61.772H201.74ZM197.6 62.096V71.852H198.512V62.096H197.6ZM209.84 63.728V64.484H214.316V63.728H209.84ZM207.968 70.916L208.268 71.792C209.432 71.528 211.04 71.18 212.552 70.832L212.492 70.04C210.812 70.376 209.072 70.724 207.968 70.916ZM209.324 61.46V70.988H210.2V61.46H209.324ZM209.84 61.46V62.252H213.86V65.996H209.84V66.788H214.736V61.46H209.84ZM212.156 66.272L211.412 66.416C211.964 68.948 213.08 70.976 214.952 71.924C215.084 71.696 215.348 71.36 215.552 71.18C213.764 70.388 212.672 68.516 212.156 66.272ZM214.544 67.064C214.04 67.64 213.14 68.396 212.492 68.864L213.056 69.32C213.728 68.876 214.58 68.204 215.252 67.58L214.544 67.064ZM204.968 61.448V71.972H205.82V62.264H208.04V61.448H204.968ZM207.776 61.448V61.7C207.5 62.528 207.008 63.98 206.528 65.072C207.464 66.008 207.716 66.8 207.716 67.46C207.728 67.832 207.656 68.144 207.452 68.276C207.332 68.348 207.188 68.384 207.032 68.396C206.816 68.408 206.552 68.408 206.24 68.372C206.384 68.612 206.456 68.972 206.468 69.188C206.768 69.212 207.104 69.212 207.38 69.176C207.632 69.152 207.86 69.08 208.04 68.96C208.4 68.708 208.556 68.216 208.556 67.556C208.556 66.812 208.328 65.96 207.356 64.964C207.8 64.016 208.304 62.78 208.688 61.784L208.076 61.412L207.944 61.448H207.776ZM218.528 64.592V65.456H225.524V64.592H218.528ZM221.984 67.46V68.312H226.028V67.46H221.984ZM221.504 65.036V70.988L222.44 71.108V65.036H221.504ZM218.66 66.488C218.396 68.66 217.748 70.376 216.404 71.42C216.62 71.552 217.004 71.864 217.148 72.02C218.504 70.844 219.26 69.008 219.596 66.584L218.66 66.488ZM219.224 68.036L218.492 68.312C219.524 71.24 221.48 71.804 224.336 71.804H227.156C227.192 71.54 227.348 71.108 227.492 70.892C226.904 70.904 224.828 70.904 224.384 70.904C221.948 70.904 220.076 70.484 219.224 68.036ZM221.492 60.932V62.876H222.44V60.932H221.492ZM216.98 62.3V64.916H217.868V63.164H226.088V64.916H227.012V62.3H216.98Z"
            fill="#6B6D76"
          />
          <Logo5GHZ />
        </svg>
      );
    default:
      return;
  }
};

export const ComplianceImageTR5: FC<ComplianceImageProps> = ({ model }) => {
  const LogoTelecom = () => (
    <svg>
      <path
        d="M26.5118 62.0198C26.3395 61.9796 26.1587 62.0074 26.0055 62.0976C25.8522 62.1878 25.7378 62.3338 25.6851 62.5065C25.0034 64.0902 23.9182 65.4571 22.5433 66.4639C20.6422 67.8376 18.3329 68.4898 16.0128 68.3082C13.6927 68.1267 11.507 67.1228 9.83183 65.4693C8.79388 64.4303 7.98134 63.1791 7.44716 61.7972C6.91297 60.4152 6.66911 58.9336 6.73146 57.4488C6.73146 57.0467 6.87614 56.8562 7.26885 56.7716C8.28164 56.56 9.33577 56.2848 10.2659 56.0521L16.0119 54.6342V57.9355L28 55.0151C28 54.8881 28 54.8035 28 54.7188C27.4582 52.7128 26.4082 50.8889 24.9563 49.4321C23.5044 47.9753 21.7022 46.9373 19.7323 46.4232C19.0101 46.2414 18.2787 46.1001 17.5414 46H15.7639H15.5158C13.3526 46.1792 11.2957 47.0363 9.62514 48.4548C7.89967 49.7438 6.56769 51.5085 5.78453 53.543C5.00137 55.5776 4.79932 57.7982 5.20194 59.9459C5.63273 62.7335 7.01606 65.2741 9.10551 67.115C11.195 68.9558 13.8548 69.9775 16.6113 69.998C18.3488 70.0312 20.0706 69.6554 21.6438 68.8996C23.217 68.1438 24.5996 67.0281 25.6851 65.6385C26.5772 64.5745 27.2771 63.3563 27.752 62.041C27.3385 62.0574 26.9245 62.0503 26.5118 62.0198V62.0198ZM15.6192 47.82C17.7239 47.5796 19.8484 48.0381 21.6794 49.1279C23.5103 50.2176 24.9508 51.8808 25.7884 53.8723L17.5207 55.9886V52.6449L7.18618 55.1421C7.70575 53.1927 8.78937 51.45 10.2945 50.1431C11.7997 48.8362 13.656 48.0263 15.6192 47.82V47.82ZM22.9567 62.6335C22.936 63.0565 22.936 63.4803 22.9567 63.9032H18.4302C18.0375 63.9032 17.9135 64.0302 17.9341 64.4323C17.9341 65.1518 17.9341 65.8925 17.9341 66.5485C17.9341 67.2046 17.8101 67.1622 17.4174 67.1622H16.0119C15.6605 67.1622 15.5778 67.0141 15.5778 66.6755C15.5778 65.7867 15.5778 64.8979 15.5778 63.9456H10.5966V62.0833H10.9893H22.2953C22.812 61.9986 23.0187 62.1468 22.9567 62.697V62.6335ZM22.9567 60.7078H10.5552V58.8878H22.9567V60.7078Z"
        fill="#6B6D76"
      />
    </svg>
  );
  const LogoT = () => (
    <svg>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M51 43.5H39V55.5H51V43.5ZM39 42.5H38V43.5V55.5V56.5H39H51H52V55.5V43.5V42.5H51H39Z"
        fill="#5A5C61"
      />
      <mask id="path-32-inside-1_4045_58133" fill="white">
        <path d="M42 46.3594V45.5H48V46.3594H45.4844V53.5H44.5156V46.3594H42Z" />
      </mask>
      <path
        d="M42 46.3594H41V47.3594H42V46.3594ZM42 45.5V44.5H41V45.5H42ZM48 45.5H49V44.5H48V45.5ZM48 46.3594V47.3594H49V46.3594H48ZM45.4844 46.3594V45.3594H44.4844V46.3594H45.4844ZM45.4844 53.5V54.5H46.4844V53.5H45.4844ZM44.5156 53.5H43.5156V54.5H44.5156V53.5ZM44.5156 46.3594H45.5156V45.3594H44.5156V46.3594ZM43 46.3594V45.5H41V46.3594H43ZM42 46.5H48V44.5H42V46.5ZM47 45.5V46.3594H49V45.5H47ZM48 45.3594H45.4844V47.3594H48V45.3594ZM44.4844 46.3594V53.5H46.4844V46.3594H44.4844ZM45.4844 52.5H44.5156V54.5H45.4844V52.5ZM45.5156 53.5V46.3594H43.5156V53.5H45.5156ZM44.5156 45.3594H42V47.3594H44.5156V45.3594Z"
        fill="#5A5C61"
        mask="url(#path-32-inside-1_4045_58133)"
      />
    </svg>
  );

  const LogoR = () => (
    <svg>
      <rect x="38.5" y="60" width="13" height="13" stroke="#5A5C61" />
      <path
        d="M42.0568 71V62.2727H45.0057C45.6875 62.2727 46.2472 62.3892 46.6847 62.6222C47.1222 62.8523 47.446 63.169 47.6562 63.5724C47.8665 63.9759 47.9716 64.4347 47.9716 64.9489C47.9716 65.4631 47.8665 65.919 47.6562 66.3168C47.446 66.7145 47.1236 67.027 46.6889 67.2543C46.2543 67.4787 45.6989 67.5909 45.0227 67.5909H42.6364V66.6364H44.9886C45.4545 66.6364 45.8295 66.5682 46.1136 66.4318C46.4006 66.2955 46.608 66.1023 46.7358 65.8523C46.8665 65.5994 46.9318 65.2983 46.9318 64.9489C46.9318 64.5994 46.8665 64.294 46.7358 64.0327C46.6051 63.7713 46.3963 63.5696 46.1094 63.4276C45.8224 63.2827 45.4432 63.2102 44.9716 63.2102H43.1136V71H42.0568ZM46.1648 67.0795L48.3125 71H47.0852L44.9716 67.0795H46.1648Z"
        fill="#5A5C61"
      />
    </svg>
  );

  const Logo5GHZ = () => (
    <svg>
      <path
        d="M41.6307 88.1193C41.1307 88.1193 40.6804 88.0199 40.2798 87.821C39.8793 87.6222 39.5582 87.3494 39.3168 87.0028C39.0753 86.6562 38.9432 86.2614 38.9205 85.8182H39.9432C39.983 86.2131 40.1619 86.5398 40.4801 86.7983C40.8011 87.054 41.1847 87.1818 41.6307 87.1818C41.9886 87.1818 42.3068 87.098 42.5852 86.9304C42.8665 86.7628 43.0866 86.5327 43.2457 86.2401C43.4077 85.9446 43.4886 85.6108 43.4886 85.2386C43.4886 84.858 43.4048 84.5185 43.2372 84.2202C43.0724 83.919 42.8452 83.6818 42.5554 83.5085C42.2656 83.3352 41.9347 83.2472 41.5625 83.2443C41.2955 83.2415 41.0213 83.2827 40.7401 83.3679C40.4588 83.4503 40.2273 83.5568 40.0455 83.6875L39.0568 83.5682L39.5852 79.2727H44.1193V80.2102H40.4716L40.1648 82.7841H40.2159C40.3949 82.642 40.6193 82.5241 40.8892 82.4304C41.1591 82.3366 41.4403 82.2898 41.733 82.2898C42.267 82.2898 42.7429 82.4176 43.1605 82.6733C43.581 82.9261 43.9105 83.2727 44.1491 83.7131C44.3906 84.1534 44.5114 84.6562 44.5114 85.2216C44.5114 85.7784 44.3864 86.2756 44.1364 86.7131C43.8892 87.1477 43.5483 87.4915 43.1136 87.7443C42.679 87.9943 42.1847 88.1193 41.6307 88.1193ZM52.3235 82C52.2298 81.7131 52.1062 81.456 51.9528 81.2287C51.8022 80.9986 51.6218 80.8026 51.4116 80.6406C51.2042 80.4787 50.9684 80.3551 50.7042 80.2699C50.44 80.1847 50.1502 80.142 49.8349 80.142C49.3178 80.142 48.8477 80.2756 48.4244 80.5426C48.0011 80.8097 47.6644 81.2031 47.4144 81.723C47.1644 82.2429 47.0394 82.8807 47.0394 83.6364C47.0394 84.392 47.1658 85.0298 47.4187 85.5497C47.6715 86.0696 48.0138 86.4631 48.4457 86.7301C48.8775 86.9972 49.3633 87.1307 49.9031 87.1307C50.4031 87.1307 50.8434 87.0241 51.2241 86.8111C51.6076 86.5952 51.9059 86.2912 52.119 85.8991C52.3349 85.5043 52.4428 85.0398 52.4428 84.5057L52.7667 84.5739H50.1417V83.6364H53.4656V84.5739C53.4656 85.2926 53.3121 85.9176 53.0053 86.4489C52.7013 86.9801 52.2809 87.392 51.744 87.6847C51.2099 87.9744 50.5962 88.1193 49.9031 88.1193C49.1303 88.1193 48.4513 87.9375 47.8661 87.5739C47.2837 87.2102 46.8292 86.6932 46.5025 86.0227C46.1786 85.3523 46.0167 84.5568 46.0167 83.6364C46.0167 82.946 46.109 82.3253 46.2937 81.7741C46.4812 81.2202 46.7454 80.7486 47.0863 80.3594C47.4272 79.9702 47.8306 79.6719 48.2965 79.4645C48.7624 79.2571 49.2752 79.1534 49.8349 79.1534C50.2951 79.1534 50.7241 79.223 51.1218 79.3622C51.5224 79.4986 51.8789 79.6932 52.1914 79.946C52.5067 80.196 52.7695 80.4957 52.9798 80.8452C53.19 81.1918 53.3349 81.5767 53.4144 82H52.3235ZM55.2756 88V79.2727H56.3324V83.1591H60.9858V79.2727H62.0426V88H60.9858V84.0966H56.3324V88H55.2756ZM63.8345 88V87.233L67.5504 82.4602V82.392H63.9538V81.4545H68.8459V82.2557L65.2322 86.9943V87.0625H68.9652V88H63.8345ZM75.1018 83.284V88.96H75.9898V83.284H75.1018ZM75.1138 77.932V81.448H76.0018V77.932H75.1138ZM71.8858 84.628V88.072H72.7498V85.372H78.9178V84.628H71.8858ZM78.5698 84.628V87.124C78.5698 87.256 78.5338 87.304 78.3658 87.316C78.1978 87.316 77.6338 87.328 76.9858 87.304C77.1178 87.52 77.2378 87.832 77.2858 88.072C78.1258 88.072 78.6778 88.072 79.0258 87.94C79.3738 87.808 79.4578 87.58 79.4578 87.136V84.628H78.5698ZM70.5298 82.624V85H71.3698V83.368H79.7938V85H80.6698V82.624H70.5298ZM72.1738 77.992V81.88H79.0378V77.992H78.1498V81.148H73.0378V77.992H72.1738ZM70.2058 79.192V79.948H80.9938V79.192H70.2058ZM86.2472 83.6364C86.2472 82.5625 86.3864 81.5753 86.6648 80.6747C86.946 79.7713 87.3466 78.9403 87.8665 78.1818H88.7528C88.5483 78.4631 88.3565 78.8097 88.1776 79.2216C88.0014 79.6307 87.8466 80.081 87.7131 80.5724C87.5795 81.0611 87.4744 81.5668 87.3977 82.0895C87.3239 82.6122 87.2869 83.1278 87.2869 83.6364C87.2869 84.3125 87.3523 84.9986 87.483 85.6946C87.6136 86.3906 87.7898 87.0369 88.0114 87.6335C88.233 88.2301 88.4801 88.7159 88.7528 89.0909H87.8665C87.3466 88.3324 86.946 87.5028 86.6648 86.6023C86.3864 85.6989 86.2472 84.7102 86.2472 83.6364ZM91.9585 88L89.5721 79.2727H90.646L92.4698 86.3807H92.555L94.413 79.2727H95.6062L97.4641 86.3807H97.5494L99.3732 79.2727H100.447L98.0607 88H96.9698L95.0437 81.0455H94.9755L93.0494 88H91.9585ZM104.338 88.1193C103.838 88.1193 103.387 88.0199 102.987 87.821C102.586 87.6222 102.265 87.3494 102.024 87.0028C101.782 86.6562 101.65 86.2614 101.627 85.8182H102.65C102.69 86.2131 102.869 86.5398 103.187 86.7983C103.508 87.054 103.892 87.1818 104.338 87.1818C104.696 87.1818 105.014 87.098 105.292 86.9304C105.574 86.7628 105.794 86.5327 105.953 86.2401C106.115 85.9446 106.196 85.6108 106.196 85.2386C106.196 84.858 106.112 84.5185 105.944 84.2202C105.779 83.919 105.552 83.6818 105.262 83.5085C104.973 83.3352 104.642 83.2472 104.27 83.2443C104.002 83.2415 103.728 83.2827 103.447 83.3679C103.166 83.4503 102.934 83.5568 102.752 83.6875L101.764 83.5682L102.292 79.2727H106.826V80.2102H103.179L102.872 82.7841H102.923C103.102 82.642 103.326 82.5241 103.596 82.4304C103.866 82.3366 104.147 82.2898 104.44 82.2898C104.974 82.2898 105.45 82.4176 105.868 82.6733C106.288 82.9261 106.618 83.2727 106.856 83.7131C107.098 84.1534 107.218 84.6562 107.218 85.2216C107.218 85.7784 107.093 86.2756 106.843 86.7131C106.596 87.1477 106.255 87.4915 105.821 87.7443C105.386 87.9943 104.892 88.1193 104.338 88.1193ZM108.911 88V87.233L111.792 84.0795C112.13 83.7102 112.408 83.3892 112.627 83.1165C112.846 82.8409 113.008 82.5824 113.113 82.3409C113.221 82.0966 113.275 81.8409 113.275 81.5739C113.275 81.267 113.201 81.0014 113.053 80.777C112.908 80.5526 112.71 80.3793 112.457 80.2571C112.204 80.1349 111.92 80.0739 111.604 80.0739C111.269 80.0739 110.977 80.1435 110.727 80.2827C110.479 80.419 110.288 80.6108 110.151 80.858C110.018 81.1051 109.951 81.3949 109.951 81.7273H108.945C108.945 81.2159 109.063 80.767 109.299 80.3807C109.535 79.9943 109.856 79.6932 110.262 79.4773C110.671 79.2614 111.13 79.1534 111.638 79.1534C112.15 79.1534 112.603 79.2614 112.998 79.4773C113.393 79.6932 113.702 79.9844 113.927 80.3509C114.151 80.7173 114.263 81.125 114.263 81.5739C114.263 81.8949 114.205 82.2088 114.089 82.5156C113.975 82.8196 113.776 83.1591 113.492 83.5341C113.211 83.9062 112.82 84.3608 112.32 84.8977L110.36 86.9943V87.0625H114.417V88H108.911ZM117.694 86.8068L117.626 87.267C117.577 87.5909 117.504 87.9375 117.404 88.3068C117.308 88.6761 117.207 89.0241 117.102 89.3509C116.996 89.6776 116.91 89.9375 116.842 90.1307H116.075C116.112 89.9489 116.16 89.7088 116.219 89.4105C116.279 89.1122 116.339 88.7784 116.398 88.4091C116.461 88.0426 116.512 87.6676 116.552 87.2841L116.603 86.8068H117.694ZM124.654 88L122.267 79.2727H123.341L125.165 86.3807H125.25L127.108 79.2727H128.301L130.159 86.3807H130.245L132.069 79.2727H133.142L130.756 88H129.665L127.739 81.0455H127.671L125.745 88H124.654ZM137.033 88.1193C136.533 88.1193 136.083 88.0199 135.682 87.821C135.282 87.6222 134.961 87.3494 134.719 87.0028C134.478 86.6562 134.346 86.2614 134.323 85.8182H135.346C135.385 86.2131 135.564 86.5398 135.882 86.7983C136.203 87.054 136.587 87.1818 137.033 87.1818C137.391 87.1818 137.709 87.098 137.988 86.9304C138.269 86.7628 138.489 86.5327 138.648 86.2401C138.81 85.9446 138.891 85.6108 138.891 85.2386C138.891 84.858 138.807 84.5185 138.64 84.2202C138.475 83.919 138.248 83.6818 137.958 83.5085C137.668 83.3352 137.337 83.2472 136.965 83.2443C136.698 83.2415 136.424 83.2827 136.142 83.3679C135.861 83.4503 135.63 83.5568 135.448 83.6875L134.459 83.5682L134.988 79.2727H139.522V80.2102H135.874L135.567 82.7841H135.618C135.797 82.642 136.022 82.5241 136.292 82.4304C136.561 82.3366 136.843 82.2898 137.135 82.2898C137.669 82.2898 138.145 82.4176 138.563 82.6733C138.983 82.9261 139.313 83.2727 139.551 83.7131C139.793 84.1534 139.914 84.6562 139.914 85.2216C139.914 85.7784 139.789 86.2756 139.539 86.7131C139.292 87.1477 138.951 87.4915 138.516 87.7443C138.081 87.9943 137.587 88.1193 137.033 88.1193ZM144.555 88.1193C143.993 88.1193 143.491 88.0227 143.051 87.8295C142.614 87.6364 142.266 87.3679 142.007 87.0241C141.751 86.6776 141.612 86.2756 141.589 85.8182H142.663C142.686 86.0994 142.783 86.3423 142.953 86.5469C143.124 86.7486 143.347 86.9048 143.622 87.0156C143.898 87.1264 144.203 87.1818 144.538 87.1818C144.913 87.1818 145.246 87.1165 145.536 86.9858C145.825 86.8551 146.053 86.6733 146.217 86.4403C146.382 86.2074 146.464 85.9375 146.464 85.6307C146.464 85.3097 146.385 85.027 146.226 84.7827C146.067 84.5355 145.834 84.3423 145.527 84.2031C145.22 84.0639 144.845 83.9943 144.402 83.9943H143.703V83.0568H144.402C144.749 83.0568 145.053 82.9943 145.314 82.8693C145.578 82.7443 145.784 82.5682 145.932 82.3409C146.082 82.1136 146.158 81.8466 146.158 81.5398C146.158 81.2443 146.092 80.9872 145.962 80.7685C145.831 80.5497 145.646 80.3793 145.408 80.2571C145.172 80.1349 144.893 80.0739 144.572 80.0739C144.271 80.0739 143.987 80.1293 143.72 80.2401C143.456 80.348 143.24 80.5057 143.072 80.7131C142.905 80.9176 142.814 81.1648 142.8 81.4545H141.777C141.794 80.9972 141.932 80.5966 142.19 80.2528C142.449 79.9062 142.787 79.6364 143.205 79.4432C143.625 79.25 144.087 79.1534 144.589 79.1534C145.129 79.1534 145.592 79.2628 145.979 79.4815C146.365 79.6974 146.662 79.983 146.869 80.3381C147.077 80.6932 147.18 81.0767 147.18 81.4886C147.18 81.9801 147.051 82.3991 146.793 82.7457C146.537 83.0923 146.189 83.3324 145.749 83.4659V83.5341C146.3 83.625 146.73 83.8594 147.04 84.2372C147.349 84.6122 147.504 85.0767 147.504 85.6307C147.504 86.1051 147.375 86.5312 147.116 86.9091C146.861 87.2841 146.511 87.5795 146.068 87.7955C145.625 88.0114 145.121 88.1193 144.555 88.1193ZM151.412 83.6364C151.412 84.7102 151.271 85.6989 150.99 86.6023C150.712 87.5028 150.313 88.3324 149.793 89.0909H148.906C149.111 88.8097 149.301 88.4631 149.477 88.0511C149.656 87.642 149.813 87.1932 149.946 86.7045C150.08 86.2131 150.183 85.706 150.257 85.1832C150.334 84.6577 150.372 84.142 150.372 83.6364C150.372 82.9602 150.307 82.2741 150.176 81.5781C150.045 80.8821 149.869 80.2358 149.648 79.6392C149.426 79.0426 149.179 78.5568 148.906 78.1818H149.793C150.313 78.9403 150.712 79.7713 150.99 80.6747C151.271 81.5753 151.412 82.5625 151.412 83.6364ZM154.345 86.8835C154.135 86.8835 153.954 86.8082 153.804 86.6577C153.653 86.5071 153.578 86.3267 153.578 86.1165C153.578 85.9062 153.653 85.7259 153.804 85.5753C153.954 85.4247 154.135 85.3494 154.345 85.3494C154.555 85.3494 154.735 85.4247 154.886 85.5753C155.037 85.7259 155.112 85.9062 155.112 86.1165C155.112 86.2557 155.076 86.3835 155.005 86.5C154.937 86.6165 154.845 86.7102 154.728 86.7812C154.615 86.8494 154.487 86.8835 154.345 86.8835ZM154.345 82.4688C154.135 82.4688 153.954 82.3935 153.804 82.2429C153.653 82.0923 153.578 81.9119 153.578 81.7017C153.578 81.4915 153.653 81.3111 153.804 81.1605C153.954 81.0099 154.135 80.9347 154.345 80.9347C154.555 80.9347 154.735 81.0099 154.886 81.1605C155.037 81.3111 155.112 81.4915 155.112 81.7017C155.112 81.8409 155.076 81.9688 155.005 82.0852C154.937 82.2017 154.845 82.2955 154.728 82.3665C154.615 82.4347 154.487 82.4688 154.345 82.4688ZM157.736 78.532V81.892C157.736 83.836 157.628 86.572 156.428 88.504C156.656 88.6 157.052 88.816 157.22 88.972C158.468 86.956 158.636 83.956 158.636 81.892V78.532H157.736ZM158.216 78.532V79.288H165.74V80.548H158.216V81.304H166.64V78.532H158.216ZM158.66 82.096V82.828H166.988V82.096H158.66ZM159.2 85.828V86.584H166.424V85.828H159.2ZM158.288 87.88V88.624H167.36V87.88H158.288ZM162.308 84.7V88.36H163.196V84.7H162.308ZM158.924 84.208L158.984 84.952C160.712 84.892 163.316 84.796 165.764 84.676L165.8 83.98C163.244 84.088 160.592 84.172 158.924 84.208ZM161.384 82.24C161.084 82.9 160.532 83.86 160.088 84.448L160.796 84.736C161.252 84.172 161.816 83.296 162.284 82.552L161.384 82.24ZM163.7 83.284C164.612 83.86 165.692 84.724 166.208 85.336L166.916 84.832C166.388 84.232 165.284 83.392 164.372 82.84L163.7 83.284ZM173.408 82.792C174.632 83.896 176.168 85.432 176.888 86.38L177.632 85.804C176.864 84.868 175.304 83.368 174.08 82.312L173.408 82.792ZM173.54 77.92V80.272C173.54 81.928 173.384 84.244 170.384 85.864C170.588 86.02 170.9 86.344 171.02 86.536C174.116 84.724 174.464 82.192 174.464 80.272V77.92H173.54ZM169.172 79.972V88.984H170.072V80.86H178.352V79.972H169.172ZM177.944 79.972V87.772C177.944 87.976 177.872 88.048 177.644 88.06C177.404 88.072 176.588 88.072 175.736 88.036C175.856 88.288 176 88.708 176.036 88.96C177.116 88.96 177.86 88.948 178.28 88.804C178.688 88.648 178.832 88.36 178.832 87.772V79.972H177.944ZM183.836 79.252V80.092H191.54V79.252H183.836ZM185.024 82.024H190.268V83.824H185.024V82.024ZM184.196 81.256V84.592H191.144V81.256H184.196ZM184.94 84.832L184.196 85.084C185.468 87.28 187.928 88.528 191.108 88.984C191.228 88.732 191.456 88.372 191.648 88.18C188.528 87.832 186.068 86.716 184.94 84.832ZM187.172 77.968V83.272C187.172 85.3 186.968 87.352 183.404 88.252C183.584 88.444 183.836 88.804 183.944 89.008C187.664 87.904 188.06 85.6 188.06 83.284V77.968H187.172ZM183.32 77.896C182.624 79.72 181.448 81.508 180.236 82.648C180.404 82.864 180.656 83.332 180.74 83.536C182.072 82.204 183.356 80.188 184.172 78.16L183.32 77.896ZM182.06 81.04V89.02H182.924V80.2L182.912 80.188L182.06 81.04ZM194.336 78.772V79.636H202.1V78.772H194.336ZM194.336 81.568V82.42H202.088V81.568H194.336ZM194.276 84.436V85.288H202.112V84.436H194.276ZM193.832 78.772V83.116C193.832 84.808 193.7 86.944 192.38 88.432C192.572 88.552 192.932 88.852 193.076 89.032C194.504 87.436 194.72 84.952 194.72 83.128V78.772H193.832ZM201.74 78.772V87.736C201.74 87.964 201.656 88.036 201.428 88.048C201.2 88.048 200.384 88.06 199.532 88.024C199.664 88.264 199.808 88.66 199.844 88.9C200.984 88.912 201.68 88.9 202.088 88.756C202.484 88.6 202.628 88.324 202.628 87.736V78.772H201.74ZM197.6 79.096V88.852H198.512V79.096H197.6ZM209.84 80.728V81.484H214.316V80.728H209.84ZM207.968 87.916L208.268 88.792C209.432 88.528 211.04 88.18 212.552 87.832L212.492 87.04C210.812 87.376 209.072 87.724 207.968 87.916ZM209.324 78.46V87.988H210.2V78.46H209.324ZM209.84 78.46V79.252H213.86V82.996H209.84V83.788H214.736V78.46H209.84ZM212.156 83.272L211.412 83.416C211.964 85.948 213.08 87.976 214.952 88.924C215.084 88.696 215.348 88.36 215.552 88.18C213.764 87.388 212.672 85.516 212.156 83.272ZM214.544 84.064C214.04 84.64 213.14 85.396 212.492 85.864L213.056 86.32C213.728 85.876 214.58 85.204 215.252 84.58L214.544 84.064ZM204.968 78.448V88.972H205.82V79.264H208.04V78.448H204.968ZM207.776 78.448V78.7C207.5 79.528 207.008 80.98 206.528 82.072C207.464 83.008 207.716 83.8 207.716 84.46C207.728 84.832 207.656 85.144 207.452 85.276C207.332 85.348 207.188 85.384 207.032 85.396C206.816 85.408 206.552 85.408 206.24 85.372C206.384 85.612 206.456 85.972 206.468 86.188C206.768 86.212 207.104 86.212 207.38 86.176C207.632 86.152 207.86 86.08 208.04 85.96C208.4 85.708 208.556 85.216 208.556 84.556C208.556 83.812 208.328 82.96 207.356 81.964C207.8 81.016 208.304 79.78 208.688 78.784L208.076 78.412L207.944 78.448H207.776ZM218.528 81.592V82.456H225.524V81.592H218.528ZM221.984 84.46V85.312H226.028V84.46H221.984ZM221.504 82.036V87.988L222.44 88.108V82.036H221.504ZM218.66 83.488C218.396 85.66 217.748 87.376 216.404 88.42C216.62 88.552 217.004 88.864 217.148 89.02C218.504 87.844 219.26 86.008 219.596 83.584L218.66 83.488ZM219.224 85.036L218.492 85.312C219.524 88.24 221.48 88.804 224.336 88.804H227.156C227.192 88.54 227.348 88.108 227.492 87.892C226.904 87.904 224.828 87.904 224.384 87.904C221.948 87.904 220.076 87.484 219.224 85.036ZM221.492 77.932V79.876H222.44V77.932H221.492ZM216.98 79.3V81.916H217.868V80.164H226.088V81.916H227.012V79.3H216.98Z"
        fill="#6B6D76"
      />
    </svg>
  );

  switch (model) {
    case DeviceModel.U7PG2:
      return (
        <svg width="260" height="105" viewBox="0 0 260 105" fill="none" xmlns="http://www.w3.org/2000/svg">
          <ComplianceImage />
          <LogoTelecom />
          <LogoT />
          <path
            d="M62.75 54H60.0568V45.2727H62.8693C63.7159 45.2727 64.4403 45.4474 65.0426 45.7969C65.6449 46.1435 66.1065 46.642 66.4276 47.2926C66.7486 47.9403 66.9091 48.7159 66.9091 49.6193C66.9091 50.5284 66.7472 51.3111 66.4233 51.9673C66.0994 52.6207 65.6278 53.1236 65.0085 53.4759C64.3892 53.8253 63.6364 54 62.75 54ZM61.1136 53.0625H62.6818C63.4034 53.0625 64.0014 52.9233 64.4759 52.6449C64.9503 52.3665 65.304 51.9702 65.5369 51.456C65.7699 50.9418 65.8864 50.3295 65.8864 49.6193C65.8864 48.9148 65.7713 48.3082 65.5412 47.7997C65.3111 47.2884 64.9673 46.8963 64.5099 46.6236C64.0526 46.348 63.483 46.2102 62.8011 46.2102H61.1136V53.0625ZM74.9716 45.2727V54H73.9148V46.3807H73.8636L71.733 47.7955V46.7216L73.9148 45.2727H74.9716ZM80.3793 54.1193C80.0213 54.1136 79.6634 54.0455 79.3054 53.9148C78.9474 53.7841 78.6207 53.5639 78.3253 53.2543C78.0298 52.9418 77.7926 52.5199 77.6136 51.9886C77.4347 51.4545 77.3452 50.7841 77.3452 49.9773C77.3452 49.2045 77.4176 48.5199 77.5625 47.9233C77.7074 47.3239 77.9176 46.8196 78.1932 46.4105C78.4688 45.9986 78.8011 45.6861 79.1903 45.473C79.5824 45.2599 80.0241 45.1534 80.5156 45.1534C81.0043 45.1534 81.4389 45.2514 81.8196 45.4474C82.2031 45.6406 82.5156 45.9105 82.7571 46.2571C82.9986 46.6037 83.1548 47.0028 83.2259 47.4545H82.1861C82.0895 47.0625 81.902 46.7372 81.6236 46.4787C81.3452 46.2202 80.9759 46.0909 80.5156 46.0909C79.8395 46.0909 79.3068 46.3849 78.9176 46.973C78.5313 47.5611 78.3366 48.3864 78.3338 49.4489H78.402C78.5611 49.2074 78.75 49.0014 78.9688 48.831C79.1903 48.6577 79.4347 48.5241 79.7017 48.4304C79.9688 48.3366 80.2514 48.2898 80.5497 48.2898C81.0497 48.2898 81.5071 48.4148 81.9219 48.6648C82.3366 48.9119 82.669 49.2543 82.919 49.6918C83.169 50.1264 83.294 50.625 83.294 51.1875C83.294 51.7273 83.1733 52.2216 82.9318 52.6705C82.6903 53.1165 82.3509 53.4716 81.9134 53.7358C81.4787 53.9972 80.9673 54.125 80.3793 54.1193ZM80.3793 53.1818C80.7372 53.1818 81.0582 53.0923 81.3423 52.9134C81.6293 52.7344 81.8551 52.4943 82.0199 52.1932C82.1875 51.892 82.2713 51.5568 82.2713 51.1875C82.2713 50.8267 82.1903 50.4986 82.0284 50.2031C81.8693 49.9048 81.6491 49.6676 81.3679 49.4915C81.0895 49.3153 80.7713 49.2273 80.4134 49.2273C80.1435 49.2273 79.892 49.2812 79.6591 49.3892C79.4261 49.4943 79.2216 49.6392 79.0455 49.8239C78.8722 50.0085 78.7358 50.2202 78.6364 50.4588C78.5369 50.6946 78.4872 50.9432 78.4872 51.2045C78.4872 51.5511 78.5682 51.875 78.7301 52.1761C78.8949 52.4773 79.1193 52.7202 79.4034 52.9048C79.6903 53.0895 80.0156 53.1818 80.3793 53.1818ZM88.7369 49.1676V50.1051H84.9187V49.1676H88.7369ZM93.3359 54.1193C92.6939 54.1193 92.147 53.9446 91.6953 53.5952C91.2436 53.2429 90.8984 52.733 90.6598 52.0653C90.4212 51.3949 90.3018 50.5852 90.3018 49.6364C90.3018 48.6932 90.4212 47.8878 90.6598 47.2202C90.9013 46.5497 91.2479 46.0384 91.6996 45.6861C92.1541 45.331 92.6996 45.1534 93.3359 45.1534C93.9723 45.1534 94.5163 45.331 94.968 45.6861C95.4226 46.0384 95.7692 46.5497 96.0078 47.2202C96.2493 47.8878 96.37 48.6932 96.37 49.6364C96.37 50.5852 96.2507 51.3949 96.0121 52.0653C95.7734 52.733 95.4283 53.2429 94.9766 53.5952C94.5249 53.9446 93.978 54.1193 93.3359 54.1193ZM93.3359 53.1818C93.9723 53.1818 94.4666 52.875 94.8189 52.2614C95.1712 51.6477 95.3473 50.7727 95.3473 49.6364C95.3473 48.8807 95.2663 48.2372 95.1044 47.706C94.9453 47.1747 94.7152 46.7699 94.4141 46.4915C94.1158 46.2131 93.7564 46.0739 93.3359 46.0739C92.7053 46.0739 92.2124 46.3849 91.8572 47.0071C91.5021 47.6264 91.3246 48.5028 91.3246 49.6364C91.3246 50.392 91.4041 51.0341 91.5632 51.5625C91.7223 52.0909 91.951 52.4929 92.2493 52.7685C92.5504 53.044 92.9126 53.1818 93.3359 53.1818ZM100.836 54.1193C100.194 54.1193 99.647 53.9446 99.1953 53.5952C98.7436 53.2429 98.3984 52.733 98.1598 52.0653C97.9212 51.3949 97.8018 50.5852 97.8018 49.6364C97.8018 48.6932 97.9212 47.8878 98.1598 47.2202C98.4013 46.5497 98.7479 46.0384 99.1996 45.6861C99.6541 45.331 100.2 45.1534 100.836 45.1534C101.472 45.1534 102.016 45.331 102.468 45.6861C102.923 46.0384 103.269 46.5497 103.508 47.2202C103.749 47.8878 103.87 48.6932 103.87 49.6364C103.87 50.5852 103.751 51.3949 103.512 52.0653C103.273 52.733 102.928 53.2429 102.477 53.5952C102.025 53.9446 101.478 54.1193 100.836 54.1193ZM100.836 53.1818C101.472 53.1818 101.967 52.875 102.319 52.2614C102.671 51.6477 102.847 50.7727 102.847 49.6364C102.847 48.8807 102.766 48.2372 102.604 47.706C102.445 47.1747 102.215 46.7699 101.914 46.4915C101.616 46.2131 101.256 46.0739 100.836 46.0739C100.205 46.0739 99.7124 46.3849 99.3572 47.0071C99.0021 47.6264 98.8246 48.5028 98.8246 49.6364C98.8246 50.392 98.9041 51.0341 99.0632 51.5625C99.2223 52.0909 99.451 52.4929 99.7493 52.7685C100.05 53.044 100.413 53.1818 100.836 53.1818ZM108.558 45.2727V54H107.501V46.3807H107.45L105.319 47.7955V46.7216L107.501 45.2727H108.558ZM113.863 54.1193C113.278 54.1193 112.761 54.0156 112.312 53.8082C111.866 53.598 111.518 53.3097 111.268 52.9432C111.018 52.5739 110.894 52.1534 110.897 51.6818C110.894 51.3125 110.967 50.9716 111.114 50.6591C111.262 50.3437 111.464 50.081 111.719 49.8707C111.978 49.6577 112.266 49.5227 112.585 49.4659V49.4148C112.167 49.3068 111.835 49.0724 111.587 48.7116C111.34 48.348 111.218 47.9347 111.221 47.4716C111.218 47.0284 111.33 46.6321 111.558 46.2827C111.785 45.9332 112.097 45.6577 112.495 45.456C112.896 45.2543 113.352 45.1534 113.863 45.1534C114.369 45.1534 114.82 45.2543 115.218 45.456C115.616 45.6577 115.928 45.9332 116.156 46.2827C116.386 46.6321 116.502 47.0284 116.505 47.4716C116.502 47.9347 116.376 48.348 116.126 48.7116C115.879 49.0724 115.55 49.3068 115.141 49.4148V49.4659C115.457 49.5227 115.741 49.6577 115.994 49.8707C116.246 50.081 116.448 50.3437 116.599 50.6591C116.749 50.9716 116.826 51.3125 116.829 51.6818C116.826 52.1534 116.698 52.5739 116.445 52.9432C116.195 53.3097 115.847 53.598 115.401 53.8082C114.958 54.0156 114.445 54.1193 113.863 54.1193ZM113.863 53.1818C114.258 53.1818 114.599 53.1179 114.886 52.9901C115.173 52.8622 115.394 52.6818 115.55 52.4489C115.707 52.2159 115.786 51.9432 115.789 51.6307C115.786 51.3011 115.701 51.0099 115.533 50.7571C115.366 50.5043 115.137 50.3054 114.847 50.1605C114.56 50.0156 114.232 49.9432 113.863 49.9432C113.491 49.9432 113.158 50.0156 112.866 50.1605C112.576 50.3054 112.347 50.5043 112.18 50.7571C112.015 51.0099 111.934 51.3011 111.937 51.6307C111.934 51.9432 112.009 52.2159 112.163 52.4489C112.319 52.6818 112.542 52.8622 112.832 52.9901C113.121 53.1179 113.465 53.1818 113.863 53.1818ZM113.863 49.0398C114.175 49.0398 114.452 48.9773 114.694 48.8523C114.938 48.7273 115.13 48.5526 115.269 48.3281C115.408 48.1037 115.479 47.8409 115.482 47.5398C115.479 47.2443 115.41 46.9872 115.273 46.7685C115.137 46.5469 114.948 46.3764 114.707 46.2571C114.465 46.1349 114.184 46.0739 113.863 46.0739C113.536 46.0739 113.251 46.1349 113.006 46.2571C112.762 46.3764 112.573 46.5469 112.44 46.7685C112.306 46.9872 112.241 47.2443 112.244 47.5398C112.241 47.8409 112.308 48.1037 112.444 48.3281C112.583 48.5526 112.775 48.7273 113.019 48.8523C113.263 48.9773 113.545 49.0398 113.863 49.0398ZM121.837 54V53.233L124.718 50.0795C125.056 49.7102 125.334 49.3892 125.553 49.1165C125.772 48.8409 125.934 48.5824 126.039 48.3409C126.147 48.0966 126.201 47.8409 126.201 47.5739C126.201 47.267 126.127 47.0014 125.979 46.777C125.834 46.5526 125.635 46.3793 125.382 46.2571C125.13 46.1349 124.846 46.0739 124.53 46.0739C124.195 46.0739 123.902 46.1435 123.652 46.2827C123.405 46.419 123.213 46.6108 123.077 46.858C122.944 47.1051 122.877 47.3949 122.877 47.7273H121.871C121.871 47.2159 121.989 46.767 122.225 46.3807C122.461 45.9943 122.782 45.6932 123.188 45.4773C123.597 45.2614 124.056 45.1534 124.564 45.1534C125.076 45.1534 125.529 45.2614 125.924 45.4773C126.319 45.6932 126.628 45.9844 126.853 46.3509C127.077 46.7173 127.189 47.125 127.189 47.5739C127.189 47.8949 127.131 48.2088 127.015 48.5156C126.901 48.8196 126.702 49.1591 126.418 49.5341C126.137 49.9062 125.746 50.3608 125.246 50.8977L123.286 52.9943V53.0625H127.343V54H121.837ZM131.949 54.1193C131.307 54.1193 130.76 53.9446 130.309 53.5952C129.857 53.2429 129.512 52.733 129.273 52.0653C129.034 51.3949 128.915 50.5852 128.915 49.6364C128.915 48.6932 129.034 47.8878 129.273 47.2202C129.515 46.5497 129.861 46.0384 130.313 45.6861C130.767 45.331 131.313 45.1534 131.949 45.1534C132.586 45.1534 133.13 45.331 133.581 45.6861C134.036 46.0384 134.382 46.5497 134.621 47.2202C134.863 47.8878 134.983 48.6932 134.983 49.6364C134.983 50.5852 134.864 51.3949 134.625 52.0653C134.387 52.733 134.042 53.2429 133.59 53.5952C133.138 53.9446 132.591 54.1193 131.949 54.1193ZM131.949 53.1818C132.586 53.1818 133.08 52.875 133.432 52.2614C133.784 51.6477 133.961 50.7727 133.961 49.6364C133.961 48.8807 133.88 48.2372 133.718 47.706C133.559 47.1747 133.328 46.7699 133.027 46.4915C132.729 46.2131 132.37 46.0739 131.949 46.0739C131.319 46.0739 130.826 46.3849 130.471 47.0071C130.115 47.6264 129.938 48.5028 129.938 49.6364C129.938 50.392 130.017 51.0341 130.176 51.5625C130.336 52.0909 130.564 52.4929 130.863 52.7685C131.164 53.044 131.526 53.1818 131.949 53.1818ZM136.603 54V53.233L139.483 50.0795C139.821 49.7102 140.1 49.3892 140.319 49.1165C140.537 48.8409 140.699 48.5824 140.804 48.3409C140.912 48.0966 140.966 47.8409 140.966 47.5739C140.966 47.267 140.892 47.0014 140.745 46.777C140.6 46.5526 140.401 46.3793 140.148 46.2571C139.895 46.1349 139.611 46.0739 139.296 46.0739C138.961 46.0739 138.668 46.1435 138.418 46.2827C138.171 46.419 137.979 46.6108 137.843 46.858C137.709 47.1051 137.642 47.3949 137.642 47.7273H136.637C136.637 47.2159 136.755 46.767 136.99 46.3807C137.226 45.9943 137.547 45.6932 137.953 45.4773C138.363 45.2614 138.821 45.1534 139.33 45.1534C139.841 45.1534 140.294 45.2614 140.689 45.4773C141.084 45.6932 141.394 45.9844 141.618 46.3509C141.843 46.7173 141.955 47.125 141.955 47.5739C141.955 47.8949 141.897 48.2088 141.78 48.5156C141.667 48.8196 141.468 49.1591 141.184 49.5341C140.902 49.9062 140.512 50.3608 140.012 50.8977L138.051 52.9943V53.0625H142.108V54H136.603Z"
            fill="#6B6D76"
          />
          <LogoR />
          <path
            d="M58.9034 71V70.233L61.7841 67.0795C62.1222 66.7102 62.4006 66.3892 62.6193 66.1165C62.8381 65.8409 63 65.5824 63.1051 65.3409C63.2131 65.0966 63.267 64.8409 63.267 64.5739C63.267 64.267 63.1932 64.0014 63.0455 63.777C62.9006 63.5526 62.7017 63.3793 62.4489 63.2571C62.196 63.1349 61.9119 63.0739 61.5966 63.0739C61.2614 63.0739 60.9688 63.1435 60.7188 63.2827C60.4716 63.419 60.2798 63.6108 60.1435 63.858C60.0099 64.1051 59.9432 64.3949 59.9432 64.7273H58.9375C58.9375 64.2159 59.0554 63.767 59.2912 63.3807C59.527 62.9943 59.848 62.6932 60.2543 62.4773C60.6634 62.2614 61.1222 62.1534 61.6307 62.1534C62.142 62.1534 62.5952 62.2614 62.9901 62.4773C63.3849 62.6932 63.6946 62.9844 63.919 63.3509C64.1435 63.7173 64.2557 64.125 64.2557 64.5739C64.2557 64.8949 64.1974 65.2088 64.081 65.5156C63.9673 65.8196 63.7685 66.1591 63.4844 66.5341C63.2031 66.9062 62.8125 67.3608 62.3125 67.8977L60.3523 69.9943V70.0625H64.4091V71H58.9034ZM69.0156 71.1193C68.3736 71.1193 67.8267 70.9446 67.375 70.5952C66.9233 70.2429 66.5781 69.733 66.3395 69.0653C66.1009 68.3949 65.9815 67.5852 65.9815 66.6364C65.9815 65.6932 66.1009 64.8878 66.3395 64.2202C66.581 63.5497 66.9276 63.0384 67.3793 62.6861C67.8338 62.331 68.3793 62.1534 69.0156 62.1534C69.652 62.1534 70.196 62.331 70.6477 62.6861C71.1023 63.0384 71.4489 63.5497 71.6875 64.2202C71.929 64.8878 72.0497 65.6932 72.0497 66.6364C72.0497 67.5852 71.9304 68.3949 71.6918 69.0653C71.4531 69.733 71.108 70.2429 70.6562 70.5952C70.2045 70.9446 69.6577 71.1193 69.0156 71.1193ZM69.0156 70.1818C69.652 70.1818 70.1463 69.875 70.4986 69.2614C70.8509 68.6477 71.027 67.7727 71.027 66.6364C71.027 65.8807 70.946 65.2372 70.7841 64.706C70.625 64.1747 70.3949 63.7699 70.0938 63.4915C69.7955 63.2131 69.4361 63.0739 69.0156 63.0739C68.3849 63.0739 67.892 63.3849 67.5369 64.0071C67.1818 64.6264 67.0043 65.5028 67.0043 66.6364C67.0043 67.392 67.0838 68.0341 67.2429 68.5625C67.402 69.0909 67.6307 69.4929 67.929 69.7685C68.2301 70.044 68.5923 70.1818 69.0156 70.1818ZM73.669 71V70.233L76.5497 67.0795C76.8878 66.7102 77.1662 66.3892 77.3849 66.1165C77.6037 65.8409 77.7656 65.5824 77.8707 65.3409C77.9787 65.0966 78.0327 64.8409 78.0327 64.5739C78.0327 64.267 77.9588 64.0014 77.8111 63.777C77.6662 63.5526 77.4673 63.3793 77.2145 63.2571C76.9616 63.1349 76.6776 63.0739 76.3622 63.0739C76.027 63.0739 75.7344 63.1435 75.4844 63.2827C75.2372 63.419 75.0455 63.6108 74.9091 63.858C74.7756 64.1051 74.7088 64.3949 74.7088 64.7273H73.7031C73.7031 64.2159 73.821 63.767 74.0568 63.3807C74.2926 62.9943 74.6136 62.6932 75.0199 62.4773C75.429 62.2614 75.8878 62.1534 76.3963 62.1534C76.9077 62.1534 77.3608 62.2614 77.7557 62.4773C78.1506 62.6932 78.4602 62.9844 78.6847 63.3509C78.9091 63.7173 79.0213 64.125 79.0213 64.5739C79.0213 64.8949 78.9631 65.2088 78.8466 65.5156C78.733 65.8196 78.5341 66.1591 78.25 66.5341C77.9688 66.9062 77.5781 67.3608 77.0781 67.8977L75.1179 69.9943V70.0625H79.1747V71H73.669ZM84.7017 66.1676V67.1051H80.8835V66.1676H84.7017ZM91.3803 64.4545C91.3292 64.0227 91.1218 63.6875 90.7582 63.4489C90.3945 63.2102 89.9485 63.0909 89.4201 63.0909C89.0337 63.0909 88.6957 63.1534 88.4059 63.2784C88.119 63.4034 87.8945 63.5753 87.7326 63.794C87.5735 64.0128 87.494 64.2614 87.494 64.5398C87.494 64.7727 87.5494 64.973 87.6602 65.1406C87.7738 65.3054 87.9187 65.4432 88.0948 65.554C88.271 65.6619 88.4556 65.7514 88.6488 65.8224C88.842 65.8906 89.0195 65.946 89.1815 65.9886L90.0678 66.2273C90.2951 66.2869 90.5479 66.3693 90.8263 66.4744C91.1076 66.5795 91.3761 66.723 91.6317 66.9048C91.8903 67.0838 92.1033 67.3139 92.271 67.5952C92.4386 67.8764 92.5224 68.2216 92.5224 68.6307C92.5224 69.1023 92.3988 69.5284 92.1516 69.9091C91.9073 70.2898 91.5494 70.5923 91.0778 70.8168C90.609 71.0412 90.0394 71.1534 89.369 71.1534C88.744 71.1534 88.2028 71.0526 87.7454 70.8509C87.2908 70.6491 86.9329 70.3679 86.6715 70.0071C86.413 69.6463 86.2667 69.2273 86.2326 68.75H87.3235C87.3519 69.0795 87.4627 69.3523 87.6559 69.5682C87.8519 69.7812 88.0991 69.9403 88.3974 70.0455C88.6985 70.1477 89.0224 70.1989 89.369 70.1989C89.7724 70.1989 90.1346 70.1335 90.4556 70.0028C90.7766 69.8693 91.0309 69.6847 91.2184 69.4489C91.4059 69.2102 91.4996 68.9318 91.4996 68.6136C91.4996 68.3239 91.4187 68.0881 91.2567 67.9062C91.0948 67.7244 90.8817 67.5767 90.6175 67.4631C90.3533 67.3494 90.0678 67.25 89.761 67.1648L88.6871 66.858C88.0053 66.6619 87.4656 66.3821 87.0678 66.0185C86.6701 65.6548 86.4712 65.179 86.4712 64.5909C86.4712 64.1023 86.6033 63.6761 86.8675 63.3125C87.1346 62.946 87.4925 62.6619 87.9414 62.4602C88.3931 62.2557 88.8974 62.1534 89.4542 62.1534C90.0167 62.1534 90.5167 62.2543 90.9542 62.456C91.3917 62.6548 91.7383 62.9276 91.994 63.2741C92.2525 63.6207 92.3888 64.0142 92.4031 64.4545H91.3803ZM94.2599 62.2727H95.5213L98.4872 69.517H98.5895L101.555 62.2727H102.817V71H101.828V64.3693H101.743L99.0156 71H98.0611L95.3338 64.3693H95.2486V71H94.2599V62.2727ZM104.936 71V62.2727H110.203V63.2102H105.993V66.1591H109.93V67.0966H105.993V70.0625H110.271V71H104.936ZM114.801 71.1193C114.159 71.1193 113.612 70.9446 113.16 70.5952C112.708 70.2429 112.363 69.733 112.125 69.0653C111.886 68.3949 111.767 67.5852 111.767 66.6364C111.767 65.6932 111.886 64.8878 112.125 64.2202C112.366 63.5497 112.713 63.0384 113.164 62.6861C113.619 62.331 114.164 62.1534 114.801 62.1534C115.437 62.1534 115.981 62.331 116.433 62.6861C116.887 63.0384 117.234 63.5497 117.473 64.2202C117.714 64.8878 117.835 65.6932 117.835 66.6364C117.835 67.5852 117.716 68.3949 117.477 69.0653C117.238 69.733 116.893 70.2429 116.441 70.5952C115.99 70.9446 115.443 71.1193 114.801 71.1193ZM114.801 70.1818C115.437 70.1818 115.931 69.875 116.284 69.2614C116.636 68.6477 116.812 67.7727 116.812 66.6364C116.812 65.8807 116.731 65.2372 116.569 64.706C116.41 64.1747 116.18 63.7699 115.879 63.4915C115.581 63.2131 115.221 63.0739 114.801 63.0739C114.17 63.0739 113.677 63.3849 113.322 64.0071C112.967 64.6264 112.789 65.5028 112.789 66.6364C112.789 67.392 112.869 68.0341 113.028 68.5625C113.187 69.0909 113.416 69.4929 113.714 69.7685C114.015 70.044 114.377 70.1818 114.801 70.1818ZM119.25 69.2102V68.3409L123.085 62.2727H123.716V63.6193H123.289L120.392 68.2045V68.2727H125.556V69.2102H119.25ZM123.358 71V68.946V68.5412V62.2727H124.363V71H123.358ZM127.153 71V70.233L130.034 67.0795C130.372 66.7102 130.651 66.3892 130.869 66.1165C131.088 65.8409 131.25 65.5824 131.355 65.3409C131.463 65.0966 131.517 64.8409 131.517 64.5739C131.517 64.267 131.443 64.0014 131.295 63.777C131.151 63.5526 130.952 63.3793 130.699 63.2571C130.446 63.1349 130.162 63.0739 129.847 63.0739C129.511 63.0739 129.219 63.1435 128.969 63.2827C128.722 63.419 128.53 63.6108 128.393 63.858C128.26 64.1051 128.193 64.3949 128.193 64.7273H127.188C127.188 64.2159 127.305 63.767 127.541 63.3807C127.777 62.9943 128.098 62.6932 128.504 62.4773C128.913 62.2614 129.372 62.1534 129.881 62.1534C130.392 62.1534 130.845 62.2614 131.24 62.4773C131.635 62.6932 131.945 62.9844 132.169 63.3509C132.393 63.7173 132.506 64.125 132.506 64.5739C132.506 64.8949 132.447 65.2088 132.331 65.5156C132.217 65.8196 132.018 66.1591 131.734 66.5341C131.453 66.9062 131.062 67.3608 130.562 67.8977L128.602 69.9943V70.0625H132.659V71H127.153Z"
            fill="#6B6D76"
          />
          <Logo5GHZ />
        </svg>
      );
    case DeviceModel.UDM:
      return (
        <svg width="260" height="105" viewBox="0 0 260 105" fill="none" xmlns="http://www.w3.org/2000/svg">
          <ComplianceImage />
          <LogoTelecom />
          <LogoT />
          <path
            d="M62.75 54H60.0568V45.2727H62.8693C63.7159 45.2727 64.4403 45.4474 65.0426 45.7969C65.6449 46.1435 66.1065 46.642 66.4276 47.2926C66.7486 47.9403 66.9091 48.7159 66.9091 49.6193C66.9091 50.5284 66.7472 51.3111 66.4233 51.9673C66.0994 52.6207 65.6278 53.1236 65.0085 53.4759C64.3892 53.8253 63.6364 54 62.75 54ZM61.1136 53.0625H62.6818C63.4034 53.0625 64.0014 52.9233 64.4759 52.6449C64.9503 52.3665 65.304 51.9702 65.5369 51.456C65.7699 50.9418 65.8864 50.3295 65.8864 49.6193C65.8864 48.9148 65.7713 48.3082 65.5412 47.7997C65.3111 47.2884 64.9673 46.8963 64.5099 46.6236C64.0526 46.348 63.483 46.2102 62.8011 46.2102H61.1136V53.0625ZM74.9716 45.2727V54H73.9148V46.3807H73.8636L71.733 47.7955V46.7216L73.9148 45.2727H74.9716ZM80.2599 45.1534C80.6179 45.1562 80.9759 45.2244 81.3338 45.358C81.6918 45.4915 82.0185 45.7131 82.3139 46.0227C82.6094 46.3295 82.8466 46.7486 83.0256 47.2798C83.2045 47.8111 83.294 48.4773 83.294 49.2784C83.294 50.054 83.2202 50.7429 83.0724 51.3452C82.9276 51.9446 82.7173 52.4503 82.4418 52.8622C82.169 53.2741 81.8366 53.5866 81.4446 53.7997C81.0554 54.0128 80.6151 54.1193 80.1236 54.1193C79.6349 54.1193 79.1989 54.0227 78.8153 53.8295C78.4347 53.6335 78.1222 53.3622 77.8778 53.0156C77.6364 52.6662 77.4815 52.2614 77.4134 51.8011H78.4531C78.5469 52.2017 78.733 52.5327 79.0114 52.794C79.2926 53.0526 79.6634 53.1818 80.1236 53.1818C80.7969 53.1818 81.3281 52.8878 81.7173 52.2997C82.1094 51.7116 82.3054 50.8807 82.3054 49.8068H82.2372C82.0781 50.0455 81.8892 50.2514 81.6705 50.4247C81.4517 50.598 81.2088 50.7315 80.9418 50.8253C80.6747 50.919 80.3906 50.9659 80.0895 50.9659C79.5895 50.9659 79.1307 50.8423 78.7131 50.5952C78.2983 50.3452 77.9659 50.0028 77.7159 49.5682C77.4688 49.1307 77.3452 48.6307 77.3452 48.0682C77.3452 47.5341 77.4645 47.0455 77.7031 46.6023C77.9446 46.1562 78.2827 45.8011 78.7173 45.5369C79.1548 45.2727 79.669 45.1449 80.2599 45.1534ZM80.2599 46.0909C79.902 46.0909 79.5795 46.1804 79.2926 46.3594C79.0085 46.5355 78.7827 46.7741 78.6151 47.0753C78.4503 47.3736 78.3679 47.7045 78.3679 48.0682C78.3679 48.4318 78.4474 48.7628 78.6065 49.0611C78.7685 49.3565 78.9886 49.5923 79.267 49.7685C79.5483 49.9418 79.8679 50.0284 80.2259 50.0284C80.4957 50.0284 80.7472 49.9759 80.9801 49.8707C81.2131 49.7628 81.4162 49.6165 81.5895 49.4318C81.7656 49.2443 81.9034 49.0327 82.0028 48.7969C82.1023 48.5582 82.152 48.3097 82.152 48.0511C82.152 47.7102 82.0696 47.3906 81.9048 47.0923C81.7429 46.794 81.5185 46.5526 81.2315 46.3679C80.9474 46.1832 80.6236 46.0909 80.2599 46.0909ZM91.1914 54.1193C90.5494 54.1193 90.0025 53.9446 89.5508 53.5952C89.0991 53.2429 88.7539 52.733 88.5153 52.0653C88.2766 51.3949 88.1573 50.5852 88.1573 49.6364C88.1573 48.6932 88.2766 47.8878 88.5153 47.2202C88.7567 46.5497 89.1033 46.0384 89.555 45.6861C90.0096 45.331 90.555 45.1534 91.1914 45.1534C91.8278 45.1534 92.3718 45.331 92.8235 45.6861C93.2781 46.0384 93.6246 46.5497 93.8633 47.2202C94.1048 47.8878 94.2255 48.6932 94.2255 49.6364C94.2255 50.5852 94.1062 51.3949 93.8675 52.0653C93.6289 52.733 93.2837 53.2429 92.832 53.5952C92.3803 53.9446 91.8335 54.1193 91.1914 54.1193ZM91.1914 53.1818C91.8278 53.1818 92.3221 52.875 92.6744 52.2614C93.0266 51.6477 93.2028 50.7727 93.2028 49.6364C93.2028 48.8807 93.1218 48.2372 92.9599 47.706C92.8008 47.1747 92.5707 46.7699 92.2695 46.4915C91.9712 46.2131 91.6119 46.0739 91.1914 46.0739C90.5607 46.0739 90.0678 46.3849 89.7127 47.0071C89.3576 47.6264 89.18 48.5028 89.18 49.6364C89.18 50.392 89.2596 51.0341 89.4187 51.5625C89.5778 52.0909 89.8065 52.4929 90.1048 52.7685C90.4059 53.044 90.7681 53.1818 91.1914 53.1818ZM98.913 45.2727V54H97.8562V46.3807H97.805L95.6744 47.7955V46.7216L97.8562 45.2727H98.913ZM104.27 54.1193C103.627 54.1193 103.081 53.9446 102.629 53.5952C102.177 53.2429 101.832 52.733 101.593 52.0653C101.355 51.3949 101.235 50.5852 101.235 49.6364C101.235 48.6932 101.355 47.8878 101.593 47.2202C101.835 46.5497 102.181 46.0384 102.633 45.6861C103.088 45.331 103.633 45.1534 104.27 45.1534C104.906 45.1534 105.45 45.331 105.902 45.6861C106.356 46.0384 106.703 46.5497 106.941 47.2202C107.183 47.8878 107.304 48.6932 107.304 49.6364C107.304 50.5852 107.184 51.3949 106.946 52.0653C106.707 52.733 106.362 53.2429 105.91 53.5952C105.458 53.9446 104.912 54.1193 104.27 54.1193ZM104.27 53.1818C104.906 53.1818 105.4 52.875 105.752 52.2614C106.105 51.6477 106.281 50.7727 106.281 49.6364C106.281 48.8807 106.2 48.2372 106.038 47.706C105.879 47.1747 105.649 46.7699 105.348 46.4915C105.049 46.2131 104.69 46.0739 104.27 46.0739C103.639 46.0739 103.146 46.3849 102.791 47.0071C102.436 47.6264 102.258 48.5028 102.258 49.6364C102.258 50.392 102.338 51.0341 102.497 51.5625C102.656 52.0909 102.885 52.4929 103.183 52.7685C103.484 53.044 103.846 53.1818 104.27 53.1818ZM108.718 52.2102V51.3409L112.554 45.2727H113.184V46.6193H112.758L109.86 51.2045V51.2727H115.025V52.2102H108.718ZM112.826 54V51.946V51.5412V45.2727H113.832V54H112.826ZM119.997 54V53.233L122.878 50.0795C123.216 49.7102 123.494 49.3892 123.713 49.1165C123.932 48.8409 124.094 48.5824 124.199 48.3409C124.307 48.0966 124.361 47.8409 124.361 47.5739C124.361 47.267 124.287 47.0014 124.139 46.777C123.994 46.5526 123.795 46.3793 123.543 46.2571C123.29 46.1349 123.006 46.0739 122.69 46.0739C122.355 46.0739 122.062 46.1435 121.812 46.2827C121.565 46.419 121.374 46.6108 121.237 46.858C121.104 47.1051 121.037 47.3949 121.037 47.7273H120.031C120.031 47.2159 120.149 46.767 120.385 46.3807C120.621 45.9943 120.942 45.6932 121.348 45.4773C121.757 45.2614 122.216 45.1534 122.724 45.1534C123.236 45.1534 123.689 45.2614 124.084 45.4773C124.479 45.6932 124.788 45.9844 125.013 46.3509C125.237 46.7173 125.349 47.125 125.349 47.5739C125.349 47.8949 125.291 48.2088 125.175 48.5156C125.061 48.8196 124.862 49.1591 124.578 49.5341C124.297 49.9062 123.906 50.3608 123.406 50.8977L121.446 52.9943V53.0625H125.503V54H119.997ZM130.109 54.1193C129.467 54.1193 128.92 53.9446 128.469 53.5952C128.017 53.2429 127.672 52.733 127.433 52.0653C127.195 51.3949 127.075 50.5852 127.075 49.6364C127.075 48.6932 127.195 47.8878 127.433 47.2202C127.675 46.5497 128.021 46.0384 128.473 45.6861C128.928 45.331 129.473 45.1534 130.109 45.1534C130.746 45.1534 131.29 45.331 131.741 45.6861C132.196 46.0384 132.543 46.5497 132.781 47.2202C133.023 47.8878 133.143 48.6932 133.143 49.6364C133.143 50.5852 133.024 51.3949 132.786 52.0653C132.547 52.733 132.202 53.2429 131.75 53.5952C131.298 53.9446 130.751 54.1193 130.109 54.1193ZM130.109 53.1818C130.746 53.1818 131.24 52.875 131.592 52.2614C131.945 51.6477 132.121 50.7727 132.121 49.6364C132.121 48.8807 132.04 48.2372 131.878 47.706C131.719 47.1747 131.489 46.7699 131.188 46.4915C130.889 46.2131 130.53 46.0739 130.109 46.0739C129.479 46.0739 128.986 46.3849 128.631 47.0071C128.276 47.6264 128.098 48.5028 128.098 49.6364C128.098 50.392 128.178 51.0341 128.337 51.5625C128.496 52.0909 128.724 52.4929 129.023 52.7685C129.324 53.044 129.686 53.1818 130.109 53.1818ZM137.831 45.2727V54H136.774V46.3807H136.723L134.592 47.7955V46.7216L136.774 45.2727H137.831Z"
            fill="#6B6D76"
          />
          <LogoR />
          <path
            d="M58.9034 71V70.233L61.7841 67.0795C62.1222 66.7102 62.4006 66.3892 62.6193 66.1165C62.8381 65.8409 63 65.5824 63.1051 65.3409C63.2131 65.0966 63.267 64.8409 63.267 64.5739C63.267 64.267 63.1932 64.0014 63.0455 63.777C62.9006 63.5526 62.7017 63.3793 62.4489 63.2571C62.196 63.1349 61.9119 63.0739 61.5966 63.0739C61.2614 63.0739 60.9688 63.1435 60.7188 63.2827C60.4716 63.419 60.2798 63.6108 60.1435 63.858C60.0099 64.1051 59.9432 64.3949 59.9432 64.7273H58.9375C58.9375 64.2159 59.0554 63.767 59.2912 63.3807C59.527 62.9943 59.848 62.6932 60.2543 62.4773C60.6634 62.2614 61.1222 62.1534 61.6307 62.1534C62.142 62.1534 62.5952 62.2614 62.9901 62.4773C63.3849 62.6932 63.6946 62.9844 63.919 63.3509C64.1435 63.7173 64.2557 64.125 64.2557 64.5739C64.2557 64.8949 64.1974 65.2088 64.081 65.5156C63.9673 65.8196 63.7685 66.1591 63.4844 66.5341C63.2031 66.9062 62.8125 67.3608 62.3125 67.8977L60.3523 69.9943V70.0625H64.4091V71H58.9034ZM69.0156 71.1193C68.3736 71.1193 67.8267 70.9446 67.375 70.5952C66.9233 70.2429 66.5781 69.733 66.3395 69.0653C66.1009 68.3949 65.9815 67.5852 65.9815 66.6364C65.9815 65.6932 66.1009 64.8878 66.3395 64.2202C66.581 63.5497 66.9276 63.0384 67.3793 62.6861C67.8338 62.331 68.3793 62.1534 69.0156 62.1534C69.652 62.1534 70.196 62.331 70.6477 62.6861C71.1023 63.0384 71.4489 63.5497 71.6875 64.2202C71.929 64.8878 72.0497 65.6932 72.0497 66.6364C72.0497 67.5852 71.9304 68.3949 71.6918 69.0653C71.4531 69.733 71.108 70.2429 70.6562 70.5952C70.2045 70.9446 69.6577 71.1193 69.0156 71.1193ZM69.0156 70.1818C69.652 70.1818 70.1463 69.875 70.4986 69.2614C70.8509 68.6477 71.027 67.7727 71.027 66.6364C71.027 65.8807 70.946 65.2372 70.7841 64.706C70.625 64.1747 70.3949 63.7699 70.0938 63.4915C69.7955 63.2131 69.4361 63.0739 69.0156 63.0739C68.3849 63.0739 67.892 63.3849 67.5369 64.0071C67.1818 64.6264 67.0043 65.5028 67.0043 66.6364C67.0043 67.392 67.0838 68.0341 67.2429 68.5625C67.402 69.0909 67.6307 69.4929 67.929 69.7685C68.2301 70.044 68.5923 70.1818 69.0156 70.1818ZM76.7372 62.2727V71H75.6804V63.3807H75.6293L73.4986 64.7955V63.7216L75.6804 62.2727H76.7372ZM83.0142 66.1676V67.1051H79.196V66.1676H83.0142ZM87.8349 62.2727V71H86.7781V63.3807H86.7269L84.5962 64.7955V63.7216L86.7781 62.2727H87.8349ZM93.1232 62.1534C93.4812 62.1562 93.8391 62.2244 94.1971 62.358C94.555 62.4915 94.8817 62.7131 95.1772 63.0227C95.4727 63.3295 95.7099 63.7486 95.8888 64.2798C96.0678 64.8111 96.1573 65.4773 96.1573 66.2784C96.1573 67.054 96.0835 67.7429 95.9357 68.3452C95.7908 68.9446 95.5806 69.4503 95.305 69.8622C95.0323 70.2741 94.6999 70.5866 94.3079 70.7997C93.9187 71.0128 93.4783 71.1193 92.9869 71.1193C92.4982 71.1193 92.0621 71.0227 91.6786 70.8295C91.2979 70.6335 90.9854 70.3622 90.7411 70.0156C90.4996 69.6662 90.3448 69.2614 90.2766 68.8011H91.3164C91.4102 69.2017 91.5962 69.5327 91.8746 69.794C92.1559 70.0526 92.5266 70.1818 92.9869 70.1818C93.6602 70.1818 94.1914 69.8878 94.5806 69.2997C94.9727 68.7116 95.1687 67.8807 95.1687 66.8068H95.1005C94.9414 67.0455 94.7525 67.2514 94.5337 67.4247C94.315 67.598 94.0721 67.7315 93.805 67.8253C93.538 67.919 93.2539 67.9659 92.9528 67.9659C92.4528 67.9659 91.994 67.8423 91.5763 67.5952C91.1616 67.3452 90.8292 67.0028 90.5792 66.5682C90.332 66.1307 90.2085 65.6307 90.2085 65.0682C90.2085 64.5341 90.3278 64.0455 90.5664 63.6023C90.8079 63.1562 91.146 62.8011 91.5806 62.5369C92.0181 62.2727 92.5323 62.1449 93.1232 62.1534ZM93.1232 63.0909C92.7653 63.0909 92.4428 63.1804 92.1559 63.3594C91.8718 63.5355 91.646 63.7741 91.4783 64.0753C91.3136 64.3736 91.2312 64.7045 91.2312 65.0682C91.2312 65.4318 91.3107 65.7628 91.4698 66.0611C91.6317 66.3565 91.8519 66.5923 92.1303 66.7685C92.4116 66.9418 92.7312 67.0284 93.0891 67.0284C93.359 67.0284 93.6104 66.9759 93.8434 66.8707C94.0763 66.7628 94.2795 66.6165 94.4528 66.4318C94.6289 66.2443 94.7667 66.0327 94.8661 65.7969C94.9656 65.5582 95.0153 65.3097 95.0153 65.0511C95.0153 64.7102 94.9329 64.3906 94.7681 64.0923C94.6062 63.794 94.3817 63.5526 94.0948 63.3679C93.8107 63.1832 93.4869 63.0909 93.1232 63.0909ZM100.68 71.1193C100.038 71.1193 99.4908 70.9446 99.0391 70.5952C98.5874 70.2429 98.2422 69.733 98.0036 69.0653C97.7649 68.3949 97.6456 67.5852 97.6456 66.6364C97.6456 65.6932 97.7649 64.8878 98.0036 64.2202C98.245 63.5497 98.5916 63.0384 99.0433 62.6861C99.4979 62.331 100.043 62.1534 100.68 62.1534C101.316 62.1534 101.86 62.331 102.312 62.6861C102.766 63.0384 103.113 63.5497 103.352 64.2202C103.593 64.8878 103.714 65.6932 103.714 66.6364C103.714 67.5852 103.594 68.3949 103.356 69.0653C103.117 69.733 102.772 70.2429 102.32 70.5952C101.869 70.9446 101.322 71.1193 100.68 71.1193ZM100.68 70.1818C101.316 70.1818 101.81 69.875 102.163 69.2614C102.515 68.6477 102.691 67.7727 102.691 66.6364C102.691 65.8807 102.61 65.2372 102.448 64.706C102.289 64.1747 102.059 63.7699 101.758 63.4915C101.46 63.2131 101.1 63.0739 100.68 63.0739C100.049 63.0739 99.5561 63.3849 99.201 64.0071C98.8459 64.6264 98.6683 65.5028 98.6683 66.6364C98.6683 67.392 98.7479 68.0341 98.907 68.5625C99.0661 69.0909 99.2947 69.4929 99.593 69.7685C99.8942 70.044 100.256 70.1818 100.68 70.1818ZM105.129 69.2102V68.3409L108.964 62.2727H109.594V63.6193H109.168L106.271 68.2045V68.2727H111.435V69.2102H105.129ZM109.237 71V68.946V68.5412V62.2727H110.242V71H109.237ZM115.983 62.2727V71H114.926V63.3807H114.875L112.745 64.7955V63.7216L114.926 62.2727H115.983ZM121.34 71.1193C120.698 71.1193 120.151 70.9446 119.699 70.5952C119.248 70.2429 118.902 69.733 118.664 69.0653C118.425 68.3949 118.306 67.5852 118.306 66.6364C118.306 65.6932 118.425 64.8878 118.664 64.2202C118.905 63.5497 119.252 63.0384 119.703 62.6861C120.158 62.331 120.703 62.1534 121.34 62.1534C121.976 62.1534 122.52 62.331 122.972 62.6861C123.426 63.0384 123.773 63.5497 124.012 64.2202C124.253 64.8878 124.374 65.6932 124.374 66.6364C124.374 67.5852 124.255 68.3949 124.016 69.0653C123.777 69.733 123.432 70.2429 122.98 70.5952C122.529 70.9446 121.982 71.1193 121.34 71.1193ZM121.34 70.1818C121.976 70.1818 122.471 69.875 122.823 69.2614C123.175 68.6477 123.351 67.7727 123.351 66.6364C123.351 65.8807 123.27 65.2372 123.108 64.706C122.949 64.1747 122.719 63.7699 122.418 63.4915C122.12 63.2131 121.76 63.0739 121.34 63.0739C120.709 63.0739 120.216 63.3849 119.861 64.0071C119.506 64.6264 119.328 65.5028 119.328 66.6364C119.328 67.392 119.408 68.0341 119.567 68.5625C119.726 69.0909 119.955 69.4929 120.253 69.7685C120.554 70.044 120.917 70.1818 121.34 70.1818Z"
            fill="#6B6D76"
          />
          <Logo5GHZ />
        </svg>
      );
    case DeviceModel.UDR:
      return (
        <svg width="260" height="105" viewBox="0 0 260 105" fill="none" xmlns="http://www.w3.org/2000/svg">
          <ComplianceImage />
          <LogoTelecom />
          <LogoT />
          <path
            d="M62.75 54H60.0568V45.2727H62.8693C63.7159 45.2727 64.4403 45.4474 65.0426 45.7969C65.6449 46.1435 66.1065 46.642 66.4276 47.2926C66.7486 47.9403 66.9091 48.7159 66.9091 49.6193C66.9091 50.5284 66.7472 51.3111 66.4233 51.9673C66.0994 52.6207 65.6278 53.1236 65.0085 53.4759C64.3892 53.8253 63.6364 54 62.75 54ZM61.1136 53.0625H62.6818C63.4034 53.0625 64.0014 52.9233 64.4759 52.6449C64.9503 52.3665 65.304 51.9702 65.5369 51.456C65.7699 50.9418 65.8864 50.3295 65.8864 49.6193C65.8864 48.9148 65.7713 48.3082 65.5412 47.7997C65.3111 47.2884 64.9673 46.8963 64.5099 46.6236C64.0526 46.348 63.483 46.2102 62.8011 46.2102H61.1136V53.0625ZM71.9034 54V53.233L74.7841 50.0795C75.1222 49.7102 75.4006 49.3892 75.6193 49.1165C75.8381 48.8409 76 48.5824 76.1051 48.3409C76.2131 48.0966 76.267 47.8409 76.267 47.5739C76.267 47.267 76.1932 47.0014 76.0455 46.777C75.9006 46.5526 75.7017 46.3793 75.4489 46.2571C75.196 46.1349 74.9119 46.0739 74.5966 46.0739C74.2614 46.0739 73.9688 46.1435 73.7188 46.2827C73.4716 46.419 73.2798 46.6108 73.1435 46.858C73.0099 47.1051 72.9432 47.3949 72.9432 47.7273H71.9375C71.9375 47.2159 72.0554 46.767 72.2912 46.3807C72.527 45.9943 72.848 45.6932 73.2543 45.4773C73.6634 45.2614 74.1222 45.1534 74.6307 45.1534C75.142 45.1534 75.5952 45.2614 75.9901 45.4773C76.3849 45.6932 76.6946 45.9844 76.919 46.3509C77.1435 46.7173 77.2557 47.125 77.2557 47.5739C77.2557 47.8949 77.1974 48.2088 77.081 48.5156C76.9673 48.8196 76.7685 49.1591 76.4844 49.5341C76.2031 49.9062 75.8125 50.3608 75.3125 50.8977L73.3523 52.9943V53.0625H77.4091V54H71.9034ZM82.2372 45.2727V54H81.1804V46.3807H81.1293L78.9986 47.7955V46.7216L81.1804 45.2727H82.2372ZM88.5142 49.1676V50.1051H84.696V49.1676H88.5142ZM93.1133 54.1193C92.4712 54.1193 91.9244 53.9446 91.4727 53.5952C91.021 53.2429 90.6758 52.733 90.4371 52.0653C90.1985 51.3949 90.0792 50.5852 90.0792 49.6364C90.0792 48.6932 90.1985 47.8878 90.4371 47.2202C90.6786 46.5497 91.0252 46.0384 91.4769 45.6861C91.9315 45.331 92.4769 45.1534 93.1133 45.1534C93.7496 45.1534 94.2937 45.331 94.7454 45.6861C95.1999 46.0384 95.5465 46.5497 95.7852 47.2202C96.0266 47.8878 96.1474 48.6932 96.1474 49.6364C96.1474 50.5852 96.0281 51.3949 95.7894 52.0653C95.5508 52.733 95.2056 53.2429 94.7539 53.5952C94.3022 53.9446 93.7553 54.1193 93.1133 54.1193ZM93.1133 53.1818C93.7496 53.1818 94.244 52.875 94.5962 52.2614C94.9485 51.6477 95.1246 50.7727 95.1246 49.6364C95.1246 48.8807 95.0437 48.2372 94.8817 47.706C94.7227 47.1747 94.4925 46.7699 94.1914 46.4915C93.8931 46.2131 93.5337 46.0739 93.1133 46.0739C92.4826 46.0739 91.9897 46.3849 91.6346 47.0071C91.2795 47.6264 91.1019 48.5028 91.1019 49.6364C91.1019 50.392 91.1815 51.0341 91.3406 51.5625C91.4996 52.0909 91.7283 52.4929 92.0266 52.7685C92.3278 53.044 92.69 53.1818 93.1133 53.1818ZM97.7667 54V53.233L100.647 50.0795C100.985 49.7102 101.264 49.3892 101.483 49.1165C101.701 48.8409 101.863 48.5824 101.968 48.3409C102.076 48.0966 102.13 47.8409 102.13 47.5739C102.13 47.267 102.056 47.0014 101.909 46.777C101.764 46.5526 101.565 46.3793 101.312 46.2571C101.059 46.1349 100.775 46.0739 100.46 46.0739C100.125 46.0739 99.832 46.1435 99.582 46.2827C99.3349 46.419 99.1431 46.6108 99.0067 46.858C98.8732 47.1051 98.8065 47.3949 98.8065 47.7273H97.8008C97.8008 47.2159 97.9187 46.767 98.1545 46.3807C98.3903 45.9943 98.7113 45.6932 99.1175 45.4773C99.5266 45.2614 99.9854 45.1534 100.494 45.1534C101.005 45.1534 101.458 45.2614 101.853 45.4773C102.248 45.6932 102.558 45.9844 102.782 46.3509C103.007 46.7173 103.119 47.125 103.119 47.5739C103.119 47.8949 103.061 48.2088 102.944 48.5156C102.831 48.8196 102.632 49.1591 102.348 49.5341C102.066 49.9062 101.676 50.3608 101.176 50.8977L99.2156 52.9943V53.0625H103.272V54H97.7667ZM107.879 54.1193C107.237 54.1193 106.69 53.9446 106.238 53.5952C105.787 53.2429 105.441 52.733 105.203 52.0653C104.964 51.3949 104.845 50.5852 104.845 49.6364C104.845 48.6932 104.964 47.8878 105.203 47.2202C105.444 46.5497 105.791 46.0384 106.243 45.6861C106.697 45.331 107.243 45.1534 107.879 45.1534C108.515 45.1534 109.059 45.331 109.511 45.6861C109.966 46.0384 110.312 46.5497 110.551 47.2202C110.792 47.8878 110.913 48.6932 110.913 49.6364C110.913 50.5852 110.794 51.3949 110.555 52.0653C110.316 52.733 109.971 53.2429 109.52 53.5952C109.068 53.9446 108.521 54.1193 107.879 54.1193ZM107.879 53.1818C108.515 53.1818 109.01 52.875 109.362 52.2614C109.714 51.6477 109.89 50.7727 109.89 49.6364C109.89 48.8807 109.809 48.2372 109.647 47.706C109.488 47.1747 109.258 46.7699 108.957 46.4915C108.659 46.2131 108.299 46.0739 107.879 46.0739C107.248 46.0739 106.755 46.3849 106.4 47.0071C106.045 47.6264 105.868 48.5028 105.868 49.6364C105.868 50.392 105.947 51.0341 106.106 51.5625C106.265 52.0909 106.494 52.4929 106.792 52.7685C107.093 53.044 107.456 53.1818 107.879 53.1818ZM112.328 52.2102V51.3409L116.163 45.2727H116.794V46.6193H116.368L113.47 51.2045V51.2727H118.635V52.2102H112.328ZM116.436 54V51.946V51.5412V45.2727H117.441V54H116.436ZM120.232 54V53.233L123.112 50.0795C123.45 49.7102 123.729 49.3892 123.947 49.1165C124.166 48.8409 124.328 48.5824 124.433 48.3409C124.541 48.0966 124.595 47.8409 124.595 47.5739C124.595 47.267 124.521 47.0014 124.374 46.777C124.229 46.5526 124.03 46.3793 123.777 46.2571C123.524 46.1349 123.24 46.0739 122.925 46.0739C122.589 46.0739 122.297 46.1435 122.047 46.2827C121.8 46.419 121.608 46.6108 121.472 46.858C121.338 47.1051 121.271 47.3949 121.271 47.7273H120.266C120.266 47.2159 120.384 46.767 120.619 46.3807C120.855 45.9943 121.176 45.6932 121.582 45.4773C121.991 45.2614 122.45 45.1534 122.959 45.1534C123.47 45.1534 123.923 45.2614 124.318 45.4773C124.713 45.6932 125.023 45.9844 125.247 46.3509C125.472 46.7173 125.584 47.125 125.584 47.5739C125.584 47.8949 125.526 48.2088 125.409 48.5156C125.295 48.8196 125.097 49.1591 124.812 49.5341C124.531 49.9062 124.141 50.3608 123.641 50.8977L121.68 52.9943V53.0625H125.737V54H120.232ZM130.344 54.1193C129.702 54.1193 129.155 53.9446 128.703 53.5952C128.251 53.2429 127.906 52.733 127.668 52.0653C127.429 51.3949 127.31 50.5852 127.31 49.6364C127.31 48.6932 127.429 47.8878 127.668 47.2202C127.909 46.5497 128.256 46.0384 128.707 45.6861C129.162 45.331 129.707 45.1534 130.344 45.1534C130.98 45.1534 131.524 45.331 131.976 45.6861C132.43 46.0384 132.777 46.5497 133.016 47.2202C133.257 47.8878 133.378 48.6932 133.378 49.6364C133.378 50.5852 133.259 51.3949 133.02 52.0653C132.781 52.733 132.436 53.2429 131.984 53.5952C131.533 53.9446 130.986 54.1193 130.344 54.1193ZM130.344 53.1818C130.98 53.1818 131.474 52.875 131.827 52.2614C132.179 51.6477 132.355 50.7727 132.355 49.6364C132.355 48.8807 132.274 48.2372 132.112 47.706C131.953 47.1747 131.723 46.7699 131.422 46.4915C131.124 46.2131 130.764 46.0739 130.344 46.0739C129.713 46.0739 129.22 46.3849 128.865 47.0071C128.51 47.6264 128.332 48.5028 128.332 49.6364C128.332 50.392 128.412 51.0341 128.571 51.5625C128.73 52.0909 128.959 52.4929 129.257 52.7685C129.558 53.044 129.92 53.1818 130.344 53.1818ZM138.065 45.2727V54H137.009V46.3807H136.957L134.827 47.7955V46.7216L137.009 45.2727H138.065Z"
            fill="#6B6D76"
          />
          <LogoR />
          <path
            d="M58.9034 71V70.233L61.7841 67.0795C62.1222 66.7102 62.4006 66.3892 62.6193 66.1165C62.8381 65.8409 63 65.5824 63.1051 65.3409C63.2131 65.0966 63.267 64.8409 63.267 64.5739C63.267 64.267 63.1932 64.0014 63.0455 63.777C62.9006 63.5526 62.7017 63.3793 62.4489 63.2571C62.196 63.1349 61.9119 63.0739 61.5966 63.0739C61.2614 63.0739 60.9688 63.1435 60.7188 63.2827C60.4716 63.419 60.2798 63.6108 60.1435 63.858C60.0099 64.1051 59.9432 64.3949 59.9432 64.7273H58.9375C58.9375 64.2159 59.0554 63.767 59.2912 63.3807C59.527 62.9943 59.848 62.6932 60.2543 62.4773C60.6634 62.2614 61.1222 62.1534 61.6307 62.1534C62.142 62.1534 62.5952 62.2614 62.9901 62.4773C63.3849 62.6932 63.6946 62.9844 63.919 63.3509C64.1435 63.7173 64.2557 64.125 64.2557 64.5739C64.2557 64.8949 64.1974 65.2088 64.081 65.5156C63.9673 65.8196 63.7685 66.1591 63.4844 66.5341C63.2031 66.9062 62.8125 67.3608 62.3125 67.8977L60.3523 69.9943V70.0625H64.4091V71H58.9034ZM69.0156 71.1193C68.3736 71.1193 67.8267 70.9446 67.375 70.5952C66.9233 70.2429 66.5781 69.733 66.3395 69.0653C66.1009 68.3949 65.9815 67.5852 65.9815 66.6364C65.9815 65.6932 66.1009 64.8878 66.3395 64.2202C66.581 63.5497 66.9276 63.0384 67.3793 62.6861C67.8338 62.331 68.3793 62.1534 69.0156 62.1534C69.652 62.1534 70.196 62.331 70.6477 62.6861C71.1023 63.0384 71.4489 63.5497 71.6875 64.2202C71.929 64.8878 72.0497 65.6932 72.0497 66.6364C72.0497 67.5852 71.9304 68.3949 71.6918 69.0653C71.4531 69.733 71.108 70.2429 70.6562 70.5952C70.2045 70.9446 69.6577 71.1193 69.0156 71.1193ZM69.0156 70.1818C69.652 70.1818 70.1463 69.875 70.4986 69.2614C70.8509 68.6477 71.027 67.7727 71.027 66.6364C71.027 65.8807 70.946 65.2372 70.7841 64.706C70.625 64.1747 70.3949 63.7699 70.0938 63.4915C69.7955 63.2131 69.4361 63.0739 69.0156 63.0739C68.3849 63.0739 67.892 63.3849 67.5369 64.0071C67.1818 64.6264 67.0043 65.5028 67.0043 66.6364C67.0043 67.392 67.0838 68.0341 67.2429 68.5625C67.402 69.0909 67.6307 69.4929 67.929 69.7685C68.2301 70.044 68.5923 70.1818 69.0156 70.1818ZM76.7372 62.2727V71H75.6804V63.3807H75.6293L73.4986 64.7955V63.7216L75.6804 62.2727H76.7372ZM83.0142 66.1676V67.1051H79.196V66.1676H83.0142ZM84.3565 71V70.233L87.2372 67.0795C87.5753 66.7102 87.8537 66.3892 88.0724 66.1165C88.2912 65.8409 88.4531 65.5824 88.5582 65.3409C88.6662 65.0966 88.7202 64.8409 88.7202 64.5739C88.7202 64.267 88.6463 64.0014 88.4986 63.777C88.3537 63.5526 88.1548 63.3793 87.902 63.2571C87.6491 63.1349 87.3651 63.0739 87.0497 63.0739C86.7145 63.0739 86.4219 63.1435 86.1719 63.2827C85.9247 63.419 85.733 63.6108 85.5966 63.858C85.4631 64.1051 85.3963 64.3949 85.3963 64.7273H84.3906C84.3906 64.2159 84.5085 63.767 84.7443 63.3807C84.9801 62.9943 85.3011 62.6932 85.7074 62.4773C86.1165 62.2614 86.5753 62.1534 87.0838 62.1534C87.5952 62.1534 88.0483 62.2614 88.4432 62.4773C88.8381 62.6932 89.1477 62.9844 89.3722 63.3509C89.5966 63.7173 89.7088 64.125 89.7088 64.5739C89.7088 64.8949 89.6506 65.2088 89.5341 65.5156C89.4205 65.8196 89.2216 66.1591 88.9375 66.5341C88.6562 66.9062 88.2656 67.3608 87.7656 67.8977L85.8054 69.9943V70.0625H89.8622V71H84.3565ZM94.6903 62.2727V71H93.6335V63.3807H93.5824L91.4517 64.7955V63.7216L93.6335 62.2727H94.6903ZM100.047 71.1193C99.4048 71.1193 98.858 70.9446 98.4062 70.5952C97.9545 70.2429 97.6094 69.733 97.3707 69.0653C97.1321 68.3949 97.0128 67.5852 97.0128 66.6364C97.0128 65.6932 97.1321 64.8878 97.3707 64.2202C97.6122 63.5497 97.9588 63.0384 98.4105 62.6861C98.8651 62.331 99.4105 62.1534 100.047 62.1534C100.683 62.1534 101.227 62.331 101.679 62.6861C102.134 63.0384 102.48 63.5497 102.719 64.2202C102.96 64.8878 103.081 65.6932 103.081 66.6364C103.081 67.5852 102.962 68.3949 102.723 69.0653C102.484 69.733 102.139 70.2429 101.688 70.5952C101.236 70.9446 100.689 71.1193 100.047 71.1193ZM100.047 70.1818C100.683 70.1818 101.178 69.875 101.53 69.2614C101.882 68.6477 102.058 67.7727 102.058 66.6364C102.058 65.8807 101.977 65.2372 101.815 64.706C101.656 64.1747 101.426 63.7699 101.125 63.4915C100.827 63.2131 100.467 63.0739 100.047 63.0739C99.4162 63.0739 98.9233 63.3849 98.5682 64.0071C98.2131 64.6264 98.0355 65.5028 98.0355 66.6364C98.0355 67.392 98.1151 68.0341 98.2741 68.5625C98.4332 69.0909 98.6619 69.4929 98.9602 69.7685C99.2614 70.044 99.6236 70.1818 100.047 70.1818ZM107.479 62.1534C107.837 62.1562 108.195 62.2244 108.553 62.358C108.911 62.4915 109.237 62.7131 109.533 63.0227C109.828 63.3295 110.065 63.7486 110.244 64.2798C110.423 64.8111 110.513 65.4773 110.513 66.2784C110.513 67.054 110.439 67.7429 110.291 68.3452C110.146 68.9446 109.936 69.4503 109.661 69.8622C109.388 70.2741 109.055 70.5866 108.663 70.7997C108.274 71.0128 107.834 71.1193 107.342 71.1193C106.854 71.1193 106.418 71.0227 106.034 70.8295C105.653 70.6335 105.341 70.3622 105.097 70.0156C104.855 69.6662 104.7 69.2614 104.632 68.8011H105.672C105.766 69.2017 105.952 69.5327 106.23 69.794C106.511 70.0526 106.882 70.1818 107.342 70.1818C108.016 70.1818 108.547 69.8878 108.936 69.2997C109.328 68.7116 109.524 67.8807 109.524 66.8068H109.456C109.297 67.0455 109.108 67.2514 108.889 67.4247C108.67 67.598 108.428 67.7315 108.161 67.8253C107.893 67.919 107.609 67.9659 107.308 67.9659C106.808 67.9659 106.349 67.8423 105.932 67.5952C105.517 67.3452 105.185 67.0028 104.935 66.5682C104.688 66.1307 104.564 65.6307 104.564 65.0682C104.564 64.5341 104.683 64.0455 104.922 63.6023C105.163 63.1562 105.501 62.8011 105.936 62.5369C106.374 62.2727 106.888 62.1449 107.479 62.1534ZM107.479 63.0909C107.121 63.0909 106.798 63.1804 106.511 63.3594C106.227 63.5355 106.001 63.7741 105.834 64.0753C105.669 64.3736 105.587 64.7045 105.587 65.0682C105.587 65.4318 105.666 65.7628 105.825 66.0611C105.987 66.3565 106.207 66.5923 106.486 66.7685C106.767 66.9418 107.087 67.0284 107.445 67.0284C107.714 67.0284 107.966 66.9759 108.199 66.8707C108.432 66.7628 108.635 66.6165 108.808 66.4318C108.984 66.2443 109.122 66.0327 109.222 65.7969C109.321 65.5582 109.371 65.3097 109.371 65.0511C109.371 64.7102 109.288 64.3906 109.124 64.0923C108.962 63.794 108.737 63.5526 108.45 63.3679C108.166 63.1832 107.842 63.0909 107.479 63.0909ZM112.189 71V70.233L115.069 67.0795C115.407 66.7102 115.686 66.3892 115.904 66.1165C116.123 65.8409 116.285 65.5824 116.39 65.3409C116.498 65.0966 116.552 64.8409 116.552 64.5739C116.552 64.267 116.478 64.0014 116.331 63.777C116.186 63.5526 115.987 63.3793 115.734 63.2571C115.481 63.1349 115.197 63.0739 114.882 63.0739C114.547 63.0739 114.254 63.1435 114.004 63.2827C113.757 63.419 113.565 63.6108 113.429 63.858C113.295 64.1051 113.228 64.3949 113.228 64.7273H112.223C112.223 64.2159 112.341 63.767 112.576 63.3807C112.812 62.9943 113.133 62.6932 113.539 62.4773C113.949 62.2614 114.407 62.1534 114.916 62.1534C115.427 62.1534 115.88 62.2614 116.275 62.4773C116.67 62.6932 116.98 62.9844 117.204 63.3509C117.429 63.7173 117.541 64.125 117.541 64.5739C117.541 64.8949 117.483 65.2088 117.366 65.5156C117.252 65.8196 117.054 66.1591 116.77 66.5341C116.488 66.9062 116.098 67.3608 115.598 67.8977L113.637 69.9943V70.0625H117.694V71H112.189ZM122.25 71.1193C121.664 71.1193 121.147 71.0156 120.699 70.8082C120.252 70.598 119.904 70.3097 119.654 69.9432C119.404 69.5739 119.281 69.1534 119.284 68.6818C119.281 68.3125 119.353 67.9716 119.501 67.6591C119.649 67.3437 119.85 67.081 120.106 66.8707C120.365 66.6577 120.653 66.5227 120.971 66.4659V66.4148C120.554 66.3068 120.221 66.0724 119.974 65.7116C119.727 65.348 119.605 64.9347 119.608 64.4716C119.605 64.0284 119.717 63.6321 119.944 63.2827C120.172 62.9332 120.484 62.6577 120.882 62.456C121.282 62.2543 121.738 62.1534 122.25 62.1534C122.755 62.1534 123.207 62.2543 123.605 62.456C124.002 62.6577 124.315 62.9332 124.542 63.2827C124.772 63.6321 124.889 64.0284 124.892 64.4716C124.889 64.9347 124.762 65.348 124.512 65.7116C124.265 66.0724 123.937 66.3068 123.528 66.4148V66.4659C123.843 66.5227 124.127 66.6577 124.38 66.8707C124.633 67.081 124.835 67.3437 124.985 67.6591C125.136 67.9716 125.213 68.3125 125.216 68.6818C125.213 69.1534 125.085 69.5739 124.832 69.9432C124.582 70.3097 124.234 70.598 123.788 70.8082C123.345 71.0156 122.832 71.1193 122.25 71.1193ZM122.25 70.1818C122.645 70.1818 122.985 70.1179 123.272 69.9901C123.559 69.8622 123.781 69.6818 123.937 69.4489C124.093 69.2159 124.173 68.9432 124.176 68.6307C124.173 68.3011 124.088 68.0099 123.92 67.7571C123.752 67.5043 123.524 67.3054 123.234 67.1605C122.947 67.0156 122.619 66.9432 122.25 66.9432C121.877 66.9432 121.545 67.0156 121.252 67.1605C120.963 67.3054 120.734 67.5043 120.566 67.7571C120.402 68.0099 120.321 68.3011 120.324 68.6307C120.321 68.9432 120.396 69.2159 120.549 69.4489C120.706 69.6818 120.929 69.8622 121.218 69.9901C121.508 70.1179 121.852 70.1818 122.25 70.1818ZM122.25 66.0398C122.562 66.0398 122.839 65.9773 123.081 65.8523C123.325 65.7273 123.517 65.5526 123.656 65.3281C123.795 65.1037 123.866 64.8409 123.869 64.5398C123.866 64.2443 123.797 63.9872 123.66 63.7685C123.524 63.5469 123.335 63.3764 123.093 63.2571C122.852 63.1349 122.571 63.0739 122.25 63.0739C121.923 63.0739 121.637 63.1349 121.393 63.2571C121.149 63.3764 120.96 63.5469 120.826 63.7685C120.693 63.9872 120.627 64.2443 120.63 64.5398C120.627 64.8409 120.694 65.1037 120.831 65.3281C120.97 65.5526 121.162 65.7273 121.406 65.8523C121.65 65.9773 121.931 66.0398 122.25 66.0398Z"
            fill="#6B6D76"
          />
          <Logo5GHZ />
        </svg>
      );
    default:
      return;
  }
};
