-- mods/default/legacy.lua
local is_54 = minetest.has_feature("direct_velocity_on_players") or false

-- Horrible stuff to support old code registering falling nodes
-- Don't use this and never do what this does, it's completely wrong!
-- (More specifically, the client and the C++ code doesn't get the group)
function default.register_falling_node(nodename, texture)
	minetest.log("error", debug.traceback())
	minetest.log('error', "WARNING: default.register_falling_node is deprecated")
	if minetest.registered_nodes[nodename] then
		minetest.registered_nodes[nodename].groups.falling_node = 1
	end
end

function default.spawn_falling_node(p, nodename)
	spawn_falling_node(p, nodename)
end

-- Liquids
WATER_ALPHA = minetest.registered_nodes["default:water_source"].alpha or true
WATER_VISC = minetest.registered_nodes["default:water_source"].liquid_viscosity
LAVA_VISC = minetest.registered_nodes["default:lava_source"].liquid_viscosity
LIGHT_MAX = default.LIGHT_MAX
if is_54 then WATER_ALPHA = minetest.registered_nodes["default:water_source"].use_texture_alpha or "opaque" end

-- Formspecs
default.gui_suvival_form = default.gui_survival_form
default.gui_bg     = ""
default.gui_bg_img = ""
default.gui_slots  = ""

-- Players
if minetest.get_modpath("player_api") then
	default.registered_player_models = player_api.registered_models
	default.player_register_model    = player_api.register_model
	default.player_attached          = player_api.player_attached
	default.player_get_animation     = player_api.get_animation
	default.player_set_model         = player_api.set_model
	default.player_set_textures      = player_api.set_textures
	default.player_set_animation     = player_api.set_animation
else
	player_api = {}
	player_api.registered_models = default.registered_player_models
	player_api.register_model = default.player_register_model
	player_api.player_attached = default.player_attached
	player_api.get_animation = default.player_get_animation
	player_api.set_model = default.player_set_model
	player_api.set_textures = default.player_set_textures
	player_api.set_animation = default.player_set_animation
end

-- Check for a volume intersecting protection
if minetest.is_area_protected then
	function default.intersects_protection(minp, maxp, player_name, interval)
		minetest.log("warning", "default.intersects_protection() is " ..
			"deprecated, use minetest.is_area_protected() instead.")
		return minetest.is_area_protected(minp, maxp, player_name, interval)
	end
end
