﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/pipes/model/CloudwatchLogsLogDestinationParameters.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace Pipes
{
namespace Model
{

CloudwatchLogsLogDestinationParameters::CloudwatchLogsLogDestinationParameters(JsonView jsonValue)
{
  *this = jsonValue;
}

CloudwatchLogsLogDestinationParameters& CloudwatchLogsLogDestinationParameters::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("LogGroupArn"))
  {
    m_logGroupArn = jsonValue.GetString("LogGroupArn");
    m_logGroupArnHasBeenSet = true;
  }
  return *this;
}

JsonValue CloudwatchLogsLogDestinationParameters::Jsonize() const
{
  JsonValue payload;

  if(m_logGroupArnHasBeenSet)
  {
   payload.WithString("LogGroupArn", m_logGroupArn);

  }

  return payload;
}

} // namespace Model
} // namespace Pipes
} // namespace Aws
