﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/s3control/S3ControlEndpointRules.h>
#include <aws/core/utils/memory/stl/AWSArray.h>

namespace Aws
{
namespace S3Control
{
const size_t S3ControlEndpointRules::RulesBlobStrLen = 31357;
const size_t S3ControlEndpointRules::RulesBlobSize = 31358;

using RulesBlobT = Aws::Array<const char, S3ControlEndpointRules::RulesBlobSize>;
static constexpr RulesBlobT RulesBlob = {{
'{','"','v','e','r','s','i','o','n','"',':','"','1','.','0','"',',','"','p','a','r','a','m','e','t',
'e','r','s','"',':','{','"','R','e','g','i','o','n','"',':','{','"','b','u','i','l','t','I','n','"',
':','"','A','W','S',':',':','R','e','g','i','o','n','"',',','"','r','e','q','u','i','r','e','d','"',
':','f','a','l','s','e',',','"','d','o','c','u','m','e','n','t','a','t','i','o','n','"',':','"','T',
'h','e',' ','A','W','S',' ','r','e','g','i','o','n',' ','u','s','e','d',' ','t','o',' ','d','i','s',
'p','a','t','c','h',' ','t','h','e',' ','r','e','q','u','e','s','t','.','"',',','"','t','y','p','e',
'"',':','"','S','t','r','i','n','g','"','}',',','"','U','s','e','F','I','P','S','"',':','{','"','b',
'u','i','l','t','I','n','"',':','"','A','W','S',':',':','U','s','e','F','I','P','S','"',',','"','r',
'e','q','u','i','r','e','d','"',':','t','r','u','e',',','"','d','e','f','a','u','l','t','"',':','f',
'a','l','s','e',',','"','d','o','c','u','m','e','n','t','a','t','i','o','n','"',':','"','W','h','e',
'n',' ','t','r','u','e',',',' ','s','e','n','d',' ','t','h','i','s',' ','r','e','q','u','e','s','t',
' ','t','o',' ','t','h','e',' ','F','I','P','S','-','c','o','m','p','l','i','a','n','t',' ','r','e',
'g','i','o','n','a','l',' ','e','n','d','p','o','i','n','t','.',' ','I','f',' ','t','h','e',' ','c',
'o','n','f','i','g','u','r','e','d',' ','e','n','d','p','o','i','n','t',' ','d','o','e','s',' ','n',
'o','t',' ','h','a','v','e',' ','a',' ','F','I','P','S',' ','c','o','m','p','l','i','a','n','t',' ',
'e','n','d','p','o','i','n','t',',',' ','d','i','s','p','a','t','c','h','i','n','g',' ','t','h','e',
' ','r','e','q','u','e','s','t',' ','w','i','l','l',' ','r','e','t','u','r','n',' ','a','n',' ','e',
'r','r','o','r','.','"',',','"','t','y','p','e','"',':','"','B','o','o','l','e','a','n','"','}',',',
'"','U','s','e','D','u','a','l','S','t','a','c','k','"',':','{','"','b','u','i','l','t','I','n','"',
':','"','A','W','S',':',':','U','s','e','D','u','a','l','S','t','a','c','k','"',',','"','r','e','q',
'u','i','r','e','d','"',':','t','r','u','e',',','"','d','e','f','a','u','l','t','"',':','f','a','l',
's','e',',','"','d','o','c','u','m','e','n','t','a','t','i','o','n','"',':','"','W','h','e','n',' ',
't','r','u','e',',',' ','u','s','e',' ','t','h','e',' ','d','u','a','l','-','s','t','a','c','k',' ',
'e','n','d','p','o','i','n','t','.',' ','I','f',' ','t','h','e',' ','c','o','n','f','i','g','u','r',
'e','d',' ','e','n','d','p','o','i','n','t',' ','d','o','e','s',' ','n','o','t',' ','s','u','p','p',
'o','r','t',' ','d','u','a','l','-','s','t','a','c','k',',',' ','d','i','s','p','a','t','c','h','i',
'n','g',' ','t','h','e',' ','r','e','q','u','e','s','t',' ','M','A','Y',' ','r','e','t','u','r','n',
' ','a','n',' ','e','r','r','o','r','.','"',',','"','t','y','p','e','"',':','"','B','o','o','l','e',
'a','n','"','}',',','"','E','n','d','p','o','i','n','t','"',':','{','"','b','u','i','l','t','I','n',
'"',':','"','S','D','K',':',':','E','n','d','p','o','i','n','t','"',',','"','r','e','q','u','i','r',
'e','d','"',':','f','a','l','s','e',',','"','d','o','c','u','m','e','n','t','a','t','i','o','n','"',
':','"','O','v','e','r','r','i','d','e',' ','t','h','e',' ','e','n','d','p','o','i','n','t',' ','u',
's','e','d',' ','t','o',' ','s','e','n','d',' ','t','h','i','s',' ','r','e','q','u','e','s','t','"',
',','"','t','y','p','e','"',':','"','S','t','r','i','n','g','"','}',',','"','A','c','c','o','u','n',
't','I','d','"',':','{','"','r','e','q','u','i','r','e','d','"',':','f','a','l','s','e',',','"','d',
'o','c','u','m','e','n','t','a','t','i','o','n','"',':','"','T','h','e',' ','A','c','c','o','u','n',
't',' ','I','D',' ','u','s','e','d',' ','t','o',' ','s','e','n','d',' ','t','h','e',' ','r','e','q',
'u','e','s','t','.',' ','T','h','i','s',' ','i','s',' ','a','n',' ','o','p','t','i','o','n','a','l',
' ','p','a','r','a','m','e','t','e','r',' ','t','h','a','t',' ','w','i','l','l',' ','b','e',' ','s',
'e','t',' ','a','u','t','o','m','a','t','i','c','a','l','l','y',' ','f','o','r',' ','o','p','e','r',
'a','t','i','o','n','s',' ','t','h','a','t',' ','r','e','q','u','i','r','e',' ','i','t','.','"',',',
'"','t','y','p','e','"',':','"','S','t','r','i','n','g','"','}',',','"','R','e','q','u','i','r','e',
's','A','c','c','o','u','n','t','I','d','"',':','{','"','r','e','q','u','i','r','e','d','"',':','f',
'a','l','s','e',',','"','d','o','c','u','m','e','n','t','a','t','i','o','n','"',':','"','I','n','t',
'e','r','n','a','l',' ','p','a','r','a','m','e','t','e','r',' ','f','o','r',' ','o','p','e','r','a',
't','i','o','n','s',' ','t','h','a','t',' ','r','e','q','u','i','r','e',' ','a','c','c','o','u','n',
't',' ','i','d',' ','h','o','s','t',' ','p','r','e','f','i','x','.','"',',','"','t','y','p','e','"',
':','"','B','o','o','l','e','a','n','"','}',',','"','O','u','t','p','o','s','t','I','d','"',':','{',
'"','r','e','q','u','i','r','e','d','"',':','f','a','l','s','e',',','"','d','o','c','u','m','e','n',
't','a','t','i','o','n','"',':','"','T','h','e',' ','O','u','t','p','o','s','t',' ','I','D','.',' ',
' ','S','o','m','e',' ','o','p','e','r','a','t','i','o','n','s',' ','h','a','v','e',' ','a','n',' ',
'o','p','t','i','o','n','a','l',' ','O','u','t','p','o','s','t','I','d',' ','w','h','i','c','h',' ',
's','h','o','u','l','d',' ','b','e',' ','u','s','e','d',' ','i','n',' ','e','n','d','p','o','i','n',
't',' ','c','o','n','s','t','r','u','c','t','i','o','n','.','"',',','"','t','y','p','e','"',':','"',
'S','t','r','i','n','g','"','}',',','"','B','u','c','k','e','t','"',':','{','"','r','e','q','u','i',
'r','e','d','"',':','f','a','l','s','e',',','"','d','o','c','u','m','e','n','t','a','t','i','o','n',
'"',':','"','T','h','e',' ','S','3',' ','b','u','c','k','e','t',' ','u','s','e','d',' ','t','o',' ',
's','e','n','d',' ','t','h','e',' ','r','e','q','u','e','s','t','.',' ','T','h','i','s',' ','i','s',
' ','a','n',' ','o','p','t','i','o','n','a','l',' ','p','a','r','a','m','e','t','e','r',' ','t','h',
'a','t',' ','w','i','l','l',' ','b','e',' ','s','e','t',' ','a','u','t','o','m','a','t','i','c','a',
'l','l','y',' ','f','o','r',' ','o','p','e','r','a','t','i','o','n','s',' ','t','h','a','t',' ','a',
'r','e',' ','s','c','o','p','e','d',' ','t','o',' ','a','n',' ','S','3',' ','b','u','c','k','e','t',
'.','"',',','"','t','y','p','e','"',':','"','S','t','r','i','n','g','"','}',',','"','A','c','c','e',
's','s','P','o','i','n','t','N','a','m','e','"',':','{','"','r','e','q','u','i','r','e','d','"',':',
'f','a','l','s','e',',','"','d','o','c','u','m','e','n','t','a','t','i','o','n','"',':','"','T','h',
'e',' ','S','3',' ','A','c','c','e','s','s','P','o','i','n','t','N','a','m','e',' ','u','s','e','d',
' ','t','o',' ','s','e','n','d',' ','t','h','e',' ','r','e','q','u','e','s','t','.',' ','T','h','i',
's',' ','i','s',' ','a','n',' ','o','p','t','i','o','n','a','l',' ','p','a','r','a','m','e','t','e',
'r',' ','t','h','a','t',' ','w','i','l','l',' ','b','e',' ','s','e','t',' ','a','u','t','o','m','a',
't','i','c','a','l','l','y',' ','f','o','r',' ','o','p','e','r','a','t','i','o','n','s',' ','t','h',
'a','t',' ','a','r','e',' ','s','c','o','p','e','d',' ','t','o',' ','a','n',' ','S','3',' ','A','c',
'c','e','s','s','P','o','i','n','t','.','"',',','"','t','y','p','e','"',':','"','S','t','r','i','n',
'g','"','}',',','"','U','s','e','A','r','n','R','e','g','i','o','n','"',':','{','"','b','u','i','l',
't','I','n','"',':','"','A','W','S',':',':','S','3','C','o','n','t','r','o','l',':',':','U','s','e',
'A','r','n','R','e','g','i','o','n','"',',','"','r','e','q','u','i','r','e','d','"',':','f','a','l',
's','e',',','"','d','o','c','u','m','e','n','t','a','t','i','o','n','"',':','"','W','h','e','n',' ',
'a','n',' ','A','c','c','e','s','s',' ','P','o','i','n','t',' ','A','R','N',' ','i','s',' ','p','r',
'o','v','i','d','e','d',' ','a','n','d',' ','t','h','i','s',' ','f','l','a','g',' ','i','s',' ','e',
'n','a','b','l','e','d',',',' ','t','h','e',' ','S','D','K',' ','M','U','S','T',' ','u','s','e',' ',
't','h','e',' ','A','R','N','\'','s',' ','r','e','g','i','o','n',' ','w','h','e','n',' ','c','o','n',
's','t','r','u','c','t','i','n','g',' ','t','h','e',' ','e','n','d','p','o','i','n','t',' ','i','n',
's','t','e','a','d',' ','o','f',' ','t','h','e',' ','c','l','i','e','n','t','\'','s',' ','c','o','n',
'f','i','g','u','r','e','d',' ','r','e','g','i','o','n','.','"',',','"','t','y','p','e','"',':','"',
'B','o','o','l','e','a','n','"','}',',','"','U','s','e','S','3','E','x','p','r','e','s','s','C','o',
'n','t','r','o','l','E','n','d','p','o','i','n','t','"',':','{','"','r','e','q','u','i','r','e','d',
'"',':','f','a','l','s','e',',','"','d','o','c','u','m','e','n','t','a','t','i','o','n','"',':','"',
'I','n','t','e','r','n','a','l',' ','p','a','r','a','m','e','t','e','r',' ','t','o',' ','i','n','d',
'i','c','a','t','e',' ','w','h','e','t','h','e','r',' ','S','3','E','x','p','r','e','s','s',' ','o',
'p','e','r','a','t','i','o','n',' ','s','h','o','u','l','d',' ','u','s','e',' ','c','o','n','t','r',
'o','l',' ','p','l','a','n','e',',',' ','(','e','x','.',' ','L','i','s','t','D','i','r','e','c','t',
'o','r','y','A','c','c','e','s','s','P','o','i','n','t','s',')','"',',','"','t','y','p','e','"',':',
'"','B','o','o','l','e','a','n','"','}','}',',','"','r','u','l','e','s','"',':','[','{','"','c','o',
'n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','i','s','S','e','t','"',',',
'"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','R','e','g','i','o','n','"','}',']',
'}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',
':','[','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"',
'a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','F','I','P','S','"','}',',',
't','r','u','e',']','}',',','{','"','f','n','"',':','"','a','w','s','.','p','a','r','t','i','t','i',
'o','n','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','R','e','g','i','o',
'n','"','}',']',',','"','a','s','s','i','g','n','"',':','"','p','a','r','t','i','t','i','o','n','R',
'e','s','u','l','t','"','}',',','{','"','f','n','"',':','"','s','t','r','i','n','g','E','q','u','a',
'l','s','"',',','"','a','r','g','v','"',':','[','{','"','f','n','"',':','"','g','e','t','A','t','t',
'r','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','p','a','r','t','i','t',
'i','o','n','R','e','s','u','l','t','"','}',',','"','n','a','m','e','"',']','}',',','"','a','w','s',
'-','c','n','"',']','}',']',',','"','e','r','r','o','r','"',':','"','P','a','r','t','i','t','i','o',
'n',' ','d','o','e','s',' ','n','o','t',' ','s','u','p','p','o','r','t',' ','F','I','P','S','"',',',
'"','t','y','p','e','"',':','"','e','r','r','o','r','"','}',',','{','"','c','o','n','d','i','t','i',
'o','n','s','"',':','[','{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v',
'"',':','[','{','"','r','e','f','"',':','"','O','u','t','p','o','s','t','I','d','"','}',']','}',']',
',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',
'{','"','f','n','"',':','"','a','w','s','.','p','a','r','t','i','t','i','o','n','"',',','"','a','r',
'g','v','"',':','[','{','"','r','e','f','"',':','"','R','e','g','i','o','n','"','}',']',',','"','a',
's','s','i','g','n','"',':','"','p','a','r','t','i','t','i','o','n','R','e','s','u','l','t','"','}',
']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':',
'[','{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"',
'r','e','f','"',':','"','R','e','q','u','i','r','e','s','A','c','c','o','u','n','t','I','d','"','}',
']','}',',','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',',
'"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','R','e','q','u','i','r','e','s','A',
'c','c','o','u','n','t','I','d','"','}',',','t','r','u','e',']','}',',','{','"','f','n','"',':','"',
'n','o','t','"',',','"','a','r','g','v','"',':','[','{','"','f','n','"',':','"','i','s','S','e','t',
'"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','A','c','c','o','u','n','t',
'I','d','"','}',']','}',']','}',']',',','"','e','r','r','o','r','"',':','"','A','c','c','o','u','n',
't','I','d',' ','i','s',' ','r','e','q','u','i','r','e','d',' ','b','u','t',' ','n','o','t',' ','s',
'e','t','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r','"','}',',','{','"','c','o','n',
'd','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','i','s','S','e','t','"',',','"',
'a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','A','c','c','o','u','n','t','I','d','"',
'}',']','}',',','{','"','f','n','"',':','"','n','o','t','"',',','"','a','r','g','v','"',':','[','{',
'"','f','n','"',':','"','i','s','V','a','l','i','d','H','o','s','t','L','a','b','e','l','"',',','"',
'a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','A','c','c','o','u','n','t','I','d','"',
'}',',','f','a','l','s','e',']','}',']','}',']',',','"','e','r','r','o','r','"',':','"','A','c','c',
'o','u','n','t','I','d',' ','m','u','s','t',' ','o','n','l','y',' ','c','o','n','t','a','i','n',' ',
'a','-','z',',',' ','A','-','Z',',',' ','0','-','9',' ','a','n','d',' ','`','-','`','.','"',',','"',
't','y','p','e','"',':','"','e','r','r','o','r','"','}',',','{','"','c','o','n','d','i','t','i','o',
'n','s','"',':','[','{','"','f','n','"',':','"','n','o','t','"',',','"','a','r','g','v','"',':','[',
'{','"','f','n','"',':','"','i','s','V','a','l','i','d','H','o','s','t','L','a','b','e','l','"',',',
'"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','O','u','t','p','o','s','t','I','d',
'"','}',',','f','a','l','s','e',']','}',']','}',']',',','"','e','r','r','o','r','"',':','"','O','u',
't','p','o','s','t','I','d',' ','m','u','s','t',' ','o','n','l','y',' ','c','o','n','t','a','i','n',
' ','a','-','z',',',' ','A','-','Z',',',' ','0','-','9',' ','a','n','d',' ','`','-','`','.','"',',',
'"','t','y','p','e','"',':','"','e','r','r','o','r','"','}',',','{','"','c','o','n','d','i','t','i',
'o','n','s','"',':','[','{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v',
'"',':','[','{','"','r','e','f','"',':','"','E','n','d','p','o','i','n','t','"','}',']','}',',','{',
'"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g',
'v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','D','u','a','l','S','t','a','c','k','"',
'}',',','t','r','u','e',']','}',']',',','"','e','r','r','o','r','"',':','"','I','n','v','a','l','i',
'd',' ','C','o','n','f','i','g','u','r','a','t','i','o','n',':',' ','D','u','a','l','S','t','a','c',
'k',' ','a','n','d',' ','c','u','s','t','o','m',' ','e','n','d','p','o','i','n','t',' ','a','r','e',
' ','n','o','t',' ','s','u','p','p','o','r','t','e','d','"',',','"','t','y','p','e','"',':','"','e',
'r','r','o','r','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f',
'n','"',':','"','i','s','V','a','l','i','d','H','o','s','t','L','a','b','e','l','"',',','"','a','r',
'g','v','"',':','[','{','"','r','e','f','"',':','"','R','e','g','i','o','n','"','}',',','t','r','u',
'e',']','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n',
's','"',':','[','{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',':',
'[','{','"','r','e','f','"',':','"','E','n','d','p','o','i','n','t','"','}',']','}',',','{','"','f',
'n','"',':','"','p','a','r','s','e','U','R','L','"',',','"','a','r','g','v','"',':','[','{','"','r',
'e','f','"',':','"','E','n','d','p','o','i','n','t','"','}',']',',','"','a','s','s','i','g','n','"',
':','"','u','r','l','"','}',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l',
'"',':','"','{','u','r','l','#','s','c','h','e','m','e','}',':','/','/','{','u','r','l','#','a','u',
't','h','o','r','i','t','y','}','{','u','r','l','#','p','a','t','h','}','"',',','"','p','r','o','p',
'e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[','{',
'"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':','t',
'r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n','i',
'n','g','N','a','m','e','"',':','"','s','3','-','o','u','t','p','o','s','t','s','"',',','"','s','i',
'g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','R','e','g','i','o','n','}','"','}',']',
'}',',','"','h','e','a','d','e','r','s','"',':','{','}','}',',','"','t','y','p','e','"',':','"','e',
'n','d','p','o','i','n','t','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',
'{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r',
'g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','F','I','P','S','"','}',',','t','r',
'u','e',']','}',',','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s',
'"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','D','u','a','l',
'S','t','a','c','k','"','}',',','t','r','u','e',']','}',']',',','"','e','n','d','p','o','i','n','t',
'"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/','s','3','-','o','u','t','p',
'o','s','t','s','-','f','i','p','s','.','{','R','e','g','i','o','n','}','.','{','p','a','r','t','i',
't','i','o','n','R','e','s','u','l','t','#','d','u','a','l','S','t','a','c','k','D','n','s','S','u',
'f','f','i','x','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t',
'h','S','c','h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l',
'e','E','n','c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s',
'i','g','v','4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','-','o',
'u','t','p','o','s','t','s','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':',
'"','{','R','e','g','i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{',
'}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',',','{','"','c',
'o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','b','o','o','l','e','a',
'n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"',
'U','s','e','F','I','P','S','"','}',',','t','r','u','e',']','}',']',',','"','e','n','d','p','o','i',
'n','t','"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/','s','3','-','o','u',
't','p','o','s','t','s','-','f','i','p','s','.','{','R','e','g','i','o','n','}','.','{','p','a','r',
't','i','t','i','o','n','R','e','s','u','l','t','#','d','n','s','S','u','f','f','i','x','}','"',',',
'"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e',
's','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i',
'n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"',
's','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','-','o','u','t','p','o','s','t','s',
'"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','R','e','g','i','o',
'n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','}','}',',','"','t','y','p',
'e','"',':','"','e','n','d','p','o','i','n','t','"','}',',','{','"','c','o','n','d','i','t','i','o',
'n','s','"',':','[','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s',
'"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','D','u','a','l',
'S','t','a','c','k','"','}',',','t','r','u','e',']','}',']',',','"','e','n','d','p','o','i','n','t',
'"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/','s','3','-','o','u','t','p',
'o','s','t','s','.','{','R','e','g','i','o','n','}','.','{','p','a','r','t','i','t','i','o','n','R',
'e','s','u','l','t','#','d','u','a','l','S','t','a','c','k','D','n','s','S','u','f','f','i','x','}',
'"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c','h','e',
'm','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n','c','o',
'd','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',
',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','-','o','u','t','p','o','s',
't','s','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','R','e','g',
'i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','}','}',',','"','t',
'y','p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',',','{','"','c','o','n','d','i','t',
'i','o','n','s','"',':','[',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l',
'"',':','"','h','t','t','p','s',':','/','/','s','3','-','o','u','t','p','o','s','t','s','.','{','R',
'e','g','i','o','n','}','.','{','p','a','r','t','i','t','i','o','n','R','e','s','u','l','t','#','d',
'n','s','S','u','f','f','i','x','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{',
'"','a','u','t','h','S','c','h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D',
'o','u','b','l','e','E','n','c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e',
'"',':','"','s','i','g','v','4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"',
's','3','-','o','u','t','p','o','s','t','s','"',',','"','s','i','g','n','i','n','g','R','e','g','i',
'o','n','"',':','"','{','R','e','g','i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r',
's','"',':','{','}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',
']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',',','{','"','c','o','n','d','i','t',
'i','o','n','s','"',':','[',']',',','"','e','r','r','o','r','"',':','"','I','n','v','a','l','i','d',
' ','r','e','g','i','o','n',':',' ','r','e','g','i','o','n',' ','w','a','s',' ','n','o','t',' ','a',
' ','v','a','l','i','d',' ','D','N','S',' ','n','a','m','e','.','"',',','"','t','y','p','e','"',':',
'"','e','r','r','o','r','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',']',
',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',',','{','"','c','o','n','d','i','t','i',
'o','n','s','"',':','[','{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v',
'"',':','[','{','"','r','e','f','"',':','"','A','c','c','e','s','s','P','o','i','n','t','N','a','m',
'e','"','}',']','}',',','{','"','f','n','"',':','"','s','u','b','s','t','r','i','n','g','"',',','"',
'a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','A','c','c','e','s','s','P','o','i','n',
't','N','a','m','e','"','}',',','0',',','7',',','t','r','u','e',']',',','"','a','s','s','i','g','n',
'"',':','"','a','c','c','e','s','s','P','o','i','n','t','S','u','f','f','i','x','"','}',',','{','"',
'f','n','"',':','"','s','t','r','i','n','g','E','q','u','a','l','s','"',',','"','a','r','g','v','"',
':','[','{','"','r','e','f','"',':','"','a','c','c','e','s','s','P','o','i','n','t','S','u','f','f',
'i','x','"','}',',','"','-','-','x','a','-','s','3','"',']','}',']',',','"','r','u','l','e','s','"',
':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','a',
'w','s','.','p','a','r','t','i','t','i','o','n','"',',','"','a','r','g','v','"',':','[','{','"','r',
'e','f','"',':','"','R','e','g','i','o','n','"','}',']',',','"','a','s','s','i','g','n','"',':','"',
'p','a','r','t','i','t','i','o','n','R','e','s','u','l','t','"','}',']',',','"','r','u','l','e','s',
'"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"',
'i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','E','n',
'd','p','o','i','n','t','"','}',']','}',',','{','"','f','n','"',':','"','b','o','o','l','e','a','n',
'E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U',
's','e','D','u','a','l','S','t','a','c','k','"','}',',','t','r','u','e',']','}',']',',','"','e','r',
'r','o','r','"',':','"','I','n','v','a','l','i','d',' ','C','o','n','f','i','g','u','r','a','t','i',
'o','n',':',' ','D','u','a','l','S','t','a','c','k',' ','a','n','d',' ','c','u','s','t','o','m',' ',
'e','n','d','p','o','i','n','t',' ','a','r','e',' ','n','o','t',' ','s','u','p','p','o','r','t','e',
'd','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r','"','}',',','{','"','c','o','n','d',
'i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q',
'u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e',
'D','u','a','l','S','t','a','c','k','"','}',',','t','r','u','e',']','}',']',',','"','e','r','r','o',
'r','"',':','"','S','3','E','x','p','r','e','s','s',' ','d','o','e','s',' ','n','o','t',' ','s','u',
'p','p','o','r','t',' ','D','u','a','l','-','s','t','a','c','k','.','"',',','"','t','y','p','e','"',
':','"','e','r','r','o','r','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',
'{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r',
'e','f','"',':','"','E','n','d','p','o','i','n','t','"','}',']','}',',','{','"','f','n','"',':','"',
'p','a','r','s','e','U','R','L','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':',
'"','E','n','d','p','o','i','n','t','"','}',']',',','"','a','s','s','i','g','n','"',':','"','u','r',
'l','"','}',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"','{',
'u','r','l','#','s','c','h','e','m','e','}',':','/','/','{','u','r','l','#','a','u','t','h','o','r',
'i','t','y','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h',
'S','c','h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e',
'E','n','c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i',
'g','v','4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','e','x','p',
'r','e','s','s','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','R',
'e','g','i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','}','}',',',
'"','t','y','p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',',','{','"','c','o','n','d',
'i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','s','u','b','s','t','r','i','n','g',
'"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','A','c','c','e','s','s','P',
'o','i','n','t','N','a','m','e','"','}',',','7',',','1','5',',','t','r','u','e',']',',','"','a','s',
's','i','g','n','"',':','"','s','3','e','x','p','r','e','s','s','A','v','a','i','l','a','b','i','l',
'i','t','y','Z','o','n','e','I','d','"','}',',','{','"','f','n','"',':','"','s','u','b','s','t','r',
'i','n','g','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','A','c','c','e',
's','s','P','o','i','n','t','N','a','m','e','"','}',',','1','5',',','1','7',',','t','r','u','e',']',
',','"','a','s','s','i','g','n','"',':','"','s','3','e','x','p','r','e','s','s','A','v','a','i','l',
'a','b','i','l','i','t','y','Z','o','n','e','D','e','l','i','m','"','}',',','{','"','f','n','"',':',
'"','s','t','r','i','n','g','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"',
'r','e','f','"',':','"','s','3','e','x','p','r','e','s','s','A','v','a','i','l','a','b','i','l','i',
't','y','Z','o','n','e','D','e','l','i','m','"','}',',','"','-','-','"',']','}',']',',','"','r','u',
'l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n',
'"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':',
'[','{','"','r','e','f','"',':','"','U','s','e','F','I','P','S','"','}',',','t','r','u','e',']','}',
']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"','h','t','t','p',
's',':','/','/','s','3','e','x','p','r','e','s','s','-','c','o','n','t','r','o','l','-','f','i','p',
's','.','{','R','e','g','i','o','n','}','.','{','p','a','r','t','i','t','i','o','n','R','e','s','u',
'l','t','#','d','n','s','S','u','f','f','i','x','}','"',',','"','p','r','o','p','e','r','t','i','e',
's','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[','{','"','d','i','s','a',
'b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':','t','r','u','e',',','"',
'n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n','i','n','g','N','a','m',
'e','"',':','"','s','3','e','x','p','r','e','s','s','"',',','"','s','i','g','n','i','n','g','R','e',
'g','i','o','n','"',':','"','{','R','e','g','i','o','n','}','"','}',']','}',',','"','h','e','a','d',
'e','r','s','"',':','{','}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i','n','t',
'"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','n','d','p',
'o','i','n','t','"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/','s','3','e',
'x','p','r','e','s','s','-','c','o','n','t','r','o','l','.','{','R','e','g','i','o','n','}','.','{',
'p','a','r','t','i','t','i','o','n','R','e','s','u','l','t','#','d','n','s','S','u','f','f','i','x',
'}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c','h',
'e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n','c',
'o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v','4',
'"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','e','x','p','r','e','s',
's','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','R','e','g','i',
'o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','}','}',',','"','t','y',
'p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',']',',','"','t','y','p','e','"',':','"',
't','r','e','e','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f',
'n','"',':','"','s','u','b','s','t','r','i','n','g','"',',','"','a','r','g','v','"',':','[','{','"',
'r','e','f','"',':','"','A','c','c','e','s','s','P','o','i','n','t','N','a','m','e','"','}',',','7',
',','1','6',',','t','r','u','e',']',',','"','a','s','s','i','g','n','"',':','"','s','3','e','x','p',
'r','e','s','s','A','v','a','i','l','a','b','i','l','i','t','y','Z','o','n','e','I','d','"','}',',',
'{','"','f','n','"',':','"','s','u','b','s','t','r','i','n','g','"',',','"','a','r','g','v','"',':',
'[','{','"','r','e','f','"',':','"','A','c','c','e','s','s','P','o','i','n','t','N','a','m','e','"',
'}',',','1','6',',','1','8',',','t','r','u','e',']',',','"','a','s','s','i','g','n','"',':','"','s',
'3','e','x','p','r','e','s','s','A','v','a','i','l','a','b','i','l','i','t','y','Z','o','n','e','D',
'e','l','i','m','"','}',',','{','"','f','n','"',':','"','s','t','r','i','n','g','E','q','u','a','l',
's','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','s','3','e','x','p','r',
'e','s','s','A','v','a','i','l','a','b','i','l','i','t','y','Z','o','n','e','D','e','l','i','m','"',
'}',',','"','-','-','"',']','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d',
'i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q',
'u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e',
'F','I','P','S','"','}',',','t','r','u','e',']','}',']',',','"','e','n','d','p','o','i','n','t','"',
':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/','s','3','e','x','p','r','e','s',
's','-','c','o','n','t','r','o','l','-','f','i','p','s','.','{','R','e','g','i','o','n','}','.','{',
'p','a','r','t','i','t','i','o','n','R','e','s','u','l','t','#','d','n','s','S','u','f','f','i','x',
'}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c','h',
'e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n','c',
'o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v','4',
'"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','e','x','p','r','e','s',
's','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','R','e','g','i',
'o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','}','}',',','"','t','y',
'p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',',','{','"','c','o','n','d','i','t','i',
'o','n','s','"',':','[',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',
':','"','h','t','t','p','s',':','/','/','s','3','e','x','p','r','e','s','s','-','c','o','n','t','r',
'o','l','.','{','R','e','g','i','o','n','}','.','{','p','a','r','t','i','t','i','o','n','R','e','s',
'u','l','t','#','d','n','s','S','u','f','f','i','x','}','"',',','"','p','r','o','p','e','r','t','i',
'e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[','{','"','d','i','s',
'a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':','t','r','u','e',',',
'"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n','i','n','g','N','a',
'm','e','"',':','"','s','3','e','x','p','r','e','s','s','"',',','"','s','i','g','n','i','n','g','R',
'e','g','i','o','n','"',':','"','{','R','e','g','i','o','n','}','"','}',']','}',',','"','h','e','a',
'd','e','r','s','"',':','{','}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i','n',
't','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',',','{','"','c','o','n',
'd','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','s','u','b','s','t','r','i','n',
'g','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','A','c','c','e','s','s',
'P','o','i','n','t','N','a','m','e','"','}',',','7',',','2','0',',','t','r','u','e',']',',','"','a',
's','s','i','g','n','"',':','"','s','3','e','x','p','r','e','s','s','A','v','a','i','l','a','b','i',
'l','i','t','y','Z','o','n','e','I','d','"','}',',','{','"','f','n','"',':','"','s','u','b','s','t',
'r','i','n','g','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','A','c','c',
'e','s','s','P','o','i','n','t','N','a','m','e','"','}',',','2','0',',','2','2',',','t','r','u','e',
']',',','"','a','s','s','i','g','n','"',':','"','s','3','e','x','p','r','e','s','s','A','v','a','i',
'l','a','b','i','l','i','t','y','Z','o','n','e','D','e','l','i','m','"','}',',','{','"','f','n','"',
':','"','s','t','r','i','n','g','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{',
'"','r','e','f','"',':','"','s','3','e','x','p','r','e','s','s','A','v','a','i','l','a','b','i','l',
'i','t','y','Z','o','n','e','D','e','l','i','m','"','}',',','"','-','-','"',']','}',']',',','"','r',
'u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f',
'n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',
':','[','{','"','r','e','f','"',':','"','U','s','e','F','I','P','S','"','}',',','t','r','u','e',']',
'}',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"','h','t','t',
'p','s',':','/','/','s','3','e','x','p','r','e','s','s','-','c','o','n','t','r','o','l','-','f','i',
'p','s','.','{','R','e','g','i','o','n','}','.','{','p','a','r','t','i','t','i','o','n','R','e','s',
'u','l','t','#','d','n','s','S','u','f','f','i','x','}','"',',','"','p','r','o','p','e','r','t','i',
'e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[','{','"','d','i','s',
'a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':','t','r','u','e',',',
'"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n','i','n','g','N','a',
'm','e','"',':','"','s','3','e','x','p','r','e','s','s','"',',','"','s','i','g','n','i','n','g','R',
'e','g','i','o','n','"',':','"','{','R','e','g','i','o','n','}','"','}',']','}',',','"','h','e','a',
'd','e','r','s','"',':','{','}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i','n',
't','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','n','d',
'p','o','i','n','t','"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/','s','3',
'e','x','p','r','e','s','s','-','c','o','n','t','r','o','l','.','{','R','e','g','i','o','n','}','.',
'{','p','a','r','t','i','t','i','o','n','R','e','s','u','l','t','#','d','n','s','S','u','f','f','i',
'x','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c',
'h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n',
'c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v',
'4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','e','x','p','r','e',
's','s','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','R','e','g',
'i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','}','}',',','"','t',
'y','p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',']',',','"','t','y','p','e','"',':',
'"','t','r','e','e','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"',
'f','n','"',':','"','s','u','b','s','t','r','i','n','g','"',',','"','a','r','g','v','"',':','[','{',
'"','r','e','f','"',':','"','A','c','c','e','s','s','P','o','i','n','t','N','a','m','e','"','}',',',
'7',',','2','1',',','t','r','u','e',']',',','"','a','s','s','i','g','n','"',':','"','s','3','e','x',
'p','r','e','s','s','A','v','a','i','l','a','b','i','l','i','t','y','Z','o','n','e','I','d','"','}',
',','{','"','f','n','"',':','"','s','u','b','s','t','r','i','n','g','"',',','"','a','r','g','v','"',
':','[','{','"','r','e','f','"',':','"','A','c','c','e','s','s','P','o','i','n','t','N','a','m','e',
'"','}',',','2','1',',','2','3',',','t','r','u','e',']',',','"','a','s','s','i','g','n','"',':','"',
's','3','e','x','p','r','e','s','s','A','v','a','i','l','a','b','i','l','i','t','y','Z','o','n','e',
'D','e','l','i','m','"','}',',','{','"','f','n','"',':','"','s','t','r','i','n','g','E','q','u','a',
'l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','s','3','e','x','p',
'r','e','s','s','A','v','a','i','l','a','b','i','l','i','t','y','Z','o','n','e','D','e','l','i','m',
'"','}',',','"','-','-','"',']','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n',
'd','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E',
'q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s',
'e','F','I','P','S','"','}',',','t','r','u','e',']','}',']',',','"','e','n','d','p','o','i','n','t',
'"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/','s','3','e','x','p','r','e',
's','s','-','c','o','n','t','r','o','l','-','f','i','p','s','.','{','R','e','g','i','o','n','}','.',
'{','p','a','r','t','i','t','i','o','n','R','e','s','u','l','t','#','d','n','s','S','u','f','f','i',
'x','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c',
'h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n',
'c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v',
'4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','e','x','p','r','e',
's','s','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','R','e','g',
'i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','}','}',',','"','t',
'y','p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',',','{','"','c','o','n','d','i','t',
'i','o','n','s','"',':','[',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l',
'"',':','"','h','t','t','p','s',':','/','/','s','3','e','x','p','r','e','s','s','-','c','o','n','t',
'r','o','l','.','{','R','e','g','i','o','n','}','.','{','p','a','r','t','i','t','i','o','n','R','e',
's','u','l','t','#','d','n','s','S','u','f','f','i','x','}','"',',','"','p','r','o','p','e','r','t',
'i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[','{','"','d','i',
's','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':','t','r','u','e',
',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n','i','n','g','N',
'a','m','e','"',':','"','s','3','e','x','p','r','e','s','s','"',',','"','s','i','g','n','i','n','g',
'R','e','g','i','o','n','"',':','"','{','R','e','g','i','o','n','}','"','}',']','}',',','"','h','e',
'a','d','e','r','s','"',':','{','}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i',
'n','t','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',',','{','"','c','o',
'n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','s','u','b','s','t','r','i',
'n','g','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','A','c','c','e','s',
's','P','o','i','n','t','N','a','m','e','"','}',',','7',',','2','7',',','t','r','u','e',']',',','"',
'a','s','s','i','g','n','"',':','"','s','3','e','x','p','r','e','s','s','A','v','a','i','l','a','b',
'i','l','i','t','y','Z','o','n','e','I','d','"','}',',','{','"','f','n','"',':','"','s','u','b','s',
't','r','i','n','g','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','A','c',
'c','e','s','s','P','o','i','n','t','N','a','m','e','"','}',',','2','7',',','2','9',',','t','r','u',
'e',']',',','"','a','s','s','i','g','n','"',':','"','s','3','e','x','p','r','e','s','s','A','v','a',
'i','l','a','b','i','l','i','t','y','Z','o','n','e','D','e','l','i','m','"','}',',','{','"','f','n',
'"',':','"','s','t','r','i','n','g','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[',
'{','"','r','e','f','"',':','"','s','3','e','x','p','r','e','s','s','A','v','a','i','l','a','b','i',
'l','i','t','y','Z','o','n','e','D','e','l','i','m','"','}',',','"','-','-','"',']','}',']',',','"',
'r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"',
'f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v',
'"',':','[','{','"','r','e','f','"',':','"','U','s','e','F','I','P','S','"','}',',','t','r','u','e',
']','}',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"','h','t',
't','p','s',':','/','/','s','3','e','x','p','r','e','s','s','-','c','o','n','t','r','o','l','-','f',
'i','p','s','.','{','R','e','g','i','o','n','}','.','{','p','a','r','t','i','t','i','o','n','R','e',
's','u','l','t','#','d','n','s','S','u','f','f','i','x','}','"',',','"','p','r','o','p','e','r','t',
'i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[','{','"','d','i',
's','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':','t','r','u','e',
',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n','i','n','g','N',
'a','m','e','"',':','"','s','3','e','x','p','r','e','s','s','"',',','"','s','i','g','n','i','n','g',
'R','e','g','i','o','n','"',':','"','{','R','e','g','i','o','n','}','"','}',']','}',',','"','h','e',
'a','d','e','r','s','"',':','{','}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i',
'n','t','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','n',
'd','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/','s',
'3','e','x','p','r','e','s','s','-','c','o','n','t','r','o','l','.','{','R','e','g','i','o','n','}',
'.','{','p','a','r','t','i','t','i','o','n','R','e','s','u','l','t','#','d','n','s','S','u','f','f',
'i','x','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S',
'c','h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E',
'n','c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g',
'v','4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','e','x','p','r',
'e','s','s','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','R','e',
'g','i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','}','}',',','"',
't','y','p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',']',',','"','t','y','p','e','"',
':','"','t','r','e','e','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',
',','"','e','r','r','o','r','"',':','"','U','n','r','e','c','o','g','n','i','z','e','d',' ','S','3',
'E','x','p','r','e','s','s',' ','A','c','c','e','s','s',' ','P','o','i','n','t',' ','n','a','m','e',
' ','f','o','r','m','a','t','.','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r','"','}',
']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',']',',','"','t','y','p','e','"',':',
'"','t','r','e','e','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"',
'f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f',
'"',':','"','U','s','e','S','3','E','x','p','r','e','s','s','C','o','n','t','r','o','l','E','n','d',
'p','o','i','n','t','"','}',']','}',',','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E',
'q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s',
'e','S','3','E','x','p','r','e','s','s','C','o','n','t','r','o','l','E','n','d','p','o','i','n','t',
'"','}',',','t','r','u','e',']','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n',
'd','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','a','w','s','.','p','a','r','t',
'i','t','i','o','n','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','R','e',
'g','i','o','n','"','}',']',',','"','a','s','s','i','g','n','"',':','"','p','a','r','t','i','t','i',
'o','n','R','e','s','u','l','t','"','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o',
'n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','i','s','S','e','t','"',',',
'"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','E','n','d','p','o','i','n','t','"',
'}',']','}',',','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',
',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','D','u','a','l','S',
't','a','c','k','"','}',',','t','r','u','e',']','}',']',',','"','e','r','r','o','r','"',':','"','I',
'n','v','a','l','i','d',' ','C','o','n','f','i','g','u','r','a','t','i','o','n',':',' ','D','u','a',
'l','S','t','a','c','k',' ','a','n','d',' ','c','u','s','t','o','m',' ','e','n','d','p','o','i','n',
't',' ','a','r','e',' ','n','o','t',' ','s','u','p','p','o','r','t','e','d','"',',','"','t','y','p',
'e','"',':','"','e','r','r','o','r','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',
':','[','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"',
'a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','D','u','a','l','S','t','a',
'c','k','"','}',',','t','r','u','e',']','}',']',',','"','e','r','r','o','r','"',':','"','S','3','E',
'x','p','r','e','s','s',' ','d','o','e','s',' ','n','o','t',' ','s','u','p','p','o','r','t',' ','D',
'u','a','l','-','s','t','a','c','k','.','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r',
'"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"',
'i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','E','n',
'd','p','o','i','n','t','"','}',']','}',',','{','"','f','n','"',':','"','p','a','r','s','e','U','R',
'L','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','E','n','d','p','o','i',
'n','t','"','}',']',',','"','a','s','s','i','g','n','"',':','"','u','r','l','"','}',']',',','"','e',
'n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"','{','u','r','l','#','s','c','h',
'e','m','e','}',':','/','/','{','u','r','l','#','a','u','t','h','o','r','i','t','y','}','"',',','"',
'p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s',
'"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n',
'g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s',
'i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','e','x','p','r','e','s','s','"',',','"',
's','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','R','e','g','i','o','n','}','"',
'}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','}','}',',','"','t','y','p','e','"',':',
'"','e','n','d','p','o','i','n','t','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',
':','[','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"',
'a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','F','I','P','S','"','}',',',
't','r','u','e',']','}',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',
':','"','h','t','t','p','s',':','/','/','s','3','e','x','p','r','e','s','s','-','c','o','n','t','r',
'o','l','-','f','i','p','s','.','{','R','e','g','i','o','n','}','.','{','p','a','r','t','i','t','i',
'o','n','R','e','s','u','l','t','#','d','n','s','S','u','f','f','i','x','}','"',',','"','p','r','o',
'p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[',
'{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':',
't','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n',
'i','n','g','N','a','m','e','"',':','"','s','3','e','x','p','r','e','s','s','"',',','"','s','i','g',
'n','i','n','g','R','e','g','i','o','n','"',':','"','{','R','e','g','i','o','n','}','"','}',']','}',
',','"','h','e','a','d','e','r','s','"',':','{','}','}',',','"','t','y','p','e','"',':','"','e','n',
'd','p','o','i','n','t','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',
',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',
':','/','/','s','3','e','x','p','r','e','s','s','-','c','o','n','t','r','o','l','.','{','R','e','g',
'i','o','n','}','.','{','p','a','r','t','i','t','i','o','n','R','e','s','u','l','t','#','d','n','s',
'S','u','f','f','i','x','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a',
'u','t','h','S','c','h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u',
'b','l','e','E','n','c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':',
'"','s','i','g','v','4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3',
'e','x','p','r','e','s','s','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':',
'"','{','R','e','g','i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{',
'}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',']',',','"','t',
'y','p','e','"',':','"','t','r','e','e','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e',
'e','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':',
'"','s','t','r','i','n','g','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"',
'r','e','f','"',':','"','R','e','g','i','o','n','"','}',',','"','s','n','o','w','"',']','}',',','{',
'"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r','e',
'f','"',':','"','E','n','d','p','o','i','n','t','"','}',']','}',',','{','"','f','n','"',':','"','p',
'a','r','s','e','U','R','L','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"',
'E','n','d','p','o','i','n','t','"','}',']',',','"','a','s','s','i','g','n','"',':','"','u','r','l',
'"','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s',
'"',':','[','{','"','f','n','"',':','"','a','w','s','.','p','a','r','t','i','t','i','o','n','"',',',
'"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','R','e','g','i','o','n','"','}',']',
',','"','a','s','s','i','g','n','"',':','"','p','a','r','t','i','t','i','o','n','R','e','s','u','l',
't','"','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n',
's','"',':','[','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',
',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','D','u','a','l','S',
't','a','c','k','"','}',',','t','r','u','e',']','}',']',',','"','e','r','r','o','r','"',':','"','S',
'3',' ','S','n','o','w',' ','d','o','e','s',' ','n','o','t',' ','s','u','p','p','o','r','t',' ','D',
'u','a','l','S','t','a','c','k','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r','"','}',
',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','b','o',
'o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e',
'f','"',':','"','U','s','e','F','I','P','S','"','}',',','t','r','u','e',']','}',']',',','"','e','r',
'r','o','r','"',':','"','S','3',' ','S','n','o','w',' ','d','o','e','s',' ','n','o','t',' ','s','u',
'p','p','o','r','t',' ','F','I','P','S','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r',
'"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','n','d','p',
'o','i','n','t','"',':','{','"','u','r','l','"',':','"','{','u','r','l','#','s','c','h','e','m','e',
'}',':','/','/','{','u','r','l','#','a','u','t','h','o','r','i','t','y','}','"',',','"','p','r','o',
'p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[',
'{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':',
't','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n',
'i','n','g','N','a','m','e','"',':','"','s','3','"',',','"','s','i','g','n','i','n','g','R','e','g',
'i','o','n','"',':','"','{','R','e','g','i','o','n','}','"','}',']','}',',','"','h','e','a','d','e',
'r','s','"',':','{','}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i','n','t','"',
'}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',']',',','"','t','y','p','e','"',
':','"','t','r','e','e','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{',
'"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r','e',
'f','"',':','"','A','c','c','e','s','s','P','o','i','n','t','N','a','m','e','"','}',']','}',',','{',
'"','f','n','"',':','"','a','w','s','.','p','a','r','s','e','A','r','n','"',',','"','a','r','g','v',
'"',':','[','{','"','r','e','f','"',':','"','A','c','c','e','s','s','P','o','i','n','t','N','a','m',
'e','"','}',']',',','"','a','s','s','i','g','n','"',':','"','a','c','c','e','s','s','P','o','i','n',
't','A','r','n','"','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t',
'i','o','n','s','"',':','[','{','"','f','n','"',':','"','g','e','t','A','t','t','r','"',',','"','a',
'r','g','v','"',':','[','{','"','r','e','f','"',':','"','a','c','c','e','s','s','P','o','i','n','t',
'A','r','n','"','}',',','"','r','e','s','o','u','r','c','e','I','d','[','0',']','"',']',',','"','a',
's','s','i','g','n','"',':','"','a','r','n','T','y','p','e','"','}',',','{','"','f','n','"',':','"',
'n','o','t','"',',','"','a','r','g','v','"',':','[','{','"','f','n','"',':','"','s','t','r','i','n',
'g','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"',
'a','r','n','T','y','p','e','"','}',',','"','"',']','}',']','}',']',',','"','r','u','l','e','s','"',
':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','s',
't','r','i','n','g','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','f','n',
'"',':','"','g','e','t','A','t','t','r','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f',
'"',':','"','a','c','c','e','s','s','P','o','i','n','t','A','r','n','"','}',',','"','s','e','r','v',
'i','c','e','"',']','}',',','"','s','3','-','o','u','t','p','o','s','t','s','"',']','}',']',',','"',
'r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"',
'f','n','"',':','"','g','e','t','A','t','t','r','"',',','"','a','r','g','v','"',':','[','{','"','r',
'e','f','"',':','"','a','c','c','e','s','s','P','o','i','n','t','A','r','n','"','}',',','"','r','e',
's','o','u','r','c','e','I','d','[','1',']','"',']',',','"','a','s','s','i','g','n','"',':','"','o',
'u','t','p','o','s','t','I','d','"','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o',
'n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','i','s','V','a','l','i','d',
'H','o','s','t','L','a','b','e','l','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',
':','"','o','u','t','p','o','s','t','I','d','"','}',',','f','a','l','s','e',']','}',']',',','"','r',
'u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f',
'n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',
':','"','E','n','d','p','o','i','n','t','"','}',']','}',',','{','"','f','n','"',':','"','b','o','o',
'l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f',
'"',':','"','U','s','e','D','u','a','l','S','t','a','c','k','"','}',',','t','r','u','e',']','}',']',
',','"','e','r','r','o','r','"',':','"','I','n','v','a','l','i','d',' ','C','o','n','f','i','g','u',
'r','a','t','i','o','n',':',' ','D','u','a','l','S','t','a','c','k',' ','a','n','d',' ','c','u','s',
't','o','m',' ','e','n','d','p','o','i','n','t',' ','a','r','e',' ','n','o','t',' ','s','u','p','p',
'o','r','t','e','d','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r','"','}',',','{','"',
'c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','i','s','S','e','t',
'"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','A','r','n','R',
'e','g','i','o','n','"','}',']','}',',','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E',
'q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s',
'e','A','r','n','R','e','g','i','o','n','"','}',',','f','a','l','s','e',']','}',',','{','"','f','n',
'"',':','"','n','o','t','"',',','"','a','r','g','v','"',':','[','{','"','f','n','"',':','"','s','t',
'r','i','n','g','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','f','n','"',
':','"','g','e','t','A','t','t','r','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',
':','"','a','c','c','e','s','s','P','o','i','n','t','A','r','n','"','}',',','"','r','e','g','i','o',
'n','"',']','}',',','"','{','R','e','g','i','o','n','}','"',']','}',']','}',']',',','"','e','r','r',
'o','r','"',':','"','I','n','v','a','l','i','d',' ','c','o','n','f','i','g','u','r','a','t','i','o',
'n',':',' ','r','e','g','i','o','n',' ','f','r','o','m',' ','A','R','N',' ','`','{','a','c','c','e',
's','s','P','o','i','n','t','A','r','n','#','r','e','g','i','o','n','}','`',' ','d','o','e','s',' ',
'n','o','t',' ','m','a','t','c','h',' ','c','l','i','e','n','t',' ','r','e','g','i','o','n',' ','`',
'{','R','e','g','i','o','n','}','`',' ','a','n','d',' ','U','s','e','A','r','n','R','e','g','i','o',
'n',' ','i','s',' ','`','f','a','l','s','e','`','"',',','"','t','y','p','e','"',':','"','e','r','r',
'o','r','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',
':','"','a','w','s','.','p','a','r','t','i','t','i','o','n','"',',','"','a','r','g','v','"',':','[',
'{','"','r','e','f','"',':','"','R','e','g','i','o','n','"','}',']',',','"','a','s','s','i','g','n',
'"',':','"','p','a','r','t','i','t','i','o','n','R','e','s','u','l','t','"','}',']',',','"','r','u',
'l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n',
'"',':','"','a','w','s','.','p','a','r','t','i','t','i','o','n','"',',','"','a','r','g','v','"',':',
'[','{','"','f','n','"',':','"','g','e','t','A','t','t','r','"',',','"','a','r','g','v','"',':','[',
'{','"','r','e','f','"',':','"','a','c','c','e','s','s','P','o','i','n','t','A','r','n','"','}',',',
'"','r','e','g','i','o','n','"',']','}',']',',','"','a','s','s','i','g','n','"',':','"','a','r','n',
'P','a','r','t','i','t','i','o','n','"','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c',
'o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','s','t','r','i','n','g',
'E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','f','n','"',':','"','g','e',
't','A','t','t','r','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','a','r',
'n','P','a','r','t','i','t','i','o','n','"','}',',','"','n','a','m','e','"',']','}',',','{','"','f',
'n','"',':','"','g','e','t','A','t','t','r','"',',','"','a','r','g','v','"',':','[','{','"','r','e',
'f','"',':','"','p','a','r','t','i','t','i','o','n','R','e','s','u','l','t','"','}',',','"','n','a',
'm','e','"',']','}',']','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i',
't','i','o','n','s','"',':','[','{','"','f','n','"',':','"','i','s','V','a','l','i','d','H','o','s',
't','L','a','b','e','l','"',',','"','a','r','g','v','"',':','[','{','"','f','n','"',':','"','g','e',
't','A','t','t','r','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','a','c',
'c','e','s','s','P','o','i','n','t','A','r','n','"','}',',','"','r','e','g','i','o','n','"',']','}',
',','t','r','u','e',']','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i',
't','i','o','n','s','"',':','[','{','"','f','n','"',':','"','n','o','t','"',',','"','a','r','g','v',
'"',':','[','{','"','f','n','"',':','"','s','t','r','i','n','g','E','q','u','a','l','s','"',',','"',
'a','r','g','v','"',':','[','{','"','f','n','"',':','"','g','e','t','A','t','t','r','"',',','"','a',
'r','g','v','"',':','[','{','"','r','e','f','"',':','"','a','c','c','e','s','s','P','o','i','n','t',
'A','r','n','"','}',',','"','a','c','c','o','u','n','t','I','d','"',']','}',',','"','"',']','}',']',
'}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',
':','[','{','"','f','n','"',':','"','i','s','V','a','l','i','d','H','o','s','t','L','a','b','e','l',
'"',',','"','a','r','g','v','"',':','[','{','"','f','n','"',':','"','g','e','t','A','t','t','r','"',
',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','a','c','c','e','s','s','P','o',
'i','n','t','A','r','n','"','}',',','"','a','c','c','o','u','n','t','I','d','"',']','}',',','f','a',
'l','s','e',']','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i',
'o','n','s','"',':','[','{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v',
'"',':','[','{','"','r','e','f','"',':','"','A','c','c','o','u','n','t','I','d','"','}',']','}',',',
'{','"','f','n','"',':','"','n','o','t','"',',','"','a','r','g','v','"',':','[','{','"','f','n','"',
':','"','s','t','r','i','n','g','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{',
'"','r','e','f','"',':','"','A','c','c','o','u','n','t','I','d','"','}',',','"','{','a','c','c','e',
's','s','P','o','i','n','t','A','r','n','#','a','c','c','o','u','n','t','I','d','}','"',']','}',']',
'}',']',',','"','e','r','r','o','r','"',':','"','I','n','v','a','l','i','d',' ','A','R','N',':',' ',
't','h','e',' ','a','c','c','o','u','n','t','I','d',' ','s','p','e','c','i','f','i','e','d',' ','i',
'n',' ','t','h','e',' ','A','R','N',' ','(','`','{','a','c','c','e','s','s','P','o','i','n','t','A',
'r','n','#','a','c','c','o','u','n','t','I','d','}','`',')',' ','d','o','e','s',' ','n','o','t',' ',
'm','a','t','c','h',' ','t','h','e',' ','p','a','r','a','m','e','t','e','r',' ','(','`','{','A','c',
'c','o','u','n','t','I','d','}','`',')','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r',
'"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"',
'g','e','t','A','t','t','r','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"',
'a','c','c','e','s','s','P','o','i','n','t','A','r','n','"','}',',','"','r','e','s','o','u','r','c',
'e','I','d','[','2',']','"',']',',','"','a','s','s','i','g','n','"',':','"','o','u','t','p','o','s',
't','T','y','p','e','"','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i',
't','i','o','n','s','"',':','[','{','"','f','n','"',':','"','g','e','t','A','t','t','r','"',',','"',
'a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','a','c','c','e','s','s','P','o','i','n',
't','A','r','n','"','}',',','"','r','e','s','o','u','r','c','e','I','d','[','3',']','"',']',',','"',
'a','s','s','i','g','n','"',':','"','a','c','c','e','s','s','P','o','i','n','t','N','a','m','e','"',
'}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',
':','[','{','"','f','n','"',':','"','s','t','r','i','n','g','E','q','u','a','l','s','"',',','"','a',
'r','g','v','"',':','[','{','"','r','e','f','"',':','"','o','u','t','p','o','s','t','T','y','p','e',
'"','}',',','"','a','c','c','e','s','s','p','o','i','n','t','"',']','}',']',',','"','r','u','l','e',
's','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':',
'"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{',
'"','r','e','f','"',':','"','U','s','e','F','I','P','S','"','}',',','t','r','u','e',']','}',',','{',
'"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g',
'v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','D','u','a','l','S','t','a','c','k','"',
'}',',','t','r','u','e',']','}',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r',
'l','"',':','"','h','t','t','p','s',':','/','/','s','3','-','o','u','t','p','o','s','t','s','-','f',
'i','p','s','.','{','a','c','c','e','s','s','P','o','i','n','t','A','r','n','#','r','e','g','i','o',
'n','}','.','{','a','r','n','P','a','r','t','i','t','i','o','n','#','d','u','a','l','S','t','a','c',
'k','D','n','s','S','u','f','f','i','x','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',
':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l',
'e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a',
'm','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',
':','"','s','3','-','o','u','t','p','o','s','t','s','"',',','"','s','i','g','n','i','n','g','R','e',
'g','i','o','n','"',':','"','{','a','c','c','e','s','s','P','o','i','n','t','A','r','n','#','r','e',
'g','i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','"','x','-','a',
'm','z','-','a','c','c','o','u','n','t','-','i','d','"',':','[','"','{','a','c','c','e','s','s','P',
'o','i','n','t','A','r','n','#','a','c','c','o','u','n','t','I','d','}','"',']',',','"','x','-','a',
'm','z','-','o','u','t','p','o','s','t','-','i','d','"',':','[','"','{','o','u','t','p','o','s','t',
'I','d','}','"',']','}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i','n','t','"',
'}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','b',
'o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r',
'e','f','"',':','"','U','s','e','F','I','P','S','"','}',',','t','r','u','e',']','}',']',',','"','e',
'n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/',
's','3','-','o','u','t','p','o','s','t','s','-','f','i','p','s','.','{','a','c','c','e','s','s','P',
'o','i','n','t','A','r','n','#','r','e','g','i','o','n','}','.','{','a','r','n','P','a','r','t','i',
't','i','o','n','#','d','n','s','S','u','f','f','i','x','}','"',',','"','p','r','o','p','e','r','t',
'i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[','{','"','d','i',
's','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':','t','r','u','e',
',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n','i','n','g','N',
'a','m','e','"',':','"','s','3','-','o','u','t','p','o','s','t','s','"',',','"','s','i','g','n','i',
'n','g','R','e','g','i','o','n','"',':','"','{','a','c','c','e','s','s','P','o','i','n','t','A','r',
'n','#','r','e','g','i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{',
'"','x','-','a','m','z','-','a','c','c','o','u','n','t','-','i','d','"',':','[','"','{','a','c','c',
'e','s','s','P','o','i','n','t','A','r','n','#','a','c','c','o','u','n','t','I','d','}','"',']',',',
'"','x','-','a','m','z','-','o','u','t','p','o','s','t','-','i','d','"',':','[','"','{','o','u','t',
'p','o','s','t','I','d','}','"',']','}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o',
'i','n','t','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n',
'"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':',
'[','{','"','r','e','f','"',':','"','U','s','e','D','u','a','l','S','t','a','c','k','"','}',',','t',
'r','u','e',']','}',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',':',
'"','h','t','t','p','s',':','/','/','s','3','-','o','u','t','p','o','s','t','s','.','{','a','c','c',
'e','s','s','P','o','i','n','t','A','r','n','#','r','e','g','i','o','n','}','.','{','a','r','n','P',
'a','r','t','i','t','i','o','n','#','d','u','a','l','S','t','a','c','k','D','n','s','S','u','f','f',
'i','x','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S',
'c','h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E',
'n','c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g',
'v','4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','-','o','u','t',
'p','o','s','t','s','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{',
'a','c','c','e','s','s','P','o','i','n','t','A','r','n','#','r','e','g','i','o','n','}','"','}',']',
'}',',','"','h','e','a','d','e','r','s','"',':','{','"','x','-','a','m','z','-','a','c','c','o','u',
'n','t','-','i','d','"',':','[','"','{','a','c','c','e','s','s','P','o','i','n','t','A','r','n','#',
'a','c','c','o','u','n','t','I','d','}','"',']',',','"','x','-','a','m','z','-','o','u','t','p','o',
's','t','-','i','d','"',':','[','"','{','o','u','t','p','o','s','t','I','d','}','"',']','}','}',',',
'"','t','y','p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',',','{','"','c','o','n','d',
'i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a',
'r','g','v','"',':','[','{','"','r','e','f','"',':','"','E','n','d','p','o','i','n','t','"','}',']',
'}',',','{','"','f','n','"',':','"','p','a','r','s','e','U','R','L','"',',','"','a','r','g','v','"',
':','[','{','"','r','e','f','"',':','"','E','n','d','p','o','i','n','t','"','}',']',',','"','a','s',
's','i','g','n','"',':','"','u','r','l','"','}',']',',','"','e','n','d','p','o','i','n','t','"',':',
'{','"','u','r','l','"',':','"','{','u','r','l','#','s','c','h','e','m','e','}',':','/','/','{','u',
'r','l','#','a','u','t','h','o','r','i','t','y','}','{','u','r','l','#','p','a','t','h','}','"',',',
'"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e',
's','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i',
'n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"',
's','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','-','o','u','t','p','o','s','t','s',
'"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','a','c','c','e','s',
's','P','o','i','n','t','A','r','n','#','r','e','g','i','o','n','}','"','}',']','}',',','"','h','e',
'a','d','e','r','s','"',':','{','"','x','-','a','m','z','-','a','c','c','o','u','n','t','-','i','d',
'"',':','[','"','{','a','c','c','e','s','s','P','o','i','n','t','A','r','n','#','a','c','c','o','u',
'n','t','I','d','}','"',']',',','"','x','-','a','m','z','-','o','u','t','p','o','s','t','-','i','d',
'"',':','[','"','{','o','u','t','p','o','s','t','I','d','}','"',']','}','}',',','"','t','y','p','e',
'"',':','"','e','n','d','p','o','i','n','t','"','}',',','{','"','c','o','n','d','i','t','i','o','n',
's','"',':','[',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"',
'h','t','t','p','s',':','/','/','s','3','-','o','u','t','p','o','s','t','s','.','{','a','c','c','e',
's','s','P','o','i','n','t','A','r','n','#','r','e','g','i','o','n','}','.','{','a','r','n','P','a',
'r','t','i','t','i','o','n','#','d','n','s','S','u','f','f','i','x','}','"',',','"','p','r','o','p',
'e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[','{',
'"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':','t',
'r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n','i',
'n','g','N','a','m','e','"',':','"','s','3','-','o','u','t','p','o','s','t','s','"',',','"','s','i',
'g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','a','c','c','e','s','s','P','o','i','n',
't','A','r','n','#','r','e','g','i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s',
'"',':','{','"','x','-','a','m','z','-','a','c','c','o','u','n','t','-','i','d','"',':','[','"','{',
'a','c','c','e','s','s','P','o','i','n','t','A','r','n','#','a','c','c','o','u','n','t','I','d','}',
'"',']',',','"','x','-','a','m','z','-','o','u','t','p','o','s','t','-','i','d','"',':','[','"','{',
'o','u','t','p','o','s','t','I','d','}','"',']','}','}',',','"','t','y','p','e','"',':','"','e','n',
'd','p','o','i','n','t','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',',',
'{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','r','r','o','r','"',':',
'"','E','x','p','e','c','t','e','d',' ','a','n',' ','o','u','t','p','o','s','t',' ','t','y','p','e',
' ','`','a','c','c','e','s','s','p','o','i','n','t','`',',',' ','f','o','u','n','d',' ','`','{','o',
'u','t','p','o','s','t','T','y','p','e','}','`','"',',','"','t','y','p','e','"',':','"','e','r','r',
'o','r','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',',','{','"','c','o',
'n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','r','r','o','r','"',':','"','I','n','v',
'a','l','i','d',' ','A','R','N',':',' ','e','x','p','e','c','t','e','d',' ','a','n',' ','a','c','c',
'e','s','s',' ','p','o','i','n','t',' ','n','a','m','e','"',',','"','t','y','p','e','"',':','"','e',
'r','r','o','r','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',',','{','"',
'c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','r','r','o','r','"',':','"','I',
'n','v','a','l','i','d',' ','A','R','N',':',' ','E','x','p','e','c','t','e','d',' ','a',' ','4','-',
'c','o','m','p','o','n','e','n','t',' ','r','e','s','o','u','r','c','e','"',',','"','t','y','p','e',
'"',':','"','e','r','r','o','r','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"',
'}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','r','r','o','r',
'"',':','"','I','n','v','a','l','i','d',' ','A','R','N',':',' ','T','h','e',' ','a','c','c','o','u',
'n','t',' ','i','d',' ','m','a','y',' ','o','n','l','y',' ','c','o','n','t','a','i','n',' ','a','-',
'z',',',' ','A','-','Z',',',' ','0','-','9',' ','a','n','d',' ','`','-','`','.',' ','F','o','u','n',
'd',':',' ','`','{','a','c','c','e','s','s','P','o','i','n','t','A','r','n','#','a','c','c','o','u',
'n','t','I','d','}','`','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r','"','}',']',',',
'"','t','y','p','e','"',':','"','t','r','e','e','"','}',',','{','"','c','o','n','d','i','t','i','o',
'n','s','"',':','[',']',',','"','e','r','r','o','r','"',':','"','I','n','v','a','l','i','d',' ','A',
'R','N',':',' ','m','i','s','s','i','n','g',' ','a','c','c','o','u','n','t',' ','I','D','"',',','"',
't','y','p','e','"',':','"','e','r','r','o','r','"','}',']',',','"','t','y','p','e','"',':','"','t',
'r','e','e','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e',
'r','r','o','r','"',':','"','I','n','v','a','l','i','d',' ','r','e','g','i','o','n',' ','i','n',' ',
'A','R','N',':',' ','`','{','a','c','c','e','s','s','P','o','i','n','t','A','r','n','#','r','e','g',
'i','o','n','}','`',' ','(','i','n','v','a','l','i','d',' ','D','N','S',' ','n','a','m','e',')','"',
',','"','t','y','p','e','"',':','"','e','r','r','o','r','"','}',']',',','"','t','y','p','e','"',':',
'"','t','r','e','e','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',',
'"','e','r','r','o','r','"',':','"','C','l','i','e','n','t',' ','w','a','s',' ','c','o','n','f','i',
'g','u','r','e','d',' ','f','o','r',' ','p','a','r','t','i','t','i','o','n',' ','`','{','p','a','r',
't','i','t','i','o','n','R','e','s','u','l','t','#','n','a','m','e','}','`',' ','b','u','t',' ','A',
'R','N',' ','h','a','s',' ','`','{','a','r','n','P','a','r','t','i','t','i','o','n','#','n','a','m',
'e','}','`','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r','"','}',']',',','"','t','y',
'p','e','"',':','"','t','r','e','e','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e',
'"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',',','{','"','c','o','n','d',
'i','t','i','o','n','s','"',':','[',']',',','"','e','r','r','o','r','"',':','"','I','n','v','a','l',
'i','d',' ','A','R','N',':',' ','T','h','e',' ','o','u','t','p','o','s','t',' ','I','d',' ','m','u',
's','t',' ','o','n','l','y',' ','c','o','n','t','a','i','n',' ','a','-','z',',',' ','A','-','Z',',',
' ','0','-','9',' ','a','n','d',' ','`','-','`','.',',',' ','f','o','u','n','d',':',' ','`','{','o',
'u','t','p','o','s','t','I','d','}','`','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r',
'"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',',','{','"','c','o','n','d',
'i','t','i','o','n','s','"',':','[',']',',','"','e','r','r','o','r','"',':','"','I','n','v','a','l',
'i','d',' ','A','R','N',':',' ','T','h','e',' ','O','u','t','p','o','s','t',' ','I','d',' ','w','a',
's',' ','n','o','t',' ','s','e','t','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r','"',
'}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',']',',','"','t','y','p','e','"',
':','"','t','r','e','e','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',
',','"','e','r','r','o','r','"',':','"','I','n','v','a','l','i','d',' ','A','R','N',':',' ','N','o',
' ','A','R','N',' ','t','y','p','e',' ','s','p','e','c','i','f','i','e','d','"',',','"','t','y','p',
'e','"',':','"','e','r','r','o','r','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e',
'"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"',
'i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','B','u',
'c','k','e','t','"','}',']','}',',','{','"','f','n','"',':','"','a','w','s','.','p','a','r','s','e',
'A','r','n','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','B','u','c','k',
'e','t','"','}',']',',','"','a','s','s','i','g','n','"',':','"','b','u','c','k','e','t','A','r','n',
'"','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s',
'"',':','[','{','"','f','n','"',':','"','g','e','t','A','t','t','r','"',',','"','a','r','g','v','"',
':','[','{','"','r','e','f','"',':','"','b','u','c','k','e','t','A','r','n','"','}',',','"','r','e',
's','o','u','r','c','e','I','d','[','0',']','"',']',',','"','a','s','s','i','g','n','"',':','"','a',
'r','n','T','y','p','e','"','}',',','{','"','f','n','"',':','"','n','o','t','"',',','"','a','r','g',
'v','"',':','[','{','"','f','n','"',':','"','s','t','r','i','n','g','E','q','u','a','l','s','"',',',
'"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','a','r','n','T','y','p','e','"','}',
',','"','"',']','}',']','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i',
't','i','o','n','s','"',':','[','{','"','f','n','"',':','"','s','t','r','i','n','g','E','q','u','a',
'l','s','"',',','"','a','r','g','v','"',':','[','{','"','f','n','"',':','"','g','e','t','A','t','t',
'r','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','b','u','c','k','e','t',
'A','r','n','"','}',',','"','s','e','r','v','i','c','e','"',']','}',',','"','s','3','-','o','u','t',
'p','o','s','t','s','"',']','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d',
'i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','g','e','t','A','t','t','r','"',',',
'"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','b','u','c','k','e','t','A','r','n',
'"','}',',','"','r','e','s','o','u','r','c','e','I','d','[','1',']','"',']',',','"','a','s','s','i',
'g','n','"',':','"','o','u','t','p','o','s','t','I','d','"','}',']',',','"','r','u','l','e','s','"',
':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','i',
's','V','a','l','i','d','H','o','s','t','L','a','b','e','l','"',',','"','a','r','g','v','"',':','[',
'{','"','r','e','f','"',':','"','o','u','t','p','o','s','t','I','d','"','}',',','f','a','l','s','e',
']','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s',
'"',':','[','{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',':','[',
'{','"','r','e','f','"',':','"','E','n','d','p','o','i','n','t','"','}',']','}',',','{','"','f','n',
'"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':',
'[','{','"','r','e','f','"',':','"','U','s','e','D','u','a','l','S','t','a','c','k','"','}',',','t',
'r','u','e',']','}',']',',','"','e','r','r','o','r','"',':','"','I','n','v','a','l','i','d',' ','C',
'o','n','f','i','g','u','r','a','t','i','o','n',':',' ','D','u','a','l','S','t','a','c','k',' ','a',
'n','d',' ','c','u','s','t','o','m',' ','e','n','d','p','o','i','n','t',' ','a','r','e',' ','n','o',
't',' ','s','u','p','p','o','r','t','e','d','"',',','"','t','y','p','e','"',':','"','e','r','r','o',
'r','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':',
'"','i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U',
's','e','A','r','n','R','e','g','i','o','n','"','}',']','}',',','{','"','f','n','"',':','"','b','o',
'o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e',
'f','"',':','"','U','s','e','A','r','n','R','e','g','i','o','n','"','}',',','f','a','l','s','e',']',
'}',',','{','"','f','n','"',':','"','n','o','t','"',',','"','a','r','g','v','"',':','[','{','"','f',
'n','"',':','"','s','t','r','i','n','g','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':',
'[','{','"','f','n','"',':','"','g','e','t','A','t','t','r','"',',','"','a','r','g','v','"',':','[',
'{','"','r','e','f','"',':','"','b','u','c','k','e','t','A','r','n','"','}',',','"','r','e','g','i',
'o','n','"',']','}',',','"','{','R','e','g','i','o','n','}','"',']','}',']','}',']',',','"','e','r',
'r','o','r','"',':','"','I','n','v','a','l','i','d',' ','c','o','n','f','i','g','u','r','a','t','i',
'o','n',':',' ','r','e','g','i','o','n',' ','f','r','o','m',' ','A','R','N',' ','`','{','b','u','c',
'k','e','t','A','r','n','#','r','e','g','i','o','n','}','`',' ','d','o','e','s',' ','n','o','t',' ',
'm','a','t','c','h',' ','c','l','i','e','n','t',' ','r','e','g','i','o','n',' ','`','{','R','e','g',
'i','o','n','}','`',' ','a','n','d',' ','U','s','e','A','r','n','R','e','g','i','o','n',' ','i','s',
' ','`','f','a','l','s','e','`','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r','"','}',
',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','a','w',
's','.','p','a','r','t','i','t','i','o','n','"',',','"','a','r','g','v','"',':','[','{','"','f','n',
'"',':','"','g','e','t','A','t','t','r','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f',
'"',':','"','b','u','c','k','e','t','A','r','n','"','}',',','"','r','e','g','i','o','n','"',']','}',
']',',','"','a','s','s','i','g','n','"',':','"','a','r','n','P','a','r','t','i','t','i','o','n','"',
'}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',
':','[','{','"','f','n','"',':','"','a','w','s','.','p','a','r','t','i','t','i','o','n','"',',','"',
'a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','R','e','g','i','o','n','"','}',']',',',
'"','a','s','s','i','g','n','"',':','"','p','a','r','t','i','t','i','o','n','R','e','s','u','l','t',
'"','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s',
'"',':','[','{','"','f','n','"',':','"','s','t','r','i','n','g','E','q','u','a','l','s','"',',','"',
'a','r','g','v','"',':','[','{','"','f','n','"',':','"','g','e','t','A','t','t','r','"',',','"','a',
'r','g','v','"',':','[','{','"','r','e','f','"',':','"','a','r','n','P','a','r','t','i','t','i','o',
'n','"','}',',','"','n','a','m','e','"',']','}',',','{','"','f','n','"',':','"','g','e','t','A','t',
't','r','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','p','a','r','t','i',
't','i','o','n','R','e','s','u','l','t','"','}',',','"','n','a','m','e','"',']','}',']','}',']',',',
'"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{',
'"','f','n','"',':','"','i','s','V','a','l','i','d','H','o','s','t','L','a','b','e','l','"',',','"',
'a','r','g','v','"',':','[','{','"','f','n','"',':','"','g','e','t','A','t','t','r','"',',','"','a',
'r','g','v','"',':','[','{','"','r','e','f','"',':','"','b','u','c','k','e','t','A','r','n','"','}',
',','"','r','e','g','i','o','n','"',']','}',',','t','r','u','e',']','}',']',',','"','r','u','l','e',
's','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':',
'"','n','o','t','"',',','"','a','r','g','v','"',':','[','{','"','f','n','"',':','"','s','t','r','i',
'n','g','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','f','n','"',':','"',
'g','e','t','A','t','t','r','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"',
'b','u','c','k','e','t','A','r','n','"','}',',','"','a','c','c','o','u','n','t','I','d','"',']','}',
',','"','"',']','}',']','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i',
't','i','o','n','s','"',':','[','{','"','f','n','"',':','"','i','s','V','a','l','i','d','H','o','s',
't','L','a','b','e','l','"',',','"','a','r','g','v','"',':','[','{','"','f','n','"',':','"','g','e',
't','A','t','t','r','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','b','u',
'c','k','e','t','A','r','n','"','}',',','"','a','c','c','o','u','n','t','I','d','"',']','}',',','f',
'a','l','s','e',']','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t',
'i','o','n','s','"',':','[','{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g',
'v','"',':','[','{','"','r','e','f','"',':','"','A','c','c','o','u','n','t','I','d','"','}',']','}',
',','{','"','f','n','"',':','"','n','o','t','"',',','"','a','r','g','v','"',':','[','{','"','f','n',
'"',':','"','s','t','r','i','n','g','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[',
'{','"','r','e','f','"',':','"','A','c','c','o','u','n','t','I','d','"','}',',','"','{','b','u','c',
'k','e','t','A','r','n','#','a','c','c','o','u','n','t','I','d','}','"',']','}',']','}',']',',','"',
'e','r','r','o','r','"',':','"','I','n','v','a','l','i','d',' ','A','R','N',':',' ','t','h','e',' ',
'a','c','c','o','u','n','t','I','d',' ','s','p','e','c','i','f','i','e','d',' ','i','n',' ','t','h',
'e',' ','A','R','N',' ','(','`','{','b','u','c','k','e','t','A','r','n','#','a','c','c','o','u','n',
't','I','d','}','`',')',' ','d','o','e','s',' ','n','o','t',' ','m','a','t','c','h',' ','t','h','e',
' ','p','a','r','a','m','e','t','e','r',' ','(','`','{','A','c','c','o','u','n','t','I','d','}','`',
')','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r','"','}',',','{','"','c','o','n','d',
'i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','g','e','t','A','t','t','r','"',',',
'"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','b','u','c','k','e','t','A','r','n',
'"','}',',','"','r','e','s','o','u','r','c','e','I','d','[','2',']','"',']',',','"','a','s','s','i',
'g','n','"',':','"','o','u','t','p','o','s','t','T','y','p','e','"','}',']',',','"','r','u','l','e',
's','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':',
'"','g','e','t','A','t','t','r','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':',
'"','b','u','c','k','e','t','A','r','n','"','}',',','"','r','e','s','o','u','r','c','e','I','d','[',
'3',']','"',']',',','"','a','s','s','i','g','n','"',':','"','b','u','c','k','e','t','N','a','m','e',
'"','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s',
'"',':','[','{','"','f','n','"',':','"','s','t','r','i','n','g','E','q','u','a','l','s','"',',','"',
'a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','o','u','t','p','o','s','t','T','y','p',
'e','"','}',',','"','b','u','c','k','e','t','"',']','}',']',',','"','r','u','l','e','s','"',':','[',
'{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','b','o','o',
'l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f',
'"',':','"','U','s','e','F','I','P','S','"','}',',','t','r','u','e',']','}',',','{','"','f','n','"',
':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[',
'{','"','r','e','f','"',':','"','U','s','e','D','u','a','l','S','t','a','c','k','"','}',',','t','r',
'u','e',']','}',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"',
'h','t','t','p','s',':','/','/','s','3','-','o','u','t','p','o','s','t','s','-','f','i','p','s','.',
'{','b','u','c','k','e','t','A','r','n','#','r','e','g','i','o','n','}','.','{','a','r','n','P','a',
'r','t','i','t','i','o','n','#','d','u','a','l','S','t','a','c','k','D','n','s','S','u','f','f','i',
'x','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c',
'h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n',
'c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v',
'4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','-','o','u','t','p',
'o','s','t','s','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','b',
'u','c','k','e','t','A','r','n','#','r','e','g','i','o','n','}','"','}',']','}',',','"','h','e','a',
'd','e','r','s','"',':','{','"','x','-','a','m','z','-','a','c','c','o','u','n','t','-','i','d','"',
':','[','"','{','b','u','c','k','e','t','A','r','n','#','a','c','c','o','u','n','t','I','d','}','"',
']',',','"','x','-','a','m','z','-','o','u','t','p','o','s','t','-','i','d','"',':','[','"','{','o',
'u','t','p','o','s','t','I','d','}','"',']','}','}',',','"','t','y','p','e','"',':','"','e','n','d',
'p','o','i','n','t','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"',
'f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v',
'"',':','[','{','"','r','e','f','"',':','"','U','s','e','F','I','P','S','"','}',',','t','r','u','e',
']','}',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"','h','t',
't','p','s',':','/','/','s','3','-','o','u','t','p','o','s','t','s','-','f','i','p','s','.','{','b',
'u','c','k','e','t','A','r','n','#','r','e','g','i','o','n','}','.','{','a','r','n','P','a','r','t',
'i','t','i','o','n','#','d','n','s','S','u','f','f','i','x','}','"',',','"','p','r','o','p','e','r',
't','i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[','{','"','d',
'i','s','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':','t','r','u',
'e',',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n','i','n','g',
'N','a','m','e','"',':','"','s','3','-','o','u','t','p','o','s','t','s','"',',','"','s','i','g','n',
'i','n','g','R','e','g','i','o','n','"',':','"','{','b','u','c','k','e','t','A','r','n','#','r','e',
'g','i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','"','x','-','a',
'm','z','-','a','c','c','o','u','n','t','-','i','d','"',':','[','"','{','b','u','c','k','e','t','A',
'r','n','#','a','c','c','o','u','n','t','I','d','}','"',']',',','"','x','-','a','m','z','-','o','u',
't','p','o','s','t','-','i','d','"',':','[','"','{','o','u','t','p','o','s','t','I','d','}','"',']',
'}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',',','{','"','c',
'o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','b','o','o','l','e','a',
'n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"',
'U','s','e','D','u','a','l','S','t','a','c','k','"','}',',','t','r','u','e',']','}',']',',','"','e',
'n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/',
's','3','-','o','u','t','p','o','s','t','s','.','{','b','u','c','k','e','t','A','r','n','#','r','e',
'g','i','o','n','}','.','{','a','r','n','P','a','r','t','i','t','i','o','n','#','d','u','a','l','S',
't','a','c','k','D','n','s','S','u','f','f','i','x','}','"',',','"','p','r','o','p','e','r','t','i',
'e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[','{','"','d','i','s',
'a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':','t','r','u','e',',',
'"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n','i','n','g','N','a',
'm','e','"',':','"','s','3','-','o','u','t','p','o','s','t','s','"',',','"','s','i','g','n','i','n',
'g','R','e','g','i','o','n','"',':','"','{','b','u','c','k','e','t','A','r','n','#','r','e','g','i',
'o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','"','x','-','a','m','z',
'-','a','c','c','o','u','n','t','-','i','d','"',':','[','"','{','b','u','c','k','e','t','A','r','n',
'#','a','c','c','o','u','n','t','I','d','}','"',']',',','"','x','-','a','m','z','-','o','u','t','p',
'o','s','t','-','i','d','"',':','[','"','{','o','u','t','p','o','s','t','I','d','}','"',']','}','}',
',','"','t','y','p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',',','{','"','c','o','n',
'd','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','i','s','S','e','t','"',',','"',
'a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','E','n','d','p','o','i','n','t','"','}',
']','}',',','{','"','f','n','"',':','"','p','a','r','s','e','U','R','L','"',',','"','a','r','g','v',
'"',':','[','{','"','r','e','f','"',':','"','E','n','d','p','o','i','n','t','"','}',']',',','"','a',
's','s','i','g','n','"',':','"','u','r','l','"','}',']',',','"','e','n','d','p','o','i','n','t','"',
':','{','"','u','r','l','"',':','"','{','u','r','l','#','s','c','h','e','m','e','}',':','/','/','{',
'u','r','l','#','a','u','t','h','o','r','i','t','y','}','{','u','r','l','#','p','a','t','h','}','"',
',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m',
'e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d',
'i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',',
'"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','-','o','u','t','p','o','s','t',
's','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','b','u','c','k',
'e','t','A','r','n','#','r','e','g','i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r',
's','"',':','{','"','x','-','a','m','z','-','a','c','c','o','u','n','t','-','i','d','"',':','[','"',
'{','b','u','c','k','e','t','A','r','n','#','a','c','c','o','u','n','t','I','d','}','"',']',',','"',
'x','-','a','m','z','-','o','u','t','p','o','s','t','-','i','d','"',':','[','"','{','o','u','t','p',
'o','s','t','I','d','}','"',']','}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i',
'n','t','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','n',
'd','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/','s',
'3','-','o','u','t','p','o','s','t','s','.','{','b','u','c','k','e','t','A','r','n','#','r','e','g',
'i','o','n','}','.','{','a','r','n','P','a','r','t','i','t','i','o','n','#','d','n','s','S','u','f',
'f','i','x','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h',
'S','c','h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e',
'E','n','c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i',
'g','v','4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','-','o','u',
't','p','o','s','t','s','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"',
'{','b','u','c','k','e','t','A','r','n','#','r','e','g','i','o','n','}','"','}',']','}',',','"','h',
'e','a','d','e','r','s','"',':','{','"','x','-','a','m','z','-','a','c','c','o','u','n','t','-','i',
'd','"',':','[','"','{','b','u','c','k','e','t','A','r','n','#','a','c','c','o','u','n','t','I','d',
'}','"',']',',','"','x','-','a','m','z','-','o','u','t','p','o','s','t','-','i','d','"',':','[','"',
'{','o','u','t','p','o','s','t','I','d','}','"',']','}','}',',','"','t','y','p','e','"',':','"','e',
'n','d','p','o','i','n','t','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',
',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','r','r','o','r','"',
':','"','I','n','v','a','l','i','d',' ','A','R','N',':',' ','E','x','p','e','c','t','e','d',' ','a',
'n',' ','o','u','t','p','o','s','t',' ','t','y','p','e',' ','`','b','u','c','k','e','t','`',',',' ',
'f','o','u','n','d',' ','`','{','o','u','t','p','o','s','t','T','y','p','e','}','`','"',',','"','t',
'y','p','e','"',':','"','e','r','r','o','r','"','}',']',',','"','t','y','p','e','"',':','"','t','r',
'e','e','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','r',
'r','o','r','"',':','"','I','n','v','a','l','i','d',' ','A','R','N',':',' ','e','x','p','e','c','t',
'e','d',' ','a',' ','b','u','c','k','e','t',' ','n','a','m','e','"',',','"','t','y','p','e','"',':',
'"','e','r','r','o','r','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',',',
'{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','r','r','o','r','"',':',
'"','I','n','v','a','l','i','d',' ','A','R','N',':',' ','E','x','p','e','c','t','e','d',' ','a',' ',
'4','-','c','o','m','p','o','n','e','n','t',' ','r','e','s','o','u','r','c','e','"',',','"','t','y',
'p','e','"',':','"','e','r','r','o','r','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e',
'e','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','r','r',
'o','r','"',':','"','I','n','v','a','l','i','d',' ','A','R','N',':',' ','T','h','e',' ','a','c','c',
'o','u','n','t',' ','i','d',' ','m','a','y',' ','o','n','l','y',' ','c','o','n','t','a','i','n',' ',
'a','-','z',',',' ','A','-','Z',',',' ','0','-','9',' ','a','n','d',' ','`','-','`','.',' ','F','o',
'u','n','d',':',' ','`','{','b','u','c','k','e','t','A','r','n','#','a','c','c','o','u','n','t','I',
'd','}','`','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r','"','}',']',',','"','t','y',
'p','e','"',':','"','t','r','e','e','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',
':','[',']',',','"','e','r','r','o','r','"',':','"','I','n','v','a','l','i','d',' ','A','R','N',':',
' ','m','i','s','s','i','n','g',' ','a','c','c','o','u','n','t',' ','I','D','"',',','"','t','y','p',
'e','"',':','"','e','r','r','o','r','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e',
'"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','r','r','o',
'r','"',':','"','I','n','v','a','l','i','d',' ','r','e','g','i','o','n',' ','i','n',' ','A','R','N',
':',' ','`','{','b','u','c','k','e','t','A','r','n','#','r','e','g','i','o','n','}','`',' ','(','i',
'n','v','a','l','i','d',' ','D','N','S',' ','n','a','m','e',')','"',',','"','t','y','p','e','"',':',
'"','e','r','r','o','r','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',',',
'{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','r','r','o','r','"',':',
'"','C','l','i','e','n','t',' ','w','a','s',' ','c','o','n','f','i','g','u','r','e','d',' ','f','o',
'r',' ','p','a','r','t','i','t','i','o','n',' ','`','{','p','a','r','t','i','t','i','o','n','R','e',
's','u','l','t','#','n','a','m','e','}','`',' ','b','u','t',' ','A','R','N',' ','h','a','s',' ','`',
'{','a','r','n','P','a','r','t','i','t','i','o','n','#','n','a','m','e','}','`','"',',','"','t','y',
'p','e','"',':','"','e','r','r','o','r','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e',
'e','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',']',',','"','t','y','p',
'e','"',':','"','t','r','e','e','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':',
'[',']',',','"','e','r','r','o','r','"',':','"','I','n','v','a','l','i','d',' ','A','R','N',':',' ',
'T','h','e',' ','o','u','t','p','o','s','t',' ','I','d',' ','m','u','s','t',' ','o','n','l','y',' ',
'c','o','n','t','a','i','n',' ','a','-','z',',',' ','A','-','Z',',',' ','0','-','9',' ','a','n','d',
' ','`','-','`','.',',',' ','f','o','u','n','d',':',' ','`','{','o','u','t','p','o','s','t','I','d',
'}','`','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r','"','}',']',',','"','t','y','p',
'e','"',':','"','t','r','e','e','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':',
'[',']',',','"','e','r','r','o','r','"',':','"','I','n','v','a','l','i','d',' ','A','R','N',':',' ',
'T','h','e',' ','O','u','t','p','o','s','t',' ','I','d',' ','w','a','s',' ','n','o','t',' ','s','e',
't','"',',','"','t','y','p','e','"',':','"','e','r','r','o','r','"','}',']',',','"','t','y','p','e',
'"',':','"','t','r','e','e','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',
',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[',']',',','"','e','r','r','o','r','"',
':','"','I','n','v','a','l','i','d',' ','A','R','N',':',' ','N','o',' ','A','R','N',' ','t','y','p',
'e',' ','s','p','e','c','i','f','i','e','d','"',',','"','t','y','p','e','"',':','"','e','r','r','o',
'r','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',',','{','"','c','o','n',
'd','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','a','w','s','.','p','a','r','t',
'i','t','i','o','n','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','R','e',
'g','i','o','n','"','}',']',',','"','a','s','s','i','g','n','"',':','"','p','a','r','t','i','t','i',
'o','n','R','e','s','u','l','t','"','}',']',',','"','r','u','l','e','s','"',':','[','{','"','c','o',
'n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','i','s','V','a','l','i','d',
'H','o','s','t','L','a','b','e','l','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',
':','"','R','e','g','i','o','n','"','}',',','t','r','u','e',']','}',']',',','"','r','u','l','e','s',
'"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"',
'i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','R','e',
'q','u','i','r','e','s','A','c','c','o','u','n','t','I','d','"','}',']','}',',','{','"','f','n','"',
':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[',
'{','"','r','e','f','"',':','"','R','e','q','u','i','r','e','s','A','c','c','o','u','n','t','I','d',
'"','}',',','t','r','u','e',']','}',',','{','"','f','n','"',':','"','n','o','t','"',',','"','a','r',
'g','v','"',':','[','{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',
':','[','{','"','r','e','f','"',':','"','A','c','c','o','u','n','t','I','d','"','}',']','}',']','}',
']',',','"','e','r','r','o','r','"',':','"','A','c','c','o','u','n','t','I','d',' ','i','s',' ','r',
'e','q','u','i','r','e','d',' ','b','u','t',' ','n','o','t',' ','s','e','t','"',',','"','t','y','p',
'e','"',':','"','e','r','r','o','r','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',
':','[','{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{',
'"','r','e','f','"',':','"','A','c','c','o','u','n','t','I','d','"','}',']','}',',','{','"','f','n',
'"',':','"','n','o','t','"',',','"','a','r','g','v','"',':','[','{','"','f','n','"',':','"','i','s',
'V','a','l','i','d','H','o','s','t','L','a','b','e','l','"',',','"','a','r','g','v','"',':','[','{',
'"','r','e','f','"',':','"','A','c','c','o','u','n','t','I','d','"','}',',','f','a','l','s','e',']',
'}',']','}',']',',','"','e','r','r','o','r','"',':','"','A','c','c','o','u','n','t','I','d',' ','m',
'u','s','t',' ','o','n','l','y',' ','c','o','n','t','a','i','n',' ','a','-','z',',',' ','A','-','Z',
',',' ','0','-','9',' ','a','n','d',' ','`','-','`','.','"',',','"','t','y','p','e','"',':','"','e',
'r','r','o','r','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f',
'n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',
':','"','E','n','d','p','o','i','n','t','"','}',']','}',',','{','"','f','n','"',':','"','p','a','r',
's','e','U','R','L','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','E','n',
'd','p','o','i','n','t','"','}',']',',','"','a','s','s','i','g','n','"',':','"','u','r','l','"','}',
']',',','"','r','u','l','e','s','"',':','[','{','"','c','o','n','d','i','t','i','o','n','s','"',':',
'[','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a',
'r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','D','u','a','l','S','t','a','c',
'k','"','}',',','t','r','u','e',']','}',']',',','"','e','r','r','o','r','"',':','"','I','n','v','a',
'l','i','d',' ','C','o','n','f','i','g','u','r','a','t','i','o','n',':',' ','D','u','a','l','S','t',
'a','c','k',' ','a','n','d',' ','c','u','s','t','o','m',' ','e','n','d','p','o','i','n','t',' ','a',
'r','e',' ','n','o','t',' ','s','u','p','p','o','r','t','e','d','"',',','"','t','y','p','e','"',':',
'"','e','r','r','o','r','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{',
'"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r','e',
'f','"',':','"','R','e','q','u','i','r','e','s','A','c','c','o','u','n','t','I','d','"','}',']','}',
',','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a',
'r','g','v','"',':','[','{','"','r','e','f','"',':','"','R','e','q','u','i','r','e','s','A','c','c',
'o','u','n','t','I','d','"','}',',','t','r','u','e',']','}',',','{','"','f','n','"',':','"','i','s',
'S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','A','c','c','o',
'u','n','t','I','d','"','}',']','}',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u',
'r','l','"',':','"','{','u','r','l','#','s','c','h','e','m','e','}',':','/','/','{','A','c','c','o',
'u','n','t','I','d','}','.','{','u','r','l','#','a','u','t','h','o','r','i','t','y','}','{','u','r',
'l','#','p','a','t','h','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a',
'u','t','h','S','c','h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u',
'b','l','e','E','n','c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':',
'"','s','i','g','v','4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3',
'"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','R','e','g','i','o',
'n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','}','}',',','"','t','y','p',
'e','"',':','"','e','n','d','p','o','i','n','t','"','}',',','{','"','c','o','n','d','i','t','i','o',
'n','s','"',':','[',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',':',
'"','{','u','r','l','#','s','c','h','e','m','e','}',':','/','/','{','u','r','l','#','a','u','t','h',
'o','r','i','t','y','}','{','u','r','l','#','p','a','t','h','}','"',',','"','p','r','o','p','e','r',
't','i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[','{','"','d',
'i','s','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':','t','r','u',
'e',',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n','i','n','g',
'N','a','m','e','"',':','"','s','3','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n',
'"',':','"','{','R','e','g','i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',
':','{','}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',']',',',
'"','t','y','p','e','"',':','"','t','r','e','e','"','}',',','{','"','c','o','n','d','i','t','i','o',
'n','s','"',':','[','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s',
'"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','F','I','P','S',
'"','}',',','t','r','u','e',']','}',',','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E',
'q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s',
'e','D','u','a','l','S','t','a','c','k','"','}',',','t','r','u','e',']','}',',','{','"','f','n','"',
':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"',
'R','e','q','u','i','r','e','s','A','c','c','o','u','n','t','I','d','"','}',']','}',',','{','"','f',
'n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',
':','[','{','"','r','e','f','"',':','"','R','e','q','u','i','r','e','s','A','c','c','o','u','n','t',
'I','d','"','}',',','t','r','u','e',']','}',',','{','"','f','n','"',':','"','i','s','S','e','t','"',
',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','A','c','c','o','u','n','t','I',
'd','"','}',']','}',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',':',
'"','h','t','t','p','s',':','/','/','{','A','c','c','o','u','n','t','I','d','}','.','s','3','-','c',
'o','n','t','r','o','l','-','f','i','p','s','.','d','u','a','l','s','t','a','c','k','.','{','R','e',
'g','i','o','n','}','.','{','p','a','r','t','i','t','i','o','n','R','e','s','u','l','t','#','d','n',
's','S','u','f','f','i','x','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"',
'a','u','t','h','S','c','h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o',
'u','b','l','e','E','n','c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',
':','"','s','i','g','v','4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s',
'3','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','R','e','g','i',
'o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','}','}',',','"','t','y',
'p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',',','{','"','c','o','n','d','i','t','i',
'o','n','s','"',':','[','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l',
's','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','F','I','P',
'S','"','}',',','t','r','u','e',']','}',',','{','"','f','n','"',':','"','b','o','o','l','e','a','n',
'E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U',
's','e','D','u','a','l','S','t','a','c','k','"','}',',','t','r','u','e',']','}',']',',','"','e','n',
'd','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/','s',
'3','-','c','o','n','t','r','o','l','-','f','i','p','s','.','d','u','a','l','s','t','a','c','k','.',
'{','R','e','g','i','o','n','}','.','{','p','a','r','t','i','t','i','o','n','R','e','s','u','l','t',
'#','d','n','s','S','u','f','f','i','x','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',
':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l',
'e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a',
'm','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',
':','"','s','3','"',',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','R',
'e','g','i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','}','}',',',
'"','t','y','p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',',','{','"','c','o','n','d',
'i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q',
'u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e',
'F','I','P','S','"','}',',','t','r','u','e',']','}',',','{','"','f','n','"',':','"','b','o','o','l',
'e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',
':','"','U','s','e','D','u','a','l','S','t','a','c','k','"','}',',','f','a','l','s','e',']','}',',',
'{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r',
'e','f','"',':','"','R','e','q','u','i','r','e','s','A','c','c','o','u','n','t','I','d','"','}',']',
'}',',','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"',
'a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','R','e','q','u','i','r','e','s','A','c',
'c','o','u','n','t','I','d','"','}',',','t','r','u','e',']','}',',','{','"','f','n','"',':','"','i',
's','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','A','c','c',
'o','u','n','t','I','d','"','}',']','}',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"',
'u','r','l','"',':','"','h','t','t','p','s',':','/','/','{','A','c','c','o','u','n','t','I','d','}',
'.','s','3','-','c','o','n','t','r','o','l','-','f','i','p','s','.','{','R','e','g','i','o','n','}',
'.','{','p','a','r','t','i','t','i','o','n','R','e','s','u','l','t','#','d','n','s','S','u','f','f',
'i','x','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S',
'c','h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E',
'n','c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g',
'v','4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','"',',','"','s',
'i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','R','e','g','i','o','n','}','"','}',
']','}',',','"','h','e','a','d','e','r','s','"',':','{','}','}',',','"','t','y','p','e','"',':','"',
'e','n','d','p','o','i','n','t','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':',
'[','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a',
'r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','F','I','P','S','"','}',',','t',
'r','u','e',']','}',',','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l',
's','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','D','u','a',
'l','S','t','a','c','k','"','}',',','f','a','l','s','e',']','}',']',',','"','e','n','d','p','o','i',
'n','t','"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/','s','3','-','c','o',
'n','t','r','o','l','-','f','i','p','s','.','{','R','e','g','i','o','n','}','.','{','p','a','r','t',
'i','t','i','o','n','R','e','s','u','l','t','#','d','n','s','S','u','f','f','i','x','}','"',',','"',
'p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s',
'"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n',
'g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s',
'i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','"',',','"','s','i','g','n','i','n','g',
'R','e','g','i','o','n','"',':','"','{','R','e','g','i','o','n','}','"','}',']','}',',','"','h','e',
'a','d','e','r','s','"',':','{','}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i',
'n','t','"','}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',
':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[',
'{','"','r','e','f','"',':','"','U','s','e','F','I','P','S','"','}',',','f','a','l','s','e',']','}',
',','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a',
'r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','D','u','a','l','S','t','a','c',
'k','"','}',',','t','r','u','e',']','}',',','{','"','f','n','"',':','"','i','s','S','e','t','"',',',
'"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','R','e','q','u','i','r','e','s','A',
'c','c','o','u','n','t','I','d','"','}',']','}',',','{','"','f','n','"',':','"','b','o','o','l','e',
'a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':',
'"','R','e','q','u','i','r','e','s','A','c','c','o','u','n','t','I','d','"','}',',','t','r','u','e',
']','}',',','{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',':','[',
'{','"','r','e','f','"',':','"','A','c','c','o','u','n','t','I','d','"','}',']','}',']',',','"','e',
'n','d','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/',
'{','A','c','c','o','u','n','t','I','d','}','.','s','3','-','c','o','n','t','r','o','l','.','d','u',
'a','l','s','t','a','c','k','.','{','R','e','g','i','o','n','}','.','{','p','a','r','t','i','t','i',
'o','n','R','e','s','u','l','t','#','d','n','s','S','u','f','f','i','x','}','"',',','"','p','r','o',
'p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[',
'{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':',
't','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n',
'i','n','g','N','a','m','e','"',':','"','s','3','"',',','"','s','i','g','n','i','n','g','R','e','g',
'i','o','n','"',':','"','{','R','e','g','i','o','n','}','"','}',']','}',',','"','h','e','a','d','e',
'r','s','"',':','{','}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i','n','t','"',
'}',',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','b',
'o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r',
'e','f','"',':','"','U','s','e','F','I','P','S','"','}',',','f','a','l','s','e',']','}',',','{','"',
'f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v',
'"',':','[','{','"','r','e','f','"',':','"','U','s','e','D','u','a','l','S','t','a','c','k','"','}',
',','t','r','u','e',']','}',']',',','"','e','n','d','p','o','i','n','t','"',':','{','"','u','r','l',
'"',':','"','h','t','t','p','s',':','/','/','s','3','-','c','o','n','t','r','o','l','.','d','u','a',
'l','s','t','a','c','k','.','{','R','e','g','i','o','n','}','.','{','p','a','r','t','i','t','i','o',
'n','R','e','s','u','l','t','#','d','n','s','S','u','f','f','i','x','}','"',',','"','p','r','o','p',
'e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',':','[','{',
'"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g','"',':','t',
'r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i','g','n','i',
'n','g','N','a','m','e','"',':','"','s','3','"',',','"','s','i','g','n','i','n','g','R','e','g','i',
'o','n','"',':','"','{','R','e','g','i','o','n','}','"','}',']','}',',','"','h','e','a','d','e','r',
's','"',':','{','}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i','n','t','"','}',
',','{','"','c','o','n','d','i','t','i','o','n','s','"',':','[','{','"','f','n','"',':','"','b','o',
'o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e',
'f','"',':','"','U','s','e','F','I','P','S','"','}',',','f','a','l','s','e',']','}',',','{','"','f',
'n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',',','"','a','r','g','v','"',
':','[','{','"','r','e','f','"',':','"','U','s','e','D','u','a','l','S','t','a','c','k','"','}',',',
'f','a','l','s','e',']','}',',','{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r',
'g','v','"',':','[','{','"','r','e','f','"',':','"','R','e','q','u','i','r','e','s','A','c','c','o',
'u','n','t','I','d','"','}',']','}',',','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E',
'q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','R','e',
'q','u','i','r','e','s','A','c','c','o','u','n','t','I','d','"','}',',','t','r','u','e',']','}',',',
'{','"','f','n','"',':','"','i','s','S','e','t','"',',','"','a','r','g','v','"',':','[','{','"','r',
'e','f','"',':','"','A','c','c','o','u','n','t','I','d','"','}',']','}',']',',','"','e','n','d','p',
'o','i','n','t','"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/','{','A','c',
'c','o','u','n','t','I','d','}','.','s','3','-','c','o','n','t','r','o','l','.','{','R','e','g','i',
'o','n','}','.','{','p','a','r','t','i','t','i','o','n','R','e','s','u','l','t','#','d','n','s','S',
'u','f','f','i','x','}','"',',','"','p','r','o','p','e','r','t','i','e','s','"',':','{','"','a','u',
't','h','S','c','h','e','m','e','s','"',':','[','{','"','d','i','s','a','b','l','e','D','o','u','b',
'l','e','E','n','c','o','d','i','n','g','"',':','t','r','u','e',',','"','n','a','m','e','"',':','"',
's','i','g','v','4','"',',','"','s','i','g','n','i','n','g','N','a','m','e','"',':','"','s','3','"',
',','"','s','i','g','n','i','n','g','R','e','g','i','o','n','"',':','"','{','R','e','g','i','o','n',
'}','"','}',']','}',',','"','h','e','a','d','e','r','s','"',':','{','}','}',',','"','t','y','p','e',
'"',':','"','e','n','d','p','o','i','n','t','"','}',',','{','"','c','o','n','d','i','t','i','o','n',
's','"',':','[','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E','q','u','a','l','s','"',
',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s','e','F','I','P','S','"',
'}',',','f','a','l','s','e',']','}',',','{','"','f','n','"',':','"','b','o','o','l','e','a','n','E',
'q','u','a','l','s','"',',','"','a','r','g','v','"',':','[','{','"','r','e','f','"',':','"','U','s',
'e','D','u','a','l','S','t','a','c','k','"','}',',','f','a','l','s','e',']','}',']',',','"','e','n',
'd','p','o','i','n','t','"',':','{','"','u','r','l','"',':','"','h','t','t','p','s',':','/','/','s',
'3','-','c','o','n','t','r','o','l','.','{','R','e','g','i','o','n','}','.','{','p','a','r','t','i',
't','i','o','n','R','e','s','u','l','t','#','d','n','s','S','u','f','f','i','x','}','"',',','"','p',
'r','o','p','e','r','t','i','e','s','"',':','{','"','a','u','t','h','S','c','h','e','m','e','s','"',
':','[','{','"','d','i','s','a','b','l','e','D','o','u','b','l','e','E','n','c','o','d','i','n','g',
'"',':','t','r','u','e',',','"','n','a','m','e','"',':','"','s','i','g','v','4','"',',','"','s','i',
'g','n','i','n','g','N','a','m','e','"',':','"','s','3','"',',','"','s','i','g','n','i','n','g','R',
'e','g','i','o','n','"',':','"','{','R','e','g','i','o','n','}','"','}',']','}',',','"','h','e','a',
'd','e','r','s','"',':','{','}','}',',','"','t','y','p','e','"',':','"','e','n','d','p','o','i','n',
't','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',',','{','"','c','o','n',
'd','i','t','i','o','n','s','"',':','[',']',',','"','e','r','r','o','r','"',':','"','I','n','v','a',
'l','i','d',' ','r','e','g','i','o','n',':',' ','r','e','g','i','o','n',' ','w','a','s',' ','n','o',
't',' ','a',' ','v','a','l','i','d',' ','D','N','S',' ','n','a','m','e','.','"',',','"','t','y','p',
'e','"',':','"','e','r','r','o','r','"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e',
'"','}',']',',','"','t','y','p','e','"',':','"','t','r','e','e','"','}',',','{','"','c','o','n','d',
'i','t','i','o','n','s','"',':','[',']',',','"','e','r','r','o','r','"',':','"','R','e','g','i','o',
'n',' ','m','u','s','t',' ','b','e',' ','s','e','t','"',',','"','t','y','p','e','"',':','"','e','r',
'r','o','r','"','}',']','}','\0'
}};

const char* S3ControlEndpointRules::GetRulesBlob()
{
    return RulesBlob.data();
}

} // namespace S3Control
} // namespace Aws
