﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/securityhub/model/AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace SecurityHub
{
namespace Model
{

AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails::AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails(JsonView jsonValue)
{
  *this = jsonValue;
}

AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails& AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("ScanEc2InstanceWithFindings"))
  {
    m_scanEc2InstanceWithFindings = jsonValue.GetObject("ScanEc2InstanceWithFindings");
    m_scanEc2InstanceWithFindingsHasBeenSet = true;
  }
  if(jsonValue.ValueExists("ServiceRole"))
  {
    m_serviceRole = jsonValue.GetString("ServiceRole");
    m_serviceRoleHasBeenSet = true;
  }
  return *this;
}

JsonValue AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails::Jsonize() const
{
  JsonValue payload;

  if(m_scanEc2InstanceWithFindingsHasBeenSet)
  {
   payload.WithObject("ScanEc2InstanceWithFindings", m_scanEc2InstanceWithFindings.Jsonize());

  }

  if(m_serviceRoleHasBeenSet)
  {
   payload.WithString("ServiceRole", m_serviceRole);

  }

  return payload;
}

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
