﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/securityhub/model/Malware.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace SecurityHub
{
namespace Model
{

Malware::Malware(JsonView jsonValue)
{
  *this = jsonValue;
}

Malware& Malware::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Name"))
  {
    m_name = jsonValue.GetString("Name");
    m_nameHasBeenSet = true;
  }
  if(jsonValue.ValueExists("Type"))
  {
    m_type = MalwareTypeMapper::GetMalwareTypeForName(jsonValue.GetString("Type"));
    m_typeHasBeenSet = true;
  }
  if(jsonValue.ValueExists("Path"))
  {
    m_path = jsonValue.GetString("Path");
    m_pathHasBeenSet = true;
  }
  if(jsonValue.ValueExists("State"))
  {
    m_state = MalwareStateMapper::GetMalwareStateForName(jsonValue.GetString("State"));
    m_stateHasBeenSet = true;
  }
  return *this;
}

JsonValue Malware::Jsonize() const
{
  JsonValue payload;

  if(m_nameHasBeenSet)
  {
   payload.WithString("Name", m_name);

  }

  if(m_typeHasBeenSet)
  {
   payload.WithString("Type", MalwareTypeMapper::GetNameForMalwareType(m_type));
  }

  if(m_pathHasBeenSet)
  {
   payload.WithString("Path", m_path);

  }

  if(m_stateHasBeenSet)
  {
   payload.WithString("State", MalwareStateMapper::GetNameForMalwareState(m_state));
  }

  return payload;
}

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
