﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/securityhub/model/MalwareType.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace SecurityHub
  {
    namespace Model
    {
      namespace MalwareTypeMapper
      {

        static const int ADWARE_HASH = HashingUtils::HashString("ADWARE");
        static const int BLENDED_THREAT_HASH = HashingUtils::HashString("BLENDED_THREAT");
        static const int BOTNET_AGENT_HASH = HashingUtils::HashString("BOTNET_AGENT");
        static const int COIN_MINER_HASH = HashingUtils::HashString("COIN_MINER");
        static const int EXPLOIT_KIT_HASH = HashingUtils::HashString("EXPLOIT_KIT");
        static const int KEYLOGGER_HASH = HashingUtils::HashString("KEYLOGGER");
        static const int MACRO_HASH = HashingUtils::HashString("MACRO");
        static const int POTENTIALLY_UNWANTED_HASH = HashingUtils::HashString("POTENTIALLY_UNWANTED");
        static const int SPYWARE_HASH = HashingUtils::HashString("SPYWARE");
        static const int RANSOMWARE_HASH = HashingUtils::HashString("RANSOMWARE");
        static const int REMOTE_ACCESS_HASH = HashingUtils::HashString("REMOTE_ACCESS");
        static const int ROOTKIT_HASH = HashingUtils::HashString("ROOTKIT");
        static const int TROJAN_HASH = HashingUtils::HashString("TROJAN");
        static const int VIRUS_HASH = HashingUtils::HashString("VIRUS");
        static const int WORM_HASH = HashingUtils::HashString("WORM");


        MalwareType GetMalwareTypeForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == ADWARE_HASH)
          {
            return MalwareType::ADWARE;
          }
          else if (hashCode == BLENDED_THREAT_HASH)
          {
            return MalwareType::BLENDED_THREAT;
          }
          else if (hashCode == BOTNET_AGENT_HASH)
          {
            return MalwareType::BOTNET_AGENT;
          }
          else if (hashCode == COIN_MINER_HASH)
          {
            return MalwareType::COIN_MINER;
          }
          else if (hashCode == EXPLOIT_KIT_HASH)
          {
            return MalwareType::EXPLOIT_KIT;
          }
          else if (hashCode == KEYLOGGER_HASH)
          {
            return MalwareType::KEYLOGGER;
          }
          else if (hashCode == MACRO_HASH)
          {
            return MalwareType::MACRO;
          }
          else if (hashCode == POTENTIALLY_UNWANTED_HASH)
          {
            return MalwareType::POTENTIALLY_UNWANTED;
          }
          else if (hashCode == SPYWARE_HASH)
          {
            return MalwareType::SPYWARE;
          }
          else if (hashCode == RANSOMWARE_HASH)
          {
            return MalwareType::RANSOMWARE;
          }
          else if (hashCode == REMOTE_ACCESS_HASH)
          {
            return MalwareType::REMOTE_ACCESS;
          }
          else if (hashCode == ROOTKIT_HASH)
          {
            return MalwareType::ROOTKIT;
          }
          else if (hashCode == TROJAN_HASH)
          {
            return MalwareType::TROJAN;
          }
          else if (hashCode == VIRUS_HASH)
          {
            return MalwareType::VIRUS;
          }
          else if (hashCode == WORM_HASH)
          {
            return MalwareType::WORM;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<MalwareType>(hashCode);
          }

          return MalwareType::NOT_SET;
        }

        Aws::String GetNameForMalwareType(MalwareType enumValue)
        {
          switch(enumValue)
          {
          case MalwareType::NOT_SET:
            return {};
          case MalwareType::ADWARE:
            return "ADWARE";
          case MalwareType::BLENDED_THREAT:
            return "BLENDED_THREAT";
          case MalwareType::BOTNET_AGENT:
            return "BOTNET_AGENT";
          case MalwareType::COIN_MINER:
            return "COIN_MINER";
          case MalwareType::EXPLOIT_KIT:
            return "EXPLOIT_KIT";
          case MalwareType::KEYLOGGER:
            return "KEYLOGGER";
          case MalwareType::MACRO:
            return "MACRO";
          case MalwareType::POTENTIALLY_UNWANTED:
            return "POTENTIALLY_UNWANTED";
          case MalwareType::SPYWARE:
            return "SPYWARE";
          case MalwareType::RANSOMWARE:
            return "RANSOMWARE";
          case MalwareType::REMOTE_ACCESS:
            return "REMOTE_ACCESS";
          case MalwareType::ROOTKIT:
            return "ROOTKIT";
          case MalwareType::TROJAN:
            return "TROJAN";
          case MalwareType::VIRUS:
            return "VIRUS";
          case MalwareType::WORM:
            return "WORM";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace MalwareTypeMapper
    } // namespace Model
  } // namespace SecurityHub
} // namespace Aws
