﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/securityhub/model/Vulnerability.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace SecurityHub
{
namespace Model
{

Vulnerability::Vulnerability(JsonView jsonValue)
{
  *this = jsonValue;
}

Vulnerability& Vulnerability::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Id"))
  {
    m_id = jsonValue.GetString("Id");
    m_idHasBeenSet = true;
  }
  if(jsonValue.ValueExists("VulnerablePackages"))
  {
    Aws::Utils::Array<JsonView> vulnerablePackagesJsonList = jsonValue.GetArray("VulnerablePackages");
    for(unsigned vulnerablePackagesIndex = 0; vulnerablePackagesIndex < vulnerablePackagesJsonList.GetLength(); ++vulnerablePackagesIndex)
    {
      m_vulnerablePackages.push_back(vulnerablePackagesJsonList[vulnerablePackagesIndex].AsObject());
    }
    m_vulnerablePackagesHasBeenSet = true;
  }
  if(jsonValue.ValueExists("Cvss"))
  {
    Aws::Utils::Array<JsonView> cvssJsonList = jsonValue.GetArray("Cvss");
    for(unsigned cvssIndex = 0; cvssIndex < cvssJsonList.GetLength(); ++cvssIndex)
    {
      m_cvss.push_back(cvssJsonList[cvssIndex].AsObject());
    }
    m_cvssHasBeenSet = true;
  }
  if(jsonValue.ValueExists("RelatedVulnerabilities"))
  {
    Aws::Utils::Array<JsonView> relatedVulnerabilitiesJsonList = jsonValue.GetArray("RelatedVulnerabilities");
    for(unsigned relatedVulnerabilitiesIndex = 0; relatedVulnerabilitiesIndex < relatedVulnerabilitiesJsonList.GetLength(); ++relatedVulnerabilitiesIndex)
    {
      m_relatedVulnerabilities.push_back(relatedVulnerabilitiesJsonList[relatedVulnerabilitiesIndex].AsString());
    }
    m_relatedVulnerabilitiesHasBeenSet = true;
  }
  if(jsonValue.ValueExists("Vendor"))
  {
    m_vendor = jsonValue.GetObject("Vendor");
    m_vendorHasBeenSet = true;
  }
  if(jsonValue.ValueExists("ReferenceUrls"))
  {
    Aws::Utils::Array<JsonView> referenceUrlsJsonList = jsonValue.GetArray("ReferenceUrls");
    for(unsigned referenceUrlsIndex = 0; referenceUrlsIndex < referenceUrlsJsonList.GetLength(); ++referenceUrlsIndex)
    {
      m_referenceUrls.push_back(referenceUrlsJsonList[referenceUrlsIndex].AsString());
    }
    m_referenceUrlsHasBeenSet = true;
  }
  if(jsonValue.ValueExists("FixAvailable"))
  {
    m_fixAvailable = VulnerabilityFixAvailableMapper::GetVulnerabilityFixAvailableForName(jsonValue.GetString("FixAvailable"));
    m_fixAvailableHasBeenSet = true;
  }
  if(jsonValue.ValueExists("EpssScore"))
  {
    m_epssScore = jsonValue.GetDouble("EpssScore");
    m_epssScoreHasBeenSet = true;
  }
  if(jsonValue.ValueExists("ExploitAvailable"))
  {
    m_exploitAvailable = VulnerabilityExploitAvailableMapper::GetVulnerabilityExploitAvailableForName(jsonValue.GetString("ExploitAvailable"));
    m_exploitAvailableHasBeenSet = true;
  }
  if(jsonValue.ValueExists("LastKnownExploitAt"))
  {
    m_lastKnownExploitAt = jsonValue.GetString("LastKnownExploitAt");
    m_lastKnownExploitAtHasBeenSet = true;
  }
  if(jsonValue.ValueExists("CodeVulnerabilities"))
  {
    Aws::Utils::Array<JsonView> codeVulnerabilitiesJsonList = jsonValue.GetArray("CodeVulnerabilities");
    for(unsigned codeVulnerabilitiesIndex = 0; codeVulnerabilitiesIndex < codeVulnerabilitiesJsonList.GetLength(); ++codeVulnerabilitiesIndex)
    {
      m_codeVulnerabilities.push_back(codeVulnerabilitiesJsonList[codeVulnerabilitiesIndex].AsObject());
    }
    m_codeVulnerabilitiesHasBeenSet = true;
  }
  return *this;
}

JsonValue Vulnerability::Jsonize() const
{
  JsonValue payload;

  if(m_idHasBeenSet)
  {
   payload.WithString("Id", m_id);

  }

  if(m_vulnerablePackagesHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> vulnerablePackagesJsonList(m_vulnerablePackages.size());
   for(unsigned vulnerablePackagesIndex = 0; vulnerablePackagesIndex < vulnerablePackagesJsonList.GetLength(); ++vulnerablePackagesIndex)
   {
     vulnerablePackagesJsonList[vulnerablePackagesIndex].AsObject(m_vulnerablePackages[vulnerablePackagesIndex].Jsonize());
   }
   payload.WithArray("VulnerablePackages", std::move(vulnerablePackagesJsonList));

  }

  if(m_cvssHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> cvssJsonList(m_cvss.size());
   for(unsigned cvssIndex = 0; cvssIndex < cvssJsonList.GetLength(); ++cvssIndex)
   {
     cvssJsonList[cvssIndex].AsObject(m_cvss[cvssIndex].Jsonize());
   }
   payload.WithArray("Cvss", std::move(cvssJsonList));

  }

  if(m_relatedVulnerabilitiesHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> relatedVulnerabilitiesJsonList(m_relatedVulnerabilities.size());
   for(unsigned relatedVulnerabilitiesIndex = 0; relatedVulnerabilitiesIndex < relatedVulnerabilitiesJsonList.GetLength(); ++relatedVulnerabilitiesIndex)
   {
     relatedVulnerabilitiesJsonList[relatedVulnerabilitiesIndex].AsString(m_relatedVulnerabilities[relatedVulnerabilitiesIndex]);
   }
   payload.WithArray("RelatedVulnerabilities", std::move(relatedVulnerabilitiesJsonList));

  }

  if(m_vendorHasBeenSet)
  {
   payload.WithObject("Vendor", m_vendor.Jsonize());

  }

  if(m_referenceUrlsHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> referenceUrlsJsonList(m_referenceUrls.size());
   for(unsigned referenceUrlsIndex = 0; referenceUrlsIndex < referenceUrlsJsonList.GetLength(); ++referenceUrlsIndex)
   {
     referenceUrlsJsonList[referenceUrlsIndex].AsString(m_referenceUrls[referenceUrlsIndex]);
   }
   payload.WithArray("ReferenceUrls", std::move(referenceUrlsJsonList));

  }

  if(m_fixAvailableHasBeenSet)
  {
   payload.WithString("FixAvailable", VulnerabilityFixAvailableMapper::GetNameForVulnerabilityFixAvailable(m_fixAvailable));
  }

  if(m_epssScoreHasBeenSet)
  {
   payload.WithDouble("EpssScore", m_epssScore);

  }

  if(m_exploitAvailableHasBeenSet)
  {
   payload.WithString("ExploitAvailable", VulnerabilityExploitAvailableMapper::GetNameForVulnerabilityExploitAvailable(m_exploitAvailable));
  }

  if(m_lastKnownExploitAtHasBeenSet)
  {
   payload.WithString("LastKnownExploitAt", m_lastKnownExploitAt);

  }

  if(m_codeVulnerabilitiesHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> codeVulnerabilitiesJsonList(m_codeVulnerabilities.size());
   for(unsigned codeVulnerabilitiesIndex = 0; codeVulnerabilitiesIndex < codeVulnerabilitiesJsonList.GetLength(); ++codeVulnerabilitiesIndex)
   {
     codeVulnerabilitiesJsonList[codeVulnerabilitiesIndex].AsObject(m_codeVulnerabilities[codeVulnerabilitiesIndex].Jsonize());
   }
   payload.WithArray("CodeVulnerabilities", std::move(codeVulnerabilitiesJsonList));

  }

  return payload;
}

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
