﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/securityhub/model/VulnerabilityCodeVulnerabilities.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace SecurityHub
{
namespace Model
{

VulnerabilityCodeVulnerabilities::VulnerabilityCodeVulnerabilities(JsonView jsonValue)
{
  *this = jsonValue;
}

VulnerabilityCodeVulnerabilities& VulnerabilityCodeVulnerabilities::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Cwes"))
  {
    Aws::Utils::Array<JsonView> cwesJsonList = jsonValue.GetArray("Cwes");
    for(unsigned cwesIndex = 0; cwesIndex < cwesJsonList.GetLength(); ++cwesIndex)
    {
      m_cwes.push_back(cwesJsonList[cwesIndex].AsString());
    }
    m_cwesHasBeenSet = true;
  }
  if(jsonValue.ValueExists("FilePath"))
  {
    m_filePath = jsonValue.GetObject("FilePath");
    m_filePathHasBeenSet = true;
  }
  if(jsonValue.ValueExists("SourceArn"))
  {
    m_sourceArn = jsonValue.GetString("SourceArn");
    m_sourceArnHasBeenSet = true;
  }
  return *this;
}

JsonValue VulnerabilityCodeVulnerabilities::Jsonize() const
{
  JsonValue payload;

  if(m_cwesHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> cwesJsonList(m_cwes.size());
   for(unsigned cwesIndex = 0; cwesIndex < cwesJsonList.GetLength(); ++cwesIndex)
   {
     cwesJsonList[cwesIndex].AsString(m_cwes[cwesIndex]);
   }
   payload.WithArray("Cwes", std::move(cwesJsonList));

  }

  if(m_filePathHasBeenSet)
  {
   payload.WithObject("FilePath", m_filePath.Jsonize());

  }

  if(m_sourceArnHasBeenSet)
  {
   payload.WithString("SourceArn", m_sourceArn);

  }

  return payload;
}

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
