﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/securityhub/model/VulnerabilityVendor.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace SecurityHub
{
namespace Model
{

VulnerabilityVendor::VulnerabilityVendor(JsonView jsonValue)
{
  *this = jsonValue;
}

VulnerabilityVendor& VulnerabilityVendor::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Name"))
  {
    m_name = jsonValue.GetString("Name");
    m_nameHasBeenSet = true;
  }
  if(jsonValue.ValueExists("Url"))
  {
    m_url = jsonValue.GetString("Url");
    m_urlHasBeenSet = true;
  }
  if(jsonValue.ValueExists("VendorSeverity"))
  {
    m_vendorSeverity = jsonValue.GetString("VendorSeverity");
    m_vendorSeverityHasBeenSet = true;
  }
  if(jsonValue.ValueExists("VendorCreatedAt"))
  {
    m_vendorCreatedAt = jsonValue.GetString("VendorCreatedAt");
    m_vendorCreatedAtHasBeenSet = true;
  }
  if(jsonValue.ValueExists("VendorUpdatedAt"))
  {
    m_vendorUpdatedAt = jsonValue.GetString("VendorUpdatedAt");
    m_vendorUpdatedAtHasBeenSet = true;
  }
  return *this;
}

JsonValue VulnerabilityVendor::Jsonize() const
{
  JsonValue payload;

  if(m_nameHasBeenSet)
  {
   payload.WithString("Name", m_name);

  }

  if(m_urlHasBeenSet)
  {
   payload.WithString("Url", m_url);

  }

  if(m_vendorSeverityHasBeenSet)
  {
   payload.WithString("VendorSeverity", m_vendorSeverity);

  }

  if(m_vendorCreatedAtHasBeenSet)
  {
   payload.WithString("VendorCreatedAt", m_vendorCreatedAt);

  }

  if(m_vendorUpdatedAtHasBeenSet)
  {
   payload.WithString("VendorUpdatedAt", m_vendorUpdatedAt);

  }

  return payload;
}

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
