/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/accessanalyzer/AccessAnalyzerClient.h>
#include <aws/accessanalyzer/AccessAnalyzerEndpointProvider.h>
#include <aws/accessanalyzer/AccessAnalyzerEndpointRules.h>
#include <aws/accessanalyzer/AccessAnalyzerErrorMarshaller.h>
#include <aws/accessanalyzer/AccessAnalyzerErrors.h>
#include <aws/accessanalyzer/AccessAnalyzerRequest.h>
#include <aws/accessanalyzer/AccessAnalyzerServiceClientModel.h>
#include <aws/accessanalyzer/AccessAnalyzer_EXPORTS.h>
#include <aws/accessanalyzer/model/Access.h>
#include <aws/accessanalyzer/model/AccessCheckPolicyType.h>
#include <aws/accessanalyzer/model/AccessCheckResourceType.h>
#include <aws/accessanalyzer/model/AccessPreview.h>
#include <aws/accessanalyzer/model/AccessPreviewFinding.h>
#include <aws/accessanalyzer/model/AccessPreviewStatus.h>
#include <aws/accessanalyzer/model/AccessPreviewStatusReason.h>
#include <aws/accessanalyzer/model/AccessPreviewStatusReasonCode.h>
#include <aws/accessanalyzer/model/AccessPreviewSummary.h>
#include <aws/accessanalyzer/model/AclGrantee.h>
#include <aws/accessanalyzer/model/AclPermission.h>
#include <aws/accessanalyzer/model/AnalysisRule.h>
#include <aws/accessanalyzer/model/AnalysisRuleCriteria.h>
#include <aws/accessanalyzer/model/AnalyzedResource.h>
#include <aws/accessanalyzer/model/AnalyzedResourceSummary.h>
#include <aws/accessanalyzer/model/AnalyzerConfiguration.h>
#include <aws/accessanalyzer/model/AnalyzerStatus.h>
#include <aws/accessanalyzer/model/AnalyzerSummary.h>
#include <aws/accessanalyzer/model/ApplyArchiveRuleRequest.h>
#include <aws/accessanalyzer/model/ArchiveRuleSummary.h>
#include <aws/accessanalyzer/model/CancelPolicyGenerationRequest.h>
#include <aws/accessanalyzer/model/CancelPolicyGenerationResult.h>
#include <aws/accessanalyzer/model/CheckAccessNotGrantedRequest.h>
#include <aws/accessanalyzer/model/CheckAccessNotGrantedResult.h>
#include <aws/accessanalyzer/model/CheckAccessNotGrantedSdkResult.h>
#include <aws/accessanalyzer/model/CheckNoNewAccessRequest.h>
#include <aws/accessanalyzer/model/CheckNoNewAccessResult.h>
#include <aws/accessanalyzer/model/CheckNoNewAccessSdkResult.h>
#include <aws/accessanalyzer/model/CheckNoPublicAccessRequest.h>
#include <aws/accessanalyzer/model/CheckNoPublicAccessResult.h>
#include <aws/accessanalyzer/model/CheckNoPublicAccessSdkResult.h>
#include <aws/accessanalyzer/model/CloudTrailDetails.h>
#include <aws/accessanalyzer/model/CloudTrailProperties.h>
#include <aws/accessanalyzer/model/Configuration.h>
#include <aws/accessanalyzer/model/ConflictException.h>
#include <aws/accessanalyzer/model/CreateAccessPreviewRequest.h>
#include <aws/accessanalyzer/model/CreateAccessPreviewResult.h>
#include <aws/accessanalyzer/model/CreateAnalyzerRequest.h>
#include <aws/accessanalyzer/model/CreateAnalyzerResult.h>
#include <aws/accessanalyzer/model/CreateArchiveRuleRequest.h>
#include <aws/accessanalyzer/model/Criterion.h>
#include <aws/accessanalyzer/model/DeleteAnalyzerRequest.h>
#include <aws/accessanalyzer/model/DeleteArchiveRuleRequest.h>
#include <aws/accessanalyzer/model/DynamodbStreamConfiguration.h>
#include <aws/accessanalyzer/model/DynamodbTableConfiguration.h>
#include <aws/accessanalyzer/model/EbsSnapshotConfiguration.h>
#include <aws/accessanalyzer/model/EcrRepositoryConfiguration.h>
#include <aws/accessanalyzer/model/EfsFileSystemConfiguration.h>
#include <aws/accessanalyzer/model/ExternalAccessDetails.h>
#include <aws/accessanalyzer/model/ExternalAccessFindingsStatistics.h>
#include <aws/accessanalyzer/model/Finding.h>
#include <aws/accessanalyzer/model/FindingAggregationAccountDetails.h>
#include <aws/accessanalyzer/model/FindingChangeType.h>
#include <aws/accessanalyzer/model/FindingDetails.h>
#include <aws/accessanalyzer/model/FindingSource.h>
#include <aws/accessanalyzer/model/FindingSourceDetail.h>
#include <aws/accessanalyzer/model/FindingSourceType.h>
#include <aws/accessanalyzer/model/FindingStatus.h>
#include <aws/accessanalyzer/model/FindingStatusUpdate.h>
#include <aws/accessanalyzer/model/FindingSummary.h>
#include <aws/accessanalyzer/model/FindingSummaryV2.h>
#include <aws/accessanalyzer/model/FindingType.h>
#include <aws/accessanalyzer/model/FindingsStatistics.h>
#include <aws/accessanalyzer/model/GenerateFindingRecommendationRequest.h>
#include <aws/accessanalyzer/model/GeneratedPolicy.h>
#include <aws/accessanalyzer/model/GeneratedPolicyProperties.h>
#include <aws/accessanalyzer/model/GeneratedPolicyResults.h>
#include <aws/accessanalyzer/model/GetAccessPreviewRequest.h>
#include <aws/accessanalyzer/model/GetAccessPreviewResult.h>
#include <aws/accessanalyzer/model/GetAnalyzedResourceRequest.h>
#include <aws/accessanalyzer/model/GetAnalyzedResourceResult.h>
#include <aws/accessanalyzer/model/GetAnalyzerRequest.h>
#include <aws/accessanalyzer/model/GetAnalyzerResult.h>
#include <aws/accessanalyzer/model/GetArchiveRuleRequest.h>
#include <aws/accessanalyzer/model/GetArchiveRuleResult.h>
#include <aws/accessanalyzer/model/GetFindingRecommendationRequest.h>
#include <aws/accessanalyzer/model/GetFindingRecommendationResult.h>
#include <aws/accessanalyzer/model/GetFindingRequest.h>
#include <aws/accessanalyzer/model/GetFindingResult.h>
#include <aws/accessanalyzer/model/GetFindingV2Request.h>
#include <aws/accessanalyzer/model/GetFindingV2Result.h>
#include <aws/accessanalyzer/model/GetFindingsStatisticsRequest.h>
#include <aws/accessanalyzer/model/GetFindingsStatisticsResult.h>
#include <aws/accessanalyzer/model/GetGeneratedPolicyRequest.h>
#include <aws/accessanalyzer/model/GetGeneratedPolicyResult.h>
#include <aws/accessanalyzer/model/IamRoleConfiguration.h>
#include <aws/accessanalyzer/model/InlineArchiveRule.h>
#include <aws/accessanalyzer/model/InternalAccessAnalysisRule.h>
#include <aws/accessanalyzer/model/InternalAccessAnalysisRuleCriteria.h>
#include <aws/accessanalyzer/model/InternalAccessConfiguration.h>
#include <aws/accessanalyzer/model/InternalAccessDetails.h>
#include <aws/accessanalyzer/model/InternalAccessFindingsStatistics.h>
#include <aws/accessanalyzer/model/InternalAccessResourceTypeDetails.h>
#include <aws/accessanalyzer/model/InternalAccessType.h>
#include <aws/accessanalyzer/model/InternalServerException.h>
#include <aws/accessanalyzer/model/InternetConfiguration.h>
#include <aws/accessanalyzer/model/JobDetails.h>
#include <aws/accessanalyzer/model/JobError.h>
#include <aws/accessanalyzer/model/JobErrorCode.h>
#include <aws/accessanalyzer/model/JobStatus.h>
#include <aws/accessanalyzer/model/KmsGrantConfiguration.h>
#include <aws/accessanalyzer/model/KmsGrantConstraints.h>
#include <aws/accessanalyzer/model/KmsGrantOperation.h>
#include <aws/accessanalyzer/model/KmsKeyConfiguration.h>
#include <aws/accessanalyzer/model/ListAccessPreviewFindingsRequest.h>
#include <aws/accessanalyzer/model/ListAccessPreviewFindingsResult.h>
#include <aws/accessanalyzer/model/ListAccessPreviewsRequest.h>
#include <aws/accessanalyzer/model/ListAccessPreviewsResult.h>
#include <aws/accessanalyzer/model/ListAnalyzedResourcesRequest.h>
#include <aws/accessanalyzer/model/ListAnalyzedResourcesResult.h>
#include <aws/accessanalyzer/model/ListAnalyzersRequest.h>
#include <aws/accessanalyzer/model/ListAnalyzersResult.h>
#include <aws/accessanalyzer/model/ListArchiveRulesRequest.h>
#include <aws/accessanalyzer/model/ListArchiveRulesResult.h>
#include <aws/accessanalyzer/model/ListFindingsRequest.h>
#include <aws/accessanalyzer/model/ListFindingsResult.h>
#include <aws/accessanalyzer/model/ListFindingsV2Request.h>
#include <aws/accessanalyzer/model/ListFindingsV2Result.h>
#include <aws/accessanalyzer/model/ListPolicyGenerationsRequest.h>
#include <aws/accessanalyzer/model/ListPolicyGenerationsResult.h>
#include <aws/accessanalyzer/model/ListTagsForResourceRequest.h>
#include <aws/accessanalyzer/model/ListTagsForResourceResult.h>
#include <aws/accessanalyzer/model/Locale.h>
#include <aws/accessanalyzer/model/Location.h>
#include <aws/accessanalyzer/model/NetworkOriginConfiguration.h>
#include <aws/accessanalyzer/model/OrderBy.h>
#include <aws/accessanalyzer/model/PathElement.h>
#include <aws/accessanalyzer/model/PolicyGeneration.h>
#include <aws/accessanalyzer/model/PolicyGenerationDetails.h>
#include <aws/accessanalyzer/model/PolicyType.h>
#include <aws/accessanalyzer/model/Position.h>
#include <aws/accessanalyzer/model/PrincipalType.h>
#include <aws/accessanalyzer/model/RdsDbClusterSnapshotAttributeValue.h>
#include <aws/accessanalyzer/model/RdsDbClusterSnapshotConfiguration.h>
#include <aws/accessanalyzer/model/RdsDbSnapshotAttributeValue.h>
#include <aws/accessanalyzer/model/RdsDbSnapshotConfiguration.h>
#include <aws/accessanalyzer/model/ReasonCode.h>
#include <aws/accessanalyzer/model/ReasonSummary.h>
#include <aws/accessanalyzer/model/RecommendationError.h>
#include <aws/accessanalyzer/model/RecommendationType.h>
#include <aws/accessanalyzer/model/RecommendedRemediationAction.h>
#include <aws/accessanalyzer/model/RecommendedStep.h>
#include <aws/accessanalyzer/model/ResourceControlPolicyRestriction.h>
#include <aws/accessanalyzer/model/ResourceNotFoundException.h>
#include <aws/accessanalyzer/model/ResourceType.h>
#include <aws/accessanalyzer/model/ResourceTypeDetails.h>
#include <aws/accessanalyzer/model/S3AccessPointConfiguration.h>
#include <aws/accessanalyzer/model/S3BucketAclGrantConfiguration.h>
#include <aws/accessanalyzer/model/S3BucketConfiguration.h>
#include <aws/accessanalyzer/model/S3ExpressDirectoryAccessPointConfiguration.h>
#include <aws/accessanalyzer/model/S3ExpressDirectoryBucketConfiguration.h>
#include <aws/accessanalyzer/model/S3PublicAccessBlockConfiguration.h>
#include <aws/accessanalyzer/model/SecretsManagerSecretConfiguration.h>
#include <aws/accessanalyzer/model/ServiceControlPolicyRestriction.h>
#include <aws/accessanalyzer/model/ServiceQuotaExceededException.h>
#include <aws/accessanalyzer/model/SnsTopicConfiguration.h>
#include <aws/accessanalyzer/model/SortCriteria.h>
#include <aws/accessanalyzer/model/Span.h>
#include <aws/accessanalyzer/model/SqsQueueConfiguration.h>
#include <aws/accessanalyzer/model/StartPolicyGenerationRequest.h>
#include <aws/accessanalyzer/model/StartPolicyGenerationResult.h>
#include <aws/accessanalyzer/model/StartResourceScanRequest.h>
#include <aws/accessanalyzer/model/Status.h>
#include <aws/accessanalyzer/model/StatusReason.h>
#include <aws/accessanalyzer/model/Substring.h>
#include <aws/accessanalyzer/model/TagResourceRequest.h>
#include <aws/accessanalyzer/model/TagResourceResult.h>
#include <aws/accessanalyzer/model/ThrottlingException.h>
#include <aws/accessanalyzer/model/Trail.h>
#include <aws/accessanalyzer/model/TrailProperties.h>
#include <aws/accessanalyzer/model/Type.h>
#include <aws/accessanalyzer/model/UntagResourceRequest.h>
#include <aws/accessanalyzer/model/UntagResourceResult.h>
#include <aws/accessanalyzer/model/UnusedAccessConfiguration.h>
#include <aws/accessanalyzer/model/UnusedAccessFindingsStatistics.h>
#include <aws/accessanalyzer/model/UnusedAccessTypeStatistics.h>
#include <aws/accessanalyzer/model/UnusedAction.h>
#include <aws/accessanalyzer/model/UnusedIamRoleDetails.h>
#include <aws/accessanalyzer/model/UnusedIamUserAccessKeyDetails.h>
#include <aws/accessanalyzer/model/UnusedIamUserPasswordDetails.h>
#include <aws/accessanalyzer/model/UnusedPermissionDetails.h>
#include <aws/accessanalyzer/model/UnusedPermissionsRecommendedStep.h>
#include <aws/accessanalyzer/model/UpdateAnalyzerRequest.h>
#include <aws/accessanalyzer/model/UpdateAnalyzerResult.h>
#include <aws/accessanalyzer/model/UpdateArchiveRuleRequest.h>
#include <aws/accessanalyzer/model/UpdateFindingsRequest.h>
#include <aws/accessanalyzer/model/ValidatePolicyFinding.h>
#include <aws/accessanalyzer/model/ValidatePolicyFindingType.h>
#include <aws/accessanalyzer/model/ValidatePolicyRequest.h>
#include <aws/accessanalyzer/model/ValidatePolicyResourceType.h>
#include <aws/accessanalyzer/model/ValidatePolicyResult.h>
#include <aws/accessanalyzer/model/ValidationException.h>
#include <aws/accessanalyzer/model/ValidationExceptionField.h>
#include <aws/accessanalyzer/model/ValidationExceptionReason.h>
#include <aws/accessanalyzer/model/VpcConfiguration.h>

using AccessAnalyzerIncludeTest = ::testing::Test;

TEST_F(AccessAnalyzerIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::AccessAnalyzer::AccessAnalyzerClient>("AccessAnalyzerIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
