/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/appflow/AppflowClient.h>
#include <aws/appflow/AppflowEndpointProvider.h>
#include <aws/appflow/AppflowEndpointRules.h>
#include <aws/appflow/AppflowErrorMarshaller.h>
#include <aws/appflow/AppflowErrors.h>
#include <aws/appflow/AppflowRequest.h>
#include <aws/appflow/AppflowServiceClientModel.h>
#include <aws/appflow/Appflow_EXPORTS.h>
#include <aws/appflow/model/AggregationConfig.h>
#include <aws/appflow/model/AggregationType.h>
#include <aws/appflow/model/AmplitudeConnectorOperator.h>
#include <aws/appflow/model/AmplitudeConnectorProfileCredentials.h>
#include <aws/appflow/model/AmplitudeConnectorProfileProperties.h>
#include <aws/appflow/model/AmplitudeMetadata.h>
#include <aws/appflow/model/AmplitudeSourceProperties.h>
#include <aws/appflow/model/ApiKeyCredentials.h>
#include <aws/appflow/model/AuthParameter.h>
#include <aws/appflow/model/AuthenticationConfig.h>
#include <aws/appflow/model/AuthenticationType.h>
#include <aws/appflow/model/BasicAuthCredentials.h>
#include <aws/appflow/model/CancelFlowExecutionsRequest.h>
#include <aws/appflow/model/CancelFlowExecutionsResult.h>
#include <aws/appflow/model/CatalogType.h>
#include <aws/appflow/model/ConnectionMode.h>
#include <aws/appflow/model/ConnectorConfiguration.h>
#include <aws/appflow/model/ConnectorDetail.h>
#include <aws/appflow/model/ConnectorEntity.h>
#include <aws/appflow/model/ConnectorEntityField.h>
#include <aws/appflow/model/ConnectorMetadata.h>
#include <aws/appflow/model/ConnectorOAuthRequest.h>
#include <aws/appflow/model/ConnectorOperator.h>
#include <aws/appflow/model/ConnectorProfile.h>
#include <aws/appflow/model/ConnectorProfileConfig.h>
#include <aws/appflow/model/ConnectorProfileCredentials.h>
#include <aws/appflow/model/ConnectorProfileProperties.h>
#include <aws/appflow/model/ConnectorProvisioningConfig.h>
#include <aws/appflow/model/ConnectorProvisioningType.h>
#include <aws/appflow/model/ConnectorRuntimeSetting.h>
#include <aws/appflow/model/ConnectorType.h>
#include <aws/appflow/model/CreateConnectorProfileRequest.h>
#include <aws/appflow/model/CreateConnectorProfileResult.h>
#include <aws/appflow/model/CreateFlowRequest.h>
#include <aws/appflow/model/CreateFlowResult.h>
#include <aws/appflow/model/CustomAuthConfig.h>
#include <aws/appflow/model/CustomAuthCredentials.h>
#include <aws/appflow/model/CustomConnectorDestinationProperties.h>
#include <aws/appflow/model/CustomConnectorProfileCredentials.h>
#include <aws/appflow/model/CustomConnectorProfileProperties.h>
#include <aws/appflow/model/CustomConnectorSourceProperties.h>
#include <aws/appflow/model/CustomerProfilesDestinationProperties.h>
#include <aws/appflow/model/CustomerProfilesMetadata.h>
#include <aws/appflow/model/DataPullMode.h>
#include <aws/appflow/model/DataTransferApi.h>
#include <aws/appflow/model/DataTransferApiType.h>
#include <aws/appflow/model/DatadogConnectorOperator.h>
#include <aws/appflow/model/DatadogConnectorProfileCredentials.h>
#include <aws/appflow/model/DatadogConnectorProfileProperties.h>
#include <aws/appflow/model/DatadogMetadata.h>
#include <aws/appflow/model/DatadogSourceProperties.h>
#include <aws/appflow/model/DeleteConnectorProfileRequest.h>
#include <aws/appflow/model/DeleteConnectorProfileResult.h>
#include <aws/appflow/model/DeleteFlowRequest.h>
#include <aws/appflow/model/DeleteFlowResult.h>
#include <aws/appflow/model/DescribeConnectorEntityRequest.h>
#include <aws/appflow/model/DescribeConnectorEntityResult.h>
#include <aws/appflow/model/DescribeConnectorProfilesRequest.h>
#include <aws/appflow/model/DescribeConnectorProfilesResult.h>
#include <aws/appflow/model/DescribeConnectorRequest.h>
#include <aws/appflow/model/DescribeConnectorResult.h>
#include <aws/appflow/model/DescribeConnectorsRequest.h>
#include <aws/appflow/model/DescribeConnectorsResult.h>
#include <aws/appflow/model/DescribeFlowExecutionRecordsRequest.h>
#include <aws/appflow/model/DescribeFlowExecutionRecordsResult.h>
#include <aws/appflow/model/DescribeFlowRequest.h>
#include <aws/appflow/model/DescribeFlowResult.h>
#include <aws/appflow/model/DestinationConnectorProperties.h>
#include <aws/appflow/model/DestinationFieldProperties.h>
#include <aws/appflow/model/DestinationFlowConfig.h>
#include <aws/appflow/model/DynatraceConnectorOperator.h>
#include <aws/appflow/model/DynatraceConnectorProfileCredentials.h>
#include <aws/appflow/model/DynatraceConnectorProfileProperties.h>
#include <aws/appflow/model/DynatraceMetadata.h>
#include <aws/appflow/model/DynatraceSourceProperties.h>
#include <aws/appflow/model/ErrorHandlingConfig.h>
#include <aws/appflow/model/ErrorInfo.h>
#include <aws/appflow/model/EventBridgeDestinationProperties.h>
#include <aws/appflow/model/EventBridgeMetadata.h>
#include <aws/appflow/model/ExecutionDetails.h>
#include <aws/appflow/model/ExecutionRecord.h>
#include <aws/appflow/model/ExecutionResult.h>
#include <aws/appflow/model/ExecutionStatus.h>
#include <aws/appflow/model/FieldTypeDetails.h>
#include <aws/appflow/model/FileType.h>
#include <aws/appflow/model/FlowDefinition.h>
#include <aws/appflow/model/FlowStatus.h>
#include <aws/appflow/model/GlueDataCatalogConfig.h>
#include <aws/appflow/model/GoogleAnalyticsConnectorOperator.h>
#include <aws/appflow/model/GoogleAnalyticsConnectorProfileCredentials.h>
#include <aws/appflow/model/GoogleAnalyticsConnectorProfileProperties.h>
#include <aws/appflow/model/GoogleAnalyticsMetadata.h>
#include <aws/appflow/model/GoogleAnalyticsSourceProperties.h>
#include <aws/appflow/model/HoneycodeConnectorProfileCredentials.h>
#include <aws/appflow/model/HoneycodeConnectorProfileProperties.h>
#include <aws/appflow/model/HoneycodeDestinationProperties.h>
#include <aws/appflow/model/HoneycodeMetadata.h>
#include <aws/appflow/model/IncrementalPullConfig.h>
#include <aws/appflow/model/InforNexusConnectorOperator.h>
#include <aws/appflow/model/InforNexusConnectorProfileCredentials.h>
#include <aws/appflow/model/InforNexusConnectorProfileProperties.h>
#include <aws/appflow/model/InforNexusMetadata.h>
#include <aws/appflow/model/InforNexusSourceProperties.h>
#include <aws/appflow/model/LambdaConnectorProvisioningConfig.h>
#include <aws/appflow/model/ListConnectorEntitiesRequest.h>
#include <aws/appflow/model/ListConnectorEntitiesResult.h>
#include <aws/appflow/model/ListConnectorsRequest.h>
#include <aws/appflow/model/ListConnectorsResult.h>
#include <aws/appflow/model/ListFlowsRequest.h>
#include <aws/appflow/model/ListFlowsResult.h>
#include <aws/appflow/model/ListTagsForResourceRequest.h>
#include <aws/appflow/model/ListTagsForResourceResult.h>
#include <aws/appflow/model/LookoutMetricsDestinationProperties.h>
#include <aws/appflow/model/MarketoConnectorOperator.h>
#include <aws/appflow/model/MarketoConnectorProfileCredentials.h>
#include <aws/appflow/model/MarketoConnectorProfileProperties.h>
#include <aws/appflow/model/MarketoDestinationProperties.h>
#include <aws/appflow/model/MarketoMetadata.h>
#include <aws/appflow/model/MarketoSourceProperties.h>
#include <aws/appflow/model/MetadataCatalogConfig.h>
#include <aws/appflow/model/MetadataCatalogDetail.h>
#include <aws/appflow/model/OAuth2Credentials.h>
#include <aws/appflow/model/OAuth2CustomParameter.h>
#include <aws/appflow/model/OAuth2CustomPropType.h>
#include <aws/appflow/model/OAuth2Defaults.h>
#include <aws/appflow/model/OAuth2GrantType.h>
#include <aws/appflow/model/OAuth2Properties.h>
#include <aws/appflow/model/OAuthCredentials.h>
#include <aws/appflow/model/OAuthProperties.h>
#include <aws/appflow/model/Operator.h>
#include <aws/appflow/model/OperatorPropertiesKeys.h>
#include <aws/appflow/model/Operators.h>
#include <aws/appflow/model/PardotConnectorOperator.h>
#include <aws/appflow/model/PardotConnectorProfileCredentials.h>
#include <aws/appflow/model/PardotConnectorProfileProperties.h>
#include <aws/appflow/model/PardotMetadata.h>
#include <aws/appflow/model/PardotSourceProperties.h>
#include <aws/appflow/model/PathPrefix.h>
#include <aws/appflow/model/PrefixConfig.h>
#include <aws/appflow/model/PrefixFormat.h>
#include <aws/appflow/model/PrefixType.h>
#include <aws/appflow/model/PrivateConnectionProvisioningFailureCause.h>
#include <aws/appflow/model/PrivateConnectionProvisioningState.h>
#include <aws/appflow/model/PrivateConnectionProvisioningStatus.h>
#include <aws/appflow/model/Range.h>
#include <aws/appflow/model/RedshiftConnectorProfileCredentials.h>
#include <aws/appflow/model/RedshiftConnectorProfileProperties.h>
#include <aws/appflow/model/RedshiftDestinationProperties.h>
#include <aws/appflow/model/RedshiftMetadata.h>
#include <aws/appflow/model/RegisterConnectorRequest.h>
#include <aws/appflow/model/RegisterConnectorResult.h>
#include <aws/appflow/model/RegistrationOutput.h>
#include <aws/appflow/model/ResetConnectorMetadataCacheRequest.h>
#include <aws/appflow/model/ResetConnectorMetadataCacheResult.h>
#include <aws/appflow/model/S3ConnectorOperator.h>
#include <aws/appflow/model/S3DestinationProperties.h>
#include <aws/appflow/model/S3InputFileType.h>
#include <aws/appflow/model/S3InputFormatConfig.h>
#include <aws/appflow/model/S3Metadata.h>
#include <aws/appflow/model/S3OutputFormatConfig.h>
#include <aws/appflow/model/S3SourceProperties.h>
#include <aws/appflow/model/SAPODataConnectorOperator.h>
#include <aws/appflow/model/SAPODataConnectorProfileCredentials.h>
#include <aws/appflow/model/SAPODataConnectorProfileProperties.h>
#include <aws/appflow/model/SAPODataDestinationProperties.h>
#include <aws/appflow/model/SAPODataMetadata.h>
#include <aws/appflow/model/SAPODataPaginationConfig.h>
#include <aws/appflow/model/SAPODataParallelismConfig.h>
#include <aws/appflow/model/SAPODataSourceProperties.h>
#include <aws/appflow/model/SalesforceConnectorOperator.h>
#include <aws/appflow/model/SalesforceConnectorProfileCredentials.h>
#include <aws/appflow/model/SalesforceConnectorProfileProperties.h>
#include <aws/appflow/model/SalesforceDataTransferApi.h>
#include <aws/appflow/model/SalesforceDestinationProperties.h>
#include <aws/appflow/model/SalesforceMetadata.h>
#include <aws/appflow/model/SalesforceSourceProperties.h>
#include <aws/appflow/model/ScheduleFrequencyType.h>
#include <aws/appflow/model/ScheduledTriggerProperties.h>
#include <aws/appflow/model/ServiceNowConnectorOperator.h>
#include <aws/appflow/model/ServiceNowConnectorProfileCredentials.h>
#include <aws/appflow/model/ServiceNowConnectorProfileProperties.h>
#include <aws/appflow/model/ServiceNowMetadata.h>
#include <aws/appflow/model/ServiceNowSourceProperties.h>
#include <aws/appflow/model/SingularConnectorOperator.h>
#include <aws/appflow/model/SingularConnectorProfileCredentials.h>
#include <aws/appflow/model/SingularConnectorProfileProperties.h>
#include <aws/appflow/model/SingularMetadata.h>
#include <aws/appflow/model/SingularSourceProperties.h>
#include <aws/appflow/model/SlackConnectorOperator.h>
#include <aws/appflow/model/SlackConnectorProfileCredentials.h>
#include <aws/appflow/model/SlackConnectorProfileProperties.h>
#include <aws/appflow/model/SlackMetadata.h>
#include <aws/appflow/model/SlackSourceProperties.h>
#include <aws/appflow/model/SnowflakeConnectorProfileCredentials.h>
#include <aws/appflow/model/SnowflakeConnectorProfileProperties.h>
#include <aws/appflow/model/SnowflakeDestinationProperties.h>
#include <aws/appflow/model/SnowflakeMetadata.h>
#include <aws/appflow/model/SourceConnectorProperties.h>
#include <aws/appflow/model/SourceFieldProperties.h>
#include <aws/appflow/model/SourceFlowConfig.h>
#include <aws/appflow/model/StartFlowRequest.h>
#include <aws/appflow/model/StartFlowResult.h>
#include <aws/appflow/model/StopFlowRequest.h>
#include <aws/appflow/model/StopFlowResult.h>
#include <aws/appflow/model/SuccessResponseHandlingConfig.h>
#include <aws/appflow/model/SupportedDataTransferType.h>
#include <aws/appflow/model/SupportedFieldTypeDetails.h>
#include <aws/appflow/model/TagResourceRequest.h>
#include <aws/appflow/model/TagResourceResult.h>
#include <aws/appflow/model/Task.h>
#include <aws/appflow/model/TaskType.h>
#include <aws/appflow/model/TrendmicroConnectorOperator.h>
#include <aws/appflow/model/TrendmicroConnectorProfileCredentials.h>
#include <aws/appflow/model/TrendmicroConnectorProfileProperties.h>
#include <aws/appflow/model/TrendmicroMetadata.h>
#include <aws/appflow/model/TrendmicroSourceProperties.h>
#include <aws/appflow/model/TriggerConfig.h>
#include <aws/appflow/model/TriggerProperties.h>
#include <aws/appflow/model/TriggerType.h>
#include <aws/appflow/model/UnregisterConnectorRequest.h>
#include <aws/appflow/model/UnregisterConnectorResult.h>
#include <aws/appflow/model/UntagResourceRequest.h>
#include <aws/appflow/model/UntagResourceResult.h>
#include <aws/appflow/model/UpdateConnectorProfileRequest.h>
#include <aws/appflow/model/UpdateConnectorProfileResult.h>
#include <aws/appflow/model/UpdateConnectorRegistrationRequest.h>
#include <aws/appflow/model/UpdateConnectorRegistrationResult.h>
#include <aws/appflow/model/UpdateFlowRequest.h>
#include <aws/appflow/model/UpdateFlowResult.h>
#include <aws/appflow/model/UpsolverDestinationProperties.h>
#include <aws/appflow/model/UpsolverMetadata.h>
#include <aws/appflow/model/UpsolverS3OutputFormatConfig.h>
#include <aws/appflow/model/VeevaConnectorOperator.h>
#include <aws/appflow/model/VeevaConnectorProfileCredentials.h>
#include <aws/appflow/model/VeevaConnectorProfileProperties.h>
#include <aws/appflow/model/VeevaMetadata.h>
#include <aws/appflow/model/VeevaSourceProperties.h>
#include <aws/appflow/model/WriteOperationType.h>
#include <aws/appflow/model/ZendeskConnectorOperator.h>
#include <aws/appflow/model/ZendeskConnectorProfileCredentials.h>
#include <aws/appflow/model/ZendeskConnectorProfileProperties.h>
#include <aws/appflow/model/ZendeskDestinationProperties.h>
#include <aws/appflow/model/ZendeskMetadata.h>
#include <aws/appflow/model/ZendeskSourceProperties.h>

using AppflowIncludeTest = ::testing::Test;

TEST_F(AppflowIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Appflow::AppflowClient>("AppflowIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
