/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/appmesh/AppMeshClient.h>
#include <aws/appmesh/AppMeshEndpointProvider.h>
#include <aws/appmesh/AppMeshEndpointRules.h>
#include <aws/appmesh/AppMeshErrorMarshaller.h>
#include <aws/appmesh/AppMeshErrors.h>
#include <aws/appmesh/AppMeshRequest.h>
#include <aws/appmesh/AppMeshServiceClientModel.h>
#include <aws/appmesh/AppMesh_EXPORTS.h>
#include <aws/appmesh/model/AccessLog.h>
#include <aws/appmesh/model/AwsCloudMapInstanceAttribute.h>
#include <aws/appmesh/model/AwsCloudMapServiceDiscovery.h>
#include <aws/appmesh/model/Backend.h>
#include <aws/appmesh/model/BackendDefaults.h>
#include <aws/appmesh/model/ClientPolicy.h>
#include <aws/appmesh/model/ClientPolicyTls.h>
#include <aws/appmesh/model/ClientTlsCertificate.h>
#include <aws/appmesh/model/CreateGatewayRouteRequest.h>
#include <aws/appmesh/model/CreateGatewayRouteResult.h>
#include <aws/appmesh/model/CreateMeshRequest.h>
#include <aws/appmesh/model/CreateMeshResult.h>
#include <aws/appmesh/model/CreateRouteRequest.h>
#include <aws/appmesh/model/CreateRouteResult.h>
#include <aws/appmesh/model/CreateVirtualGatewayRequest.h>
#include <aws/appmesh/model/CreateVirtualGatewayResult.h>
#include <aws/appmesh/model/CreateVirtualNodeRequest.h>
#include <aws/appmesh/model/CreateVirtualNodeResult.h>
#include <aws/appmesh/model/CreateVirtualRouterRequest.h>
#include <aws/appmesh/model/CreateVirtualRouterResult.h>
#include <aws/appmesh/model/CreateVirtualServiceRequest.h>
#include <aws/appmesh/model/CreateVirtualServiceResult.h>
#include <aws/appmesh/model/DefaultGatewayRouteRewrite.h>
#include <aws/appmesh/model/DeleteGatewayRouteRequest.h>
#include <aws/appmesh/model/DeleteGatewayRouteResult.h>
#include <aws/appmesh/model/DeleteMeshRequest.h>
#include <aws/appmesh/model/DeleteMeshResult.h>
#include <aws/appmesh/model/DeleteRouteRequest.h>
#include <aws/appmesh/model/DeleteRouteResult.h>
#include <aws/appmesh/model/DeleteVirtualGatewayRequest.h>
#include <aws/appmesh/model/DeleteVirtualGatewayResult.h>
#include <aws/appmesh/model/DeleteVirtualNodeRequest.h>
#include <aws/appmesh/model/DeleteVirtualNodeResult.h>
#include <aws/appmesh/model/DeleteVirtualRouterRequest.h>
#include <aws/appmesh/model/DeleteVirtualRouterResult.h>
#include <aws/appmesh/model/DeleteVirtualServiceRequest.h>
#include <aws/appmesh/model/DeleteVirtualServiceResult.h>
#include <aws/appmesh/model/DescribeGatewayRouteRequest.h>
#include <aws/appmesh/model/DescribeGatewayRouteResult.h>
#include <aws/appmesh/model/DescribeMeshRequest.h>
#include <aws/appmesh/model/DescribeMeshResult.h>
#include <aws/appmesh/model/DescribeRouteRequest.h>
#include <aws/appmesh/model/DescribeRouteResult.h>
#include <aws/appmesh/model/DescribeVirtualGatewayRequest.h>
#include <aws/appmesh/model/DescribeVirtualGatewayResult.h>
#include <aws/appmesh/model/DescribeVirtualNodeRequest.h>
#include <aws/appmesh/model/DescribeVirtualNodeResult.h>
#include <aws/appmesh/model/DescribeVirtualRouterRequest.h>
#include <aws/appmesh/model/DescribeVirtualRouterResult.h>
#include <aws/appmesh/model/DescribeVirtualServiceRequest.h>
#include <aws/appmesh/model/DescribeVirtualServiceResult.h>
#include <aws/appmesh/model/DnsResponseType.h>
#include <aws/appmesh/model/DnsServiceDiscovery.h>
#include <aws/appmesh/model/Duration.h>
#include <aws/appmesh/model/DurationUnit.h>
#include <aws/appmesh/model/EgressFilter.h>
#include <aws/appmesh/model/EgressFilterType.h>
#include <aws/appmesh/model/FileAccessLog.h>
#include <aws/appmesh/model/GatewayRouteData.h>
#include <aws/appmesh/model/GatewayRouteHostnameMatch.h>
#include <aws/appmesh/model/GatewayRouteHostnameRewrite.h>
#include <aws/appmesh/model/GatewayRouteRef.h>
#include <aws/appmesh/model/GatewayRouteSpec.h>
#include <aws/appmesh/model/GatewayRouteStatus.h>
#include <aws/appmesh/model/GatewayRouteStatusCode.h>
#include <aws/appmesh/model/GatewayRouteTarget.h>
#include <aws/appmesh/model/GatewayRouteVirtualService.h>
#include <aws/appmesh/model/GrpcGatewayRoute.h>
#include <aws/appmesh/model/GrpcGatewayRouteAction.h>
#include <aws/appmesh/model/GrpcGatewayRouteMatch.h>
#include <aws/appmesh/model/GrpcGatewayRouteMetadata.h>
#include <aws/appmesh/model/GrpcGatewayRouteRewrite.h>
#include <aws/appmesh/model/GrpcMetadataMatchMethod.h>
#include <aws/appmesh/model/GrpcRetryPolicy.h>
#include <aws/appmesh/model/GrpcRetryPolicyEvent.h>
#include <aws/appmesh/model/GrpcRoute.h>
#include <aws/appmesh/model/GrpcRouteAction.h>
#include <aws/appmesh/model/GrpcRouteMatch.h>
#include <aws/appmesh/model/GrpcRouteMetadata.h>
#include <aws/appmesh/model/GrpcRouteMetadataMatchMethod.h>
#include <aws/appmesh/model/GrpcTimeout.h>
#include <aws/appmesh/model/HeaderMatchMethod.h>
#include <aws/appmesh/model/HealthCheckPolicy.h>
#include <aws/appmesh/model/HttpGatewayRoute.h>
#include <aws/appmesh/model/HttpGatewayRouteAction.h>
#include <aws/appmesh/model/HttpGatewayRouteHeader.h>
#include <aws/appmesh/model/HttpGatewayRouteMatch.h>
#include <aws/appmesh/model/HttpGatewayRoutePathRewrite.h>
#include <aws/appmesh/model/HttpGatewayRoutePrefixRewrite.h>
#include <aws/appmesh/model/HttpGatewayRouteRewrite.h>
#include <aws/appmesh/model/HttpMethod.h>
#include <aws/appmesh/model/HttpPathMatch.h>
#include <aws/appmesh/model/HttpQueryParameter.h>
#include <aws/appmesh/model/HttpRetryPolicy.h>
#include <aws/appmesh/model/HttpRoute.h>
#include <aws/appmesh/model/HttpRouteAction.h>
#include <aws/appmesh/model/HttpRouteHeader.h>
#include <aws/appmesh/model/HttpRouteMatch.h>
#include <aws/appmesh/model/HttpScheme.h>
#include <aws/appmesh/model/HttpTimeout.h>
#include <aws/appmesh/model/IpPreference.h>
#include <aws/appmesh/model/JsonFormatRef.h>
#include <aws/appmesh/model/ListGatewayRoutesRequest.h>
#include <aws/appmesh/model/ListGatewayRoutesResult.h>
#include <aws/appmesh/model/ListMeshesRequest.h>
#include <aws/appmesh/model/ListMeshesResult.h>
#include <aws/appmesh/model/ListRoutesRequest.h>
#include <aws/appmesh/model/ListRoutesResult.h>
#include <aws/appmesh/model/ListTagsForResourceRequest.h>
#include <aws/appmesh/model/ListTagsForResourceResult.h>
#include <aws/appmesh/model/ListVirtualGatewaysRequest.h>
#include <aws/appmesh/model/ListVirtualGatewaysResult.h>
#include <aws/appmesh/model/ListVirtualNodesRequest.h>
#include <aws/appmesh/model/ListVirtualNodesResult.h>
#include <aws/appmesh/model/ListVirtualRoutersRequest.h>
#include <aws/appmesh/model/ListVirtualRoutersResult.h>
#include <aws/appmesh/model/ListVirtualServicesRequest.h>
#include <aws/appmesh/model/ListVirtualServicesResult.h>
#include <aws/appmesh/model/Listener.h>
#include <aws/appmesh/model/ListenerTimeout.h>
#include <aws/appmesh/model/ListenerTls.h>
#include <aws/appmesh/model/ListenerTlsAcmCertificate.h>
#include <aws/appmesh/model/ListenerTlsCertificate.h>
#include <aws/appmesh/model/ListenerTlsFileCertificate.h>
#include <aws/appmesh/model/ListenerTlsMode.h>
#include <aws/appmesh/model/ListenerTlsSdsCertificate.h>
#include <aws/appmesh/model/ListenerTlsValidationContext.h>
#include <aws/appmesh/model/ListenerTlsValidationContextTrust.h>
#include <aws/appmesh/model/Logging.h>
#include <aws/appmesh/model/LoggingFormat.h>
#include <aws/appmesh/model/MatchRange.h>
#include <aws/appmesh/model/MeshData.h>
#include <aws/appmesh/model/MeshRef.h>
#include <aws/appmesh/model/MeshServiceDiscovery.h>
#include <aws/appmesh/model/MeshSpec.h>
#include <aws/appmesh/model/MeshStatus.h>
#include <aws/appmesh/model/MeshStatusCode.h>
#include <aws/appmesh/model/OutlierDetection.h>
#include <aws/appmesh/model/PortMapping.h>
#include <aws/appmesh/model/PortProtocol.h>
#include <aws/appmesh/model/QueryParameterMatch.h>
#include <aws/appmesh/model/ResourceMetadata.h>
#include <aws/appmesh/model/RouteData.h>
#include <aws/appmesh/model/RouteRef.h>
#include <aws/appmesh/model/RouteSpec.h>
#include <aws/appmesh/model/RouteStatus.h>
#include <aws/appmesh/model/RouteStatusCode.h>
#include <aws/appmesh/model/ServiceDiscovery.h>
#include <aws/appmesh/model/SubjectAlternativeNameMatchers.h>
#include <aws/appmesh/model/SubjectAlternativeNames.h>
#include <aws/appmesh/model/TagRef.h>
#include <aws/appmesh/model/TagResourceRequest.h>
#include <aws/appmesh/model/TagResourceResult.h>
#include <aws/appmesh/model/TcpRetryPolicyEvent.h>
#include <aws/appmesh/model/TcpRoute.h>
#include <aws/appmesh/model/TcpRouteAction.h>
#include <aws/appmesh/model/TcpRouteMatch.h>
#include <aws/appmesh/model/TcpTimeout.h>
#include <aws/appmesh/model/TlsValidationContext.h>
#include <aws/appmesh/model/TlsValidationContextAcmTrust.h>
#include <aws/appmesh/model/TlsValidationContextFileTrust.h>
#include <aws/appmesh/model/TlsValidationContextSdsTrust.h>
#include <aws/appmesh/model/TlsValidationContextTrust.h>
#include <aws/appmesh/model/UntagResourceRequest.h>
#include <aws/appmesh/model/UntagResourceResult.h>
#include <aws/appmesh/model/UpdateGatewayRouteRequest.h>
#include <aws/appmesh/model/UpdateGatewayRouteResult.h>
#include <aws/appmesh/model/UpdateMeshRequest.h>
#include <aws/appmesh/model/UpdateMeshResult.h>
#include <aws/appmesh/model/UpdateRouteRequest.h>
#include <aws/appmesh/model/UpdateRouteResult.h>
#include <aws/appmesh/model/UpdateVirtualGatewayRequest.h>
#include <aws/appmesh/model/UpdateVirtualGatewayResult.h>
#include <aws/appmesh/model/UpdateVirtualNodeRequest.h>
#include <aws/appmesh/model/UpdateVirtualNodeResult.h>
#include <aws/appmesh/model/UpdateVirtualRouterRequest.h>
#include <aws/appmesh/model/UpdateVirtualRouterResult.h>
#include <aws/appmesh/model/UpdateVirtualServiceRequest.h>
#include <aws/appmesh/model/UpdateVirtualServiceResult.h>
#include <aws/appmesh/model/VirtualGatewayAccessLog.h>
#include <aws/appmesh/model/VirtualGatewayBackendDefaults.h>
#include <aws/appmesh/model/VirtualGatewayClientPolicy.h>
#include <aws/appmesh/model/VirtualGatewayClientPolicyTls.h>
#include <aws/appmesh/model/VirtualGatewayClientTlsCertificate.h>
#include <aws/appmesh/model/VirtualGatewayConnectionPool.h>
#include <aws/appmesh/model/VirtualGatewayData.h>
#include <aws/appmesh/model/VirtualGatewayFileAccessLog.h>
#include <aws/appmesh/model/VirtualGatewayGrpcConnectionPool.h>
#include <aws/appmesh/model/VirtualGatewayHealthCheckPolicy.h>
#include <aws/appmesh/model/VirtualGatewayHttp2ConnectionPool.h>
#include <aws/appmesh/model/VirtualGatewayHttpConnectionPool.h>
#include <aws/appmesh/model/VirtualGatewayListener.h>
#include <aws/appmesh/model/VirtualGatewayListenerTls.h>
#include <aws/appmesh/model/VirtualGatewayListenerTlsAcmCertificate.h>
#include <aws/appmesh/model/VirtualGatewayListenerTlsCertificate.h>
#include <aws/appmesh/model/VirtualGatewayListenerTlsFileCertificate.h>
#include <aws/appmesh/model/VirtualGatewayListenerTlsMode.h>
#include <aws/appmesh/model/VirtualGatewayListenerTlsSdsCertificate.h>
#include <aws/appmesh/model/VirtualGatewayListenerTlsValidationContext.h>
#include <aws/appmesh/model/VirtualGatewayListenerTlsValidationContextTrust.h>
#include <aws/appmesh/model/VirtualGatewayLogging.h>
#include <aws/appmesh/model/VirtualGatewayPortMapping.h>
#include <aws/appmesh/model/VirtualGatewayPortProtocol.h>
#include <aws/appmesh/model/VirtualGatewayRef.h>
#include <aws/appmesh/model/VirtualGatewaySpec.h>
#include <aws/appmesh/model/VirtualGatewayStatus.h>
#include <aws/appmesh/model/VirtualGatewayStatusCode.h>
#include <aws/appmesh/model/VirtualGatewayTlsValidationContext.h>
#include <aws/appmesh/model/VirtualGatewayTlsValidationContextAcmTrust.h>
#include <aws/appmesh/model/VirtualGatewayTlsValidationContextFileTrust.h>
#include <aws/appmesh/model/VirtualGatewayTlsValidationContextSdsTrust.h>
#include <aws/appmesh/model/VirtualGatewayTlsValidationContextTrust.h>
#include <aws/appmesh/model/VirtualNodeConnectionPool.h>
#include <aws/appmesh/model/VirtualNodeData.h>
#include <aws/appmesh/model/VirtualNodeGrpcConnectionPool.h>
#include <aws/appmesh/model/VirtualNodeHttp2ConnectionPool.h>
#include <aws/appmesh/model/VirtualNodeHttpConnectionPool.h>
#include <aws/appmesh/model/VirtualNodeRef.h>
#include <aws/appmesh/model/VirtualNodeServiceProvider.h>
#include <aws/appmesh/model/VirtualNodeSpec.h>
#include <aws/appmesh/model/VirtualNodeStatus.h>
#include <aws/appmesh/model/VirtualNodeStatusCode.h>
#include <aws/appmesh/model/VirtualNodeTcpConnectionPool.h>
#include <aws/appmesh/model/VirtualRouterData.h>
#include <aws/appmesh/model/VirtualRouterListener.h>
#include <aws/appmesh/model/VirtualRouterRef.h>
#include <aws/appmesh/model/VirtualRouterServiceProvider.h>
#include <aws/appmesh/model/VirtualRouterSpec.h>
#include <aws/appmesh/model/VirtualRouterStatus.h>
#include <aws/appmesh/model/VirtualRouterStatusCode.h>
#include <aws/appmesh/model/VirtualServiceBackend.h>
#include <aws/appmesh/model/VirtualServiceData.h>
#include <aws/appmesh/model/VirtualServiceProvider.h>
#include <aws/appmesh/model/VirtualServiceRef.h>
#include <aws/appmesh/model/VirtualServiceSpec.h>
#include <aws/appmesh/model/VirtualServiceStatus.h>
#include <aws/appmesh/model/VirtualServiceStatusCode.h>
#include <aws/appmesh/model/WeightedTarget.h>

using AppMeshIncludeTest = ::testing::Test;

TEST_F(AppMeshIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::AppMesh::AppMeshClient>("AppMeshIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
