/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/appsync/AppSyncClient.h>
#include <aws/appsync/AppSyncEndpointProvider.h>
#include <aws/appsync/AppSyncEndpointRules.h>
#include <aws/appsync/AppSyncErrorMarshaller.h>
#include <aws/appsync/AppSyncErrors.h>
#include <aws/appsync/AppSyncRequest.h>
#include <aws/appsync/AppSyncServiceClientModel.h>
#include <aws/appsync/AppSync_EXPORTS.h>
#include <aws/appsync/model/AdditionalAuthenticationProvider.h>
#include <aws/appsync/model/Api.h>
#include <aws/appsync/model/ApiAssociation.h>
#include <aws/appsync/model/ApiCache.h>
#include <aws/appsync/model/ApiCacheStatus.h>
#include <aws/appsync/model/ApiCacheType.h>
#include <aws/appsync/model/ApiCachingBehavior.h>
#include <aws/appsync/model/ApiKey.h>
#include <aws/appsync/model/AppSyncRuntime.h>
#include <aws/appsync/model/AssociateApiRequest.h>
#include <aws/appsync/model/AssociateApiResult.h>
#include <aws/appsync/model/AssociateMergedGraphqlApiRequest.h>
#include <aws/appsync/model/AssociateMergedGraphqlApiResult.h>
#include <aws/appsync/model/AssociateSourceGraphqlApiRequest.h>
#include <aws/appsync/model/AssociateSourceGraphqlApiResult.h>
#include <aws/appsync/model/AssociationStatus.h>
#include <aws/appsync/model/AuthMode.h>
#include <aws/appsync/model/AuthProvider.h>
#include <aws/appsync/model/AuthenticationType.h>
#include <aws/appsync/model/AuthorizationConfig.h>
#include <aws/appsync/model/AuthorizationType.h>
#include <aws/appsync/model/AwsIamConfig.h>
#include <aws/appsync/model/BadRequestDetail.h>
#include <aws/appsync/model/BadRequestException.h>
#include <aws/appsync/model/BadRequestReason.h>
#include <aws/appsync/model/CacheHealthMetricsConfig.h>
#include <aws/appsync/model/CachingConfig.h>
#include <aws/appsync/model/ChannelNamespace.h>
#include <aws/appsync/model/CodeError.h>
#include <aws/appsync/model/CodeErrorLocation.h>
#include <aws/appsync/model/CognitoConfig.h>
#include <aws/appsync/model/CognitoUserPoolConfig.h>
#include <aws/appsync/model/ConflictDetectionType.h>
#include <aws/appsync/model/ConflictHandlerType.h>
#include <aws/appsync/model/CreateApiCacheRequest.h>
#include <aws/appsync/model/CreateApiCacheResult.h>
#include <aws/appsync/model/CreateApiKeyRequest.h>
#include <aws/appsync/model/CreateApiKeyResult.h>
#include <aws/appsync/model/CreateApiRequest.h>
#include <aws/appsync/model/CreateApiResult.h>
#include <aws/appsync/model/CreateChannelNamespaceRequest.h>
#include <aws/appsync/model/CreateChannelNamespaceResult.h>
#include <aws/appsync/model/CreateDataSourceRequest.h>
#include <aws/appsync/model/CreateDataSourceResult.h>
#include <aws/appsync/model/CreateDomainNameRequest.h>
#include <aws/appsync/model/CreateDomainNameResult.h>
#include <aws/appsync/model/CreateFunctionRequest.h>
#include <aws/appsync/model/CreateFunctionResult.h>
#include <aws/appsync/model/CreateGraphqlApiRequest.h>
#include <aws/appsync/model/CreateGraphqlApiResult.h>
#include <aws/appsync/model/CreateResolverRequest.h>
#include <aws/appsync/model/CreateResolverResult.h>
#include <aws/appsync/model/CreateTypeRequest.h>
#include <aws/appsync/model/CreateTypeResult.h>
#include <aws/appsync/model/DataSource.h>
#include <aws/appsync/model/DataSourceIntrospectionModel.h>
#include <aws/appsync/model/DataSourceIntrospectionModelField.h>
#include <aws/appsync/model/DataSourceIntrospectionModelFieldType.h>
#include <aws/appsync/model/DataSourceIntrospectionModelIndex.h>
#include <aws/appsync/model/DataSourceIntrospectionResult.h>
#include <aws/appsync/model/DataSourceIntrospectionStatus.h>
#include <aws/appsync/model/DataSourceLevelMetricsBehavior.h>
#include <aws/appsync/model/DataSourceLevelMetricsConfig.h>
#include <aws/appsync/model/DataSourceType.h>
#include <aws/appsync/model/DefaultAction.h>
#include <aws/appsync/model/DeleteApiCacheRequest.h>
#include <aws/appsync/model/DeleteApiCacheResult.h>
#include <aws/appsync/model/DeleteApiKeyRequest.h>
#include <aws/appsync/model/DeleteApiKeyResult.h>
#include <aws/appsync/model/DeleteApiRequest.h>
#include <aws/appsync/model/DeleteApiResult.h>
#include <aws/appsync/model/DeleteChannelNamespaceRequest.h>
#include <aws/appsync/model/DeleteChannelNamespaceResult.h>
#include <aws/appsync/model/DeleteDataSourceRequest.h>
#include <aws/appsync/model/DeleteDataSourceResult.h>
#include <aws/appsync/model/DeleteDomainNameRequest.h>
#include <aws/appsync/model/DeleteDomainNameResult.h>
#include <aws/appsync/model/DeleteFunctionRequest.h>
#include <aws/appsync/model/DeleteFunctionResult.h>
#include <aws/appsync/model/DeleteGraphqlApiRequest.h>
#include <aws/appsync/model/DeleteGraphqlApiResult.h>
#include <aws/appsync/model/DeleteResolverRequest.h>
#include <aws/appsync/model/DeleteResolverResult.h>
#include <aws/appsync/model/DeleteTypeRequest.h>
#include <aws/appsync/model/DeleteTypeResult.h>
#include <aws/appsync/model/DeltaSyncConfig.h>
#include <aws/appsync/model/DisassociateApiRequest.h>
#include <aws/appsync/model/DisassociateApiResult.h>
#include <aws/appsync/model/DisassociateMergedGraphqlApiRequest.h>
#include <aws/appsync/model/DisassociateMergedGraphqlApiResult.h>
#include <aws/appsync/model/DisassociateSourceGraphqlApiRequest.h>
#include <aws/appsync/model/DisassociateSourceGraphqlApiResult.h>
#include <aws/appsync/model/DomainNameConfig.h>
#include <aws/appsync/model/DynamodbDataSourceConfig.h>
#include <aws/appsync/model/ElasticsearchDataSourceConfig.h>
#include <aws/appsync/model/EnhancedMetricsConfig.h>
#include <aws/appsync/model/ErrorDetail.h>
#include <aws/appsync/model/EvaluateCodeErrorDetail.h>
#include <aws/appsync/model/EvaluateCodeRequest.h>
#include <aws/appsync/model/EvaluateCodeResult.h>
#include <aws/appsync/model/EvaluateMappingTemplateRequest.h>
#include <aws/appsync/model/EvaluateMappingTemplateResult.h>
#include <aws/appsync/model/EventBridgeDataSourceConfig.h>
#include <aws/appsync/model/EventConfig.h>
#include <aws/appsync/model/EventLogConfig.h>
#include <aws/appsync/model/EventLogLevel.h>
#include <aws/appsync/model/FieldLogLevel.h>
#include <aws/appsync/model/FlushApiCacheRequest.h>
#include <aws/appsync/model/FlushApiCacheResult.h>
#include <aws/appsync/model/FunctionConfiguration.h>
#include <aws/appsync/model/GetApiAssociationRequest.h>
#include <aws/appsync/model/GetApiAssociationResult.h>
#include <aws/appsync/model/GetApiCacheRequest.h>
#include <aws/appsync/model/GetApiCacheResult.h>
#include <aws/appsync/model/GetApiRequest.h>
#include <aws/appsync/model/GetApiResult.h>
#include <aws/appsync/model/GetChannelNamespaceRequest.h>
#include <aws/appsync/model/GetChannelNamespaceResult.h>
#include <aws/appsync/model/GetDataSourceIntrospectionRequest.h>
#include <aws/appsync/model/GetDataSourceIntrospectionResult.h>
#include <aws/appsync/model/GetDataSourceRequest.h>
#include <aws/appsync/model/GetDataSourceResult.h>
#include <aws/appsync/model/GetDomainNameRequest.h>
#include <aws/appsync/model/GetDomainNameResult.h>
#include <aws/appsync/model/GetFunctionRequest.h>
#include <aws/appsync/model/GetFunctionResult.h>
#include <aws/appsync/model/GetGraphqlApiEnvironmentVariablesRequest.h>
#include <aws/appsync/model/GetGraphqlApiEnvironmentVariablesResult.h>
#include <aws/appsync/model/GetGraphqlApiRequest.h>
#include <aws/appsync/model/GetGraphqlApiResult.h>
#include <aws/appsync/model/GetIntrospectionSchemaRequest.h>
#include <aws/appsync/model/GetIntrospectionSchemaResult.h>
#include <aws/appsync/model/GetResolverRequest.h>
#include <aws/appsync/model/GetResolverResult.h>
#include <aws/appsync/model/GetSchemaCreationStatusRequest.h>
#include <aws/appsync/model/GetSchemaCreationStatusResult.h>
#include <aws/appsync/model/GetSourceApiAssociationRequest.h>
#include <aws/appsync/model/GetSourceApiAssociationResult.h>
#include <aws/appsync/model/GetTypeRequest.h>
#include <aws/appsync/model/GetTypeResult.h>
#include <aws/appsync/model/GraphQLApiIntrospectionConfig.h>
#include <aws/appsync/model/GraphQLApiType.h>
#include <aws/appsync/model/GraphQLApiVisibility.h>
#include <aws/appsync/model/GraphqlApi.h>
#include <aws/appsync/model/HandlerBehavior.h>
#include <aws/appsync/model/HandlerConfig.h>
#include <aws/appsync/model/HandlerConfigs.h>
#include <aws/appsync/model/HttpDataSourceConfig.h>
#include <aws/appsync/model/Integration.h>
#include <aws/appsync/model/InvokeType.h>
#include <aws/appsync/model/LambdaAuthorizerConfig.h>
#include <aws/appsync/model/LambdaConfig.h>
#include <aws/appsync/model/LambdaConflictHandlerConfig.h>
#include <aws/appsync/model/LambdaDataSourceConfig.h>
#include <aws/appsync/model/ListApiKeysRequest.h>
#include <aws/appsync/model/ListApiKeysResult.h>
#include <aws/appsync/model/ListApisRequest.h>
#include <aws/appsync/model/ListApisResult.h>
#include <aws/appsync/model/ListChannelNamespacesRequest.h>
#include <aws/appsync/model/ListChannelNamespacesResult.h>
#include <aws/appsync/model/ListDataSourcesRequest.h>
#include <aws/appsync/model/ListDataSourcesResult.h>
#include <aws/appsync/model/ListDomainNamesRequest.h>
#include <aws/appsync/model/ListDomainNamesResult.h>
#include <aws/appsync/model/ListFunctionsRequest.h>
#include <aws/appsync/model/ListFunctionsResult.h>
#include <aws/appsync/model/ListGraphqlApisRequest.h>
#include <aws/appsync/model/ListGraphqlApisResult.h>
#include <aws/appsync/model/ListResolversByFunctionRequest.h>
#include <aws/appsync/model/ListResolversByFunctionResult.h>
#include <aws/appsync/model/ListResolversRequest.h>
#include <aws/appsync/model/ListResolversResult.h>
#include <aws/appsync/model/ListSourceApiAssociationsRequest.h>
#include <aws/appsync/model/ListSourceApiAssociationsResult.h>
#include <aws/appsync/model/ListTagsForResourceRequest.h>
#include <aws/appsync/model/ListTagsForResourceResult.h>
#include <aws/appsync/model/ListTypesByAssociationRequest.h>
#include <aws/appsync/model/ListTypesByAssociationResult.h>
#include <aws/appsync/model/ListTypesRequest.h>
#include <aws/appsync/model/ListTypesResult.h>
#include <aws/appsync/model/LogConfig.h>
#include <aws/appsync/model/MergeType.h>
#include <aws/appsync/model/OpenIDConnectConfig.h>
#include <aws/appsync/model/OpenSearchServiceDataSourceConfig.h>
#include <aws/appsync/model/OperationLevelMetricsConfig.h>
#include <aws/appsync/model/OutputType.h>
#include <aws/appsync/model/Ownership.h>
#include <aws/appsync/model/PipelineConfig.h>
#include <aws/appsync/model/PutGraphqlApiEnvironmentVariablesRequest.h>
#include <aws/appsync/model/PutGraphqlApiEnvironmentVariablesResult.h>
#include <aws/appsync/model/RdsDataApiConfig.h>
#include <aws/appsync/model/RdsHttpEndpointConfig.h>
#include <aws/appsync/model/RelationalDatabaseDataSourceConfig.h>
#include <aws/appsync/model/RelationalDatabaseSourceType.h>
#include <aws/appsync/model/Resolver.h>
#include <aws/appsync/model/ResolverKind.h>
#include <aws/appsync/model/ResolverLevelMetricsBehavior.h>
#include <aws/appsync/model/ResolverLevelMetricsConfig.h>
#include <aws/appsync/model/RuntimeName.h>
#include <aws/appsync/model/SchemaStatus.h>
#include <aws/appsync/model/SourceApiAssociation.h>
#include <aws/appsync/model/SourceApiAssociationConfig.h>
#include <aws/appsync/model/SourceApiAssociationStatus.h>
#include <aws/appsync/model/SourceApiAssociationSummary.h>
#include <aws/appsync/model/StartDataSourceIntrospectionRequest.h>
#include <aws/appsync/model/StartDataSourceIntrospectionResult.h>
#include <aws/appsync/model/StartSchemaCreationRequest.h>
#include <aws/appsync/model/StartSchemaCreationResult.h>
#include <aws/appsync/model/StartSchemaMergeRequest.h>
#include <aws/appsync/model/StartSchemaMergeResult.h>
#include <aws/appsync/model/SyncConfig.h>
#include <aws/appsync/model/TagResourceRequest.h>
#include <aws/appsync/model/TagResourceResult.h>
#include <aws/appsync/model/Type.h>
#include <aws/appsync/model/TypeDefinitionFormat.h>
#include <aws/appsync/model/UntagResourceRequest.h>
#include <aws/appsync/model/UntagResourceResult.h>
#include <aws/appsync/model/UpdateApiCacheRequest.h>
#include <aws/appsync/model/UpdateApiCacheResult.h>
#include <aws/appsync/model/UpdateApiKeyRequest.h>
#include <aws/appsync/model/UpdateApiKeyResult.h>
#include <aws/appsync/model/UpdateApiRequest.h>
#include <aws/appsync/model/UpdateApiResult.h>
#include <aws/appsync/model/UpdateChannelNamespaceRequest.h>
#include <aws/appsync/model/UpdateChannelNamespaceResult.h>
#include <aws/appsync/model/UpdateDataSourceRequest.h>
#include <aws/appsync/model/UpdateDataSourceResult.h>
#include <aws/appsync/model/UpdateDomainNameRequest.h>
#include <aws/appsync/model/UpdateDomainNameResult.h>
#include <aws/appsync/model/UpdateFunctionRequest.h>
#include <aws/appsync/model/UpdateFunctionResult.h>
#include <aws/appsync/model/UpdateGraphqlApiRequest.h>
#include <aws/appsync/model/UpdateGraphqlApiResult.h>
#include <aws/appsync/model/UpdateResolverRequest.h>
#include <aws/appsync/model/UpdateResolverResult.h>
#include <aws/appsync/model/UpdateSourceApiAssociationRequest.h>
#include <aws/appsync/model/UpdateSourceApiAssociationResult.h>
#include <aws/appsync/model/UpdateTypeRequest.h>
#include <aws/appsync/model/UpdateTypeResult.h>
#include <aws/appsync/model/UserPoolConfig.h>

using AppSyncIncludeTest = ::testing::Test;

TEST_F(AppSyncIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::AppSync::AppSyncClient>("AppSyncIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
