/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/apptest/AppTestClient.h>
#include <aws/apptest/AppTestEndpointProvider.h>
#include <aws/apptest/AppTestEndpointRules.h>
#include <aws/apptest/AppTestErrorMarshaller.h>
#include <aws/apptest/AppTestErrors.h>
#include <aws/apptest/AppTestRequest.h>
#include <aws/apptest/AppTestServiceClientModel.h>
#include <aws/apptest/AppTest_EXPORTS.h>
#include <aws/apptest/model/Batch.h>
#include <aws/apptest/model/BatchStepInput.h>
#include <aws/apptest/model/BatchStepOutput.h>
#include <aws/apptest/model/BatchSummary.h>
#include <aws/apptest/model/CaptureTool.h>
#include <aws/apptest/model/CloudFormation.h>
#include <aws/apptest/model/CloudFormationAction.h>
#include <aws/apptest/model/CloudFormationActionType.h>
#include <aws/apptest/model/CloudFormationStepSummary.h>
#include <aws/apptest/model/CompareAction.h>
#include <aws/apptest/model/CompareActionSummary.h>
#include <aws/apptest/model/CompareDataSetsStepInput.h>
#include <aws/apptest/model/CompareDataSetsStepOutput.h>
#include <aws/apptest/model/CompareDataSetsSummary.h>
#include <aws/apptest/model/CompareDatabaseCDCStepInput.h>
#include <aws/apptest/model/CompareDatabaseCDCStepOutput.h>
#include <aws/apptest/model/CompareDatabaseCDCSummary.h>
#include <aws/apptest/model/CompareFileType.h>
#include <aws/apptest/model/ComparisonStatusEnum.h>
#include <aws/apptest/model/ConflictException.h>
#include <aws/apptest/model/CreateCloudFormationStepInput.h>
#include <aws/apptest/model/CreateCloudFormationStepOutput.h>
#include <aws/apptest/model/CreateCloudFormationSummary.h>
#include <aws/apptest/model/CreateTestCaseRequest.h>
#include <aws/apptest/model/CreateTestCaseResult.h>
#include <aws/apptest/model/CreateTestConfigurationRequest.h>
#include <aws/apptest/model/CreateTestConfigurationResult.h>
#include <aws/apptest/model/CreateTestSuiteRequest.h>
#include <aws/apptest/model/CreateTestSuiteResult.h>
#include <aws/apptest/model/DataSet.h>
#include <aws/apptest/model/DataSetType.h>
#include <aws/apptest/model/DatabaseCDC.h>
#include <aws/apptest/model/DeleteCloudFormationStepInput.h>
#include <aws/apptest/model/DeleteCloudFormationStepOutput.h>
#include <aws/apptest/model/DeleteCloudFormationSummary.h>
#include <aws/apptest/model/DeleteTestCaseRequest.h>
#include <aws/apptest/model/DeleteTestCaseResult.h>
#include <aws/apptest/model/DeleteTestConfigurationRequest.h>
#include <aws/apptest/model/DeleteTestConfigurationResult.h>
#include <aws/apptest/model/DeleteTestRunRequest.h>
#include <aws/apptest/model/DeleteTestRunResult.h>
#include <aws/apptest/model/DeleteTestSuiteRequest.h>
#include <aws/apptest/model/DeleteTestSuiteResult.h>
#include <aws/apptest/model/File.h>
#include <aws/apptest/model/FileMetadata.h>
#include <aws/apptest/model/Format.h>
#include <aws/apptest/model/GetTestCaseRequest.h>
#include <aws/apptest/model/GetTestCaseResult.h>
#include <aws/apptest/model/GetTestConfigurationRequest.h>
#include <aws/apptest/model/GetTestConfigurationResult.h>
#include <aws/apptest/model/GetTestRunStepRequest.h>
#include <aws/apptest/model/GetTestRunStepResult.h>
#include <aws/apptest/model/GetTestSuiteRequest.h>
#include <aws/apptest/model/GetTestSuiteResult.h>
#include <aws/apptest/model/Input.h>
#include <aws/apptest/model/InputFile.h>
#include <aws/apptest/model/InternalServerException.h>
#include <aws/apptest/model/ListTagsForResourceRequest.h>
#include <aws/apptest/model/ListTagsForResourceResult.h>
#include <aws/apptest/model/ListTestCasesRequest.h>
#include <aws/apptest/model/ListTestCasesResult.h>
#include <aws/apptest/model/ListTestConfigurationsRequest.h>
#include <aws/apptest/model/ListTestConfigurationsResult.h>
#include <aws/apptest/model/ListTestRunStepsRequest.h>
#include <aws/apptest/model/ListTestRunStepsResult.h>
#include <aws/apptest/model/ListTestRunTestCasesRequest.h>
#include <aws/apptest/model/ListTestRunTestCasesResult.h>
#include <aws/apptest/model/ListTestRunsRequest.h>
#include <aws/apptest/model/ListTestRunsResult.h>
#include <aws/apptest/model/ListTestSuitesRequest.h>
#include <aws/apptest/model/ListTestSuitesResult.h>
#include <aws/apptest/model/M2ManagedActionProperties.h>
#include <aws/apptest/model/M2ManagedActionType.h>
#include <aws/apptest/model/M2ManagedApplication.h>
#include <aws/apptest/model/M2ManagedApplicationAction.h>
#include <aws/apptest/model/M2ManagedApplicationStepInput.h>
#include <aws/apptest/model/M2ManagedApplicationStepOutput.h>
#include <aws/apptest/model/M2ManagedApplicationStepSummary.h>
#include <aws/apptest/model/M2ManagedApplicationSummary.h>
#include <aws/apptest/model/M2ManagedRuntime.h>
#include <aws/apptest/model/M2NonManagedActionType.h>
#include <aws/apptest/model/M2NonManagedApplication.h>
#include <aws/apptest/model/M2NonManagedApplicationAction.h>
#include <aws/apptest/model/M2NonManagedApplicationStepInput.h>
#include <aws/apptest/model/M2NonManagedApplicationStepOutput.h>
#include <aws/apptest/model/M2NonManagedApplicationStepSummary.h>
#include <aws/apptest/model/M2NonManagedApplicationSummary.h>
#include <aws/apptest/model/M2NonManagedRuntime.h>
#include <aws/apptest/model/MainframeAction.h>
#include <aws/apptest/model/MainframeActionProperties.h>
#include <aws/apptest/model/MainframeActionSummary.h>
#include <aws/apptest/model/MainframeActionType.h>
#include <aws/apptest/model/MainframeResourceSummary.h>
#include <aws/apptest/model/Output.h>
#include <aws/apptest/model/OutputFile.h>
#include <aws/apptest/model/Resource.h>
#include <aws/apptest/model/ResourceAction.h>
#include <aws/apptest/model/ResourceActionSummary.h>
#include <aws/apptest/model/ResourceNotFoundException.h>
#include <aws/apptest/model/ResourceType.h>
#include <aws/apptest/model/Script.h>
#include <aws/apptest/model/ScriptSummary.h>
#include <aws/apptest/model/ScriptType.h>
#include <aws/apptest/model/ServiceQuotaExceededException.h>
#include <aws/apptest/model/ServiceSettings.h>
#include <aws/apptest/model/SourceDatabase.h>
#include <aws/apptest/model/SourceDatabaseMetadata.h>
#include <aws/apptest/model/StartTestRunRequest.h>
#include <aws/apptest/model/StartTestRunResult.h>
#include <aws/apptest/model/Step.h>
#include <aws/apptest/model/StepAction.h>
#include <aws/apptest/model/StepRunStatus.h>
#include <aws/apptest/model/StepRunSummary.h>
#include <aws/apptest/model/TN3270.h>
#include <aws/apptest/model/TN3270StepInput.h>
#include <aws/apptest/model/TN3270StepOutput.h>
#include <aws/apptest/model/TN3270Summary.h>
#include <aws/apptest/model/TagResourceRequest.h>
#include <aws/apptest/model/TagResourceResult.h>
#include <aws/apptest/model/TargetDatabase.h>
#include <aws/apptest/model/TargetDatabaseMetadata.h>
#include <aws/apptest/model/TestCaseLatestVersion.h>
#include <aws/apptest/model/TestCaseLifecycle.h>
#include <aws/apptest/model/TestCaseRunStatus.h>
#include <aws/apptest/model/TestCaseRunSummary.h>
#include <aws/apptest/model/TestCaseSummary.h>
#include <aws/apptest/model/TestCases.h>
#include <aws/apptest/model/TestConfigurationLatestVersion.h>
#include <aws/apptest/model/TestConfigurationLifecycle.h>
#include <aws/apptest/model/TestConfigurationSummary.h>
#include <aws/apptest/model/TestRunStatus.h>
#include <aws/apptest/model/TestRunStepSummary.h>
#include <aws/apptest/model/TestRunSummary.h>
#include <aws/apptest/model/TestSuiteLatestVersion.h>
#include <aws/apptest/model/TestSuiteLifecycle.h>
#include <aws/apptest/model/TestSuiteSummary.h>
#include <aws/apptest/model/ThrottlingException.h>
#include <aws/apptest/model/UntagResourceRequest.h>
#include <aws/apptest/model/UntagResourceResult.h>
#include <aws/apptest/model/UpdateTestCaseRequest.h>
#include <aws/apptest/model/UpdateTestCaseResult.h>
#include <aws/apptest/model/UpdateTestConfigurationRequest.h>
#include <aws/apptest/model/UpdateTestConfigurationResult.h>
#include <aws/apptest/model/UpdateTestSuiteRequest.h>
#include <aws/apptest/model/UpdateTestSuiteResult.h>
#include <aws/apptest/model/ValidationException.h>
#include <aws/apptest/model/ValidationExceptionField.h>
#include <aws/apptest/model/ValidationExceptionReason.h>

using AppTestIncludeTest = ::testing::Test;

TEST_F(AppTestIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::AppTest::AppTestClient>("AppTestIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
