/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/athena/AthenaClient.h>
#include <aws/athena/AthenaEndpointProvider.h>
#include <aws/athena/AthenaEndpointRules.h>
#include <aws/athena/AthenaErrorMarshaller.h>
#include <aws/athena/AthenaErrors.h>
#include <aws/athena/AthenaRequest.h>
#include <aws/athena/AthenaServiceClientModel.h>
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/athena/model/AclConfiguration.h>
#include <aws/athena/model/ApplicationDPUSizes.h>
#include <aws/athena/model/AthenaError.h>
#include <aws/athena/model/AuthenticationType.h>
#include <aws/athena/model/BatchGetNamedQueryRequest.h>
#include <aws/athena/model/BatchGetNamedQueryResult.h>
#include <aws/athena/model/BatchGetPreparedStatementRequest.h>
#include <aws/athena/model/BatchGetPreparedStatementResult.h>
#include <aws/athena/model/BatchGetQueryExecutionRequest.h>
#include <aws/athena/model/BatchGetQueryExecutionResult.h>
#include <aws/athena/model/CalculationExecutionState.h>
#include <aws/athena/model/CalculationResult.h>
#include <aws/athena/model/CalculationStatistics.h>
#include <aws/athena/model/CalculationStatus.h>
#include <aws/athena/model/CalculationSummary.h>
#include <aws/athena/model/CancelCapacityReservationRequest.h>
#include <aws/athena/model/CancelCapacityReservationResult.h>
#include <aws/athena/model/CapacityAllocation.h>
#include <aws/athena/model/CapacityAllocationStatus.h>
#include <aws/athena/model/CapacityAssignment.h>
#include <aws/athena/model/CapacityAssignmentConfiguration.h>
#include <aws/athena/model/CapacityReservation.h>
#include <aws/athena/model/CapacityReservationStatus.h>
#include <aws/athena/model/Column.h>
#include <aws/athena/model/ColumnInfo.h>
#include <aws/athena/model/ColumnNullable.h>
#include <aws/athena/model/ConnectionType.h>
#include <aws/athena/model/CreateCapacityReservationRequest.h>
#include <aws/athena/model/CreateCapacityReservationResult.h>
#include <aws/athena/model/CreateDataCatalogRequest.h>
#include <aws/athena/model/CreateDataCatalogResult.h>
#include <aws/athena/model/CreateNamedQueryRequest.h>
#include <aws/athena/model/CreateNamedQueryResult.h>
#include <aws/athena/model/CreateNotebookRequest.h>
#include <aws/athena/model/CreateNotebookResult.h>
#include <aws/athena/model/CreatePreparedStatementRequest.h>
#include <aws/athena/model/CreatePreparedStatementResult.h>
#include <aws/athena/model/CreatePresignedNotebookUrlRequest.h>
#include <aws/athena/model/CreatePresignedNotebookUrlResult.h>
#include <aws/athena/model/CreateWorkGroupRequest.h>
#include <aws/athena/model/CreateWorkGroupResult.h>
#include <aws/athena/model/CustomerContentEncryptionConfiguration.h>
#include <aws/athena/model/DataCatalog.h>
#include <aws/athena/model/DataCatalogStatus.h>
#include <aws/athena/model/DataCatalogSummary.h>
#include <aws/athena/model/DataCatalogType.h>
#include <aws/athena/model/Database.h>
#include <aws/athena/model/Datum.h>
#include <aws/athena/model/DeleteCapacityReservationRequest.h>
#include <aws/athena/model/DeleteCapacityReservationResult.h>
#include <aws/athena/model/DeleteDataCatalogRequest.h>
#include <aws/athena/model/DeleteDataCatalogResult.h>
#include <aws/athena/model/DeleteNamedQueryRequest.h>
#include <aws/athena/model/DeleteNamedQueryResult.h>
#include <aws/athena/model/DeleteNotebookRequest.h>
#include <aws/athena/model/DeleteNotebookResult.h>
#include <aws/athena/model/DeletePreparedStatementRequest.h>
#include <aws/athena/model/DeletePreparedStatementResult.h>
#include <aws/athena/model/DeleteWorkGroupRequest.h>
#include <aws/athena/model/DeleteWorkGroupResult.h>
#include <aws/athena/model/EncryptionConfiguration.h>
#include <aws/athena/model/EncryptionOption.h>
#include <aws/athena/model/EngineConfiguration.h>
#include <aws/athena/model/EngineVersion.h>
#include <aws/athena/model/ExecutorState.h>
#include <aws/athena/model/ExecutorType.h>
#include <aws/athena/model/ExecutorsSummary.h>
#include <aws/athena/model/ExportNotebookRequest.h>
#include <aws/athena/model/ExportNotebookResult.h>
#include <aws/athena/model/FilterDefinition.h>
#include <aws/athena/model/GetCalculationExecutionCodeRequest.h>
#include <aws/athena/model/GetCalculationExecutionCodeResult.h>
#include <aws/athena/model/GetCalculationExecutionRequest.h>
#include <aws/athena/model/GetCalculationExecutionResult.h>
#include <aws/athena/model/GetCalculationExecutionStatusRequest.h>
#include <aws/athena/model/GetCalculationExecutionStatusResult.h>
#include <aws/athena/model/GetCapacityAssignmentConfigurationRequest.h>
#include <aws/athena/model/GetCapacityAssignmentConfigurationResult.h>
#include <aws/athena/model/GetCapacityReservationRequest.h>
#include <aws/athena/model/GetCapacityReservationResult.h>
#include <aws/athena/model/GetDataCatalogRequest.h>
#include <aws/athena/model/GetDataCatalogResult.h>
#include <aws/athena/model/GetDatabaseRequest.h>
#include <aws/athena/model/GetDatabaseResult.h>
#include <aws/athena/model/GetNamedQueryRequest.h>
#include <aws/athena/model/GetNamedQueryResult.h>
#include <aws/athena/model/GetNotebookMetadataRequest.h>
#include <aws/athena/model/GetNotebookMetadataResult.h>
#include <aws/athena/model/GetPreparedStatementRequest.h>
#include <aws/athena/model/GetPreparedStatementResult.h>
#include <aws/athena/model/GetQueryExecutionRequest.h>
#include <aws/athena/model/GetQueryExecutionResult.h>
#include <aws/athena/model/GetQueryResultsRequest.h>
#include <aws/athena/model/GetQueryResultsResult.h>
#include <aws/athena/model/GetQueryRuntimeStatisticsRequest.h>
#include <aws/athena/model/GetQueryRuntimeStatisticsResult.h>
#include <aws/athena/model/GetSessionRequest.h>
#include <aws/athena/model/GetSessionResult.h>
#include <aws/athena/model/GetSessionStatusRequest.h>
#include <aws/athena/model/GetSessionStatusResult.h>
#include <aws/athena/model/GetTableMetadataRequest.h>
#include <aws/athena/model/GetTableMetadataResult.h>
#include <aws/athena/model/GetWorkGroupRequest.h>
#include <aws/athena/model/GetWorkGroupResult.h>
#include <aws/athena/model/IdentityCenterConfiguration.h>
#include <aws/athena/model/ImportNotebookRequest.h>
#include <aws/athena/model/ImportNotebookResult.h>
#include <aws/athena/model/InvalidRequestException.h>
#include <aws/athena/model/ListApplicationDPUSizesRequest.h>
#include <aws/athena/model/ListApplicationDPUSizesResult.h>
#include <aws/athena/model/ListCalculationExecutionsRequest.h>
#include <aws/athena/model/ListCalculationExecutionsResult.h>
#include <aws/athena/model/ListCapacityReservationsRequest.h>
#include <aws/athena/model/ListCapacityReservationsResult.h>
#include <aws/athena/model/ListDataCatalogsRequest.h>
#include <aws/athena/model/ListDataCatalogsResult.h>
#include <aws/athena/model/ListDatabasesRequest.h>
#include <aws/athena/model/ListDatabasesResult.h>
#include <aws/athena/model/ListEngineVersionsRequest.h>
#include <aws/athena/model/ListEngineVersionsResult.h>
#include <aws/athena/model/ListExecutorsRequest.h>
#include <aws/athena/model/ListExecutorsResult.h>
#include <aws/athena/model/ListNamedQueriesRequest.h>
#include <aws/athena/model/ListNamedQueriesResult.h>
#include <aws/athena/model/ListNotebookMetadataRequest.h>
#include <aws/athena/model/ListNotebookMetadataResult.h>
#include <aws/athena/model/ListNotebookSessionsRequest.h>
#include <aws/athena/model/ListNotebookSessionsResult.h>
#include <aws/athena/model/ListPreparedStatementsRequest.h>
#include <aws/athena/model/ListPreparedStatementsResult.h>
#include <aws/athena/model/ListQueryExecutionsRequest.h>
#include <aws/athena/model/ListQueryExecutionsResult.h>
#include <aws/athena/model/ListSessionsRequest.h>
#include <aws/athena/model/ListSessionsResult.h>
#include <aws/athena/model/ListTableMetadataRequest.h>
#include <aws/athena/model/ListTableMetadataResult.h>
#include <aws/athena/model/ListTagsForResourceRequest.h>
#include <aws/athena/model/ListTagsForResourceResult.h>
#include <aws/athena/model/ListWorkGroupsRequest.h>
#include <aws/athena/model/ListWorkGroupsResult.h>
#include <aws/athena/model/ManagedQueryResultsConfiguration.h>
#include <aws/athena/model/ManagedQueryResultsConfigurationUpdates.h>
#include <aws/athena/model/ManagedQueryResultsEncryptionConfiguration.h>
#include <aws/athena/model/NamedQuery.h>
#include <aws/athena/model/NotebookMetadata.h>
#include <aws/athena/model/NotebookSessionSummary.h>
#include <aws/athena/model/NotebookType.h>
#include <aws/athena/model/PreparedStatement.h>
#include <aws/athena/model/PreparedStatementSummary.h>
#include <aws/athena/model/PutCapacityAssignmentConfigurationRequest.h>
#include <aws/athena/model/PutCapacityAssignmentConfigurationResult.h>
#include <aws/athena/model/QueryExecution.h>
#include <aws/athena/model/QueryExecutionContext.h>
#include <aws/athena/model/QueryExecutionState.h>
#include <aws/athena/model/QueryExecutionStatistics.h>
#include <aws/athena/model/QueryExecutionStatus.h>
#include <aws/athena/model/QueryResultType.h>
#include <aws/athena/model/QueryResultsS3AccessGrantsConfiguration.h>
#include <aws/athena/model/QueryRuntimeStatistics.h>
#include <aws/athena/model/QueryRuntimeStatisticsRows.h>
#include <aws/athena/model/QueryRuntimeStatisticsTimeline.h>
#include <aws/athena/model/QueryStage.h>
#include <aws/athena/model/QueryStagePlanNode.h>
#include <aws/athena/model/ResourceNotFoundException.h>
#include <aws/athena/model/ResultConfiguration.h>
#include <aws/athena/model/ResultConfigurationUpdates.h>
#include <aws/athena/model/ResultReuseByAgeConfiguration.h>
#include <aws/athena/model/ResultReuseConfiguration.h>
#include <aws/athena/model/ResultReuseInformation.h>
#include <aws/athena/model/ResultSet.h>
#include <aws/athena/model/ResultSetMetadata.h>
#include <aws/athena/model/Row.h>
#include <aws/athena/model/S3AclOption.h>
#include <aws/athena/model/SessionConfiguration.h>
#include <aws/athena/model/SessionState.h>
#include <aws/athena/model/SessionStatistics.h>
#include <aws/athena/model/SessionStatus.h>
#include <aws/athena/model/SessionSummary.h>
#include <aws/athena/model/StartCalculationExecutionRequest.h>
#include <aws/athena/model/StartCalculationExecutionResult.h>
#include <aws/athena/model/StartQueryExecutionRequest.h>
#include <aws/athena/model/StartQueryExecutionResult.h>
#include <aws/athena/model/StartSessionRequest.h>
#include <aws/athena/model/StartSessionResult.h>
#include <aws/athena/model/StatementType.h>
#include <aws/athena/model/StopCalculationExecutionRequest.h>
#include <aws/athena/model/StopCalculationExecutionResult.h>
#include <aws/athena/model/StopQueryExecutionRequest.h>
#include <aws/athena/model/StopQueryExecutionResult.h>
#include <aws/athena/model/TableMetadata.h>
#include <aws/athena/model/Tag.h>
#include <aws/athena/model/TagResourceRequest.h>
#include <aws/athena/model/TagResourceResult.h>
#include <aws/athena/model/TerminateSessionRequest.h>
#include <aws/athena/model/TerminateSessionResult.h>
#include <aws/athena/model/ThrottleReason.h>
#include <aws/athena/model/TooManyRequestsException.h>
#include <aws/athena/model/UnprocessedNamedQueryId.h>
#include <aws/athena/model/UnprocessedPreparedStatementName.h>
#include <aws/athena/model/UnprocessedQueryExecutionId.h>
#include <aws/athena/model/UntagResourceRequest.h>
#include <aws/athena/model/UntagResourceResult.h>
#include <aws/athena/model/UpdateCapacityReservationRequest.h>
#include <aws/athena/model/UpdateCapacityReservationResult.h>
#include <aws/athena/model/UpdateDataCatalogRequest.h>
#include <aws/athena/model/UpdateDataCatalogResult.h>
#include <aws/athena/model/UpdateNamedQueryRequest.h>
#include <aws/athena/model/UpdateNamedQueryResult.h>
#include <aws/athena/model/UpdateNotebookMetadataRequest.h>
#include <aws/athena/model/UpdateNotebookMetadataResult.h>
#include <aws/athena/model/UpdateNotebookRequest.h>
#include <aws/athena/model/UpdateNotebookResult.h>
#include <aws/athena/model/UpdatePreparedStatementRequest.h>
#include <aws/athena/model/UpdatePreparedStatementResult.h>
#include <aws/athena/model/UpdateWorkGroupRequest.h>
#include <aws/athena/model/UpdateWorkGroupResult.h>
#include <aws/athena/model/WorkGroup.h>
#include <aws/athena/model/WorkGroupConfiguration.h>
#include <aws/athena/model/WorkGroupConfigurationUpdates.h>
#include <aws/athena/model/WorkGroupState.h>
#include <aws/athena/model/WorkGroupSummary.h>

using AthenaIncludeTest = ::testing::Test;

TEST_F(AthenaIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Athena::AthenaClient>("AthenaIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
