/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/auditmanager/AuditManagerClient.h>
#include <aws/auditmanager/AuditManagerEndpointProvider.h>
#include <aws/auditmanager/AuditManagerEndpointRules.h>
#include <aws/auditmanager/AuditManagerErrorMarshaller.h>
#include <aws/auditmanager/AuditManagerErrors.h>
#include <aws/auditmanager/AuditManagerRequest.h>
#include <aws/auditmanager/AuditManagerServiceClientModel.h>
#include <aws/auditmanager/AuditManager_EXPORTS.h>
#include <aws/auditmanager/model/AWSAccount.h>
#include <aws/auditmanager/model/AWSService.h>
#include <aws/auditmanager/model/AccountStatus.h>
#include <aws/auditmanager/model/ActionEnum.h>
#include <aws/auditmanager/model/Assessment.h>
#include <aws/auditmanager/model/AssessmentControl.h>
#include <aws/auditmanager/model/AssessmentControlSet.h>
#include <aws/auditmanager/model/AssessmentEvidenceFolder.h>
#include <aws/auditmanager/model/AssessmentFramework.h>
#include <aws/auditmanager/model/AssessmentFrameworkMetadata.h>
#include <aws/auditmanager/model/AssessmentFrameworkShareRequest.h>
#include <aws/auditmanager/model/AssessmentMetadata.h>
#include <aws/auditmanager/model/AssessmentMetadataItem.h>
#include <aws/auditmanager/model/AssessmentReport.h>
#include <aws/auditmanager/model/AssessmentReportDestinationType.h>
#include <aws/auditmanager/model/AssessmentReportEvidenceError.h>
#include <aws/auditmanager/model/AssessmentReportMetadata.h>
#include <aws/auditmanager/model/AssessmentReportStatus.h>
#include <aws/auditmanager/model/AssessmentReportsDestination.h>
#include <aws/auditmanager/model/AssessmentStatus.h>
#include <aws/auditmanager/model/AssociateAssessmentReportEvidenceFolderRequest.h>
#include <aws/auditmanager/model/AssociateAssessmentReportEvidenceFolderResult.h>
#include <aws/auditmanager/model/BatchAssociateAssessmentReportEvidenceRequest.h>
#include <aws/auditmanager/model/BatchAssociateAssessmentReportEvidenceResult.h>
#include <aws/auditmanager/model/BatchCreateDelegationByAssessmentError.h>
#include <aws/auditmanager/model/BatchCreateDelegationByAssessmentRequest.h>
#include <aws/auditmanager/model/BatchCreateDelegationByAssessmentResult.h>
#include <aws/auditmanager/model/BatchDeleteDelegationByAssessmentError.h>
#include <aws/auditmanager/model/BatchDeleteDelegationByAssessmentRequest.h>
#include <aws/auditmanager/model/BatchDeleteDelegationByAssessmentResult.h>
#include <aws/auditmanager/model/BatchDisassociateAssessmentReportEvidenceRequest.h>
#include <aws/auditmanager/model/BatchDisassociateAssessmentReportEvidenceResult.h>
#include <aws/auditmanager/model/BatchImportEvidenceToAssessmentControlError.h>
#include <aws/auditmanager/model/BatchImportEvidenceToAssessmentControlRequest.h>
#include <aws/auditmanager/model/BatchImportEvidenceToAssessmentControlResult.h>
#include <aws/auditmanager/model/ChangeLog.h>
#include <aws/auditmanager/model/Control.h>
#include <aws/auditmanager/model/ControlComment.h>
#include <aws/auditmanager/model/ControlDomainInsights.h>
#include <aws/auditmanager/model/ControlInsightsMetadataByAssessmentItem.h>
#include <aws/auditmanager/model/ControlInsightsMetadataItem.h>
#include <aws/auditmanager/model/ControlMappingSource.h>
#include <aws/auditmanager/model/ControlMetadata.h>
#include <aws/auditmanager/model/ControlResponse.h>
#include <aws/auditmanager/model/ControlSet.h>
#include <aws/auditmanager/model/ControlSetStatus.h>
#include <aws/auditmanager/model/ControlState.h>
#include <aws/auditmanager/model/ControlStatus.h>
#include <aws/auditmanager/model/ControlType.h>
#include <aws/auditmanager/model/CreateAssessmentFrameworkControl.h>
#include <aws/auditmanager/model/CreateAssessmentFrameworkControlSet.h>
#include <aws/auditmanager/model/CreateAssessmentFrameworkRequest.h>
#include <aws/auditmanager/model/CreateAssessmentFrameworkResult.h>
#include <aws/auditmanager/model/CreateAssessmentReportRequest.h>
#include <aws/auditmanager/model/CreateAssessmentReportResult.h>
#include <aws/auditmanager/model/CreateAssessmentRequest.h>
#include <aws/auditmanager/model/CreateAssessmentResult.h>
#include <aws/auditmanager/model/CreateControlMappingSource.h>
#include <aws/auditmanager/model/CreateControlRequest.h>
#include <aws/auditmanager/model/CreateControlResult.h>
#include <aws/auditmanager/model/CreateDelegationRequest.h>
#include <aws/auditmanager/model/DataSourceType.h>
#include <aws/auditmanager/model/DefaultExportDestination.h>
#include <aws/auditmanager/model/Delegation.h>
#include <aws/auditmanager/model/DelegationMetadata.h>
#include <aws/auditmanager/model/DelegationStatus.h>
#include <aws/auditmanager/model/DeleteAssessmentFrameworkRequest.h>
#include <aws/auditmanager/model/DeleteAssessmentFrameworkResult.h>
#include <aws/auditmanager/model/DeleteAssessmentFrameworkShareRequest.h>
#include <aws/auditmanager/model/DeleteAssessmentFrameworkShareResult.h>
#include <aws/auditmanager/model/DeleteAssessmentReportRequest.h>
#include <aws/auditmanager/model/DeleteAssessmentReportResult.h>
#include <aws/auditmanager/model/DeleteAssessmentRequest.h>
#include <aws/auditmanager/model/DeleteAssessmentResult.h>
#include <aws/auditmanager/model/DeleteControlRequest.h>
#include <aws/auditmanager/model/DeleteControlResult.h>
#include <aws/auditmanager/model/DeleteResources.h>
#include <aws/auditmanager/model/DeregisterAccountRequest.h>
#include <aws/auditmanager/model/DeregisterAccountResult.h>
#include <aws/auditmanager/model/DeregisterOrganizationAdminAccountRequest.h>
#include <aws/auditmanager/model/DeregisterOrganizationAdminAccountResult.h>
#include <aws/auditmanager/model/DeregistrationPolicy.h>
#include <aws/auditmanager/model/DisassociateAssessmentReportEvidenceFolderRequest.h>
#include <aws/auditmanager/model/DisassociateAssessmentReportEvidenceFolderResult.h>
#include <aws/auditmanager/model/Evidence.h>
#include <aws/auditmanager/model/EvidenceFinderBackfillStatus.h>
#include <aws/auditmanager/model/EvidenceFinderEnablement.h>
#include <aws/auditmanager/model/EvidenceFinderEnablementStatus.h>
#include <aws/auditmanager/model/EvidenceInsights.h>
#include <aws/auditmanager/model/ExportDestinationType.h>
#include <aws/auditmanager/model/Framework.h>
#include <aws/auditmanager/model/FrameworkMetadata.h>
#include <aws/auditmanager/model/FrameworkType.h>
#include <aws/auditmanager/model/GetAccountStatusRequest.h>
#include <aws/auditmanager/model/GetAccountStatusResult.h>
#include <aws/auditmanager/model/GetAssessmentFrameworkRequest.h>
#include <aws/auditmanager/model/GetAssessmentFrameworkResult.h>
#include <aws/auditmanager/model/GetAssessmentReportUrlRequest.h>
#include <aws/auditmanager/model/GetAssessmentReportUrlResult.h>
#include <aws/auditmanager/model/GetAssessmentRequest.h>
#include <aws/auditmanager/model/GetAssessmentResult.h>
#include <aws/auditmanager/model/GetChangeLogsRequest.h>
#include <aws/auditmanager/model/GetChangeLogsResult.h>
#include <aws/auditmanager/model/GetControlRequest.h>
#include <aws/auditmanager/model/GetControlResult.h>
#include <aws/auditmanager/model/GetDelegationsRequest.h>
#include <aws/auditmanager/model/GetDelegationsResult.h>
#include <aws/auditmanager/model/GetEvidenceByEvidenceFolderRequest.h>
#include <aws/auditmanager/model/GetEvidenceByEvidenceFolderResult.h>
#include <aws/auditmanager/model/GetEvidenceFileUploadUrlRequest.h>
#include <aws/auditmanager/model/GetEvidenceFileUploadUrlResult.h>
#include <aws/auditmanager/model/GetEvidenceFolderRequest.h>
#include <aws/auditmanager/model/GetEvidenceFolderResult.h>
#include <aws/auditmanager/model/GetEvidenceFoldersByAssessmentControlRequest.h>
#include <aws/auditmanager/model/GetEvidenceFoldersByAssessmentControlResult.h>
#include <aws/auditmanager/model/GetEvidenceFoldersByAssessmentRequest.h>
#include <aws/auditmanager/model/GetEvidenceFoldersByAssessmentResult.h>
#include <aws/auditmanager/model/GetEvidenceRequest.h>
#include <aws/auditmanager/model/GetEvidenceResult.h>
#include <aws/auditmanager/model/GetInsightsByAssessmentRequest.h>
#include <aws/auditmanager/model/GetInsightsByAssessmentResult.h>
#include <aws/auditmanager/model/GetInsightsRequest.h>
#include <aws/auditmanager/model/GetInsightsResult.h>
#include <aws/auditmanager/model/GetOrganizationAdminAccountRequest.h>
#include <aws/auditmanager/model/GetOrganizationAdminAccountResult.h>
#include <aws/auditmanager/model/GetServicesInScopeRequest.h>
#include <aws/auditmanager/model/GetServicesInScopeResult.h>
#include <aws/auditmanager/model/GetSettingsRequest.h>
#include <aws/auditmanager/model/GetSettingsResult.h>
#include <aws/auditmanager/model/Insights.h>
#include <aws/auditmanager/model/InsightsByAssessment.h>
#include <aws/auditmanager/model/KeywordInputType.h>
#include <aws/auditmanager/model/ListAssessmentControlInsightsByControlDomainRequest.h>
#include <aws/auditmanager/model/ListAssessmentControlInsightsByControlDomainResult.h>
#include <aws/auditmanager/model/ListAssessmentFrameworkShareRequestsRequest.h>
#include <aws/auditmanager/model/ListAssessmentFrameworkShareRequestsResult.h>
#include <aws/auditmanager/model/ListAssessmentFrameworksRequest.h>
#include <aws/auditmanager/model/ListAssessmentFrameworksResult.h>
#include <aws/auditmanager/model/ListAssessmentReportsRequest.h>
#include <aws/auditmanager/model/ListAssessmentReportsResult.h>
#include <aws/auditmanager/model/ListAssessmentsRequest.h>
#include <aws/auditmanager/model/ListAssessmentsResult.h>
#include <aws/auditmanager/model/ListControlDomainInsightsByAssessmentRequest.h>
#include <aws/auditmanager/model/ListControlDomainInsightsByAssessmentResult.h>
#include <aws/auditmanager/model/ListControlDomainInsightsRequest.h>
#include <aws/auditmanager/model/ListControlDomainInsightsResult.h>
#include <aws/auditmanager/model/ListControlInsightsByControlDomainRequest.h>
#include <aws/auditmanager/model/ListControlInsightsByControlDomainResult.h>
#include <aws/auditmanager/model/ListControlsRequest.h>
#include <aws/auditmanager/model/ListControlsResult.h>
#include <aws/auditmanager/model/ListKeywordsForDataSourceRequest.h>
#include <aws/auditmanager/model/ListKeywordsForDataSourceResult.h>
#include <aws/auditmanager/model/ListNotificationsRequest.h>
#include <aws/auditmanager/model/ListNotificationsResult.h>
#include <aws/auditmanager/model/ListTagsForResourceRequest.h>
#include <aws/auditmanager/model/ListTagsForResourceResult.h>
#include <aws/auditmanager/model/ManualEvidence.h>
#include <aws/auditmanager/model/Notification.h>
#include <aws/auditmanager/model/ObjectTypeEnum.h>
#include <aws/auditmanager/model/RegisterAccountRequest.h>
#include <aws/auditmanager/model/RegisterAccountResult.h>
#include <aws/auditmanager/model/RegisterOrganizationAdminAccountRequest.h>
#include <aws/auditmanager/model/RegisterOrganizationAdminAccountResult.h>
#include <aws/auditmanager/model/Resource.h>
#include <aws/auditmanager/model/ResourceNotFoundException.h>
#include <aws/auditmanager/model/Role.h>
#include <aws/auditmanager/model/RoleType.h>
#include <aws/auditmanager/model/Scope.h>
#include <aws/auditmanager/model/ServiceMetadata.h>
#include <aws/auditmanager/model/SettingAttribute.h>
#include <aws/auditmanager/model/Settings.h>
#include <aws/auditmanager/model/ShareRequestAction.h>
#include <aws/auditmanager/model/ShareRequestStatus.h>
#include <aws/auditmanager/model/ShareRequestType.h>
#include <aws/auditmanager/model/SourceFrequency.h>
#include <aws/auditmanager/model/SourceKeyword.h>
#include <aws/auditmanager/model/SourceSetUpOption.h>
#include <aws/auditmanager/model/SourceType.h>
#include <aws/auditmanager/model/StartAssessmentFrameworkShareRequest.h>
#include <aws/auditmanager/model/StartAssessmentFrameworkShareResult.h>
#include <aws/auditmanager/model/TagResourceRequest.h>
#include <aws/auditmanager/model/TagResourceResult.h>
#include <aws/auditmanager/model/URL.h>
#include <aws/auditmanager/model/UntagResourceRequest.h>
#include <aws/auditmanager/model/UntagResourceResult.h>
#include <aws/auditmanager/model/UpdateAssessmentControlRequest.h>
#include <aws/auditmanager/model/UpdateAssessmentControlResult.h>
#include <aws/auditmanager/model/UpdateAssessmentControlSetStatusRequest.h>
#include <aws/auditmanager/model/UpdateAssessmentControlSetStatusResult.h>
#include <aws/auditmanager/model/UpdateAssessmentFrameworkControlSet.h>
#include <aws/auditmanager/model/UpdateAssessmentFrameworkRequest.h>
#include <aws/auditmanager/model/UpdateAssessmentFrameworkResult.h>
#include <aws/auditmanager/model/UpdateAssessmentFrameworkShareRequest.h>
#include <aws/auditmanager/model/UpdateAssessmentFrameworkShareResult.h>
#include <aws/auditmanager/model/UpdateAssessmentRequest.h>
#include <aws/auditmanager/model/UpdateAssessmentResult.h>
#include <aws/auditmanager/model/UpdateAssessmentStatusRequest.h>
#include <aws/auditmanager/model/UpdateAssessmentStatusResult.h>
#include <aws/auditmanager/model/UpdateControlRequest.h>
#include <aws/auditmanager/model/UpdateControlResult.h>
#include <aws/auditmanager/model/UpdateSettingsRequest.h>
#include <aws/auditmanager/model/UpdateSettingsResult.h>
#include <aws/auditmanager/model/ValidateAssessmentReportIntegrityRequest.h>
#include <aws/auditmanager/model/ValidateAssessmentReportIntegrityResult.h>
#include <aws/auditmanager/model/ValidationException.h>
#include <aws/auditmanager/model/ValidationExceptionField.h>
#include <aws/auditmanager/model/ValidationExceptionReason.h>

using AuditManagerIncludeTest = ::testing::Test;

TEST_F(AuditManagerIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::AuditManager::AuditManagerClient>("AuditManagerIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
